#include "3dc.h"
#include "module.h"
#include "inline.h"
#include "stratdef.h"
#include "platform.h"
#include "gamedef.h"
#include "hudgfx.h"
#include "usr_io.h"

#include "AvP_Menus.h"
#include "AvP_UserProfile.h"

#include "GammaControl.h"
#include "bh_types.h"
#include "pldnet.h"

#include "AvP_MP_Config.h"
#include "DetailLevels.h"
#include "CD_player.h"

#define MPLAYER_SUPPORT 0


#define MAX_MULTIPLAYER_NAME_LENGTH 10
#define MAX_IPADDRESS_LENGTH 15
char MP_PlayerName[NET_PLAYERNAMELENGTH+3] = "";
char MP_SessionName[MAX_MULTIPLAYER_NAME_LENGTH+23] = "TEST SESH";
char IPAddressString[MAX_IPADDRESS_LENGTH+1]= ""; 
char CommandLineIPAddressString[MAX_IPADDRESS_LENGTH+1]= ""; 
char UserProfileName[MAX_SIZE_OF_USERS_NAME+1]="";
char IP_Address_Name[22];

int MP_Species=0;
int MP_GameStyle=0;
int MP_LevelNumber=0;


int AlienEpisodeToPlay;
int MarineEpisodeToPlay;
int PredatorEpisodeToPlay;
int UserProfileNumber = -1;	/* set to -1 for first time into game */

extern CONTROL_METHODS PlayerControlMethods;
extern JOYSTICK_CONTROL_METHODS PlayerJoystickControlMethods;
extern int SmackerSoundVolume;
extern int EffectsSoundVolume;
extern int MoviesAreActive;
extern int IntroOutroMoviesAreActive;


extern AVPMENU_ELEMENT* AvPMenu_Multiplayer_LoadConfig;
extern AVPMENU_ELEMENT* AvPMenu_Multiplayer_LoadIPAddress;

#if MARINE_DEMO
static AVPMENU_ELEMENT AvPMenu_MainMenu[] =
{
	{AVPMENU_ELEMENT_STARTMARINEDEMO, TEXTSTRING_START_MARINE_DEMO,			0},
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_MAINMENU_GAMEPLAYOPTIONS,		AVPMENU_OPTIONS},
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_AVOPTIONS_TITLE,				AVPMENU_MAINMENUAVOPTIONS},
	{AVPMENU_ELEMENT_QUITGAME, TEXTSTRING_MAINMENU_EXITGAME,			0},
	{AVPMENU_ELEMENT_ENDOFMENU}
};			  
#elif PREDATOR_DEMO													   
static AVPMENU_ELEMENT AvPMenu_MainMenu[] =
{
	{AVPMENU_ELEMENT_STARTPREDATORDEMO, TEXTSTRING_START_PREDATOR_DEMO,			0},
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_MAINMENU_GAMEPLAYOPTIONS,		AVPMENU_OPTIONS},
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_AVOPTIONS_TITLE,				AVPMENU_MAINMENUAVOPTIONS},
	{AVPMENU_ELEMENT_QUITGAME, TEXTSTRING_MAINMENU_EXITGAME,			0},
	{AVPMENU_ELEMENT_ENDOFMENU}
};			  
#elif ALIEN_DEMO
static AVPMENU_ELEMENT AvPMenu_MainMenu[] =
{
	{AVPMENU_ELEMENT_STARTALIENDEMO, TEXTSTRING_START_ALIEN_DEMO,			0},
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_MAINMENU_GAMEPLAYOPTIONS,		AVPMENU_OPTIONS},
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_AVOPTIONS_TITLE,				AVPMENU_MAINMENUAVOPTIONS},
	{AVPMENU_ELEMENT_QUITGAME, TEXTSTRING_MAINMENU_EXITGAME,			0},
	{AVPMENU_ELEMENT_ENDOFMENU}
};			  
#elif DEATHMATCH_DEMO
static AVPMENU_ELEMENT AvPMenu_MainMenu[] =
{
//	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_MAINMENU_STARTSINGLEPLAYER,	AVPMENU_SINGLEPLAYER},
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_MAINMENU_MULTIPLAYER,			AVPMENU_MULTIPLAYER_CONNECTION},
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_MAINMENU_GAMEPLAYOPTIONS,		AVPMENU_OPTIONS},
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_AVOPTIONS_TITLE,				AVPMENU_MAINMENUAVOPTIONS},
	{AVPMENU_ELEMENT_QUITGAME, TEXTSTRING_MAINMENU_EXITGAME,			0},
	{AVPMENU_ELEMENT_ENDOFMENU}
};
#else
static AVPMENU_ELEMENT AvPMenu_MainMenu[] =
{
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_MAINMENU_STARTSINGLEPLAYER,	AVPMENU_SINGLEPLAYER,0,0,			TEXTSTRING_MAINMENU_STARTSINGLEPLAYER_HELP},
#if SAVE_GAME_ON
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_LOADGAME,						AVPMENU_LOADGAME, 0,0,				TEXTSTRING_LOADGAME_HELP},
#endif
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_MAINMENU_MULTIPLAYER,			AVPMENU_MULTIPLAYER_CONNECTION,0,0,	TEXTSTRING_MAINMENU_MULTIPLAYER_HELP},
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_MAINMENU_SKIRMISH,			AVPMENU_MULTIPLAYER_SKIRMISH,0,0,	TEXTSTRING_MAINMENU_SKIRMISH_HELP},
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_MAINMENU_GAMEPLAYOPTIONS,		AVPMENU_OPTIONS,0,0,				TEXTSTRING_MAINMENU_GAMEPLAYOPTIONS_HELP},
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_AVOPTIONS_TITLE,				AVPMENU_MAINMENUAVOPTIONS,0,0,		TEXTSTRING_AVOPTIONS_TITLE_HELP},
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_MAINMENU_CHANGEUSERPROFILE,	AVPMENU_USERPROFILESELECT,0,0,		TEXTSTRING_MAINMENU_CHANGEUSERPROFILE_HELP},
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_MAINMENU_EXITGAME,			AVPMENU_EXITGAME,0,0,				TEXTSTRING_MAINMENU_EXITGAME_HELP},
	{AVPMENU_ELEMENT_ENDOFMENU}
};
#endif
static AVPMENU_ELEMENT AvPMenu_MainMenu_WithCheats[] =
{
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_MAINMENU_STARTSINGLEPLAYER,	AVPMENU_SINGLEPLAYER,0,0,			TEXTSTRING_MAINMENU_STARTSINGLEPLAYER_HELP},
#if SAVE_GAME_ON
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_LOADGAME,						AVPMENU_LOADGAME, 0,0,				TEXTSTRING_LOADGAME_HELP},
#endif
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_MAINMENU_MULTIPLAYER,			AVPMENU_MULTIPLAYER_CONNECTION,0,0,	TEXTSTRING_MAINMENU_MULTIPLAYER_HELP},
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_MAINMENU_SKIRMISH,			AVPMENU_MULTIPLAYER_SKIRMISH,0,0,	TEXTSTRING_MAINMENU_SKIRMISH_HELP},
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_MAINMENU_GAMEPLAYOPTIONS,		AVPMENU_OPTIONS,0,0,				TEXTSTRING_MAINMENU_GAMEPLAYOPTIONS_HELP},
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_AVOPTIONS_TITLE,				AVPMENU_MAINMENUAVOPTIONS,0,0,		TEXTSTRING_AVOPTIONS_TITLE_HELP},
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_MAINMENU_CHANGEUSERPROFILE,	AVPMENU_USERPROFILESELECT,0,0,		TEXTSTRING_MAINMENU_CHANGEUSERPROFILE_HELP},
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_MAINMENU_CHEATOPTIONS,		AVPMENU_CHEATOPTIONS,0,0,			TEXTSTRING_MAINMENU_CHEATOPTIONS_HELP},
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_MAINMENU_EXITGAME,			AVPMENU_EXITGAME,0,0,				TEXTSTRING_MAINMENU_EXITGAME_HELP},
	{AVPMENU_ELEMENT_ENDOFMENU}
};
static AVPMENU_ELEMENT AvPMenu_Debug_MainMenu[] =
{
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_MAINMENU_STARTSINGLEPLAYER,	AVPMENU_SINGLEPLAYER,0,0,			TEXTSTRING_MAINMENU_STARTSINGLEPLAYER_HELP},
#if SAVE_GAME_ON
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_LOADGAME,						AVPMENU_LOADGAME, 0,0,				TEXTSTRING_LOADGAME_HELP},
#endif
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_MAINMENU_SKIRMISH,			AVPMENU_MULTIPLAYER_SKIRMISH,0,0,	TEXTSTRING_MAINMENU_SKIRMISH_HELP},
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_MAINMENU_GAMEPLAYOPTIONS,		AVPMENU_OPTIONS,0,0,				TEXTSTRING_MAINMENU_GAMEPLAYOPTIONS_HELP},
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_AVOPTIONS_TITLE,				AVPMENU_MAINMENUAVOPTIONS,0,0,		TEXTSTRING_AVOPTIONS_TITLE_HELP},
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_MAINMENU_CHANGEUSERPROFILE,	AVPMENU_USERPROFILESELECT,0,0,		TEXTSTRING_MAINMENU_CHANGEUSERPROFILE_HELP},
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_MAINMENU_EXITGAME,			AVPMENU_EXITGAME,0,0,				TEXTSTRING_MAINMENU_EXITGAME_HELP},
	{AVPMENU_ELEMENT_ENDOFMENU}
};
static AVPMENU_ELEMENT AvPMenu_Debug_MainMenu_WithCheats[] =
{
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_MAINMENU_STARTSINGLEPLAYER,	AVPMENU_SINGLEPLAYER,0,0,			TEXTSTRING_MAINMENU_STARTSINGLEPLAYER_HELP},
#if SAVE_GAME_ON
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_LOADGAME,						AVPMENU_LOADGAME, 0,0,				TEXTSTRING_LOADGAME_HELP},
#endif
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_MAINMENU_SKIRMISH,			AVPMENU_MULTIPLAYER_SKIRMISH,0,0,	TEXTSTRING_MAINMENU_SKIRMISH_HELP},
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_MAINMENU_GAMEPLAYOPTIONS,		AVPMENU_OPTIONS,0,0,				TEXTSTRING_MAINMENU_GAMEPLAYOPTIONS_HELP},
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_AVOPTIONS_TITLE,				AVPMENU_MAINMENUAVOPTIONS,0,0,		TEXTSTRING_AVOPTIONS_TITLE_HELP},
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_MAINMENU_CHANGEUSERPROFILE,	AVPMENU_USERPROFILESELECT,0,0,		TEXTSTRING_MAINMENU_CHANGEUSERPROFILE_HELP},
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_MAINMENU_CHEATOPTIONS,		AVPMENU_CHEATOPTIONS,0,0,			TEXTSTRING_MAINMENU_CHEATOPTIONS_HELP},
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_MAINMENU_EXITGAME,			AVPMENU_EXITGAME,0,0,				TEXTSTRING_MAINMENU_EXITGAME_HELP},
	{AVPMENU_ELEMENT_ENDOFMENU}
};

static AVPMENU_ELEMENT AvPMenu_ExitGame[] = 
{
	{AVPMENU_ELEMENT_GOTOMENU, 	TEXTSTRING_NO,	AVPMENU_MAIN},
	{AVPMENU_ELEMENT_QUITGAME,	TEXTSTRING_YES},
	{AVPMENU_ELEMENT_ENDOFMENU}
	
};


static AVPMENU_ELEMENT AvPMenu_SinglePlayer[] =
{
	{AVPMENU_ELEMENT_GOTOMENU_GFX,	AVPMENUGFX_ALIEN_LOGO,		AVPMENU_ALIENLEVELS,0,0,  	TEXTSTRING_MAINMENU_SINGLEPLAYER_ALIEN},
	{AVPMENU_ELEMENT_GOTOMENU_GFX,	AVPMENUGFX_MARINE_LOGO,		AVPMENU_MARINELEVELS,0,0, 	TEXTSTRING_MAINMENU_SINGLEPLAYER_MARINE},
	{AVPMENU_ELEMENT_GOTOMENU_GFX,	AVPMENUGFX_PREDATOR_LOGO,	AVPMENU_PREDATORLEVELS,0,0,	TEXTSTRING_MAINMENU_SINGLEPLAYER_PREDATOR},
//	{AVPMENU_ELEMENT_GOTOMENU,	 	TEXTSTRING_MAINMENU_TITLE,	AVPMENU_MAIN},
	{AVPMENU_ELEMENT_ENDOFMENU}
};
static AVPMENU_ELEMENT AvPMenu_ControlsOptions[] =
{
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MOUSECONTROLS_VERTICAL_AXIS,		1, 	(int*)&PlayerControlMethods.VAxisIsMovement,	TEXTSTRING_MOUSECONTROLS_LOOKING, TEXTSTRING_MOUSECONTROLS_VERTICAL_AXIS_HELP},
	{AVPMENU_ELEMENT_SLIDER, 		TEXTSTRING_MOUSECONTROLS_YSENSITIVITY,		DEFAULT_MOUSEY_SENSITIVITY*3,	(int*)&PlayerControlMethods.MouseYSensitivity, 0, TEXTSTRING_MOUSECONTROLS_YSENSITIVITY_HELP},

	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MOUSECONTROLS_HORIZONTAL_AXIS,	1, 	(int*)&PlayerControlMethods.HAxisIsTurning,		TEXTSTRING_MOUSECONTROLS_SIDESTEPPING, TEXTSTRING_MOUSECONTROLS_HORIZONTAL_AXIS_HELP},
	{AVPMENU_ELEMENT_SLIDER, 		TEXTSTRING_MOUSECONTROLS_XSENSITIVITY,		DEFAULT_MOUSEX_SENSITIVITY*3,	(int*)&PlayerControlMethods.MouseXSensitivity, 0, TEXTSTRING_MOUSECONTROLS_XSENSITIVITY_HELP},

	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MOUSECONTROLS_INVERTVERTICAL,	1, 	(int*)&PlayerControlMethods.FlipVerticalAxis,		TEXTSTRING_NO, TEXTSTRING_MOUSECONTROLS_INVERTVERTICAL_HELP},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MOUSECONTROLS_AUTOCENTRE,		1, 	(int*)&PlayerControlMethods.AutoCentreOnMovement,	TEXTSTRING_NO, TEXTSTRING_MOUSECONTROLS_AUTOCENTRE_HELP},
																						   
	{AVPMENU_ELEMENT_KEYCONFIGOK,	TEXTSTRING_MOUSECONTROLS_SAVETHESESETTINGS,	AVPMENU_INGAME,	0,	0,	TEXTSTRING_MOUSECONTROLS_SAVETHESESETTINGS_HELP},
	{AVPMENU_ELEMENT_RESETKEYCONFIG,	TEXTSTRING_CONTROLS_RESETTODEFAULT,	0,	0,	0, TEXTSTRING_CONTROLS_RESETTODEFAULT_HELP},

	{AVPMENU_ELEMENT_ENDOFMENU}	
};
static AVPMENU_ELEMENT AvPMenu_JoystickControlsOptions[] =
{
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_JOYSTICKCONTROLS_ENABLED,		1, 	(int*)&PlayerJoystickControlMethods.JoystickEnabled,	TEXTSTRING_NO,	TEXTSTRING_JOYSTICKCONTROLS_ENABLED_HELP},

	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MOUSECONTROLS_VERTICAL_AXIS,		1, 	(int*)&PlayerJoystickControlMethods.JoystickVAxisIsMovement,	TEXTSTRING_MOUSECONTROLS_LOOKING,	TEXTSTRING_MOUSECONTROLS_VERTICAL_AXIS_HELP},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MOUSECONTROLS_HORIZONTAL_AXIS,	1, 	(int*)&PlayerJoystickControlMethods.JoystickHAxisIsTurning,		TEXTSTRING_MOUSECONTROLS_SIDESTEPPING,	TEXTSTRING_MOUSECONTROLS_HORIZONTAL_AXIS_HELP},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MOUSECONTROLS_INVERTVERTICAL,	1, 	(int*)&PlayerJoystickControlMethods.JoystickFlipVerticalAxis, 	TEXTSTRING_NO,	TEXTSTRING_JOYSTICKCONTROLS_INVERTVERTICAL_HELP},


	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_JOYSTICKCONTROLS_POVHATVERTICAL,	1, 	(int*)&PlayerJoystickControlMethods.JoystickPOVVAxisIsMovement,	TEXTSTRING_MOUSECONTROLS_LOOKING,	  TEXTSTRING_JOYSTICKCONTROLS_POVHATVERTICAL_HELP},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_JOYSTICKCONTROLS_POVHATHORIZONTAL,1,	(int*)&PlayerJoystickControlMethods.JoystickPOVHAxisIsTurning,	TEXTSTRING_MOUSECONTROLS_SIDESTEPPING, TEXTSTRING_JOYSTICKCONTROLS_POVHATHORIZONTAL_HELP},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_JOYSTICKCONTROLS_POVHATREVERSED,	1, 	(int*)&PlayerJoystickControlMethods.JoystickPOVFlipVerticalAxis,TEXTSTRING_NO,						  TEXTSTRING_JOYSTICKCONTROLS_POVHATREVERSED_HELP},

	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_JOYSTICKCONTROLS_RUDDERENABLED,	1, 	(int*)&PlayerJoystickControlMethods.JoystickRudderEnabled,		TEXTSTRING_NO,	TEXTSTRING_JOYSTICKCONTROLS_RUDDERENABLED_HELP},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_JOYSTICKCONTROLS_RUDDERAXIS,		1, 	(int*)&PlayerJoystickControlMethods.JoystickRudderAxisIsTurning,TEXTSTRING_MOUSECONTROLS_SIDESTEPPING, TEXTSTRING_JOYSTICKCONTROLS_RUDDERAXIS_HELP},

	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_TRACKERBALL_ENABLED,				1, 	(int*)&PlayerJoystickControlMethods.JoystickTrackerBallEnabled,		TEXTSTRING_NO,	TEXTSTRING_TRACKERBALL_ENABLED_HELP},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_TRACKERBALL_FLIPVERTICALAXIS,	1, 	(int*)&PlayerJoystickControlMethods.JoystickTrackerBallFlipVerticalAxis,		TEXTSTRING_NO,	TEXTSTRING_TRACKERBALL_FLIPVERTICALAXIS_HELP},
	{AVPMENU_ELEMENT_SLIDER, 		TEXTSTRING_TRACKERBALL_VERTICAL_SENSITIVITY,		DEFAULT_TRACKERBALL_VERTICAL_SENSITIVITY*3,	(int*)&PlayerJoystickControlMethods.JoystickTrackerBallVerticalSensitivity, 0, TEXTSTRING_MOUSECONTROLS_YSENSITIVITY_HELP},
	{AVPMENU_ELEMENT_SLIDER, 		TEXTSTRING_TRACKERBALL_HORIZONTAL_SENSITIVITY,		DEFAULT_TRACKERBALL_HORIZONTAL_SENSITIVITY*3,	(int*)&PlayerJoystickControlMethods.JoystickTrackerBallHorizontalSensitivity, 0, TEXTSTRING_MOUSECONTROLS_YSENSITIVITY_HELP},

//	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MOUSECONTROLS_AUTOCENTRE,		1, 	(int*)&PlayerControlMethods.AutoCentreOnMovement,	TEXTSTRING_NO},
																						   
	{AVPMENU_ELEMENT_KEYCONFIGOK,	TEXTSTRING_MOUSECONTROLS_SAVETHESESETTINGS,	AVPMENU_INGAME,	0,	0,	TEXTSTRING_MOUSECONTROLS_SAVETHESESETTINGS_HELP},
	{AVPMENU_ELEMENT_RESETKEYCONFIG,	TEXTSTRING_CONTROLS_RESETTODEFAULT,	0,	0,	0, TEXTSTRING_CONTROLS_RESETTODEFAULT_HELP},

	{AVPMENU_ELEMENT_ENDOFMENU}	
};

static AVPMENU_ELEMENT AvPMenu_VideoModeOptions[] =
{
	{AVPMENU_ELEMENT_VIDEOMODE,		TEXTSTRING_VIDEOOPTIONS_TITLE,	0,	0,	0,	TEXTSTRING_VIDEOOPTIONS_TITLE_HELP},
	{AVPMENU_ELEMENT_VIDEOMODEOK,	TEXTSTRING_AVOPTIONS_USETHESESETTINGS,	AVPMENU_MAINMENUAVOPTIONS,	0,	0,	TEXTSTRING_AVOPTIONS_USETHESESETTINGS_HELP},
	{AVPMENU_ELEMENT_ENDOFMENU}
};

static AVPMENU_ELEMENT AvPMenu_InGameAVOptions[] = 
{
	{AVPMENU_ELEMENT_SLIDER, 		TEXTSTRING_AVOPTIONS_GAMMASETTING,	255,	&RequestedGammaSetting},
	{AVPMENU_ELEMENT_SLIDER, 		TEXTSTRING_AVOPTIONS_EFFECTSVOLUME,	 VOLUME_MAX,	&EffectsSoundVolume},
	{AVPMENU_ELEMENT_SLIDER, 		TEXTSTRING_AVOPTIONS_MUSICVOLUME,	 ONE_FIXED/512,	&SmackerSoundVolume},
	{AVPMENU_ELEMENT_SLIDER, 		TEXTSTRING_AVOPTIONS_CDVOLUME,	 CDDA_VOLUME_MAX,	&CDPlayerVolume},
	{AVPMENU_ELEMENT_TEXTSLIDER, 	TEXTSTRING_AVOPTIONS_INGAMEMOVIES, 1, &MoviesAreActive,	TEXTSTRING_NO},
	{AVPMENU_ELEMENT_GOTOMENU,		TEXTSTRING_DETAILLEVELS_TITLE,	AVPMENU_DETAILLEVELS},
	{AVPMENU_ELEMENT_SAVESETTINGS,	TEXTSTRING_AVOPTIONS_USETHESESETTINGS,			0,	0,												0, 									TEXTSTRING_AVOPTIONS_USETHESESETTINGS_HELP},
	{AVPMENU_ELEMENT_ENDOFMENU}
};
static AVPMENU_ELEMENT AvPMenu_MainMenuAVOptions[] = 
{
	{AVPMENU_ELEMENT_GOTOMENU,		TEXTSTRING_VIDEOOPTIONS_TITLE,	AVPMENU_VIDEOMODE,	0,	0,	TEXTSTRING_VIDEOOPTIONS_TITLE_HELP},
	{AVPMENU_ELEMENT_SLIDER, 		TEXTSTRING_AVOPTIONS_EFFECTSVOLUME,	 VOLUME_MAX,	&EffectsSoundVolume,	0,	TEXTSTRING_AVOPTIONS_EFFECTSVOLUME_HELP},
	{AVPMENU_ELEMENT_SLIDER, 		TEXTSTRING_AVOPTIONS_MUSICVOLUME,	 ONE_FIXED/512,	&SmackerSoundVolume,	0,	TEXTSTRING_AVOPTIONS_MUSICVOLUME_HELP},
	{AVPMENU_ELEMENT_SLIDER, 		TEXTSTRING_AVOPTIONS_CDVOLUME,	 CDDA_VOLUME_MAX,	&CDPlayerVolume,		0,	TEXTSTRING_AVOPTIONS_CDVOLUME_HELP},
	{AVPMENU_ELEMENT_TEXTSLIDER, 	TEXTSTRING_AVOPTIONS_INGAMEMOVIES, 1, &MoviesAreActive,	TEXTSTRING_NO,	TEXTSTRING_AVOPTIONS_INGAMEMOVIES_HELP},
	{AVPMENU_ELEMENT_TEXTSLIDER,   	TEXTSTRING_AVOPTIONS_INTROOUTROMOVIES, 1, &IntroOutroMoviesAreActive,	TEXTSTRING_NO,	TEXTSTRING_AVOPTIONS_INTROOUTROMOVIES_HELP},
	{AVPMENU_ELEMENT_GOTOMENU,		TEXTSTRING_DETAILLEVELS_TITLE,	AVPMENU_DETAILLEVELS,	0,	0,	TEXTSTRING_DETAILLEVELS_TITLE_HELP},
	{AVPMENU_ELEMENT_SAVESETTINGS,	TEXTSTRING_AVOPTIONS_USETHESESETTINGS,			0,	0,												0, 									TEXTSTRING_AVOPTIONS_USETHESESETTINGS_HELP},
	{AVPMENU_ELEMENT_ENDOFMENU}
};

static AVPMENU_ELEMENT AvPMenu_UserProfileSelect[] =
{
	{AVPMENU_ELEMENT_USERPROFILE,	 	TEXTSTRING_MARINELEVELS_1,		0, &UserProfileNumber, 0, TEXTSTRING_USERPROFILE_HELP},
	{AVPMENU_ELEMENT_ENDOFMENU}
};
static AVPMENU_ELEMENT AvPMenu_UserProfileEnterName[] =
{
	{AVPMENU_ELEMENT_TEXTFIELD, 	TEXTSTRING_BLANK, MAX_SIZE_OF_USERS_NAME,	NULL},
	{AVPMENU_ELEMENT_GOTOMENU, 		TEXTSTRING_CONTINUE,	AVPMENU_MAIN},
	{AVPMENU_ELEMENT_ENDOFMENU}
};

static AVPMENU_ELEMENT AvPMenu_UserProfileDelete[] = 
{
	{AVPMENU_ELEMENT_GOTOMENU, 				TEXTSTRING_NO,	AVPMENU_USERPROFILESELECT, 0, 0, TEXTSTRING_USERPROFILE_DELETE_HELP},
	{AVPMENU_ELEMENT_USERPROFILE_DELETE, 	TEXTSTRING_YES, 0, 0, 0, TEXTSTRING_USERPROFILE_DELETE_HELP},
	{AVPMENU_ELEMENT_ENDOFMENU}
	
};

static AVPMENU_ELEMENT AvPMenu_MarineLevels[] =
{
	{AVPMENU_ELEMENT_MARINEEPISODE,	 	TEXTSTRING_MARINELEVELS_1,		MAX_NO_OF_MARINE_EPISODES-1, &MarineEpisodeToPlay},
	{AVPMENU_ELEMENT_ENDOFMENU}
};

static AVPMENU_ELEMENT AvPMenu_AlienLevels[] =
{
	{AVPMENU_ELEMENT_ALIENEPISODE,		TEXTSTRING_ALIENLEVELS_1,		MAX_NO_OF_ALIEN_EPISODES-1, &AlienEpisodeToPlay},
	{AVPMENU_ELEMENT_ENDOFMENU}
};

static AVPMENU_ELEMENT AvPMenu_PredatorLevels[] =
{
	{AVPMENU_ELEMENT_PREDATOREPISODE,	TEXTSTRING_PREDATORLEVELS_1, 	MAX_NO_OF_PREDATOR_EPISODES-1, &PredatorEpisodeToPlay},
	{AVPMENU_ELEMENT_ENDOFMENU}
};

static AVPMENU_ELEMENT AvPMenu_Multiplayer[]=
{
	{AVPMENU_ELEMENT_TEXTFIELD, 	TEXTSTRING_MULTIPLAYER_PLAYERNAME,	NET_PLAYERNAMELENGTH-1,	(int*)MP_PlayerName,	0,	TEXTSTRING_MULTIPLAYER_PLAYERNAME_HELP},
	{AVPMENU_ELEMENT_GOTOMENU, 	TEXTSTRING_MULTIPLAYER_STARTGAME,	AVPMENU_MULTIPLAYER_CONFIG,	0,	0,	TEXTSTRING_MULTIPLAYER_STARTGAME_HELP},
	{AVPMENU_ELEMENT_GOTOMENU, 	TEXTSTRING_MULTIPLAYER_JOINGAME,	AVPMENU_MULTIPLAYERJOINGAME,	0,	0,	TEXTSTRING_MULTIPLAYER_JOINGAME_HELP},

	{AVPMENU_ELEMENT_ENDOFMENU}

};


static AVPMENU_ELEMENT AvPMenu_Multiplayer_LobbiedServer[]=
{
	{AVPMENU_ELEMENT_TEXTFIELD, 	TEXTSTRING_MULTIPLAYER_PLAYERNAME,	NET_PLAYERNAMELENGTH-1,	(int*)MP_PlayerName,	0,	TEXTSTRING_MULTIPLAYER_PLAYERNAME_HELP},
	{AVPMENU_ELEMENT_GOTOMENU, 	TEXTSTRING_MULTIPLAYER_CONTINUE,	AVPMENU_MULTIPLAYER_CONFIG,	0,	0,	TEXTSTRING_MULTIPLAYER_CONTINUETOCONFIG_HELP},

	{AVPMENU_ELEMENT_ENDOFMENU}
};

static AVPMENU_ELEMENT AvPMenu_Multiplayer_LobbiedClient[]=
{
	{AVPMENU_ELEMENT_TEXTFIELD, 	TEXTSTRING_MULTIPLAYER_PLAYERNAME,	NET_PLAYERNAMELENGTH-1,	(int*)MP_PlayerName,	0,	TEXTSTRING_MULTIPLAYER_PLAYERNAME_HELP},
	{AVPMENU_ELEMENT_JOINLOBBIED, 	TEXTSTRING_MULTIPLAYER_CONTINUE,	AVPMENU_MULTIPLAYER_JOINING,	0,	0,	TEXTSTRING_MULTIPLAYER_CONTINUETOCONFIG_HELP},

	{AVPMENU_ELEMENT_ENDOFMENU}
};

static AVPMENU_ELEMENT AvPMenu_Multiplayer_Skirmish[]=
{
	{AVPMENU_ELEMENT_TEXTFIELD, 	TEXTSTRING_MULTIPLAYER_PLAYERNAME,	NET_PLAYERNAMELENGTH-1,	(int*)MP_PlayerName,	0,	TEXTSTRING_MULTIPLAYER_PLAYERNAME_HELP},
	{AVPMENU_ELEMENT_GOTOMENU, 	TEXTSTRING_MULTIPLAYER_CONTINUE,	AVPMENU_MULTIPLAYER_CONFIG,	0,	0,	TEXTSTRING_MULTIPLAYER_CONTINUETOCONFIG_HELP},
	{AVPMENU_ELEMENT_ENDOFMENU}
};

static AVPMENU_ELEMENT AvPMenu_MultiplayerStartGame[]=
{
	{AVPMENU_ELEMENT_TEXTFIELD, 	TEXTSTRING_MULTIPLAYER_SESSIONNAME,	MAX_MULTIPLAYER_NAME_LENGTH,	(int*)MP_SessionName},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_SPECIES,		2,								&MP_Species,		TEXTSTRING_MULTIPLAYER_MARINE},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_GAMESTYLE,	3,								&MP_GameStyle,		TEXTSTRING_MULTIPLAYER_DEATHMATCH},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ENVIRONMENT, MAX_NO_OF_MULTIPLAYER_EPISODES-1,	&MP_LevelNumber,	TEXTSTRING_MULTIPLAYERLEVELS_1},
	{AVPMENU_ELEMENT_STARTMPGAME,	TEXTSTRING_LEVELSELECT_START,	0},
	{AVPMENU_ELEMENT_ENDOFMENU}


};
static AVPMENU_ELEMENT AvPMenu_MultiplayerJoinGame[]=
{
	{AVPMENU_ELEMENT_GOTOMENU,	 	TEXTSTRING_MULTIPLAYER_FINDLOCAL,	AVPMENU_MULTIPLAYERSELECTSESSION,	0,	0,	TEXTSTRING_MULTIPLAYER_FINDLOCAL_HELP},
	{AVPMENU_ELEMENT_GOTOMENU,	 	TEXTSTRING_MULTIPLAYER_OPENADDRESS,	AVPMENU_MULTIPLAYEROPENADDRESS,	0,	0,	TEXTSTRING_MULTIPLAYER_OPENADDRESS_HELP},
	{AVPMENU_ELEMENT_ENDOFMENU}
};
static AVPMENU_ELEMENT AvPMenu_MultiplayerJoinGame2[]=
{
	{AVPMENU_ELEMENT_DUMMYTEXTFIELD, 	TEXTSTRING_MULTIPLAYER_SESSIONNAME,	MAX_MULTIPLAYER_NAME_LENGTH,		(int*)MP_SessionName},
	{AVPMENU_ELEMENT_TEXTSLIDER,		TEXTSTRING_MULTIPLAYER_SPECIES,		2,									&MP_Species,		TEXTSTRING_MULTIPLAYER_MARINE},
	{AVPMENU_ELEMENT_DUMMYTEXTSLIDER,	TEXTSTRING_MULTIPLAYER_GAMESTYLE,	1,									&MP_GameStyle,		TEXTSTRING_MULTIPLAYER_DEATHMATCH},
	{AVPMENU_ELEMENT_DUMMYTEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ENVIRONMENT, MAX_NO_OF_MULTIPLAYER_EPISODES-1,	&MP_LevelNumber,	TEXTSTRING_MULTIPLAYERLEVELS_1},
	{AVPMENU_ELEMENT_JOINMPGAME,		TEXTSTRING_LEVELSELECT_START,		0},
	{AVPMENU_ELEMENT_ENDOFMENU}

};
static AVPMENU_ELEMENT AvPMenu_MultiplayerSelectSession[]=
{
	{AVPMENU_ELEMENT_ENDOFMENU}, // 1
	{AVPMENU_ELEMENT_ENDOFMENU}, // 2
	{AVPMENU_ELEMENT_ENDOFMENU}, // 3
	{AVPMENU_ELEMENT_ENDOFMENU}, // 4
	{AVPMENU_ELEMENT_ENDOFMENU}, // 5
	{AVPMENU_ELEMENT_ENDOFMENU}, // 6
	{AVPMENU_ELEMENT_ENDOFMENU}, // 7
	{AVPMENU_ELEMENT_ENDOFMENU}, // 8
	{AVPMENU_ELEMENT_ENDOFMENU}, // 9
	{AVPMENU_ELEMENT_ENDOFMENU}, // 10

	{AVPMENU_ELEMENT_ENDOFMENU}
};

static AVPMENU_ELEMENT AvPMenu_MultiplayerConnection[]=
{
	{AVPMENU_ELEMENT_ENDOFMENU}, // 1
	{AVPMENU_ELEMENT_ENDOFMENU}, // 2
	{AVPMENU_ELEMENT_ENDOFMENU}, // 3
	{AVPMENU_ELEMENT_ENDOFMENU}, // 4
	{AVPMENU_ELEMENT_ENDOFMENU}, // 5

	{AVPMENU_ELEMENT_ENDOFMENU}
};

static AVPMENU_ELEMENT AvPMenu_MultiplayerOpenAddress[]=
{
	{AVPMENU_ELEMENT_TEXTFIELD, TEXTSTRING_MULTIPLAYER_ADDRESS,	MAX_IPADDRESS_LENGTH,	(int*)IPAddressString,	0,	TEXTSTRING_MPHELP_IPADDRESS},
	{AVPMENU_ELEMENT_TEXTFIELD, TEXTSTRING_FILENAME, 20,	(int*)IP_Address_Name,	0,	TEXTSTRING_MPHELP_ADDRESSDESCRIPTION},
	{AVPMENU_ELEMENT_GOTOMENU,	TEXTSTRING_MULTIPLAYER_OKTOCONNECT,	AVPMENU_MULTIPLAYERSELECTSESSION,	0,	0,	TEXTSTRING_MULTIPLAYER_OKTOCONNECT_HELP},
	{AVPMENU_ELEMENT_GOTOMENU,	TEXTSTRING_MULTIPLAYER_LOADADDRESS,	AVPMENU_MULTIPLAYER_LOADIPADDRESS,	0,	0,	TEXTSTRING_MPHELP_LOADADDRESS},
	{AVPMENU_ELEMENT_ENDOFMENU}

};

AVPMENU_ELEMENT AvPMenu_Multiplayer_Config[]=
{
	{AVPMENU_ELEMENT_RESETMPCONFIG, 	TEXTSTRING_CONTROLS_RESETTODEFAULT,	0,	0,	TEXTSTRING_BLANK,	TEXTSTRING_CONTROLS_RESETTODEFAULT_HELP},
	{AVPMENU_ELEMENT_GOTOMENU, 	TEXTSTRING_MULTIPLAYER_LOADCONFIG,	AVPMENU_MULTIPLAYER_LOADCONFIG,	0,	TEXTSTRING_BLANK,	TEXTSTRING_MULTIPLAYER_LOADCONFIG_HELP},
	{AVPMENU_ELEMENT_GOTOMENU, 	TEXTSTRING_MULTIPLAYER_SAVECONFIG,	AVPMENU_MULTIPLAYER_SAVECONFIG,	0,	TEXTSTRING_BLANK,	TEXTSTRING_MULTIPLAYER_SAVECONFIG_HELP},
	
	{AVPMENU_ELEMENT_GOTOMENU, 	TEXTSTRING_LEVELSELECT_START,	AVPMENU_MULTIPLAYER_SPECIES_HOST,	0,	TEXTSTRING_BLANK,	TEXTSTRING_LEVELSELECT_START_HELP},
	
	{AVPMENU_ELEMENT_TEXTFIELD, 	TEXTSTRING_MULTIPLAYER_SESSIONNAME,	MAX_MULTIPLAYER_NAME_LENGTH,	(int*)MP_SessionName,	TEXTSTRING_BLANK,	TEXTSTRING_MPHELP_SESSIONNAME},

 	#ifdef MPLAYER_DEMO
 	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_GAMESTYLE,	1,								(int*)&netGameData.gameType,		TEXTSTRING_MULTIPLAYER_DEATHMATCH,	TEXTSTRING_MPHELP_GAMESTYLE_DEATHMATCH},
 	#else
  	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_GAMESTYLE,	5,								(int*)&netGameData.gameType,		TEXTSTRING_MULTIPLAYER_DEATHMATCH,	TEXTSTRING_MPHELP_GAMESTYLE_DEATHMATCH},
 	#endif
	//values initialised later
	{AVPMENU_ELEMENT_TEXTSLIDER_POINTER,	TEXTSTRING_MULTIPLAYER_ENVIRONMENT, 0,	&netGameData.levelNumber,	0,	TEXTSTRING_MPHELP_ENVIRONMENT},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_GAMESPEED,	3,								(int*)&netGameData.gameSpeed,		TEXTSTRING_MULTIPLAYER_70PERCENT,	TEXTSTRING_MPHELP_GAMESPEED},

	{AVPMENU_ELEMENT_NUMBERFIELD,	TEXTSTRING_MULTIPLAYER_SCORELIMIT,	1000000,	&netGameData.scoreLimit,	TEXTSTRING_MULTIPLAYER_POINTS,	TEXTSTRING_MPHELP_SCORELIMIT,	TEXTSTRING_MULTIPLAYER_NOSCORELIMIT},
	{AVPMENU_ELEMENT_NUMBERFIELD,	TEXTSTRING_MULTIPLAYER_TIMELIMIT,	255,	&netGameData.timeLimit,			TEXTSTRING_MULTIPLAYER_MINUTES,	TEXTSTRING_MPHELP_TIMELIMIT,	TEXTSTRING_MULTIPLAYER_NOTIMELIMIT},
	{AVPMENU_ELEMENT_NUMBERFIELD,	TEXTSTRING_MULTIPLAYER_INVULNTIME,	255,	&netGameData.invulnerableTime,	TEXTSTRING_MULTIPLAYER_SECONDS,	TEXTSTRING_MPHELP_INVULNTIME,	TEXTSTRING_BLANK},
	
	{AVPMENU_ELEMENT_NUMBERFIELD,	TEXTSTRING_MULTIPLAYER_MAXPREDATOR,				8,	&netGameData.maxPredator,	TEXTSTRING_BLANK,	TEXTSTRING_MPHELP_MAXCHARACTER,	TEXTSTRING_BLANK},
	{AVPMENU_ELEMENT_NUMBERFIELD,	TEXTSTRING_MULTIPLAYER_MAXALIEN,				8,	&netGameData.maxAlien,	TEXTSTRING_BLANK,	TEXTSTRING_MPHELP_MAXCHARACTER,	TEXTSTRING_BLANK},
	{AVPMENU_ELEMENT_NUMBERFIELD,	TEXTSTRING_MULTIPLAYER_MAXMARINE,				8,	&netGameData.maxMarine,	TEXTSTRING_BLANK,	TEXTSTRING_MPHELP_MAXCHARACTER,	TEXTSTRING_BLANK},
	{AVPMENU_ELEMENT_NUMBERFIELD,	TEXTSTRING_MULTIPLAYER_MAXMARINE_GENERAL,		8,	&netGameData.maxMarineGeneral,	TEXTSTRING_BLANK,	TEXTSTRING_MPHELP_MAXSPECIALIST,	TEXTSTRING_BLANK},
	{AVPMENU_ELEMENT_NUMBERFIELD,	TEXTSTRING_MULTIPLAYER_MAXMARINE_PULSERIFLE,	8,	&netGameData.maxMarinePulseRifle,	TEXTSTRING_BLANK,	TEXTSTRING_MPHELP_MAXSPECIALIST,	TEXTSTRING_BLANK},
	{AVPMENU_ELEMENT_NUMBERFIELD,	TEXTSTRING_MULTIPLAYER_MAXMARINE_SMARTGUN,		8,	&netGameData.maxMarineSmartgun,	TEXTSTRING_BLANK,	TEXTSTRING_MPHELP_MAXSPECIALIST,	TEXTSTRING_BLANK},
	{AVPMENU_ELEMENT_NUMBERFIELD,	TEXTSTRING_MULTIPLAYER_MAXMARINE_FLAMER,		8,	&netGameData.maxMarineFlamer,	TEXTSTRING_BLANK,	TEXTSTRING_MPHELP_MAXSPECIALIST,	TEXTSTRING_BLANK},
	{AVPMENU_ELEMENT_NUMBERFIELD,	TEXTSTRING_MULTIPLAYER_MAXMARINE_SADAR,			8,	&netGameData.maxMarineSadar,	TEXTSTRING_BLANK,	TEXTSTRING_MPHELP_MAXSPECIALIST,	TEXTSTRING_BLANK},
	{AVPMENU_ELEMENT_NUMBERFIELD,	TEXTSTRING_MULTIPLAYER_MAXMARINE_GRENADE,		8,	&netGameData.maxMarineGrenade,	TEXTSTRING_BLANK,	TEXTSTRING_MPHELP_MAXSPECIALIST,	TEXTSTRING_BLANK},
	{AVPMENU_ELEMENT_NUMBERFIELD,	TEXTSTRING_MULTIPLAYER_MAXMARINE_MINIGUN,		8,	&netGameData.maxMarineMinigun,	TEXTSTRING_BLANK,	TEXTSTRING_MPHELP_MAXSPECIALIST,	TEXTSTRING_BLANK},
	{AVPMENU_ELEMENT_NUMBERFIELD,	TEXTSTRING_MULTIPLAYER_MAXMARINE_SKEETER,		8,	&netGameData.maxMarineSmartDisc,	TEXTSTRING_BLANK,	TEXTSTRING_MPHELP_MAXSPECIALIST,	TEXTSTRING_BLANK},
	{AVPMENU_ELEMENT_NUMBERFIELD,	TEXTSTRING_MULTIPLAYER_MAXMARINE_PISTOLS,		8,	&netGameData.maxMarinePistols,	TEXTSTRING_BLANK,	TEXTSTRING_MPHELP_MAXSPECIALIST,	TEXTSTRING_BLANK},

	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ALLOW_SMARTGUN,	1,	&netGameData.allowSmartgun,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_ALLOWEAPON},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ALLOW_FLAMER,	1,	&netGameData.allowFlamer,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_ALLOWEAPON},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ALLOW_SADAR,	1,	&netGameData.allowSadar,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_ALLOWEAPON},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ALLOW_GRENADELAUNCHER,	1,	&netGameData.allowGrenadeLauncher,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_ALLOWEAPON},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ALLOW_MINIGUN,	1,	&netGameData.allowMinigun,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_ALLOWEAPON},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ALLOW_SKEETER,	1,	&netGameData.allowSmartDisc,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_ALLOWEAPON},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ALLOW_MARINE_PISTOLS,	1,	&netGameData.allowPistols,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_ALLOWEAPON},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ALLOW_DISC,	1,	&netGameData.allowDisc,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_ALLOWEAPON_PRED},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ALLOW_PISTOL,	1,	&netGameData.allowPistol,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_ALLOWEAPON_PRED},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ALLOW_PLASMACASTER,	1,	&netGameData.allowPlasmaCaster,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_ALLOWEAPON_PRED},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ALLOW_SPEARGUN,	1,	&netGameData.allowSpeargun,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_ALLOWEAPON_PRED},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ALLOW_MEDICOMP,	1,	&netGameData.allowMedicomp,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_ALLOWEAPON_PRED},

	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_DYNAMICSCORING,	1,	&netGameData.useDynamicScoring,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_DYNAMICSCORING},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_CHARACTERSCORING,	1,	&netGameData.useCharacterKillValues,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_CHARACTERSCORING},
	
	{AVPMENU_ELEMENT_NUMBERFIELD,	TEXTSTRING_MULTIPLAYER_BASEKILLVALUE,	255,	&netGameData.baseKillValue,	TEXTSTRING_MULTIPLAYER_POINTS,	TEXTSTRING_MPHELP_BASEKILLVALUE,	TEXTSTRING_BLANK},
	{AVPMENU_ELEMENT_NUMBERFIELD,	TEXTSTRING_MULTIPLAYER_ALIENVALUE,	255,	&netGameData.characterKillValues[NGCT_Alien],	TEXTSTRING_BLANK,	TEXTSTRING_MPHELP_ALIENVALUE,	TEXTSTRING_BLANK},
	{AVPMENU_ELEMENT_NUMBERFIELD,	TEXTSTRING_MULTIPLAYER_MARINEVALUE,	255,	&netGameData.characterKillValues[NGCT_Marine],	TEXTSTRING_BLANK,	TEXTSTRING_MPHELP_MARINEVALUE,	TEXTSTRING_BLANK},
	{AVPMENU_ELEMENT_NUMBERFIELD,	TEXTSTRING_MULTIPLAYER_PREDATORVALUE,	255,	&netGameData.characterKillValues[NGCT_Predator],	TEXTSTRING_BLANK,	TEXTSTRING_MPHELP_PREDATORVALUE,	TEXTSTRING_BLANK},

	{AVPMENU_ELEMENT_NUMBERFIELD,	TEXTSTRING_MULTIPLAYER_AI_ALIENVALUE,	255,	&netGameData.aiKillValues[0],	TEXTSTRING_MULTIPLAYER_POINTS,	TEXTSTRING_MPHELP_AIVALUE,	TEXTSTRING_BLANK},
	{AVPMENU_ELEMENT_NUMBERFIELD,	TEXTSTRING_MULTIPLAYER_AI_PREDALIENVALUE,	255,	&netGameData.aiKillValues[1],	TEXTSTRING_MULTIPLAYER_POINTS,	TEXTSTRING_MPHELP_AIVALUE,	TEXTSTRING_BLANK},
	{AVPMENU_ELEMENT_NUMBERFIELD,	TEXTSTRING_MULTIPLAYER_AI_PRAETORIANVALUE,	255,	&netGameData.aiKillValues[2],	TEXTSTRING_MULTIPLAYER_POINTS,	TEXTSTRING_MPHELP_AIVALUE,	TEXTSTRING_BLANK},
	
	{AVPMENU_ELEMENT_NUMBERFIELD,	TEXTSTRING_MULTIPLAYER_LIVES,	255,	&netGameData.maxLives,	TEXTSTRING_BLANK,	TEXTSTRING_MPHELP_LIVES,	TEXTSTRING_MULTIPLAYER_INFINITE},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_SHAREDLIVES,	1,	&netGameData.useSharedLives,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_SHAREDLIVES},

	{AVPMENU_ELEMENT_NUMBERFIELD,	TEXTSTRING_MULTIPLAYER_RESPAWN_POINTS,	1000000,	&netGameData.pointsForRespawn,	TEXTSTRING_MULTIPLAYER_POINTS,	TEXTSTRING_MPHELP_RESPAWN_POINTS,	TEXTSTRING_MULTIPLAYER_RESPAWN_POINTS_NO},
	{AVPMENU_ELEMENT_NUMBERFIELD,	TEXTSTRING_MULTIPLAYER_RESPAWN_TIME,	255,	&netGameData.timeForRespawn,	TEXTSTRING_MULTIPLAYER_SECONDS,	TEXTSTRING_MPHELP_RESPAWN_TIME,	TEXTSTRING_MULTIPLAYER_RESPAWN_TIME_NO},
	
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_PREDESTROYLIGHTS,	1,	&netGameData.preDestroyLights,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_PREDESTROYLIGHTS},

	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_NOFRIENDLYFIRE,	1,	&netGameData.disableFriendlyFire,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_NOFRIENDLYFIRE},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_FALLINGDAMAGE,	1,	&netGameData.fallingDamage,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_FALLINGDAMAGE},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_PISTOLINFINITEAMMO,	1,	&netGameData.pistolInfiniteAmmo,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_PISTOLINFINITEAMMO},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_SPECIALISTPISTOLS,	1,	&netGameData.specialistPistols,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_SPECIALISTPISTOLS},

	{AVPMENU_ELEMENT_ENDOFMENU}
};

AVPMENU_ELEMENT AvPMenu_Multiplayer_Config_Join[]=
{
	{AVPMENU_ELEMENT_GOTOMENU, 	TEXTSTRING_LEVELSELECT_START,	AVPMENU_MULTIPLAYER_SPECIES_JOIN,	0,	TEXTSTRING_BLANK,	TEXTSTRING_LEVELSELECT_START_HELP},
	
	{AVPMENU_ELEMENT_DUMMYTEXTFIELD, 	TEXTSTRING_MULTIPLAYER_SESSIONNAME,	MAX_MULTIPLAYER_NAME_LENGTH,	(int*)MP_SessionName,	TEXTSTRING_BLANK,	TEXTSTRING_MPHELP_SESSIONNAME},
	{AVPMENU_ELEMENT_DUMMYTEXTSLIDER,	TEXTSTRING_MULTIPLAYER_GAMESTYLE,	5,								(int*)&netGameData.gameType,		TEXTSTRING_MULTIPLAYER_DEATHMATCH,	TEXTSTRING_MPHELP_GAMESTYLE_DEATHMATCH},
	//values initialised later
	{AVPMENU_ELEMENT_DUMMYTEXTSLIDER_POINTER,	TEXTSTRING_MULTIPLAYER_ENVIRONMENT, 0,	&netGameData.levelNumber,	0,	TEXTSTRING_MPHELP_ENVIRONMENT},
	{AVPMENU_ELEMENT_DUMMYTEXTSLIDER,	TEXTSTRING_MULTIPLAYER_GAMESPEED,	3,								(int*)&netGameData.gameSpeed,		TEXTSTRING_MULTIPLAYER_70PERCENT,	TEXTSTRING_MPHELP_GAMESPEED},

	{AVPMENU_ELEMENT_DUMMYNUMBERFIELD,	TEXTSTRING_MULTIPLAYER_SCORELIMIT,	1000000,	&netGameData.scoreLimit,	TEXTSTRING_MULTIPLAYER_POINTS,	TEXTSTRING_MPHELP_SCORELIMIT,	TEXTSTRING_MULTIPLAYER_NOSCORELIMIT},
	{AVPMENU_ELEMENT_DUMMYNUMBERFIELD,	TEXTSTRING_MULTIPLAYER_TIMELIMIT,	255,	&netGameData.timeLimit,			TEXTSTRING_MULTIPLAYER_MINUTES,	TEXTSTRING_MPHELP_TIMELIMIT,	TEXTSTRING_MULTIPLAYER_NOTIMELIMIT},
	{AVPMENU_ELEMENT_DUMMYNUMBERFIELD,	TEXTSTRING_MULTIPLAYER_INVULNTIME,	255,	&netGameData.invulnerableTime,	TEXTSTRING_MULTIPLAYER_SECONDS,	TEXTSTRING_MPHELP_INVULNTIME,	TEXTSTRING_BLANK},
	
	{AVPMENU_ELEMENT_DUMMYNUMBERFIELD,	TEXTSTRING_MULTIPLAYER_MAXPREDATOR,				8,	&netGameData.maxPredator,	TEXTSTRING_BLANK,	TEXTSTRING_MPHELP_MAXCHARACTER,	TEXTSTRING_BLANK},
	{AVPMENU_ELEMENT_DUMMYNUMBERFIELD,	TEXTSTRING_MULTIPLAYER_MAXALIEN,				8,	&netGameData.maxAlien,	TEXTSTRING_BLANK,	TEXTSTRING_MPHELP_MAXCHARACTER,	TEXTSTRING_BLANK},
	{AVPMENU_ELEMENT_DUMMYNUMBERFIELD,	TEXTSTRING_MULTIPLAYER_MAXMARINE,				8,	&netGameData.maxMarine,	TEXTSTRING_BLANK,	TEXTSTRING_MPHELP_MAXCHARACTER,	TEXTSTRING_BLANK},
	{AVPMENU_ELEMENT_DUMMYNUMBERFIELD,	TEXTSTRING_MULTIPLAYER_MAXMARINE_GENERAL,		8,	&netGameData.maxMarineGeneral,	TEXTSTRING_BLANK,	TEXTSTRING_MPHELP_MAXSPECIALIST,	TEXTSTRING_BLANK},
	{AVPMENU_ELEMENT_DUMMYNUMBERFIELD,	TEXTSTRING_MULTIPLAYER_MAXMARINE_PULSERIFLE,	8,	&netGameData.maxMarinePulseRifle,	TEXTSTRING_BLANK,	TEXTSTRING_MPHELP_MAXSPECIALIST,	TEXTSTRING_BLANK},
	{AVPMENU_ELEMENT_DUMMYNUMBERFIELD,	TEXTSTRING_MULTIPLAYER_MAXMARINE_SMARTGUN,		8,	&netGameData.maxMarineSmartgun,	TEXTSTRING_BLANK,	TEXTSTRING_MPHELP_MAXSPECIALIST,	TEXTSTRING_BLANK},
	{AVPMENU_ELEMENT_DUMMYNUMBERFIELD,	TEXTSTRING_MULTIPLAYER_MAXMARINE_FLAMER,		8,	&netGameData.maxMarineFlamer,	TEXTSTRING_BLANK,	TEXTSTRING_MPHELP_MAXSPECIALIST,	TEXTSTRING_BLANK},
	{AVPMENU_ELEMENT_DUMMYNUMBERFIELD,	TEXTSTRING_MULTIPLAYER_MAXMARINE_SADAR,			8,	&netGameData.maxMarineSadar,	TEXTSTRING_BLANK,	TEXTSTRING_MPHELP_MAXSPECIALIST,	TEXTSTRING_BLANK},
	{AVPMENU_ELEMENT_DUMMYNUMBERFIELD,	TEXTSTRING_MULTIPLAYER_MAXMARINE_GRENADE,		8,	&netGameData.maxMarineGrenade,	TEXTSTRING_BLANK,	TEXTSTRING_MPHELP_MAXSPECIALIST,	TEXTSTRING_BLANK},
	{AVPMENU_ELEMENT_DUMMYNUMBERFIELD,	TEXTSTRING_MULTIPLAYER_MAXMARINE_MINIGUN,		8,	&netGameData.maxMarineMinigun,	TEXTSTRING_BLANK,	TEXTSTRING_MPHELP_MAXSPECIALIST,	TEXTSTRING_BLANK},
	{AVPMENU_ELEMENT_DUMMYNUMBERFIELD,	TEXTSTRING_MULTIPLAYER_MAXMARINE_SKEETER,		8,	&netGameData.maxMarineSmartDisc,	TEXTSTRING_BLANK,	TEXTSTRING_MPHELP_MAXSPECIALIST,	TEXTSTRING_BLANK},
	{AVPMENU_ELEMENT_DUMMYNUMBERFIELD,	TEXTSTRING_MULTIPLAYER_MAXMARINE_PISTOLS,		8,	&netGameData.maxMarinePistols,	TEXTSTRING_BLANK,	TEXTSTRING_MPHELP_MAXSPECIALIST,	TEXTSTRING_BLANK},

	{AVPMENU_ELEMENT_DUMMYTEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ALLOW_SMARTGUN,	1,	&netGameData.allowSmartgun,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_ALLOWEAPON},
	{AVPMENU_ELEMENT_DUMMYTEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ALLOW_FLAMER,	1,	&netGameData.allowFlamer,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_ALLOWEAPON},
	{AVPMENU_ELEMENT_DUMMYTEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ALLOW_SADAR,	1,	&netGameData.allowSadar,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_ALLOWEAPON},
	{AVPMENU_ELEMENT_DUMMYTEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ALLOW_GRENADELAUNCHER,	1,	&netGameData.allowGrenadeLauncher,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_ALLOWEAPON},
	{AVPMENU_ELEMENT_DUMMYTEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ALLOW_MINIGUN,	1,	&netGameData.allowMinigun,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_ALLOWEAPON},
	{AVPMENU_ELEMENT_DUMMYTEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ALLOW_SKEETER,	1,	&netGameData.allowSmartDisc,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_ALLOWEAPON},
	{AVPMENU_ELEMENT_DUMMYTEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ALLOW_MARINE_PISTOLS,	1,	&netGameData.allowPistols,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_ALLOWEAPON},
	{AVPMENU_ELEMENT_DUMMYTEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ALLOW_DISC,	1,	&netGameData.allowDisc,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_ALLOWEAPON_PRED},
	{AVPMENU_ELEMENT_DUMMYTEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ALLOW_PISTOL,	1,	&netGameData.allowPistol,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_ALLOWEAPON_PRED},
	{AVPMENU_ELEMENT_DUMMYTEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ALLOW_PLASMACASTER,	1,	&netGameData.allowPlasmaCaster,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_ALLOWEAPON_PRED},
	{AVPMENU_ELEMENT_DUMMYTEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ALLOW_SPEARGUN,	1,	&netGameData.allowSpeargun,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_ALLOWEAPON_PRED},
	{AVPMENU_ELEMENT_DUMMYTEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ALLOW_MEDICOMP,	1,	&netGameData.allowMedicomp,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_ALLOWEAPON_PRED},

	{AVPMENU_ELEMENT_DUMMYTEXTSLIDER,	TEXTSTRING_MULTIPLAYER_DYNAMICSCORING,	1,	&netGameData.useDynamicScoring,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_DYNAMICSCORING},
	{AVPMENU_ELEMENT_DUMMYTEXTSLIDER,	TEXTSTRING_MULTIPLAYER_CHARACTERSCORING,	1,	&netGameData.useCharacterKillValues,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_CHARACTERSCORING},
	
	{AVPMENU_ELEMENT_DUMMYNUMBERFIELD,	TEXTSTRING_MULTIPLAYER_BASEKILLVALUE,	255,	&netGameData.baseKillValue,	TEXTSTRING_MULTIPLAYER_POINTS,	TEXTSTRING_MPHELP_BASEKILLVALUE,	TEXTSTRING_BLANK},
	{AVPMENU_ELEMENT_DUMMYNUMBERFIELD,	TEXTSTRING_MULTIPLAYER_ALIENVALUE,	255,	&netGameData.characterKillValues[NGCT_Alien],	TEXTSTRING_BLANK,	TEXTSTRING_MPHELP_ALIENVALUE,	TEXTSTRING_BLANK},
	{AVPMENU_ELEMENT_DUMMYNUMBERFIELD,	TEXTSTRING_MULTIPLAYER_MARINEVALUE,	255,	&netGameData.characterKillValues[NGCT_Marine],	TEXTSTRING_BLANK,	TEXTSTRING_MPHELP_MARINEVALUE,	TEXTSTRING_BLANK},
	{AVPMENU_ELEMENT_DUMMYNUMBERFIELD,	TEXTSTRING_MULTIPLAYER_PREDATORVALUE,	255,	&netGameData.characterKillValues[NGCT_Predator],	TEXTSTRING_BLANK,	TEXTSTRING_MPHELP_PREDATORVALUE,	TEXTSTRING_BLANK},

	{AVPMENU_ELEMENT_DUMMYNUMBERFIELD,	TEXTSTRING_MULTIPLAYER_AI_ALIENVALUE,	255,	&netGameData.aiKillValues[0],	TEXTSTRING_MULTIPLAYER_POINTS,	TEXTSTRING_MPHELP_AIVALUE,	TEXTSTRING_BLANK},
	{AVPMENU_ELEMENT_DUMMYNUMBERFIELD,	TEXTSTRING_MULTIPLAYER_AI_PREDALIENVALUE,	255,	&netGameData.aiKillValues[1],	TEXTSTRING_MULTIPLAYER_POINTS,	TEXTSTRING_MPHELP_AIVALUE,	TEXTSTRING_BLANK},
	{AVPMENU_ELEMENT_DUMMYNUMBERFIELD,	TEXTSTRING_MULTIPLAYER_AI_PRAETORIANVALUE,	255,	&netGameData.aiKillValues[2],	TEXTSTRING_MULTIPLAYER_POINTS,	TEXTSTRING_MPHELP_AIVALUE,	TEXTSTRING_BLANK},
	
	{AVPMENU_ELEMENT_DUMMYNUMBERFIELD,	TEXTSTRING_MULTIPLAYER_LIVES,	255,	&netGameData.maxLives,	TEXTSTRING_BLANK,	TEXTSTRING_MPHELP_LIVES,	TEXTSTRING_MULTIPLAYER_INFINITE},
	{AVPMENU_ELEMENT_DUMMYTEXTSLIDER,	TEXTSTRING_MULTIPLAYER_SHAREDLIVES,	1,	&netGameData.useSharedLives,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_SHAREDLIVES},

	{AVPMENU_ELEMENT_DUMMYNUMBERFIELD,	TEXTSTRING_MULTIPLAYER_RESPAWN_POINTS,	1000000,	&netGameData.pointsForRespawn,	TEXTSTRING_MULTIPLAYER_POINTS,	TEXTSTRING_MPHELP_RESPAWN_POINTS,	TEXTSTRING_MULTIPLAYER_RESPAWN_POINTS_NO},
	{AVPMENU_ELEMENT_DUMMYNUMBERFIELD,	TEXTSTRING_MULTIPLAYER_RESPAWN_TIME,	255,	&netGameData.timeForRespawn,	TEXTSTRING_MULTIPLAYER_SECONDS,	TEXTSTRING_MPHELP_RESPAWN_TIME,	TEXTSTRING_MULTIPLAYER_RESPAWN_TIME_NO},
	
	{AVPMENU_ELEMENT_DUMMYTEXTSLIDER,	TEXTSTRING_MULTIPLAYER_PREDESTROYLIGHTS,	1,	&netGameData.preDestroyLights,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_PREDESTROYLIGHTS},

	{AVPMENU_ELEMENT_DUMMYTEXTSLIDER,	TEXTSTRING_MULTIPLAYER_NOFRIENDLYFIRE,	1,	&netGameData.disableFriendlyFire,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_NOFRIENDLYFIRE},
	{AVPMENU_ELEMENT_DUMMYTEXTSLIDER,	TEXTSTRING_MULTIPLAYER_FALLINGDAMAGE,	1,	&netGameData.fallingDamage,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_FALLINGDAMAGE},
	{AVPMENU_ELEMENT_DUMMYTEXTSLIDER,	TEXTSTRING_MULTIPLAYER_PISTOLINFINITEAMMO,	1,	&netGameData.pistolInfiniteAmmo,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_PISTOLINFINITEAMMO},
	{AVPMENU_ELEMENT_DUMMYTEXTSLIDER,	TEXTSTRING_MULTIPLAYER_SPECIALISTPISTOLS,	1,	&netGameData.specialistPistols,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_SPECIALISTPISTOLS},

	{AVPMENU_ELEMENT_ENDOFMENU}
};


AVPMENU_ELEMENT AvPMenu_Skirmish_Config[]=
{
	{AVPMENU_ELEMENT_RESETMPCONFIG, 	TEXTSTRING_CONTROLS_RESETTODEFAULT,	0,	0,	TEXTSTRING_BLANK,	TEXTSTRING_CONTROLS_RESETTODEFAULT_HELP},
	{AVPMENU_ELEMENT_GOTOMENU, 	TEXTSTRING_MULTIPLAYER_LOADCONFIG,	AVPMENU_MULTIPLAYER_LOADCONFIG,	0,	TEXTSTRING_BLANK,	TEXTSTRING_MULTIPLAYER_LOADCONFIG_HELP},
	{AVPMENU_ELEMENT_GOTOMENU, 	TEXTSTRING_MULTIPLAYER_SAVECONFIG,	AVPMENU_MULTIPLAYER_SAVECONFIG,	0,	TEXTSTRING_BLANK,	TEXTSTRING_MULTIPLAYER_SAVECONFIG_HELP},
	
	{AVPMENU_ELEMENT_GOTOMENU, 	TEXTSTRING_LEVELSELECT_START,	AVPMENU_MULTIPLAYER_SPECIES_HOST,	0,	TEXTSTRING_BLANK,	TEXTSTRING_LEVELSELECT_START_HELP},
	
	//values initialised later
	{AVPMENU_ELEMENT_TEXTSLIDER_POINTER,	TEXTSTRING_MULTIPLAYER_ENVIRONMENT, 0,	&netGameData.levelNumber,	0,	TEXTSTRING_MPHELP_ENVIRONMENT},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_GAMESPEED,	3,								(int*)&netGameData.gameSpeed,		TEXTSTRING_MULTIPLAYER_70PERCENT,	TEXTSTRING_MPHELP_GAMESPEED},

	{AVPMENU_ELEMENT_NUMBERFIELD,	TEXTSTRING_MULTIPLAYER_SCORELIMIT,	1000000,	&netGameData.scoreLimit,	TEXTSTRING_MULTIPLAYER_POINTS,	TEXTSTRING_MPHELP_SCORELIMIT,	TEXTSTRING_MULTIPLAYER_NOSCORELIMIT},
	{AVPMENU_ELEMENT_NUMBERFIELD,	TEXTSTRING_MULTIPLAYER_TIMELIMIT,	255,	&netGameData.timeLimit,			TEXTSTRING_MULTIPLAYER_MINUTES,	TEXTSTRING_MPHELP_TIMELIMIT,	TEXTSTRING_MULTIPLAYER_NOTIMELIMIT},
	{AVPMENU_ELEMENT_NUMBERFIELD,	TEXTSTRING_MULTIPLAYER_INVULNTIME,	255,	&netGameData.invulnerableTime,	TEXTSTRING_MULTIPLAYER_SECONDS,	TEXTSTRING_MPHELP_INVULNTIME,	TEXTSTRING_BLANK},
	
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ALLOW_SMARTGUN,	1,	&netGameData.allowSmartgun,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_ALLOWEAPON},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ALLOW_FLAMER,	1,	&netGameData.allowFlamer,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_ALLOWEAPON},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ALLOW_SADAR,	1,	&netGameData.allowSadar,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_ALLOWEAPON},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ALLOW_GRENADELAUNCHER,	1,	&netGameData.allowGrenadeLauncher,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_ALLOWEAPON},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ALLOW_MINIGUN,	1,	&netGameData.allowMinigun,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_ALLOWEAPON},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ALLOW_SKEETER,	1,	&netGameData.allowSmartDisc,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_ALLOWEAPON},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ALLOW_MARINE_PISTOLS,	1,	&netGameData.allowPistols,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_ALLOWEAPON},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ALLOW_DISC,	1,	&netGameData.allowDisc,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_ALLOWEAPON_PRED},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ALLOW_PISTOL,	1,	&netGameData.allowPistol,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_ALLOWEAPON_PRED},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ALLOW_PLASMACASTER,	1,	&netGameData.allowPlasmaCaster,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_ALLOWEAPON_PRED},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ALLOW_SPEARGUN,	1,	&netGameData.allowSpeargun,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_ALLOWEAPON_PRED},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ALLOW_MEDICOMP,	1,	&netGameData.allowMedicomp,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_ALLOWEAPON_PRED},
	
	{AVPMENU_ELEMENT_NUMBERFIELD,	TEXTSTRING_MULTIPLAYER_BASEKILLVALUE,	255,	&netGameData.baseKillValue,	TEXTSTRING_MULTIPLAYER_POINTS,	TEXTSTRING_MPHELP_BASEKILLVALUE,	TEXTSTRING_BLANK},

	{AVPMENU_ELEMENT_NUMBERFIELD,	TEXTSTRING_MULTIPLAYER_AI_ALIENVALUE,	255,	&netGameData.aiKillValues[0],	TEXTSTRING_MULTIPLAYER_POINTS,	TEXTSTRING_MPHELP_AIVALUE,	TEXTSTRING_BLANK},
	{AVPMENU_ELEMENT_NUMBERFIELD,	TEXTSTRING_MULTIPLAYER_AI_PREDALIENVALUE,	255,	&netGameData.aiKillValues[1],	TEXTSTRING_MULTIPLAYER_POINTS,	TEXTSTRING_MPHELP_AIVALUE,	TEXTSTRING_BLANK},
	{AVPMENU_ELEMENT_NUMBERFIELD,	TEXTSTRING_MULTIPLAYER_AI_PRAETORIANVALUE,	255,	&netGameData.aiKillValues[2],	TEXTSTRING_MULTIPLAYER_POINTS,	TEXTSTRING_MPHELP_AIVALUE,	TEXTSTRING_BLANK},
	
	{AVPMENU_ELEMENT_NUMBERFIELD,	TEXTSTRING_MULTIPLAYER_LIVES,	255,	&netGameData.maxLives,	TEXTSTRING_BLANK,	TEXTSTRING_MPHELP_LIVES,	TEXTSTRING_MULTIPLAYER_INFINITE},

	{AVPMENU_ELEMENT_NUMBERFIELD,	TEXTSTRING_MULTIPLAYER_RESPAWN_POINTS,	1000000,	&netGameData.pointsForRespawn,	TEXTSTRING_MULTIPLAYER_POINTS,	TEXTSTRING_MPHELP_RESPAWN_POINTS,	TEXTSTRING_MULTIPLAYER_RESPAWN_POINTS_NO},
	{AVPMENU_ELEMENT_NUMBERFIELD,	TEXTSTRING_MULTIPLAYER_RESPAWN_TIME,	255,	&netGameData.timeForRespawn,	TEXTSTRING_MULTIPLAYER_SECONDS,	TEXTSTRING_MPHELP_RESPAWN_TIME,	TEXTSTRING_MULTIPLAYER_RESPAWN_TIME_NO},
	
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_PREDESTROYLIGHTS,	1,	&netGameData.preDestroyLights,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_PREDESTROYLIGHTS},

	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_FALLINGDAMAGE,	1,	&netGameData.fallingDamage,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_FALLINGDAMAGE},

	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_PISTOLINFINITEAMMO,	1,	&netGameData.pistolInfiniteAmmo,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_PISTOLINFINITEAMMO},

	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_SPECIALISTPISTOLS,	1,	&netGameData.specialistPistols,	TEXTSTRING_NO,	TEXTSTRING_MPHELP_SPECIALISTPISTOLS},

	{AVPMENU_ELEMENT_ENDOFMENU}
};

static AVPMENU_ELEMENT AvPMenu_Multiplayer_Species_Host[]=
{

	{AVPMENU_ELEMENT_SPECIES_TEXTSLIDER,		TEXTSTRING_MULTIPLAYER_SPECIES,		10,	&MP_Species,		TEXTSTRING_MULTIPLAYER_MARINE,	TEXTSTRING_MULTIPLAYER_SPECIES_HELP},
	{AVPMENU_ELEMENT_STARTMPGAME,		TEXTSTRING_LEVELSELECT_START,		0,	0,	0,	TEXTSTRING_MULTIPLAYER_START2_HELP},
	{AVPMENU_ELEMENT_ENDOFMENU}
};

static AVPMENU_ELEMENT AvPMenu_Multiplayer_Species_Join[]=
{

	{AVPMENU_ELEMENT_SPECIES_TEXTSLIDER,		TEXTSTRING_MULTIPLAYER_SPECIES,		10,	&MP_Species,		TEXTSTRING_MULTIPLAYER_MARINE,	TEXTSTRING_MULTIPLAYER_SPECIES_HELP},
	{AVPMENU_ELEMENT_JOINMPGAME,		TEXTSTRING_LEVELSELECT_START,		0,	0,	0,	TEXTSTRING_MULTIPLAYER_START2_HELP},
	{AVPMENU_ELEMENT_ENDOFMENU}
};

char MP_Config_Name[22];
char MP_Config_Description[202]="";
static AVPMENU_ELEMENT AvPMenu_Multiplayer_SaveConfig[] =
{
	{AVPMENU_ELEMENT_TEXTFIELD, 	TEXTSTRING_FILENAME, 20,	(int*)MP_Config_Name,	0,	TEXTSTRING_CONFIGFILENAME_HELP},
	{AVPMENU_ELEMENT_TEXTFIELD_SMALLWRAPPED, 	TEXTSTRING_DESCRIPTION, 200,	(int*)MP_Config_Description,	0,	TEXTSTRING_CONFIGDESCRIPTION_HELP},
	{AVPMENU_ELEMENT_SAVEMPCONFIG, 		TEXTSTRING_SAVEFILE,	AVPMENU_MULTIPLAYER_CONFIG,	0,	0,	TEXTSTRING_CONFIGSAVEFILE_HELP},
	{AVPMENU_ELEMENT_ENDOFMENU}
};

static AVPMENU_ELEMENT AvPMenu_Multiplayer_DeleteConfig[] =
{
	{AVPMENU_ELEMENT_GOTOMENU, 	TEXTSTRING_NO,	AVPMENU_MULTIPLAYER_CONFIG,	0,	0,	TEXTSTRING_DELETECONFIGURATION_HELP},
	{AVPMENU_ELEMENT_DELETEMPCONFIG,	TEXTSTRING_YES,	0,	0,	0,	TEXTSTRING_DELETECONFIGURATION_HELP},
	{AVPMENU_ELEMENT_ENDOFMENU}
};


static AVPMENU_ELEMENT AvPMenu_Multiplayer_Joining[] =
{
	{AVPMENU_ELEMENT_DUMMYTEXTSLIDER, 	TEXTSTRING_BLANK,	1,	&netGameData.joiningGameStatus,	TEXTSTRING_MULTIPLAYER_WAITSTART,	TEXTSTRING_MULTIPLAYER_WAIT_HELP},
	{AVPMENU_ELEMENT_ENDOFMENU}
};



static AVPMENU_ELEMENT AvPMenu_InGame[] =
{
	{AVPMENU_ELEMENT_RESUMEGAME,TEXTSTRING_INGAMEMENU_RESUMEGAME,			0},
#if SAVE_GAME_ON
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_SAVEGAME,						AVPMENU_SAVEGAME},
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_LOADGAME,						AVPMENU_LOADGAME},
#endif
	{AVPMENU_ELEMENT_RESTARTGAME,TEXTSTRING_INGAMEMENU_RESTARTMISSION,		0},
	{AVPMENU_ELEMENT_GOTOMENU,	TEXTSTRING_MOUSECONTROLS_TITLE,		AVPMENU_CONTROLS},
	{AVPMENU_ELEMENT_GOTOMENU,	TEXTSTRING_JOYSTICKCONTROLS_TITLE,		AVPMENU_JOYSTICKCONTROLS},
	{AVPMENU_ELEMENT_GOTOMENU,	TEXTSTRING_MARINEKEYCONTROLS_TITLE, 		AVPMENU_MARINEKEYCONFIG},
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_AVOPTIONS_TITLE,				AVPMENU_INGAMEAVOPTIONS},
	{AVPMENU_ELEMENT_QUITGAME, TEXTSTRING_INGAMEMENU_QUITTOMAINMENU,			0},
	{AVPMENU_ELEMENT_ENDOFMENU}
};
static AVPMENU_ELEMENT AvPMenu_InNetGame[] =
{
	{AVPMENU_ELEMENT_RESUMEGAME,TEXTSTRING_INGAMEMENU_RESUMEGAME,			0},
	{AVPMENU_ELEMENT_GOTOMENU,	TEXTSTRING_MOUSECONTROLS_TITLE,		AVPMENU_CONTROLS},
	{AVPMENU_ELEMENT_GOTOMENU,	TEXTSTRING_JOYSTICKCONTROLS_TITLE,		AVPMENU_JOYSTICKCONTROLS},
	{AVPMENU_ELEMENT_GOTOMENU,	TEXTSTRING_MARINEKEYCONTROLS_TITLE, 		AVPMENU_MARINEKEYCONFIG},
	{AVPMENU_ELEMENT_GOTOMENU, TEXTSTRING_AVOPTIONS_TITLE,				AVPMENU_INGAMEAVOPTIONS},
	{AVPMENU_ELEMENT_QUITGAME, TEXTSTRING_INGAMEMENU_QUITTOMAINMENU,			0},
	{AVPMENU_ELEMENT_ENDOFMENU}
};


/*
extra +1 for marine auto weapon change option.
Not really necessary , since the marine has fewer options anyway (I think), but
I'll add it to keep things honest.
*/
static AVPMENU_ELEMENT AvPMenu_KeyConfig[NUMBER_OF_PREDATOR_INPUTS+2+1];

static AVPMENU_ELEMENT AvPMenu_Options[] =
{
	{AVPMENU_ELEMENT_GOTOMENU,	TEXTSTRING_MOUSECONTROLS_TITLE,		AVPMENU_CONTROLS,	0,	0,	TEXTSTRING_MOUSECONTROLS_TITLE_HELP},
	{AVPMENU_ELEMENT_GOTOMENU,	TEXTSTRING_JOYSTICKCONTROLS_TITLE,		AVPMENU_JOYSTICKCONTROLS,	0,	0,	TEXTSTRING_JOYSTICKCONTROLS_TITLE_HELP},
	#if !(MARINE_DEMO||ALIEN_DEMO)
	{AVPMENU_ELEMENT_GOTOMENU,	TEXTSTRING_PREDATORKEYCONTROLS_TITLE, 		AVPMENU_PREDATORKEYCONFIG,	0,	0,	TEXTSTRING_PREDATORKEYCONTROLS_TITLE_HELP},
	#endif
	#if !(PREDATOR_DEMO||ALIEN_DEMO)
	{AVPMENU_ELEMENT_GOTOMENU,	TEXTSTRING_MARINEKEYCONTROLS_TITLE, 		AVPMENU_MARINEKEYCONFIG,	0,	0,	TEXTSTRING_MARINEKEYCONTROLS_TITLE_HELP},
	#endif
	#if !(PREDATOR_DEMO||MARINE_DEMO)
	{AVPMENU_ELEMENT_GOTOMENU,	TEXTSTRING_ALIENKEYCONTROLS_TITLE, 		AVPMENU_ALIENKEYCONFIG,	0,	0,	TEXTSTRING_ALIENKEYCONTROLS_TITLE_HELP},
	#endif
	{AVPMENU_ELEMENT_ENDOFMENU}
};

static AVPMENU_ELEMENT AvPMenu_DifficultyLevelSelect[] =
{
	{AVPMENU_ELEMENT_DIFFICULTYLEVEL, TEXTSTRING_DIFFICULTY_EASY,	0,	0,	0,	TEXTSTRING_DIFFICULTY_EASY_HELP},
	{AVPMENU_ELEMENT_DIFFICULTYLEVEL, TEXTSTRING_DIFFICULTY_MEDIUM,	0,	0,	0,	TEXTSTRING_DIFFICULTY_MEDIUM_HELP},
	{AVPMENU_ELEMENT_DIFFICULTYLEVEL, TEXTSTRING_DIFFICULTY_HARD,	0,	0,	0,	TEXTSTRING_DIFFICULTY_HARD_HELP},
	{AVPMENU_ELEMENT_ENDOFMENU}
};
static AVPMENU_ELEMENT AvPMenu_BriefingBonus[] =
{
	{AVPMENU_ELEMENT_DIFFICULTYLEVEL, TEXTSTRING_LEVELSELECT_START},
	{AVPMENU_ELEMENT_ENDOFMENU}
};

static AVPMENU_ELEMENT AvPMenu_CheatOptions[] =
{
	{AVPMENU_ELEMENT_CHEATMODE_TEXTSLIDER,	TEXTSTRING_MAINMENU_CHEATMODE,	MAX_NUMBER_OF_CHEATMODES-1, &CheatMode_Active, TEXTSTRING_CHEATOPTIONS_1, TEXTSTRING_CHEATOPTIONS_CHEATMODE_HELP},
	{AVPMENU_ELEMENT_CHEATMODE_SPECIES_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_SPECIES,		2,	&CheatMode_Species,		TEXTSTRING_MULTIPLAYER_MARINE, TEXTSTRING_CHEATOPTIONS_SPECIES_HELP},
	{AVPMENU_ELEMENT_CHEATMODE_ENVIRONMENT_TEXTSLIDER,	TEXTSTRING_MULTIPLAYER_ENVIRONMENT, (MAX_NO_OF_MARINE_EPISODES+MAX_NO_OF_PREDATOR_EPISODES+MAX_NO_OF_ALIEN_EPISODES-1),	&CheatMode_Environment,	TEXTSTRING_MARINELEVELS_1,	TEXTSTRING_CHEATOPTIONS_ENVIRONMENT_HELP},
	{AVPMENU_ELEMENT_STARTLEVELWITHCHEAT, TEXTSTRING_LEVELSELECT_START,			0},

	
	{AVPMENU_ELEMENT_ENDOFMENU}
};

static AVPMENU_ELEMENT AvPMenu_DetailLevels[] =
{
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_DETAILLEVELS_DECALNUMBER,			3,	&MenuDetailLevelOptions.DecalNumber,			TEXTSTRING_DETAILLEVELS_VERYLOW,	TEXTSTRING_DETAILLEVELS_DECALNUMBER_HELP},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_DETAILLEVELS_LIGHTCORONAS,			1,	&MenuDetailLevelOptions.LightCoronas,			TEXTSTRING_DETAILLEVELS_OFF,		TEXTSTRING_DETAILLEVELS_LIGHTCORONAS_HELP},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_DETAILLEVELS_DECALSONCHARACTERS,		1,	&MenuDetailLevelOptions.DecalsOnCharacters,		TEXTSTRING_DETAILLEVELS_OFF,		TEXTSTRING_DETAILLEVELS_DECALSONCHARACTERS_HELP},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_DETAILLEVELS_DEFORMABLEEXPLOSIONS,	1,	&MenuDetailLevelOptions.DeformableExplosions,	TEXTSTRING_DETAILLEVELS_OFF,		TEXTSTRING_DETAILLEVELS_DEFORMABLEEXPLOSIONS_HELP},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_DETAILLEVELS_CHARACTERCOMPLEXITY,	3,	&MenuDetailLevelOptions.CharacterComplexity,	TEXTSTRING_DETAILLEVELS_VERYLOW,	TEXTSTRING_DETAILLEVELS_CHARACTERCOMPLEXITY_HELP},
	{AVPMENU_ELEMENT_TEXTSLIDER,	TEXTSTRING_DETAILLEVELS_PARTICLECOMPLEXITY,		1,	&MenuDetailLevelOptions.ParticleComplexity,		TEXTSTRING_DETAILLEVELS_OFF,		TEXTSTRING_DETAILLEVELS_PARTICLECOMPLEXITY_HELP},
	{AVPMENU_ELEMENT_SAVESETTINGS,	TEXTSTRING_AVOPTIONS_USETHESESETTINGS,			0,	0,												0, 									TEXTSTRING_AVOPTIONS_USETHESESETTINGS_HELP},
	{AVPMENU_ELEMENT_ENDOFMENU}
};

static AVPMENU_ELEMENT AvPMenu_LoadGame[] =
{
	{AVPMENU_ELEMENT_LOADGAME,	TEXTSTRING_BLANK,	0,	0,	0,	TEXTSTRING_LOADGAME_INSTRUCTIONS},
	{AVPMENU_ELEMENT_LOADGAME,	TEXTSTRING_BLANK,	0,	0,	0,	TEXTSTRING_LOADGAME_INSTRUCTIONS},
	{AVPMENU_ELEMENT_LOADGAME,	TEXTSTRING_BLANK,	0,	0,	0,	TEXTSTRING_LOADGAME_INSTRUCTIONS},
	{AVPMENU_ELEMENT_LOADGAME,	TEXTSTRING_BLANK,	0,	0,	0,	TEXTSTRING_LOADGAME_INSTRUCTIONS},

	{AVPMENU_ELEMENT_LOADGAME,	TEXTSTRING_BLANK,	0,	0,	0,	TEXTSTRING_LOADGAME_INSTRUCTIONS},
	{AVPMENU_ELEMENT_LOADGAME,	TEXTSTRING_BLANK,	0,	0,	0,	TEXTSTRING_LOADGAME_INSTRUCTIONS},
	{AVPMENU_ELEMENT_LOADGAME,	TEXTSTRING_BLANK,	0,	0,	0,	TEXTSTRING_LOADGAME_INSTRUCTIONS},
	{AVPMENU_ELEMENT_LOADGAME,	TEXTSTRING_BLANK,	0,	0,	0,	TEXTSTRING_LOADGAME_INSTRUCTIONS},
	
	{AVPMENU_ELEMENT_ENDOFMENU}
};

static AVPMENU_ELEMENT AvPMenu_SaveGame[] =
{
	{AVPMENU_ELEMENT_SAVEGAME,	TEXTSTRING_BLANK,	0,	0,	0,	TEXTSTRING_SAVEGAME_INSTRUCTIONS},
	{AVPMENU_ELEMENT_SAVEGAME,	TEXTSTRING_BLANK,	0,	0,	0,	TEXTSTRING_SAVEGAME_INSTRUCTIONS},
	{AVPMENU_ELEMENT_SAVEGAME,	TEXTSTRING_BLANK,	0,	0,	0,	TEXTSTRING_SAVEGAME_INSTRUCTIONS},
	{AVPMENU_ELEMENT_SAVEGAME,	TEXTSTRING_BLANK,	0,	0,	0,	TEXTSTRING_SAVEGAME_INSTRUCTIONS},

	{AVPMENU_ELEMENT_SAVEGAME,	TEXTSTRING_BLANK,	0,	0,	0,	TEXTSTRING_SAVEGAME_INSTRUCTIONS},
	{AVPMENU_ELEMENT_SAVEGAME,	TEXTSTRING_BLANK,	0,	0,	0,	TEXTSTRING_SAVEGAME_INSTRUCTIONS},
	{AVPMENU_ELEMENT_SAVEGAME,	TEXTSTRING_BLANK,	0,	0,	0,	TEXTSTRING_SAVEGAME_INSTRUCTIONS},
	{AVPMENU_ELEMENT_SAVEGAME,	TEXTSTRING_BLANK,	0,	0,	0,	TEXTSTRING_SAVEGAME_INSTRUCTIONS},
	
	{AVPMENU_ELEMENT_ENDOFMENU}
};


AVPMENU AvPMenusData[]= 
{
	// AVPMENU_MAIN
	{AVPMENU_FONT_BIG,	TEXTSTRING_MAINMENU_TITLE,				&AvPMenu_MainMenu,					AVPMENU_MAIN,	0},

	// AVPMENU_MAIN_WITHCHEATS
	{AVPMENU_FONT_BIG,	TEXTSTRING_MAINMENU_TITLE,				&AvPMenu_MainMenu_WithCheats,		AVPMENU_MAIN_WITHCHEATS,	0},

	// AVPMENU_DEBUG_MAIN
	{AVPMENU_FONT_BIG,	TEXTSTRING_MAINMENU_TITLE,				&AvPMenu_Debug_MainMenu,					AVPMENU_DEBUG_MAIN,	0},

	// AVPMENU_DEBUG_MAIN_WITHCHEATS
	{AVPMENU_FONT_BIG,	TEXTSTRING_MAINMENU_TITLE,				&AvPMenu_Debug_MainMenu_WithCheats,		AVPMENU_DEBUG_MAIN_WITHCHEATS,	0},

	// AVPMENU_EXITGAME
	{AVPMENU_FONT_BIG,	TEXTSTRING_EXITGAME_TITLE,				&AvPMenu_ExitGame,					AVPMENU_MAIN, 	1},

	// AVPMENU_USERPROFILESELECT
	{AVPMENU_FONT_BIG,	TEXTSTRING_USERPROFILE_SELECT,			&AvPMenu_UserProfileSelect,			AVPMENU_USERPROFILESELECT,	0},

	// AVPMENU_USERPROFILEENTERNAME
	{AVPMENU_FONT_BIG,	TEXTSTRING_USERPROFILE_ENTERNAME,		&AvPMenu_UserProfileEnterName, 		AVPMENU_USERPROFILESELECT,	0},

	// AVPMENU_USERPROFILEDELETE
	{AVPMENU_FONT_BIG,	TEXTSTRING_USERPROFILE_DELETE,			&AvPMenu_UserProfileDelete,			AVPMENU_USERPROFILESELECT, 0},

	// AVPMENU_SINGLEPLAYER
	{AVPMENU_FONT_BIG,	TEXTSTRING_MAINMENU_STARTSINGLEPLAYER,	&AvPMenu_SinglePlayer,				AVPMENU_MAIN,	0},
	
	// AVPMENU_MARINELEVELS
	{AVPMENU_FONT_BIG,	TEXTSTRING_LEVELSELECT_TITLE,			&AvPMenu_MarineLevels,				AVPMENU_SINGLEPLAYER,	0},
	
	// AVPMENU_ALIENLEVELS
	{AVPMENU_FONT_BIG,	TEXTSTRING_LEVELSELECT_TITLE,			&AvPMenu_AlienLevels,				AVPMENU_SINGLEPLAYER,	0},
	
	// AVPMENU_PREDATORLEVELS
	{AVPMENU_FONT_BIG,	TEXTSTRING_LEVELSELECT_TITLE,			&AvPMenu_PredatorLevels,			AVPMENU_SINGLEPLAYER,	0},
	
	// AVPMENU_MULTIPLAYER
	{AVPMENU_FONT_BIG,	TEXTSTRING_MAINMENU_MULTIPLAYER,		&AvPMenu_Multiplayer,				AVPMENU_MULTIPLAYER_CONNECTION,	0},

	// AVPMENU_MULTIPLAYER_LOBBIEDSERVER
	{AVPMENU_FONT_BIG,	TEXTSTRING_MAINMENU_MULTIPLAYER,		&AvPMenu_Multiplayer_LobbiedServer,				AVPMENU_MAIN,	0},

	// AVPMENU_MULTIPLAYER_LOBBIEDCLIENT
	{AVPMENU_FONT_BIG,	TEXTSTRING_MAINMENU_MULTIPLAYER,		&AvPMenu_Multiplayer_LobbiedClient,				AVPMENU_MAIN,	0},
	
	// AVPMENU_MULTIPLAYER_LOBBIEDCLIENT
	{AVPMENU_FONT_BIG,	TEXTSTRING_MAINMENU_SKIRMISH,		&AvPMenu_Multiplayer_Skirmish,				AVPMENU_MAIN,	0},

	// AVPMENU_MULTIPLAYERSTARTGAME_
	{AVPMENU_FONT_BIG,	TEXTSTRING_MULTIPLAYER_STARTGAME,		&AvPMenu_MultiplayerStartGame,		AVPMENU_MULTIPLAYER,	0},

	// AVPMENU_MULTIPLAYERJOINGAME
	{AVPMENU_FONT_BIG,	TEXTSTRING_MULTIPLAYER_JOINGAME,		&AvPMenu_MultiplayerJoinGame,		AVPMENU_MULTIPLAYER,	0},

	//AVPMENU_MULTIPLAYERSELECTSESSION
	{AVPMENU_FONT_BIG,	TEXTSTRING_MULTIPLAYER_SELECTSESSION,	&AvPMenu_MultiplayerSelectSession,	AVPMENU_MULTIPLAYERJOINGAME,	0},

	// AVPMENU_MULTIPLAYERJOINGAME2
	{AVPMENU_FONT_BIG,	TEXTSTRING_MULTIPLAYER_JOINGAME,		&AvPMenu_MultiplayerJoinGame2,		AVPMENU_MULTIPLAYERJOINGAME,	0},

	// AVPMENU_MULTIPLAYEROPENADDRESS
	{AVPMENU_FONT_BIG,	TEXTSTRING_MULTIPLAYER_OPENADDRESS,		&AvPMenu_MultiplayerOpenAddress,	AVPMENU_MULTIPLAYERJOINGAME,	0},

	// AVPMENU_MULTIPLAYER_LOADIPADDRESS
	{AVPMENU_FONT_BIG,	TEXTSTRING_MULTIPLAYER_LOADADDRESS,	0,	AVPMENU_MULTIPLAYEROPENADDRESS,	0},

	// AVPMENU_MULTIPLAYER CONNECTION
	{AVPMENU_FONT_BIG,	TEXTSTRING_MAINMENU_MULTIPLAYER,		&AvPMenu_MultiplayerConnection,				AVPMENU_MAIN,	0},

	// AVPMENU_MULTIPLAYER_CONFIG
	{AVPMENU_FONT_SMALL,TEXTSTRING_MULTIPLAYER_CONFIG,	&AvPMenu_Multiplayer_Config,					AVPMENU_MULTIPLAYER,	0},

	// AVPMENU_MULTIPLAYER_CONFIG_JOIN
	{AVPMENU_FONT_SMALL,TEXTSTRING_MULTIPLAYER_CONFIG,	&AvPMenu_Multiplayer_Config_Join,					AVPMENU_MULTIPLAYER,	0},

	// AVPMENU_SKIRMISH_CONFIG
	{AVPMENU_FONT_SMALL,TEXTSTRING_MAINMENU_SKIRMISH,	&AvPMenu_Skirmish_Config,					AVPMENU_MULTIPLAYER_SKIRMISH,	0},

	// AVPMENU_MULTIPLAYER_SPECIES_HOST
	{AVPMENU_FONT_BIG,TEXTSTRING_MULTIPLAYER_STARTGAME,	&AvPMenu_Multiplayer_Species_Host,					AVPMENU_MULTIPLAYER_CONFIG,	0},
	
	// AVPMENU_MULTIPLAYER_SPECIES_JOIN
	{AVPMENU_FONT_BIG,TEXTSTRING_MULTIPLAYER_JOINGAME,	&AvPMenu_Multiplayer_Species_Join,					AVPMENU_MULTIPLAYER_CONFIG_JOIN,	0},
	
	// AVPMENU_MULTIPLAYER_SAVECONFIG
	{AVPMENU_FONT_BIG,TEXTSTRING_MULTIPLAYER_SAVECONFIG,	&AvPMenu_Multiplayer_SaveConfig,					AVPMENU_MULTIPLAYER_CONFIG,	0},
		
	// AVPMENU_MULTIPLAYER_LOADCONFIG
	{AVPMENU_FONT_BIG,TEXTSTRING_MULTIPLAYER_LOADCONFIG,	0,					AVPMENU_MULTIPLAYER_CONFIG,	0},

	// AVPMENU_MULTIPLAYER_DELETECONFIG
	{AVPMENU_FONT_BIG,TEXTSTRING_DELETECONFIGURATION,	&AvPMenu_Multiplayer_DeleteConfig,					AVPMENU_MULTIPLAYER_LOADCONFIG,	0},

	// AVPMENU_MULTIPLAYER_JOINING
	{AVPMENU_FONT_BIG,TEXTSTRING_MULTIPLAYER_JOININGGAME,	&AvPMenu_Multiplayer_Joining,					AVPMENU_MULTIPLAYER_JOINING,	0},
	
	// AVPMENU_CONTROLS
	{AVPMENU_FONT_SMALL,TEXTSTRING_MOUSECONTROLS_TITLE,			&AvPMenu_ControlsOptions,			AVPMENU_OPTIONS,	0},

	// AVPMENU_JOYSTICKCONTROLS
	{AVPMENU_FONT_SMALL,TEXTSTRING_JOYSTICKCONTROLS_TITLE,	 	&AvPMenu_JoystickControlsOptions,	AVPMENU_OPTIONS,	0},

	// AVPMENU_INGAMEAVOPTIONS
	{AVPMENU_FONT_SMALL,TEXTSTRING_AVOPTIONS_TITLE,	&AvPMenu_InGameAVOptions, AVPMENU_INGAME, 0},

	// AVPMENU_MAINMENUAVOPTIONS
	{AVPMENU_FONT_SMALL,TEXTSTRING_AVOPTIONS_TITLE,	&AvPMenu_MainMenuAVOptions, AVPMENU_MAIN, 0},

	// AVPMENU_VIDEOMODE
	{AVPMENU_FONT_BIG,	TEXTSTRING_VIDEOOPTIONS_TITLE,			&AvPMenu_VideoModeOptions,	 AVPMENU_MAINMENUAVOPTIONS,	0},

	// AVPMENU_INGAME
	{AVPMENU_FONT_SMALL,TEXTSTRING_BLANK,						&AvPMenu_InGame,					AVPMENU_INGAME,	0},
	
	// AVPMENU_INNETGAME
	{AVPMENU_FONT_SMALL,TEXTSTRING_BLANK,						&AvPMenu_InNetGame,					AVPMENU_INNETGAME,	0},
	
	// AVPMENU_MARINEKEYCONFIG
	{AVPMENU_FONT_SMALL,TEXTSTRING_MARINEKEYCONTROLS_TITLE,			&AvPMenu_KeyConfig,			 	AVPMENU_OPTIONS,	0},
	// AVPMENU_PREDATORKEYCONFIG
	{AVPMENU_FONT_SMALL,TEXTSTRING_PREDATORKEYCONTROLS_TITLE,		&AvPMenu_KeyConfig,			 	AVPMENU_OPTIONS,	0},
	// AVPMENU_ALIENKEYCONFIG
	{AVPMENU_FONT_SMALL,TEXTSTRING_ALIENKEYCONTROLS_TITLE,			&AvPMenu_KeyConfig,			 	AVPMENU_OPTIONS,	0},

	// AVPMENU_OPTIONS
	{AVPMENU_FONT_BIG,TEXTSTRING_MAINMENU_GAMEPLAYOPTIONS,	&AvPMenu_Options,					AVPMENU_MAIN,	0},

	// AVPMENU_LEVELBRIEFING_BASIC
	{AVPMENU_FONT_BIG,TEXTSTRING_LEVELBRIEFING_TITLE,	&AvPMenu_DifficultyLevelSelect, AVPMENU_MAIN, 0},

	// AVPMENU_LEVELBRIEFING_BONUS
	{AVPMENU_FONT_BIG,TEXTSTRING_LEVELBRIEFING_TITLE,	&AvPMenu_BriefingBonus, AVPMENU_MAIN, 0},

	// AVPMENU_CHEATOPTIONS
	{AVPMENU_FONT_BIG,TEXTSTRING_MAINMENU_CHEATOPTIONS, &AvPMenu_CheatOptions, AVPMENU_MAIN, 0},

	// AVPMENU_DETAILLEVELS
	{AVPMENU_FONT_SMALL,TEXTSTRING_DETAILLEVELS_TITLE,	&AvPMenu_DetailLevels, AVPMENU_MAINMENUAVOPTIONS, 0},

	// AVPMENU_LOADGAME
	{AVPMENU_FONT_SMALL,TEXTSTRING_LOADGAME,	&AvPMenu_LoadGame, AVPMENU_MAIN, 0},

	// AVPMENU_SAVEGAME
	{AVPMENU_FONT_SMALL,TEXTSTRING_SAVEGAME,	&AvPMenu_SaveGame, AVPMENU_MAIN, 0},

};

extern void MakeSelectSessionMenu(void)
{
	int i;

	if (NumberOfSessionsFound)
	{
		for (i=0; i<NumberOfSessionsFound; i++)
		{
			AvPMenu_MultiplayerSelectSession[i].ElementID = AVPMENU_ELEMENT_LISTCHOICE;
			AvPMenu_MultiplayerSelectSession[i].TextPtr = SessionData[i].Name;
			AvPMenu_MultiplayerSelectSession[i].MenuToGoTo = AVPMENU_MULTIPLAYER_JOINING;
			AvPMenu_MultiplayerSelectSession[i].HelpString = TEXTSTRING_MULTIPLAYER_SELECTSESSION_HELP;
		}
	}
	else
	{
		AvPMenu_MultiplayerSelectSession[0].ElementID = AVPMENU_ELEMENT_GOTOMENU;
		AvPMenu_MultiplayerSelectSession[0].TextDescription = TEXTSTRING_MULTIPLAYER_NOSESSIONSFOUND;
		AvPMenu_MultiplayerSelectSession[0].MenuToGoTo = AVPMENU_MULTIPLAYERJOINGAME;
		AvPMenu_MultiplayerSelectSession[0].HelpString = TEXTSTRING_MULTIPLAYER_NOSESSIONSFOUND_HELP;

		if(netGameData.connectionType!=CONN_TCPIP)
		{
			AvPMenu_MultiplayerSelectSession[0].MenuToGoTo = AVPMENU_MULTIPLAYER;
		}
			
		i=1;
	}
	AvPMenu_MultiplayerSelectSession[i].ElementID = AVPMENU_ELEMENT_ENDOFMENU;

	/*
	Need to choose the correct parent menu.
	For tcpip go back to chance to choose ip address.
	Otherwise skip back to host/join menu
	*/
	if(netGameData.connectionType==CONN_TCPIP)
	{
		AvPMenusData[AVPMENU_MULTIPLAYERSELECTSESSION].ParentMenu=AVPMENU_MULTIPLAYERJOINGAME;
	}
	else
	{
		AvPMenusData[AVPMENU_MULTIPLAYERSELECTSESSION].ParentMenu=AVPMENU_MULTIPLAYER;
	}
}


extern void MakeInGameMenu(void)
{
	/* KJL 14:51:28 06/11/98 - set the only available key config to be that of the player's
	cyrrent character */
	/*Adjust both variants of the menu -Richard*/
	switch (AvP.PlayerType)
	{
		case I_Marine:
		{
			AvPMenu_InGame[6].TextDescription = TEXTSTRING_MARINEKEYCONTROLS_TITLE;
			AvPMenu_InGame[6].MenuToGoTo = AVPMENU_MARINEKEYCONFIG;
			
			AvPMenu_InNetGame[3].TextDescription = TEXTSTRING_MARINEKEYCONTROLS_TITLE;
			AvPMenu_InNetGame[3].MenuToGoTo = AVPMENU_MARINEKEYCONFIG;
			break;
		}
		case I_Predator:
		{
			AvPMenu_InGame[6].TextDescription = TEXTSTRING_PREDATORKEYCONTROLS_TITLE;
			AvPMenu_InGame[6].MenuToGoTo = AVPMENU_PREDATORKEYCONFIG;
			
			AvPMenu_InNetGame[3].TextDescription = TEXTSTRING_PREDATORKEYCONTROLS_TITLE;
			AvPMenu_InNetGame[3].MenuToGoTo = AVPMENU_PREDATORKEYCONFIG;
			break;
		}
		case I_Alien:
		{
			AvPMenu_InGame[6].TextDescription = TEXTSTRING_ALIENKEYCONTROLS_TITLE;
			AvPMenu_InGame[6].MenuToGoTo = AVPMENU_ALIENKEYCONFIG;
			
			AvPMenu_InNetGame[3].TextDescription = TEXTSTRING_ALIENKEYCONTROLS_TITLE;
			AvPMenu_InNetGame[3].MenuToGoTo = AVPMENU_ALIENKEYCONFIG;
			break;
		}
	}
}

extern void MakePredatorKeyConfigMenu(void)
{
	int i=0;
	int j;
	
	AvPMenu_KeyConfig[i].ElementID = AVPMENU_ELEMENT_KEYCONFIGOK;
	AvPMenu_KeyConfig[i].TextDescription = TEXTSTRING_MOUSECONTROLS_SAVETHESESETTINGS;
	AvPMenu_KeyConfig[i].MenuToGoTo = AVPMENU_INGAME;
	AvPMenu_KeyConfig[i].HelpString = TEXTSTRING_MOUSECONTROLS_SAVETHESESETTINGS_HELP;
	i++;
	AvPMenu_KeyConfig[i].ElementID = AVPMENU_ELEMENT_RESETKEYCONFIG;
	AvPMenu_KeyConfig[i].TextDescription = TEXTSTRING_CONTROLS_RESETTODEFAULT;
	AvPMenu_KeyConfig[i].HelpString = TEXTSTRING_CONTROLS_RESETTODEFAULT_HELP;
	i++;
	#if 1
	for(j=0; j<NUMBER_OF_PREDATOR_INPUTS; j++)
	{
		AvPMenu_KeyConfig[i+j].ElementID = AVPMENU_ELEMENT_KEYCONFIG;
		AvPMenu_KeyConfig[i+j].TextDescription = TEXTSTRING_PREDATOR_KEY_FORWARD+j;
		AvPMenu_KeyConfig[i+j].MenuToGoTo = AVPMENU_MAIN;
		AvPMenu_KeyConfig[i+j].HelpString = TEXTSTRING_KEYCONTROLS_HELP;

	}
	#else
	AvPMenu_KeyConfig[i].ElementID = AVPMENU_ELEMENT_BUTTONSETTING;
	AvPMenu_KeyConfig[i].TextDescription = TEXTSTRING_PREDATOR_KEY_FORWARD;
	AvPMenu_KeyConfig[i].MaxSliderValue = NUMBER_OF_PREDATOR_INPUTS-1;
	i++;
	#endif
	AvPMenu_KeyConfig[i+j].ElementID = AVPMENU_ELEMENT_ENDOFMENU;
}

extern int AutoWeaponChangeOn;
int AutoWeaponChangeOn_Temp;
extern void MakeMarineKeyConfigMenu(void)
{
	int i=0;
	int j;
	
	AvPMenu_KeyConfig[i].ElementID = AVPMENU_ELEMENT_KEYCONFIGOK;
	AvPMenu_KeyConfig[i].TextDescription = TEXTSTRING_MOUSECONTROLS_SAVETHESESETTINGS;
	AvPMenu_KeyConfig[i].MenuToGoTo = AVPMENU_INGAME;
	AvPMenu_KeyConfig[i].HelpString = TEXTSTRING_MOUSECONTROLS_SAVETHESESETTINGS_HELP;
	i++;
	AvPMenu_KeyConfig[i].ElementID = AVPMENU_ELEMENT_RESETKEYCONFIG;
	AvPMenu_KeyConfig[i].TextDescription = TEXTSTRING_CONTROLS_RESETTODEFAULT;
	AvPMenu_KeyConfig[i].HelpString = TEXTSTRING_CONTROLS_RESETTODEFAULT_HELP;
	i++;
	#if 1
	for(j=0; j<NUMBER_OF_MARINE_INPUTS; j++)
	{
		AvPMenu_KeyConfig[i+j].ElementID = AVPMENU_ELEMENT_KEYCONFIG;
		AvPMenu_KeyConfig[i+j].TextDescription = TEXTSTRING_MARINE_KEY_FORWARD+j;
		AvPMenu_KeyConfig[i+j].MenuToGoTo = AVPMENU_MAIN;
		AvPMenu_KeyConfig[i+j].HelpString = TEXTSTRING_KEYCONTROLS_HELP;
	}
	#else
	AvPMenu_KeyConfig[i].ElementID = AVPMENU_ELEMENT_BUTTONSETTING;
	AvPMenu_KeyConfig[i].TextDescription = TEXTSTRING_MARINE_KEY_FORWARD;
	AvPMenu_KeyConfig[i].MaxSliderValue = NUMBER_OF_MARINE_INPUTS-1;
	i++;
	#endif

	//store the value of AutoWeaponChange in a seperate variable , so we can restore the value
	//if the user decides to cancel
	AutoWeaponChangeOn_Temp = AutoWeaponChangeOn;
	//add autoweapon change option , for lack of anywhere better to put it
	AvPMenu_KeyConfig[i+j].ElementID = AVPMENU_ELEMENT_TEXTSLIDER;
	AvPMenu_KeyConfig[i+j].TextDescription = TEXTSTRING_AUTOWEAPONCHANGE;	
	AvPMenu_KeyConfig[i+j].MaxSliderValue = 1;	
	AvPMenu_KeyConfig[i+j].SliderValuePtr = &AutoWeaponChangeOn_Temp;	
	AvPMenu_KeyConfig[i+j].FirstTextSliderString = TEXTSTRING_NO;	
	AvPMenu_KeyConfig[i+j].HelpString = TEXTSTRING_AUTOWEAPONCHANGE_HELP;	

	AvPMenu_KeyConfig[i+j+1].ElementID = AVPMENU_ELEMENT_ENDOFMENU;
}
extern void MakeAlienKeyConfigMenu(void)
{
	int i=0;
	int j;
	
	AvPMenu_KeyConfig[i].ElementID = AVPMENU_ELEMENT_KEYCONFIGOK;
	AvPMenu_KeyConfig[i].TextDescription = TEXTSTRING_MOUSECONTROLS_SAVETHESESETTINGS;
	AvPMenu_KeyConfig[i].MenuToGoTo = AVPMENU_INGAME;
	AvPMenu_KeyConfig[i].HelpString = TEXTSTRING_MOUSECONTROLS_SAVETHESESETTINGS_HELP;
	i++;
	AvPMenu_KeyConfig[i].ElementID = AVPMENU_ELEMENT_RESETKEYCONFIG;
	AvPMenu_KeyConfig[i].TextDescription = TEXTSTRING_CONTROLS_RESETTODEFAULT;
	AvPMenu_KeyConfig[i].HelpString = TEXTSTRING_CONTROLS_RESETTODEFAULT_HELP;
	i++;
	#if 1
	for(j=0; j<NUMBER_OF_ALIEN_INPUTS; j++)
	{
		AvPMenu_KeyConfig[i+j].ElementID = AVPMENU_ELEMENT_KEYCONFIG;
		AvPMenu_KeyConfig[i+j].TextDescription = TEXTSTRING_ALIEN_KEY_FORWARD+j;
		AvPMenu_KeyConfig[i+j].MenuToGoTo = AVPMENU_MAIN;
		AvPMenu_KeyConfig[i+j].HelpString = TEXTSTRING_KEYCONTROLS_HELP;
	}
	#else
	AvPMenu_KeyConfig[i].ElementID = AVPMENU_ELEMENT_BUTTONSETTING;
	AvPMenu_KeyConfig[i].TextDescription = TEXTSTRING_ALIEN_KEY_FORWARD;
	AvPMenu_KeyConfig[i].MaxSliderValue = NUMBER_OF_ALIEN_INPUTS-1;
	i++;
	#endif
	AvPMenu_KeyConfig[i+j].ElementID = AVPMENU_ELEMENT_ENDOFMENU;
}

extern void MakeUserProfileSelectMenu(void)
{
	int n = NumberOfUserProfiles();
	AvPMenu_UserProfileSelect[0].MaxSliderValue = n;
	
	if (n>0) UserProfileNumber=1;
	else UserProfileNumber=0;
}

extern void MakeConnectionSelectMenu()
{
	int pos=0;

	if(netGameData.tcpip_available)
	{
		AvPMenu_MultiplayerConnection[pos].ElementID = AVPMENU_ELEMENT_CONNECTIONCHOICE;
		AvPMenu_MultiplayerConnection[pos].TextDescription = TEXTSTRING_MULTIPLAYER_TCPIP;
		AvPMenu_MultiplayerConnection[pos].MenuToGoTo = AVPMENU_MULTIPLAYER;
		AvPMenu_MultiplayerConnection[pos].Value = CONN_TCPIP;
		AvPMenu_MultiplayerConnection[pos].HelpString = TEXTSTRING_MULTIPLAYER_PROTOCOL_HELP;
		pos++;
	}
	if(netGameData.ipx_available)
	{
		AvPMenu_MultiplayerConnection[pos].ElementID = AVPMENU_ELEMENT_CONNECTIONCHOICE;
		AvPMenu_MultiplayerConnection[pos].TextDescription = TEXTSTRING_MULTIPLAYER_IPX;
		AvPMenu_MultiplayerConnection[pos].MenuToGoTo = AVPMENU_MULTIPLAYER;
		AvPMenu_MultiplayerConnection[pos].Value = CONN_IPX;
		AvPMenu_MultiplayerConnection[pos].HelpString = TEXTSTRING_MULTIPLAYER_PROTOCOL_HELP;
		pos++;
	}
	if(netGameData.modem_available)
	{
		AvPMenu_MultiplayerConnection[pos].ElementID = AVPMENU_ELEMENT_CONNECTIONCHOICE;
		AvPMenu_MultiplayerConnection[pos].TextDescription = TEXTSTRING_MULTIPLAYER_MODEM;
		AvPMenu_MultiplayerConnection[pos].MenuToGoTo = AVPMENU_MULTIPLAYER;
		AvPMenu_MultiplayerConnection[pos].Value = CONN_Modem;
		AvPMenu_MultiplayerConnection[pos].HelpString = TEXTSTRING_MULTIPLAYER_PROTOCOL_HELP;
		pos++;
	}
	if(netGameData.serial_available)
	{
		AvPMenu_MultiplayerConnection[pos].ElementID = AVPMENU_ELEMENT_CONNECTIONCHOICE;
		AvPMenu_MultiplayerConnection[pos].TextDescription = TEXTSTRING_MULTIPLAYER_SERIAL;
		AvPMenu_MultiplayerConnection[pos].MenuToGoTo = AVPMENU_MULTIPLAYER;
		AvPMenu_MultiplayerConnection[pos].Value = CONN_Serial;
		AvPMenu_MultiplayerConnection[pos].HelpString = TEXTSTRING_MULTIPLAYER_PROTOCOL_HELP;
		pos++;
	}
	#if MPLAYER_SUPPORT
	//if(!LobbiedGame)
    //Add an option for launching a game using mplayer
    {
		AvPMenu_MultiplayerConnection[pos].ElementID =	AVPMENU_ELEMENT_CONNECTIONCHOICE;
		AvPMenu_MultiplayerConnection[pos].TextDescription = TEXTSTRING_MPLAYER_TEXT_1;
		AvPMenu_MultiplayerConnection[pos].MenuToGoTo = AVPMENU_MULTIPLAYER;
		AvPMenu_MultiplayerConnection[pos].Value = CONN_Mplayer;
		 pos++;           
    }
	#endif

	
	
	if(pos==0)
	{
		//no available connections
		AvPMenu_MultiplayerConnection[0].ElementID = AVPMENU_ELEMENT_GOTOMENU;
		AvPMenu_MultiplayerConnection[0].TextDescription = TEXTSTRING_MULTIPLAYER_NOCONNECTIONS;
		AvPMenu_MultiplayerConnection[0].MenuToGoTo = AVPMENU_MAIN;
		AvPMenu_MultiplayerConnection[pos].HelpString = TEXTSTRING_MULTIPLAYER_NOCONNECTIONS_HELP;

		pos=1;			
	}
	AvPMenu_MultiplayerConnection[pos].ElementID = AVPMENU_ELEMENT_ENDOFMENU;
}

extern void MakeOpenIPAddressMenu()
{
	IP_Address_Name[0]=0;
	//determine whether the load ip address option should be available
	if(BuildLoadIPAddressMenu())	
	{
		AvPMenu_MultiplayerOpenAddress[3].ElementID=AVPMENU_ELEMENT_GOTOMENU;
	}
	else
	{
		AvPMenu_MultiplayerOpenAddress[3].ElementID=AVPMENU_ELEMENT_ENDOFMENU;
	}

}



