/*
	
	rentrntq.h

	Created 21/11/97 by DHM:

	"Support for a queue of messages (generated by/analagous to Windows messages)
	to avoid problems with re-entrancy".
	
	The problem being solved is that (in theory at least) the application's
	WinProc() procedure can be called at any point within any function in the Win32 API.

	This means that any code that the application's WinProc procedure
	calls (both directly or indirectly) must, in general, be re-entrant

	For example, textprint(), the memory allocators, etc. can't be guaranteed to work if
	called from WinProc() or something called by it.  This is a mahor restriction on what
	you can call from WinProc.

	The idea of this code is to isolate the re-entrancy by buffering the
	messages, which can then be flushed somewhere "safe" within the main loop
	that doesn't need to be re-entrant.

	Functions within this header are labelled with either (i)"WinProc" or (ii)"WinMain"
	in their names to indicate whether (i)they should be called from the windows procedure
	or (ii) from within the WinMain function (or anything it calls i.e. the entire program
	and main loop _except_ for the windows procedure)
*/

#ifndef _rentrntq
#define _rentrntq 1

#ifdef __cplusplus
	extern "C" {
#endif

/* Version settings *****************************************************/

/* Constants  ***********************************************************/

/* Macros ***************************************************************/

/* Type definitions *****************************************************/

/* Exported globals *****************************************************/

/* Function prototypes **************************************************/
	/* Functions callable within the Windows procedure */
	extern void RE_ENTRANT_QUEUE_WinProc_AddMessage_WM_CHAR
	(
		char Ch
	);

	extern void RE_ENTRANT_QUEUE_WinProc_AddMessage_WM_KEYDOWN
	(
		WPARAM wParam
	);

	/* Functions callable from the WinMain() body of code */
	extern void RE_ENTRANT_QUEUE_WinMain_FlushMessages(void);
	extern void RE_ENTRANT_QUEUE_WinMain_FlushMessagesWithoutProcessing(void);


/* End of the header ****************************************************/


#ifdef __cplusplus
	};
#endif

#endif
