/*
 * Copyright (C) Volition, Inc. 1999.  All rights reserved.
 *
 * All source code herein is the property of Volition, Inc. You may not sell 
 * or otherwise commercially exploit the source or things you created based on the 
 * source.
 *
*/ 

/*
 * $Logfile: /Freespace2/code/Graphics/Scaler.h $
 * $Revision: 2 $
 * $Date: 10/07/98 10:53a $
 * $Author: Dave $
 *
 * Header file for bitmap scaler.
 *
 * $Log: /Freespace2/code/Graphics/Scaler.h $
 * 
 * 2     10/07/98 10:53a Dave
 * Initial checkin.
 * 
 * 1     10/07/98 10:49a Dave
 * 
 * 9     3/10/98 4:19p John
 * Cleaned up graphics lib.  Took out most unused gr functions.   Made D3D
 * & Glide have popups and print screen.  Took out all >8bpp software
 * support.  Made Fred zbuffer.  Made zbuffer allocate dynamically to
 * support Fred.  Made zbuffering key off of functions rather than one
 * global variable.
 * 
 * 8     11/30/97 12:18p John
 * added more 24 & 32-bpp primitives
 * 
 * 7     10/15/97 4:48p John
 * added 16-bpp aascaler
 * 
 * 6     8/04/97 4:47p John
 * added gr_aascaler.
 * 
 * 5     11/07/96 6:19p John
 * Added a bunch of 16bpp primitives so the game sort of runs in 16bpp
 * mode.
 * 
 * 4     10/26/96 1:40p John
 * Added some now primitives to the 2d library and
 * cleaned up some old ones.
 *
 * $NoKeywords: $
 */


#ifndef _SCALER_H
#define _SCALER_H

#include "pstypes.h"


// Scales current bitmap between va and vb
void gr8_scaler(vertex *va, vertex *vb );
void gr8_aascaler(vertex *va, vertex *vb );

#endif

