/**
  ******************************************************************************
  * @file    LwIP/LwIP_TCP_Echo_Server/Inc/main.h 
  * @author  MCD Application Team
  * @brief   Header for main.c module
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2016 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __MAIN_H
#define __MAIN_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include "stm32f1xx_hal.h"
#include "stm3210c_eval.h"
#include "stm3210c_eval_lcd.h"
#include "stm3210c_eval_io.h"

/* Exported types ------------------------------------------------------------*/
/* Exported constants --------------------------------------------------------*/
#define USE_LCD        /* enable LCD  */
#define USE_DHCP       /* enable DHCP, if disabled static address is used */

#define DEST_IP_ADDR0   ((uint8_t)192)
#define DEST_IP_ADDR1   ((uint8_t)168)
#define DEST_IP_ADDR2   ((uint8_t)0)
#define DEST_IP_ADDR3   ((uint8_t)1)

#define DEST_PORT       ((uint16_t)7)
 
/*Static IP ADDRESS: IP_ADDR0.IP_ADDR1.IP_ADDR2.IP_ADDR3 */
#define IP_ADDR0   ((uint8_t)192)
#define IP_ADDR1   ((uint8_t)168)
#define IP_ADDR2   ((uint8_t)0)
#define IP_ADDR3   ((uint8_t)10)

/*NETMASK*/
#define NETMASK_ADDR0   ((uint8_t)255)
#define NETMASK_ADDR1   ((uint8_t)255)
#define NETMASK_ADDR2   ((uint8_t)255)
#define NETMASK_ADDR3   ((uint8_t)0)

/*Gateway Address*/
#define GW_ADDR0   ((uint8_t)192)
#define GW_ADDR1   ((uint8_t)168)
#define GW_ADDR2   ((uint8_t)0)
#define GW_ADDR3   ((uint8_t)1)

/* Exported macro ------------------------------------------------------------*/
/* Exported functions ------------------------------------------------------- */

#ifdef __cplusplus
}
#endif

#endif /* __MAIN_H */


/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
