/**
  ******************************************************************************
  * @file    DMA2D/DMA2D_MemToMemWithPFC/Inc/RGB565_300x120.h 
  * @author  MCD Application Team
  * @brief   This file contains image used for DMA2D Validation.   
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; COPYRIGHT(c) 2017 STMicroelectronics</center></h2>
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *   3. Neither the name of STMicroelectronics nor the names of its contributors
  *      may be used to endorse or promote products derived from this software
  *      without specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
  * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
  * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  *
  ******************************************************************************
  */ 

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __RGB565_300x120_H
#define __RGB565_300x120_H

__ALIGN_BEGIN const uint16_t RGB565_300x120[36000] __ALIGN_END =
{
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x83FF, 
        0x83FF, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x83FF, 
        0x83FF, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x83FF, 
        0x83FF, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x83FF, 
        0x83FF, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x83FF, 
        0x83FF, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x83FF, 
        0x83FF, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBDFF, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x83FF, 
        0x83FF, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x83FF, 
        0x83FF, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x83FF, 
        0x83FF, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x83FF, 
        0x83FF, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x83FF, 
        0x83FF, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x83FF, 
        0x83FF, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xC61F, 0xC61F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xC61F, 0xC61F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xC61F, 0xC61F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xC61F, 0xC61F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xC61F, 0xC61F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CFF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CDF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CDF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA51F, 0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CDF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA4FF, 0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CDF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA4FF, 0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CDF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA4FF, 0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CDF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA4FF, 0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
  0x001F, 0x001F, 0x001F, 0x001F, 0x001F, 0x003F, 0x003F, 0x003F, 0x083F, 0x083F, 0x083F, 0x083F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x085F, 0x087F, 0x087F, 0x087F, 0x087F, 0x107F, 0x107F, 0x109F, 0x109F, 0x109F, 0x109F, 
        0x109F, 0x109F, 0x109F, 0x10BF, 0x10BF, 0x10BF, 0x18BF, 0x18BF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18DF, 0x18FF, 0x18FF, 0x18FF, 0x18FF, 0x20FF, 0x20FF, 0x20FF, 0x211F, 0x211F, 0x211F, 0x211F, 0x211F, 0x293F, 0x293F, 0x293F, 0x293F, 0x295F, 
        0x295F, 0x295F, 0x295F, 0x295F, 0x317F, 0x317F, 0x317F, 0x317F, 0x319F, 0x319F, 0x319F, 0x319F, 0x319F, 0x31BF, 0x39BF, 0x39BF, 0x39BF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39DF, 0x39FF, 0x41FF, 0x41FF, 0x41FF, 0x421F, 0x421F, 0x421F, 
        0x423F, 0x423F, 0x423F, 0x423F, 0x4A3F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A5F, 0x4A7F, 0x4A7F, 0x4A7F, 0x4A7F, 0x529F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x52BF, 0x5ABF, 0x5ABF, 0x5ADF, 0x5ADF, 0x5ADF, 0x62FF, 0x62FF, 0x62FF, 0x631F, 
        0x631F, 0x631F, 0x631F, 0x633F, 0x6B3F, 0x6B3F, 0x6B3F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B5F, 0x6B7F, 0x6B7F, 0x737F, 0x737F, 0x739F, 0x739F, 0x739F, 0x73BF, 0x73BF, 0x73BF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BDF, 0x7BFF, 0x7BFF, 0x7BFF, 0x83FF, 0x841F, 
        0x841F, 0x841F, 0x841F, 0x841F, 0x843F, 0x843F, 0x845F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C5F, 0x8C7F, 0x8C7F, 0x8C7F, 0x949F, 0x949F, 0x949F, 0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x94DF, 0x94DF, 0x9CDF, 0x9CDF, 0x9CDF, 0x9CDF, 0x9CFF, 0x9CFF, 0x9CFF, 
        0xA4FF, 0xA51F, 0xA51F, 0xA51F, 0xA53F, 0xA53F, 0xA53F, 0xA55F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD5F, 0xAD7F, 0xAD7F, 0xB57F, 0xB59F, 0xB59F, 0xB59F, 0xB59F, 0xB5BF, 0xB5BF, 0xB5BF, 0xB5DF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDDF, 0xBDFF, 
        0xBDFF, 0xBDFF, 0xBDFF, 0xBE1F, 0xBE1F, 0xC61F, 0xC61F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC63F, 0xC65F, 0xCE5F, 0xCE5F, 0xCE5F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE7F, 0xCE9F, 0xD69F, 0xD69F, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xD6BF, 0xDEDF, 
        0xDEDF, 0xDEDF, 0xDEDF, 0xDEDF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDEFF, 0xDF1F, 0xE71F, 0xE71F, 0xE71F, 0xE71F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xE73F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF5F, 0xEF7F, 0xEF7F, 0xEF7F, 0xEF7F, 
        0xEF7F, 0xEF7F, 0xEF7F, 0xEF9F, 0xEF9F, 0xF79F, 0xF79F, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7BF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF
};

#endif /* __RGB565_300X120_H */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
