/**
  ******************************************************************************
  * @file    LTDC/LTDC_Display_2Layers/Inc/RGB565_320x240.h 
  * @author  MCD Application Team
  * @brief   This file contains image used for LTDC Validation.   
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; COPYRIGHT(c) 2017 STMicroelectronics</center></h2>
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *   3. Neither the name of STMicroelectronics nor the names of its contributors
  *      may be used to endorse or promote products derived from this software
  *      without specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
  * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
  * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  *
  ******************************************************************************
  */ 

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __RGB565_320X240_H
#define __RGB565_320X240_H

const uint16_t RGB565_320x240[76800] =
{
  0x7A33, 0x7A32, 0x7A32, 0x7232, 0x8A32, 0x8A33, 0x8A33, 0x8253, 0x8A32, 0x8232, 0x8232, 0x8232, 0x8252, 0x8252, 0x8253, 0x8253, 0x8A53, 0x8A53, 0x8A53, 0x8A53, 0x8273, 0x8A53, 0x8A53, 0x8A53, 0x8A73, 0x8A73, 0x8A73, 0x8A54, 0x8A54, 0x8A73, 0x8A73, 
        0x8A73, 0x8A73, 0x8A73, 0x8A93, 0x8A93, 0x8A73, 0x8A73, 0x8A93, 0x8A93, 0x8A94, 0x8A73, 0x8A73, 0x9293, 0x8A74, 0x9B37, 0x92F6, 0x6190, 0x20C7, 0xA515, 0xF7BE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 
        0xFFFE, 0xFFFE, 0xFFBD, 0xE5B2, 0x93EA, 0x5B06, 0x5B88, 0xD615, 0x6AEA, 0x62EB, 0xE6DA, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFBB, 0xFF78, 0xFF56, 0xF6D5, 0xF693, 0xF6F6, 0xFFDB, 0xFF58, 0xF717, 0xF6D6, 0xEE74, 0xE6B3, 0xEEB3, 0xEE93, 
        0xE652, 0xDDF2, 0xD5D0, 0xD62F, 0xE6B1, 0xF6F3, 0xDE50, 0xDE90, 0xE6D2, 0x62A3, 0x8325, 0xAC8A, 0xC58F, 0xCD4F, 0xEED5, 0xEF16, 0xDE34, 0xFFBE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xEF17, 0xDE71, 0xCE6E, 0xCE6E, 
        0x9D06, 0x94A4, 0xAD48, 0xC5EA, 0xE6EE, 0xCE6C, 0x9CA7, 0xDD38, 0xE5D6, 0xEEB6, 0xF79B, 0xE698, 0xF75C, 0xFFDE, 0xEF7C, 0x8369, 0x3142, 0x10A1, 0x2121, 0x18A0, 0x20E1, 0x18E1, 0x08A0, 0x18C2, 0x2082, 0x1841, 0x0840, 0x3164, 0x6B09, 0x838A, 
        0x8307, 0xC52E, 0x93A9, 0x8327, 0x9BCA, 0x7AE9, 0xB4D0, 0xE5F5, 0xF5F6, 0xFE77, 0xF657, 0xEDF7, 0xE5B6, 0xEEB6, 0xF799, 0xFFFB, 0xFFFB, 0xFFFC, 0xFFDC, 0xFFDC, 0xFFFD, 0xFFBC, 0xFFD9, 0xFFB7, 0xF795, 0xFF15, 0xFF36, 0xFF56, 0xFF97, 0xFFFC, 
        0xFFFC, 0xFFFB, 0xFF99, 0xEE51, 0xE611, 0xEE53, 0xFEF7, 0xFF76, 0xFFB9, 0xFFDB, 0xFFFB, 0xFFFC, 0xFFFC, 0xFFFC, 0xFFDB, 0xFFFC, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFE, 0xFFFE, 0xFFDF, 0xFFFB, 0xFFDB, 0xFFDD, 0xF7BD, 0xBDEE, 0xA4A9, 0x9C69, 
        0x9CAB, 0x9C4A, 0xBCEC, 0xCD0E, 0xD4CE, 0xE44F, 0xD40E, 0xCBCD, 0xD3AE, 0xDBCE, 0xE3EE, 0xE42F, 0xE471, 0xD3CE, 0xDBAE, 0xDBEE, 0xE42F, 0xE3CF, 0xE40F, 0xEC50, 0xEC72, 0xF492, 0xF4B2, 0xF4B2, 0xF492, 0xF4B4, 0xECB2, 0xF4B2, 0xF4D4, 0xED14, 
        0xF555, 0xFD76, 0xFD57, 0xDD17, 0xCCB7, 0xBC79, 0xBC1C, 0xB41C, 0xBC3D, 0xC43D, 0xBBFD, 0xC41D, 0xC3FD, 0xC3FD, 0xC3DD, 0xC41B, 0xBC3B, 0xBBFB, 0xB3BA,
  0x7A12, 0x7A32, 0x7A32, 0x8252, 0x7A52, 0x7232, 0x7232, 0x7A52, 0x7232, 0x7A32, 0x7A32, 0x7A32, 0x7A53, 0x7A33, 0x7A32, 0x8232, 0x8232, 0x8232, 0x8253, 0x8253, 0x8253, 0x8A53, 0x8253, 0x7A33, 0x8252, 0x8A32, 0x8232, 0x8232, 0x8A52, 0x8232, 0x8233, 
        0x8273, 0x8273, 0x8253, 0x8A73, 0x8273, 0x8A53, 0x8A53, 0x8A73, 0x8A73, 0x8273, 0x8A73, 0x8A73, 0x8A73, 0x92F6, 0x61B1, 0x616F, 0x8AF4, 0xEF3E, 0xFFDF, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFBE, 0xFFBD, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFDE, 0xFFFE, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFFE, 
        0xFFFE, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFE, 
        0xFFBC, 0xFFBB, 0xF7BB, 0xEF7C, 0x7BAB, 0x2901, 0x20C3, 0xDD54, 0xC3EE, 0xC490, 0xF79D, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFDD, 0xEEB6, 0xE5F1, 0xEDD1, 0xDD8F, 0xBD0C, 0xB4AC, 0xCD2F, 0xF799, 0xFF79, 0xEED5, 0xCE11, 0xDDCF, 0xD5B0, 0xD5B1, 
        0xDDB2, 0xD56D, 0xBD2C, 0xCDF0, 0xEF56, 0xAD0A, 0xB4EA, 0xACCA, 0x9C47, 0x9427, 0x8386, 0x7324, 0x7B85, 0xEEF5, 0xEE73, 0xEE95, 0xFFDD, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xEF7D, 0x9BF1, 0xC572, 0xD692, 0xC62D, 0xA4E9, 
        0x9CE6, 0xA567, 0xBE0A, 0xB58A, 0x9C65, 0xA4A5, 0xC5CB, 0xAC51, 0xBCD2, 0xDD72, 0xED92, 0xAC8E, 0xD698, 0xFFDE, 0xFFDE, 0xDE97, 0x5AA9, 0x1902, 0x31C2, 0x28C2, 0x1081, 0x10A0, 0x2121, 0x1902, 0x20A3, 0x2882, 0x28C1, 0x3943, 0x18A1, 0x1880, 
        0x41A1, 0xB42B, 0x9BAA, 0x8328, 0x8309, 0x9BEB, 0x936B, 0xA38B, 0xC46E, 0xDC91, 0xDD33, 0xE616, 0xF6B9, 0xBC8E, 0xCD91, 0xEE56, 0xFE79, 0xFEF4, 0xFF37, 0xFF3A, 0xFF1A, 0xF6F7, 0xE652, 0xDDF0, 0xDDF0, 0xF6D4, 0xF6F6, 0xF6D5, 0xF693, 0xF6B5, 
        0xFF38, 0xFF9A, 0xFFFB, 0xFFFC, 0xFF57, 0xF693, 0xEE33, 0xF734, 0xFF57, 0xFF78, 0xFFB7, 0xFF96, 0xFF97, 0xFF78, 0xFF59, 0xFF79, 0xFF79, 0xFF79, 0xFF7A, 0xFF7A, 0xFF5A, 0xFF1A, 0xFEB9, 0xF693, 0xF759, 0xDEFA, 0xA551, 0x4AA3, 0x9469, 0xB52C, 
        0x942A, 0x7326, 0xB46C, 0xD4CF, 0xCC0C, 0xDBEE, 0xE44F, 0xE490, 0xE492, 0xEC92, 0xEC71, 0xEC50, 0xE430, 0xF452, 0xEC50, 0xEC2F, 0xEC10, 0xF3B0, 0xE432, 0xE472, 0xEC71, 0xF492, 0xF491, 0xEC51, 0xE411, 0xE431, 0xE432, 0xDC32, 0xD410, 0xD431, 
        0xC3F3, 0xC393, 0xC353, 0xAB17, 0xAB1A, 0xAB1B, 0xA35B, 0xAB5C, 0xB33C, 0xAB5C, 0xAB5B, 0xAB5B, 0xB35C, 0xB35C, 0xA35B, 0xB33B, 0xAB5A, 0xA35A, 0xA33A,
  0x8232, 0x8232, 0x8233, 0x8233, 0x8252, 0x7A52, 0x7A52, 0x8232, 0x8232, 0x8252, 0x8272, 0x8273, 0x8253, 0x8253, 0x8253, 0x8253, 0x7A52, 0x8252, 0x7A52, 0x7A32, 0x8273, 0x8253, 0x8253, 0x8A53, 0x8253, 0x8253, 0x8252, 0x8232, 0x7A32, 0x8A73, 0x8A94, 
        0x8A74, 0x8A73, 0x8A73, 0x8A73, 0x8A53, 0x8A73, 0x8273, 0x8273, 0x8273, 0x8A73, 0x8A73, 0x8A54, 0x8A34, 0x8AB4, 0x6970, 0x9313, 0xEF5E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFF, 
        0xFFFE, 0xFFDA, 0xFFF6, 0xEF5C, 0x632C, 0x4A64, 0x8CC7, 0x2943, 0xA514, 0xF7BE, 0xFFFF, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFBE, 0xDDF3, 0xDD4F, 0xE5D1, 0xD58F, 0xDDB0, 0xC4ED, 0x93C9, 0xC551, 0xD5B3, 0xE674, 0xF776, 0xD590, 0xD58F, 0xDDD0, 
        0xDDB1, 0xBD4E, 0xBD4D, 0xD631, 0xE736, 0x7B65, 0x9C68, 0xCDAD, 0xDE2F, 0xAC8B, 0x9C4C, 0xB4EF, 0xEE33, 0xF6B5, 0xEEB2, 0xF716, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xEEDC, 0xAC72, 0x51C4, 0xC573, 0xEF17, 0xDF35, 0xB60E, 0x9D09, 
        0x8C85, 0xAD89, 0xE750, 0xA4E7, 0x9CC7, 0xAD4B, 0xD5F1, 0xC476, 0xC514, 0xBD71, 0x9D0E, 0x72E6, 0xA4AE, 0xD698, 0xFFDE, 0xEF5D, 0x5AEB, 0x0841, 0x0000, 0x0060, 0x10C3, 0x2924, 0x3164, 0x08A1, 0x1902, 0x2942, 0x3163, 0x29C4, 0x39A4, 0x5A24, 
        0x8B05, 0xAC2C, 0x93AA, 0x72C7, 0x5A26, 0xAC0E, 0xAC2D, 0xAC4D, 0xBCF1, 0xB512, 0xCCD0, 0xE573, 0xFEFA, 0xFFBE, 0xF6B6, 0xF673, 0xFF36, 0xFF3B, 0xFF1A, 0xFF17, 0xF715, 0xFF19, 0xF695, 0xF673, 0xFED4, 0xFFB8, 0xFFDB, 0xFFFD, 0xFFBC, 0xEDF0, 
        0xCCAD, 0xBBEB, 0xBC0C, 0xF779, 0xFFF9, 0xFF75, 0xFEB1, 0xFF74, 0xFF76, 0xFF98, 0xFFB8, 0xFF96, 0xFF98, 0xFF9A, 0xFFBB, 0xFFDC, 0xFF9B, 0xFF59, 0xFF39, 0xFFBA, 0xEED5, 0xEE74, 0xF6D7, 0xFFDE, 0xFF5A, 0xD5B1, 0x9386, 0xACCE, 0xA4CC, 0x8408, 
        0x5B46, 0xD56C, 0xDDCE, 0xCD2E, 0xBC2E, 0xECB1, 0xE470, 0xDC4F, 0xDC2E, 0xCBAF, 0xE3EE, 0xEC2E, 0xEC50, 0xE433, 0xE4B1, 0xE4B1, 0xE451, 0xF493, 0xFC73, 0xFC52, 0xF431, 0xD430, 0xBC10, 0xC430, 0xDC50, 0xBBAF, 0xC3CF, 0xCC0F, 0xCC0E, 0xB3EE, 
        0xB3B0, 0xB371, 0xB374, 0xAB9A, 0xA37B, 0xAB9B, 0xBBDA, 0xAB98, 0xB37A, 0xB37A, 0xAB99, 0xB39B, 0xB37B, 0xB37B, 0xB37C, 0xAB9B, 0xB39B, 0xAB9B, 0xA37B,
  0x7212, 0x7212, 0x7212, 0x7211, 0x7A12, 0x7A13, 0x7A13, 0x7212, 0x7212, 0x7212, 0x79F2, 0x79F2, 0x7A32, 0x7A53, 0x7A52, 0x7232, 0x7A33, 0x8252, 0x8252, 0x8A53, 0x8A32, 0x8232, 0x8232, 0x8232, 0x8212, 0x8232, 0x8A32, 0x8232, 0x8232, 0x8233, 0x8253, 
        0x8253, 0x8253, 0x8253, 0x8253, 0x8253, 0x8A53, 0x8A53, 0x8A53, 0x8A53, 0x8272, 0x8253, 0x8253, 0x8274, 0x8AB3, 0x596D, 0x592D, 0x92B5, 0xE6BC, 0x82EF, 0x3045, 0x0801, 0x40A9, 0xB517, 0xEF5D, 0xE73C, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDF, 0xFFFE, 0xFFDD, 0xFFBE, 0xFFBE, 0xFFBE, 0xFFBE, 0xFFBE, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDD, 0xFFFC, 0xFFBF, 0xFFBE, 0xFFDE, 
        0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFF7C, 0xFF5A, 0xFF3A, 0xF679, 0xFF3C, 0xEF3C, 0xDE58, 0xEF7C, 0xF7DE, 0xFFFF, 0xFFFF, 0xFFFE, 
        0xF77A, 0xF77A, 0xF77C, 0x9C6D, 0x4265, 0x10E1, 0x18A1, 0xA469, 0xE6B6, 0xFFBD, 0xFF9D, 0xFFDF, 0xFFFE, 0xFFFE, 0xFFDE, 0xF6B5, 0xEE33, 0xDDF1, 0xCDAF, 0xD58C, 0xCD6E, 0xD5B1, 0xE633, 0xC52E, 0xC54D, 0xCD4F, 0xDD93, 0xEED3, 0xDE13, 0xDDF2, 
        0xDE30, 0xB4EA, 0xBD6C, 0xDE70, 0xEEF1, 0x7B64, 0x8386, 0xB54F, 0xEF5A, 0xC54D, 0xB4A9, 0xC52C, 0xE694, 0xFFB6, 0xFFDC, 0xFFFF, 0xFFFF, 0xFFDF, 0xF7DE, 0xFFDE, 0xE71B, 0x2924, 0x4A07, 0x940E, 0xCE54, 0xF798, 0xC611, 0xB58E, 0xC60F, 0xA529, 
        0xB5A9, 0xBDE9, 0xB588, 0xBDEB, 0xCE2D, 0x8C49, 0x2965, 0xDEDB, 0xE616, 0xB48B, 0x8341, 0x6380, 0x7C22, 0xB58C, 0xF79C, 0xDE95, 0xB4CC, 0x9307, 0x79A6, 0x3041, 0x1080, 0x00A0, 0x08A1, 0x3967, 0x3145, 0x2942, 0x2161, 0x20A1, 0x51A5, 0x7267, 
        0x6AA5, 0x7AE6, 0x9BAA, 0x93A9, 0x72E6, 0x9328, 0x8B8A, 0x9C0C, 0xC4CF, 0xCD72, 0xBCD2, 0x938E, 0x6A69, 0xED94, 0xFEB6, 0xFED7, 0xF679, 0xF759, 0xF718, 0xF6F9, 0xFF5A, 0xEEB7, 0xF6B7, 0xFF18, 0xFFDA, 0xFFFC, 0xFF9A, 0xFF79, 0xFF99, 0xFFFE, 
        0xFFDC, 0xEF38, 0xD612, 0xABA9, 0xDD8E, 0xF733, 0xFFB5, 0xFED5, 0xFF76, 0xFFB7, 0xFF79, 0xFF77, 0xFF58, 0xFF38, 0xF717, 0xFEB6, 0xF6B7, 0xEEB7, 0xE676, 0xEE35, 0xF6F6, 0xFF77, 0xF778, 0xF7BC, 0xC633, 0x8CCA, 0x73E5, 0xAD69, 0x8C26, 0x7B85, 
        0x8C07, 0xA4E9, 0xDE54, 0xEE77, 0xDD12, 0xDBEE, 0xDC4F, 0xDC6F, 0xDC4F, 0xE453, 0xE472, 0xE491, 0xDC72, 0xDCD3, 0xDC91, 0xDC71, 0xDC52, 0xDBEF, 0xE431, 0xE432, 0xD431, 0xC430, 0xC3EF, 0xBBAF, 0xB34E, 0xC38E, 0xBB72, 0xAB56, 0xAB17, 0xAB39, 
        0xAB3A, 0xAB5B, 0xAB3D, 0xBB5C, 0xB37A, 0xAB59, 0xAB5A, 0xAB5C, 0xAB7A, 0xB37A, 0xB35C, 0xAB1A, 0xAB59, 0xB379, 0xAB79, 0xA379, 0xAB79, 0xAB79, 0xAB5A,
  0x7A32, 0x7A32, 0x7A32, 0x7A12, 0x8232, 0x7A32, 0x7A32, 0x7A32, 0x7A13, 0x7A32, 0x7A32, 0x7A32, 0x7A52, 0x7A32, 0x7A32, 0x7A32, 0x7A53, 0x8253, 0x8253, 0x7253, 0x7A32, 0x8252, 0x8232, 0x8212, 0x8252, 0x8253, 0x8233, 0x8253, 0x8252, 0x8253, 0x8253, 
        0x8273, 0x8253, 0x8A53, 0x8A53, 0x8232, 0x8A53, 0x8A53, 0x8A53, 0x8253, 0x8A53, 0x8A53, 0x8A53, 0x8A33, 0x8290, 0x8AD2, 0x8AB3, 0x7A12, 0x304A, 0x386A, 0x69B0, 0xB378, 0x61D2, 0x388C, 0x2007, 0x30E6, 0xDED9, 0xE6DA, 0xDEDA, 0xEF9D, 0xFFFF, 
        0xFFBE, 0xFFBE, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFDE, 0xFFDD, 0xFFDD, 0xFFDD, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFE, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFE, 0xFFDE, 0xFFBE, 0xFFDE, 0xFFDE, 0xFFDE, 
        0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFDE, 0xF7DE, 0xF73C, 0xEE9A, 0xF6BB, 0xF73C, 0xDD92, 0xEEB9, 0xF75B, 0xD634, 0x2904, 0x6AEB, 0xC595, 0xF7BE, 0xFFDE, 
        0xFF9C, 0xFFBD, 0xE71B, 0x2104, 0x3163, 0x3163, 0x2104, 0xE71B, 0xFFFF, 0xFFDE, 0xFFDF, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFDD, 0xEEB5, 0xEEB4, 0xE652, 0xDDAF, 0xCD6E, 0xCD6F, 0xD590, 0xCD90, 0xD591, 0xD590, 0xCD90, 0xCD91, 0xBCEB, 0xD5B0, 0xEE73, 
        0xE652, 0x8BC5, 0xC610, 0xEF15, 0xDE2F, 0xBD8C, 0xDE4F, 0xB4CC, 0x5A05, 0xE73C, 0xFFFF, 0xFFFF, 0xFFDE, 0xE676, 0xDE36, 0xE6D7, 0xF799, 0xDE57, 0xC533, 0xC531, 0xC54F, 0x2944, 0x9CD0, 0xBDD1, 0x83E8, 0xEF7B, 0xFFBB, 0xE6F5, 0xBDCE, 0xADA9, 
        0xAD69, 0xAD89, 0xADE9, 0xCE2D, 0xE6F1, 0x9CED, 0x3185, 0xDEBA, 0xBD10, 0x83A7, 0x6BE4, 0x7442, 0x83E3, 0xAD0B, 0xDED6, 0x5263, 0x51E4, 0x8B2B, 0xE555, 0xB4F3, 0x7B2D, 0x4986, 0x2041, 0x08C1, 0x08C1, 0x0881, 0x0040, 0x0000, 0x1060, 0x3182, 
        0x7326, 0xB44C, 0x93AA, 0x8B6A, 0x9BCB, 0x6A85, 0x8B08, 0xA3EB, 0xA4EF, 0xCD51, 0xBCCE, 0xB46D, 0xB44E, 0xABED, 0xDE58, 0xFFBD, 0xFFBC, 0xFF7B, 0xFF5B, 0xF71A, 0xF6D8, 0xFED6, 0xF6B7, 0xF676, 0xEE95, 0xFFB9, 0xFF9A, 0xFF9A, 0xFFDA, 0xFF9A, 
        0xFFDC, 0xFFFE, 0xFFFE, 0xFF78, 0xF6F5, 0xF714, 0xFF94, 0xFF96, 0xFF76, 0xFF76, 0xFF77, 0xFF98, 0xFF99, 0xFF79, 0xFF39, 0xFF57, 0xF6D7, 0xEE97, 0xEEB7, 0xEE76, 0xEE55, 0xEEB7, 0xFF7C, 0xDEFA, 0x9BEB, 0x8B88, 0xBDAF, 0x8BE8, 0x8BE8, 0x8BE8, 
        0x8406, 0xD62E, 0xEE73, 0xE5B4, 0xCC52, 0xCC2D, 0xC40E, 0xCC0E, 0xD40D, 0xDC32, 0xE451, 0xE471, 0xDC91, 0xDC92, 0xE492, 0xDC92, 0xDC91, 0xE533, 0xE4F3, 0xE4F3, 0xDCF3, 0xC431, 0xB32F, 0xAACD, 0xB2CB, 0xAB2A, 0xAB4E, 0xB372, 0xBB74, 0xB35A, 
        0xAB5B, 0xAB5B, 0xA37A, 0xB37A, 0xB37A, 0xAB7A, 0xA37A, 0xAB5B, 0xAB5B, 0xAB5B, 0xAB7B, 0xAB5B, 0xAB7C, 0xB37B, 0xB37B, 0xAB7B, 0xAB7B, 0xAB5A, 0xAB5A,
  0x8232, 0x8232, 0x8233, 0x8232, 0x8253, 0x8252, 0x7A32, 0x7A32, 0x7A32, 0x7A52, 0x8252, 0x8233, 0x8272, 0x8273, 0x8252, 0x8251, 0x8253, 0x8253, 0x8252, 0x8232, 0x8253, 0x8A53, 0x8A53, 0x8A53, 0x8253, 0x8253, 0x8253, 0x8273, 0x8252, 0x8A53, 0x8A73, 
        0x8273, 0x8273, 0x8A73, 0x8A73, 0x8A73, 0x8273, 0x8273, 0x8253, 0x8A53, 0x8A73, 0x8A94, 0x8A94, 0x8A93, 0x82B0, 0x8AB4, 0x8A96, 0x8275, 0x7214, 0x8AB8, 0x92B7, 0x8210, 0x9AF6, 0x8A76, 0x9296, 0xA315, 0x1883, 0x2101, 0x73AB, 0xEF7D, 0xFFBF, 
        0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDE, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFD, 0xFFFE, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFBE, 0xF75D, 0xFF7C, 0xFF3A, 0xFF5A, 0xFF9B, 0xFEDA, 0xF75D, 0xF7BF, 0xF7BE, 0xC619, 0xDE9A, 0x9CB2, 0x3165, 0xE71C, 
        0xFFFF, 0xFFFF, 0xE71C, 0x2104, 0x20E1, 0x6AA6, 0xD570, 0xFFBD, 0xFFFE, 0xFFDE, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xF733, 0xF6B3, 0xEE53, 0xEDF2, 0xDDAE, 0xD58F, 0xD590, 0xCD90, 0xDDD3, 0xDDD2, 0xDDB1, 0xDD71, 0xD56F, 0xC54E, 0xB52E, 
        0xACCD, 0x9424, 0xCE4E, 0xEF32, 0xD62D, 0x8363, 0x3981, 0x62E7, 0xDE91, 0xAC8A, 0xB4AD, 0xC550, 0xC592, 0x9B88, 0x9BC7, 0xBD6F, 0xF77C, 0xEEB6, 0xF6D6, 0xE695, 0xB50F, 0x2903, 0x83A9, 0xACC9, 0x8C05, 0xEF7B, 0xFFBA, 0xF715, 0xDE50, 0xADAA, 
        0xA569, 0xB5C9, 0xC6AB, 0xCE4F, 0xDEF0, 0x9CEB, 0x20E2, 0x92A7, 0xB42D, 0xA44B, 0x7B82, 0x9524, 0x9D24, 0x9CE3, 0x94C4, 0xCE10, 0x5A87, 0x38C2, 0x7965, 0xC2AD, 0xE494, 0xD535, 0x940E, 0x9083, 0x58C4, 0x51A7, 0x726A, 0x7187, 0x78C5, 0x6043, 
        0x3881, 0x8389, 0xA40C, 0xA3EC, 0x8B69, 0x82E6, 0x8B89, 0x940B, 0xA48B, 0xC5B1, 0xACAE, 0xA44D, 0xACAD, 0xA3AC, 0xDD75, 0xFF1B, 0xFFDD, 0xFFBE, 0xFF9C, 0xFF7B, 0xF759, 0xFE95, 0xF6B6, 0xF695, 0xFE74, 0xFEF7, 0xFF37, 0xFF78, 0xFF9B, 0xFF9A, 
        0xFFBB, 0xFFBB, 0xFFBB, 0xFFDC, 0xFFDD, 0xFFBC, 0xFF77, 0xFFD7, 0xFFB6, 0xFFB6, 0xFFD9, 0xFF17, 0xEE54, 0xEE74, 0xF717, 0xCD74, 0xD593, 0xDDD4, 0xE5F5, 0xDE14, 0xEED6, 0xF778, 0xD717, 0x7AE4, 0xA429, 0xB52C, 0xACEA, 0x7BC7, 0x8C08, 0x9428, 
        0x8C49, 0xE671, 0xE5D2, 0xD4D1, 0xBC31, 0xDC0F, 0xE450, 0xDC50, 0xCBEF, 0xD3AE, 0xBB8D, 0xBBCE, 0xCC31, 0xCC72, 0xD491, 0xD491, 0xCCB2, 0xCC6F, 0xB3CF, 0xA30E, 0x9A4B, 0x8928, 0x89E9, 0x928A, 0x9ACE, 0xBB5A, 0xC39C, 0xBB9C, 0xB39B, 0xB37D, 
        0xA39D, 0xA3BC, 0xAB9A, 0xB37B, 0xB37D, 0xAB7D, 0xA39A, 0xABDB, 0xABBB, 0xAB9B, 0xAB7B, 0xAB7C, 0xAB7C, 0xAB7C, 0xAB9D, 0xBB5D, 0xB37D, 0xAB7D, 0xAB5C,
  0x7212, 0x7212, 0x7212, 0x7211, 0x7A12, 0x7A33, 0x7A32, 0x7212, 0x7212, 0x7A12, 0x7A12, 0x7A12, 0x7A32, 0x7A32, 0x7A32, 0x7A13, 0x7A52, 0x8A33, 0x8233, 0x7233, 0x7A52, 0x8232, 0x8212, 0x8212, 0x8252, 0x8252, 0x8233, 0x8213, 0x8252, 0x8253, 0x8253, 
        0x8253, 0x8252, 0x8253, 0x8253, 0x8253, 0x8253, 0x8253, 0x8A53, 0x8A53, 0x8233, 0x8253, 0x8252, 0x8233, 0x8254, 0x8273, 0x8A73, 0x8A93, 0x8AB3, 0x7A52, 0x8293, 0x9B36, 0x79B3, 0x7A94, 0x6AD2, 0x5A6C, 0x940F, 0x830B, 0x9C30, 0xF75C, 0xFEB8, 
        0xEE36, 0xEDD5, 0xF5B4, 0xEF7D, 0xF7DF, 0xFFFF, 0xFFFF, 0xFFBE, 0xFFDF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFFE, 0xFFBE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFF9D, 0xFFDE, 0xFFDF, 0xFFDE, 
        0xFFDD, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFBE, 0xFFBD, 0xF7FD, 0xF79D, 0xF79C, 0xF7DC, 0xFFDC, 0xF6B6, 0xF759, 0xF737, 0xEE71, 0xFFBD, 0xF7BE, 0xB554, 0x3922, 0x18A2, 
        0x9CD3, 0xC5F5, 0x7B48, 0x1061, 0x0841, 0x5AEB, 0xEF5C, 0xFFBB, 0xFFDD, 0xFFDE, 0xFFFD, 0xFFBE, 0xFFDD, 0xFFDC, 0xFFDB, 0xEF19, 0xF6D6, 0xEEB4, 0xDE74, 0xD5D3, 0xD5D2, 0xDDD1, 0xD58F, 0xCD71, 0xCD71, 0xD591, 0xD5B0, 0xCD71, 0xD570, 0xC56D, 
        0xAD0A, 0x9467, 0xCE73, 0xDE93, 0x9C46, 0x2901, 0x83C8, 0xDE52, 0xF79B, 0xD5D3, 0xCD92, 0xCD92, 0xD592, 0xDE75, 0xEF5B, 0xE6D8, 0xC570, 0xEEB8, 0xF77B, 0xDE95, 0x9428, 0x20C1, 0x6B06, 0xBD4F, 0xF71A, 0xFFDE, 0xF75B, 0xD654, 0xA58B, 0xCECC, 
        0xCEAD, 0xCE6D, 0xC66D, 0xCF10, 0xADAB, 0x6B46, 0x2861, 0x2861, 0x7325, 0x8CC5, 0x64A2, 0x8445, 0x94A9, 0xB54D, 0xD64D, 0xA527, 0x5A03, 0x4020, 0x6000, 0x3800, 0x5081, 0x7925, 0xA1E8, 0x7925, 0x9A09, 0xC26B, 0xDA6C, 0xFD19, 0xFD3A, 0xD3B2, 
        0x91A6, 0x5B07, 0x8368, 0x8307, 0x5244, 0x9348, 0x93A7, 0x8B89, 0x936D, 0xB48D, 0xAC4D, 0xAC4F, 0xBCB2, 0xAB8C, 0xC554, 0xE6FB, 0xFFDE, 0xFF9A, 0xFFBB, 0xFFBC, 0xFF5B, 0xFF9C, 0xFF5B, 0xF739, 0xF736, 0xF655, 0xF6D8, 0xF738, 0xFF16, 0xFF98, 
        0xFF99, 0xFF79, 0xFF3A, 0xFF79, 0xFFBA, 0xFF9A, 0xFF38, 0xFF15, 0xFF75, 0xFFB6, 0xFF98, 0xF738, 0xF778, 0xDE54, 0xB48F, 0xCDD2, 0xDE15, 0xDE16, 0xDE16, 0xF657, 0xFEF8, 0xE695, 0xACAC, 0x3202, 0x9469, 0xACEA, 0x6B46, 0x9CEC, 0x9489, 0x8BE6, 
        0x83E6, 0xCDD2, 0xC553, 0xBC90, 0xB3EB, 0xBBAE, 0xB38D, 0xBBAE, 0xD3EF, 0xAB4C, 0xC3D0, 0xCC31, 0xCC0F, 0xBB8D, 0xAB0C, 0xA2AB, 0xA24B, 0x7146, 0x6905, 0x68C3, 0x7082, 0xA165, 0xBA09, 0xC28B, 0xC32E, 0xA334, 0xAB38, 0xB33B, 0xB33D, 0xAB3C, 
        0xAB5B, 0xB35B, 0xAB7C, 0xB33D, 0xAB5C, 0xAB7A, 0xAB79, 0xAB7A, 0xAB5B, 0xAB5B, 0xA35A, 0xAB5C, 0xB37B, 0xB37A, 0xAB5B, 0xAB7A, 0xAB7A, 0xAB7B, 0xB35A,
  0x7A12, 0x7A12, 0x7A12, 0x7212, 0x7A32, 0x7A32, 0x7A32, 0x7A12, 0x7A32, 0x7A32, 0x7A12, 0x7A12, 0x7A52, 0x7A32, 0x7A32, 0x7A52, 0x7A33, 0x7A33, 0x7A33, 0x7A33, 0x8252, 0x8252, 0x7A52, 0x7232, 0x8A52, 0x8A52, 0x8253, 0x8253, 0x8233, 0x8A53, 0x8A53, 
        0x8253, 0x8253, 0x8273, 0x8A53, 0x8252, 0x8A73, 0x8A53, 0x8253, 0x8253, 0x8A53, 0x8253, 0x8253, 0x8A73, 0x8255, 0x8253, 0x7A52, 0x6A72, 0x8A75, 0x8AB5, 0x92B3, 0x9270, 0x6A53, 0x7253, 0x9353, 0xB4D6, 0x8C4F, 0x6AE8, 0x7AE9, 0xBCD3, 0xF77D, 
        0xF6F8, 0xE614, 0xCD12, 0x93EF, 0xC513, 0xE678, 0xF7DE, 0xFFFF, 0xFFDF, 0xFFDE, 0xFFDF, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFDE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFBD, 0xFFBD, 0xFF9D, 0xFFBE, 0xFFDE, 
        0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFF, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDD, 0xFFBD, 0xFFBC, 0xFFBB, 0xFFBB, 0xFF59, 0xFF19, 0xF6F9, 0xE6BA, 0xE6D7, 0xEEF7, 0xFF5A, 0xF79D, 0xBD53, 
        0x4A07, 0x1882, 0x28C3, 0x1062, 0x630C, 0xB5B6, 0xF7BE, 0xFF7E, 0xF77D, 0xFF9D, 0xFFFE, 0xFFDD, 0xFFDC, 0xFFFC, 0xFFDB, 0xF758, 0xF6F6, 0xF6B5, 0xEE95, 0xDDD3, 0xD5B2, 0xD5D1, 0xD5D0, 0xD5B2, 0xD592, 0xD591, 0xD591, 0xD591, 0xCD91, 0xBD2E, 
        0xA489, 0x9D07, 0xD6AE, 0xD6AE, 0xA509, 0xDE0E, 0xE691, 0xDE10, 0xC54D, 0xEED6, 0xEEB7, 0xE634, 0xD5B1, 0xF7BD, 0xFFBC, 0xFF7A, 0xF717, 0xE698, 0xEF1B, 0xB573, 0x39A2, 0x1881, 0x8BA9, 0xDE53, 0xFFDD, 0xFFFF, 0xF7BE, 0xF799, 0xEF51, 0x9525, 
        0xADEA, 0xC68C, 0xBE8B, 0xC68F, 0xA54C, 0x6B47, 0x2102, 0x6987, 0xA409, 0xA507, 0x8462, 0x8CC7, 0x8C88, 0x94C8, 0xB5EA, 0xCE68, 0x5AA3, 0x2860, 0x5881, 0x6105, 0x5062, 0x4801, 0x4022, 0x38C3, 0x5841, 0x6801, 0x8023, 0xB9AA, 0xE415, 0xFDFC, 
        0xE69B, 0x3983, 0x3101, 0x51E3, 0x7B07, 0x7264, 0x82E6, 0x93C9, 0xAC8D, 0xC510, 0xAC4E, 0xA3ED, 0xA40F, 0xA3CC, 0xD5D6, 0xEF19, 0xFF36, 0xFF3A, 0xFF5B, 0xFF7B, 0xFF7B, 0xFFDB, 0xFFDB, 0xFFBB, 0xFFBB, 0xF6F6, 0xF695, 0xEE96, 0xEED8, 0xFF56, 
        0xFF77, 0xF758, 0xF719, 0xFF59, 0xF6D6, 0xF6D6, 0xF717, 0xF716, 0xFF96, 0xFFB7, 0xFF57, 0xFF98, 0xFFB9, 0xFF9A, 0xFF5A, 0xDE13, 0xD532, 0xD512, 0xDD92, 0xC572, 0xA44E, 0x6268, 0x2903, 0xCDEE, 0xC5AB, 0x94A7, 0x6BE5, 0xA4AB, 0x9429, 0x8C07, 
        0x9488, 0xD5F4, 0xCD54, 0xC4B1, 0xBC2F, 0xC38C, 0xBBAC, 0xBBAD, 0xBBAE, 0xC36D, 0xAAEA, 0xA2EA, 0xAB2C, 0x8A27, 0x924A, 0x89C8, 0x6883, 0x70C6, 0x8125, 0x9145, 0x9927, 0xA9EC, 0xAA70, 0xAAF5, 0xB379, 0xAB79, 0xAB59, 0xAB5A, 0xAB3A, 0xB37A, 
        0xB35B, 0xB35C, 0xB35B, 0xAB7B, 0xAB7A, 0xAB9A, 0xAB99, 0xB35A, 0xAB79, 0xAB9A, 0xB39B, 0xAB3A, 0xAB7A, 0xAB9A, 0xAB7B, 0xAB7A, 0xAB7A, 0xAB7A, 0xAB7B,
  0x8252, 0x8233, 0x8253, 0x8252, 0x8232, 0x7A12, 0x7A32, 0x8252, 0x8252, 0x7A52, 0x8252, 0x8272, 0x8252, 0x8252, 0x8252, 0x8253, 0x8253, 0x8253, 0x8252, 0x8232, 0x8A73, 0x8253, 0x8A53, 0x8A73, 0x8273, 0x8252, 0x8252, 0x8252, 0x8252, 0x8253, 0x8273, 
        0x8A73, 0x8253, 0x8253, 0x8A73, 0x8A74, 0x8252, 0x8272, 0x8273, 0x8A73, 0x8A73, 0x8A74, 0x8A74, 0x8A74, 0x8A73, 0x8A73, 0x8A94, 0x8A94, 0x8A52, 0x8252, 0x8273, 0x8A74, 0x8A73, 0x9B36, 0xABF5, 0xA430, 0x6226, 0x59A8, 0x93B1, 0xEF5D, 0xFF3E, 
        0xEE37, 0xDDB4, 0xD575, 0xDD94, 0xCCF2, 0xC4F2, 0xDD95, 0xFFBE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFF9F, 0xFF7E, 0xFFDE, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFDE, 0xFFBC, 0xFFFF, 0xFFFE, 0xFFFE, 
        0xFFFF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFDF, 0xFFDC, 0xFFFB, 0xFFDC, 0xFF9C, 0xFF9C, 0xFF9D, 0xFF7C, 0xFF7B, 0xFF3B, 0xFF7C, 0xFFFF, 0xFFFF, 
        0xF7BE, 0xA514, 0x10A2, 0x1082, 0xA4B0, 0xF75A, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFD, 0xFFFE, 0xFFDE, 0xFFFE, 0xFFFD, 0xFFFB, 0xFF7A, 0xF718, 0xF6D7, 0xFE96, 0xEE73, 0xDDD1, 0xD591, 0xD5B2, 0xD5D0, 0xD5D1, 0xDDB2, 0xDDB1, 0xD56E, 0xDE10, 0xBD2D, 
        0x7B86, 0xEEEF, 0xF751, 0xE670, 0xCD4F, 0xE674, 0xDE32, 0xDE11, 0xE674, 0xEE94, 0xE653, 0xEE95, 0xFF5B, 0xFFDC, 0xFF58, 0xFEF7, 0xF739, 0xFFD8, 0xF756, 0xB52F, 0x4A03, 0x6222, 0xBDB3, 0xF7BD, 0xFFFC, 0xFFFF, 0xF7BE, 0xC594, 0x82A5, 0xEF35, 
        0xEF52, 0xE711, 0xEF12, 0xB5CC, 0xD6AE, 0x9CEB, 0x3184, 0xDED2, 0xBD8B, 0x9465, 0x8C84, 0x94A4, 0x94A6, 0xA529, 0xC62D, 0xC64E, 0xCD70, 0x8B4C, 0x2082, 0x7905, 0x70E5, 0x6883, 0x6862, 0x9146, 0x8945, 0x70C3, 0x5021, 0x98A4, 0x9083, 0xB1A8, 
        0xF474, 0xEEDA, 0x82EB, 0x5101, 0x5A02, 0x8367, 0x8BCA, 0x93EC, 0xAC0F, 0xB4CF, 0xAC0D, 0xA3CD, 0x9BED, 0xA3AF, 0xBD13, 0xDE78, 0xFF7C, 0xFEFC, 0xFF5B, 0xFF9B, 0xFFBC, 0xFF9C, 0xFFDC, 0xFFFD, 0xFFFE, 0xFFBA, 0xFEF7, 0xFE76, 0xFE76, 0xFF98, 
        0xFFB8, 0xFF9A, 0xFF7B, 0xFF56, 0xFF99, 0xFFBB, 0xFF5B, 0xFF36, 0xFF54, 0xFF94, 0xFFD5, 0xF6F7, 0xFF5B, 0xFFBC, 0xFFFD, 0xFFFD, 0xFF5C, 0xEE37, 0xBC4F, 0x4922, 0x4120, 0x5204, 0x7B89, 0xC5CE, 0x9466, 0x7BC4, 0x9488, 0x8C09, 0x83E7, 0x9448, 
        0xACEC, 0xD5D3, 0xC531, 0xAC2E, 0x932A, 0x8AAA, 0xA32D, 0xB34D, 0xB2CA, 0x7145, 0x6083, 0x6042, 0x6882, 0x8A6B, 0x9288, 0x8A25, 0x79C5, 0x89C7, 0x9186, 0x99A6, 0xA208, 0xCB70, 0xC332, 0xBB16, 0xBB3C, 0xB35C, 0xB37C, 0xB39C, 0xB37C, 0xAB5C, 
        0xAB5C, 0xAB5C, 0xAB5B, 0xB39B, 0xB37B, 0xB37B, 0xAB9C, 0xB37B, 0xB39B, 0xAB9B, 0xA35C, 0xB37C, 0xAB9B, 0xAB9B, 0xAB7B, 0xAB9B, 0xB39B, 0xB39B, 0xB39B,
  0x7A11, 0x7A32, 0x7A12, 0x7A12, 0x7A32, 0x7A32, 0x7A12, 0x7A12, 0x7A12, 0x7A12, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A52, 0x7A32, 0x7A32, 0x7A33, 0x8253, 0x8A32, 0x8232, 0x8252, 0x8253, 0x8253, 0x8252, 0x8232, 0x8233, 0x8232, 0x8253, 0x8253, 
        0x8252, 0x8232, 0x8252, 0x8253, 0x8273, 0x8A32, 0x8253, 0x8253, 0x8A53, 0x8253, 0x8253, 0x8A53, 0x8A52, 0x8253, 0x8253, 0x8253, 0x8253, 0x8A73, 0x8274, 0x8273, 0x8272, 0x82B3, 0x9310, 0x9B8C, 0x940A, 0x9370, 0x832D, 0x6A88, 0x6A66, 0xE71B, 
        0xDE36, 0xCD51, 0xD550, 0xD617, 0xE617, 0xEDF6, 0xDDB4, 0xCCF3, 0xCCB2, 0xD510, 0xE5F0, 0xF79B, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xFF9C, 0xFF5B, 0xFF7D, 0xFFBE, 
        0xFFBE, 0xFFFE, 0xFFDE, 0xFFFF, 0xFFFE, 0xFFDE, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFBE, 0xFFBE, 0xFFDE, 0xFFDE, 0xFFDF, 0xFFDE, 0xFFDD, 0xFFDC, 0xFFBC, 0xFFDB, 0xF79A, 0xF718, 0xFFDC, 0xFFBD, 0xFFBE, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xE71C, 0x3186, 0xA514, 0xF7BE, 0xFFFF, 0xFFFE, 0xFFDD, 0xFFDC, 0xFFFC, 0xFFFD, 0xFFFB, 0xFFDA, 0xFFBA, 0xFF78, 0xFF38, 0xF6F7, 0xF6D5, 0xEE94, 0xE653, 0xDE13, 0xDDD2, 0xD5B2, 0xD5B2, 0xD5B2, 0xD5D2, 0xD5D0, 0xE650, 0xCD4D, 
        0x9389, 0xEEF0, 0xEF10, 0xDEB0, 0xDE53, 0xEE74, 0xF6B4, 0xF6D5, 0xEEB5, 0xF695, 0xEE95, 0xEF18, 0xF7DC, 0xFF5A, 0xF6F8, 0xF73A, 0xF7BC, 0xD5CE, 0x83A7, 0x6A62, 0x8AA4, 0xEF5B, 0xFFFC, 0xFFDB, 0xF7BE, 0xFFDF, 0xEF1C, 0x9CB2, 0x31A6, 0xAD6C, 
        0xA4EA, 0x9409, 0x9C4D, 0xE71B, 0x7C0B, 0x2A01, 0x2221, 0xA549, 0x9CE8, 0x8C45, 0x8C23, 0x94EA, 0xA54A, 0xA547, 0xA506, 0xCDF4, 0xDEB6, 0xCDB1, 0x92C8, 0x2061, 0x4882, 0x60C3, 0x58E3, 0x7082, 0x90E5, 0xA0E6, 0x9084, 0x6064, 0x80A5, 0x9084, 
        0x90C5, 0xEDBA, 0xC451, 0x6A07, 0x20C2, 0x93C8, 0x72E5, 0x72E5, 0xA44A, 0xC530, 0xA4AD, 0x9C6D, 0xAC4D, 0x7A67, 0xAC8F, 0xDE56, 0xFED8, 0xFE16, 0xFEF9, 0xFF5A, 0xFF19, 0xFF7D, 0xFF9C, 0xFFBB, 0xFFBB, 0xFF9C, 0xFFDC, 0xF7BC, 0xF75A, 0xF654, 
        0xF675, 0xFF17, 0xFFD8, 0xFF5A, 0xF6B5, 0xF6D6, 0xFFDB, 0xFF7C, 0xF738, 0xF754, 0xFFD2, 0xF716, 0xF696, 0xF655, 0xF676, 0xFEF6, 0xFF98, 0xFFFB, 0xFFFD, 0xEF5C, 0x630B, 0x3141, 0x6281, 0x8C47, 0x9429, 0x9409, 0x9449, 0xA50A, 0x9469, 0x9C29, 
        0xACAC, 0xCD53, 0xBC90, 0x930B, 0x6944, 0x8145, 0x8104, 0x70C3, 0x5883, 0x68E6, 0x8188, 0x9A2A, 0xB26C, 0x9264, 0x9247, 0x9A0A, 0x99EA, 0xA9A9, 0x9109, 0x912C, 0xA1EF, 0x9A51, 0xAB19, 0xB35C, 0xAB3A, 0xAB7B, 0xAB7B, 0xAB5A, 0xAB5B, 0xB37C, 
        0xB37A, 0xB39A, 0xAB9A, 0xB35A, 0xB37A, 0xAB7B, 0xAB7B, 0xAB7A, 0xAB7A, 0xAB7B, 0xAB7A, 0xAB7B, 0xB35B, 0xB37A, 0xAB9B, 0xAB5A, 0xAB7A, 0xAB7B, 0xAB5B,
  0x7232, 0x7A12, 0x7A12, 0x7A32, 0x7212, 0x7A32, 0x7A32, 0x7A33, 0x7A12, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A12, 0x7A32, 0x7A32, 0x7A33, 0x7A33, 0x7A32, 0x8232, 0x8232, 0x8212, 0x8273, 0x8252, 0x8232, 0x8253, 0x8232, 0x8253, 0x8253, 
        0x8253, 0x8252, 0x8252, 0x8253, 0x8253, 0x8A53, 0x8253, 0x8253, 0x8A53, 0x8A53, 0x8253, 0x8273, 0x8A73, 0x8253, 0x8253, 0x8273, 0x8A73, 0x8A53, 0x8A53, 0x8273, 0x8273, 0x8A54, 0x92D4, 0x8B0F, 0x7B48, 0x9BEE, 0x7B0D, 0x72AD, 0x9370, 0xD637, 
        0xDE36, 0xD5B3, 0xCD52, 0xE635, 0xE616, 0xDDF6, 0xDDF5, 0xDDD4, 0xE615, 0xE636, 0xE615, 0xC592, 0xB510, 0xC551, 0xEE76, 0xFFDE, 0xFFDF, 0xFFDF, 0xFFDF, 0xF7FD, 0xFFDD, 0xFFDD, 0xF7BE, 0xFFBD, 0xFFDD, 0xFFBD, 0xFF7D, 0xFFBD, 0xFFDE, 0xFFDE, 
        0xFFBD, 0xFF9E, 0xFF9E, 0xFFBE, 0xFFFF, 0xFFDE, 0xFFDE, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFBB, 0xF7BB, 0xF77A, 0xF759, 0xFFDC, 0xFFDE, 0xFFDF, 0xFFDE, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFDD, 0xFFBD, 0xFFDD, 0xFFDC, 0xFFFC, 0xFFFE, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xF759, 0xF758, 0xF737, 0xF6F7, 0xF6B5, 0xEE74, 0xE653, 0xDE32, 0xDE13, 0xDE13, 0xD5F2, 0xD5D2, 0xDE11, 0xEEB4, 0xCDAF, 
        0x93C6, 0xEE91, 0xF711, 0xEEF2, 0xEE94, 0xEED5, 0xF6D6, 0xF6F6, 0xEED5, 0xFEF7, 0xFF7A, 0xFFDC, 0xFFBB, 0xFF7A, 0xFF5A, 0xEED7, 0xD5D2, 0xB4ED, 0xCD90, 0xE694, 0xFF7A, 0xFFDE, 0xFFBC, 0xFFBC, 0xFFFF, 0xFFFF, 0xF7BE, 0xA514, 0x18A2, 0x1840, 
        0x5204, 0x72E7, 0x834A, 0xE6FA, 0x8C2B, 0x31A1, 0x1901, 0xB548, 0xA4E6, 0x8C64, 0x8464, 0x9CC8, 0xA54A, 0xADCA, 0xB5E9, 0xAD2C, 0xDEB5, 0xFF9A, 0xE6B7, 0x20E3, 0x3081, 0x48A1, 0x58A2, 0x6062, 0x78A3, 0x88C4, 0x88A5, 0xA125, 0xC1CB, 0xB18A, 
        0x9045, 0xB909, 0xDCF5, 0xB4D3, 0x48C3, 0x3143, 0x6AA5, 0x93A8, 0xAC4C, 0xBD4F, 0xB50F, 0x9C4D, 0x7B2A, 0x8AC7, 0xCD92, 0xF719, 0xEEBA, 0xF636, 0xF697, 0xFED9, 0xFEF9, 0xFF5B, 0xFF9B, 0xFFBB, 0xFFBC, 0xFFBC, 0xFFBC, 0xFFDC, 0xFFDB, 0xF6F8, 
        0xF676, 0xEE35, 0xE654, 0xF6F7, 0xF6D6, 0xF6D6, 0xFF77, 0xFF7B, 0xF717, 0xF714, 0xFF52, 0xFF16, 0xF6F7, 0xF718, 0xFF38, 0xF6D6, 0xF6D6, 0xF717, 0xFF78, 0xFFFE, 0xFFDD, 0xDE98, 0xAC4E, 0x6262, 0x5A01, 0x7B46, 0xBD8E, 0x9449, 0x9408, 0x9C49, 
        0xB4CD, 0xDDB3, 0xAC4E, 0x7287, 0x4902, 0x50E2, 0x50A1, 0x5881, 0x68A2, 0x8168, 0x7967, 0x7927, 0x8969, 0xB36D, 0x8A48, 0x7964, 0x8165, 0x7907, 0x78E6, 0x9127, 0xC22C, 0xD35C, 0xBB7B, 0xAB7B, 0xA39C, 0xAB39, 0xAB59, 0xAB7A, 0xA35B, 0xB35B, 
        0xB35B, 0xAB7B, 0xAB7B, 0xB39A, 0xB37A, 0xAB7B, 0xAB7A, 0xAB5A, 0xAB7A, 0xAB7B, 0xAB7B, 0xAB7B, 0xB37B, 0xB37B, 0xAB7B, 0xAB7A, 0xAB7A, 0xAB7B, 0xAB7B,
  0x8212, 0x8232, 0x8233, 0x8232, 0x7A52, 0x7A32, 0x7A32, 0x7A32, 0x8232, 0x7A52, 0x8252, 0x8252, 0x8272, 0x8253, 0x8253, 0x8252, 0x8253, 0x8252, 0x8252, 0x7A52, 0x8253, 0x8253, 0x8273, 0x8252, 0x8273, 0x8253, 0x8252, 0x8252, 0x8252, 0x8252, 0x8273, 
        0x8253, 0x9274, 0x8A73, 0x8273, 0x8A74, 0x8232, 0x8253, 0x8273, 0x8A53, 0x8A73, 0x8A74, 0x8A74, 0x8273, 0x8A74, 0x8A73, 0x8A73, 0x8273, 0x8A73, 0x8293, 0x8A73, 0x9253, 0x7A93, 0x830D, 0x938A, 0x9BEB, 0x8B30, 0x82AE, 0x7AED, 0x83EE, 0xEDB4, 
        0xE614, 0xE654, 0xEE73, 0xCD96, 0xD574, 0xDD94, 0xDDB5, 0xE5D7, 0xE5D7, 0xEDD7, 0xF5B8, 0xDDD6, 0xAC6E, 0xBCEE, 0xF715, 0xFFD9, 0xFFBA, 0xFFBB, 0xFFFE, 0xFFFF, 0xFFDD, 0xF75C, 0xF69B, 0xFEDC, 0xFF9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFDD, 0xFFDD, 0xFFBB, 0xFF99, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFBE, 0xFFBD, 0xFFBD, 0xFFFD, 0xFFFC, 0xFFFC, 0xFFFE, 0xFFDA, 0xFFDA, 0xFFDB, 0xFFDC, 0xFFBA, 0xFF78, 0xFF77, 0xFF57, 0xFF16, 0xFEF5, 0xFEB5, 0xF695, 0xF6B4, 0xEE94, 0xEE74, 0xEE53, 0xEE92, 0xF735, 0xCE13, 
        0x8BCB, 0xEEEF, 0xF6EF, 0xEEB1, 0xEEB6, 0xFF16, 0xFF36, 0xFF16, 0xF6D5, 0xFFBB, 0xFFFE, 0xFFBD, 0xF77B, 0xFFDB, 0xFF59, 0xE654, 0xC550, 0xF6D4, 0xFF9A, 0xFFFC, 0xFFFC, 0xFF7A, 0xFFBD, 0xFFDF, 0xFFDF, 0xFFFF, 0xF7BE, 0xB574, 0x4182, 0x4181, 
        0x72EB, 0x7AAC, 0x4945, 0x8C2D, 0xCE57, 0x9CF3, 0x2944, 0xCD71, 0xB4CB, 0x9426, 0x8465, 0x8CA5, 0x9509, 0xADCC, 0xC68E, 0xA5AB, 0xB50D, 0xD5D4, 0xF77D, 0xC534, 0x5208, 0x2881, 0x48C1, 0x70C4, 0x70A3, 0x70A2, 0x7882, 0x9063, 0xA0A4, 0xB947, 
        0xD1EA, 0xA8A6, 0xC1CA, 0xE452, 0xEEDB, 0x79A6, 0x5122, 0x6245, 0x940C, 0xB4CE, 0xA48E, 0x942C, 0x7BCA, 0xA328, 0xDDF5, 0xF71B, 0xF657, 0xEE57, 0xF697, 0xFED8, 0xFEFA, 0xFF7A, 0xFFBB, 0xFFBC, 0xFFDD, 0xFFDC, 0xFFDC, 0xFFDD, 0xFFFE, 0xFFFC, 
        0xFF58, 0xF654, 0xED70, 0xF75A, 0xFFDB, 0xFFBA, 0xFF78, 0xFF5A, 0xFF19, 0xFF16, 0xFF52, 0xF794, 0xFFB7, 0xFFB9, 0xFF79, 0xFEF7, 0xF738, 0xF737, 0xFED5, 0xF6D6, 0xFF79, 0xFFFD, 0xFFFF, 0xF77D, 0xBD6F, 0x8365, 0x5221, 0x83A6, 0x946B, 0xACCF, 
        0xBD11, 0xAC8F, 0x82C8, 0x7265, 0x8308, 0x9A89, 0x8185, 0x7903, 0x8124, 0x8167, 0x8167, 0x6905, 0x50A2, 0xC3F0, 0xED35, 0xD452, 0x8A0A, 0x6084, 0xA26E, 0xC356, 0xB2F7, 0xB39D, 0xA39D, 0xA39B, 0xABB9, 0xAB79, 0xB399, 0xB39A, 0xAB5C, 0xB39B, 
        0xB37B, 0xAB7B, 0xAB9B, 0xAB7B, 0xAB9B, 0xB39B, 0xB39B, 0xB37B, 0xAB9B, 0xAB9B, 0xAB9B, 0xB37B, 0xAB7B, 0xAB7B, 0xAB7B, 0xAB9B, 0xB39B, 0xB39B, 0xB39B,
  0x7A32, 0x7A32, 0x7A32, 0x7A52, 0x7A12, 0x7A32, 0x7A32, 0x7A12, 0x7A12, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A52, 0x7A32, 0x7A32, 0x7A53, 0x7A33, 0x8233, 0x8A53, 0x7232, 0x7A32, 0x8253, 0x8233, 0x8232, 0x8252, 0x8252, 0x8252, 0x8253, 0x8253, 0x8253, 
        0x8253, 0x8252, 0x8232, 0x8233, 0x8253, 0x8A73, 0x8A53, 0x8A53, 0x8253, 0x8A53, 0x8253, 0x8253, 0x8253, 0x8253, 0x8273, 0x8273, 0x8253, 0x8A53, 0x8A53, 0x8253, 0x8293, 0x9253, 0x8A93, 0x8B30, 0x8C0B, 0x7B6B, 0x6AAE, 0x6A10, 0x8252, 0xCD99, 
        0xEE1A, 0xEDB8, 0xDD16, 0xDDD5, 0xEDF8, 0xF639, 0xF699, 0xF6B7, 0xFEFA, 0xFEFA, 0xFED8, 0xEE57, 0xF6B8, 0xFEB7, 0xF634, 0xF5D1, 0xF613, 0xF654, 0xE6B3, 0xF695, 0xFE55, 0xF653, 0xEE50, 0xDD4D, 0xDD6C, 0xDD8B, 0xDD6C, 0xEDF7, 0xF678, 0xE616, 
        0xCD32, 0xD5B4, 0xA40D, 0xAC4D, 0xF6B6, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFFE, 0xFFFE, 0xFFBE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDD, 0xF7BC, 0xF75A, 0xF6F9, 0xFFDC, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFFE, 0xFFFE, 0xFFFD, 0xFFDA, 0xFFDC, 0xFFFC, 0xFFFB, 0xFFD9, 0xFFBA, 0xFF9A, 0xFF99, 0xF77A, 0xF79A, 0xF79A, 0xF799, 0xF737, 0xF757, 0xF756, 0xF756, 0xF757, 0xFF57, 0xFF57, 0xF777, 0xFF18, 0xFF37, 0xEE94, 
        0xD5AD, 0xDE92, 0xE6B1, 0xEEB2, 0xF696, 0xF738, 0xF779, 0xF77A, 0xF75A, 0xFFDD, 0xFFDB, 0xFFDA, 0xFFDB, 0xF737, 0xEE55, 0xEE55, 0xF737, 0xFFBE, 0xFFBB, 0xFFBB, 0xFFDE, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFF, 0xFFDF, 0xDEFC, 0x94F6, 0x20E4, 
        0x6287, 0x6287, 0x2923, 0xE715, 0xFFDA, 0xDE74, 0xAC06, 0x83E3, 0x8C85, 0x8CA5, 0x8464, 0x9CEC, 0x9D4B, 0xB5CB, 0xCE4D, 0x9489, 0xA4EC, 0xBD91, 0xD678, 0xEF3C, 0x7AEB, 0x3881, 0x4081, 0x78A3, 0x6882, 0x7082, 0x88E4, 0x9906, 0xA8E7, 0xB0E8, 
        0xB928, 0xC18A, 0xC1AB, 0xD28D, 0xF432, 0xF636, 0xCC90, 0xA32A, 0x82A8, 0x7AC8, 0xA48D, 0xACAD, 0x9328, 0xA3EC, 0xDE57, 0xF6DA, 0xED94, 0xF656, 0xF6B8, 0xFEF9, 0xFF1A, 0xFF9B, 0xFFBB, 0xFFBB, 0xFF9B, 0xFFDB, 0xFFDC, 0xFFDB, 0xFFBB, 0xFFDB, 
        0xFFFC, 0xFF9C, 0xF73A, 0xF7DC, 0xFFFC, 0xFFDB, 0xFFFB, 0xFFDB, 0xFF7A, 0xF6D5, 0xE62F, 0xFF95, 0xF6F5, 0xF6D7, 0xFF9B, 0xFFBA, 0xFF79, 0xFF59, 0xF77A, 0xFF59, 0xF737, 0xF6F5, 0xF6D5, 0xFFDC, 0xFFFE, 0xFFFD, 0xE737, 0x51E4, 0x8348, 0xACCC, 
        0xAD0E, 0xA48D, 0x6A25, 0x4902, 0x6103, 0x7184, 0x8AA8, 0x92C9, 0x8A27, 0x7143, 0x6944, 0x71C7, 0x8209, 0x5842, 0x70A2, 0xAA8A, 0xECF6, 0xD413, 0x9A4C, 0x9A4D, 0xCBD5, 0xA2B9, 0xAAFA, 0xAB3B, 0xA37C, 0xB39A, 0xAB7B, 0xA37B, 0xAB7A, 0xB35A, 
        0xB37A, 0xB37A, 0xAB7A, 0xAB7A, 0xAB7A, 0xAB7B, 0xAB9B, 0xAB7B, 0xAB9B, 0xAB7B, 0xAB7B, 0xAB7B, 0xAB9B, 0xAB9B, 0xAB7B, 0xAB9B, 0xAB7A, 0xAB7A, 0xAB9B,
  0x7A12, 0x7212, 0x7212, 0x7A12, 0x7211, 0x7A12, 0x7A32, 0x7A32, 0x7A12, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A33, 0x7A32, 0x7A33, 0x7A53, 0x7A33, 0x7A32, 0x8232, 0x8232, 0x8232, 0x8232, 0x8232, 0x8232, 0x8232, 0x8253, 0x8253, 0x8253, 
        0x8253, 0x8252, 0x8252, 0x8253, 0x8253, 0x8A53, 0x8A53, 0x8A53, 0x8A53, 0x8253, 0x8253, 0x8253, 0x8273, 0x8252, 0x8253, 0x8A73, 0x8A73, 0x8A73, 0x8274, 0x8A53, 0x9252, 0x7295, 0x7B0F, 0x93EC, 0xB4AC, 0x620E, 0x7A32, 0x61B0, 0x1889, 0x92EF, 
        0xD5B8, 0xF6DB, 0xFE78, 0xFE5B, 0xF61A, 0xF619, 0xFE78, 0xF6D8, 0xF676, 0xF5F6, 0xF5B8, 0xFDB6, 0xF5B5, 0xF595, 0xFD96, 0xFE17, 0xFDF6, 0xF593, 0xED51, 0xFEB4, 0xF714, 0xEF34, 0xF712, 0xFFD5, 0xF793, 0xF732, 0xF6D3, 0xFF35, 0xFF15, 0xEEF4, 
        0xDEB4, 0xEE31, 0xA46B, 0xAD0F, 0xF79D, 0xFFDD, 0xFFDC, 0xFFFC, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFE, 0xFFDE, 0xFFDD, 0xFFBD, 0xFFDD, 0xFFDC, 0xF75A, 0xEED8, 0xFF9B, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDE, 0xFFDC, 0xFFDB, 0xFFFB, 0xFFFC, 0xFFDC, 0xFFBB, 0xFFB9, 0xFF99, 0xFF79, 0xFF7A, 0xFFB9, 0xF799, 0xFFBA, 0xFFBA, 0xFF98, 0xFF99, 0xFF99, 0xFF99, 0xFFB9, 0xFFB9, 0xFFBA, 0xFFB9, 0xFF77, 0xF738, 0xF718, 
        0xF736, 0xDE2E, 0xE66F, 0xEEB2, 0xF6D5, 0xFF58, 0xF77A, 0xFF9B, 0xFFDC, 0xFFDD, 0xFFDC, 0xFFDC, 0xFFDB, 0xEEB5, 0xEE96, 0xF6F8, 0xFF9A, 0xFFFD, 0xFFFD, 0xFFDD, 0xFFDE, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xE73C, 0x31A5, 
        0x3123, 0x30E2, 0x1881, 0x934A, 0xD616, 0xCE35, 0x93E7, 0x8BE1, 0x9484, 0x94C5, 0x8C85, 0xAD69, 0xAD6A, 0x9D4A, 0x9509, 0xA4C9, 0xBD8D, 0xA4AB, 0x72E5, 0xE6FA, 0xB533, 0x6A89, 0x3861, 0x68A3, 0x68C3, 0x68A3, 0x6883, 0x90E5, 0x90C5, 0x98C5, 
        0xA926, 0xB149, 0xB0E8, 0xB867, 0xC908, 0xF6FC, 0xFEDA, 0xE575, 0xBBEF, 0x8247, 0x7A88, 0x832A, 0x9BCB, 0xB48D, 0xDE97, 0xF6FB, 0xF5D7, 0xF6B7, 0xF6B7, 0xFEB7, 0xFF19, 0xFFBC, 0xFFBB, 0xFFBB, 0xFFBB, 0xFFDA, 0xFFDB, 0xFFDB, 0xFFBA, 0xFF9B, 
        0xFFBC, 0xFFDC, 0xFFDC, 0xFFBA, 0xFFBB, 0xFFDB, 0xFFFA, 0xFF9A, 0xFF9A, 0xF716, 0xE631, 0xF772, 0xEED3, 0xEEB5, 0xF717, 0xFF79, 0xFF79, 0xFF59, 0xFF5A, 0xFFBB, 0xFF9A, 0xFF79, 0xFF59, 0xF738, 0xF757, 0xFF9A, 0xFFDE, 0xF73A, 0xCD70, 0xA44A, 
        0x83A9, 0x6A24, 0x71C5, 0x6985, 0x5922, 0x6184, 0x6984, 0x69A5, 0x71C6, 0x89C7, 0x81A7, 0x89A8, 0x99C9, 0x99E7, 0x89C9, 0x7969, 0x7988, 0xD411, 0xDC96, 0xCC17, 0xAB36, 0xA315, 0xAB37, 0xAB59, 0xB37A, 0xA33B, 0xAB5C, 0xAB5B, 0xAB77, 0xB379, 
        0xB37A, 0xB37A, 0xB37A, 0xAB7A, 0xAB7A, 0xAB7B, 0xAB7B, 0xAB7A, 0xAB7A, 0xAB7B, 0xAB7B, 0xAB7B, 0xAB7B, 0xAB7B, 0xAB7B, 0xAB7B, 0xAB7A, 0xAB7A, 0xAB7A,
  0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x8252, 0x7A52, 0x7A32, 0x7A12, 0x7A12, 0x7A32, 0x7A52, 0x8252, 0x8253, 0x8253, 0x8252, 0x8232, 0x8253, 0x8252, 0x8232, 0x7A32, 0x8273, 0x8A73, 0x8A53, 0x8252, 0x8253, 0x8253, 0x8253, 0x8253, 0x8252, 0x8252, 0x8273, 
        0x8273, 0x8273, 0x8253, 0x8273, 0x8A73, 0x8A53, 0x8A53, 0x8253, 0x8253, 0x8A73, 0x8A73, 0x8A73, 0x8A73, 0x8A93, 0x8A93, 0x8A73, 0x8A53, 0x8AB3, 0x8A93, 0x8253, 0x8A52, 0x92D6, 0x9336, 0x724E, 0x2883, 0x5229, 0x7A2D, 0x816C, 0x890A, 0xEEFC, 
        0xFF1E, 0xFEBC, 0xFEBA, 0xFEBB, 0xFE39, 0xFE17, 0xFE15, 0xF5D6, 0xFDD4, 0xFDD4, 0xFDF5, 0xFDD5, 0xFDB5, 0xFD95, 0xFD96, 0xFD95, 0xFD95, 0xFD33, 0xFC91, 0xF4F3, 0xECF1, 0xED52, 0xFE56, 0xFED8, 0xFF7A, 0xFF58, 0xFEF4, 0xFFD6, 0xFFF5, 0xFFF6, 
        0xFFF9, 0xFFB4, 0xFFD8, 0xFFD9, 0xFFB6, 0xF7B5, 0xFFD8, 0xFFFB, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xFFDD, 0xFFBC, 0xFF9B, 0xF759, 0xFF9B, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDD, 0xFFFC, 0xFFFC, 0xFFFC, 0xFFFC, 0xFFFC, 0xFFDB, 0xFFBA, 0xFFBA, 0xFFDA, 0xFFDA, 0xFFBB, 0xFFBA, 0xFFDA, 0xFFFB, 0xFFDB, 0xFFFA, 0xFFFB, 0xFFFC, 0xFFDB, 0xFFFB, 0xFFFC, 0xFFFD, 0xFFFC, 0xFFBA, 0xFFB9, 
        0xFFD9, 0xE691, 0xD62F, 0xDE51, 0xFEF6, 0xFFBC, 0xFFFB, 0xFFFB, 0xFFFB, 0xFFFD, 0xFFFE, 0xFFBD, 0xFF5A, 0xFF39, 0xFF7A, 0xFFDC, 0xFFFE, 0xFFDF, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xEF5D, 
        0x630C, 0x3144, 0x5A47, 0x38A1, 0x59C3, 0xA44D, 0xEF5A, 0xC5E8, 0x9484, 0x8403, 0x9464, 0xA58C, 0xBE2E, 0x8CAA, 0x31E3, 0xCD6E, 0xC5F0, 0xAD0D, 0xA409, 0xCD74, 0xDEB9, 0x9CF2, 0x20A3, 0x78E4, 0x7904, 0x70C4, 0x7083, 0x98E5, 0xA107, 0xA109, 
        0xA92A, 0xB169, 0xB909, 0xA8A7, 0x98E5, 0xEE9A, 0xFF5E, 0xFF7E, 0xFFBC, 0xEDD6, 0xC3EE, 0x92C8, 0x6245, 0x82A9, 0xCDB6, 0xF6BA, 0xED95, 0xFE77, 0xFEB7, 0xFED7, 0xFF17, 0xFF9D, 0xFFDC, 0xFFFC, 0xFFDC, 0xFFBB, 0xFFDB, 0xFFBB, 0xFF5A, 0xFFDC, 
        0xFFDC, 0xFFDD, 0xFFDD, 0xFF9A, 0xFFDB, 0xFF9B, 0xFF39, 0xFFDB, 0xFFBA, 0xFF97, 0xFF53, 0xE64E, 0xEEB4, 0xFEF7, 0xFEF6, 0xFF58, 0xFF39, 0xFF39, 0xFF58, 0xFF38, 0xFF5A, 0xFF7B, 0xFFBB, 0xFF5A, 0xFF7B, 0xFF7A, 0xFF78, 0xFFFE, 0xFFFE, 0xEF39, 
        0xCD6F, 0x49A3, 0x7AC9, 0xC42F, 0xECD1, 0xB40E, 0x9B4B, 0xA2EA, 0xB30C, 0xABAE, 0xB3AE, 0xC3AF, 0xC3D0, 0xAB0E, 0xBB8F, 0xD412, 0xDC34, 0xD3F2, 0xD412, 0xCC32, 0xCC53, 0xEC73, 0xCBF3, 0xB393, 0x9B55, 0xB359, 0xAB7A, 0xB379, 0xB396, 0xB39A, 
        0xB39A, 0xAB9A, 0xAB7B, 0xAB7A, 0xB39B, 0xB39B, 0xAB9B, 0xAB9C, 0xAB9B, 0xAB9B, 0xAB7B, 0xAB9B, 0xAB9C, 0xAB9C, 0xAB9C, 0xAB9B, 0xAB9B, 0xAB9B, 0xAB7B,
  0x7A32, 0x7A32, 0x7A32, 0x7A12, 0x7231, 0x7A12, 0x7A12, 0x7A32, 0x7A52, 0x7A32, 0x7A32, 0x7A32, 0x8273, 0x8253, 0x8233, 0x8232, 0x7A53, 0x7A53, 0x7A53, 0x7A53, 0x9232, 0x8A52, 0x8252, 0x8252, 0x8253, 0x8253, 0x8253, 0x8253, 0x8233, 0x8253, 0x8253, 
        0x8253, 0x8253, 0x8253, 0x8253, 0x8253, 0x8A73, 0x8A53, 0x8A53, 0x8A53, 0x8253, 0x8253, 0x8253, 0x8253, 0x8273, 0x8A73, 0x8273, 0x8273, 0x8274, 0x8273, 0x8A74, 0x8A74, 0x7290, 0x82ED, 0xAC8F, 0xF6F8, 0xFFBE, 0xFFDE, 0xFFDE, 0xFF9E, 0xFCF4, 
        0xFD34, 0xF574, 0xED52, 0xED50, 0xED52, 0xF554, 0xFD74, 0xFDB4, 0xFDF5, 0xFDF5, 0xF5B3, 0xF513, 0xF513, 0xF512, 0xFCF2, 0xFCD2, 0xFCB2, 0xFCB2, 0xF4F4, 0xFCF1, 0xF512, 0xE490, 0xCBAB, 0xD38B, 0xDB8A, 0xE510, 0xF79C, 0xE737, 0xE717, 0xE736, 
        0xEF73, 0xFFD5, 0xFFD5, 0xF7D5, 0xF7D5, 0xF7B3, 0xFFD3, 0xFFF6, 0xFFFB, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFE, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFDE, 0xF7DD, 0xF7BB, 0xF779, 0xFF1A, 0xFF9D, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDC, 0xFFDB, 0xFFFB, 0xFFFD, 0xFFDB, 0xFFDA, 0xFFD9, 0xFFB9, 0xFFB9, 0xFFB9, 0xFF99, 0xFFD9, 0xFFDA, 0xFFDB, 0xFFFB, 0xFFDC, 0xFFDC, 0xFFDC, 0xFFDB, 0xFFDC, 0xFFDC, 0xFFDC, 0xFFDC, 0xFFFC, 0xFFBD, 0xFFBD, 
        0xFFDA, 0xDE90, 0xDE51, 0xEE94, 0xFF58, 0xFF99, 0xFFDB, 0xFFFD, 0xFFFF, 0xF7BE, 0xE636, 0xE636, 0xFFBD, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFDD, 0xFFDE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xFFDE, 0xFFFF, 0xEF7D, 
        0x738C, 0x29A3, 0x3A44, 0x6245, 0x6A26, 0x8AE9, 0xCC6D, 0x9C46, 0x9484, 0x9CA5, 0x9CEA, 0xAD0A, 0xB60C, 0x8D09, 0x3A02, 0x6AA4, 0xA4CC, 0xBDD0, 0xBD91, 0xD511, 0x6A07, 0x3041, 0x3820, 0x60C3, 0x70E3, 0x68C3, 0x58A1, 0x9105, 0xA927, 0xB127, 
        0xB168, 0xF250, 0xF2B1, 0xEA6F, 0xE9ED, 0xE372, 0xF432, 0xFCB3, 0xFD55, 0xFF9E, 0xF73D, 0xCD14, 0x8267, 0xAC0B, 0xDE56, 0xF6DA, 0xEDD6, 0xFEB6, 0xFEB7, 0xFED8, 0xFF5B, 0xFFDC, 0xFFDB, 0xFFBB, 0xFFDC, 0xFFBB, 0xFF9B, 0xFF7B, 0xFF7A, 0xFFDD, 
        0xFFDC, 0xFFBB, 0xFF7A, 0xFFDD, 0xFFDC, 0xFF79, 0xF737, 0xFF9A, 0xFF78, 0xFF79, 0xF79A, 0xD5CC, 0xEE91, 0xF6D3, 0xE673, 0xFEF9, 0xF6D7, 0xF6B6, 0xF6B6, 0xFEB7, 0xFED7, 0xFF17, 0xFF77, 0xFF7B, 0xFF9A, 0xFF7A, 0xFF5A, 0xFF19, 0xFF9A, 0xFFFC, 
        0xFFDE, 0xF6D6, 0xCC2E, 0xAAA9, 0x9AC9, 0xD4B2, 0xD532, 0xCCF1, 0xC430, 0xE491, 0xDC11, 0xCBD0, 0xCBD0, 0xDC71, 0xD430, 0xCC10, 0xCBF1, 0xDC73, 0xE474, 0xE413, 0xE3B3, 0xE452, 0xECD3, 0xECD3, 0xD452, 0xB3F3, 0xABB2, 0xA374, 0x9B59, 0xAB7B, 
        0xAB7B, 0xB39B, 0xB3BB, 0xAB9B, 0xAB7B, 0xAB7B, 0xAB9B, 0xAB7B, 0xAB7B, 0xAB9B, 0xAB7C, 0xAB7B, 0xAB9B, 0xAB9B, 0xAB9B, 0xAB9B, 0xAB7B, 0xAB7B, 0xAB7B,
  0x7212, 0x7212, 0x7211, 0x7A11, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A12, 0x7A12, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A31, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7232, 0x7A32, 0x8232, 0x7A32, 0x8232, 0x8232, 0x8232, 0x8253, 0x8A73, 0x8A53, 0x8233, 
        0x8253, 0x8252, 0x8252, 0x8252, 0x8253, 0x8253, 0x8253, 0x8253, 0x8233, 0x8273, 0x8252, 0x8253, 0x8A74, 0x8272, 0x8272, 0x8273, 0x8A53, 0x8A74, 0x8274, 0x8A53, 0x9272, 0x7A94, 0x6A4F, 0x8B8F, 0xD615, 0xF5F6, 0xDCD2, 0xDC91, 0xECF3, 0xE4B3, 
        0xECF2, 0xED13, 0xE513, 0xECD1, 0xE470, 0xE470, 0xECD0, 0xE44F, 0xDBED, 0xD3ED, 0xCBED, 0xDBED, 0xDC2F, 0xEC91, 0xFCD2, 0xF4D2, 0xF491, 0xE3CE, 0xBACA, 0xD3AB, 0xD3EC, 0xDC6F, 0xF513, 0xF5D4, 0xF71A, 0xEF1B, 0xB535, 0x18A2, 0x0841, 0x5288, 
        0xDE75, 0xFFDD, 0xFFDE, 0xFFBC, 0xFFBB, 0xFFFB, 0xFFDA, 0xFFDB, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFDF, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFE, 0xFFFD, 0xF7BC, 0xF75B, 0xEF39, 0xF79C, 0xFFDE, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFDD, 0xFFDB, 0xFFDB, 0xFFFC, 0xFFBA, 0xFF99, 0xFF9A, 0xFF9A, 0xFF78, 0xFF99, 0xFF99, 0xFF99, 0xFFBA, 0xFFDA, 0xFFDA, 0xFFDA, 0xFFDA, 0xFFDB, 0xFFDB, 0xFFFD, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDB, 0xFFDD, 0xFFBB, 0xFFBC, 
        0xF7BC, 0xCE0A, 0xC60B, 0xD6D0, 0xF7D7, 0xFFDE, 0xF7BE, 0xC659, 0x6BAE, 0x6A45, 0xC594, 0xF7BE, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 
        0xD699, 0x83EE, 0x18A2, 0x49E4, 0x20E2, 0x1021, 0x3104, 0xDE55, 0xAD4B, 0x8423, 0x8422, 0x9588, 0xCEAF, 0xB58D, 0x4A43, 0x28E1, 0x946A, 0xDEF2, 0xEF35, 0x8B69, 0x3123, 0x2861, 0x60C2, 0x6122, 0x68E2, 0x6081, 0x6081, 0x88C5, 0xA0C7, 0xB0C8, 
        0xB928, 0xB96A, 0xB14A, 0xB12A, 0xB96B, 0xE2AD, 0xDA2B, 0xD2AE, 0xE415, 0xDC73, 0xEDD9, 0xFE9C, 0xFE5B, 0xEEB8, 0xF71A, 0xFEFA, 0xF657, 0xF657, 0xF677, 0xFEB7, 0xFF39, 0xFF9A, 0xFFBB, 0xFF9B, 0xFF9B, 0xFFDB, 0xFF59, 0xFF58, 0xFF9A, 0xFFDC, 
        0xFFDC, 0xFFDB, 0xFFDB, 0xFFDB, 0xFF79, 0xFF9A, 0xFFFD, 0xF7B9, 0xD5F3, 0xD593, 0xEE97, 0xC5CD, 0xD64D, 0xE6B1, 0xEE96, 0xFEB7, 0xEEB6, 0xE676, 0xE616, 0xF6B7, 0xF6D7, 0xF6B6, 0xF696, 0xF718, 0xF758, 0xF759, 0xFF39, 0xFF9A, 0xFF7A, 0xFF7A, 
        0xFF9B, 0xFFFE, 0xFFDE, 0xEE99, 0xBC2E, 0x6203, 0x92A9, 0xC3CF, 0xE490, 0xBBCF, 0xCC2F, 0xDCB0, 0xE4F2, 0xCC70, 0xD4B2, 0xD4B1, 0xD450, 0xCC50, 0xCC10, 0xD432, 0xE493, 0xE433, 0xDC33, 0xD433, 0xD433, 0xDC54, 0xCC32, 0xCC53, 0xD455, 0xBB74, 
        0xAB34, 0xA334, 0x9B15, 0xAAF9, 0xB35B, 0xB3BC, 0xB3DD, 0xB39B, 0xB37B, 0xB39B, 0xABBB, 0xB37B, 0xB37A, 0xAB7A, 0xAB79, 0xAB99, 0xAB9A, 0xAB9A, 0xAB7A,
  0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x8252, 0x7A52, 0x7A52, 0x7A32, 0x7A12, 0x7A12, 0x8232, 0x8252, 0x7A72, 0x8253, 0x8253, 0x7A52, 0x7A52, 0x7A52, 0x7A52, 0x7A52, 0x7A52, 0x8253, 0x8252, 0x7A52, 0x8A53, 0x8252, 0x7A52, 0x7A53, 0x8253, 0x8253, 0x8253, 
        0x8253, 0x8253, 0x8273, 0x8A73, 0x8A73, 0x8253, 0x8253, 0x8273, 0x8273, 0x8A73, 0x8A93, 0x8A73, 0x8A54, 0x8A93, 0x8A93, 0x8273, 0x8273, 0x8A73, 0x8A73, 0x8253, 0x8233, 0xA2D4, 0x8B30, 0xA452, 0xEDF7, 0xB471, 0xDCB1, 0xECD1, 0xE491, 0xEC2F, 
        0xDC0E, 0xD3EE, 0xDBED, 0xCBAD, 0xCB6B, 0xCB8B, 0xD3ED, 0xF470, 0xF4B0, 0xF4B0, 0xFCB0, 0xFD95, 0xFD54, 0xEC91, 0xCB6D, 0xD30A, 0xCAE9, 0xDB6B, 0xEC6D, 0xECCF, 0xF5D2, 0xFED7, 0xFF9D, 0xFFBD, 0xDD53, 0x82A8, 0x1041, 0x0861, 0x6B28, 0xBDD2, 
        0xF7BD, 0xFFDC, 0xFFDD, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFDE, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFBD, 0xF738, 0xFF7C, 0xFFDF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFD, 0xFFFC, 0xFFFB, 0xFFFC, 0xFFBA, 0xFF79, 0xFF58, 0xFF58, 0xFF98, 0xFF79, 0xFF9A, 0xFFBB, 0xFFDA, 0xFFFB, 0xFFDC, 0xFFDC, 0xFFF8, 0xFFFA, 0xFFDC, 0xFFDD, 0xFFFC, 0xFFDC, 0xFFDD, 0xFFDD, 0xFFDD, 0xFFDB, 0xFFDB, 
        0xFFDD, 0xDEB1, 0xC689, 0xD6EE, 0xF7DD, 0xEF7D, 0x636D, 0x3185, 0x6AA9, 0xDE33, 0xF77B, 0xFFFE, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 
        0xF79D, 0xA513, 0x2123, 0x7425, 0x6B25, 0x4184, 0x28E3, 0xDE12, 0xCDAD, 0xA4C7, 0x8C24, 0x7543, 0xB6AD, 0xA56D, 0x41C3, 0x4980, 0x6A23, 0x9BEA, 0xE674, 0xEF5B, 0x9BED, 0x5143, 0x3040, 0x7923, 0x7903, 0x70C2, 0x6881, 0x68A2, 0x78E5, 0x9928, 
        0xB169, 0xC169, 0xC98C, 0xC9CD, 0xC1EE, 0xCA6D, 0xDAEF, 0xE2F0, 0xE290, 0xE1EB, 0xD9AA, 0xE310, 0xFDDB, 0xFE9C, 0xFF7E, 0xFFFE, 0xFFFE, 0xFFDD, 0xFF7B, 0xFF3A, 0xFF5A, 0xFFDB, 0xFFDB, 0xFFBC, 0xFFDC, 0xFFBB, 0xFF79, 0xFF99, 0xFFFC, 0xFFDC, 
        0xFFDD, 0xFFFE, 0xFFDD, 0xFF79, 0xFFBC, 0xFFFE, 0xEF7C, 0x93EA, 0xA4AC, 0xCDB2, 0xEE15, 0xC54F, 0xCDCE, 0xDE2F, 0xE693, 0xF718, 0xEEB7, 0xE635, 0xE5D4, 0xF6D6, 0xF6D6, 0xF6B6, 0xFED6, 0xF717, 0xF738, 0xFF38, 0xFF38, 0xFF18, 0xFF38, 0xFF59, 
        0xFF7B, 0xFF9B, 0xFF7A, 0xFFBC, 0xF7BD, 0xC5B1, 0x8226, 0x5881, 0x5922, 0xBBEE, 0x9ACB, 0x9AAA, 0xC3ED, 0xB3CD, 0xB3AD, 0xC40E, 0xCCB1, 0xBBCF, 0xC40E, 0xD44F, 0xEC71, 0xFCB8, 0xF4D5, 0xECD3, 0xECB3, 0xECF4, 0xECF6, 0xF4F7, 0xFD17, 0xED37, 
        0xDCB8, 0xCC18, 0xBB78, 0xAB3B, 0x9B19, 0x9AF6, 0xA2F5, 0xBBBD, 0xB3BC, 0xABDB, 0xB3DC, 0xBBBC, 0xAB9C, 0xA37B, 0xB39B, 0xB39C, 0xAB7A, 0xAB79, 0xABBA,
  0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A12, 0x7A52, 0x7A52, 0x7A52, 0x7A52, 0x7A32, 0x8252, 0x8252, 0x7A52, 0x7A52, 0x7A52, 0x7A52, 0x7A32, 0x7A52, 0x8252, 0x8253, 0x8A53, 0x8252, 0x8252, 0x8253, 0x8253, 0x8253, 0x8253, 0x8253, 
        0x8253, 0x8253, 0x8253, 0x8273, 0x8A73, 0x8A53, 0x8253, 0x8273, 0x8A73, 0x8273, 0x8273, 0x8A73, 0x8A74, 0x8273, 0x8273, 0x8273, 0x8273, 0x8A53, 0x8293, 0x8253, 0x89F2, 0x92D6, 0x7A93, 0x8B54, 0xBD59, 0xEDD4, 0xC38B, 0xB268, 0xBAE9, 0xAAC9, 
        0xC34B, 0xDC0E, 0xEC8F, 0xF490, 0xF4D0, 0xF4F1, 0xF4F3, 0xF4B1, 0xF470, 0xE40D, 0xCB4A, 0xCAEC, 0xB248, 0xBAC9, 0xE44E, 0xFCF1, 0xFD53, 0xFDB4, 0xFDD3, 0xFED6, 0xFF9B, 0xFFFF, 0xEF3C, 0x6163, 0x2860, 0x3A04, 0x7469, 0x3203, 0xA553, 0xF79D, 
        0xFFBE, 0xFFFF, 0xFFFE, 0xFFFD, 0xFFFC, 0xFFD9, 0xFFF6, 0xFFF5, 0xFFD7, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFFE, 0xFFFE, 0xFFFF, 0xFFDE, 0xFFBD, 0xF739, 0xFF9B, 0xFFDD, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFDE, 0xFFDB, 0xFFFC, 0xFFFC, 0xFFBA, 0xFF79, 0xFF57, 0xFF37, 0xFF36, 0xF758, 0xF759, 0xFF79, 0xFFB9, 0xFFDA, 0xFFFA, 0xFFDA, 0xFFDB, 0xFFFE, 0xFFDD, 0xFFDC, 0xFFDC, 0xFFDE, 0xFFDD, 0xFFDC, 0xFFDC, 0xFFDD, 0xFFDB, 0xFFFC, 
        0xF7BC, 0xD62D, 0xD66F, 0xE716, 0xDEFB, 0x2104, 0x4126, 0x93D0, 0xEF3C, 0xDE13, 0xEF1A, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 
        0xFFBE, 0xE679, 0xB3CF, 0x5083, 0x7928, 0x7928, 0x50A2, 0xD42A, 0xB46A, 0x8C46, 0x7C63, 0xBE2F, 0xC5D0, 0x83AA, 0x20E2, 0x8384, 0x82E6, 0x7287, 0x734A, 0xEF5B, 0xE6F6, 0x8C4C, 0x1881, 0x5880, 0x6862, 0x7043, 0x8063, 0xB94A, 0xE26E, 0xE28E, 
        0xC1AC, 0x9888, 0xC9CD, 0xD1EE, 0xA8CA, 0x8845, 0xBA2C, 0xEB52, 0xFB54, 0xFB12, 0xF354, 0xF333, 0xFB52, 0xFEDD, 0xFF1D, 0xFF1D, 0xFF3D, 0xFFBF, 0xFFBD, 0xFF9C, 0xFF7B, 0xFFDB, 0xFFBB, 0xFFBC, 0xFFDD, 0xFF78, 0xFF79, 0xFFBB, 0xFFDD, 0xFFFE, 
        0xFFDD, 0xFFBC, 0xFFDC, 0xFFFC, 0xF7BD, 0xB513, 0x4944, 0x946B, 0xB52F, 0xC551, 0xBD52, 0xCDF1, 0xCDCD, 0xC58C, 0xC58F, 0xF79B, 0xE6B7, 0xDDD3, 0xDD93, 0xEEB4, 0xEE74, 0xEE75, 0xFEB6, 0xF738, 0xF6F7, 0xF6B6, 0xF6B7, 0xF6D7, 0xEEB6, 0xEE95, 
        0xFE95, 0xFF5A, 0xFF5A, 0xFF5A, 0xFF7A, 0xFFDE, 0xEF5B, 0xD5D6, 0xB38D, 0x8163, 0xAAEA, 0x9ACB, 0x58E4, 0x92A8, 0xA30A, 0x9ACA, 0x8A68, 0xCC0E, 0xC3EE, 0xBBCE, 0xC3EF, 0xCC12, 0xCBF2, 0xDC13, 0xE4B5, 0xF4B3, 0xF4F3, 0xF4F4, 0xF4D4, 0xFD56, 
        0xFDB8, 0xFDB9, 0xFD79, 0xFD78, 0xECF8, 0xD459, 0xAB99, 0x8A93, 0x92B6, 0xA2DB, 0xAAFE, 0xB39D, 0xBBDC, 0xBBBB, 0xB35B, 0xB3BC, 0xB39D, 0xB39D, 0xB37B,
  0x7212, 0x7212, 0x7212, 0x7212, 0x7231, 0x7232, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A52, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x8232, 0x8232, 0x8232, 0x8232, 0x8233, 0x8253, 0x8233, 0x8A53, 0x8253, 
        0x8252, 0x8252, 0x8252, 0x8252, 0x8253, 0x8253, 0x8253, 0x8A73, 0x8A73, 0x8253, 0x8253, 0x8253, 0x8252, 0x8273, 0x8273, 0x8273, 0x8A53, 0x8A73, 0x8274, 0x8253, 0x8A12, 0x8A92, 0x7AAF, 0x7ACC, 0x938C, 0xEF1B, 0xCC8F, 0xAA87, 0xA246, 0xD3AD, 
        0xD3CD, 0xCBCD, 0xD3ED, 0xCB4A, 0xC309, 0xCB09, 0xCB2A, 0xC2EA, 0xD34B, 0xE3CD, 0xEC8E, 0xE4B0, 0xF4F2, 0xFD54, 0xFDD5, 0xFED7, 0xFE75, 0xFEB7, 0xFF9B, 0xFFFE, 0xF77C, 0xA4D2, 0x20C2, 0x2982, 0x6368, 0x5B07, 0x2944, 0xD716, 0xF7FD, 0xFFFF, 
        0xFFDF, 0xFF9C, 0xFFB7, 0xFFB6, 0xFFB8, 0xFFB6, 0xFFD5, 0xFFF5, 0xFFD6, 0xF7BC, 0xF7DE, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFFE, 0xFFFF, 0xFFDE, 0xFFDD, 0xFFBC, 0xEF1A, 0xF77C, 0xFFDE, 0xFFFF, 0xFFDF, 
        0xFFDE, 0xF7BC, 0xFF9A, 0xFFFE, 0xFFDE, 0xFFBB, 0xF778, 0xF797, 0xF758, 0xF758, 0xF778, 0xF739, 0xF759, 0xFF7A, 0xFF9A, 0xFFB9, 0xFFDA, 0xFFDB, 0xFFDC, 0xFFDB, 0xFFDC, 0xFFDC, 0xFFDC, 0xFFDB, 0xFFFC, 0xFFDD, 0xFFBD, 0xFFBC, 0xFFDD, 0xFFFE, 
        0xFFDE, 0xF754, 0xEF71, 0xB58C, 0x51E5, 0x3041, 0x7166, 0xBC11, 0xF73C, 0xF5B4, 0xF6F9, 0xFFDD, 0xFFBE, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFBE, 
        0xFFDE, 0xDF1A, 0xA510, 0x18A2, 0x30A2, 0x40A2, 0x3862, 0x8AA5, 0xAB89, 0x9BE8, 0x7C44, 0xDEEF, 0x5AE7, 0x0841, 0x18E3, 0xCE79, 0x6B0C, 0x20A2, 0x3164, 0xC54B, 0xE6D6, 0x9CF3, 0x18A2, 0x3820, 0x60E2, 0x8924, 0x98A5, 0x8904, 0xB28B, 0xCAAD, 
        0xC1EC, 0xDAD0, 0xDA6F, 0xC1AC, 0xA8C8, 0xDAB0, 0xF3B4, 0xF393, 0xE28F, 0xFBD5, 0xF3B5, 0xEB74, 0xEBB5, 0xFE1A, 0xFE5B, 0xFE9C, 0xFF1E, 0xFF5E, 0xFF9E, 0xFFBD, 0xFFBC, 0xFFDA, 0xFFBB, 0xFFBB, 0xFFDB, 0xFF78, 0xFF99, 0xFFDB, 0xFFFE, 0xFFBE, 
        0xFFBD, 0xFFDC, 0xFFFA, 0xEF7C, 0x83AE, 0x3104, 0x1040, 0x39C0, 0x4242, 0x4A65, 0x5245, 0x49E4, 0xAD52, 0xA531, 0x41C4, 0x73AF, 0xCE59, 0xE6D9, 0xCD72, 0xE5B2, 0xEE55, 0xEE95, 0xE694, 0xF6D7, 0xEE96, 0xE656, 0xDE35, 0xDE56, 0xE636, 0xE635, 
        0xDE15, 0xFEF8, 0xFF5A, 0xFF5A, 0xF739, 0xFF19, 0xFF9C, 0xFFFE, 0xEF7D, 0x9BAE, 0xBCD1, 0xE656, 0xE699, 0x4904, 0x6165, 0x8268, 0x9AA9, 0xAB2C, 0xAB0B, 0xA2C9, 0x9A69, 0x99E9, 0xAA8A, 0xAAA9, 0x9A67, 0xB2E9, 0xB32B, 0xBB4C, 0xBB4C, 0xCC11, 
        0xDC52, 0xEC72, 0xF4B2, 0xFD39, 0xFDFB, 0xFE5D, 0xFE7E, 0xEDFE, 0xD51B, 0xC438, 0xB335, 0x92B4, 0x9AB8, 0xAB1A, 0xB39B, 0xB39A, 0xAB99, 0xAB9A, 0xAB7B,
  0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x8232, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A52, 0x7A52, 0x8252, 0x7A52, 0x8252, 0x8252, 0x7A52, 0x7A52, 0x7A52, 0x7A52, 0x7A32, 0x7A52, 0x8252, 0x8253, 0x8A33, 0x8253, 0x8253, 0x8253, 0x8253, 0x8253, 0x8253, 0x8252, 
        0x8253, 0x8253, 0x8A73, 0x8A73, 0x8293, 0x8A33, 0x8253, 0x8273, 0x8A73, 0x8273, 0x8A73, 0x8A73, 0x8273, 0x8A93, 0x8293, 0x8273, 0x8273, 0x8A73, 0x8A93, 0x8A73, 0x89F2, 0x9295, 0x8AF7, 0x7AB5, 0x82B1, 0xEEFB, 0xD48F, 0xC308, 0xCB2A, 0xCB6C, 
        0xCB6C, 0xCBAC, 0xDC0C, 0xE3ED, 0xEC0D, 0xF46F, 0xF4F2, 0xF4F2, 0xF4B1, 0xFCD1, 0xFD73, 0xFE16, 0xFEB8, 0xFEB7, 0xFE15, 0xFEB5, 0xFF79, 0xFFFC, 0xFFBD, 0xE5D3, 0x6247, 0x20E2, 0x4A25, 0x744A, 0x3A05, 0x31A6, 0x842F, 0xEF9D, 0xFFFF, 0xFFDF, 
        0xFF7D, 0xF756, 0xF793, 0xF7D4, 0xF7D7, 0xFFF5, 0xFFB5, 0xF796, 0xFF98, 0xF75C, 0xF79E, 0xFFDF, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFFE, 0xFFBC, 0xF759, 0xF759, 0xFF9B, 0xFFFF, 0xFFDF, 
        0xFFDE, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFDC, 0xF779, 0xFF58, 0xFF59, 0xFF5A, 0xFF7B, 0xFFBA, 0xFFB9, 0xFFDA, 0xFFFC, 0xFFDC, 0xFFDD, 0xFFDC, 0xFFDB, 0xFFBC, 0xFFDD, 0xFFDE, 0xFFBE, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF7BE, 0xAD76, 
        0x424A, 0xE737, 0xE753, 0x94AA, 0x20A1, 0x5862, 0x3082, 0x62EC, 0xEF5C, 0xFF39, 0xFF5B, 0xFF9D, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFDE, 0xFFDD, 0xE71A, 0x2924, 0x59C7, 0x7A28, 0x6123, 0x6102, 0x9BAA, 0xBD4E, 0xB54A, 0x7345, 0x3942, 0x1020, 0x20E3, 0xD699, 0x8BCC, 0x3122, 0x0820, 0x1061, 0x7B4A, 0xCDF4, 0xDEDA, 0x2904, 0x60E4, 0xA1A7, 0xB1E7, 0x9085, 0xCACF, 0xF3B4, 
        0xE2AF, 0x8145, 0xB1CC, 0xEA91, 0xF2F1, 0xDB53, 0xD270, 0xDAF1, 0xF4B6, 0xF3F5, 0xFC97, 0xF4D7, 0xF475, 0xFD39, 0xFDFB, 0xFE9D, 0xFF1F, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDD, 0xFFDD, 0xFFDD, 0xFFFC, 0xFFDB, 0xFFFC, 0xFFFD, 0xFFFF, 0xFFDE, 
        0xFFDD, 0xFFFE, 0xFFFE, 0xEF18, 0x62E9, 0x41A3, 0x7B25, 0x4223, 0x4202, 0x41C1, 0x2902, 0x18A3, 0x9CD2, 0xAD33, 0x39A4, 0x0861, 0x39E9, 0x8C71, 0xEF57, 0xFFDC, 0xF696, 0xEE33, 0xEE75, 0xF6B7, 0xEEB7, 0xE675, 0xDE14, 0xE615, 0xDDF4, 0xD5D4, 
        0xD5D4, 0xF6F8, 0xFF17, 0xFF18, 0xF73B, 0xFF57, 0xFF3A, 0xFF3B, 0xFF7C, 0xFFFD, 0xFFFE, 0xFFBE, 0xF71B, 0xCD92, 0xCC4F, 0xBB2B, 0x9248, 0x71C5, 0x92CA, 0xB3CE, 0xCC71, 0xE4B2, 0xD471, 0xD3EF, 0xD32B, 0xAB4C, 0xAB0A, 0xAAEA, 0xAAEB, 0xAAE9, 
        0xAACB, 0xAAAB, 0xA2AA, 0xB30B, 0xB32D, 0xB370, 0xB432, 0xDD57, 0xEDD8, 0xF63B, 0xF63E, 0xD4DC, 0xAB7A, 0x9AD9, 0xAB1A, 0xAB9B, 0xAB9A, 0xAB9A, 0xAB9A,
  0x7A31, 0x7A32, 0x7A32, 0x7A32, 0x8252, 0x7A32, 0x7A32, 0x7A52, 0x8252, 0x8252, 0x7A52, 0x8253, 0x8252, 0x8252, 0x8252, 0x7A52, 0x7A52, 0x7A52, 0x7A52, 0x7A52, 0x7A52, 0x8253, 0x8253, 0x8253, 0x8273, 0x8253, 0x8253, 0x8253, 0x8253, 0x8252, 0x8252, 
        0x8A73, 0x8273, 0x8253, 0x8253, 0x8A73, 0x7A53, 0x8253, 0x8273, 0x8A73, 0x8A73, 0x8A73, 0x8A73, 0x8A73, 0x8293, 0x8A73, 0x8A73, 0x8273, 0x8A73, 0x8253, 0x8A74, 0x92D5, 0x824F, 0x7A4D, 0x8A8E, 0xB372, 0xF6B9, 0xFF1A, 0xEDD5, 0xDBCD, 0xE42D, 
        0xE48F, 0xE4D1, 0xF512, 0xFD30, 0xFD50, 0xFD51, 0xFD52, 0xFE15, 0xFE15, 0xFE36, 0xFE77, 0xFE56, 0xFE76, 0xFE56, 0xFE57, 0xFFDE, 0xF7BE, 0xAD34, 0x28E2, 0x0861, 0x5287, 0x7C0A, 0x7C4A, 0x5B46, 0x31C3, 0x6B4C, 0xEF7D, 0xFFFE, 0xFFBC, 0xF737, 
        0xEEB0, 0xF7D6, 0xF7F6, 0xFFD5, 0xFFB5, 0xF79D, 0xFFDE, 0xFFBD, 0xFF7D, 0xFFFE, 0xFFFE, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDE, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xFFBC, 0xF718, 0xFF5B, 0xFF9D, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFBD, 0xF73A, 0xFF9B, 0xFFBC, 0xFFDC, 0xFFFC, 0xFFFB, 0xFFDB, 0xFFDB, 0xFFDC, 0xFFDA, 0xFFDC, 0xFFDD, 0xFFDE, 0xFFFD, 0xFFFE, 0xFFFE, 0xFFFD, 0xF7BD, 0xB532, 0x5A88, 0x20E3, 0xB492, 0x6208, 0x2041, 
        0x1882, 0xBC2F, 0xE658, 0x9CF3, 0x20E4, 0x7AAB, 0x4945, 0x40C1, 0x8A44, 0xEF3B, 0xF6FA, 0xF6FA, 0xFFBE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 
        0xFF9F, 0xFF9F, 0xE71B, 0x3144, 0x61A8, 0x8A4C, 0x79EB, 0x40A3, 0xA36B, 0xD5B0, 0xBE0C, 0x20E1, 0x40C0, 0x40C0, 0x2103, 0xCE79, 0x6AEB, 0x28A1, 0x38C0, 0x0820, 0x0841, 0x5AEB, 0xDEFA, 0x93EA, 0x61A3, 0x5881, 0x88C3, 0xEB90, 0xF3D3, 0xEB32, 
        0xC9EE, 0x90E6, 0xCA6C, 0xEB52, 0xE333, 0xC1EC, 0xA16A, 0xB2AE, 0xF517, 0xFC14, 0xFC76, 0xFCB9, 0xFCFA, 0xFE7C, 0xFF3E, 0xFF9F, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFDF, 0xFFDE, 0xFFFE, 0xFFDE, 0xFFFE, 0xFFFE, 0xFFFF, 0xFFFF, 
        0xFFDE, 0xFFDE, 0xE71B, 0x2104, 0x2922, 0x41C3, 0x4224, 0x4A63, 0x4264, 0x4A65, 0x5266, 0x2942, 0xA4CC, 0xDE70, 0xA50C, 0x10E1, 0x0020, 0x1040, 0x3122, 0xBD51, 0xEF18, 0xFFDC, 0xF7BD, 0xCD73, 0xD593, 0xDDB4, 0xDD94, 0xDDD4, 0xD593, 0xD573, 
        0xD5B3, 0xF6B6, 0xFEF8, 0xFEF8, 0xFED7, 0xFF18, 0xFF78, 0xFF78, 0xF739, 0xFF39, 0xFF38, 0xFF39, 0xFF7B, 0xFFDE, 0xFFBC, 0xDEF9, 0xB5B5, 0xBC4E, 0xAB2B, 0x8A27, 0x7183, 0x81C4, 0x79A4, 0x9268, 0xCBF0, 0xD40C, 0xD3EE, 0xCBCF, 0xCBAF, 0xBB8D, 
        0xCBCD, 0xD3EE, 0xE3F0, 0xE450, 0xE470, 0xE46F, 0xDC6F, 0xE472, 0xE4D2, 0xE513, 0xED55, 0xFE5B, 0xFF3E, 0xE67B, 0xC437, 0x9B1C, 0xAB5E, 0xB39D, 0xAB9A,
  0x7212, 0x7212, 0x7212, 0x7212, 0x7232, 0x7232, 0x7A32, 0x7A32, 0x7232, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x8232, 0x8232, 0x8232, 0x8232, 0x8233, 0x8233, 0x8253, 0x8253, 0x7A53, 
        0x6A33, 0x8A73, 0x8A72, 0x8252, 0x8253, 0x8A53, 0x8A53, 0x8A53, 0x8A53, 0x8253, 0x8253, 0x8253, 0x8253, 0x8273, 0x8273, 0x8273, 0x8A73, 0x8274, 0x8A74, 0x8A73, 0x8252, 0x9253, 0x69D1, 0x722F, 0xABD0, 0xF6DB, 0xFE98, 0xF573, 0xE42E, 0xF573, 
        0xF573, 0xF573, 0xF5D3, 0xFE74, 0xFE53, 0xFE13, 0xFDF4, 0xFE34, 0xFE76, 0xFE96, 0xFE56, 0xFE77, 0xFEB8, 0xFF3B, 0xFFBD, 0xD592, 0x5A27, 0x20A1, 0x3161, 0x7C0B, 0x8C8D, 0x7C4B, 0x5347, 0x1903, 0xA512, 0xF7BC, 0xFFFF, 0xFFDE, 0xE6D5, 0xE6D2, 
        0xEFB5, 0xF797, 0xF778, 0xF778, 0xF799, 0xF75A, 0xF77C, 0xF79D, 0xF7BD, 0xFFFC, 0xFFDC, 0xFFDC, 0xFFFE, 0xFFFF, 0xFFDE, 0xFFDE, 0xFFDF, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFBE, 0xFFDF, 0xFFDE, 0xFFFD, 0xF7DB, 0xE6D8, 0xE696, 0xEF18, 0xFFDE, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFE, 0xFFFE, 0xFFDE, 0xFFFE, 0xFFDE, 0xFFFD, 0xFFDD, 0xFFDD, 0xF7BE, 0xF7DE, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xEF1C, 0x5944, 0x2881, 0x38A3, 0x60E4, 0x4082, 0x4883, 0x4862, 
        0x48A2, 0xD531, 0xEED5, 0xB54F, 0x51C3, 0x71C8, 0x38E4, 0x49A5, 0xAC4C, 0xD694, 0xEF5B, 0xFFBE, 0xFFBE, 0xFFDE, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFDE, 0xFF9E, 
        0xFFBE, 0xFFDD, 0xE71A, 0x2103, 0x40A2, 0x5924, 0x5126, 0x3882, 0x8B29, 0xB4AC, 0x9429, 0x40A1, 0x5923, 0x4923, 0x28E3, 0xD634, 0x7B69, 0x41A3, 0x49A5, 0x4142, 0x20A1, 0x41A5, 0xAC6F, 0xEF1B, 0x9BAC, 0x4901, 0x38A2, 0xD3D2, 0x99E9, 0x9948, 
        0xEAD3, 0xE392, 0xBA6D, 0xC26F, 0xF394, 0xD351, 0xD391, 0xE3F3, 0xF454, 0xEBB3, 0xF416, 0xFC78, 0xFD1A, 0xFF9E, 0xFFDF, 0xFFBF, 0xFF7D, 0xFF1C, 0xFF9E, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xF7BE, 0xB574, 0x4182, 0x1061, 0x4205, 0x4A65, 0x2121, 0x31E3, 0x39E3, 0x39E3, 0x39A2, 0x18A1, 0x9429, 0xD66F, 0xBE10, 0x20E2, 0x3183, 0x31C3, 0x10E1, 0x1881, 0x6289, 0xACD1, 0xE6B6, 0xFFBC, 0xEEB8, 0xD5D4, 0xC551, 0xD532, 0xCD52, 0xCD53, 
        0xCD73, 0xF656, 0xF6B7, 0xF6D8, 0xEEB7, 0xF6D7, 0xF717, 0xF737, 0xF717, 0xF739, 0xF739, 0xF718, 0xF6F7, 0xF6F7, 0xFF9B, 0xFFFD, 0xFFFE, 0xFFDE, 0xDE78, 0xC554, 0xB491, 0xB42D, 0xB36B, 0x9AA9, 0x71E7, 0x9A89, 0x8A48, 0x8227, 0x9267, 0x9AAB, 
        0x9AAB, 0xA2A8, 0xA2C6, 0xA2CD, 0xAB0D, 0xB34C, 0xB38B, 0xAB8B, 0xB3AC, 0xBBCD, 0xB3CD, 0xBBAE, 0xC430, 0xD513, 0xDE36, 0xC4D5, 0xABD3, 0xA375, 0xAB79,
  0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A52, 0x7A52, 0x8252, 0x7A52, 0x7A52, 0x7A52, 0x7A52, 0x7A52, 0x7A32, 0x7A52, 0x8252, 0x8253, 0x8233, 0x8252, 0x8253, 0x8253, 0x8A53, 0x8253, 0x8253, 0x8273, 
        0x7A73, 0x8252, 0x8A52, 0x8253, 0x8253, 0x8253, 0x8273, 0x8273, 0x8A73, 0x8273, 0x8273, 0x8A73, 0x8273, 0x8A73, 0x8A73, 0x8273, 0x8273, 0x8A74, 0x7A33, 0x8A73, 0xB336, 0x8AB2, 0x61AD, 0x61AD, 0x9B11, 0xF5B5, 0xFDB4, 0xFDB5, 0xFE17, 0xFED9, 
        0xFF1A, 0xFF3B, 0xFF3C, 0xFEFA, 0xFED8, 0xFEB6, 0xFE95, 0xFE79, 0xFEFA, 0xFF1A, 0xFEFA, 0xFFDD, 0xFFDE, 0xD677, 0x8BAB, 0x30C2, 0x4A05, 0x7349, 0x940C, 0x94EE, 0x6BA8, 0x39E3, 0x18C2, 0x8C31, 0xD6BA, 0xFFDF, 0xFFDE, 0xF6B6, 0xE6D1, 0xE751, 
        0xFFD6, 0xF757, 0xF71B, 0xF71C, 0xF73A, 0xFFDB, 0xFFDB, 0xFFBB, 0xFFDA, 0xFFD7, 0xFFF9, 0xFFBA, 0xFF7A, 0xF77A, 0xFFDD, 0xFFFF, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xF7BC, 0xF77B, 0xF77B, 0xFF79, 0xFF99, 0xF7BD, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xFFDE, 0xFFFE, 0xFFFF, 0xEF7D, 0x734C, 0x41E7, 0x6B8F, 0x6B8E, 0x6B8E, 0x6B6D, 0x52CA, 0x1082, 0x5965, 0x8A08, 0x91E9, 0x9208, 0x920A, 0x8968, 
        0x7043, 0x5163, 0xB553, 0xE738, 0xC5F0, 0x20C2, 0x1841, 0x6AEB, 0xD679, 0x3186, 0xA514, 0xF7BE, 0xFFFF, 0xFFBE, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFDD, 0xFFDE, 
        0xF77D, 0xF77D, 0xE73C, 0x5A67, 0x20C2, 0x30A3, 0x7125, 0x6882, 0x9309, 0x9C6B, 0x7BE5, 0x40A2, 0x7187, 0x89C7, 0x6901, 0x1881, 0x6327, 0x7BEA, 0x5248, 0x5062, 0x4861, 0x3060, 0x1882, 0xA470, 0xDE34, 0xDE55, 0xAD13, 0xB209, 0x8906, 0x9989, 
        0xDAAF, 0xA9EA, 0x80E5, 0x99A9, 0xF3F5, 0xF454, 0xF475, 0xEC34, 0xE3D2, 0xFCF8, 0xFE7D, 0xFF9F, 0xFFFF, 0xFFDF, 0xFF3D, 0xFEFC, 0xFF1D, 0xFF9D, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xF7DF, 0xCE9A, 0x7431, 0x1082, 0x10C1, 0x29A3, 0x4A65, 0x2103, 0x2924, 0x39E6, 0x52A6, 0x18A1, 0x62C6, 0xB56E, 0xDED3, 0x2103, 0x2182, 0x4AC5, 0x6388, 0x10E1, 0x0840, 0x0820, 0x1862, 0x6B6F, 0xC5D5, 0xF75A, 0xFFDE, 0xFF7A, 0xDDD4, 0xCCF1, 
        0xCD10, 0xF655, 0xF6B6, 0xFED7, 0xFEF8, 0xFED8, 0xF6D6, 0xF6D6, 0xFF18, 0xFF37, 0xFF58, 0xFF79, 0xF77A, 0xFF37, 0xFF38, 0xFF38, 0xFF38, 0xFF39, 0xFF9C, 0xEED9, 0xDD93, 0xFF5D, 0xFFBE, 0xF6BA, 0xDC93, 0xA34C, 0xB36E, 0xBBCF, 0xBBF0, 0xB32D, 
        0xBB2B, 0xBB2B, 0xAB0C, 0xA2CC, 0xA2AB, 0xA2CB, 0xAAEB, 0xAB0B, 0xAB6D, 0xB36D, 0xBB2D, 0xCC2F, 0xD44F, 0xE4B2, 0xED57, 0xB477, 0xABB9, 0xAB5A, 0xAB5B,
  0x7A31, 0x7A32, 0x7A32, 0x7A32, 0x8252, 0x7A52, 0x7A31, 0x7A31, 0x7A52, 0x7A32, 0x7A32, 0x7A52, 0x8252, 0x8252, 0x8252, 0x7A52, 0x8252, 0x8233, 0x8233, 0x7A52, 0x8233, 0x8A53, 0x8A72, 0x8252, 0x8A53, 0x8253, 0x8272, 0x8253, 0x8253, 0x8253, 0x8A53, 
        0x8A53, 0x8A93, 0x8A93, 0x8A73, 0x8A73, 0x8253, 0x8273, 0x8273, 0x8A73, 0x8A93, 0x8A94, 0x8A94, 0x8A73, 0x8293, 0x8273, 0x8A93, 0x9293, 0x8272, 0x7A72, 0x92F5, 0xAB38, 0x28AA, 0x69CE, 0xB477, 0xF79E, 0xFFFF, 0xFFDE, 0xFFDE, 0xFFDE, 0xFEFA, 
        0xFF1C, 0xFF3D, 0xFF1D, 0xFEB9, 0xFE9B, 0xFEBC, 0xFEFD, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFBE, 0xD616, 0x83AC, 0x4A05, 0x39A3, 0x7C0B, 0x7C2C, 0x8C4D, 0x8C6E, 0x18E2, 0x1061, 0x62EB, 0xEF5D, 0xFFFF, 0xFFFE, 0xFFFE, 0xF7BC, 0xC5AA, 0xE6F2, 0xF798, 
        0xF73B, 0xFF5C, 0xFF3C, 0xFF3C, 0xFF7B, 0xF759, 0xF7BC, 0xFFFB, 0xFFD7, 0xFFD8, 0xFFFA, 0xFFF9, 0xFFF8, 0xFFFE, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFDF, 0xFFBD, 0xFFBC, 0xFFBC, 0xFF7B, 0xFFBD, 0xFFFF, 0xFFFE, 0xF7BE, 0xD635, 0xD635, 0xF7BE, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFDE, 0xFFBE, 0xFFDE, 0xFFFD, 0xEF7D, 0x73CF, 0x2925, 0x1820, 0x1000, 0x1000, 0x1800, 0x3020, 0x50C4, 0x5084, 0x4063, 0x30A1, 0x4883, 0x48C3, 0x5906, 
        0x712A, 0x20C3, 0xA511, 0xF7BC, 0xE71B, 0x3185, 0x9CD0, 0xC570, 0x7263, 0x31C6, 0xA575, 0xF7BE, 0xFFDF, 0xFFDE, 0xFFDF, 0xFFFF, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFDE, 0xFFDD, 0xFFDC, 
        0xF77A, 0xF77A, 0xFFDD, 0xEEF9, 0x6ACA, 0x38A2, 0x6924, 0x8207, 0x9229, 0x8A69, 0x7A67, 0x79A6, 0x7165, 0x7145, 0x6924, 0x2041, 0x51A6, 0x7AE9, 0x7369, 0x1882, 0x4904, 0x6945, 0x6082, 0x2061, 0x930B, 0xE553, 0xF637, 0xCBAB, 0xCC0C, 0xDCEE, 
        0xF590, 0xD2AE, 0xEB73, 0xFC76, 0xFD17, 0xFDFB, 0xFE3C, 0xFE7D, 0xFEBF, 0xFF1E, 0xE619, 0xC535, 0x9C11, 0x8248, 0xCD95, 0xF79D, 0xFF9D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 
        0xFF5B, 0xFF5B, 0xF79C, 0x94D0, 0x4A26, 0x20A2, 0x28C4, 0x5A66, 0x39E4, 0x1942, 0x1901, 0x49E1, 0x5A84, 0x948F, 0xD6BA, 0x2104, 0x2121, 0x29A2, 0x2981, 0x1921, 0x31A1, 0x31C2, 0x1902, 0x0840, 0x20E1, 0x4204, 0x6B28, 0x9C8F, 0xC593, 0xE696, 
        0xFF59, 0xFF7A, 0xFF3A, 0xFF19, 0xFEF7, 0xF657, 0xF697, 0xF6D6, 0xF6B5, 0xFE96, 0xFF38, 0xFF9A, 0xFF7A, 0xFF36, 0xF6D4, 0xFF15, 0xFFB9, 0xFF98, 0xFFBA, 0xD654, 0x93A9, 0x7B07, 0xC593, 0xF75C, 0xEF1B, 0x7166, 0xB390, 0xCC94, 0xB38F, 0xCC71, 
        0xC412, 0xC3D3, 0xC414, 0xD3D0, 0xD3F0, 0xCBF0, 0xC3F0, 0xCC0F, 0xCC4F, 0xD471, 0xE452, 0xEC94, 0xDCB3, 0xC492, 0xAC93, 0xD4F2, 0xC476, 0xB3DB, 0xAB5F,
  0x7212, 0x7212, 0x7212, 0x7212, 0x7232, 0x7232, 0x7212, 0x79F2, 0x7232, 0x7232, 0x7232, 0x7232, 0x7A31, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A52, 0x7252, 0x7232, 0x8A52, 0x7A32, 0x7232, 0x7A53, 0x7A51, 0x7A53, 0x7A53, 0x7A53, 0x7253, 0x7A53, 0x8253, 
        0x8233, 0x8253, 0x8253, 0x8253, 0x8253, 0x8A53, 0x8A53, 0x8A53, 0x8A53, 0x8253, 0x8252, 0x8252, 0x8A53, 0x8273, 0x8273, 0x8A54, 0x8234, 0x8232, 0x9B35, 0x7271, 0x20C8, 0xA3D6, 0xE67C, 0xFFBF, 0xFF9F, 0xFFDF, 0xFFBF, 0xFF9F, 0xFF5E, 0xEDBA, 
        0xED58, 0xF578, 0xF5D9, 0xF5B8, 0xED97, 0xF5D7, 0xFE39, 0xFDD6, 0xDD74, 0xB4B0, 0x8B6A, 0x5247, 0x5AC8, 0x6349, 0x6BAA, 0x6B88, 0x840B, 0x62E8, 0x1081, 0x3186, 0xAD75, 0xF7BE, 0xFFFF, 0xFFBB, 0xFFDD, 0xEF19, 0xDE11, 0xE731, 0xF796, 0xF77B, 
        0xF71C, 0xF71A, 0xF71B, 0xF73C, 0xF75D, 0xFFD7, 0xF7D5, 0xF7D6, 0xF7D9, 0xFFFE, 0xFFFF, 0xF7DE, 0xEF7B, 0xD6FA, 0xEF9D, 0xFFFF, 0xFFFF, 0xFFFF, 0xF77C, 0xF739, 0xFF58, 0xFF9B, 0xE6F9, 0xE6F9, 0xE718, 0x5285, 0x9C6C, 0xDE76, 0xFFDE, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFBE, 0xFFDC, 0xFFBD, 0xFF7D, 0xF75C, 0xF7BE, 0xCE58, 0x7BAE, 0x1882, 0x5923, 0x48E3, 0x38A2, 0x40E2, 0x4063, 0x4084, 0x38C3, 0x28E1, 0x4862, 0x3821, 0x3842, 
        0x4065, 0x18A3, 0x9CF1, 0xDE56, 0xB48F, 0xA34B, 0xCD6E, 0x9C6B, 0x1081, 0x10A2, 0xA513, 0xF77E, 0xFF9E, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFDD, 0xFFBB, 0xFFBB, 
        0xFFBB, 0xFFBC, 0xFFDD, 0xEF5C, 0x630C, 0x30E3, 0x6164, 0x5881, 0x81A8, 0xA2AC, 0xA2CC, 0x60C4, 0x6123, 0x6964, 0x6105, 0x4043, 0x6166, 0x7268, 0x6AE7, 0x1081, 0x38A1, 0x5082, 0x5822, 0x6125, 0x7125, 0x7103, 0x68E2, 0x7A88, 0xCCCF, 0xE591, 
        0xCCAE, 0xF53A, 0xFD7B, 0xFD9A, 0xFD9A, 0xF537, 0xED38, 0xC495, 0x8B4E, 0x936F, 0x69E9, 0x38C4, 0x1841, 0x8A66, 0xD5D5, 0xFF9D, 0xFF7D, 0xFF7D, 0xFFBE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF7DD, 
        0xF6D8, 0xF6D8, 0xFF9C, 0xDDB5, 0x6268, 0x18A1, 0x1080, 0x2963, 0x2962, 0x31A3, 0x4225, 0x4A43, 0x5A86, 0x946F, 0xD6BA, 0x2104, 0x29A1, 0x3A21, 0x31C0, 0x39E3, 0x2981, 0x29A2, 0x3A25, 0x31A3, 0x28E1, 0x1880, 0x0860, 0x4163, 0x62A8, 0x7BCD, 
        0x9C90, 0xB510, 0xD5B3, 0xD5B4, 0xB532, 0xACD0, 0xDE56, 0xEE77, 0xD552, 0xDE15, 0xDDD4, 0xE5D3, 0xF635, 0xFFBE, 0xFFFE, 0xF73A, 0xE5D2, 0x9CAE, 0xA4CE, 0xB50E, 0xB54E, 0xB54E, 0x9B69, 0xAC2E, 0xE6BA, 0x7164, 0x6966, 0x8A8B, 0xC3CE, 0xBB4D, 
        0xB2EF, 0xAAAF, 0xAAAE, 0xB36D, 0xB36F, 0xAB10, 0xA2D2, 0xC394, 0xB372, 0xAB50, 0xAB72, 0xC3B6, 0xBB56, 0xBB17, 0xBB38, 0xA396, 0xA3B8, 0xAB9A, 0xA37C,
  0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A11, 0x7A52, 0x7A52, 0x7A52, 0x7A32, 0x7A52, 0x7A52, 0x7A52, 0x7A52, 0x7A52, 0x7A32, 0x8232, 0x8A52, 0x8252, 0x7A53, 0x7A52, 0x8252, 0x8253, 0x7A53, 0x7A53, 0x7A53, 0x7A53, 0x7A73, 0x8273, 
        0x8252, 0x8A53, 0x8273, 0x8273, 0x8A53, 0x8253, 0x8253, 0x8A73, 0x8A73, 0x8A73, 0x8273, 0x8273, 0x8A73, 0x8A73, 0x8A73, 0x8A73, 0x9294, 0x9AD5, 0x69B0, 0x590D, 0x720F, 0xEF3D, 0xFF5F, 0xF6FD, 0xEEFB, 0xFF3B, 0xFF1D, 0xFF1E, 0xF73F, 0xF6BF, 
        0xFE5E, 0xF63C, 0xF63C, 0xFDBC, 0xFDDA, 0xF5B8, 0xF555, 0xE4F4, 0xB430, 0x8BAC, 0x736B, 0x7C6C, 0x7BEB, 0x6B29, 0x5AE8, 0x94CE, 0x4227, 0x3164, 0x7BAB, 0xEF7D, 0xFFFF, 0xFFDF, 0xFFBE, 0xFFDE, 0xEF59, 0xE6D2, 0xDE8E, 0xF7B8, 0xF75B, 0xF71B, 
        0xF759, 0xF75C, 0xFF5C, 0xFF9B, 0xFFD9, 0xFFD0, 0xFFF8, 0xFFFE, 0xEF9D, 0x948E, 0x7C0A, 0x6348, 0x4245, 0x5265, 0x4267, 0x4AAA, 0x73CF, 0xEF7D, 0xF77B, 0xEF38, 0xDED6, 0xB571, 0x944D, 0x8C2C, 0x946C, 0x7B68, 0xC615, 0xF7DE, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFDF, 0xFFFE, 0xFFDE, 0xFFBD, 0xFF9C, 0xFFDD, 0xFF9C, 0xFF1B, 0xFF7B, 0xF79C, 0xA513, 0x20C3, 0x7162, 0x5123, 0x40C3, 0x48C3, 0x48C3, 0x40C4, 0x38C3, 0x30C1, 0x58A3, 0x5862, 0x5081, 
        0x40C2, 0x1882, 0x938C, 0xE593, 0xE5D4, 0xAC2D, 0x8B67, 0x5223, 0x20C2, 0xAC0F, 0xC512, 0xD636, 0xFFBE, 0xFFDE, 0xFFDF, 0xFFDF, 0xFFFE, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFD, 0xFFDB, 0xFFDC, 
        0xFFDE, 0xFFFD, 0xFFFC, 0xEF7C, 0x8B6C, 0x5942, 0x6923, 0x4041, 0x7946, 0xBAED, 0xDC11, 0x50A2, 0x58A1, 0x60E2, 0x68E3, 0x7908, 0x7946, 0x71C5, 0x6266, 0x2101, 0x4103, 0x58C3, 0x6862, 0x99EA, 0x6906, 0x5063, 0x4843, 0x2042, 0x4125, 0x5985, 
        0x6984, 0x7AAD, 0x7AAE, 0x726B, 0x6208, 0x4966, 0x30A4, 0x2042, 0x1862, 0x1000, 0x1801, 0x38A3, 0x5965, 0x20A3, 0x9C50, 0xEEFA, 0xFFDE, 0xFFBF, 0xFFBF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xFEBA, 
        0xF5D4, 0xF5B3, 0xFE97, 0xF77C, 0xA510, 0x5266, 0x18E2, 0x7CAC, 0x7BCC, 0x7B0B, 0x7AE9, 0x4961, 0x20C1, 0x62C8, 0xD632, 0x3162, 0x18E0, 0x10C0, 0x08A0, 0x4A63, 0x29A2, 0x2121, 0x2981, 0x3A02, 0x39E3, 0x39E5, 0x41E5, 0x1922, 0x2103, 0x3143, 
        0x3942, 0x0840, 0x1061, 0x2902, 0x5A05, 0xB511, 0xD594, 0xD573, 0xC510, 0xBC6E, 0xDDD4, 0xF71A, 0xEF5C, 0x6B6F, 0x840E, 0x83AB, 0x51E3, 0x30C1, 0x5225, 0x5A87, 0x4A27, 0x9C6C, 0xA3EA, 0xBCF0, 0xF73B, 0xCCB0, 0x71E8, 0x61A8, 0x93AD, 0x8AAA, 
        0xA38D, 0xAC2B, 0xA446, 0x9BD2, 0xA3D6, 0xABD5, 0xB3D4, 0xC396, 0xBB96, 0xBB96, 0xB396, 0xBB96, 0xB378, 0xAB7A, 0xB35D, 0xB35C, 0xB37C, 0xAB9B, 0xABB8,
  0x7A31, 0x7A32, 0x7A32, 0x7A32, 0x8252, 0x8252, 0x7A31, 0x7A31, 0x7A52, 0x7A52, 0x8252, 0x8252, 0x8252, 0x8252, 0x8272, 0x7A52, 0x8252, 0x8252, 0x8253, 0x8272, 0x8252, 0x8252, 0x8253, 0x8273, 0x8272, 0x8272, 0x8253, 0x8253, 0x7A52, 0x8272, 0x8273, 
        0x8273, 0x8A73, 0x8A73, 0x8A73, 0x8A73, 0x8273, 0x8273, 0x8273, 0x8A73, 0x8A73, 0x8A73, 0x8A94, 0x8A94, 0x8A72, 0x8A73, 0x8A93, 0x92D4, 0x8272, 0x6150, 0x8B15, 0xEF5E, 0xFFBE, 0xEE37, 0xED92, 0xF633, 0xF7BD, 0xFF5E, 0xFEFE, 0xFE7D, 0xFD18, 
        0xEC74, 0xDC12, 0xDBB1, 0xD3F1, 0xD453, 0xCC73, 0xB431, 0x836C, 0x7BCB, 0x844C, 0x7C8D, 0x7389, 0x6B49, 0x7BEC, 0x94CF, 0x18C3, 0x41E6, 0x9490, 0xF79D, 0xFFFF, 0xFFBF, 0xFFBF, 0xFFDF, 0xFF3B, 0xEED4, 0xEF11, 0xFFD4, 0xFFBE, 0xFF7E, 0xFF3D, 
        0xF73C, 0xF7B8, 0xFFD7, 0xFFD3, 0xFFAE, 0xFFFD, 0xF7BE, 0xAD74, 0x39A2, 0x3200, 0x4AE2, 0x6BC3, 0x7C44, 0x63A3, 0x63A3, 0x4AC2, 0x21A1, 0x6343, 0x842A, 0x94AD, 0x94CE, 0x8C6B, 0x844A, 0x7C0A, 0x7BC8, 0x8C8A, 0xCE95, 0xF79C, 0xF79E, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFFE, 0xFFDD, 0xF75B, 0xFF7C, 0xFF7C, 0xFF3B, 0xFEFA, 0xF75C, 0xC5D6, 0x5A68, 0x1061, 0x4123, 0x6165, 0x60E5, 0x50A2, 0x48E2, 0x50E4, 0x60C6, 0x50C1, 0x6164, 0x6965, 
        0x58A4, 0x20A2, 0xA4D1, 0xF77C, 0xEF5C, 0x82C5, 0x6A83, 0x8BA8, 0xBD2E, 0xBC8C, 0x5206, 0x630C, 0xEF5C, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFDD, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFD, 0xFFDD, 
        0xFFFD, 0xFFFE, 0xFFFF, 0xF77D, 0xABEE, 0x81A5, 0x8924, 0x7041, 0x80E5, 0xAA8C, 0xD412, 0x60A3, 0x6062, 0x70E4, 0x7945, 0xA147, 0x9145, 0x7123, 0x4902, 0x31C2, 0x4142, 0x7145, 0xB1C8, 0x4841, 0x5022, 0x5884, 0x58C4, 0x5043, 0x58A6, 0x50A5, 
        0x3821, 0x0800, 0x0000, 0x0800, 0x0800, 0x1000, 0x1800, 0x1861, 0x20E2, 0x2924, 0x3103, 0x30C2, 0x2080, 0x1882, 0x9BED, 0xEE77, 0xFFBD, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF77D, 0xD3CC, 
        0xED33, 0xFE59, 0xFE79, 0xFFDE, 0xF79D, 0xB512, 0x4923, 0x1124, 0x28E3, 0x2881, 0x1000, 0x0820, 0x49C4, 0x9C6C, 0xEF57, 0xCE77, 0xC5F4, 0x942D, 0x41A1, 0x3160, 0x39A1, 0x39E2, 0x29E3, 0x2181, 0x29E1, 0x2A01, 0x31E3, 0x29E5, 0x19A3, 0x1101, 
        0x1881, 0x6B0A, 0xA40F, 0xC4B1, 0xCD12, 0xBD33, 0xB512, 0xB4D1, 0xC4D1, 0xF75C, 0xDE56, 0xAC6E, 0x6288, 0x1041, 0x1020, 0x28C1, 0x5265, 0xCDD4, 0x93EC, 0x6AA5, 0x5A63, 0x20E2, 0x9C8E, 0xEE95, 0xFE77, 0xF75D, 0xBBF3, 0x6948, 0x2061, 0x6201, 
        0x82E9, 0xA3AF, 0xC434, 0xDBDE, 0xCB5D, 0xBBBB, 0xBC7A, 0xB39E, 0xB35C, 0xB399, 0xABD8, 0xA35D, 0xAB97, 0xB3B7, 0xAB9B, 0xB39B, 0xB39B, 0xB3BC, 0xABBD,
  0x7212, 0x7212, 0x7212, 0x7212, 0x7212, 0x7212, 0x7212, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A12, 0x7A52, 0x7A52, 0x7A32, 0x7A32, 0x7A32, 0x7A33, 0x7A33, 0x8213, 0x8A32, 0x8232, 0x7A32, 0x7231, 0x7A53, 0x7A53, 0x7A53, 0x7A53, 0x7A53, 0x7A53, 0x7A53, 
        0x7A53, 0x8252, 0x8252, 0x8253, 0x8253, 0x8A53, 0x8A53, 0x8253, 0x8A53, 0x8253, 0x8253, 0x8253, 0x8253, 0x8272, 0x8A93, 0x8A73, 0x8232, 0x8232, 0x6150, 0x8B34, 0xEF3E, 0xFF7F, 0xFF1A, 0xEE35, 0xC4AF, 0x8A83, 0xCC4D, 0xF555, 0xFCF8, 0xED15, 
        0xF534, 0xFD54, 0xFD54, 0xED73, 0xB3EE, 0x92CA, 0x9A8A, 0x8B0A, 0x8B2B, 0x7B4B, 0x6B0A, 0x6AE8, 0x8BAC, 0x6AE9, 0x2902, 0x5286, 0xBDD5, 0xF7BE, 0xFFFF, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFBD, 0xE6D1, 0xE6F1, 0xEF56, 0xF77B, 0xF6FD, 0xF73C, 0xF77C, 
        0xF79D, 0xF7B6, 0xF791, 0xF7B1, 0xFFF7, 0xEF5C, 0x630C, 0x31A2, 0x6362, 0x84E7, 0x8CE7, 0x7C85, 0x6C41, 0x7423, 0x7C83, 0x7CA4, 0x7485, 0x5B01, 0x4A81, 0x4AA3, 0x6385, 0xAD8E, 0xA58E, 0x94EB, 0x7BE7, 0x7325, 0xC5F4, 0xF7BE, 0xFFDF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFDE, 0xFFDF, 0xFFFE, 0xFF7A, 0xF75A, 0xF719, 0xF6D9, 0xEED8, 0xF77C, 0xEEFA, 0xC4F1, 0x20C2, 0x4944, 0x6165, 0x50A4, 0x4041, 0x50C3, 0x60E4, 0x68A3, 0x50A2, 0x50E4, 0x38A3, 
        0x1882, 0x840E, 0xCE58, 0xACF3, 0x4102, 0x5A42, 0xB50D, 0xCD6F, 0x8B48, 0x2861, 0x1000, 0x28C1, 0x6A86, 0xEF5C, 0xFFFF, 0xFFBE, 0xFF7E, 0xFFFE, 0xFFFE, 0xFFDF, 0xFFDF, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFE, 0xFFFE, 0xFFDE, 0xFF9C, 
        0xFFBC, 0xFFDD, 0xFFFF, 0xEF7D, 0x7B0C, 0x6124, 0xA1C7, 0x8842, 0x98A4, 0xC24B, 0xDC31, 0x38A3, 0x58E4, 0x8186, 0x9186, 0x80E5, 0x8126, 0x6904, 0x40C1, 0x4A45, 0x5185, 0x58C4, 0x68A3, 0x70A3, 0x8188, 0x7188, 0x4061, 0x2820, 0x4144, 0x51A4, 
        0x3902, 0x1820, 0x1041, 0x1882, 0x18A1, 0x2080, 0x2081, 0x20A2, 0x28E3, 0x4123, 0x2081, 0x0800, 0x1020, 0x5185, 0xBD75, 0xF75D, 0xFF1C, 0xFF3E, 0xFFBF, 0xFFFF, 0xFFFF, 0xFFBF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xD617, 0xAB6D, 0xF577, 
        0xFEFC, 0xFEFD, 0xFDFA, 0xFF3D, 0xDE39, 0xB472, 0x8229, 0x3862, 0x6964, 0x8248, 0x728A, 0x52EC, 0xB593, 0xF75A, 0xFFFD, 0xF7BD, 0xCDF2, 0x83C8, 0x31E1, 0x4A63, 0x6308, 0x5AE8, 0x4203, 0x3180, 0x2920, 0x18C0, 0x1080, 0x28E0, 0x3963, 0x5206, 
        0x7AE9, 0xBC6E, 0xDD53, 0xE5D5, 0xD5F5, 0xE5D6, 0xCD53, 0xD5F6, 0xF79C, 0xBDD4, 0x4A48, 0x0841, 0x0841, 0x39E4, 0x2943, 0x62E8, 0xE6D5, 0xEED9, 0x72EA, 0x3901, 0x3161, 0x18A1, 0x93EA, 0xDDB1, 0xEDB5, 0xF75C, 0xCD52, 0xAB90, 0x92B4, 0x3885, 
        0x4986, 0x59C6, 0x5943, 0x6A6F, 0x8B73, 0xB396, 0xC33B, 0xB39D, 0xAB5B, 0xA37A, 0xABDB, 0xA37C, 0xAB9B, 0xABBA, 0xAB9A, 0xAB5D, 0xB37A, 0xB399, 0xAB7C,
  0x7A12, 0x7A32, 0x7A32, 0x7A12, 0x7A32, 0x7232, 0x7212, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A52, 0x7A52, 0x7A32, 0x7A52, 0x8253, 0x8232, 0x7A32, 0x7A32, 0x8253, 0x8252, 0x7A52, 0x7A53, 0x7A52, 0x7A53, 0x7A53, 0x7A53, 0x7A52, 0x7A52, 0x8273, 
        0x8273, 0x8253, 0x8253, 0x8A73, 0x8A53, 0x8253, 0x8253, 0x8A73, 0x8A73, 0x8273, 0x8273, 0x8A73, 0x8A72, 0x8272, 0x8293, 0x8A73, 0x8A72, 0x8252, 0x89F3, 0xB397, 0xEEBC, 0xCD73, 0xB46C, 0x82C6, 0x5142, 0xCC0D, 0xF532, 0xFD95, 0xFDD7, 0xFE58, 
        0xF574, 0xF533, 0xF594, 0xD3F1, 0xC410, 0xD4D2, 0xEDD6, 0xFED8, 0xEE97, 0xDE56, 0xD614, 0xC5B3, 0x9C0D, 0x6A46, 0x51A4, 0xE73C, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFDF, 0xFFDF, 0xF77C, 0xEED7, 0xEF53, 0xF794, 0xFF97, 0xF73B, 0xF71D, 0xFF7D, 0xFFBA, 
        0xFF97, 0xFFF5, 0xF7CF, 0xFFD2, 0xE73A, 0x41C4, 0x5281, 0x7C04, 0x94E7, 0x6C24, 0x6C24, 0x7444, 0x7C64, 0x7465, 0x6BE3, 0x63C2, 0x6402, 0x6C04, 0x6BE5, 0x5B44, 0x4281, 0x4B44, 0x7C68, 0x9D4B, 0xADCD, 0x946B, 0xD676, 0xF7BD, 0xFFBF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFDE, 0xFFDF, 0xFFDE, 0xFFDD, 0xFF9B, 0xF75A, 0xF73A, 0xF6F9, 0xEED9, 0xF71B, 0xFF7E, 0xE71B, 0x2904, 0x5124, 0x6145, 0x40A3, 0x5084, 0x58A4, 0x68E5, 0x8925, 0x60A2, 0x2862, 0x4229, 
        0x9D56, 0xCE14, 0x6AA8, 0x2061, 0x20E3, 0xDEDA, 0xAD4F, 0x5AA5, 0x1060, 0x30A0, 0x2060, 0x3902, 0x82E9, 0xEF5C, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFDF, 0xFFDF, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFBD, 0xFFDE, 0xFFFE, 0xFFDE, 0xFFDC, 
        0xFFBB, 0xFFBC, 0xFFDE, 0xF77D, 0x9BEE, 0x6945, 0x7863, 0xDAEC, 0xE4D5, 0xEDB8, 0xDD15, 0x28C3, 0x50C3, 0x7945, 0x7925, 0x6843, 0x78E5, 0x7145, 0x5963, 0x5265, 0x59A5, 0x6104, 0x70C4, 0x80E4, 0xA20C, 0xC352, 0xD414, 0x7A89, 0x51E4, 0x49A2, 
        0x51C2, 0x4986, 0x2904, 0x1882, 0x0820, 0x18A1, 0x28E2, 0x30E2, 0x38C2, 0x2840, 0x1820, 0x2882, 0x5945, 0x59A4, 0x7A87, 0xB4B0, 0xF75C, 0xF5B8, 0xFEFC, 0xFFDF, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xD5F7, 0xAB4D, 0xF61B, 
        0xFE3D, 0xFDFC, 0xFD9A, 0xF515, 0xFDD8, 0xFE1A, 0xF598, 0xD593, 0xEDB4, 0xFE16, 0xFED9, 0xFFBD, 0xFF7C, 0xFF3A, 0xFF39, 0xFFDC, 0xFFDA, 0xD613, 0x8B46, 0x3A22, 0x4263, 0x4223, 0x39A1, 0x7328, 0x7329, 0x6B0A, 0x730B, 0xA42E, 0xAC4E, 0xB46F, 
        0xC490, 0x9B29, 0xA329, 0x9B4A, 0x834A, 0xB3ED, 0xDDF5, 0xCE38, 0x8452, 0x10A2, 0x20E2, 0x3162, 0x41A3, 0x2963, 0x18E3, 0x630C, 0xEF7C, 0xEF79, 0x6B4A, 0x2901, 0x28E1, 0x10A1, 0x4A46, 0x9C0D, 0xF5D5, 0xF79C, 0xD613, 0xB433, 0x929C, 0x6231, 
        0x5AA7, 0x52C2, 0x4A60, 0x59E4, 0x72AF, 0x9359, 0xB3DE, 0xAB9A, 0xC39C, 0xCB7E, 0xC35F, 0xAB5E, 0xAB9C, 0xABBC, 0xB3BD, 0xAB7A, 0xAB9A, 0xABBB, 0xABBC,
  0x7A31, 0x7A32, 0x7A32, 0x7A32, 0x7A52, 0x7A31, 0x7A32, 0x7A32, 0x7A52, 0x7A52, 0x7A32, 0x8232, 0x8252, 0x8252, 0x8252, 0x7A32, 0x7A52, 0x7A52, 0x7A52, 0x8252, 0x7A53, 0x7A73, 0x8273, 0x8272, 0x8273, 0x8273, 0x8252, 0x7A53, 0x8253, 0x8A73, 0x8A73, 
        0x8A53, 0x8A73, 0x8A73, 0x8A73, 0x8273, 0x8273, 0x8273, 0x8A73, 0x8A73, 0x8A73, 0x8A73, 0x8A94, 0x8A73, 0x8A73, 0x8273, 0x8273, 0x8A74, 0x92B4, 0x69D1, 0x8AB5, 0xED1C, 0xCCB3, 0xC450, 0xCC4E, 0xDC8D, 0xCCEC, 0xE612, 0xFF38, 0xF75B, 0xD36C, 
        0xE490, 0xF5D5, 0xFE78, 0xFD57, 0xFD56, 0xFDF9, 0xFEDC, 0xFE9A, 0xFEDB, 0xFEFB, 0xF6FC, 0xFEFE, 0xE69C, 0xE6DC, 0xFFDF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFF, 0xFFFF, 0xFF7C, 0xF718, 0xF6D3, 0xFFB9, 0xFF9B, 0xF77B, 0xF75B, 0xFFDE, 0xFF9B, 0xFF98, 
        0xFFD5, 0xEEED, 0xF777, 0xEF78, 0xBE0E, 0x2942, 0x7BE6, 0x9D48, 0x7426, 0x6C45, 0x7C25, 0x8446, 0x7C67, 0x63A3, 0x5B42, 0x6BC4, 0x7CA7, 0x63A4, 0x5B43, 0x5B23, 0x5303, 0x42C0, 0x42A0, 0x3220, 0x29E2, 0xCE32, 0xF77A, 0xFFDE, 0xF7DF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFFE, 0xFFDD, 0xFFBB, 0xFF79, 0xFF59, 0xFF58, 0xEEB8, 0xEE56, 0xF6D8, 0xDEFB, 0x20E4, 0x3882, 0x58C4, 0x58E4, 0x58E5, 0x68C4, 0x60A3, 0x4861, 0x5082, 0xB42E, 0xEE14, 
        0xCD10, 0x18A2, 0x0820, 0x41A3, 0xB48B, 0xE6FA, 0x62EB, 0x20A1, 0x38E1, 0x50A4, 0x2862, 0x49E5, 0xB50E, 0xF79D, 0xFFDF, 0xFFBF, 0xFFBF, 0xFFBE, 0xFFBE, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFF9D, 0xFFDD, 0xFFFE, 0xFFFF, 0xFFFE, 
        0xFF9B, 0xFF9B, 0xFFFD, 0xF7BE, 0xB595, 0x82EA, 0x78C3, 0xEC13, 0xF4D5, 0xECD4, 0xD431, 0x2082, 0x4882, 0x68C3, 0x5883, 0x5063, 0x4841, 0x5923, 0x7A86, 0x3962, 0x40E2, 0x58A2, 0x68A3, 0x60E4, 0x50A2, 0x79E8, 0xDCF3, 0xEDD6, 0xB44F, 0x932A, 
        0x8AEA, 0x7AEC, 0x7AEB, 0x7AC9, 0x6A47, 0x5144, 0x4904, 0x4923, 0x5183, 0x7208, 0x7A29, 0x8A8A, 0x9B0C, 0x9B8D, 0x51A6, 0x6207, 0xC4D2, 0xF75D, 0xFF5E, 0xFF5E, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF7DE, 0xD618, 0xCC52, 0xE30F, 0xFD5A, 
        0xFD3A, 0xFCD8, 0xFC96, 0xFD79, 0xFD59, 0xFC96, 0xFBF3, 0xFE98, 0xFDB6, 0xFD14, 0xFD13, 0xFD74, 0xFD12, 0xFD53, 0xFE56, 0xFFBD, 0xFFFF, 0xFFFF, 0xE71C, 0x2924, 0x6287, 0x93EB, 0x8BCB, 0x4164, 0x6A86, 0x93C8, 0x9C6B, 0x9C0A, 0x936A, 0x9B0A, 
        0x9AC9, 0x8206, 0x8A68, 0x82A9, 0x7AA8, 0x92C9, 0x6AC7, 0x31C4, 0x1081, 0x4A04, 0x41E3, 0x39C3, 0x31C3, 0x19A1, 0x1921, 0x3183, 0x734A, 0xDEDA, 0x630C, 0x3164, 0x62A6, 0x1101, 0x0881, 0x5AEB, 0xEF3B, 0xFEFA, 0xDE75, 0xCD75, 0xC439, 0xBC58, 
        0x7AD2, 0x59EE, 0x518E, 0x38A9, 0x30E5, 0x4185, 0x6A8B, 0x93B8, 0xB4BA, 0xCCFB, 0xCC7D, 0xB45B, 0xB3BD, 0xAB7D, 0xB37A, 0xABF8, 0xB39C, 0xB35C, 0xAB98,
  0x7212, 0x7212, 0x7A12, 0x7A12, 0x7212, 0x7212, 0x7212, 0x7A12, 0x7A32, 0x7A32, 0x7A12, 0x7A12, 0x7A52, 0x7A32, 0x7A32, 0x7A31, 0x7A33, 0x7A33, 0x7A53, 0x7A53, 0x8232, 0x8232, 0x8252, 0x7A32, 0x7A52, 0x8253, 0x7A53, 0x7A53, 0x7A53, 0x7A53, 0x8253, 
        0x8A52, 0x8253, 0x8253, 0x8253, 0x8253, 0x8253, 0x8A53, 0x8A73, 0x8A73, 0x8253, 0x8273, 0x8273, 0x8274, 0x8253, 0x8253, 0x8A73, 0x8A74, 0x8252, 0x92D6, 0x6A10, 0x28A3, 0xA30D, 0xDE38, 0xFFDD, 0xFF99, 0xDCCD, 0xE4EE, 0xEE15, 0xFF7D, 0xF5F6, 
        0xFE58, 0xFF1B, 0xFFDE, 0xFF5D, 0xFE7B, 0xF619, 0xFE5A, 0xFEFC, 0xFF1D, 0xFF5E, 0xFF7F, 0xFEBE, 0xFF7E, 0xFFFF, 0xFFFF, 0xFFDE, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDE, 0xF719, 0xEEF7, 0xF798, 0xF7BB, 0xF75B, 0xF75B, 0xF79B, 0xEF99, 0xF797, 0xF796, 
        0xF776, 0xF793, 0xEF99, 0x9D33, 0x29A4, 0xA56D, 0x94E9, 0x7C45, 0x7444, 0x7CC5, 0x7485, 0x63E4, 0x5B22, 0x6BE4, 0x7C66, 0x6C45, 0x4B83, 0x4AE1, 0x52E2, 0x5324, 0x5B65, 0x5303, 0x63A4, 0x4AA3, 0x2923, 0xE719, 0xFFFE, 0xFFFF, 0xFFDF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFDE, 0xFFFE, 0xFFDD, 0xFFDB, 0xF799, 0xF738, 0xF718, 0xEEF8, 0xDE76, 0xDE35, 0xE6B8, 0xE6FB, 0x40E3, 0x2800, 0x40A2, 0x61A5, 0x58E3, 0x3061, 0x2061, 0x4985, 0xDDF4, 0xBCCF, 0x6287, 
        0x1861, 0x5103, 0x30C3, 0x630C, 0xCE79, 0x18E3, 0x0000, 0x20A0, 0x5181, 0x1040, 0x30E2, 0x6A85, 0xB4CC, 0xEF7C, 0xDE5B, 0xD578, 0xED77, 0xFF9E, 0xFF3D, 0xFF3D, 0xFFDE, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFF9D, 0xFF9C, 0xFFBD, 0xFFDE, 0xFFDC, 
        0xFFBA, 0xFF9A, 0xFF9C, 0xF7BE, 0xCDD6, 0xABCD, 0xB228, 0xEB4E, 0xF4B4, 0xBB8F, 0x6082, 0x4021, 0x4862, 0x4861, 0x4061, 0x40A4, 0x5082, 0x6943, 0x7267, 0x1041, 0x1800, 0x3000, 0x4821, 0x4881, 0x50C2, 0x50A1, 0x50E3, 0xDE97, 0xBCAE, 0xA308, 
        0x9AE9, 0x6AAB, 0x6269, 0x6A48, 0x7228, 0x61A5, 0x5944, 0x5944, 0x6965, 0x82AA, 0x9AEC, 0xAB2C, 0xBBCD, 0xDD14, 0xA34D, 0xAB6C, 0xE5B4, 0xF6FD, 0xFEFC, 0xFF3D, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xF77D, 0xA3CE, 0xA2AB, 0xF474, 0xFC15, 
        0xFBF6, 0xFC37, 0xFC76, 0xFC76, 0xFC76, 0xF496, 0xFCD6, 0xF4D1, 0xF4D2, 0xF491, 0xE44F, 0xF554, 0xE4D1, 0xE490, 0xFD14, 0xF6D8, 0xF79C, 0xE6D9, 0xA4AE, 0x20C2, 0x5245, 0x6306, 0x4A65, 0x8BCA, 0x6265, 0x4161, 0x4140, 0x5221, 0x6203, 0x7A06, 
        0x9A29, 0x8A05, 0x79C5, 0x81E6, 0x8AA8, 0x936A, 0x41E4, 0x10E0, 0x1901, 0x3A05, 0x4204, 0x39C2, 0x1940, 0x0860, 0x10A0, 0x1080, 0x20E3, 0xD6BA, 0x8C2F, 0x3984, 0x1061, 0x3A24, 0x2143, 0x630C, 0xE71C, 0xDE17, 0xE6B5, 0xA4CF, 0x3929, 0xBC5B, 
        0xAC99, 0x9C36, 0x8394, 0x2945, 0x2101, 0x2101, 0x2941, 0x2122, 0x3142, 0x41A6, 0x6A4D, 0xAABB, 0xAB3D, 0xA37B, 0xABB7, 0xB46E, 0xA3B4, 0xA339, 0xA37A,
  0x7A12, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A12, 0x7A33, 0x7A32, 0x7A32, 0x7A32, 0x7A52, 0x7A52, 0x7A32, 0x7A33, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A53, 0x7A52, 0x8252, 0x8A53, 0x8232, 0x8232, 0x8233, 0x8253, 0x8253, 0x8253, 0x8253, 
        0x8253, 0x8253, 0x8253, 0x8253, 0x8253, 0x8A53, 0x8A53, 0x8253, 0x8253, 0x8A73, 0x8273, 0x8253, 0x8253, 0x8273, 0x8A93, 0x8273, 0x8233, 0x8A74, 0x8AB4, 0x71EF, 0x5129, 0xE71C, 0xFFFF, 0xFFFF, 0xFFBC, 0xDD90, 0xE592, 0xF637, 0xFEDC, 0xF698, 
        0xF6B9, 0xF73C, 0xFFDF, 0xFFBF, 0xFF3E, 0xFEDD, 0xF69B, 0xEE99, 0xEE7A, 0xEE7C, 0xEE9D, 0xF65C, 0xFF5E, 0xFFDF, 0xFFFF, 0xFFDE, 0xFFDE, 0xFFFF, 0xFFFE, 0xF77A, 0xF717, 0xF759, 0xFFDC, 0xF7BB, 0xF77B, 0xF79C, 0xF79D, 0xD592, 0xE6D9, 0xF759, 
        0xE6D2, 0xF79C, 0xB594, 0x740A, 0x5362, 0xA4E9, 0x8C87, 0x7C65, 0x7CA6, 0x7443, 0x63E2, 0x63C3, 0x7C25, 0x84E7, 0x6C04, 0x5341, 0x42E1, 0x5B63, 0x5343, 0x5343, 0x6345, 0x4B41, 0x63E3, 0x52C3, 0x2944, 0xE71C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xFFDC, 0xFFDA, 0xF77A, 0xF719, 0xF6F7, 0xEEF6, 0xDE95, 0xD5F4, 0xDE77, 0xE73B, 0x72A9, 0x38C3, 0x3862, 0x60C3, 0x58C2, 0x62CA, 0x9CD1, 0xE5B3, 0x730A, 0x2924, 0x28A2, 
        0x5924, 0x5861, 0x8208, 0xBCB2, 0xDEBA, 0x20E3, 0x20A0, 0x28C0, 0x1880, 0x50E3, 0x28A2, 0x6289, 0xEE78, 0xFF9E, 0xDD57, 0xBB91, 0xAB0F, 0xF6BB, 0xFF9E, 0xFF7D, 0xFEFB, 0xFFBE, 0xFFDF, 0xFFDF, 0xFF9E, 0xFFDD, 0xFFBD, 0xFF9D, 0xFF9D, 0xFFDC, 
        0xF7BC, 0xF77B, 0xF77B, 0xFFDE, 0xEF3B, 0xB491, 0x7104, 0xEC74, 0xF65B, 0xA4D3, 0x20A2, 0x5081, 0x4882, 0x3882, 0x30C3, 0x5925, 0x4882, 0x3020, 0x3082, 0x9452, 0x9BCF, 0x7229, 0x2041, 0x0800, 0x1800, 0x3862, 0x6945, 0xBC6F, 0xDDD4, 0xAC2F, 
        0x48C3, 0x82AB, 0x8ACB, 0x82AA, 0x7A89, 0x7A69, 0x8248, 0x69A5, 0x5103, 0xB38E, 0xDC72, 0xE4F4, 0xDD35, 0xE555, 0xF596, 0xF575, 0xED53, 0xFF1B, 0xFF1D, 0xFF3E, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xEF1C, 0x82EC, 0x8147, 0xE290, 0xFB13, 
        0xFB14, 0xFB14, 0xFB73, 0xF414, 0xF3F3, 0xF3F3, 0xF415, 0xED17, 0xF5B7, 0xEDF6, 0xE5D5, 0xF658, 0xEE58, 0xE5B4, 0xECAF, 0xF574, 0xFEF9, 0xF75A, 0xC5F5, 0x2103, 0x31E4, 0x4284, 0x31C1, 0x39C3, 0x41C4, 0x41A3, 0x3981, 0x4A03, 0x7307, 0x7AC8, 
        0x69A4, 0x69A3, 0x7A25, 0x7245, 0x59E3, 0x4A03, 0x29C2, 0x21A2, 0x2981, 0x2120, 0x20E0, 0x20E0, 0x2941, 0x6BAC, 0x738C, 0x5247, 0x3103, 0xAD53, 0xDED9, 0x9CF2, 0x18C2, 0x29A1, 0x18E1, 0x39A5, 0x9C6F, 0xF77D, 0xF799, 0xCDD1, 0x82E9, 0x728C, 
        0x8B8E, 0x93EE, 0x7B6B, 0x4A82, 0x49E3, 0x4163, 0x2140, 0x29E0, 0x2961, 0x2961, 0x39C3, 0x596C, 0x724F, 0x934F, 0xB46D, 0xA4A7, 0xA432, 0xA3BA, 0xA37B,
  0x7A31, 0x7A32, 0x7A32, 0x7A32, 0x8252, 0x8251, 0x7A32, 0x7A32, 0x7A32, 0x8252, 0x8252, 0x7A52, 0x8252, 0x8252, 0x8252, 0x7A52, 0x7A52, 0x7A52, 0x7A52, 0x7A52, 0x7A52, 0x8273, 0x8273, 0x8A73, 0x8253, 0x8252, 0x8252, 0x8253, 0x8253, 0x8253, 0x8273, 
        0x8273, 0x7A72, 0x8A73, 0x8A73, 0x8A73, 0x8A53, 0x8A73, 0x8253, 0x8253, 0x8A73, 0x8A73, 0x8A93, 0x8A94, 0x8A53, 0x8A73, 0x8273, 0x8A93, 0x92D5, 0x6971, 0x7A32, 0xCD7A, 0xF79E, 0xFEB8, 0xF5D2, 0xE56F, 0xD4F1, 0xE574, 0xED34, 0xD411, 0xC36B, 
        0xDD55, 0xF6DB, 0xF77E, 0xFFDF, 0xFFDF, 0xFF3D, 0xFE3B, 0xFF5D, 0xF67B, 0xF5DA, 0xFE1B, 0xFFBF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFBA, 0xFFDA, 0xFFFC, 0xFFFF, 0xFFBE, 0xFFDF, 0xFFDE, 0xFF9D, 0xF71B, 0xFF9D, 0xF7B7, 
        0xF76D, 0xEF7A, 0x846C, 0x6364, 0x8CA8, 0x84A6, 0x8CA5, 0x8466, 0x6C06, 0x6383, 0x7425, 0x8486, 0x7C85, 0x6362, 0x6BA2, 0x6BC3, 0x5B83, 0x5B63, 0x63A3, 0x5B42, 0x4AC1, 0x6BE5, 0x63A3, 0x3A41, 0x2124, 0xE71C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFDE, 0xFFFD, 0xFFFB, 0xFFBB, 0xFF59, 0xF6F7, 0xEED7, 0xEE75, 0xDDF4, 0xDE77, 0xF79C, 0xBD75, 0x4A08, 0x2821, 0x5841, 0x9A8A, 0xD532, 0xB46F, 0x48C2, 0x2840, 0x3840, 0x5082, 
        0x70E5, 0x40A3, 0xAC92, 0xB593, 0x4B24, 0x1181, 0x4244, 0x4A24, 0x10E1, 0x0840, 0x3861, 0x8AEB, 0xEEFC, 0xFCF6, 0xF495, 0xEC55, 0xD372, 0x9149, 0xCC95, 0xF6DD, 0xFF5E, 0xFFDF, 0xFF9D, 0xFF7D, 0xFF9F, 0xFFDF, 0xFFBE, 0xFF9D, 0xFF7C, 0xFF9D, 
        0xFFBC, 0xFF9B, 0xF75B, 0xFFBE, 0xF79E, 0xA513, 0x3125, 0xE432, 0xF4D6, 0xA34F, 0x2082, 0x50A2, 0x48A1, 0x3860, 0x2800, 0x2000, 0x1020, 0x2924, 0x6B0A, 0xBD73, 0xE6FA, 0xDF5B, 0xADD5, 0x5984, 0x7247, 0xB470, 0xDDF8, 0x61C7, 0xB451, 0xEDF8, 
        0xDD75, 0x7247, 0x8269, 0x9B0D, 0xAB8E, 0x9B2A, 0x8A68, 0x8249, 0x9B0B, 0xCBCE, 0xC3D0, 0xD493, 0xEDD7, 0xED54, 0xE513, 0xDCB3, 0xE4B3, 0xFEB8, 0xFEDB, 0xFF3D, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xE6FB, 0x62CB, 0x3862, 0x8063, 0xC9EC, 
        0xEA90, 0xFAF2, 0xFB54, 0xF456, 0xFD3A, 0xFDFD, 0xFEDF, 0xFF9F, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFBE, 0xF79C, 0xF73A, 0xF6BA, 0xF6B8, 0xFF19, 0xF77D, 0x9CB0, 0x734A, 0x6B08, 0x7C09, 0x8C2D, 0x6B08, 0x5AC6, 0x6328, 0x28C2, 0x59C5, 0x8286, 
        0x7A85, 0x6A65, 0x6AC5, 0x6B05, 0x62E5, 0x5284, 0x52A4, 0x5283, 0x5A63, 0x6B49, 0x942C, 0xA48D, 0xA46D, 0xADB1, 0x6B89, 0x4A64, 0x5284, 0x10A1, 0x4AA6, 0x7C09, 0x7BC8, 0x1921, 0x39E2, 0x39C2, 0x2124, 0xDF1B, 0xEF3A, 0xD5B4, 0xABAE, 0x9B8A, 
        0x59E5, 0x51C5, 0x7B2D, 0xAC51, 0x93CF, 0x6B0B, 0x4A68, 0x522A, 0x62A9, 0x6AEA, 0x732E, 0xA4B6, 0xA431, 0x9C2C, 0x94A9, 0x94A8, 0xACB0, 0xB438, 0xB35E,
  0x7212, 0x7A12, 0x7A12, 0x7212, 0x7A32, 0x7A32, 0x7A32, 0x7A12, 0x7A13, 0x7A12, 0x7A12, 0x7A32, 0x7A52, 0x7A52, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A52, 0x7A33, 0x7A32, 0x8232, 0x8232, 0x8232, 0x8252, 0x8253, 0x8253, 0x8A53, 0x8253, 0x7A53, 
        0x7253, 0x9253, 0x8A53, 0x8253, 0x8253, 0x8A53, 0x8253, 0x8253, 0x8A73, 0x8273, 0x8A73, 0x8A73, 0x8273, 0x8A73, 0x8A53, 0x8A74, 0x8A94, 0x8A53, 0x69AF, 0x8271, 0xC498, 0xF69C, 0xFEFB, 0xFF1B, 0xF75A, 0xF79B, 0xFF5B, 0xFF5D, 0xF75D, 0xCC30, 
        0x9228, 0x7903, 0x8924, 0xEC54, 0xEE1A, 0xE6DC, 0xEEFC, 0xEEBD, 0xF5DB, 0xEDDA, 0xF6DC, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFF9E, 0xFFBD, 0xFFBC, 0xFFBC, 0xFFDB, 0xFFDC, 0xFFDD, 0xFFBE, 0xFFDF, 0xFFDE, 0xF77A, 0xEED3, 0xF7BD, 0xEF59, 0xEF55, 
        0xFFD6, 0xEEFC, 0x73CC, 0x5305, 0x9CE8, 0x8C86, 0x7C25, 0x6BE4, 0x63A4, 0x7C45, 0x7C65, 0x73E4, 0x6341, 0x6BE4, 0x6C04, 0x6BC4, 0x5B82, 0x5B85, 0x5363, 0x5342, 0x5341, 0x5B64, 0x63A4, 0x4A83, 0x2102, 0xBE12, 0xEF7B, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFDE, 0xFFFE, 0xFFDD, 0xFFBC, 0xFF9A, 0xFF39, 0xF6D7, 0xEE96, 0xE635, 0xD5F5, 0xDE56, 0xF719, 0xCD96, 0x6249, 0x4103, 0x61C4, 0x5922, 0x5902, 0x6123, 0x6985, 0x60A3, 0x68E4, 0x68C4, 
        0x5821, 0x48A2, 0xACB2, 0x9CB2, 0x1903, 0x4323, 0x6B88, 0x6AE8, 0x4163, 0x18C3, 0xA514, 0xF7BE, 0xFF7D, 0xF3B1, 0xEC13, 0xDBF3, 0xCAAF, 0xCA2D, 0xA1A9, 0xB38F, 0xF75C, 0xFEFA, 0xF6B9, 0xF6DB, 0xFF7E, 0xFF5B, 0xFFBC, 0xF79D, 0xF73C, 0xFEFA, 
        0xFF5A, 0xF73A, 0xF6BA, 0xFFBD, 0xF79D, 0xA513, 0x3145, 0xDD18, 0xC434, 0x7A4A, 0x3061, 0x4882, 0x3861, 0x4904, 0x82AA, 0x8B2C, 0x834C, 0x8BAD, 0xA3EE, 0x7287, 0xBD12, 0xBD54, 0x734B, 0xC42F, 0xA36C, 0x9B6C, 0xB451, 0x9B4C, 0x9B6D, 0xC513, 
        0xE6FB, 0x7A29, 0x826A, 0x92EB, 0x9B0B, 0xA34C, 0x92C9, 0x8A88, 0x9288, 0x6966, 0x7966, 0xAAEC, 0xE535, 0xE533, 0xD4D2, 0xD4B2, 0xE4F2, 0xFE77, 0xFEFC, 0xFF7E, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDF, 0xF79E, 0xC4D2, 0x61C7, 0x4841, 0x8082, 0xDA2D, 
        0xF332, 0xFBB4, 0xFC15, 0xFDFD, 0xFEDE, 0xFF7F, 0xFFDF, 0xFFDF, 0xFFDE, 0xFFDE, 0xFFDD, 0xFFDE, 0xFFBE, 0xFFDD, 0xFFDD, 0xEF5C, 0xF6DA, 0xFF1B, 0xFFBE, 0xD615, 0x6309, 0x4A65, 0x7C0B, 0x7BE9, 0xB56F, 0x9C6D, 0x3162, 0x5AC7, 0x49C3, 0x5183, 
        0x7246, 0x6AA5, 0x6285, 0x5A84, 0x5AA4, 0x6AE5, 0x62E5, 0x5AA4, 0x5263, 0x6AC4, 0xBD4E, 0xEF16, 0xDEF6, 0x2103, 0x18C0, 0x2982, 0x3A24, 0x31C2, 0x18C1, 0x2963, 0x5327, 0x2162, 0x2961, 0x3181, 0x39C1, 0x7B8B, 0xC5F6, 0xACD3, 0x4946, 0xD5B1, 
        0x9C29, 0x5223, 0x28E2, 0x734C, 0x9C4C, 0xACE9, 0xA525, 0x9D2A, 0x9CED, 0x944C, 0x7B8A, 0x9BF0, 0x9BEE, 0x8BA8, 0x73A2, 0xA529, 0xACCC, 0xABF4, 0xAB3E,
  0x7A12, 0x7A32, 0x7232, 0x7212, 0x7A32, 0x7232, 0x7A32, 0x7A12, 0x7A32, 0x7A32, 0x7A32, 0x7A52, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A53, 0x7A32, 0x7A32, 0x7A53, 0x7A32, 0x7A52, 0x8252, 0x8232, 0x8232, 0x8253, 0x8253, 0x8253, 0x8A33, 0x8253, 0x7A53, 
        0x7252, 0x8A52, 0x8A53, 0x8253, 0x8253, 0x8253, 0x8273, 0x8273, 0x8A53, 0x8253, 0x8273, 0x8273, 0x8A53, 0x8A73, 0x8A73, 0x8A54, 0x8253, 0x8211, 0x8254, 0xABB8, 0xEDDD, 0xCE77, 0xE6FB, 0xFF7E, 0xFFDE, 0xFF38, 0xFEB8, 0xF638, 0xDD55, 0xA2EB, 
        0xAA89, 0xC2CB, 0xD30D, 0xA24A, 0x924B, 0xAAED, 0xD3CF, 0xD32F, 0xDC94, 0xEE3A, 0xFFBE, 0xFFDF, 0xFFDF, 0xFFDE, 0xFFBE, 0xFFBE, 0xFFBE, 0xF7BC, 0xF7BA, 0xFFFD, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDF, 0xF79D, 0xEF38, 0xEEF2, 0xF7BC, 0xEF17, 0xEF17, 
        0xEF5B, 0x7385, 0x6BC4, 0x7C45, 0x8466, 0x8466, 0x7C45, 0x7C45, 0x7C85, 0x7425, 0x6C03, 0x6C03, 0x7404, 0x7484, 0x6C24, 0x6BC4, 0x6383, 0x5344, 0x4B43, 0x5383, 0x5BE3, 0x4AC2, 0x7406, 0x6345, 0x2944, 0xDEB8, 0xFFDD, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFDD, 0xFFFD, 0xFF9B, 0xF739, 0xEEB7, 0xE634, 0xD634, 0xD5F4, 0xDE35, 0xEEF7, 0xDE17, 0x5A69, 0x2881, 0x48E2, 0x8AA8, 0x7A46, 0x6964, 0x58C2, 0x6906, 0x8147, 0x60E5, 
        0x3082, 0xBBAC, 0xD592, 0x944D, 0x1902, 0x3BC5, 0x4B87, 0x3225, 0x18C3, 0xAC51, 0xE69A, 0xFE5B, 0xF415, 0xDB11, 0xD2F0, 0xD2CF, 0xDAAE, 0xA129, 0x8084, 0x7945, 0x938F, 0xEF5D, 0xF6DA, 0xE5D6, 0xDD75, 0xF77D, 0xFFBD, 0xF79C, 0xFF7C, 0xF6BA, 
        0xF73A, 0xF75A, 0xF6FA, 0xFF5B, 0xF77D, 0xA513, 0x3145, 0xD4D6, 0x922A, 0x5882, 0x6124, 0xBD13, 0xBD13, 0x9BAD, 0x79E5, 0xB3AF, 0xDD14, 0xC450, 0x71C4, 0x4082, 0x8AEB, 0xB451, 0xBC52, 0xB44F, 0x934C, 0x61E7, 0x4903, 0xC4D2, 0x930A, 0x9B8D, 
        0xE69A, 0xB492, 0x79E7, 0x79A7, 0xABAF, 0xA36B, 0x9B2B, 0x92A9, 0x79C6, 0x20A2, 0x9B4C, 0xECF2, 0xDCF3, 0xD4F4, 0xD4B3, 0xCC92, 0xCCB1, 0xF617, 0xFEFA, 0xFF9D, 0xFFDF, 0xFFDF, 0xFFDE, 0xFFDE, 0xF75C, 0xA2E9, 0x58E3, 0x4840, 0x7881, 0xCA6C, 
        0xEC35, 0xFCD8, 0xFCD8, 0xFEFE, 0xFFBF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFBE, 0xFFBE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xF73C, 0xF73C, 0xFFDF, 0xEF7D, 0x7B8C, 0x5246, 0x7BCA, 0x7BA5, 0xBDF2, 0x9CD2, 0x2103, 0x6B89, 0x6264, 0x5181, 
        0x51C3, 0x6AE6, 0x5A44, 0x5A03, 0x6283, 0x6AC5, 0x62A4, 0x5AA3, 0x5AA3, 0x72E5, 0xAC8A, 0xA46B, 0x5A67, 0x31C2, 0x39E3, 0x39E4, 0x31C3, 0x31C2, 0x29C2, 0x31E3, 0x3A05, 0x49A5, 0x3982, 0x2941, 0x2102, 0x4A02, 0xAD13, 0xD635, 0xB50A, 0x8B87, 
        0x9407, 0x7B65, 0x39A1, 0x28E0, 0x41A0, 0x52A0, 0x63A2, 0x94AD, 0x9C8E, 0x9C4D, 0x9C0C, 0x9C6F, 0x83A7, 0x7B42, 0x8382, 0x7C22, 0x9CA8, 0xAC51, 0xA33D,
  0x7A31, 0x7A32, 0x7A32, 0x7A32, 0x8252, 0x7A52, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A52, 0x8252, 0x8252, 0x8252, 0x8252, 0x7A53, 0x7A52, 0x7A52, 0x7A52, 0x7A52, 0x7A73, 0x8273, 0x8253, 0x8A53, 0x8273, 0x8252, 0x8252, 0x8253, 0x8252, 0x8A73, 0x8273, 
        0x7A52, 0x8A93, 0x8A73, 0x8A73, 0x8252, 0x8273, 0x8273, 0x8273, 0x8273, 0x8A73, 0x8A73, 0x8A73, 0x8A94, 0x8A93, 0x8A73, 0x8A93, 0x8AB3, 0x7A73, 0x92B6, 0x7A11, 0x40A7, 0x9372, 0xD5F9, 0xF77D, 0xFFFF, 0xFFDE, 0xFFFE, 0xF7BE, 0xEF3C, 0xEF1C, 
        0xF63A, 0xE4D5, 0xB34F, 0x89EA, 0xB189, 0xC949, 0xC928, 0xA0C5, 0xD514, 0xFFBE, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFDE, 0xFFFF, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFDE, 0xEF39, 0xEF37, 0xFFDA, 0xFFDE, 0xF737, 0xF737, 
        0xDEFB, 0x2944, 0x6B86, 0x94E9, 0x8467, 0x7C65, 0x8CA6, 0x8CA6, 0x7C45, 0x7446, 0x7C65, 0x7C85, 0x7CA6, 0x7C45, 0x7403, 0x6BC3, 0x63A3, 0x5362, 0x63A2, 0x6382, 0x5302, 0x6BC4, 0x6BE3, 0x4AA2, 0x2124, 0xE71C, 0xF7BE, 0xB5B4, 0x4225, 0x39A7, 
        0x5289, 0x5ACA, 0x52AA, 0x734B, 0xBDB4, 0xEF5B, 0xFFFE, 0xFFFE, 0xFFDD, 0xFFFE, 0xFFDE, 0xFF5B, 0xF71A, 0xEED7, 0xD654, 0xD5F4, 0xC5B3, 0xCDF5, 0xEEB7, 0xE5D6, 0x6269, 0x3143, 0x72C7, 0xBCB1, 0x6A07, 0x40A2, 0x5903, 0x6106, 0x68E5, 0x4883, 
        0x28E4, 0xD699, 0x6B4B, 0x30E1, 0x4900, 0x4A63, 0x2122, 0x3986, 0x9BF0, 0xEF1C, 0xEC75, 0xDAF0, 0xD330, 0xEAD1, 0xF372, 0xFC34, 0xF474, 0xCA6B, 0xD2AE, 0xBA8C, 0x89C7, 0x93AD, 0xD658, 0xEF1B, 0xE618, 0xEDB5, 0xF677, 0xFF1A, 0xFF3C, 0xF718, 
        0xFF18, 0xFF19, 0xFF3A, 0xFF39, 0xF75C, 0xA513, 0x3105, 0xDB32, 0xC2CE, 0xB32D, 0xCC92, 0x9C30, 0xB4AF, 0xCD72, 0xD5B4, 0x4903, 0x3041, 0x6185, 0xAB8D, 0x9ACA, 0xA2EC, 0x9AAB, 0x8269, 0xD593, 0xD532, 0xABCD, 0x7A89, 0xD552, 0xA40E, 0x5A07, 
        0x2924, 0xDEBA, 0xAC50, 0x8A89, 0x9ACB, 0xBC2E, 0xCC70, 0xA32C, 0x50C2, 0x58A2, 0xBB4D, 0xE492, 0xD430, 0xD4F3, 0xD4F3, 0xDCD3, 0xD4D3, 0xDD73, 0xF699, 0xFF5D, 0xFFBF, 0xFFDF, 0xFFBE, 0xFFBE, 0xF75D, 0xB2EB, 0x7104, 0x7145, 0xB2AA, 0x8883, 
        0xB9EA, 0xE454, 0xFF1E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFFF, 0xF7BE, 0xDEB9, 0x41A7, 0x4A27, 0x842D, 0xD696, 0xE65A, 0xF75D, 0xFFBE, 0xFF9E, 0xF79E, 0x9CF4, 0x4A6A, 0x2944, 0xDED8, 0xAD10, 0x83CA, 0x8BEC, 0x7BAA, 0x8389, 0x72C6, 
        0x49A1, 0x4A22, 0x5283, 0x62A4, 0x72C5, 0x5283, 0x5AE3, 0x6324, 0x6B05, 0x6283, 0x7B27, 0x8349, 0x6267, 0x2922, 0x3162, 0x31A2, 0x2983, 0x3183, 0x2983, 0x2942, 0x30E1, 0x4183, 0x836A, 0x8BCC, 0x5266, 0x2921, 0x5265, 0x7BA9, 0x9C4D, 0x8B0B, 
        0x942B, 0x9CCA, 0x8C47, 0x3101, 0x2060, 0x20A1, 0x3123, 0x2923, 0x49E8, 0x72CA, 0x9389, 0x8C03, 0x8C44, 0x8C26, 0x8BC6, 0x9D25, 0x9CC4, 0xA40D, 0xBB7D,
  0x7A12, 0x7A12, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A12, 0x7A32, 0x7A52, 0x7A52, 0x7A32, 0x7A52, 0x7A52, 0x7A53, 0x7A52, 0x7A52, 0x7A52, 0x7A52, 0x7A52, 0x8232, 0x8232, 0x8252, 0x8253, 0x8253, 0x8253, 0x8253, 0x8A53, 0x8273, 
        0x7252, 0x8A53, 0x8A53, 0x8253, 0x8A53, 0x8A53, 0x8253, 0x8273, 0x8A73, 0x8273, 0x8273, 0x8273, 0x8A74, 0x8A53, 0x8A73, 0x8A74, 0x8A74, 0x8AB3, 0x8A93, 0x8A93, 0x8291, 0x696D, 0x518A, 0x5A0A, 0x92CE, 0xDD59, 0xDE7B, 0xDEFB, 0xEF3D, 0xFFDF, 
        0xFFFF, 0xFFDF, 0xF73D, 0xFCF7, 0xF4F7, 0xD351, 0xA948, 0xEE9B, 0xFFBE, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDE, 0xFFDD, 0xFFDD, 0xFFDE, 0xFFFE, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFFF, 0xF7DE, 0xEF38, 0xEF38, 0xFFDE, 0xFFBE, 0xF777, 0xF797, 
        0xE73B, 0x42C4, 0x5BC5, 0x84C9, 0x94E9, 0x8465, 0x8486, 0x8CA7, 0x94E6, 0x7C67, 0x7C86, 0x7C85, 0x7C65, 0x7465, 0x6C23, 0x63A2, 0x5321, 0x63A3, 0x6382, 0x5B42, 0x5B02, 0x6C23, 0x4B01, 0x4240, 0x6304, 0xD6D9, 0x630B, 0x10E1, 0x1940, 0x10A0, 
        0x0840, 0x0840, 0x1080, 0x18E0, 0x18C1, 0x2965, 0x6B2D, 0xEF5D, 0xFFDE, 0xFFBD, 0xFF9D, 0xFF5B, 0xF6F8, 0xE696, 0xCE33, 0xCDB3, 0xC573, 0xD636, 0xEF5A, 0x9C4F, 0x41A6, 0x49E6, 0xAC6E, 0xA3CE, 0x4986, 0x38C3, 0x6945, 0x5063, 0x50A4, 0x3083, 
        0x20E4, 0xCE79, 0x630C, 0x4123, 0x79E4, 0x2060, 0x1061, 0x62EB, 0xEEFB, 0xEC73, 0xE3B1, 0xE3F2, 0xF496, 0xFC76, 0xFC54, 0xF494, 0xF515, 0xFC94, 0xF452, 0xF432, 0xE3F2, 0x6206, 0x9C70, 0xDEB9, 0xF77D, 0xED51, 0xE573, 0xEE17, 0xFEFA, 0xF6F8, 
        0xF6D7, 0xF6D7, 0xF6D7, 0xFF5B, 0xF77C, 0xA513, 0x3105, 0xE3B2, 0xF435, 0xE413, 0xAB4D, 0x2082, 0x5923, 0x9248, 0xA36D, 0xB3EE, 0x9B0B, 0x9AC9, 0xA329, 0x9AAA, 0xA30C, 0x7A49, 0x28E3, 0xC4F0, 0xAC2D, 0xABED, 0xC490, 0x48E3, 0x82EB, 0x82EB, 
        0x4924, 0xCDD7, 0xEF3C, 0xDDD6, 0xB34B, 0xDD72, 0xDCD1, 0xB32C, 0x7164, 0x5881, 0xA249, 0xDBD0, 0xECB3, 0xCC70, 0xD4B2, 0xD4D2, 0xD4B1, 0xE554, 0xF678, 0xFF5C, 0xFFBF, 0xFF7E, 0xFF7D, 0xFFBD, 0xEF1B, 0x6104, 0x6945, 0x928A, 0xBB4E, 0xA186, 
        0xD28C, 0xF495, 0xFEFE, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xF7DE, 0xC5F7, 0x628A, 0x1061, 0x3182, 0x6B8A, 0xAD75, 0xAC8E, 0xDE16, 0xFF1B, 0xFF1A, 0xF79D, 0xB530, 0x6285, 0x2924, 0xD6BA, 0x944D, 0x83A9, 0xBD70, 0x6328, 0x62C5, 0x5A64, 
        0x4A23, 0x5AC5, 0x5A83, 0x5A63, 0x62A4, 0x5263, 0x5AA4, 0x5AC4, 0x5AA5, 0x72A5, 0x7B06, 0xACCE, 0xD6B7, 0x20E3, 0x0820, 0x20E2, 0x4205, 0x3183, 0x2941, 0x41C4, 0x6AC9, 0x30A2, 0x51E6, 0x9C71, 0xD6BA, 0x2124, 0x3A04, 0x6306, 0x7B67, 0x9428, 
        0x7BA5, 0x7BE6, 0xA4CB, 0x9C4D, 0x8B8D, 0x72CB, 0x49E8, 0x3103, 0x6248, 0x93AA, 0xACC8, 0x8401, 0x8424, 0x9485, 0x9D05, 0xB56A, 0xB528, 0xAC6D, 0xAB5B,
  0x7A32, 0x7A32, 0x7232, 0x7212, 0x7A32, 0x7232, 0x7A32, 0x7A12, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A52, 0x7A52, 0x7A52, 0x7A33, 0x7A33, 0x7A52, 0x7A53, 0x7A52, 0x8252, 0x8232, 0x8252, 0x8252, 0x8253, 0x8A53, 0x8252, 0x8253, 0x8253, 
        0x8253, 0x8252, 0x8253, 0x8253, 0x8253, 0x8A53, 0x8A53, 0x8A73, 0x8A53, 0x8273, 0x8253, 0x8253, 0x8A54, 0x8A73, 0x8A53, 0x8253, 0x8253, 0x8A54, 0x8A53, 0x8A93, 0x8AD4, 0x8A92, 0x8A72, 0x8252, 0x69F0, 0x508A, 0x512B, 0x7A30, 0xBB98, 0xF6DE, 
        0xF75E, 0xF73E, 0xF6FF, 0xF6DD, 0xBBD0, 0x9987, 0xB166, 0xF73C, 0xFFFF, 0xFFDE, 0xFF9E, 0xFFBF, 0xFFDE, 0xFFDE, 0xFFDF, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF79E, 0xEF18, 0xEF38, 0xFFDE, 0xF7BC, 0xF7BB, 0xD696, 
        0x944D, 0x6BE5, 0x7C85, 0x8CE7, 0x94EA, 0x94C7, 0x94C8, 0x94C7, 0x94C5, 0x7CA9, 0x7486, 0x7464, 0x6C24, 0x6C25, 0x6BE4, 0x6383, 0x5B42, 0x5B42, 0x5B43, 0x5B64, 0x5B64, 0x5B84, 0x5B63, 0x52E2, 0x4A40, 0x31E1, 0x1921, 0x31C3, 0x6367, 0x2201, 
        0x3A43, 0x52C6, 0x6327, 0x5B49, 0x6348, 0x4225, 0x18C3, 0x8C73, 0xD6DB, 0xFFDE, 0xFFDD, 0xFF1A, 0xF6D8, 0xE696, 0xD654, 0xC572, 0xBD52, 0xD616, 0xE71B, 0x6A07, 0x48A2, 0x69E6, 0xAC6F, 0x836D, 0x4965, 0x40A3, 0x7125, 0x70E6, 0x48A4, 0x3042, 
        0x38E4, 0xD679, 0x630B, 0x4924, 0x8A06, 0x20A2, 0x636C, 0xBE17, 0xF77D, 0xED56, 0xF5F9, 0xFE1A, 0xFD57, 0xFD36, 0xF4F5, 0xF535, 0xF595, 0xF4B3, 0xFCF3, 0xE4B2, 0xBBAE, 0x8B8A, 0x5A26, 0x7AC9, 0xDDD4, 0xFF9D, 0xEE78, 0xE574, 0xED94, 0xF6F8, 
        0xEEB7, 0xEE96, 0xEEB7, 0xF73A, 0xF75C, 0xAD13, 0x4125, 0xDBF4, 0xC30F, 0x8188, 0x4083, 0x8269, 0x8228, 0x7165, 0x6903, 0xC491, 0xDD53, 0xE553, 0xD4AF, 0x50E4, 0x5924, 0x79E6, 0x92A9, 0x7A67, 0xA3AC, 0xC4D0, 0xC4D0, 0x4103, 0x82E9, 0xAC0D, 
        0x934B, 0x6144, 0xBD13, 0xEF1C, 0xEE38, 0xDCF0, 0xED54, 0xBBEF, 0x60A2, 0x4061, 0x9AAA, 0xDC10, 0xE452, 0xBCF2, 0xCCD2, 0xDCD2, 0xDCD2, 0xD4F2, 0xEE16, 0xFEDA, 0xFF3C, 0xFF7D, 0xFF9C, 0xFFBD, 0xE71B, 0x5124, 0x79C7, 0xAAEC, 0xC36E, 0xC2CB, 
        0xBA4A, 0xD411, 0xF77D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xDE57, 0x8BAD, 0x1061, 0x0820, 0x3163, 0x4245, 0x4286, 0x93AE, 0xD618, 0xF79D, 0xFFDD, 0xEF7C, 0x838B, 0x28E1, 0x0840, 0x41C3, 0xA4CD, 0xCDF1, 0xA4AC, 0x2942, 0x3182, 0x3182, 
        0x2941, 0x7BA8, 0x6AE5, 0x5243, 0x5243, 0x6A85, 0x62A4, 0x5AA3, 0x5AA3, 0x7304, 0x8B66, 0xB44A, 0xE58F, 0x9470, 0x4207, 0x1061, 0x0800, 0x0000, 0x0000, 0x1081, 0x2943, 0x2860, 0x1861, 0x62EB, 0xDEDA, 0x62EA, 0x2103, 0x2102, 0x52A5, 0xC5AD, 
        0x93C9, 0x72C5, 0x83A5, 0xB5AC, 0xCDD1, 0xCD37, 0xB43C, 0xB4D9, 0xAC77, 0xA413, 0xA40C, 0x8401, 0x7360, 0x7B82, 0x8C65, 0x83A5, 0x9CA4, 0xB4CC, 0xAB9D,
  0x7A31, 0x7A32, 0x7A32, 0x7A32, 0x8252, 0x7A51, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x8252, 0x8272, 0x8252, 0x8252, 0x7A52, 0x7A52, 0x7A52, 0x7A52, 0x7A52, 0x7A52, 0x8273, 0x8253, 0x8A53, 0x8253, 0x8253, 0x8273, 0x8A73, 0x7232, 0x7A52, 0x8273, 
        0x8A73, 0x8A73, 0x8A73, 0x8A73, 0x8A73, 0x8A53, 0x8A73, 0x8A73, 0x8273, 0x8A73, 0x8A73, 0x8A73, 0x8A93, 0x8A93, 0x8A73, 0x8A73, 0x8A93, 0x8273, 0x8A94, 0x8A94, 0x8AB3, 0x8AB5, 0x8A95, 0x8A54, 0x8253, 0x9274, 0x8A54, 0x79F3, 0x6992, 0x61AD, 
        0x596C, 0x618C, 0x71ED, 0x50A7, 0x48C5, 0x832D, 0xEF7D, 0xFFFF, 0xFFDF, 0xFFBF, 0xFF9F, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xEEB8, 0xF77B, 0xFFDE, 0xFFDF, 0xFFFF, 0xE75B, 0xA4D1, 
        0x4163, 0x8448, 0x7C44, 0x7401, 0x7C22, 0x7C45, 0x8445, 0x8445, 0x8445, 0x84C6, 0x84A5, 0x7C85, 0x7C65, 0x6C03, 0x63A3, 0x6383, 0x6BC3, 0x5321, 0x5B64, 0x6B86, 0x6B86, 0x5B83, 0x5B62, 0x6342, 0x6343, 0x4AA2, 0x4AC2, 0x42C3, 0x3283, 0x42A3, 
        0x4AC4, 0x52E4, 0x5B04, 0x6387, 0x7C08, 0x8C89, 0x8448, 0x2902, 0x736A, 0xC5F4, 0xF79D, 0xFF1A, 0xF718, 0xE6D6, 0xD614, 0xCD53, 0xCD12, 0xDDF6, 0xDEDB, 0x28E4, 0x50A2, 0x9228, 0xC40F, 0x634B, 0x4964, 0x60C3, 0x9146, 0x7044, 0x4022, 0x38E1, 
        0x7AC5, 0xDE33, 0x62A9, 0x4061, 0x8061, 0x20A2, 0xA513, 0xF77D, 0xFF7D, 0xFFBF, 0xFF9F, 0xFF1D, 0xFE9B, 0xFEFC, 0xFE5A, 0xF618, 0xF678, 0xFF5B, 0xF6F9, 0xCD32, 0x82A8, 0x942D, 0xAD30, 0x83AC, 0x4144, 0xE657, 0xFF7C, 0xF6FA, 0xEDD5, 0xF635, 
        0xF697, 0xF6B7, 0xF695, 0xFF38, 0xF77B, 0xAD13, 0x38C4, 0xC22D, 0xEBF3, 0xCC12, 0x8A8B, 0x68E5, 0x9A2A, 0xB2ED, 0xA2AD, 0x71A6, 0x8267, 0x92E7, 0x9348, 0xCD13, 0xD553, 0xB48F, 0x8B48, 0xABED, 0xAC0D, 0xA3EC, 0xB40B, 0xEEB5, 0xBC8E, 0xA38B, 
        0xA40D, 0x20C3, 0x6A88, 0xBD33, 0xEF3B, 0xC42D, 0xE553, 0xF618, 0xED97, 0xC44F, 0xAACB, 0xBAAB, 0xE3EE, 0xCD35, 0xD4F3, 0xDCD2, 0xDCD2, 0xE512, 0xEDD4, 0xFE98, 0xFF1B, 0xFF3B, 0xFF5B, 0xFF9D, 0xF75C, 0xB36B, 0xAB8C, 0xC4B2, 0xEDD7, 0xBB2D, 
        0xAAAB, 0xA2CB, 0xABF0, 0xF77D, 0xFFFF, 0xFFFE, 0xF7FD, 0xFF9D, 0xF79D, 0xA513, 0x20A2, 0x0861, 0x39C6, 0x8C4D, 0xD674, 0x2944, 0x738D, 0xC638, 0xF7DE, 0xEF58, 0x630A, 0x1902, 0x29C1, 0x20C1, 0x5A65, 0xAC8C, 0xD5F2, 0x20E3, 0x3182, 0x4A03, 
        0x41C2, 0x5284, 0x5A84, 0x5A43, 0x5202, 0x8306, 0x72E5, 0x6AA3, 0x6A82, 0x8368, 0xAC4C, 0xA3CA, 0x8306, 0xEED9, 0xF698, 0xD5B4, 0x9CD1, 0xAC70, 0xACD1, 0xA4B0, 0xA44F, 0xCE36, 0x62CA, 0x6AEA, 0xEED7, 0xF7BD, 0xC5D7, 0x734D, 0x2903, 0x8BC9, 
        0x9C6A, 0x7C07, 0x5B22, 0x93AA, 0xA3EF, 0xA40F, 0xA44C, 0xACD6, 0xAC99, 0xA414, 0x8BC9, 0x7C42, 0x7B81, 0x72C3, 0x6284, 0x7381, 0x9CC5, 0xACCE, 0xA3BA,
  0x7A32, 0x7A32, 0x7A32, 0x7232, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A52, 0x8252, 0x7A52, 0x7A51, 0x7A53, 0x7A53, 0x7A53, 0x7A33, 0x7A32, 0x8252, 0x8252, 0x8232, 0x8232, 0x8253, 0x8253, 0x8253, 0x7A53, 0x8253, 0x8A53, 
        0x8A73, 0x8A73, 0x8A73, 0x8A73, 0x8253, 0x8A53, 0x8A53, 0x8273, 0x8A73, 0x8273, 0x8273, 0x8273, 0x8274, 0x8A73, 0x8A73, 0x8A73, 0x8A93, 0x8A73, 0x8A94, 0x8A94, 0x8A73, 0x8274, 0x8A94, 0x8A94, 0x8AB4, 0x8AB4, 0x8A94, 0x8254, 0x7A14, 0x7234, 
        0x59CF, 0x620F, 0x8AD3, 0x6A0F, 0xBD38, 0xEF7E, 0xFFFF, 0xFFBF, 0xFFBF, 0xFF9F, 0xFF9E, 0xFFDE, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xF716, 0xFF9B, 0xFFFF, 0xFFFF, 0xEF5B, 0x6B2C, 0x6AEA, 
        0xDEB7, 0xEF96, 0xDF14, 0xC610, 0x9C8A, 0x6B83, 0x73C3, 0x6BA3, 0x5B22, 0x6360, 0x6BA2, 0x73E3, 0x7425, 0x8CA7, 0x8445, 0x73E4, 0x6383, 0x5B83, 0x6384, 0x6B85, 0x6365, 0x5322, 0x6363, 0x6BA5, 0x6386, 0x39E1, 0x3A21, 0x3A62, 0x3A83, 0x52E3, 
        0x5323, 0x5323, 0x5B04, 0x63E5, 0x5365, 0x63E8, 0x9D4D, 0xA50A, 0x7B05, 0x8B48, 0xDDF3, 0xFF9D, 0xEEDA, 0xEE37, 0xEDF5, 0xBD51, 0xB592, 0xCE97, 0xDEFB, 0x2924, 0x6247, 0x9BAC, 0x9C2E, 0x6289, 0x5104, 0x58E3, 0x61C4, 0x4862, 0x3821, 0x5143, 
        0x9369, 0xC613, 0x5A88, 0x1841, 0x2061, 0x9B2B, 0xDE37, 0xFFDE, 0xFFDF, 0xF6FB, 0xD595, 0xD5F6, 0xF7BE, 0xFFFF, 0xFFFF, 0xFFBE, 0xF75C, 0xFFDE, 0xEF3B, 0xB552, 0x6AC4, 0x9CCA, 0x944B, 0x5AA7, 0x20C2, 0xA3AB, 0xBC4F, 0xD595, 0xF77D, 0xF5F6, 
        0xF5D4, 0xF656, 0xF738, 0xFF39, 0xF75C, 0xB513, 0x50E4, 0xB2AE, 0xDC55, 0xC3F3, 0x79E8, 0x89E8, 0x99EA, 0x8169, 0x58A6, 0x7144, 0x7144, 0x6144, 0x61A5, 0x9B8D, 0xABAD, 0xA38A, 0x93A9, 0xD531, 0xAC0D, 0x936A, 0xA3AA, 0xA44B, 0xAC8D, 0xA44C, 
        0x7B68, 0x4162, 0x7AE7, 0xBC8D, 0xEE13, 0xF77D, 0xF658, 0xE552, 0xCCAF, 0xECB4, 0xBB6D, 0xAB2B, 0xD430, 0xE492, 0xDCB1, 0xD471, 0xC430, 0xC4F3, 0xE6DA, 0xFF9D, 0xF75B, 0xF71A, 0xFF3B, 0xFF9C, 0xF77C, 0xA3EE, 0xB3CD, 0xD491, 0xDD15, 0xA30C, 
        0xD4B3, 0xED76, 0xD4B2, 0x832D, 0x736E, 0x632C, 0x5AEB, 0xE73C, 0xD6B9, 0x7C0F, 0x18C2, 0x3A24, 0x5B27, 0x83CA, 0x9BED, 0x2904, 0x9C50, 0xEEFA, 0xEF5C, 0x8B8A, 0x3943, 0x2102, 0x4245, 0x39C1, 0x18C1, 0x39C5, 0x83EB, 0x3A02, 0x31A1, 0x39C2, 
        0x4222, 0x4244, 0x4A23, 0x4A03, 0x4A22, 0x5A63, 0x6AC4, 0x72C4, 0x72A3, 0x9BAB, 0xC4AF, 0xC4AF, 0xAC0D, 0xAC4C, 0xCD11, 0xDDB4, 0xE637, 0xFE77, 0xFEB7, 0xFEB7, 0xFED8, 0xF75B, 0x9C0E, 0x934A, 0xD5B4, 0xFFBD, 0xF7BE, 0xBD94, 0x5A24, 0x5A66, 
        0x9C0C, 0x93CA, 0x5202, 0x7B63, 0x9407, 0x93C8, 0x8325, 0x8C24, 0x9409, 0x93EC, 0x8C2B, 0x8C62, 0x83E3, 0x9C49, 0xBD2F, 0x5B62, 0x8424, 0xAC8C, 0xAC17,
  0x7A12, 0x7212, 0x7212, 0x7A12, 0x7232, 0x7A32, 0x7232, 0x7232, 0x7A32, 0x7A32, 0x7A52, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A53, 0x7A33, 0x7A32, 0x7233, 0x7A52, 0x7A52, 0x7A32, 0x8232, 0x8252, 0x8253, 0x8253, 0x8253, 0x8A53, 0x8253, 0x8253, 
        0x8253, 0x8253, 0x8253, 0x8253, 0x8253, 0x8A73, 0x8253, 0x8A53, 0x8A73, 0x8A73, 0x8A73, 0x8253, 0x8A53, 0x8273, 0x8A73, 0x8A73, 0x8A73, 0x8A73, 0x8A93, 0x8A73, 0x8A53, 0x8A94, 0x8A94, 0x8A73, 0x8A73, 0x8A73, 0x8A94, 0x9AD6, 0xA2D7, 0x4930, 
        0x8B14, 0xBC76, 0xAC73, 0x61E8, 0xBD55, 0xF7BE, 0xFFDE, 0xFFBF, 0xFFBF, 0xFFBF, 0xFFBF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xF7BE, 0xF7BB, 0xFFDD, 0xFFFF, 0xEF5C, 0x9385, 0xCDB0, 0xF77A, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xF799, 0xF778, 0xEF37, 0xDEB5, 0xA4EC, 0x8427, 0x6B83, 0x52C0, 0x52A0, 0x6B83, 0x7404, 0x63E4, 0x7405, 0x5B63, 0x5322, 0x5B64, 0x73C4, 0x6BA5, 0x4263, 0x2103, 0xC632, 0xA550, 0x5B29, 0x21A1, 0x4B23, 
        0x5364, 0x4B03, 0x4A82, 0x6CA7, 0x6489, 0x7D0A, 0x9DAA, 0x18E1, 0x3120, 0x4120, 0x4103, 0xE6FB, 0xEE57, 0xEDD5, 0xEE37, 0xA4EF, 0xCE77, 0xBDB5, 0x7A47, 0x6081, 0x6247, 0x7BED, 0x94AE, 0x5288, 0x48E4, 0x50E3, 0x59E5, 0x48C1, 0x4061, 0x7185, 
        0xBBED, 0xA52F, 0x4A26, 0x1041, 0x20C3, 0xE616, 0xFF7C, 0xFFFF, 0xFFDE, 0xEE59, 0xD5D6, 0xCE16, 0xCE99, 0x9472, 0xD659, 0xFFDE, 0xFFFF, 0xFFFF, 0xEF7C, 0xB573, 0x62E5, 0x9D0B, 0x6B25, 0x3180, 0x20E1, 0x6B09, 0x8AA7, 0x8AA8, 0x7BCE, 0xEF5C, 
        0xEE98, 0xEDF4, 0xF615, 0xF719, 0xF75C, 0xBD13, 0x68E4, 0xBAAD, 0xDC95, 0xB3D1, 0x5904, 0xA228, 0x89EA, 0x798A, 0x7969, 0x6145, 0x7125, 0x89C8, 0xAACB, 0x7187, 0x6965, 0x92C9, 0xD512, 0xCCCE, 0xCCEF, 0xCD31, 0xCD31, 0xB42C, 0xDDF2, 0xEEF6, 
        0xDE93, 0xB4AD, 0x9BE8, 0xB4AB, 0xEEB6, 0xFFBD, 0xF637, 0xC40D, 0x9244, 0xE452, 0xBBEE, 0xAB8D, 0xCBF0, 0xE533, 0xE4F3, 0xCC10, 0xB38D, 0xF67A, 0xFF9E, 0xFFDD, 0xFF9B, 0xF6F9, 0xFF19, 0xFF5A, 0xF79C, 0xCDF6, 0xA3CD, 0x9AEA, 0xBBCF, 0xF71B, 
        0xFF5D, 0xF71C, 0xDE37, 0x4269, 0x10C3, 0x0800, 0x20E3, 0xD69A, 0x738E, 0x20E3, 0x0820, 0x2921, 0x7B48, 0x8BC9, 0x5224, 0x18C3, 0xA514, 0xF7BE, 0xE71C, 0x2104, 0x2983, 0x4A44, 0x4A44, 0x2963, 0x2962, 0x2961, 0x2161, 0x5A05, 0x41C2, 0x31C1, 
        0x3201, 0x31C3, 0x2983, 0x4204, 0x6306, 0x3A03, 0x5243, 0x6263, 0x6A62, 0xA347, 0xC48D, 0xCD10, 0xC4CF, 0xB48D, 0xB44D, 0xAC2E, 0xB44F, 0xCCF0, 0xCD10, 0xCD31, 0xDD72, 0xEEB5, 0xB54F, 0xB550, 0xF717, 0xFF17, 0xFF58, 0xDE98, 0xA4B7, 0x8AF3, 
        0xA3B4, 0xA3D2, 0x830C, 0x5AE2, 0x7323, 0x9369, 0xABCE, 0x9462, 0x8C40, 0x8C44, 0x944A, 0x8C06, 0x9405, 0x9C87, 0xAD4B, 0xA489, 0x9C85, 0x9C4A, 0x9BB7,
  0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x8252, 0x7A32, 0x7A32, 0x7A32, 0x7A52, 0x7A52, 0x7A52, 0x8252, 0x8252, 0x8252, 0x7A52, 0x7A53, 0x8252, 0x8252, 0x7A53, 0x7A52, 0x8253, 0x8252, 0x8253, 0x8A53, 0x8252, 0x8253, 0x8253, 0x8252, 0x8A73, 0x8273, 0x8273, 
        0x8A53, 0x8273, 0x8A73, 0x8273, 0x8253, 0x8A73, 0x8A73, 0x8253, 0x8A73, 0x8A73, 0x8A73, 0x8A73, 0x8A94, 0x8293, 0x8273, 0x8A73, 0x8A93, 0x8A93, 0x8A93, 0x8A93, 0x8AB4, 0x8A94, 0x8A94, 0x8A94, 0x8A94, 0x8A93, 0x8A94, 0x7A12, 0x6990, 0xDD3B, 
        0xEE9C, 0x9CD2, 0x2945, 0xD635, 0xF79C, 0xFFBF, 0xFF7F, 0xFFDE, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xFF9C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFC, 0xFFFE, 0xFFFF, 
        0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFD, 0xF7DA, 0xBDF1, 0x6306, 0x31A1, 0x3A21, 0x7C87, 0x73E6, 0x6B85, 0x63A3, 0x5AC2, 0x2941, 0x5287, 0xCE54, 0xEF7C, 0x844E, 0x4A45, 0x4222, 0x5BC5, 
        0x5BA4, 0x63A5, 0x6BA6, 0x3AC2, 0x844A, 0x944B, 0x7285, 0x6184, 0x7183, 0x5121, 0x20A2, 0xA42F, 0xDE99, 0xDEB9, 0xBD52, 0xD552, 0xE699, 0xA4F3, 0x38C3, 0x89C9, 0x7AEB, 0x740D, 0x950F, 0x944F, 0x61C7, 0x4904, 0x5225, 0x6A47, 0x4903, 0x40C1, 
        0x6A65, 0xDEB7, 0x5AEA, 0x0841, 0x18A3, 0xE5D7, 0xF73C, 0xCDD6, 0x8B0B, 0xB513, 0xDE9A, 0x9CF3, 0x18A3, 0x28C3, 0x1882, 0x39A6, 0x9C91, 0xF79D, 0xF7BE, 0xBDD4, 0x62C3, 0x8445, 0x9CA9, 0x7387, 0x2941, 0x18A2, 0x9C2F, 0xBC70, 0x7145, 0x426A, 
        0xB5B6, 0xF71B, 0xF67A, 0xFFBC, 0xF73A, 0xBC91, 0x68E4, 0xB30F, 0xDCB4, 0xCC52, 0x8A69, 0x89A7, 0x68C5, 0x6085, 0x8128, 0xBB2F, 0xBB0E, 0xB2CD, 0xAAED, 0xBBAF, 0x79A6, 0x60C2, 0x81C5, 0x8A68, 0x69A5, 0x79E7, 0xA32D, 0xAC6A, 0x9C48, 0x83A9, 
        0x632A, 0x8B87, 0x9BC8, 0x8B06, 0x6A24, 0xEF3B, 0xFF9C, 0xFED9, 0xF574, 0xA208, 0xC3AC, 0xCC4F, 0xBB6D, 0xE4D3, 0xED14, 0xDC52, 0xC3D0, 0xF77C, 0xFFDE, 0xFF9E, 0xFF7C, 0xFF7B, 0xF73A, 0xFEF9, 0xFF1A, 0xFFDE, 0xFFDE, 0xE659, 0xCC30, 0xD553, 
        0xEE38, 0xFF1C, 0xFFDF, 0xFFDF, 0xE6FA, 0xB552, 0x62C9, 0x1061, 0x1041, 0x20C3, 0x31A6, 0x59E5, 0x4162, 0x6265, 0xB4AC, 0xB4B3, 0xDE7A, 0xCE38, 0x738C, 0x1081, 0x2162, 0x31E3, 0x39E3, 0x4223, 0x4A43, 0x39C2, 0x1921, 0x5A64, 0x4203, 0x2981, 
        0x2940, 0x3182, 0x1921, 0x2142, 0x4A45, 0x6306, 0x62E5, 0x62A4, 0x6AC5, 0xCCED, 0xCCCD, 0xBC6C, 0xB46D, 0xBC6E, 0xBC8F, 0xB48F, 0xB4AE, 0xCD11, 0xDD52, 0xDD52, 0xD531, 0xDD53, 0xE5D4, 0xB46F, 0x6A47, 0xE6FB, 0xCDF3, 0x9C32, 0x8B5A, 0xC4BE, 
        0xC49B, 0xBC78, 0xAC54, 0x6AE7, 0x83A7, 0xA429, 0xA448, 0x8BC5, 0x8404, 0x9485, 0xB527, 0x83A9, 0x8BC9, 0x8BC6, 0x83A2, 0xB54C, 0xB50B, 0xB48F, 0xAC18,
  0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A52, 0x7A32, 0x7A32, 0x7A32, 0x7A52, 0x7A32, 0x7A52, 0x8252, 0x7A52, 0x8252, 0x7A52, 0x7A52, 0x8252, 0x8252, 0x8253, 0x7A52, 0x8253, 0x8253, 0x8253, 0x8A53, 0x8252, 0x8253, 0x8253, 0x8252, 0x8253, 0x8A53, 0x8A73, 
        0x8A73, 0x8A73, 0x8A73, 0x8253, 0x8253, 0x8A73, 0x8A73, 0x8253, 0x8253, 0x8A73, 0x8A73, 0x8A73, 0x8A73, 0x8A93, 0x8A93, 0x8A93, 0x8A93, 0x8A93, 0x8A73, 0x8A93, 0x8A94, 0x8A93, 0x8A93, 0x8A93, 0x8A94, 0x8A94, 0x8A94, 0x71F2, 0x616F, 0xE59C, 
        0xCD58, 0x834D, 0x5165, 0xE71B, 0xFFBE, 0xFF9E, 0xFF7F, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFBE, 0xFF7D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFDA, 0xFFFB, 0xFFFD, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF79D, 0xD696, 0x9469, 0x18C1, 0x29A0, 0x3A20, 0x2980, 0x3182, 0xAD51, 0xF79B, 0xFFFD, 0xEF7D, 0x7C0D, 0x4223, 0x4263, 0x63E6, 
        0x63E5, 0x63C5, 0x63A6, 0x53A3, 0x6BA6, 0x7B27, 0x7A65, 0x8A45, 0x7985, 0x8A47, 0xAC0A, 0x2924, 0x9CF3, 0xD678, 0xBD31, 0xDE36, 0xD5D5, 0xABCE, 0x70A5, 0x6863, 0x7AEB, 0x8CAF, 0x94F1, 0x8CAF, 0x6A69, 0x5965, 0x5A25, 0x738B, 0x59E7, 0x4924, 
        0x6A67, 0xDEB5, 0x62E9, 0x1061, 0x3103, 0xDEBA, 0xA4D3, 0x5229, 0x1061, 0x5963, 0x4985, 0x4125, 0x40E4, 0x4944, 0x2082, 0x0000, 0x18E3, 0xDEFB, 0xEEFB, 0xA491, 0x39A3, 0x9466, 0xA509, 0x7BE7, 0x3181, 0x1081, 0x72C9, 0xC574, 0xDEDA, 0x2904, 
        0x59A6, 0x9B4C, 0xCD13, 0xF79C, 0xEF1A, 0xAC70, 0x5104, 0xD414, 0xDC33, 0xAAED, 0x7965, 0xB2EB, 0x9A6A, 0x89A9, 0x8107, 0x91C8, 0x9A09, 0x9A09, 0x89A8, 0x4841, 0x5082, 0x7124, 0x89A6, 0x58A3, 0x4042, 0x5925, 0x8A8A, 0x59C1, 0x40E0, 0x2060, 
        0x1881, 0xA3E9, 0xB44A, 0x9BA7, 0x82E4, 0xCDF6, 0xEF1A, 0xFED9, 0xF574, 0xCACA, 0xD40E, 0xCC70, 0xB38E, 0xCC51, 0xCC51, 0xD410, 0xE430, 0xFF7D, 0xFFBC, 0xFF7B, 0xFF7C, 0xF77B, 0xFF3A, 0xFF1A, 0xFF1A, 0xF6F9, 0xF75B, 0xE6B9, 0xC534, 0xCC70, 
        0xEDF7, 0xEEBA, 0xE658, 0xD5D4, 0xEF1A, 0xF77C, 0xD677, 0x5A89, 0x20E3, 0x18A2, 0x3964, 0x3983, 0x28E1, 0x4983, 0x93AA, 0xEF7C, 0xF7BE, 0xA514, 0x18E3, 0x3A03, 0x31E3, 0x29C3, 0x29E2, 0x4A23, 0x4223, 0x4A64, 0x52A5, 0x52A5, 0x41E3, 0x3161, 
        0x2942, 0x2102, 0x2142, 0x2141, 0x2942, 0x7348, 0x5AA4, 0x5A63, 0x8367, 0xC44C, 0xC46D, 0xC48D, 0xBC8D, 0xB42E, 0xAC4D, 0xAC6E, 0xB48F, 0xAC2E, 0xC4AF, 0xD511, 0xDD53, 0xE595, 0xD553, 0x9BED, 0x6228, 0xAC51, 0x728A, 0x6A4A, 0x9C13, 0x9C10, 
        0x93B0, 0xA3F0, 0xBCAF, 0x7384, 0x83C4, 0x93C3, 0x9381, 0xA4A8, 0xACAF, 0xAC92, 0xA44F, 0x8369, 0x940A, 0x9408, 0x8BA3, 0xACED, 0xB4D0, 0xBC55, 0xBBFD,
  0x7212, 0x7212, 0x7212, 0x7212, 0x7A31, 0x7A32, 0x7232, 0x7232, 0x7A32, 0x7A32, 0x7A32, 0x7A31, 0x7A32, 0x7A52, 0x7A32, 0x7A32, 0x7A53, 0x7A53, 0x7A53, 0x7A53, 0x7A52, 0x7A52, 0x7252, 0x7232, 0x8A53, 0x8A53, 0x8253, 0x8232, 0x8A53, 0x8A53, 0x8253, 
        0x8253, 0x8253, 0x8253, 0x8253, 0x8253, 0x8A53, 0x8A53, 0x8A53, 0x8A53, 0x8253, 0x8A53, 0x8A73, 0x8A93, 0x8253, 0x8273, 0x8A73, 0x8A73, 0x8A73, 0x8A73, 0x8A73, 0x8273, 0x8273, 0x8A73, 0x8A73, 0x8273, 0x8A74, 0x8A94, 0x9274, 0x9254, 0x6A51, 
        0x828E, 0xB472, 0xF79D, 0xFFFE, 0xFFBE, 0xFF9E, 0xFF7F, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xFFBE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xF7D7, 0xFFFB, 0xFFFE, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDE, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xEF7C, 0x8409, 0x73E7, 0x8427, 0x9C89, 0xF79C, 0xFFFE, 0xF77B, 0xE6F7, 0xEF9C, 0xA572, 0x52E7, 0x2942, 0x7C69, 
        0x7468, 0x6C06, 0x6405, 0x6CE8, 0x7C49, 0x7B07, 0x7162, 0x71C7, 0x5904, 0x830B, 0xD677, 0x3185, 0x9CF3, 0xD637, 0xB4AF, 0xE6FB, 0x8AEC, 0x5862, 0x6042, 0x78E5, 0x93AC, 0x950F, 0x84EE, 0xA531, 0x6A69, 0x4924, 0x51C6, 0x6BAC, 0x6309, 0x6AA8, 
        0x7B6A, 0xB5D1, 0x4A87, 0x1881, 0x4183, 0xDEDA, 0xB554, 0x5AA9, 0x0841, 0x0000, 0x0820, 0x3944, 0x7B09, 0x41A5, 0x18A2, 0x2945, 0x62AA, 0x28A2, 0x6A89, 0x7B6A, 0x5AE4, 0x6BC4, 0x9488, 0x8C27, 0x5AE3, 0x5A83, 0x4142, 0x7B0C, 0xE6FB, 0xC44F, 
        0x5185, 0x4040, 0x88C3, 0xA555, 0xCDB5, 0xB3AE, 0x70E4, 0xE414, 0xDC34, 0x9AAC, 0x48A3, 0xB2AB, 0xA28B, 0x81A9, 0x6884, 0x6883, 0x78E5, 0x70E5, 0x5883, 0x4021, 0x50A4, 0x50A4, 0x4882, 0xB36E, 0x9B6D, 0x82A9, 0x71A6, 0x3081, 0x2061, 0x5247, 
        0xBD50, 0xB42A, 0xB46A, 0x9B67, 0x71E3, 0xE5F5, 0xF6FB, 0xF69A, 0xED33, 0xE3EF, 0xE4D2, 0xD4B1, 0xB3AE, 0xCBEF, 0xCBEF, 0xD4B2, 0xE658, 0xFFBE, 0xFF7C, 0xFF5B, 0xFF7C, 0xF739, 0xF6F9, 0xF6F9, 0xFF19, 0xFEDA, 0xFF7C, 0xF77C, 0xE6D9, 0xDD95, 
        0xE5D6, 0xEDD6, 0xDD75, 0xDE37, 0xE658, 0xEEDA, 0xF7BD, 0xEF5C, 0x5AEB, 0x0841, 0x0841, 0x4A05, 0x2923, 0x3984, 0x8C0C, 0xCE79, 0x738F, 0x2946, 0x1061, 0x29A4, 0x31C3, 0x31A3, 0x31A3, 0x39C2, 0x4223, 0x4244, 0x4224, 0x6B07, 0x5285, 0x41E4, 
        0x39A4, 0x0841, 0x2102, 0x3183, 0x3142, 0x31A3, 0x4A45, 0x4A44, 0x5203, 0xDD4E, 0xCC8C, 0xB40B, 0xB44D, 0xBC8E, 0xAC0C, 0xA3EC, 0xAC2D, 0xB46F, 0xAC4D, 0xBD0F, 0xE654, 0xB470, 0x936A, 0x8327, 0x8B67, 0x7325, 0x8387, 0x8387, 0x7B63, 0x83C4, 
        0x9405, 0x9425, 0x9425, 0x7B41, 0x7362, 0x83C6, 0xA44B, 0xB466, 0xA467, 0xA44F, 0xABDB, 0x82CA, 0x8BC5, 0x9CA7, 0xACAE, 0xB414, 0xB3D7, 0xABD9, 0xAB9C,
  0x7A32, 0x7A32, 0x7A32, 0x7A52, 0x7A52, 0x7A32, 0x7A32, 0x7A32, 0x7A52, 0x7A52, 0x7A52, 0x8252, 0x7A52, 0x8252, 0x7A52, 0x7A52, 0x8253, 0x8252, 0x7A52, 0x7A52, 0x8253, 0x8272, 0x8252, 0x8252, 0x8A53, 0x8253, 0x8253, 0x8253, 0x8A73, 0x8273, 0x8273, 
        0x8A73, 0x8A53, 0x8A73, 0x8A73, 0x8273, 0x8A73, 0x8A73, 0x8A73, 0x8253, 0x8A73, 0x8A73, 0x8A94, 0x8A94, 0x8A73, 0x8A93, 0x8A93, 0x8A73, 0x8A73, 0x8A94, 0x8A93, 0x8A93, 0x8A94, 0x8A94, 0x8A94, 0x8A93, 0x8A93, 0x8A94, 0x92B5, 0x92B5, 0x50EC, 
        0x82F0, 0xC577, 0xF7BE, 0xFF9E, 0xFFBE, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xF7B6, 0xFFDB, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF7DE, 0xF7BE, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDC, 0xF759, 0xF71A, 0xFF3D, 0xFFBC, 0xF7BD, 0xAD73, 0x31C2, 0x3A82, 
        0x5B84, 0x6BE6, 0x6BE7, 0x7D6A, 0x8CEC, 0x938A, 0x89E5, 0x6946, 0x50C4, 0x830C, 0xD679, 0x3166, 0xA4F3, 0xF79C, 0xEF39, 0x72A9, 0x7986, 0x8905, 0x88E6, 0xAAAC, 0x9C0F, 0x846E, 0x7C2B, 0xADB3, 0x93ED, 0x7209, 0x5107, 0x536A, 0x63CC, 0x636B, 
        0x5B08, 0x848C, 0x948C, 0x9CCD, 0x9CCD, 0x3924, 0xA4D3, 0xC5D6, 0x8B2A, 0x5204, 0x49C1, 0x3120, 0x18A2, 0x844D, 0x4227, 0x6288, 0xC50F, 0x20C2, 0x2061, 0x49A4, 0x7B89, 0x5AC1, 0x7383, 0xA4C9, 0xC5CF, 0x5A63, 0x20C0, 0x2040, 0x5943, 0xDE99, 
        0xAB4C, 0x80C3, 0x7042, 0x2841, 0x8A27, 0xBAAA, 0x99C9, 0xAA8C, 0xDCF6, 0xD4F6, 0x926B, 0x6062, 0x60C4, 0x68E5, 0x70A4, 0x70A4, 0x70A4, 0x6883, 0x6042, 0x6083, 0x5062, 0x7966, 0xD34F, 0x9B0D, 0x7207, 0x4902, 0x3041, 0x69E6, 0xBCCE, 0xD590, 
        0xA42B, 0xA38A, 0xC48C, 0xBCCB, 0x9BC9, 0x9309, 0xD5D6, 0xFEFB, 0xFDF8, 0xF513, 0xECB1, 0xE4F0, 0xE571, 0xC431, 0xD451, 0xDC71, 0xE4B2, 0xFF7D, 0xFF7D, 0xFF5C, 0xFF5C, 0xFF9C, 0xFF5A, 0xFF1A, 0xFEFA, 0xFF5B, 0xFF5B, 0xFF9C, 0xFFBD, 0xE699, 
        0xEE58, 0xF678, 0xFED9, 0xF6DA, 0xF6FA, 0xEEB7, 0xD613, 0xF73B, 0xF77D, 0xA513, 0x18C3, 0x2965, 0x39A5, 0x2922, 0x0820, 0x0000, 0x0000, 0x18C1, 0x31C2, 0x2982, 0x2982, 0x31A3, 0x39E4, 0x29E2, 0x4223, 0x4A44, 0x4243, 0x3141, 0x5265, 0x4A05, 
        0x2103, 0xB553, 0x52A9, 0x18E2, 0x2121, 0x2121, 0x39C3, 0x5224, 0x6A66, 0xA389, 0xAB69, 0xB3CB, 0xCCEF, 0xE533, 0xC4B0, 0xAC0D, 0x9B8C, 0xACCF, 0xC591, 0xC58F, 0x9429, 0x4162, 0x5A85, 0x7BA6, 0x9405, 0x73A3, 0x73A3, 0x7BA3, 0x8BA3, 0x94A6, 
        0x9485, 0x83E3, 0x7341, 0x83E3, 0x9CA7, 0xA508, 0xA4A4, 0xA3A8, 0xABB3, 0xA399, 0x8B17, 0x8367, 0x9BEC, 0xAC15, 0xBBFE, 0xB39D, 0xB37E, 0xB39D, 0xB3DB,
  0x7A52, 0x7A52, 0x7A52, 0x7A32, 0x7A52, 0x7A32, 0x7A32, 0x7A32, 0x7A52, 0x7A32, 0x7A32, 0x8252, 0x8253, 0x7A52, 0x8252, 0x8252, 0x7A52, 0x8252, 0x8253, 0x7A53, 0x8252, 0x8A52, 0x8A53, 0x8A53, 0x8253, 0x8253, 0x8A53, 0x8A73, 0x8A53, 0x8273, 0x8273, 
        0x8A53, 0x8A93, 0x8A73, 0x8A73, 0x8A73, 0x8273, 0x8A73, 0x8273, 0x8253, 0x8253, 0x8A74, 0x8A74, 0x8A93, 0x8A73, 0x8A93, 0x8A93, 0x8A94, 0x8A94, 0x8A93, 0x8A93, 0x8A93, 0x8A93, 0x8A94, 0x8A95, 0x8A94, 0x8A93, 0x8A93, 0x9AD6, 0xA318, 0x310A, 
        0xA516, 0xF79E, 0xFFDF, 0xFFBF, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFD6, 0xFFFB, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xF7BE, 0xFFFF, 0xFFDD, 0xF7BC, 0xF79A, 0xF75B, 0xFF5B, 0xFF5B, 0xFF7C, 0xF75B, 0xF7BD, 0xF7BD, 0xD698, 0x31C3, 
        0x4243, 0x73C8, 0x9D2D, 0x74CB, 0xBE76, 0xCDD6, 0x82A9, 0x40C3, 0x93CE, 0xAC2E, 0x7A45, 0xEF3B, 0xFF9D, 0xF73B, 0xDE14, 0x6945, 0x91A7, 0x9988, 0x78A5, 0xD3B0, 0x9C2E, 0x73EB, 0x6BCA, 0xA571, 0x944E, 0x7A89, 0x5926, 0x632A, 0x6B4B, 0x630A, 
        0x4AE7, 0x73EA, 0xA530, 0xB571, 0x948C, 0x20E3, 0x7B2B, 0xCDD4, 0xF7B9, 0xEF39, 0x8BEB, 0x4161, 0x28C1, 0x6B8A, 0x5265, 0x5265, 0x7B8B, 0x18A2, 0x3965, 0x5206, 0x4A24, 0x7BC6, 0x6B25, 0x7B66, 0x9C6A, 0x6B46, 0x6324, 0x5AE3, 0x6326, 0xE654, 
        0xBC4F, 0x91E8, 0x90A5, 0xBA6A, 0xA1C8, 0x8945, 0x8966, 0xB2CE, 0xDCD5, 0xDCD5, 0xAACD, 0x2862, 0x5062, 0x7084, 0x6865, 0x6883, 0x6863, 0x6842, 0x6042, 0x5882, 0x81A8, 0xB2CB, 0xC34B, 0x50E2, 0x40E1, 0x5A03, 0x93E9, 0xEDD4, 0xD571, 0x9C0B, 
        0x6A86, 0xD4EE, 0xCCED, 0xB48C, 0xA40A, 0x71C6, 0xBD13, 0xEEFB, 0xFE9B, 0xFD95, 0xDC71, 0xDD12, 0xF6D6, 0xCBCF, 0xD431, 0xD491, 0xC4B1, 0xF77D, 0xFF9D, 0xFF5C, 0xFF7C, 0xFF9B, 0xFF5A, 0xFF3A, 0xFF3B, 0xFFBC, 0xFF7B, 0xFF7B, 0xFF9D, 0xFF1C, 
        0xE67A, 0xBD34, 0x9BEE, 0xEE79, 0xFEFA, 0xFF3B, 0xF73C, 0xA48F, 0xD657, 0xE71B, 0xB574, 0x18E3, 0x3985, 0x4A07, 0x39A6, 0x18E1, 0x2141, 0x2982, 0x2181, 0x2143, 0x2983, 0x39C3, 0x4223, 0x3A03, 0x41E2, 0x4A43, 0x5284, 0x3161, 0x3962, 0x2902, 
        0x20E3, 0xC597, 0x7BAE, 0x31A5, 0x10C1, 0x29C2, 0x41E3, 0x49E3, 0x59E4, 0x7A67, 0x92C8, 0xB3AB, 0xD4F0, 0xF636, 0xE593, 0xB46E, 0x8B6A, 0xDD52, 0xC550, 0x8C09, 0x5261, 0x6B02, 0x7384, 0x7BA4, 0x7383, 0x7383, 0x7BE4, 0x8C26, 0x9C28, 0x83A7, 
        0x7384, 0x7BA5, 0x9448, 0x9CE5, 0x9C85, 0x9447, 0x9C28, 0x93C9, 0xAC71, 0xA3F4, 0x7A92, 0xA40D, 0xB454, 0xBBFA, 0xB35E, 0xB3FD, 0xABBD, 0xB3BD, 0xB3DA,
  0x7212, 0x7232, 0x7232, 0x7212, 0x7232, 0x7232, 0x7232, 0x7A32, 0x7A32, 0x7A32, 0x7A31, 0x7A31, 0x7A32, 0x7A32, 0x7A32, 0x7A52, 0x7A33, 0x7A53, 0x7A53, 0x7A32, 0x7A52, 0x8232, 0x8232, 0x8253, 0x8253, 0x8253, 0x8A53, 0x8253, 0x8A53, 0x8A53, 0x8253, 
        0x8233, 0x8273, 0x8253, 0x8253, 0x8273, 0x8A53, 0x8A53, 0x8A53, 0x8A53, 0x8253, 0x8273, 0x8273, 0x8273, 0x8A73, 0x8A73, 0x8A73, 0x8A74, 0x8A74, 0x8A74, 0x8A73, 0x8A73, 0x8273, 0x8A74, 0x8A75, 0x8A74, 0x8273, 0x9B16, 0x8274, 0x490E, 0x82F0, 
        0xCE19, 0xF75E, 0xFF1E, 0xFFDE, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDD, 0xF7D7, 0xFFFB, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFBE, 0xF7DE, 0xF7BC, 0xFF7B, 0xF77B, 0xF79A, 0xF77B, 0xF77B, 0xF79B, 0xEF1A, 0xF6F9, 0xF75B, 0xFFDE, 0xEF18, 
        0xB58F, 0xA56C, 0xADCB, 0x2944, 0x9CD3, 0xD5F8, 0xA3AE, 0x7AA7, 0x9BCA, 0xB48E, 0xCD34, 0xF79E, 0xF75D, 0xA4B2, 0x3145, 0xDD76, 0xAAAC, 0x7863, 0x6862, 0xDB71, 0x936C, 0x6349, 0x63CA, 0xA52E, 0x8C8C, 0x6AA7, 0x48C2, 0x734A, 0x6B8B, 0x4AA8, 
        0x29C3, 0xA56F, 0x6BEB, 0x29C5, 0x1081, 0x5286, 0x3164, 0x630C, 0xD6B9, 0x51E4, 0x2080, 0x2943, 0x62E7, 0x4AC6, 0x5AE8, 0x5AE9, 0x4A48, 0x1082, 0x5A69, 0x732B, 0x5266, 0x3A41, 0x4A40, 0x4A01, 0x5204, 0xA52D, 0x9D2A, 0xA549, 0xB5EB, 0xA4AA, 
        0xB40B, 0xAAA9, 0x88A5, 0xA1C9, 0x9946, 0x8905, 0x9186, 0xBAAE, 0xDCD7, 0xC454, 0x7966, 0x4821, 0x5042, 0x6044, 0x6844, 0x6023, 0x5862, 0x5042, 0x5844, 0x99C6, 0xA247, 0x79A5, 0x4061, 0x6982, 0xBCAD, 0xEE93, 0xEEB2, 0x8AC8, 0x92EA, 0x9B4B, 
        0x9B6A, 0xD54E, 0xCCED, 0xB40B, 0x92E7, 0x51C4, 0xB4F2, 0xEE9A, 0xE5F8, 0xF5D2, 0xDCAF, 0xDCB0, 0xF5B3, 0xEDD3, 0xDC6F, 0xDC4F, 0xEDD5, 0xFF9E, 0xF73D, 0xF73C, 0xFF9C, 0xFFBB, 0xFF5A, 0xFF5A, 0xFF7B, 0xF75B, 0xF75B, 0xF73A, 0xFF3A, 0xF7BE, 
        0xCDF7, 0xA430, 0x934D, 0xEF3C, 0xDE18, 0xD595, 0xE616, 0xC594, 0xCDF5, 0xE6D9, 0xDEFB, 0x18E3, 0x0000, 0x1882, 0x3164, 0x29C4, 0x2162, 0x1921, 0x1921, 0x29A3, 0x31E3, 0x39E3, 0x39C3, 0x29A2, 0x31E2, 0x4243, 0x5284, 0x5204, 0x20C2, 0x0840, 
        0x1081, 0x39E6, 0x6B2B, 0x52A9, 0x1082, 0x31E3, 0x3142, 0x4984, 0x72C9, 0x7224, 0x8A67, 0xA32A, 0xB40B, 0xCCD1, 0xE573, 0xDD71, 0xC50F, 0xEE94, 0x9C89, 0x6303, 0x5AC3, 0x73E2, 0x6B81, 0x6B41, 0x7363, 0x7BE6, 0x7BC8, 0x83C6, 0x83C2, 0x7B42, 
        0x83C4, 0x9485, 0xA4C6, 0xA447, 0x8C07, 0x83A6, 0x8366, 0xBC72, 0xBC95, 0x9BB3, 0x7A71, 0xCC5A, 0xC3FC, 0xB37D, 0xB37C, 0xABBB, 0xABDC, 0xABDB, 0xA396,
  0x7A52, 0x7A32, 0x7A32, 0x7A32, 0x8252, 0x8252, 0x7A52, 0x7A52, 0x7A53, 0x7A53, 0x7A53, 0x8253, 0x7A52, 0x7A52, 0x8252, 0x8252, 0x7A73, 0x7A53, 0x8252, 0x8232, 0x8A53, 0x8253, 0x8253, 0x8A73, 0x8273, 0x8253, 0x8253, 0x8A53, 0x8253, 0x8273, 0x8273, 
        0x8A73, 0x8A53, 0x8A73, 0x8A73, 0x8A73, 0x8253, 0x8A73, 0x8A73, 0x8A54, 0x8A93, 0x8A73, 0x8A73, 0x8A73, 0x8A93, 0x8A73, 0x8A93, 0x8A94, 0x8A94, 0x8A93, 0x8A93, 0x8A94, 0x8A94, 0x8A94, 0x8A73, 0x8A73, 0x92D5, 0x8A75, 0x596E, 0x3906, 0xE71C, 
        0xFF9F, 0xFF7F, 0xFFBE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFD, 0xF7D6, 0xFFFB, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFF9E, 0xFFDF, 0xFFDE, 0xFFBD, 0xF7DC, 0xFF7D, 0xFF7C, 0xFF9C, 0xFF9D, 0xFFBE, 0xF79C, 0xF75C, 0xF73C, 0xF7BB, 
        0xC5F4, 0x734B, 0x1061, 0x0000, 0x18C3, 0x6B6D, 0xDEBA, 0x59E7, 0x49E6, 0x736B, 0xC5D3, 0xEF3B, 0x8B4C, 0x40E1, 0x3122, 0xDD13, 0xD3B0, 0x81C9, 0x3083, 0xAB2F, 0xB3AF, 0x8B6C, 0x5B29, 0x746B, 0x944D, 0x82C9, 0x58C3, 0xA3D0, 0x936E, 0x5A08, 
        0x2123, 0x9D0F, 0x5AC7, 0x2941, 0x2982, 0x4266, 0x2983, 0x1880, 0x1040, 0x3142, 0x39E3, 0x3A24, 0x4A65, 0x5B29, 0x6B6A, 0x6B6B, 0x6B4A, 0x5AE7, 0x7B8C, 0x732C, 0x41E7, 0x5266, 0x940B, 0xB4F0, 0xA48F, 0x6324, 0x63A3, 0x6BE3, 0x73A4, 0xACEC, 
        0xDDB2, 0xC42E, 0x78C4, 0xA949, 0xA128, 0x9106, 0x9106, 0xBA8D, 0xE4F6, 0xE558, 0xB38F, 0x3862, 0x4862, 0x5863, 0x4861, 0x50E2, 0x58C2, 0x70E3, 0x8964, 0x48A1, 0x2061, 0x2985, 0x7C0C, 0xEE36, 0xD593, 0x836B, 0x30E2, 0x920A, 0x6187, 0x4923, 
        0x6A23, 0xE6F7, 0xB510, 0x9BAB, 0x9B6C, 0x5123, 0xA40F, 0xE699, 0xFF9D, 0xFD92, 0xF5B4, 0xF553, 0xF490, 0xFDF4, 0xE510, 0xDC8F, 0xECD3, 0xFEB7, 0xFF7C, 0xF7BD, 0xFF7C, 0xFF5B, 0xFF9B, 0xFF9C, 0xFF9D, 0xFFBD, 0xFFDE, 0xFFDE, 0xF7BC, 0xFFDD, 
        0xFFDE, 0xEEFB, 0xD595, 0xC555, 0xD5B6, 0xE638, 0xEEFA, 0xF7BD, 0xDE78, 0xDE16, 0xEEF9, 0xEF5C, 0x630C, 0x18E2, 0x2983, 0x2141, 0x2942, 0x2943, 0x2961, 0x2982, 0x2982, 0x2982, 0x31A2, 0x4263, 0x4264, 0x4A44, 0x5244, 0x4A44, 0x4A24, 0x4182, 
        0x18A0, 0x1081, 0x6B2B, 0x6B2B, 0x18A2, 0x4208, 0x3184, 0x4A05, 0x936B, 0x7A66, 0x7A68, 0x8269, 0x8AA9, 0xCC2D, 0xB42C, 0xA42D, 0xB490, 0x9CAB, 0x6B25, 0x62C3, 0x7BA4, 0x6B43, 0x73A3, 0x83E5, 0x93E6, 0x7BC4, 0x7363, 0x7B62, 0x83A1, 0x9486, 
        0x9CE8, 0x9467, 0x7B67, 0x9CAC, 0x944A, 0x8BA7, 0x8345, 0xCD78, 0x9B34, 0x8A91, 0xB3F3, 0xBBFE, 0xBBBF, 0xB3BD, 0xB3DB, 0xABBC, 0xA399, 0xA396, 0xA3B5,
  0x7A32, 0x7A52, 0x7A52, 0x7A52, 0x8252, 0x7A52, 0x7A52, 0x8252, 0x8252, 0x7A53, 0x7A53, 0x7A53, 0x8253, 0x8253, 0x8253, 0x7A52, 0x8253, 0x8252, 0x8252, 0x8253, 0x8253, 0x8273, 0x8273, 0x8A74, 0x8A73, 0x8A73, 0x8273, 0x8253, 0x8A73, 0x8273, 0x8273, 
        0x8A73, 0x8A73, 0x8A73, 0x8A73, 0x8A73, 0x8A73, 0x8A73, 0x8273, 0x8274, 0x8A93, 0x8A93, 0x8A93, 0x8AB4, 0x8A93, 0x8A73, 0x8A93, 0x8A93, 0x8A94, 0x8A93, 0x8A94, 0x8A94, 0x8A93, 0x8AB4, 0x8A73, 0x8A52, 0x9B77, 0x61B1, 0x7A72, 0xDDBB, 0xFFBF, 
        0xFFBF, 0xFFBF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDD, 0xFFD6, 0xFFFB, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFBE, 0xFFDF, 0xFFDE, 0xFFBD, 0xFFBD, 0xFFDD, 0xFFDD, 0xFFBD, 0xFFBE, 0xFFBE, 0xFFBE, 0xFF9D, 0xF739, 
        0xBD73, 0x6B0A, 0x1081, 0x0182, 0x0902, 0x5B0C, 0xDEBA, 0x7ACB, 0x5A88, 0x52A8, 0x6349, 0xD6DA, 0x630C, 0x49E6, 0xA3ED, 0xC40D, 0x81A6, 0x68A4, 0x8989, 0xC3F1, 0xAB8E, 0x832B, 0x6329, 0x63EA, 0x83CB, 0x92EA, 0x91A7, 0xA269, 0xA2EC, 0x82CA, 
        0x5A45, 0x840C, 0x4246, 0x3163, 0x4A25, 0x29A4, 0x2122, 0x28C1, 0x38C2, 0x4A06, 0x4A65, 0x4244, 0x4203, 0x6B69, 0x636A, 0x73CC, 0x94B0, 0x6B09, 0x73AB, 0x5AC8, 0x3124, 0xC5D5, 0xEEFA, 0xFF7C, 0xE71B, 0x2184, 0x42E2, 0x7445, 0x8C66, 0x7365, 
        0xA46C, 0xAC0D, 0x9207, 0xB18B, 0xA109, 0x98C7, 0x9907, 0xBAAD, 0xE495, 0xF599, 0xDD35, 0x28A3, 0x4041, 0x5882, 0x58A3, 0x6081, 0x68C2, 0x6082, 0x4020, 0x40E1, 0x9B6B, 0xDDD3, 0xE6D6, 0x6103, 0x6983, 0x5182, 0x28E4, 0xCD59, 0x628C, 0x4185, 
        0x9B8A, 0xE715, 0xA44C, 0x6224, 0x4962, 0x71A4, 0xC574, 0xF7BE, 0xFFBE, 0xF596, 0xFE18, 0xF659, 0xF617, 0xFDD5, 0xF552, 0xED92, 0xEE76, 0xFF7C, 0xF73B, 0xF75B, 0xFFDC, 0xFF9C, 0xFF5B, 0xFF5C, 0xFFBE, 0xFFFF, 0xFFBD, 0xFFBD, 0xFFDE, 0xFFFE, 
        0xF7BD, 0xB513, 0x5125, 0xC493, 0xEEBA, 0xFF9D, 0xF75D, 0xDD96, 0xEE59, 0xF6BA, 0xEE99, 0xEF7D, 0x9C92, 0x49E7, 0x1061, 0x2962, 0x2941, 0x2142, 0x29A3, 0x2942, 0x2982, 0x31A2, 0x3182, 0x39C3, 0x4243, 0x52A4, 0x6305, 0x62A6, 0x6AC6, 0x6B07, 
        0x6AC8, 0x4A02, 0x6306, 0x5AC7, 0x2943, 0x2104, 0x2182, 0x4244, 0x7309, 0x9AE9, 0x92E9, 0x8289, 0x8228, 0xA38C, 0xBC8E, 0xC510, 0xB48F, 0x62A2, 0x6AE3, 0x7B64, 0x7BC3, 0x7345, 0x7B86, 0x7BC6, 0x7BA4, 0x7B63, 0x8BC6, 0x9428, 0x9488, 0x9C27, 
        0x93E8, 0x944A, 0xA4CC, 0x8C24, 0x9C28, 0xA44B, 0x942C, 0x832B, 0x936F, 0xAC15, 0xD49C, 0xA35D, 0xABB8, 0xABF6, 0xABD7, 0xA397, 0xABB7, 0xB3D9, 0xBC1D,
  0x7232, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A12, 0x7A33, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A52, 0x7A52, 0x7A52, 0x7A32, 0x8233, 0x8A33, 0x8253, 0x8233, 0x8253, 0x8253, 0x8253, 0x8233, 0x8253, 0x8A53, 0x8253, 0x8A53, 0x8253, 0x8253, 
        0x8253, 0x8253, 0x8253, 0x8253, 0x8273, 0x8253, 0x8A74, 0x8A74, 0x8A73, 0x8A94, 0x8A73, 0x8273, 0x8A93, 0x8A73, 0x8A73, 0x8A74, 0x8A74, 0x8A73, 0x8A94, 0x8A94, 0x8273, 0x8A73, 0x8A73, 0x8A74, 0x8AB4, 0x8A73, 0x6150, 0x8B14, 0xEF5E, 0xFFFF, 
        0xFFDE, 0xFFBE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFDC, 0xFFB4, 0xFFDA, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFDE, 0xFFBE, 0xFFDD, 0xFFDD, 0xFFBE, 0xEF9D, 0xF7BD, 0xFFDC, 0xFFBC, 0xF7BE, 0xF7BE, 0xF79D, 0xF79C, 0xF7BC, 
        0xC5F5, 0x736B, 0x18E2, 0x0142, 0x08C2, 0x5A29, 0xD514, 0x8B8C, 0x83CD, 0x7C2D, 0x740B, 0x5328, 0x62E9, 0x7B2A, 0x93CC, 0xAB4B, 0xB2AB, 0xBAAD, 0xCB70, 0xD3B1, 0xAB0D, 0x82AA, 0x62E8, 0x5387, 0x5B88, 0x7B4A, 0xA2CA, 0x89C7, 0x9AEB, 0x8AEB, 
        0x6248, 0xB54F, 0x5267, 0x20E3, 0x41C5, 0x49C5, 0x4144, 0x40E3, 0x50A3, 0x6267, 0x4A66, 0x3A24, 0x31C4, 0x5B08, 0x638A, 0x6B8C, 0x6B8B, 0x738A, 0x5267, 0x4A47, 0x7BCC, 0xEEDA, 0xFF9D, 0xDEB9, 0x946F, 0x18E2, 0x52C4, 0x7405, 0x6BC4, 0x8BEA, 
        0xA3CB, 0xA349, 0x9A47, 0xB1CA, 0x98C7, 0x88A5, 0xA188, 0xC28D, 0xE536, 0xDD76, 0x9B0C, 0x1862, 0x4062, 0x6883, 0x7082, 0x4801, 0x3000, 0x38A3, 0x6A29, 0xEE53, 0xFDF2, 0xD42C, 0x89E2, 0x40A1, 0x9B2A, 0x932A, 0x3904, 0xD497, 0x7A4B, 0x832A, 
        0xE6F4, 0x9C28, 0x8B27, 0x69E6, 0x38E3, 0xD552, 0xF71B, 0xF73B, 0xEE37, 0xFE78, 0xFE78, 0xF637, 0xF5F7, 0xF679, 0xF6DA, 0xF73A, 0xF7DA, 0xFFBE, 0xFF5C, 0xFF7B, 0xFFDD, 0xFFDD, 0xFF3A, 0xFF3B, 0xFFDE, 0xFFBE, 0xFFDE, 0xFFFE, 0xFFFF, 0xFFFF, 
        0xF71C, 0xCD15, 0x92AD, 0xEEDB, 0xF6DB, 0xEE17, 0xD512, 0xA3D0, 0xD639, 0xF73C, 0xEE9A, 0xF6F9, 0xCE16, 0x7BAE, 0x18A2, 0x4224, 0x2983, 0x2922, 0x3182, 0x31A2, 0x31A2, 0x3182, 0x3162, 0x31C3, 0x4223, 0x4A43, 0x5284, 0x5AC5, 0x6AE6, 0x72E5, 
        0x6AE4, 0x7348, 0x7BA9, 0x6B67, 0x4A44, 0x10A1, 0x2101, 0x39C3, 0x6285, 0x9268, 0x9289, 0x9AEA, 0xA2EB, 0x7187, 0xBC2F, 0xEE76, 0xE6F7, 0x6223, 0x62C3, 0x6B63, 0x6321, 0x6B64, 0x6B64, 0x6B63, 0x7B85, 0x9448, 0x9485, 0x8C24, 0x7BA5, 0x8BE5, 
        0x9CA5, 0xA4E5, 0xAC85, 0x6322, 0x9369, 0xBC52, 0xC4F9, 0x72A6, 0x8BAA, 0xAC74, 0xBC7C, 0x9B14, 0xAB74, 0xABD6, 0xABB8, 0xB3FA, 0xB3DA, 0xB39C, 0xB39E,
  0x7A52, 0x7A32, 0x7A32, 0x7A32, 0x7A52, 0x7A32, 0x7A32, 0x8253, 0x7A52, 0x7A52, 0x7A52, 0x7A32, 0x8252, 0x8252, 0x8252, 0x7A52, 0x7A33, 0x8252, 0x8A53, 0x8A53, 0x7253, 0x8253, 0x8A73, 0x8273, 0x8A53, 0x8A73, 0x8A73, 0x8253, 0x8A73, 0x8A73, 0x8273, 
        0x8253, 0x8253, 0x8A73, 0x8A73, 0x8A94, 0x8A53, 0x8A73, 0x8A73, 0x8A73, 0x8A93, 0x8A93, 0x8A93, 0x8A93, 0x8A94, 0x8A94, 0x8A93, 0x8A93, 0x8A94, 0x8A93, 0x8A93, 0x8A93, 0x8293, 0x8A93, 0x8AB4, 0x8AD5, 0x81F2, 0x81F2, 0xABF7, 0xF77E, 0xFFDF, 
        0xFFDF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFD, 0xF7D5, 0xFFFA, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFBD, 0xFFBD, 0xFFDD, 0xF79D, 0xFFBD, 0xFFDE, 0xFFFF, 0xFFDF, 0xFFFE, 0xFFDE, 0xFFBE, 0xF7DD, 
        0xCE76, 0x7BCB, 0x10A2, 0x0182, 0x1903, 0x1862, 0x1061, 0x6AA9, 0x7BAD, 0x846F, 0x8D0F, 0x9D10, 0x9CD0, 0x942E, 0x8B6B, 0xB34B, 0x81E7, 0x8167, 0xB22B, 0xC2CE, 0xCB4F, 0xAB2C, 0x72A8, 0x5B07, 0x5328, 0x5AE7, 0x7AA8, 0xCBD0, 0xC3D1, 0x826B, 
        0x2924, 0xD655, 0x8B4B, 0x5104, 0x5924, 0x69E7, 0x6986, 0x68E4, 0x70A3, 0x7AA7, 0x5286, 0x4224, 0x39E3, 0x52E9, 0x6B6B, 0x73AC, 0x6B8B, 0x4265, 0x4A26, 0x8C2E, 0xEF5D, 0xF6FB, 0xF75D, 0xBDF6, 0x62E9, 0x3A02, 0x5B24, 0x6B85, 0x6325, 0x7C08, 
        0xA46C, 0xABEC, 0x9AA9, 0xB22B, 0x9947, 0x9106, 0xA168, 0xBA8E, 0xDCD6, 0xD4F5, 0x92AB, 0x4061, 0x5062, 0x4062, 0x1861, 0x730B, 0xBCB0, 0xE5D5, 0xDDF6, 0x68E3, 0x60A0, 0x48A0, 0x28C3, 0xDD78, 0xED54, 0xA34C, 0x50E5, 0xCC12, 0xAB2C, 0xB44E, 
        0xE6D5, 0x8B47, 0x9B69, 0x930A, 0x7227, 0xCCD4, 0xEE58, 0xFED9, 0xF698, 0xFE99, 0xFE98, 0xFEF9, 0xFF9C, 0xFFFF, 0xFFFF, 0xFFDF, 0xFF9D, 0xFF5B, 0xFFBD, 0xFFBD, 0xFF1B, 0xF5D6, 0xFF1B, 0xFFDF, 0xFFFF, 0xFFBE, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFDF, 0xEEBB, 0xCCB4, 0xBBF0, 0xDD35, 0xE5B6, 0xD4F3, 0xB410, 0xBD35, 0xD638, 0xEE78, 0xCD74, 0xDE99, 0x9CF3, 0x18A2, 0x18A1, 0x2122, 0x2962, 0x3182, 0x39E3, 0x39E3, 0x31A2, 0x2961, 0x31E4, 0x3A03, 0x3A22, 0x4201, 0x41E2, 0x7307, 0x8367, 
        0x7304, 0x8386, 0x7BA7, 0x9449, 0x9CAD, 0x18A2, 0x18E1, 0x49E4, 0x82C7, 0x8A67, 0x9268, 0x9AA9, 0xA2EC, 0xAB6E, 0xB451, 0xAC2E, 0x7B06, 0x6B24, 0x7363, 0x6341, 0x5300, 0x6B41, 0x6B63, 0x7BA3, 0x8C24, 0x83E4, 0x7BC2, 0x83C4, 0x8C29, 0xACC8, 
        0x9445, 0x83A3, 0x7B46, 0xB438, 0xB419, 0xB41A, 0xB419, 0x8369, 0x9C2A, 0x9BD0, 0x8A97, 0xBC3C, 0xBC1B, 0xB3DC, 0xB3FE, 0xB39B, 0xB3BD, 0xB3BD, 0xB3BD,
  0x7A32, 0x8233, 0x8233, 0x8252, 0x8252, 0x7A52, 0x7A52, 0x7A52, 0x7A52, 0x7A53, 0x8253, 0x8253, 0x8273, 0x8273, 0x8273, 0x8272, 0x8252, 0x8252, 0x8252, 0x8253, 0x8273, 0x8A73, 0x8A73, 0x8A73, 0x8A73, 0x8A73, 0x8A53, 0x8253, 0x8A73, 0x8A73, 0x8A73, 
        0x8A73, 0x8A73, 0x8A73, 0x8A73, 0x8A73, 0x8A93, 0x8A93, 0x8A73, 0x8273, 0x8293, 0x8A94, 0x8A93, 0x8A73, 0x8AB4, 0x8AB4, 0x8A93, 0x8293, 0x8A93, 0x8A93, 0x8A93, 0x8AB4, 0x8A94, 0x8A94, 0x92D4, 0x9B15, 0x6971, 0x8AB4, 0xC4F9, 0xF79E, 0xFFDF, 
        0xFFBF, 0xFFDF, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDD, 0xFFD5, 0xFFFA, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFBF, 0xFFBE, 0xFFBD, 0xF7BD, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFDE, 0xFFFE, 0xFFDE, 
        0xDED8, 0x842D, 0x10A2, 0x1962, 0x2122, 0x3103, 0x6164, 0x7B09, 0x838C, 0x8C2E, 0x9CF1, 0x94F0, 0x9CF0, 0xACB0, 0xAC2E, 0x8ACB, 0x4964, 0x40A2, 0x70A4, 0x90E7, 0xAA0A, 0xB2CC, 0xA32C, 0x6AE6, 0x6306, 0x5AC7, 0x6A69, 0xCBF0, 0xB34E, 0x69E9, 
        0x2924, 0xD679, 0x72EC, 0x38A2, 0x50E3, 0x69A7, 0x6905, 0x6883, 0x7062, 0x69C5, 0x5A45, 0x4A44, 0x4204, 0x5AC8, 0x6B6B, 0x8C2E, 0x8C6F, 0x2104, 0x9450, 0xE6DA, 0xFF5E, 0xF73E, 0xF77E, 0xBDB6, 0x6267, 0x4263, 0x6387, 0x6BC6, 0x5343, 0x7369, 
        0x9C2C, 0xC4CF, 0xE4B1, 0xA26A, 0xA1E9, 0xA168, 0x98C6, 0xAA2C, 0xDCD6, 0xCD14, 0x7AA8, 0x2041, 0x2021, 0x59E6, 0xACF0, 0xEF39, 0xAC71, 0x71C8, 0x6041, 0x6082, 0xA249, 0xA2AB, 0x7A09, 0xDC74, 0x922A, 0x91E8, 0xDBF2, 0x9ACC, 0x8A89, 0xAC4D, 
        0xE6F6, 0x8B49, 0x930A, 0xABCD, 0xB42F, 0x7208, 0xC512, 0xF6F9, 0xFF19, 0xF6FB, 0xFEFA, 0xFF1A, 0xFF5B, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFDE, 0xF6B9, 0xB533, 0x836C, 0x79E6, 0xDCB3, 0xCD75, 0xA512, 0x7BCE, 0x942E, 0xA491, 0xAD34, 0xB5D6, 0xD5F8, 
        0xE65A, 0xCCF5, 0x8209, 0x924A, 0xD4D4, 0xFE39, 0xF618, 0xB492, 0xABAF, 0xC4D2, 0xEF3A, 0xD594, 0xE6B8, 0xEEF9, 0xBD54, 0x18C3, 0x2922, 0x3182, 0x2961, 0x31E4, 0x3A03, 0x39E3, 0x3182, 0x39A1, 0x3202, 0x4264, 0x5264, 0x41A1, 0x7306, 0x83A8, 
        0x7325, 0x8B86, 0x8385, 0x9428, 0xACCE, 0x18C2, 0x18C0, 0x41A2, 0x7A86, 0xAB4B, 0x92A9, 0x92AA, 0xB34E, 0xAB8F, 0x934D, 0x7ACA, 0x6286, 0x8BC4, 0x8C26, 0x8405, 0x7BE3, 0x7BA3, 0x83E4, 0x7BC4, 0x6B64, 0x8C26, 0x9C67, 0xA487, 0xA488, 0x8382, 
        0x8364, 0x8BA7, 0x93EB, 0xAC55, 0xB438, 0xA3D6, 0x9312, 0x8B49, 0x936B, 0xABD1, 0xCC79, 0xB41E, 0xABBE, 0xAB7E, 0xAB9C, 0xBBFE, 0xBBDD, 0xB3DD, 0xBBDE,
  0x7212, 0x7232, 0x7232, 0x7232, 0x7A11, 0x7A32, 0x7A33, 0x7A32, 0x7A33, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x8A32, 0x8A32, 0x7252, 0x7A32, 0x8A53, 0x8A53, 0x7A53, 0x7253, 0x8253, 0x8A53, 0x8253, 0x8253, 0x8253, 0x8253, 0x8A53, 0x8A53, 0x8253, 0x8253, 
        0x8253, 0x8233, 0x8252, 0x8A73, 0x8A73, 0x8A73, 0x8A73, 0x8A73, 0x8A73, 0x8253, 0x8273, 0x8A93, 0x8273, 0x8253, 0x8A73, 0x8A74, 0x8A74, 0x8A74, 0x8A74, 0x8A74, 0x8A73, 0x8A94, 0x8A74, 0x9274, 0x9294, 0x92B6, 0x6170, 0x8313, 0xEF5E, 0xFFFF, 
        0xFFDF, 0xFFDF, 0xFFDE, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFDC, 0xFFD4, 0xFFFA, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFF9E, 0xFFBE, 0xF7BD, 0xF77C, 0xFFDD, 0xFFDD, 0xFFDD, 0xFFDD, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFF, 0xFFDE, 
        0xE719, 0x8C6F, 0x18A2, 0x2962, 0x2142, 0x3184, 0x6287, 0x8B2A, 0x9BEC, 0x9C8D, 0x94EE, 0x842F, 0x8C2E, 0xB553, 0xDED9, 0x4945, 0x736B, 0x8C2E, 0x7228, 0x4843, 0x4001, 0x4821, 0x60A2, 0x69A4, 0x61E4, 0x62A7, 0x7BCC, 0xA2CC, 0x928B, 0x79C8, 
        0x6926, 0xD69A, 0x630C, 0x18C3, 0x3124, 0x5104, 0x50A3, 0x4842, 0x4800, 0x4041, 0x5A46, 0x52A7, 0x39A4, 0x4AC7, 0x6B8A, 0x5288, 0x20E3, 0xAD52, 0xE71B, 0xF73D, 0xE67C, 0xF79E, 0xD619, 0x8BAF, 0x2943, 0x5AC8, 0x6BC9, 0x6387, 0x4AC3, 0x8C6A, 
        0x9C6C, 0xBD10, 0xEDD5, 0x9A49, 0x99A8, 0x9147, 0x90C6, 0xC2ED, 0xE597, 0x9CB3, 0x18A3, 0x2986, 0xAD53, 0xF75B, 0xE678, 0x20C3, 0x2000, 0x60C4, 0xA1C9, 0x78C2, 0xAA29, 0xD3F0, 0xED13, 0x99CB, 0x40A5, 0x6209, 0xD453, 0x58E4, 0x82E9, 0xC571, 
        0xE6B6, 0x7A45, 0x9B2A, 0xA38D, 0x7A69, 0x9248, 0xD596, 0xF75D, 0xFEFB, 0xF6F9, 0xFEF9, 0xFF5B, 0xFFFF, 0xFFFF, 0xFFDF, 0xEEFB, 0xC533, 0x61A5, 0x4081, 0x2800, 0x2020, 0x7924, 0x91C6, 0x8986, 0x6083, 0x5041, 0x9188, 0xBA8D, 0xC30F, 0xCBD2, 
        0xD453, 0xDC53, 0xCC12, 0xD452, 0xEDB7, 0xD536, 0x930C, 0x8289, 0xCDB6, 0xF75D, 0xF6DB, 0xC512, 0xDE36, 0xE6B8, 0xB553, 0x18C2, 0x18C1, 0x2942, 0x2983, 0x39A3, 0x39E3, 0x3A03, 0x4203, 0x29A2, 0x39E2, 0x4223, 0x4224, 0x4A42, 0x7306, 0x7B48, 
        0x6AE5, 0x8385, 0x8BA5, 0x9427, 0x944B, 0x18A1, 0x20E1, 0x49C3, 0x6A65, 0x9226, 0x9AAA, 0x928A, 0x9248, 0xDD15, 0xAC6F, 0x8B8A, 0x7B07, 0x6B61, 0x7362, 0x7B63, 0x8BA6, 0x9C2F, 0xA3EE, 0xAC0E, 0xAC90, 0xA40C, 0x942B, 0x8BC9, 0x8326, 0x93A7, 
        0x8B8B, 0x8B8C, 0x9C0D, 0xABD4, 0xA398, 0xABB9, 0xB437, 0xC453, 0xB3B7, 0x9B15, 0x92AF, 0xBC3B, 0xC41E, 0xBBBE, 0xB39D, 0xAB9D, 0xB39D, 0xB39C, 0xB3BC,
  0x7A32, 0x7A32, 0x7A52, 0x7A52, 0x7A33, 0x7A52, 0x7A52, 0x7A52, 0x7A53, 0x7A52, 0x7A52, 0x7A52, 0x7A72, 0x8253, 0x8A53, 0x7A52, 0x7A53, 0x7A53, 0x7A53, 0x8A53, 0x8A53, 0x8253, 0x8273, 0x8253, 0x8A53, 0x8A53, 0x8A53, 0x8253, 0x8A53, 0x8A73, 0x8273, 
        0x8273, 0x8253, 0x8253, 0x8A73, 0x8A93, 0x8A33, 0x8A73, 0x8273, 0x8273, 0x8273, 0x8A93, 0x8A73, 0x8A73, 0x8A93, 0x8A93, 0x8A94, 0x8A94, 0x8A74, 0x8A94, 0x8A94, 0x8A74, 0x9294, 0x8A94, 0x8A94, 0x8A92, 0x8A94, 0x79F2, 0x8272, 0xAC54, 0xF79E, 
        0xFFDF, 0xFFBE, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFB, 0xFFD4, 0xFFDA, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFDE, 0xF7DE, 0xF7BD, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFFF, 0xFFFF, 0xFF7D, 
        0xF77C, 0xA512, 0x10A2, 0x10E0, 0x3142, 0x59E5, 0x7AC9, 0x8AE8, 0xA42D, 0xA4B0, 0x8490, 0x844E, 0x7C2D, 0xA511, 0xDE57, 0x6226, 0x5224, 0x7BEA, 0xB634, 0xAC51, 0x934C, 0x6A47, 0x3103, 0x2861, 0x6A87, 0x72C7, 0x4143, 0x7207, 0x5924, 0x58A3, 
        0x7105, 0x9AAC, 0x82AA, 0x6AA7, 0x5A86, 0x3041, 0x3800, 0x4841, 0x58E4, 0x7226, 0x8308, 0x7AE8, 0x5A06, 0x5AA7, 0x4265, 0x2963, 0x2104, 0xDF1B, 0xF77E, 0xF73D, 0xFF1D, 0xFFDF, 0xF75E, 0xC5B7, 0x7B6C, 0x6308, 0x6BC9, 0x6BE8, 0x5B85, 0x7C49, 
        0x7347, 0x9C2C, 0xE655, 0xAAEC, 0xA24A, 0x99C8, 0x9127, 0xCAAD, 0xE4B4, 0xCCD3, 0x93EF, 0xCDF7, 0x8B4D, 0x4104, 0x1862, 0x926C, 0xD411, 0xD3AF, 0x9187, 0x6862, 0x99EA, 0x9A2B, 0x7146, 0xDC13, 0xA38F, 0xA3AF, 0xD453, 0x3124, 0x9C90, 0xDE14, 
        0xB44B, 0x8A48, 0xA34C, 0x8ACB, 0x4083, 0x48A2, 0xB513, 0xF77E, 0xFF7E, 0xFF5C, 0xFF9D, 0xFFDE, 0xEF7D, 0x6BAF, 0x83CE, 0x8BAD, 0x62A9, 0x18A2, 0x7268, 0x9AAA, 0x70E4, 0x5841, 0x7104, 0x8966, 0x9127, 0x98C5, 0x8864, 0x8042, 0x7882, 0x98C9, 
        0xD3D3, 0xF578, 0xF597, 0xFDF9, 0xED57, 0xC3B0, 0x81C7, 0xB493, 0xDE39, 0xDE19, 0xCD34, 0xEE36, 0xCD11, 0xCD94, 0xE6FB, 0x5269, 0x18C3, 0x18A1, 0x3162, 0x39E4, 0x39C3, 0x39E2, 0x3202, 0x41E2, 0x4243, 0x4263, 0x4223, 0x4201, 0x5244, 0x6AC6, 
        0x8368, 0x7B45, 0x8B84, 0x9427, 0x948C, 0x18C2, 0x3122, 0x59C4, 0x7A25, 0xB2C9, 0xA32A, 0x9B0B, 0xAACB, 0xAC2C, 0x9367, 0x7AA5, 0x72A5, 0x8B69, 0x7B2A, 0x8B4C, 0xABF1, 0xAC19, 0xB3FA, 0xC41C, 0xDC7C, 0xA395, 0x9B54, 0x9B32, 0x934E, 0x736C, 
        0x9C0E, 0xB470, 0xB433, 0xA3BB, 0xB3BE, 0xBBFD, 0xC3FA, 0xB379, 0xC3DC, 0xBBFC, 0xABB7, 0x9311, 0xABB7, 0xB3FC, 0xB3BE, 0xB39F, 0xB39E, 0xB3BD, 0xBBDC,
  0x7A32, 0x8252, 0x8252, 0x8252, 0x8253, 0x8252, 0x7A52, 0x7A52, 0x8253, 0x8273, 0x8273, 0x8253, 0x8273, 0x8A53, 0x8A53, 0x8252, 0x7A53, 0x8272, 0x8253, 0x8253, 0x8A73, 0x8A73, 0x8A73, 0x8A73, 0x8A73, 0x8A73, 0x8A73, 0x8253, 0x8273, 0x8A73, 0x8A73, 
        0x8A73, 0x8A53, 0x8A73, 0x8A73, 0x8A93, 0x8273, 0x8A73, 0x8A73, 0x8273, 0x8A93, 0x8A94, 0x8A94, 0x8A93, 0x8AB4, 0x8A94, 0x8293, 0x8293, 0x8A94, 0x8A94, 0x8A94, 0x8A94, 0x9295, 0x8AB4, 0x8A94, 0x8A93, 0x9B55, 0x69AF, 0x69EF, 0xACB5, 0xF79E, 
        0xFFDF, 0xFF9F, 0xFF9F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDC, 0xFFEF, 0xFFF8, 0xFFFE, 
        0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFDE, 0xFFBD, 0xFFDE, 0xFFFE, 0xFFFE, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFF9E, 
        0xF79D, 0xA513, 0x10A2, 0x0880, 0x49A5, 0x7A88, 0x8B0B, 0x8B29, 0xAC2D, 0xA4B0, 0x7C4E, 0x6C2E, 0x7C2C, 0x7BEB, 0x8B8C, 0xDE77, 0x62EA, 0x31E6, 0x6C4E, 0xADD4, 0xB552, 0xA48F, 0x940C, 0xDCAF, 0xBCAF, 0x8B6B, 0x5164, 0x4820, 0x4040, 0x60E4, 
        0x91E9, 0x4862, 0x6124, 0x8B2A, 0x9CEE, 0x28C3, 0x4145, 0x6207, 0x7A67, 0x932B, 0x8AE9, 0x8AE9, 0x830B, 0x51E3, 0x20E1, 0x4A46, 0xB5B1, 0xF7BD, 0xFF5D, 0xFF3D, 0xFF9F, 0xFF9F, 0xFFDF, 0xFFBF, 0xE6BB, 0x3164, 0x6349, 0x848C, 0x6C28, 0x6385, 
        0x73A7, 0x8BCA, 0xA3CE, 0xDCB2, 0xC34E, 0xA1E9, 0x8926, 0xB26C, 0xDDB7, 0xCE79, 0x8410, 0x1082, 0x2000, 0x5042, 0x9946, 0xED36, 0xC34F, 0xA20A, 0xAA6B, 0xDBD0, 0xBBB0, 0x7A4A, 0x40E4, 0xD4D5, 0xEDB7, 0xEDB6, 0xD4F2, 0x4125, 0xA4F3, 0xD636, 
        0xA40B, 0x8AC5, 0x8247, 0x6966, 0x4861, 0x6184, 0x81E6, 0xB40F, 0xF77D, 0xFFDF, 0xEEFB, 0xBCD2, 0x71E5, 0x4966, 0x4925, 0x6248, 0xAC90, 0xE595, 0xD451, 0x9A8A, 0x68A3, 0x78A4, 0x88E5, 0x9105, 0x8925, 0xA106, 0x9086, 0x9908, 0xBA6D, 0xC9CE, 
        0xDAF1, 0xE3D3, 0xDC32, 0xAA6D, 0x91CA, 0xAAAD, 0xF557, 0xF73C, 0xB3F0, 0x9AAB, 0xB450, 0xEE99, 0xD554, 0xD513, 0xF638, 0xEF3A, 0x630B, 0x18C2, 0x2942, 0x31C3, 0x31A2, 0x31A2, 0x31C2, 0x3A43, 0x4263, 0x4223, 0x31C1, 0x41E2, 0x49E2, 0x6264, 
        0x8368, 0x7B24, 0x8B86, 0x9C49, 0xA4CC, 0x2962, 0x4183, 0x61A3, 0x8183, 0xC36D, 0xA36C, 0x92C9, 0x8A46, 0x82A5, 0xB44B, 0xD510, 0xCCD1, 0x9C30, 0xAC14, 0xC479, 0xC4BC, 0xA39A, 0xAB7D, 0xBB9F, 0xC3BE, 0x9B55, 0x8AF4, 0x9B73, 0xB492, 0xB451, 
        0xABF4, 0xABF8, 0xBC1C, 0xB39E, 0xB3BD, 0xB3DD, 0xBBDE, 0xAB5E, 0xB39C, 0xBBDC, 0xBBDD, 0xA395, 0x9BB1, 0x9BB2, 0xABD7, 0xBC1E, 0xBBFF, 0xB3DE, 0xB3BD,
  0x7A32, 0x7A32, 0x7A32, 0x7A31, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A52, 0x7A52, 0x7A32, 0x7A32, 0x8232, 0x8253, 0x8A53, 0x8A53, 0x8A53, 0x8A53, 0x8253, 0x8253, 0x8253, 0x8253, 0x8253, 0x8253, 0x8253, 0x8A53, 0x8273, 0x8A53, 0x8A53, 
        0x8A73, 0x8A73, 0x8A73, 0x8A73, 0x8A53, 0x8A93, 0x8A73, 0x8A73, 0x8A93, 0x8A93, 0x8273, 0x8273, 0x8A73, 0x8274, 0x8A74, 0x8A94, 0x8A94, 0x8A94, 0x9294, 0x8A74, 0x8A73, 0x8AB4, 0x82B3, 0x8AB3, 0x8A94, 0x7A90, 0x8B51, 0x72AE, 0x516A, 0xE6BC, 
        0xFFBF, 0xFFBE, 0xF75D, 0xFF9E, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xF7BC, 0xFF95, 0xFFDB, 0xFFFE, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xF77B, 0xF79D, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xFFDD, 0xFFBD, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFE, 0xFFDE, 0xFFFF, 0xFFDF, 0xF75C, 
        0xEF7D, 0x9D13, 0x10A2, 0x10A0, 0x41C4, 0x6AC7, 0x9369, 0xAB8A, 0xB42C, 0xAC6D, 0x9C2D, 0x6B6B, 0x6C0A, 0x740A, 0x73EB, 0xB54F, 0x9CAB, 0x62E6, 0x2962, 0x6BCD, 0x7C8E, 0x954F, 0xA5D0, 0x6AE7, 0x5AA5, 0x6B48, 0x83ED, 0x38C2, 0x4122, 0x61A5, 
        0x7986, 0x6042, 0x4923, 0x4A66, 0x63AA, 0x734A, 0x7B09, 0x7AE9, 0x7AEA, 0xAB0A, 0x92E8, 0x8308, 0x834B, 0x7B0A, 0x3985, 0x630C, 0xEF5C, 0xF75D, 0xFF5E, 0xFF9E, 0xFFDE, 0xF75E, 0xF79E, 0xE69A, 0xAC50, 0x4A85, 0x6BE8, 0x84AA, 0x7C09, 0x5B67, 
        0x6BE8, 0x7BE9, 0x8B89, 0xCB90, 0xA26B, 0x89A7, 0x99E9, 0xEC94, 0xECD4, 0x9B2D, 0x28A3, 0xB22A, 0xA167, 0xAA0B, 0xDBD1, 0x78A4, 0x5842, 0x8187, 0xD3F0, 0xECB3, 0x8208, 0x5905, 0x822A, 0xA26C, 0x9ACC, 0xB3EE, 0xDD32, 0x8B27, 0xC5B2, 0xBD70, 
        0x7285, 0xD4D2, 0x6A29, 0x40E3, 0x71A6, 0x4902, 0x9289, 0xD4F3, 0xFF9D, 0xEEDA, 0x82CB, 0x5944, 0x7287, 0xA3EE, 0x92C9, 0xAC0E, 0xEF1B, 0xC4B0, 0xAAAB, 0x8926, 0x6842, 0x90C5, 0x80E5, 0x8926, 0xA168, 0x9085, 0x98E7, 0xA96A, 0xC1EC, 0xB1AB, 
        0xA92A, 0xA96A, 0xBA2C, 0xBA6D, 0xB28E, 0xCB91, 0xED56, 0xE4F6, 0xCCB4, 0xC4D3, 0xDD55, 0xEE39, 0xEDF7, 0xEDF7, 0xEE5A, 0xE73A, 0x62EB, 0x10A1, 0x18E1, 0x2983, 0x31A3, 0x39A3, 0x39C3, 0x3203, 0x3A03, 0x3A02, 0x3221, 0x41C1, 0x5AA5, 0x62C5, 
        0x5243, 0x6307, 0x8B49, 0x8B49, 0x6AC6, 0x4182, 0x5A05, 0x72A8, 0x8AA8, 0x58A2, 0xA2C9, 0x9AC9, 0x4903, 0xCCEF, 0xB40C, 0xBCB0, 0xEF1B, 0xBD13, 0x9371, 0x9B75, 0xCC7E, 0xB35E, 0xBBBD, 0xBBFD, 0xB3DD, 0xB37A, 0xAB7A, 0xA3B6, 0xABD0, 0xBBD7, 
        0xBBBC, 0xB3BE, 0xB3BD, 0xC3BE, 0xBBBD, 0xB3BD, 0xB3DE, 0xB3BC, 0xB3BC, 0xB3BD, 0xB39D, 0xB3DB, 0xBBFA, 0xABD6, 0x9371, 0xABF6, 0xB43A, 0xBC3D, 0xC3FF,
  0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A52, 0x7A32, 0x7A32, 0x7A33, 0x7A53, 0x7A52, 0x7A52, 0x7A52, 0x7A52, 0x7A53, 0x7A53, 0x8253, 0x8253, 0x8253, 0x8253, 0x8A53, 0x8253, 0x8253, 0x8273, 0x8253, 0x8253, 0x8273, 0x8273, 0x8253, 0x8A73, 0x8A73, 0x8A73, 
        0x8A73, 0x8A73, 0x8273, 0x8273, 0x8253, 0x8A93, 0x8A93, 0x8A73, 0x8A93, 0x8A73, 0x8A73, 0x8A93, 0x8A93, 0x8A74, 0x8A74, 0x8A74, 0x8A73, 0x8A94, 0x8A73, 0x8A93, 0x8A93, 0x8253, 0x7253, 0x7252, 0x8253, 0xA2F6, 0x8B14, 0x8B51, 0xA410, 0xB556, 
        0xDEDB, 0xFF9E, 0xFF9F, 0xFFDE, 0xFFBF, 0xFFBF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF7FF, 0xF7BD, 0xF753, 0xFFBA, 0xFFDF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDE, 0xFFDF, 0xFFBE, 0xF77D, 0xF79C, 0xFFDD, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xFFBD, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFBD, 
        0xF79D, 0xA513, 0x18A2, 0x1841, 0x59E6, 0x8309, 0x9B69, 0x9BAA, 0x9BCA, 0xAC4D, 0xC4D2, 0x6368, 0x5B69, 0x63EB, 0x648A, 0x4A44, 0x7348, 0x8C0B, 0x940C, 0x7BCA, 0x6429, 0x6449, 0x63C9, 0x19E2, 0x6368, 0x8C4C, 0x73EA, 0x4266, 0x5267, 0x51E5, 
        0x50A2, 0x5924, 0x51E5, 0x4A66, 0x42A6, 0x73AB, 0x736A, 0x7B2A, 0x932A, 0x932A, 0x9309, 0x9329, 0x9B4A, 0x92C9, 0x7AA6, 0xA44D, 0xF77D, 0xF77E, 0xF75E, 0xFF9E, 0xFFDF, 0xF77E, 0xFFBF, 0xFF9F, 0xE65C, 0x41A4, 0x5B28, 0x94ED, 0xB56D, 0x62A7, 
        0x7347, 0x8BC9, 0x9BCB, 0xCB4E, 0xC2CD, 0xB24A, 0x9A48, 0xBC50, 0xDD16, 0xBBB0, 0x7083, 0x88C5, 0xBA2C, 0xBA8D, 0xA24A, 0xDC73, 0x934D, 0x830C, 0xC410, 0xCC50, 0xABCF, 0xB411, 0xDC93, 0x8A47, 0xA30C, 0xD472, 0xE574, 0x72E4, 0xBD8F, 0xCDEF, 
        0x8324, 0x4083, 0x3821, 0x6123, 0xA2C8, 0x92E9, 0x4144, 0x48E4, 0xA20A, 0xA2A8, 0x9B2B, 0x932C, 0x8AEC, 0xCCF2, 0xAC0F, 0x82AA, 0x7A08, 0xDEDA, 0x8C30, 0x5986, 0x6023, 0x6021, 0x80C4, 0x9947, 0xA168, 0x9085, 0x9065, 0xA0E8, 0xB9AA, 0xA90A, 
        0x9887, 0xB18B, 0xF417, 0xFD59, 0xFDDC, 0xFDBB, 0xECD6, 0xB350, 0xA3B0, 0xBC93, 0xF5B8, 0xFDF8, 0xDD76, 0xD515, 0xD555, 0xEF5C, 0x9CB2, 0x4A27, 0x1081, 0x39A4, 0x39A2, 0x39A1, 0x39E3, 0x3223, 0x3A23, 0x31E1, 0x2961, 0x5AA5, 0x7BAA, 0x6B49, 
        0x41E2, 0x5AA5, 0x5203, 0x5182, 0x59A3, 0x51E2, 0x5A24, 0x59E4, 0x5922, 0x8142, 0x6902, 0x9309, 0xE613, 0x9AA9, 0x9AA7, 0xC48F, 0xE6DA, 0x61EB, 0x9B56, 0xBC1E, 0xB33E, 0xBC1C, 0xBC5C, 0xB41A, 0xA356, 0xAB94, 0xB3D6, 0xBBFA, 0xB3DD, 0xB3DB, 
        0xB3BC, 0xB3BD, 0xB3DD, 0xBBDB, 0xBBBC, 0xBBBD, 0xB3DD, 0xB3BE, 0xBBBE, 0xBBBE, 0xB3BD, 0xB3BC, 0xBBBE, 0xBBDE, 0xBC3C, 0xA3B0, 0x934F, 0x9331, 0x9B74,
  0x7A52, 0x8232, 0x8233, 0x8252, 0x8252, 0x7A32, 0x7A32, 0x7A52, 0x7A53, 0x7A53, 0x7A53, 0x8253, 0x8253, 0x8273, 0x8253, 0x8253, 0x8252, 0x8253, 0x8253, 0x8A53, 0x8A73, 0x8A73, 0x8A74, 0x8273, 0x8274, 0x8273, 0x8A73, 0x8A93, 0x8273, 0x8A73, 0x8A73, 
        0x8A93, 0x8A73, 0x8A73, 0x8A73, 0x8A93, 0x8A73, 0x8A93, 0x8A93, 0x8A93, 0x8A93, 0x8A93, 0x8A93, 0x8A93, 0x8A94, 0x8A94, 0x8A93, 0x8A93, 0x8A92, 0x8A93, 0x8AB3, 0x82B3, 0x82B1, 0x7AAF, 0x72AE, 0x72AE, 0x7AD1, 0x9BB3, 0x93F1, 0x83CE, 0xD579, 
        0xF6FD, 0xFF9E, 0xFF9D, 0xFF7E, 0xFFBF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFD, 0xF7AE, 0xFFD7, 0xFFFE, 
        0xFFFF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFDF, 0xFF5E, 0xFFBE, 0xFFDD, 0xFFDC, 0xFFDD, 0xFFDE, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFDE, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xF7BE, 0xC5F6, 0x62A8, 0x1882, 0x6A88, 0x9BAB, 0x9B8B, 0xA40C, 0x9C0C, 0xB46F, 0xD532, 0x8BED, 0x6329, 0x5B28, 0x6BCB, 0x52C5, 0x39A2, 0x5A47, 0x9C4F, 0x7206, 0x51E3, 0x4282, 0x3B23, 0x4242, 0x840A, 0xA530, 0x8CCF, 0x29E2, 0x3A24, 0x4A05, 
        0x4982, 0x6246, 0x5A86, 0x52C6, 0x5B08, 0x6B8A, 0x738B, 0x73AB, 0x73AC, 0x934B, 0x936B, 0x9B8B, 0xAB8C, 0x7A47, 0x9B4C, 0xCD54, 0xF79D, 0xF75E, 0xFF7E, 0xFFBF, 0xFFFF, 0xFFFF, 0xFFBF, 0xFFBF, 0xE6FC, 0x52A4, 0x5B66, 0x7CAC, 0x9550, 0x7BCA, 
        0x6305, 0x6B65, 0x946B, 0xC430, 0xD3D1, 0xCB6F, 0xB32D, 0xB470, 0xD5B8, 0x9C53, 0x2083, 0x6884, 0xC2AE, 0xCACF, 0x9209, 0xEF3C, 0xF77E, 0xC514, 0x81E7, 0xED95, 0xFF1B, 0xE678, 0xB42E, 0xABCE, 0xD5B7, 0xC4F3, 0x7A25, 0xACE9, 0xDE90, 0xA4ED, 
        0x30A2, 0x4000, 0x5821, 0x7904, 0xA2AA, 0xA2E9, 0x6944, 0x4041, 0x40A2, 0xC471, 0xB3EF, 0xB431, 0xDD56, 0xA38E, 0x9B4D, 0x7AAB, 0x4926, 0x38A3, 0xAC93, 0xED98, 0xD32F, 0x9168, 0x80A4, 0x8084, 0x88E6, 0xA0C5, 0x9064, 0x9065, 0x9908, 0xC1AD, 
        0xDA4E, 0xE2AE, 0xDA6E, 0x98EA, 0xD394, 0xFD9A, 0xF5DA, 0xC371, 0x81C9, 0x928B, 0xF536, 0xFE9B, 0xDD75, 0xD534, 0xE638, 0xFF9C, 0xF79B, 0xA4F2, 0x18C3, 0x31C4, 0x2962, 0x2941, 0x31A2, 0x3203, 0x3A43, 0x31E2, 0x2961, 0x62C5, 0x944E, 0x946D, 
        0x5AE5, 0x2901, 0x4162, 0x59A3, 0x59A2, 0x6245, 0x5A24, 0x6A66, 0x8AE9, 0xAAC9, 0x8205, 0x9287, 0xC40D, 0x81E5, 0xBC6F, 0xEE98, 0xEEDA, 0x726D, 0x9335, 0xB3DB, 0xAB9E, 0xC43E, 0xA35A, 0x9B15, 0xB394, 0xBC3B, 0xBC39, 0xBBFA, 0xBBBE, 0xB3FD, 
        0xB3BD, 0xB39D, 0xB39E, 0xB41C, 0xB3FD, 0xBBDE, 0xBBBF, 0xBBDD, 0xBBDD, 0xBBBD, 0xB39E, 0xB3DE, 0xB3BE, 0xBB9E, 0xBB9E, 0xBC39, 0xAC14, 0x938C, 0x72E5,
  0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A52, 0x7A32, 0x7A32, 0x7A52, 0x7A52, 0x7A53, 0x8A53, 0x8A53, 0x8A53, 0x8A53, 0x8A53, 0x8253, 0x8253, 0x8253, 0x8253, 0x8273, 0x8253, 0x8A53, 0x8A53, 0x8A73, 0x8A73, 0x8A73, 
        0x8A73, 0x8293, 0x8A93, 0x8A73, 0x8A73, 0x8A94, 0x8A74, 0x8A73, 0x8A73, 0x8A94, 0x8A93, 0x8A93, 0x8A73, 0x8293, 0x8A94, 0x8A93, 0x8292, 0x7A52, 0x7A73, 0x7A73, 0x7212, 0x71F1, 0x61B0, 0x518D, 0x51EB, 0x9BB5, 0xA475, 0xBD56, 0xCDFA, 0x9BD2, 
        0xC578, 0xEF1D, 0xFFDF, 0xF79D, 0xF77D, 0xF79E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDD, 0xE6ED, 0xF797, 0xFFFE, 
        0xFFDF, 0xEF5D, 0xF7BE, 0xFFFF, 0xFFDF, 0xFFDD, 0xFFDE, 0xFFDE, 0xFFDD, 0xFFDD, 0xFFDE, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xFFBE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 
        0xFFDE, 0xF77C, 0xD615, 0x2903, 0x5AA7, 0x9BEA, 0xB3CB, 0x9BAB, 0xA3EA, 0xB44D, 0xC492, 0xB510, 0x836B, 0x5A87, 0x4284, 0x2A03, 0x3A45, 0x6B29, 0xB430, 0xAACA, 0x6A46, 0x4A66, 0x5AC7, 0x3A64, 0x73A8, 0x9D2E, 0xA5B2, 0x2143, 0x19A3, 0x3264, 
        0x4A85, 0x732A, 0x52C6, 0x4AC5, 0x6348, 0x5B49, 0x636A, 0x6B6A, 0x6B4A, 0x6329, 0x93AB, 0xAC0C, 0x9BEB, 0x8247, 0xABAD, 0xCCD2, 0xE595, 0xFF9E, 0xFFBF, 0xF79F, 0xF7DE, 0xFFFF, 0xFFBF, 0xFEBD, 0xECD7, 0x6245, 0x7367, 0x8C4B, 0x944C, 0x938A, 
        0x9369, 0x8367, 0x7B66, 0xD555, 0xD471, 0xBB6C, 0xA2CC, 0xDCB3, 0xBBD1, 0x7A2A, 0x50C3, 0xE3F2, 0xFCD7, 0xF4D8, 0xF4B5, 0xFE5A, 0xE514, 0xDD13, 0xEE57, 0xD534, 0xB410, 0xABED, 0xC4AF, 0xEE36, 0xB48F, 0x7A67, 0x5923, 0xE6D4, 0xC5B1, 0x730A, 
        0x1881, 0x7123, 0x58C2, 0x8228, 0xD491, 0x20A2, 0x3820, 0x5820, 0x68A3, 0xE4F3, 0xC430, 0xABF0, 0xBC94, 0xB3F1, 0x92AB, 0xA34D, 0xD4D4, 0x3125, 0x9C73, 0xF5F9, 0xEC53, 0xA189, 0x80A5, 0x7863, 0x8884, 0x88A5, 0x80A5, 0x90A5, 0xA0E7, 0xB14A, 
        0xC1EC, 0xCA2D, 0xD20C, 0xB9CC, 0xE3D5, 0xECB7, 0xE434, 0xFDB8, 0xFDB9, 0xFD98, 0xF577, 0xCCB4, 0xE5B7, 0xE5F7, 0xD5B5, 0xF79B, 0xE6D8, 0x8C2E, 0x18A2, 0x2981, 0x2981, 0x3161, 0x3182, 0x31C3, 0x3A23, 0x3202, 0x2981, 0x52A4, 0x7347, 0x6B28, 
        0x4A65, 0x4182, 0x5A25, 0x6246, 0x59E5, 0x4181, 0x72C8, 0x938B, 0xA36A, 0xB38D, 0xBB8C, 0x8267, 0x2904, 0xDD74, 0xC48F, 0xC532, 0xE6FC, 0x8292, 0x8AB6, 0xAB9B, 0xCC5D, 0xABB3, 0x8AAF, 0x8A90, 0xA396, 0xC439, 0xBC38, 0xBC36, 0xBC75, 0xCC7C, 
        0xC41E, 0xB39D, 0xAB3B, 0xB39E, 0xB3BD, 0xB3DD, 0xB3DE, 0xBBBC, 0xBBBD, 0xB3BE, 0xB39E, 0xB3DC, 0xBBBC, 0xBB9D, 0xBBBE, 0xB35E, 0xB3DD, 0xBC79, 0xBCD4,
  0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A52, 0x7A32, 0x7A32, 0x7A32, 0x7A53, 0x7A52, 0x7A52, 0x7A52, 0x7A52, 0x7A52, 0x7A53, 0x8253, 0x8A53, 0x8A53, 0x8253, 0x8A53, 0x8253, 0x8253, 0x8253, 0x8273, 0x8253, 0x8253, 0x8273, 0x8A73, 0x8A54, 0x8A74, 0x8A73, 
        0x8A73, 0x8A93, 0x8A73, 0x8A73, 0x8A73, 0x8A73, 0x8A74, 0x8A74, 0x8A74, 0x8A54, 0x8A74, 0x8A73, 0x8A73, 0x8A93, 0x8A94, 0x8273, 0x8252, 0x7251, 0x6A4F, 0x622C, 0x624A, 0x5209, 0x5A08, 0x49E7, 0x41E7, 0x936E, 0xA432, 0xB4F5, 0xD5D8, 0xBD55, 
        0x93CE, 0xA450, 0xE6DB, 0xFFDF, 0xF79E, 0xF79E, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDD, 0xE730, 0xEF77, 0xCE37, 
        0x734C, 0x20E4, 0xA514, 0xF7BE, 0xFFFF, 0xFFFE, 0xFFFF, 0xFFFE, 0xFFDD, 0xFFDE, 0xFFFE, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xE71C, 0x2944, 0x7308, 0xAC4C, 0xAC0C, 0xAC0B, 0xAC2C, 0xABCC, 0x9AEB, 0xABEF, 0xDDB7, 0xD597, 0xA3CE, 0x9B4C, 0xBC2F, 0xD452, 0xDB72, 0xA98B, 0xAA8C, 0x8B2A, 0x4AE5, 0x4A64, 0x4A85, 0x844C, 0xD6B5, 0x2A24, 0x1961, 0x31C3, 
        0x5AA6, 0x7B09, 0x6307, 0x6327, 0x73AA, 0x6B89, 0x6B8A, 0x638B, 0x5B6A, 0x7BAB, 0x6349, 0x6328, 0x7B49, 0x8B6A, 0xCDF5, 0xDE77, 0xC553, 0xF79D, 0xFFBE, 0xF79E, 0xF7BF, 0xFFDF, 0xF67D, 0xF57A, 0xECB6, 0xAA49, 0x82E8, 0x7BAA, 0x83ED, 0x8A6A, 
        0x932A, 0x8328, 0x5AC5, 0xA4CD, 0xBCD0, 0xC490, 0xCCAF, 0xE577, 0xBC11, 0xBC10, 0xED16, 0xC38F, 0x9A2A, 0x8168, 0x8209, 0xEE56, 0xE616, 0xE658, 0xDEFB, 0x2104, 0x38E2, 0x6A45, 0x8BAA, 0x6AE7, 0x6267, 0x59C5, 0x71E4, 0xE6D6, 0xA4CD, 0x6224, 
        0x3841, 0x70C3, 0x68A3, 0x7924, 0x9A27, 0x3861, 0x58A3, 0x60A3, 0x48A3, 0xDCB2, 0xD4B2, 0x92EB, 0x6124, 0xCCF6, 0x7A8B, 0x82AB, 0xE597, 0xD38F, 0xE412, 0xD3D1, 0xA22A, 0x7864, 0x8906, 0x8947, 0x7885, 0x8864, 0x90E6, 0x9107, 0x88C6, 0x9887, 
        0xA8C7, 0xB149, 0xCA2D, 0xF395, 0xF3F5, 0xF496, 0xF517, 0xD3F2, 0xDC13, 0xE454, 0xDBD1, 0x60E5, 0xB3CF, 0xE596, 0xEDD6, 0xF75B, 0xF77C, 0x9D13, 0x18C2, 0x2101, 0x31A3, 0x39A3, 0x3142, 0x2982, 0x31C2, 0x4203, 0x4A03, 0x2921, 0x52A5, 0x6B68, 
        0x62C7, 0x41C3, 0x62A6, 0x6AE8, 0x5A86, 0x5244, 0x8B49, 0x9B8B, 0x9309, 0xB36A, 0xA2E9, 0xAB2A, 0xB3AC, 0x4903, 0xAC70, 0xF677, 0xF5F7, 0xBCD6, 0xC49B, 0xB419, 0x92F1, 0x726F, 0xBC97, 0xD4FB, 0xB378, 0xA377, 0xB453, 0xB4AE, 0xAC8B, 0xC48F, 
        0xD535, 0xCD38, 0xBC5A, 0xB37C, 0xB39C, 0xBBBD, 0xBBDD, 0xB3BC, 0xBBDD, 0xBBDD, 0xBBBE, 0xBBBD, 0xBBBE, 0xBBBD, 0xBBBD, 0xBBDD, 0xBBDE, 0xBBBE, 0xB3BD,
  0x7A52, 0x8252, 0x8252, 0x8252, 0x8253, 0x7A52, 0x7A52, 0x7A33, 0x8252, 0x8253, 0x8253, 0x8273, 0x8253, 0x8253, 0x8253, 0x8273, 0x8253, 0x8A73, 0x8A73, 0x8253, 0x8A73, 0x8A73, 0x8A73, 0x8253, 0x8A93, 0x8A73, 0x8A73, 0x8A74, 0x8A73, 0x8A73, 0x8A93, 
        0x8A93, 0x8A93, 0x8A93, 0x8A93, 0x8A93, 0x8A73, 0x8293, 0x8293, 0x8274, 0x8A74, 0x8A94, 0x92B4, 0x8AB4, 0x8A93, 0x8A93, 0x8293, 0x7A93, 0x7A6F, 0x728E, 0x6A6E, 0x624D, 0x5A28, 0x5246, 0x5245, 0x5246, 0x6AA9, 0x8BAE, 0x9C91, 0xAD32, 0xCD97, 
        0x9BD1, 0x9BD0, 0xD617, 0xFFBE, 0xFFBF, 0xFF9F, 0xFFBF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xEF5D, 0xDE9A, 0xE75C, 0x73CC, 0x2922, 
        0x2082, 0x3982, 0xAD74, 0xF7BE, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDE, 0xFFFE, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFBF, 0xFFBF, 0xE71C, 0x2924, 0x6AC8, 0xAC4D, 0xC48E, 0xAC0B, 0xA3CB, 0xAC0E, 0xCCB2, 0xECB3, 0xF557, 0xED57, 0xD494, 0xC472, 0xC3F1, 0xD36F, 0xD2CE, 0x88A9, 0xBACE, 0xB3AF, 0x72C9, 0x4264, 0x4244, 0x6348, 0x94EF, 0x748D, 0x4A85, 0x3982, 
        0x5226, 0xB46E, 0xA46E, 0x8C0C, 0x7369, 0x7B29, 0x734A, 0x6B6A, 0x636B, 0x6389, 0x6369, 0x638A, 0x63AA, 0x5A65, 0x6AA7, 0x8BED, 0xC5D4, 0xF7BE, 0xFFFF, 0xFFFF, 0xFFFF, 0xF7BE, 0xEDDA, 0xE497, 0xEC36, 0xE2ED, 0x9AA9, 0x7B2A, 0x940E, 0x9A4A, 
        0xAAEB, 0xA38B, 0x7BC9, 0x73A8, 0x9C6E, 0xCD12, 0xECF2, 0xABEF, 0x9B8E, 0xA3AF, 0xBBF0, 0xC390, 0xE5F9, 0xFF9E, 0xFFDE, 0xFF5A, 0xF75B, 0xA513, 0x2924, 0x8BEB, 0x6265, 0x28C0, 0x0820, 0x38C0, 0x28E1, 0x49A4, 0xA389, 0xEF1A, 0xA42E, 0x5983, 
        0x4041, 0x78C4, 0x78C4, 0x70E3, 0x68E3, 0x4821, 0x6843, 0x88C6, 0xA969, 0x9AAB, 0xBC30, 0xA3AE, 0x79E8, 0xC4D4, 0xA3AF, 0xB3F0, 0xEDD8, 0xF5B8, 0xB34F, 0x9A0A, 0xAA2A, 0xCAAD, 0xA9EA, 0x9127, 0x8884, 0x90C5, 0x9908, 0xA169, 0x9989, 0x9888, 
        0x8825, 0x9066, 0xB14A, 0xE2B0, 0xE332, 0xEC15, 0xFD59, 0xEC75, 0x99EA, 0xA1EA, 0xE434, 0xAB2D, 0xD515, 0xF65A, 0xF657, 0xDD12, 0xEEB9, 0xFFDC, 0xE716, 0x2103, 0x2983, 0x3A04, 0x31A3, 0x41A3, 0x3181, 0x31C2, 0x4A24, 0x3161, 0x52A6, 0x6B48, 
        0x5AE6, 0x3901, 0x4163, 0x5205, 0x5A85, 0x49E3, 0x72A6, 0x9BAB, 0xBC8F, 0xB38B, 0xA309, 0xA32A, 0xB3AC, 0xA2E8, 0xCC8F, 0xEE58, 0xEF3D, 0x9B53, 0x69D0, 0x61AC, 0x7AEB, 0xE59C, 0xD4DC, 0xABB7, 0x9B12, 0xB44F, 0xC4EC, 0xC52D, 0xBD0F, 0x9C0C, 
        0xAC4D, 0xCCD2, 0xDD58, 0xB35E, 0xB39F, 0xBBDE, 0xBBDD, 0xBBFE, 0xBBFD, 0xBBDD, 0xB3DD, 0xBBBF, 0xB3DF, 0xB3BE, 0xBB9E, 0xBC1E, 0xB3DD, 0xB3DD, 0xBBFD,
  0x7A52, 0x7A32, 0x7A32, 0x7A32, 0x7A53, 0x7A52, 0x7A32, 0x7A32, 0x7A53, 0x7A53, 0x7A52, 0x7A52, 0x7A72, 0x7A72, 0x7A73, 0x8253, 0x8253, 0x8A53, 0x8A53, 0x8253, 0x8253, 0x8253, 0x8273, 0x8A73, 0x8A93, 0x8A73, 0x8A53, 0x8A53, 0x8A53, 0x8A73, 0x8A93, 
        0x8A73, 0x8A73, 0x8A93, 0x8A93, 0x8A73, 0x8A94, 0x8294, 0x8294, 0x8A93, 0x8293, 0x8293, 0x8A94, 0x8A94, 0x8A93, 0x8A73, 0x8A73, 0x7A90, 0x626C, 0x5A2B, 0x622C, 0x6A2C, 0x620B, 0x5A4A, 0x5A6A, 0x628B, 0x93EE, 0xA431, 0xAC92, 0xAD12, 0xAC4F, 
        0x7B4B, 0x41C5, 0x2124, 0xE71C, 0xFFFF, 0xFFDF, 0xFF9E, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF7DF, 0xEF9E, 0xF6DD, 0xE61A, 0x8BD0, 0x2945, 0xD6B9, 0x842C, 0x4A84, 
        0x4A86, 0x10A2, 0x632C, 0xBDD7, 0xF7BE, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFFE, 0xFFDE, 0xFFFE, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFDE, 0xFFFE, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFBE, 0xFFBE, 0xE71B, 0x2924, 0x7287, 0xB42C, 0xCCEF, 0xA3EB, 0x9329, 0xB46F, 0xF71C, 0xECD5, 0xE495, 0xCBF1, 0xA2EC, 0xA371, 0xAB4E, 0xBACD, 0xC1ED, 0xA087, 0xC26D, 0xD3D1, 0xBBEE, 0x41A5, 0x4204, 0x4AA5, 0x6348, 0xA5B0, 0x7C0C, 0x62A8, 
        0x7247, 0xBC8F, 0xC510, 0xB4CF, 0x9C2C, 0x8B29, 0x72E9, 0x6AC8, 0x6AC8, 0x4245, 0x4A65, 0x62E7, 0x7349, 0x5A25, 0x5A05, 0x8B8B, 0xDE76, 0xFFDE, 0xFFBE, 0xFFBE, 0xFFDF, 0xFE9E, 0xF4D8, 0xE3D5, 0xD3B4, 0xEAD0, 0x9A6A, 0x62C9, 0x6BCD, 0xB34D, 
        0xCBAF, 0xC40F, 0xABED, 0x42A4, 0x948D, 0xC5B3, 0xC553, 0x8A67, 0x930B, 0xA3AE, 0xBC10, 0xF75C, 0xF638, 0xF5F7, 0xFF3C, 0xEF5C, 0x6B4C, 0x39A4, 0x62E8, 0x7B89, 0x49E4, 0x20E0, 0x39A2, 0xCDF1, 0x8348, 0x7A25, 0xBC0B, 0xE6FA, 0x82EB, 0x4861, 
        0x5820, 0x6842, 0x6863, 0x6082, 0x5860, 0x5060, 0x6884, 0x9109, 0xB1EC, 0x8184, 0xA32B, 0xABEF, 0xA38D, 0xAB8E, 0xA38D, 0xC513, 0xEEDB, 0x91E8, 0x68A3, 0x8988, 0xE3D1, 0xF537, 0xAA8D, 0x80E6, 0x88C6, 0x90E7, 0x9908, 0xA149, 0xA96A, 0xA0E8, 
        0xB109, 0xB94A, 0xB98B, 0xD26F, 0xE313, 0xEBF5, 0xE475, 0xA18B, 0xB1EB, 0xCAEE, 0xE453, 0xF65B, 0xE577, 0xDD56, 0xEE19, 0xE618, 0xF6DA, 0xFF9C, 0xE71B, 0x2104, 0x10E1, 0x29A3, 0x4204, 0x4203, 0x39C2, 0x3982, 0x39A2, 0x21C1, 0x5B26, 0x7B88, 
        0x62E6, 0x2121, 0x20C1, 0x3983, 0x5AA6, 0x2122, 0x6287, 0x938A, 0x9BCA, 0xB3EC, 0xBBCC, 0xA329, 0x8AA6, 0xDD10, 0xDD93, 0xE678, 0xE6FB, 0x4145, 0x82EE, 0x9370, 0x5A08, 0x8AEF, 0x9BF1, 0xAC53, 0xBC33, 0xAC48, 0xBCAE, 0xC512, 0xC532, 0xCCD1, 
        0xBCB0, 0xBCD1, 0xDD72, 0xCCF5, 0xBC19, 0xB39C, 0xB3BE, 0xBBFD, 0xBBDC, 0xBBBD, 0xBBBE, 0xBBBD, 0xBBBD, 0xBBBE, 0xB3DE, 0xB39D, 0xB3BD, 0xBBDC, 0xBBF9,
  0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A52, 0x7A52, 0x7A32, 0x7A32, 0x7A73, 0x8252, 0x8232, 0x7A32, 0x7A73, 0x7A53, 0x7A53, 0x8273, 0x8A33, 0x8A53, 0x8A53, 0x8A33, 0x8253, 0x8253, 0x8253, 0x8293, 0x8A73, 0x8A73, 0x8A73, 0x8A73, 0x8A73, 0x8A74, 0x8A73, 
        0x8273, 0x8A53, 0x8A73, 0x8A93, 0x8A73, 0x8A74, 0x8294, 0x8293, 0x8A73, 0x8A73, 0x8A73, 0x8A73, 0x8A94, 0x8294, 0x8A94, 0x9293, 0x9292, 0x72AF, 0x6A8E, 0x6A6D, 0x72AD, 0x730F, 0x836E, 0x8B8E, 0x8BCE, 0x9C2E, 0x9BED, 0x938C, 0x834B, 0x52A7, 
        0x62A8, 0x5A46, 0x2921, 0x18C2, 0xA514, 0xF7BE, 0xFFFF, 0xFF9D, 0xFFDE, 0xFFDF, 0xFFBF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xF73D, 0xF71C, 0xF75D, 0xFFDE, 0xEEF9, 0x8BED, 0x3184, 0x2104, 0xE71C, 0xFFDF, 0xEEFB, 0xD5B7, 0xF77C, 0xBDB3, 0x6B09, 
        0x20E2, 0x9489, 0x942B, 0xAD12, 0xEF5C, 0xBD93, 0xDEFA, 0xFFDE, 0xFFFE, 0xFFBE, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xFFDE, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 
        0xFFDE, 0xFFFF, 0xEF7C, 0x9C29, 0x940A, 0xA46D, 0xB4CE, 0xC54F, 0xA44C, 0x8B4A, 0x932B, 0xEEDC, 0xDD78, 0xBC12, 0xA3AF, 0xB452, 0xB3AF, 0xAA6B, 0x9909, 0xB149, 0xD28E, 0xDBB2, 0xC431, 0x4224, 0x4A65, 0x5286, 0x5265, 0x7429, 0x73E8, 0x8BEB, 
        0xBC90, 0xCC4F, 0xBC4E, 0xB46E, 0xB4AE, 0xCD10, 0xC4CF, 0xBCAF, 0xB4CE, 0xACCF, 0xB4AE, 0xA40C, 0x934A, 0xBC8D, 0xE698, 0xFF7C, 0xFF3B, 0xF7BE, 0xFFDF, 0xFFFF, 0xF79E, 0xDD1A, 0xE416, 0xDB93, 0xCB93, 0xEB94, 0xC30F, 0x8ACA, 0x6B0A, 0xD534, 
        0xECF6, 0xDC13, 0xAB0B, 0x5327, 0x4284, 0x7BEA, 0xEF17, 0xE697, 0xE616, 0xF699, 0xFF7D, 0xEDB5, 0xF6BA, 0xFF9E, 0xF77C, 0x9BCB, 0x4184, 0x4A45, 0xA4EB, 0x52A3, 0x6306, 0x946B, 0xB5CE, 0x8BE9, 0x8307, 0x9327, 0xBC8A, 0xE6F4, 0x7309, 0x40A1, 
        0x68E2, 0x7043, 0x6823, 0x6021, 0x6060, 0x68E3, 0x70E4, 0x9168, 0xC24D, 0x60A3, 0x8A69, 0xB3AE, 0xBC51, 0xE5F7, 0x8ACC, 0x932E, 0xD67A, 0x2904, 0x61A7, 0xA2CC, 0xBB2F, 0xD330, 0xAA2A, 0x91A8, 0x9989, 0x90E7, 0xA168, 0xA989, 0xA16A, 0xB9EB, 
        0xD24C, 0xD20C, 0xC9AB, 0xEB11, 0xEB12, 0xE353, 0xE393, 0xB22A, 0xDC76, 0xF55A, 0xE474, 0xCBB1, 0xAB0E, 0xBC12, 0xF69C, 0xFF19, 0xFEF8, 0xFF3B, 0xEF5C, 0x7B47, 0x3122, 0x2122, 0x5264, 0x5265, 0x4223, 0x39E2, 0x39E2, 0x3121, 0x6348, 0x842B, 
        0x7349, 0x20C1, 0x3183, 0x4A25, 0x4A44, 0x5A85, 0x3142, 0x3943, 0x8308, 0xC4B0, 0xBC6D, 0xA3AA, 0x9369, 0xEDB2, 0xF6F8, 0xCE76, 0x844E, 0x5A48, 0xBD35, 0xF73D, 0xEED9, 0x6AC6, 0x7AE9, 0xA3CE, 0xB472, 0xAC4F, 0xB451, 0xBCD2, 0xC574, 0xDD73, 
        0xD533, 0xCD51, 0xD590, 0xDD57, 0xC47B, 0xB3DC, 0xBB9D, 0xB3BD, 0xB3DD, 0xBBDD, 0xBBDD, 0xBBDD, 0xBBDD, 0xBBBD, 0xBBBD, 0xBBBE, 0xBBBD, 0xBBBD, 0xB39E,
  0x7A52, 0x8252, 0x8252, 0x8253, 0x8252, 0x7A72, 0x7A73, 0x7A72, 0x8252, 0x8252, 0x8253, 0x8253, 0x8A73, 0x8A73, 0x8A73, 0x8273, 0x8253, 0x8253, 0x8253, 0x8A73, 0x8A73, 0x8A73, 0x8A73, 0x8A74, 0x8A74, 0x8A74, 0x8A73, 0x8A93, 0x8A93, 0x8273, 0x8273, 
        0x8A93, 0x8A74, 0x8A94, 0x8A94, 0x8A74, 0x8A93, 0x8A93, 0x8A93, 0x8292, 0x8A93, 0x9293, 0x9293, 0x8A94, 0x8AB4, 0x8A94, 0x8A73, 0x8292, 0x8292, 0x7AB1, 0x82B0, 0x8AB0, 0x82B1, 0x8311, 0x93B2, 0x9C53, 0x9BB0, 0x938F, 0x8B8E, 0x8B8E, 0x732C, 
        0x6249, 0x51C8, 0x5185, 0x48E2, 0x9B8D, 0xD618, 0xFFBE, 0xFF9E, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFF7D, 0xEE79, 0xBC91, 0xAC6F, 0xC5B5, 0xE73B, 0x7B65, 0x3161, 0x4A66, 0xBDF2, 0xF7DE, 0xFFFF, 0xEF7E, 0xDEDC, 0xF7B3, 0xE774, 0xAD6F, 
        0x6264, 0x8B68, 0x93AB, 0x6AEA, 0x3A07, 0xB570, 0xE739, 0xFFDE, 0xFFBD, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF7DE, 
        0xFFFF, 0xFFFF, 0xF7BD, 0xAD52, 0x946D, 0x942C, 0x9C8D, 0x94AD, 0xA4EF, 0x7B4A, 0x4145, 0xDEBA, 0xB492, 0x7289, 0x5A46, 0xCDB6, 0xB3AF, 0x89A8, 0x8927, 0xD3F1, 0xD390, 0xCB70, 0xB3D0, 0x5265, 0x5284, 0x52A4, 0x52A4, 0x5B67, 0x73EA, 0x946D, 
        0xB4B0, 0xBC0C, 0xBBED, 0xB3EE, 0xAC2E, 0xC4B0, 0xC4CF, 0xBCAF, 0xB4AF, 0xC4AF, 0xBCAF, 0xC4AF, 0xCCAF, 0x8269, 0xCD95, 0xF75D, 0xFF1C, 0xFFDF, 0xFFFF, 0xFFFF, 0xF75E, 0xEC76, 0xF3D5, 0xF3D5, 0xF415, 0xF3F4, 0xF538, 0xDCD5, 0xAB4C, 0xACF1, 
        0xDDD7, 0xDCF5, 0xBB4E, 0xD635, 0xA4EF, 0x62E7, 0x41A3, 0xAD10, 0xCDB3, 0xDDD5, 0xF636, 0xFFBE, 0xFFDF, 0xEF1A, 0xB510, 0x2923, 0x9CCD, 0xB5AE, 0x6305, 0x5A63, 0x83E8, 0x8C49, 0x7386, 0x8BCA, 0x8B28, 0x9326, 0xAC67, 0xE6F6, 0x8AEA, 0x5882, 
        0x7083, 0x6864, 0x7043, 0x7841, 0x7042, 0x8946, 0x8945, 0x70C3, 0x6062, 0x9A08, 0x7965, 0x8268, 0xC4D1, 0xCCB3, 0xC452, 0xBC51, 0xB4F2, 0xF5B7, 0xDC93, 0x9A8C, 0x5063, 0x9107, 0xCAEE, 0xD370, 0xAA6C, 0x9107, 0x9908, 0xA16A, 0xA18A, 0xA969, 
        0xB969, 0xDAAF, 0xEC76, 0x98C8, 0xCA0D, 0xDAB1, 0xC290, 0xF4B8, 0xEC55, 0xEC33, 0xF4B4, 0xDC73, 0xBC32, 0xBC52, 0xE515, 0xFEDA, 0xF6B8, 0xF6D8, 0xFF5B, 0xEF5C, 0x62EB, 0x10A1, 0x2101, 0x5AA5, 0x5263, 0x4A43, 0x52A4, 0x4A43, 0x6B07, 0x944C, 
        0xB50E, 0x20E2, 0x31C3, 0x4A43, 0x51C3, 0x4AA4, 0x5AE5, 0x4224, 0x20C2, 0xAC4D, 0xCD71, 0xC571, 0xACCF, 0xBC4E, 0x8B29, 0x6AE8, 0x73CD, 0xDF3A, 0xDE18, 0xDD54, 0xDD31, 0xA3ED, 0xBC90, 0xCD30, 0xCD0D, 0x9BAF, 0xB450, 0xC4F1, 0xCD32, 0xDD12, 
        0xDD52, 0xDD73, 0xE594, 0xDD36, 0xC497, 0xB437, 0xB3D8, 0xC3DE, 0xBBDE, 0xBBDD, 0xB3DD, 0xBBDE, 0xB3DE, 0xBBDE, 0xBBDE, 0xBBDD, 0xBBDD, 0xBBDD, 0xBBBE,
  0x7A52, 0x7A32, 0x7A52, 0x7A52, 0x7A53, 0x7A52, 0x7A52, 0x7A33, 0x7A53, 0x7A52, 0x7A72, 0x7A72, 0x8A53, 0x8253, 0x8253, 0x8273, 0x8253, 0x8273, 0x8273, 0x8A73, 0x8273, 0x8273, 0x8273, 0x8253, 0x8A73, 0x8A53, 0x8A73, 0x8A93, 0x8A73, 0x8A53, 0x8A74, 
        0x8AB4, 0x8295, 0x8294, 0x8273, 0x8A73, 0x8274, 0x8A93, 0x8AB3, 0x8A93, 0x8A72, 0x8A93, 0x8A93, 0x8A93, 0x8AB3, 0x8A93, 0x8AB3, 0x8AB3, 0x8AD3, 0x8AB4, 0x8AB4, 0x8AB3, 0x9332, 0x9B53, 0xA3D5, 0xA456, 0xAC12, 0x9BD0, 0x938F, 0x8B6E, 0x52A9, 
        0x4A87, 0x5AC7, 0x6307, 0x41C5, 0x6268, 0xA491, 0xF79D, 0xFFDF, 0xFFFF, 0xFFFF, 0xF79D, 0xA450, 0x9BEF, 0xC513, 0xEED9, 0xB5D4, 0x5289, 0x632C, 0xEF5C, 0xEEDA, 0x8C0A, 0x31A1, 0x18A2, 0x9C92, 0xDEDB, 0xFFDF, 0xFFFF, 0xFFFE, 0xF7B6, 0xA50C, 
        0x20C1, 0x6203, 0x93ED, 0x736C, 0x3184, 0xCED7, 0xF7DD, 0xFFDE, 0xFFBD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDE, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xF7BE, 0xAD54, 0x41C5, 0xA552, 0x9D11, 0x8C4D, 0x83A9, 0x6347, 0x6347, 0x5B25, 0x6345, 0xDEDA, 0x6B0C, 0x3184, 0x5B49, 0xB4F0, 0x92EB, 0x9ACB, 0xCC51, 0xAB0D, 0xB2CD, 0xC330, 0xCBF2, 0x93CD, 0x5285, 0x4242, 0x5303, 0x4B04, 0x6B48, 0x838A, 
        0x9BAB, 0xAC0D, 0xABED, 0xABED, 0xB44E, 0xBCAE, 0xBCAE, 0xC48F, 0xC48E, 0xC48D, 0xC46D, 0xC46E, 0xBC4F, 0x9B49, 0xD5F5, 0xF7BD, 0xF7BC, 0xFFDF, 0xFFDF, 0xF77E, 0xE65C, 0xE456, 0xF416, 0xFC57, 0xF4B7, 0xF4B6, 0xF519, 0xFE1B, 0xFF1C, 0xEE18, 
        0xE5F8, 0xE63A, 0xFE9D, 0xFF1D, 0xDE16, 0xBD71, 0x94CD, 0x2103, 0x838C, 0xD637, 0xFFDE, 0xF7BD, 0xB532, 0x6287, 0x2923, 0xDED5, 0xB550, 0x83E9, 0x6B66, 0x5AC4, 0x7B87, 0x83A7, 0x7B45, 0x9CAB, 0x6A65, 0x7B07, 0xDEB0, 0xEF0F, 0x6AE6, 0x40A2, 
        0x78C4, 0x7843, 0x7083, 0x70C3, 0x7904, 0xA169, 0x9127, 0x9147, 0x9A08, 0x922A, 0x5905, 0x5985, 0x9BAD, 0xB492, 0xD555, 0xCCB2, 0xAB6E, 0xE69A, 0x8B0C, 0x7986, 0xC36D, 0xED9A, 0xC3D2, 0xA26B, 0x9A2A, 0xBACD, 0xA1E9, 0xA168, 0xA948, 0x8885, 
        0xB1AA, 0xDAAE, 0xEB30, 0xA0E8, 0xA0E8, 0xB96C, 0xD230, 0xD2D0, 0xE3D2, 0xEC74, 0xFCB5, 0xE4D4, 0xD453, 0xC433, 0xC473, 0xE596, 0xF698, 0xF6D9, 0xF698, 0xF77C, 0xB553, 0x5AA9, 0x1881, 0x5A43, 0x6AE7, 0x5AA6, 0x39E3, 0x5A64, 0x6AC6, 0x83A9, 
        0x844B, 0x18C2, 0x2983, 0x4A64, 0x5282, 0x3A21, 0x4A83, 0x5263, 0x41C1, 0x6B06, 0xB50F, 0xCDB1, 0x9C6A, 0x38C2, 0x61E5, 0xAC8F, 0xE6FB, 0x9ACA, 0xBBCF, 0xDD54, 0xE5F4, 0xAC48, 0xAC2B, 0xBC8F, 0xCCF1, 0x9BCB, 0xAC4A, 0xC4EC, 0xDD50, 0xCD53, 
        0xD553, 0xDD93, 0xE5D4, 0xE5B4, 0xCCF7, 0xBC1B, 0xB37E, 0xBBFE, 0xBBFE, 0xBBDE, 0xB3DE, 0xBBBE, 0xBBBD, 0xBBDD, 0xBBDD, 0xBBDD, 0xBBDE, 0xBBDE, 0xBBDD,
  0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A52, 0x7A53, 0x7A53, 0x7A53, 0x7A52, 0x7A52, 0x7253, 0x8A52, 0x8252, 0x8253, 0x8253, 0x8253, 0x8A53, 0x8A53, 0x8A53, 0x8253, 0x8253, 0x8253, 0x8A33, 0x8A73, 0x8A74, 0x8A54, 0x8253, 0x8273, 0x8A93, 0x8A73, 
        0x8272, 0x8272, 0x8271, 0x8291, 0x8290, 0x8A93, 0x8A73, 0x8A74, 0x8A74, 0x8AB2, 0x8AB3, 0x8A93, 0x8A93, 0x8AB3, 0x8A93, 0x8A74, 0x9275, 0x92B4, 0x8A73, 0x8273, 0x82D2, 0x82D2, 0x8310, 0x7B30, 0x8350, 0x8BB0, 0x8B8F, 0x838E, 0x7B6D, 0x9B6E, 
        0x9B8F, 0xA36F, 0xAB4F, 0xAB8E, 0x9B2C, 0xB3CE, 0xE5B5, 0xFF9E, 0xFF1E, 0xFEDD, 0xF6FC, 0xCD12, 0xE6B9, 0xFFDE, 0xE71C, 0x2903, 0x20E0, 0x49E3, 0x836B, 0xDEDA, 0x6B0C, 0x2902, 0x39A1, 0x0840, 0x1041, 0x6AEB, 0xE75C, 0xE7B7, 0xEFBB, 0xDE76, 
        0xBC6B, 0xCD53, 0xC571, 0x9C4B, 0x62A6, 0x950F, 0xD6D9, 0xFF9D, 0xFF5D, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xEF5D, 
        0x632C, 0x4247, 0x94D0, 0x9490, 0x94D0, 0x84CE, 0x6C6B, 0x7C29, 0x6BC8, 0x7409, 0x94CB, 0x6307, 0x5286, 0x6308, 0x7C4C, 0x5B6A, 0x4A46, 0x51E5, 0x72A7, 0xD512, 0xCB90, 0xBB0E, 0xBBAE, 0x72C8, 0x7369, 0x6B68, 0x42A3, 0x52A4, 0x52E6, 0x5AE6, 
        0x6AE6, 0xA42D, 0xA3CB, 0xA3CA, 0xAC0C, 0xAC6E, 0xBCAF, 0xCCCF, 0xC4AF, 0xBC8F, 0xCCAF, 0xD4AF, 0xCC8E, 0xAB4C, 0xDDB4, 0xFF5B, 0xFFDF, 0xFFFF, 0xFF9F, 0xEEBD, 0xDD9A, 0xECD6, 0xF4F8, 0xFD39, 0xFD99, 0xFDDB, 0xFE7B, 0xF6DC, 0xF71D, 0xFF5D, 
        0xFF7E, 0xFF3C, 0xF6BA, 0xF71C, 0xF77D, 0xCE36, 0x7B49, 0x4A45, 0xB594, 0xEF9D, 0xD6DA, 0x51E3, 0x20C0, 0x5245, 0xC56D, 0xA48C, 0x7368, 0x5AE5, 0x5B05, 0x7BEA, 0x41E5, 0x4204, 0x8C69, 0x93EB, 0x5A46, 0x7B8B, 0xDEF7, 0x8B87, 0x5162, 0x50E3, 
        0x81C6, 0x8946, 0x8966, 0x99A7, 0xB1E9, 0xB24B, 0xAA49, 0xC34D, 0xE4F4, 0x5143, 0x2060, 0x2903, 0x6AE8, 0xC5D3, 0xCD33, 0xDD54, 0xF637, 0xC472, 0xCC71, 0xDD15, 0xF598, 0xBB4E, 0x8946, 0x7925, 0x9ACB, 0xE431, 0xBACD, 0xA22B, 0xB28C, 0xC26B, 
        0xA949, 0xB1AB, 0xE310, 0xC9CB, 0xB96A, 0xC1AA, 0xE28C, 0xF2D2, 0xE312, 0xE3D3, 0xF4F6, 0xFDDB, 0xF578, 0xD453, 0xA34F, 0xEDD8, 0xF639, 0xEE78, 0xF6D8, 0xFF1A, 0xF759, 0xAD11, 0x30E2, 0x28E1, 0x3981, 0x5AA5, 0x7BE9, 0x4A44, 0x39C3, 0x6B28, 
        0xB550, 0x4245, 0x4224, 0x52A5, 0x5B26, 0x4201, 0x4222, 0x5AA5, 0x6326, 0x18E2, 0x7BCB, 0x9C6C, 0x6203, 0x4922, 0xB4F1, 0xF77B, 0xEF5B, 0x8B0C, 0xAB6E, 0xDCD2, 0xF616, 0xCD16, 0xBCB5, 0xBC92, 0xB46E, 0xAC0E, 0xA40C, 0xAC2C, 0xB48D, 0xD56E, 
        0xD552, 0xDD54, 0xDDB4, 0xEE15, 0xE5D7, 0xD557, 0xBC95, 0xBB7E, 0xB3DE, 0xBBFD, 0xBBBD, 0xBBDD, 0xBBBE, 0xBBBE, 0xBBDD, 0xB3DD, 0xBBBD, 0xBBBD, 0xBBBD,
  0x7A32, 0x8252, 0x8252, 0x8272, 0x7A53, 0x8253, 0x8252, 0x7A53, 0x7A53, 0x8253, 0x8272, 0x8273, 0x8A73, 0x8A53, 0x8253, 0x8273, 0x8253, 0x8273, 0x8273, 0x8A73, 0x8A73, 0x8A73, 0x8A73, 0x8253, 0x8A93, 0x8A93, 0x8273, 0x8273, 0x8A93, 0x8A93, 0x8A94, 
        0x8294, 0x8272, 0x8271, 0x82B1, 0x82D1, 0x8292, 0x82B3, 0x8294, 0x8A74, 0x82B4, 0x8AD4, 0x92D4, 0x92D5, 0x92D4, 0x8AB4, 0x82B4, 0x8293, 0x8A94, 0x9294, 0x9294, 0x8A92, 0x7AB2, 0x7AD1, 0x72B0, 0x6A6E, 0x730F, 0x7B4F, 0x7B4F, 0x834F, 0x8B71, 
        0x8BB2, 0x9BF2, 0xA413, 0xABB1, 0xA38F, 0x92EB, 0x92C8, 0xEF5C, 0xFFDF, 0xF73D, 0xE638, 0xE594, 0xEE56, 0xB510, 0x51E3, 0x49E6, 0x62A5, 0x7BA8, 0x8CAD, 0x6A22, 0x30C0, 0x3143, 0x838A, 0xEF7C, 0xFFDE, 0xD679, 0x9430, 0xAC2C, 0xDE56, 0xE715, 
        0xBDC9, 0x940A, 0xAC8F, 0x834C, 0x2945, 0xE71C, 0xFFFF, 0xFFDF, 0xFF9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xE71C, 0x2944, 
        0x5B09, 0x8CD0, 0x9554, 0x9D31, 0x9D10, 0x8CCE, 0x746C, 0x6BE9, 0x63A8, 0x4AE5, 0x2A02, 0x7BEB, 0x7BCA, 0x6B49, 0x634A, 0xCEB7, 0x842D, 0x41E5, 0x3141, 0x82E8, 0x8A88, 0x81E6, 0x8A27, 0xDDF4, 0x942C, 0x5AE6, 0x5AC5, 0x4AC4, 0x4AC4, 0x42A4, 
        0x42E3, 0x8B8B, 0x9BEB, 0x9C0B, 0xA3EC, 0xC44E, 0xC48F, 0xC4AF, 0xC4AF, 0xC4B1, 0xD4B0, 0xDCB0, 0xDC90, 0xAB8C, 0xBCB1, 0xDE57, 0xFFDE, 0xFFDF, 0xFF3E, 0xFE7D, 0xFDFC, 0xFD39, 0xFD7B, 0xFDFC, 0xFE7D, 0xFF1E, 0xFF5E, 0xFF9F, 0xFFBF, 0xF73D, 
        0xFF3D, 0xFF7E, 0xFF5E, 0xEED8, 0xE697, 0xEEFA, 0xFFDE, 0xEF9D, 0x8C2B, 0x39A1, 0x10A0, 0x39E3, 0x6B46, 0x7367, 0x52A5, 0x7BC9, 0x5A64, 0x3180, 0x2980, 0x5A44, 0x2902, 0x2921, 0x6AA3, 0x7B89, 0x6AE7, 0x944D, 0xEF57, 0xBDAB, 0x5A44, 0x4923, 
        0x7A27, 0x7944, 0x9166, 0x9987, 0xA1A8, 0xB20A, 0xDBD1, 0xE3F2, 0xB28B, 0x49E4, 0x49A2, 0x3901, 0x2103, 0xDEF8, 0xE676, 0xD553, 0xDD13, 0xF638, 0xEE19, 0xD556, 0xBBEF, 0x8166, 0xC390, 0xC3F2, 0x8A6A, 0xEC73, 0xF515, 0xCBD0, 0x8988, 0xBA8C, 
        0x9168, 0x9128, 0xC26C, 0xF391, 0xF371, 0xF351, 0xF311, 0xA9CB, 0xB28E, 0xCB50, 0xD411, 0xED16, 0xF598, 0xDD16, 0xB3D2, 0xDD14, 0xEDD7, 0xF678, 0xF6D8, 0xE615, 0xEED8, 0xF799, 0xEF58, 0x8B8E, 0x41A5, 0x3142, 0x5204, 0x5A63, 0x3122, 0x49E6, 
        0x9C6E, 0x944D, 0x62E6, 0x6307, 0x8C8C, 0x62E4, 0x5243, 0x4A23, 0x4A62, 0x6385, 0x31C3, 0x62A7, 0xDDF1, 0x8B6A, 0xCDB3, 0xF77A, 0xEF1A, 0x6186, 0x9ACC, 0xDCD2, 0xEE35, 0xCD13, 0xB471, 0xB491, 0xCD12, 0xAC2D, 0xB4AC, 0xC50D, 0xCD10, 0xD553, 
        0xDD54, 0xE575, 0xE5B4, 0xF615, 0xE5B6, 0xCCF8, 0xBC1B, 0xB39E, 0xB3DD, 0xBBFD, 0xBBDE, 0xB3FE, 0xBBFE, 0xBBFE, 0xBBFE, 0xBBFE, 0xBBDE, 0xBBDE, 0xBBDE,
  0x7A53, 0x8253, 0x7A53, 0x7A52, 0x8253, 0x8252, 0x7A53, 0x7A33, 0x7A53, 0x7A53, 0x8253, 0x8253, 0x8A73, 0x8A73, 0x8A73, 0x8273, 0x8253, 0x8273, 0x8273, 0x8A73, 0x8A73, 0x8A73, 0x8A53, 0x8A53, 0x8A93, 0x8A93, 0x8A73, 0x8273, 0x8A94, 0x9294, 0x8A94, 
        0x7272, 0x8A90, 0x8AB0, 0x82EF, 0x7AED, 0x82D3, 0x82B3, 0x8AB2, 0x8AD2, 0x92D1, 0x9AF2, 0x9AF1, 0x9AD0, 0x9311, 0x9AF0, 0xA2F2, 0xB354, 0xAB56, 0x9B34, 0x8B12, 0x7B0F, 0x72CD, 0x6ACB, 0x5A8A, 0x4A49, 0x4A24, 0x5A47, 0x6A6A, 0x7AAC, 0xA36E, 
        0xBBF2, 0xCC34, 0xD454, 0xD472, 0xD4F3, 0x936D, 0x4924, 0xE5D6, 0xFF5C, 0xFFFF, 0xFFBE, 0xDDD5, 0x6248, 0x2061, 0x2860, 0x3940, 0x28C0, 0x1040, 0x0820, 0x4101, 0xB44C, 0xF6B6, 0xFF9D, 0xF554, 0xED56, 0xF5D9, 0xEE38, 0x950C, 0xCEB5, 0xEF37, 
        0xDE0F, 0x93AD, 0x7329, 0x4A05, 0x2124, 0xE71A, 0xFFFE, 0xFFDE, 0xFF9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDE, 0xFFFE, 0xFFFF, 0xFFDE, 0xDEDA, 0x94B0, 0x41C3, 
        0x842D, 0xA552, 0x94B0, 0x94F0, 0x94AF, 0x8C6E, 0x744C, 0x63E9, 0x5B46, 0x42A4, 0x3A62, 0x9D0E, 0x7389, 0x52E7, 0x6C0B, 0xC617, 0x9CCF, 0x5AE7, 0x2941, 0x6AA4, 0x9329, 0xC40F, 0xDCF3, 0x7285, 0x41E2, 0x4243, 0x6326, 0x6365, 0x4AC4, 0x3A63, 
        0x3A42, 0x5A63, 0x8348, 0xA40B, 0xAC4D, 0xB44E, 0xBC8F, 0xC4B0, 0xC48F, 0xD4D0, 0xDCCF, 0xDCCF, 0xD4B0, 0xABAB, 0xC511, 0xDE98, 0xFFDE, 0xFFDF, 0xFEDD, 0xF65C, 0xF65B, 0xF63D, 0xFE7E, 0xFEFF, 0xFF5F, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFBF, 0xF75C, 
        0xEEDB, 0xEE79, 0xEE78, 0xFFDE, 0xFFFE, 0xFFFE, 0xE73B, 0x4A03, 0x2100, 0x2961, 0x4A62, 0x7368, 0x7367, 0x7BC8, 0x7BE9, 0x3921, 0x4982, 0x41C2, 0x3141, 0x1020, 0x0840, 0x2901, 0x5A25, 0x6BAB, 0x6387, 0x8C67, 0xC5CD, 0x8245, 0x7924, 0x88E5, 
        0x8905, 0x4862, 0x91E7, 0xA269, 0x7966, 0x7883, 0x8904, 0x99A8, 0x9A6A, 0x49A2, 0x39C2, 0x2941, 0x1081, 0x6B4B, 0xC574, 0xCD74, 0x9C0F, 0xE6B9, 0xBC30, 0xB32D, 0xE4D4, 0xFF1D, 0xFE7A, 0xD492, 0xA2AA, 0xE4F6, 0xECD4, 0xC36E, 0x91A6, 0xB22A, 
        0xDB70, 0xDB4F, 0xC20B, 0xF414, 0xE2F0, 0xDA6E, 0xE2F0, 0xC1EB, 0xCACE, 0xD330, 0xCB30, 0xECB5, 0xF557, 0xFD98, 0xFD78, 0xE597, 0xE596, 0xE5D6, 0xEE17, 0xE676, 0xE635, 0xEE77, 0xFF39, 0xF6D5, 0xC572, 0x732B, 0x18A2, 0x41E3, 0x4182, 0x49C2, 
        0x6B06, 0x8C6D, 0x6B8A, 0x6B48, 0x7BCA, 0x6B45, 0x5AC4, 0x52A4, 0x5AA6, 0x3201, 0x4A43, 0x6A85, 0x7A85, 0x8B47, 0xD615, 0xF77C, 0xE657, 0x6104, 0x926C, 0xD473, 0xF5D3, 0xCD52, 0xB46F, 0xAC2F, 0xB492, 0xB42F, 0xB450, 0xBC90, 0xC50E, 0xD571, 
        0xD554, 0xDD55, 0xDD95, 0xE5D5, 0xE5F6, 0xD554, 0xBC70, 0xBBDD, 0xBBDE, 0xB3FD, 0xBBDE, 0xBBBE, 0xBBDF, 0xB3DE, 0xBBDD, 0xBBFE, 0xBBFE, 0xBBDE, 0xBBBD,
  0x7A32, 0x7A32, 0x7A32, 0x7A32, 0x7A52, 0x7A52, 0x7A53, 0x7A53, 0x7A52, 0x7252, 0x7A52, 0x8A53, 0x8253, 0x8232, 0x8232, 0x8253, 0x8253, 0x8A53, 0x8A53, 0x8A53, 0x8253, 0x8253, 0x8272, 0x8A72, 0x8A53, 0x8A53, 0x8A73, 0x8274, 0x9274, 0x8253, 0x7A53, 
        0x7A51, 0x6ACD, 0x830D, 0x934E, 0x9B71, 0x9AF1, 0x92F2, 0x9AD3, 0x9AF3, 0x9B72, 0xA331, 0xA311, 0xA353, 0xB3D3, 0xC415, 0xC456, 0xC476, 0xBBB3, 0xB374, 0x92D2, 0x71EE, 0x6A0B, 0x51EA, 0x41A8, 0x3965, 0x2124, 0x3184, 0x4A26, 0x6349, 0xAC73, 
        0xC4D4, 0xD4F5, 0xE4D5, 0xE4D5, 0xC452, 0xC451, 0xCC91, 0x3924, 0xA514, 0xF7BE, 0xE71C, 0x3924, 0x59E5, 0x938A, 0xC4EF, 0xF6D6, 0xFF7A, 0xFFDC, 0xFFFF, 0xFFFD, 0xFF7A, 0xE615, 0xCC70, 0xDDF4, 0xEDF6, 0xE5B5, 0xC552, 0x9509, 0xCEB3, 0xDF15, 
        0xC60E, 0xF79A, 0xD675, 0x8C0B, 0x3183, 0x6BAC, 0xC658, 0xF7BE, 0xFF9E, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xEEFB, 0xEF3C, 0x9CF3, 0x2944, 0xA58F, 
        0x9D4F, 0x8CCE, 0x94F0, 0x948D, 0x844D, 0x846D, 0x84AD, 0x5B27, 0x4AA5, 0x5B06, 0x842A, 0xAD90, 0x8C8D, 0x63CB, 0x53AB, 0x952F, 0x9D70, 0x63AB, 0x20E3, 0x9BCA, 0xBC8E, 0xD572, 0xDDD4, 0x2903, 0x39E3, 0x4AA3, 0x4282, 0x7388, 0x7BC8, 0x6BA8, 
        0x5B26, 0x5A65, 0x59E2, 0x6A03, 0x92C7, 0xB4AE, 0xC4CF, 0xCCAF, 0xCC8F, 0xCCF1, 0xCCD1, 0xD4D1, 0xDCD1, 0xC3CB, 0xDD11, 0xEE98, 0xFFDE, 0xFFDF, 0xF6FD, 0xF69D, 0xFF1E, 0xFF7F, 0xFF9E, 0xFF9E, 0xFF9F, 0xFFBE, 0xFFDE, 0xFFFF, 0xF7DE, 0xF73B, 
        0xF75B, 0xFF9D, 0xF7BD, 0xB594, 0x948E, 0x5AA8, 0x18C2, 0x7389, 0x73A8, 0x6B25, 0x62C4, 0x7369, 0x6B48, 0x4A25, 0x2081, 0x51E4, 0x4982, 0x3962, 0x3181, 0x2080, 0x1840, 0x3143, 0x7308, 0x8B0C, 0x6B0A, 0x6388, 0x8446, 0x5261, 0x6A45, 0x7987, 
        0x9085, 0xD1C9, 0xDB0C, 0xEC50, 0xF555, 0xD38F, 0x8166, 0x68E4, 0x71C5, 0x3961, 0x31A2, 0x3A02, 0x3A21, 0x18E2, 0x9CF2, 0xE6B8, 0xD5B4, 0xEE18, 0xDD75, 0xDDF7, 0xF71D, 0xED55, 0xEDB7, 0xF6BB, 0xE6FB, 0x3145, 0xA3D0, 0xF5F8, 0xFDF9, 0xE474, 
        0xE432, 0xE452, 0xE473, 0xDBD1, 0xD34E, 0xDB90, 0xFCB5, 0xF434, 0xD351, 0xCB51, 0xE433, 0xE4B5, 0xDC95, 0xE557, 0xF69B, 0xEDD7, 0xEE57, 0xE677, 0xDE36, 0xD5F5, 0xDE36, 0xE636, 0xE636, 0xEEF7, 0xF75B, 0xB555, 0x4166, 0x1081, 0x2901, 0x2901, 
        0x3102, 0xB4CD, 0x948D, 0x73EC, 0x73C9, 0x6B47, 0x6327, 0x52C5, 0x4A42, 0x52C4, 0x5262, 0x5202, 0x5A44, 0x7B07, 0xCDD4, 0xE699, 0xC4D3, 0x6104, 0xAB4D, 0xDD95, 0xEEB7, 0xE5D4, 0xBC91, 0xA3EF, 0xA3CC, 0x9BCB, 0x93C8, 0xA428, 0xBCCD, 0xD554, 
        0xD574, 0xD574, 0xD553, 0xE5B5, 0xE5B6, 0xDD99, 0xD53E, 0xAB7C, 0xB3BD, 0xBBFD, 0xBBBD, 0xBBDE, 0xBBDE, 0xBBDD, 0xBBDC, 0xB3BE, 0xB3DD, 0xB3DD, 0xBBDD,
  0x8252, 0x8253, 0x7A53, 0x7A52, 0x8272, 0x8253, 0x8253, 0x8A73, 0x8A53, 0x8253, 0x8253, 0x8253, 0x8A73, 0x8A73, 0x8A73, 0x8273, 0x8253, 0x8273, 0x8273, 0x8A73, 0x8273, 0x8A73, 0x8A73, 0x8274, 0x8294, 0x8A93, 0x8A73, 0x8A73, 0x8A94, 0x7A93, 0x7A71, 
        0x724E, 0x830D, 0x8B4E, 0x9370, 0xA372, 0x9B52, 0x9B32, 0xA312, 0xA311, 0xB350, 0xB370, 0xB370, 0xBB72, 0xC412, 0xCBF2, 0xD413, 0xDC75, 0xBC75, 0xABF3, 0xA3B1, 0x8B4E, 0x622A, 0x5A48, 0x5A47, 0x5205, 0x4964, 0x4943, 0x5965, 0x71C9, 0xAB8F, 
        0xCC12, 0xDC54, 0xE495, 0xECB5, 0xDC93, 0xCC71, 0xAC0E, 0x9AC9, 0xABEF, 0xB491, 0xA44E, 0xB4F1, 0xDEB7, 0xFF3A, 0xFEB8, 0xF6F8, 0xF6D7, 0xF676, 0xF655, 0xEE55, 0xE5B3, 0xDD52, 0xD551, 0xF615, 0xF5F7, 0xF61A, 0xEEBB, 0xCE10, 0xC58D, 0xD633, 
        0xDEFA, 0x39E4, 0x4247, 0x4A67, 0x4A24, 0xBE54, 0xEF9C, 0xFFDE, 0xFFBE, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF7BE, 0xA514, 0x2103, 0x52E5, 
        0x4AA5, 0x52A7, 0x6B4A, 0x9C8F, 0x8C4D, 0x7C0C, 0x73EB, 0x6B68, 0x6B47, 0x7BAA, 0x9CCE, 0xB54F, 0xA4EE, 0x842C, 0x636A, 0x6C2B, 0x9D50, 0x844C, 0x4203, 0xAD10, 0xC4D0, 0xD553, 0xDE36, 0x3163, 0x4223, 0x52C4, 0x52A3, 0x5B24, 0x842A, 0x94CD, 
        0x9D0D, 0x9C0B, 0x9BCA, 0x9B89, 0x9B8B, 0xBC4E, 0xC48F, 0xCCB0, 0xDCD0, 0xCCD0, 0xD4F1, 0xD4F1, 0xD4B0, 0xCC4D, 0xD46F, 0xE5B5, 0xFFBE, 0xFFDF, 0xFFBF, 0xFFBF, 0xFFBF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFBE, 0xFF9D, 0xFF7D, 0xFFDF, 
        0xF7BE, 0xCE17, 0x730B, 0x1061, 0x0820, 0x20E2, 0x5246, 0x942C, 0x7367, 0x5A84, 0x49E4, 0x4961, 0x3900, 0x38E1, 0x4123, 0x5204, 0x49E4, 0x39A3, 0x2963, 0x1882, 0x1861, 0x59A6, 0xC40F, 0x7B4C, 0x6B49, 0x6387, 0x73E8, 0xAC0B, 0x9ACA, 0x8A09, 
        0x91E8, 0xBA69, 0xCB6D, 0xE492, 0xFDD7, 0xFE78, 0xF595, 0xF595, 0xDDB5, 0x2103, 0x2141, 0x2A22, 0x2A63, 0x3983, 0x4964, 0x83AD, 0xEF3C, 0xF616, 0xF6BA, 0xFEFC, 0xFE9A, 0xDD36, 0xEE1A, 0xFEBC, 0xEE5A, 0x9B0C, 0xCCF3, 0xED96, 0xD493, 0xC3CF, 
        0x9229, 0x9209, 0xCB6F, 0xE411, 0xE370, 0xE391, 0xFC94, 0xF493, 0xF474, 0xEBF3, 0xDB31, 0xD412, 0xDC53, 0xDC74, 0xE4D5, 0xFE9B, 0xF6DB, 0xF6FA, 0xF71A, 0xEE34, 0xDE35, 0xE676, 0xF6D6, 0xDDF4, 0xEEB7, 0xF77B, 0xE71B, 0x4944, 0x2060, 0x1040, 
        0x0840, 0x49E5, 0x8C6D, 0x8C6D, 0x5A86, 0x8C0B, 0x948D, 0x7BCA, 0x4A43, 0x52A4, 0x52A4, 0x52A3, 0x62A2, 0x7328, 0xC511, 0xCCF2, 0x932B, 0xCC51, 0xEDB8, 0xFE99, 0xFE96, 0xE594, 0xEE16, 0xE5F8, 0xD536, 0xC4D1, 0xBC6F, 0xBC8F, 0xCD30, 0xE573, 
        0xDD94, 0xDD94, 0xDD74, 0xF615, 0xE5D6, 0xCD55, 0xBC93, 0xBC7C, 0xBC3D, 0xBBFD, 0xBBDE, 0xBBDE, 0xBBDE, 0xBBFE, 0xBBFD, 0xBBDE, 0xBBDE, 0xBBDD, 0xBBFE,
  0x7A53, 0x8253, 0x8273, 0x8A73, 0x7253, 0x7A52, 0x8252, 0x8253, 0x8253, 0x8253, 0x7A53, 0x8293, 0x8A73, 0x8A73, 0x8A73, 0x8273, 0x8273, 0x8273, 0x8273, 0x8A73, 0x8A73, 0x8273, 0x8274, 0x8273, 0x8A93, 0x8A94, 0x8A93, 0x8273, 0x8A93, 0x8A93, 0x7A72, 
        0x6A6E, 0x7ACB, 0x8B6D, 0x93AF, 0x93D0, 0xABB1, 0xAB71, 0xAB72, 0xA393, 0xBB33, 0xBB72, 0xC3D2, 0xD412, 0xDC14, 0xE474, 0xECD4, 0xF535, 0xD495, 0xBC12, 0xA370, 0x82AF, 0x5A2B, 0x51C8, 0x4966, 0x3964, 0x4A64, 0x4A23, 0x49E4, 0x4A26, 0xA390, 
        0xC3F3, 0xDC34, 0xEC76, 0xEC96, 0xDC53, 0xD471, 0xCC90, 0x9B4C, 0x930C, 0x8B2C, 0x8BAD, 0xD613, 0xEDB4, 0xED95, 0xEDF6, 0xFF38, 0xFF18, 0xFEF8, 0xFED8, 0xE5B4, 0xD5D3, 0xD5D3, 0xDDB3, 0xFE98, 0xFEDB, 0xDDB6, 0xB3ED, 0xBE90, 0xD672, 0xEEB6, 
        0xEF38, 0x82C7, 0x72A7, 0x4A25, 0x2164, 0xC6BA, 0xEFDE, 0xFFDF, 0xFFDF, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xEF3C, 0xCE37, 0xADB1, 
        0xAD50, 0x948E, 0x6389, 0x7B8A, 0x83AA, 0x94AD, 0xB5D1, 0x6AC7, 0x6AC7, 0x7B8A, 0x8C4D, 0x7BC7, 0x9C6C, 0x944E, 0x736C, 0x5349, 0x7C6C, 0x950D, 0xA52D, 0xEE95, 0xDD32, 0xDD94, 0xDEDA, 0x2964, 0x21A1, 0x4282, 0x5AE4, 0x5B04, 0x6B88, 0x73AA, 
        0x7B8A, 0x9B8A, 0xAC0D, 0xB42D, 0xB42B, 0xBC90, 0xC4B0, 0xCCAF, 0xD490, 0xCD11, 0xD511, 0xD4F1, 0xCCD1, 0xD4B0, 0xC3EC, 0xCD11, 0xF79D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFDE, 0xDE17, 
        0x72E9, 0x3101, 0x28C2, 0x49C4, 0x5264, 0x6AE6, 0x8B6C, 0x94AE, 0x62E6, 0x4181, 0x4142, 0x4161, 0x4962, 0x5183, 0x51A3, 0x4164, 0x49E4, 0x4223, 0x39A1, 0x1881, 0x3986, 0x6A8A, 0x9B4D, 0x9A4B, 0x8B2C, 0x840C, 0x8CCB, 0x9C8D, 0x61E5, 0x4083, 
        0x5125, 0xB2E9, 0xC289, 0xB209, 0x9A6A, 0xE5B6, 0xED75, 0xE554, 0xC4F1, 0x20E3, 0x3203, 0x3243, 0x2181, 0x7B67, 0x39A4, 0x49E7, 0xAC91, 0xDE36, 0xF6D8, 0xF6B8, 0xF617, 0xFF9E, 0xF6FC, 0xF6DC, 0xF73D, 0xDDB5, 0xEEDA, 0xF6BB, 0xDCD4, 0xAAAA, 
        0xCBCE, 0xC3AD, 0x9268, 0xD3D2, 0xEC31, 0xD3AE, 0xB2ED, 0xF578, 0xF4D5, 0xEC12, 0xDBD2, 0xDC52, 0xDC92, 0xDC73, 0xD453, 0xF5B8, 0xFE7A, 0xFEFA, 0xFF1B, 0xF6D9, 0xEE98, 0xE698, 0xEEB9, 0xF6F9, 0xEE96, 0xEED8, 0xEF7C, 0x8C6F, 0x39A5, 0x0820, 
        0x0820, 0x3101, 0x838A, 0x948C, 0x63C9, 0x938B, 0x9C6D, 0x844B, 0x6326, 0x52C4, 0x4283, 0x5AC4, 0x8BA8, 0x9C2C, 0xACB0, 0xACB0, 0xAC2F, 0xDCF2, 0xED74, 0xDD74, 0xC511, 0xBD71, 0xE671, 0xFED1, 0xF6B2, 0xDD55, 0xEDB9, 0xE5B7, 0xC530, 0xD513, 
        0xDD33, 0xDD54, 0xE575, 0xEE14, 0xF636, 0xE5B8, 0xBC7B, 0x929E, 0xAB3F, 0xB3DF, 0xB3DF, 0xC39F, 0xBBFE, 0xBC1D, 0xBBDE, 0xBBFE, 0xBBDE, 0xBBDE, 0xB3FE,
  0x7A32, 0x7A32, 0x7232, 0x6A12, 0x9232, 0x8A53, 0x8A53, 0x8253, 0x8253, 0x8A53, 0x8253, 0x8253, 0x8252, 0x8252, 0x8252, 0x8233, 0x8A53, 0x8A53, 0x8253, 0x8254, 0x8A54, 0x8A53, 0x8A53, 0x8273, 0x8273, 0x8253, 0x8A73, 0x8A74, 0x8A75, 0x7A71, 0x6A4D, 
        0x6A29, 0x9392, 0x9BB2, 0xAB94, 0xBB76, 0xC495, 0xBC54, 0xC3F3, 0xDC13, 0xE4D3, 0xE493, 0xDC74, 0xD493, 0xDC73, 0xDC53, 0xD432, 0xC410, 0xBB8D, 0x9AEB, 0x7A69, 0x6A06, 0x51A3, 0x5984, 0x61C5, 0x6A25, 0x8288, 0x8A89, 0xAB0D, 0xD412, 0xE4D3, 
        0xF514, 0xFCF5, 0xF4B5, 0xD431, 0xC3CF, 0xBB4D, 0xAACA, 0x9A26, 0xA2A7, 0xC3A9, 0xECEB, 0xE552, 0xD552, 0xDDD2, 0xEE94, 0xD5B5, 0xCD93, 0xDDF5, 0xF698, 0xC4EF, 0xD551, 0xD5B2, 0xCDB2, 0xD616, 0xD5F4, 0xDE75, 0xF718, 0xCD55, 0x8C0C, 0x94EE, 
        0xE77A, 0xA5C9, 0x4A83, 0x52C7, 0xAD90, 0x2964, 0xA513, 0xF77D, 0xFF9D, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xF79E, 0xB555, 0xDEBA, 0xDEFA, 0xAD51, 0x52A4, 0x9C6C, 0xBCEE, 0x9BE9, 0x9C8E, 0x9CAE, 0x8C0B, 0x6B29, 0x6B68, 0x5B47, 0x5346, 0x5B87, 0xAD30, 0xE636, 0xFED9, 0xFED8, 0xEDF6, 0x6289, 0x29A4, 0x5366, 0x52C3, 0x6B88, 0x6BC9, 
        0x5B88, 0x9B69, 0xABEB, 0xB42C, 0xB44D, 0xC4AE, 0xCCD0, 0xD4F1, 0xCD11, 0xD4F1, 0xD4D1, 0xD4F1, 0xD4F2, 0xC4AE, 0xBBCC, 0xCCB1, 0xF71B, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFBE, 0xFF9E, 0xFFFF, 0xF7BE, 0xCD95, 0x71C6, 0x1841, 
        0x4963, 0x9349, 0xB50F, 0x4A23, 0x5A85, 0x6B67, 0x63A7, 0x4A43, 0x5AA6, 0x4A45, 0x3121, 0x5A05, 0x51C5, 0x5184, 0x4983, 0x31A2, 0x4224, 0x4225, 0x2963, 0x1882, 0x928A, 0xAAAB, 0x6946, 0xBBF2, 0x8B8D, 0x7C0B, 0x9D2E, 0x51A3, 0x60C3, 0x9947, 
        0xDAED, 0xE532, 0xCC6F, 0xB38C, 0x9B09, 0x938D, 0xCDF6, 0xBD92, 0x6265, 0x2140, 0x2120, 0x39A2, 0x5286, 0x4226, 0x18E3, 0x0020, 0x18E3, 0xDE95, 0xEED7, 0xEEB9, 0xFF1B, 0xFF3E, 0xF6DB, 0xF6DB, 0xF75E, 0xFF7C, 0xF678, 0xDD94, 0xCD52, 0xF6FB, 
        0xFEFB, 0xEE18, 0xDCF3, 0xE532, 0xC470, 0xC470, 0xDCF1, 0xEC73, 0xEC94, 0xE494, 0xDC73, 0xCC12, 0xCC32, 0xCC72, 0xD4D2, 0xED96, 0xF658, 0xF6D9, 0xEF1B, 0xFF1B, 0xFF3A, 0xFF3B, 0xF73C, 0xF77A, 0xF739, 0xF719, 0xFF39, 0xEF5C, 0x7B4B, 0x30C1, 
        0x2060, 0x4921, 0x83C9, 0x8C6C, 0x6B4A, 0x9C0B, 0xA48D, 0x944D, 0x7389, 0x42A3, 0x842B, 0x7BAB, 0x3922, 0x6984, 0x92E9, 0xBC90, 0xDE16, 0xC4F1, 0xB491, 0xA44E, 0x9C0A, 0xB449, 0xB46A, 0xBCCC, 0xD5D1, 0xF799, 0xE695, 0xDDB2, 0xD592, 0xE655, 
        0xE635, 0xE5F5, 0xE5F5, 0xDDD4, 0xDDB5, 0xDDB6, 0xF639, 0xEE5A, 0xCCF7, 0xBBF7, 0xC39A, 0xAC79, 0xA39B, 0xAB3D, 0xBB9E, 0xB3DD, 0xBC1E, 0xC41E, 0xBBDD,
  0x7A52, 0x8272, 0x8272, 0x8253, 0x8273, 0x8253, 0x8253, 0x8252, 0x7272, 0x8253, 0x8A53, 0x8A73, 0x8A53, 0x8A73, 0x8273, 0x8A73, 0x8253, 0x8A73, 0x8273, 0x8273, 0x8A73, 0x8A93, 0x8A93, 0x8273, 0x8A73, 0x8A93, 0x8A93, 0x8273, 0x8A94, 0x7A70, 0x726D, 
        0x728D, 0x8AAE, 0x9B51, 0xABD3, 0xB435, 0xC436, 0xBC55, 0xC454, 0xDC53, 0xDC53, 0xDC32, 0xDC33, 0xE453, 0xCC52, 0xCC51, 0xD431, 0xD40F, 0xC430, 0xBBCE, 0xA36C, 0x7B2B, 0x62A7, 0x6A87, 0x6AA7, 0x7307, 0x8B4A, 0x8B2A, 0x932C, 0xAB6E, 0xD451, 
        0xE493, 0xF4D4, 0xF4F4, 0xE453, 0xDC11, 0xCBF0, 0xBBAF, 0xC32A, 0xA286, 0x9AA5, 0xBBA9, 0xF594, 0xDD72, 0xC551, 0xC5B3, 0xE6D6, 0xE656, 0xE615, 0xE615, 0xCD71, 0xD5D2, 0xD5F2, 0xD5F3, 0xF657, 0xDDD4, 0xDE55, 0xF77B, 0xB4F3, 0x5A88, 0x6B8C, 
        0xEF7B, 0xEF72, 0x7407, 0x52C6, 0x83CD, 0x31A4, 0xA554, 0xF7BE, 0xFFFF, 0xFFBE, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xEF3C, 
        0xF7BE, 0xFFFF, 0xFFFF, 0xFFDE, 0xE6F9, 0x944E, 0x18C2, 0x5AA6, 0x9C4B, 0xC50F, 0xCD10, 0x9BAA, 0x93CA, 0xB48D, 0xC510, 0x5AA5, 0x5AE6, 0x6B89, 0x7BEB, 0x5B05, 0xB5D2, 0xF759, 0xFF19, 0xEE37, 0x7309, 0x39E3, 0x4AE5, 0x6305, 0x6B68, 0x6BA9, 
        0x63CA, 0x7BA8, 0x9BEB, 0xB42D, 0xBC8F, 0xCCB0, 0xD4D1, 0xDCF1, 0xDCF1, 0xD511, 0xDCF1, 0xDCF1, 0xD511, 0xE513, 0xBC0D, 0xBC4E, 0xE5F6, 0xFFBE, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF79D, 0xAC90, 0x59E6, 0x20C2, 0xC4EF, 
        0xB46D, 0x8B49, 0x6A85, 0x5AA5, 0x62C5, 0x5AA5, 0x5A64, 0x7367, 0x7BA9, 0x6B48, 0x5244, 0x4141, 0x51A3, 0x5A04, 0x4A24, 0x2141, 0x3A24, 0x4A64, 0x3182, 0x1881, 0x82EA, 0xCC50, 0xD412, 0xA2AD, 0xAB6F, 0xA42E, 0x844A, 0x93EA, 0xCCB0, 0xF472, 
        0xF370, 0xDCF2, 0xE5F6, 0xDDB5, 0xC451, 0xAC2E, 0xCD74, 0xB512, 0x62C6, 0x3101, 0x39A0, 0x4AA3, 0x6366, 0x30C2, 0x1841, 0x0821, 0x1081, 0x8BEB, 0xA4AD, 0xBD50, 0xE676, 0xFF1A, 0xFF3D, 0xF73E, 0xF71C, 0xFFBE, 0xFF1B, 0xFEFA, 0xFF7D, 0xFF3B, 
        0xF6D9, 0xF71A, 0xFFBD, 0xFE59, 0xFF1A, 0xFF7B, 0xFED9, 0xED13, 0xF513, 0xFD54, 0xFD36, 0xDC93, 0xE4D3, 0xE4B2, 0xCC30, 0xB411, 0xDD35, 0xFE38, 0xFEDA, 0xFF7C, 0xFF7C, 0xFF7C, 0xF75B, 0xFEFA, 0xFF3A, 0xEEF8, 0xDE76, 0xF79B, 0xD674, 0x9C6C, 
        0x5A05, 0x40E1, 0x6A65, 0x8389, 0x8BCC, 0x948F, 0x9C4B, 0x942A, 0x842C, 0x6B88, 0x5AE6, 0x944B, 0xDEB5, 0x5903, 0x6144, 0x8AA9, 0xABED, 0xB490, 0xBD32, 0xC5B3, 0xD614, 0xF5D3, 0xE5B2, 0xC4F0, 0x9C2E, 0xE613, 0xF739, 0xF718, 0xE5D2, 0xEE16, 
        0xE615, 0xE5D4, 0xE5B3, 0xEE15, 0xEDF6, 0xE5D6, 0xE5D4, 0xEDF6, 0xF658, 0xF65B, 0xEDDE, 0xD55B, 0xBC39, 0xAB99, 0xB37B, 0xA35B, 0xA37B, 0xAB9C, 0xB3BE,
  0x8252, 0x8252, 0x8252, 0x8252, 0x8273, 0x7A73, 0x7A72, 0x8273, 0x8252, 0x8273, 0x8273, 0x8273, 0x8273, 0x8A73, 0x8A73, 0x8A93, 0x8A93, 0x8A73, 0x8A73, 0x8273, 0x8A73, 0x8A74, 0x8A94, 0x8A94, 0x8A94, 0x8A93, 0x8A93, 0x8273, 0x8A75, 0x7AAF, 0x72AD, 
        0x728F, 0x8AB0, 0x9331, 0xA3B2, 0xBBD2, 0xD415, 0xE413, 0xF412, 0xF434, 0xDC73, 0xDCB3, 0xDCD4, 0xD4D5, 0xE433, 0xCC31, 0xC410, 0xC3AF, 0x934D, 0x8B0A, 0x92C9, 0xA289, 0x8A49, 0x8AAA, 0x92EC, 0xA2ED, 0xA36C, 0xB36D, 0xC38E, 0xD3EE, 0xF452, 
        0xFCB3, 0xFCD5, 0xF4D6, 0xF494, 0xE411, 0xCB6F, 0xB30D, 0xA2A8, 0xA287, 0xAAA8, 0xB34B, 0xDCD1, 0xE552, 0xE5B3, 0xEDF4, 0xEE14, 0xEE33, 0xDDD3, 0xC552, 0xEDD2, 0xDDB2, 0xE5F3, 0xEE34, 0xBC8F, 0xDE35, 0xFF9A, 0xEF5A, 0x8B2B, 0x49A5, 0x6B4C, 
        0xDF3B, 0xF7D4, 0xCE8F, 0x9CCB, 0x62A5, 0x21A3, 0xA554, 0xF7BE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xEF5D, 0x630C, 0x39E6, 0x73CC, 0x83CC, 0x62E6, 0x8367, 0xC50E, 0xAC2C, 0xA38B, 0xA36A, 0x9BEC, 0xD572, 0x7308, 0x3A03, 0x5326, 0x9D2E, 0xA44D, 0xBD11, 0xF79A, 0xF719, 0x9C2C, 0x5A83, 0x4262, 0x5B25, 0x7389, 0x73CA, 
        0x6BC8, 0x8349, 0xA3CC, 0xC44E, 0xD48F, 0xE533, 0xDD32, 0xDD11, 0xD4F2, 0xE4F1, 0xDCF1, 0xDCF2, 0xDD12, 0xD4F1, 0xD48F, 0xC46E, 0xBD10, 0xF79D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xEF5D, 0x632C, 0x4A05, 0x942A, 0x9BED, 
        0x7B2A, 0x72E7, 0x7B05, 0x62A4, 0x62E5, 0x5AC5, 0x4A42, 0x6B07, 0x7347, 0x6B06, 0x5263, 0x4162, 0x4983, 0x5A05, 0x5245, 0x1901, 0x62C7, 0x62A7, 0x1861, 0x50A2, 0xBC72, 0xED98, 0xDBD2, 0xB30D, 0x930A, 0xACAF, 0xE716, 0x8BEB, 0x8B4B, 0xAB6D, 
        0xD3EF, 0xED92, 0xDD51, 0xDD92, 0xEE35, 0xA4D1, 0xCD74, 0xA40E, 0x28E2, 0x4A84, 0x52C3, 0x6325, 0x7BA7, 0x1901, 0x20C2, 0x20C2, 0x10A1, 0x62C6, 0x9C6A, 0xB4CB, 0xBC4C, 0xF67B, 0xFF3E, 0xFF7E, 0xFF7E, 0xFFBE, 0xF79E, 0xF71B, 0xFEB9, 0xFFBB, 
        0xFF7A, 0xEE78, 0xDD55, 0xFE55, 0xFEB9, 0xFEBA, 0xF676, 0xFE98, 0xF616, 0xF5B5, 0xFD55, 0xF515, 0xF555, 0xED54, 0xE514, 0xC471, 0xC492, 0xD554, 0xE656, 0xFF3A, 0xFF3B, 0xFF3C, 0xFF3C, 0xF6F7, 0xEED7, 0xE697, 0xDE56, 0xEE57, 0xCDD1, 0x9CAB, 
        0x7B07, 0x61E2, 0x5A03, 0x62E6, 0x7C0A, 0x940B, 0x9C4C, 0x9C8C, 0x948C, 0x6B69, 0x5285, 0x840C, 0xEEDB, 0xC2ED, 0x9A8A, 0x8AA9, 0x8AA8, 0x7AA8, 0xA42D, 0xCD93, 0xE677, 0xF6F6, 0xFF16, 0xFF37, 0xEED5, 0x9BAB, 0xC52F, 0xEED7, 0xFFBD, 0xF653, 
        0xF612, 0xF633, 0xEE73, 0xDD95, 0xDD95, 0xDDB4, 0xE613, 0xEE54, 0xEDF4, 0xEDF5, 0xF698, 0xFEF9, 0xFEDC, 0xFF1E, 0xFF7F, 0xE4FF, 0xD43C, 0xC43B, 0xBC5D,
  0x7A12, 0x7A32, 0x7A52, 0x7A53, 0x7A32, 0x7A53, 0x7A53, 0x7233, 0x7A53, 0x8253, 0x8253, 0x8252, 0x8253, 0x8252, 0x8252, 0x8253, 0x8A53, 0x8A53, 0x8253, 0x8254, 0x8A73, 0x8A73, 0x8A73, 0x8A73, 0x8253, 0x8A53, 0x8A73, 0x8A93, 0x9292, 0x7A93, 0x6A71, 
        0x6A2D, 0x8AB2, 0x9B13, 0xABB5, 0xC477, 0xD4B6, 0xDCD6, 0xDCF7, 0xDCF6, 0xF473, 0xEC74, 0xEC14, 0xE371, 0xB38C, 0xABAD, 0xAB8D, 0xBB6D, 0xC40E, 0xC3EE, 0xC40E, 0xBC4E, 0xC40D, 0xC3ED, 0xBC0D, 0xBC8E, 0xD4B3, 0xDD34, 0xED54, 0xFD15, 0xF555, 
        0xF536, 0xFD15, 0xF4F3, 0xDBF2, 0xCBB0, 0xCB8E, 0xCBAD, 0xC38E, 0xD42F, 0xD46E, 0xCC4D, 0xCD53, 0xDD53, 0xDD72, 0xDD92, 0xDDB4, 0xD5B3, 0xC54F, 0xB4EC, 0xC56F, 0xB52C, 0xAD0C, 0xB551, 0xE656, 0xF73A, 0xCE37, 0x8BCD, 0x73A7, 0x4A23, 0x6B48, 
        0xD6D4, 0xFF35, 0xF714, 0xA52D, 0x29C2, 0x2941, 0x6B29, 0xB573, 0xF79E, 0xF77E, 0xF7BF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFBF, 
        0xFFDF, 0xFFFF, 0xFFDF, 0xD6BA, 0x5B2B, 0x4AE7, 0xA56E, 0x73C9, 0xBDF5, 0xCDD4, 0x9347, 0xC44A, 0xB38A, 0xA349, 0xABCA, 0xDD8F, 0xD5D2, 0xA46D, 0x41E2, 0x2120, 0x4A23, 0x9BEA, 0xF654, 0xF75C, 0xA430, 0x5A46, 0x3242, 0x62A5, 0x7368, 0x63A9, 
        0x4B48, 0x7B48, 0xB44B, 0xC4AF, 0xC492, 0xD4D0, 0xD511, 0xDD12, 0xDD11, 0xDD32, 0xDD52, 0xDD11, 0xD4D0, 0xE553, 0xC48E, 0xCC2D, 0xF4F2, 0xFF9D, 0xFFBF, 0xFFBF, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFFF, 0xE71C, 0x2944, 0x5B07, 0x6347, 0x3141, 0x5A64, 
        0x7327, 0x7B49, 0x72E8, 0x62A5, 0x6AA5, 0x62A5, 0x52A5, 0x6264, 0x5A84, 0x4A64, 0x4222, 0x5263, 0x3161, 0x20E1, 0x2922, 0x39E3, 0x4225, 0x2983, 0x2104, 0xD69A, 0xA430, 0xA38F, 0xDD37, 0x7926, 0xBBB0, 0xEE14, 0xCE6E, 0x6A64, 0x79E5, 0xAB4B, 
        0xDDD4, 0xF6B9, 0xE593, 0xB44D, 0x8BAB, 0xDEDA, 0x6B4C, 0x3143, 0x41E3, 0x4281, 0x42A2, 0x4AC4, 0x52C5, 0x51E4, 0x41C4, 0x2943, 0x1040, 0x2122, 0x9C4A, 0xC5AD, 0xAD4C, 0xEDF5, 0xEE36, 0xEEB7, 0xFF5A, 0xFF9B, 0xFF5A, 0xF73B, 0xF75C, 0xF739, 
        0xD635, 0xCD72, 0xDD73, 0xEEBA, 0xF6F8, 0xFED7, 0xFEB8, 0xEEB8, 0xF697, 0xF656, 0xEE15, 0xE5D3, 0xE5B5, 0xE5B5, 0xDD94, 0xCC50, 0xBC30, 0xCCD2, 0xF617, 0xFF5A, 0xF71A, 0xF6F9, 0xF6FA, 0xF6B9, 0xE696, 0xD634, 0xCDD4, 0xD677, 0xA48F, 0x9C0A, 
        0xB487, 0x59A2, 0x51C3, 0x6265, 0x7B68, 0x9C8B, 0x8C8B, 0x8C2B, 0x8BAA, 0x5B27, 0x6BA9, 0x62E7, 0x49E4, 0xDEB9, 0xA36C, 0x6102, 0x40E1, 0x49C1, 0x3120, 0x30E0, 0x5182, 0xB550, 0xE696, 0xFF5A, 0xFFFE, 0xF79C, 0xBD10, 0xB42C, 0xE591, 0xFF9B, 
        0xF75B, 0xF719, 0xFED7, 0xF674, 0xEE35, 0xE636, 0xE674, 0xDDD3, 0xDDF2, 0xDDD3, 0xD595, 0xF674, 0xF6B6, 0xEE34, 0xE531, 0xFEFA, 0xFF9D, 0xFF5B, 0xFE96,
  0x7A52, 0x8252, 0x8252, 0x7A72, 0x8273, 0x7A53, 0x7A53, 0x8273, 0x8A53, 0x8253, 0x8273, 0x8273, 0x8253, 0x8273, 0x8A73, 0x8273, 0x8A73, 0x8A73, 0x8A73, 0x8A73, 0x8273, 0x8273, 0x8293, 0x8A93, 0x8A93, 0x8A73, 0x8A73, 0x9274, 0x7274, 0x7AB2, 0x7AB2, 
        0x7272, 0x7A8E, 0x8B11, 0x9B92, 0xBBF1, 0xDC94, 0xEC73, 0xF494, 0xF4F5, 0xDCB4, 0xDCB3, 0xD492, 0xC44F, 0xB371, 0xB38F, 0xB3AE, 0xB3CF, 0xBC10, 0xC410, 0xC3EF, 0xBBCE, 0xC3AD, 0xBC0F, 0xBC30, 0xD411, 0xDC51, 0xE493, 0xECB4, 0xF4D3, 0xFCF4, 
        0xFD56, 0xFD36, 0xFCD5, 0xF4B3, 0xEC72, 0xEC52, 0xEC33, 0xCBEF, 0xD3EF, 0xDBEF, 0xDC31, 0xD4B0, 0xDD52, 0xE594, 0xDD93, 0xD5B2, 0xD590, 0xC54F, 0xB4EF, 0xC52E, 0xAC8C, 0xACAD, 0xD591, 0xEF37, 0x8C2C, 0x5245, 0x4A64, 0x6BA6, 0x6264, 0x8BAC, 
        0xEF5B, 0xF673, 0xCD2E, 0x93A9, 0x4A64, 0x3A42, 0x7C0C, 0xC616, 0xF7BE, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF7DE, 0xD658, 0xB46F, 0xF77D, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xF7BE, 0xBDD8, 0x5ACA, 0x4A86, 0x8CAC, 0x8C4E, 0xCE37, 0xC595, 0x82A7, 0xB3E9, 0xBBEC, 0xB3EC, 0xABEB, 0xAC0B, 0xDE14, 0xF79A, 0xE759, 0x6A66, 0x28C2, 0x1860, 0x41A3, 0xE73B, 0xF75A, 0xA4CF, 0x2922, 0x5AE5, 0x6B87, 0x6BA8, 
        0x6BA8, 0x83EB, 0xB46D, 0xD4AF, 0xD4F0, 0xED53, 0xE553, 0xDD53, 0xD553, 0xE532, 0xE532, 0xE532, 0xD552, 0xDCD0, 0xDCF1, 0xD44E, 0xBB8B, 0xF75C, 0xFFDF, 0xFFBF, 0xFFDF, 0xFFFF, 0xEF5C, 0xBD12, 0x71E4, 0x72EA, 0x6A86, 0x6264, 0x6AC5, 0x8389, 
        0x7B48, 0x8308, 0x8B28, 0x6265, 0x6AA5, 0x6AA5, 0x6285, 0x5AA5, 0x5AC6, 0x5AC5, 0x5262, 0x4A64, 0x5A86, 0x4205, 0x10E1, 0x39A3, 0x2922, 0x49E5, 0x9C0C, 0xF6BB, 0xF5D9, 0xF557, 0xED16, 0x8146, 0x92C7, 0xC54E, 0xEF15, 0xB3EB, 0xAC8E, 0x7B6B, 
        0x3903, 0xAD12, 0xDEF9, 0xDE77, 0xBCAF, 0xE676, 0x62CA, 0x3143, 0x62A6, 0x5AA5, 0x52C5, 0x3A23, 0x1921, 0x4184, 0x3984, 0x39C5, 0x4226, 0x1081, 0x4A23, 0x9407, 0xCD6C, 0xCD11, 0xDD53, 0xE5D3, 0xEE33, 0xFF19, 0xFF3C, 0xFF3B, 0xFF18, 0xFF79, 
        0xFF7B, 0xFF5B, 0xFF5A, 0xFF5C, 0xFF1A, 0xF6D8, 0xF697, 0xFF18, 0xFF18, 0xFEF7, 0xF6B6, 0xEE16, 0xE594, 0xED94, 0xFDF7, 0xFEB7, 0xD553, 0xB470, 0xAC90, 0xF697, 0xFEF9, 0xFF3B, 0xFF3B, 0xE696, 0xE696, 0xDE76, 0xDDF6, 0xD5D3, 0xC570, 0xBD4D, 
        0xB54A, 0xDD70, 0x8347, 0x5242, 0x5AC5, 0xACEC, 0xACCC, 0x946C, 0x7BEB, 0x7B88, 0xA4CD, 0x7BAA, 0x2924, 0xCDD4, 0xDD74, 0x9B4D, 0x40E4, 0xBC71, 0xDD52, 0x93CB, 0x1081, 0x0860, 0x3984, 0x5289, 0x6B6F, 0xD657, 0xEF5C, 0xE6DA, 0xC594, 0xF797, 
        0xFFDA, 0xFF9A, 0xFEF8, 0xFE76, 0xF655, 0xF615, 0xEDF6, 0xE614, 0xE5F3, 0xE594, 0xDD75, 0xE5F4, 0xEDF4, 0xEE14, 0xEE56, 0xE574, 0xDCF2, 0xE594, 0xFF5A,
  0x8253, 0x8A73, 0x8A73, 0x8A93, 0x8A93, 0x7A72, 0x7A72, 0x8273, 0x8A53, 0x8A73, 0x8A73, 0x8A74, 0x8A94, 0x8A74, 0x8A73, 0x8A73, 0x8A73, 0x8A53, 0x8A53, 0x8A52, 0x8274, 0x8A74, 0x8A74, 0x8A94, 0x8A93, 0x8A93, 0x8A93, 0x8A72, 0x8292, 0x7A93, 0x7A93, 
        0x7A92, 0x7A4F, 0x82B3, 0x9334, 0xABD3, 0xCC56, 0xEC96, 0xFCB5, 0xFCD3, 0xFCB6, 0xFCB8, 0xFC97, 0xF433, 0xB450, 0xAC10, 0xB411, 0xC431, 0xCC93, 0xCC92, 0xCC90, 0xCC4F, 0xC40F, 0xCC2F, 0xCC70, 0xD4F2, 0xDCB2, 0xECB3, 0xFCD4, 0xFD15, 0xF555, 
        0xFD76, 0xFD97, 0xFD97, 0xF473, 0xF472, 0xEC92, 0xECB1, 0xEC72, 0xEC72, 0xEC71, 0xEC6F, 0xE534, 0xD532, 0xD530, 0xD571, 0xE593, 0xD591, 0xC590, 0xB570, 0xAC8B, 0xB4CC, 0xC56F, 0xCDF2, 0x8B6B, 0x8389, 0x73C9, 0x6BAA, 0x8C69, 0x5AA4, 0x6AE8, 
        0xD593, 0xF758, 0xCD71, 0x93A9, 0x52C2, 0x4262, 0x7369, 0xB573, 0xF7BE, 0xF7BE, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF7BE, 0xA514, 0x3186, 0xE71C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xF7BE, 0xBD92, 0x6B67, 0x5B45, 0x950C, 0xBD73, 0xE6FA, 0xFFDF, 0xE71C, 0x5145, 0x92E9, 0xBC4D, 0xAC2C, 0xCC8E, 0xD4D0, 0xE572, 0xFE97, 0xFFBA, 0xF758, 0xA4CF, 0x1882, 0x28A2, 0xA4B2, 0x9CD2, 0x2103, 0x5AC7, 0x6B89, 0x6BA9, 
        0x6B68, 0x8C0C, 0xC48F, 0xE4F1, 0xED32, 0xDD31, 0xE551, 0xED72, 0xED72, 0xE532, 0xE532, 0xDD32, 0xDD12, 0xDD34, 0xDD52, 0xCC8D, 0xBB68, 0xF75C, 0xFFFF, 0xFFFF, 0xFFFF, 0xEF5D, 0x630C, 0x3986, 0x832B, 0xA40C, 0xA3EB, 0x93CB, 0x83EA, 0x7349, 
        0x8369, 0x836A, 0x7B69, 0x7AC4, 0x7AC5, 0x72A5, 0x6A83, 0x62C5, 0x62A5, 0x6305, 0x6386, 0x2922, 0x4AA7, 0x5B08, 0x4A25, 0x5A66, 0x2944, 0x630C, 0xDE99, 0xA246, 0xD4D2, 0xFE7B, 0xED99, 0x91CA, 0x9A09, 0xC42D, 0xEED3, 0xA3E9, 0xD531, 0xEE35, 
        0xCDD1, 0x93AB, 0x940C, 0xBD93, 0xDEDA, 0x18E3, 0x0820, 0x3183, 0x7388, 0x83A7, 0x4A64, 0x1921, 0x1041, 0x2924, 0x3185, 0x31C5, 0x31C5, 0x18A1, 0x1061, 0x39E4, 0x9C8A, 0xBD0E, 0xDD70, 0xE591, 0xE592, 0xFED6, 0xFF17, 0xFF39, 0xF75B, 0xFF16, 
        0xFF38, 0xFF5A, 0xFF7D, 0xFFBA, 0xFF9A, 0xFF7A, 0xFF5A, 0xFF3A, 0xFF58, 0xFF37, 0xF6D7, 0xFEB6, 0xF614, 0xEDD3, 0xEE15, 0xFE99, 0xFE77, 0xEDF5, 0xE534, 0xCD33, 0xE657, 0xFEF8, 0xFF17, 0xE6B8, 0xE676, 0xD634, 0xC5F3, 0xBD52, 0xD5B3, 0xDE11, 
        0xD5EE, 0xEDF0, 0xC4EE, 0x8B89, 0x5AA3, 0x9CED, 0x9CAD, 0x944C, 0x840B, 0x5AE7, 0x5AE5, 0x6B27, 0x730B, 0x50E4, 0xB431, 0xF618, 0xED54, 0xA30B, 0xD5D6, 0xFFBE, 0xE73C, 0x51A4, 0x49E4, 0x4224, 0x3161, 0x2060, 0x41A4, 0x942D, 0xEEF6, 0xD572, 
        0xEEDA, 0xFFDF, 0xFFFF, 0xFFFC, 0xFFFE, 0xFFDE, 0xFF9E, 0xFEDC, 0xFEBA, 0xFE98, 0xFE37, 0xFE98, 0xFEB5, 0xFED7, 0xFEFD, 0xFF7F, 0xFFBF, 0xF69B, 0xECB5,
  0x7A52, 0x7A52, 0x7A52, 0x7A33, 0x7233, 0x8A54, 0x9254, 0x8233, 0x8252, 0x8252, 0x8232, 0x7A32, 0x8272, 0x8252, 0x8253, 0x8233, 0x8A73, 0x8A73, 0x8A74, 0x8A74, 0x8A73, 0x8293, 0x8273, 0x8A53, 0x8292, 0x8A73, 0x8A74, 0x9274, 0x7A52, 0x7290, 0x728E, 
        0x6A6D, 0x620B, 0x828A, 0x932B, 0xA3AE, 0xED14, 0xF4F3, 0xF4B3, 0xEC94, 0xBC50, 0xBBCD, 0xAB8B, 0x8B6B, 0x8A68, 0x8AA8, 0x8B09, 0x938B, 0xB3ED, 0xB38C, 0xBB8C, 0xD42E, 0xDC6F, 0xDC91, 0xD491, 0xD491, 0xF4B4, 0xF4B3, 0xF4D4, 0xF515, 0xFD36, 
        0xF536, 0xF536, 0xF516, 0xFD35, 0xF515, 0xFD15, 0xFD15, 0xF4F5, 0xF4B4, 0xECB3, 0xD4B2, 0xD551, 0xDD72, 0xD574, 0xC575, 0xACEB, 0xA48B, 0x9C2A, 0x9B89, 0x7AC6, 0x9388, 0xB4AC, 0xCD8F, 0x9449, 0x7B48, 0x83CA, 0xA54D, 0x5C28, 0x748A, 0x6368, 
        0x2121, 0x3961, 0x49A3, 0x5A67, 0x63CC, 0x6BE5, 0x31E3, 0x5AEA, 0xDEFA, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xE71C, 0x3186, 0xA514, 0xF7BE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 
        0xFFDE, 0xFFDE, 0xF79D, 0x9451, 0x5B07, 0x5B45, 0x94CC, 0xB613, 0xE75A, 0xFFFF, 0xF79D, 0xCC4B, 0x8AA7, 0x8AE8, 0xC46C, 0xBC4C, 0xCC8D, 0xDD10, 0xEDD4, 0xFF1B, 0xFED7, 0xFEF8, 0xF75C, 0xB42C, 0xD5F5, 0xB554, 0x49E5, 0x4A81, 0x6B87, 0x6389, 
        0x4B07, 0xA48B, 0xCD10, 0xDD53, 0xE573, 0xDD72, 0xE573, 0xE573, 0xDD53, 0xDD93, 0xE572, 0xE573, 0xED93, 0xC4EF, 0xDD52, 0xC42D, 0x8A85, 0xEF3C, 0xFFFF, 0xFFFF, 0xE71C, 0x3145, 0x93AB, 0xCCCF, 0xAB8C, 0x8309, 0x9368, 0x9B48, 0x92E8, 0x9368, 
        0x9329, 0x9308, 0x92E8, 0x6AC8, 0x72A6, 0x72A6, 0x72E8, 0x7B68, 0x7389, 0x6306, 0x4241, 0x11C0, 0x29C2, 0x6309, 0x8C6F, 0x2924, 0x9CF3, 0xDE98, 0xC573, 0xF69A, 0xFDFB, 0xF518, 0xD391, 0x7103, 0xBC0C, 0xDD8E, 0xBCC8, 0xED30, 0xF6D9, 0xE73B, 
        0xBD93, 0x69A5, 0xBD13, 0xC615, 0x7368, 0x1081, 0x2103, 0x4A25, 0x7B66, 0x736A, 0x3185, 0x18E1, 0x31A3, 0x28E3, 0x3123, 0x3143, 0x2923, 0x4A04, 0x2902, 0x5A66, 0xD5AD, 0xBD0B, 0xC56D, 0xD5CF, 0xDE11, 0xFED7, 0xF739, 0xF79A, 0xF799, 0xD615, 
        0xEED7, 0xF799, 0xFF9A, 0xFF9B, 0xFF7A, 0xFF59, 0xF737, 0xF6D8, 0xF6F7, 0xF717, 0xFEF7, 0xE655, 0xE656, 0xE656, 0xE5F5, 0xDDF4, 0xEE36, 0xE615, 0xD5B3, 0xDE35, 0xEE57, 0xEE98, 0xEED9, 0xDE55, 0xCE34, 0xBD92, 0xB4EF, 0xC572, 0xDE54, 0xEE91, 
        0xEE4D, 0xD58D, 0xACE8, 0x8407, 0x7308, 0x944A, 0x9CAB, 0x8C2A, 0x6B07, 0x5305, 0x6B48, 0x8389, 0x8B68, 0x4943, 0x40A1, 0x50C1, 0x81C5, 0xECB2, 0xE573, 0xE657, 0xE71B, 0x4A26, 0x18A1, 0x2922, 0x62A5, 0x41A3, 0x2081, 0x0800, 0x1040, 0x6A04, 
        0x7AC6, 0x942C, 0xC636, 0xEF7B, 0xF77B, 0xF79B, 0xFFBB, 0xFF59, 0xFF79, 0xFF7A, 0xFF5B, 0xFED9, 0xEE97, 0xE696, 0xE695, 0xCD51, 0xC4AF, 0xB44E, 0x8BEE,
  0x7A53, 0x8252, 0x8252, 0x8253, 0x8273, 0x7A54, 0x8254, 0x9274, 0x8A75, 0x8254, 0x8274, 0x8275, 0x8253, 0x8274, 0x8274, 0x8253, 0x8A53, 0x8A73, 0x8A73, 0x8A73, 0x8A52, 0x8A93, 0x8A94, 0x8A74, 0x8A73, 0x8A74, 0x8A75, 0x8295, 0x7A51, 0x7AB1, 0x7AB0, 
        0x7AAF, 0x726E, 0x828D, 0x8ACE, 0x9B4F, 0xCC50, 0xEC53, 0xF434, 0xF3F2, 0xDB90, 0xD370, 0xCB4F, 0xAB2D, 0x8389, 0x7B49, 0x7B09, 0x8B29, 0x9BAC, 0xA3AC, 0xB3AD, 0xC3CF, 0xDC6E, 0xDC70, 0xE472, 0xEC53, 0xE491, 0xE492, 0xEC73, 0xF473, 0xF513, 
        0xF555, 0xF556, 0xF556, 0xFD35, 0xFD55, 0xFD56, 0xFD36, 0xF4B3, 0xEC92, 0xE493, 0xDCB3, 0xDD32, 0xDD53, 0xDD73, 0xDD71, 0xACCE, 0x9C4B, 0xA46C, 0xB4CE, 0x7B45, 0xACCC, 0xCDB0, 0xC50F, 0x7369, 0x8C2B, 0x94AD, 0x6C2C, 0x42C2, 0x63C7, 0x7449, 
        0x6BC7, 0x6268, 0x7AAC, 0x7AEB, 0x6306, 0x52E3, 0x2962, 0x41C5, 0x9C8F, 0xF79D, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDD, 0xCE4E, 0x83C6, 0x8C4C, 0xEF9D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 
        0xFFDE, 0xFFFF, 0xF7BE, 0xC574, 0x6368, 0x6386, 0xA56E, 0xA4EF, 0xDEB9, 0xFFDE, 0xFFDE, 0xF77D, 0xA3AC, 0x8A86, 0xB40C, 0xB3EB, 0xDCF1, 0xF553, 0xED12, 0xFE15, 0xFE97, 0xFE97, 0xFE76, 0xFF9B, 0xFF3B, 0xFF19, 0xE653, 0x2923, 0x5B07, 0x744A, 
        0x63E9, 0x940B, 0xD4F1, 0xF574, 0xED93, 0xED73, 0xED73, 0xE572, 0xE552, 0xED54, 0xED53, 0xED73, 0xE572, 0xDD32, 0xE592, 0xD52F, 0xBC0A, 0xD4F6, 0xE6BC, 0xCE39, 0x8BD0, 0x8B49, 0xA3AA, 0xA3AB, 0x8B0A, 0x92E8, 0x9308, 0x9308, 0x8B28, 0x8329, 
        0x8B28, 0x8B08, 0x8309, 0x92C6, 0x7AA5, 0x72A5, 0x8307, 0x7B69, 0x7BA9, 0x6326, 0x3201, 0x1980, 0x29E3, 0x31C4, 0x3182, 0x7BCB, 0xCE57, 0xF75D, 0xEEFB, 0xFF1A, 0xF639, 0xF558, 0xF455, 0xAA0A, 0xAB2A, 0xBC6B, 0xC56C, 0xDD4F, 0xED52, 0xFE36, 
        0xFFBC, 0xF7BD, 0xC555, 0xC555, 0xE73C, 0x7C74, 0x31C8, 0x39C4, 0x7BC8, 0x5A65, 0x2902, 0x20C2, 0x41C4, 0x31A4, 0x2984, 0x3184, 0x4184, 0x28E2, 0x1882, 0x5A88, 0xDDF3, 0xB50B, 0xBD0B, 0xD5AF, 0xEEB3, 0xF6B6, 0xFF18, 0xFF9B, 0xFFBD, 0xE634, 
        0xDDF1, 0xE695, 0xFFBD, 0xFF59, 0xFF79, 0xFFBB, 0xFFDB, 0xFF39, 0xF716, 0xF6F5, 0xEED6, 0xF716, 0xF6D6, 0xF6B6, 0xEE97, 0xE5D5, 0xE5D4, 0xEE75, 0xF738, 0xDE35, 0xD593, 0xDDB4, 0xE656, 0xE6B6, 0xDE55, 0xC592, 0xACAE, 0xC571, 0xE675, 0xEED4, 
        0xDE70, 0xE5CD, 0xDDCC, 0xB4E9, 0x7344, 0x840A, 0x948C, 0x8C6B, 0x6368, 0x2181, 0x39C2, 0x7B28, 0xCCD0, 0x7246, 0x59A4, 0x7226, 0xAB4B, 0xBBD0, 0xE596, 0xFF1B, 0xFFDE, 0xF77C, 0x942E, 0x41A5, 0x1081, 0x62A6, 0x6B08, 0x6AE7, 0x6A85, 0x28E1, 
        0x2923, 0x2103, 0x0840, 0x30E0, 0x5182, 0x59E5, 0x51E9, 0x5249, 0x6AEA, 0x734C, 0x736D, 0x72CA, 0x5247, 0x41C5, 0x3143, 0x0820, 0x0020, 0x2944, 0x6349,
  0x7A72, 0x8273, 0x8272, 0x8292, 0x8252, 0x7A72, 0x7251, 0x7231, 0x822D, 0x926F, 0x9270, 0x926F, 0x9251, 0x8A0F, 0x8A10, 0x8273, 0x7A94, 0x8294, 0x8254, 0x7A53, 0x92D6, 0x9294, 0x8253, 0x8232, 0x82B4, 0x8271, 0x7A4E, 0x824F, 0x8271, 0x7ACC, 0x7B0B, 
        0x8AEE, 0x92CD, 0x8ACD, 0x82EB, 0x9B8A, 0xD4F0, 0xD511, 0xCCF1, 0xC4D1, 0xA4B1, 0xA48E, 0x9C4C, 0x83EB, 0x8269, 0x72A7, 0x6AC6, 0x62A6, 0x7AA9, 0x8AC9, 0x9B09, 0xA32A, 0xCBF0, 0xDC11, 0xEC51, 0xF492, 0xECD2, 0xEC92, 0xECB2, 0xED12, 0xFCF6, 
        0xFD16, 0xFD35, 0xFD36, 0xFDB6, 0xFD97, 0xFD78, 0xFD77, 0xFD35, 0xFCF4, 0xECB2, 0xDC70, 0xDD53, 0xDDB3, 0xDDD3, 0xE5B3, 0xB591, 0xACCE, 0x8329, 0x51C3, 0xD5B2, 0xCD51, 0xAC6D, 0x942C, 0xBCEE, 0x946B, 0x73C8, 0x7BC8, 0xB52E, 0x7BE8, 0x6304, 
        0x6B06, 0x6B45, 0x6305, 0x6304, 0x7346, 0x93AD, 0x942C, 0x62E8, 0x2923, 0xD60F, 0xF799, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF7BD, 0xBDAF, 0x6B05, 0x2944, 0xE71C, 0xFFDF, 0xFFDE, 0xFFDE, 0xFFDF, 
        0xFFDF, 0xFFFF, 0xFFDF, 0xD6B9, 0x73CB, 0x6BA9, 0xB5D2, 0x7B8C, 0xC5B6, 0xF77D, 0xFFFF, 0xF7BE, 0xC594, 0xA3ED, 0xA32A, 0xBC2D, 0xDCD0, 0xEDB4, 0xFED8, 0xFED6, 0xFE96, 0xFE97, 0xFED8, 0xF635, 0xFDF4, 0xFE98, 0xE6FB, 0x2945, 0x5AC9, 0x7BEB, 
        0x7389, 0xDD73, 0xF5D4, 0xF5D4, 0xF5D4, 0xF593, 0xF594, 0xF594, 0xF574, 0xED73, 0xF593, 0xED53, 0xDD11, 0xDD31, 0xDD31, 0xD4F1, 0xCCD2, 0xF617, 0xFF3C, 0xEEB9, 0xC4D0, 0x9B8B, 0x9B8A, 0x9B6A, 0x9B4B, 0x9B8A, 0x9369, 0x9349, 0x8B28, 0x9309, 
        0x9329, 0x9349, 0x9329, 0x7AE9, 0x92E8, 0x8A86, 0x6A05, 0x84AE, 0x846C, 0x5AC7, 0x10E1, 0x21A2, 0x4A84, 0x5283, 0x4A22, 0x8BAB, 0xD5F7, 0xFF3D, 0xFF7F, 0xFF5E, 0xFE9B, 0xF5D7, 0xE513, 0xF311, 0xEA6F, 0xD3CD, 0xB64B, 0xB649, 0xCDAE, 0xE5B1, 
        0xF654, 0xDEBC, 0xEF7D, 0xFFDD, 0xFFBF, 0xEF5D, 0x632C, 0x5265, 0x9CCA, 0x18C2, 0x2104, 0x2905, 0x1843, 0x3141, 0x51E2, 0x4162, 0x0820, 0x1061, 0x732A, 0xBD31, 0xD5F3, 0xA4AD, 0xA4CB, 0xC54C, 0xEDAE, 0xF712, 0xFF16, 0xFF5A, 0xFFDD, 0xF734, 
        0xF794, 0xFF74, 0xFED2, 0xFFDD, 0xFFBB, 0xFF5A, 0xF71A, 0xFFDD, 0xFFDA, 0xFF78, 0xFF18, 0xF6F8, 0xF717, 0xF717, 0xF6D7, 0xF676, 0xF676, 0xEE35, 0xE5B3, 0xF6F6, 0xEE96, 0xE656, 0xEE55, 0xDE54, 0xE655, 0xD5D3, 0xB50F, 0xB551, 0xDE13, 0xF692, 
        0xF691, 0xF631, 0xEE91, 0xBDAC, 0x7BE6, 0x9CCD, 0x8C2C, 0x7BCA, 0x73A7, 0x39E3, 0x4222, 0x5262, 0x6A65, 0xDB6E, 0xAB8D, 0x7268, 0x60A2, 0xB2E9, 0xDC91, 0xBC50, 0x730A, 0xEF5C, 0xF7DF, 0xEF1B, 0xDD54, 0x20C2, 0x2940, 0x3180, 0x2120, 0x41E1, 
        0x3960, 0x3140, 0x41A1, 0x72E8, 0x6AC8, 0x838A, 0xA4AE, 0x93A8, 0x6265, 0x5205, 0x5A66, 0x6B07, 0x7329, 0x7B4A, 0x8B6A, 0xA4CD, 0xB4ED, 0xCDF0, 0xF7B7,
  0x7232, 0x7251, 0x7252, 0x7232, 0x6A11, 0x8A72, 0xA2B4, 0xAB16, 0xBBB9, 0xB3B9, 0xB3B8, 0xABB7, 0x9B55, 0x9B15, 0x8AB4, 0x8251, 0x8A52, 0x8A72, 0x8A73, 0x9273, 0x8A93, 0x8AB3, 0x8AB4, 0x8AD5, 0xA291, 0xA333, 0xA374, 0xA334, 0xA36F, 0x9311, 0x8AD0, 
        0x82CD, 0x62AD, 0x7AAE, 0x92CF, 0x92EF, 0xA34B, 0xAB4B, 0xAB0B, 0xAAE9, 0x9A47, 0x7A07, 0x61E6, 0x59E5, 0x5B45, 0x6B46, 0x7327, 0x8B48, 0xA3AA, 0xAB8A, 0xAB8A, 0xBBAB, 0xCC0C, 0xDC2E, 0xE42F, 0xE431, 0xE3D0, 0xD38E, 0xCB8F, 0xD3D3, 0xDC72, 
        0xE4B3, 0xECF3, 0xF534, 0xED38, 0xF557, 0xFD76, 0xFD56, 0xE494, 0xD3F1, 0xCBF0, 0xCC71, 0xDD32, 0xD533, 0xCD31, 0xC4EE, 0x8BC8, 0x8347, 0x8388, 0x9C49, 0xCD71, 0xDED4, 0xD692, 0xACAB, 0x42A3, 0x5284, 0x6AE6, 0x6B67, 0x6346, 0x5AC4, 0x5AA3, 
        0x5B05, 0x52E6, 0x6308, 0x62C8, 0x4A66, 0x31E1, 0x39E2, 0x31A2, 0x10E0, 0x0861, 0x4227, 0x94D2, 0xF79D, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF7BE, 0xBDD4, 0x9469, 0x9444, 0xEF7C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFF9C, 
        0xFFBE, 0xFFDF, 0xFFDF, 0xDE7A, 0x6B6B, 0x6BA9, 0xCE72, 0x7388, 0xBDF5, 0xF7DE, 0xFFFF, 0xFFFF, 0xF7BD, 0xBD32, 0x6964, 0xC44C, 0xD4AF, 0xE573, 0xFEF8, 0xFE98, 0xFEB8, 0xFEB8, 0xF6B7, 0xF6F7, 0xF5D4, 0xFE37, 0xEEDB, 0x6124, 0x5204, 0x5AE5, 
        0x7367, 0xEE97, 0xF636, 0xF5D4, 0xF5F4, 0xE5D4, 0xE5D4, 0xEDB4, 0xE5B3, 0xE5F4, 0xF5B3, 0xF5B3, 0xE5D4, 0xE593, 0xE532, 0xCCB0, 0xA40E, 0xBCD2, 0xE699, 0xE6D9, 0xC510, 0x9A85, 0x9B29, 0x9BCA, 0xA3C8, 0x7AC9, 0x8AEA, 0x9B0A, 0x9B09, 0x8B08, 
        0x8AE9, 0x82C8, 0x7AA7, 0x9389, 0x92A8, 0x8267, 0x7B09, 0xC50E, 0x52C6, 0x1921, 0x20E0, 0x19C3, 0x4B49, 0x52E8, 0x41A4, 0xE6B6, 0xFF9C, 0xFF9F, 0xFFBE, 0xEFBC, 0xEF3B, 0xEDDA, 0xE3B6, 0xCA8B, 0xD3AD, 0xCCCD, 0xBD4B, 0xCD30, 0xE5F6, 0xDDD6, 
        0xBD53, 0xF77A, 0xFF7D, 0xFF7F, 0xE71C, 0x2124, 0x4A05, 0x7B87, 0x8427, 0x1081, 0x0020, 0x10E2, 0x3A26, 0x61C8, 0x28A4, 0x0843, 0x2127, 0xCE32, 0xEF17, 0xD615, 0xA46F, 0xACCC, 0xBCEE, 0xBD2F, 0xB58F, 0xF671, 0xFEF2, 0xF713, 0xF6F6, 0xFFBE, 
        0xE6FB, 0xE6FB, 0xFFDE, 0xFF9A, 0xF717, 0xEEF4, 0xF734, 0xFF99, 0xF718, 0xEED6, 0xE6B4, 0xF6B7, 0xEEB8, 0xE6B7, 0xEEB6, 0xE657, 0xD614, 0xD5F3, 0xDDF5, 0xE675, 0xDE35, 0xD5F3, 0xCDB2, 0xE697, 0xDE75, 0xBD70, 0x9C2A, 0xDDD1, 0xE694, 0xEEB5, 
        0xEE32, 0xE5EE, 0xCD8C, 0xBD4B, 0xA50B, 0x7347, 0x6B47, 0x5B07, 0x3225, 0x31C2, 0x6B49, 0x93AB, 0xA2A8, 0x4A04, 0x9B09, 0xC3CC, 0x936A, 0x1861, 0x3820, 0x9145, 0xEBAF, 0xFF7D, 0xF7DE, 0xBE16, 0x6B49, 0x6A45, 0x51A4, 0x51E5, 0x6B07, 0x838A, 
        0x83AA, 0x8BEA, 0x942B, 0x7B69, 0x8BAA, 0xAC6B, 0xD58E, 0xF79C, 0xF75A, 0xE694, 0xDDAF, 0xDE12, 0xE5F1, 0xE5F0, 0xEE11, 0xF633, 0xFF3A, 0xFF5B, 0xFE75,
  0x8292, 0x8293, 0x7A72, 0x7291, 0x92D4, 0x8AD4, 0x8AF4, 0x9B54, 0xC3D2, 0xCC34, 0xC435, 0xB3D4, 0xB3B3, 0xAB51, 0xAB11, 0xAAB3, 0x9291, 0x8A72, 0x8A72, 0x8A73, 0x8AB4, 0x9294, 0x9AB2, 0xA2CF, 0x9AF4, 0xA313, 0xAB72, 0xABF3, 0xB412, 0xA3F0, 0x9BAE, 
        0x932C, 0x8AEA, 0x82CA, 0x7AA8, 0x72C5, 0x8328, 0x8349, 0x834A, 0x834A, 0x7B6A, 0x7349, 0x7308, 0x72A6, 0x7AE7, 0x8307, 0x8B08, 0x9AEA, 0xA329, 0xABAB, 0xB40D, 0xBC6E, 0xCC4F, 0xDC51, 0xE452, 0xDC51, 0xD431, 0xD3EF, 0xCBAD, 0xBB8B, 0xD4A9, 
        0xDCCC, 0xE4CF, 0xED31, 0xF553, 0xF534, 0xED35, 0xED15, 0xEC73, 0xEBF3, 0xE3D2, 0xD410, 0xDD13, 0xDD53, 0xD573, 0xCD72, 0xA46D, 0x9C2B, 0x93CA, 0x938B, 0xEF3A, 0xCDD5, 0x7B6B, 0x2922, 0x73E6, 0x84A7, 0x7405, 0x6262, 0x3140, 0x3A02, 0x4A62, 
        0x5A62, 0x6347, 0x4223, 0x39C1, 0x5A22, 0x3100, 0x2080, 0x28C2, 0x5228, 0xDEDA, 0xAC0F, 0xAC0F, 0xF77D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xDEB9, 0xAD2F, 0x9447, 0xEF5B, 0xEEDC, 0xEEBA, 0xFF9B, 0xFFFE, 
        0xFFBC, 0xFFBC, 0xFFFF, 0xEF7D, 0x83AC, 0x6B28, 0x9D8F, 0x6B49, 0xBDB5, 0xF77D, 0xFFFF, 0xFFFF, 0xF7BE, 0xBD94, 0x6A25, 0xB3EB, 0xD4CE, 0xEDB2, 0xFEB6, 0xFEB7, 0xFED8, 0xFED8, 0xFEB7, 0xFEB8, 0xF5F5, 0xF676, 0xF77C, 0xCD31, 0x5A06, 0x41A5, 
        0x9C0C, 0xF719, 0xF637, 0xF5B5, 0xFE15, 0xF5F5, 0xF5D4, 0xEDB4, 0xEDB4, 0xED93, 0xEDB4, 0xEDD4, 0xEDF5, 0xE552, 0xDCF2, 0xCCB0, 0xBC2E, 0x93AD, 0xCDF6, 0xB513, 0x5943, 0x7AA6, 0x82A8, 0x82A8, 0x7AA6, 0x82A7, 0x82A8, 0x82C8, 0x7AC7, 0x8B0A, 
        0x8B2A, 0x934A, 0x9329, 0x82E9, 0x7266, 0x8AC7, 0xB3CC, 0x742A, 0x4264, 0x2962, 0x2184, 0x4AC5, 0x6BA8, 0x6346, 0x4202, 0x944A, 0xDE77, 0xF79E, 0xFFBF, 0xFFDF, 0xF73C, 0xEDF9, 0xEC54, 0xE34C, 0xCAC8, 0x9A25, 0x69E5, 0xCD72, 0xDDD5, 0xD574, 
        0xCD71, 0xF73D, 0xFFBF, 0xE71A, 0xAD10, 0x2923, 0x944B, 0xAD2B, 0x4AC2, 0x0860, 0x1881, 0x3123, 0x4185, 0x1082, 0x62E9, 0xB594, 0xF7BD, 0xE75B, 0xBD52, 0xAC8F, 0xB4F1, 0xAD11, 0xB510, 0xC54E, 0xCD8B, 0xDE4F, 0xF6F3, 0xFF78, 0xFFFE, 0xFFFF, 
        0xFFFF, 0xFFFE, 0xFFFE, 0xF7BD, 0xEF38, 0xE672, 0xDDCE, 0xF778, 0xFFD9, 0xF778, 0xF696, 0xE696, 0xEED7, 0xF6F8, 0xF719, 0xF6B6, 0xEE75, 0xDE34, 0xDE33, 0xE635, 0xE696, 0xE675, 0xD5D3, 0xDE14, 0xDE55, 0xCDD3, 0xB510, 0xB54D, 0xDE53, 0xF6D5, 
        0xEE94, 0xE630, 0xDDEF, 0xC58E, 0xA50B, 0x7367, 0x6B47, 0x6327, 0x4A85, 0x39C2, 0x93EB, 0xB4AE, 0x938B, 0x8245, 0x81A5, 0x91E8, 0xAACB, 0xD4D2, 0x8A89, 0x50C2, 0x48E4, 0xE71B, 0xFFFE, 0xFFFE, 0xEF7D, 0x8C2D, 0x7B27, 0x72A5, 0x7286, 0xC50E, 
        0xEEF9, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFDE, 0xEE98, 0xD4EF, 0xF6D6, 0xFF9A, 0xFFDB, 0xFF9B, 0xFF58, 0xFF38, 0xF6F8, 0xF696, 0xFED8, 0xE5D4, 0xE592, 0xEE15,
  0x8293, 0x82B3, 0x8A92, 0x8272, 0x72B4, 0x82B2, 0x92D2, 0xAB35, 0xABF6, 0xBC37, 0xD477, 0xE498, 0xABF3, 0xB395, 0xBB75, 0xB352, 0x92B2, 0x92B1, 0x92B1, 0x9291, 0x92B3, 0x9AD3, 0xAAD3, 0xBAD3, 0x9351, 0xA391, 0xABB2, 0xB3D3, 0xB432, 0xB453, 0xB432, 
        0xA3CF, 0x8B4D, 0x932D, 0x930D, 0x8B0D, 0x82A5, 0x8B06, 0x9307, 0x92A9, 0x8308, 0x7B09, 0x72E8, 0x6305, 0x7AE8, 0x8B0A, 0x930A, 0x9B09, 0xAB0C, 0xC36D, 0xCB8E, 0xD390, 0xD3CF, 0xD430, 0xD451, 0xD452, 0xCBEF, 0xCBEE, 0xC40E, 0xC42D, 0xB467, 
        0xCCA9, 0xDCEB, 0xE50F, 0xFD33, 0xFD76, 0xFD56, 0xFCD6, 0xF4F5, 0xDCD1, 0xD450, 0xDBD0, 0xDCB2, 0xED33, 0xDD32, 0xB4D0, 0xACAC, 0x8BE9, 0x8388, 0x9BCA, 0xB572, 0x6B68, 0x31E1, 0x19C1, 0x8467, 0x7326, 0x5A04, 0x5224, 0xB58A, 0xBD8D, 0x9CCC, 
        0x6386, 0x20A1, 0x59A5, 0x7A87, 0x7B29, 0xDE36, 0xEED7, 0xF73A, 0xEF5C, 0x6B29, 0x69C4, 0x71E7, 0x936F, 0xEF7D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF7BE, 0xBDB4, 0x6B06, 0xE71B, 0xD659, 0xA470, 0x7B2A, 0xEF5B, 
        0xFFFE, 0xFFDE, 0xFFBD, 0xF79D, 0xAD12, 0x83EB, 0x846A, 0x7C4C, 0xB5B5, 0xE6FB, 0xFFDF, 0xFFFF, 0xFFDE, 0xEEB8, 0xCC4D, 0x6A24, 0xB42C, 0xEDD3, 0xFEB7, 0xFEF8, 0xFF18, 0xFF18, 0xFF19, 0xFEB8, 0xF6D9, 0xFE57, 0xFD93, 0xEF1B, 0x6B2C, 0x62A9, 
        0xE634, 0xFF99, 0xFE56, 0xFDD5, 0xFE36, 0xFE14, 0xF5D3, 0xF593, 0xF553, 0xFE56, 0xFE76, 0xF636, 0xDDB5, 0xD4AF, 0xCCB1, 0xC492, 0xB450, 0x930A, 0x6984, 0x48E0, 0x4941, 0x6A05, 0x6A04, 0x7224, 0x6A26, 0x7204, 0x7204, 0x69E4, 0x61E2, 0x7AC7, 
        0x8B08, 0x82E8, 0x72A7, 0x8B08, 0x8285, 0x92E8, 0xAC4E, 0x7B88, 0x4A63, 0x31C2, 0x39E4, 0x4AC6, 0x6B8A, 0x7368, 0x5281, 0x52C4, 0xBD93, 0xF73C, 0xF75F, 0xFFDF, 0xFF9E, 0xFE99, 0xF4D2, 0xD2ED, 0xDB4D, 0xAAA8, 0x5141, 0x7AC5, 0x9C2D, 0xB4D1, 
        0xBD33, 0xF717, 0xF77B, 0xBDB6, 0x5208, 0x1882, 0x7348, 0xA50C, 0x94EC, 0x4AC2, 0x31C2, 0x18E2, 0x1041, 0x8227, 0xCD95, 0xD657, 0xA46E, 0xA430, 0xB511, 0xBD51, 0xB4F1, 0xBCF1, 0xDDF4, 0xDE13, 0xACCD, 0x8AE4, 0xCDD4, 0xF7BE, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xF7BE, 0xF7DE, 0xF79C, 0xB4C9, 0xCDAD, 0xE6F4, 0xFFB8, 0xF655, 0xFEB6, 0xFF39, 0xFF7B, 0xF75B, 0xF758, 0xEEB6, 0xD5B4, 0xDDF2, 0xE654, 0xEE75, 0xEE55, 0xCDD3, 0xCDF3, 0xCDB1, 0xCD2F, 0xDDD3, 0xEED4, 0xF714, 
        0xF6B3, 0xFE92, 0xEE31, 0xCD8E, 0x9489, 0x8C2A, 0x946C, 0x73C9, 0x4262, 0x6A88, 0xB4CF, 0xC550, 0xA42D, 0x7349, 0x82C7, 0x8205, 0x6964, 0xAA87, 0xC38E, 0xA2CC, 0x6925, 0xEEFB, 0xFF39, 0xFF39, 0xFFDE, 0xF7BE, 0xD617, 0xB470, 0x9328, 0x6246, 
        0x59E3, 0x8B4A, 0xEE57, 0xFFB8, 0xFF39, 0xFF5A, 0xEF36, 0x9AE8, 0xBC4D, 0xE634, 0xFF77, 0xF653, 0xF5F2, 0xF5F3, 0xF654, 0xF5D3, 0xF636, 0xFE77, 0xFE77,
  0x8291, 0x8291, 0x8290, 0x8ACF, 0xB370, 0xBBF3, 0xBC55, 0xC4B5, 0xECF6, 0xED56, 0xE557, 0xDD37, 0xF537, 0xE514, 0xDC93, 0xD3F3, 0xA38F, 0xA331, 0xA2F1, 0x9AB0, 0xA2B1, 0xA2B2, 0x9A90, 0xAAAD, 0xCBD5, 0xC414, 0xC493, 0xCD35, 0xC4F4, 0xCCD3, 0xCCF2, 
        0xBCF0, 0x9B8D, 0x934A, 0x8307, 0x62A3, 0x3A21, 0x3A04, 0x4A45, 0x5AA5, 0x42A4, 0x4A64, 0x5A85, 0x6AA8, 0x82C7, 0x92C8, 0xA2E9, 0xB30A, 0xC34B, 0xD3CD, 0xDC4E, 0xDCD1, 0xED74, 0xED74, 0xE554, 0xCCD3, 0xD44C, 0xC3AA, 0xB369, 0xB3A9, 0xC429, 
        0xCC6C, 0xDC8D, 0xE48E, 0xE4B2, 0xE4B2, 0xDCB2, 0xDC72, 0xD370, 0xD391, 0xCBB1, 0xC3D1, 0xE473, 0xDD55, 0xDDD5, 0xEDD4, 0xDDD8, 0xD595, 0xE657, 0xE71B, 0x7284, 0x5A42, 0x8C4D, 0xE75B, 0xC60C, 0xBE2A, 0xD6F1, 0xF7DC, 0xFFFF, 0xFFDE, 0xEEF8, 
        0xCD6E, 0x9D2A, 0xA5AD, 0xBE51, 0xD651, 0x6AA3, 0x9388, 0xBCCD, 0xDD91, 0xF5F9, 0xE576, 0xB46E, 0x62C4, 0x20E3, 0xA514, 0xF7BE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xF73A, 0xE635, 0xFFBE, 0xFFBE, 0xEEBA, 0xD553, 0xE5D2, 
        0xF697, 0xFF3A, 0xFFFD, 0xF7BD, 0xB573, 0x8C2C, 0x7C09, 0x738A, 0xC637, 0xF7DE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xE71C, 0x3145, 0xA3EE, 0xF655, 0xFEF7, 0xFEF7, 0xFEFA, 0xFEFA, 0xFEF7, 0xFE57, 0xFE77, 0xF697, 0xF677, 0xF6FA, 0xE572, 0xED92, 
        0xFF3A, 0xEE14, 0xED94, 0xF5B4, 0xFE15, 0xF5F6, 0xF616, 0xFE57, 0xF676, 0xC4F2, 0x938B, 0x82E8, 0x92C8, 0x8248, 0x71E5, 0x69A3, 0x71A4, 0x6206, 0x6A46, 0x82A8, 0x8AEA, 0x6A88, 0x6A68, 0x6A26, 0x61C4, 0x69A4, 0x59A4, 0x5983, 0x5963, 0x5122, 
        0x4962, 0x6224, 0x8AE7, 0x7286, 0x6A45, 0x82A7, 0xAB4A, 0x3283, 0x3A44, 0x39E4, 0x41C4, 0x7387, 0x6B46, 0x52A3, 0x4262, 0x93E9, 0xC572, 0xE6B8, 0xFF7B, 0xFFBE, 0xEE79, 0xED76, 0xECD4, 0xCA2A, 0xDB0C, 0xA289, 0x2881, 0x49E2, 0xB572, 0xEEF9, 
        0xE615, 0xE69A, 0xEF3C, 0x9CF3, 0x18A2, 0x1841, 0x4A86, 0x94EA, 0xCE4C, 0x3186, 0x3122, 0x28E0, 0x2103, 0xDEBA, 0xB4F1, 0xA3EC, 0xCD31, 0xBD92, 0xB531, 0xB4D0, 0xC511, 0xE718, 0x8BEB, 0x5162, 0x5904, 0xEF1B, 0xFFFE, 0xFFFE, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDD, 0xEF59, 0xD654, 0xC548, 0xC5AD, 0xD611, 0xEE33, 0xF718, 0xF738, 0xF759, 0xF75A, 0xFED5, 0xDE75, 0xCE14, 0xC5F2, 0xDDB4, 0xE656, 0xE6B6, 0xDE75, 0xDDD2, 0xCDD2, 0xC5B2, 0xCD92, 0xF6D5, 0xEE95, 0xE695, 
        0xEEB5, 0xF673, 0xD5AF, 0xB4EB, 0x9C49, 0x8C8A, 0x7409, 0x52E6, 0x39E3, 0x73A8, 0xBD4F, 0xBCEF, 0x9329, 0xE551, 0x92E9, 0x9287, 0xD42D, 0x48A2, 0x6102, 0x9A46, 0xE3EE, 0xFF7C, 0xFF7B, 0xFF19, 0xFF38, 0xF799, 0xCD71, 0xBCAE, 0xD552, 0xCCF0, 
        0xABEC, 0x7A86, 0x61C4, 0xEE98, 0xFFBC, 0xFFBB, 0xFF7A, 0xF79B, 0xCD91, 0xB46C, 0xC4AE, 0xDDB1, 0xDDB2, 0xDDB2, 0xEE12, 0xEEB5, 0xEE74, 0xEE33, 0xEE52,
  0x7292, 0x82B3, 0x8AB3, 0x8B13, 0x9372, 0xABF3, 0xBC54, 0xC475, 0xE4B7, 0xE4F7, 0xE537, 0xE537, 0xECF6, 0xE4F6, 0xDCD6, 0xD4B4, 0xC412, 0xB391, 0xB371, 0xB332, 0x92AF, 0x9AAE, 0xAACE, 0xB2ED, 0xAB8E, 0xABEE, 0xBC0F, 0xC451, 0xDCF4, 0xC4B2, 0xB471, 
        0xB471, 0xABAD, 0x934C, 0x82EA, 0x7AA6, 0x5201, 0x5222, 0x5243, 0x5244, 0x6285, 0x5AA6, 0x52A5, 0x52A5, 0x7267, 0x8AC9, 0x9AC9, 0xA2A9, 0xB32B, 0xC38C, 0xD40E, 0xDCB1, 0xED13, 0xF554, 0xF595, 0xF574, 0xDCB0, 0xC40C, 0xBBC9, 0xC3E6, 0xCC87, 
        0xCC89, 0xD46B, 0xDC6C, 0xE4AC, 0xE4B0, 0xECB3, 0xEC94, 0xEC72, 0xD411, 0xC3F0, 0xBC0F, 0xCCD2, 0xE574, 0xFDF6, 0xF658, 0xEE95, 0xE615, 0xDDD5, 0xD5B5, 0x8C8B, 0xCE55, 0xCE73, 0x94A4, 0xB56D, 0xBD2E, 0xD5F4, 0xF79C, 0xC612, 0x93E7, 0x7303, 
        0x6387, 0x9CEB, 0xACEC, 0x9409, 0x6AC4, 0x9389, 0xB46D, 0xBCF0, 0xCCD1, 0xCC92, 0xCC72, 0x9B8C, 0x3201, 0x3A43, 0xB5B4, 0xF7BE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFBE, 0xF77D, 0xFFFE, 0xFFDE, 0xEEFB, 0xE5B4, 0xFF18, 
        0xF6D7, 0xF656, 0xF659, 0xFFBE, 0xF77C, 0xBD53, 0x6A45, 0x73E8, 0xC676, 0xF7DE, 0xFFFF, 0xFFDE, 0xFFDE, 0xFFFF, 0xEF5C, 0x9AE7, 0xAB28, 0xD4EF, 0xF719, 0xFF3A, 0xFF1A, 0xFEF9, 0xFEB9, 0xFEB6, 0xFEB7, 0xFEB8, 0xFE77, 0xFE36, 0xFF3B, 0xF6D9, 
        0xED52, 0xEE76, 0xF5F6, 0xED95, 0xED94, 0xEDD4, 0xD532, 0xBC4F, 0x9B0A, 0x6122, 0x7227, 0x7228, 0x5963, 0x7A48, 0x8ACA, 0x82C8, 0x7A85, 0x7267, 0x7A87, 0x82C8, 0x932A, 0x8AA8, 0x7A67, 0x7266, 0x7A85, 0x7205, 0x69E4, 0x69E4, 0x69C4, 0x61E3, 
        0x59A3, 0x5983, 0x69A4, 0x59E3, 0x59A3, 0x61A3, 0x61C3, 0x5264, 0x4AA4, 0x4A64, 0x4205, 0x7349, 0x6B27, 0x6326, 0x6B66, 0x6306, 0x8BEB, 0xBD92, 0xF75B, 0xFFDD, 0xF6BB, 0xED78, 0xE415, 0xEB4F, 0xD36E, 0x9B4E, 0x634D, 0xE632, 0xEE33, 0xD5D3, 
        0xCDD3, 0xEEB7, 0xA4F2, 0x5289, 0x0841, 0x0020, 0x2962, 0x840A, 0xE733, 0x94A9, 0x4204, 0x632C, 0xE6FB, 0xC4B0, 0xCD11, 0xCD72, 0xBD51, 0xBD52, 0xC592, 0xD5F4, 0xDE55, 0x93E9, 0x51C4, 0x730A, 0xEF59, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF7BC, 0xBD4D, 0x9C68, 0xACA9, 0xCDF0, 0xF717, 0xFFBA, 0xFFFB, 0xFFDA, 0xF6F9, 0xEEB6, 0xDE54, 0xCD92, 0xDE13, 0xD613, 0xDE54, 0xEEB4, 0xCDB3, 0xC551, 0xBD50, 0xCD92, 0xF6D4, 0xF6D4, 0xF6D5, 
        0xF6D6, 0xF6D5, 0xDDF0, 0xB4EB, 0x9C49, 0xAD2B, 0x94CC, 0x6B89, 0x4203, 0x62A4, 0xBDB1, 0xBDD2, 0x8389, 0xD592, 0xC4AF, 0xA36B, 0x9289, 0xC34D, 0x8186, 0x7165, 0xA38D, 0xF77C, 0xFF7B, 0xFF39, 0xF75A, 0xFFDD, 0xF75A, 0xCD51, 0x8AA7, 0xC48F, 
        0xDD53, 0xD532, 0xB40C, 0x7AC7, 0xB4F0, 0xE677, 0xFEF9, 0xFFDB, 0xFFBB, 0xF718, 0xE612, 0xDD50, 0xDD70, 0xDD90, 0xD5B1, 0xE5D0, 0xEE12, 0xF653, 0xF673,
  0x7AF0, 0x830F, 0x8B2F, 0x8B4E, 0xA351, 0xB3D2, 0xBC12, 0xCC53, 0xED15, 0xED16, 0xED35, 0xED74, 0xF517, 0xFD36, 0xF515, 0xECD4, 0xDC53, 0xD3F2, 0xC3D2, 0xB3B2, 0xAB10, 0xAAEF, 0xB30E, 0xB34D, 0xAB30, 0xAB6D, 0xABED, 0xBC71, 0xBCB0, 0xC4F0, 0xC4D1, 
        0xCCB2, 0xAC90, 0xA44D, 0x93EB, 0x8389, 0x4A84, 0x4243, 0x4243, 0x4A44, 0x4A85, 0x5A65, 0x6245, 0x6A66, 0x82A6, 0x8246, 0x8A07, 0x9A29, 0xB2AB, 0xBB6D, 0xD40F, 0xEC70, 0xED56, 0xF596, 0xFDB6, 0xFDB6, 0xE511, 0xE48E, 0xCBEB, 0xB368, 0xD42C, 
        0xCC4C, 0xCC2C, 0xD42D, 0xE42F, 0xE470, 0xEC71, 0xEC52, 0xEC11, 0xDC11, 0xCBD0, 0xB38F, 0xCC2F, 0xC513, 0xCE16, 0xF6F9, 0xE657, 0xF679, 0xE5F6, 0xC512, 0xEF5B, 0xC572, 0xBCF0, 0xDDD3, 0x8485, 0xC670, 0xEF15, 0xDDB1, 0x82CA, 0x8389, 0x8427, 
        0x8405, 0x9468, 0x6344, 0x5323, 0x7C48, 0xC570, 0xB4ED, 0xBD0E, 0xD552, 0xB350, 0xA38E, 0x6AA9, 0x2924, 0xE71C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDF, 0xF73C, 0xDDF6, 0xBCD0, 0xF779, 
        0xFED7, 0xF676, 0xF6D6, 0xFF18, 0xF75B, 0xB573, 0x49E4, 0x7369, 0xC636, 0xF7DE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xDE32, 0x82A8, 0x932C, 0xEF5C, 0xFF5B, 0xFF3B, 0xFF3A, 0xFF18, 0xFEB9, 0xFED8, 0xFEF8, 0xFED8, 0xF635, 0xFDB4, 0xFE15, 
        0xFED8, 0xF5B4, 0xFE56, 0xF657, 0xDD54, 0xA34C, 0x8ACA, 0x7A48, 0x6A06, 0x8B6C, 0x7268, 0x7A88, 0xA3AE, 0x92EA, 0x8287, 0x71E5, 0x5984, 0x9348, 0x9B69, 0x9BCB, 0xA46C, 0x9369, 0x9389, 0x9BA9, 0xA3AB, 0x9B4C, 0x934B, 0x932A, 0x8AE8, 0x82C8, 
        0x7287, 0x6A26, 0x6A03, 0x7224, 0x69E2, 0x7244, 0x8B07, 0x4222, 0x4245, 0x4A46, 0x5246, 0x7345, 0x7B87, 0x7B68, 0x7348, 0x9CAB, 0x6AE5, 0x6AA6, 0xACD0, 0xF79D, 0xFF3D, 0xF5D9, 0xE3F3, 0xEAD4, 0xF477, 0xFE3B, 0xFFBE, 0xFF1A, 0xEE53, 0xDDF0, 
        0xE5F2, 0xE73B, 0x630C, 0x10A2, 0x1903, 0x39A5, 0x20E3, 0x4A24, 0xB56C, 0xCE54, 0x5AE9, 0x6B2C, 0xDEBA, 0x72EA, 0xBCD1, 0xEE16, 0xE5D4, 0xC593, 0xBD72, 0xCD92, 0xC54F, 0x4123, 0x7B68, 0xC5F3, 0xF7BE, 0xFFDE, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF7BA, 0xCDAD, 0xB4C8, 0xB52D, 0xB531, 0xCDD3, 0xEED6, 0xFFDB, 0xFFBA, 0xFF17, 0xEEB5, 0xDE52, 0xCD72, 0xD5D2, 0xE674, 0xEEF6, 0xE613, 0xBD50, 0xB50F, 0xD590, 0xEE35, 0xDE33, 0xE653, 
        0xF694, 0xEE94, 0xEE93, 0xCDD0, 0x948B, 0xA50B, 0x9CEC, 0x6B68, 0x3982, 0x8348, 0xCE15, 0xF6F8, 0xEDB0, 0x9BCC, 0xBCAF, 0xCC8F, 0xB34B, 0xA2A8, 0x9248, 0xB32B, 0xED52, 0xFF9D, 0xFFBC, 0xFF7A, 0xF759, 0xFF57, 0xFF9B, 0xE6D9, 0xC4F1, 0xBBCC, 
        0xD470, 0xD4F2, 0xB4F0, 0x9C0D, 0xBCD1, 0xDE15, 0xFF59, 0xFEB7, 0xFF18, 0xFF9A, 0xFFBA, 0xF631, 0xEDD1, 0xE5B1, 0xE590, 0xE58F, 0xE5D0, 0xEE11, 0xF651,
  0x72CF, 0x830F, 0x9350, 0x9B91, 0xABB0, 0xBC52, 0xCCD4, 0xD515, 0xE4D7, 0xE4D7, 0xDCD7, 0xDCF7, 0xE556, 0xE536, 0xE536, 0xED35, 0xE4F4, 0xE4B3, 0xD473, 0xC412, 0xC38E, 0xB32D, 0xA2CC, 0x9AAA, 0xAB6C, 0xA3CD, 0xB40D, 0xC44D, 0xB46E, 0xB44E, 0xB40D, 
        0xA3CD, 0x9308, 0x7AA7, 0x6A66, 0x69E3, 0x39A1, 0x39E3, 0x4225, 0x4225, 0x4A84, 0x4243, 0x3A23, 0x3A23, 0x6984, 0x9206, 0xAA89, 0xB2A9, 0xA288, 0xBB2A, 0xD3CD, 0xDC71, 0xF554, 0xFDB6, 0xFDF7, 0xF617, 0xFD96, 0xECF2, 0xE48F, 0xDC8C, 0xDC29, 
        0xD44B, 0xD46C, 0xDC6C, 0xEC90, 0xEC70, 0xEC72, 0xEC94, 0xECD4, 0xD472, 0xC430, 0xC470, 0xBD13, 0xE5D6, 0xFE99, 0xFF3C, 0xFFDF, 0xFFDE, 0xFF9E, 0xFF3D, 0xEF78, 0xE712, 0xB5CA, 0x7443, 0xCE31, 0xD613, 0xD637, 0xD69B, 0xB58C, 0xA4EA, 0xAD0B, 
        0xAD4B, 0x5325, 0x6B66, 0x8BE9, 0xA42B, 0xAC6A, 0xC52E, 0xBD0E, 0x9C2B, 0xC471, 0x7AA9, 0x41A3, 0x4244, 0xE73C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xF71A, 0xF75A, 0xDE76, 0xBCF0, 0xF757, 
        0xF6F6, 0xF674, 0xFE74, 0xF655, 0xF73A, 0xEE97, 0xBC6C, 0x4245, 0xAD94, 0xF79E, 0xFFBF, 0xFF9B, 0xFFDD, 0xFFFF, 0xFF9D, 0xDD10, 0xCC2D, 0xD532, 0xF75B, 0xFF1A, 0xFF19, 0xFF19, 0xFEF8, 0xFE77, 0xFEB8, 0xFED9, 0xF6D8, 0xFE35, 0xDD72, 0xCCF0, 
        0xCCD0, 0xEDF5, 0xABEE, 0x7A49, 0x69A6, 0x82E9, 0x82C9, 0x8B2B, 0x9BCE, 0x7A87, 0x8AC9, 0x8AE9, 0x82A8, 0x92C9, 0x934A, 0xA3CB, 0xAC2C, 0xC48F, 0xC50F, 0xBD2E, 0xBCEE, 0xC56F, 0xC54F, 0xBD0E, 0xB48C, 0xB46B, 0xB42C, 0xAC0D, 0xABCC, 0xABEC, 
        0xABEB, 0xABAB, 0x9B2A, 0xA3AB, 0xA38A, 0xAB4A, 0xAB4A, 0x5304, 0x4AA3, 0x4A44, 0x4A46, 0x7347, 0x8388, 0x7B88, 0x7388, 0x7BC8, 0x6B46, 0x62E3, 0x7B65, 0xEF3B, 0xFEFD, 0xEDBA, 0xDC15, 0xC2D2, 0xE457, 0xFDDC, 0xFEFF, 0xFFBE, 0xEEDA, 0xEEDA, 
        0xEF5C, 0x73C9, 0x2963, 0x1902, 0x39E4, 0x0861, 0x18E2, 0x6B89, 0xD691, 0x41C4, 0x9C4D, 0xC591, 0xB4F0, 0xEEF8, 0xC5B3, 0xB531, 0xCDB3, 0xBCB1, 0xBD2F, 0x9C8A, 0x6AA3, 0x9BA5, 0xDE55, 0xFFBD, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF7DE, 0xDE98, 0xC571, 0xB4CB, 0xACA9, 0xE631, 0xE674, 0xD655, 0xC5B4, 0xBD52, 0xCD91, 0xD5B2, 0xD5F4, 0xE6B4, 0xE6B5, 0xE674, 0xD5F2, 0xD5F3, 0xD5B2, 0xD571, 0xC531, 0xC54F, 0xD591, 0xD5D2, 
        0xD633, 0xF6B6, 0xE653, 0xC56E, 0xAC8A, 0xA54C, 0x8CAA, 0x52E6, 0x2944, 0xE71A, 0xFFD9, 0xDF16, 0xB5B3, 0xC4CD, 0xC4CE, 0xBCEF, 0xBCEF, 0xBB8C, 0xA1C6, 0xB34C, 0xF75C, 0xFF7A, 0xF77A, 0xF759, 0xFEF6, 0xFF99, 0xEF39, 0xDDD5, 0xC3CE, 0x8BEC, 
        0x9C2D, 0xBC70, 0xCC92, 0xAC30, 0xB4D2, 0xD554, 0xE5D6, 0xF6F9, 0xEE77, 0xEE36, 0xFE97, 0xFED8, 0xFED6, 0xFE95, 0xF654, 0xEE54, 0xF674, 0xF673, 0xEE53,
  0x7310, 0x8330, 0x8B4E, 0x934C, 0xAC33, 0xBC54, 0xC474, 0xDC95, 0xDC96, 0xDCB5, 0xD4D4, 0xD4D4, 0xDCF4, 0xE515, 0xED15, 0xF535, 0xE513, 0xE4B3, 0xDC93, 0xCC50, 0xAB4D, 0x9ACB, 0x9AAA, 0xA2EB, 0xA3AC, 0xABCD, 0xB3CD, 0xB3ED, 0xB3ED, 0xB3EE, 0xABCD, 
        0x9B8C, 0x732A, 0x6287, 0x4A24, 0x4203, 0x4203, 0x4202, 0x4203, 0x4A24, 0x5A64, 0x6286, 0x6A66, 0x7206, 0x6A86, 0x92E9, 0xAB4B, 0xB36D, 0xC36C, 0xBB0B, 0xBB6D, 0xD470, 0xF534, 0xFD76, 0xF5B6, 0xF5D6, 0xF575, 0xE4F2, 0xDCAF, 0xD4AD, 0xD429, 
        0xDC8B, 0xE4EE, 0xE512, 0xED51, 0xED13, 0xECF4, 0xED14, 0xE4F2, 0xDCF2, 0xCCF1, 0xB4F0, 0xCD74, 0xEDF6, 0xFE98, 0xFF5B, 0xFFBD, 0xF75C, 0xF71B, 0xFF1C, 0xF73A, 0xD616, 0xC592, 0xCDD0, 0xA56A, 0xDE51, 0xFF16, 0xEEB6, 0x7B88, 0x8C88, 0x9D4A, 
        0x9D2A, 0x7404, 0x7C25, 0x7C27, 0x7C49, 0xBD0D, 0xC54F, 0xCD51, 0xD533, 0x82EB, 0x6285, 0x3A02, 0x3204, 0xE73C, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xF6B8, 0xEED8, 0xE615, 0xD4F0, 0xF695, 
        0xF634, 0xEDF3, 0xF654, 0xFEF7, 0xFF38, 0xFF7A, 0xEF3B, 0x7AA7, 0xC574, 0xF73C, 0xFEB9, 0xFF99, 0xF718, 0xF676, 0xF615, 0xFED6, 0xFF18, 0xFF19, 0xFED8, 0xFF19, 0xFF1A, 0xFEF9, 0xFED8, 0xFED7, 0xFE97, 0xFE97, 0xF697, 0xF574, 0xD4D0, 0xC46E, 
        0xBC4D, 0xA349, 0x92C8, 0x92C9, 0x930B, 0x8267, 0x8AE9, 0x8B2A, 0x8AEA, 0xA349, 0xAB8A, 0xABEB, 0xBC6C, 0xBD2F, 0xC52F, 0xCD2F, 0xCD2F, 0xCD71, 0xDD70, 0xDD4F, 0xD52F, 0xD4ED, 0xC4CD, 0xBCAD, 0xBCCD, 0xAC8B, 0xAC8C, 0xAC8C, 0xAC6B, 0xA3EB, 
        0xA40B, 0xA3EA, 0x9369, 0x9349, 0x9B69, 0x9308, 0x8285, 0xB48D, 0x5A86, 0x2983, 0x4247, 0x7347, 0x6B67, 0x83EA, 0x9C8D, 0x41E3, 0x7B67, 0x83E9, 0x52A5, 0x6AC6, 0xC5B4, 0xE639, 0xD3F2, 0xDBB5, 0xED7A, 0xF6FD, 0xFFBF, 0xF6DC, 0xE678, 0xEED9, 
        0xE73B, 0x6AA5, 0x5265, 0x5285, 0x3A03, 0x0840, 0x0841, 0x5AEB, 0xD6D8, 0x7346, 0xBD50, 0xE656, 0xD593, 0xCDB2, 0xCDB3, 0xBD51, 0xA48D, 0xD5AF, 0xAC6B, 0x8B45, 0x9344, 0xEF7C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xEEFA, 0xCDB2, 0xBD0C, 0xB52B, 0xCDD3, 0xC5B2, 0xBD72, 0xBD72, 0xBD91, 0xCDB2, 0xCDD2, 0xD5F2, 0xEEB5, 0xD613, 0xCDD3, 0xDE14, 0xDE74, 0xDE34, 0xD5D2, 0xC571, 0xCD50, 0xD551, 0xD5B2, 
        0xDE33, 0xD652, 0xE6D4, 0xCDF0, 0x8428, 0xA56C, 0x6B27, 0x7AC6, 0xDD2D, 0xFF9C, 0xFF58, 0xFF58, 0xEF5B, 0x9347, 0x9349, 0xAC2D, 0xC4CE, 0x9AE8, 0xC42E, 0xE616, 0xFFBD, 0xFF39, 0xF738, 0xF717, 0xF6F7, 0xFEF7, 0xFF7B, 0xDE77, 0xB44C, 0xB3ED, 
        0xBC50, 0xBC70, 0xAC4F, 0xD5B6, 0xAC6F, 0xA40D, 0xC4D1, 0xCD73, 0xDDD5, 0xE5F5, 0xEE15, 0xFF39, 0xF6D8, 0xF696, 0xF6B6, 0xF675, 0xEE13, 0xEDD3, 0xEE13,
  0x832D, 0x834D, 0x8B6D, 0x8B8D, 0xA391, 0xBBD3, 0xCC34, 0xDC74, 0xDC75, 0xE495, 0xDCB5, 0xD4B3, 0xDD13, 0xED34, 0xED14, 0xE4D4, 0xF4F4, 0xECB3, 0xEC92, 0xDC71, 0xB44E, 0xAB8C, 0xA30B, 0x9B2A, 0xB38D, 0xABCD, 0xB3ED, 0xBC0D, 0xB3CD, 0xAC0D, 0xABEB, 
        0xAB89, 0x9308, 0x8B06, 0x72A3, 0x4A00, 0x49E1, 0x4202, 0x3A03, 0x3A23, 0x52C5, 0x4AA4, 0x4A84, 0x6285, 0x8245, 0x92A8, 0xA32B, 0xB36C, 0xC38D, 0xAB2C, 0xBB6D, 0xE450, 0xECD3, 0xF575, 0xFDF7, 0xFDF9, 0xFD95, 0xFD34, 0xFCB2, 0xF450, 0xF40D, 
        0xE42F, 0xE471, 0xEC92, 0xFCD4, 0xFCF4, 0xFCF3, 0xF4D2, 0xFCD5, 0xF4B4, 0xE492, 0xDC92, 0xD532, 0xDDB3, 0xEE57, 0xFF3C, 0xFFDF, 0xFFBF, 0xFFBE, 0xFFFE, 0xFF9D, 0xDDD5, 0xC4CF, 0xB4EC, 0xD753, 0xE734, 0xD631, 0xA4CC, 0x9C8A, 0xAD4C, 0xA52C, 
        0x9409, 0x8BEA, 0x8BCB, 0x8BEB, 0x9C8C, 0xE5B2, 0xDDB4, 0xC4B2, 0x92AC, 0x5AA3, 0x7366, 0x5AA5, 0x2924, 0xE71C, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xF69A, 0xF719, 0xEE76, 0xC4B0, 0x8B89, 
        0xAC6D, 0xD593, 0xE676, 0xD572, 0xCD30, 0xD5D3, 0xF719, 0xE574, 0xF678, 0xFF1A, 0xFEF7, 0xFEF6, 0xF6D6, 0xF676, 0xFE15, 0xFF9D, 0xFF39, 0xFEF8, 0xFF1B, 0xFF1A, 0xFF39, 0xFF19, 0xFEB8, 0xFE97, 0xFE97, 0xFE97, 0xFE56, 0xE511, 0xC46E, 0xB40C, 
        0xABAA, 0xA3AC, 0x9B4B, 0x9AE9, 0x9AA8, 0x8ACA, 0x932A, 0x9B4A, 0xA36B, 0xAC4E, 0xC4AE, 0xDD0F, 0xDD71, 0xE5B0, 0xE5B2, 0xE5B2, 0xE592, 0xDD31, 0xD510, 0xCD30, 0xCD6F, 0xC50F, 0xC50F, 0xCD0E, 0xCD0E, 0xC4CE, 0xC4AD, 0xB46C, 0xAC2C, 0xABEC, 
        0xABEB, 0xABCB, 0xA3AB, 0xA3EA, 0xA40B, 0x9368, 0x7AA4, 0xBD0F, 0x7B29, 0x41E3, 0x3A02, 0x6327, 0x6B06, 0x83AA, 0xB511, 0x7B8A, 0x3984, 0x4A65, 0x9D0A, 0x42A4, 0x940A, 0xDE14, 0xFF3D, 0xF396, 0xF4B9, 0xF65D, 0xFFDF, 0xFFBE, 0xFFBE, 0xFFDF, 
        0xE71C, 0x2104, 0x39C3, 0x5AC5, 0x7367, 0xB553, 0x5289, 0x62E9, 0xCE13, 0x6AC4, 0xBD50, 0xEEB6, 0xDE15, 0xD5D4, 0xC552, 0xBD31, 0xBD50, 0xBD30, 0xAC4A, 0xC52E, 0xF79D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFBC, 0xD655, 0xA48B, 0xD5B2, 0xD5D3, 0xCDD2, 0xC5D2, 0xBD71, 0xBD91, 0xCDB2, 0xE5F3, 0xE633, 0xCD70, 0xCD70, 0xDE33, 0xF6B5, 0xF6B6, 0xEE75, 0xE634, 0xEE74, 0xE654, 0xE633, 
        0xE652, 0xE633, 0xE693, 0xD652, 0xBD6F, 0x9CCB, 0x6345, 0x7347, 0xC531, 0xF6F1, 0xFF92, 0xFFF4, 0xFFD7, 0xEF19, 0xDD53, 0xDCF1, 0xE5B3, 0xDCEE, 0xEEB8, 0xFFBD, 0xFF9B, 0xFF37, 0xFF37, 0xFF17, 0xF6D6, 0xFED6, 0xFF79, 0xFFDA, 0xEEF6, 0x8A6A, 
        0xB34E, 0xC470, 0xB4B0, 0xA450, 0xC4D2, 0xCCF2, 0xB4D1, 0xD534, 0xDD74, 0xCD32, 0xACD0, 0xF656, 0xFE96, 0xF676, 0xF636, 0xEDF4, 0xF635, 0xF635, 0xEDF4,
  0x830D, 0x834E, 0x8B6D, 0x936D, 0xA3CF, 0xB432, 0xCC74, 0xDC95, 0xD4B3, 0xCCB3, 0xCC92, 0xCCB1, 0xCCD2, 0xCCB3, 0xD473, 0xDC72, 0xE472, 0xECB3, 0xE4B3, 0xDC72, 0xB3CD, 0xA34B, 0x9B09, 0x930A, 0xB3AC, 0xC42C, 0xC46E, 0xCCCF, 0xD4AE, 0xC42F, 0xB3F1, 
        0x9BD1, 0x72EB, 0x4A48, 0x4206, 0x4A26, 0x4A24, 0x4223, 0x5224, 0x7245, 0x92A9, 0xAAEB, 0xBB2C, 0xB34D, 0xB38D, 0xBBCD, 0xBBED, 0xBC0D, 0xDC72, 0xE451, 0xE451, 0xDC91, 0xF534, 0xF556, 0xF536, 0xFD16, 0xED34, 0xE4D2, 0xDCB1, 0xDCB1, 0xDC8F, 
        0xED11, 0xF593, 0xF634, 0xFE58, 0xF678, 0xF657, 0xF5D6, 0xD552, 0xD552, 0xCD53, 0xB553, 0xDE36, 0xF6B8, 0xF71A, 0xF75A, 0xFF9E, 0xFFBE, 0xFFBD, 0xFF7D, 0xFFBD, 0xFFDD, 0xF77B, 0xDE75, 0xAD07, 0xAD29, 0xBDAD, 0xC610, 0x8C28, 0x9CEC, 0xAD8D, 
        0x9D8A, 0x8449, 0x8447, 0x8426, 0x8C27, 0xE694, 0xB52F, 0x8368, 0x6263, 0x6B47, 0x7BE6, 0x5AC4, 0x2942, 0xE70F, 0xFFF9, 0xFFDE, 0xFFBF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xFEB9, 0xF6F9, 0xCDD5, 0x836A, 0x7246, 
        0x7287, 0x7AE9, 0x834B, 0x69E4, 0x8B29, 0x8B49, 0x7AA7, 0xDDF6, 0xCCD2, 0xCC91, 0xF5B6, 0xF636, 0xFE76, 0xFED8, 0xFF1A, 0xFEB7, 0xFED9, 0xFF1B, 0xFF1B, 0xFF19, 0xFEF9, 0xFED8, 0xFEB8, 0xF677, 0xF677, 0xFE57, 0xF5D6, 0xDCF0, 0xC48E, 0xB3CB, 
        0x9B09, 0xB3CA, 0xB38A, 0xA329, 0xA309, 0xA34A, 0xAB8A, 0xABEB, 0xB48E, 0xDD70, 0xDD72, 0xDD93, 0xD591, 0xCD31, 0xCD31, 0xC52F, 0xBCED, 0xB4F1, 0xB50E, 0xBD0D, 0xBD2D, 0xC4ED, 0xBCED, 0xBCEE, 0xBCEF, 0xBCAC, 0xB44B, 0xB44B, 0xBC6C, 0xB48B, 
        0xAC4B, 0xAC0B, 0xA3CB, 0xA3AA, 0x9BAA, 0x9329, 0x8AA8, 0xBD4E, 0x6328, 0x3A05, 0x4AA6, 0x5AA3, 0x6347, 0x842B, 0x94AE, 0x4266, 0x31E3, 0x29A4, 0x2987, 0x6B62, 0x83E5, 0xB54F, 0xEF3C, 0xDC77, 0xEE1B, 0xFF7F, 0xFFFF, 0xFFBD, 0xFFBD, 0xDE96, 
        0x9BE8, 0x18A1, 0x31C4, 0x5AC6, 0x62E7, 0x41A3, 0x9C8E, 0x944E, 0x3144, 0xD635, 0xE697, 0xDE35, 0xD5F3, 0xD552, 0xBCEF, 0xC571, 0xDDF4, 0x72A5, 0xBD94, 0xF7BE, 0xFFFF, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF7DE, 0xD697, 0xC5F2, 0xD5D1, 0xD633, 0xCDF3, 0xC5B2, 0xC592, 0xB591, 0xBD70, 0xBD70, 0xAD70, 0xCD50, 0xD5B3, 0xDE35, 0xEE74, 0xDE96, 0xE696, 0xEE95, 0xEEB6, 0xEE95, 0xEE95, 0xEE95, 
        0xEE95, 0xDE52, 0xE6B4, 0xE6B3, 0xC5B0, 0x6AE4, 0x9449, 0xC5AD, 0xF64D, 0xF6B0, 0xFF75, 0xFFD8, 0xFFBA, 0xF7BC, 0xD656, 0xC4EF, 0xCC4D, 0xF77C, 0xFF9B, 0xFF58, 0xFF38, 0xF718, 0xFF18, 0xF6F7, 0xF6B4, 0xFF17, 0xFF98, 0xE717, 0xBD51, 0xA208, 
        0xB38D, 0xBC90, 0xAC70, 0xB4D2, 0xBCB1, 0xC491, 0xC4B2, 0xD575, 0xDDF5, 0xD594, 0xBCD1, 0xCD52, 0xD593, 0xE5D4, 0xEE15, 0xD5D3, 0xDE14, 0xE5F4, 0xE5B3,
  0x834B, 0x8B6B, 0x936C, 0x936D, 0x9B6D, 0xB3F1, 0xC453, 0xD494, 0xDCB4, 0xDC94, 0xCC72, 0xBC50, 0xBC70, 0xC470, 0xD450, 0xDC50, 0xE472, 0xEC94, 0xECB5, 0xDC94, 0xAB8C, 0xA309, 0xA2E9, 0xA32A, 0xB38C, 0xB3EC, 0xB3EC, 0xB3CD, 0xBB8A, 0xAB68, 0x9B08, 
        0x8289, 0x722A, 0x5A49, 0x4A68, 0x4A67, 0x4AA7, 0x52E7, 0x6327, 0x8369, 0x9C4D, 0xA46F, 0xAC70, 0xB44F, 0xDC70, 0xD471, 0xCC91, 0xC4D0, 0xDCD2, 0xE4B2, 0xE492, 0xE4B2, 0xECD3, 0xE492, 0xDC71, 0xD492, 0xDC52, 0xE452, 0xEC52, 0xF472, 0xFC72, 
        0xFD55, 0xFDF7, 0xFE79, 0xFEFC, 0xFEBA, 0xFE58, 0xF5F6, 0xF554, 0xED54, 0xE595, 0xE5B4, 0xDDD6, 0xEE97, 0xF73A, 0xFF9E, 0xF7BD, 0xF77E, 0xF77E, 0xF77D, 0xF73A, 0xF77C, 0xD696, 0xA4AA, 0xB52C, 0xB4CB, 0xA48B, 0x94AB, 0xAD8D, 0xB5CE, 0xB5CD, 
        0xAD6B, 0x73C5, 0x7BC7, 0x9CAB, 0xC5D0, 0xB4EE, 0x72A7, 0x51C2, 0x4A42, 0x7386, 0x6324, 0x5B02, 0x5322, 0x2963, 0xA534, 0xF7BE, 0xFFFF, 0xFFBF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFDE, 0xFFDE, 0xFFFE, 0xFFDF, 0xFF5C, 0xF6F9, 0xD5D3, 0x940B, 0x7247, 
        0x7AA9, 0x72AA, 0x6249, 0x8349, 0x9B8A, 0x932A, 0x8288, 0x8AC9, 0x7A27, 0x7A27, 0xA32C, 0xF5D6, 0xF637, 0xF616, 0xF616, 0xFE78, 0xFEB8, 0xFED8, 0xFF19, 0xFF19, 0xFEF8, 0xFED8, 0xFEB8, 0xF656, 0xF656, 0xF636, 0xF5D4, 0xDCF0, 0xCC6D, 0xC40C, 
        0xB3CB, 0xAB49, 0xB36A, 0xB36B, 0xAB6A, 0xC4AD, 0xC50F, 0xC50F, 0xC4CF, 0xDD93, 0xCDD2, 0xC5B1, 0xC592, 0xCD91, 0xCDB1, 0xCDB2, 0xD592, 0xC572, 0xC551, 0xC530, 0xBD0F, 0xBD0E, 0xBD0E, 0xB4EE, 0xACCC, 0xB4AC, 0xBC8B, 0xBC4B, 0xBC4B, 0xB42B, 
        0xB46C, 0xB44B, 0xABEA, 0x9BCA, 0x9BEB, 0x9369, 0x8AC7, 0xB50E, 0x6B08, 0x4A25, 0x52E7, 0x5305, 0x52E5, 0x52E6, 0x5B07, 0x7BCA, 0x52A5, 0x2961, 0x18E2, 0xA56C, 0x9446, 0xACCC, 0xF73C, 0xF4F8, 0xF5FB, 0xFF3E, 0xFFDF, 0xFFFF, 0xF7BE, 0xA514, 
        0x18A2, 0x10A0, 0x18C0, 0x3163, 0x5288, 0x8B6B, 0x8B89, 0x5A66, 0x2924, 0xDEFB, 0xE698, 0xD5D4, 0xCD93, 0xB4F0, 0xC571, 0xBD4E, 0x9448, 0xC54F, 0xEEF9, 0xFFDE, 0xFFDE, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xE73B, 0xD636, 0xCD50, 0xCE13, 0xD5F3, 0xCDD2, 0xBD92, 0xB591, 0xBD70, 0xBD70, 0xBD70, 0xD5B3, 0xDDF3, 0xE675, 0xEED8, 0xE695, 0xEED6, 0xF6D6, 0xF6B6, 0xFF17, 0xF6F6, 0xF6B5, 
        0xEE54, 0xE655, 0xF6D5, 0xE693, 0xB54D, 0x5264, 0xB572, 0xDE96, 0xC50E, 0xF60D, 0xFF53, 0xFFF6, 0xFFF6, 0xF7BC, 0xDE14, 0xD613, 0xF79A, 0xFFDB, 0xF739, 0xF718, 0xF758, 0xFF38, 0xFF38, 0xF6F8, 0xEEB7, 0xF6F5, 0xFF77, 0xEF98, 0xCE53, 0x7904, 
        0xAA8B, 0xC3CF, 0xAC0E, 0xBCF2, 0xBCB2, 0xB490, 0xB490, 0xDD75, 0xDDB5, 0xD5B4, 0xCD73, 0xC531, 0xDD72, 0xE5B3, 0xDDB4, 0xE5F3, 0xDDD3, 0xDDD3, 0xDDD3,
  0x832C, 0x8B6D, 0x938D, 0x936D, 0x9B8D, 0xA3AF, 0xB3F2, 0xCC74, 0xE4D5, 0xCCD3, 0xBCB1, 0xB48F, 0xBC6D, 0xC470, 0xC450, 0xBC0E, 0xEC32, 0xEC73, 0xF4B4, 0xF4F5, 0xCC52, 0xAB8E, 0x930A, 0x92E8, 0xB38D, 0xABCD, 0xAC0C, 0xAC2C, 0xABAF, 0x9B90, 0x8B2F, 
        0x7AAD, 0x5AAB, 0x626A, 0x5A29, 0x5228, 0x6245, 0x7244, 0x8265, 0x92C8, 0xB34F, 0xC3B0, 0xD3F0, 0xDC11, 0xE451, 0xE471, 0xDC91, 0xD4D0, 0xE4F2, 0xE4B2, 0xECB3, 0xF4D3, 0xECF3, 0xF4D3, 0xF4D3, 0xEC92, 0xDC32, 0xDC32, 0xDC71, 0xE4D2, 0xF4B3, 
        0xFD15, 0xFD96, 0xFE77, 0xFFBE, 0xFF5C, 0xFED9, 0xFE77, 0xF5F3, 0xDD92, 0xD592, 0xDDD5, 0xDE16, 0xE697, 0xF6F9, 0xFF5C, 0xFF9E, 0xFFBF, 0xFFBF, 0xFFBF, 0xFFFF, 0xF77C, 0xBD52, 0x7283, 0xA50A, 0xA50A, 0x9D0A, 0xA56D, 0xB5ED, 0xADAE, 0x952D, 
        0x7C8A, 0x8469, 0x8C69, 0x9CCA, 0xAD2B, 0x62A5, 0x39C2, 0x5285, 0x8C0C, 0x5AC3, 0x6304, 0x6B84, 0x6340, 0x2102, 0xA514, 0xF79E, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFBE, 0xE617, 0xEEFB, 0xCDF6, 0x8329, 0x8B2A, 
        0x8309, 0x8B2B, 0x93AF, 0xA3AB, 0x9BAB, 0x934B, 0x8AEA, 0x936B, 0x936B, 0x8268, 0x6964, 0xC4B1, 0xEDD5, 0xFE57, 0xFE97, 0xFE38, 0xFE98, 0xFEF8, 0xFF37, 0xFED9, 0xFF18, 0xFEF8, 0xFEB8, 0xFE97, 0xFE56, 0xFDF5, 0xFDB4, 0xDD11, 0xD4CF, 0xD4AE, 
        0xD48E, 0xABED, 0xB3CD, 0xBBEC, 0xCC8D, 0xCD31, 0xC530, 0xCD30, 0xCD71, 0xC591, 0xBD71, 0xBD92, 0xB5D3, 0xAD11, 0xA4AF, 0xA510, 0xB5B2, 0xC4F1, 0xBD32, 0xBD91, 0xBDB0, 0xC592, 0xB551, 0xB4F0, 0xB4CF, 0xB50F, 0xBCEF, 0xBCAE, 0xB44C, 0xB44D, 
        0xB46D, 0xB46D, 0xBC6C, 0xAC2C, 0xAC2C, 0xA3CB, 0x9B8A, 0xBD2E, 0x6B47, 0x4A64, 0x5B06, 0x6365, 0x5B26, 0x4265, 0x21A1, 0x5326, 0x4A85, 0x2963, 0x18C2, 0xA52E, 0x8407, 0x9449, 0xDE96, 0xFF9E, 0xFEDE, 0xFEFE, 0xFFDF, 0xF7DE, 0xCE99, 0x842F, 
        0x3142, 0x39A1, 0x39C5, 0x2125, 0x18A2, 0xA46B, 0x93EB, 0x72E9, 0x830B, 0xEF3C, 0xEEB7, 0xC572, 0x9CAF, 0xDD92, 0xE654, 0xBCCE, 0x8265, 0xEF3C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xF7DE, 0xF7BA, 0xCDAF, 0xDDD3, 0xD5F4, 0xB592, 0xCD92, 0xC591, 0xC5B2, 0xCDF3, 0xDE15, 0xE635, 0xE695, 0xF6F6, 0xFF59, 0xFF18, 0xFEF7, 0xF717, 0xFF78, 0xFF17, 0xFED6, 
        0xFED7, 0xF6D4, 0xF736, 0xDEB5, 0xB52F, 0xA48D, 0xDE95, 0xFF78, 0xF6B3, 0xDD8B, 0xE5ED, 0xEED3, 0xFFB9, 0xFFB8, 0xFFBA, 0xFFBC, 0xFF9C, 0xFF7A, 0xFF7A, 0xFF79, 0xFF97, 0xFF57, 0xFF59, 0xFF39, 0xF6F7, 0xFED6, 0xFEF5, 0xFF58, 0xE71B, 0x6145, 
        0xB3CF, 0xCCD2, 0x9B6B, 0xAC90, 0xAC90, 0xB470, 0xC4B1, 0xE575, 0xE5B6, 0xDD95, 0xD552, 0xCD12, 0xDD73, 0xE594, 0xE594, 0xEE15, 0xEDF5, 0xEDD5, 0xE5D5,
  0x8B8A, 0x938A, 0x938C, 0x936D, 0x936C, 0xABEE, 0xBC51, 0xCC94, 0xDCF4, 0xD4B3, 0xC491, 0xBC8D, 0x9BAB, 0xABAB, 0xABAB, 0xAB8B, 0xDC52, 0xEC93, 0xF4D6, 0xF517, 0xC3AD, 0xAB4B, 0xA32A, 0xAB0B, 0xB3AC, 0xABAC, 0x9B6B, 0x92E9, 0x7A65, 0x69E6, 0x61C8, 
        0x61AB, 0x49A9, 0x49E9, 0x524B, 0x6AAC, 0x634A, 0x7BEB, 0x942D, 0xA42E, 0xDD53, 0xF555, 0xF554, 0xED53, 0xFD36, 0xF534, 0xF533, 0xF554, 0xF514, 0xECD4, 0xF4D4, 0xF4F4, 0xDC91, 0xCC0F, 0xBBAE, 0xA38D, 0xC38F, 0xD3D0, 0xE411, 0xF472, 0xFCB3, 
        0xFDB6, 0xFE79, 0xFEBC, 0xFF1B, 0xFF3B, 0xFF1B, 0xFED9, 0xFE98, 0xFE97, 0xF676, 0xF655, 0xE697, 0xE6B8, 0xEF1A, 0xFFBE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDD, 0xF6DB, 0xCD95, 0xB50F, 0xA50A, 0x7B83, 0x73A6, 0x94CA, 0xC66F, 0xC632, 0xB5B0, 0xA52B, 
        0x9CA6, 0x7407, 0x8C29, 0x946A, 0x8C6A, 0x7B86, 0x8409, 0x8429, 0x6BC6, 0x7343, 0x6B85, 0x6BA5, 0x5B43, 0x18C2, 0x630C, 0xB5B6, 0xF7BE, 0xFFBE, 0xFFDF, 0xFFDF, 0xFF9E, 0xFFDE, 0xF6FA, 0xF6B8, 0xFF5A, 0xEF5C, 0x834C, 0x61E6, 0x9BCC, 0xCD50, 
        0xBCAE, 0xAC2D, 0xA40D, 0xABEA, 0xA3CB, 0xA40D, 0xA44E, 0x934B, 0x934A, 0x8AE9, 0x7A46, 0x71E5, 0xAB8B, 0xDCF1, 0xFD95, 0xFDF5, 0xFE96, 0xFED7, 0xFED8, 0xFEF8, 0xFED8, 0xFEF8, 0xFF19, 0xF696, 0xF655, 0xEE15, 0xEDD5, 0xFD93, 0xF571, 0xED30, 
        0xE4EF, 0xDCCF, 0xDCAE, 0xD4CE, 0xC50F, 0xC4CE, 0xBCAE, 0xB4CE, 0xB4CE, 0x940B, 0x7B89, 0x7349, 0x6B28, 0x4A65, 0x5AC7, 0x5AA7, 0x41C4, 0x1981, 0x1940, 0x2940, 0x29A1, 0x39E3, 0x52A6, 0x6B69, 0x83EB, 0x8BCC, 0x942B, 0xA46B, 0xAC6D, 0xA48B, 
        0xAC6B, 0xA44C, 0x9C4D, 0xABEC, 0xABEB, 0xAC4C, 0xB4CD, 0x9BEA, 0x7327, 0x5AC6, 0x52E6, 0x6346, 0x52A5, 0x4264, 0x3AA4, 0x29C2, 0x2141, 0x4244, 0x9449, 0x84E9, 0x6BA5, 0x946B, 0xEF5B, 0xFF9F, 0xFF7F, 0xFFBF, 0xFFFF, 0xEF7D, 0x7B2C, 0x3963, 
        0x4A64, 0x52C5, 0x3982, 0x1880, 0x18A2, 0xB4CF, 0xBD2D, 0xD5F2, 0xF79C, 0xE614, 0xBD31, 0xB511, 0xCD93, 0xDDF3, 0xA4AC, 0xAD2D, 0xF755, 0xFFFE, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xEF5C, 0xD699, 0xDE96, 0xCE13, 0xCDB2, 0xDDB3, 0xBDB2, 0xBDB2, 0xC592, 0xD592, 0xEE94, 0xE6B5, 0xE696, 0xEEB6, 0xFF59, 0xF718, 0xF718, 0xFF38, 0xFF37, 0xF6F6, 0xF6F6, 
        0xF717, 0xFEB7, 0xFF58, 0xD633, 0x9C0A, 0xEF37, 0xF736, 0xF736, 0xF779, 0xDDCF, 0xE62F, 0xEF11, 0xF7D3, 0xFF5A, 0xFF9B, 0xFFBA, 0xFF9A, 0xFF7B, 0xFFBA, 0xFFBA, 0xF7B9, 0xFF79, 0xFF79, 0xFF59, 0xF737, 0xF696, 0xFF59, 0xFFF9, 0xE715, 0x4144, 
        0xAB6F, 0xF5D9, 0xEE9A, 0x7AC8, 0xA3CB, 0xBCAF, 0xBC90, 0xBCD0, 0xC4D0, 0xC4D1, 0xC4D1, 0xCD32, 0xD532, 0xDD32, 0xE593, 0xF676, 0xEE76, 0xE614, 0xD573,
  0x8B69, 0x938A, 0x938B, 0x934C, 0x936B, 0xA40D, 0xB470, 0xC493, 0xDC94, 0xCC92, 0xBC4F, 0xABEB, 0x93A8, 0x9B8A, 0xABCC, 0xBC4E, 0xE453, 0xF4B5, 0xF4D6, 0xE4B5, 0xC40F, 0xAB8C, 0xA34B, 0xAB4B, 0xB3AD, 0xA34B, 0x82A9, 0x59E8, 0x51C8, 0x49C9, 0x51EA, 
        0x624B, 0x526B, 0x526B, 0x626B, 0x72AC, 0xAB8D, 0xBC4E, 0xD491, 0xE4B5, 0xF555, 0xF536, 0xFD36, 0xFD55, 0xF537, 0xF535, 0xF554, 0xFD55, 0xF514, 0xF4F4, 0xECB3, 0xDC71, 0xBB8C, 0xB30B, 0xA2EB, 0xA30C, 0xCBCF, 0xDC11, 0xE453, 0xECB3, 0xECD3, 
        0xF575, 0xF616, 0xFE98, 0xFF7C, 0xFF7B, 0xFF5B, 0xFEF9, 0xFF39, 0xFF18, 0xF6D8, 0xE6B8, 0xD5D4, 0xDE56, 0xEEF9, 0xEF3B, 0xD638, 0xEF3C, 0xF79D, 0xF75B, 0xF7BE, 0xDE9A, 0xBD74, 0x9CCD, 0x9525, 0x9506, 0x9549, 0xA5AC, 0xC64F, 0xB60F, 0xA58D, 
        0x9D0A, 0x6BE6, 0x8C68, 0x9CAA, 0x948A, 0x83C7, 0x73E6, 0x73C6, 0x6B86, 0x5B85, 0x5B02, 0x39E1, 0x18E2, 0x950B, 0x8426, 0x9CEC, 0xEF7C, 0xF69C, 0xF73D, 0xFFBE, 0xFFBE, 0xFEFB, 0xFF9D, 0xFFFF, 0xE71B, 0x2924, 0x59E6, 0x938B, 0xBCCF, 0xCD10, 
        0xDD92, 0xE5D4, 0xEDF5, 0xD5B0, 0xCD71, 0xD573, 0xD5D5, 0xCD72, 0xBCCF, 0xBCAF, 0xCCF1, 0xA46D, 0x8B68, 0x9348, 0xBC2C, 0xF5D4, 0xFE76, 0xFE96, 0xFE97, 0xFEF9, 0xFEF9, 0xFEF8, 0xFF18, 0xF6B8, 0xF656, 0xF614, 0xF5F4, 0xF5B4, 0xED73, 0xED52, 
        0xE531, 0xDCCE, 0xD4AE, 0xCCCE, 0xC4EE, 0xBCEE, 0xBCEF, 0xA44D, 0x8347, 0x6B69, 0x7BEC, 0x840D, 0x840D, 0x8C2D, 0x8C4D, 0x840D, 0x73AC, 0x7C0B, 0x6BCA, 0x6349, 0x52E7, 0x3A04, 0x39E5, 0x3A04, 0x3A44, 0x52E8, 0x734A, 0x83AB, 0x940A, 0xA44D, 
        0xA46D, 0xA44C, 0xAC4C, 0xAC2D, 0xAC6D, 0xAC6D, 0xA42C, 0x9348, 0x7B69, 0x6B48, 0x5AE7, 0x52A5, 0x4243, 0x3A43, 0x3A65, 0x1941, 0x21A3, 0x5B07, 0x9D2C, 0x94C8, 0x7BC5, 0x94A9, 0xDF35, 0xFFDE, 0xFF9F, 0xFF9F, 0xFFDF, 0xDEDA, 0x62CB, 0x41E5, 
        0x7BCA, 0x4A22, 0x2901, 0x1061, 0x1881, 0xA409, 0xDE95, 0xF75B, 0xEE79, 0xACF0, 0xB530, 0xC5B3, 0xDE35, 0xCDB0, 0xB4AD, 0xC552, 0xF79D, 0xFF7C, 0xFFBE, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFFF, 0xEF7D, 0xDEB9, 0xD5F2, 0xD5D2, 0xCDB2, 0xCDB3, 0xCDB1, 0xCDD2, 0xC5D3, 0xCDB3, 0xE676, 0xEE97, 0xF6B7, 0xF6D6, 0xEF18, 0xF75A, 0xF73A, 0xF6F8, 0xEE95, 0xF738, 0xFF59, 
        0xFEF7, 0xFF36, 0xFF78, 0xE6D6, 0xCD91, 0xF778, 0xF757, 0xF757, 0xFF99, 0xE651, 0xDE10, 0xE693, 0xFF98, 0xFFDB, 0xFFBB, 0xFF9A, 0xFF9A, 0xFFDB, 0xFFDB, 0xFFB9, 0xFFB8, 0xFFB9, 0xFF9A, 0xFF5A, 0xF6F9, 0xF6F5, 0xF77A, 0xD718, 0x9D2D, 0x78C2, 
        0xC1E9, 0xF493, 0xF71B, 0xB3CB, 0xA3CC, 0xAC8E, 0xBD2F, 0xC48F, 0xC4AF, 0xCD11, 0xDD73, 0xF677, 0xEEB6, 0xEED7, 0xF718, 0xF779, 0xF6D7, 0xEE75, 0xEE35,
  0x8B2C, 0x936D, 0x9B8D, 0x9B6D, 0x8B4B, 0x938B, 0xA3CD, 0xBC11, 0xDCB4, 0xCCB2, 0xBC70, 0xAC2D, 0x9BE8, 0x9BE9, 0xA3EB, 0xB3EE, 0xEBF1, 0xF474, 0xFCD5, 0xF4F5, 0xDC54, 0xC3F0, 0xB38D, 0xA36C, 0xB3EF, 0xABAD, 0x932A, 0x7267, 0x59CB, 0x4969, 0x4969, 
        0x59EC, 0x626E, 0x62AE, 0x62AF, 0x6ACF, 0x8B6E, 0xA40E, 0xBC8F, 0xDCB1, 0xFD56, 0xFD56, 0xFD56, 0xFD57, 0xFD36, 0xF555, 0xFD55, 0xFD36, 0xFCF4, 0xF4F4, 0xF4D4, 0xEC92, 0xD3CF, 0xB36D, 0xA32C, 0xA32B, 0xB3AF, 0xC3F0, 0xDC51, 0xECB1, 0xE472, 
        0xF515, 0xFDF6, 0xFEF8, 0xFF7B, 0xFF7A, 0xFF7B, 0xFF3D, 0xFEDA, 0xFF39, 0xFF18, 0xF675, 0xF6F9, 0xDE98, 0xCDF7, 0xCD96, 0xD676, 0xEF7B, 0xFFFF, 0xFFFF, 0xF79D, 0xDDF6, 0xBD2F, 0x9D48, 0x7C84, 0x8CE7, 0x9D8C, 0xAE0F, 0xADAE, 0xADAE, 0x9D2C, 
        0x8C49, 0x9C89, 0x946A, 0x8C4A, 0x7C09, 0x7BE6, 0x6B86, 0x6345, 0x5303, 0x52E2, 0x41E1, 0x62C7, 0xA530, 0x9D8C, 0x4A65, 0x5A47, 0xD571, 0xFF9D, 0xFF3C, 0xF6DB, 0xF6FB, 0xFF9E, 0xDDD6, 0x832C, 0x18A2, 0x5285, 0x7AEA, 0x82AB, 0x8ACA, 0xEF38, 
        0xFEF7, 0xF5F3, 0xED70, 0xFF57, 0xEE96, 0xEE14, 0xEE54, 0xF696, 0xEE54, 0xEE54, 0xF654, 0xE5D3, 0xDD70, 0xDD2E, 0xDD0E, 0xED0F, 0xF5F3, 0xFEB5, 0xFED6, 0xFEF8, 0xFEF8, 0xFEF8, 0xFF19, 0xFEB7, 0xF676, 0xF635, 0xFDD5, 0xF5B2, 0xF572, 0xED52, 
        0xED51, 0xDC8F, 0xD4CF, 0xCCEF, 0xC4EF, 0xBD10, 0x9C4D, 0x6B07, 0x5A24, 0xD697, 0xDF19, 0xDEF9, 0xDED9, 0xC615, 0xBDD4, 0xC5F6, 0xCE78, 0xA531, 0x9D11, 0x9D31, 0x9D30, 0x8C6D, 0x7BAC, 0x6B2B, 0x52C8, 0x39A2, 0x4A24, 0x5AC7, 0x736A, 0x942C, 
        0x940C, 0xA44D, 0xB46F, 0xABF0, 0xCCF1, 0xBC4D, 0x7A65, 0xB48C, 0x9BEB, 0x6AE7, 0x3A03, 0x5243, 0x4A43, 0x3A23, 0x2A22, 0x29E2, 0x31A4, 0x6B4A, 0xC651, 0x94EA, 0x9D09, 0x8447, 0x6345, 0xEF3C, 0xFFFF, 0xFFFF, 0xFFFF, 0xEF7D, 0x836B, 0x28C1, 
        0x18A1, 0x8C28, 0x62A5, 0x51E5, 0x7B2C, 0xEF17, 0xE654, 0xDDB3, 0xD5F6, 0xCD53, 0xD5B3, 0xE635, 0xEE36, 0xA4AC, 0xB52E, 0xDE55, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFDF, 0xE71A, 0xD615, 0xCD72, 0xCD71, 0xC550, 0xD5B2, 0xD5D2, 0xC5D2, 0xEEB6, 0xF718, 0xF6F7, 0xE695, 0xEED9, 0xF71A, 0xFF3B, 0xFF19, 0xE633, 0xEF16, 0xFFBA, 
        0xFFDC, 0xFF19, 0xFF9A, 0xFFDA, 0xFF98, 0xFFB9, 0xFF78, 0xFF57, 0xF778, 0xFFD9, 0xF776, 0xF756, 0xFF99, 0xFFFD, 0xFFDC, 0xFFDC, 0xFFFC, 0xFFFD, 0xFFDC, 0xFFDB, 0xFFFB, 0xFFDE, 0xFFDC, 0xFFDB, 0xFF9A, 0xFF79, 0xFFBC, 0xFFFB, 0xE713, 0x5124, 
        0xB20B, 0xF3F2, 0xFDB6, 0xFF7D, 0xDD94, 0xCCAF, 0xC511, 0xE593, 0xE5B4, 0xE5B5, 0xEDD5, 0xF636, 0xE635, 0xE634, 0xE655, 0xE655, 0xF6B4, 0xFED5, 0xFEB6,
  0x834E, 0x8B8F, 0x93AE, 0x8B8C, 0x8369, 0x8B2B, 0x9B6D, 0xB410, 0xCC53, 0xB430, 0xABEE, 0xABAC, 0x8B88, 0x8B89, 0x93AA, 0xAB8C, 0xDBB3, 0xF434, 0xFCB5, 0xF517, 0xD452, 0xDC52, 0xD431, 0xC40E, 0xE492, 0xCC30, 0xAB4E, 0x8A6D, 0x49E9, 0x520A, 0x522B, 
        0x524B, 0x730D, 0x6ACD, 0x6AAC, 0x7AEB, 0xB431, 0xDCD3, 0xF514, 0xFD76, 0xFDB6, 0xFDB7, 0xFD97, 0xFD76, 0xFD56, 0xFD56, 0xFD76, 0xFD77, 0xFD55, 0xF515, 0xF4B4, 0xE452, 0xA32C, 0x9ACA, 0x9AAA, 0x9ACA, 0xB3EF, 0xCC51, 0xDC72, 0xDC92, 0xE490, 
        0xE4F1, 0xED94, 0xFE77, 0xFED8, 0xFF3A, 0xFF9C, 0xFFDD, 0xFFDB, 0xFFBA, 0xFFDB, 0xFFBD, 0xD635, 0xACF1, 0x8C2E, 0x840D, 0xC550, 0xD593, 0xDE57, 0xF75D, 0xFF59, 0xE6D7, 0xDE38, 0xD599, 0x7C65, 0x8487, 0x94CA, 0x952B, 0xAE0E, 0x9D6C, 0x8CEB, 
        0x94AA, 0x8C28, 0x83E7, 0x7386, 0x6B65, 0x6344, 0x6323, 0x6324, 0x5B05, 0x4241, 0x73A7, 0x8C69, 0x7407, 0x2A21, 0x63E3, 0x5B63, 0x2943, 0xE715, 0xFFDC, 0xFF3C, 0xFE39, 0xEF3C, 0x630C, 0x2982, 0x5303, 0x7385, 0x8427, 0x5B26, 0x31A4, 0xE6F9, 
        0xF694, 0xEDF0, 0xE60F, 0xC4D0, 0xC510, 0xC550, 0xB530, 0xBD91, 0xC551, 0xBD51, 0xB572, 0xC5D4, 0xC5F4, 0xD635, 0xE657, 0xDE35, 0xE614, 0xF634, 0xFE96, 0xFED8, 0xFEF8, 0xFEF8, 0xFEF9, 0xFEB7, 0xFE36, 0xFDF4, 0xF5F3, 0xED92, 0xDD51, 0xD50F, 
        0xC46E, 0xB44C, 0xB46D, 0xB46E, 0xB48E, 0xB4B0, 0x72E8, 0x7B8A, 0xCE76, 0xDDF5, 0x7B09, 0x49A4, 0x49E6, 0x18C1, 0x1880, 0x1880, 0x1080, 0x10C2, 0x1903, 0x2102, 0x2903, 0x2984, 0x3184, 0x3984, 0x3985, 0x5245, 0x5A87, 0x6AC9, 0x7B4A, 0x93AB, 
        0xA42D, 0xA44D, 0xA42C, 0xC510, 0xB4CE, 0x940B, 0x8B49, 0xDD30, 0xAC6D, 0x5AA7, 0x1081, 0x39C1, 0x41A1, 0x41E2, 0x4264, 0x2120, 0x18E0, 0x4265, 0x9CEC, 0x94CA, 0x94EB, 0x8469, 0x6B67, 0xBD54, 0xE71B, 0xFFDF, 0xFFFF, 0xF7BE, 0xC618, 0xAD54, 
        0xB571, 0x6B06, 0x4A63, 0x842B, 0xEF3A, 0xDD94, 0xE655, 0xEEB5, 0xD613, 0xBD51, 0xCDD2, 0xCDB3, 0xB551, 0xCD90, 0xEF19, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFBD, 0xFFBD, 0xFFFF, 0xFFFF, 0xFFFF, 0xF7DE, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xDEDB, 0xD697, 0xCE53, 0xD5F2, 0xEE75, 0xE634, 0xDE54, 0xEEF7, 0xFF39, 0xFF5A, 0xF759, 0xEF17, 0xF697, 0xEE97, 0xF719, 0xF79B, 0xCD90, 0xCD4F, 0xDE32, 
        0xFF98, 0xFFFE, 0xFFBB, 0xFFBA, 0xFFDA, 0xF798, 0xF7BB, 0xFFDD, 0xFFFC, 0xFFFA, 0xFFFC, 0xFFFD, 0xFFFD, 0xFFDD, 0xFFDD, 0xFFDE, 0xFFDE, 0xFFDC, 0xFFBB, 0xFFBB, 0xFFFE, 0xFFDB, 0xFFFC, 0xFFDB, 0xFF9B, 0xFF9B, 0xFFBD, 0xEEFC, 0xC4F5, 0x9905, 
        0xCB8D, 0xF593, 0xFE14, 0xFF78, 0xDE75, 0xC552, 0xC46E, 0xC530, 0xDDB3, 0xEE14, 0xEE14, 0xF656, 0xEE34, 0xE613, 0xEE32, 0xE5D3, 0xE5F4, 0xEE55, 0xFEF8,
  0x8B4F, 0x8B6E, 0x8B6E, 0x834D, 0x836A, 0x936B, 0x9B8C, 0xA3AD, 0xC3F2, 0xB3D0, 0xABCD, 0xA3EC, 0x8B69, 0x8388, 0x8BA9, 0x9B8A, 0xD370, 0xEC33, 0xF495, 0xEC95, 0xE494, 0xDC93, 0xDC72, 0xD452, 0xDC90, 0xBBCD, 0xA2EA, 0x9269, 0x8331, 0x7310, 0x5AAD, 
        0x526A, 0x7BAA, 0x83A9, 0x8B8A, 0xA3CE, 0xDCF3, 0xE533, 0xF534, 0xFD36, 0xF515, 0xED15, 0xF515, 0xF535, 0xED75, 0xED75, 0xF556, 0xFD56, 0xF555, 0xF515, 0xECB4, 0xDC33, 0xBB4C, 0xAB0B, 0x9B0B, 0x9B0B, 0xC410, 0xC430, 0xBC4F, 0xBC2E, 0xBB4C, 
        0xCC2F, 0xDD73, 0xEE76, 0xF6F9, 0xFF9C, 0xFFDD, 0xF7FC, 0xFF99, 0xF77A, 0xF79C, 0xEF7C, 0x942D, 0xA4D0, 0xCE36, 0xF79B, 0xDE57, 0xEEB7, 0xF739, 0xFF7C, 0xE6BA, 0xEF39, 0xCE52, 0x8C86, 0xADAD, 0xA58C, 0x94EA, 0x8C89, 0xCE10, 0xC60F, 0xAD4B, 
        0x8428, 0x8426, 0x7BE5, 0x73A5, 0x6B86, 0x7C46, 0x7426, 0x6344, 0x4A61, 0x8408, 0x73E8, 0x5326, 0x4221, 0x5323, 0x53A3, 0x53A2, 0x4B00, 0x10A0, 0x5A64, 0xB50E, 0xEF3B, 0x944F, 0x3A06, 0x3A44, 0x8448, 0x73E7, 0x73A6, 0x6B24, 0x5AA2, 0xBC4C, 
        0xE653, 0xEEB4, 0xDD6F, 0xBCCF, 0xDD92, 0xE634, 0xCE12, 0x9C4A, 0xA4AD, 0xACEE, 0xA4AD, 0x948D, 0x9CAF, 0x9CCF, 0xA4CF, 0xD5D3, 0xE5F4, 0xF615, 0xFE55, 0xF6D8, 0xFED8, 0xFED8, 0xFEF9, 0xF676, 0xF635, 0xF5F4, 0xEDD2, 0xED92, 0xDD30, 0xCCAD, 
        0xC44C, 0xB40B, 0xB44C, 0xB46D, 0xAC6E, 0x940C, 0x93AB, 0xAC4E, 0xB4F0, 0x20A2, 0x1020, 0x1020, 0x2041, 0x4A29, 0x3964, 0x2081, 0x1842, 0x3945, 0x2904, 0x20A2, 0x2882, 0x3124, 0x3924, 0x4125, 0x3945, 0x3964, 0x5A06, 0x6A88, 0x72EA, 0x9BEC, 
        0x9B6C, 0x8B2B, 0x8B8B, 0xCD70, 0xA42B, 0x9C0B, 0xC530, 0xBC4D, 0xABEB, 0x9BAA, 0x8BAA, 0xACAD, 0x5245, 0x2141, 0x3202, 0x29A0, 0x18C0, 0x39C3, 0x9447, 0xAD6D, 0x94EA, 0xA54D, 0xC653, 0x2984, 0x6B0C, 0xBD75, 0xEF3B, 0xFFFD, 0xFFFF, 0xFFFF, 
        0xEF5C, 0x6307, 0x7306, 0x6B06, 0x62E6, 0xEF59, 0xFF99, 0xE695, 0xBD51, 0xCDB2, 0xDE14, 0xD5D3, 0xBD51, 0xE693, 0xE6D7, 0xDEB9, 0xDEB9, 0xD698, 0xCE37, 0xC5F6, 0xC5F7, 0xCE16, 0xD678, 0xDEB9, 0xDEB9, 0xD67A, 0xCE17, 0xCE37, 0xD678, 0xA4F0, 
        0xC616, 0xC637, 0x9CD4, 0x9D14, 0xD6DA, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xE6DC, 0xE6DB, 0xEED8, 0xEE96, 0xEE76, 0xEE75, 0xE655, 0xEE56, 0xFF9B, 0xF7BA, 0xF759, 0xF6D8, 0xE6B7, 0xEED8, 0xF739, 0xF779, 0xAD4C, 0xBD8E, 0xCE11, 
        0xD675, 0xF7DD, 0xFFDC, 0xF7BB, 0xFF9A, 0xFFDB, 0xFF99, 0xFF79, 0xF7BC, 0xF716, 0xF737, 0xFF9A, 0xFFFE, 0xFFFD, 0xFFFD, 0xFFFC, 0xFFDC, 0xFFFE, 0xFFFD, 0xFFDD, 0xFFDE, 0xFFDC, 0xFFDC, 0xFFDC, 0xFFBC, 0xFFBD, 0xFFBD, 0xD5B5, 0x9226, 0xA987, 
        0xDC70, 0xF634, 0xEE32, 0xF6F5, 0xEEF7, 0xD5F5, 0xB48F, 0xC511, 0xD591, 0xE633, 0xF6D7, 0xEE34, 0xEE54, 0xF675, 0xF676, 0xFEB8, 0xE636, 0xE655, 0xFF16,
  0x832A, 0x8B6C, 0x93AD, 0x8BAB, 0x8B4A, 0x936A, 0x936C, 0xA36E, 0xBB91, 0xB410, 0xAC2F, 0xB3EF, 0xB3CD, 0xA3AB, 0x9BAB, 0xA38D, 0xC34F, 0xDBD2, 0xEC33, 0xEC73, 0xF4B5, 0xF4B4, 0xEC73, 0xE432, 0xEC72, 0xE431, 0xC3AF, 0x930D, 0x8AED, 0x8B2F, 0x730D, 
        0x5AA9, 0x8C0B, 0x8B8C, 0x8B4D, 0xA38E, 0xCC72, 0xDCF3, 0xE554, 0xF574, 0xF593, 0xED92, 0xED92, 0xED72, 0xFD15, 0xF556, 0xF576, 0xFD56, 0xFD76, 0xF535, 0xF4F4, 0xF494, 0xD410, 0xBBAE, 0xA34D, 0xA2CC, 0xB38E, 0xBBEF, 0xC42F, 0xC42F, 0xB3ED, 
        0xC42E, 0xD4F1, 0xEE15, 0xFED8, 0xFF3B, 0xFF5B, 0xF75A, 0xFFDE, 0xF7DE, 0xCE16, 0x8BC9, 0xCE95, 0xCE55, 0xCE54, 0xDEF5, 0xEF7C, 0xF6FB, 0xEE59, 0xEDF9, 0xF79B, 0xD6B6, 0xBD74, 0xB492, 0x7C64, 0x8429, 0x9C8E, 0xB5AF, 0xD66E, 0xBD8C, 0x9C88, 
        0x7BE2, 0x842C, 0x846B, 0x7C47, 0x73E5, 0x7C46, 0x6BE6, 0x6BE6, 0x7C05, 0x62E4, 0x39E1, 0x39C1, 0x52C2, 0x5B24, 0x52A2, 0x5A83, 0x62E7, 0x8405, 0x5A82, 0x41A3, 0x41A6, 0x3942, 0x7387, 0x8C69, 0x7BC6, 0x6BE5, 0x7BC7, 0xA46C, 0xBD50, 0x2944, 
        0x9CF3, 0xDE99, 0xCD32, 0xCD2E, 0xC510, 0xA42D, 0x62C5, 0x7328, 0x7B69, 0x83CA, 0x8C2D, 0x83EC, 0x8BEC, 0x83CB, 0x7B8B, 0xACAF, 0xC551, 0xDD92, 0xF593, 0xFF18, 0xFEF8, 0xFEF8, 0xFF18, 0xFE97, 0xFE56, 0xFDF5, 0xFDB3, 0xE571, 0xD4EF, 0xBC8E, 
        0xA42D, 0xB3EB, 0xB3EC, 0xB42D, 0xAC6E, 0x938B, 0xB490, 0x93AD, 0x38E2, 0x5A45, 0x6A88, 0x9C31, 0xE6BB, 0x72EC, 0x3104, 0x20A3, 0x3145, 0x2022, 0x2021, 0x4986, 0x7B2D, 0x3985, 0x3944, 0x3904, 0x28A3, 0x49C4, 0x6247, 0x7288, 0x7AC8, 0x8B8C, 
        0x9BCD, 0xAC2E, 0xB4AF, 0xA3AB, 0x9B6A, 0xAC0C, 0xD531, 0xB40C, 0xB40C, 0xB44C, 0xAC4C, 0xA3CA, 0x8B68, 0x62C5, 0x3A01, 0x4AA3, 0x4202, 0x2121, 0x2103, 0xDED4, 0xBE10, 0x9CEC, 0x94CB, 0xA54D, 0x6307, 0x5A88, 0x8BAD, 0x41C7, 0x528A, 0x632D, 
        0x52EC, 0x41E4, 0x8409, 0x7BE9, 0x39A3, 0x9C8D, 0xDE75, 0xF717, 0xE694, 0xCDB2, 0xD5D3, 0xDDF4, 0xD5B3, 0xA4EE, 0xBD10, 0xCD72, 0xC5B3, 0xC531, 0xA44E, 0x942D, 0xA4B0, 0x9CD0, 0xA4B0, 0xACB0, 0xB4B1, 0x9C90, 0xA490, 0x9C4E, 0x942C, 0x8BCC, 
        0x4A46, 0x1901, 0x1061, 0x62C8, 0x736B, 0x734B, 0x734C, 0xAD37, 0xDEFC, 0xFFDF, 0xFFFF, 0xFFFF, 0xF7BE, 0xF7BD, 0xFFFC, 0xFFBC, 0xFF9A, 0xF739, 0xF6F9, 0xFF1A, 0xFF9B, 0xFF9A, 0xF6F8, 0xE677, 0xF739, 0xF738, 0xDE32, 0xB58D, 0xCDCF, 0xC58F, 
        0xAD2C, 0xD612, 0xEF39, 0xFF9B, 0xFF19, 0xF676, 0xF6F7, 0xFF7A, 0xF7BD, 0xEE56, 0xE674, 0xEEB4, 0xF6D5, 0xE697, 0xF71A, 0xFF9C, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDC, 0xFFFD, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFBE, 0xD5F5, 0x92E6, 0xA9E8, 
        0xDCF0, 0xF694, 0xF674, 0xEE74, 0xF6D6, 0xDE14, 0xAC4F, 0xCD31, 0xE614, 0xF6D6, 0xFF57, 0xF655, 0xF6B5, 0xFEF7, 0xFED9, 0xFEB7, 0xF6B6, 0xF6B6, 0xFEB8,
  0x7B2B, 0x834B, 0x8B8C, 0x8BAC, 0x83EA, 0x93A9, 0x938A, 0x938B, 0xB36F, 0xB410, 0xB451, 0xB412, 0xBC4F, 0xC40F, 0xC3CE, 0xBB8D, 0xB32F, 0xCB91, 0xDBD2, 0xEC32, 0xF4B4, 0xF4B4, 0xECB4, 0xEC73, 0xEC11, 0xDBD0, 0xCB8F, 0xB34D, 0xA3D1, 0xABF4, 0x9BD2, 
        0x734D, 0x834A, 0x93CD, 0xAC0F, 0xBC51, 0xF4F3, 0xF515, 0xF516, 0xF536, 0xFD35, 0xED12, 0xDCD0, 0xDCCF, 0xED91, 0xF533, 0xF514, 0xF535, 0xFCF5, 0xFD16, 0xFD16, 0xF4B5, 0xDC51, 0xCBCF, 0xB38E, 0xAB6D, 0xB40E, 0xABEE, 0xA3CD, 0x9BAC, 0x936A, 
        0x9389, 0xA42C, 0xBD73, 0xF6F8, 0xF73B, 0xF77D, 0xFFFE, 0xF7BA, 0xCD91, 0xC552, 0xDEBB, 0xDDB4, 0xDE95, 0xDEB6, 0xEE36, 0xEEFC, 0xF71D, 0xF71C, 0xEF3C, 0xF719, 0xB531, 0x8C4B, 0x8CCB, 0xB571, 0xAD4E, 0xB58D, 0xD650, 0xBDCF, 0xB58E, 0xB52D, 
        0x9C8A, 0x8C24, 0x8C26, 0x83E6, 0x6BA4, 0x73A6, 0x73A5, 0x8427, 0x94EA, 0x9428, 0x9469, 0x9488, 0x8C25, 0x49E1, 0x4201, 0x4202, 0x41A2, 0x2102, 0x39C3, 0x49E2, 0x4161, 0x842A, 0x8C69, 0x8427, 0x7BA6, 0x5323, 0x8C48, 0x93C8, 0x59A2, 0x1061, 
        0x51A5, 0xA44F, 0xEF3B, 0xAC8B, 0x72A5, 0x51C3, 0x49E5, 0x840B, 0x840C, 0x8C4D, 0x9CEF, 0x940C, 0x944D, 0x9C8F, 0x9C8F, 0x6AE7, 0x7B28, 0x9C0C, 0xC552, 0xF5B4, 0xFEB6, 0xFF17, 0xFED7, 0xFE98, 0xFE56, 0xFDD4, 0xF552, 0xD4F1, 0xC48E, 0xB40C, 
        0xABAC, 0xA3AB, 0xA3AB, 0xA3AB, 0x9BCC, 0x930B, 0xA3ED, 0xA42D, 0x8B49, 0x40C2, 0x6207, 0xA4B1, 0xE71C, 0x8BF1, 0x6AEC, 0x41C7, 0x2104, 0xD63A, 0x93F1, 0x6AAC, 0x7B0D, 0x30A2, 0x3904, 0x4104, 0x30A1, 0x59E7, 0x6AA9, 0x7AEA, 0x8B0A, 0x9BAC, 
        0xB44E, 0xB48F, 0xA44E, 0x8AA9, 0xB46E, 0xCD10, 0xBC4D, 0xB46C, 0xBC6D, 0xBC6D, 0xB44B, 0x9BAA, 0x8B28, 0x6264, 0x39E2, 0x84AC, 0x5B06, 0x2141, 0x10A1, 0x73E7, 0xA4EC, 0xAD2E, 0x9D0D, 0xAD6D, 0x7C06, 0x6344, 0x6B26, 0x3164, 0x1081, 0x1881, 
        0x38E1, 0x1041, 0x51C4, 0xA46D, 0xDEF7, 0x6AE7, 0x7B29, 0xA44D, 0xBD72, 0xF695, 0xE633, 0xCDD2, 0xC591, 0xCDD2, 0xD5D3, 0xDE14, 0xDE55, 0xBDB4, 0xBD73, 0xC593, 0xD5D6, 0xD615, 0xC5D4, 0xBDB4, 0xBDB5, 0xBD32, 0xBD53, 0xB511, 0xA46D, 0xAD91, 
        0x4A67, 0x2123, 0x39E4, 0x0841, 0x0880, 0x1941, 0x3A64, 0xA40F, 0xA490, 0x8C2E, 0x738C, 0xC593, 0xEEDA, 0xFF9D, 0xFFFD, 0xFFDD, 0xFFFD, 0xFFDE, 0xF77D, 0xF75A, 0xF75A, 0xF6F8, 0xEE97, 0xFFBB, 0xF779, 0xC5D3, 0x8BEA, 0xC5CF, 0xDE6F, 0xDE50, 
        0xCDF0, 0xB530, 0xD614, 0xEED8, 0xFF3C, 0xF73A, 0xF778, 0xF777, 0xF737, 0xF737, 0xEEF7, 0xE697, 0xDE16, 0xDE74, 0xEED5, 0xF738, 0xFF7B, 0xFFBC, 0xFFBD, 0xFFDE, 0xFFFF, 0xFFBE, 0xFFDE, 0xFFFE, 0xFFDE, 0xFFDF, 0xFFDE, 0xF6B8, 0xD46D, 0x9205, 
        0xCD51, 0xF737, 0xFED5, 0xFF77, 0xE654, 0xC531, 0xAC6E, 0xDD73, 0xF6B7, 0xFF38, 0xFEF7, 0xF6B5, 0xFEB8, 0xFEDA, 0xF6FA, 0xEE56, 0xF695, 0xEE16, 0xD517,
  0x8329, 0x9BAC, 0xA3EE, 0xA42E, 0xB42F, 0xABCD, 0x9B6C, 0x934B, 0xAB8F, 0xBC10, 0xC452, 0xCC73, 0xDC93, 0xD473, 0xD411, 0xCB6F, 0xB30C, 0xC32E, 0xD391, 0xDBD2, 0xEC54, 0xEC94, 0xEC94, 0xE453, 0xDC13, 0xDBF2, 0xDC32, 0xD4B3, 0xC433, 0xC451, 0xABEF, 
        0x832B, 0x93AA, 0xB42F, 0xC492, 0xCCD2, 0xE513, 0xD4D1, 0xC48F, 0xBC6C, 0xB469, 0xAC29, 0xAC2A, 0xBC8C, 0xD4AD, 0xD4EE, 0xDCF0, 0xECD2, 0xF4F5, 0xF4F6, 0xF4D5, 0xECB4, 0xDC52, 0xCBCF, 0xB34C, 0x9AEA, 0x92CA, 0x8AC9, 0x8B0A, 0x9B4A, 0x9B2A, 
        0xABCC, 0xBC8E, 0xD551, 0xEEB6, 0xFF7B, 0xFFDE, 0xF79D, 0xBD30, 0x9C2B, 0xA48C, 0xBDCF, 0xAD4D, 0x842B, 0x6BAA, 0x7BEB, 0xBD90, 0xBCF1, 0xC4B3, 0xDD96, 0xF79D, 0xDEF8, 0xBD94, 0xA3EF, 0x7C24, 0x9CC9, 0xA52D, 0x9CCB, 0x8C25, 0x8C04, 0x83C4, 
        0x7343, 0x7B88, 0x7367, 0x73E7, 0x8488, 0x7365, 0x62E2, 0x7363, 0xA487, 0xAD29, 0x9D08, 0x94C7, 0x94A9, 0xCD4F, 0xEDB6, 0xF5D8, 0xF597, 0xF637, 0xEE34, 0xDE12, 0xCD4E, 0x8369, 0x7BA7, 0x7C06, 0x7C47, 0xDECF, 0x8BA7, 0x4121, 0x28A1, 0x62C6, 
        0x4183, 0x6246, 0xC56F, 0xC570, 0x5A88, 0x6B0B, 0xE6F9, 0xD696, 0xCE55, 0xCE35, 0xCDF5, 0xC5B6, 0xBD74, 0xACD2, 0x9411, 0xBD51, 0x9C0C, 0x8B89, 0x9C4B, 0xCD34, 0xEE58, 0xFED9, 0xFED8, 0xFE97, 0xF634, 0xEDD3, 0xDD52, 0xCC8C, 0xBC4C, 0xAC0C, 
        0x93AB, 0xA38A, 0xA38B, 0x9B6B, 0x936B, 0x9BAC, 0xC532, 0xAC8F, 0x49A3, 0x4142, 0x51C4, 0x5A06, 0x6AAB, 0xEEDC, 0xF77D, 0xA513, 0x3186, 0xDEDB, 0xC556, 0x8B4E, 0x5A48, 0x6A69, 0x6249, 0x5A28, 0x5A27, 0x6A89, 0x82EA, 0x934B, 0xA3AD, 0xB44E, 
        0xB46E, 0xBC6E, 0xBC8E, 0xD4F0, 0xCCEF, 0xC4CF, 0xBCAE, 0xB46C, 0xBC4B, 0xBC0B, 0xB3CA, 0xABA9, 0x8B27, 0x8B89, 0xACAD, 0x83A9, 0x5284, 0x39E1, 0x31A0, 0x2101, 0x7BA9, 0xB54D, 0xB56E, 0x8CAA, 0x6B85, 0x6B66, 0x840D, 0x5AC5, 0x62E5, 0x4A25, 
        0x20A1, 0x18A2, 0xA512, 0xF7BC, 0xF79B, 0xA4CD, 0x7B48, 0x7B28, 0x944B, 0xE655, 0xDE35, 0xCDF3, 0xCDF3, 0xCDB3, 0xCDD3, 0xCDD3, 0xCD92, 0xB552, 0xC593, 0xCDB4, 0xCDD4, 0xDE57, 0xCDF6, 0xC5B4, 0xCDB4, 0xC593, 0xA4D0, 0xACF1, 0xD635, 0xD6D6, 
        0x740C, 0x2984, 0x0861, 0x31E4, 0x3204, 0x31E4, 0x21A3, 0x0840, 0x18E2, 0x39C4, 0x6B09, 0xCE58, 0xCE98, 0xD6B8, 0xF718, 0xE6D8, 0xF77A, 0xFFFC, 0xFFDD, 0xF73B, 0xF71A, 0xF738, 0xF739, 0xF79B, 0xB572, 0x9C8C, 0xACED, 0xBD6D, 0xC5CF, 0xC60E, 
        0xC5EC, 0xD60F, 0xD5F2, 0xE635, 0xFF17, 0xFFBA, 0xFF9A, 0xF79A, 0xF759, 0xEE75, 0xEEB6, 0xEED7, 0xEEB6, 0xEED9, 0xEEB8, 0xEED7, 0xEF17, 0xF697, 0xFF5B, 0xFFDE, 0xFFFD, 0xFFFF, 0xFFDE, 0xFFBE, 0xFF9E, 0xFFDE, 0xFEF8, 0xFEF8, 0xEF1B, 0x9A85, 
        0xCCAD, 0xF674, 0xFED5, 0xFF99, 0xDE33, 0xBCED, 0xA44B, 0xE5D5, 0xF6B7, 0xF6F7, 0xF6B6, 0xF6D7, 0xF6B7, 0xF6D8, 0xF739, 0xFE76, 0xE5D8, 0xCCDA, 0xABBA,
  0x7B89, 0x8C0B, 0xA46E, 0xB470, 0xB48F, 0xAC4E, 0xA3ED, 0x9B8C, 0xA34E, 0xB3AF, 0xBC11, 0xD453, 0xE494, 0xEC93, 0xEC52, 0xE412, 0xC32D, 0xBB2D, 0xBB0E, 0xCB11, 0xEC52, 0xF4B5, 0xECB5, 0xE494, 0xF413, 0xE413, 0xE412, 0xE431, 0xCC72, 0xC431, 0xB410, 
        0x9BCE, 0x8BAC, 0xAC2E, 0xCC71, 0xE453, 0xD493, 0xDC72, 0xDC50, 0xCC4F, 0xAC0D, 0xAC2C, 0xB44B, 0xB48C, 0xCC8E, 0xDC8F, 0xEC92, 0xECD5, 0xFCF5, 0xFCF5, 0xFCF6, 0xFCF6, 0xE472, 0xD3F0, 0xC38E, 0xAB4C, 0x82E8, 0x8328, 0x8349, 0x8B89, 0x940A, 
        0x9C0B, 0xA44D, 0xB4D0, 0xF658, 0xFF5B, 0xDED8, 0xA52F, 0x8BC8, 0xBDB0, 0xE757, 0xEF79, 0x8C10, 0x6369, 0x7389, 0xA40F, 0xC532, 0xAC90, 0xA42E, 0xB4F0, 0xEF3B, 0xB530, 0x7346, 0x4AA2, 0xB56E, 0xAD6D, 0x94A9, 0x73C4, 0x7C08, 0x94E8, 0x9D29, 
        0x9CE9, 0x8427, 0x7BC7, 0x83E7, 0x8C27, 0x52E2, 0x9428, 0xACCB, 0xA489, 0xA4A8, 0x9CC8, 0x94A7, 0x9C68, 0xB44C, 0xB40E, 0xBC30, 0xD513, 0xE592, 0xEDD4, 0xD552, 0xA3ED, 0x62A3, 0x6362, 0x8D28, 0xC6D1, 0x7B45, 0x6161, 0x5080, 0x48E2, 0x840D, 
        0x4207, 0x5268, 0xC591, 0xEEB1, 0xACCE, 0x942E, 0xACF2, 0x8BF0, 0x840F, 0x7BCD, 0x6B2B, 0x7B6B, 0x7B6C, 0x7B4C, 0x7B4C, 0x940E, 0xACD0, 0xBCD0, 0xB46F, 0xA4B1, 0xCD32, 0xEE36, 0xFF3A, 0xFEB8, 0xF615, 0xED93, 0xDD30, 0xBC4D, 0xAC0C, 0xA3CB, 
        0x9BAA, 0x936B, 0x936B, 0x9B4B, 0x934B, 0x93AC, 0xB4CF, 0x938B, 0x28A2, 0x5A25, 0x830A, 0x7ACB, 0x49E8, 0x59E7, 0x6227, 0x6249, 0x72CC, 0xBD55, 0xAC92, 0x9B8E, 0x930B, 0x93AE, 0x9BCF, 0x9BAE, 0x936C, 0x8B6C, 0x9BAD, 0xABEE, 0xB40E, 0xB46F, 
        0xB490, 0xBCB0, 0xBCF0, 0xDD11, 0xD4F0, 0xC4CF, 0xBC8E, 0xC46D, 0xBC4C, 0xB42B, 0xABEA, 0xABEB, 0x9B89, 0x9BA9, 0xA40B, 0x6B48, 0x6B27, 0x6B27, 0x5AC5, 0x10A1, 0x4A24, 0x7BA7, 0x9C8B, 0x9CEE, 0xBE11, 0xAD6E, 0x62E4, 0x1080, 0x1900, 0x1900, 
        0x20E3, 0xE656, 0xFF9C, 0xFF5B, 0xF676, 0xEED7, 0xDDF4, 0xC551, 0xB4CF, 0xA4CE, 0xBD90, 0xD5F1, 0xD5D2, 0xD5D3, 0xDE34, 0xDE35, 0xD5D4, 0xC592, 0xD5D5, 0xD5D5, 0xD5D4, 0xEEB7, 0xD616, 0xC5D4, 0xC5D3, 0xB511, 0xBD52, 0xB551, 0xB4F0, 0xCE34, 
        0x844C, 0x3A05, 0x0881, 0x29C3, 0x29A2, 0x2163, 0x29A4, 0x5AC5, 0x4244, 0x2962, 0x2102, 0x940A, 0x8BA9, 0x83CA, 0x94CE, 0xC4CE, 0xC550, 0xBD90, 0xBDD1, 0xF7BD, 0xFFDF, 0xFFDF, 0xEF5B, 0x7B67, 0x9C6C, 0xBD70, 0xCD90, 0xB4ED, 0xB54E, 0xBDAE, 
        0xBDCD, 0xBDED, 0xC5CF, 0xC5B1, 0xC592, 0xF737, 0xFFDC, 0xFFFD, 0xFFDB, 0xF6D6, 0xFED7, 0xFF19, 0xF738, 0xCD53, 0xBD12, 0xCD93, 0xEE96, 0xFFBE, 0xF73B, 0xF71B, 0xFFBD, 0xFFFF, 0xFFDE, 0xFFDE, 0xFFFF, 0xF79D, 0xC530, 0xC530, 0xF77C, 0xEE33, 
        0xED91, 0xEDD1, 0xF694, 0xFF98, 0xDE13, 0xBCAF, 0xB46F, 0xF6B5, 0xFEF7, 0xFEB7, 0xF6B6, 0xFEF7, 0xFEB6, 0xFEF7, 0xF77A, 0xCD33, 0xB415, 0xABD9, 0xBC1E,
  0xA2EF, 0xB372, 0xBBF4, 0xC454, 0xD495, 0xCCB4, 0xBC93, 0xAC30, 0x9BAC, 0xAB8E, 0xBBD1, 0xD452, 0xECB4, 0xF473, 0xFC53, 0xF474, 0xD370, 0xC2EE, 0xC2CD, 0xCAEE, 0xDB71, 0xEC33, 0xF4B5, 0xF4B5, 0xF474, 0xF493, 0xEC93, 0xEC94, 0xE514, 0xCC52, 0xB3D1, 
        0x9BCF, 0x8B2B, 0xA3CE, 0xC471, 0xE4B1, 0xDCB1, 0xC48E, 0xAC6C, 0x9409, 0x8BC7, 0x93A7, 0x93A9, 0x9BCA, 0xB46B, 0xC48D, 0xDC90, 0xF4B3, 0xFCB6, 0xFCD5, 0xF4F5, 0xECD5, 0xEC93, 0xDC11, 0xC3B0, 0xB36E, 0x8246, 0x7A46, 0x7AA8, 0x8309, 0x9C0B, 
        0xAC4D, 0xBCAE, 0xCD51, 0xEE56, 0xD5B4, 0xB4D0, 0xA42D, 0xC5B1, 0xE6F5, 0xE736, 0xC5F1, 0x7B27, 0x52A4, 0x4AA5, 0x5B28, 0x7C0B, 0x6287, 0x6227, 0x834B, 0x8C49, 0x944B, 0xB50F, 0xEEB6, 0xF79A, 0xB5B3, 0x946C, 0x944A, 0xBECF, 0x9D6A, 0x8446, 
        0x83E4, 0x7C24, 0x7C05, 0x7384, 0x5B02, 0xA4CA, 0x9CC7, 0x9CC7, 0xACEA, 0x9CA7, 0x9CE8, 0x94E9, 0x9489, 0xB42F, 0xD413, 0xE436, 0xF4D8, 0xFE57, 0xF554, 0xCC31, 0x936B, 0x62C2, 0x6B63, 0x8487, 0x9509, 0x5A21, 0x71E1, 0x79C2, 0x61E4, 0xAD51, 
        0x4A88, 0x1081, 0x3103, 0xE6FB, 0xEE97, 0x9BED, 0x1882, 0x2061, 0x18C1, 0x08A1, 0x0821, 0x38C6, 0x3125, 0x736D, 0xE6BC, 0xC515, 0x9C10, 0xA44F, 0xBD11, 0xC512, 0xD533, 0xE5D6, 0xFEDA, 0xFE97, 0xF615, 0xED72, 0xDCCE, 0xB42D, 0xA3CB, 0x9B8A, 
        0x934A, 0x93AA, 0x934B, 0x8AE9, 0x7AC8, 0xC512, 0xAC6F, 0x6288, 0x20C3, 0x9BCD, 0xBCB0, 0xBCB1, 0xA430, 0x6ACA, 0x8B6D, 0xA410, 0xA40E, 0x7ACB, 0x8B4D, 0x934D, 0x8B0D, 0xBCD0, 0xB4B2, 0xB451, 0xAC2F, 0xA410, 0xAC6F, 0xBCAF, 0xC490, 0xCCD1, 
        0xD4F1, 0xD4D0, 0xCCAF, 0xD512, 0xD4F0, 0xD4CF, 0xCCAF, 0xBC6C, 0xB44C, 0xB44C, 0xB46B, 0xAC0A, 0xA3AA, 0x9329, 0x8307, 0x83AB, 0x8BEC, 0x7B8A, 0x5AC6, 0x2921, 0x5222, 0x5A83, 0x4244, 0x83E9, 0x94AB, 0xA52F, 0xAD31, 0x5282, 0x2921, 0x5AA8, 
        0xDE95, 0xFFBD, 0xFE79, 0xF5F6, 0xDE35, 0xC592, 0xE676, 0xEEB8, 0xDE35, 0xD5F1, 0xD5D1, 0xD5B2, 0xD5D4, 0xDE56, 0xDE16, 0xD5D4, 0xCDD3, 0xCDB4, 0xD5D4, 0xDE15, 0xDE57, 0xD616, 0xD616, 0xCDD5, 0xBD53, 0xA4CF, 0xCE57, 0x9CF3, 0x10A2, 0x08A0, 
        0x0860, 0x1902, 0x3224, 0x1101, 0x1941, 0x1961, 0x1921, 0x31C2, 0x3203, 0x3A02, 0x4243, 0xACEF, 0x7B89, 0x6306, 0x740A, 0xAC8B, 0xB4CC, 0xACCD, 0xA4CD, 0xB591, 0xDEB8, 0xCE15, 0x8BCA, 0x9C6A, 0xB52E, 0xC5B2, 0xCDD3, 0xB52D, 0xBD4E, 0xC590, 
        0xDDF1, 0xD58F, 0xC5CF, 0xBDEE, 0xB5CD, 0xDE13, 0xF739, 0xFF7A, 0xFEF8, 0xF71D, 0xF79E, 0xFF9D, 0xF6FA, 0xCD90, 0xDEB7, 0xDED8, 0xBDB2, 0xA48E, 0xD695, 0xF799, 0xFF59, 0xFFBE, 0xFFDF, 0xFFBF, 0xFF5E, 0xF6F5, 0xD56F, 0xC48D, 0xDCF0, 0xFF7C, 
        0xFED7, 0xFE34, 0xF653, 0xF6B5, 0xDDD2, 0xCD0F, 0xD530, 0xF719, 0xFEB8, 0xF696, 0xF6B5, 0xFEB6, 0xFF16, 0xFF38, 0xEE9A, 0x8AB3, 0xAB9A, 0xC43E, 0xC3FF,
  0xA370, 0xABF2, 0xBC53, 0xC494, 0xCC95, 0xCC54, 0xC413, 0xABB0, 0x8AEA, 0x930B, 0xA32C, 0xB34D, 0xCC11, 0xE433, 0xEC53, 0xE433, 0xE392, 0xDB51, 0xDB51, 0xDB71, 0xD351, 0xE413, 0xEC93, 0xEC72, 0xE434, 0xE3F3, 0xDBB1, 0xD390, 0xD3B1, 0xB34E, 0x92EB, 
        0x82EA, 0x9BCC, 0xB430, 0xCC73, 0xD473, 0xBBCD, 0xAB6B, 0x9B49, 0x8368, 0x8326, 0x8B85, 0x93E6, 0xA468, 0xC46D, 0xD4AF, 0xDCB1, 0xE4D2, 0xE494, 0xF4B5, 0xF4B5, 0xE494, 0xE493, 0xDC52, 0xCC30, 0xBBCE, 0x7A65, 0x7244, 0x7AA6, 0x8B69, 0xACED, 
        0xB50F, 0xBD10, 0xCD32, 0xDE36, 0xEEB7, 0xDE55, 0xB54F, 0xAD4D, 0xBDAD, 0xBDAF, 0xA50F, 0x7B4C, 0x5B28, 0x4AC5, 0x6246, 0x734B, 0x49C5, 0x4184, 0x5AC8, 0x6B07, 0x944B, 0xAD2D, 0xAD4E, 0xAD2E, 0xA50C, 0x9CA9, 0x9447, 0xB56A, 0xAD09, 0x9C87, 
        0x9446, 0x6424, 0x63A2, 0x6B62, 0x7B85, 0xCD8F, 0xD5CE, 0xC54B, 0x9C88, 0x9CC7, 0x9CE9, 0x9CC9, 0xA489, 0xBC0F, 0xCB90, 0xCB71, 0xCBF1, 0xD533, 0xE532, 0xDCB0, 0xA3CC, 0x7364, 0x6BE4, 0x6C05, 0x6BC6, 0xB3EA, 0x8A45, 0x71C2, 0x7AA6, 0x6B6C, 
        0x42A7, 0x2162, 0x2103, 0xCE77, 0x6AEA, 0x1841, 0x0820, 0x3965, 0x4206, 0x62EB, 0x9C31, 0x93D0, 0x5249, 0x730D, 0xEE3B, 0xFEFD, 0xDE17, 0xDE16, 0xF6FA, 0xCD95, 0xDD75, 0xEDF6, 0xFE98, 0xFE56, 0xEDF5, 0xDD92, 0xCCCD, 0xB40C, 0xA3CA, 0x9B8A, 
        0x9349, 0x8B69, 0x82E8, 0x7A88, 0x82C9, 0xD5B2, 0xB48F, 0xAC4E, 0xD572, 0xAC90, 0x9BCD, 0x8B8B, 0x93CC, 0xCDB6, 0xBD13, 0xAC90, 0xA491, 0xA44F, 0xC513, 0xCD75, 0xCD13, 0xBCB3, 0xB471, 0xB450, 0xB470, 0xBCD2, 0xC4D2, 0xCCD2, 0xD512, 0xD512, 
        0xD4F1, 0xD4F1, 0xD510, 0xCD32, 0xCCEF, 0xCCAD, 0xCCAE, 0xBC4C, 0xBC4B, 0xB46B, 0xAC8B, 0xAB88, 0xA369, 0x8B48, 0x6B07, 0x62E7, 0x6B28, 0x6B08, 0x5A45, 0x31E3, 0x5285, 0x62A4, 0x4A62, 0x6308, 0x5AE8, 0x842B, 0xBDD1, 0x2923, 0x6AC6, 0xC570, 
        0xF79D, 0xFF5A, 0xEE56, 0xDDB4, 0xCD93, 0xCE14, 0xE697, 0xE676, 0xCDB2, 0xD634, 0xDE34, 0xDE14, 0xD614, 0xD633, 0xD614, 0xC5D4, 0xB572, 0xCD93, 0xD5F5, 0xD636, 0xDE57, 0xCDD5, 0xCDD5, 0xBD53, 0xA490, 0xCE97, 0xB5D5, 0x7BED, 0x3982, 0x0840, 
        0x1922, 0x1942, 0x0080, 0x0100, 0x1941, 0x2162, 0x1963, 0x2161, 0x3223, 0x29E3, 0x2142, 0x9C4B, 0x942B, 0x8BC9, 0x9408, 0xA5A9, 0xAD88, 0xAD29, 0xA4CC, 0xCDF4, 0xA4AD, 0x9C4B, 0xACEE, 0xA4CC, 0xAD2D, 0xBD6F, 0xC5B1, 0xCD52, 0xB50F, 0xB570, 
        0xCE35, 0xCD90, 0xBD6E, 0xBD8E, 0xCDB0, 0xC613, 0xCDD3, 0xDE54, 0xF798, 0xF77A, 0xF75A, 0xF77B, 0xFFBD, 0xDEB8, 0xB552, 0xA4AF, 0xACD1, 0xC5D3, 0xC655, 0xDF18, 0xFFDD, 0xFFFD, 0xFFFC, 0xFFDC, 0xFF9B, 0xDE31, 0xDE0F, 0xDDCF, 0xDD71, 0xF6B6, 
        0xF6F7, 0xFF59, 0xF77A, 0xA429, 0x9BE9, 0xB4CE, 0xEE55, 0xFEB7, 0xEE96, 0xEE96, 0xF6B7, 0xF674, 0xF736, 0xDE35, 0xABB1, 0xBC1D, 0xBC3F, 0xBC3F, 0xC41E,
  0x932F, 0xA3B2, 0xB3F3, 0xBC15, 0xBCB6, 0xB4B2, 0xAC70, 0xA3F0, 0x9B0E, 0x8AAB, 0x8AAA, 0x9B0B, 0xB3CE, 0xD411, 0xEC53, 0xF495, 0xF3F2, 0xEB92, 0xEB92, 0xEBB1, 0xDB30, 0xE3F2, 0xF474, 0xF474, 0xE3F2, 0xDBD0, 0xD3CF, 0xCBCE, 0xB40D, 0xA3AD, 0x934D, 
        0x8B0C, 0xA38C, 0xAC0E, 0xC471, 0xE472, 0xB40D, 0xA3EB, 0xA3C9, 0x9BA9, 0x8B85, 0x8BA7, 0x8BC8, 0x9BE9, 0xC44E, 0xDC51, 0xE472, 0xDCB2, 0xD4B2, 0xE4B2, 0xECB3, 0xECF4, 0xE4B3, 0xDC92, 0xD491, 0xBC4F, 0x9B6B, 0x7AC6, 0x72A5, 0x7307, 0x944A, 
        0xA48D, 0xACD0, 0xAD12, 0xE5F5, 0xDE15, 0xB590, 0x94A8, 0xBD70, 0xCE11, 0xDE51, 0xE631, 0xB572, 0x940A, 0x8365, 0x8365, 0x62A3, 0x5286, 0x5AC9, 0x6B6A, 0x6B09, 0x7B8A, 0x7C0A, 0x7C6A, 0x8C6D, 0x840D, 0x944D, 0xB52D, 0xCDAA, 0xB589, 0x9D07, 
        0x7C45, 0x6342, 0x6322, 0x7B85, 0xB44A, 0xE511, 0xD452, 0xBC0F, 0xB46B, 0x9C69, 0x9509, 0x9588, 0x95C7, 0xA4A9, 0xA3CB, 0xA3AD, 0xB42F, 0xECF6, 0xE494, 0xCBD0, 0xAACC, 0x83C9, 0x73E5, 0x7425, 0x8467, 0x7B02, 0x7A63, 0x9AEA, 0xC3F2, 0x41A3, 
        0x39E2, 0x3A23, 0x31C2, 0x0840, 0x0000, 0x1862, 0x4967, 0x932B, 0x72C9, 0x942F, 0xEF9D, 0xF79D, 0xA492, 0x93D0, 0xD5D8, 0xFFBE, 0xFFDF, 0xEF1B, 0xCD55, 0x7AEB, 0x932C, 0xC4F2, 0xF75A, 0xFE76, 0xF5D4, 0xED52, 0xD4EF, 0xAC0C, 0xA3CB, 0xA38A, 
        0x9349, 0x934A, 0x8B0A, 0x82C9, 0x82E9, 0xB490, 0xBCF1, 0xBD31, 0xBD53, 0xCD12, 0xBCD1, 0xB48F, 0xAC4E, 0xA491, 0xAC90, 0xAC90, 0xACD1, 0xDDF6, 0xD574, 0xCD33, 0xBD13, 0xCCB1, 0xCCD2, 0xCCF2, 0xCCD1, 0xD513, 0xDD53, 0xDD33, 0xDCF3, 0xDD52, 
        0xDD51, 0xDD32, 0xDD12, 0xD530, 0xD50F, 0xD4CF, 0xD48E, 0xBC6C, 0xBC4C, 0xBC4C, 0xBC2B, 0xA3A8, 0xABCB, 0x9B4A, 0x6A45, 0x4A83, 0x5AE6, 0x6B28, 0x6328, 0x41E2, 0x5A64, 0x5AC4, 0x52C4, 0x52E6, 0x5AC6, 0x49C3, 0x2881, 0x72A6, 0xC5D5, 0xF73B, 
        0xF6B7, 0xF6D8, 0xEE96, 0xE655, 0xDE54, 0xE696, 0xDE55, 0xDE34, 0xE654, 0xDE54, 0xDE53, 0xDE33, 0xDE14, 0xE695, 0xDE34, 0xD5D4, 0xC5D3, 0xDE36, 0xD5D5, 0xDE16, 0xEEB8, 0xD5B5, 0xBD54, 0xACD2, 0xAC90, 0xE71B, 0x9470, 0x5AC8, 0x5B08, 0x3A02, 
        0x18C1, 0x10C2, 0x2984, 0x10C1, 0x18E1, 0x1921, 0x1922, 0x2162, 0x3A04, 0x4224, 0x4A24, 0x62E5, 0x7B89, 0x9BEB, 0xAC49, 0x9548, 0xADE8, 0xB5CA, 0xA4EC, 0x8BAC, 0x83A8, 0x9448, 0xBD4D, 0x9CAA, 0x9CAC, 0xAD0F, 0xC591, 0xD5D3, 0xB52F, 0xA4CD, 
        0xAD2D, 0xEF14, 0xD692, 0xC5F1, 0xC5B2, 0xB550, 0xBD71, 0xDE35, 0xFF5C, 0xFFDE, 0xFFDE, 0xFFBD, 0xF79D, 0xFFDE, 0xFFDE, 0xE71B, 0xBDB6, 0xBD71, 0xA46C, 0x8BEA, 0x946D, 0xEF9D, 0xFFFF, 0xFFDD, 0xF77B, 0xFEF8, 0xF6D6, 0xEE53, 0xDD8F, 0xDD91, 
        0xF6D6, 0xFF98, 0xF779, 0xCDF3, 0xCD90, 0xDDEF, 0xF6D0, 0xF6F6, 0xF6B7, 0xF676, 0xEE75, 0xFEDA, 0xF718, 0xD5B6, 0xA355, 0xC43E, 0xC43E, 0xC43E, 0xC43F,
  0x9331, 0xABB3, 0xBBF4, 0xC3F5, 0xBBF4, 0xBBD4, 0xABD3, 0x9BB1, 0x82ED, 0x6289, 0x62A9, 0x834C, 0xB3B0, 0xC3D0, 0xD432, 0xEC95, 0xFC13, 0xFBD3, 0xFBB3, 0xFBB2, 0xEB91, 0xF3F3, 0xF434, 0xEC53, 0xF413, 0xEBB1, 0xDB4E, 0xBAEC, 0xB34F, 0x930B, 0x82C9, 
        0x8309, 0xABEE, 0xBC30, 0xC450, 0xC44F, 0xBC4E, 0xA3AC, 0x9B8A, 0x93C8, 0x8B86, 0x8BE7, 0x9428, 0xA449, 0xAC8C, 0xCCCE, 0xE4D1, 0xECD3, 0xDC70, 0xD471, 0xDC92, 0xE493, 0xE492, 0xEC92, 0xEC92, 0xE491, 0xAC0C, 0x9B8B, 0x8B0A, 0x7AA8, 0x93EA, 
        0xA4AC, 0xAD0F, 0xC532, 0xD5B5, 0xD5B3, 0xC591, 0xB54E, 0xCD4C, 0xDE11, 0xE653, 0xD5F3, 0xAC8E, 0x9C8D, 0x946B, 0x8386, 0x3A01, 0x4241, 0x5264, 0x5267, 0x4A01, 0x5A85, 0x62A8, 0x6A69, 0x5A46, 0x83AA, 0xACCC, 0xBD4B, 0xBD89, 0xB5AB, 0x94C9, 
        0x6B42, 0x6364, 0x7B65, 0x9348, 0xBB2D, 0xDCF4, 0xC4AE, 0xB48A, 0xACA8, 0x8CE6, 0x8D07, 0x9D2A, 0xBCED, 0xABCE, 0xA36D, 0xA2EB, 0xAAAB, 0xED15, 0xD514, 0xB4D0, 0x9C8C, 0x63E2, 0x6C03, 0x83E4, 0x9B84, 0xA38B, 0x9AAC, 0x8A6A, 0x6286, 0x41A4, 
        0x49C6, 0x49E6, 0x41C5, 0x40C1, 0x3881, 0x72EB, 0xDEBB, 0x92CD, 0x7229, 0x6229, 0x6B0C, 0xDEDB, 0x8BAE, 0x8BAE, 0xEF5D, 0xF6BB, 0xB4B2, 0x82EC, 0x71E9, 0x7287, 0xAB6C, 0xDD32, 0xFF59, 0xFE96, 0xFDB4, 0xED32, 0xD4D0, 0xABEC, 0x9B8B, 0x9B4B, 
        0x9B2B, 0x9B6A, 0x936A, 0x8B2A, 0x7AEA, 0x938C, 0xA42E, 0xA46E, 0xAC4E, 0xC4F1, 0xC512, 0xBCF2, 0xBCD2, 0xDD31, 0xDD73, 0xDD95, 0xDD74, 0xDD53, 0xDD32, 0xDD12, 0xDD12, 0xDD32, 0xDD52, 0xE553, 0xE553, 0xED74, 0xF573, 0xED52, 0xDD32, 0xE532, 
        0xE512, 0xE512, 0xE533, 0xE550, 0xDD0F, 0xD4EF, 0xDCCE, 0xB44D, 0xB44D, 0xB42D, 0xB3EC, 0xABCB, 0xABCB, 0x9BAA, 0x8308, 0x41E1, 0x5285, 0x5AE7, 0x4AC7, 0x72C5, 0x6AA4, 0x5A82, 0x4A82, 0x8CCD, 0x7BA8, 0x4202, 0x2124, 0xE71B, 0xFF7C, 0xFF3A, 
        0xFEF9, 0xF657, 0xEE35, 0xE655, 0xE6B6, 0xEEB6, 0xEE96, 0xE676, 0xE696, 0xE656, 0xE656, 0xDE55, 0xDE55, 0xDE16, 0xD5D5, 0xCD94, 0xCD94, 0xDED7, 0xD636, 0xD5F6, 0xDDF7, 0xC5B4, 0xC553, 0xC553, 0xCDF5, 0xE71C, 0x630C, 0x2964, 0x52C7, 0x842A, 
        0x4224, 0x18C0, 0x18C0, 0x2944, 0x2143, 0x2122, 0x2101, 0x29C3, 0x39C3, 0x39E3, 0x3A24, 0x62A4, 0x8367, 0x93E9, 0x8C08, 0xA487, 0xB56B, 0xB58B, 0xA4E9, 0x944D, 0xACB0, 0xAC8F, 0xA44C, 0xAD0C, 0x9CAB, 0x9CAC, 0xB54F, 0xD594, 0xDDD4, 0xCD90, 
        0x9CCB, 0xBDCF, 0xCE92, 0xCE93, 0xB5D2, 0xA510, 0xBDCF, 0xDE8E, 0xEF0F, 0xFFDC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xF77D, 0xE73B, 0xD636, 0xB50F, 0x942A, 0x948E, 0xCE33, 0xF778, 0xFFFE, 0xFFFC, 0xFFDB, 0xFF37, 0xF650, 0xEE31, 
        0xF6B3, 0xF715, 0xFF35, 0xFEB6, 0xFEF6, 0xFEF5, 0xFEB5, 0xFED8, 0xFED7, 0xF694, 0xEE51, 0xF756, 0xD576, 0xB418, 0xA3DE, 0xCC3F, 0xC3FF, 0xBBFE, 0xC45F,
  0x92F0, 0x9B31, 0x9B32, 0x9B12, 0x9B32, 0x930F, 0x8AED, 0x828B, 0x8A8D, 0x92CD, 0xA32E, 0xB371, 0xBBAF, 0xD3F1, 0xEC33, 0xF473, 0xF495, 0xF435, 0xF3D4, 0xF3B3, 0xEC14, 0xE3F3, 0xE3F2, 0xD3D2, 0xC351, 0xB32C, 0xAB2A, 0x9B29, 0x9B09, 0x9B6A, 0x9BAC, 
        0xA3AD, 0xB42E, 0xC44F, 0xCC51, 0xD453, 0xBB8D, 0xABAB, 0xA3AA, 0x9BA8, 0x9409, 0x9BE9, 0x9BA9, 0x9B89, 0xBC2D, 0xCC2E, 0xD3EF, 0xD3AF, 0xB3AD, 0xB38D, 0xBBAF, 0xCC30, 0xCC70, 0xCC71, 0xCC71, 0xCC70, 0xCC6F, 0xBC6D, 0xAC0C, 0x936A, 0x6B45, 
        0x6B25, 0x7B88, 0x9C4C, 0xBD72, 0xD616, 0xD675, 0xC64E, 0xB549, 0xBD8C, 0xC58D, 0xBD6E, 0xAD50, 0xAD4C, 0xA4E9, 0x9467, 0x8426, 0x4243, 0x2962, 0x31C2, 0x41C5, 0x41E4, 0x4A44, 0x4265, 0x18A2, 0x734A, 0xBD71, 0xDE12, 0xA4C5, 0xAD05, 0xB568, 
        0xAD89, 0x7B65, 0x9C49, 0xBCAE, 0xD432, 0xEC92, 0xE4D3, 0xCCB0, 0xA429, 0x9CC7, 0x84C6, 0x84E7, 0xA4E9, 0xA44A, 0x82A7, 0x8227, 0x9AAB, 0xC32F, 0xCBB0, 0xD431, 0xC492, 0x8BC7, 0x73C5, 0x73E5, 0x7404, 0x83C4, 0x9386, 0x8B28, 0x6288, 0x31C2, 
        0x4243, 0x39A3, 0x18A2, 0xAB6B, 0xE637, 0xFF1A, 0xEDD4, 0x938D, 0xA450, 0x9C0E, 0x5A48, 0x4924, 0x5A28, 0x8B8E, 0xBCD3, 0x8B4D, 0x8B6B, 0xA3ED, 0xBCB0, 0xF5D7, 0xFE77, 0xFE97, 0xF656, 0xFE35, 0xED93, 0xDD31, 0xCCAD, 0xABCC, 0xABAB, 0xA36A, 
        0x9B2A, 0x9B29, 0x9B4A, 0x934B, 0x8B29, 0x8B0A, 0x9B8C, 0xA40D, 0xB48E, 0xB4D0, 0xBCF1, 0xB4F1, 0xACF0, 0xE554, 0xDD53, 0xCD52, 0xCD11, 0xE554, 0xDD33, 0xDD33, 0xE533, 0xE553, 0xE573, 0xE574, 0xE574, 0xDD53, 0xE573, 0xE553, 0xE552, 0xE572, 
        0xDD52, 0xDD33, 0xDD33, 0xCD0E, 0xCCEE, 0xCCCE, 0xCCAE, 0xBC6C, 0xBC6D, 0xBC4C, 0xB40B, 0xABA9, 0xB3A9, 0xABAA, 0x9389, 0x4162, 0x4223, 0x4AC5, 0x52A6, 0x6A44, 0x6A44, 0x6284, 0x62E5, 0x9CEE, 0x4A67, 0x6309, 0xEF16, 0xFFDE, 0xFEF9, 0xF677, 
        0xEE98, 0xE676, 0xE656, 0xE676, 0xE697, 0xDE77, 0xE6B7, 0xE6B7, 0xE677, 0xE656, 0xDE56, 0xE657, 0xE657, 0xCDB4, 0xCDD4, 0xCDD4, 0xC5D4, 0xDDF5, 0xD5F5, 0xD636, 0xDE58, 0xBD32, 0xBD52, 0xD657, 0xEF7C, 0xA531, 0x4246, 0x31C4, 0x7389, 0x8C8B, 
        0x39E5, 0x0880, 0x10E0, 0x2944, 0x2922, 0x2122, 0x2162, 0x2121, 0x29A2, 0x31E3, 0x3203, 0x6347, 0x7B87, 0x8367, 0x8386, 0xA56A, 0xA56A, 0x9D09, 0x8CA9, 0x9C6B, 0xA48E, 0xA48E, 0x9C4B, 0xB52B, 0x9C8A, 0x944A, 0xA4CE, 0xCD74, 0xD614, 0xCDF2, 
        0xB54E, 0xAD0F, 0xBDB1, 0xC632, 0xBE11, 0xB56F, 0xD64F, 0xEF15, 0xFF7E, 0xFFBF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFBE, 0xFFDF, 0xFFFF, 0xF7BE, 0xCDD5, 0x942D, 0x8BC9, 0xA469, 0xB52C, 0xDE75, 0xF77B, 0xFFFD, 0xFFFC, 0xFFDC, 0xF758, 0xE691, 0xEE72, 
        0xEE72, 0xF6B3, 0xFEF5, 0xF716, 0xF6D5, 0xF696, 0xF677, 0xF6D4, 0xEE72, 0xEE94, 0xFF58, 0xEE16, 0xB417, 0xAB5A, 0xC3FE, 0xBC3F, 0xBBFF, 0xBBFE, 0xBBFE,
  0x8292, 0x92D2, 0x92F1, 0x92B1, 0x92F2, 0x92D2, 0x8AAF, 0x82AD, 0x730E, 0x9330, 0xA351, 0xB391, 0xC370, 0xD3B1, 0xDC12, 0xEC33, 0xF454, 0xF434, 0xFC14, 0xFBF3, 0xEBD5, 0xE3D4, 0xE3F3, 0xEBF3, 0xCB51, 0xCB2E, 0xBB0C, 0xA2EB, 0x9B09, 0x9368, 0x8BA7, 
        0x93A9, 0xB38E, 0xBBCF, 0xCC11, 0xE432, 0xBBCE, 0xABCC, 0xA3CA, 0x9BC9, 0x93E7, 0x9BE9, 0x93E9, 0x93C8, 0xA3EA, 0xB40D, 0xC3EE, 0xD3CE, 0xC3AE, 0xBB8E, 0xBBAE, 0xC40E, 0xDC0F, 0xDC30, 0xD450, 0xD470, 0xC3EF, 0xBBEE, 0xB3ED, 0x9B8C, 0x7326, 
        0x6AE6, 0x6AE6, 0x6B28, 0xAD10, 0xCDB4, 0xDDD3, 0xCDAE, 0xAD4A, 0xC5CE, 0xCE32, 0xC5F3, 0x944B, 0x9C0A, 0x9C28, 0x9466, 0x7345, 0x4A66, 0x3A26, 0x4A85, 0x4A45, 0x4244, 0x3A43, 0x4202, 0x4A24, 0xA4AE, 0xCDD0, 0xBD6A, 0xA4E6, 0x9CE6, 0xA528, 
        0xAD4A, 0xA4CB, 0xBCCE, 0xD471, 0xD3F4, 0xE4D3, 0xDD51, 0xC56D, 0xA4E6, 0x9CC9, 0x9CA9, 0xA4A9, 0xACCA, 0xA38C, 0x92A9, 0x8A49, 0x9A8B, 0xC34D, 0xCBCF, 0xBC0E, 0x9C0B, 0x8448, 0x7424, 0x7422, 0x7C23, 0x8BCA, 0x936C, 0x7AC9, 0x4A04, 0x3A24, 
        0x5246, 0x3984, 0x2104, 0xE71B, 0xFF7B, 0xFEF8, 0xEE55, 0x9C6F, 0x7B4D, 0x8BCF, 0xCD74, 0xACD2, 0xA471, 0x93EF, 0x834D, 0xA451, 0xBD13, 0xCD33, 0xCD11, 0xD552, 0xEDF6, 0xFE77, 0xFE77, 0xFE55, 0xF5B3, 0xDD31, 0xC48E, 0xB3CB, 0xAB8B, 0xA38B, 
        0x9B4A, 0x934A, 0x9B8B, 0xA3AC, 0xA3AC, 0x7AE9, 0x7B0A, 0x93AC, 0xB4AF, 0xB4D0, 0xC512, 0xCD33, 0xD552, 0xDD54, 0xDD74, 0xE574, 0xE573, 0xED94, 0xED74, 0xE574, 0xE5B4, 0xED74, 0xED94, 0xEDB4, 0xED74, 0xE574, 0xE573, 0xE573, 0xE553, 0xE572, 
        0xE552, 0xE533, 0xDD32, 0xD511, 0xD4F0, 0xD4CF, 0xCCAF, 0xD48D, 0xBC4D, 0xB42C, 0xB40C, 0xABAB, 0xAB8A, 0xB3CB, 0xAC0C, 0x49C2, 0x4222, 0x4A83, 0x5284, 0x7204, 0x7265, 0x7B27, 0x7BCA, 0x49E4, 0x6A65, 0xAC8F, 0xF77C, 0xF695, 0xFE98, 0xF6B9, 
        0xE697, 0xE676, 0xEE97, 0xEE97, 0xE678, 0xEEB8, 0xEE97, 0xEE97, 0xEE97, 0xE696, 0xE675, 0xDE56, 0xDE36, 0xDE14, 0xDE15, 0xDE36, 0xD616, 0xCDF4, 0xD5F5, 0xD5F6, 0xCE16, 0xDE34, 0xEF3A, 0xDEB9, 0x9470, 0x18C2, 0x4205, 0x6B28, 0x73CA, 0x948C, 
        0x842B, 0x52A6, 0x1081, 0x31A2, 0x2121, 0x2122, 0x2984, 0x2964, 0x2982, 0x29C1, 0x3203, 0x7366, 0x7BA8, 0x7B67, 0x7B45, 0xB5AA, 0xA529, 0x9CC8, 0xA4A9, 0x8BEC, 0xA450, 0xA490, 0x9C4C, 0xA4E9, 0xA4CA, 0x9C6A, 0x946A, 0xB550, 0xBDB1, 0xC5F3, 
        0xCE34, 0xC551, 0xB551, 0xBDD1, 0xCE51, 0xC690, 0xCDAF, 0xDD91, 0xEE57, 0xF7DC, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFBD, 0xDED9, 0xC5F6, 0xB552, 0x9C2B, 0xD5F3, 0xFF39, 0xFF7A, 0xFF9B, 0xFF9B, 0xFFBA, 0xFFB7, 0xF68E, 
        0xE60E, 0xE630, 0xF693, 0xF6B5, 0xF6D5, 0xF695, 0xEE16, 0xF716, 0xF735, 0xFF35, 0xF6B5, 0xB413, 0xAB9A, 0xB3BE, 0xC41E, 0xBC3E, 0xC45E, 0xC45E, 0xBC1E,
  0x8A73, 0x8A74, 0x8A94, 0x8AB3, 0x7272, 0x8250, 0x8A2F, 0x824E, 0x9B12, 0xAB31, 0xC350, 0xD3B1, 0xE3D3, 0xE3D2, 0xE3D2, 0xE3F2, 0xE390, 0xE3B2, 0xE3B2, 0xE372, 0xEBF3, 0xEC12, 0xE412, 0xE3F2, 0xD42F, 0xBBCD, 0xAB6B, 0xA36B, 0x9B2B, 0x9B2B, 0x9B0B, 
        0x930A, 0xB3AC, 0xB42D, 0xBC4E, 0xC431, 0xC42E, 0xB3EE, 0xB3CC, 0xABCA, 0xA3CB, 0xA3EB, 0x9BCB, 0x9BAB, 0xAB6B, 0xB36D, 0xBB8E, 0xBB8F, 0xB3CE, 0xB3AE, 0xABEE, 0xB46F, 0xBC71, 0xBC70, 0xBCB0, 0xBD11, 0xB46E, 0xACAE, 0xA4AE, 0x8C6D, 0x73AA, 
        0x6B48, 0x5AA5, 0x49E2, 0x842C, 0xBD55, 0xD5F6, 0xC60F, 0xB587, 0xC60B, 0xB58C, 0x8C28, 0x8C4A, 0x94CA, 0xA52A, 0xA509, 0x4A41, 0x39C1, 0x4A64, 0x6B86, 0x4A26, 0x5245, 0x4A63, 0x4201, 0x4A65, 0x9CAE, 0xBD90, 0x94EA, 0xAC68, 0x9C67, 0xA529, 
        0xC62C, 0xA4A9, 0xA469, 0xC4AE, 0xED55, 0xE4F6, 0xDCD4, 0xCC70, 0xB3CC, 0xA48E, 0x952B, 0x956B, 0xA50C, 0xA48A, 0x8B09, 0x81E8, 0x8989, 0xBAAD, 0xCB2E, 0xD3D0, 0xD450, 0x938A, 0x7B89, 0x73E6, 0x7464, 0x9446, 0x7B65, 0x6283, 0x41C1, 0x4A45, 
        0x5A44, 0x4182, 0x2104, 0xE71B, 0xFF58, 0xFED6, 0xFE58, 0xE595, 0xAC50, 0x7ACB, 0x61E7, 0xB470, 0xA42F, 0xB4B1, 0xEDD6, 0xE554, 0xE553, 0xE553, 0xE533, 0xDD32, 0xEDB4, 0xF656, 0xFEB7, 0xFE55, 0xF593, 0xDD11, 0xBC8F, 0xB3EB, 0xABAB, 0xA38B, 
        0xA36B, 0xA38B, 0xA3AC, 0xA3CC, 0x9BCC, 0x938B, 0x8309, 0x82E9, 0x8B6B, 0xC511, 0xBCD1, 0xBCD1, 0xD553, 0xE575, 0xE574, 0xED94, 0xF595, 0xEDB4, 0xF5B4, 0xFDB5, 0xFDB5, 0xEDB4, 0xED94, 0xF5B4, 0xF5B4, 0xED94, 0xED74, 0xED73, 0xED73, 0xED53, 
        0xED52, 0xE532, 0xE533, 0xED31, 0xDD11, 0xD4F0, 0xDCCF, 0xBC6F, 0xBC6D, 0xBC2D, 0xB3ED, 0xABCC, 0xABAA, 0xABEB, 0xAC2D, 0x6A84, 0x4A01, 0x5243, 0x6AE6, 0x71C4, 0x8245, 0x82E7, 0x7307, 0x49A3, 0xB553, 0xF73A, 0xFEB5, 0xF6DB, 0xFEDB, 0xF6B9, 
        0xEE76, 0xEEB6, 0xEEB7, 0xEEB8, 0xEEB8, 0xF6D8, 0xEEB8, 0xEEB7, 0xEED6, 0xEE98, 0xE676, 0xE675, 0xEE75, 0xD637, 0xDE76, 0xE656, 0xDDF7, 0xD5B5, 0xE677, 0xE677, 0xD5D4, 0xEF3B, 0x83ED, 0x3142, 0x1081, 0x6B27, 0x7BEA, 0x7BEA, 0x7369, 0x8C4A, 
        0xA50C, 0x948C, 0x62C8, 0x1061, 0x10C0, 0x2122, 0x2144, 0x29C4, 0x2A03, 0x2A02, 0x3A03, 0x6B47, 0x83A9, 0x7B66, 0x6B23, 0xBE0D, 0xA50B, 0x946A, 0x9CCB, 0x8409, 0x946C, 0xA4AE, 0xA48E, 0xA46A, 0xA4AB, 0x9CAC, 0x8C8D, 0xACAD, 0xB510, 0xBD91, 
        0xD632, 0xC5B2, 0xBD50, 0xB52F, 0xBD6F, 0xD633, 0xE615, 0xDD74, 0xCD32, 0xF71D, 0xFFBF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF7DE, 0xFFFF, 0xFFFF, 0xEF7D, 0xD6B9, 0xEF53, 0xFFB8, 0xFF59, 0xFE95, 0xEEB6, 0xF6B8, 0xF6D8, 0xF6D5, 0xF6F1, 
        0xF6B0, 0xF670, 0xEE31, 0xEE32, 0xEE52, 0xEE52, 0xF652, 0xFED6, 0xFF19, 0xE5F8, 0xBBF5, 0xB3DE, 0xBBFF, 0xC41F, 0xC45E, 0xC43E, 0xBC1E, 0xBBFE, 0xC41E,
  0x8A92, 0x8A72, 0x8A92, 0x92B3, 0x7271, 0x8252, 0x8251, 0x8290, 0xAB94, 0xBBF5, 0xCC55, 0xDCB5, 0xDC53, 0xD3D1, 0xD391, 0xDB70, 0xD32E, 0xD32F, 0xD32F, 0xCAEF, 0xCB50, 0xD371, 0xD391, 0xDBD2, 0xD3B0, 0xC38E, 0xB36C, 0xA329, 0x9329, 0x9B2A, 0x92A9, 
        0x8209, 0xA2CA, 0xA32B, 0xAB6C, 0xBB8D, 0xBBEE, 0xBBCE, 0xBBAD, 0xABCC, 0xA3E9, 0x93C9, 0x93A9, 0x9369, 0x9B49, 0xAB4B, 0xB32C, 0xB30B, 0xA2AB, 0xA30B, 0xA34C, 0xABAD, 0xB3CE, 0xA38D, 0x9B4C, 0x9B2B, 0x9309, 0x9309, 0x8B09, 0x7309, 0x5AE6, 
        0x62E5, 0x5283, 0x31A1, 0x41E3, 0x7B8A, 0x9C8D, 0xAD09, 0xAD88, 0xB5AB, 0xBDAD, 0xAD4D, 0x5B86, 0x6B24, 0x8BE5, 0xA548, 0x9488, 0x734A, 0x62EA, 0x5B28, 0x5A66, 0x5286, 0x4224, 0x2981, 0x52A5, 0x942B, 0xB50D, 0xB52C, 0xD56B, 0xB528, 0xA506, 
        0xAD47, 0xBD4B, 0xB4AB, 0xB44E, 0xC473, 0xF596, 0xF617, 0xE635, 0xCDAF, 0x9447, 0x8486, 0x9509, 0xAD4D, 0xACAD, 0xA34A, 0xAAA9, 0xB2EC, 0xC36E, 0xC34D, 0xCBAE, 0xD450, 0xAD0D, 0x8CA8, 0x7445, 0x7424, 0x8C27, 0x6B27, 0x5286, 0x4A64, 0x4243, 
        0x5265, 0x39A4, 0x2103, 0xE713, 0xFFB8, 0xFF18, 0xF5F6, 0xF5F7, 0xDD94, 0xC4D1, 0xAC0D, 0xC4D2, 0xD554, 0xE5B5, 0xEDD5, 0xDD54, 0xD573, 0xDD73, 0xED74, 0xE594, 0xEDF6, 0xEE57, 0xFE96, 0xFDF5, 0xED73, 0xD510, 0xBC6D, 0xB3EC, 0xABAB, 0xAB8B, 
        0xA36B, 0xA36B, 0xA3AB, 0x9BAB, 0x9BAB, 0xABCC, 0x9B6B, 0x82E9, 0x7AA8, 0xB4AF, 0xBD11, 0xC512, 0xCD12, 0xDD53, 0xE553, 0xDD74, 0xDD94, 0xEDD5, 0xEDD5, 0xEDD5, 0xEDD5, 0xEDD4, 0xEDB4, 0xED94, 0xED95, 0xE573, 0xE573, 0xE573, 0xE574, 0xE553, 
        0xE552, 0xDD32, 0xDD32, 0xDD31, 0xDCF0, 0xD4CF, 0xD4CE, 0xC44D, 0xC44D, 0xBC6D, 0xC42C, 0xB3AB, 0xA38A, 0xA38B, 0xABAB, 0x82C6, 0x5202, 0x4A22, 0x62E5, 0x8AA7, 0x92C7, 0x61E5, 0x2924, 0xE6FB, 0xFF3B, 0xF6B7, 0xF676, 0xF6FA, 0xF6D9, 0xEE78, 
        0xEE57, 0xEE98, 0xEED7, 0xEED7, 0xF6F8, 0xEED8, 0xEEB8, 0xEEB8, 0xEED8, 0xDE57, 0xDE36, 0xE677, 0xE6D8, 0xDE35, 0xD635, 0xD616, 0xCDB5, 0xD635, 0xEE77, 0xFF1B, 0xF79E, 0xB576, 0x4A49, 0x3184, 0x6B48, 0x6B86, 0x6B87, 0x73A9, 0x7BE9, 0x842A, 
        0x846A, 0x844A, 0x7388, 0x1901, 0x0860, 0x0060, 0x00A0, 0x21C2, 0x3A04, 0x39E3, 0x3A03, 0x7387, 0x7346, 0x6B05, 0x7365, 0xCE4D, 0x9CA8, 0x8407, 0xA4EB, 0x8C0B, 0x944C, 0x9C6D, 0x9C6C, 0xA48C, 0x9C6A, 0x9C8A, 0xACED, 0xA4CB, 0xB52F, 0xBD71, 
        0xBD92, 0xCDB2, 0xC570, 0xBD2E, 0xBD4D, 0xC5B0, 0xDE53, 0xEED5, 0xFF57, 0xFFD9, 0xFFFC, 0xFFDD, 0xFFDD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFDE, 0xEF3B, 0xD5F5, 0xB530, 0xDED8, 0xFFBC, 0xFF5B, 0xEE56, 0xE656, 0xEE96, 0xEEB6, 0xF6D5, 
        0xF6D4, 0xF6B3, 0xEE51, 0xF651, 0xEE50, 0xE62F, 0xE64E, 0xF714, 0xEE36, 0xCCD9, 0xAB9D, 0xD43F, 0xCC1F, 0xBC1F, 0xBC1E, 0xBC1E, 0xBC1E, 0xBC1E, 0xBBFE,
  0x8A91, 0x8A92, 0x82B2, 0x82D1, 0x8292, 0x9272, 0x9A92, 0x9AB1, 0xB393, 0xD415, 0xE455, 0xEC54, 0xE413, 0xDBD2, 0xDB70, 0xD30D, 0xDB4E, 0xD32E, 0xCB0D, 0xBACC, 0xB2AD, 0xC32E, 0xD38F, 0xCBEF, 0xCBEF, 0xC3CE, 0xBB8C, 0xAB4B, 0x9B0B, 0xA32B, 0xAB4B, 
        0xA32A, 0x8A49, 0x9AAA, 0xA30B, 0xB34D, 0xC3EE, 0xBBCD, 0xBBCD, 0xBBED, 0xA3AB, 0xA3AC, 0xAB8D, 0xAB4C, 0xB36D, 0xBB6D, 0xBB4D, 0xB32C, 0x9ACB, 0x828A, 0x7A89, 0x7AE9, 0x83AC, 0x838B, 0x732A, 0x62E8, 0x6AA8, 0x62C7, 0x6308, 0x6328, 0x5AA7, 
        0x5286, 0x5286, 0x5AA6, 0x39C2, 0x5247, 0x6AEA, 0x7BE9, 0xB569, 0xBDAA, 0xB58A, 0xA528, 0x8445, 0x7C26, 0x8486, 0x9CE6, 0x73A4, 0x7385, 0x7BA6, 0x7387, 0x39E1, 0x31E1, 0x3A02, 0x5283, 0xA50E, 0x83AB, 0x83AB, 0xBD70, 0xD5AE, 0xB54A, 0xA507, 
        0xA4E7, 0xC58B, 0xBD6B, 0xBD2D, 0xCCD0, 0xDD74, 0xE5B6, 0xEDD7, 0xDD56, 0x9368, 0x8C27, 0x9D0A, 0xAD4D, 0x94AC, 0xA3AA, 0xB32B, 0xC30D, 0xE371, 0xD3AF, 0xC3CD, 0xBBED, 0xCC90, 0xA46C, 0x9449, 0x9C26, 0x8BC6, 0x6325, 0x42A3, 0x3262, 0x5244, 
        0x6284, 0x41C3, 0x2123, 0xE715, 0xFFB9, 0xFF18, 0xFE16, 0xF5F5, 0xF616, 0xF5F6, 0xF5B6, 0xE574, 0xE554, 0xE574, 0xEDD6, 0xEDD6, 0xED94, 0xEDB4, 0xF5F5, 0xEDD5, 0xF636, 0xF677, 0xFE97, 0xFDD5, 0xED72, 0xD4F0, 0xBC4E, 0xB40C, 0xB3CC, 0xABAB, 
        0xA38C, 0xABAB, 0xA3AB, 0xA3CB, 0xA3CB, 0xABED, 0x9BCC, 0x938B, 0x932A, 0x93CC, 0xBCB0, 0xCD12, 0xD512, 0xD532, 0xE554, 0xE594, 0xE5B4, 0xF5B6, 0xF5B5, 0xF5B5, 0xF5D6, 0xEDB5, 0xEDB5, 0xEDB5, 0xEDB5, 0xED74, 0xED93, 0xED73, 0xE553, 0xE553, 
        0xE552, 0xE532, 0xE533, 0xDD32, 0xDD12, 0xDCF1, 0xD4CF, 0xD46E, 0xC48E, 0xC46D, 0xC44D, 0xB3ED, 0xB3AB, 0xAB8A, 0xA38A, 0x9328, 0x72A6, 0x6285, 0x7AC5, 0x9B0A, 0x61A5, 0x5102, 0x7A26, 0xEF1B, 0xF6D9, 0xF656, 0xF698, 0xEEF8, 0xEE97, 0xEE77, 
        0xF6B8, 0xF6D7, 0xF6F8, 0xF719, 0xF719, 0xF6B7, 0xEEB7, 0xF6D9, 0xFF1A, 0xE675, 0xE696, 0xE6D8, 0xE6F8, 0xD635, 0xD636, 0xD636, 0xD636, 0xEE58, 0xF6FB, 0xFF9D, 0xE71B, 0x2944, 0x5AE8, 0x73C9, 0x5AC5, 0x6B88, 0x73C8, 0x7C29, 0x948B, 0x946B, 
        0x844A, 0x8429, 0x8429, 0x7409, 0x4AA7, 0x4226, 0x5AC8, 0x4B05, 0x4264, 0x39E3, 0x39E3, 0x7B88, 0x6B26, 0x6B05, 0x83A6, 0xD60D, 0x9449, 0x7BA8, 0x9C8B, 0x942A, 0x944C, 0x9C6D, 0x9C8C, 0x9C8C, 0x944A, 0x9C6B, 0xACED, 0xB52D, 0xC570, 0xC592, 
        0xB571, 0xA4ED, 0xB54E, 0xBD8E, 0xBD6D, 0xAD4C, 0xCDAF, 0xEEB3, 0xFFB9, 0xFF99, 0xFFDD, 0xFFDF, 0xFFBF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFDE, 0xE696, 0xE6B7, 0xEF3A, 0xFFDD, 0xFF99, 0xFF38, 0xF719, 0xEF3A, 0xFF98, 
        0xFF97, 0xFF78, 0xFF78, 0xFF34, 0xF6D3, 0xEE90, 0xEE4D, 0xF694, 0xB471, 0x9B74, 0xABFC, 0xBBDF, 0xBC1F, 0xB41E, 0xB3DD, 0xB3DE, 0xC45F, 0xCC7F, 0xCC5F,
  0x8A92, 0x8A72, 0x8272, 0x7A53, 0x9295, 0x8AB4, 0x92B4, 0x9AD4, 0xB392, 0xDBF3, 0xEC55, 0xECB5, 0xEC75, 0xEC54, 0xEBF2, 0xDB70, 0xDB2E, 0xD32E, 0xD32D, 0xD30D, 0xB2AD, 0xB2CD, 0xBB2E, 0xD38F, 0xDC10, 0xC40E, 0xB3ED, 0xB3AC, 0x934A, 0xA32C, 0xB32D, 
        0xB32D, 0xA2AB, 0x9289, 0x92A8, 0x9AC9, 0xBBAE, 0xBBCE, 0xB3CE, 0xB3ED, 0xB3CD, 0xB3CD, 0xABED, 0xA3CD, 0xA3AE, 0xB38E, 0xBB8E, 0xBB6F, 0xA30B, 0x8A89, 0x7208, 0x61E8, 0x72C8, 0x732A, 0x6B09, 0x6286, 0x4A23, 0x4A02, 0x4A23, 0x4244, 0x5285, 
        0x52A5, 0x52A6, 0x5AA6, 0x41E2, 0x5A86, 0x7368, 0x8C48, 0xBD6A, 0xC5CC, 0xBDCD, 0xAD6D, 0x7B67, 0x7BE5, 0x94E7, 0xAD8B, 0x73A3, 0x7368, 0x6B68, 0x5B43, 0x5B09, 0x5AC5, 0x6B46, 0x8C4B, 0x49E2, 0x2901, 0x4A05, 0x9C4C, 0xCDCD, 0xCE0C, 0xB5A9, 
        0x94E6, 0xB4E9, 0xB54A, 0xB56B, 0xB58D, 0xE535, 0xF59A, 0xFDFD, 0xEDDA, 0x73E5, 0x7464, 0x8D47, 0xA5CB, 0xCC4E, 0xBB2E, 0xAACE, 0xB2F0, 0xDB0D, 0xE410, 0xDC31, 0xBB6F, 0xBC6E, 0xACAC, 0x9CAB, 0x8468, 0x52E2, 0x5305, 0x52A5, 0x49E2, 0x5A44, 
        0x6AC5, 0x4A04, 0x2123, 0xE717, 0xFF98, 0xFF17, 0xFE76, 0xFE56, 0xFE77, 0xFE78, 0xFE16, 0xF5D6, 0xF616, 0xF617, 0xFDD7, 0xFE17, 0xFE36, 0xFE16, 0xFDF7, 0xFE36, 0xFE76, 0xFE96, 0xFE96, 0xFDB3, 0xF552, 0xDCF0, 0xB48E, 0xBC0C, 0xB3EC, 0xB3EC, 
        0xABCB, 0xABCD, 0xB3CC, 0xB3CC, 0xA3AB, 0xB40D, 0xB40D, 0xAC0D, 0xA3ED, 0xA38C, 0xABEE, 0xC491, 0xE533, 0xD553, 0xDD73, 0xED94, 0xED94, 0xEDB4, 0xED94, 0xF595, 0xF594, 0xF5D5, 0xF5D5, 0xF5D5, 0xED96, 0xFDB5, 0xF5B4, 0xF593, 0xED73, 0xF573, 
        0xF553, 0xED53, 0xED33, 0xE532, 0xE532, 0xE511, 0xD4D1, 0xD4AF, 0xCC8E, 0xBC8F, 0xBC6E, 0xBBED, 0xB3CC, 0xB3AC, 0xAB8B, 0x9BAC, 0x8B6A, 0x7B09, 0x82C8, 0xBB6D, 0x59A6, 0x630C, 0xEF5C, 0xFFDC, 0xFEDA, 0xF699, 0xFEF8, 0xF6B7, 0xF6D7, 0xF6F7, 
        0xFED8, 0xFEFA, 0xFF1A, 0xFF3B, 0xFF3C, 0xF6F9, 0xF6F9, 0xF73B, 0xFF7C, 0xE6B8, 0xF6F8, 0xF6F7, 0xE675, 0xE6B7, 0xDE77, 0xDE15, 0xDDD4, 0xFFBE, 0xF7BE, 0xA514, 0x20C2, 0x3181, 0x2961, 0x3A04, 0x7389, 0x8C4B, 0x94AB, 0x94AB, 0x8C6B, 0x94CD, 
        0x946B, 0x8429, 0x7C29, 0xC652, 0xA56F, 0x8C8C, 0x840B, 0x7385, 0x6304, 0x4A63, 0x31E2, 0x7BA8, 0x7348, 0x7345, 0x8C04, 0xD672, 0x8C2A, 0x6B47, 0x8C8B, 0x9C6D, 0x9C8D, 0x9C8D, 0x946C, 0x83CB, 0xA4CC, 0xB52C, 0xACCD, 0xBD71, 0xC571, 0x9C4D, 
        0x62C6, 0xAD71, 0xBDD0, 0xB5AE, 0xA56C, 0x8C46, 0xB54F, 0xDE14, 0xE615, 0xEDD3, 0xF71A, 0xFFBD, 0xFF7C, 0xFF7C, 0xFFDE, 0xFFFE, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFDD, 0xFFBC, 0xFFDE, 0xFF7C, 0xF77B, 0xFFFD, 0xFFFC, 0xFFBB, 0xFFBC, 0xFFBE, 0xFFBC, 
        0xFF9A, 0xFF99, 0xFFB9, 0xFFFB, 0xFF99, 0xFF57, 0xFF15, 0xEE91, 0xDDD4, 0xDD59, 0xDCDC, 0xCC7D, 0xC43E, 0xCC1E, 0xD41E, 0xC3FE, 0xB3BE, 0xB39D, 0xB3BC,
  0x7A8F, 0x7A70, 0x7A30, 0x69EF, 0x8AB2, 0x9313, 0x9B33, 0xB353, 0xC434, 0xE494, 0xECB5, 0xEC95, 0xEC73, 0xE432, 0xE3B2, 0xE351, 0xDB51, 0xDB70, 0xE391, 0xEBB2, 0xC34F, 0xBB0D, 0xBB0D, 0xC34C, 0xBBEC, 0xBBED, 0xC3CD, 0xC3AD, 0xCC31, 0xD472, 0xD432, 
        0xCBB2, 0xC32E, 0x9A49, 0x81E6, 0x8A47, 0xAB6B, 0xB3AD, 0xBC2E, 0xCCB0, 0xB36B, 0xB3ED, 0xB42D, 0xB42D, 0xD433, 0xD453, 0xCC32, 0xC3F1, 0xB36D, 0x8AAA, 0x59A6, 0x3861, 0x20A1, 0x3102, 0x3942, 0x39A3, 0x2941, 0x3162, 0x3182, 0x29A2, 0x4A23, 
        0x4A64, 0x4A65, 0x4225, 0x5285, 0x39C2, 0x39C2, 0x5AE4, 0x9D28, 0xBE0C, 0xC64E, 0xC60F, 0xA4EA, 0x9467, 0x8426, 0x7C45, 0xA509, 0x9489, 0x8429, 0x73E8, 0x41A2, 0x3962, 0x3182, 0x3981, 0x41E2, 0x62E5, 0x62C4, 0x4A01, 0x93A9, 0xD52F, 0xEE53, 
        0xE6D2, 0xA52C, 0xAC6B, 0xB48A, 0xB54A, 0xBD4D, 0xC56E, 0xD5B1, 0xE5D3, 0xCC6F, 0xABCA, 0x9BC8, 0x8C69, 0x946D, 0xA44E, 0xC40F, 0xEBF1, 0xF453, 0xBCAF, 0xAC6B, 0xBB8B, 0xCB4D, 0xCB0C, 0xCAEC, 0xC32E, 0x9349, 0x5283, 0x4263, 0x5AA5, 0x5A83, 
        0x62E4, 0x4A23, 0x2923, 0xE6F5, 0xFF38, 0xFE98, 0xFE36, 0xFE77, 0xFE57, 0xF656, 0xF657, 0xFE79, 0xFE58, 0xFE37, 0xF616, 0xF637, 0xF637, 0xF637, 0xF617, 0xF616, 0xF657, 0xFE97, 0xFE97, 0xFDF4, 0xED72, 0xDCF0, 0xCC8D, 0xB44C, 0xBC2D, 0xB3ED, 
        0xB3AB, 0xB3CB, 0xB3CB, 0xB3CB, 0xAB8A, 0xB3CC, 0xB42D, 0xB46D, 0xBC8E, 0xB44D, 0xAC2D, 0xAC2E, 0xB471, 0xDD32, 0xDD53, 0xDD54, 0xDD74, 0xE595, 0xED95, 0xEDB5, 0xF5D5, 0xEDD6, 0xEDD5, 0xF5D5, 0xF5F5, 0xF5D6, 0xF5B5, 0xF5B4, 0xF5B4, 0xED53, 
        0xED73, 0xED73, 0xE512, 0xDCF1, 0xDCF0, 0xDCF1, 0xDCB1, 0xCCCE, 0xD48E, 0xCC6E, 0xBC6D, 0xBC4C, 0xB3CC, 0xAB8B, 0xAB6A, 0xA38B, 0x8B29, 0x936A, 0xB3CC, 0x28C3, 0x730C, 0xBDB6, 0xF79D, 0xF677, 0xF697, 0xF6D8, 0xF6B8, 0xF6DA, 0xF6F9, 0xF6F9, 
        0xFED9, 0xF719, 0xF719, 0xF6F9, 0xF6F9, 0xEEFA, 0xF71A, 0xF75B, 0xFF7B, 0xE678, 0xEF1B, 0xEEFA, 0xD635, 0xE6D8, 0xDE97, 0xDE16, 0xE5D5, 0xF77C, 0xAD53, 0x5AA9, 0x18A2, 0x5A87, 0x31A3, 0x3A04, 0x7C0B, 0x9D0E, 0x8C2B, 0x6B87, 0x5B25, 0x52E5, 
        0x6BA7, 0x844A, 0x8CAE, 0x5B25, 0x5325, 0x5305, 0x5AE4, 0x7BE7, 0x5AE4, 0x4221, 0x4A42, 0x83EA, 0x6307, 0x7386, 0xB56A, 0xB54D, 0x7366, 0x6306, 0x946B, 0xACCE, 0x942C, 0x840B, 0x8C4D, 0x944C, 0xB591, 0xDED5, 0xF795, 0xC5CF, 0x62E8, 0x4183, 
        0x6A43, 0xC5CE, 0xB58E, 0x94AB, 0x8C29, 0xB52D, 0xAC4C, 0xBCCF, 0xE6D6, 0xF79A, 0xFF9B, 0xFFBD, 0xFFDE, 0xFF7C, 0xFFBD, 0xFFDF, 0xFFFF, 0xFFDF, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFDE, 0xFF9C, 0xF75A, 0xF758, 0xF758, 0xFF59, 0xFF3B, 
        0xFF3A, 0xFF5A, 0xFF9B, 0xFFBC, 0xFFBA, 0xFF98, 0xF798, 0xFF57, 0xF739, 0xF71B, 0xEEDD, 0xEE7D, 0xDDDC, 0xD59B, 0xCD9B, 0xCD1A, 0xCD1A, 0xD4FB, 0xCCBB,
  0x728C, 0x7A6D, 0x724D, 0x6A0C, 0x728D, 0x8B10, 0xA353, 0xB355, 0xCC34, 0xDC94, 0xEC94, 0xECB4, 0xE474, 0xE3F3, 0xDB91, 0xD32F, 0xE391, 0xEBD2, 0xF412, 0xEC12, 0xEC13, 0xDBD1, 0xCB8F, 0xB32E, 0xC3CC, 0xC44C, 0xBC6D, 0xC44F, 0xD472, 0xE4B4, 0xEC94, 
        0xE473, 0xD3D2, 0xAAEC, 0x9247, 0x8A26, 0xB38C, 0xB36D, 0xBBAD, 0xCC4E, 0xBB6E, 0xBB8F, 0xC3B0, 0xC3B1, 0xDC31, 0xE473, 0xDC73, 0xD432, 0xCC30, 0xB3CE, 0x9B0B, 0x71E7, 0x2081, 0x18A1, 0x2922, 0x3983, 0x29C4, 0x29A4, 0x31C3, 0x2A42, 0x5225, 
        0x4A45, 0x4A45, 0x4A24, 0x4223, 0x4243, 0x5B24, 0x8CC8, 0xB5CA, 0xAD87, 0xAD67, 0xAD89, 0xA529, 0x9CE8, 0x8C47, 0x7BA7, 0xACAA, 0x9429, 0x9429, 0xACAC, 0x52E7, 0x2963, 0x18E1, 0x2983, 0x52C5, 0x4AA3, 0x4281, 0x52E1, 0x8BCA, 0xA44D, 0xB48E, 
        0xB4CE, 0xAD8D, 0xACED, 0xB4CC, 0xB56A, 0xBE2E, 0xB52D, 0xBC4C, 0xCBCC, 0xD3AE, 0xAB8B, 0x9C09, 0x9CEB, 0x846B, 0xAC2D, 0xD3EF, 0xF3F1, 0xF4B6, 0xCC30, 0xBBCD, 0xD38E, 0xDBB0, 0xCB4F, 0xC34E, 0xCB6F, 0xA38B, 0x4B45, 0x3AE3, 0x6AC5, 0x5283, 
        0x62E4, 0x4A03, 0x2923, 0xE6F6, 0xFF1A, 0xFE7A, 0xFE37, 0xFE77, 0xFE57, 0xF657, 0xFE57, 0xFE58, 0xF638, 0xF637, 0xFE58, 0xF657, 0xF657, 0xF657, 0xFE57, 0xF637, 0xF657, 0xFE77, 0xFE77, 0xFE15, 0xED73, 0xDCF1, 0xD48F, 0xB44D, 0xBC4C, 0xBC2C, 
        0xB3EC, 0xB3EA, 0xB3EB, 0xB3EC, 0xB3EB, 0xB3CB, 0xB40C, 0xBC2D, 0xBC6D, 0xC48E, 0xC4AE, 0xB46D, 0xA40C, 0xDD13, 0xDD54, 0xD574, 0xDD74, 0xED96, 0xEDB5, 0xEDD5, 0xEDD6, 0xEDD5, 0xF5D5, 0xF5F5, 0xF615, 0xF5F6, 0xF5D5, 0xF5D5, 0xF5D5, 0xED93, 
        0xF593, 0xED73, 0xE532, 0xE532, 0xDD11, 0xDCF1, 0xDCF1, 0xCC8E, 0xCCAE, 0xCCAE, 0xC48D, 0xBC0D, 0xB3CC, 0xB3AB, 0xAB8B, 0x934A, 0x9B8B, 0x9B2A, 0x8A25, 0x6143, 0xBD34, 0xF7BE, 0xFFDE, 0xF698, 0xF6B8, 0xF6F9, 0xF6FA, 0xF6F9, 0xF71A, 0xF71A, 
        0xF6FA, 0xF71A, 0xF73A, 0xF73A, 0xF719, 0xF73A, 0xF71A, 0xF73A, 0xF77A, 0xFEFA, 0xF71B, 0xEF3B, 0xE6D8, 0xEE76, 0xE655, 0xE6D8, 0xFFBE, 0xDE99, 0x5AAA, 0x31A4, 0x5B48, 0x41E4, 0x2141, 0x2162, 0x4265, 0x7BCC, 0x3A05, 0x1920, 0x21A0, 0x3181, 
        0x4284, 0x52E5, 0x4A65, 0x10A1, 0x52C5, 0x7C09, 0x73C9, 0x7B86, 0x39E3, 0x39E3, 0x7BA6, 0x7B89, 0x62C6, 0x7BA6, 0xBDAB, 0xACEB, 0x6B46, 0x6326, 0x9C8C, 0xA48C, 0x942C, 0x7BCA, 0x73CB, 0xDE99, 0xEF7B, 0xCE77, 0x844F, 0x7B47, 0x4A04, 0x18E1, 
        0x18C1, 0xBD0B, 0xC5CE, 0xAD6E, 0x9CAC, 0xBD6E, 0xB54E, 0xB4CE, 0xBCAF, 0xF739, 0xFFDB, 0xFFDB, 0xFF9B, 0xFF39, 0xFF9A, 0xFFDB, 0xFFDD, 0xFFBE, 0xFFDE, 0xFFFE, 0xFFDD, 0xFFBE, 0xFFDE, 0xFFDC, 0xF79A, 0xFF9C, 0xFF9B, 0xFF9A, 0xF759, 0xF6F8, 
        0xFF19, 0xFF39, 0xFF59, 0xFFBC, 0xFFDB, 0xFFDA, 0xFFDA, 0xFFDA, 0xFFBA, 0xFFDA, 0xFFFB, 0xFFFA, 0xFFDC, 0xFFDD, 0xFFFD, 0xFFBB, 0xFF7B, 0xF6FA, 0xE659,
  0x726B, 0x7A8B, 0x7A6B, 0x722C, 0x728B, 0x82EC, 0x936D, 0xABD0, 0xC3D3, 0xD453, 0xE4B3, 0xE4D2, 0xF4B5, 0xEC33, 0xDBD2, 0xDB50, 0xD30E, 0xE392, 0xF3F3, 0xEC33, 0xF4D5, 0xEC94, 0xEC33, 0xE3F1, 0xBBAE, 0xCBEE, 0xDC10, 0xDC52, 0xEC73, 0xF4D4, 0xF4F5, 
        0xFCF6, 0xE452, 0xD3D0, 0xB30C, 0x8A07, 0xA30B, 0xAB6B, 0xB3AC, 0xC3EE, 0xC3EF, 0xC3AF, 0xCB90, 0xDB92, 0xBC52, 0xDCD4, 0xE4F5, 0xDCD4, 0xBC31, 0xBC92, 0xB471, 0x9BAD, 0x38E2, 0x28A1, 0x20C1, 0x20C1, 0x31A3, 0x4183, 0x41C3, 0x3A84, 0x5226, 
        0x5266, 0x5285, 0x4A44, 0x39A2, 0x73AA, 0x94AC, 0x8C69, 0x7C28, 0x8CA9, 0xAD4D, 0xC5D1, 0x9449, 0x7BE4, 0x7402, 0x8464, 0xA50A, 0x9CAA, 0x83E6, 0x5AE2, 0x5AC3, 0x41C2, 0x2920, 0x2101, 0x4A44, 0x5AA6, 0x5265, 0x5202, 0x9B8A, 0xAC2D, 0xB46E, 
        0xB42C, 0x8308, 0xBC2C, 0xEDB2, 0xEEB6, 0x9429, 0x8365, 0x93E7, 0xC54D, 0xF5F3, 0xD46E, 0xBBCB, 0xB42B, 0x8C6C, 0xB46E, 0xDC50, 0xF452, 0xCCF0, 0xB48C, 0xB46C, 0xDC51, 0xEBB3, 0xD36F, 0xD3CF, 0xEC52, 0x9289, 0x6264, 0x52A3, 0x5AC4, 0x62C5, 
        0x62E5, 0x4203, 0x2124, 0xE6FB, 0xFF1B, 0xFE79, 0xFE18, 0xFE57, 0xFE77, 0xFE78, 0xFE98, 0xF658, 0xFE78, 0xFE98, 0xFE78, 0xFE78, 0xFE78, 0xF678, 0xF677, 0xFE57, 0xFE77, 0xFE97, 0xFE97, 0xFE17, 0xED53, 0xDCD1, 0xCC8F, 0xB40C, 0xB40C, 0xBC2D, 
        0xBBED, 0xB3EB, 0xB42D, 0xB42D, 0xB3EC, 0xBC0D, 0xBC0D, 0xBC2C, 0xBC4D, 0xC490, 0xCCD1, 0xD4F1, 0xD4F2, 0xD4D1, 0xE533, 0xE554, 0xE574, 0xED95, 0xEDB4, 0xF5D5, 0xF5F5, 0xFDD5, 0xFDF5, 0xFE16, 0xF616, 0xFDF6, 0xFDF6, 0xFDD5, 0xFDB5, 0xF573, 
        0xF553, 0xF552, 0xF552, 0xED12, 0xE4F2, 0xE4F2, 0xE4F2, 0xDC8F, 0xD48F, 0xCC8F, 0xC48F, 0xBC0E, 0xB3EE, 0xB3CD, 0xABAB, 0xA40C, 0xC4B0, 0x8B4C, 0x2945, 0xE71C, 0xFFFF, 0xFFFF, 0xFFDE, 0xFEDB, 0xFEFA, 0xFF1B, 0xFF1B, 0xF73A, 0xFF3B, 0xFF5B, 
        0xFF5B, 0xFF5B, 0xFF5B, 0xFF3B, 0xF73B, 0xFF5B, 0xFF5B, 0xF75C, 0xF75D, 0xFF9C, 0xF73B, 0xF73B, 0xF75D, 0xDE57, 0xEED9, 0xFF7C, 0xE71B, 0x2104, 0x1102, 0x3225, 0x5AE7, 0x49E4, 0x3183, 0x2962, 0x1941, 0x1900, 0x31C2, 0x3A23, 0x3202, 0x3A44, 
        0x29C2, 0x31C1, 0x5243, 0x29A5, 0x31A4, 0x7389, 0xC631, 0x2123, 0x52C6, 0x7C08, 0x83C7, 0x83EB, 0x6B07, 0x8BE7, 0xCE0D, 0x948A, 0x83E9, 0x83CA, 0x8C2C, 0x8BEB, 0xB530, 0xDE97, 0xF7BD, 0xE75B, 0x6B6B, 0x18C2, 0x1061, 0x6B08, 0xBDD1, 0x9CCE, 
        0x18A2, 0x2942, 0xA50C, 0xE712, 0xDEB3, 0xA4EE, 0xB4EF, 0xBD30, 0xBD10, 0x9C2D, 0xCD51, 0xF6B7, 0xFF9C, 0xEE73, 0xF717, 0xFF7B, 0xFF5C, 0xFFBE, 0xFF9E, 0xFF9E, 0xFFBF, 0xFFBC, 0xFF9B, 0xFF5B, 0xF759, 0xFF7B, 0xFFBC, 0xFFBB, 0xF779, 0xFF9B, 
        0xFF5A, 0xFF59, 0xFF78, 0xFF18, 0xFF5A, 0xFF9B, 0xFFBB, 0xFFDA, 0xFF9A, 0xFF99, 0xFFB8, 0xFF99, 0xFFDA, 0xFFDA, 0xFFB9, 0xFFBB, 0xFFDC, 0xFFFE, 0xFFFF,
  0x7228, 0x8AAB, 0x92EC, 0x92AC, 0x6A69, 0x72AA, 0x8B0C, 0xA38D, 0xC412, 0xD453, 0xDC73, 0xDC72, 0xEC93, 0xE433, 0xDBD2, 0xDB31, 0xBAAE, 0xD330, 0xEBD3, 0xF495, 0xF4B5, 0xF4D5, 0xF4D5, 0xEC73, 0xC3CF, 0xD430, 0xDC71, 0xE491, 0xECB5, 0xF4D5, 0xF4F5, 
        0xF516, 0xE452, 0xD3D0, 0xBB6D, 0xA34B, 0xB32D, 0xBB4D, 0xBB8E, 0xC3CE, 0xB36D, 0xBB8F, 0xC3D1, 0xCBF2, 0xC3B1, 0xD433, 0xE4D5, 0xF556, 0xDCD4, 0xDD14, 0xDD35, 0xCD13, 0x938C, 0x6A68, 0x51E5, 0x5225, 0x5AA7, 0x5AA7, 0x62A7, 0x6AE8, 0x62E7, 
        0x5AE6, 0x5AE6, 0x4A84, 0x4A23, 0x52A4, 0x3A43, 0x1941, 0x3A01, 0x4A82, 0x6B64, 0x9CA7, 0xAD48, 0x9D07, 0x8CA6, 0x8C66, 0x83C6, 0xA4C9, 0xB54A, 0xACE9, 0x6B4A, 0x5AE8, 0x4A25, 0x2923, 0x3965, 0x4206, 0x5286, 0x5AA6, 0x5A23, 0x8329, 0x9BCD, 
        0x938D, 0x8B49, 0x7A86, 0x8B08, 0xBD2E, 0xE6F2, 0xC5CE, 0xACAB, 0x9BE9, 0xAB49, 0xBB8C, 0xC3CD, 0xC3EC, 0x9C6B, 0xB4AE, 0xDCF3, 0xF537, 0xE4B2, 0xC3ED, 0xCBCD, 0xEC32, 0xEC53, 0xE3F1, 0xE3D1, 0xF412, 0xDC30, 0x7B27, 0x4AA3, 0x52A4, 0x62C5, 
        0x6305, 0x4203, 0x2123, 0xE715, 0xFF5B, 0xFE9A, 0xFDF6, 0xFE77, 0xFE78, 0xFE78, 0xFE58, 0xFE77, 0xF657, 0xF657, 0xFE57, 0xF658, 0xF658, 0xF677, 0xF677, 0xFE77, 0xFE97, 0xFEB7, 0xFEB8, 0xFDF6, 0xED53, 0xDCD1, 0xC46F, 0xBC4C, 0xBC2C, 0xBC2C, 
        0xBC4C, 0xB40C, 0xB42C, 0xB42C, 0xB40C, 0xB40D, 0xBC2D, 0xBC4D, 0xB46D, 0xCCCE, 0xD4D0, 0xD4F2, 0xDD33, 0xD4F1, 0xDD32, 0xDD53, 0xDD33, 0xED95, 0xED94, 0xF594, 0xF5B4, 0xF5D5, 0xF5F5, 0xF616, 0xF616, 0xFDD5, 0xF5D5, 0xF5D5, 0xFDB4, 0xF593, 
        0xF573, 0xED53, 0xED33, 0xE532, 0xDCF2, 0xDCD1, 0xDCF0, 0xDCB1, 0xD48F, 0xD48E, 0xCC8F, 0xBC4E, 0xB40D, 0xB3CD, 0xB3AC, 0xB40D, 0x71C5, 0x6943, 0x9B2A, 0xF75C, 0xFFDE, 0xFFBE, 0xFF9E, 0xFF5B, 0xF75B, 0xF73B, 0xF73C, 0xFF7B, 0xF77C, 0xF77C, 
        0xFF7B, 0xFF5A, 0xF73A, 0xF73A, 0xF71B, 0xFF5C, 0xFF9C, 0xF79D, 0xF75D, 0xFF9C, 0xFF3B, 0xF71B, 0xF6FB, 0xE678, 0xEF3B, 0xE6D9, 0xB4D0, 0x18A2, 0x2101, 0x39C4, 0x3A46, 0x3265, 0x3203, 0x31C2, 0x2982, 0x31C3, 0x29E2, 0x31E2, 0x3204, 0x3204, 
        0x3A43, 0x4AC5, 0x6348, 0x31C3, 0x3A04, 0x4204, 0x39C1, 0x62E7, 0x7388, 0x7367, 0x6AE6, 0x7BC9, 0x6B27, 0x9429, 0xCE4F, 0x8C49, 0x7B88, 0x7348, 0x83C9, 0xC5F3, 0xEF5B, 0xFFFE, 0xE71A, 0x18E3, 0x0820, 0x1080, 0x2921, 0x7B89, 0xACEE, 0x83CB, 
        0x18A2, 0x6244, 0xB52D, 0xDEB2, 0xD630, 0x6283, 0x72E7, 0x8BAA, 0xAC6D, 0xE6F7, 0xCD91, 0xCD72, 0xF6DA, 0xFF78, 0xFF9A, 0xFF7A, 0xFF59, 0xFF9C, 0xFF9C, 0xFF7C, 0xFF9B, 0xFF9B, 0xFF7B, 0xFF5A, 0xF73A, 0xFF7A, 0xFF7B, 0xFF5B, 0xFF39, 0xF75B, 
        0xF75A, 0xFF39, 0xFF19, 0xFF79, 0xFF79, 0xFF9A, 0xFF9B, 0xFFDB, 0xFF9A, 0xFF7A, 0xFF5A, 0xFF99, 0xFF7A, 0xFF7A, 0xFF99, 0xFF79, 0xFF9A, 0xFFBB, 0xFFBB,
  0x7A48, 0x930B, 0xA36D, 0xA34C, 0x8ACA, 0x7A87, 0x72A7, 0x832A, 0xBBCF, 0xCBF1, 0xCBF1, 0xCC2F, 0xDCB3, 0xDC32, 0xCB8F, 0xC2EC, 0x9A4A, 0x9A8B, 0xB34D, 0xD452, 0xDC92, 0xDCB3, 0xE4B4, 0xEC94, 0xDC11, 0xDC11, 0xDC32, 0xDC52, 0xD453, 0xE474, 0xECB5, 
        0xECD5, 0xDC52, 0xD3B0, 0xCB8E, 0xBB8D, 0xBB8E, 0xB38E, 0xB38D, 0xBB4D, 0xBB6D, 0xB36F, 0xB390, 0xBBF1, 0xBBD1, 0xB38F, 0xB3EF, 0xC4B2, 0xD534, 0xDD55, 0xDD95, 0xD5B6, 0xB4D2, 0x9C2F, 0x8BAC, 0x7B4B, 0x7B69, 0x7B4A, 0x836A, 0x8BAA, 0x73CA, 
        0x6B69, 0x6307, 0x52A5, 0x5AA4, 0x52A4, 0x39C2, 0x1080, 0x4A61, 0x4A62, 0x4A65, 0x5AC9, 0x946B, 0xA4AA, 0xACC9, 0xB4E9, 0x9C67, 0x8C06, 0x8C68, 0xA509, 0x8C06, 0x8C28, 0x7C08, 0x6345, 0x2961, 0x39C3, 0x5286, 0x62E9, 0x8266, 0x9B0B, 0x9B2E, 
        0x828D, 0xA309, 0xA2E8, 0x9AC9, 0x9B2C, 0xD56F, 0xD58E, 0xBD0C, 0xA427, 0x9387, 0xAB88, 0xB389, 0xB389, 0xB4CD, 0xBCAE, 0xD512, 0xF5F7, 0xC48F, 0xB44B, 0xCC6D, 0xECF2, 0xEC54, 0xE472, 0xD44F, 0xCBCD, 0xE450, 0xA32B, 0x6A86, 0x42A3, 0x5AA4, 
        0x62E4, 0x4203, 0x2102, 0xE632, 0xFF3A, 0xFEDB, 0xFDF7, 0xFE57, 0xFE78, 0xFE78, 0xFE57, 0xFE57, 0xF657, 0xF657, 0xF658, 0xF637, 0xF658, 0xF677, 0xF676, 0xF636, 0xF677, 0xFEB7, 0xF6B8, 0xFDF5, 0xED73, 0xDCF1, 0xCC6E, 0xC44C, 0xBC4C, 0xB42C, 
        0xB42C, 0xB42D, 0xB40C, 0xB42C, 0xB42C, 0xBC0D, 0xBC2D, 0xBC4C, 0xBC4D, 0xD4AF, 0xD4D0, 0xD4F2, 0xDCF2, 0xDD52, 0xE552, 0xE553, 0xE554, 0xE594, 0xEDB4, 0xF5B4, 0xF5D5, 0xF5F6, 0xF5F5, 0xF5F6, 0xF5F6, 0xF5F5, 0xF5D5, 0xF5D5, 0xF5D4, 0xF573, 
        0xED73, 0xED74, 0xF554, 0xDD11, 0xDCF1, 0xDCF1, 0xDCD1, 0xDCB1, 0xD4AF, 0xD48E, 0xCC6E, 0xC44E, 0xBC2E, 0xBBED, 0xB3AC, 0x92A8, 0x8A46, 0xAC0E, 0xF77D, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFBE, 0xFF7D, 0xFF7D, 0xFF7D, 0xFF7D, 0xFF9C, 0xFFBD, 0xFF9D, 
        0xFF5B, 0xFF3A, 0xF71A, 0xF71B, 0xF73C, 0xFF7C, 0xFFBE, 0xFF9E, 0xF73D, 0xFFBD, 0xFF9D, 0xF73C, 0xF6FA, 0xFFDE, 0xF7BE, 0xA514, 0x10A2, 0x1080, 0x18C1, 0x20E2, 0x2123, 0x29A3, 0x5AE8, 0x4A87, 0x10A2, 0x4AA7, 0x4244, 0x31C2, 0x21E1, 0x4A45, 
        0x3A44, 0x3A64, 0x52C5, 0x6B49, 0x2964, 0x18A0, 0x31A1, 0x7BE9, 0x7346, 0x6B06, 0x7B89, 0x62C6, 0x6B26, 0x9469, 0xC5EE, 0x8C29, 0x840A, 0x8C0B, 0x9C4C, 0xEF5C, 0xBDF7, 0x6B4D, 0x0861, 0x0000, 0x0020, 0x0020, 0x0000, 0x1081, 0x83E9, 0x83E9, 
        0x18A1, 0x3941, 0x9C49, 0xA4EB, 0x5AE4, 0x3180, 0x1080, 0x0800, 0x20A2, 0xBD52, 0xC551, 0xCD31, 0xE594, 0xFF9C, 0xF77A, 0xF758, 0xFF58, 0xFF7A, 0xFF7B, 0xFF7C, 0xFF7B, 0xFF7A, 0xFF59, 0xFF59, 0xFF79, 0xFF9B, 0xFF9B, 0xFF9B, 0xFF79, 0xFF9A, 
        0xF77A, 0xF719, 0xF6D7, 0xEEB6, 0xF6D6, 0xF6F7, 0xF738, 0xFF79, 0xFFBA, 0xFFDA, 0xFFFC, 0xFFFC, 0xFFDB, 0xFFDB, 0xFFDC, 0xFF9A, 0xFFBB, 0xFFBB, 0xFF9A,
  0x8288, 0x9B0A, 0xA36C, 0xABAE, 0xAB8C, 0x8B09, 0x72C6, 0x62C5, 0xA3CC, 0xB3AF, 0xBBAF, 0xCC0E, 0xDCB4, 0xE474, 0xDBD2, 0xC30F, 0xA22A, 0x9209, 0x9A6A, 0xAB4D, 0xECB4, 0xE494, 0xDC94, 0xECD5, 0xEC53, 0xE411, 0xDC11, 0xE432, 0xDBF2, 0xDC12, 0xE433, 
        0xF495, 0xF494, 0xEC52, 0xDC11, 0xD3D0, 0xD3B0, 0xCB90, 0xC34E, 0xB32D, 0xB36E, 0xB36F, 0xB38F, 0xB3CF, 0xCC33, 0xB38F, 0x9B2D, 0x9B8E, 0xDCF3, 0xDD35, 0xDD96, 0xE5F7, 0xDD74, 0xC4F3, 0xB491, 0x9C50, 0x8BCC, 0x93ED, 0x942D, 0x8C2C, 0x9C8F, 
        0x8C2C, 0x7BC9, 0x7348, 0x5AE4, 0x5AA5, 0x5A86, 0x4A45, 0x29A2, 0x39C3, 0x5286, 0x7BC9, 0xA4EB, 0xA4C8, 0x9465, 0x8BE3, 0x8BC4, 0x8C47, 0x9D2A, 0xBE0D, 0x9488, 0x7364, 0x62E3, 0x62A5, 0x2941, 0x41E4, 0x5A85, 0x62A5, 0x8A89, 0x8A89, 0x8AEA, 
        0x934C, 0xA30D, 0xAB2D, 0xA30B, 0x92A7, 0x8AA7, 0xA3A9, 0xAC29, 0xAC28, 0x9409, 0xABCA, 0xC38A, 0xBB6A, 0xB44C, 0xC48F, 0xDD12, 0xED54, 0xA329, 0xD490, 0xF555, 0xF4B4, 0xF474, 0xEC32, 0xE411, 0xE411, 0xEC32, 0x9B0B, 0x62A5, 0x52C3, 0x62E4, 
        0x62C5, 0x4203, 0x2142, 0xD5B2, 0xF73A, 0xFF1B, 0xFDF6, 0xFE97, 0xFE78, 0xFE78, 0xFE98, 0xFE77, 0xFE57, 0xFE77, 0xFE78, 0xFE58, 0xFE57, 0xFE77, 0xFE77, 0xFE57, 0xFE77, 0xFEB7, 0xFEF8, 0xFDD4, 0xED33, 0xE4D1, 0xDC8F, 0xAC2C, 0xBC4D, 0xBC2D, 
        0xB3EB, 0xB40C, 0xB40C, 0xB40C, 0xBC0D, 0xBC2D, 0xBC4D, 0xBC4D, 0xBC4D, 0xCCB1, 0xDCD1, 0xDCF2, 0xDD13, 0xE553, 0xED74, 0xF594, 0xFD94, 0xF595, 0xFDB5, 0xFDD5, 0xFDF5, 0xFDF6, 0xFDD6, 0xFE16, 0xFE77, 0xFDF6, 0xFDF6, 0xFDF5, 0xFDD4, 0xFD74, 
        0xF573, 0xF553, 0xFD54, 0xE533, 0xE512, 0xE512, 0xE4F2, 0xDC90, 0xDC90, 0xD490, 0xC48F, 0xC44F, 0xC42F, 0xC44F, 0xC40E, 0x9AA9, 0xA38C, 0xCD74, 0xF7BE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFBF, 0xFFBF, 0xFFDE, 0xFFDF, 0xFFBE, 0xFFBE, 
        0xFFBE, 0xFF1B, 0xFF3B, 0xFF7C, 0xFF9D, 0xFF7D, 0xFFBE, 0xFFFF, 0xFFDF, 0xF79F, 0xF79E, 0xFFBE, 0xFFFF, 0xEF5D, 0x5AEB, 0x0841, 0x0820, 0x2121, 0x1921, 0x08A1, 0x0020, 0x1081, 0x4206, 0x5287, 0x4203, 0x3A04, 0x4265, 0x4244, 0x31E3, 0x4AA6, 
        0x4A85, 0x4243, 0x4242, 0x7BCA, 0x4225, 0x31A4, 0x62E7, 0x52C3, 0x6B25, 0x7B89, 0x83AA, 0x6AE8, 0x7327, 0x9448, 0xBDAC, 0x8C09, 0xB4EF, 0xDE56, 0xE73B, 0x5AA8, 0x2103, 0x39E6, 0x844D, 0x83C9, 0x944D, 0xAD10, 0xB5B2, 0xAD30, 0xC56F, 0xCD8E, 
        0xBD4E, 0x9CD0, 0x9CAD, 0x946B, 0x83E8, 0x6B45, 0x7B26, 0x940C, 0xA595, 0xACAD, 0xD5B1, 0xEE53, 0xEE73, 0xFF38, 0xFF9A, 0xFF39, 0xFE76, 0xF6B6, 0xFF18, 0xFF58, 0xFF37, 0xFF3A, 0xF75A, 0xF77A, 0xFF5B, 0xFF37, 0xFF58, 0xFF7A, 0xFF7A, 0xFF7B, 
        0xFF7B, 0xFF79, 0xFF58, 0xEEF7, 0xEE95, 0xEE53, 0xE633, 0xEE95, 0xEEB5, 0xEEB5, 0xE6D6, 0xEEF8, 0xEED7, 0xEED6, 0xEED7, 0xFF59, 0xFF78, 0xFF98, 0xFFDB,
  0xA30A, 0xA36C, 0xABCC, 0xABEC, 0xA3EC, 0x8309, 0x7287, 0x72A8, 0x9B8B, 0xAB6E, 0xB38F, 0xBBCF, 0xD410, 0xCBAF, 0xBB4D, 0xA2CB, 0x69A6, 0x5924, 0x5944, 0x7228, 0xB3CF, 0xBC11, 0xC3F1, 0xCBF0, 0xDBD3, 0xDC12, 0xE3F2, 0xDBB1, 0xC3AE, 0xB34E, 0xB32E, 
        0xC34E, 0xBB6E, 0xC38E, 0xCBAF, 0xDBD1, 0xDBD0, 0xDB6F, 0xCB0E, 0xB2AC, 0xA2AC, 0xB30E, 0xB30F, 0xB30F, 0xABCF, 0x934C, 0x7288, 0x49E5, 0x93AE, 0xB4B2, 0xC553, 0xD595, 0xE658, 0xD5D6, 0xC574, 0xB533, 0xA490, 0xA48F, 0xA48E, 0x9C8E, 0xA50F, 
        0x9C8D, 0x842B, 0x6BA8, 0x6326, 0x52C4, 0x52A3, 0x5AA3, 0x2160, 0x2940, 0x31C2, 0x4266, 0x6B4A, 0x844A, 0x8C89, 0x7BE6, 0x7305, 0x6B07, 0x732A, 0x838C, 0xBDAE, 0xBDAD, 0xA4EA, 0x83E8, 0x7327, 0x5A86, 0x5267, 0x6AC9, 0x9AE9, 0x9B0C, 0x92EC, 
        0x92AA, 0xA38F, 0xA34D, 0x9ACA, 0x9269, 0x9286, 0x9307, 0xA367, 0xABA7, 0x93A6, 0x9386, 0xA386, 0xB3A7, 0xCBEA, 0xDC4D, 0xE490, 0xDCB1, 0xBBEF, 0xD4B1, 0xE553, 0xF554, 0xF4D4, 0xF474, 0xE412, 0xCBAF, 0xCC2E, 0xAB2B, 0x7AA7, 0x4AC3, 0x62C4, 
        0x62C5, 0x4A44, 0x3181, 0x840A, 0xD677, 0xFEFB, 0xFDD8, 0xFEB8, 0xFE97, 0xFE78, 0xFE99, 0xFE77, 0xFE57, 0xFE57, 0xF657, 0xF636, 0xF637, 0xF656, 0xFE56, 0xF678, 0xFE77, 0xFE56, 0xFE15, 0xFD93, 0xED32, 0xE4D0, 0xDC8E, 0xB42D, 0xBC6D, 0xBC4C, 
        0xB3CB, 0xB3CB, 0xB3EC, 0xB3EC, 0xB3CC, 0xB40C, 0xBC2D, 0xBC4D, 0xC46D, 0xCCD0, 0xD4D1, 0xDCF2, 0xE552, 0xE574, 0xED94, 0xF5B4, 0xF5B4, 0xFDB6, 0xF5D5, 0xF5F4, 0xF5F5, 0xFDF5, 0xFE36, 0xF657, 0xFE56, 0xFDD6, 0xF5D6, 0xF5D5, 0xF5B4, 0xF594, 
        0xED73, 0xF553, 0xF554, 0xE533, 0xE512, 0xDCF1, 0xDCF1, 0xDC90, 0xD490, 0xD490, 0xCC8E, 0xC42E, 0xC44E, 0xC44E, 0xC40E, 0xA2C9, 0x9B0A, 0xBCD2, 0xF79E, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFFF, 0xFFDE, 0xFF9D, 0xFF9D, 
        0xFF9D, 0xF71B, 0xF75C, 0xF79C, 0xF79C, 0xF73D, 0xFF9E, 0xFFDF, 0xFFDF, 0xF7BE, 0xFFDE, 0xFFFF, 0xE71C, 0x18E3, 0x0000, 0x18A1, 0x3963, 0x18A1, 0x1081, 0x10A1, 0x1081, 0x0881, 0x3184, 0x4A05, 0x41E4, 0x31A3, 0x4244, 0x4A84, 0x3A24, 0x4AC5, 
        0x4AA5, 0x4AA4, 0x52A4, 0x52E6, 0x4A64, 0x5284, 0x6B25, 0x5262, 0x6B07, 0x7B89, 0x7B89, 0x62E7, 0x7B88, 0x9448, 0xA508, 0xB54E, 0xDEB7, 0xCE16, 0x7B6B, 0x41E2, 0x7BC9, 0xAD2D, 0xB56D, 0xCDD0, 0xD631, 0xE6D3, 0xFFB6, 0xF712, 0xF6F2, 0xF6F4, 
        0xF737, 0xF79A, 0xDF16, 0xD6B3, 0xCE4F, 0xB4EC, 0xCDB1, 0xE6D6, 0xF798, 0xE612, 0xF694, 0xFF57, 0xFFDA, 0xFF17, 0xFEF7, 0xF6D6, 0xF695, 0xF6D7, 0xFEF7, 0xFF17, 0xFF37, 0xF737, 0xFF59, 0xFF59, 0xFF59, 0xFF18, 0xFF38, 0xFF38, 0xFF39, 0xFF59, 
        0xFF58, 0xFF57, 0xFF37, 0xF6F6, 0xEE95, 0xE654, 0xE634, 0xE655, 0xEE56, 0xEE35, 0xE615, 0xEE55, 0xF675, 0xF695, 0xEE95, 0xEE75, 0xEE95, 0xEEB6, 0xF6D7,
  0xAAAB, 0xAB2C, 0xA36C, 0x9B8B, 0x938A, 0x7AE7, 0x6AA6, 0x6AA7, 0x9B6D, 0xAB8E, 0xBB8F, 0xBB8F, 0xB38D, 0xAB2B, 0x9AA9, 0x7A07, 0x5964, 0x40E2, 0x3861, 0x3861, 0x6288, 0x82EB, 0x9B0C, 0xBB6F, 0xD3D1, 0xE412, 0xEC53, 0xEC33, 0xBB2E, 0xAB0D, 0xA2CC, 
        0x9A8B, 0x8A08, 0xA28A, 0xB30D, 0xC38F, 0xD3B0, 0xD38F, 0xC32D, 0xAA8A, 0x81C8, 0x9ACC, 0xAB6E, 0x9B2D, 0xA2EC, 0x8AAB, 0x61E7, 0x30E1, 0x4A05, 0x7B2A, 0x9C0E, 0xACB2, 0xD595, 0xCD74, 0xC533, 0xBCD2, 0xA4AE, 0xA48E, 0xA4AF, 0xA4F1, 0xACEF, 
        0xA4AD, 0x8C4B, 0x7BA9, 0x6B28, 0x6306, 0x52A5, 0x4A44, 0x4A25, 0x31C4, 0x31C5, 0x4A28, 0x4A65, 0x6325, 0x6323, 0x52A1, 0x6B85, 0x6B46, 0x6AE6, 0x72C5, 0x7363, 0x7BA5, 0x7BA6, 0x7B86, 0xA42F, 0x9BEE, 0x8B8D, 0x832C, 0x6A44, 0x7A66, 0x928A, 
        0xAACD, 0xA38D, 0x9B2B, 0xA2CB, 0xB2CD, 0xAB0A, 0xB369, 0xB388, 0xAB87, 0x9B86, 0x93E5, 0x9C06, 0xABC7, 0xBB48, 0xD46C, 0xDC8E, 0xBB6D, 0xA34E, 0xCC51, 0xE4F3, 0xECF5, 0xE474, 0xE453, 0xD3F1, 0xC36E, 0xD3CE, 0xB3AC, 0x8348, 0x52E3, 0x5AA4, 
        0x5AA4, 0x5283, 0x4221, 0x62A5, 0xC5B4, 0xF6FB, 0xFE18, 0xFE78, 0xFE98, 0xFE78, 0xFE77, 0xFE57, 0xFE57, 0xFE57, 0xF636, 0xF636, 0xF636, 0xF636, 0xFE77, 0xF657, 0xFE56, 0xFE36, 0xFDF5, 0xFDD4, 0xED32, 0xDCD0, 0xCC6D, 0xBC2C, 0xBC2C, 0xBC0C, 
        0xB3AB, 0xB3AB, 0xB3AB, 0xB3CB, 0xABCB, 0xB3AC, 0xBBED, 0xBC2C, 0xBC4C, 0xD4B0, 0xD4F2, 0xDD12, 0xE553, 0xED94, 0xED94, 0xF5B4, 0xF5B5, 0xF5D5, 0xF5D5, 0xF5D5, 0xF5D5, 0xF5F5, 0xF616, 0xF636, 0xF636, 0xF5F6, 0xF5D6, 0xF5D6, 0xF5D5, 0xF575, 
        0xF575, 0xED74, 0xED32, 0xE533, 0xE512, 0xDCF2, 0xD4F1, 0xDCB1, 0xD4B1, 0xD490, 0xCC6E, 0xBC4E, 0xC42E, 0xC42E, 0xBC0E, 0xA2C9, 0x9B0A, 0xBCD2, 0xF79D, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDE, 0xFFDE, 0xFFBE, 0xFF9E, 0xFF9E, 
        0xF79D, 0xF73B, 0xF73B, 0xF75C, 0xF75C, 0xF71B, 0xFF7D, 0xFFDF, 0xFFFF, 0xFFFF, 0xF79E, 0xA4F3, 0x1082, 0x0820, 0x2923, 0x3163, 0x20C2, 0x20C2, 0x18A2, 0x10A1, 0x10C1, 0x18C1, 0x3184, 0x39A4, 0x2963, 0x3204, 0x3A24, 0x4244, 0x4245, 0x4285, 
        0x4284, 0x4263, 0x4243, 0x5B67, 0x6306, 0x52A4, 0x4A83, 0x5AC4, 0x6B07, 0x7B69, 0x83AA, 0x62C7, 0x83C7, 0x9468, 0x94C9, 0xE6F5, 0x9CCD, 0x5285, 0x3162, 0x9CAB, 0xAD2C, 0x9C8A, 0x83A7, 0xACEC, 0x9C8A, 0xA4AB, 0xC56F, 0xCDEE, 0xDE50, 0xEED4, 
        0xFF37, 0xF778, 0xF778, 0xF7B8, 0xF7B6, 0xDE91, 0xEF36, 0xEF16, 0xD632, 0xDE52, 0xEEB5, 0xFF16, 0xFF77, 0xF798, 0xEED6, 0xEE74, 0xF6B5, 0xFEF7, 0xF6D6, 0xF6D6, 0xFF17, 0xFF37, 0xFF37, 0xFF18, 0xFEF9, 0xFF17, 0xFF17, 0xFF18, 0xFF18, 0xF717, 
        0xF718, 0xFF5A, 0xFF7C, 0xFF37, 0xEED5, 0xEE76, 0xF657, 0xEE36, 0xF677, 0xF677, 0xF657, 0xF678, 0xF676, 0xEE55, 0xE653, 0xE634, 0xE614, 0xE634, 0xEE75,
  0x930A, 0x934B, 0x9B6C, 0x938B, 0x7B49, 0x7309, 0x72C9, 0x72AA, 0xA34E, 0xAB6F, 0xB38F, 0xBBB0, 0xB36E, 0xAB2C, 0x92AB, 0x7249, 0x5983, 0x5123, 0x30C2, 0x1881, 0x61C6, 0x61E8, 0x724A, 0x9AEC, 0xC3CF, 0xDC31, 0xEC73, 0xF474, 0xDC11, 0xB30D, 0x9A8B, 
        0xA2AB, 0x8A69, 0x8228, 0x8228, 0x9A8A, 0xBB50, 0xC38F, 0xC3AF, 0xC36F, 0x7166, 0x79C8, 0x926C, 0xA2EF, 0x8B6B, 0x7B2B, 0x6AA9, 0x5224, 0x18A1, 0x41E6, 0x6B0A, 0x83AD, 0xACB1, 0xB4F2, 0xBCF1, 0xB4D1, 0xA48F, 0xA490, 0xA48F, 0x9C8F, 0xA4D0, 
        0xA4CE, 0xA46D, 0x9BEC, 0x736A, 0x6B26, 0x5AA4, 0x4204, 0x4A65, 0x4A66, 0x4A66, 0x4A65, 0x4A45, 0x5A4C, 0x6290, 0x630F, 0x4209, 0x5AA9, 0x62C9, 0x52A9, 0x732A, 0x7B4B, 0x7B6C, 0x7BAC, 0x6A65, 0x72A5, 0x8326, 0x8B46, 0x6A8A, 0x6A48, 0x7267, 
        0x8B0A, 0xABAE, 0xAB8F, 0xB34D, 0xB329, 0xA328, 0xA369, 0xAB8A, 0xABAA, 0xA3E7, 0xB429, 0xBC0A, 0xBBA9, 0xB3EA, 0xB46D, 0xA3CB, 0x92E8, 0xEDD6, 0xE514, 0xDC71, 0xD450, 0xDC8F, 0xDC90, 0xEC91, 0xF452, 0xC3F1, 0xB38D, 0x9AE9, 0x7245, 0x52C4, 
        0x5AE4, 0x5AA4, 0x5243, 0x4A43, 0xB593, 0xF71B, 0xFE59, 0xFE99, 0xFE97, 0xFE97, 0xFE79, 0xFE7A, 0xFE78, 0xFE77, 0xFE77, 0xF678, 0xFE77, 0xFE97, 0xFE77, 0xFE36, 0xF636, 0xFE36, 0xFE35, 0xFDD4, 0xED32, 0xDC8F, 0xCC0E, 0xB44C, 0xB40C, 0xB3EB, 
        0xB3CB, 0xB3EC, 0xB3CC, 0xB3CC, 0xABAC, 0xABAB, 0xABAB, 0xB3CC, 0xB44D, 0xD490, 0xDCF1, 0xDD11, 0xE532, 0xF5D4, 0xF5B4, 0xF594, 0xFDB5, 0xFDF5, 0xFE15, 0xFE16, 0xFE16, 0xFE57, 0xFE37, 0xFE36, 0xFE77, 0xFDD6, 0xF5D6, 0xFDD5, 0xFD94, 0xF574, 
        0xF574, 0xF553, 0xE533, 0xED32, 0xE512, 0xE4F2, 0xE512, 0xD490, 0xD490, 0xD48F, 0xD48F, 0xC42E, 0xBC2E, 0xC44E, 0xC40E, 0x9AEB, 0x8A49, 0xABF0, 0xF77D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDE, 0xFFDF, 0xFFDF, 0xFFDF, 
        0xFFDF, 0xFF7C, 0xF71B, 0xEEDB, 0xE6BA, 0xF6FB, 0xFF9E, 0xFFFF, 0xF7BE, 0xB5B5, 0x4A48, 0x0861, 0x10C1, 0x3A04, 0x2142, 0x18C1, 0x28E2, 0x2904, 0x2103, 0x2102, 0x1902, 0x20E2, 0x18C2, 0x2102, 0x3183, 0x31A3, 0x3A04, 0x4A65, 0x4A85, 0x4AA5, 
        0x4A85, 0x4AA5, 0x4B05, 0x5281, 0x6325, 0x6345, 0x52C3, 0x6AE6, 0x7349, 0x7BAB, 0x83CB, 0x5AC4, 0x8C27, 0xB54B, 0xB54D, 0x4263, 0x3A01, 0x6325, 0x9D0C, 0x6304, 0x7B65, 0x9C69, 0xB54E, 0x946A, 0xA4CC, 0xACEC, 0xB50A, 0xC5D0, 0xE691, 0xF6F1, 
        0xF713, 0xF795, 0xF794, 0xFF94, 0xFFD6, 0xFFF9, 0xFFB7, 0xFFB6, 0xFFD8, 0xFF76, 0xFF55, 0xF714, 0xFEF3, 0xFF16, 0xF6D6, 0xF6B6, 0xF6B6, 0xEE75, 0xF674, 0xFE95, 0xFED6, 0xFF9A, 0xFF38, 0xFED7, 0xFED7, 0xFF78, 0xFF18, 0xFED7, 0xF6D7, 0xFEF8, 
        0xFEF8, 0xFF18, 0xFF3A, 0xFF37, 0xFEB6, 0xFE75, 0xF655, 0xF675, 0xF675, 0xF695, 0xFE95, 0xFE96, 0xFED6, 0xF6D6, 0xF6B5, 0xFE96, 0xFEB6, 0xFEB6, 0xFEB6,
  0x9ACB, 0x92CA, 0x82EA, 0x7B09, 0x6284, 0x5A65, 0x6287, 0x7AEB, 0xAB72, 0xAB91, 0xB3AF, 0xC3CF, 0xA30D, 0x9AAB, 0x9269, 0x7246, 0x30C1, 0x3903, 0x3943, 0x2922, 0x3923, 0x4124, 0x5985, 0x7248, 0xC370, 0xDC33, 0xEC94, 0xFCB5, 0xEC74, 0xC38F, 0x9ACC, 
        0x8A6A, 0x8A68, 0x79E7, 0x79C7, 0x8A29, 0xAB0D, 0xBB2E, 0xCB4E, 0xC34E, 0x7165, 0x60E5, 0x7148, 0x8A4B, 0x7ACA, 0x6AA8, 0x6247, 0x49C4, 0x18C0, 0x20C0, 0x3943, 0x5247, 0x6B2A, 0x83AD, 0x940E, 0xA44F, 0xAC90, 0xA48F, 0xA4AF, 0xACCF, 0xACF1, 
        0xA4AF, 0x9C8D, 0x944C, 0x8389, 0x7369, 0x6B28, 0x62C6, 0x4262, 0x4A83, 0x5AA4, 0x5AA5, 0x3988, 0x398B, 0x49EF, 0x5A71, 0x4AAE, 0x528D, 0x49EB, 0x2909, 0x3A02, 0x39C3, 0x4A03, 0x62A4, 0x6AE7, 0x6263, 0x6262, 0x72E3, 0x61C8, 0x6207, 0x6A66, 
        0x82E8, 0xAB30, 0xB371, 0xBB90, 0xBB6E, 0xA30A, 0xA38A, 0xABC9, 0xABC8, 0xAC08, 0xABC8, 0xB388, 0xB388, 0xCC4B, 0xB3AB, 0xA3AB, 0xAC4D, 0xB4AE, 0xC40E, 0xCBCF, 0xCBCF, 0xCC0E, 0xCC0E, 0xC3EE, 0xC3EE, 0xC3CF, 0xD40F, 0xABAB, 0x5A83, 0x4AA3, 
        0x5AC5, 0x62C5, 0x6284, 0x2143, 0xA513, 0xF6FC, 0xFE1A, 0xFEB8, 0xFEB8, 0xFEB8, 0xFEB7, 0xFE98, 0xFE78, 0xFE98, 0xFE98, 0xFE78, 0xFE98, 0xFE97, 0xF677, 0xFE36, 0xFE56, 0xFE56, 0xFE36, 0xFD74, 0xED32, 0xDCD0, 0xD46E, 0xCC8E, 0xBC2C, 0xB3EB, 
        0xB3AB, 0xABCB, 0xABCB, 0xABAA, 0xA369, 0xA36A, 0xA349, 0xA38A, 0xB3EC, 0xC4AF, 0xD4B0, 0xDCD1, 0xDD32, 0xEDD3, 0xF5B4, 0xF5B5, 0xF5F5, 0xFDF5, 0xFE16, 0xFE16, 0xFE16, 0xF636, 0xFE36, 0xFE16, 0xFE16, 0xFDF6, 0xF5D6, 0xF5B6, 0xFD75, 0xF574, 
        0xF574, 0xF554, 0xED53, 0xE512, 0xDCF2, 0xDCF2, 0xDCF2, 0xD491, 0xD4B0, 0xD48F, 0xD46F, 0xC46E, 0xC46D, 0xC44D, 0xC3EE, 0x92AB, 0x92CB, 0xB492, 0xF79D, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFDF, 0xFFBE, 0xFFDE, 0xFFDF, 
        0xFFFF, 0xFF9D, 0xEF1B, 0xDE58, 0xD5D6, 0xEF1B, 0xF79D, 0xD6BA, 0x8450, 0x10A2, 0x10E1, 0x21A2, 0x31C2, 0x10C1, 0x10E1, 0x2102, 0x2902, 0x2102, 0x2102, 0x1921, 0x1901, 0x20E2, 0x2923, 0x2123, 0x18E2, 0x3163, 0x41E4, 0x4245, 0x4A86, 0x4AA5, 
        0x4AA5, 0x4AA5, 0x42A4, 0x5283, 0x6325, 0x6345, 0x5AE4, 0x52A4, 0x6B28, 0x83CB, 0x840B, 0x62C4, 0x9CAA, 0xAD2B, 0x6B85, 0x31C1, 0x6B66, 0x8429, 0x7BA7, 0x6B87, 0x7BC8, 0x8C4A, 0xA4ED, 0xC56E, 0xBD6E, 0xB54E, 0xB52D, 0xC5D1, 0xD612, 0xE693, 
        0xF735, 0xFF76, 0xFFB6, 0xFFD6, 0xFFB7, 0xFF96, 0xFF96, 0xFFB6, 0xF7D6, 0xFFB7, 0xFF96, 0xF755, 0xEF35, 0xFF15, 0xEEF5, 0xEEB4, 0xEE93, 0xEED5, 0xF6F5, 0xF715, 0xF716, 0xF717, 0xFEF8, 0xFF19, 0xFF38, 0xF717, 0xF6F7, 0xF6D7, 0xEE96, 0xFEF7, 
        0xFF18, 0xFF79, 0xFFB9, 0xE6B6, 0xEE55, 0xEE54, 0xEE54, 0xEEB7, 0xEE96, 0xEE75, 0xEE74, 0xF6B6, 0xF6B5, 0xF6B5, 0xEE96, 0xF676, 0xF696, 0xF6B6, 0xF6B7,
  0x9ACA, 0x8A47, 0x69E5, 0x51E3, 0x5243, 0x5244, 0x5A65, 0x6AA9, 0xABD2, 0xBBD1, 0xB3D0, 0xABEE, 0x9AEB, 0x8AAA, 0x7A88, 0x6A26, 0x3921, 0x3121, 0x3142, 0x3162, 0x3163, 0x3962, 0x49A4, 0x7288, 0xB38D, 0xD452, 0xE4D4, 0xF4D5, 0xE4D4, 0xD431, 0xB34D, 
        0x8A69, 0x8228, 0x7207, 0x61C6, 0x61A7, 0xA2CB, 0xAB0D, 0xB32D, 0xB32C, 0x6166, 0x40E4, 0x4925, 0x59C8, 0x6A68, 0x6266, 0x4A25, 0x39A4, 0x3142, 0x20E1, 0x20A0, 0x30A1, 0x4A25, 0x6AE9, 0x93AC, 0xAC8E, 0xACD3, 0xACD1, 0xACCF, 0x9CAD, 0x9C0C, 
        0x942D, 0x942D, 0x9BCB, 0x83CB, 0x7BA9, 0x7369, 0x6B49, 0x62E5, 0x52A5, 0x52A7, 0x52A9, 0x3149, 0x3149, 0x39AA, 0x420C, 0x4A6E, 0x4A0D, 0x49CD, 0x418B, 0x2102, 0x18A0, 0x20E1, 0x3983, 0x3124, 0x3966, 0x49A7, 0x5A07, 0x59C8, 0x7A6A, 0x8AEA, 
        0x9B4A, 0xC3D2, 0xCBF1, 0xCB6F, 0xCAAE, 0xB34C, 0xA369, 0x9B87, 0xA3E8, 0xAC2B, 0xA3A9, 0xA367, 0xAB66, 0xB3A8, 0xA388, 0xA389, 0xB3AB, 0xBC6D, 0xB38C, 0xBB4C, 0xC3CD, 0xD3AE, 0xCB6E, 0xCB6D, 0xC36D, 0xBB6D, 0xDC11, 0xD3F1, 0x8AEA, 0x41E2, 
        0x5264, 0x6306, 0x6306, 0x2103, 0xA4F3, 0xF71B, 0xFE99, 0xFE7A, 0xFE99, 0xFE98, 0xFEBA, 0xFE79, 0xFE78, 0xFE97, 0xFE98, 0xFE77, 0xFE77, 0xFE97, 0xFE97, 0xFE56, 0xFE35, 0xFE35, 0xFE15, 0xF573, 0xED31, 0xE510, 0xDCCF, 0xCC6D, 0xBC2C, 0xB3EB, 
        0xB3CB, 0xB3AB, 0xAB8A, 0xA369, 0xA349, 0x9B09, 0x9B09, 0xA329, 0xB38C, 0xBC4D, 0xCC8E, 0xD4D0, 0xDD12, 0xE594, 0xF5D4, 0xF5F5, 0xF5F6, 0xF5F6, 0xF616, 0xF616, 0xF636, 0xF616, 0xF636, 0xF636, 0xF5F6, 0xF5D6, 0xF5D6, 0xF5B5, 0xFD75, 0xED94, 
        0xED74, 0xED54, 0xE533, 0xDD13, 0xDCF2, 0xDCD1, 0xD4B0, 0xD4D1, 0xD4B0, 0xD490, 0xCC6F, 0xC46D, 0xBC4E, 0xBC2E, 0xBBEE, 0x8A88, 0x9AEB, 0xC4F3, 0xF79E, 0xFFDF, 0xFFFF, 0xFFDF, 0xFFBF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFBE, 0xFFDE, 0xFFDE, 
        0xFFBE, 0xEEBB, 0xDE79, 0xDE78, 0xEEDA, 0xEF7D, 0x8C51, 0x31A6, 0x1081, 0x3A45, 0x31E3, 0x2962, 0x2941, 0x2162, 0x2943, 0x2923, 0x2101, 0x2122, 0x2122, 0x2102, 0x1901, 0x1922, 0x2142, 0x2943, 0x2943, 0x31A2, 0x29C3, 0x31E3, 0x4223, 0x4285, 
        0x42A5, 0x4AA4, 0x4AA3, 0x4AA4, 0x6325, 0x6346, 0x52C5, 0x4202, 0x5AA5, 0x7B68, 0x8C09, 0x7366, 0x9CCB, 0x8429, 0x3A22, 0x6B67, 0x73C7, 0x73C8, 0x6BC8, 0x7388, 0x6B87, 0x7BA7, 0x9C69, 0xBDCF, 0xC5D0, 0xC590, 0xB52F, 0xBD50, 0xCDF2, 0xDE74, 
        0xF6D6, 0xFF98, 0xFFB8, 0xFFB8, 0xFFB8, 0xFFB8, 0xFFB7, 0xFFB7, 0xFFD8, 0xFF96, 0xFFB6, 0xFFB7, 0xFF96, 0xF736, 0xF714, 0xEEF4, 0xE6D5, 0xFED6, 0xF6F6, 0xF717, 0xF738, 0xF6D7, 0xFF38, 0xFF99, 0xFFBA, 0xEE35, 0xEE76, 0xF6B6, 0xFF16, 0xFFDD, 
        0xFFFD, 0xFF9B, 0xFEF7, 0xDE34, 0xDE13, 0xE634, 0xE654, 0xE635, 0xE636, 0xE656, 0xEE55, 0xEE95, 0xEEB6, 0xF6B7, 0xF6B7, 0xEE76, 0xEE56, 0xEE96, 0xF6D7,
  0xAB2C, 0x8A6A, 0x7A07, 0x6A44, 0x5A44, 0x5243, 0x4A24, 0x5A47, 0x9B8C, 0xAB6F, 0xAB70, 0xABB0, 0xAB6D, 0x9ACC, 0x8A8B, 0x7A89, 0x49C3, 0x3962, 0x3162, 0x39A4, 0x41A3, 0x4182, 0x4183, 0x49E5, 0xA34C, 0xC410, 0xDC92, 0xF4F4, 0xF494, 0xECD4, 0xCC51, 
        0xA30C, 0x92EB, 0x8ACA, 0x7A69, 0x69E7, 0x828A, 0x9B0C, 0xAB6D, 0xAB8E, 0x7A4A, 0x5987, 0x4925, 0x5144, 0x62A8, 0x5AA8, 0x5A66, 0x51E3, 0x2982, 0x2943, 0x2102, 0x20C1, 0x4183, 0x5A68, 0x834C, 0xA42F, 0xACF2, 0xB4D1, 0xAC8F, 0x9C2E, 0x9C4E, 
        0x9C2D, 0x9C2D, 0xA42D, 0x8BCB, 0x83AB, 0x7BAA, 0x7B8A, 0x6B28, 0x6326, 0x6325, 0x5AE6, 0x4A29, 0x418A, 0x418C, 0x4A4D, 0x41ED, 0x39CD, 0x39AD, 0x416E, 0x10C6, 0x2124, 0x2923, 0x28C3, 0x39C9, 0x4A29, 0x41C6, 0x2922, 0x59E6, 0x6227, 0x7AA8, 
        0x9B6B, 0xB42F, 0xCBF1, 0xDBB2, 0xDB92, 0xAB6D, 0xA34B, 0xAB8A, 0xB3AA, 0xB34A, 0xBB6B, 0xB3CB, 0xA409, 0x9B25, 0xA366, 0xABC9, 0xBC0C, 0xAB6B, 0xB3CD, 0xBBED, 0xB38D, 0xBBCD, 0xC3EE, 0xBBAD, 0xB34C, 0xBBAD, 0xD410, 0xBBCF, 0x82C9, 0x5264, 
        0x5AA4, 0x6305, 0x6345, 0x3163, 0x9CD1, 0xE6FA, 0xFEFC, 0xFEDB, 0xFED8, 0xFED7, 0xFEB8, 0xFE9C, 0xFE99, 0xFE97, 0xFED9, 0xFEBA, 0xFE98, 0xFE97, 0xFE76, 0xFE96, 0xFE75, 0xFE55, 0xFE36, 0xFDF3, 0xF552, 0xED11, 0xE4EF, 0xD46E, 0xC42D, 0xBC0C, 
        0xB3CB, 0xB3AB, 0xB3AB, 0xB3AB, 0xB38B, 0xA36A, 0xA32A, 0x9B0A, 0x9B29, 0xAB4C, 0xBBED, 0xC46E, 0xD4D0, 0xF573, 0xFDF5, 0xFE17, 0xFDF7, 0xFE36, 0xFE36, 0xFE36, 0xFE56, 0xF656, 0xFE56, 0xFE37, 0xFDF6, 0xF5D6, 0xF5D6, 0xFDB5, 0xFD95, 0xF594, 
        0xF573, 0xED53, 0xED33, 0xED13, 0xE512, 0xDCF1, 0xDCB1, 0xD4B1, 0xD491, 0xD490, 0xD46F, 0xBC4E, 0xBC4E, 0xBC2E, 0xC3EE, 0xA3CD, 0x8207, 0xA2EC, 0xEE7B, 0xFFDF, 0xFFFF, 0xFFDF, 0xFFBF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF7DE, 0xF7DE, 
        0xFFDF, 0xF79D, 0xFFBE, 0xF79D, 0xDEB9, 0x41C8, 0x18A2, 0x3184, 0x6B68, 0x21C4, 0x2162, 0x2941, 0x3121, 0x3124, 0x2943, 0x2162, 0x2142, 0x2121, 0x2922, 0x2923, 0x2102, 0x1902, 0x2983, 0x39C4, 0x39E5, 0x39C4, 0x3A03, 0x4223, 0x39E2, 0x4243, 
        0x4263, 0x4AA4, 0x52E5, 0x52C3, 0x6305, 0x6B46, 0x6326, 0x5263, 0x5283, 0x7388, 0x9D0D, 0x73A7, 0x7BE8, 0x8409, 0x73C8, 0x6324, 0x6304, 0x6346, 0x6B89, 0x73A8, 0x73A8, 0x6B86, 0x6B65, 0x8409, 0xB54F, 0xCDD2, 0xCDB3, 0xB4EF, 0xB510, 0xC571, 
        0xDE13, 0xFF99, 0xFFBA, 0xFFDB, 0xFFDB, 0xFFBB, 0xFFDA, 0xFFB9, 0xFFB8, 0xFFB7, 0xFFD7, 0xFFF8, 0xFFF8, 0xFFF8, 0xFFF8, 0xFFF8, 0xFFF8, 0xFFB9, 0xFFBA, 0xFFBA, 0xF79A, 0xFF1A, 0xFF7B, 0xDEB7, 0xA50E, 0xC550, 0xD612, 0xE6B5, 0xF6F6, 0xCE54, 
        0xB571, 0xACF0, 0xBD11, 0xE5B3, 0xDDD3, 0xD5D3, 0xCDB2, 0xCD92, 0xD5D4, 0xDDD5, 0xE5D5, 0xE615, 0xEE55, 0xEE75, 0xEE75, 0xF6D6, 0xEEB7, 0xF697, 0xF697,
  0xAB0C, 0x92AA, 0x8247, 0x7225, 0x5263, 0x49E1, 0x41A2, 0x4A05, 0x8B2C, 0x934D, 0x936D, 0x9BAC, 0x936C, 0x92EB, 0x8AAA, 0x7AAA, 0x41C2, 0x3983, 0x3963, 0x4183, 0x41C3, 0x41C3, 0x41C3, 0x4A03, 0x930A, 0xABCD, 0xC471, 0xE4D4, 0xE4D4, 0xDCD3, 0xCC71, 
        0xABCE, 0x9B6D, 0x9B6D, 0x8AEB, 0x7A48, 0x92AA, 0xA30D, 0xBB8E, 0xC3CF, 0x92AA, 0x61C8, 0x4926, 0x48E4, 0x5A04, 0x5285, 0x5245, 0x49A4, 0x3962, 0x4143, 0x4124, 0x40E3, 0x4143, 0x6226, 0x832A, 0xA42E, 0xBD33, 0xB4F1, 0xA48F, 0x9C4D, 0x7BEA, 
        0x8BCB, 0x8BEC, 0x8C0C, 0x93AB, 0x83AA, 0x7B8A, 0x7B6A, 0x736B, 0x6B69, 0x6308, 0x5A88, 0x41CB, 0x292A, 0x290A, 0x418B, 0x41AD, 0x418C, 0x394C, 0x310C, 0x3963, 0x3162, 0x3163, 0x2942, 0x20E1, 0x3921, 0x4142, 0x4143, 0x69E9, 0x82AA, 0x934C, 
        0xABED, 0xDC32, 0xDC31, 0xCC30, 0xBC0D, 0xB36C, 0xB36C, 0xB34B, 0xB329, 0xAB2B, 0xABAC, 0xAC2B, 0x9C8A, 0x8BA7, 0x9347, 0xA38A, 0xB40E, 0xBBAC, 0xC3EE, 0xCBF0, 0xD3B0, 0xD38E, 0xCB6D, 0xCB8E, 0xCB8E, 0xC34E, 0xE431, 0xD3F0, 0x92C9, 0x5283, 
        0x5AA4, 0x6B05, 0x7326, 0x39E2, 0x7C0B, 0xC616, 0xF75E, 0xFEBB, 0xFEB9, 0xFED7, 0xFEB7, 0xFE98, 0xFE97, 0xFEB8, 0xFEDA, 0xFEDA, 0xFED9, 0xFEB7, 0xFE56, 0xFE56, 0xFE76, 0xFE76, 0xFE15, 0xFDB2, 0xF572, 0xF531, 0xECEF, 0xD48E, 0xC42C, 0xBBEC, 
        0xBBCB, 0xB3AA, 0xB3CB, 0xB3CC, 0xB3AC, 0xB38B, 0xB36B, 0xA34A, 0x92E9, 0x9AC9, 0xA36B, 0xBC0D, 0xDC8F, 0xED53, 0xF5D5, 0xFE16, 0xF5F7, 0xF655, 0xFE56, 0xFE57, 0xFE56, 0xFE55, 0xFE16, 0xFE17, 0xFE56, 0xFDF6, 0xFDD6, 0xFDD5, 0xFDB4, 0xF574, 
        0xF573, 0xF553, 0xED33, 0xED32, 0xE512, 0xDCD2, 0xDCB1, 0xD4B0, 0xD490, 0xD470, 0xD490, 0xC44E, 0xBC2D, 0xBC0D, 0xBBCD, 0xABAC, 0x8A48, 0x7A28, 0x9BEF, 0xF77D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xF79E, 0x9CF3, 0x8C0E, 0x62C9, 0x2901, 0x1040, 0x39E4, 0x52E6, 0x52E6, 0x3943, 0x3102, 0x2902, 0x2901, 0x2942, 0x2162, 0x2142, 0x2142, 0x2942, 0x2943, 0x2923, 0x2122, 0x2122, 0x2983, 0x31C4, 0x39E4, 0x4A65, 0x4A85, 0x4243, 0x31C1, 0x4284, 
        0x4A84, 0x4AC4, 0x5326, 0x5AA4, 0x5AE5, 0x6326, 0x7387, 0x73A9, 0x7BCA, 0x8C2A, 0x946B, 0x6B47, 0x7BE8, 0x8449, 0x842A, 0x6B46, 0x6325, 0x6B26, 0x6B47, 0x63A7, 0x6BC7, 0x73C7, 0x73C8, 0x8387, 0x9C8B, 0xB550, 0xC593, 0xBD11, 0xB530, 0xC571, 
        0xDDF3, 0xFF5A, 0xFF9B, 0xFFBC, 0xFFDC, 0xFFDC, 0xFFDB, 0xFFDA, 0xFFDA, 0xFFD9, 0xFFD9, 0xFFB8, 0xFFB6, 0xFFFA, 0xFFFA, 0xFFD9, 0xFFF8, 0xFFBB, 0xFFBB, 0xFFBB, 0xFF9A, 0xFFFE, 0xF7DB, 0xC5F3, 0x7347, 0xB58F, 0xB54F, 0xB52E, 0xB54F, 0x93C9, 
        0x938A, 0xA44E, 0xC573, 0xDDF4, 0xCDD3, 0xC592, 0xC591, 0xC571, 0xC572, 0xCD73, 0xDD94, 0xDDD5, 0xDE14, 0xE634, 0xE655, 0xF6D7, 0xF697, 0xF697, 0xEEB7,
  0xB32C, 0x9ACA, 0x7A47, 0x59E4, 0x5A42, 0x49C1, 0x3981, 0x41C4, 0x72CA, 0x72CA, 0x7AEA, 0x830A, 0x6B09, 0x6AA8, 0x6A67, 0x6A45, 0x39A4, 0x3183, 0x3963, 0x4184, 0x4A03, 0x4A24, 0x4A44, 0x4A64, 0x6A67, 0x930A, 0xB3CE, 0xD492, 0xD432, 0xBBF0, 0xABAE, 
        0xA3AE, 0x9B8D, 0xA3CE, 0xAC0E, 0xBC4F, 0xB452, 0xB472, 0xBCB2, 0xC4D2, 0xA40E, 0x72CA, 0x51E6, 0x4184, 0x51C5, 0x49E4, 0x41E3, 0x39C3, 0x5246, 0x62A8, 0x72C9, 0x8289, 0x7AA9, 0x72EA, 0x7B2B, 0x938D, 0xB4D0, 0x9C4F, 0x836B, 0x62C6, 0x6B29, 
        0x7348, 0x7B48, 0x7B29, 0x7329, 0x6B07, 0x6B27, 0x6B68, 0x6B69, 0x6B48, 0x5AC7, 0x4A26, 0x3187, 0x2949, 0x294C, 0x316D, 0x41AB, 0x316B, 0x290B, 0x20EA, 0x2949, 0x2906, 0x28E5, 0x2904, 0x2923, 0x41C5, 0x5227, 0x5A49, 0x9390, 0x9BAF, 0xA38E, 
        0xAB8E, 0xEB74, 0xF334, 0xE372, 0xCBEE, 0xCB6E, 0xD32F, 0xCB0E, 0xBB0B, 0xB48A, 0xC52D, 0xC54F, 0xBCEF, 0x6AC6, 0x9389, 0xB40C, 0xC40E, 0xD48E, 0xCC4F, 0xCC2F, 0xDC51, 0xECB2, 0xDC10, 0xDC10, 0xE452, 0xCB4B, 0xD430, 0xD4B2, 0xB44F, 0x41C2, 
        0x5A64, 0x6AE6, 0x62E5, 0x4263, 0x6AA6, 0xAC8F, 0xF75C, 0xFE17, 0xFE79, 0xFEBA, 0xFE7A, 0xFE97, 0xFE99, 0xFEB9, 0xFED9, 0xFED9, 0xFED9, 0xFEB8, 0xFE56, 0xFE77, 0xFE96, 0xFE96, 0xFE75, 0xF592, 0xED51, 0xED32, 0xE4F2, 0xD4AD, 0xCC2C, 0xC3EC, 
        0xC3CB, 0xB38B, 0xB3AB, 0xBBCB, 0xB3CB, 0xAB6A, 0xB38A, 0xB36A, 0xA2E9, 0x9AC8, 0xA309, 0xBBCC, 0xD4B0, 0xE553, 0xF5B5, 0xFE16, 0xF656, 0xF637, 0xFE37, 0xFE37, 0xF657, 0xF635, 0xF5F6, 0xF616, 0xF656, 0xF5D5, 0xF5D6, 0xF5D6, 0xF5D4, 0xED75, 
        0xED54, 0xED53, 0xED52, 0xDD13, 0xDCF2, 0xDCD1, 0xDCB0, 0xCCD0, 0xCC90, 0xCC70, 0xD470, 0xC44F, 0xC42E, 0xBBED, 0xAB8C, 0x938A, 0xAB8C, 0x9289, 0x5964, 0xB5B7, 0xE75D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF7BE, 0xBDF7, 0xBDF8, 0xAD55, 
        0x6B6D, 0x1062, 0x0020, 0x1040, 0x2080, 0x39E3, 0x4AA6, 0x52C7, 0x4A45, 0x4102, 0x3902, 0x3103, 0x2943, 0x29A2, 0x2963, 0x2143, 0x2122, 0x3122, 0x2922, 0x2963, 0x39C3, 0x2122, 0x1902, 0x2983, 0x3A04, 0x29A2, 0x2961, 0x3A03, 0x5328, 0x5AE5, 
        0x5B26, 0x5B47, 0x5B47, 0x4A83, 0x4AA4, 0x5B26, 0x840A, 0x94CD, 0x7BEA, 0x6B47, 0x6B46, 0x7BC9, 0x73E9, 0x73E8, 0x73C7, 0x62E5, 0x6305, 0x6325, 0x6B46, 0x6389, 0x6B87, 0x6BC6, 0x73E5, 0x7347, 0x9CAC, 0xB590, 0xBD92, 0xB52F, 0xB530, 0xC592, 
        0xE634, 0xFF59, 0xFFBB, 0xFFDC, 0xFFBD, 0xFFDC, 0xFFDC, 0xFFDB, 0xFFDA, 0xFFBA, 0xFFBA, 0xFFB9, 0xFFB8, 0xFFDA, 0xFFD9, 0xFFD9, 0xFFD9, 0xFFBA, 0xFFBA, 0xFFBA, 0xF77A, 0xF79D, 0x9CCF, 0x6B25, 0x6322, 0x73A7, 0x7BA7, 0x7BA5, 0x6B63, 0x4A43, 
        0xB4CF, 0xE614, 0xD592, 0xE5F7, 0xD5F4, 0xCDF3, 0xCDF3, 0xD653, 0xD614, 0xCDD4, 0xD5D4, 0xE5F5, 0xD5F4, 0xD5F5, 0xE635, 0xE675, 0xE656, 0xEE77, 0xF697,
  0xA2ED, 0x928B, 0x8229, 0x69E6, 0x5A03, 0x41C2, 0x39A1, 0x41C2, 0x6288, 0x6AEA, 0x6AEA, 0x72A8, 0x5AA5, 0x6AA6, 0x6A87, 0x6265, 0x41C3, 0x41A3, 0x39A3, 0x39E3, 0x4A05, 0x5245, 0x5264, 0x4A63, 0x6285, 0x6AA7, 0x8B2A, 0xBBEE, 0xC451, 0xB3EE, 0x9BCD, 
        0x93CF, 0xA3AD, 0xAC0F, 0xB451, 0xBC52, 0xBC51, 0xCC92, 0xDCB3, 0xDCD3, 0xCC93, 0xB3F0, 0x930C, 0x69E7, 0x61A5, 0x4A05, 0x4223, 0x41C3, 0x59E6, 0x7A89, 0x92CB, 0x92ED, 0x82EA, 0x72C9, 0x7B09, 0x8B8B, 0x9C0D, 0x9C4E, 0x8C0C, 0x6B29, 0x5AA4, 
        0x6B07, 0x7349, 0x7368, 0x7369, 0x6B48, 0x6B28, 0x7328, 0x6B49, 0x6B68, 0x6B47, 0x6AE8, 0x39A9, 0x314C, 0x312D, 0x312C, 0x49CB, 0x41AA, 0x3949, 0x3928, 0x5126, 0x4104, 0x3903, 0x3902, 0x4184, 0x51E6, 0x6228, 0x7A4A, 0x9B0B, 0xA32B, 0xA34B, 
        0xA3AC, 0xE391, 0xD3D0, 0xD3F0, 0xE3F2, 0xDBB0, 0xCBAE, 0xC3EE, 0xBC6E, 0xBD8E, 0xC58F, 0xB42D, 0x8A29, 0xA38B, 0x9B6A, 0xA3AB, 0xBC6E, 0xBC6D, 0xCC30, 0xDC33, 0xEC95, 0xEC73, 0xE412, 0xE412, 0xE452, 0xCC2F, 0xDC93, 0xD451, 0x9AE9, 0x5A03, 
        0x5AC5, 0x5B05, 0x5AA4, 0x6325, 0x5244, 0x83AC, 0xEF3C, 0xFE7A, 0xFEB9, 0xFED9, 0xFED8, 0xFEBA, 0xFE9B, 0xFEBB, 0xFEDA, 0xFEF9, 0xFED8, 0xFEB7, 0xFEB7, 0xFED8, 0xFEB7, 0xFEB6, 0xFE75, 0xF5D4, 0xFD72, 0xF531, 0xE510, 0xDC8E, 0xD46D, 0xC44D, 
        0xBC2C, 0xC3EC, 0xC40D, 0xC42D, 0xC40C, 0xB3CB, 0xBBCB, 0xBBAB, 0xB34A, 0x9AE8, 0x9AE9, 0xB36B, 0xD44F, 0xED53, 0xF595, 0xFE16, 0xFE78, 0xFE77, 0xFE77, 0xFE77, 0xFE76, 0xFE57, 0xFE37, 0xFE36, 0xFE56, 0xFDF6, 0xFDD5, 0xF5B5, 0xF594, 0xFD94, 
        0xF573, 0xF553, 0xED53, 0xE513, 0xE4F2, 0xE4F2, 0xE4D1, 0xD491, 0xD490, 0xCC90, 0xCC4F, 0xCC0E, 0xC40F, 0xBC0E, 0xABCD, 0x9B8C, 0xB40E, 0xB40D, 0x7B08, 0x1081, 0x2923, 0x4A07, 0x5A8B, 0x62AA, 0x6B0C, 0x5AAB, 0x3986, 0x0821, 0x0000, 0x0800, 
        0x1040, 0x3A03, 0x4A23, 0x4A04, 0x41C5, 0x41E2, 0x4A64, 0x5224, 0x4102, 0x28C3, 0x30C2, 0x3902, 0x4942, 0x29A5, 0x2983, 0x2983, 0x31A3, 0x31A4, 0x2962, 0x2942, 0x2983, 0x4244, 0x39C2, 0x39C2, 0x4A64, 0x5B28, 0x6BA8, 0x6B87, 0x6347, 0x6BC8, 
        0x6BA8, 0x6387, 0x5B87, 0x6305, 0x52A4, 0x6326, 0x948C, 0xA4CD, 0xA4EE, 0x7BCA, 0x31C2, 0x73C6, 0x6B86, 0x73A8, 0x946B, 0x6B66, 0x5B05, 0x6325, 0x6B67, 0x6BA7, 0x6365, 0x6B84, 0x7C05, 0x6BA8, 0x946B, 0xB52F, 0xC5B3, 0xBD51, 0xCD72, 0xDDD2, 
        0xE633, 0xFF39, 0xFF9C, 0xFFBD, 0xFFBD, 0xFFDD, 0xFFDC, 0xFFDC, 0xFFDC, 0xFFFC, 0xFFFC, 0xFFFC, 0xFFFB, 0xFFDC, 0xFFDB, 0xFFFB, 0xFFFC, 0xFFFB, 0xFFDB, 0xFFFC, 0xFFFD, 0xF79D, 0xA50F, 0x6B65, 0x5B22, 0x73A4, 0x73A5, 0x7BC6, 0x9469, 0xEF57, 
        0xE696, 0xD5D4, 0xCD94, 0xC5B1, 0xB50F, 0xACAD, 0xA48D, 0x948D, 0x9C8D, 0xA4CE, 0xBD31, 0xD612, 0xD5F2, 0xD5D3, 0xE614, 0xDE14, 0xDE55, 0xE676, 0xEE97,
  0xA2ED, 0x8A8A, 0x7A28, 0x6A05, 0x51A3, 0x49C3, 0x41E3, 0x4222, 0x5A46, 0x62C8, 0x62E9, 0x62C9, 0x5A85, 0x5A85, 0x5A65, 0x5A25, 0x4203, 0x41C3, 0x41A3, 0x41C4, 0x5A64, 0x5A85, 0x5A85, 0x5264, 0x62C4, 0x6AA6, 0x72E8, 0x8B6B, 0xB470, 0xA3CE, 0x8B2B, 
        0x82EA, 0xA3AE, 0xB450, 0xBC91, 0xC4B2, 0xED14, 0xF555, 0xF595, 0xF596, 0xE4F2, 0xCC72, 0xB3AF, 0x9ACB, 0x8248, 0x5A24, 0x39E2, 0x31A2, 0x6205, 0x832B, 0xA3CF, 0xBBD1, 0xA34F, 0x8B4C, 0x834A, 0x7B49, 0x838C, 0x8BCC, 0x838B, 0x6AE8, 0x5282, 
        0x5AC5, 0x62E6, 0x62E6, 0x6306, 0x62E5, 0x62E5, 0x6306, 0x6B49, 0x6B29, 0x6B09, 0x5AC9, 0x41A8, 0x418C, 0x316D, 0x292B, 0x496C, 0x496B, 0x4149, 0x3947, 0x4948, 0x4125, 0x4124, 0x4123, 0x3902, 0x41A4, 0x6267, 0x8B2B, 0xA34C, 0xAB2C, 0xAB6D, 
        0xB3EE, 0xCBD1, 0xC3D0, 0xD3CF, 0xE3D0, 0xD46F, 0xBC8E, 0xB4AD, 0xB4AC, 0xA46D, 0xA38B, 0xBB4D, 0xDB8F, 0x8A47, 0x8AC8, 0xA3CB, 0xBCCE, 0xC42E, 0xDC31, 0xE453, 0xE473, 0xD3F0, 0xEC52, 0xF4B4, 0xF4B2, 0xDC30, 0xDCB2, 0xCC50, 0x92E9, 0x4A23, 
        0x5AE5, 0x6325, 0x52A3, 0x5283, 0x8BA9, 0xCD51, 0xF719, 0xFE7B, 0xFEBA, 0xFEF9, 0xFEFA, 0xFEDB, 0xFED9, 0xFEB8, 0xFEB8, 0xFEFB, 0xFED9, 0xFED7, 0xFEF8, 0xFED9, 0xFED7, 0xFED6, 0xFE95, 0xFDB3, 0xF573, 0xF552, 0xECF0, 0xDCAE, 0xD48E, 0xD46D, 
        0xCC2C, 0xCC2D, 0xCC6E, 0xCC6D, 0xC44C, 0xBC2D, 0xBBCB, 0xB3AB, 0xBB8B, 0xAB29, 0xA2E9, 0xAB4B, 0xCC2D, 0xE533, 0xF595, 0xFDF6, 0xFE58, 0xFE77, 0xFE77, 0xFE77, 0xF657, 0xFE37, 0xFE37, 0xFE56, 0xFE56, 0xFDF6, 0xFDD5, 0xF5B5, 0xFD94, 0xFD94, 
        0xF573, 0xF553, 0xF553, 0xED13, 0xE4F2, 0xE4F2, 0xE4F2, 0xD470, 0xD491, 0xD470, 0xCC2F, 0xD42F, 0xC3EF, 0xBBCE, 0xB3CD, 0x940D, 0xA3AC, 0x9B29, 0x6AA4, 0x5B06, 0x29A2, 0x18E1, 0x2101, 0x10C0, 0x1060, 0x1020, 0x0860, 0x2943, 0x31C3, 0x4204, 
        0x49E4, 0x3982, 0x41A3, 0x49E4, 0x5A24, 0x6286, 0x5204, 0x4963, 0x4902, 0x3102, 0x38E2, 0x40E3, 0x4143, 0x2984, 0x2942, 0x3142, 0x41C3, 0x4224, 0x39C2, 0x39A2, 0x4A03, 0x62E6, 0x5AE6, 0x52E6, 0x5B28, 0x73C9, 0x7C2A, 0x7408, 0x6325, 0x5305, 
        0x52E5, 0x5B25, 0x6386, 0x5B45, 0x5B05, 0x6B47, 0x842A, 0x9CCD, 0xAD2F, 0x9CCD, 0x6BA8, 0x4A63, 0x7BC7, 0xA50D, 0xAD30, 0x6B24, 0x6324, 0x6346, 0x6B47, 0x73A7, 0x6B65, 0x6364, 0x5B85, 0x83E7, 0x9CAB, 0xA50E, 0xAD0F, 0xDDB2, 0xE5F3, 0xEE54, 
        0xF6D6, 0xFF59, 0xFF9A, 0xFFBB, 0xFFBC, 0xFFBC, 0xFFBC, 0xFFDB, 0xFFFC, 0xFFDD, 0xFFFC, 0xFFFC, 0xFFFD, 0xFFDD, 0xFFDD, 0xFFDD, 0xFFDE, 0xFFFE, 0xFFDD, 0xFFFE, 0xFFFF, 0xF79D, 0x9CAE, 0x5AE4, 0x5321, 0xA4C9, 0x9CCA, 0xA4EB, 0xBD6D, 0xBD4E, 
        0xBD4F, 0xC572, 0xCDB4, 0x8BE8, 0x7325, 0x6B04, 0x6B24, 0x52A2, 0x6B23, 0x83C5, 0x9468, 0x9C69, 0xA48D, 0xACF0, 0xBD52, 0xEE16, 0xE5D5, 0xDDF5, 0xE677,
  0x9ACA, 0x8A27, 0x71E4, 0x59C3, 0x4984, 0x4A24, 0x4A64, 0x4A45, 0x5AA6, 0x62E8, 0x62E8, 0x5AC6, 0x5AA6, 0x5285, 0x4A24, 0x41E3, 0x39A2, 0x41E3, 0x4204, 0x4A04, 0x5265, 0x5285, 0x5A85, 0x62A5, 0x52E4, 0x6B26, 0x72E7, 0x6A88, 0xABED, 0x9BAC, 0x7AC9, 
        0x6A26, 0x9BAC, 0xBC91, 0xD514, 0xE555, 0xF596, 0xFDB6, 0xFDD6, 0xFDD7, 0xFD97, 0xF514, 0xECD3, 0xE473, 0xB38D, 0x92E9, 0x6A66, 0x49E4, 0x7A66, 0xB3CD, 0xDCF3, 0xE516, 0xBBAF, 0x8B0B, 0x72C8, 0x72A8, 0x6AC7, 0x6AA7, 0x6287, 0x5A45, 0x31C2, 
        0x39C1, 0x41E3, 0x4A45, 0x5AA5, 0x62C5, 0x6305, 0x5B25, 0x6B08, 0x6B08, 0x6B08, 0x6AE9, 0x62AB, 0x626C, 0x5A2D, 0x49ED, 0x412A, 0x498A, 0x49CA, 0x5209, 0x6A49, 0x5A07, 0x49A6, 0x4164, 0x4983, 0x51E5, 0x6A88, 0x932C, 0xA3CE, 0xAB6E, 0xB38E, 
        0xC450, 0xBB6D, 0xCB4D, 0xCB8E, 0xBBCD, 0xB48C, 0x9CCA, 0x8485, 0x7422, 0xB449, 0xBBEA, 0xABCA, 0x8B89, 0x49E4, 0x41C2, 0x6285, 0x9BAA, 0x8AA6, 0xAB8B, 0xCC90, 0xE533, 0xEDB6, 0xED55, 0xED13, 0xECF2, 0xECB3, 0xE4B2, 0xC42F, 0x8B2A, 0x5245, 
        0x7A68, 0x8269, 0x7267, 0xAB8A, 0xABEB, 0xC4CF, 0xF656, 0xFEDC, 0xFEBA, 0xFEB9, 0xFEBB, 0xFEB9, 0xFEB7, 0xFEB7, 0xFED9, 0xFED9, 0xFED8, 0xFEF9, 0xFF1A, 0xFF3A, 0xFF18, 0xFED7, 0xFE75, 0xF5B3, 0xF572, 0xED52, 0xED32, 0xDCCD, 0xDCCD, 0xD4AD, 
        0xD44C, 0xC40B, 0xC42B, 0xCC2C, 0xC40B, 0xCC4C, 0xCC4D, 0xCC4D, 0xCC2C, 0xA2C8, 0xA2C9, 0xAB4A, 0xC42C, 0xED53, 0xF5B5, 0xFE16, 0xFE77, 0xFE57, 0xFE57, 0xFE57, 0xF637, 0xFE57, 0xFE36, 0xF5F6, 0xF5F6, 0xF5F5, 0xF5F5, 0xF5F5, 0xF5D5, 0xF574, 
        0xF554, 0xED53, 0xED53, 0xDD12, 0xDCF2, 0xDCD1, 0xD4B0, 0xD4D1, 0xD490, 0xCC6F, 0xCC6F, 0xCC6E, 0xC42E, 0xB3CD, 0xAB8B, 0xBC2D, 0x9329, 0x6A86, 0x5264, 0x42C5, 0x4AA5, 0x52A4, 0x4A83, 0x4A03, 0x5204, 0x5A04, 0x5A04, 0x4A24, 0x49E4, 0x49E4, 
        0x4A23, 0x5A45, 0x6A45, 0x6A25, 0x61E6, 0x5162, 0x4942, 0x4943, 0x4124, 0x28E1, 0x2901, 0x38E2, 0x4082, 0x30E2, 0x5246, 0x5AC7, 0x4A83, 0x52C5, 0x5AE6, 0x62E6, 0x62E6, 0x5B07, 0x6B67, 0x73A8, 0x73C8, 0x3A82, 0x52E4, 0x6BA7, 0x7427, 0x5B25, 
        0x5B06, 0x5B05, 0x4B25, 0x7BC9, 0x6B67, 0x5B05, 0x52E5, 0x6326, 0xA52F, 0xD696, 0xD675, 0x52E4, 0xAD8E, 0xBE10, 0x6BA7, 0x6325, 0x5B06, 0x6327, 0x6B47, 0x6B45, 0x5B45, 0x5B44, 0x6384, 0x8BC8, 0xA4AB, 0xAD0D, 0xACEE, 0xE634, 0xF6B7, 0xF6F8, 
        0xFF18, 0xFF79, 0xFF79, 0xFF79, 0xFF9B, 0xFFDB, 0xFFDC, 0xFFBC, 0xFF9B, 0xFFFE, 0xFFFD, 0xFFDD, 0xFFDE, 0xFFDD, 0xFFDD, 0xFFDE, 0xFFFE, 0xFFDD, 0xFFDD, 0xFFDD, 0xF77C, 0x9C29, 0x7344, 0x73A4, 0x9486, 0x8C07, 0x8C28, 0x8408, 0x8409, 0xCDF1, 
        0xC58F, 0x9CAC, 0x7368, 0x39E1, 0x4A42, 0x52A3, 0x5AC2, 0x73A4, 0x6B63, 0x6B63, 0x7385, 0x6B05, 0x8BE7, 0xA4AA, 0xB50D, 0xD613, 0xDE55, 0xDE55, 0xDE34,
  0xA2AA, 0x9A89, 0x9268, 0x7A46, 0x4A05, 0x4A24, 0x4A44, 0x4A65, 0x5AA5, 0x62E6, 0x6308, 0x6308, 0x5B07, 0x5AA6, 0x5264, 0x4A23, 0x49C3, 0x49C4, 0x49E4, 0x49E3, 0x5A85, 0x5A85, 0x5A85, 0x5AA4, 0x52A5, 0x62E6, 0x7328, 0x836A, 0x82EA, 0x938C, 0x936C, 
        0x8AEB, 0xA3AD, 0xB430, 0xCCB3, 0xED76, 0xF555, 0xF596, 0xFDB6, 0xFDB7, 0xFDB6, 0xFD56, 0xFCF5, 0xECB3, 0xDC11, 0xBBF0, 0x9BAC, 0x7B28, 0x7AA8, 0x9B4C, 0xBC10, 0xDC92, 0xD4B3, 0xB3EF, 0x9B4B, 0x92E9, 0x8328, 0x7B49, 0x7B28, 0x6AE7, 0x39A2, 
        0x39A2, 0x39E2, 0x4243, 0x62C4, 0x6305, 0x5B25, 0x5B05, 0x6B48, 0x6B68, 0x6B48, 0x6B0A, 0x732C, 0x830E, 0x82CF, 0x728E, 0x51AA, 0x59CA, 0x620A, 0x6A49, 0x7A69, 0x6A28, 0x61E7, 0x59C5, 0x49C3, 0x5A05, 0x6A68, 0x7AAA, 0xAB6F, 0xBB6E, 0xBB8E, 
        0xBBCF, 0xB38B, 0xBB4B, 0xC3EC, 0xBD2D, 0xA46A, 0x94A9, 0x94E9, 0xA4C9, 0xDBEB, 0xD38B, 0xBB6B, 0x8B4A, 0x6A44, 0x6A85, 0x72A6, 0x82E6, 0x8368, 0x8B09, 0xAB6D, 0xD493, 0xECD5, 0xF4F5, 0xFD16, 0xFD56, 0xF4F5, 0xF4B4, 0xBBAF, 0x6245, 0x49C2, 
        0x7AA8, 0xA3AD, 0xBC8E, 0xA369, 0xC4AF, 0xE657, 0xFF9D, 0xF639, 0xFE9A, 0xFEDA, 0xFE97, 0xFEBA, 0xFEDA, 0xFEF9, 0xFEF7, 0xFEF9, 0xFED9, 0xFEF8, 0xFF3A, 0xFF9C, 0xFF3A, 0xFED8, 0xFE96, 0xF5B4, 0xF573, 0xED32, 0xE4F0, 0xDCAE, 0xDC6D, 0xD46D, 
        0xDCAE, 0xF552, 0xE572, 0xE552, 0xED11, 0xDC6E, 0xDC8E, 0xDCAF, 0xDCAE, 0xA34A, 0x9B08, 0xAB8B, 0xD491, 0xF573, 0xF574, 0xFDD6, 0xFE77, 0xFE77, 0xFE77, 0xFE77, 0xFE57, 0xFE57, 0xFE37, 0xFE16, 0xF616, 0xF5F6, 0xFDD6, 0xFDB5, 0xF5B5, 0xF594, 
        0xF574, 0xF554, 0xED33, 0xE533, 0xE4F2, 0xE4F2, 0xDCF2, 0xD490, 0xD490, 0xDC6F, 0xDC4F, 0xBC4E, 0xBC2E, 0xBBEE, 0xBBCE, 0xC42D, 0x9309, 0x6285, 0x4AC5, 0x4AE5, 0x4A83, 0x5AC5, 0x73A9, 0x9B4B, 0x9329, 0x8B49, 0x934A, 0x7B07, 0x8308, 0x7AC7, 
        0x6A65, 0x7246, 0x6A26, 0x6A06, 0x69E5, 0x6185, 0x5964, 0x5164, 0x4964, 0x38E3, 0x30C2, 0x30A2, 0x3082, 0x40A1, 0x5985, 0x838C, 0xBDF4, 0x9D6F, 0x73C9, 0x6B46, 0x7BE8, 0x7C4A, 0x6B88, 0x5B26, 0x6365, 0x6B86, 0x5B24, 0x52E4, 0x5B04, 0x6B85, 
        0x6BA6, 0x6B85, 0x6344, 0x7387, 0x6305, 0x6B87, 0x948C, 0x6308, 0x39A4, 0x4A68, 0x94B3, 0xC5F0, 0xD692, 0xB5D0, 0x7BC9, 0x6BC6, 0x6BA5, 0x6B65, 0x6365, 0x6B86, 0x6B65, 0x6344, 0x6365, 0x7C08, 0x8C29, 0xA4AC, 0xD5D2, 0xF758, 0xFF9B, 0xFF9D, 
        0xFFBD, 0xFF9B, 0xF79B, 0xFF9B, 0xFF9B, 0xFFDD, 0xFFDE, 0xFFDE, 0xFFDD, 0xFFFF, 0xFFDE, 0xFFDE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFF, 0xF7BE, 0xB5B2, 0x8C87, 0x7BE3, 0x8C25, 0xBDAE, 0xAD0C, 0x83A9, 0x5246, 0x29A1, 
        0x4262, 0x4A82, 0x4220, 0x6322, 0x7364, 0x6B44, 0x6323, 0x7BE5, 0x7383, 0x6B43, 0x6B65, 0x73C6, 0x7385, 0x6B03, 0x6A82, 0x8BA6, 0xB50E, 0xD634, 0xFF17,
  0xAAAB, 0xAAAB, 0x9AAB, 0x7A6A, 0x5265, 0x4A24, 0x4A24, 0x62A5, 0x52A5, 0x5B06, 0x6327, 0x6B28, 0x62C6, 0x62A6, 0x5A85, 0x4A43, 0x41C3, 0x49E3, 0x4A04, 0x41E4, 0x5244, 0x4A64, 0x4A64, 0x5284, 0x4A23, 0x5265, 0x62C8, 0x8B4B, 0x932B, 0x934C, 0x8B6C, 
        0x938C, 0xB3F0, 0xC451, 0xDCF3, 0xF5B6, 0xFD56, 0xFD96, 0xFDB7, 0xFDF7, 0xFDB7, 0xFDB7, 0xFD96, 0xF555, 0xECB3, 0xE472, 0xCC2F, 0xABCC, 0x9B49, 0xB36A, 0xCC0D, 0xECD2, 0xDCD2, 0xBC2F, 0xAB8C, 0x9AEA, 0x832A, 0x8349, 0x7B49, 0x7B29, 0x4A03, 
        0x3161, 0x2941, 0x39A2, 0x5AC5, 0x6AE5, 0x6AE5, 0x62C5, 0x7308, 0x7309, 0x7B09, 0x7AEA, 0x8B0D, 0x9B2F, 0xA350, 0xAB30, 0x79E9, 0x71A8, 0x79E8, 0x8A6A, 0x8AAB, 0x7A8A, 0x6A27, 0x69A4, 0x5964, 0x61A5, 0x69E7, 0x8249, 0xAB8E, 0xB3F0, 0xBBEF, 
        0xBBCD, 0xBB8D, 0xD40E, 0xDC4E, 0xC44E, 0xAC2B, 0xA4AA, 0xA509, 0xA50A, 0xC44B, 0xBBEB, 0xA3AB, 0x834B, 0x59E3, 0x6A85, 0x7B29, 0x8349, 0x59E2, 0x6A25, 0x7AC9, 0x93AC, 0xED33, 0xED34, 0xED36, 0xFD77, 0xFDD8, 0xF556, 0xB3CE, 0x51E3, 0x6306, 
        0x838A, 0x942D, 0x9CAD, 0xA34A, 0xDDF6, 0xFFBD, 0xFFBE, 0xFE17, 0xFE79, 0xFEB9, 0xFEB6, 0xFEDA, 0xFEDA, 0xFEFA, 0xFEF9, 0xFEF9, 0xFED9, 0xFEB9, 0xFEDA, 0xFF7C, 0xFF3A, 0xFED8, 0xFE76, 0xFDB3, 0xFD93, 0xF551, 0xE4CF, 0xE46E, 0xD42C, 0xDCAE, 
        0xF5F4, 0xF677, 0xD552, 0xD573, 0xF6B8, 0xE530, 0xDCAF, 0xDCAF, 0xDCD0, 0xAB4A, 0x9B09, 0xB38B, 0xE4D0, 0xFDB5, 0xFDB5, 0xFDF5, 0xFE57, 0xFE97, 0xFE76, 0xFE76, 0xFE77, 0xFE57, 0xFE37, 0xFE16, 0xFDF6, 0xFE17, 0xFDD6, 0xFDD5, 0xFDB6, 0xFD74, 
        0xFD74, 0xF554, 0xF533, 0xE533, 0xE4F2, 0xE4F2, 0xDD12, 0xDCB0, 0xDC91, 0xD470, 0xCC4F, 0xC44E, 0xC42E, 0xC40E, 0xC40E, 0xBC4F, 0x8329, 0x62A5, 0x5AE5, 0x3AA4, 0x6B28, 0x8BAB, 0x9C2D, 0xAB4B, 0x9B0A, 0x932A, 0x9B2A, 0x8AC9, 0x82A8, 0x8286, 
        0x7A65, 0x7A46, 0x7246, 0x7226, 0x6A05, 0x59A4, 0x5964, 0x5144, 0x4163, 0x40E2, 0x40C2, 0x30C3, 0x28E3, 0x50C2, 0x2861, 0x3124, 0x6B0A, 0x94CD, 0x8C4B, 0x73A9, 0x6327, 0x7388, 0x73C9, 0x73E9, 0x7409, 0x6BA8, 0x6B66, 0x6345, 0x6345, 0x5B03, 
        0x6B45, 0x73A7, 0x7BE8, 0x5B04, 0x842A, 0xBDD2, 0xEF56, 0xCE32, 0xA510, 0x946E, 0x7BCA, 0x4225, 0xA553, 0xBE16, 0x73E9, 0x73C3, 0x73E4, 0x73A5, 0x6B45, 0x7366, 0x6B86, 0x6365, 0x6345, 0x7C07, 0x8C09, 0xB50E, 0xF6D5, 0xFF7A, 0xFF7C, 0xFF9D, 
        0xFFDE, 0xFF9B, 0xFFBC, 0xFFDD, 0xFFFD, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFF, 0xFFDD, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFDE, 0xFFDE, 0xF7BD, 0xB591, 0x5AA7, 0x5AA6, 0xBDAE, 0xD5F0, 0xC5AF, 0xC5B0, 0xCDB0, 0x6B48, 
        0x5AE4, 0x6323, 0x6B83, 0x6B23, 0x6B43, 0x6B43, 0x6B83, 0x9D0A, 0x6B85, 0x52A2, 0x6B23, 0x73A4, 0x73A4, 0x73A5, 0x83C6, 0x62E3, 0x7323, 0x93E8, 0xBD0F,
  0xB28B, 0xAA8B, 0xA26A, 0x9A2A, 0x5267, 0x4A25, 0x4204, 0x4244, 0x4AC5, 0x5AC6, 0x62A6, 0x62A6, 0x4A86, 0x5285, 0x5244, 0x49E3, 0x41C3, 0x4204, 0x4203, 0x41C2, 0x4204, 0x39E3, 0x31C2, 0x31E1, 0x3A03, 0x4A25, 0x5267, 0x6B09, 0x8B4B, 0x9B2B, 0xA36C, 
        0xAC0D, 0xCCB3, 0xE555, 0xED76, 0xF576, 0xF5B7, 0xF5B7, 0xF5B7, 0xF5D6, 0xFDD7, 0xFD76, 0xF555, 0xF555, 0xF4D3, 0xECD3, 0xECD3, 0xE513, 0xD4D0, 0xDCD1, 0xE490, 0xDC4F, 0xDCB0, 0xD491, 0xCC50, 0xBBEE, 0xBCB0, 0xB42D, 0x9BAB, 0x8B6B, 0x5224, 
        0x39A1, 0x3161, 0x3182, 0x4203, 0x4223, 0x4A84, 0x52E6, 0x738A, 0x8BCC, 0x93AC, 0x936B, 0x8BED, 0xA3F0, 0xAC12, 0xAC12, 0xBBB0, 0xA34E, 0x932C, 0x934B, 0x82A9, 0x8AAA, 0x92EB, 0x934C, 0x934B, 0x936C, 0x934C, 0x9B2C, 0xCC11, 0xCC92, 0xC490, 
        0xBBCC, 0xA287, 0xCB6D, 0xDD0F, 0xCE4C, 0x9C47, 0x9C87, 0xAD29, 0xCD4C, 0xAACA, 0x9A08, 0x81E5, 0x61E3, 0x5981, 0x4981, 0x5202, 0x6AC4, 0x6AA6, 0x4163, 0x30C1, 0x5123, 0xA32D, 0xBBAE, 0xCC10, 0xDC94, 0xE4B3, 0xD491, 0xBC0E, 0x930A, 0x6266, 
        0x7B49, 0x8389, 0x72C5, 0xAB08, 0xCD73, 0xE73B, 0xFFDE, 0xFEF9, 0xFE37, 0xF636, 0xF6D6, 0xFE9B, 0xFE9A, 0xFEB9, 0xFEF9, 0xFEB9, 0xFED9, 0xFED9, 0xFE99, 0xFEF9, 0xFEFA, 0xFEB9, 0xFE35, 0xF5D4, 0xF593, 0xE4F0, 0xC40C, 0xED11, 0xF5F4, 0xE570, 
        0xAB27, 0x2061, 0x0800, 0x2000, 0x60E3, 0xEEDA, 0xEDF5, 0xE4F0, 0xD4CE, 0x9AA8, 0xAB2A, 0xC40D, 0xDCF1, 0xF594, 0xF5D5, 0xF5F5, 0xFDF5, 0xFE77, 0xF657, 0xF657, 0xFE36, 0xFE57, 0xFE36, 0xFDF6, 0xFDF7, 0xF5F5, 0xF5D5, 0xF5B5, 0xF595, 0xF594, 
        0xF554, 0xF554, 0xF553, 0xDCF2, 0xDCF2, 0xDCF2, 0xD4F1, 0xD490, 0xDC91, 0xD490, 0xCC6E, 0xBC4E, 0xC3EE, 0xC3EE, 0xCC2D, 0xBBED, 0x8B29, 0x62E7, 0x4B05, 0x4284, 0x8BEB, 0xAC4D, 0x934A, 0x9AC8, 0x9AE9, 0x92C9, 0x8A87, 0x92A8, 0x8A67, 0x8A46, 
        0x8A66, 0x7287, 0x6A46, 0x6A05, 0x61E4, 0x51A5, 0x5965, 0x5144, 0x4143, 0x30E2, 0x38C3, 0x40E3, 0x40E3, 0x4944, 0x38E2, 0x2060, 0x0840, 0x4A25, 0x9C8D, 0x9C8C, 0x52A6, 0x73CA, 0x7C2A, 0x7C6A, 0x848A, 0x73A9, 0x73A9, 0x6B87, 0x6346, 0x7387, 
        0x7C08, 0x8449, 0x83E8, 0x31A3, 0x9CCF, 0xEF38, 0xFFBB, 0xEF36, 0xEF7A, 0xB595, 0x4A87, 0xA50F, 0xCE75, 0xADD1, 0x63C5, 0x6B86, 0x6B66, 0x6B66, 0x6B86, 0x5B84, 0x6385, 0x6B65, 0x6365, 0x7BC6, 0xACEC, 0xD653, 0xF7BA, 0xFF5A, 0xFF5A, 0xFF7A, 
        0xFFBA, 0xFFBE, 0xFFBD, 0xFFBD, 0xFFBC, 0xFFDE, 0xFFFE, 0xFFDD, 0xFFBD, 0xFFFE, 0xFFDE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFF, 0xDEFB, 0x2944, 0x7328, 0xBD4F, 0xE613, 0xB4ED, 0xA4AC, 0xB54F, 0xC611, 0x946A, 
        0x6325, 0x52A2, 0x5AC2, 0x7345, 0x39E3, 0x6308, 0xD651, 0x52E3, 0x5B23, 0x73A5, 0x7BC5, 0x5AE3, 0x6B45, 0x7385, 0x7384, 0x7BC6, 0x6B03, 0x7324, 0x9429,
  0xB2AD, 0xAAAD, 0xAAAD, 0xA2AC, 0x828B, 0x6A48, 0x6226, 0x5A26, 0x4A63, 0x5AC4, 0x5AC5, 0x5285, 0x5284, 0x5265, 0x5244, 0x4A23, 0x41E2, 0x49E3, 0x4203, 0x3A03, 0x3204, 0x39E4, 0x39A3, 0x3982, 0x4224, 0x4A44, 0x5A65, 0x6AC8, 0x934B, 0x9B8C, 0xA3AD, 
        0xABD0, 0xC491, 0xDD13, 0xED55, 0xF576, 0xF556, 0xFD76, 0xFD96, 0xFD97, 0xF5B7, 0xF596, 0xF576, 0xF556, 0xE4D4, 0xE4D3, 0xE4F3, 0xE4F2, 0xDC90, 0xDC8F, 0xDCAF, 0xECD0, 0xF492, 0xE492, 0xDC52, 0xD431, 0xCC4F, 0xB3EE, 0xABAD, 0xA38C, 0x6AA6, 
        0x5203, 0x41C2, 0x41C2, 0x3983, 0x49E3, 0x5A44, 0x6A86, 0x8B8C, 0xA40E, 0xAC0F, 0xAB8D, 0xA36F, 0xA38F, 0xB3D0, 0xC432, 0xBBD1, 0xB36F, 0xB30D, 0xAACA, 0x9AAA, 0x930C, 0x9B6D, 0xABCF, 0xAB8E, 0xABAD, 0xABAE, 0xAB8F, 0xC451, 0xD471, 0xD40F, 
        0xB36C, 0xAB2A, 0xDC91, 0xED73, 0xCD6F, 0xA448, 0xB4EA, 0xBD4B, 0xBCAB, 0x6A06, 0x6A47, 0x6AC8, 0x62E8, 0x4A45, 0x52A5, 0x52A5, 0x52A5, 0x7346, 0x6A85, 0x5203, 0x49E2, 0x6A66, 0x7A88, 0x930B, 0xB3CF, 0xC3EE, 0xD490, 0xBC0E, 0x8AA8, 0x8349, 
        0x8308, 0x7AE7, 0x8B06, 0xBCF1, 0xE6DA, 0xFFDF, 0xFFFF, 0xFFDE, 0xF6D9, 0xFE78, 0xFEBA, 0xFEB8, 0xFEB9, 0xFED9, 0xFEF8, 0xFEDA, 0xFEFB, 0xFEFA, 0xFED9, 0xFED8, 0xFEB8, 0xFEB8, 0xFEB7, 0xF5B4, 0xED52, 0xED11, 0xED12, 0xEDB3, 0x9288, 0x5881, 
        0x5081, 0x8A27, 0x89E5, 0x6942, 0x50E3, 0xD4AE, 0xDCCF, 0xD44E, 0xBBCC, 0x9AC8, 0xB3CD, 0xD4B0, 0xE4F2, 0xE572, 0xED93, 0xF594, 0xFD95, 0xF656, 0xFE56, 0xFE56, 0xFE57, 0xF616, 0xF5F6, 0xF616, 0xFE16, 0xFDB5, 0xF5B5, 0xF595, 0xF594, 0xFD74, 
        0xF574, 0xF554, 0xF533, 0xED33, 0xE532, 0xE512, 0xDCD2, 0xDCF2, 0xDC91, 0xDC50, 0xCC4E, 0xBC6F, 0xBC0E, 0xBBEE, 0xCC4F, 0xBC6D, 0x93AA, 0x5AA6, 0x3244, 0xACAD, 0xAC2D, 0x9B6B, 0x9B2A, 0x9B0A, 0x9B2A, 0x932A, 0x8B0A, 0x92E8, 0x92C8, 0x8AC7, 
        0x82A6, 0x7A67, 0x7246, 0x7246, 0x6A46, 0x5985, 0x5964, 0x5164, 0x4143, 0x38E2, 0x38E3, 0x40E3, 0x4103, 0x4902, 0x3902, 0x28C2, 0x1842, 0x0821, 0x3185, 0x7B8C, 0xC593, 0x8C2D, 0x8C2B, 0x7BEA, 0x6389, 0x9CAC, 0x9CAC, 0x8C8B, 0x7C8B, 0x7BC9, 
        0x7BA8, 0x83C8, 0x83EA, 0x6BAC, 0xAD53, 0xDED9, 0xFFBC, 0xFFDC, 0xFFDE, 0xFFFE, 0xF7BB, 0xB5B0, 0xD6B5, 0xB5F1, 0x6B45, 0x7469, 0x7C08, 0x6BA6, 0x63A4, 0x6B85, 0x6BA6, 0x6B86, 0x6345, 0x7365, 0xB550, 0xEEB6, 0xF6D7, 0xDE15, 0xDE15, 0xDE56, 
        0xDEB8, 0xFF5C, 0xFF9D, 0xFFDE, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFBE, 0xFFBE, 0xD6BA, 0x9CD1, 0xA46B, 0xD5B1, 0xDDF2, 0xBD2F, 0xBD0E, 0xBD2F, 0xACCE, 0x9C8C, 0xD652, 
        0xAD0D, 0x7BA7, 0x5AA3, 0x6B04, 0x5AA3, 0x8C2B, 0xD6B8, 0x31E3, 0x3A00, 0x52A1, 0x6303, 0x73C4, 0x6B43, 0x6303, 0x6343, 0x7B65, 0x7344, 0x6303, 0x5A81,
  0xB2AD, 0xAA8D, 0xB28C, 0xB2EB, 0x8AED, 0x8B0C, 0x8AEB, 0x7AAA, 0x5265, 0x52A4, 0x52C4, 0x52A3, 0x5A85, 0x5265, 0x4A44, 0x4A23, 0x4203, 0x4223, 0x4203, 0x31C3, 0x2982, 0x2983, 0x3163, 0x3163, 0x41E3, 0x5244, 0x5A65, 0x6288, 0x8B4A, 0x9B6C, 0xA3AD, 
        0xB42F, 0xDCB2, 0xDD13, 0xED54, 0xFD75, 0xFD77, 0xFD77, 0xFD76, 0xFDB7, 0xF5D8, 0xFDB7, 0xFD96, 0xFD75, 0xED14, 0xF4F3, 0xF4D2, 0xF4F3, 0xF4F1, 0xECCF, 0xECCF, 0xF4F2, 0xF4B2, 0xEC92, 0xEC92, 0xEC93, 0xE451, 0xC410, 0xB3CF, 0xB38D, 0x6B08, 
        0x5A64, 0x5223, 0x5224, 0x4962, 0x4183, 0x41E3, 0x5244, 0x936D, 0xABEF, 0xAC10, 0xAC10, 0xAB8F, 0xABAF, 0xB3D0, 0xC3F2, 0xCC31, 0xBC10, 0xB3AE, 0xAB0C, 0x9ACA, 0x92EA, 0x9B2C, 0xB3AE, 0xBC70, 0xBC0F, 0xB3CF, 0xB3D0, 0xC430, 0xD4B2, 0xD491, 
        0xB3CE, 0xA36A, 0xD574, 0xD613, 0xA4E7, 0xA489, 0xBD2B, 0xC52B, 0xAC2A, 0x6A68, 0x6A67, 0x6AA6, 0x6AA5, 0x4203, 0x39C2, 0x5AC5, 0x9CAC, 0x93E9, 0x7328, 0x5A85, 0x4201, 0x49A0, 0x6243, 0x7307, 0x8BCC, 0xBBEF, 0xCC31, 0xB3CD, 0x82E6, 0x9B8C, 
        0x6A87, 0x5A84, 0x83C7, 0xEF3C, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFDE, 0xFF1B, 0xFEBA, 0xFE9B, 0xF655, 0xF656, 0xFEB7, 0xFF17, 0xFEFB, 0xFF1B, 0xFF1A, 0xFED9, 0xFEB7, 0xFE97, 0xFE77, 0xFE57, 0xF575, 0xF573, 0xFDF5, 0xEE36, 0x9285, 0x6101, 0x79A5, 
        0xCC0D, 0xECD1, 0xD42E, 0xC3ED, 0xCC0D, 0xC3CE, 0xA32B, 0x9B09, 0xA34A, 0xAB8B, 0xCC2E, 0xDCB0, 0xE4F1, 0xED32, 0xF573, 0xFD94, 0xFDB5, 0xFDF4, 0xFE15, 0xFE36, 0xFE36, 0xF5F5, 0xFDF5, 0xFDF6, 0xFDF6, 0xFDD5, 0xFDD5, 0xFDB4, 0xFD74, 0xFD54, 
        0xF573, 0xF553, 0xF554, 0xED33, 0xED12, 0xE4F2, 0xE4F2, 0xDCF2, 0xDC91, 0xDC70, 0xCC70, 0xBC6F, 0xBC2F, 0xC42F, 0xCC4F, 0xBC6E, 0x8B6A, 0x6B29, 0x7BAA, 0xBCEF, 0xABCC, 0xA34B, 0xAB6C, 0x932B, 0x934A, 0x934A, 0x9329, 0x930A, 0x8309, 0x82E9, 
        0x82A9, 0x8285, 0x7A86, 0x7266, 0x6A05, 0x61A5, 0x5964, 0x5144, 0x4943, 0x40C2, 0x38C2, 0x40E3, 0x4103, 0x5103, 0x48E2, 0x4103, 0x3966, 0x3123, 0x18C2, 0x630C, 0xDEDA, 0x83EC, 0x8C4D, 0x8C4C, 0x6B68, 0x9CAE, 0x946D, 0x8C4C, 0x946D, 0x842B, 
        0x8C8C, 0x9CAE, 0xAD10, 0xF79C, 0xFFFE, 0xFFDE, 0xF79C, 0xFFFF, 0xFFDF, 0xE6FB, 0xBD73, 0xA50C, 0xD696, 0xBE14, 0x6BA7, 0x8C69, 0x8449, 0x7BC7, 0x6B25, 0x6BE6, 0x73E7, 0x6B86, 0x5B04, 0x7BA5, 0xC58F, 0xEE95, 0xE655, 0xCDD3, 0xCD92, 0xCD52, 
        0xD572, 0xF778, 0xFFDC, 0xF75B, 0xEE97, 0xFFBE, 0xFFDD, 0xFFBD, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xFFFF, 0xFFFF, 0xF79D, 0xC52F, 0xBD2E, 0xBD50, 0xBD72, 0xCD91, 0xBD50, 0xB530, 0xB510, 0xACAE, 
        0xB550, 0xA4EE, 0x7369, 0x52A4, 0x6303, 0x9488, 0xC62F, 0x4A22, 0x6B23, 0x8425, 0x7C07, 0x6324, 0x6B64, 0x7383, 0x7342, 0x6302, 0x6B43, 0x7B83, 0x7B83,
  0xB30E, 0xB2ED, 0xB2ED, 0xB2ED, 0xB2EE, 0xAB2D, 0xA38D, 0xABAD, 0x7B2B, 0x5AA5, 0x4A43, 0x49E3, 0x31C1, 0x39C2, 0x39C2, 0x29A3, 0x41C3, 0x41C2, 0x39E3, 0x39E5, 0x31A3, 0x3162, 0x3142, 0x3162, 0x41C4, 0x4A46, 0x5A87, 0x6AA8, 0x932B, 0xABAB, 0xB40E, 
        0xBC71, 0xD4D1, 0xDCF2, 0xE513, 0xED55, 0xF515, 0xF555, 0xF575, 0xF555, 0xED76, 0xED35, 0xDD14, 0xCD13, 0xCCB2, 0xD4B3, 0xE4D4, 0xF534, 0xF555, 0xF534, 0xF533, 0xF512, 0xF4D3, 0xEC92, 0xE431, 0xD3AE, 0xC38D, 0xBB6E, 0xBB6E, 0xBB8D, 0x8B07, 
        0x6AA6, 0x5A85, 0x5A25, 0x4182, 0x49A3, 0x6246, 0x8B09, 0xBC50, 0xD4F3, 0xDD14, 0xDCB3, 0xB3EF, 0xBBCF, 0xC3F0, 0xD431, 0xEC95, 0xEC53, 0xD3CF, 0xB32C, 0xB30C, 0xC3D0, 0xD494, 0xF556, 0xED34, 0xE4F4, 0xE4B4, 0xE4D3, 0xED55, 0xE533, 0xCC6F, 
        0xA32B, 0x92C8, 0xD450, 0xEE13, 0xD70D, 0x7C83, 0xAD87, 0xBDA9, 0x8C06, 0x20C1, 0x2124, 0x39E5, 0x5265, 0x5AA8, 0x5AA6, 0x4A43, 0x3A43, 0xC672, 0xBD8D, 0xA48A, 0x83E8, 0x3981, 0x28C0, 0x30C0, 0x4962, 0x6248, 0x82C8, 0x9B28, 0xA328, 0x9AAA, 
        0x92A9, 0x8A67, 0x8A06, 0xC551, 0xEF1A, 0xFFBE, 0xFFBF, 0xFFDF, 0xF77C, 0xF6BA, 0xFE18, 0xF638, 0xF5F6, 0xF637, 0xFED9, 0xFED9, 0xFEF9, 0xFEFA, 0xFEBA, 0xFEB9, 0xFE98, 0xFE37, 0xF5D5, 0xF594, 0xED74, 0xF5B4, 0xED93, 0x8184, 0xC3AB, 0xF551, 
        0xF552, 0xDCEF, 0xCC4E, 0xC3ED, 0xB3AC, 0x9B09, 0x92A7, 0x92A8, 0xA309, 0xBC0B, 0xD4AF, 0xE4F1, 0xDD11, 0xDCF1, 0xED52, 0xF573, 0xED73, 0xEDB3, 0xF5D4, 0xFDF5, 0xF5F6, 0xF636, 0xF5F5, 0xF5D5, 0xFDF5, 0xFDF6, 0xF5D5, 0xF5B5, 0xF595, 0xF573, 
        0xF573, 0xED74, 0xED54, 0xE4F3, 0xDCF2, 0xDCD1, 0xD4B1, 0xDCF2, 0xDCD1, 0xDC90, 0xCC6F, 0xD46E, 0xCC0E, 0xC40F, 0xC46F, 0xA3EB, 0x936A, 0x93AC, 0xB44D, 0xAB8B, 0xA36B, 0xA36B, 0xA38B, 0x9B09, 0x9B2A, 0xA349, 0x9B08, 0x82E9, 0x8AE9, 0x8AC8, 
        0x82C8, 0x7A87, 0x7266, 0x6A45, 0x59E4, 0x59A5, 0x5184, 0x4964, 0x4143, 0x38C1, 0x38C2, 0x38E2, 0x4103, 0x50E3, 0x50C3, 0x4103, 0x2963, 0x29A3, 0x18E2, 0x4A08, 0xB534, 0xEF3B, 0xBDB4, 0x9CCF, 0xA50F, 0xAD30, 0xAD11, 0xB4F0, 0xB510, 0xB592, 
        0xCE36, 0xD636, 0xCDD3, 0xEF7D, 0xFFDF, 0xFFDE, 0xF7DE, 0xFFFE, 0xF7BE, 0xB573, 0x5A46, 0xE71B, 0xD6D6, 0xA54E, 0x73E7, 0x8C49, 0x7BE8, 0x6B66, 0x6325, 0x73E8, 0x7387, 0x6304, 0x52C2, 0xACED, 0xDE95, 0xE6D6, 0xCDB2, 0xD5B3, 0xD5D2, 0xD5D1, 
        0xD5D1, 0xF79D, 0xE71A, 0xDED9, 0xDF1A, 0xDEB9, 0xEF1A, 0xF77C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xD637, 0x9BCC, 0xBDD2, 0xCDD2, 0xD592, 0xCD72, 0xAD10, 0xB50E, 0xB50D, 0xACCD, 0xB531, 
        0xC593, 0xACCF, 0x6305, 0x5B44, 0x8C69, 0x8C08, 0x5242, 0x5A61, 0x6B24, 0x6B66, 0x62E3, 0x4A41, 0x6B45, 0x7BA6, 0x6B24, 0x6B44, 0x6B23, 0x6B02, 0x6302,
  0xBB6E, 0xBB6E, 0xC36F, 0xC351, 0xCB92, 0xB370, 0xA32D, 0x9B2D, 0x936B, 0x72E7, 0x5A64, 0x4A23, 0x4244, 0x41E3, 0x39C2, 0x29A2, 0x41A3, 0x41C4, 0x41E4, 0x4204, 0x3184, 0x3163, 0x3142, 0x3142, 0x3983, 0x49E4, 0x5245, 0x5AA7, 0x932B, 0x9B8C, 0xABED, 
        0xBC50, 0xCC8F, 0xDCD1, 0xE512, 0xE533, 0xE514, 0xED14, 0xF514, 0xF514, 0xED16, 0xE515, 0xDCD4, 0xDCB2, 0xC451, 0xC471, 0xCCB2, 0xE4F4, 0xFD55, 0xF554, 0xF553, 0xFD74, 0xF4D5, 0xF4B4, 0xE451, 0xD38E, 0xCB8D, 0xC38D, 0xBBAE, 0xC40F, 0x9BAC, 
        0x7B08, 0x6AC5, 0x6AA5, 0x61C5, 0x6A06, 0x7267, 0x82E9, 0xBC2F, 0xD4B2, 0xDCF3, 0xE4D3, 0xCC73, 0xC3F1, 0xC3D0, 0xD411, 0xEC93, 0xE473, 0xDBF0, 0xC34D, 0xBBCF, 0xBBF0, 0xCC52, 0xDCD3, 0xE4F6, 0xE4D4, 0xE4D2, 0xECD2, 0xE536, 0xDD34, 0xC490, 
        0xA36B, 0x8AE8, 0xCCD1, 0xDDF2, 0xBDE9, 0x9C47, 0xC50A, 0xCD2A, 0x9C06, 0x39A3, 0x31A3, 0x39E3, 0x3A42, 0x52C5, 0x4A83, 0x52E4, 0x8C49, 0xCE0F, 0xAD0D, 0x8C6B, 0x7C09, 0x49C2, 0x51E2, 0x51C2, 0x4942, 0x51E4, 0x7B08, 0x936B, 0xAB0A, 0xB327, 
        0x8A04, 0x7184, 0x7AA9, 0xEF5C, 0xFFBE, 0xFF9D, 0xFF9D, 0xFFDF, 0xF79D, 0xF6FB, 0xFE39, 0xFE79, 0xFE97, 0xFE97, 0xFEBA, 0xFEFA, 0xFEFA, 0xFEFA, 0xFEB9, 0xFEFB, 0xFED9, 0xFE98, 0xFE57, 0xFE16, 0xFDD5, 0xFDD5, 0xFDD5, 0xF593, 0xF594, 0xF573, 
        0xED32, 0xE553, 0xDCD0, 0xD44E, 0xC3CD, 0xAB8A, 0xAB8B, 0xAB8B, 0xABAB, 0xD4AF, 0xDCF1, 0xDCF2, 0xDCF1, 0xED32, 0xED52, 0xED53, 0xED73, 0xF553, 0xF573, 0xF593, 0xF5B4, 0xFE15, 0xFDF5, 0xFDD5, 0xF594, 0xF593, 0xF594, 0xF594, 0xFD94, 0xF594, 
        0xF573, 0xED53, 0xF553, 0xE513, 0xE4F2, 0xDCD1, 0xDCB1, 0xE4F1, 0xDCB1, 0xD491, 0xCCB0, 0xCC6E, 0xCC0E, 0xCC0F, 0xCC8F, 0xA3EC, 0xA42D, 0xAC2D, 0xABAC, 0xB36B, 0xAB8C, 0xAB8C, 0xABAB, 0xA34B, 0xA34A, 0xA34A, 0x9B2B, 0x92C8, 0x92C8, 0x92E8, 
        0x82C8, 0x6A86, 0x7266, 0x7246, 0x6225, 0x59C4, 0x49A3, 0x4963, 0x4903, 0x38E3, 0x40C4, 0x48C3, 0x5103, 0x4143, 0x3183, 0x2962, 0x1901, 0x21A3, 0x10C1, 0x0020, 0x18E3, 0xDEDB, 0xC636, 0xAD32, 0xAD11, 0xC5D5, 0xD657, 0xDE98, 0xE6B9, 0xDEF8, 
        0xBDB4, 0xB513, 0xC555, 0xEF7B, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xEF5D, 0xBDB5, 0x8C0A, 0xEF5C, 0xE73A, 0xBDD2, 0x8C08, 0x9CA9, 0x8427, 0x73C7, 0x7BE7, 0x7BE7, 0x6B85, 0x5B23, 0x6383, 0xD693, 0xE6B5, 0xDE54, 0xDE33, 0xF779, 0xE6B7, 0xE676, 
        0xF6D6, 0xEEB5, 0xB4EE, 0xA46C, 0xBD31, 0xD551, 0xD5F4, 0xDE97, 0xE719, 0xFFBC, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xDEB9, 0xCDD6, 0xB553, 0xACF0, 0xB4EE, 0xBD30, 0xC552, 0xCD52, 0xBD53, 0xBD30, 0xB52F, 0xB50F, 0xA48B, 
        0xACCE, 0xCDF4, 0xEF59, 0x9CCB, 0x83E8, 0x7387, 0x73A6, 0xACE9, 0x8BE6, 0x6303, 0x5AA3, 0xA4AB, 0x8C09, 0x7BA6, 0x7BC6, 0x9427, 0x9427, 0x9468, 0x9CCA,
  0xAB8C, 0xB3CF, 0xC411, 0xC412, 0xCC13, 0xC472, 0xB431, 0xA36E, 0xA32D, 0x8B0B, 0x6AA7, 0x4A22, 0x4A44, 0x4204, 0x39E4, 0x29C3, 0x49A3, 0x49E3, 0x4A24, 0x4A25, 0x49E4, 0x39C4, 0x3183, 0x2961, 0x3983, 0x4A05, 0x5265, 0x5265, 0x7B2A, 0x8B4B, 0xA3AC, 
        0xBC2F, 0xC490, 0xD4F2, 0xE512, 0xE512, 0xE513, 0xECD3, 0xECD3, 0xE4F3, 0xED15, 0xE515, 0xDCF4, 0xCCB2, 0xBC10, 0xC410, 0xCC31, 0xE4B3, 0xFD55, 0xFD76, 0xFD75, 0xFD54, 0xFD35, 0xFCF4, 0xF4B3, 0xEC51, 0xC32C, 0xB36D, 0xB3AE, 0xBBEE, 0xAC4D, 
        0x9B8A, 0x82E8, 0x7A65, 0x79E5, 0x69C4, 0x6A26, 0x7ACA, 0xABCE, 0xD492, 0xED14, 0xF514, 0xE473, 0xDC32, 0xDC12, 0xDBD2, 0xEC94, 0xECB4, 0xE473, 0xD3F0, 0xC34E, 0xD3D0, 0xDC73, 0xECF5, 0xFD35, 0xECF4, 0xECD4, 0xECD4, 0xF517, 0xF556, 0xD4B3, 
        0xA3AE, 0x8B68, 0xCD93, 0xDE74, 0xB5CB, 0xC58D, 0xB52D, 0x8BC8, 0x49E1, 0x4A22, 0x5224, 0x5204, 0x59E4, 0x4204, 0x4A65, 0x83EA, 0xC5D0, 0x9BC6, 0xACCA, 0x8C89, 0x4A81, 0x38E0, 0x41A4, 0x41C4, 0x3921, 0x59C3, 0x5A87, 0x734A, 0x9BCD, 0x7A86, 
        0x72C7, 0x9CB0, 0xF79C, 0xFFB9, 0xFF9C, 0xFFBE, 0xFFDD, 0xFF7D, 0xFFBE, 0xFF7D, 0xF6BA, 0xFE77, 0xFEB7, 0xFED8, 0xFED9, 0xFED9, 0xFED9, 0xFEDA, 0xFEB9, 0xFF1B, 0xFF19, 0xFED8, 0xFE98, 0xF636, 0xFE56, 0xFE97, 0xFEB8, 0xFE57, 0xFDB4, 0xFDB4, 
        0xFE15, 0xFDD4, 0xF553, 0xE4F1, 0xD4AF, 0xB40D, 0xBC2E, 0xC46E, 0xCC8E, 0xDCAF, 0xD4B0, 0xD4D1, 0xDCF1, 0xED73, 0xED52, 0xED51, 0xED52, 0xF572, 0xF573, 0xF553, 0xF553, 0xF5B3, 0xF5D4, 0xFDD5, 0xFDB4, 0xFD74, 0xFD74, 0xFD94, 0xFD94, 0xF594, 
        0xF573, 0xF553, 0xED12, 0xED33, 0xED12, 0xECF2, 0xECF2, 0xDCD1, 0xDCB1, 0xDCB1, 0xD4D1, 0xD48F, 0xD44F, 0xD40F, 0xC40E, 0xC44F, 0xBC4F, 0xB40D, 0xB3CC, 0xBBAD, 0xB3AD, 0xABAC, 0xA3AC, 0xB36D, 0xA36C, 0x9B6C, 0x9B6C, 0x9B09, 0x92E9, 0x8AE9, 
        0x82A9, 0x72A5, 0x7A66, 0x7A46, 0x7225, 0x59C5, 0x5184, 0x5144, 0x4925, 0x40C3, 0x40C4, 0x48E3, 0x5903, 0x39A4, 0x21C2, 0x1981, 0x2142, 0x10E1, 0x1101, 0x10C1, 0x0841, 0x51E7, 0xBD95, 0xDED9, 0xBDD4, 0xBD76, 0xC595, 0xD616, 0xDEB8, 0xE6D9, 
        0xE698, 0xDE38, 0xCDB8, 0xDE95, 0xEF7B, 0xFFDF, 0xFFBF, 0xFFFF, 0xF7DD, 0xBE14, 0x73C8, 0xE73B, 0xD699, 0xBDB2, 0xAD4A, 0x9CEA, 0x94AA, 0x8C88, 0x7C25, 0x7C47, 0x7C27, 0x5B24, 0x4A44, 0xE6F8, 0xDDF4, 0xDDF5, 0xFFBD, 0xFFDD, 0xF759, 0xF717, 
        0xF717, 0xDE32, 0xEEB5, 0xE633, 0xBCCD, 0xBD0F, 0xC550, 0xC550, 0xB50F, 0x8C0C, 0xAD10, 0xCDF5, 0xDE18, 0xBD93, 0xC5D5, 0xCE17, 0xC5D5, 0xAD11, 0x944E, 0xA4AF, 0xC5B2, 0xBD32, 0xC573, 0xCD74, 0xC533, 0xC574, 0xC593, 0xC573, 0xBD34, 0xD591, 
        0xC530, 0xACAE, 0x9C6E, 0xEE95, 0xFF78, 0xEF17, 0xCDD1, 0x9487, 0x6B43, 0x83E7, 0xD610, 0xDE50, 0xB50C, 0xA4A9, 0xB54B, 0xD5AF, 0xEEB3, 0xFF77, 0xFFFB,
  0xB370, 0xB38E, 0xBBAF, 0xC3B2, 0xCC53, 0xCC14, 0xCBF2, 0xB3CF, 0x7269, 0x5A66, 0x5245, 0x4A24, 0x4A85, 0x4A44, 0x4204, 0x41E3, 0x3182, 0x41E3, 0x4A24, 0x4A25, 0x4225, 0x41C4, 0x31A3, 0x2182, 0x31A3, 0x31C4, 0x31E4, 0x3A25, 0x7AE8, 0x936A, 0xABED, 
        0xBC70, 0xCC70, 0xD4D1, 0xD4F2, 0xD4D2, 0xD4D1, 0xD4B1, 0xD491, 0xCC71, 0xB453, 0xAC31, 0xA410, 0x93AF, 0x7AEC, 0x9B2C, 0xBBAE, 0xDC52, 0xFD58, 0xFD98, 0xFDB8, 0xFD98, 0xF575, 0xF515, 0xEC94, 0xDBD1, 0xBB0C, 0xC36D, 0xCBCF, 0xCC30, 0xB3ED, 
        0x9BCA, 0x93AA, 0x938A, 0x938A, 0x9B6C, 0xAB8C, 0xBBED, 0xCC72, 0xE4D4, 0xECF4, 0xECD4, 0xE472, 0xDC32, 0xDC12, 0xE411, 0xE453, 0xE431, 0xDBEF, 0xDB8E, 0xD430, 0xE493, 0xF4B5, 0xECB6, 0xE432, 0xE453, 0xE493, 0xF4F4, 0xFD38, 0xE4D4, 0xBBED, 
        0x8A87, 0x8AE6, 0xC44D, 0xDDEF, 0xCF0D, 0xB58D, 0xBD6D, 0x9CCA, 0x6324, 0x20C1, 0x3162, 0x41A4, 0x4166, 0x39E3, 0x39E2, 0x62A5, 0xAC49, 0xC5EC, 0xAD07, 0x9C86, 0x946A, 0x4206, 0x3984, 0x3142, 0x3120, 0x39A1, 0x49A3, 0x6226, 0x7B0A, 0x59E5, 
        0x5963, 0x938C, 0xEF7C, 0xFFFF, 0xFF9D, 0xF77D, 0xF7BE, 0xFFDE, 0xFFBE, 0xF75B, 0xF6B8, 0xFE7A, 0xFE58, 0xFE57, 0xFE97, 0xFE97, 0xFE98, 0xFEB8, 0xFEF9, 0xFED7, 0xFEB8, 0xFEB8, 0xFE77, 0xF5F5, 0xF636, 0xFEB7, 0xFF18, 0xFE77, 0xF656, 0xF676, 
        0xFED7, 0xFE57, 0xED94, 0xDD11, 0xD4CF, 0xC46D, 0xD4AE, 0xDCCF, 0xDCAE, 0xD4CE, 0xDCF0, 0xDD11, 0xCD30, 0xE511, 0xED12, 0xE531, 0xE550, 0xF572, 0xF553, 0xED52, 0xED72, 0xED73, 0xF5B4, 0xF5B4, 0xF5B3, 0xF574, 0xED73, 0xED73, 0xF5B3, 0xF553, 
        0xED73, 0xED73, 0xF553, 0xE512, 0xDCF1, 0xDD11, 0xE512, 0xDCD0, 0xDCF1, 0xD4F1, 0xD4B1, 0xD4AF, 0xCC6E, 0xC42E, 0xBC0E, 0xC44E, 0xBBEE, 0xBBCD, 0xBBCC, 0xB3CD, 0xB3CD, 0xABAC, 0xABAC, 0xAB8C, 0xAB8B, 0xA36A, 0xA329, 0x930A, 0x92E9, 0x8AC8, 
        0x82A7, 0x7A88, 0x7246, 0x6A25, 0x59E5, 0x51A5, 0x5164, 0x5123, 0x48E3, 0x40E3, 0x40C3, 0x4104, 0x4986, 0x41A2, 0x31A1, 0x2983, 0x2944, 0x08C1, 0x08C0, 0x1080, 0x1000, 0x1082, 0x8C0E, 0xCE36, 0xCE38, 0xBD13, 0xB534, 0xC596, 0xE678, 0xEF1C, 
        0xDE9A, 0xC5F6, 0xB573, 0xE6B9, 0xF79D, 0xFFDE, 0xFFBE, 0xF7BE, 0xC5D3, 0xAD2C, 0xBE2C, 0xEF9B, 0xC5F3, 0xA4ED, 0x94CD, 0xA4EA, 0x8467, 0x7405, 0x7404, 0x7C08, 0x6B65, 0x6304, 0x7386, 0xE73B, 0xD636, 0xD636, 0xF7BD, 0xFF38, 0xE6B6, 0xE696, 
        0xFED7, 0xF77A, 0xA4AE, 0x8BA8, 0xB4EC, 0xDE15, 0xBD0F, 0x8BC8, 0x6304, 0xC5AF, 0xE694, 0xEEB5, 0xE634, 0xE676, 0xD613, 0xB52F, 0x7BCA, 0x7346, 0x944B, 0xB52F, 0xBD70, 0xB512, 0xB4F2, 0xBCF2, 0xBCF2, 0xB532, 0xBD53, 0xBD32, 0xBD31, 0xBD52, 
        0xBD4F, 0xC54E, 0xCD4F, 0xCD95, 0xCDD5, 0xCE12, 0xC5AE, 0x5AA2, 0x6304, 0x9CED, 0xE718, 0x7B68, 0x9C49, 0xC54C, 0xDDAE, 0xCDF3, 0xCDD2, 0xCD92, 0xC553,
  0x8B29, 0x9B8B, 0xA3CD, 0xA3AD, 0x9B2C, 0xA36C, 0xA38C, 0x936C, 0x72A8, 0x5265, 0x4A44, 0x5284, 0x5A85, 0x5265, 0x4A45, 0x4A04, 0x3983, 0x41E3, 0x4A44, 0x4A65, 0x4A45, 0x4225, 0x3A03, 0x29E2, 0x31A2, 0x2981, 0x2141, 0x2942, 0x6AE8, 0x936B, 0xABED, 
        0xBC6D, 0xC4B2, 0xCCB1, 0xD4D1, 0xD4D2, 0xDCF1, 0xDCD1, 0xD4B1, 0xC46F, 0xABAF, 0xA3AF, 0x9BAF, 0x938F, 0x8B2D, 0x9B2D, 0xB3AF, 0xDC93, 0xF556, 0xFD78, 0xFD98, 0xFDB8, 0xFD57, 0xFD56, 0xF515, 0xE4B4, 0xC30C, 0xCB6F, 0xD3F0, 0xCC0F, 0xBC0D, 
        0xABCC, 0xAB8C, 0xAB6C, 0xB40C, 0xBC0D, 0xBC0F, 0xCC11, 0xDC52, 0xE493, 0xECD4, 0xECD4, 0xD451, 0xDBF2, 0xE3B2, 0xE391, 0xE3D1, 0xE3D1, 0xDBD0, 0xD3CE, 0xD3EC, 0xDC0F, 0xE431, 0xE472, 0xE432, 0xE452, 0xEC72, 0xF493, 0xED18, 0xE516, 0xABAE, 
        0x51A4, 0x7AE9, 0xB46F, 0xD5B1, 0xE66F, 0xBDAB, 0xC5EE, 0xAD2D, 0x6AC5, 0x2061, 0x3123, 0x3984, 0x3164, 0x39C4, 0x41C4, 0x7347, 0xCDCC, 0xB4C9, 0xACC8, 0xA4A7, 0x8BE5, 0x5AA4, 0x41E3, 0x4163, 0x4143, 0x4142, 0x49A4, 0x6247, 0x72A7, 0x18A2, 
        0x730C, 0xC5B7, 0xF7BE, 0xFF5F, 0xFFBF, 0xFFDD, 0xFF9C, 0xFF5D, 0xFF9D, 0xFF7C, 0xF6DA, 0xF659, 0xFE57, 0xFE77, 0xFE97, 0xFE98, 0xFE98, 0xFEB8, 0xFEF8, 0xFED8, 0xFED7, 0xFEB7, 0xFE97, 0xFDF5, 0xF656, 0xFEB8, 0xFEFA, 0xF6B8, 0xF677, 0xF697, 
        0xFED9, 0xFEB7, 0xF614, 0xE572, 0xDCF1, 0xD50F, 0xD510, 0xD4EF, 0xD4EF, 0xD4D1, 0xDCF1, 0xDCF1, 0xE4F1, 0xE511, 0xE511, 0xE511, 0xE530, 0xE532, 0xED32, 0xED51, 0xED51, 0xED72, 0xED73, 0xED73, 0xF593, 0xF554, 0xED73, 0xF573, 0xF553, 0xED73, 
        0xED73, 0xF553, 0xED32, 0xE551, 0xE531, 0xE511, 0xDD11, 0xDCF1, 0xD4B0, 0xD4B0, 0xD4B1, 0xCC6F, 0xCC4F, 0xCC4E, 0xD44E, 0xBC2F, 0xBC2E, 0xBC2E, 0xB40E, 0xB3CC, 0xB3CC, 0xB3CD, 0xABAC, 0xAB6B, 0xAB6C, 0xA36B, 0x9B4A, 0x9B2A, 0x92E9, 0x92C8, 
        0x8AE7, 0x7287, 0x7246, 0x6A25, 0x6205, 0x5184, 0x5964, 0x4944, 0x2143, 0x48A2, 0x48C3, 0x4924, 0x3983, 0x29A3, 0x2982, 0x2142, 0x18C1, 0x18C1, 0x1081, 0x18A2, 0x2903, 0x0820, 0x0841, 0x5AEB, 0xE71B, 0xB513, 0xB4D3, 0xC555, 0xE617, 0xEEFC, 
        0xE6BA, 0xD617, 0xBD95, 0xDEB9, 0xF77D, 0xFFDF, 0xFFDF, 0xF7BD, 0xBDD2, 0xB550, 0xD677, 0xF79D, 0xC5F4, 0xAD2E, 0xAD4D, 0x9D08, 0x94E8, 0x8CA7, 0x7C67, 0x7C09, 0x52A5, 0x7BCA, 0xE717, 0xACF0, 0xDE98, 0xFF9C, 0xF73A, 0xDE13, 0xE655, 0xF6F8, 
        0xF79B, 0xC56F, 0x6AA6, 0x51C2, 0x7AE5, 0x93E9, 0x8BE9, 0x83E9, 0x9409, 0x83A6, 0x9428, 0x9C4B, 0x942C, 0xAC8C, 0xB50D, 0x83E9, 0x3161, 0x2940, 0x4A23, 0x5A84, 0x62C4, 0x9C89, 0xA4AA, 0x9C69, 0x9468, 0xACAE, 0xB4EE, 0xB52F, 0xBD50, 0xBD50, 
        0xBD11, 0xBD11, 0xC552, 0xD613, 0xCDF1, 0x946B, 0x39E1, 0x62E2, 0xAD0B, 0xAD0D, 0x7B88, 0xE613, 0xE655, 0xE635, 0xE634, 0xF675, 0xEE76, 0xEE77, 0xF678,
  0x7B6A, 0x836A, 0x8B6B, 0x9B8E, 0xA3D0, 0x9B6E, 0x934D, 0x8B6D, 0x6AA8, 0x5265, 0x5264, 0x5A86, 0x5AA5, 0x5A85, 0x5265, 0x4A44, 0x49E3, 0x4203, 0x4224, 0x4A45, 0x5285, 0x4A64, 0x4243, 0x3222, 0x39A2, 0x3182, 0x2942, 0x2101, 0x6285, 0x8309, 0xA38C, 
        0xBC2F, 0xC4F0, 0xD4D1, 0xDCD2, 0xDCD1, 0xD4F0, 0xDCD1, 0xDCB1, 0xCC91, 0xB431, 0xA3F0, 0x9BAF, 0x9370, 0x8B0D, 0x930D, 0xAB4E, 0xC411, 0xF536, 0xFD77, 0xFD78, 0xFDB8, 0xF5D8, 0xFD77, 0xFD36, 0xF4B4, 0xDBD0, 0xDBEF, 0xDBF0, 0xDC11, 0xBC2E, 
        0xB40D, 0xB3EC, 0xB3ED, 0xBBEE, 0xBC0F, 0xC410, 0xCC10, 0xDC72, 0xEC93, 0xF494, 0xF494, 0xEC52, 0xEBF2, 0xEBD2, 0xEBB2, 0xE3B1, 0xE3D1, 0xDBD0, 0xDBCF, 0xD3AE, 0xDC2F, 0xEC91, 0xF492, 0xE451, 0xE432, 0xE452, 0xEC93, 0xF514, 0xED14, 0xCC70, 
        0x930A, 0x5183, 0xB4B0, 0xEEB4, 0xDEAE, 0xBD8D, 0xB54D, 0x8C09, 0x4982, 0x20E2, 0x2943, 0x31A4, 0x31A5, 0x38E1, 0x6AA5, 0xA46A, 0xD58D, 0xACE7, 0xA4E7, 0x8C67, 0x7387, 0x836A, 0x6A48, 0x51A5, 0x5183, 0x5163, 0x5984, 0x4903, 0x28A2, 0xA491, 
        0xE6DA, 0xFFBF, 0xFFBF, 0xFF7D, 0xFF7C, 0xF77D, 0xF77D, 0xFF9D, 0xFFDD, 0xFFBD, 0xFF5B, 0xF659, 0xFE78, 0xFE97, 0xFE98, 0xFE98, 0xFEB8, 0xFED8, 0xFEB8, 0xFEF7, 0xFED6, 0xFEB7, 0xFE97, 0xF5F6, 0xFE76, 0xFED8, 0xFF1B, 0xFED8, 0xFE76, 0xFE76, 
        0xFED8, 0xFF18, 0xF655, 0xF593, 0xED31, 0xED31, 0xE512, 0xDCF1, 0xD4AF, 0xD4D0, 0xDD11, 0xE512, 0xED33, 0xED31, 0xE531, 0xDD31, 0xE550, 0xE531, 0xED31, 0xED31, 0xED51, 0xED52, 0xED53, 0xF553, 0xFD53, 0xF594, 0xF574, 0xF553, 0xF553, 0xF553, 
        0xF552, 0xF553, 0xF553, 0xED52, 0xED32, 0xED12, 0xE512, 0xDCB0, 0xDCB0, 0xD4B0, 0xD490, 0xD4AF, 0xD48F, 0xCC6F, 0xC44F, 0xC42F, 0xC42F, 0xC42F, 0xBC0F, 0xB3EE, 0xB3CD, 0xB3AD, 0xABCD, 0xABCC, 0xA38C, 0xA38C, 0xAB6B, 0x932A, 0x930A, 0x8AE9, 
        0x82C8, 0x7288, 0x7266, 0x7245, 0x6205, 0x5964, 0x5964, 0x5144, 0x4924, 0x48A1, 0x5122, 0x4983, 0x31A3, 0x29A2, 0x2941, 0x2101, 0x10C1, 0x10C1, 0x1081, 0x18A2, 0x20C3, 0x1061, 0x5A87, 0x838A, 0x83CC, 0xE73C, 0xC5D7, 0xB4F3, 0xD596, 0xF73B, 
        0xE6DB, 0xD658, 0xC615, 0xDE56, 0xEF5C, 0xFFFF, 0xFFFF, 0xF7BE, 0xBDD3, 0xAD50, 0xC636, 0xF79D, 0xDE56, 0xBD70, 0xAD4D, 0xB56D, 0xA52B, 0x9CE9, 0x94C9, 0x7C48, 0x5AE5, 0x840C, 0xEF3B, 0xE5F3, 0xF6F9, 0xFF7B, 0xFED7, 0xDDF4, 0xE654, 0xEE54, 
        0xE5B3, 0x9BEB, 0xB4CE, 0xBCEE, 0x9BEB, 0x7347, 0xA4CC, 0xB50D, 0x9408, 0xA4AA, 0xB52D, 0xAD0E, 0xA4AE, 0xC58E, 0xC5F1, 0x946C, 0x41E2, 0x5A83, 0x5282, 0x4241, 0x4200, 0x7323, 0x9426, 0x9466, 0x8404, 0x9427, 0x9448, 0x8C28, 0x7BC7, 0x8B86, 
        0x93E9, 0xA46D, 0xACAF, 0x7B66, 0x6AE4, 0x62E5, 0x7B46, 0x9487, 0x8C06, 0x7325, 0x7328, 0xEF3A, 0xF6F7, 0xE655, 0xE5F5, 0xE595, 0xEE78, 0xF6B9, 0xF677,
  0x72C7, 0x6A65, 0x6246, 0x6A88, 0xA3CE, 0x9BAC, 0x934A, 0x82E9, 0x4A64, 0x4A23, 0x4A24, 0x4A45, 0x5244, 0x5244, 0x5265, 0x5265, 0x4203, 0x4203, 0x4204, 0x4A24, 0x4A65, 0x4A65, 0x4224, 0x41E3, 0x31E2, 0x31C2, 0x2982, 0x2161, 0x62A5, 0x9329, 0xABAC, 
        0xB42D, 0xCCB2, 0xD4D1, 0xD4F1, 0xCCF0, 0xDD12, 0xDCF1, 0xD4D0, 0xC46F, 0xA38D, 0x936E, 0x8B4D, 0x8B2D, 0x9390, 0xABF1, 0xBC31, 0xCC73, 0xF558, 0xFD57, 0xF577, 0xFD97, 0xFD99, 0xF557, 0xFD16, 0xF4D4, 0xDC12, 0xDC12, 0xE451, 0xDC90, 0xB3CD, 
        0xB3ED, 0xBC0D, 0xBC2E, 0xCC6F, 0xD471, 0xDC92, 0xDCD3, 0xECB3, 0xF4B4, 0xECB4, 0xEC93, 0xE371, 0xE391, 0xE3B2, 0xDB72, 0xCB6C, 0xD38D, 0xD3AD, 0xD3ED, 0xD44E, 0xD44E, 0xD42D, 0xDC0D, 0xCC0E, 0xD430, 0xE472, 0xF4B3, 0xF476, 0xDC73, 0xBC51, 
        0x9BAD, 0x5163, 0x938C, 0xCD32, 0xDDCF, 0xCE2C, 0xCE0C, 0xB52A, 0x7B65, 0x1081, 0x2103, 0x3164, 0x2923, 0x1901, 0x3142, 0x7328, 0xD62F, 0xBD0B, 0xA4A8, 0xA4E6, 0xAD27, 0x6B85, 0x62C6, 0x5A45, 0x51A4, 0x4163, 0x4102, 0x5943, 0x92AA, 0xEF5C, 
        0xFFFE, 0xFF9B, 0xFF1A, 0xFFDE, 0xFFDE, 0xFF9D, 0xF73B, 0xEF3A, 0xF75C, 0xFF5C, 0xF73A, 0xFE37, 0xFE37, 0xFE57, 0xFE78, 0xFED8, 0xFEB8, 0xFEB8, 0xFED8, 0xFED7, 0xFE97, 0xF656, 0xF635, 0xFE56, 0xFE78, 0xFE38, 0xF5F7, 0xFE77, 0xFE57, 0xFE77, 
        0xFED7, 0xFDD5, 0xF5B4, 0xED72, 0xD510, 0xDD32, 0xDCEF, 0xDCAD, 0xDCAE, 0xCCEE, 0xD4F0, 0xDCF2, 0xD4F1, 0xD4F1, 0xD4F0, 0xD4F0, 0xDCF1, 0xDD10, 0xE511, 0xE511, 0xE4F0, 0xDCF0, 0xE531, 0xED12, 0xE4F1, 0xED73, 0xF593, 0xED73, 0xED32, 0xED32, 
        0xED52, 0xED53, 0xF553, 0xE551, 0xE512, 0xE511, 0xDD10, 0xDCB0, 0xDCB1, 0xD4B1, 0xD4B0, 0xCC6F, 0xCC6F, 0xCC6F, 0xD46F, 0xBC6D, 0xC42E, 0xC42E, 0xC44D, 0xB3ED, 0xB3CC, 0xB3CC, 0xABAC, 0xB38C, 0xAB8C, 0x9B6B, 0x9B6B, 0x932A, 0x92E9, 0x92E9, 
        0x82C9, 0x7287, 0x6A45, 0x6A05, 0x61C5, 0x5164, 0x5124, 0x5124, 0x4904, 0x40A3, 0x5143, 0x49C3, 0x29E3, 0x19C1, 0x1961, 0x18E0, 0x10A1, 0x18C2, 0x18C2, 0x18C2, 0x1080, 0x1082, 0x8C2E, 0x9C8E, 0x4A25, 0xE6FB, 0xDE57, 0xCDB4, 0xCE15, 0xDE5B, 
        0xD678, 0xCE56, 0xC614, 0xDEB7, 0xF77C, 0xFFFF, 0xFFFF, 0xF79C, 0xAD4F, 0xAD4F, 0xF79D, 0xF79D, 0xC5D2, 0xAD0D, 0xAD4D, 0xA54A, 0x9CE9, 0x9D0A, 0xAD4C, 0x5324, 0x8C6B, 0xCE34, 0xF7DD, 0xFFDE, 0xF6F9, 0xF676, 0xF696, 0xDE35, 0xDE35, 0xD5B2, 
        0xBCAD, 0xCD31, 0xCD71, 0xB4AE, 0x7B68, 0x9C29, 0x8BC8, 0x83A7, 0x83E6, 0xA488, 0xB4EB, 0xACCC, 0x9C8B, 0xC58D, 0x7BA8, 0x4223, 0x39E1, 0x5B04, 0x5AE3, 0x52A2, 0x4AA2, 0x5AA3, 0x7326, 0x9409, 0xA4CB, 0x7BE9, 0x83E9, 0x8428, 0x8426, 0x93C9, 
        0x9C4C, 0xA44D, 0x8BCB, 0x62E4, 0x6304, 0x7BA5, 0x9C88, 0x8C27, 0x83C7, 0x8C0A, 0xAD10, 0xEE76, 0xF698, 0xE657, 0xD5F6, 0xE5F6, 0xDD96, 0xDDB6, 0xEE78,
  0x6326, 0x62E5, 0x62A4, 0x5A65, 0x5288, 0x62A8, 0x62C8, 0x52A6, 0x5A44, 0x4A24, 0x4223, 0x41E2, 0x4A24, 0x4A44, 0x4A44, 0x4A24, 0x4A25, 0x4A04, 0x4203, 0x4224, 0x4264, 0x4224, 0x4225, 0x4224, 0x3A03, 0x4203, 0x39A3, 0x3163, 0x62A5, 0x8309, 0x9B8C, 
        0xBC6E, 0xCC91, 0xCCD1, 0xD4D1, 0xD4D2, 0xDD10, 0xDCF1, 0xE4F2, 0xDCF1, 0xC472, 0xBC72, 0xB452, 0xA412, 0xAC72, 0xB431, 0xC451, 0xE4F3, 0xECD5, 0xF4F5, 0xF535, 0xED35, 0xF557, 0xF557, 0xF536, 0xECF5, 0xF453, 0xF453, 0xE452, 0xDC50, 0xC3ED, 
        0xA36C, 0x9B4B, 0xB36C, 0xBC0E, 0xCC2E, 0xDC50, 0xEC93, 0xE493, 0xE493, 0xEC73, 0xEC53, 0xE3D2, 0xE3D2, 0xDBD1, 0xDB90, 0xDBD1, 0xD3EF, 0xD40E, 0xD44E, 0xD42D, 0xD44D, 0xD44D, 0xD44E, 0xD46E, 0xD44E, 0xDC50, 0xE4B3, 0xECF4, 0xE4D4, 0xDCD3, 
        0xD4B0, 0x93AC, 0xB430, 0xBCB0, 0xBD0C, 0xD5ED, 0xCDAC, 0xBD2B, 0x940A, 0x18A1, 0x18A1, 0x2122, 0x2182, 0x2101, 0x3141, 0x5243, 0x8BE7, 0xCE0C, 0xBD89, 0xAD08, 0xACC9, 0x7B69, 0x72A8, 0x6A47, 0x6226, 0x5A07, 0x6164, 0x7163, 0x79C5, 0x6A26, 
        0xBD33, 0xEF1B, 0xF75D, 0xEEB9, 0xF71B, 0xFF5C, 0xFF5C, 0xF77B, 0xF77B, 0xF75B, 0xFF1B, 0xFF5A, 0xFEB8, 0xFE77, 0xFE77, 0xFE98, 0xFEB8, 0xFEB8, 0xFEB8, 0xFE77, 0xFEB7, 0xFEB7, 0xFE96, 0xF616, 0xF5D5, 0xF594, 0xED52, 0xD4B1, 0xD4D0, 0xE531, 
        0xF593, 0xF615, 0xF5F4, 0xEDB3, 0xE592, 0xDD51, 0xE512, 0xDCD0, 0xD46D, 0xD50F, 0xD4CE, 0xDC8D, 0xD4AD, 0xD4CF, 0xD4AF, 0xD4AE, 0xDCAD, 0xE4F2, 0xE4D1, 0xE4CF, 0xDCCE, 0xDCF0, 0xDD11, 0xDCF1, 0xD4D0, 0xDCF1, 0xED32, 0xED53, 0xED52, 0xED32, 
        0xED53, 0xED53, 0xF552, 0xE552, 0xE532, 0xDD11, 0xDD11, 0xDCD0, 0xDCD0, 0xDCF1, 0xDCD1, 0xCC6E, 0xC44E, 0xCC6E, 0xCC8F, 0xC44E, 0xC42E, 0xC42D, 0xBC0D, 0xBC2D, 0xBC0D, 0xB3CC, 0xAB8A, 0xB3ED, 0xABAC, 0xA36B, 0x9B4B, 0x9329, 0x92E9, 0x92C8, 
        0x82A6, 0x7268, 0x6A26, 0x61E5, 0x51A5, 0x5143, 0x4922, 0x4902, 0x48E3, 0x5123, 0x49A4, 0x41E3, 0x31C1, 0x2982, 0x2101, 0x20C0, 0x18C0, 0x10A1, 0x20E3, 0x18A3, 0x1061, 0x7309, 0xACEF, 0x944B, 0x3A23, 0x8C2D, 0xD678, 0xDE9A, 0xBD34, 0xD617, 
        0xDE58, 0xDE77, 0xCE76, 0xC5F5, 0xE6FA, 0xFFBE, 0xF7BE, 0xCE55, 0xB58E, 0xC631, 0xF7BD, 0xE6F9, 0xBD91, 0xAD4E, 0xB5CF, 0xAD2E, 0xAD8E, 0xBE0D, 0xBE0D, 0x7347, 0xC5F2, 0xF7B9, 0xFFBA, 0xFEDA, 0xFED8, 0xF6D7, 0xE697, 0xE675, 0xDE14, 0xD592, 
        0xBCD0, 0xB48D, 0xBCEF, 0xCCF0, 0xCCD0, 0x9C8B, 0xB54C, 0xA4CA, 0x6B44, 0x72C3, 0x6B04, 0x7345, 0x8BA6, 0xAD0B, 0x5285, 0x3181, 0x5281, 0x4A82, 0x4A62, 0x52A2, 0x6303, 0x6B47, 0x39C3, 0x3982, 0x7347, 0xD6B9, 0xEF9A, 0xDED4, 0xB56C, 0xD633, 
        0xB52D, 0x8BC6, 0x62C2, 0x6304, 0x7385, 0x7365, 0x6324, 0x7BC7, 0x5AE4, 0x6B26, 0xBCEF, 0xF6F9, 0xF699, 0xEE38, 0xEE18, 0xEE79, 0xE617, 0xE637, 0xF6B8,
  0x7B4B, 0x6AE9, 0x6AC8, 0x6AA7, 0x7285, 0x6A87, 0x6A88, 0x72A6, 0x5284, 0x4A44, 0x4A23, 0x4223, 0x5243, 0x4A44, 0x4A44, 0x5245, 0x4A44, 0x4A24, 0x4223, 0x4202, 0x4264, 0x4A25, 0x5225, 0x5A45, 0x5286, 0x4225, 0x39A3, 0x4143, 0x5223, 0x7AA7, 0x9B4B, 
        0xB3ED, 0xCCB1, 0xD4F2, 0xDD12, 0xDD11, 0xDCF1, 0xE512, 0xE512, 0xDD12, 0xB471, 0xB472, 0xB492, 0xB471, 0xAC11, 0xB410, 0xC450, 0xDC92, 0xF4F5, 0xF4F5, 0xF516, 0xFD77, 0xF515, 0xF556, 0xFD57, 0xFD36, 0xF492, 0xF453, 0xEC52, 0xE471, 0xCC70, 
        0xB3CD, 0xA38B, 0xA38B, 0xB3CF, 0xCC0F, 0xDC50, 0xDC52, 0xF494, 0xF494, 0xEC74, 0xE433, 0xF433, 0xEC12, 0xE3F2, 0xE3D2, 0xD3B0, 0xDBF1, 0xE3F2, 0xE3D1, 0xDC2F, 0xD42E, 0xD42F, 0xDC30, 0xDC6E, 0xDC2F, 0xDC10, 0xEC51, 0xF4D3, 0xF4B3, 0xECB3, 
        0xDCB3, 0xB3AE, 0xB38F, 0xBBF0, 0xCCEF, 0xEE51, 0xD5AD, 0xAC88, 0x7304, 0x28C1, 0x1880, 0x20C1, 0x2923, 0x18C1, 0x31A2, 0x6B28, 0xA50E, 0xB58C, 0xB56A, 0x94C6, 0x6BA2, 0x9C0A, 0x834A, 0x62A7, 0x5224, 0x6265, 0x61C4, 0x50E2, 0x48A2, 0xABCF, 
        0x9BCF, 0xA3D0, 0xD4D2, 0xE655, 0xF75B, 0xFFBE, 0xFF9D, 0xFF9D, 0xFF7A, 0xFF7B, 0xFFBD, 0xF656, 0xF656, 0xFE77, 0xFEB8, 0xFE98, 0xFEB8, 0xFEB8, 0xFEB7, 0xFEB7, 0xFE56, 0xF615, 0xF615, 0xFEB8, 0xFEB9, 0xFE58, 0xF5B5, 0xDC0E, 0xD40D, 0xDCD0, 
        0xFE36, 0xFF7C, 0xFE79, 0xFD76, 0xFD14, 0xFD76, 0xFD95, 0xF595, 0xED74, 0xF533, 0xE510, 0xDD10, 0xDD31, 0xDCAE, 0xDCAF, 0xD4AF, 0xCCCF, 0xDCB0, 0xDCAF, 0xDCAF, 0xECD1, 0xD4EE, 0xD4F0, 0xD4F1, 0xDD11, 0xE4F1, 0xE532, 0xED52, 0xED53, 0xED52, 
        0xED53, 0xF573, 0xF553, 0xF532, 0xED32, 0xE512, 0xE4F1, 0xE4D0, 0xDCB0, 0xD4B0, 0xD4D0, 0xD48F, 0xCC8F, 0xCC8F, 0xC48F, 0xC46F, 0xC44F, 0xC44F, 0xC46E, 0xB3ED, 0xB3ED, 0xB3CD, 0xA3AB, 0xB3CD, 0xAB8C, 0xA38C, 0x9B8B, 0x9B0B, 0x8AE9, 0x82C9, 
        0x82A9, 0x7A65, 0x7225, 0x6A05, 0x69C6, 0x6124, 0x5123, 0x5103, 0x58C3, 0x51A5, 0x49E5, 0x39E3, 0x29C2, 0x2141, 0x1921, 0x1901, 0x18C2, 0x10A1, 0x2103, 0x20E3, 0x2103, 0xD6B7, 0x94CE, 0x7BEB, 0x9CEE, 0x3163, 0x7BAD, 0xC5F6, 0xF73B, 0xCDF4, 
        0xC5F6, 0xCE37, 0xD637, 0xD656, 0xD657, 0xE6FA, 0xF7BD, 0xD6B2, 0x9CAC, 0xAD10, 0xF79D, 0xF7BD, 0xC5F2, 0xB50D, 0xBD4F, 0xBE0F, 0xBDEF, 0xAD4D, 0x946B, 0x8C2A, 0xBD4F, 0xE6B6, 0xFFBD, 0xF698, 0xF6B7, 0xF6B6, 0xF676, 0xF6D7, 0xE696, 0xDDD3, 
        0xCD11, 0xB4B0, 0xB46F, 0xB490, 0xBD11, 0xBD4F, 0xA48A, 0x8BE6, 0x7BC4, 0x9448, 0xAD0B, 0xC5CF, 0xD651, 0x9CAB, 0xAD2D, 0x83CA, 0x2922, 0x62E4, 0x62E3, 0x5B02, 0x6385, 0x8389, 0x83C9, 0x7368, 0x52A6, 0x5241, 0x6B04, 0x7B86, 0x7BC6, 0x6AE1, 
        0x62A2, 0x62E2, 0x7363, 0x7B86, 0x73A6, 0x7385, 0x7365, 0x7366, 0x6AE4, 0x8B89, 0xCD94, 0xF79D, 0xF6DA, 0xF658, 0xF658, 0xEE37, 0xF71A, 0xE698, 0xBCB2,
  0x7349, 0x6308, 0x6308, 0x7349, 0x732A, 0x7B49, 0x7B29, 0x72C8, 0x5AC5, 0x5265, 0x4A24, 0x4222, 0x4A23, 0x4A43, 0x4A64, 0x5285, 0x4A63, 0x4A43, 0x4224, 0x39E3, 0x4A23, 0x4A23, 0x5225, 0x5A66, 0x5AA6, 0x5266, 0x4225, 0x39E3, 0x6A85, 0x82C8, 0x934B, 
        0xAC0D, 0xC4D1, 0xD4D2, 0xD4F1, 0xD4F1, 0xE512, 0xE512, 0xE512, 0xED12, 0xDCF4, 0xCCD2, 0xC4D2, 0xC4F4, 0xB493, 0xB431, 0xC431, 0xE493, 0xE4D5, 0xD493, 0xD4B3, 0xE4F4, 0xECF5, 0xF537, 0xF537, 0xF4F6, 0xFCD5, 0xF4B4, 0xEC93, 0xE471, 0xCC2F, 
        0xAB8B, 0x92E9, 0x92A8, 0xB36C, 0xB3AD, 0xC3CF, 0xDC33, 0xEC74, 0xEC74, 0xEC54, 0xF434, 0xEC54, 0xEC33, 0xE413, 0xE413, 0xE433, 0xEC52, 0xE453, 0xE433, 0xEC51, 0xDC2F, 0xD42F, 0xDC50, 0xD431, 0xD40F, 0xDC30, 0xE452, 0xF472, 0xF493, 0xE494, 
        0xE4B3, 0xED55, 0xE4D5, 0xBC10, 0x8B88, 0xC5CE, 0xE66E, 0xD5ED, 0x9C8A, 0x2943, 0x1061, 0x18A1, 0x2963, 0x2983, 0x1901, 0x1902, 0x4A45, 0xDE2D, 0xC5CC, 0x9CE9, 0x8C07, 0x7BCA, 0x6B49, 0x62C8, 0x6287, 0x6AAA, 0x8269, 0x9AAA, 0xAB0D, 0x58E4, 
        0x2841, 0x1821, 0x2841, 0x2841, 0x7A47, 0xC4F1, 0xF79D, 0xFFFF, 0xFFFE, 0xFFFD, 0xF7BD, 0xEDD8, 0xEDF6, 0xF655, 0xFE96, 0xFE78, 0xFE78, 0xFE98, 0xFED8, 0xFE77, 0xFE36, 0xFE35, 0xFE96, 0xFF3C, 0xFDF7, 0xFD54, 0xFD76, 0xFE78, 0xFE57, 0xFE99, 
        0xFEFC, 0xFCF2, 0xEB6E, 0xE2AD, 0xEA6C, 0xF30D, 0xDAAB, 0xC269, 0xC2CA, 0xF473, 0xFD34, 0xFD75, 0xF574, 0xDCEF, 0xDCAF, 0xD4CF, 0xC4EF, 0xC4AD, 0xCC8D, 0xDC8E, 0xE4AF, 0xDCD1, 0xDCD1, 0xD4D0, 0xD4F0, 0xDCF1, 0xDCF1, 0xE511, 0xED52, 0xED53, 
        0xED53, 0xED53, 0xF553, 0xED32, 0xE512, 0xE512, 0xDCF1, 0xDCB0, 0xDCB0, 0xD4AF, 0xCCAF, 0xD48F, 0xD48F, 0xCC6E, 0xC44E, 0xD46F, 0xC44E, 0xBC2E, 0xBC2E, 0xBC0D, 0xBBED, 0xB3CD, 0xABAD, 0xB38B, 0xAB8C, 0xA36C, 0x9B4A, 0x930A, 0x8AE9, 0x8AC8, 
        0x8288, 0x6A25, 0x69E5, 0x61C5, 0x59C5, 0x5123, 0x5924, 0x5924, 0x50E3, 0x4A66, 0x4204, 0x4183, 0x3963, 0x1920, 0x1120, 0x1901, 0x28E2, 0x20E2, 0x0862, 0x0801, 0x30E3, 0xD6B6, 0x94CE, 0x6349, 0x6B69, 0x6B26, 0x5263, 0x7BCA, 0xDEF9, 0xF71C, 
        0xDE58, 0xC574, 0xBCF2, 0xDE97, 0xD614, 0xDE77, 0xEF5B, 0x7C2A, 0x94AB, 0xC613, 0xF7BD, 0xF7BB, 0xBD8F, 0xACED, 0xC5F3, 0xAD6B, 0xAD4C, 0xA52C, 0x9CC9, 0xC56D, 0xE6F8, 0xFFDD, 0xFFBB, 0xF699, 0xEE56, 0xEE95, 0xEED7, 0xF6B6, 0xEE96, 0xE635, 
        0xDDB2, 0xD552, 0xAC6D, 0xA44C, 0xB510, 0xA4AD, 0x8BE9, 0x7305, 0x6282, 0x9CAA, 0xAD4D, 0x9CAB, 0x83A7, 0xE691, 0xAD0D, 0x7367, 0x5261, 0x39E0, 0x5262, 0x5AA3, 0x4A82, 0x39E0, 0x6322, 0x8405, 0x8C47, 0x6BA2, 0x5B01, 0x6322, 0x7BA6, 0x6B64, 
        0x73A6, 0x7BC7, 0x7BC7, 0x6B63, 0x6B84, 0x6384, 0x5343, 0x7B27, 0x7B07, 0xACAE, 0xEF5B, 0xDDB6, 0xE5F7, 0xEE18, 0xEDB7, 0xF6D7, 0xDE55, 0xCD93, 0xCD12,
  0x6B08, 0x62E8, 0x62E9, 0x7B2A, 0x7B49, 0x7B49, 0x7B49, 0x7B2A, 0x6AA7, 0x52A5, 0x4A83, 0x4A43, 0x4223, 0x4A23, 0x4A44, 0x4A84, 0x4A64, 0x4A64, 0x4A43, 0x4202, 0x4202, 0x4A03, 0x4A24, 0x5266, 0x6A68, 0x6266, 0x5245, 0x4A04, 0x49E3, 0x82C9, 0xAB8C, 
        0xBC0C, 0xCCD2, 0xD4F2, 0xDCF1, 0xE4D2, 0xDD11, 0xDD12, 0xE512, 0xE511, 0xE534, 0xDD14, 0xCD34, 0xBD34, 0xB472, 0xBC72, 0xCC92, 0xE4D4, 0xE4B5, 0xDCD3, 0xCC91, 0xC42F, 0xDC73, 0xF4F6, 0xFD58, 0xFD59, 0xF4F4, 0xF4F5, 0xF4B4, 0xE431, 0xCB8D, 
        0xB38C, 0x9309, 0x8247, 0x9AE9, 0xA36B, 0xABCE, 0xBBF1, 0xE4B3, 0xECD5, 0xECD5, 0xEC94, 0xE453, 0xE433, 0xE413, 0xDC15, 0xE433, 0xEC74, 0xF493, 0xEC92, 0xCB71, 0xD3CF, 0xCBEE, 0xC3CE, 0xD3EF, 0xD3AF, 0xD38F, 0xDBB0, 0xE472, 0xEC73, 0xEC93, 
        0xECB4, 0xE4D4, 0xE4B4, 0xED75, 0xF696, 0xAC89, 0x9C28, 0xACCC, 0xC550, 0x6287, 0x41C2, 0x3180, 0x2940, 0x2981, 0x2981, 0x29E1, 0x3A62, 0x7345, 0xB4E8, 0xDDAA, 0xC54A, 0x32A6, 0x52A5, 0x6305, 0x5B26, 0x5B05, 0x7308, 0x7AEA, 0x7AA9, 0x6A68, 
        0x7248, 0x7206, 0x61C3, 0x4124, 0x2862, 0x1800, 0x1800, 0x2000, 0x2800, 0x2000, 0x30C2, 0xE5D3, 0xF697, 0xF658, 0xF638, 0xF5F6, 0xFE56, 0xFE77, 0xFE57, 0xFE76, 0xFE55, 0xFED8, 0xF71B, 0xD1E6, 0xB105, 0xB0C4, 0xD145, 0xF5D9, 0xFDB8, 0xF452, 
        0xDA49, 0xA8C4, 0xA186, 0xA9E7, 0xB1A7, 0xC9E8, 0xC9E8, 0xC1C7, 0xB166, 0xB126, 0xC187, 0xDA8B, 0xE411, 0xF472, 0xF513, 0xF554, 0xFD13, 0xF534, 0xF4F2, 0xECD1, 0xE4B1, 0xDCCE, 0xD490, 0xD491, 0xDCD0, 0xDD31, 0xDD11, 0xE512, 0xF573, 0xED53, 
        0xED53, 0xED53, 0xED32, 0xE531, 0xE511, 0xDCF1, 0xDCB0, 0xDCF0, 0xDCB1, 0xD4B1, 0xD4D0, 0xCC8E, 0xCC8E, 0xCC6F, 0xC46E, 0xC44E, 0xC44E, 0xC44E, 0xBC4E, 0xB40D, 0xBBEC, 0xB3AC, 0xAB8C, 0xABAC, 0xAB8B, 0x9B6A, 0x9349, 0x9B0A, 0x92C9, 0x82A8, 
        0x7288, 0x7225, 0x69E5, 0x61A5, 0x5144, 0x5124, 0x5924, 0x5924, 0x5144, 0x4A04, 0x39C3, 0x3182, 0x3162, 0x2920, 0x2101, 0x10A0, 0x0860, 0x3184, 0x20E2, 0x5288, 0xBDB2, 0x8327, 0x7387, 0x7C4B, 0x8CCF, 0x5284, 0x4202, 0x5265, 0x83EC, 0xEF5C, 
        0xEEFB, 0xDE58, 0xD5D7, 0xCDB3, 0xE676, 0xF6F8, 0xE675, 0x7BA7, 0xA50D, 0xD6B6, 0xF7BD, 0xF6D9, 0xCDF2, 0xB58D, 0xAD8B, 0xA4CC, 0x9C4B, 0xA44B, 0xC52F, 0xF79D, 0xFFFD, 0xFF9B, 0xF719, 0xEE97, 0xF6B7, 0xF6D8, 0xEEB7, 0xE696, 0xDE14, 0xD5B3, 
        0xC552, 0x9C2A, 0xB50D, 0xBD4E, 0xACAA, 0x9449, 0x9449, 0x9C6A, 0x9C4B, 0x72A2, 0x7324, 0x9C6A, 0xD5B0, 0xA46A, 0x9C8A, 0x8C29, 0x7306, 0x5AA3, 0x6B45, 0x6B45, 0x6B25, 0x94A8, 0x73C5, 0x52A2, 0x4A00, 0x5AE3, 0x73C4, 0x73C4, 0x6B42, 0x73C3, 
        0x7C05, 0x7C27, 0x8448, 0x6344, 0x5304, 0x7324, 0x9BC5, 0x7427, 0xC632, 0xF6F8, 0xF659, 0xEDD8, 0xF658, 0xEE97, 0xE696, 0xEF5B, 0xACB1, 0xAC70, 0xF71A,
  0x6B0A, 0x6B09, 0x732A, 0x7B8B, 0x8B8B, 0x838B, 0x838A, 0x7B69, 0x6AE9, 0x5AA6, 0x5285, 0x5285, 0x4A64, 0x4A44, 0x4A64, 0x4A84, 0x4AC5, 0x4AA4, 0x4A63, 0x3A03, 0x3A22, 0x4A43, 0x5A44, 0x6A66, 0x72AA, 0x6AA9, 0x6286, 0x5A24, 0x5224, 0x7AA8, 0x9B4B, 
        0xB40D, 0xCCB1, 0xDCF1, 0xE4F2, 0xE512, 0xE511, 0xED12, 0xED32, 0xED32, 0xE553, 0xE554, 0xDD34, 0xDD34, 0xB4B3, 0xB491, 0xCC71, 0xE493, 0xE4D5, 0xDC93, 0xC450, 0xB42D, 0xE494, 0xF516, 0xFD57, 0xFD58, 0xF516, 0xFCF6, 0xFCF6, 0xF4D5, 0xCBEF, 
        0xBC10, 0xABEE, 0x9329, 0x82E7, 0x9B4B, 0xABAD, 0xBBCF, 0xE474, 0xF495, 0xF495, 0xF495, 0xF474, 0xE453, 0xE433, 0xE413, 0xF433, 0xF454, 0xF453, 0xEC13, 0xDBF2, 0xD3F1, 0xD3F0, 0xD410, 0xDC10, 0xDBD1, 0xDBB1, 0xEBD1, 0xEC53, 0xE453, 0xE474, 
        0xF494, 0xECF5, 0xF4F7, 0xFD58, 0xF5D8, 0xB3EB, 0xD4AC, 0xDD4F, 0xBD10, 0x62A4, 0x29C1, 0x1940, 0x2921, 0x31E4, 0x2162, 0x2161, 0x4A64, 0xCE31, 0xDE4E, 0xAD2A, 0x5B85, 0x72C1, 0x6B23, 0x6364, 0x6364, 0x6B45, 0x7B26, 0x8309, 0x7B0C, 0x8246, 
        0x81E7, 0x7986, 0x5903, 0x3163, 0x28E2, 0x1861, 0x1061, 0x61E5, 0x6A04, 0x7286, 0x9BCC, 0xE592, 0xF6F9, 0xFF5C, 0xFE9A, 0xFE37, 0xFE96, 0xFE76, 0xF5F5, 0xFE75, 0xFF39, 0xEDD5, 0xDAAA, 0xB8C8, 0xD169, 0xD9EA, 0xDA2A, 0xE26A, 0xF28C, 0xEA2B, 
        0xD988, 0xD969, 0xD9CB, 0xDA0B, 0xEA0B, 0xE9AA, 0xE1AA, 0xD989, 0xC968, 0xD1A8, 0xC147, 0xA8C5, 0x8862, 0xC209, 0xC24A, 0xC2AB, 0xC30C, 0xD34C, 0xE40F, 0xF4D1, 0xFD53, 0xF533, 0xE4D0, 0xDCB0, 0xDCF2, 0xED52, 0xE511, 0xE511, 0xF532, 0xF573, 
        0xF573, 0xF553, 0xED32, 0xED32, 0xED32, 0xE512, 0xDCF1, 0xDCD0, 0xD4B0, 0xD4B0, 0xDCAF, 0xD4B0, 0xD490, 0xD490, 0xD470, 0xD46F, 0xC44E, 0xC44E, 0xC44F, 0xB3ED, 0xB3ED, 0xB3CD, 0xA3AC, 0xB3CD, 0xABAC, 0xA38C, 0x9B6C, 0x8B29, 0x8B09, 0x8AC8, 
        0x7A87, 0x6A25, 0x69A5, 0x6185, 0x6165, 0x5964, 0x6165, 0x6165, 0x5944, 0x5A04, 0x4224, 0x31C2, 0x2940, 0x2101, 0x2101, 0x1900, 0x1100, 0x18E1, 0x1081, 0x4A07, 0xBCB1, 0x8C2C, 0x73C9, 0x73E9, 0x742A, 0x6B8A, 0x94CD, 0x73C9, 0x1081, 0x2944, 
        0xAD54, 0xF75B, 0xF6B7, 0xE5F7, 0xDE57, 0xDE98, 0xDE38, 0x7BAA, 0x5A24, 0x8BAC, 0xEF7D, 0xFF7E, 0xE636, 0xC550, 0xA52E, 0xCD8F, 0xEEB5, 0xFF58, 0xFF99, 0xFF9C, 0xFF5B, 0xFF39, 0xFF37, 0xFF19, 0xFF1B, 0xF6F9, 0xEE96, 0xF75A, 0xDE34, 0xCD71, 
        0xBD30, 0xACAE, 0xACCD, 0xA4AC, 0x9C29, 0xA489, 0x9C89, 0x9C69, 0x9449, 0x944A, 0x9409, 0xA46A, 0xBD2C, 0xACED, 0xB50F, 0xBD4F, 0xB56D, 0x8BC8, 0xA4AB, 0xB54E, 0xA4ED, 0x4A62, 0x6305, 0x8408, 0x948A, 0x4A41, 0x4A21, 0x62A2, 0x8384, 0x6B82, 
        0x52A1, 0x5AE2, 0x8C66, 0xBE2E, 0xA50B, 0x9489, 0xA4EB, 0xD5CF, 0xC551, 0xB4D1, 0xB491, 0xC514, 0xE5BA, 0xFE9D, 0xEF1C, 0x6AA6, 0xA40E, 0xCD36, 0xD55B,
  0x6B08, 0x62E7, 0x6B08, 0x736A, 0x738A, 0x7B6A, 0x7B6A, 0x7349, 0x5AA5, 0x4A65, 0x5265, 0x52A5, 0x5265, 0x5284, 0x4A83, 0x4284, 0x52A5, 0x4A64, 0x4223, 0x3A03, 0x49E3, 0x51E4, 0x5A04, 0x6244, 0x6A87, 0x6AA7, 0x5A87, 0x4A47, 0x5A25, 0x82A9, 0xA34B, 
        0xB42D, 0xCCB3, 0xDD12, 0xE511, 0xDCF2, 0xED32, 0xED32, 0xE532, 0xED32, 0xED34, 0xDD54, 0xDD54, 0xD534, 0xB4D2, 0xBC92, 0xCC92, 0xDCD3, 0xDCB2, 0xBC6F, 0xB40D, 0xB38C, 0xBC31, 0xE4B5, 0xFD37, 0xFD59, 0xF4F8, 0xFCF7, 0xFD16, 0xFD16, 0xDBD1, 
        0xBBAF, 0xB3EE, 0xAC2C, 0x6A45, 0x82A7, 0x9B4A, 0xABCE, 0xCCB3, 0xD515, 0xDD35, 0xE534, 0xEC95, 0xEC94, 0xE474, 0xE433, 0xE453, 0xEC94, 0xF475, 0xF415, 0xC410, 0xBBEF, 0xBBCF, 0xBBF0, 0xC3AF, 0xBB8F, 0xC36F, 0xD370, 0xEC13, 0xE433, 0xE453, 
        0xE494, 0xF516, 0xFD36, 0xF556, 0xE574, 0xBCCD, 0xB44B, 0xC52F, 0xEED6, 0xBD6F, 0x5226, 0x20C2, 0x2983, 0x31E4, 0x29C2, 0x2981, 0x3164, 0x6ACC, 0x8368, 0x7304, 0x4241, 0x5306, 0x5B05, 0x5AE4, 0x5AE4, 0x6B46, 0x6B28, 0x6B07, 0x6B25, 0x62A6, 
        0x6247, 0x6248, 0x6287, 0x6184, 0x40A1, 0x3061, 0x4103, 0xA3ED, 0xB3CD, 0x8AAA, 0x59C7, 0xCC6D, 0xF696, 0xFF5B, 0xF6DD, 0xFE3A, 0xFE77, 0xFE55, 0xFDF5, 0xFE97, 0xF657, 0xD40F, 0xA0C3, 0xEA4D, 0xF24C, 0xF20C, 0xF1AC, 0xF949, 0xF169, 0xE169, 
        0xC929, 0xB0A4, 0xC8A4, 0xC8A5, 0xB865, 0xB002, 0xB003, 0xB864, 0xC0E6, 0xC023, 0xD044, 0xE0E8, 0xF1AB, 0xB0A4, 0xB063, 0xB023, 0xA002, 0x8041, 0x8882, 0xA145, 0xC28A, 0xCBCE, 0xDC90, 0xE4F1, 0xED12, 0xED73, 0xED52, 0xE511, 0xE4F2, 0xF573, 
        0xF573, 0xED52, 0xED32, 0xED52, 0xE512, 0xE511, 0xE4F1, 0xDCB0, 0xDCB0, 0xD4D0, 0xD4AF, 0xD4AF, 0xD48F, 0xD490, 0xCC8F, 0xCC6E, 0xC44E, 0xC44E, 0xBC2E, 0xB3ED, 0xB3CD, 0xB3CD, 0xABAC, 0xABAB, 0x9B8B, 0x9B8A, 0x9B49, 0x8AE9, 0x8AC9, 0x82A7, 
        0x7265, 0x7206, 0x61A5, 0x5965, 0x5945, 0x6164, 0x5984, 0x5944, 0x6924, 0x5265, 0x4243, 0x31C2, 0x2141, 0x2100, 0x20C1, 0x28E2, 0x2944, 0x0841, 0x3964, 0x738A, 0xAD6F, 0x72E6, 0x6B89, 0x848C, 0x94ED, 0x7BE9, 0x4263, 0x1900, 0x0020, 0x1061, 
        0x7B6D, 0xCDF7, 0xEF5C, 0xDD75, 0xDD95, 0xE636, 0xDE16, 0x4983, 0x7B07, 0xBD91, 0xF7BD, 0xF77D, 0xD5B2, 0xB4AD, 0xB4ED, 0xF736, 0xF737, 0xF739, 0xFF7A, 0xFF9B, 0xFF5B, 0xFF1A, 0xF6F9, 0xF6BA, 0xF6D9, 0xF697, 0xF615, 0xF75B, 0xACF0, 0xA44C, 
        0xCD72, 0xACCE, 0x9C4C, 0x9C2B, 0xA44B, 0x9449, 0xA48B, 0xACAB, 0x9C8A, 0xAC8D, 0xBD0E, 0xBD0D, 0xACAC, 0xB4ED, 0xB4EC, 0xB4EC, 0xB4CD, 0x9C49, 0xBD6E, 0xCDF1, 0xBD4E, 0x9409, 0x6B05, 0x73A8, 0xA5AF, 0xBD2E, 0x8387, 0x5AA4, 0x62E5, 0x83C7, 
        0x83E6, 0x73C5, 0x6363, 0x5261, 0x7BA8, 0xA4ED, 0xBD91, 0xBC91, 0xAC10, 0xABF2, 0xB3D6, 0xB39E, 0xBC1E, 0xBC98, 0xACAC, 0x8B27, 0xCD14, 0xDD7C, 0xB41D,
  0x6AE9, 0x5AA5, 0x5AC4, 0x6B45, 0x6AE5, 0x6307, 0x6307, 0x5AA4, 0x4A64, 0x52A5, 0x52E6, 0x5AC7, 0x5AC4, 0x52A5, 0x4AA5, 0x42C3, 0x4A85, 0x4A85, 0x4A64, 0x4222, 0x31A2, 0x4983, 0x5984, 0x61C6, 0x6A45, 0x6A66, 0x6266, 0x5A86, 0x5A47, 0x7AC8, 0x8B0A, 
        0x9B2D, 0xBC6C, 0xCCB0, 0xD4F2, 0xE512, 0xDD12, 0xE532, 0xE552, 0xED73, 0xE573, 0xE554, 0xDD54, 0xD554, 0xB4D2, 0xB491, 0xBC92, 0xCCB3, 0xC46F, 0xB3EE, 0xAB8D, 0x9B4B, 0xBBED, 0xCC72, 0xDCD4, 0xED16, 0xFD78, 0xED16, 0xE4D4, 0xDCB3, 0xD472, 
        0xB3CE, 0xAB6C, 0xAB6C, 0x8B09, 0x7AC6, 0x7AC7, 0x932A, 0xAB4C, 0xC3F0, 0xCBF2, 0xCB51, 0xDC32, 0xDC33, 0xDC33, 0xE413, 0xEC56, 0xE413, 0xD3D0, 0xBB6D, 0x92AA, 0x92CC, 0xA30D, 0xA34D, 0xB34D, 0xB34E, 0xBB8F, 0xD3F1, 0xE474, 0xE3F3, 0xDB92, 
        0xD3B1, 0xDC94, 0xE494, 0xDC72, 0xD44F, 0xBBED, 0xA36A, 0x8AC8, 0x8AA7, 0xCD90, 0xC56F, 0x8BC9, 0x2961, 0x20E0, 0x31C3, 0x31E3, 0x2160, 0x2A61, 0x2161, 0x18C0, 0x1901, 0x5AC3, 0x4A41, 0x3A00, 0x3A81, 0x5A85, 0x52A4, 0x5AE6, 0x6B6A, 0x9368, 
        0x9349, 0x9329, 0x9308, 0x6B4B, 0x6A69, 0x61C6, 0x61E5, 0x936A, 0x9BAB, 0xA3CC, 0xB40C, 0xABAB, 0xCD12, 0xEE58, 0xFEFC, 0xEE16, 0xF636, 0xF615, 0xF594, 0xF75C, 0xC470, 0xBA48, 0xD147, 0xD929, 0xD9AA, 0xD988, 0xD8E5, 0xE948, 0xA884, 0x9802, 
        0xB824, 0xB104, 0xA905, 0x90E4, 0x78E3, 0xA1E9, 0xA208, 0x9A07, 0x9207, 0xC086, 0xC0C5, 0xB8E5, 0xB0E5, 0xB085, 0xB0C5, 0xB0E5, 0xB0E5, 0xA905, 0xA0A3, 0x8842, 0x7020, 0x8104, 0xBB6D, 0xDCD1, 0xDCF1, 0xE531, 0xED52, 0xED53, 0xED13, 0xED53, 
        0xED52, 0xED52, 0xED32, 0xDD11, 0xDCF1, 0xDCD0, 0xD4D0, 0xDCB0, 0xDCB0, 0xD490, 0xCC8F, 0xCC8F, 0xCC8F, 0xCC8F, 0xCC8F, 0xCC4F, 0xCC2E, 0xC44E, 0xBC4E, 0xBBED, 0xB3CC, 0xB3AC, 0xABCD, 0xAB6A, 0x9B4A, 0x9B2A, 0x9B2A, 0x92C8, 0x82C7, 0x7286, 
        0x6A26, 0x69A5, 0x5964, 0x5964, 0x5984, 0x6185, 0x5985, 0x5964, 0x6163, 0x6AC6, 0x4204, 0x2161, 0x1141, 0x2122, 0x20A2, 0x20C2, 0x2943, 0x1081, 0x72E9, 0xA3EB, 0x8347, 0x6C28, 0x950B, 0x8CCA, 0x5305, 0x0860, 0x0040, 0x10E1, 0x29C3, 0x0840, 
        0x0841, 0x5AEB, 0xE71C, 0xCDF6, 0xDE17, 0xD553, 0xABEC, 0xBD4E, 0xE6F8, 0xFFDE, 0xFFDE, 0xF6D9, 0xD593, 0xDD93, 0xF6D7, 0xF739, 0xFF9B, 0xFFDD, 0xFF9D, 0xF6F8, 0xF6B8, 0xF6B8, 0xF6F8, 0xF71A, 0xF699, 0xF6FA, 0xF77D, 0xB4D1, 0x8B8A, 0xA42D, 
        0xD5D4, 0x942B, 0xAC8C, 0xB4CD, 0xACCC, 0xB4AB, 0xB4ED, 0xB4EE, 0xBCEF, 0xD5D1, 0xBD2F, 0xA44C, 0x9BCA, 0xD5B1, 0xC591, 0xBD4F, 0xBCEF, 0xACAC, 0x8327, 0x9368, 0xCD6E, 0xD60F, 0xBD6E, 0xC5D2, 0xE6FA, 0xB591, 0x944C, 0x6287, 0x20A1, 0x3A21, 
        0x7388, 0x83C8, 0x7322, 0x7C65, 0xB5AC, 0xB58D, 0x7C46, 0x4261, 0x6B25, 0x83E9, 0x844C, 0x94B2, 0x836B, 0x7226, 0x71E6, 0xE63C, 0xBC7D, 0xAB5C, 0xBBDD,
  0x734A, 0x6B29, 0x6B07, 0x6325, 0x6B26, 0x62C5, 0x5AA5, 0x5AC5, 0x62C4, 0x5AE5, 0x5B06, 0x6B07, 0x6B06, 0x62E5, 0x62C5, 0x5AA5, 0x5285, 0x5A85, 0x5A65, 0x5244, 0x51C3, 0x51A3, 0x59A4, 0x61E4, 0x6A46, 0x6285, 0x5AA5, 0x6285, 0x5A65, 0x72C9, 0x8B0A, 
        0x9B4A, 0xB3CD, 0xBC4E, 0xCCB0, 0xE512, 0xED12, 0xED32, 0xED52, 0xE553, 0xED53, 0xE574, 0xED74, 0xE574, 0xB4F3, 0xB4B2, 0xC491, 0xCC90, 0xBC31, 0xBBEE, 0xB3CD, 0x9B8C, 0x934B, 0xBC0F, 0xDC93, 0xECD5, 0xFD58, 0xF537, 0xECF6, 0xE4B5, 0xCC30, 
        0xBBEF, 0xABAF, 0xA36D, 0x9329, 0x7AA8, 0x7AA8, 0x8B09, 0x93AC, 0x9BED, 0xA42E, 0xB470, 0xC430, 0xCC72, 0xD492, 0xD472, 0xEC72, 0xE472, 0xD450, 0xC40E, 0x930B, 0x8B2C, 0x9B6D, 0xB38E, 0xA34E, 0xB36F, 0xBB90, 0xC3D0, 0xEC34, 0xEC33, 0xDBF2, 
        0xD3B1, 0xD3F2, 0xE473, 0xE4D3, 0xDCB2, 0xBC2D, 0xABEC, 0x9B8B, 0x934B, 0xB44C, 0xA40B, 0x7B69, 0x42A6, 0x29A3, 0x3163, 0x3163, 0x3183, 0x39C2, 0x49E1, 0x5202, 0x5265, 0x4A64, 0x4A24, 0x4A44, 0x5283, 0x6266, 0x6AC6, 0x7306, 0x7326, 0x8B87, 
        0x8B47, 0x8B28, 0x932B, 0x92E8, 0x92A7, 0x8225, 0x71A4, 0xAB4B, 0xC44F, 0xB42E, 0x932B, 0xE490, 0xF572, 0xF636, 0xF6BB, 0xF5FA, 0xFE57, 0xFE35, 0xFDB6, 0xF6D8, 0xCBED, 0xC228, 0xE1E9, 0xD8E9, 0xD129, 0xC9A9, 0xB1C9, 0x7882, 0xB2CA, 0xE514, 
        0xFEBB, 0xFFDF, 0xFFDF, 0xFF1C, 0xFDF7, 0xFFBE, 0xFFFF, 0xFFFF, 0xFF7D, 0xE3AF, 0x99C7, 0x7144, 0x79A5, 0x9A07, 0xAA89, 0xA208, 0x90E4, 0x9944, 0x98E4, 0x9863, 0x9042, 0x99C8, 0xB38D, 0xCC90, 0xDCD1, 0xF512, 0xFD53, 0xF554, 0xED33, 0xF573, 
        0xF553, 0xF553, 0xED12, 0xE512, 0xE511, 0xE4F1, 0xDCF1, 0xDC90, 0xDC90, 0xDCB0, 0xD48F, 0xD4AF, 0xD4B0, 0xD4B0, 0xDC90, 0xBC4E, 0xC44F, 0xC44F, 0xBC4E, 0xB3CD, 0xB3CD, 0xB3CD, 0xB3AC, 0xA38B, 0x9B4A, 0x9B2A, 0x9B4A, 0x8AA9, 0x8268, 0x7A47, 
        0x6A46, 0x6165, 0x6184, 0x61C5, 0x61C6, 0x6984, 0x71A5, 0x71C5, 0x71E4, 0x6328, 0x31C4, 0x1921, 0x2982, 0x18E2, 0x18C2, 0x18E2, 0x18E1, 0x10A1, 0x8BCB, 0xACEE, 0x6B89, 0x9CCD, 0x7B88, 0x4223, 0x08C0, 0x0880, 0x10E0, 0x1901, 0x20E2, 0x2923, 
        0x20E1, 0x20C1, 0x41A5, 0xE71C, 0xEF5C, 0xE658, 0xE555, 0xFF7B, 0xFF9A, 0xFF9B, 0xFFDE, 0xF6FA, 0xFF1A, 0xFF7B, 0xFFDC, 0xFFFD, 0xFF9C, 0xFF7B, 0xF77A, 0xF6FB, 0xFEF9, 0xFEF8, 0xFF17, 0xF6FA, 0xFED8, 0xFF3A, 0xF77C, 0xA42C, 0x8349, 0x942D, 
        0xD5D4, 0xACCF, 0xACAF, 0xB4AE, 0xB48D, 0xB4AF, 0xB4AF, 0xB4CF, 0xBD10, 0xAC8F, 0xD572, 0xD572, 0xAC8F, 0xB50F, 0xB50D, 0xBD2E, 0xD591, 0xB4CD, 0xB4AC, 0xA44A, 0x8BA8, 0xA4CD, 0xBD0F, 0xA3EB, 0x6244, 0xDE37, 0xF719, 0xEED6, 0xC5F1, 0x7B27, 
        0x7366, 0x83E6, 0x9447, 0xAD09, 0x9467, 0x73C5, 0x5B43, 0x8405, 0x6BA4, 0x6364, 0x6B65, 0x4A43, 0x51C4, 0x8B4D, 0xE5FD, 0xBBBF, 0xBBFF, 0xCC5F, 0xCC1F,
  0x7B4C, 0x7B2A, 0x7307, 0x6305, 0x62C8, 0x5AA7, 0x5AC5, 0x5AC4, 0x5AA7, 0x5AE6, 0x6327, 0x6B49, 0x7B69, 0x7349, 0x6B49, 0x6349, 0x5A84, 0x5AA5, 0x52A5, 0x5264, 0x51E3, 0x59E4, 0x61E5, 0x6A04, 0x6A25, 0x6245, 0x6265, 0x62A5, 0x6AA6, 0x82C9, 0x8AEA, 
        0x8B09, 0xA3CD, 0xB44D, 0xC4AF, 0xC4D1, 0xECF2, 0xED33, 0xED73, 0xED73, 0xE554, 0xE574, 0xE574, 0xD554, 0xCCF3, 0xC4D2, 0xBCB2, 0xBC91, 0xB3ED, 0xA3CC, 0x9BAB, 0x9B49, 0x9AEA, 0xAB6D, 0xBBEF, 0xCC91, 0xF557, 0xED56, 0xE514, 0xDC71, 0xB3CF, 
        0xB38D, 0xAB4C, 0x9ACA, 0x9ACB, 0x8287, 0x6A65, 0x62A7, 0x7288, 0x6AC9, 0x732B, 0x938C, 0xAB6F, 0xCBF2, 0xDC54, 0xEC95, 0xF496, 0xE413, 0xCB91, 0xAB2E, 0x5A25, 0x6246, 0x7AA9, 0x930B, 0x9B2D, 0xA34D, 0xB38F, 0xCBD2, 0xEC34, 0xEC33, 0xEC14, 
        0xEBF3, 0xA3AD, 0xA3CE, 0xBBF0, 0xDBD0, 0xAB8D, 0xA34D, 0x92AC, 0x79C9, 0x9A6A, 0xC470, 0xD5D0, 0xBD8B, 0x41A1, 0x2100, 0x1921, 0x21A3, 0x0A46, 0x3204, 0x4A03, 0x4A44, 0x4182, 0x41E2, 0x4A03, 0x49C2, 0x5A84, 0x6347, 0x63A7, 0x6384, 0x83A6, 
        0x8BEA, 0x9C4D, 0xACAE, 0xA3ED, 0xABAE, 0xA36F, 0x8B2E, 0xABCD, 0xBC30, 0xBC30, 0xB3CF, 0xDCAF, 0xDCD0, 0xDD54, 0xEE38, 0xFE9A, 0xFEB8, 0xF635, 0xF595, 0xF73C, 0xBBEE, 0xA185, 0xB8E5, 0xD908, 0xD1CB, 0xBA0A, 0x9185, 0x2061, 0x8269, 0xD4D2, 
        0xFEFA, 0xFFDC, 0xFFDD, 0xEEFB, 0xD5B6, 0xF6D8, 0xEE97, 0xB490, 0x59E6, 0x9B6B, 0xB40E, 0xC4B1, 0xD4F2, 0x8A27, 0x9248, 0x9A28, 0x9166, 0x7986, 0x88C4, 0x8822, 0x8882, 0xEBF0, 0xE492, 0xDC91, 0xDC90, 0xE532, 0xED33, 0xF533, 0xF533, 0xF593, 
        0xF573, 0xF552, 0xED32, 0xE512, 0xE4F1, 0xDCF0, 0xDCF1, 0xDCB1, 0xDCB0, 0xDCB0, 0xD4AF, 0xD4B0, 0xD48F, 0xD48F, 0xD490, 0xCC6E, 0xC44E, 0xBC4F, 0xC44E, 0xB3CC, 0xB3CC, 0xABAC, 0xA36C, 0xA38A, 0x9B4A, 0x932A, 0x8AEA, 0x8A68, 0x7A28, 0x6A07, 
        0x69A5, 0x6184, 0x61A5, 0x61C5, 0x61A5, 0x5985, 0x69C5, 0x7245, 0x72C6, 0x4203, 0x1961, 0x1941, 0x3983, 0x08A2, 0x2123, 0x2102, 0x0861, 0x1082, 0x93ED, 0xD5D3, 0xC570, 0x3A43, 0x1920, 0x10E0, 0x1920, 0x10E0, 0x2102, 0x2102, 0x20E1, 0x2984, 
        0x3186, 0x2104, 0x18C3, 0xADD7, 0xE75D, 0xF7BE, 0xEF1B, 0xDCD0, 0xEE96, 0xFFBB, 0xFF9C, 0xFF5D, 0xFFBD, 0xFFFE, 0xFFDD, 0xFFBB, 0xFF7B, 0xFF5A, 0xF73A, 0xFEFA, 0xFEF9, 0xF6F9, 0xF6DB, 0xF6DA, 0xF6F8, 0xFF59, 0xEF59, 0x834B, 0x836A, 0x9C4D, 
        0xBD51, 0xB511, 0xACCF, 0xA48E, 0xA46E, 0xAC4E, 0xAC6E, 0xB4AE, 0xBCCF, 0xBD50, 0xBCCE, 0xC510, 0xD5D4, 0xACAC, 0xACAD, 0xC551, 0xDE35, 0xC50F, 0xA40B, 0x9C0B, 0xA4AD, 0x9C08, 0x9C6A, 0xACCB, 0xB4ED, 0x9C4C, 0xD5F4, 0xFF39, 0xE6F7, 0x52C4, 
        0x5AE3, 0x8427, 0xAD6C, 0xAD69, 0x8C86, 0x73A5, 0x5B24, 0x73C5, 0x73C4, 0x73C5, 0x6B85, 0x2962, 0xA48E, 0xDD99, 0xBBFE, 0xBBDF, 0xC43E, 0xC45E, 0xCBFE,
  0x7B2F, 0x730C, 0x62EA, 0x5B08, 0x62A8, 0x62C9, 0x62C9, 0x62A9, 0x6B09, 0x6B28, 0x6B68, 0x6BC9, 0x838A, 0x8B6A, 0x836A, 0x8349, 0x6AE8, 0x62A7, 0x6286, 0x6265, 0x6226, 0x6A25, 0x6A45, 0x6A26, 0x6A05, 0x6224, 0x6264, 0x6AA4, 0x72C7, 0x82A9, 0x928A, 
        0x92AA, 0x9B0A, 0xAB4B, 0xB38C, 0xB40D, 0xDCF2, 0xE532, 0xE533, 0xED53, 0xED54, 0xED53, 0xE554, 0xE554, 0xC491, 0xB42E, 0xB3CC, 0xA34A, 0x92E9, 0x9AE9, 0x92C8, 0x7A67, 0x8287, 0x92EA, 0xA32C, 0xB36D, 0xB3CE, 0xC410, 0xC411, 0xB3AE, 0xAB2B, 
        0xA32B, 0xA32B, 0xA32A, 0x9268, 0x9289, 0x9AA8, 0x9A86, 0x8287, 0x7245, 0x6205, 0x5206, 0x82A7, 0x834A, 0x93CD, 0xB3F1, 0xD3F2, 0xBB8D, 0x9B09, 0x7287, 0x6265, 0x6246, 0x6A68, 0x82E9, 0x8B2A, 0x9B4C, 0xABCE, 0xBC50, 0xECB4, 0xE474, 0xDC73, 
        0xD4B3, 0xC3AE, 0xA38B, 0x934A, 0x92C9, 0x82E8, 0x8AE8, 0x8AE7, 0x82C7, 0x6A66, 0x5A05, 0x41A3, 0x2983, 0x83AA, 0x72E7, 0x51E4, 0x3122, 0x3141, 0x4162, 0x4164, 0x3965, 0x3921, 0x3902, 0x4185, 0x5A67, 0x6AE9, 0x72E9, 0x72E9, 0x7B07, 0x9C2A, 
        0xB48C, 0xC4CD, 0xCCCE, 0xBC8D, 0xC46D, 0xCC0D, 0xCB6C, 0xBB8D, 0xBBCC, 0xCC0E, 0xE493, 0xCC6E, 0xCC6E, 0xCC6F, 0xCC73, 0xDD35, 0xF616, 0xFE98, 0xF6BA, 0xFEFA, 0xE5D6, 0xB38D, 0x7882, 0xC147, 0xB0E5, 0xA0C5, 0x9106, 0x50C1, 0x2040, 0x0000, 
        0x18E3, 0xDE77, 0xC4F3, 0xABEF, 0xABED, 0x4102, 0x6A27, 0x9BAC, 0xB46E, 0x936C, 0xBCB0, 0xBC0E, 0x89A6, 0xAA08, 0x9125, 0x90C3, 0xA104, 0x9104, 0x9062, 0xA0A3, 0xC1E9, 0xF556, 0xDD12, 0xD490, 0xDCB2, 0xF4F2, 0xE512, 0xDD32, 0xE553, 0xF553, 
        0xF552, 0xE532, 0xDD12, 0xE511, 0xDCF1, 0xDCD1, 0xD4D0, 0xDCB0, 0xD4B1, 0xD4B0, 0xD48E, 0xCCAE, 0xCCAE, 0xCC6E, 0xC42F, 0xCC6E, 0xC44E, 0xBC2E, 0xC42D, 0xB3CC, 0xB3CC, 0xB3AC, 0xAB8B, 0xA30A, 0x9309, 0x8AE8, 0x8AA9, 0x8289, 0x7226, 0x61E5, 
        0x59C5, 0x6163, 0x6184, 0x61A5, 0x61A4, 0x61E5, 0x59A4, 0x7226, 0x8329, 0x1901, 0x1921, 0x2162, 0x2123, 0x20C1, 0x2922, 0x18E2, 0x10A2, 0x8CCC, 0xB5AF, 0x8C4B, 0x2981, 0x0860, 0x39E4, 0x4224, 0x18C1, 0x18C1, 0x2122, 0x2123, 0x20E2, 0x28E3, 
        0x39C5, 0x31A5, 0x08A1, 0x10A2, 0x9CF3, 0xEF1C, 0xEE9A, 0xE698, 0xEE57, 0xF658, 0xF6F9, 0xFFDC, 0xFFBC, 0xFFBC, 0xFFDC, 0xF6FA, 0xF6FA, 0xF6FA, 0xEED9, 0xF6B9, 0xF6D9, 0xF6DA, 0xF6D9, 0xEE96, 0xF73A, 0xE6D9, 0xB512, 0x6B27, 0x7368, 0xA48E, 
        0xD595, 0xB4CE, 0xA48C, 0xAC6C, 0xAC2D, 0xA40D, 0xAC4E, 0xB4AE, 0xACCD, 0xAC6F, 0xC532, 0xD573, 0xC512, 0xB54E, 0xB56E, 0xACCC, 0x93C8, 0x9C6B, 0xACEC, 0xACAB, 0x9C09, 0xCDAF, 0xC52D, 0xB4AC, 0xAC6C, 0xA42B, 0xD5D2, 0xBD30, 0x62A5, 0x7366, 
        0xA4CA, 0xB56B, 0xACE8, 0x5B65, 0x5B24, 0x6324, 0x7304, 0x6B64, 0x7BE9, 0x5AC8, 0x1902, 0x9529, 0xD6F5, 0xDE59, 0xBC16, 0xB41E, 0xBC1E, 0xBC3E, 0xBC5D,
  0x8B70, 0x7B0F, 0x7AED, 0x72CA, 0x6B0B, 0x6AEC, 0x72ED, 0x72CD, 0x72AE, 0x6B0B, 0x6B8A, 0x83AB, 0x93CB, 0x9BAB, 0x9BAB, 0x93AB, 0x8B4A, 0x7AE9, 0x72A7, 0x6A67, 0x7A87, 0x8A89, 0x9288, 0x8A86, 0x7A45, 0x6A44, 0x6284, 0x6AC4, 0x82C8, 0x9B0B, 0xA32D, 
        0x9AEC, 0x9AC9, 0x9AE9, 0xA32B, 0xABAE, 0xCC6E, 0xDCD1, 0xE513, 0xE532, 0xF573, 0xF554, 0xED54, 0xE533, 0xCCF2, 0xBC4F, 0xABEE, 0xA38D, 0x9B2A, 0x9309, 0x92E8, 0x92C8, 0x8A69, 0x9AAA, 0xA30B, 0xB38D, 0xB3EF, 0xC3EF, 0xC3F0, 0xBC10, 0xB36E, 
        0xAB6D, 0xAB6C, 0xA32C, 0x9ACA, 0xA2CA, 0xA2AA, 0x92A9, 0x8AA8, 0x82A7, 0x7AA6, 0x7285, 0x6AC9, 0x832A, 0x938B, 0xA3ED, 0xC46E, 0xBC2E, 0xA3AC, 0x8B49, 0x6A87, 0x6265, 0x6265, 0x6AA8, 0x934C, 0x934B, 0x9B6B, 0xB40E, 0xD4B3, 0xE494, 0xE453, 
        0xDC12, 0xBC0F, 0xABCD, 0xABAD, 0xBB8F, 0xAB0B, 0x8AA9, 0x7A67, 0x8285, 0x930A, 0x82A9, 0x62A7, 0x52A5, 0x5A41, 0x61A0, 0x5141, 0x4142, 0x51C5, 0x51A5, 0x4943, 0x3921, 0x51C5, 0x41A4, 0x3163, 0x3162, 0x5AA7, 0x7309, 0x8369, 0x8BE9, 0x8387, 
        0x9409, 0xAC6B, 0xBC8D, 0xC4B0, 0xC46F, 0xBC0E, 0xBBEF, 0xBBEF, 0xC40E, 0xDC70, 0xECF3, 0xD430, 0xCC6E, 0xCC90, 0xD4B4, 0xF639, 0xFE57, 0xFE58, 0xFE7B, 0xF5F4, 0xF6D9, 0xCCF3, 0x88A3, 0xB0A5, 0xB908, 0xB98A, 0xC20C, 0xAA4B, 0x7925, 0x4041, 
        0x1800, 0x4841, 0x8249, 0xBC51, 0xDD96, 0x82C9, 0x92E9, 0xABAD, 0xC491, 0xB36C, 0xA2CB, 0x91E7, 0x88A2, 0xB189, 0x98C4, 0x98C4, 0xB967, 0x90A3, 0x9062, 0xB9C8, 0xF453, 0xDC71, 0xE4D2, 0xDCD1, 0xD490, 0xECF2, 0xED12, 0xED12, 0xED12, 0xED52, 
        0xED52, 0xED32, 0xED52, 0xE512, 0xE511, 0xE4F1, 0xDCD1, 0xDCB1, 0xDCB0, 0xDCCF, 0xD4AF, 0xD46F, 0xD46F, 0xCC6F, 0xCC6E, 0xCC2F, 0xC44F, 0xBC4E, 0xBC2D, 0xB3CD, 0xABAC, 0xA38C, 0xA34B, 0xA36A, 0x9329, 0x92E9, 0x92A8, 0x6A67, 0x6A06, 0x69C5, 
        0x61A5, 0x5984, 0x69C4, 0x7205, 0x7206, 0x6244, 0x61E3, 0x82E8, 0xAC8F, 0x18C2, 0x2963, 0x31A3, 0x18C1, 0x20E3, 0x2963, 0x2122, 0x18E2, 0xB5AF, 0x7BE8, 0x3A02, 0x2141, 0x3202, 0x4A84, 0x4203, 0x1900, 0x1101, 0x2944, 0x3165, 0x2945, 0x2923, 
        0x3985, 0x49E6, 0x4A07, 0x0841, 0x1881, 0x732C, 0xEF7D, 0xFFDE, 0xFF19, 0xFEF9, 0xFF9D, 0xFFFF, 0xFFBD, 0xFF9B, 0xFF7B, 0xF75C, 0xFF3C, 0xFF3B, 0xFF1A, 0xF6F7, 0xF6F8, 0xFEF8, 0xF6F7, 0xEEB9, 0xF6D8, 0xF73A, 0xE71B, 0x3104, 0x18C1, 0x41E4, 
        0x8BEB, 0xEE97, 0xC550, 0xA46B, 0xA42D, 0xB44F, 0xB46F, 0xB4AF, 0xB4D0, 0xBCEE, 0xBCD0, 0xBCB1, 0xC4D0, 0xD614, 0xD5F3, 0xB510, 0x83AB, 0x72C6, 0xAC2D, 0xC4CF, 0xAC6C, 0x9C89, 0xA4EB, 0xACCC, 0xA48C, 0xACCB, 0x9C68, 0x9C88, 0xA52B, 0x9466, 
        0x8C45, 0x8CA8, 0x9D2C, 0x7BE4, 0x62E3, 0x62C4, 0x8366, 0x7365, 0x62A4, 0x5A65, 0x7309, 0xE713, 0xCD71, 0xB472, 0xBC96, 0xB45B, 0xBC5E, 0xCC5E, 0xD45D,
  0x8AD2, 0x8AF1, 0x830F, 0x7B0E, 0x7AEE, 0x7ACF, 0x7AD1, 0x82F4, 0x7ACD, 0x6B2A, 0x7369, 0x93AA, 0x8BCF, 0x93AF, 0x9B8D, 0x9B8B, 0x934B, 0x930A, 0x8AC9, 0x8289, 0x82C9, 0x9ACA, 0xA2CB, 0x92AB, 0x9264, 0x7AA4, 0x6A85, 0x6A47, 0x930D, 0x9B2D, 0xA32D, 
        0xA34E, 0xA2EC, 0x9AEB, 0x930C, 0xA36E, 0xAC2F, 0xC491, 0xDD12, 0xE553, 0xF534, 0xED53, 0xED73, 0xED94, 0xDCB2, 0xCC2E, 0xB3AC, 0x9B0A, 0x92C9, 0x8AA8, 0x92C9, 0x9AEC, 0x9269, 0x92CA, 0xA32B, 0xB34C, 0xA36D, 0xAB6D, 0xB36D, 0xBBAE, 0xBBCD, 
        0xBBAD, 0xB38D, 0xB36C, 0xBB8D, 0xB34B, 0xAB0B, 0xA2CA, 0x8AE8, 0x82E8, 0x7AA9, 0x6269, 0x5A64, 0x72A8, 0x8B0C, 0xA38E, 0xA3B0, 0x9B8D, 0x934B, 0x830A, 0x7B8A, 0x7349, 0x7309, 0x7AE8, 0x7B49, 0x936B, 0xA3AD, 0xB431, 0xDCD3, 0xECF5, 0xE4B5, 
        0xCC51, 0xBC11, 0xB3CE, 0xA38B, 0x9309, 0x82A9, 0x72C6, 0x7306, 0x8349, 0x72E7, 0x6AC8, 0x6AC9, 0x62C8, 0x49C3, 0x49E3, 0x5A45, 0x6AA6, 0x4A44, 0x41C4, 0x49A4, 0x4985, 0x38A1, 0x3881, 0x40E2, 0x51C5, 0x8B0A, 0x932A, 0x9329, 0x9329, 0x9B4A, 
        0xB40D, 0xBC6E, 0xC46F, 0xF4B3, 0xE471, 0xDC50, 0xDC4F, 0xCBCE, 0xCBCD, 0xD3EE, 0xD431, 0xD48E, 0xD46E, 0xDC6F, 0xD470, 0x9B0B, 0xC44F, 0xE5D5, 0xFEDB, 0xFE56, 0xFEFA, 0xFE37, 0xEBCD, 0x98C6, 0xCA0B, 0xE2EE, 0xBACC, 0x9947, 0x7946, 0x6125, 
        0x5903, 0x7126, 0xB34E, 0xBC0F, 0x936C, 0xB3AE, 0x9B0C, 0x82C9, 0x7AE6, 0xB189, 0xB8E7, 0xC948, 0xD20B, 0xA083, 0xB0A5, 0xC0E6, 0xB0A5, 0x9042, 0xC22A, 0xE36E, 0xEC2E, 0xE4F2, 0xE4F1, 0xE4D1, 0xE4D2, 0xE4D1, 0xE4D1, 0xE4D1, 0xE4D1, 0xE4F1, 
        0xED32, 0xED32, 0xED11, 0xDD11, 0xE4F1, 0xE4F1, 0xE4F1, 0xDCB0, 0xDCB0, 0xDCD0, 0xD4CF, 0xD46F, 0xD48F, 0xCC8F, 0xBC6F, 0xC44E, 0xBC2E, 0xBC2E, 0xBC4D, 0xAB8C, 0xAB6C, 0xA36B, 0xA34A, 0x92E9, 0x92CA, 0x8AA9, 0x7247, 0x79A5, 0x6985, 0x6185, 
        0x61A5, 0x71A5, 0x6A06, 0x6A26, 0x6A05, 0x69E5, 0x6A66, 0x8B69, 0x9C2A, 0x18A2, 0x2942, 0x2982, 0x20C1, 0x3164, 0x3965, 0x28E4, 0x2104, 0xCE79, 0x630C, 0x3184, 0x62E6, 0x4262, 0x3A21, 0x29C1, 0x1121, 0x3161, 0x3162, 0x2983, 0x2984, 0x3141, 
        0x3141, 0x3183, 0x39A5, 0x1061, 0x3963, 0x6AE7, 0x940B, 0xAB6A, 0xDE17, 0xFFBE, 0xFFBF, 0xFFFF, 0xFFBD, 0xFF9C, 0xFF7C, 0xFF5B, 0xF6F9, 0xF6D7, 0xF6F6, 0xFEFA, 0xFEF8, 0xF696, 0xF635, 0xF719, 0xFF7B, 0xFFBB, 0xE6D7, 0x20E3, 0x1080, 0x2941, 
        0x5A63, 0xCD92, 0xBD51, 0xA4AE, 0x942C, 0xB3EE, 0xB44E, 0xAC8E, 0xB4AE, 0xB530, 0xB4EF, 0xBCCE, 0xC4D0, 0xBD50, 0xBD72, 0xB4EF, 0x9C0B, 0xB4CD, 0xB4CC, 0xC590, 0xE6D6, 0x5B04, 0x8467, 0xAD4A, 0xA488, 0x83A5, 0x7B44, 0x7B83, 0x8483, 0x9C89, 
        0xADAB, 0xA5AA, 0x8C65, 0x6362, 0x7364, 0x7365, 0x6345, 0x6AE4, 0x4A23, 0x7BCA, 0xE717, 0xCD31, 0xD532, 0xD554, 0xCD35, 0xC47D, 0xC47E, 0xCC7E, 0xC43E,
  0x8A92, 0x8AB2, 0x92D1, 0x92EE, 0x6ACE, 0x6AB1, 0x7A93, 0x82B3, 0x7AB3, 0x6ACD, 0x5B09, 0x5B69, 0xA3CB, 0xA3CB, 0xABED, 0xBBF0, 0xB34C, 0xA30B, 0xA30B, 0xA34A, 0xA34D, 0xAB2D, 0xAB2C, 0xA34B, 0x72A8, 0x72C7, 0x8B28, 0xB389, 0x9B4D, 0xAB8E, 0xB36E, 
        0xAAEC, 0x92CA, 0x8A49, 0x81E7, 0x79A6, 0x9B4D, 0xABCE, 0xC430, 0xDCB2, 0xE594, 0xE574, 0xE574, 0xE553, 0xD492, 0xC470, 0xBC2D, 0xB3AB, 0xA32B, 0xA34A, 0xA32A, 0x9AEA, 0xA32B, 0x9AEB, 0x92AA, 0x8269, 0x8228, 0x7A69, 0x8269, 0x8A68, 0x92AA, 
        0x92CA, 0x92EA, 0x9B2B, 0xA2EB, 0xAB0B, 0xAB4C, 0xB34C, 0xBB4C, 0xAB2B, 0xA309, 0xA327, 0x8AA8, 0x7AA5, 0x7AA5, 0x8AA7, 0x9B49, 0xAB8A, 0xA3CA, 0x93EA, 0x9BAB, 0x8B8A, 0x7B49, 0x6AC8, 0x7328, 0x7328, 0x7B07, 0x8B07, 0x9BAC, 0xA3CD, 0xABCE, 
        0xABED, 0x936A, 0x936A, 0x8389, 0x6B69, 0x6B05, 0x6B05, 0x7306, 0x6B07, 0x7349, 0x7329, 0x730A, 0x6AEB, 0x52A9, 0x4A27, 0x41C5, 0x3984, 0x5A24, 0x5A04, 0x4A25, 0x4286, 0x52A7, 0x62A8, 0x7AC9, 0x932A, 0x936A, 0x93CC, 0x9C2D, 0x9C6A, 0x93C6, 
        0x9386, 0x93A8, 0x9BCA, 0xB3CB, 0xB38B, 0xBBCC, 0xD46D, 0xDC6F, 0xDC90, 0xD471, 0xDC31, 0xE432, 0xDC51, 0xE492, 0xF4D2, 0xC3CE, 0xD472, 0xED35, 0xF5D5, 0xFE35, 0xF5F5, 0xF679, 0xEEFB, 0x9104, 0xA9A7, 0xD26B, 0xE22A, 0xA186, 0xBA6A, 0xD32C, 
        0xDB6C, 0xCB6C, 0xBA49, 0xB9C8, 0xB9E9, 0xBA09, 0xC229, 0xC1C8, 0xB126, 0xD167, 0xD168, 0xC947, 0xB0E6, 0xA8E5, 0xB0E5, 0xA084, 0x8841, 0xB988, 0xE36E, 0xE42F, 0xC40D, 0xDD31, 0xDD32, 0xDD11, 0xDCF0, 0xD4AF, 0xDCD1, 0xDCD1, 0xDCF1, 0xDD31, 
        0xE511, 0xE4F1, 0xD4F1, 0xDD11, 0xDCF1, 0xD4F0, 0xDCD0, 0xCCF1, 0xCCAF, 0xCCAE, 0xD4CF, 0xCC6E, 0xC44E, 0xC42E, 0xBC2E, 0xBC0D, 0xBC2D, 0xBC0C, 0xBB8C, 0xAB8B, 0xAB6A, 0xA32A, 0x9B0A, 0x92A9, 0x7A68, 0x7247, 0x6A07, 0x6984, 0x6185, 0x6185, 
        0x6985, 0x6A25, 0x69E5, 0x6A05, 0x6A26, 0x69A6, 0x8AE9, 0x6AA8, 0x18E1, 0x29E2, 0x29A3, 0x2922, 0x20C1, 0x31A3, 0x18E2, 0x39A6, 0x7BAD, 0x2942, 0x3202, 0x3A63, 0x31E1, 0x4243, 0x3A02, 0x2981, 0x20E0, 0x3983, 0x4A26, 0x4205, 0x1941, 0x2963, 
        0x2983, 0x3182, 0x3162, 0x3A26, 0x18E3, 0x0020, 0x18E3, 0xE71B, 0xFFBD, 0xFFBB, 0xFFDB, 0xFF9D, 0xFF7E, 0xFF5E, 0xF6FC, 0xF6D9, 0xFEF8, 0xF6F8, 0xEED9, 0xF6D8, 0xF6B8, 0xF697, 0xEE97, 0xF6B7, 0xDDB4, 0xCD93, 0xC5D1, 0x20E3, 0x39C4, 0x39C4, 
        0x2103, 0xDE75, 0xC592, 0xA46D, 0x93EA, 0x942B, 0xA42B, 0xAC4C, 0xB48E, 0xB4AF, 0xBCF0, 0xBD11, 0xBD31, 0xC551, 0xCD32, 0xCD12, 0xC4D0, 0xA42B, 0xCD91, 0xBD4F, 0x7B46, 0xA42B, 0x9BAA, 0x72E6, 0x4A62, 0x93C7, 0x9468, 0x9468, 0x9427, 0xA56A, 
        0xA4E9, 0x7B85, 0x4A41, 0x6303, 0x6364, 0x6B64, 0x6AE2, 0x3142, 0xA511, 0xEF18, 0xDE36, 0xBCB2, 0xCD11, 0xD554, 0xCD1B, 0xBBBE, 0xC41E, 0xC45E, 0xBC3E,
  0x8AB4, 0x8AB3, 0x8AD3, 0x82D2, 0x92F4, 0x8AB4, 0x8294, 0x7A94, 0x72CE, 0x6AEB, 0x6309, 0x6B68, 0x93CD, 0xA3EE, 0xABEF, 0xB411, 0xB38F, 0xAB6E, 0xA34E, 0x9B2E, 0xAB4E, 0xA32F, 0x9B50, 0x9B6F, 0x92EB, 0x8B0B, 0x8B0C, 0x932E, 0xAB72, 0xA332, 0xA310, 
        0x9AEE, 0x92CB, 0x828A, 0x7249, 0x7208, 0x7A89, 0x934C, 0xABEE, 0xBC70, 0xDD33, 0xE554, 0xED74, 0xED74, 0xDD31, 0xD4B1, 0xCC4F, 0xBBED, 0xB36B, 0xAB4C, 0xAB4C, 0xB36C, 0x9AEB, 0x92AB, 0x9AAA, 0x9AA9, 0x7A8A, 0x7A69, 0x8249, 0x7A6A, 0x7A69, 
        0x8289, 0x8A89, 0x9289, 0x9B2B, 0xAB2C, 0xB32C, 0xBB4B, 0xBB0C, 0xBB0B, 0xB2EB, 0x9AAB, 0x9288, 0x92A7, 0x92A7, 0x92C9, 0xA34B, 0x9B8B, 0x9B8B, 0xA3CB, 0x8BCA, 0x8389, 0x7B68, 0x7B28, 0x7327, 0x7328, 0x6B28, 0x6B48, 0x8BAB, 0x9BCC, 0x9BCD, 
        0xA3EE, 0xAC2F, 0x9C2D, 0x9C0C, 0x9BCB, 0x7345, 0x7345, 0x7325, 0x6AE5, 0x7369, 0x7B8B, 0x7B4B, 0x6AEA, 0x52AA, 0x41E4, 0x41C2, 0x4A24, 0x5244, 0x6285, 0x6A86, 0x6A27, 0x69E5, 0x79E6, 0x8A48, 0x9B0B, 0xAB2B, 0xAB8D, 0xABCE, 0xABCD, 0xAB8C, 
        0xB38B, 0xB3AC, 0xB3AE, 0xCBCF, 0xD3EF, 0xD40F, 0xD40F, 0xE4D2, 0xDC91, 0xDC91, 0xDCB2, 0xD450, 0xE492, 0xE472, 0xD451, 0xDC91, 0xE4F4, 0xED55, 0xF596, 0xFDD6, 0xFD75, 0xFE38, 0xEEDB, 0x9904, 0xC187, 0xD9E9, 0xD908, 0xB168, 0xC1C8, 0xCA48, 
        0xCAA9, 0xA9A7, 0xB148, 0xB908, 0xB0E6, 0xA8A5, 0xC107, 0xD147, 0xD125, 0xD98A, 0xE1E9, 0xD1A7, 0xB0E5, 0xC147, 0xB083, 0x9801, 0x90A2, 0xECF3, 0xE491, 0xD40E, 0xD44F, 0xECF2, 0xED12, 0xE4F1, 0xDCD1, 0xDCD0, 0xDCD0, 0xDCD0, 0xDCF1, 0xE511, 
        0xE511, 0xE511, 0xE511, 0xE511, 0xDCF1, 0xDCF1, 0xDCF1, 0xD4AE, 0xD48E, 0xCC8F, 0xD46F, 0xDC8E, 0xCC6F, 0xC46F, 0xC44E, 0xC42D, 0xBC0C, 0xB3CC, 0xABCC, 0xAB6B, 0x9B2B, 0x9309, 0x8B08, 0x8AAA, 0x7A49, 0x71E6, 0x71A5, 0x6185, 0x69C5, 0x69E5, 
        0x69E5, 0x69C5, 0x6205, 0x6A25, 0x7246, 0x8A67, 0x82A8, 0x5205, 0x18E1, 0x3A04, 0x2983, 0x2122, 0x2922, 0x2945, 0x18C3, 0x39C6, 0x73CD, 0x41E2, 0x5263, 0x5283, 0x3A02, 0x5285, 0x4243, 0x31A1, 0x2921, 0x4A65, 0x4A85, 0x5244, 0x51E3, 0x3181, 
        0x2120, 0x18A0, 0x1061, 0x59E3, 0x3902, 0x4103, 0x92E9, 0xEF5C, 0xFFDE, 0xFFBE, 0xFF9D, 0xFF5D, 0xFF7D, 0xFF7C, 0xFF5B, 0xFF38, 0xF739, 0xF71A, 0xF6FA, 0xFEB9, 0xF697, 0xF697, 0xFE97, 0xEEF7, 0xDDF4, 0xD5D3, 0xBDD3, 0x2103, 0x39E4, 0x4A44, 
        0x39A1, 0x72C6, 0xBD31, 0xCDB3, 0xA46E, 0x9C2D, 0xAC2E, 0xB42E, 0xB46E, 0xB48E, 0xB4B0, 0xBCD1, 0xC4F1, 0xBD11, 0xCD51, 0xDD72, 0xDDB4, 0xBD6E, 0x9C4A, 0x8BA8, 0x9409, 0xEED3, 0xD631, 0xA48A, 0x7324, 0xD64F, 0xD66E, 0xA549, 0x6BA5, 0xA4A7, 
        0x7BA4, 0x62E2, 0x52A0, 0x52C1, 0x5282, 0x41E2, 0x39A2, 0xD56F, 0xEE76, 0xDDD5, 0xB471, 0xDD77, 0xDDB3, 0xD54F, 0xC4D0, 0xC45C, 0xC45E, 0xC43F, 0xC41F,
  0x8AD4, 0x92B5, 0x92B4, 0x8AD3, 0x8B14, 0x8AF2, 0x7AF0, 0x7311, 0x7A93, 0x6ACE, 0x6B0B, 0x7329, 0x8BAC, 0xA3EC, 0xABED, 0xB3F0, 0xBBF3, 0xAB92, 0xA330, 0xA2EE, 0x9B92, 0xA3B0, 0xABAF, 0x9B8E, 0x8ACC, 0x932D, 0x9B6F, 0x9B70, 0xA3B2, 0xA36F, 0xA30D, 
        0x92AD, 0x826B, 0x7A2A, 0x71E9, 0x61C7, 0x61E5, 0x82C9, 0x9BAE, 0xAC71, 0xC4D3, 0xDD34, 0xE554, 0xED54, 0xED30, 0xE4F1, 0xDCB1, 0xD44F, 0xB36D, 0xB36D, 0xB36D, 0xB34D, 0x9B2C, 0x92EB, 0x92CB, 0x8AAC, 0x6A48, 0x6A08, 0x6208, 0x6208, 0x6A08, 
        0x7209, 0x7A49, 0x7A8A, 0x9AAC, 0xA30C, 0xAB4C, 0xB34C, 0xBB6D, 0xAB6C, 0xA36B, 0xA34A, 0x8B09, 0x8AE8, 0x8AE9, 0x8B0A, 0xA308, 0xA36A, 0xABEC, 0xB44C, 0x8BEA, 0x8BCA, 0x8389, 0x7B28, 0x7B65, 0x7305, 0x6AC5, 0x6AA3, 0x7B8B, 0x836B, 0x836A, 
        0x8BCA, 0x9C2D, 0xA42C, 0x942B, 0x83EB, 0x7B09, 0x6AE7, 0x6B07, 0x6B48, 0x6B0B, 0x7B0D, 0x834E, 0x7B6D, 0x6286, 0x4A24, 0x39C2, 0x39A1, 0x5AA5, 0x4AA4, 0x4284, 0x5AA5, 0x7329, 0x8B6C, 0x9BAE, 0x9BEF, 0xB3CC, 0xC3CD, 0xBBEF, 0xABF0, 0xB3AE, 
        0xB38D, 0xAB6C, 0xAB4A, 0xB3CF, 0xC3F0, 0xD3CF, 0xDBEF, 0xEC92, 0xEC92, 0xEC51, 0xE410, 0xECD4, 0xF4B3, 0xECB3, 0xECD4, 0xF535, 0xCC30, 0xBC0E, 0xDCF2, 0xF5D5, 0xFD13, 0xFDB6, 0xF6DB, 0xB185, 0xB9E7, 0xD24A, 0xF1AA, 0xC909, 0xB906, 0xA903, 
        0x98E2, 0xC123, 0xD167, 0xD1AA, 0xC9E9, 0xD22A, 0xDA09, 0xE26B, 0xF34F, 0xEA29, 0xD9A9, 0xC988, 0xC147, 0xA043, 0x9042, 0xA9A6, 0xEBEF, 0xDBD0, 0xD3EF, 0xD44F, 0xDCCF, 0xF4F1, 0xECF2, 0xE4F2, 0xE4F1, 0xDCD1, 0xDCD1, 0xDCF1, 0xE4F1, 0xDCF0, 
        0xE4F1, 0xE511, 0xE512, 0xE511, 0xE4F0, 0xDCF1, 0xDCF2, 0xDC8E, 0xDC8F, 0xD490, 0xCC6F, 0xC48F, 0xC470, 0xCC4F, 0xC42D, 0xBC6E, 0xB40D, 0xB3CB, 0xAB8A, 0x9B4B, 0x9B2A, 0xA30A, 0xA2AA, 0x6AA7, 0x6A06, 0x71C5, 0x71C6, 0x69A5, 0x6A06, 0x7246, 
        0x7A07, 0x7205, 0x7A46, 0x7266, 0x6A44, 0x7287, 0x6A64, 0x49E3, 0x1983, 0x3181, 0x3161, 0x2963, 0x29A3, 0x2922, 0x18A3, 0x41E6, 0x844A, 0x4A83, 0x4A84, 0x5A84, 0x5A42, 0x4AA5, 0x4AA4, 0x31E2, 0x10C1, 0x5AE6, 0x6B49, 0x4A87, 0x1101, 0x0020, 
        0x1880, 0x41C4, 0x7B49, 0x1881, 0x5101, 0xA3AB, 0xF77D, 0xFFFF, 0xFF5C, 0xFF3B, 0xFF7D, 0xFF7D, 0xFF7D, 0xFF7D, 0xFF7D, 0xFF7C, 0xF73B, 0xF71A, 0xF6FA, 0xFED9, 0xFEB8, 0xFE77, 0xF636, 0xFF19, 0xE656, 0xDE15, 0xCDB4, 0x20E3, 0x2983, 0x4A63, 
        0x5AA2, 0x5221, 0x9C4B, 0xBD71, 0xAD51, 0xA42C, 0xAC0D, 0xB42E, 0xAC2D, 0xAC6E, 0xBCB1, 0xBCD1, 0xB4D0, 0xDD52, 0xD573, 0xD573, 0xDD54, 0xD56F, 0xA46D, 0xB4EF, 0xEE53, 0xCD72, 0xD570, 0xD58F, 0xBD4E, 0x9C68, 0xCDEF, 0xEE71, 0xD56E, 0x6345, 
        0x6B46, 0x7B88, 0x8BCA, 0x7C07, 0x5AE4, 0x7BC7, 0xDE2F, 0xD572, 0xBCF1, 0xCD34, 0xEDD8, 0xBD13, 0xC4F3, 0xC4D5, 0xC499, 0xC43E, 0xC41F, 0xCC1F, 0xCC1F,
  0x8A53, 0x8A93, 0x8AB3, 0x8AB3, 0x7AAF, 0x82D1, 0x8AD2, 0x7AD0, 0x6B0B, 0x6ACB, 0x6ACB, 0x6B2A, 0x8B8A, 0x938F, 0xA393, 0xAB96, 0xA335, 0xAB55, 0xAB55, 0xA335, 0x9AF4, 0x9B34, 0x9B33, 0x9AF2, 0x82D3, 0x9B34, 0xA354, 0xA355, 0xAB56, 0x9AB4, 0x9252, 
        0x8A2E, 0x6209, 0x6208, 0x6A08, 0x6207, 0x6A29, 0x6228, 0x7268, 0x9B0A, 0xBC71, 0xCCD2, 0xDD32, 0xE573, 0xDD33, 0xD4F2, 0xD4B0, 0xCC4E, 0xC46E, 0xC40D, 0xBBCD, 0xB38D, 0xAB0C, 0x9AEC, 0x8ACB, 0x7AA9, 0x8A69, 0x69E7, 0x59A6, 0x61A7, 0x59E5, 
        0x5985, 0x5125, 0x50E5, 0x59A4, 0x8247, 0x9ACA, 0xAB0C, 0xB36C, 0xB32B, 0xAB0A, 0x9AC9, 0x8225, 0x8AA6, 0x9B08, 0xA309, 0xAB6A, 0x9B48, 0x9B48, 0x9B28, 0x6AC5, 0x62C5, 0x62C5, 0x5AC4, 0x6B05, 0x7346, 0x7346, 0x6B27, 0x52A3, 0x52C4, 0x6307, 
        0x8369, 0x83AA, 0x944C, 0x9C6D, 0xA44C, 0x944A, 0x83A9, 0x6B28, 0x5AE8, 0x936B, 0x9C6E, 0xA4B0, 0xA42F, 0x5289, 0x3143, 0x2922, 0x4224, 0x7BAA, 0x8B8B, 0x9B8C, 0xABAE, 0xB410, 0xB3CF, 0xBBAE, 0xCBCD, 0xBB8E, 0xC32C, 0xCB2D, 0xCB6E, 0xC40E, 
        0xCC4F, 0xD42F, 0xDBCF, 0xDB6E, 0xDBCF, 0xDC10, 0xDC31, 0xD510, 0xDD51, 0xDD33, 0xDCF5, 0xE572, 0xE594, 0xE574, 0xDD53, 0xDD34, 0xEEDA, 0xF71B, 0xEDB4, 0xBC70, 0xDD75, 0xFE17, 0xFDF6, 0xF576, 0xBACA, 0xB945, 0xE947, 0xEA2B, 0xEA4B, 0xE1C9, 
        0xD145, 0xC9E9, 0xE1AA, 0xE9CB, 0xEA2A, 0xF20B, 0xE20B, 0xE22A, 0xF22B, 0xDACC, 0xD249, 0xC946, 0xA822, 0x8041, 0xBA69, 0xD3EE, 0xCC8F, 0xE48E, 0xE530, 0xDD52, 0xDD13, 0xDD11, 0xE4D0, 0xDCD1, 0xD4F1, 0xCC8D, 0xCC8D, 0xD4AE, 0xD4D0, 0xDD12, 
        0xE4F1, 0xDCF0, 0xDCF0, 0xDCD1, 0xD4D1, 0xCCB0, 0xCC8E, 0xCCCF, 0xCC8E, 0xCC6D, 0xC44D, 0xCC6E, 0xC44E, 0xBC2D, 0xB42D, 0xBB8C, 0xB38B, 0xAB6A, 0xA32B, 0xA32A, 0x92C8, 0x82A8, 0x6A88, 0x6984, 0x6185, 0x6185, 0x69A5, 0x61C5, 0x61E5, 0x61E5, 
        0x61E4, 0x69A7, 0x69C6, 0x69E6, 0x6A46, 0x6AC6, 0x31C3, 0x2140, 0x3160, 0x2184, 0x2102, 0x2922, 0x2964, 0x1881, 0x41E4, 0x5AC5, 0x5AC3, 0x52C5, 0x4A83, 0x4243, 0x4225, 0x6305, 0x3162, 0x39A3, 0x7BA7, 0x7B6A, 0x3164, 0x1842, 0x38E4, 0x946D, 
        0x83ED, 0x4A48, 0x2924, 0xE71C, 0xFFFF, 0xFFFE, 0xFFDC, 0xEE76, 0xF6D9, 0xFF5C, 0xFF7C, 0xEF7B, 0xF77C, 0xF75C, 0xF73A, 0xF6F8, 0xFEF9, 0xF719, 0xF6F8, 0xEE58, 0xF677, 0xEE77, 0xEE57, 0xF675, 0xB50F, 0xA4CE, 0xA50F, 0x18C2, 0x3163, 0x5284, 
        0x62E4, 0x5202, 0xB4CF, 0xD5D3, 0xACAD, 0x9C4E, 0xA42D, 0xAC2D, 0xAC4E, 0xAC6E, 0xAC8D, 0xBCEE, 0xCD32, 0xBD11, 0xBD10, 0xC571, 0xD5F3, 0xB4F0, 0xC52F, 0xCD4F, 0xC550, 0xBCCF, 0xDDB3, 0xD592, 0xAC4A, 0x9429, 0xC570, 0xEEB7, 0xEF38, 0x8B47, 
        0x9388, 0x9408, 0x8BE6, 0x9BA9, 0xCD71, 0xF6F8, 0xEF3B, 0x6AE7, 0xBC91, 0xDDB6, 0xC573, 0xC554, 0xBCEF, 0xBCB0, 0xC498, 0xC41E, 0xC41F, 0xC43E, 0xC41E,
  0x8AB6, 0x8A96, 0x8AB6, 0x8AF4, 0x8AF4, 0x8AF1, 0x82EF, 0x7B0E, 0x8AF3, 0x82F2, 0x7AF0, 0x72CE, 0x8B6E, 0x93AF, 0x9BB1, 0xA392, 0xA334, 0x9B35, 0x9B34, 0xA335, 0x9B15, 0x9B15, 0x9B34, 0x8B53, 0x9312, 0x9B33, 0x9B54, 0xA354, 0x92F5, 0x92F6, 0x92F4, 
        0x92B0, 0x7AAC, 0x728A, 0x726A, 0x724A, 0x6A68, 0x7269, 0x7269, 0x82AA, 0xBC6F, 0xCCD2, 0xDD14, 0xED53, 0xE533, 0xE4F2, 0xDCB0, 0xCC6E, 0xC40E, 0xBC2D, 0xC40D, 0xC3CE, 0xABAD, 0x9B2C, 0x92EA, 0x92CA, 0x8AED, 0x7AAB, 0x7249, 0x6208, 0x6A48, 
        0x7228, 0x6A07, 0x69E6, 0x79E9, 0x7A69, 0x8AAA, 0xA30C, 0xBB8D, 0xB38D, 0xAB6C, 0x9B09, 0x6AC6, 0x7AC6, 0x8AE8, 0x9B4A, 0xA34A, 0xA369, 0x9B89, 0xA3AA, 0x9B8A, 0x8B88, 0x7B87, 0x7367, 0x8387, 0x8387, 0x8387, 0x8B87, 0x7366, 0x6B26, 0x6B47, 
        0x7BEA, 0x9C8D, 0xA46D, 0xAC6D, 0xB4AF, 0x940D, 0x8BAA, 0x8369, 0x7329, 0x838C, 0x9430, 0xA472, 0x9C2F, 0x6B0B, 0x49E6, 0x3983, 0x39E3, 0x6AE9, 0x7B6A, 0x83AB, 0x9BED, 0xA40F, 0xB3CF, 0xBB8E, 0xC38E, 0xAB8D, 0xAB6D, 0xB34D, 0xBB6D, 0xC3CF, 
        0xC3F0, 0xCC11, 0xCC31, 0xCBAE, 0xDBAF, 0xDBD0, 0xE3D0, 0xE471, 0xE4D1, 0xE4F2, 0xE512, 0xE532, 0xE553, 0xE574, 0xED95, 0xD4F2, 0xC491, 0xD553, 0xEE77, 0xCCD2, 0xDCF3, 0xED55, 0xFDB5, 0xEE17, 0xC2EB, 0xC1A7, 0xF2AD, 0xFA6D, 0xF24C, 0xF24B, 
        0xEA6A, 0xF34E, 0xF2CE, 0xF24C, 0xE1C9, 0xF28C, 0xFB2F, 0xFB70, 0xFB50, 0xDA08, 0x9104, 0x7061, 0x8082, 0xE3F0, 0xF4D2, 0xE4D0, 0xCC6E, 0xECF3, 0xED12, 0xE511, 0xE4F1, 0xECF1, 0xE4F1, 0xDCD1, 0xD4B0, 0xDCAF, 0xD490, 0xD490, 0xDCB0, 0xDCD0, 
        0xDCD1, 0xDCF1, 0xE4F1, 0xE4D1, 0xDCD0, 0xD4D0, 0xD4D0, 0xDCAF, 0xD48E, 0xC44E, 0xBC4D, 0xC46D, 0xC46E, 0xC42F, 0xBBEE, 0xB3EC, 0xABCC, 0xA38B, 0x9B4A, 0x9AE9, 0x8288, 0x7227, 0x7226, 0x69E5, 0x69A5, 0x71A5, 0x69C6, 0x61A5, 0x69E5, 0x6A05, 
        0x6A05, 0x6A26, 0x6A06, 0x6A06, 0x6A47, 0x6A65, 0x41E2, 0x29A2, 0x31C3, 0x2161, 0x2962, 0x2983, 0x2943, 0x10C2, 0x41C5, 0x62C6, 0x6B86, 0x5A84, 0x4A43, 0x4263, 0x52C5, 0x5AE3, 0x3181, 0x28E1, 0x3142, 0x1061, 0x6269, 0xB514, 0xF7BE, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xF79B, 0xF759, 0xF759, 0xFF3A, 0xF6DA, 0xF6FB, 0xFF5D, 0xFF7C, 0xFF7C, 0xFF7C, 0xF75A, 0xFF39, 0xF739, 0xF719, 0xFF1A, 0xFEFA, 0xF6D9, 0xEE97, 0xE636, 0xF6D8, 0xD5F4, 0xB531, 0x8C4D, 0x3223, 0x31C2, 0x52A5, 
        0x7BC7, 0x41A2, 0x7348, 0xA4CE, 0xC592, 0xA46E, 0xA44E, 0xAC4E, 0xB44E, 0xA46E, 0xAC8E, 0xB48F, 0xB4B1, 0xC512, 0xCD32, 0xD553, 0xDD53, 0xCD73, 0xCD53, 0xBCF0, 0xAC6D, 0xD551, 0xDD73, 0xEE55, 0xEF36, 0x82E8, 0x8347, 0xB50E, 0xF6F7, 0xDDF3, 
        0xB48C, 0xB4CC, 0xE673, 0xF716, 0xE615, 0xCD54, 0xBCF2, 0xBCD3, 0xCD34, 0xCD53, 0xBCF2, 0xC4B1, 0xC477, 0xC45B, 0xC43D, 0xC43F, 0xC43F, 0xC43F, 0xC41F,
  0x8B14, 0x8AD3, 0x92D3, 0x9313, 0x8B11, 0x8B4F, 0x832D, 0x830C, 0x934F, 0x9332, 0x92F2, 0x92F2, 0x7372, 0x8372, 0x9372, 0x9393, 0x92D5, 0x92F5, 0x8B15, 0x82F5, 0x9B56, 0x9335, 0x92F5, 0x92F6, 0x92F6, 0x9316, 0x9336, 0x9356, 0x9317, 0x92D5, 0x9293, 
        0x8250, 0x828D, 0x826D, 0x7A6C, 0x7A8A, 0x7268, 0x6A48, 0x7248, 0x8AA9, 0xA42E, 0xC4B1, 0xDD13, 0xFD54, 0xF573, 0xED33, 0xE4F1, 0xE4AF, 0xC430, 0xB42F, 0xBC6F, 0xCC90, 0xC3D0, 0xB3CF, 0x9B6D, 0x82CA, 0x934D, 0x934D, 0x82EC, 0x6A49, 0x6229, 
        0x7209, 0x7209, 0x7209, 0x71E8, 0x71E8, 0x8249, 0x9AEB, 0xABAE, 0xB3AF, 0xB36E, 0x9B0C, 0x7A45, 0x6AA5, 0x7B07, 0x9B6A, 0xAB6A, 0xAB69, 0x9B48, 0x9348, 0x9BCA, 0x8BEA, 0x8389, 0x8B27, 0x83C9, 0x8BC9, 0x8BC9, 0x8BEA, 0x6B47, 0x62A5, 0x62A5, 
        0x6B28, 0x8BEA, 0x942C, 0xA44E, 0xB48F, 0xACAE, 0x9C0D, 0x8B6B, 0x7308, 0x736B, 0x8C0F, 0xA492, 0xB4D4, 0x940E, 0x52A7, 0x2963, 0x3102, 0x72EC, 0x8B4C, 0x9B8D, 0xABCF, 0xB42E, 0xC3F0, 0xCBD1, 0xC3CF, 0xE370, 0xCB4D, 0xB30C, 0xB30D, 0xE3EF, 
        0xEC31, 0xF472, 0xF493, 0xD390, 0xDC11, 0xDC91, 0xD4D1, 0xF4D4, 0xED33, 0xE533, 0xDD13, 0xDD31, 0xDD73, 0xDD93, 0xDDB4, 0xF6BA, 0xDDD4, 0xBC8F, 0xB3ED, 0xEF19, 0xE574, 0xDCB2, 0xF576, 0xF71C, 0xC32C, 0xC146, 0xF28B, 0xFB73, 0xFB31, 0xF2CD, 
        0xF28A, 0xFB52, 0xF351, 0xEB6F, 0xEBAF, 0xFC54, 0xF432, 0xCB2D, 0x8966, 0x9021, 0xB023, 0xD169, 0xEBD1, 0xF5D2, 0xE50F, 0xE4EF, 0xF571, 0xE512, 0xDD31, 0xDD31, 0xE4F1, 0xE511, 0xE4D0, 0xECD1, 0xED12, 0xD4AE, 0xDCD0, 0xDCB1, 0xDC8F, 0xDCD2, 
        0xDCD1, 0xDCD0, 0xE4F1, 0xDCD1, 0xDCB0, 0xDCB0, 0xDCF0, 0xD48F, 0xD46F, 0xC44E, 0xB42D, 0xBC0E, 0xC42E, 0xC44E, 0xC42E, 0xB3AD, 0xA38B, 0x9B4A, 0x930A, 0x82A9, 0x7A46, 0x7225, 0x7205, 0x71A5, 0x71C5, 0x71C5, 0x71C5, 0x6A25, 0x69E5, 0x69C5, 
        0x6A05, 0x6A47, 0x6A25, 0x7226, 0x7A67, 0x4181, 0x51E2, 0x4A22, 0x39E3, 0x2943, 0x3143, 0x3963, 0x3963, 0x1901, 0x4205, 0x62E6, 0x6B25, 0x62C4, 0x6B26, 0x6345, 0x52A1, 0x1080, 0x51C1, 0x8305, 0x8C4D, 0xE71B, 0xFFBE, 0xFFFF, 0xFFDE, 0xFFBE, 
        0xFFDE, 0xFFDE, 0xFF9E, 0xFFFF, 0xFFDE, 0xFF9D, 0xF75D, 0xFFDD, 0xFFFE, 0xFFDE, 0xFFBE, 0xFFBC, 0xFF7B, 0xFF7B, 0xFF9B, 0xFF3C, 0xFF5C, 0xFF5B, 0xFF1A, 0xFF3B, 0xF719, 0xFEF7, 0xFF17, 0xFF18, 0xDE76, 0xBD73, 0x8C2E, 0x1982, 0x2981, 0x5A85, 
        0x7BC8, 0x6326, 0x5A63, 0x8369, 0xCD93, 0xA44E, 0xAC2F, 0xB470, 0xAC6F, 0xAC4E, 0xB44F, 0xAC4F, 0xA42E, 0xC4F1, 0xCCF2, 0xC4F2, 0xC533, 0xE555, 0xC4F2, 0xBCF1, 0xCD73, 0xCDD3, 0xBD50, 0xCD51, 0xF5D6, 0xF757, 0xA4ED, 0x8369, 0x9BAD, 0xEE96, 
        0xCD92, 0xA46D, 0x9C0D, 0xC533, 0xCD13, 0xCD33, 0xC576, 0xCD13, 0xC513, 0xC512, 0xC4D1, 0xB4B2, 0xBC97, 0xBC7B, 0xC47E, 0xCC1F, 0xC43F, 0xC43F, 0xCC3F,
  0x9295, 0x8AB5, 0x8AB5, 0x8AD3, 0x7332, 0x8B4F, 0x934E, 0x934E, 0x82D6, 0x8AB6, 0x8AB5, 0x8295, 0x92D3, 0x82F1, 0x82F0, 0x92D1, 0x8AF4, 0x8AD4, 0x92B5, 0x92B5, 0x8AB6, 0x9AF6, 0x9AF6, 0x92D7, 0x92F7, 0x9AF7, 0xA2F8, 0xA2F8, 0x9296, 0x9AF7, 0xA337, 
        0xA2F6, 0xA313, 0x9B30, 0x9B2E, 0x92EE, 0x82E9, 0x8AE9, 0x8ACA, 0x82AB, 0xA3AD, 0xB44E, 0xC4F1, 0xD533, 0xE514, 0xDCD2, 0xCC90, 0xC44E, 0xC42D, 0xCC4E, 0xCC6F, 0xC490, 0xB40C, 0xABAD, 0xAB6D, 0xAB6C, 0x932C, 0x930C, 0x9B0C, 0x9B2C, 0xA38D, 
        0x9B4C, 0x9B2B, 0xA30B, 0x9B4D, 0xA36D, 0xB3AD, 0xC3EF, 0xCBEE, 0xBBCD, 0xB3CB, 0xABAB, 0x8B49, 0x8309, 0x8B08, 0x9328, 0xA34A, 0xA38A, 0xB3EB, 0xBC2C, 0xBC2B, 0xAC4B, 0x9C4B, 0x8C6B, 0xA44B, 0x9C8C, 0x9CAC, 0xACAD, 0xB50E, 0x9CAC, 0x944A, 
        0x9C2A, 0xCD71, 0xCD70, 0xC571, 0xC552, 0xB4AE, 0xA44D, 0x93EC, 0x93CB, 0xA48E, 0xACF2, 0xACD2, 0x9C2F, 0x5AA9, 0x39A5, 0x3143, 0x41A4, 0x5B06, 0x7B49, 0x8B49, 0x92E9, 0xAAEB, 0xAB4D, 0xAB6D, 0xBB2D, 0xAA8A, 0xA289, 0xA289, 0xB269, 0xD38F, 
        0xCB8E, 0xBB2C, 0xB2EA, 0xF492, 0xEC72, 0xE3F1, 0xD3B1, 0xBBCB, 0xCC6E, 0xD4D1, 0xD511, 0xC553, 0xC533, 0xC533, 0xC553, 0xAC4F, 0xB4B2, 0xC512, 0xD50F, 0xD496, 0xD433, 0xCC11, 0xC471, 0xF5D6, 0xF618, 0xCC10, 0xA0C3, 0xD22B, 0xEB51, 0xF391, 
        0xEB0D, 0xF30C, 0xF32D, 0xF30E, 0xF2AE, 0xC166, 0xA904, 0xB0C4, 0xC8E4, 0x9126, 0xCBAD, 0xF531, 0xFD51, 0xE4D2, 0xED52, 0xED52, 0xD511, 0xED73, 0xE532, 0xDD12, 0xED73, 0xE553, 0xD511, 0xD4D0, 0xD4AF, 0xCCD1, 0xCCD1, 0xCCB0, 0xCC8E, 0xCC8E, 
        0xCCB0, 0xCCB0, 0xD4CE, 0xCC8E, 0xC48E, 0xC48E, 0xCC6E, 0xC46C, 0xC44D, 0xC44D, 0xBC2C, 0xB40B, 0xB3AD, 0xB38D, 0xAB8B, 0xA32A, 0x9309, 0x92C9, 0x9287, 0x7A05, 0x69E5, 0x69E6, 0x71E7, 0x51A4, 0x6A05, 0x6A05, 0x61A5, 0x59C5, 0x61E6, 0x6A26, 
        0x6225, 0x6166, 0x5984, 0x6205, 0x72A6, 0x3181, 0x31E2, 0x39E3, 0x3164, 0x2121, 0x2943, 0x3185, 0x31A6, 0x2124, 0x4A25, 0x5AC7, 0x4AC7, 0x4AA3, 0x31A1, 0x18C0, 0x20E4, 0xE71C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFDE, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFBE, 0xFFDE, 0xFFFF, 0xF7DF, 0xFF1B, 0xEEFB, 0xEF1B, 0xFF7A, 0xEF7B, 0xF75A, 0xF73A, 0xF71A, 0xF738, 0xF739, 0xF719, 0xF718, 0xF6F9, 0xF698, 0xEE57, 0xEE36, 0xF75B, 0xACF1, 0x8BCB, 0x7C2A, 0x18C2, 0x4AA4, 0x6BE6, 
        0x6BA8, 0x4A05, 0x4A03, 0x7328, 0xAD11, 0xBCEF, 0xACAD, 0xA44D, 0xABEE, 0xA48E, 0xAC6E, 0xB46E, 0xB490, 0xC4F2, 0xC4F1, 0xC4F2, 0xCCF3, 0xCD32, 0xCD94, 0xBCF1, 0x93A9, 0xC4AE, 0xE636, 0xDE36, 0xBCED, 0xACF0, 0xAC6C, 0xB48B, 0xBD70, 0xD614, 
        0xC550, 0xBD2E, 0xC5D0, 0xE5B4, 0xDDB4, 0xCD72, 0xBCEE, 0xBD12, 0xC4D3, 0xBCB3, 0xBCB4, 0xCCB9, 0xD49D, 0xCC3E, 0xBBDD, 0xC47E, 0xC45E, 0xC41E, 0xC3FE,
  0x82D3, 0x8AF4, 0x9314, 0x8B33, 0x8350, 0x836E, 0x8B4F, 0x92F3, 0x92B6, 0x92D5, 0x92F4, 0x9316, 0x92D6, 0x9AD7, 0x92D6, 0x8AF3, 0x92F3, 0x92F5, 0x9AF6, 0x92F6, 0x9AD7, 0x92F6, 0x9B17, 0x9AF7, 0x9AD6, 0x9AF6, 0x9AF6, 0x9AD5, 0x9336, 0x9B36, 0xA316, 
        0x9B16, 0x9B13, 0x9B11, 0x9310, 0x8AED, 0x92CA, 0x930B, 0x930B, 0x930B, 0xAC0D, 0xC470, 0xD4B2, 0xE513, 0xE512, 0xDCD2, 0xD4B0, 0xCC6E, 0xC44E, 0xC46E, 0xC470, 0xC471, 0xBC4E, 0xB3EE, 0xABAE, 0xA3AD, 0xA3AE, 0x9B8D, 0x8B4C, 0x832C, 0x8B2C, 
        0x932C, 0x932D, 0x9B4D, 0xAB8E, 0xAB8D, 0xB3AD, 0xC40E, 0xBC4E, 0xBC6E, 0xBC6E, 0xBC0E, 0xA3AA, 0x8B49, 0x8B49, 0x9369, 0x936A, 0xA38A, 0xABAB, 0xA38B, 0xB40C, 0xA42C, 0x9C2B, 0x940A, 0x93C9, 0x9C2B, 0xA48C, 0xA48C, 0xB4CD, 0xACAD, 0x9C4C, 
        0x942B, 0xACEF, 0xBD30, 0xC550, 0xC570, 0xC512, 0xB4B0, 0x9C4D, 0x8C0B, 0x940E, 0xA492, 0xACF3, 0xB4F1, 0x7B4E, 0x5248, 0x3184, 0x2961, 0x5A67, 0x72C8, 0x8B49, 0xA3AC, 0xBB6E, 0xBB6D, 0xB34D, 0xAB0C, 0xBAED, 0xBAEB, 0xB2A9, 0xA268, 0xCC0D, 
        0xB3AC, 0xBC2F, 0xED96, 0x9CEC, 0xB4CF, 0xC4B2, 0xBC72, 0xBCAE, 0xB4AE, 0xC4CF, 0xDD11, 0xDCB3, 0xD4D2, 0xD4F1, 0xDD31, 0xB511, 0x7B09, 0x7268, 0x938F, 0xCD52, 0xE599, 0xBC19, 0x81F2, 0xC610, 0xEDF6, 0xDD95, 0xB4CE, 0xB0A5, 0xA884, 0xA8E5, 
        0xB145, 0xB904, 0xB0A4, 0xB065, 0xC045, 0xB126, 0x926A, 0x92AC, 0xBAAC, 0xF73C, 0xFE99, 0xFDB4, 0xF552, 0xFD73, 0xF573, 0xF573, 0xF572, 0xED12, 0xF532, 0xF532, 0xED31, 0xDD12, 0xDD32, 0xDD11, 0xDCF0, 0xD4B1, 0xD4D0, 0xD4AF, 0xD48F, 0xD4AF, 
        0xD4AF, 0xD4AE, 0xDCAF, 0xD470, 0xD46F, 0xD46F, 0xD46F, 0xD44E, 0xCC4E, 0xC44D, 0xBC2D, 0xB3CD, 0xB3AD, 0xB3AC, 0xABAC, 0x9B4A, 0x92E9, 0x8A8A, 0x824A, 0x6185, 0x69A6, 0x71C6, 0x71C6, 0x6A25, 0x6A05, 0x6A05, 0x6A25, 0x6A45, 0x61E4, 0x61C4, 
        0x61C4, 0x4963, 0x5165, 0x5A06, 0x5AC5, 0x39A2, 0x39A2, 0x39C2, 0x39C1, 0x3184, 0x3163, 0x3163, 0x39A4, 0x4225, 0x62E8, 0x6B28, 0x52E5, 0x3A02, 0x41C2, 0x8366, 0xEEB0, 0xFFDD, 0xFFFE, 0xFFDE, 0xFFFE, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFBF, 0xFFDF, 0xFFDE, 0xFFDD, 0xFFDD, 0xFF9D, 0xFF9C, 0xFFBB, 0xF75B, 0xFF5A, 0xF73A, 0xF6FA, 0xFF5A, 0xF6F9, 0xF71A, 0xFFBD, 0xE695, 0xC591, 0x7BAB, 0x2101, 0x0860, 0x39E3, 0x6348, 
        0x742C, 0x49E3, 0x2921, 0x3984, 0x7B0A, 0xCDD4, 0xB511, 0xAC6E, 0xB48E, 0xAC4E, 0xAC4E, 0xB46F, 0xB470, 0xB46D, 0xB490, 0xB4B1, 0xB4EF, 0xDDD3, 0xBD10, 0xB48E, 0xCCD0, 0xF637, 0xC492, 0x82A9, 0x61E4, 0xDE79, 0xCDD4, 0xA42B, 0x7AE6, 0xDDF4, 
        0xE616, 0xD592, 0xBD0E, 0xBD32, 0xC533, 0xC533, 0xC552, 0xBCD0, 0xBD0F, 0xC530, 0xC4F2, 0xBC5D, 0xBC3F, 0xC43F, 0xC45F, 0xC41F, 0xC43E, 0xC43E, 0xC41E,
  0x8AF4, 0x9314, 0x9333, 0x9352, 0x834F, 0x8370, 0x8371, 0x8333, 0x9AD5, 0x92F5, 0x92F5, 0x92F5, 0x92D8, 0x9AD8, 0x9AD7, 0x92F6, 0x9314, 0x92F5, 0x92F5, 0x92F6, 0x9318, 0x9AF7, 0x9AF6, 0x9316, 0xA2D8, 0x9AD7, 0x92D7, 0x92B9, 0xA37A, 0x9B37, 0xA337, 
        0xB379, 0xA2F4, 0xA333, 0xA372, 0x9B4F, 0x9B2D, 0x9B4D, 0x9B2C, 0x9B0D, 0xABAC, 0xC450, 0xD4D1, 0xE531, 0xE533, 0xECF1, 0xE490, 0xCC2F, 0xB44F, 0xB46F, 0xCCB0, 0xE4F2, 0xB470, 0xBC4F, 0xBC2F, 0xB3EF, 0x9B6C, 0x9B4D, 0x9B4D, 0x9B2B, 0x9B0C, 
        0xAB4D, 0xAB6C, 0xAB6B, 0xB40E, 0xBBEE, 0xBC0E, 0xBC4E, 0xC42E, 0xC42F, 0xCC6F, 0xC4AE, 0xB34C, 0xA36A, 0x9B49, 0x9329, 0x9B69, 0x9369, 0x9B8A, 0xB40B, 0xBC2C, 0xB46E, 0xB48D, 0xA46C, 0x942C, 0xA44C, 0xAC8C, 0xACAD, 0xA46D, 0xA4AE, 0xA4AD, 
        0xA48B, 0xB531, 0xB551, 0xCD91, 0xEDD2, 0xBD32, 0xACAF, 0xA42D, 0x93ED, 0x944D, 0xA490, 0xB4F3, 0xB534, 0x940F, 0x6ACA, 0x3964, 0x2061, 0x51E4, 0x7287, 0x8B0A, 0xA38E, 0xD3F0, 0xBBCF, 0xAB8E, 0xA36D, 0xB2AB, 0xB2AA, 0xB269, 0xB1E7, 0xE26B, 
        0xEAAF, 0xEB32, 0xF414, 0xD532, 0xD532, 0xD4F2, 0xDC91, 0xBBEF, 0xABCC, 0xAC8D, 0xC632, 0xCE78, 0xCDD7, 0xCD57, 0xC4D6, 0xA288, 0xDD95, 0xFF5A, 0xEE53, 0x7A66, 0xC553, 0xDF37, 0xB60D, 0xA962, 0xDB09, 0xFD72, 0xFEFB, 0xFD37, 0xDC12, 0xCB8E, 
        0xD3AC, 0xCBB0, 0xCB6D, 0xCB6D, 0xCBAE, 0xF46E, 0xFD32, 0xFE16, 0xFE76, 0xFCF2, 0xFD12, 0xF512, 0xF4F2, 0xFDD5, 0xFDB4, 0xFD94, 0xF575, 0xED32, 0xED52, 0xED53, 0xED33, 0xE510, 0xE511, 0xE512, 0xDCF2, 0xDCB0, 0xDCD0, 0xDCD0, 0xD4AF, 0xDCAF, 
        0xDCAF, 0xD490, 0xBC70, 0xCC8F, 0xCC8F, 0xC48F, 0xC44E, 0xC48E, 0xBC4E, 0xBBED, 0xBBCC, 0xB3ED, 0xB3CD, 0xABAC, 0x9B6A, 0x9AEA, 0x92A9, 0x8A87, 0x7265, 0x7965, 0x7985, 0x7185, 0x7146, 0x7A46, 0x7245, 0x7205, 0x7206, 0x61E5, 0x59A5, 0x51A5, 
        0x49A4, 0x48E3, 0x5965, 0x6206, 0x5A66, 0x41A1, 0x41C2, 0x39A2, 0x2161, 0x3184, 0x39C4, 0x2963, 0x1902, 0x93ED, 0x7B90, 0x6AEF, 0x72AB, 0x4B03, 0x3241, 0x31A1, 0x4A24, 0xE736, 0xFFDD, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDD, 0xFFFD, 0xFFDC, 0xFF7C, 0xFF7D, 0xFF7B, 0xFF7B, 0xFF7B, 0xFF39, 0xFF3A, 0xFF5B, 0xFF9C, 0xFF1A, 0xE655, 0x944D, 0x1922, 0x10E0, 0x2941, 0x5AE5, 
        0x9CCB, 0x2962, 0x2121, 0x3961, 0x61C2, 0x6AE8, 0xB4B0, 0xCD31, 0xAC4E, 0xAC50, 0xAC90, 0xAC6F, 0xAC2F, 0xAC90, 0xBC91, 0xC492, 0xC4B2, 0xD575, 0xBC91, 0xC513, 0xEE97, 0x9346, 0x8B25, 0x93A7, 0x9429, 0x8323, 0x9446, 0xB52B, 0xC550, 0x8BAD, 
        0xB530, 0xD5F3, 0xD591, 0xB4CA, 0xBD0F, 0xCD52, 0xCD72, 0xBCD1, 0xC499, 0xC47D, 0xBC3E, 0xC3DF, 0xBC3F, 0xBC5F, 0xC43F, 0xCC1F, 0xCC3F, 0xC45F, 0xCC5E,
  0x8AD4, 0x8AF4, 0x8AF3, 0x8311, 0x8B30, 0x8B51, 0x8B32, 0x92B4, 0x9299, 0x92B7, 0x92B5, 0x92B6, 0x92D6, 0x92B6, 0x92D5, 0x92D3, 0x92D6, 0x92D6, 0x9AD7, 0x9AB7, 0x92B6, 0x92D6, 0x9AD5, 0x9AD4, 0x8AF6, 0x9AF6, 0xA336, 0xAB76, 0xA335, 0xA336, 0x9B36, 
        0x9333, 0x9B0F, 0x9B0E, 0x9B4D, 0xA3AC, 0xC410, 0xC430, 0xC44F, 0xC46E, 0xCC90, 0xD4B0, 0xD4B1, 0xCC91, 0xDCD0, 0xCC90, 0xC44F, 0xCC2D, 0xC44E, 0xC44E, 0xC46F, 0xC470, 0xDCD1, 0xC491, 0xBC6F, 0xC46D, 0xBC6F, 0xBC6F, 0xB46F, 0xB46F, 0xBC70, 
        0xBC70, 0xC470, 0xC471, 0xC450, 0xC46F, 0xC48E, 0xC46E, 0xCC6E, 0xC46D, 0xC44C, 0xBC2D, 0xCC6D, 0xBBEC, 0xB3CB, 0xB42A, 0xA38B, 0xABAB, 0xB3CB, 0xAB8B, 0xA389, 0x9348, 0x8327, 0x7B06, 0x82E6, 0x9BCA, 0xB48D, 0xC50E, 0xCD71, 0xD5B2, 0xD5B2, 
        0xD592, 0xF653, 0xEE13, 0xD5D2, 0xBD91, 0xD5B2, 0xCD73, 0xBD31, 0xACCD, 0x9C2D, 0xA490, 0xACB3, 0xAC74, 0x734D, 0x4A47, 0x3A05, 0x4AA7, 0x936A, 0xABAD, 0xBBEE, 0xBC0E, 0xA34D, 0xAAEB, 0xAACA, 0x9AAA, 0x9AAB, 0xB26B, 0xC30D, 0xCBF0, 0x8AEA, 
        0xB491, 0xCD77, 0xCD5A, 0xF5B6, 0xF5B7, 0xEDB6, 0xDD73, 0xB2EF, 0xB3AE, 0xABCD, 0x8B29, 0x8B87, 0x83E9, 0x840A, 0x842C, 0x9472, 0x39C7, 0x0821, 0x18C3, 0xCDBC, 0xCD3F, 0xD59F, 0xDEDC, 0x4949, 0x9AEF, 0xD452, 0xD46E, 0xF636, 0xFE57, 0xFE77, 
        0xFE97, 0xFE35, 0xFE98, 0xFEB9, 0xFE38, 0xED95, 0xED54, 0xED33, 0xE532, 0xEDD3, 0xF593, 0xF5B5, 0xF616, 0xED53, 0xED74, 0xED93, 0xE572, 0xF573, 0xF573, 0xED52, 0xED32, 0xDD32, 0xD4F1, 0xD4D0, 0xDCCF, 0xCCF1, 0xCCAF, 0xCC8E, 0xCC8E, 0xC44E, 
        0xBC8E, 0xC48D, 0xCC4D, 0xBC50, 0xBC4F, 0xBC2E, 0xB42E, 0xC40E, 0xBBED, 0xB3AC, 0xB36C, 0xA369, 0xA32A, 0xA30A, 0x9AC9, 0x8226, 0x61C5, 0x5986, 0x6986, 0x61E5, 0x61C5, 0x69E5, 0x6A65, 0x61E5, 0x59A5, 0x5165, 0x5124, 0x4925, 0x4944, 0x4144, 
        0x4125, 0x4122, 0x4945, 0x49C6, 0x4A63, 0x3183, 0x29A3, 0x3183, 0x3143, 0x3A23, 0x2961, 0x3161, 0x5223, 0x4268, 0x4A47, 0x5AC6, 0x5B88, 0x3142, 0x6286, 0xACEE, 0xF798, 0xFFFE, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDE, 0xFFDE, 0xFFBD, 0xFFBD, 0xFFDD, 0xFFFD, 0xFFBE, 0xFF9C, 0xFF7B, 0xFF7B, 0xFF59, 0xFF5A, 0xFF3A, 0xF719, 0xFF3A, 0xF73A, 0xF73A, 0xFF3B, 0xDE96, 0xAD10, 0x6B29, 0x2942, 0x1061, 0x5246, 0x6B08, 
        0x4A45, 0x31A0, 0x28E0, 0x2040, 0x20C3, 0xDE36, 0xC5B5, 0xACF2, 0xAC8F, 0x9C2C, 0xAC4D, 0xBC8F, 0xBC90, 0xAC2E, 0xB470, 0xB4B1, 0xB4B0, 0xB4B0, 0xC532, 0xC4F1, 0xABED, 0x7BE7, 0x7C09, 0x6347, 0x3A42, 0xAD2C, 0xDE76, 0xCDB4, 0x8BE9, 0xB52D, 
        0xC530, 0xD573, 0xD5B4, 0xB4EE, 0xBCF1, 0xCD52, 0xCD6F, 0xBCB6, 0xC47A, 0xC45D, 0xBC3F, 0xBC5F, 0xCC3F, 0xCC1E, 0xBBFE, 0xBC1E, 0xC41E, 0xC41E, 0xBBFE,
  0x92D4, 0x8AF5, 0x8B14, 0x9311, 0x8B51, 0x8B52, 0x8B33, 0x92F6, 0x9AB6, 0x92B6, 0x92D6, 0x92B6, 0x92D6, 0x92B6, 0x92D6, 0x92F6, 0x9AF6, 0x92D6, 0x92D6, 0x92D6, 0x9B17, 0x9AF7, 0x92B8, 0x92B8, 0xA339, 0xAB59, 0xAB79, 0xB378, 0xB3B7, 0xAB76, 0xA355, 
        0x9353, 0x9B31, 0x9B4F, 0xA36E, 0xAB8D, 0xBC2F, 0xBC50, 0xC451, 0xCC50, 0xBC71, 0xCC92, 0xD4B1, 0xD4D0, 0xD4D1, 0xDC8F, 0xD44D, 0xCC4E, 0xBC2F, 0xBC4E, 0xC46F, 0xD4B1, 0xD4B1, 0xCCD1, 0xBCB1, 0xBC90, 0xBC90, 0xBC70, 0xBC50, 0xBC30, 0xC470, 
        0xC44F, 0xBC4F, 0xBC51, 0xCC70, 0xC46E, 0xCC6E, 0xD46E, 0xCC4D, 0xCC6E, 0xCC6E, 0xCC4C, 0xCC4E, 0xC44D, 0xB42C, 0xAC0B, 0xABCA, 0xA38A, 0xA36A, 0xB3AA, 0xA389, 0x9B89, 0x8B68, 0x8346, 0x9389, 0xA3EB, 0xB44B, 0xBCCC, 0xBD2F, 0xCD50, 0xCD51, 
        0xC570, 0xD5B2, 0xC570, 0xBD4E, 0xC54F, 0xDD93, 0xD593, 0xC531, 0xB48D, 0xAC8E, 0xAC70, 0xB490, 0xACCE, 0x7BAD, 0x5AC8, 0x4A65, 0x5284, 0x7329, 0x834A, 0x8B49, 0x932A, 0xBB6D, 0xB36D, 0xA30D, 0x9AAC, 0xA2EB, 0xA32B, 0xA34B, 0xB38C, 0xF514, 
        0xEC93, 0xDBF2, 0xD371, 0xD16E, 0xD9CE, 0xC9AE, 0xA8EC, 0xE290, 0xC22E, 0xB26C, 0xC34A, 0xA34B, 0x936B, 0x93AD, 0x8BCF, 0x18E4, 0x2187, 0x322F, 0x29D6, 0x10A9, 0x6B31, 0x9D16, 0xAD57, 0xEC77, 0xB2AE, 0xA2CC, 0xCCB2, 0xF553, 0xECD2, 0xECB2, 
        0xF4F2, 0xED33, 0xF593, 0xF593, 0xF532, 0xED33, 0xED32, 0xF573, 0xFDD5, 0xF574, 0xF594, 0xF594, 0xF594, 0xF5B5, 0xF594, 0xF593, 0xED93, 0xF554, 0xF553, 0xED73, 0xED93, 0xE4F1, 0xDCF1, 0xDCF1, 0xD4D1, 0xD48E, 0xCCAF, 0xCCAF, 0xCC8E, 0xCC8F, 
        0xC46D, 0xC44D, 0xBC2E, 0xBC2E, 0xBC0E, 0xC3CE, 0xBB8D, 0xBC2E, 0xB3ED, 0xABAC, 0xAB8B, 0x9B29, 0x9B09, 0x9AC9, 0x8A87, 0x7A05, 0x71C6, 0x69A6, 0x69C5, 0x71C5, 0x71C5, 0x71E4, 0x69C3, 0x59A5, 0x5185, 0x5165, 0x5145, 0x5145, 0x4125, 0x4124, 
        0x4122, 0x2842, 0x40E5, 0x51C8, 0x5A68, 0x39E1, 0x31A2, 0x39A4, 0x41C5, 0x3182, 0x3141, 0x3982, 0x4A25, 0x5A8D, 0x628F, 0x732D, 0x7BA9, 0x2922, 0x5266, 0x94AD, 0xDEF6, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFDF, 0xFFDE, 0xFFDE, 0xFFDD, 0xFF9C, 0xFF9B, 0xFF7C, 0xFF5A, 0xF71A, 0xF71A, 0xFF3A, 0xFF5A, 0xFF3A, 0xFF3B, 0xF71B, 0xCE15, 0xD676, 0xA4F0, 0x31A2, 0x10E1, 0x4225, 0x5AC6, 
        0x4264, 0x1061, 0x3942, 0x6245, 0x7B08, 0x9BCB, 0xAC90, 0xB512, 0xBD32, 0xABED, 0xAC4D, 0xAC6E, 0xAC4F, 0xB44D, 0xB48F, 0xBC91, 0xBC91, 0xB4B0, 0xCD73, 0xBCD1, 0x8B0B, 0x52E7, 0x5B87, 0x6BA7, 0x7B68, 0x8BA7, 0xB56D, 0xD630, 0xD5B0, 0x93AA, 
        0xACCF, 0xD5D2, 0xE633, 0xB4F1, 0xB4EE, 0xB4ED, 0xC4D2, 0xC49C, 0xBC3E, 0xBC3E, 0xC47E, 0xC3FF, 0xC41F, 0xCC3F, 0xCC3E, 0xBC1E, 0xBC1F, 0xC3FF, 0xC3DF,
  0x92D4, 0x92D5, 0x92F4, 0x8B32, 0x8B31, 0x8B12, 0x8AF4, 0x8AF5, 0x92F7, 0x92D6, 0x92D6, 0x92D7, 0x9B16, 0x9B16, 0x9AF6, 0x92D6, 0x92D6, 0x92D6, 0x9AF7, 0x9AF7, 0x9B17, 0x9B17, 0x9B16, 0x92F5, 0xAB77, 0xAB96, 0xABB5, 0xB3B5, 0xBBF2, 0xABD2, 0x9B93, 
        0x9B54, 0x9350, 0x9B4E, 0xA34D, 0xA38C, 0xCC90, 0xC490, 0xBC70, 0xBC71, 0xDC8F, 0xDCD1, 0xDCD2, 0xDCB1, 0xDCD1, 0xDCB0, 0xD46F, 0xCC0E, 0xB42E, 0xCC4F, 0xD470, 0xCCB2, 0xDCD1, 0xD4B0, 0xD4D1, 0xDCF2, 0xD4D1, 0xCCB0, 0xC490, 0xC48F, 0xBC90, 
        0xC470, 0xCC90, 0xD4B1, 0xD48F, 0xD48F, 0xD46F, 0xD46F, 0xD4AF, 0xD48E, 0xDC6E, 0xDC6E, 0xB42D, 0xBC4E, 0xC44E, 0xC42D, 0xB40C, 0xABCB, 0xABAA, 0xB3AB, 0xA38A, 0x9B89, 0x9388, 0x8369, 0x8327, 0x9BE9, 0xB46D, 0xC4AF, 0xED6F, 0xE592, 0xE5D3, 
        0xEE13, 0xEE15, 0xF614, 0xDDD2, 0xB54F, 0xED72, 0xED92, 0xD552, 0xBCF0, 0x9C6C, 0xAC8E, 0xB4D0, 0xA4F2, 0xA46F, 0x7369, 0x52A4, 0x5242, 0x6B4C, 0x8BAC, 0xA3EC, 0xAC0E, 0xAB6F, 0xAB6F, 0xAB2E, 0xA2CE, 0xAA6C, 0xA26B, 0x9AAB, 0x936E, 0xEC9B, 
        0xE253, 0xD90C, 0xD12B, 0xF0F4, 0xF8F5, 0xF134, 0xE153, 0xF954, 0xE8B2, 0xE88F, 0xE90B, 0xA983, 0xBA8A, 0xB2AD, 0x8208, 0x2987, 0x1167, 0x0908, 0x104A, 0x188D, 0x9397, 0xBC19, 0x9294, 0xDEBA, 0x8B14, 0x79D0, 0xCBD2, 0xCBEF, 0xECD3, 0xFD35, 
        0xFD35, 0xFD97, 0xF575, 0xF554, 0xFD54, 0xF594, 0xF574, 0xFD54, 0xFD54, 0xFD53, 0xFD73, 0xFD74, 0xFD95, 0xFDD5, 0xFDB5, 0xF595, 0xED94, 0xFDB4, 0xF573, 0xED52, 0xF552, 0xE4F1, 0xE4F1, 0xE4D1, 0xDCB0, 0xD4B0, 0xD48F, 0xD46F, 0xC46F, 0xC44E, 
        0xC44E, 0xC42E, 0xBC4D, 0xBC6E, 0xC40D, 0xC3ED, 0xBC0D, 0xB3CC, 0xB3AB, 0xABAB, 0xA36B, 0x92C9, 0x92EB, 0x8AAB, 0x7228, 0x7225, 0x7A05, 0x79E5, 0x71C5, 0x69C6, 0x69E5, 0x7205, 0x7226, 0x6987, 0x6144, 0x5944, 0x5967, 0x28C2, 0x30A1, 0x3061, 
        0x2842, 0x51E9, 0x7B0E, 0x7B2F, 0x4A6A, 0x3141, 0x3982, 0x41A3, 0x4183, 0x39E3, 0x5AA7, 0x62AA, 0x49CC, 0x51CD, 0x5A4B, 0x6AE9, 0x7B89, 0x6B0A, 0x5266, 0x6A24, 0xBAE9, 0xF75C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFC, 0xFFBC, 0xFF7C, 0xFF7B, 0xFF5B, 0xFF5B, 0xFF3B, 0xFF1C, 0xFF39, 0xFF5B, 0xFF5C, 0xFF5A, 0xF6D8, 0xE697, 0x948F, 0x1942, 0x4205, 0x6286, 0x51E4, 
        0x2081, 0x5203, 0x7B28, 0x93EC, 0xA42E, 0x83AB, 0x93ED, 0xA450, 0xBCB2, 0xBD0F, 0xA42E, 0xA40F, 0xBCAF, 0xAC2F, 0xB470, 0xBC70, 0xAC70, 0xBCB1, 0xCD13, 0xBCF1, 0x9C2D, 0x83E7, 0x5AC3, 0x5AE2, 0x7C05, 0x8304, 0xABA6, 0xC48D, 0xCD74, 0xB56B, 
        0xA4AA, 0xBD2F, 0xEE58, 0xBCF5, 0xB46E, 0xB46D, 0xB492, 0xBC5E, 0xBC3F, 0xC41F, 0xC41F, 0xBC7E, 0xC43E, 0xC41E, 0xCC1E, 0xCC3F, 0xCBFF, 0xCBFF, 0xCC5F,
  0x8A96, 0x8AD5, 0x8AD3, 0x8AD3, 0x8AF2, 0x8AF4, 0x8AD6, 0x9277, 0x9AB5, 0x92D6, 0x92D6, 0x92B6, 0x92D6, 0x92B6, 0x92D6, 0x92F6, 0x92D6, 0x9AD7, 0x9AF7, 0x92F7, 0x9AB6, 0x9AB7, 0x9AD8, 0xAB19, 0xABD6, 0xBBF7, 0xC417, 0xC456, 0xB3D2, 0xB392, 0xA351, 
        0x8311, 0x934D, 0x938E, 0xA3CF, 0xBC0E, 0xC4AE, 0xCCB1, 0xCCB2, 0xCCD1, 0xD4B2, 0xD4B1, 0xD4B0, 0xDCD1, 0xD4D1, 0xCC6F, 0xCC4D, 0xC44D, 0xD44E, 0xCC4E, 0xCC4E, 0xD4B0, 0xD512, 0xD4F2, 0xD4F2, 0xD4F1, 0xCC91, 0xD4B1, 0xD4D1, 0xD4D0, 0xD4B1, 
        0xD4B0, 0xCCB0, 0xCC91, 0xCC6F, 0xD48F, 0xD48F, 0xCC8E, 0xD44F, 0xD46F, 0xCC8E, 0xCC6E, 0xD44F, 0xD42D, 0xCC2D, 0xC42D, 0xC42B, 0xBBCC, 0xB3AC, 0xB3AA, 0xA349, 0x9348, 0x8328, 0x8B07, 0xAB6B, 0xB3CC, 0xB42C, 0xB4AC, 0xBCCE, 0xC50E, 0xC4ED, 
        0xCCAD, 0xBCED, 0xAC6B, 0xA42A, 0xAC8C, 0xD5D3, 0xDDF5, 0xDDB3, 0xCD50, 0xBCAE, 0xB4AE, 0xACAE, 0xAC6D, 0x6329, 0x52A6, 0x5285, 0x52E7, 0x7325, 0x6B05, 0x72C6, 0x8287, 0xA32A, 0xA36C, 0xAB6E, 0xBB4E, 0x92E9, 0xB34C, 0xDC31, 0xFD36, 0xF515, 
        0xD22E, 0xD0AB, 0xF10E, 0xFA13, 0xF214, 0xF255, 0xFAB8, 0xFA59, 0xF9DA, 0xE975, 0xC8CB, 0xD026, 0xA825, 0xA0E8, 0xC22F, 0xD235, 0xE25A, 0x9A5B, 0x19D6, 0x184A, 0x404B, 0x8A6F, 0xDD53, 0x69DC, 0xB4DD, 0xB495, 0x6147, 0xE552, 0xED12, 0xE4B2, 
        0xF4F3, 0xED74, 0xED75, 0xED75, 0xED94, 0xF594, 0xED74, 0xED73, 0xF593, 0xF5B5, 0xF5B5, 0xED95, 0xE555, 0xED74, 0xED74, 0xED94, 0xFDB4, 0xEDB3, 0xED73, 0xED52, 0xED12, 0xDD31, 0xDCF1, 0xD4D0, 0xD4CE, 0xD48F, 0xC48F, 0xC46E, 0xC46D, 0xBC2D, 
        0xC42D, 0xBC2C, 0xB42C, 0xC38C, 0xBB8C, 0xB38C, 0xB36C, 0xBBAB, 0xAB4B, 0xA30A, 0x9AE9, 0x8A87, 0x8226, 0x71A5, 0x6165, 0x71A5, 0x6986, 0x71A7, 0x7A47, 0x7206, 0x61E5, 0x5985, 0x4905, 0x28A2, 0x20A3, 0x20A2, 0x28A1, 0x2825, 0x30E6, 0x522A, 
        0x8370, 0x7B31, 0x7292, 0x620F, 0x49C9, 0x2981, 0x3182, 0x3983, 0x41A2, 0x5A86, 0x4A09, 0x49AA, 0x49CA, 0x30EA, 0x49EC, 0x732E, 0x8C2E, 0x52A4, 0x6AE5, 0x9C8D, 0xD6F9, 0xFFDE, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDD, 0xFF7E, 0xF75C, 0xF75B, 0xF75B, 0xF739, 0xF6F9, 0xF6D9, 0xF6D8, 0xF71B, 0xFF7C, 0xFF7B, 0xF6F8, 0xDE55, 0x944D, 0x5265, 0x2921, 0x42A7, 0x31E3, 0x1940, 
        0x2182, 0xAC8E, 0xB44E, 0x9BCC, 0x8BCC, 0x9BED, 0x93CB, 0x9C0C, 0xAC90, 0xB513, 0xB4AF, 0xAC4E, 0xAC2E, 0xAC6D, 0xAC4F, 0xB451, 0xB451, 0xBCF0, 0xC513, 0xB431, 0x8AA9, 0x5AC4, 0x5345, 0x6BE6, 0x8C47, 0x8448, 0x946A, 0xACEC, 0xCD4E, 0xB44C, 
        0xB4AD, 0xBD2E, 0xBD70, 0xCE0F, 0xBD50, 0xB476, 0xC41E, 0xC47C, 0xBC5D, 0xBC1F, 0xC41F, 0xBC1E, 0xC41F, 0xC43F, 0xC45F, 0xC45D, 0xC49E, 0xC47B, 0xB3D6,
  0x92B6, 0x92D6, 0x8AD4, 0x8AD3, 0x8AF3, 0x8AD5, 0x8AD7, 0x92B7, 0x92D6, 0x92D6, 0x92D6, 0x92B6, 0x9AF6, 0x9AD6, 0x92D6, 0x92D6, 0x9AD7, 0x9AF7, 0x9AD7, 0x9AD7, 0x9AF6, 0x9AF7, 0x9AF7, 0x9B17, 0xBBF6, 0xBC36, 0xBC55, 0xCC73, 0xBBF1, 0xB392, 0xAB91, 
        0x9B6E, 0x930D, 0xA38E, 0xB40F, 0xC430, 0xC492, 0xCCB1, 0xCCB1, 0xCCB1, 0xD4B1, 0xD4B1, 0xDCB1, 0xDCD1, 0xD490, 0xD46E, 0xCC4D, 0xCC6D, 0xCC4E, 0xCC4E, 0xCC6F, 0xCCB1, 0xDD11, 0xDD11, 0xD4F2, 0xCCF1, 0xD4B1, 0xD4B1, 0xD4B1, 0xD4B1, 0xCCB1, 
        0xCC90, 0xD4B0, 0xD4B0, 0xD491, 0xD4B0, 0xD4B0, 0xDC90, 0xD48F, 0xD4AF, 0xDC8F, 0xD44E, 0xCC4E, 0xCC2F, 0xD42E, 0xDC2C, 0xB3AD, 0xBBAC, 0xBBAB, 0xABAB, 0xA328, 0x9348, 0x8B68, 0x8B48, 0x9B08, 0xAB4A, 0xB3AB, 0xB3EC, 0xB42D, 0xBBEC, 0xB3CB, 
        0xB40C, 0xCC4D, 0xB42C, 0xAC2B, 0xB48D, 0xCD92, 0xE5D4, 0xDDB3, 0xC551, 0xB4EE, 0xBCCF, 0xB4D0, 0xACD0, 0x93AB, 0x7B27, 0x62E5, 0x5AC5, 0x5AC7, 0x5AC6, 0x52A6, 0x5287, 0x9B0C, 0xA34D, 0x9B2E, 0x930E, 0xA2C9, 0x9BEE, 0xAD56, 0xDE5C, 0xF2F5, 
        0xE952, 0xE8F1, 0xF971, 0xF193, 0xF9F6, 0xF9D6, 0xF175, 0xFA39, 0xF997, 0xF176, 0xE9B3, 0xD0EB, 0xC089, 0xB047, 0xA803, 0xD028, 0xE8AC, 0xD92F, 0x998E, 0x5084, 0xB22F, 0xCA34, 0x98CF, 0xDC19, 0xEE3C, 0xC517, 0x796C, 0xB2CC, 0xE451, 0xF4D3, 
        0xE4B2, 0xED74, 0xED74, 0xF575, 0xF596, 0xF595, 0xED74, 0xED94, 0xF5D6, 0xF5D5, 0xFD95, 0xF575, 0xED54, 0xED55, 0xED75, 0xF595, 0xF5B5, 0xF593, 0xED72, 0xED52, 0xE531, 0xDD11, 0xDCD0, 0xD4AF, 0xD4CF, 0xC48F, 0xCC6E, 0xC44D, 0xC44E, 0xC44E, 
        0xBC4C, 0xBC0C, 0xBBAD, 0xB3AB, 0xB38B, 0xB36C, 0xB36C, 0xA30C, 0xA30A, 0x9AC9, 0x9288, 0x7A68, 0x69E7, 0x6987, 0x6988, 0x71C9, 0x7A27, 0x7A46, 0x7208, 0x5164, 0x4103, 0x30C2, 0x2082, 0x2082, 0x2864, 0x3085, 0x40E9, 0x7330, 0x8372, 0x8312, 
        0x6A90, 0x5A0E, 0x6A72, 0x6A71, 0x5229, 0x2941, 0x39A4, 0x5226, 0x5A27, 0x49AB, 0x496B, 0x494C, 0x410C, 0x41AA, 0x628C, 0x7B4D, 0x7B6C, 0x5A69, 0x6B0B, 0xA48F, 0xF655, 0xFFDE, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFBE, 0xFF9B, 0xF75B, 0xF73B, 0xFF3B, 0xF719, 0xF6F9, 0xF6FA, 0xF6FA, 0xF739, 0xFF7B, 0xFF7B, 0xF719, 0xB50E, 0x83A9, 0x5285, 0x29C2, 0x4A07, 0x3944, 0x51C5, 
        0x8BAC, 0xA3EC, 0x93AB, 0x93CC, 0x9C4E, 0xA42D, 0x93AC, 0x938C, 0x9BED, 0xC573, 0xB4B1, 0xAC2F, 0xA42E, 0xAC2D, 0xB44F, 0xAC6F, 0xAC70, 0xCCD3, 0xCCF3, 0xB470, 0x8B6C, 0x6B03, 0x83C3, 0x8C46, 0x7448, 0x8304, 0x9BC4, 0xB489, 0xBCF1, 0xC54F, 
        0xACAC, 0xACEC, 0xCDD0, 0xDDB7, 0xCD17, 0xBCB6, 0xBC77, 0xC45E, 0xB41E, 0xB3FE, 0xC43F, 0xD45F, 0xCC3F, 0xC43F, 0xCC5F, 0xBC5E, 0xBC3C, 0xB3F9, 0xABF5,
  0x8A95, 0x92B6, 0x92D5, 0x92D3, 0x9AF6, 0x92D6, 0x92B6, 0x92B7, 0x92D6, 0x92D7, 0x92D7, 0x92F6, 0x9AF6, 0x9AF7, 0x9AF7, 0x92F6, 0x9B17, 0x9AD6, 0x92B6, 0x9AB6, 0x9AB8, 0x9AD8, 0x9B18, 0x9B59, 0xB3D8, 0xB3F6, 0xC454, 0xCCD3, 0xB3F1, 0xB3D2, 0xB3B2, 
        0xA371, 0x9B4E, 0xABCF, 0xB430, 0xB431, 0xE4AF, 0xDC91, 0xD4B1, 0xD4B1, 0xD4B0, 0xDCB0, 0xE4D1, 0xE4D2, 0xDCAF, 0xD48F, 0xD46F, 0xD42E, 0xCC6E, 0xCC4F, 0xD470, 0xDCF1, 0xE4F2, 0xDCF1, 0xDD11, 0xE512, 0xCCB1, 0xD4B1, 0xD4B1, 0xD490, 0xD4D1, 
        0xD4B1, 0xDCB1, 0xDC91, 0xD491, 0xDCB0, 0xDCB0, 0xDC91, 0xDCAE, 0xDCAF, 0xDC8F, 0xDC70, 0xCC4F, 0xD44F, 0xD42F, 0xCC0F, 0xC40D, 0xBBCD, 0xBBCD, 0xB3EC, 0x8348, 0x8B49, 0x9369, 0x9B49, 0xA32A, 0xAB4C, 0xAB8C, 0xB3CC, 0xB42C, 0xB42C, 0xBC4D, 
        0xC46F, 0xC42C, 0xB3EC, 0xABCC, 0xAC0D, 0xD573, 0xEDF4, 0xF614, 0xE5B3, 0xB48F, 0xB48F, 0xB4AF, 0xB4AF, 0x944D, 0x7B48, 0x6AA5, 0x6AA4, 0x5B04, 0x6306, 0x62A6, 0x6A65, 0x936C, 0x9BCD, 0xABEE, 0xB3EF, 0x8B29, 0xB34C, 0xE4B2, 0xEE58, 0xAA2F, 
        0xD233, 0xFA13, 0xF930, 0xFA56, 0xFA96, 0xFA36, 0xF997, 0xFAB7, 0xF1F6, 0xF197, 0xFA19, 0xE8EC, 0xD0AC, 0xB8AC, 0xB0CA, 0xB828, 0xC02A, 0xB0CA, 0x9969, 0xA051, 0xB116, 0xB134, 0xA0EE, 0x42D9, 0xADFD, 0xF77F, 0xEE9C, 0x91A8, 0xCB2C, 0xECB1, 
        0xE4F2, 0xF4B2, 0xECD3, 0xED14, 0xFD75, 0xF594, 0xF555, 0xF575, 0xFDD4, 0xFDB6, 0xFDD6, 0xF5B6, 0xED75, 0xFD95, 0xFD95, 0xFDB4, 0xFDD3, 0xF574, 0xF573, 0xED71, 0xE551, 0xECD2, 0xDCD0, 0xD4D0, 0xDC8F, 0xD44F, 0xCC4F, 0xCC4E, 0xC44D, 0xB3ED, 
        0xBBCD, 0xBBCD, 0xB3CD, 0xBB8B, 0xB38C, 0xA38C, 0x9B6C, 0x9B2C, 0x92ED, 0x8ACB, 0x82A7, 0x6965, 0x7186, 0x79C7, 0x79C9, 0x79C7, 0x7A27, 0x61C5, 0x30A1, 0x1820, 0x2020, 0x2042, 0x2886, 0x596B, 0x726E, 0x7B12, 0x8B76, 0x8B74, 0x6AB2, 0x6250, 
        0x624E, 0x6A70, 0x6A92, 0x5A2E, 0x4987, 0x4262, 0x5A68, 0x624B, 0x5A0B, 0x496E, 0x51CE, 0x59CD, 0x59AC, 0x624F, 0x5A4C, 0x62AA, 0x7B4A, 0x734C, 0x396A, 0x418C, 0x9BD4, 0xF77E, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFFE, 0xFF9E, 0xFF7D, 0xFF7C, 0xFF1B, 0xFF1B, 0xFEFA, 0xFEFA, 0xFF5B, 0xFF7A, 0xFF7A, 0xFF38, 0xD5F4, 0x942D, 0x5A86, 0x3182, 0x62E9, 0x4245, 0x39C2, 
        0x5243, 0xB4F0, 0xC572, 0xB4EF, 0x93EC, 0xA491, 0xA451, 0x9BEE, 0x8B8C, 0xA450, 0xBCD0, 0xB48F, 0x9BCE, 0xB450, 0xBC70, 0xB470, 0xA470, 0xBCB0, 0xDD35, 0xBC10, 0x6A05, 0xB64E, 0x8CA7, 0x7C05, 0x9D0A, 0x6B46, 0x7B44, 0x8BA6, 0xA42D, 0xC573, 
        0xBCF1, 0xB4AF, 0xB4D1, 0xDD94, 0xD534, 0xCD18, 0xCCFD, 0xABD4, 0xD4DA, 0xDCFE, 0xBC5C, 0xC414, 0xC496, 0xAC75, 0x83F0, 0xA52F, 0x944C, 0x83A9, 0x8387,
  0x92D6, 0x92B5, 0x92D5, 0x9AF5, 0x8AD4, 0x92D5, 0x92D5, 0x9AB6, 0x92D7, 0x92B6, 0x9AB6, 0x92B6, 0x92F7, 0x92D6, 0x92B6, 0x92D6, 0x9AD7, 0x9B17, 0xA338, 0xAB5A, 0x9316, 0x9B16, 0xA337, 0xB398, 0xBBD5, 0xC434, 0xC452, 0xC411, 0xB390, 0xAB71, 0xAB70, 
        0xA36E, 0x9B4D, 0xABAD, 0xB3EE, 0xBC30, 0xDCB2, 0xDCD2, 0xD4D1, 0xD4F2, 0xE4B1, 0xDCF1, 0xD4F2, 0xDCD2, 0xDC8E, 0xD46E, 0xD46E, 0xCC6E, 0xCC2D, 0xCC6E, 0xCC90, 0xD471, 0xD4D1, 0xDCF2, 0xDCF2, 0xD4F1, 0xDCF2, 0xDCD1, 0xD4B1, 0xD4B1, 0xD491, 
        0xD4B1, 0xD4B1, 0xDCD1, 0xDCD0, 0xDCD1, 0xDCB1, 0xDCB1, 0xE492, 0xDC91, 0xD490, 0xD46F, 0xC46E, 0xC44E, 0xC40E, 0xC3CD, 0xBBAD, 0xBBAC, 0xAB8B, 0x9B6A, 0x8B47, 0x8367, 0x8B68, 0x9329, 0xA2E9, 0xA329, 0x9B29, 0x9B29, 0x9AE8, 0x9AC8, 0x92A7, 
        0x9287, 0x92C8, 0x92A7, 0x9AC7, 0x9B8A, 0xC54D, 0xD572, 0xDD93, 0xE5D2, 0xC570, 0xC52F, 0xBCEF, 0xBC8F, 0xA42C, 0x9BAA, 0x8369, 0x6B27, 0x5A88, 0x41E4, 0x3182, 0x3162, 0x41A2, 0x6286, 0x72E9, 0x7ACA, 0x92AF, 0xA391, 0xC537, 0xF65C, 0xF0F1, 
        0xF0D1, 0xF153, 0xF9B4, 0xF153, 0xF154, 0xF1B6, 0xF218, 0xF116, 0xF998, 0xF974, 0xF08C, 0xE0AD, 0xD8ED, 0xC8AB, 0xB829, 0xB0E8, 0xB067, 0xB006, 0xA826, 0xB086, 0xA044, 0x9843, 0x9862, 0x7002, 0x7001, 0x8004, 0x9849, 0xBAAB, 0xCB6D, 0xD36D, 
        0xDB4D, 0xCCB3, 0xDCF3, 0xE4B2, 0xDC91, 0xF515, 0xF555, 0xF554, 0xF555, 0xF575, 0xF595, 0xF575, 0xF555, 0xED75, 0xED75, 0xF575, 0xF595, 0xF593, 0xF572, 0xED32, 0xE4F2, 0xDCD2, 0xD4B0, 0xCC6F, 0xCC4E, 0xD46E, 0xCC4E, 0xC42D, 0xB40E, 0xBBAD, 
        0xB38C, 0xAB6B, 0xAB6A, 0xA36A, 0x9B09, 0x9AEA, 0xA2EB, 0x9289, 0x8245, 0x7A04, 0x71C4, 0x69A4, 0x71C5, 0x69A6, 0x6165, 0x40E1, 0x2041, 0x1801, 0x2822, 0x4148, 0x498A, 0x59EC, 0x7A6F, 0x8374, 0x7B13, 0x72B2, 0x6A90, 0x5A0F, 0x5A0F, 0x5A2E, 
        0x5A2E, 0x5A2F, 0x5A4D, 0x524A, 0x5228, 0x624A, 0x520C, 0x51ED, 0x59CD, 0x49AC, 0x51CD, 0x51EC, 0x4A09, 0x498A, 0x72EE, 0x7B71, 0x5AAE, 0x18A3, 0x7268, 0xB46E, 0xC5F3, 0xF7BE, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFDE, 0xFF9E, 0xF79C, 0xF75C, 0xFF3C, 0xFF1C, 0xF6D9, 0xF6F9, 0xF6FA, 0xF71A, 0xFF5B, 0xF71A, 0xE698, 0xD5F5, 0xCDD2, 0x83EB, 0x4A66, 0x39E3, 0x52A5, 0x4243, 0x39C2, 
        0x59C5, 0xA40B, 0x836A, 0x8BEC, 0xB551, 0xA44F, 0xA44F, 0x9BCD, 0x8B0B, 0xA42D, 0xB4D2, 0xBD12, 0xB4EF, 0xAC2D, 0xB450, 0xB471, 0xB450, 0xB4F1, 0xCDF5, 0xA4AF, 0x4182, 0x8881, 0xAB47, 0x9CEA, 0x7CA7, 0x5BA2, 0x8449, 0xACED, 0xC56C, 0xE5AE, 
        0xCD6F, 0xC58F, 0xCDEE, 0x9D06, 0xCD91, 0xD535, 0xBC11, 0xEE7C, 0xB4F6, 0xB4D6, 0xE63D, 0x93B8, 0x736D, 0x9CAB, 0xD612, 0x5266, 0x4A03, 0x8C08, 0xEF73,
  0x92B5, 0x8AB5, 0x8AB5, 0x92D6, 0x92B5, 0x92D6, 0x92D6, 0x92D6, 0x92B7, 0x9AB7, 0x9AD6, 0x92D6, 0x92D6, 0x92D7, 0x92D6, 0x92B6, 0xA338, 0xA337, 0xA356, 0xA376, 0xB377, 0xAB76, 0xA356, 0xA337, 0xBBB5, 0xBBF3, 0xBC12, 0xBC10, 0xAB6E, 0xA34E, 0xA34D, 
        0xA32D, 0x9B4D, 0xA38D, 0xB3EE, 0xC450, 0xDCD2, 0xDCD2, 0xD4D1, 0xD4D1, 0xE4D1, 0xDCD1, 0xDCD2, 0xDCD2, 0xD48D, 0xD46E, 0xD44F, 0xD42E, 0xCC6E, 0xD44F, 0xD46F, 0xD4B0, 0xDCD2, 0xDCF1, 0xDCF1, 0xDCF1, 0xDCF1, 0xDCF1, 0xDCD1, 0xDCB1, 0xDCD1, 
        0xDCB1, 0xDCB1, 0xDCD2, 0xDCD1, 0xDCD1, 0xE4D2, 0xE4F2, 0xDCD1, 0xDCB0, 0xD48F, 0xCC6F, 0xCC4E, 0xCC2E, 0xCC0E, 0xC3CE, 0xBBAD, 0xBBAC, 0xB38A, 0xAB49, 0x9369, 0x8B49, 0x9328, 0xA308, 0xAAE9, 0xA2CA, 0xA2EA, 0xA309, 0x9AC9, 0x9AE8, 0xA2E8, 
        0xA2E9, 0x9B08, 0x9AC8, 0x92A8, 0x9B07, 0xA40B, 0xBCCD, 0xCD2F, 0xDD52, 0xC532, 0xBD32, 0xBD11, 0xBCCF, 0xA42D, 0x93AB, 0x8327, 0x6AA2, 0x4222, 0x31A2, 0x2941, 0x3100, 0x49C1, 0x5A44, 0x6AC7, 0x8B0A, 0x8B0E, 0xA3D3, 0xB519, 0xCDDC, 0xF112, 
        0xF8F2, 0xF193, 0xF1F3, 0xF994, 0xF9B5, 0xF9B6, 0xF9B7, 0xF9D8, 0xF9F9, 0xF9D7, 0xF153, 0xD02D, 0xC02B, 0xB049, 0xA888, 0xB049, 0xB06A, 0xB069, 0xB046, 0xA867, 0xB068, 0xB068, 0xB048, 0xB026, 0xB048, 0x9026, 0x5802, 0x9068, 0xC26D, 0xDB6E, 
        0xDB6E, 0xD3ED, 0xDC31, 0xDC52, 0xDC92, 0xED33, 0xED14, 0xED35, 0xF555, 0xF553, 0xF575, 0xF576, 0xF576, 0xF594, 0xF595, 0xF576, 0xED56, 0xF574, 0xED53, 0xE512, 0xE4F1, 0xDC90, 0xD46F, 0xD44E, 0xD44E, 0xD42E, 0xC3EE, 0xBBCD, 0xC3AB, 0xAB6C, 
        0xAB4C, 0xAB4B, 0xAB4A, 0xAAEA, 0xA2CA, 0x9ACA, 0x9AAA, 0x8A09, 0x7A06, 0x69C4, 0x5965, 0x5966, 0x48C4, 0x3842, 0x3021, 0x3884, 0x40E8, 0x494A, 0x51CB, 0x728E, 0x6AD0, 0x72D1, 0x72D2, 0x6250, 0x5A2E, 0x5A6E, 0x628F, 0x6A2F, 0x6A6F, 0x626F, 
        0x5A0F, 0x5A6E, 0x628E, 0x626D, 0x5A6B, 0x5A49, 0x59EC, 0x51CD, 0x51EC, 0x498C, 0x49AC, 0x49CC, 0x49CC, 0x51C9, 0x624D, 0x6AAF, 0x628F, 0x3927, 0x3905, 0x628C, 0xB538, 0xF7BE, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFDF, 0xF79E, 0xF77D, 0xF75B, 0xEF3A, 0xF6F9, 0xF6F9, 0xF6D9, 0xF6D9, 0xFF39, 0xF6D9, 0xE656, 0xD614, 0xEEB8, 0x83AC, 0x4A03, 0x4A42, 0x52C6, 0x52A6, 0x39E4, 
        0x2102, 0x83AD, 0xACAF, 0xACAD, 0x93EA, 0xACB0, 0xB4F2, 0xB4F2, 0xA46F, 0x934A, 0xA42E, 0xBCB1, 0xBC90, 0xAC6E, 0xAC6F, 0xB46F, 0xB470, 0xAC71, 0xD5D4, 0xB511, 0x69E8, 0xB14D, 0xAA2A, 0xB3AA, 0xD56F, 0x9449, 0x9C88, 0xAD0A, 0xBD4D, 0xAC6C, 
        0xCD0E, 0xDD50, 0xCD12, 0xE63B, 0x6C2C, 0x4283, 0x8268, 0xEEFC, 0xF61B, 0xC495, 0x734D, 0x8B4F, 0x9BEA, 0xA428, 0x93E9, 0x6A63, 0x8BE8, 0xAD6C, 0xD62E,
  0x92D6, 0x92B6, 0x92D6, 0x92F6, 0x92D6, 0x92D6, 0x92D6, 0x92D6, 0x92B6, 0x92D6, 0x92D6, 0x9AD6, 0x9B17, 0x9B17, 0x9AF7, 0x92B8, 0x9B36, 0xA376, 0xAB95, 0xAB94, 0xB395, 0xB3D5, 0xB3D5, 0xBBB6, 0xB3D4, 0xBBD2, 0xBBB0, 0xB3AD, 0xA36E, 0xA34F, 0xA36E, 
        0x9B8D, 0xABAE, 0xAB8E, 0xABCF, 0xB432, 0xE451, 0xE4B1, 0xE4F2, 0xDCF2, 0xDCD1, 0xE4F1, 0xE4F2, 0xECD2, 0xE48F, 0xD48F, 0xD46F, 0xD44F, 0xD46F, 0xD46F, 0xD490, 0xD4B2, 0xECF0, 0xECF2, 0xE4F2, 0xE4F1, 0xE512, 0xE4F1, 0xDCD1, 0xDCD1, 0xDCB1, 
        0xE4F2, 0xE4F2, 0xE4F1, 0xECD2, 0xECD2, 0xECF2, 0xECF1, 0xE491, 0xDCB0, 0xDC90, 0xE431, 0xCC8E, 0xD44F, 0xCC2F, 0xC40E, 0xC3CD, 0xBBAD, 0xB3AC, 0xA3AC, 0x8B48, 0x9369, 0x9349, 0x9B2A, 0xAB4B, 0xA2EB, 0x9ACA, 0x9AE9, 0x9AC8, 0x9AC9, 0x9AC9, 
        0xA309, 0xAAEA, 0xA2E9, 0x9AE8, 0xA2E9, 0xB3CB, 0xC48E, 0xD510, 0xDD50, 0xDD31, 0xDD31, 0xD531, 0xC511, 0xBC8E, 0xAC0C, 0x93AB, 0x7B2A, 0x5266, 0x39A3, 0x2900, 0x20E1, 0x3967, 0x620B, 0x7A8E, 0x8291, 0x9AB6, 0x93B6, 0xB438, 0xF3DB, 0xF912, 
        0xF112, 0xF953, 0xF9B4, 0xF9B5, 0xF9D7, 0xF9D7, 0xF9D7, 0xF9B9, 0xF9B8, 0xF9F8, 0xFA38, 0xF1D4, 0xE8EF, 0xD86A, 0xC828, 0xA806, 0x9803, 0xA003, 0xA807, 0x9008, 0x9005, 0x9005, 0xA028, 0xB028, 0xA026, 0xB0AA, 0xD172, 0x8063, 0x9169, 0xBACD, 
        0xD3CD, 0xC34E, 0xC36F, 0xC3D0, 0xC452, 0xEC72, 0xEC92, 0xE4B2, 0xDCD1, 0xF4F3, 0xF534, 0xFD55, 0xFD56, 0xFDB5, 0xFD95, 0xFD75, 0xF555, 0xF532, 0xED11, 0xE4F0, 0xE4F1, 0xD46E, 0xDC6F, 0xD46F, 0xC44D, 0xC44E, 0xC40D, 0xBBCD, 0xAB8D, 0xAB4C, 
        0xAB2B, 0xAB0B, 0xAAEC, 0xA2A8, 0xA2CA, 0xA2AA, 0x9228, 0x6966, 0x6924, 0x60E3, 0x50C4, 0x2864, 0x3023, 0x4064, 0x5928, 0x720D, 0x7A50, 0x7A71, 0x7290, 0x5A6D, 0x628E, 0x628F, 0x624F, 0x6A0E, 0x6A6F, 0x6270, 0x624F, 0x626F, 0x6A6F, 0x6A4F, 
        0x626F, 0x626F, 0x6A70, 0x6A6F, 0x6A6D, 0x622C, 0x59CD, 0x598D, 0x59AC, 0x498D, 0x51AC, 0x51CC, 0x59CD, 0x59AC, 0x622D, 0x6A8E, 0x72CF, 0x7AF0, 0x6A4D, 0x6187, 0x6942, 0x8B8D, 0xCE58, 0xF7DE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFBE, 0xFF9D, 0xFF5B, 0xFF3C, 0xFF1B, 0xFEFB, 0xFF1B, 0xFF5C, 0xF718, 0xE675, 0xE5F4, 0xF75B, 0xC614, 0x736A, 0x18A2, 0x5A65, 0x4285, 0x3224, 
        0x3983, 0x4942, 0x8B67, 0xC4ED, 0xDD71, 0xACB1, 0xB513, 0xC554, 0xCD55, 0xAC90, 0x9BEE, 0x9C0F, 0xB490, 0xBCB2, 0xB470, 0xAC4F, 0xAC4F, 0xAC92, 0xD658, 0xB514, 0x5927, 0x912B, 0xA2EB, 0x8308, 0x5243, 0x9D47, 0x94C5, 0x9C49, 0xB472, 0xBD13, 
        0xDDF9, 0xC455, 0x7968, 0x7EA9, 0xAEAE, 0x9C0D, 0x5886, 0x5083, 0x71A8, 0xAC0F, 0xE6B5, 0x8BEE, 0xA4AF, 0xAD2E, 0x8CCA, 0x42C3, 0xAD90, 0xBDF1, 0x6B67,
  0x92D6, 0x92D6, 0x92D5, 0x92B5, 0x92B6, 0x92D6, 0x9AB7, 0x9AB7, 0x92D6, 0x92D6, 0x92D6, 0x92F6, 0x92D7, 0x92F7, 0x92D7, 0x92D7, 0xA338, 0xAB58, 0xB376, 0xBB95, 0xBBF5, 0xC3F3, 0xC3F3, 0xBC15, 0xBBB2, 0xBB91, 0xB36F, 0xA38D, 0xB38D, 0xB3AE, 0xABAE, 
        0xA36E, 0xB38D, 0xB40E, 0xBC70, 0xC492, 0xDCD3, 0xDCF3, 0xDCF2, 0xE4D0, 0xECD2, 0xE4D1, 0xDCD1, 0xDCB1, 0xDCAE, 0xD48E, 0xCC6D, 0xCC6D, 0xCC8E, 0xD4AE, 0xD4AE, 0xD4B0, 0xDCF2, 0xE4F2, 0xE512, 0xE512, 0xE4F1, 0xE4F1, 0xE4F1, 0xE512, 0xE4F2, 
        0xECF2, 0xECF2, 0xE513, 0xED13, 0xED12, 0xE4F1, 0xE4D2, 0xDCD1, 0xDC91, 0xDC90, 0xD4AF, 0xCC4E, 0xCC2E, 0xCC0E, 0xC3CE, 0xBBAE, 0xC38D, 0xBB8B, 0xAB8A, 0x9349, 0x9349, 0x9B49, 0xAB29, 0xAAEA, 0xA2EA, 0xAAEA, 0xAAE9, 0xA2C9, 0xA2E8, 0xA2E9, 
        0xAB0A, 0xA309, 0xA2C9, 0x9AA8, 0x8285, 0x7A86, 0x9308, 0xABCB, 0xC48E, 0xD4F1, 0xC4F2, 0xBD12, 0xBD10, 0xAB8E, 0x9B4C, 0x7AC8, 0x51E2, 0x3940, 0x20E0, 0x18A0, 0x18C0, 0x3941, 0x51C5, 0x6A6A, 0x8AF1, 0xA354, 0xAC99, 0xBC79, 0xD2F4, 0xF134, 
        0xF954, 0xF173, 0xF172, 0xF9D5, 0xF9D6, 0xF9B7, 0xF999, 0xF998, 0xF9B7, 0xF9F9, 0xFA1B, 0xF9B9, 0xF1B4, 0xE971, 0xE0CF, 0xD86D, 0xD8AD, 0xD8AC, 0xD0A9, 0xC8A8, 0xC089, 0xC88A, 0xD8CC, 0xC8CB, 0xC0AB, 0xB06A, 0xA807, 0x9027, 0xA0E9, 0xB9CB, 
        0xCAAC, 0xB2AC, 0xBB2D, 0xCB8D, 0xC3AD, 0xBBCF, 0xC40F, 0xCC30, 0xDC51, 0xE4B2, 0xE4F2, 0xECF3, 0xF515, 0xF575, 0xED54, 0xED33, 0xF554, 0xECF3, 0xF4D3, 0xEC92, 0xDC30, 0xCC4E, 0xCBED, 0xC40D, 0xC470, 0xBBAF, 0xBB8D, 0xB36C, 0xB32B, 0xA2C9, 
        0xAAAA, 0xAA8A, 0x9A29, 0xA249, 0x89E7, 0x71A6, 0x6146, 0x40A5, 0x38A4, 0x30C4, 0x28C5, 0x498A, 0x518B, 0x59AC, 0x69EE, 0x61CC, 0x514A, 0x514B, 0x61CD, 0x59AC, 0x51AC, 0x59ED, 0x6270, 0x620D, 0x51ED, 0x51EE, 0x620F, 0x624E, 0x624E, 0x624E, 
        0x6A4E, 0x624F, 0x6A2F, 0x620E, 0x51EE, 0x59ED, 0x59CD, 0x51CD, 0x51CD, 0x51CC, 0x498C, 0x496B, 0x416A, 0x51AE, 0x51AC, 0x49AB, 0x49EC, 0x5A0E, 0x5A0D, 0x59ED, 0x7230, 0xB578, 0xCDD8, 0xE69A, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFBE, 0xFF9D, 0xF75B, 0xF73A, 0xF6D9, 0xF6D9, 0xF719, 0xFF3B, 0xF6D8, 0xEE56, 0xDDD4, 0xD5F3, 0xEF5C, 0x8C50, 0x39E6, 0x10E1, 0x1920, 0x3183, 0x3984, 
        0x2943, 0x31E6, 0x52C7, 0x73AA, 0x946D, 0xBD32, 0xB4F1, 0xB4F1, 0xBD53, 0xC555, 0xBD11, 0xB4B0, 0xB471, 0xACCF, 0xAC6F, 0xB44F, 0xBC6F, 0xABEF, 0xD615, 0xB571, 0x6206, 0xB072, 0xC9B3, 0xD272, 0xC24F, 0x928B, 0xAC2D, 0x93E9, 0x6A23, 0xE5D2, 
        0xE5B0, 0xB3CB, 0x8968, 0xCADA, 0xC5B0, 0xADCA, 0x8B2C, 0x4082, 0x7167, 0x6967, 0x4104, 0xDEB6, 0xBCF0, 0x82E8, 0x6AA5, 0xE714, 0xB5AB, 0x7BC7, 0x6249,
  0x92B6, 0x92D6, 0x92D6, 0x92D6, 0x92D6, 0x92D6, 0x92D6, 0x9AD6, 0x9AB6, 0x92D6, 0x92D6, 0x92D6, 0x92F6, 0x9AF6, 0x9AF7, 0x9AD8, 0x92B6, 0xA337, 0xAB97, 0xABB7, 0xBB97, 0xBBF5, 0xBC13, 0xC413, 0xBBB3, 0xB370, 0xAB2D, 0xAB4C, 0xB3AE, 0xB3CF, 0xBC10, 
        0xBC51, 0xB411, 0xBC30, 0xBC0F, 0xBC0F, 0xDCB3, 0xE4F3, 0xDCF3, 0xDCF2, 0xE4F2, 0xDCD0, 0xDCAF, 0xDCCE, 0xDC8E, 0xCC6E, 0xCC6D, 0xCC6D, 0xD46D, 0xD46E, 0xCC6E, 0xC4AE, 0xE4D0, 0xDCD1, 0xDCF1, 0xE512, 0xE532, 0xE532, 0xE512, 0xE512, 0xF533, 
        0xED13, 0xED13, 0xECF2, 0xE4F2, 0xE513, 0xE4F3, 0xE4B2, 0xE4D1, 0xE4B2, 0xDC91, 0xD44F, 0xD44E, 0xCC2E, 0xC42E, 0xCBEE, 0xC3AE, 0xBB8D, 0xBB6C, 0xBB8B, 0x8B28, 0x9B49, 0xA34A, 0xAB0A, 0xAB0A, 0xAAEA, 0xAAEA, 0xAB0A, 0xA309, 0xA2E9, 0xAAE9, 
        0xAAE9, 0x9AE9, 0x92C9, 0x9AA8, 0x9A65, 0x71C4, 0x8245, 0x92C8, 0xAB6B, 0xD48F, 0xCC90, 0xC44E, 0xC40C, 0x9B48, 0x7AA7, 0x5A25, 0x4183, 0x30E4, 0x28C3, 0x18A2, 0x18A2, 0x4948, 0x51EB, 0x6A8F, 0x9315, 0x9B5B, 0xBC7D, 0xDBFC, 0xFA16, 0xF933, 
        0xF952, 0xF192, 0xF1B2, 0xF974, 0xF996, 0xF9B7, 0xF9B7, 0xF9B8, 0xF9B8, 0xF9B8, 0xF9F8, 0xF9D7, 0xFA38, 0xFA57, 0xF9F4, 0xF132, 0xF130, 0xF14F, 0xF170, 0xF911, 0xF170, 0xF1B1, 0xE971, 0xD08B, 0xC04A, 0xB04A, 0xA848, 0xA02A, 0x9869, 0xA0E9, 
        0xA98A, 0xCAAB, 0xBB0C, 0xB32D, 0xBB2D, 0xB32B, 0xBB8C, 0xC3CD, 0xCC0E, 0xDC10, 0xDC50, 0xE492, 0xECF3, 0xF514, 0xED33, 0xE512, 0xE4D3, 0xE4F3, 0xE4B2, 0xDC51, 0xD3EF, 0xD3ED, 0xCBCB, 0xCBCC, 0xCBCE, 0xBB8B, 0xB36B, 0xAB2B, 0xA2CB, 0x9289, 
        0x9A49, 0x9A29, 0x9208, 0x7986, 0x6124, 0x48A3, 0x3041, 0x2820, 0x2882, 0x28A4, 0x28A5, 0x3128, 0x3908, 0x4908, 0x512A, 0x516C, 0x514B, 0x516B, 0x51AC, 0x496B, 0x51AB, 0x51AC, 0x518C, 0x5A0C, 0x59EC, 0x59CD, 0x61CE, 0x51CD, 0x520D, 0x5A2D, 
        0x520E, 0x624D, 0x5A2E, 0x5A2E, 0x5A2E, 0x51AE, 0x51AD, 0x51AC, 0x518C, 0x498C, 0x498C, 0x496C, 0x414B, 0x59CE, 0x496C, 0x496B, 0x59AB, 0x620E, 0x620E, 0x498A, 0x38E5, 0xA32F, 0xDDD7, 0xFF7C, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFBF, 0xFF9E, 0xF75C, 0xF71B, 0xF6D8, 0xF6D9, 0xF6FA, 0xF6FA, 0xF6B8, 0xEE35, 0xDDD4, 0xD5D6, 0xEF5B, 0x9CAF, 0x4245, 0x08E1, 0x2921, 0x2121, 0x2162, 
        0x29A4, 0x18E1, 0x1943, 0x4AA7, 0xACCD, 0xDDB6, 0xB4D2, 0xA451, 0xB4B2, 0xC554, 0xCD34, 0xBCF3, 0xA491, 0xB48F, 0xAC6E, 0xAC4E, 0xAC2E, 0xAC30, 0xD638, 0xB534, 0x6147, 0x988C, 0x98ED, 0xA94F, 0xC1F1, 0x8B47, 0x9CAA, 0xB4EC, 0xBC2A, 0x8B43, 
        0x69A2, 0x6087, 0x70AF, 0xA54D, 0xD6F0, 0xC590, 0x7A0A, 0x6843, 0x78E5, 0xAA69, 0xD40C, 0x51C4, 0x30E2, 0x6B06, 0xE72D, 0xD66A, 0xB52B, 0xC512, 0xF5FE,
  0x92B6, 0x92D6, 0x92F6, 0x9316, 0x92D6, 0x92B6, 0x92D6, 0x9AF6, 0x9AD7, 0x9AF7, 0x92F7, 0x92D6, 0x9AF6, 0x9AF7, 0x9B17, 0x92F7, 0x92B7, 0x9B16, 0xA356, 0xAB97, 0xC3F5, 0xC414, 0xC413, 0xCC32, 0xC411, 0xBBCF, 0xB36D, 0xAB2B, 0xB40E, 0xC430, 0xCC32, 
        0xDC53, 0xCC92, 0xD4B3, 0xD4B2, 0xD470, 0xDCD3, 0xE4F3, 0xE512, 0xDD12, 0xECF2, 0xECF1, 0xE4F0, 0xE4D0, 0xE4B0, 0xD48E, 0xCC4E, 0xCC2E, 0xD44E, 0xD46E, 0xD46F, 0xD46F, 0xDCD0, 0xE4D1, 0xE4F1, 0xE511, 0xED32, 0xED12, 0xED12, 0xF532, 0xF4F3, 
        0xF513, 0xED33, 0xF512, 0xF533, 0xED13, 0xED12, 0xECF1, 0xE4D2, 0xE4B1, 0xE490, 0xDC70, 0xDC90, 0xD44F, 0xD42F, 0xDBEE, 0xBC0E, 0xBBCD, 0xBBAD, 0xABAD, 0x9B68, 0xA369, 0xAB4B, 0xAB2B, 0xAB2B, 0xB32B, 0xB32A, 0xAB2A, 0xA2E9, 0xA2E9, 0xAAEA, 
        0xAB0A, 0xAB09, 0xA2C9, 0x9AC9, 0x92C8, 0x7224, 0x7244, 0x82C6, 0x9B88, 0xBC4B, 0xC46F, 0xCCB2, 0xCCB2, 0x9B8A, 0x8B28, 0x7A85, 0x5981, 0x18E1, 0x20C1, 0x20A1, 0x1882, 0x3989, 0x59EC, 0x7A70, 0x9B54, 0xB3DE, 0xB4BF, 0xCC1C, 0xF217, 0xF913, 
        0xF932, 0xF972, 0xF9B3, 0xF154, 0xF996, 0xF9D7, 0xF9D7, 0xF9FB, 0xF9DA, 0xF9B8, 0xF9B7, 0xFA19, 0xF9FB, 0xFA1C, 0xFA7C, 0xFA36, 0xF9D5, 0xF9B4, 0xF972, 0xF912, 0xF932, 0xF952, 0xF953, 0xF12F, 0xD8EE, 0xD0AD, 0xD06B, 0x9829, 0x9007, 0x9867, 
        0xA109, 0xB1EC, 0xBA6C, 0xC2AC, 0xC28D, 0xB2CC, 0xBAEC, 0xBB0D, 0xC30D, 0xCB2C, 0xC38D, 0xD3EF, 0xEC52, 0xECF2, 0xE4D1, 0xE4B1, 0xDCB1, 0xDC30, 0xDBEF, 0xD3EF, 0xD3EF, 0xBB4C, 0xBB6D, 0xC38D, 0xBB8B, 0xBB6B, 0xAB2A, 0xA2E8, 0x9286, 0x89A7, 
        0x89C7, 0x81C6, 0x7166, 0x58A3, 0x4841, 0x4020, 0x3000, 0x1820, 0x1041, 0x0842, 0x1023, 0x1863, 0x2885, 0x30A6, 0x38E7, 0x3909, 0x3928, 0x4149, 0x518B, 0x59AC, 0x516C, 0x596C, 0x59CC, 0x494B, 0x518B, 0x59AC, 0x59AE, 0x598C, 0x59CC, 0x59ED, 
        0x51ED, 0x61AE, 0x624E, 0x624E, 0x61CE, 0x598D, 0x518C, 0x518C, 0x496B, 0x494B, 0x496B, 0x496B, 0x516C, 0x498D, 0x514B, 0x512B, 0x518D, 0x626F, 0x626F, 0x626F, 0x5A6D, 0x4909, 0x6A2B, 0xA452, 0xF6DB, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFBF, 0xFFBE, 0xF79D, 0xF71A, 0xFEDA, 0xFEFA, 0xF73B, 0xFEF9, 0xF696, 0xEE55, 0xE635, 0xEEBA, 0xD634, 0x9CCC, 0x52E4, 0x1080, 0x20A1, 0x28E2, 
        0x2902, 0x3983, 0x2101, 0x10A0, 0x2902, 0xACB0, 0xE616, 0xDDF6, 0xACD1, 0xB4D2, 0xB512, 0xB4F2, 0xB4D1, 0xB4B2, 0xAC50, 0xAC4F, 0xBCB1, 0xB492, 0xDE57, 0xB552, 0x5184, 0xA82E, 0xA8B1, 0xA8F1, 0xB0D1, 0xC174, 0xB1F2, 0xB36E, 0xBDAB, 0xA3CD, 
        0x5185, 0x3863, 0x6066, 0x8184, 0xB30B, 0xD532, 0xCED4, 0x28E3, 0x5004, 0x4804, 0x1001, 0x40A6, 0xA4F3, 0xE755, 0xEF2B, 0x9CC8, 0x5204, 0x724C, 0xED3D,
  0x92D6, 0x92D6, 0x92D6, 0x9296, 0x92D7, 0x9AD6, 0x9AD6, 0x92D6, 0x92F7, 0x92F6, 0x9AD7, 0x9AF7, 0x9AF7, 0x9AF7, 0x9AF7, 0x9AF7, 0x9AF8, 0x92B7, 0x9AD7, 0xA357, 0xB3F6, 0xBC15, 0xC434, 0xCC14, 0xC3D0, 0xB38E, 0xB36C, 0xB38B, 0xC42E, 0xD492, 0xDCD4, 
        0xED55, 0xED76, 0xED96, 0xE595, 0xE575, 0xDCB3, 0xDCD2, 0xDCF2, 0xE4F1, 0xE4D1, 0xECD1, 0xE4D0, 0xDCAF, 0xDC8E, 0xD44E, 0xCC0D, 0xC40B, 0xCC2D, 0xD44D, 0xD44E, 0xCC4E, 0xDC6F, 0xD490, 0xDCB1, 0xE4D2, 0xED11, 0xED32, 0xED33, 0xED13, 0xF553, 
        0xED32, 0xED12, 0xF513, 0xFD12, 0xF4F3, 0xECF3, 0xECF2, 0xE4D1, 0xE491, 0xDC71, 0xD46F, 0xD46F, 0xD44F, 0xCC0E, 0xCBCE, 0xC3EE, 0xBBAE, 0xB38D, 0xA38C, 0xAB6A, 0xA36B, 0xA34C, 0xAB0B, 0xAB0B, 0xAB0A, 0xAAEA, 0xAAEA, 0xAB2A, 0xAB2A, 0xAB0A, 
        0xAB0A, 0xAAE8, 0xA2E9, 0x9AC8, 0x9A65, 0x71E4, 0x71E4, 0x8224, 0x9287, 0xB36D, 0xBBCD, 0xC3CB, 0xBBA7, 0x8AA7, 0x6A05, 0x4963, 0x20C2, 0x20A4, 0x2083, 0x2083, 0x20C3, 0x59C5, 0x724B, 0x8AB1, 0xAB56, 0xB49E, 0xD43F, 0xEADB, 0xF915, 0xF954, 
        0xF193, 0xF993, 0xF952, 0xF154, 0xF997, 0xF9B8, 0xF9B8, 0xF9B9, 0xF9B9, 0xF9DA, 0xFA19, 0xF195, 0xF9D6, 0xF9F7, 0xFA17, 0xFA38, 0xFA18, 0xFA18, 0xFA39, 0xFA16, 0xF1B4, 0xF193, 0xF193, 0xF973, 0xF150, 0xE94F, 0xD94F, 0xC86A, 0xA827, 0x9806, 
        0x9828, 0xB108, 0xA148, 0x99A7, 0xA248, 0xAAEC, 0xAB0B, 0xA2E9, 0xA2C9, 0xBA8C, 0xC2CB, 0xC32D, 0xC3B0, 0xDC11, 0xD42E, 0xCC4F, 0xDC72, 0xDB6E, 0xDB8D, 0xCB8D, 0xBB4C, 0xB30B, 0xBB2C, 0xBB4D, 0xC34D, 0xBB0B, 0xA228, 0x89A5, 0x7986, 0x6927, 
        0x60A4, 0x5042, 0x4821, 0x3801, 0x4022, 0x4822, 0x5823, 0x4823, 0x4063, 0x4083, 0x4064, 0x3804, 0x2003, 0x1802, 0x1002, 0x0823, 0x2063, 0x2083, 0x1064, 0x30A7, 0x30C7, 0x3109, 0x394B, 0x30E6, 0x3128, 0x4129, 0x512A, 0x494A, 0x494B, 0x516C, 
        0x51AC, 0x51AC, 0x51CD, 0x59CD, 0x51AD, 0x516C, 0x516C, 0x496B, 0x494B, 0x416B, 0x412B, 0x492A, 0x496B, 0x410C, 0x412B, 0x490A, 0x48C9, 0x5109, 0x4909, 0x4129, 0x498B, 0x698D, 0x9B30, 0xAC52, 0x9D14, 0xEF5E, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFDF, 
        0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFDF, 0xFFBE, 0xF77D, 0xFF3C, 0xFF3C, 0xF719, 0xF6F8, 0xF6F9, 0xF6D8, 0xF6D8, 0xE677, 0xDDF7, 0xF738, 0xBDAE, 0x73C8, 0x3205, 0x10A1, 0x3142, 0x4984, 
        0x4163, 0x2101, 0x2902, 0x3102, 0x3102, 0x9BAD, 0xC513, 0xD555, 0xCCD4, 0xBD13, 0xBCF2, 0xBCF3, 0xBD34, 0xB4D2, 0xA42E, 0xA42E, 0xBC70, 0xBCB1, 0xDE17, 0xB4F2, 0x5925, 0xA04A, 0x98CA, 0x90CC, 0x904E, 0x71C5, 0x7323, 0x9C29, 0xC452, 0x9BC9, 
        0x8AC9, 0x7187, 0x6063, 0xBA52, 0xA38B, 0x8C46, 0x8C68, 0xB2B0, 0xAA4E, 0xA2CE, 0xA412, 0xE597, 0xBD2B, 0xB4E8, 0xCC8B, 0x20A2, 0x5086, 0x6888, 0x4807,
  0x92D6, 0x92D5, 0x92D5, 0x92D6, 0x92B6, 0x92D6, 0x9AD6, 0x92F6, 0x92D7, 0x92D7, 0x9AD7, 0x9AD7, 0x92D7, 0x9AF7, 0x9AF7, 0x9AF7, 0xA2D7, 0x9AF8, 0x9AF8, 0xA2F7, 0xAB96, 0xBBD6, 0xBBD5, 0xBBD5, 0xC3B1, 0xC3AE, 0xBBEE, 0xBC4F, 0xDCB2, 0xDCF2, 0xDD13, 
        0xDD14, 0xD514, 0xD514, 0xD4D3, 0xC492, 0xDCD3, 0xDCD2, 0xDCF2, 0xE4F2, 0xED10, 0xE4F1, 0xECF0, 0xECCF, 0xD48F, 0xCC4D, 0xCC2D, 0xCC0D, 0xD46D, 0xDC6D, 0xD46D, 0xCC4D, 0xCC4D, 0xCC6D, 0xD46E, 0xD490, 0xE512, 0xED12, 0xED32, 0xED52, 0xED33, 
        0xED13, 0xED13, 0xED13, 0xF533, 0xED12, 0xED13, 0xECF3, 0xE4B1, 0xE492, 0xDC91, 0xDC6E, 0xCC4F, 0xCC4F, 0xD40E, 0xD3CE, 0xBBCD, 0xBBCD, 0xC3AD, 0xBB8B, 0xA34A, 0xA34A, 0xA34A, 0xAB2A, 0xB32B, 0xB30A, 0xAB0A, 0xAB2B, 0xAB09, 0xAB09, 0xAAE9, 
        0xAB09, 0xA2E8, 0xA2C9, 0x9AA8, 0x9266, 0x7A45, 0x8265, 0x92A6, 0xA2E7, 0xB389, 0xB3AA, 0xB38A, 0xAB49, 0x8A84, 0x61A1, 0x4100, 0x30A0, 0x20C1, 0x28E5, 0x2906, 0x2926, 0x59AC, 0x6A4D, 0x7AB1, 0x9357, 0xBC7E, 0xCC1E, 0xE2DB, 0xF917, 0xF994, 
        0xF1B3, 0xF172, 0xF912, 0xF9B5, 0xF9D7, 0xF9F8, 0xF9F8, 0xF178, 0xF1B8, 0xF1D9, 0xF1B8, 0xF196, 0xF218, 0xFA5A, 0xFA39, 0xF1F9, 0xF219, 0xFA39, 0xFA19, 0xF9BA, 0xF9F9, 0xF9D7, 0xF195, 0xF193, 0xF153, 0xF153, 0xE973, 0xC04B, 0xB809, 0xB008, 
        0xB027, 0xA0E6, 0x98C7, 0x98E8, 0xA169, 0xB1E8, 0xB209, 0xAA29, 0xAA68, 0xAA29, 0xB249, 0xB2A9, 0xBB4C, 0xCB6D, 0xC36D, 0xC38D, 0xCB8E, 0xCB6D, 0xC34C, 0xBB0B, 0xAAC9, 0xAACB, 0xBB4D, 0xBB6D, 0xAAEB, 0x7966, 0x7124, 0x6902, 0x60A2, 0x4822, 
        0x4802, 0x4802, 0x4002, 0x4802, 0x5043, 0x5844, 0x5804, 0x5864, 0x5884, 0x5885, 0x6086, 0x5845, 0x5066, 0x4886, 0x48A5, 0x3024, 0x3003, 0x2802, 0x2003, 0x2004, 0x1803, 0x1823, 0x2064, 0x28A5, 0x28A6, 0x28C7, 0x30E8, 0x48E9, 0x412A, 0x494B, 
        0x598A, 0x49AC, 0x51AC, 0x51AD, 0x51AD, 0x496C, 0x414B, 0x412B, 0x410B, 0x2889, 0x38EA, 0x410A, 0x40E8, 0x3129, 0x412A, 0x492A, 0x4929, 0x40E9, 0x38A8, 0x38C9, 0x390B, 0x4129, 0x596A, 0x8AAE, 0xC4D6, 0xF77E, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFDF, 
        0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xFFBF, 0xFF9E, 0xFF7D, 0xF75C, 0xF697, 0xF6B7, 0xF6F9, 0xF73B, 0xF6F9, 0xEE37, 0xEE99, 0xF7BD, 0xDE94, 0x9CCC, 0x6B46, 0x4221, 0x1120, 0x39A2, 0x4A03, 
        0x49E3, 0x49E4, 0x49E2, 0x3161, 0x1041, 0x49A5, 0xA3EF, 0xDD76, 0xDDB7, 0xB4D2, 0xBD13, 0xC534, 0xCD54, 0xBCD3, 0x9C0E, 0x9BAC, 0xB40E, 0xC4F5, 0xDE58, 0xACF0, 0x4944, 0xA04F, 0xA10E, 0x894B, 0x80A8, 0xB0F0, 0xC1F0, 0xB38A, 0x9563, 0x9487, 
        0x6223, 0x4881, 0x4801, 0x70A6, 0xAB6D, 0xDDF1, 0xE710, 0x4AA7, 0x732C, 0xBC92, 0xEDB5, 0xAC10, 0xB38D, 0x8247, 0x2862, 0x68A6, 0x8069, 0x884B, 0x88AA,
  0x92D6, 0x92D6, 0x92D6, 0x92D6, 0x9AF6, 0x92F6, 0x92F6, 0x9AF6, 0x92D6, 0x9AF7, 0x9AF7, 0x9AF7, 0x9317, 0x9B17, 0x9AF7, 0x9AF8, 0x9B37, 0x9AF8, 0x9AD8, 0xA2F8, 0x9B38, 0xAB97, 0xBBD5, 0xBBF3, 0xC3F2, 0xC3F1, 0xCC10, 0xD411, 0xD493, 0xDCB2, 0xDCB3, 
        0xDCB4, 0xDCD2, 0xD4D3, 0xCCF4, 0xBCF2, 0xC472, 0xD4D2, 0xDCF1, 0xE4D1, 0xED13, 0xED11, 0xED11, 0xECF2, 0xDCAF, 0xDC6E, 0xDC2D, 0xD42D, 0xD44C, 0xDC6D, 0xD46E, 0xD44D, 0xCC2D, 0xCC4E, 0xD46E, 0xDC8E, 0xE4F2, 0xED12, 0xED12, 0xED12, 0xF513, 
        0xF513, 0xED13, 0xED13, 0xF533, 0xF513, 0xED13, 0xF513, 0xE4D1, 0xE4B1, 0xE491, 0xDC6F, 0xDC70, 0xD430, 0xD410, 0xD42F, 0xCBCE, 0xBBCE, 0xBBCE, 0xB38D, 0xABAB, 0xAB8B, 0xAB6C, 0xAB8B, 0xB34C, 0xB32C, 0xAB2B, 0xA32A, 0xAB0A, 0xAB0A, 0xAB2A, 
        0xB32A, 0xA328, 0xA2CA, 0xA2AA, 0x92A7, 0x8246, 0x8A45, 0x9286, 0xA307, 0xAB89, 0xB3AA, 0xBBAA, 0xB388, 0xA2A3, 0x81E1, 0x5941, 0x28A0, 0x28E2, 0x28E4, 0x28C3, 0x20E2, 0x626A, 0x7ACD, 0x8B0F, 0xA374, 0xB4BE, 0xDBDE, 0xF27B, 0xF955, 0xF955, 
        0xF994, 0xF992, 0xF971, 0xF9B7, 0xF9D8, 0xF9F8, 0xF9F8, 0xF9B8, 0xF9F9, 0xF9D7, 0xF174, 0xFA58, 0xFA58, 0xFA39, 0xFA1A, 0xF23A, 0xFA19, 0xFA3A, 0xFA7B, 0xFA3D, 0xFA3C, 0xFA5C, 0xFA5B, 0xFA16, 0xFA36, 0xFA16, 0xF9B4, 0xE8F3, 0xE8F0, 0xD0AC, 
        0xB027, 0xA048, 0xA047, 0x9846, 0xA087, 0xA949, 0xA949, 0xA969, 0xA9CA, 0xA1E7, 0x99E8, 0x99C9, 0xA1C9, 0xB2AC, 0xAAAB, 0xAAAB, 0xB2EB, 0xB2EA, 0xAAA9, 0xAAAA, 0xAAEB, 0xAB2C, 0xA28B, 0x89E8, 0x6903, 0x5022, 0x4801, 0x4822, 0x4022, 0x4821, 
        0x4822, 0x5023, 0x5024, 0x5883, 0x6043, 0x6044, 0x60A5, 0x6024, 0x6044, 0x6845, 0x6826, 0x7066, 0x7086, 0x7888, 0x78AA, 0x7889, 0x6889, 0x6089, 0x5888, 0x58A8, 0x50A6, 0x3864, 0x1002, 0x0823, 0x1044, 0x1865, 0x28C6, 0x28C6, 0x38C9, 0x490A, 
        0x598B, 0x416C, 0x51AD, 0x59CE, 0x59AE, 0x312B, 0x30CB, 0x38AA, 0x38C9, 0x3088, 0x3889, 0x40AA, 0x40CA, 0x38E5, 0x38E7, 0x30C9, 0x2889, 0x4869, 0x50CA, 0x48C9, 0x4046, 0x71CC, 0x4989, 0x4106, 0x50E6, 0x7AAB, 0x93AD, 0xA470, 0xBD54, 0xF7BE, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFF7C, 0xF6B7, 0xFEF7, 0xF73A, 0xF79D, 0xF7BC, 0xE615, 0xF6F7, 0xFFBB, 0xE73B, 0x4225, 0x946A, 0xBDD0, 0x9D10, 0x41C3, 0x5A84, 0x7B68, 
        0x8BCA, 0x8BCA, 0x8389, 0x8349, 0x8329, 0x5A47, 0x7B0B, 0x93CE, 0x9C30, 0xCD12, 0xCD33, 0xCD34, 0xCD54, 0xBD52, 0xBCF2, 0xACAF, 0xA48C, 0xC554, 0xDDF8, 0xAC32, 0x5085, 0xA8CD, 0xA0CC, 0xA08E, 0xA852, 0x7908, 0x82A9, 0x8C27, 0x7D22, 0x8C0A, 
        0xA3AC, 0x9AEA, 0x7186, 0x5065, 0x58A4, 0x82A8, 0xC60F, 0xEEEF, 0xA4AE, 0x6ACA, 0x51E5, 0x5081, 0x6046, 0x6848, 0x7068, 0x804B, 0x886A, 0x8069, 0x7028,
  0x92B6, 0x92D6, 0x92D7, 0x9AD7, 0x92F6, 0x9AD6, 0x9AD6, 0x9AD7, 0x92F7, 0x9AF7, 0x9AD7, 0x9AD7, 0x9B17, 0x9B17, 0x9B17, 0x9B17, 0x9B18, 0x9B18, 0x9AF7, 0x9AD7, 0xA337, 0xB378, 0xB398, 0xB3B6, 0xBBD3, 0xC3F3, 0xCC53, 0xE4B3, 0xE4D5, 0xED34, 0xED34, 
        0xDCD3, 0xB451, 0xB470, 0xB42F, 0xA3AE, 0x938C, 0xB3EF, 0xCC71, 0xE4F3, 0xED32, 0xED12, 0xED12, 0xED12, 0xE4AF, 0xD46E, 0xCC4D, 0xCC0D, 0xD42D, 0xD44D, 0xD46E, 0xD46E, 0xCC0D, 0xCC2C, 0xCC4D, 0xCC8E, 0xED12, 0xED12, 0xED12, 0xED32, 0xED33, 
        0xED13, 0xF513, 0xED13, 0xF533, 0xED33, 0xED12, 0xECF1, 0xE4B1, 0xDC91, 0xE471, 0xE451, 0xD450, 0xD44F, 0xD44F, 0xCC4F, 0xD3CF, 0xCBCE, 0xC3ED, 0xC3CC, 0xAB8D, 0xAB8C, 0xABAC, 0xB38C, 0xAB2B, 0xAB4B, 0xAB4A, 0xAB2A, 0xAB4A, 0xAB4A, 0xAB2A, 
        0xAB2A, 0xA2EA, 0xA2C8, 0x9AA6, 0x9265, 0x8267, 0x82C8, 0x9309, 0x9B4A, 0xB389, 0xBB8A, 0xB38A, 0xA349, 0x7A87, 0x49A5, 0x28E3, 0x1841, 0x28C4, 0x3104, 0x3124, 0x4165, 0x6AE5, 0x7AEC, 0x8AF1, 0xA374, 0xBCBD, 0xE35B, 0xF218, 0xF954, 0xF9B4, 
        0xF994, 0xF174, 0xF174, 0xF1B6, 0xF9D7, 0xF9D8, 0xF9B8, 0xF9F8, 0xF997, 0xF997, 0xF9F8, 0xFA7B, 0xFA3A, 0xFA19, 0xFA19, 0xFA19, 0xFA3A, 0xF9F9, 0xF197, 0xFA1B, 0xFA5D, 0xFA5C, 0xFA7A, 0xFA1A, 0xFA3B, 0xFA1B, 0xF9FA, 0xFA17, 0xF173, 0xF111, 
        0xF110, 0xA867, 0xA847, 0xA847, 0x9065, 0x98A7, 0x98E6, 0x9906, 0xA106, 0xA1AA, 0x9987, 0xA185, 0xA186, 0x9185, 0xA186, 0xA1A8, 0xA1C9, 0xB24A, 0xA208, 0x91A6, 0x9187, 0x7905, 0x6062, 0x5001, 0x4800, 0x4861, 0x4842, 0x4822, 0x4822, 0x4864, 
        0x4824, 0x5023, 0x6042, 0x5866, 0x6045, 0x6865, 0x6865, 0x6865, 0x7066, 0x7067, 0x7087, 0x6846, 0x7068, 0x7869, 0x8068, 0x806A, 0x7889, 0x78A9, 0x8088, 0x8048, 0x7869, 0x68A9, 0x58A7, 0x4044, 0x3845, 0x3025, 0x2004, 0x1045, 0x20A6, 0x20C7, 
        0x20E8, 0x498B, 0x496B, 0x414A, 0x38E9, 0x2848, 0x3869, 0x508B, 0x60AB, 0x60C8, 0x4868, 0x3828, 0x2807, 0x3003, 0x2044, 0x2067, 0x2889, 0x3065, 0x30C8, 0x38E9, 0x38C8, 0x2887, 0x50E9, 0x48E7, 0x2084, 0x7252, 0x9B57, 0x9BB4, 0x8C4E, 0xEF7D, 
        0xFF9F, 0xFF7F, 0xFFBF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFDF, 0xFFBF, 0xFF5E, 0xFEFB, 0xF6B8, 0xFF7B, 0xFF5A, 0xFF1B, 0xFEFB, 0xF6B5, 0xEF3A, 0xAD33, 0x49A4, 0x94CD, 0xBDEF, 0xC5EF, 0xA4ED, 0x3103, 0x6A88, 0x93AC, 
        0x93AB, 0x8B69, 0xAC2B, 0xBC8D, 0xBC6D, 0x8AE9, 0x6A46, 0x7AA7, 0xB40D, 0xBC92, 0xBCD2, 0xBD12, 0xBD54, 0xC555, 0xBD31, 0xB4CD, 0x9C8C, 0xA4F2, 0xAD0F, 0x834A, 0x4885, 0xB0AC, 0xA0EC, 0x88E9, 0x88A7, 0xA92C, 0xB9AF, 0xC232, 0xC2D3, 0x8463, 
        0x6C43, 0x73C6, 0x8B09, 0x9223, 0x9A87, 0xA30B, 0xB38D, 0xA46A, 0x6224, 0x48A4, 0x7069, 0x98CC, 0x8089, 0x7868, 0x906A, 0x786A, 0x7869, 0x7849, 0x7849,
  0x92D6, 0x92D6, 0x92B6, 0x92B6, 0x92D6, 0x92D7, 0x9AD7, 0x92D7, 0x9AD7, 0x9AD7, 0x9AF7, 0x92F7, 0x9AF7, 0x9AF7, 0x9AF6, 0x9AD7, 0x9B19, 0x9B18, 0xA318, 0xA2F8, 0x9B18, 0x9B59, 0xA358, 0xB377, 0xBBF6, 0xCC35, 0xD494, 0xE4D5, 0xED34, 0xED14, 0xE4F4, 
        0xDCD3, 0xB431, 0x9B2C, 0x7A68, 0x4A05, 0x72C9, 0x9BAC, 0xC44F, 0xD4F2, 0xE512, 0xE532, 0xDD12, 0xE4F2, 0xD48E, 0xCC4D, 0xCC2C, 0xCC0C, 0xCC2C, 0xCC6C, 0xCC6D, 0xCC4D, 0xCC4D, 0xCC6D, 0xD48E, 0xDCB2, 0xDD32, 0xDD31, 0xE512, 0xE4F3, 0xE513, 
        0xE512, 0xE512, 0xE512, 0xDCF2, 0xE4F2, 0xECF2, 0xE4F1, 0xE4B2, 0xDCB1, 0xE4B1, 0xE471, 0xCC50, 0xCC4F, 0xD44F, 0xD42F, 0xCC0E, 0xCBEE, 0xC3CE, 0xBBCE, 0xC38C, 0xBB8C, 0xB38C, 0xAB6C, 0xAB4B, 0xAB4A, 0xAB2A, 0xAB0A, 0xAB2A, 0xAB2A, 0xAB2A, 
        0xA32A, 0x9AC8, 0xA2C7, 0x9A87, 0x8A47, 0x8A66, 0x92A8, 0x9AE9, 0xAB49, 0xB3A9, 0xB3CA, 0xB389, 0x9AA6, 0x51A2, 0x3922, 0x28C2, 0x28A1, 0x3987, 0x49C8, 0x51E8, 0x51E9, 0x6A89, 0x82EA, 0x932C, 0x9BB1, 0xBD1A, 0xDB1B, 0xF1D9, 0xF9B7, 0xF194, 
        0xF193, 0xF194, 0xF9B6, 0xF195, 0xF9B6, 0xF9D8, 0xF9B8, 0xF1B8, 0xF197, 0xF9D8, 0xFA5B, 0xF1F8, 0xFA18, 0xFA18, 0xF218, 0xF219, 0xF1D8, 0xF1B7, 0xF1D7, 0xFA3A, 0xFA3A, 0xF21A, 0xF23B, 0xF25B, 0xFA3B, 0xFA1B, 0xFA1B, 0xFA5A, 0xF1F7, 0xF155, 
        0xE8D2, 0xC06B, 0xB02A, 0xA829, 0xA026, 0x9003, 0x9043, 0x9084, 0x98A5, 0x8905, 0x9105, 0x9906, 0xA126, 0x8986, 0x8967, 0x8967, 0x8126, 0x68C3, 0x60A3, 0x5083, 0x4041, 0x4000, 0x4001, 0x4802, 0x5022, 0x4042, 0x4042, 0x4822, 0x5022, 0x5024, 
        0x4844, 0x5045, 0x6005, 0x5044, 0x5845, 0x6025, 0x6005, 0x6845, 0x6846, 0x6846, 0x6867, 0x6045, 0x6047, 0x6047, 0x6026, 0x6847, 0x6025, 0x6025, 0x6846, 0x6825, 0x6827, 0x6827, 0x6046, 0x68C8, 0x60C8, 0x58A8, 0x48A6, 0x3065, 0x2044, 0x2885, 
        0x30E8, 0x4149, 0x28E8, 0x28C9, 0x40EA, 0x58C9, 0x790C, 0x890D, 0x88AC, 0x8048, 0x88A9, 0x910B, 0x894D, 0x68C9, 0x4046, 0x2004, 0x0802, 0x2003, 0x2004, 0x2845, 0x3086, 0x30A8, 0x30E7, 0x392A, 0x494E, 0x388C, 0x2066, 0x62EC, 0xEF5D, 0xFFBE, 
        0xFF5D, 0xFF3D, 0xFF5E, 0xF7BE, 0xFFDE, 0xFFDF, 0xFFBF, 0xFFDE, 0xFFFE, 0xFFFF, 0xFFBF, 0xFF5E, 0xF6B9, 0xF6F9, 0xFFBB, 0xFEF9, 0xF677, 0xEE55, 0xEE75, 0xEF5B, 0x83EC, 0x5222, 0x6303, 0xB5AE, 0xC610, 0xACED, 0x7307, 0x6266, 0x8B08, 0x9369, 
        0x8B49, 0xA3AA, 0xABCA, 0xA38B, 0x9B6B, 0xAC0C, 0xB3ED, 0x9B6B, 0x82C8, 0xBC0F, 0xC491, 0xC4B2, 0xCCB3, 0xC531, 0xC552, 0xBD32, 0xAD0F, 0xBD2D, 0x940A, 0x6AA7, 0x5965, 0xB850, 0xA0AD, 0x90EA, 0x90CA, 0x810B, 0x8A4A, 0xA38B, 0xBCAD, 0x84A6, 
        0x7C23, 0x8BE5, 0xA3E8, 0x71E6, 0x70E6, 0x92A9, 0xCDED, 0x8349, 0x6927, 0x6026, 0x7027, 0x684A, 0x806A, 0x8889, 0x8889, 0x80AA, 0x888A, 0x8869, 0x7848,
  0x92D6, 0x92D6, 0x92D6, 0x9AD6, 0x92F7, 0x9AF7, 0x9AF7, 0x9AD8, 0x92F6, 0x92F7, 0x92F7, 0x9AF7, 0x9B18, 0x9B17, 0x9B17, 0x9AF7, 0x9B17, 0x9B18, 0x9B18, 0x9B18, 0xA337, 0xAB78, 0xB398, 0xBBB6, 0xC3D4, 0xC433, 0xD474, 0xE495, 0xED12, 0xED14, 0xE4F4, 
        0xDCF3, 0xCC92, 0xABEF, 0x830B, 0x6A48, 0x6A46, 0x8309, 0xA3ED, 0xD490, 0xE4D2, 0xED13, 0xED13, 0xE4D2, 0xE4AF, 0xDC8E, 0xCC4D, 0xBC2D, 0xCC4C, 0xD46D, 0xD46E, 0xDC6E, 0xD46F, 0xCC8F, 0xDCB0, 0xECD2, 0xE532, 0xE512, 0xE512, 0xE512, 0xECF1, 
        0xE4F2, 0xE4F2, 0xECF3, 0xED12, 0xED12, 0xE4F2, 0xECF1, 0xE4B1, 0xE4B1, 0xE4B1, 0xDCB1, 0xDC4E, 0xDC4F, 0xDC50, 0xDC50, 0xD42F, 0xCC2F, 0xC40E, 0xBBCD, 0xBBCE, 0xC3AD, 0xBB8D, 0xB38C, 0xAB8B, 0xAB6B, 0xAB4B, 0xAB4B, 0xAB4A, 0xA34A, 0xA34B, 
        0xA32B, 0xA328, 0x9AE8, 0x92C7, 0x8AA6, 0x8286, 0x8AA8, 0x92E9, 0xA369, 0xB38A, 0xABAA, 0xABAA, 0xAB6A, 0x6205, 0x4984, 0x2903, 0x10C2, 0x4945, 0x5186, 0x51E8, 0x5249, 0x72EB, 0x932D, 0x934E, 0x93D1, 0xCCFA, 0xEAFA, 0xF9D8, 0xF9B6, 0xF9B4, 
        0xF9B5, 0xF9B6, 0xF9B6, 0xF9F6, 0xF9D7, 0xF9D8, 0xF1D8, 0xF977, 0xF997, 0xFA38, 0xFA9A, 0xF175, 0xF996, 0xFA19, 0xFA5B, 0xFA38, 0xF1B7, 0xF196, 0xF996, 0xFA59, 0xFA5A, 0xFA3A, 0xFA5B, 0xF2BD, 0xF27C, 0xF9DA, 0xF958, 0xFA3A, 0xFA9A, 0xFA99, 
        0xF9F6, 0xE92F, 0xD8AC, 0xC04A, 0xA829, 0xA044, 0x8822, 0x8021, 0x8862, 0x8084, 0x8865, 0x8845, 0x7842, 0x6822, 0x6022, 0x6021, 0x5822, 0x6042, 0x5022, 0x4801, 0x4802, 0x5883, 0x5864, 0x5844, 0x5844, 0x5863, 0x5864, 0x5044, 0x5803, 0x6064, 
        0x5885, 0x5885, 0x6045, 0x6846, 0x6025, 0x6825, 0x7046, 0x5044, 0x5825, 0x6825, 0x6805, 0x5045, 0x5824, 0x5804, 0x5804, 0x5003, 0x5024, 0x5004, 0x4803, 0x5824, 0x6845, 0x6846, 0x6847, 0x7046, 0x6825, 0x6004, 0x5825, 0x60CA, 0x58E9, 0x50C8, 
        0x48A9, 0x4108, 0x4129, 0x410A, 0x50C9, 0x788B, 0x90AC, 0x988C, 0x906B, 0x990C, 0x8889, 0x888A, 0xA14E, 0xB211, 0xA990, 0x996E, 0x896C, 0x3825, 0x3005, 0x2803, 0x2001, 0x1024, 0x2066, 0x40E8, 0x616B, 0x1022, 0x1041, 0x6AEC, 0xEF5C, 0xFF17, 
        0xFF1B, 0xFEFC, 0xF6DB, 0xFF1D, 0xFF5E, 0xFFBE, 0xFFFF, 0xFFDF, 0xFFDF, 0xFF9E, 0xFF5D, 0xFEFB, 0xF6DB, 0xF73C, 0xFFDE, 0xFF7C, 0xFF1A, 0xF6B7, 0xEE75, 0xE73B, 0x632C, 0x4A66, 0xA50D, 0x94AB, 0xB5B0, 0xBDB0, 0x93EA, 0x38E2, 0x61C4, 0x8AA7, 
        0x92C9, 0x8B2A, 0x932A, 0x934A, 0x9B6B, 0xA36C, 0xAB8D, 0xB40E, 0xBC8F, 0x9B0B, 0xA34C, 0xABCE, 0xB42F, 0x8B6B, 0xABED, 0xC4F1, 0xCDB4, 0xA3EE, 0x832A, 0x72A7, 0x7227, 0xA88D, 0xB08E, 0xA8CE, 0xA10D, 0x910C, 0x910D, 0xA1AE, 0xBAEE, 0xC450, 
        0xAC2B, 0x9407, 0x8405, 0x9421, 0x82A3, 0x81A7, 0x920D, 0xD5B1, 0x8347, 0x5903, 0x6827, 0x882A, 0x804A, 0x786A, 0x786A, 0x806A, 0x888B, 0x806B, 0x8049,
  0x9AF7, 0x92D6, 0x92D6, 0x9B17, 0x9AF6, 0x9AF7, 0x9AF7, 0x9AD6, 0x92F6, 0x9B17, 0x9B18, 0x9AF8, 0x9AF8, 0x9B17, 0x9B17, 0x9AF8, 0x9B17, 0x9B17, 0xA2F8, 0xA317, 0xB398, 0xBBB7, 0xB3B6, 0xB3D5, 0xBBF4, 0xCC34, 0xD454, 0xDCB4, 0xF515, 0xECF6, 0xECF6, 
        0xECF5, 0xDCD3, 0xBC71, 0xB430, 0xB40F, 0x82C9, 0x8B0A, 0x936B, 0xA3CC, 0xCCB2, 0xD4F2, 0xDCD1, 0xDCB2, 0xD48E, 0xCC4E, 0xC40D, 0xC40D, 0xBC4E, 0xCC2E, 0xD44E, 0xD48F, 0xDC8F, 0xDC91, 0xDCD1, 0xE511, 0xED12, 0xED32, 0xE512, 0xE4F1, 0xDCF2, 
        0xE4F2, 0xE512, 0xE513, 0xDD12, 0xECF2, 0xECF2, 0xE4F1, 0xE4B1, 0xE4B0, 0xE490, 0xDC8E, 0xD470, 0xDC70, 0xDC70, 0xD44F, 0xD46F, 0xD44F, 0xD42E, 0xD40E, 0xC3EE, 0xBBED, 0xBBCD, 0xBBCD, 0xB38B, 0xB38B, 0xB36B, 0xAB4B, 0xAB4A, 0xAB2A, 0xA32A, 
        0x9B49, 0xA2E9, 0xA2C8, 0x9AA7, 0x9266, 0x92A8, 0x8AA8, 0x8B08, 0x9B89, 0xBBEB, 0xB38B, 0xB38B, 0xABAA, 0x6161, 0x38C1, 0x30C2, 0x3944, 0x4988, 0x59E9, 0x6A69, 0x6AA8, 0x62AA, 0x8B8D, 0x9C0F, 0xA411, 0xACD8, 0xDADA, 0xF9B9, 0xF9B6, 0xF9B4, 
        0xF195, 0xF175, 0xF975, 0xF9F8, 0xF9F8, 0xF197, 0xF135, 0xF997, 0xFA3A, 0xFA7A, 0xFA58, 0xF915, 0xF996, 0xFA18, 0xFA59, 0xFA17, 0xF1B6, 0xF196, 0xF195, 0xF997, 0xF9D9, 0xF9DA, 0xF9D9, 0xFA7B, 0xFA5C, 0xF1DA, 0xE937, 0xF999, 0xFA3C, 0xFA7C, 
        0xFA5A, 0xF1D7, 0xF152, 0xE0EF, 0xD0AD, 0xB04A, 0xA027, 0x9825, 0x9025, 0x8025, 0x8025, 0x8045, 0x7824, 0x7825, 0x8045, 0x8045, 0x8045, 0x7845, 0x7845, 0x7865, 0x7865, 0x7823, 0x7844, 0x7864, 0x7844, 0x7865, 0x7045, 0x7865, 0x7886, 0x7047, 
        0x7066, 0x7866, 0x8066, 0x7866, 0x7866, 0x7867, 0x78A7, 0x7025, 0x6825, 0x7045, 0x7045, 0x6025, 0x6045, 0x6845, 0x6845, 0x6065, 0x5864, 0x6065, 0x6066, 0x5845, 0x6045, 0x6825, 0x7025, 0x78A9, 0x6869, 0x6828, 0x6806, 0x5804, 0x6006, 0x6027, 
        0x6067, 0x4848, 0x5888, 0x6888, 0x6848, 0x7008, 0x884A, 0x8849, 0x7028, 0x98CD, 0xA98E, 0x914A, 0x7046, 0x994C, 0xA9B0, 0xB1B3, 0xB9B6, 0xDA94, 0xC233, 0xB1B2, 0x9951, 0x608C, 0x4908, 0x28E6, 0x0824, 0x10A3, 0xA513, 0xF79B, 0xFFBA, 0xFF3E, 
        0xFF7D, 0xFF9C, 0xFF7C, 0xFEFC, 0xFEFC, 0xFF1C, 0xFF3C, 0xFF3E, 0xFF3D, 0xFEFB, 0xF6BA, 0xF6F8, 0xF75A, 0xEED9, 0xDD94, 0xEEB7, 0xF675, 0xF6D8, 0xDEFB, 0x2104, 0x39A2, 0x7B87, 0xB54E, 0xAD4F, 0xD632, 0xA48D, 0x30A2, 0x6123, 0x71A6, 0x7A28, 
        0x8AAB, 0x9B2A, 0x92EA, 0x92CA, 0x9B0A, 0xA38D, 0xAB8D, 0xA30C, 0x92AA, 0xBBCD, 0xABAC, 0x9B6C, 0xA36D, 0xB40D, 0xB42E, 0xAC2F, 0xAC0F, 0x934B, 0x8349, 0x7B07, 0x7265, 0x992C, 0x90EC, 0x98CC, 0xA8AE, 0xA8B0, 0xB06D, 0xA0E9, 0x7A86, 0xADCB, 
        0x9D08, 0x9C45, 0xA442, 0xA3A7, 0x926B, 0x81A9, 0x7A04, 0xB5CD, 0x934C, 0x790A, 0x7829, 0x908B, 0x808B, 0x786B, 0x786B, 0x784B, 0x806B, 0x806B, 0x806B,
  0x92D7, 0x92D6, 0x92B6, 0x92B5, 0x9AD7, 0x9AD7, 0x9AD7, 0x9AD7, 0x9AD7, 0x9AF7, 0x9AF7, 0x9AF7, 0x9AF7, 0x9AF7, 0x9AF7, 0x9AF7, 0x9B18, 0xA318, 0xA339, 0xA358, 0xAB58, 0xB397, 0xB3B6, 0xB3B5, 0xB3D5, 0xB3B4, 0xBBD3, 0xCC54, 0xDCD4, 0xE4F6, 0xECF5, 
        0xDCD3, 0xCC94, 0xBC72, 0xB430, 0xABCD, 0x930A, 0x8AE9, 0x8AE9, 0x9B2A, 0xB40D, 0xC42E, 0xCC4F, 0xD48F, 0xC48F, 0xC46E, 0xC44D, 0xBC4D, 0xCC8E, 0xDC8E, 0xDCAF, 0xD4B1, 0xDCD0, 0xE4F2, 0xE512, 0xE531, 0xED33, 0xE512, 0xE512, 0xE512, 0xE4F2, 
        0xDCD2, 0xD4D2, 0xD4B0, 0xDCB1, 0xDCB1, 0xDCB1, 0xDCD0, 0xDCD1, 0xDCD0, 0xDCB1, 0xE471, 0xCC8E, 0xD470, 0xD470, 0xD46F, 0xCC6F, 0xD46F, 0xD44E, 0xCC2E, 0xC40D, 0xC3ED, 0xC3AC, 0xB38C, 0xB38B, 0xAB8B, 0xAB6A, 0xB34B, 0xAB49, 0xAB29, 0xAB4A, 
        0xA36A, 0x92A8, 0x92A7, 0x92A6, 0x9285, 0x92A9, 0x92A8, 0x92E8, 0x9B49, 0xBC6C, 0xC44B, 0xBBEA, 0xA329, 0x7245, 0x5184, 0x4165, 0x5208, 0x6AE9, 0x72CB, 0x6AAB, 0x626B, 0x7ACC, 0xA3CE, 0xAC70, 0x9CB2, 0xACB7, 0xDA99, 0xF978, 0xF9B6, 0xF193, 
        0xF1B5, 0xF1B5, 0xF174, 0xF9B7, 0xF9D7, 0xF1B6, 0xF196, 0xFA38, 0xFA79, 0xFA59, 0xF9D6, 0xF176, 0xF196, 0xF1D7, 0xF217, 0xF218, 0xF1B7, 0xE976, 0xF156, 0xF1B6, 0xF196, 0xF196, 0xF1D7, 0xFA3C, 0xFA1A, 0xE997, 0xD8D4, 0xF9D9, 0xFA5C, 0xFA7D, 
        0xFA1C, 0xFA19, 0xF1B5, 0xE931, 0xD8AD, 0xB869, 0xA067, 0x9845, 0x9004, 0x9045, 0x9066, 0x9066, 0x9046, 0x9066, 0x9067, 0x8846, 0x8846, 0x9066, 0x8846, 0x8046, 0x7865, 0x8068, 0x8046, 0x8024, 0x8025, 0x7847, 0x8868, 0x9087, 0x8087, 0x7849, 
        0x8068, 0x8887, 0x8888, 0x8868, 0x9089, 0x8889, 0x8048, 0x8827, 0x8889, 0x88A9, 0x9089, 0x90C9, 0x8888, 0x7867, 0x7068, 0x80A8, 0x8087, 0x7887, 0x8068, 0x7047, 0x6846, 0x6847, 0x6048, 0x6824, 0x78A8, 0x810B, 0x890B, 0x7888, 0x7048, 0x7848, 
        0x8089, 0x6849, 0x7028, 0x8069, 0x90CB, 0x7029, 0x888A, 0x908A, 0x8008, 0x7008, 0x80AA, 0x912B, 0x994B, 0x6828, 0x786A, 0x890E, 0x99D1, 0xC0F1, 0xB972, 0xB9D4, 0xC9F6, 0xC213, 0x9A92, 0x59EB, 0x20A3, 0xB3D2, 0xEE7B, 0xFF9D, 0xFF3C, 0xFF3E, 
        0xF77C, 0xF77C, 0xFF3C, 0xFED9, 0xF6D9, 0xF6B9, 0xF699, 0xF6D8, 0xF6D9, 0xF6B9, 0xF698, 0xF697, 0xEE57, 0xE636, 0xD635, 0xF657, 0xFF19, 0xF75A, 0xD656, 0x2924, 0x7368, 0xBD6E, 0xD650, 0xD653, 0x9CAD, 0x62A6, 0x28A1, 0x4983, 0x7206, 0x9288, 
        0x9AC9, 0xA2CB, 0x9AEB, 0x9B0B, 0xA30B, 0xABCF, 0xA32C, 0xA32C, 0xAB8E, 0xAB0B, 0xB38C, 0xB3AC, 0xA30A, 0xA34C, 0xB3ED, 0xBC4E, 0xABCD, 0x30C3, 0x7A68, 0xA3AC, 0x936A, 0x5203, 0x7187, 0x910B, 0x98AD, 0xA08D, 0x9890, 0xA191, 0xC371, 0xBC8D, 
        0x9C46, 0x9463, 0xA4E5, 0x7403, 0x49A2, 0x6907, 0xCAB2, 0xBD2D, 0x6AC5, 0x4924, 0x70C9, 0x988B, 0x906B, 0x888A, 0x908B, 0x888B, 0x886A, 0x804A, 0x786A,
  0x92D7, 0x92F6, 0x92F6, 0x9AF6, 0x9AF8, 0x9AD7, 0x9AD7, 0x92D7, 0x9317, 0x92F7, 0x9AF8, 0x9B18, 0x9AF8, 0x9B17, 0x9B17, 0x9AF8, 0xA338, 0x9B18, 0x9B18, 0xA338, 0xAB77, 0xB3B5, 0xB3D5, 0xBBD5, 0xBBD6, 0xB3B5, 0xB3B4, 0xB3D5, 0xDC34, 0xDCB5, 0xE4D5, 
        0xE4D4, 0xE4D5, 0xCCB3, 0xBC51, 0xB3EE, 0x9B4B, 0x8B0A, 0x8B09, 0x9329, 0xA3AC, 0xBC2E, 0xC490, 0xC490, 0xD490, 0xD490, 0xCC8F, 0xCC6F, 0xCC6F, 0xD490, 0xD490, 0xDCB0, 0xDCF1, 0xDD11, 0xDD11, 0xE531, 0xED32, 0xE532, 0xE512, 0xE4F1, 0xE4D1, 
        0xE4F1, 0xDCD1, 0xDCB0, 0xDC8F, 0xDCB0, 0xDCD1, 0xDCB1, 0xDCB0, 0xDCB0, 0xDCB0, 0xDCB0, 0xD471, 0xDC91, 0xDC91, 0xDC91, 0xD46E, 0xD46F, 0xD46F, 0xD44F, 0xC42E, 0xC40D, 0xC3ED, 0xBBCD, 0xB38B, 0xB3AB, 0xB3AB, 0xB36B, 0xAB8A, 0xA34A, 0xA349, 
        0x9B2A, 0x9B09, 0x92C6, 0x92A6, 0x92A7, 0x8A86, 0x92E8, 0x9B29, 0xA349, 0xBC2D, 0xC44C, 0xBC0B, 0xAB8A, 0x8286, 0x6205, 0x51A5, 0x49A6, 0x6AAA, 0x72EC, 0x6ACB, 0x6A8A, 0x832A, 0x93ED, 0x9490, 0x94D2, 0xBC56, 0xE278, 0xF978, 0xF9B6, 0xF194, 
        0xF1B4, 0xF9B6, 0xF977, 0xFA37, 0xF197, 0xF997, 0xFA37, 0xFA7B, 0xFA5B, 0xFA5A, 0xFA39, 0xF9F7, 0xF9B7, 0xF977, 0xF977, 0xFA38, 0xF218, 0xF1D7, 0xF9B7, 0xF197, 0xF176, 0xF135, 0xE914, 0xFA7B, 0xFA9D, 0xF1DA, 0xE0B3, 0xE935, 0xFA19, 0xFA7D, 
        0xFA7E, 0xFABE, 0xFA5A, 0xF9D7, 0xF156, 0xE8F0, 0xC88E, 0xB82B, 0xB008, 0x9866, 0x8865, 0x8885, 0x88A6, 0x9048, 0x9049, 0x8829, 0x8828, 0x8888, 0x9089, 0x9068, 0x8866, 0x908B, 0x9069, 0x9068, 0x9889, 0x9849, 0x9069, 0x8888, 0x8046, 0x8047, 
        0x8066, 0x8887, 0x888A, 0x806B, 0x886A, 0x884A, 0x9029, 0x9068, 0x8849, 0x8009, 0x8007, 0x9049, 0x908B, 0x90CB, 0x90CB, 0x90CB, 0x98CB, 0x98AA, 0x90A8, 0x80AB, 0x808A, 0x7868, 0x6847, 0xA12C, 0x90EC, 0x88CB, 0x80CA, 0x88AA, 0x908A, 0x98AB, 
        0x98EC, 0x910E, 0x806A, 0x7829, 0x886A, 0x90EC, 0x98AC, 0x98AC, 0xA0AB, 0x780A, 0x6808, 0x7849, 0x908B, 0x906E, 0x802C, 0x802B, 0x906C, 0x9991, 0xA171, 0xA971, 0xB171, 0xB0B1, 0x89F0, 0x59CA, 0x4925, 0xE71C, 0xFFDF, 0xFFBE, 0xFF7E, 0xFFBF, 
        0xFF9E, 0xFF7D, 0xF73C, 0xF6DA, 0xFED9, 0xFEF8, 0xF719, 0xFEDA, 0xFEFB, 0xF71A, 0xF6F7, 0xEE56, 0xF5F5, 0xCD32, 0x9C4F, 0xEEF6, 0xF77B, 0xA513, 0x20E3, 0x5A64, 0x8349, 0x8B69, 0x7B87, 0xA4CC, 0x6AE5, 0x4981, 0x5162, 0x82A8, 0x79C5, 0x7145, 
        0x81AA, 0xA34D, 0xAB6E, 0xAB4E, 0xA32D, 0xB3D0, 0xBBAF, 0xB36E, 0xAB6E, 0xBBEF, 0xBBEE, 0xB3CD, 0xBBCD, 0xB3AD, 0xB3CD, 0xB3CD, 0xABAE, 0xC490, 0xBC0F, 0xABED, 0x9429, 0x7B42, 0x9AC7, 0x99EB, 0x80CB, 0x98CE, 0xA08F, 0x992D, 0x9308, 0x9504, 
        0x8D22, 0x8D03, 0x9CE7, 0x9BCB, 0x89AB, 0x7868, 0x7125, 0xB5EB, 0x93AB, 0x816A, 0x804A, 0x80AA, 0x806A, 0x884A, 0x906B, 0x90CB, 0x908B, 0x886B, 0x886B,
  0x9AF6, 0x92F7, 0x9AF7, 0x9AF7, 0x9AF7, 0x92F7, 0x9AF7, 0x9AF7, 0x9AF7, 0x9AF7, 0x9AF8, 0x9B18, 0x9AF8, 0x9B18, 0x9B18, 0x9B18, 0x9AF8, 0x9B19, 0xA31A, 0xAB3B, 0xABB7, 0xAB96, 0xAB96, 0xB396, 0xB398, 0xB358, 0xB357, 0xB377, 0xBBF5, 0xD474, 0xE4B4, 
        0xECB4, 0xD4D3, 0xCC92, 0xC430, 0xB3AE, 0x934C, 0x82C9, 0x7267, 0x6A26, 0x92EA, 0xA3AC, 0xAC0D, 0xB42E, 0xE4D2, 0xDCB1, 0xDC90, 0xDCB0, 0xDCF2, 0xDCD1, 0xDCD0, 0xE511, 0xE513, 0xED13, 0xED33, 0xED34, 0xECD3, 0xE4F2, 0xE4F2, 0xE4F2, 0xE4D3, 
        0xDCB1, 0xD490, 0xCC8F, 0xCC30, 0xD470, 0xDCB0, 0xDCD0, 0xDCD0, 0xDCD0, 0xDCD1, 0xDCD1, 0xE490, 0xDCB0, 0xDCB1, 0xDCB0, 0xD4AF, 0xD48F, 0xD46E, 0xD44E, 0xC42D, 0xC42E, 0xBC0D, 0xBC0D, 0xBBCD, 0xB3AC, 0xB3AB, 0xB3CA, 0xAB8C, 0xAB8B, 0xAB6A, 
        0xA32A, 0x9AE9, 0x92C7, 0x8AA6, 0x8AA6, 0x92C8, 0x92E8, 0x9B29, 0xA38A, 0xB3EB, 0xC42C, 0xCC4C, 0xC42C, 0x9348, 0x72C9, 0x6269, 0x5A49, 0x72EB, 0x7B4B, 0x7B2B, 0x72AB, 0x8B4E, 0xAC0E, 0xBCAF, 0xBD33, 0x9C54, 0xD297, 0xF9B8, 0xF996, 0xF9D6, 
        0xF996, 0xF9F7, 0xFA58, 0xF8F5, 0xF956, 0xF9D7, 0xFA38, 0xFA77, 0xFA38, 0xFA3A, 0xFA7B, 0xF9B7, 0xF9B8, 0xF9D9, 0xF9F9, 0xFA5A, 0xFA1A, 0xF9D8, 0xF996, 0xF976, 0xF996, 0xF176, 0xE955, 0xFA1A, 0xFA1A, 0xF9B8, 0xF0F3, 0xE0D4, 0xF1B9, 0xFA5D, 
        0xFA9F, 0xFA3D, 0xFA3D, 0xFA7B, 0xFA98, 0xF174, 0xE8F1, 0xE0CF, 0xD0ED, 0xA027, 0x8825, 0x8846, 0x9049, 0x8848, 0x8848, 0x9067, 0x9887, 0x8025, 0x8827, 0x8849, 0x9049, 0x9069, 0x8869, 0x9069, 0x906A, 0x906B, 0x9049, 0x8827, 0x6824, 0x7004, 
        0x6804, 0x6004, 0x6003, 0x7005, 0x7005, 0x7804, 0x8003, 0x7807, 0x8829, 0x988B, 0xA8ED, 0x8027, 0x7005, 0x7005, 0x7006, 0x6004, 0x5004, 0x5004, 0x5805, 0x7867, 0x7888, 0x88AA, 0xA0ED, 0x6026, 0x6005, 0x7006, 0x9028, 0x90AC, 0x90AC, 0x90CB, 
        0x90CC, 0xA92F, 0x908C, 0x7809, 0x7028, 0xB130, 0x98CD, 0x906B, 0x986D, 0xA12E, 0x7089, 0x6026, 0x7827, 0x884D, 0x906C, 0x906C, 0x904D, 0x88CC, 0x914F, 0x992F, 0xA0CB, 0xB914, 0x6089, 0x5887, 0xB1F0, 0xF73D, 0xFFDE, 0xFFDE, 0xFFDF, 0xFF7F, 
        0xFF9E, 0xFF9D, 0xF77D, 0xFF1B, 0xFEFB, 0xFEFB, 0xFEFB, 0xFF5B, 0xFF1A, 0xFEF8, 0xFED7, 0xF6B7, 0xD5B2, 0xBC6D, 0xC38A, 0xE6DA, 0x834C, 0x3942, 0x4203, 0xBC6F, 0x7A87, 0x4942, 0x4983, 0x7206, 0x61E3, 0x51C1, 0x6224, 0xBC4E, 0x9AEA, 0x79A6, 
        0x78E3, 0x922A, 0xB34E, 0xBBD0, 0xB3AF, 0xC410, 0xBC11, 0xC412, 0xD431, 0xCC31, 0xBBEF, 0xB3AD, 0xC38F, 0xC491, 0xAC0E, 0xABCD, 0xC40E, 0xC4F1, 0xB42F, 0xABAD, 0xABCE, 0xC40F, 0xAB4C, 0xAACC, 0xBA8E, 0x88EA, 0x99D0, 0xAA6F, 0x9A48, 0x7267, 
        0xA40B, 0xB50A, 0x94E4, 0x84C2, 0x7284, 0x78C6, 0x90A9, 0xBCED, 0x9448, 0x6A65, 0x6046, 0x880A, 0x886B, 0x808B, 0x808A, 0x884A, 0x886B, 0x908C, 0x988D,
  0x92D6, 0x92D6, 0x92D6, 0x9AD6, 0x92F7, 0x9AF7, 0x9AD7, 0x9AD7, 0x9AD7, 0x9AF8, 0x9AF8, 0x9AF7, 0x9AF7, 0x9AF7, 0x9B18, 0x9B18, 0x9AF8, 0xA319, 0xA31A, 0xA31A, 0x9AF8, 0x9B18, 0xA338, 0xA338, 0xA35A, 0xAB5A, 0xB359, 0xB358, 0xC435, 0xD4B5, 0xDCD5, 
        0xDC93, 0xDCB2, 0xCC51, 0xB3EF, 0xA36C, 0x8247, 0x7227, 0x6A26, 0x6A05, 0x5A25, 0x82C8, 0x9B4B, 0xABAE, 0xBC6F, 0xD4B1, 0xD4B3, 0xCC92, 0xD4D0, 0xD4B1, 0xD4B1, 0xDCF0, 0xDCD1, 0xDCF1, 0xDCF1, 0xDCD1, 0xD4D1, 0xDC91, 0xD470, 0xCC6F, 0xCBED, 
        0xBBAD, 0xB3AD, 0xB38C, 0xBC2E, 0xCC6D, 0xD4AE, 0xDCF1, 0xD4D0, 0xDCD0, 0xDCB0, 0xDCB0, 0xD48F, 0xDCB0, 0xD4B0, 0xCCB0, 0xDC8E, 0xD48E, 0xD46E, 0xD44E, 0xBC4E, 0xC42D, 0xC40C, 0xBBCD, 0xB3AB, 0xB3AC, 0xB3AC, 0xB38B, 0xAB8A, 0xAB69, 0xAB49, 
        0xAB29, 0x92C7, 0x92A7, 0x8AA7, 0x82A7, 0x82A8, 0x92A8, 0x9AE8, 0xA368, 0xCBEA, 0xCC4B, 0xC44B, 0xBBEA, 0x8B48, 0x830A, 0x7B0B, 0x730B, 0x7B6D, 0x7B8B, 0x7B6B, 0x7B4D, 0x8BED, 0x948D, 0x8CAD, 0x8C2D, 0xEC15, 0xFA37, 0xF957, 0xF996, 0xFA56, 
        0xF216, 0xF175, 0xF0D2, 0xF155, 0xF9D7, 0xFA17, 0xF9F8, 0xFA19, 0xF9F9, 0xFA1A, 0xFA7C, 0xF196, 0xF1D7, 0xF219, 0xFA1B, 0xFA19, 0xF9F9, 0xF1B8, 0xF155, 0xF176, 0xF197, 0xF196, 0xF195, 0xF1F9, 0xF1F9, 0xE135, 0xC850, 0xF196, 0xFA1A, 0xFA1D, 
        0xF9DE, 0xFA3C, 0xFA3C, 0xFA3D, 0xFA7D, 0xE976, 0xE0B3, 0xD04F, 0xC84C, 0xC8AA, 0xC089, 0xB069, 0x9827, 0x8825, 0x8845, 0x9065, 0x9064, 0x8825, 0x9027, 0x9007, 0x9027, 0x9049, 0x9068, 0x8868, 0x8029, 0x8829, 0x8807, 0x8025, 0x6823, 0x4800, 
        0x5800, 0x6822, 0x8086, 0xB90B, 0xA908, 0x90A5, 0x8023, 0x9888, 0xC9AF, 0xEA13, 0xE993, 0x9028, 0x7806, 0x7005, 0x6803, 0x3800, 0x3802, 0x4823, 0x5845, 0x5824, 0x5804, 0x5804, 0x5004, 0x4001, 0x6024, 0x7066, 0x70A5, 0x6025, 0x7066, 0x7866, 
        0x7827, 0x986B, 0x888B, 0x8049, 0x8027, 0x90AA, 0x908C, 0x884B, 0x8028, 0xA90F, 0xA0CD, 0x7869, 0x5825, 0x9088, 0x886A, 0x704A, 0x6049, 0x68A8, 0x80C9, 0x990D, 0xB970, 0xB151, 0x78C8, 0x8B0C, 0xEF5D, 0xFFFF, 0xFFDE, 0xFF9E, 0xFF7F, 0xFF7E, 
        0xFF5C, 0xFF3B, 0xFF1B, 0xF71B, 0xF6FB, 0xF6FA, 0xFF1A, 0xEED9, 0xEEB8, 0xF697, 0xFE97, 0xF6F7, 0xB46D, 0xB48F, 0xE6FA, 0x8348, 0x3943, 0x5A47, 0xCCF0, 0xA2CA, 0x5144, 0x30E2, 0x4983, 0x61E2, 0x7223, 0x8AA5, 0x9B49, 0x9B2A, 0x8227, 0x7145, 
        0x7945, 0xB2ED, 0xC390, 0xCC12, 0xDC33, 0xB3F1, 0xBBF0, 0xC3F0, 0xBC10, 0xD431, 0xD471, 0xD490, 0xCC8F, 0xB3AC, 0xBC0E, 0xBC0F, 0xB38D, 0xB3AF, 0xB38E, 0xBB8E, 0xC38F, 0xAACD, 0xB30D, 0xB2AC, 0x99C9, 0x89AA, 0x81E9, 0x81C8, 0x89C9, 0xAC68, 
        0x9CA5, 0x9D24, 0xAD85, 0x824A, 0x58C6, 0x6045, 0x9147, 0xBE2D, 0x8B89, 0x7108, 0x782A, 0xA04A, 0x8069, 0x7069, 0x7069, 0x7069, 0x7869, 0x886A, 0x904B,
  0x9AD7, 0x9AF7, 0x9AF7, 0x9AD7, 0x92F7, 0x9AF7, 0x9AF7, 0x9AD8, 0x92D7, 0x9AF8, 0x9AF8, 0x9B17, 0x9B18, 0x9B18, 0x9B18, 0x9B39, 0xA318, 0xA318, 0xA319, 0x9B19, 0xA31A, 0xA339, 0xA339, 0xA33A, 0xA33A, 0xA35A, 0xAB7A, 0xB378, 0xBBD5, 0xDC95, 0xECF5, 
        0xE4D4, 0xECF4, 0xDCD4, 0xD4B2, 0xD490, 0x9329, 0x7A66, 0x7205, 0x7225, 0x72A5, 0x7AE7, 0x8B29, 0x9B4B, 0xBC0F, 0xCC71, 0xD491, 0xD450, 0xD46F, 0xD46F, 0xDC70, 0xDC70, 0xD490, 0xD470, 0xD470, 0xD470, 0xDC70, 0xDC30, 0xDC10, 0xDBF0, 0xB3AD, 
        0xB3AD, 0xBB8E, 0xBBAE, 0xC44F, 0xCC6F, 0xD490, 0xDCB0, 0xDCD0, 0xDCD1, 0xE4D1, 0xE4D0, 0xD4AE, 0xD4AF, 0xDCD0, 0xDCF0, 0xD48E, 0xD48F, 0xD48F, 0xD46E, 0xD44D, 0xC44D, 0xBC2D, 0xBBCC, 0xBC0C, 0xB3CC, 0xB38C, 0xB38B, 0xABC9, 0xAB69, 0xA349, 
        0x9B29, 0x9AE6, 0x92C6, 0x92C6, 0x92C7, 0x8AC8, 0x92C8, 0x9B08, 0xAB68, 0xB3CA, 0xCC4B, 0xD46C, 0xCC2B, 0x9B88, 0x8B49, 0x830B, 0x7AED, 0x7B4C, 0x8B8D, 0x93AC, 0x93AC, 0x93CD, 0x9C4E, 0x8C6D, 0x7C2C, 0xDC36, 0xF259, 0xF958, 0xF975, 0xF9D4, 
        0xF194, 0xF175, 0xF198, 0xFA79, 0xFA7A, 0xFA38, 0xFA16, 0xFA1A, 0xFA3B, 0xFA3A, 0xFA58, 0xF9B7, 0xF1F8, 0xF219, 0xFA1A, 0xFA9B, 0xF218, 0xF196, 0xF135, 0xE914, 0xF156, 0xF9B6, 0xF1F6, 0xF177, 0xE936, 0xE8F4, 0xE092, 0xF915, 0xF999, 0xFA1B, 
        0xFA3B, 0xFA1D, 0xFA1C, 0xFA1B, 0xFA3B, 0xFA7D, 0xFA18, 0xF194, 0xE8D1, 0xD0AE, 0xB88B, 0xB08B, 0xB8AB, 0x9829, 0x9848, 0x9848, 0x9828, 0x90C7, 0x9087, 0x9048, 0x9049, 0x9889, 0x9089, 0x9069, 0x9049, 0x9828, 0x9047, 0x8045, 0x6002, 0x6862, 
        0x98E9, 0xC16D, 0xD98D, 0xB0EB, 0x9888, 0x8844, 0x8003, 0xA069, 0xD151, 0xF1B6, 0xF997, 0xE9B3, 0xB94D, 0x90A7, 0x6001, 0x3000, 0x5063, 0x70A5, 0x80C6, 0x6824, 0x6025, 0x6024, 0x7024, 0x80C8, 0x7887, 0x7066, 0x7866, 0x7867, 0x7025, 0x6805, 
        0x6827, 0x884A, 0x802A, 0x8029, 0x7828, 0x888B, 0x908C, 0x886A, 0x7848, 0xA8CE, 0xA0CE, 0x908B, 0x7027, 0x8088, 0x7889, 0x806B, 0x806B, 0x4805, 0x6867, 0x992C, 0xCA32, 0x984F, 0x906C, 0xB311, 0xF75D, 0xFFDF, 0xFFDF, 0xFF9F, 0xFF7E, 0xFF5E, 
        0xFF7D, 0xFF7D, 0xFF3C, 0xFF5B, 0xFF3B, 0xFF3B, 0xFF3A, 0xFED9, 0xF6B8, 0xF6B8, 0xFED8, 0xE635, 0xCD0E, 0xCD92, 0xDEDA, 0x2104, 0x2962, 0x6B88, 0xC5CF, 0x8A88, 0x6104, 0x58E3, 0x69E5, 0x6AA6, 0x9349, 0xA36A, 0x9B4A, 0xBBED, 0xA36B, 0x82A8, 
        0x69E6, 0x89C8, 0x924B, 0xB34F, 0xDC94, 0xE474, 0xD452, 0xCC52, 0xCC52, 0xD452, 0xDC72, 0xDC92, 0xD471, 0xAB8D, 0xC3CE, 0xC3CE, 0xB38D, 0xCC30, 0xC3CF, 0xBBAF, 0xC410, 0xE472, 0xD431, 0xB3AE, 0x9B0B, 0xAB0F, 0x92AA, 0x69A6, 0x5064, 0x9189, 
        0xC3CD, 0xC4EC, 0x94C6, 0x6C02, 0x61C3, 0x6044, 0x70A7, 0xD491, 0xAC8C, 0x72C6, 0x5864, 0x884A, 0x786A, 0x7069, 0x706A, 0x7849, 0x7049, 0x7849, 0x8049,
  0x92F7, 0x9AF7, 0x9AF7, 0x92F7, 0x9B18, 0x9B18, 0x9AF7, 0x9AF8, 0x9AF7, 0x9AF7, 0x9B18, 0x9B38, 0x9B18, 0xA318, 0xA338, 0x9B38, 0x9B17, 0xA318, 0x9B1A, 0x9B1A, 0xAB59, 0xAB5A, 0xAB5A, 0xA37A, 0xA33A, 0xA33B, 0xAB7B, 0xB3B9, 0xB3D6, 0xD455, 0xECD5, 
        0xFD35, 0xF554, 0xF534, 0xED14, 0xDCD3, 0xD42E, 0xAB4B, 0x8288, 0x61E4, 0x7A65, 0x7AA6, 0x8308, 0x938A, 0xB3F1, 0xB430, 0xBC6F, 0xC48F, 0xC42E, 0xCC4F, 0xCC50, 0xBC50, 0xD430, 0xD410, 0xD3F0, 0xC3CF, 0xBB8F, 0xBB6F, 0xBB8F, 0xB3AD, 0xAB2C, 
        0xA30B, 0xA32B, 0xAB6C, 0xC40E, 0xC44F, 0xD490, 0xE4D0, 0xE4F1, 0xE4F1, 0xE4F0, 0xE4CF, 0xD4D0, 0xDCD1, 0xDCD0, 0xDCD0, 0xDC8F, 0xD48F, 0xDC8E, 0xDC6E, 0xC42D, 0xC44E, 0xC44E, 0xC42E, 0xBBED, 0xBBCC, 0xB3CB, 0xB3AA, 0xABAA, 0xABAA, 0xAB69, 
        0xA327, 0x9AC8, 0x92E7, 0x92E8, 0x92CA, 0x92C8, 0x8AA9, 0x8AA9, 0x92E9, 0xBB8B, 0xCC0B, 0xD44B, 0xC46B, 0xABCB, 0x934A, 0x830A, 0x7B0B, 0x734D, 0x8B8D, 0x8BCD, 0x840D, 0xA450, 0x9CB0, 0x7C8F, 0x63EF, 0xEBB7, 0xF9D8, 0xF977, 0xFA95, 0xF933, 
        0xFA19, 0xFABC, 0xFAFB, 0xFA7B, 0xFA58, 0xFA58, 0xFA3A, 0xFA5B, 0xFA59, 0xFA39, 0xFA3B, 0xFA16, 0xFA18, 0xFA3A, 0xFA5B, 0xFA1B, 0xF9B7, 0xF155, 0xE914, 0xE0F4, 0xF135, 0xF976, 0xF996, 0xF115, 0xE8D4, 0xE893, 0xE892, 0xF955, 0xF997, 0xF9B9, 
        0xF9DB, 0xFA5A, 0xFA5D, 0xFA3D, 0xFA5B, 0xFA7D, 0xFA7D, 0xFA5A, 0xF215, 0xF10F, 0xE0EE, 0xD0ED, 0xB8AC, 0xB048, 0xB068, 0xB089, 0xB0AA, 0xB0CC, 0xB0CB, 0xA8AA, 0xA0A9, 0xA04B, 0xA049, 0xA069, 0xA0AA, 0xA028, 0x9007, 0x9006, 0xA888, 0xEA71, 
        0xE1F1, 0xB90E, 0x902A, 0x8001, 0x8802, 0x8003, 0x8023, 0xB0EA, 0xD970, 0xE111, 0xD050, 0xE114, 0xE112, 0xD0EF, 0xB0CD, 0x9069, 0x90CA, 0x98C9, 0x9866, 0x6823, 0x7885, 0x90C9, 0x98CC, 0x88A7, 0x8067, 0x8869, 0x908B, 0x888A, 0x7047, 0x7868, 
        0x90EB, 0x7025, 0x7825, 0x7846, 0x7866, 0x7025, 0x908A, 0x888A, 0x7026, 0x908D, 0x98AD, 0x908C, 0x904A, 0x8029, 0x90CC, 0x88CB, 0x6868, 0x6803, 0x7868, 0x90CD, 0xA12E, 0x28A4, 0xA454, 0xF6FE, 0xFFDF, 0xFF3E, 0xFF9F, 0xFFDF, 0xFFBE, 0xFF9F, 
        0xFF9F, 0xFF9F, 0xFF9F, 0xFF9D, 0xFF9D, 0xFF7C, 0xFF3B, 0xFEB9, 0xFEB8, 0xFF19, 0xF759, 0xD4EF, 0xDDB4, 0xEEDA, 0xDEF9, 0x2924, 0x5AA5, 0xAC6B, 0xDCB0, 0x8146, 0x58A2, 0x5165, 0x72CA, 0x8A84, 0x9AE7, 0xC40E, 0xED53, 0xA3AC, 0xABCD, 0xABCD, 
        0xA34C, 0x9A8B, 0xA26C, 0x9A0B, 0x89AA, 0xCC11, 0xDC93, 0xDC94, 0xCC53, 0xD492, 0xDC92, 0xDC72, 0xCC50, 0xBBEE, 0xBBCE, 0xC3CE, 0xBBF0, 0xAB4E, 0xBB8E, 0xB38E, 0xAB0D, 0xBB51, 0xAB8E, 0x9B6D, 0xA32E, 0xDC52, 0xD491, 0xCC51, 0xB32F, 0x38C2, 
        0x7384, 0xA5A7, 0xB5A9, 0x92C9, 0x8129, 0x7848, 0x68A5, 0x8CA6, 0xB50D, 0xA34D, 0x6867, 0x808B, 0x806B, 0x806A, 0x788A, 0x784A, 0x786A, 0x7869, 0x8049,
  0x9AD7, 0x9AD7, 0x92D6, 0x92F6, 0x9AF8, 0x9AF8, 0x9AF8, 0xA2F8, 0x9AD8, 0x9AF8, 0x9AF8, 0x9AD8, 0x9B18, 0x9B17, 0x9B18, 0xA31A, 0xA339, 0xA319, 0xA319, 0xA339, 0x9B39, 0xA339, 0xA339, 0xA33A, 0xA33A, 0xA33A, 0xAB5A, 0xB37B, 0xBBB7, 0xD475, 0xE4F4, 
        0xE533, 0xF554, 0xED54, 0xE534, 0xE4F4, 0xD512, 0xBC2E, 0x9B2A, 0x7A87, 0x6A27, 0x6A46, 0x7267, 0x82CB, 0xA3AB, 0xA3AD, 0xABAD, 0xB3AC, 0xAB4B, 0xAB6B, 0xAB4C, 0xAB0C, 0xAB0D, 0xAB2C, 0xAB0C, 0xAAEC, 0xA28B, 0xA28B, 0xA28A, 0x9A69, 0xAAAB, 
        0xB30C, 0xBB6D, 0xC40F, 0xCCAF, 0xD4B0, 0xD4D1, 0xDCD0, 0xE4F1, 0xDCD0, 0xD4D0, 0xD4D0, 0xD4B1, 0xD4CF, 0xD4AF, 0xCC8F, 0xD4AE, 0xD4AE, 0xD48E, 0xCC6D, 0xCC4D, 0xC42D, 0xC40E, 0xBBEE, 0xBBCB, 0xB3AB, 0xB3AA, 0xB389, 0xAB69, 0xA349, 0x9B28, 
        0x9AE7, 0x8A86, 0x8AA6, 0x8AA6, 0x8AA6, 0x9B2B, 0x9B2A, 0xA34A, 0xAB69, 0xBBEA, 0xD44B, 0xDC8C, 0xE4CC, 0xB46B, 0x9B6A, 0x8AE9, 0x72E9, 0x6AEB, 0x7B6D, 0x8C0E, 0x946F, 0x942F, 0x844D, 0x5BC9, 0x4327, 0xE456, 0xFA98, 0xF957, 0xF155, 0xF9FA, 
        0xFA3A, 0xFA19, 0xF998, 0xF1F7, 0xF1F8, 0xF9F9, 0xF9D8, 0xF1D8, 0xF1B8, 0xF1B7, 0xF1F7, 0xF1FA, 0xF1FA, 0xF219, 0xFA18, 0xF177, 0xE976, 0xE955, 0xE914, 0xE114, 0xE935, 0xE936, 0xE936, 0xF114, 0xE0F3, 0xE0D3, 0xE0D3, 0xF956, 0xF9B8, 0xF1D8, 
        0xF198, 0xF9BB, 0xF9FA, 0xFA1A, 0xFA1B, 0xF9FE, 0xFA3E, 0xFA1B, 0xF198, 0xE934, 0xE0F0, 0xD88E, 0xC82C, 0xA849, 0xA84A, 0xB06C, 0xB88D, 0xC08B, 0xB06A, 0xA86A, 0xA84A, 0xA828, 0xA829, 0xA049, 0x9047, 0x7823, 0xA088, 0xD14E, 0xF211, 0xC90C, 
        0x9867, 0x8805, 0xA828, 0xC94C, 0xD18E, 0xC96E, 0xD12D, 0xE9F1, 0xE953, 0xE114, 0xE154, 0xE0F2, 0xE153, 0xE953, 0xE90F, 0xB8AC, 0xA06A, 0x8848, 0x8026, 0x8888, 0x9069, 0x9869, 0x986B, 0x8088, 0x7867, 0x8068, 0x908A, 0x88CA, 0x8888, 0x8889, 
        0x90EA, 0x5823, 0x6044, 0x6845, 0x6805, 0x7045, 0x8068, 0x7868, 0x6007, 0x9049, 0x988B, 0x98AC, 0x888B, 0x8028, 0x8069, 0x7869, 0x6027, 0x78C9, 0x7888, 0x5025, 0x2843, 0xE2F4, 0xFE1B, 0xFF7E, 0xFF3E, 0xFFDF, 0xFFDE, 0xFFBE, 0xFFBF, 0xFFBE, 
        0xFFBE, 0xFFBE, 0xFFBE, 0xFF7C, 0xFF5C, 0xF73B, 0xF6FA, 0xF698, 0xF697, 0xF6D9, 0xF6D9, 0xBC8D, 0xD636, 0xA4F3, 0x20C2, 0x1181, 0x6BEB, 0xA4AE, 0xA329, 0x7082, 0x7104, 0x71C7, 0x7A48, 0x8AC9, 0xB44D, 0xCCCF, 0xC3ED, 0xAB8D, 0xABAC, 0xAB6C, 
        0xAACC, 0x8208, 0x9208, 0xA26B, 0xB2EE, 0xCBD2, 0xDC53, 0xDC73, 0xCC32, 0xD494, 0xDC74, 0xD432, 0xC40F, 0xC3EE, 0xB38D, 0xB34D, 0xC36D, 0xB3AD, 0xB32C, 0xB32D, 0xB38D, 0xAACE, 0xAACD, 0xA2EA, 0x9B2A, 0xED19, 0xE516, 0xC3CF, 0x91E8, 0xBA4E, 
        0xD3B0, 0xCCEE, 0x9D49, 0x4942, 0x4843, 0x6806, 0x9089, 0xE492, 0x9C09, 0x5A63, 0x4864, 0x884C, 0x986B, 0x906A, 0x706B, 0x7829, 0x7849, 0x7869, 0x7869,
  0x9AF7, 0x9AF7, 0x9B17, 0x9B17, 0x92D7, 0x9AF8, 0x9AF8, 0x9AF8, 0x9AF7, 0x9B18, 0x9AF8, 0xA2F8, 0x9B38, 0x9B17, 0xA318, 0xA339, 0x9B1A, 0xA319, 0xA339, 0xA33A, 0xA339, 0xA33A, 0xA35A, 0xA35A, 0xA35A, 0xAB3A, 0xAB3B, 0xB37B, 0xBBD8, 0xC415, 0xD453, 
        0xE4D1, 0xED74, 0xF574, 0xFD74, 0xF576, 0xE515, 0xCC72, 0xB3CE, 0x9B09, 0x6A05, 0x6A26, 0x7268, 0x82AA, 0x932F, 0xA370, 0xB370, 0xB32E, 0xAACB, 0xB2CB, 0xAACC, 0xA2CC, 0xB30D, 0xAAED, 0xA2CC, 0xAAAB, 0xA26A, 0xA26B, 0xA28B, 0xAAAC, 0xB30C, 
        0xBB8E, 0xC3EF, 0xD42F, 0xCCB1, 0xD4D1, 0xDCD1, 0xE4B1, 0xDCF1, 0xDCD0, 0xDCD0, 0xDCD0, 0xDCB0, 0xD4B0, 0xD4AF, 0xD4CF, 0xD4AF, 0xD48F, 0xD48E, 0xD46D, 0xBC4D, 0xC42D, 0xC42E, 0xC44E, 0xBBCC, 0xBBCB, 0xB3CB, 0xB3CA, 0xA369, 0x9B28, 0x9B08, 
        0x92E8, 0x82A6, 0x82A6, 0x8AC7, 0x8AC9, 0x9B2C, 0xA36D, 0xAB6E, 0xB38E, 0xBBED, 0xCC6C, 0xE4CD, 0xF52F, 0xD4CE, 0xA3EA, 0x8348, 0x8309, 0x730B, 0x7B4B, 0x73AC, 0x6C2D, 0x9C2E, 0x840D, 0x638B, 0x5B09, 0xE3D6, 0xF9D7, 0xF916, 0xF236, 0xFA5B, 
        0xF177, 0xF134, 0xE9B6, 0xF1B8, 0xF9B8, 0xF198, 0xF157, 0xF156, 0xF156, 0xF156, 0xF156, 0xFA1B, 0xFA5B, 0xFA19, 0xF9B8, 0xF196, 0xE955, 0xE934, 0xE934, 0xE8F4, 0xE914, 0xE8F4, 0xE8D4, 0xF134, 0xF114, 0xE8F4, 0xE914, 0xF135, 0xF977, 0xF9B7, 
        0xF1B6, 0xF159, 0xF19C, 0xF9FE, 0xFA3D, 0xFA5F, 0xFA7F, 0xFA5E, 0xFA1C, 0xF155, 0xE911, 0xE110, 0xE12F, 0xC887, 0xA825, 0xA024, 0xA026, 0xB04C, 0xB04A, 0xB027, 0xA826, 0xB06A, 0xA027, 0x8803, 0x7022, 0xC12C, 0xE1F1, 0xE9B1, 0xD0AD, 0x8024, 
        0xA0E8, 0xD1EE, 0xF2B4, 0xFA34, 0xF235, 0xEA55, 0xE234, 0xF974, 0xF995, 0xF9D6, 0xF9D7, 0xFA57, 0xFA58, 0xFA59, 0xFA38, 0xE912, 0xC06D, 0x9008, 0x7005, 0x9089, 0x9089, 0x9069, 0x9849, 0x90C9, 0x8068, 0x7847, 0x8048, 0x8888, 0x7847, 0x8027, 
        0x8848, 0x6004, 0x6004, 0x7026, 0x8047, 0x7086, 0x7886, 0x7867, 0x7028, 0x788A, 0x90AB, 0x988B, 0x906B, 0x90AB, 0x8069, 0x7827, 0x7046, 0x7049, 0x6826, 0x68A5, 0x8A29, 0xEE5C, 0xFF9F, 0xFFDF, 0xFFBF, 0xFFBF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 
        0xFFDF, 0xFFDF, 0xFFDF, 0xFFBE, 0xFF5C, 0xF73B, 0xFF1A, 0xF6B8, 0xFED9, 0xF6D9, 0xEE55, 0xE552, 0xEE98, 0x9D13, 0x1923, 0x4A04, 0x8AC9, 0xB30B, 0xBA8B, 0x78C3, 0x6905, 0x79E7, 0x8AA9, 0x8AC8, 0xBBED, 0xDCB1, 0xDCD1, 0xB36C, 0xBC0F, 0xCC70, 
        0xC40E, 0xA2EC, 0x8A09, 0x8187, 0x8147, 0xA20C, 0xBB50, 0xDC95, 0xF578, 0xD473, 0xD452, 0xCC31, 0xBBCF, 0xC3CF, 0xCBEE, 0xBBAD, 0xA30C, 0x9249, 0x8A28, 0x8227, 0x8A68, 0xA28C, 0xC3AF, 0xD450, 0xD471, 0xE4F7, 0xCC72, 0xBB4E, 0xAA0C, 0x9A89, 
        0x9BC9, 0xAD2B, 0xBD8D, 0x6966, 0x6846, 0x7006, 0x88A7, 0xA4EA, 0x9C8A, 0x82A9, 0x6068, 0x8069, 0x886A, 0x906B, 0x886B, 0x884A, 0x8049, 0x8069, 0x786A,
  0x92F7, 0x9B17, 0x9B17, 0x9AF8, 0x9B18, 0x9B18, 0x9AF7, 0x9B17, 0x9B18, 0x9B18, 0x9B18, 0xA338, 0xA338, 0xA339, 0xA339, 0x9B3A, 0xA31A, 0xA33A, 0xA33A, 0xA33A, 0xA33A, 0xA35A, 0xAB7B, 0xAB7B, 0xAB7B, 0xA35B, 0xA33B, 0xAB7C, 0xBBD9, 0xC3F5, 0xCC12, 
        0xDC4F, 0xE4F2, 0xF554, 0xF575, 0xF575, 0xED15, 0xDCD3, 0xC471, 0xABCE, 0x7267, 0x7248, 0x726A, 0x82AB, 0x930D, 0x9B4F, 0x9B50, 0x9AEF, 0x9A8B, 0x926A, 0x9A6A, 0xAA6C, 0xB28D, 0xB28D, 0xAA8D, 0xA26D, 0xA24B, 0xA24C, 0xA26B, 0xA2AA, 0xB38D, 
        0xCBD0, 0xD431, 0xDC91, 0xE4D2, 0xDCF1, 0xDCF1, 0xE4B1, 0xE4D0, 0xDCD0, 0xDCD1, 0xDCD1, 0xDCCF, 0xDCD0, 0xDCD0, 0xD4D0, 0xDCAF, 0xDC8E, 0xD48E, 0xCC8E, 0xD42D, 0xCC2E, 0xC42E, 0xCC2D, 0xBBED, 0xC3EC, 0xBC0B, 0xB3E9, 0xA369, 0xA36A, 0xA36A, 
        0x9B0A, 0x8AA8, 0x82C8, 0x82C7, 0x8AA7, 0x9B0C, 0xA38D, 0xABEE, 0xABF0, 0xBC0E, 0xD44E, 0xECCE, 0xFD4F, 0xFD90, 0xDD2F, 0xAC6D, 0x736A, 0x6ACA, 0x7AEC, 0x836C, 0x7BED, 0x840F, 0x8C10, 0x6BAD, 0x434A, 0xCC36, 0xEA38, 0xF937, 0xF9B5, 0xFA5C, 
        0xFA39, 0xF1B5, 0xF132, 0xF996, 0xF996, 0xF975, 0xF976, 0xF936, 0xF976, 0xF976, 0xF936, 0xFA3D, 0xFA7C, 0xFA19, 0xF977, 0xF977, 0xE914, 0xE8F3, 0xF134, 0xF154, 0xE914, 0xE8F4, 0xF114, 0xE8F4, 0xF0F4, 0xE8F3, 0xE8F3, 0xF157, 0xF998, 0xF9D8, 
        0xF9D8, 0xF99A, 0xF9D9, 0xFA39, 0xFABB, 0xFADC, 0xFA9E, 0xFA5E, 0xFA3D, 0xF9F9, 0xF156, 0xF134, 0xF192, 0xD8CE, 0xC88D, 0xB049, 0x9003, 0x8004, 0x7803, 0x8803, 0x9845, 0x9086, 0x7043, 0x80C5, 0xD9EE, 0xF2D6, 0xE131, 0xB02A, 0x8027, 0xE971, 
        0xFA96, 0xF255, 0xE931, 0xE0D1, 0xE111, 0xE111, 0xE0B2, 0xE0B2, 0xE8F2, 0xF193, 0xFA36, 0xFA38, 0xFA5A, 0xFA7A, 0xFA78, 0xFA35, 0xF1D2, 0xD92F, 0xA86A, 0x9026, 0x9087, 0x9089, 0x904A, 0x9889, 0x9068, 0x8848, 0x8068, 0x8828, 0x90AA, 0x88A8, 
        0x6824, 0x78A6, 0x7045, 0x7066, 0x80C8, 0x7844, 0x7025, 0x7047, 0x7047, 0x7805, 0x8849, 0x906A, 0x904A, 0x90AC, 0x806A, 0x7828, 0x8028, 0x7889, 0x6065, 0x8A0B, 0xED7C, 0xFFBF, 0xFFBE, 0xFFBE, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 
        0xFFFF, 0xFFDF, 0xFFBF, 0xFF7D, 0xFF7D, 0xFF5C, 0xFF1B, 0xF6FB, 0xFF3A, 0xEE55, 0xD4F0, 0xF75C, 0xD639, 0x7B8E, 0x18C2, 0x4AE5, 0x7B49, 0xA2EB, 0xC22C, 0x8884, 0x70A4, 0x7167, 0x826B, 0x8228, 0x930A, 0xC48F, 0xF5D5, 0xDC30, 0xBBEE, 0xC470, 
        0xED14, 0xBB8F, 0xAB0C, 0x9AAB, 0x922A, 0x91E9, 0x89A9, 0x9A0B, 0xBB30, 0xF536, 0xECD5, 0xDC53, 0xCBF0, 0xABAE, 0xC3F0, 0xCBF0, 0xBB8E, 0xC3CE, 0xCBAE, 0xBB4E, 0xAB2D, 0xDC70, 0xECD3, 0xF4D4, 0xF474, 0xB370, 0xA30D, 0x9ACD, 0x8A4D, 0x80A3, 
        0xB36C, 0xBD2E, 0x94A8, 0x58A5, 0x7049, 0x7849, 0x7867, 0xAB0B, 0xACCC, 0x83C9, 0x4882, 0x882B, 0x886B, 0x888A, 0x908B, 0x886B, 0x886B, 0x886B, 0x804A,
  0x9AF7, 0x9AF7, 0x9AF8, 0x9AF8, 0x9AF7, 0x9AF8, 0xA2F8, 0x9AF8, 0x9AF8, 0x9AF8, 0x9AF8, 0x9AF9, 0x9B38, 0x9B18, 0x9AF8, 0xA319, 0xA339, 0xA339, 0xA33A, 0xA31A, 0xA339, 0xA339, 0xA33A, 0xA35A, 0xA35A, 0xA33A, 0xAB3B, 0xB35C, 0xBBB9, 0xBBD7, 0xC414, 
        0xCC51, 0xDCB1, 0xE4D2, 0xED12, 0xED33, 0xE534, 0xD492, 0xC410, 0xB38D, 0x6A47, 0x6206, 0x7227, 0x8A8A, 0x92EE, 0x9AEF, 0x9ACF, 0x928D, 0x99EB, 0x99CA, 0xA1EA, 0xB22B, 0xB26C, 0xB28D, 0xB28E, 0xB26D, 0xB28D, 0xB2CC, 0xC32D, 0xCB90, 0xD451, 
        0xE492, 0xE4B2, 0xE4D2, 0xDD32, 0xDD12, 0xDCF2, 0xDCB1, 0xDCCF, 0xDCCF, 0xDCCF, 0xDCAF, 0xCCAF, 0xD4AF, 0xD4AF, 0xCCCE, 0xD48F, 0xD48E, 0xD48E, 0xD46E, 0xC44D, 0xC40D, 0xBC0D, 0xBC2C, 0xB3EC, 0xB3CB, 0xB3CB, 0xA3A9, 0xA2E7, 0x8AA6, 0x8286, 
        0x7A47, 0x7A45, 0x7A65, 0x7AA8, 0x82EB, 0xABAE, 0xBC31, 0xC472, 0xD472, 0xDC91, 0xED52, 0xF592, 0xFD91, 0xFE75, 0xF613, 0xDD70, 0xB48C, 0x8BCB, 0x834B, 0x732A, 0x6B0A, 0x72EA, 0x6AE9, 0x5AC8, 0x5B08, 0xE416, 0xFA77, 0xF976, 0xF9B8, 0xFA3D, 
        0xFA39, 0xF1F5, 0xF172, 0xE112, 0xE932, 0xE953, 0xE955, 0xF1B8, 0xF9D8, 0xF1BA, 0xF19B, 0xF218, 0xFA19, 0xFA1A, 0xF1D8, 0xD8B4, 0xD8B3, 0xE0F3, 0xE933, 0xE933, 0xE8F3, 0xE8F3, 0xE0F3, 0xD8B2, 0xE0D3, 0xF154, 0xF1B6, 0xF198, 0xF198, 0xF997, 
        0xF976, 0xF157, 0xF97A, 0xF9FC, 0xFABD, 0xFA5E, 0xFA1C, 0xFA1C, 0xFA3C, 0xF9B7, 0xF156, 0xE935, 0xE113, 0xE912, 0xD8EE, 0xC88B, 0xB828, 0x8004, 0x7802, 0x7802, 0x7802, 0x5021, 0x9929, 0xD270, 0xF314, 0xC86C, 0x9806, 0xA027, 0xE0B0, 0xFADA, 
        0xE974, 0xD88F, 0xC86C, 0xE0D2, 0xE112, 0xE112, 0xE0F2, 0xE0F2, 0xE933, 0xF175, 0xF1F5, 0xF9F7, 0xFA19, 0xFA3A, 0xFA3A, 0xFA5A, 0xF1B6, 0xE112, 0xD06C, 0x8806, 0x8827, 0x9089, 0x98CA, 0x9027, 0x8848, 0x9068, 0x8868, 0x8828, 0x988B, 0x8889, 
        0x5824, 0x7085, 0x7865, 0x7866, 0x7088, 0x6002, 0x6823, 0x7045, 0x7887, 0x6825, 0x7847, 0x8048, 0x8028, 0x906A, 0x8869, 0x7867, 0x7046, 0x6029, 0x80AB, 0xBB12, 0xF6FD, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFBF, 0xFFDF, 0xFFDF, 0xFFBF, 0xFFBF, 0xFFDF, 
        0xFFDF, 0xFFBE, 0xFF9E, 0xFF5B, 0xFF5B, 0xFF3B, 0xF71A, 0xF677, 0xEE56, 0xE5F5, 0xE5B3, 0xEF1B, 0x6B2B, 0x1901, 0x2181, 0x92C8, 0xB28B, 0xBA2B, 0xA189, 0x5862, 0x6925, 0x71A8, 0x71A7, 0x8267, 0xC44F, 0xED34, 0xE4F4, 0xC3CD, 0xD451, 0xDC92, 
        0xD42F, 0xBB2E, 0xAACB, 0x9A6A, 0x89E8, 0x89A8, 0xAA4C, 0xC2EF, 0xD3D2, 0xED15, 0xDC73, 0xC3D0, 0xBB4D, 0xD411, 0xCBF0, 0xC3CE, 0xCBAD, 0xC3EF, 0xCC31, 0xCC10, 0xB3ED, 0xD471, 0xCBF2, 0xCBB1, 0xCB8E, 0xAB4E, 0xBB8E, 0x8A69, 0x38A3, 0xCB6F, 
        0xE552, 0xAC6C, 0x4922, 0x4825, 0x7048, 0x884A, 0x88AA, 0xB4CB, 0x9429, 0x7A47, 0x6847, 0x7849, 0x8889, 0x908A, 0x906B, 0x806B, 0x886A, 0x886A, 0x7049,
  0x9AF8, 0x9AF8, 0x9AF8, 0x92F8, 0xA2F8, 0x9AF8, 0x9AF8, 0x9AF8, 0x9AF8, 0x9AF7, 0x9AF9, 0x9AFB, 0x9B36, 0x9B17, 0xA319, 0xA31A, 0xA33A, 0xA33A, 0xA33A, 0xA339, 0xA33A, 0xA35A, 0xA35A, 0xA35A, 0xA35A, 0xAB5A, 0xAB3B, 0xA33B, 0xAB9B, 0xC418, 0xD456, 
        0xDC73, 0xDC91, 0xDCB1, 0xE4F1, 0xE513, 0xDD13, 0xCC91, 0xBC0E, 0xA38C, 0x82A8, 0x7247, 0x7248, 0x8A8A, 0x8AEE, 0x9AEE, 0x9AEE, 0x9AAD, 0xA20D, 0xA9AB, 0xA9EB, 0xB28D, 0xB26D, 0xB28D, 0xB2AE, 0xB2AE, 0xBAAC, 0xC30E, 0xBBAF, 0xBC2F, 0xD491, 
        0xDCB0, 0xDCD1, 0xDCF1, 0xE531, 0xDCF1, 0xDCD1, 0xE4D1, 0xDCAF, 0xDCCF, 0xDCCF, 0xDCCF, 0xD4AF, 0xD4AF, 0xD4AF, 0xCCAF, 0xD48F, 0xD48E, 0xD48D, 0xCC8C, 0xBC2E, 0xC42D, 0xC42C, 0xC40C, 0xB3CB, 0xB3AA, 0xB36A, 0xAB28, 0x7AE5, 0x72A7, 0x7267, 
        0x7245, 0x72A6, 0x7AC8, 0x7AE9, 0x8B0A, 0xAB8D, 0xB410, 0xC452, 0xD453, 0xD413, 0xE4F2, 0xF591, 0xFD91, 0xFE33, 0xF632, 0xE5CF, 0xCCCC, 0x8B8A, 0x836B, 0x7B6B, 0x6329, 0x5B29, 0x6B09, 0x62E9, 0x52E9, 0xCCB4, 0xEB17, 0xF9D8, 0xF99A, 0xFA5C, 
        0xFA5B, 0xFA18, 0xF193, 0xE0B0, 0xE0D0, 0xE912, 0xE934, 0xF1D6, 0xF9F8, 0xF1D8, 0xF1D8, 0xF9F9, 0xFA1B, 0xFA1A, 0xF9B6, 0xE0F2, 0xE0D2, 0xE0F2, 0xE8F2, 0xE933, 0xE0F3, 0xE0B3, 0xE0B3, 0xF0F3, 0xF155, 0xF9B6, 0xF9F8, 0xF136, 0xF135, 0xF115, 
        0xF0F4, 0xF133, 0xF114, 0xF957, 0xF9DC, 0xFA5E, 0xFA3D, 0xFA3C, 0xFA1B, 0xF9F7, 0xF156, 0xF115, 0xE935, 0xE912, 0xE151, 0xE130, 0xD8AD, 0xC086, 0xA085, 0x8063, 0x6821, 0xB0A4, 0xE2B1, 0xF2B5, 0xD8AD, 0x8824, 0xB0A9, 0xD9D2, 0xF2DA, 0xE8B1, 
        0xD88F, 0xD0D0, 0xD8F0, 0xE0F0, 0xE131, 0xE132, 0xD912, 0xE912, 0xE133, 0xE953, 0xF173, 0xF9F6, 0xFA18, 0xFA1A, 0xFA3A, 0xFA1C, 0xFA3B, 0xF9F7, 0xE931, 0x9027, 0x8806, 0x9026, 0x9067, 0x9049, 0x9869, 0x9888, 0x9088, 0x9868, 0x9889, 0x8068, 
        0x6805, 0x6043, 0x70A4, 0x7085, 0x6826, 0x6003, 0x8066, 0x8867, 0x7846, 0x6825, 0x7867, 0x8068, 0x7007, 0x802A, 0x9089, 0x88A7, 0x7886, 0x706A, 0x6047, 0x91AB, 0xEC76, 0xFF9E, 0xFFDF, 0xFFBF, 0xFFBF, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 
        0xFFDF, 0xFFDF, 0xFFBE, 0xFF3B, 0xFF3B, 0xF71A, 0xF6DA, 0xFED8, 0xF615, 0xF677, 0xFFBC, 0xE6FB, 0x5AEB, 0x1983, 0x3B04, 0x9308, 0xAA29, 0xB18A, 0xB14B, 0x6062, 0x58E4, 0x6165, 0x71C6, 0xA2AC, 0xD431, 0xED55, 0xF5B6, 0xCB90, 0xCBF1, 0xDC72, 
        0xDC93, 0xCBAE, 0xAAEC, 0xA2CB, 0xAACB, 0x9A09, 0x91E9, 0x99EA, 0xA20C, 0xC34F, 0xD3F2, 0xDC12, 0xCBD0, 0xD433, 0xD432, 0xCC31, 0xC431, 0xF596, 0xF536, 0xDCB4, 0xC431, 0xBB8D, 0xC3B0, 0xC391, 0xBB0D, 0xB3AD, 0xBB4E, 0x820A, 0x20A3, 0xABED, 
        0xDC6F, 0xA30A, 0x2882, 0x58E4, 0x7866, 0x902A, 0xA88F, 0xB370, 0x9C4B, 0x6AE5, 0x4062, 0x884A, 0x8869, 0x8089, 0x908B, 0x904B, 0x882B, 0x802A, 0x784A,
  0x9B18, 0xA318, 0xA318, 0x9AF7, 0x9B19, 0x9B18, 0x9B18, 0x9B18, 0xA318, 0xA338, 0x9B38, 0xA318, 0xA33A, 0xA35A, 0xA339, 0xA33A, 0xA33A, 0xA33A, 0xA33A, 0xA35B, 0xA359, 0xAB5B, 0xAB5B, 0xAB5B, 0xAB7A, 0xAB7B, 0xAB7B, 0xAB5C, 0xA35C, 0xBBB9, 0xCC17, 
        0xDC77, 0xECD3, 0xE4D2, 0xE4B2, 0xE491, 0xDCD3, 0xD4D1, 0xC48F, 0xABED, 0x9AE9, 0x8AA9, 0x8A89, 0x8A8A, 0x92CE, 0x92D0, 0x9AF2, 0xA2F1, 0xA26D, 0xA24D, 0xA24D, 0xAA4B, 0xAAAC, 0xAAAC, 0xAACC, 0xAAEC, 0xB36C, 0xBBAD, 0xC3EF, 0xD431, 0xE4B1, 
        0xECD2, 0xECF2, 0xED12, 0xE512, 0xE4F2, 0xE4F1, 0xDCD0, 0xDCB0, 0xD4D0, 0xD4CF, 0xD4D0, 0xDCAF, 0xDCB0, 0xDCB0, 0xDC8F, 0xD48E, 0xD48E, 0xD46E, 0xD44E, 0xD46E, 0xC48E, 0xC46E, 0xC42D, 0xC40B, 0xB3CB, 0xA38A, 0x9349, 0x72C9, 0x6247, 0x5A05, 
        0x6224, 0x72AA, 0x72CB, 0x72CA, 0x7AAA, 0x93EF, 0xAC30, 0xC450, 0xDC72, 0xDC70, 0xE4D0, 0xED72, 0xFDF4, 0xFE56, 0xFED6, 0xF674, 0xE530, 0x938A, 0x7B2A, 0x6AA9, 0x5A48, 0x630A, 0x6B0A, 0x62E8, 0x4AE7, 0xB3F2, 0xE2B9, 0xF9DA, 0xF9D9, 0xFA7B, 
        0xFABA, 0xFA79, 0xF9B6, 0xE912, 0xE0D1, 0xE0D0, 0xE0D1, 0xF156, 0xF9B6, 0xF9D6, 0xF9D6, 0xF158, 0xF1DA, 0xF9F9, 0xF9B6, 0xE932, 0xE8F1, 0xE0F2, 0xE0F2, 0xE113, 0xE0D3, 0xE8D3, 0xF913, 0xF996, 0xF9B8, 0xF156, 0xE0B3, 0xE8D1, 0xF195, 0xF9D7, 
        0xF9B6, 0xF996, 0xF954, 0xF913, 0xF934, 0xFA39, 0xFA3C, 0xFA3C, 0xFA3B, 0xFA3B, 0xF9B8, 0xF976, 0xF996, 0xF9B4, 0xF995, 0xF156, 0xE955, 0xF953, 0xF151, 0xE92F, 0xD8ED, 0xF1B1, 0xF150, 0xB8A9, 0x7823, 0xE110, 0xFAD8, 0xF2B8, 0xF0D1, 0xE8D2, 
        0xE131, 0xE151, 0xE112, 0xD8D1, 0xE112, 0xE112, 0xD8D1, 0xE953, 0xF174, 0xF974, 0xF975, 0xF9B5, 0xF9F6, 0xFA37, 0xFA3A, 0xFA1B, 0xFA3B, 0xFA7A, 0xFA98, 0xD90E, 0xB068, 0x9006, 0x9027, 0x9889, 0xA0A9, 0xA0A9, 0xA0A9, 0xA86C, 0x9049, 0x7846, 
        0x7084, 0x5823, 0x70A6, 0x78A6, 0x7003, 0x7006, 0x908A, 0x988B, 0x8829, 0x6024, 0x6845, 0x7867, 0x806A, 0x7825, 0x8027, 0x8049, 0x786A, 0x788A, 0x6848, 0x5804, 0x48A3, 0xB534, 0xE71B, 0xFFDF, 0xFFDF, 0xFFBF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFDF, 
        0xFFDF, 0xFFFF, 0xFFFF, 0xFFBE, 0xF77C, 0xFF1A, 0xFEB8, 0xF6B7, 0xD5F2, 0xD655, 0xF79D, 0xDE58, 0x62AA, 0x5A08, 0xC3F1, 0xA148, 0xB9AA, 0xC9ED, 0xB96A, 0x6041, 0x5061, 0x5862, 0x6864, 0x9A2C, 0xD433, 0xFD57, 0xFD77, 0xECD5, 0xDC31, 0xD3F0, 
        0xDC11, 0xF513, 0xDC30, 0xC36E, 0xB32E, 0xB30E, 0xB2CD, 0xBAED, 0xBAEE, 0x8087, 0x78E7, 0xA26C, 0xDC73, 0xDC72, 0xD472, 0xD472, 0xD472, 0xC412, 0xDC94, 0xECF4, 0xECB1, 0xAB6D, 0xB32D, 0xBB0E, 0xBB4F, 0xD411, 0xD330, 0x91CB, 0x2882, 0x7266, 
        0xB3AA, 0xA2E9, 0x5062, 0x98AB, 0xB9B1, 0xB1D1, 0x78EB, 0x5A42, 0x8C29, 0xA3ED, 0x918C, 0x7829, 0x7048, 0x7067, 0x8048, 0x886B, 0x884A, 0x806A, 0x786A,
  0x9AF8, 0x9AF7, 0x9AF7, 0x9AF8, 0x9AF8, 0x9AF8, 0xA318, 0xA319, 0x9B18, 0x9B18, 0x9B17, 0x9B17, 0xA33A, 0xA33A, 0xA339, 0xA33A, 0xA31A, 0xA33A, 0xA33A, 0xA33A, 0xAB39, 0xA33A, 0xA33B, 0xA35A, 0xA35A, 0xAB5A, 0xAB5B, 0xAB5B, 0xA31B, 0xBBDB, 0xCC59, 
        0xD477, 0xE516, 0xE513, 0xDCD1, 0xDCB0, 0xD4B2, 0xC451, 0xBBEF, 0xB38E, 0x9B4C, 0x9B4B, 0x9B2B, 0x9B2C, 0xA34C, 0xA32F, 0xAB31, 0xB333, 0xB2D3, 0xBAB2, 0xBA90, 0xC2AD, 0xB2ED, 0xBAED, 0xBAED, 0xBB2E, 0xCBF0, 0xD430, 0xD471, 0xDCF1, 0xE4F2, 
        0xE511, 0xE511, 0xE4F1, 0xE511, 0xDCF1, 0xDCD0, 0xD4CF, 0xDCCF, 0xDCAF, 0xD4AF, 0xD4AF, 0xD4CF, 0xD4AF, 0xCC8E, 0xCC8E, 0xCCAE, 0xCC8D, 0xD46D, 0xD44D, 0xC46D, 0xC42C, 0xBC0B, 0xB3EB, 0x9B29, 0x92C7, 0x82A5, 0x6A64, 0x6A04, 0x61E5, 0x69E5, 
        0x7A47, 0x8B2B, 0x934C, 0x934C, 0x936D, 0xAC50, 0xAC4F, 0xB44F, 0xB42F, 0xCBEE, 0xDC70, 0xED11, 0xF592, 0xF5B2, 0xEDB2, 0xE591, 0xD52E, 0xA40C, 0x836B, 0x62E9, 0x4A87, 0x7289, 0x730C, 0x5B4B, 0x4B2A, 0xBB91, 0xE2F6, 0xFA59, 0xF9D9, 0xFA3A, 
        0xFA9A, 0xFA59, 0xF997, 0xE10F, 0xD8CF, 0xD8CF, 0xD8D0, 0xF154, 0xF996, 0xF9B8, 0xF1B8, 0xE955, 0xF1B8, 0xF1F8, 0xF1B6, 0xF135, 0xE8F2, 0xE0B1, 0xD891, 0xD8D3, 0xE934, 0xF154, 0xF134, 0xF9D7, 0xF176, 0xE8D2, 0xD84D, 0xE0F2, 0xF195, 0xF9D7, 
        0xF9D8, 0xF996, 0xF156, 0xF156, 0xF155, 0xF997, 0xF9DA, 0xF9FB, 0xFA1B, 0xF1FC, 0xE998, 0xE996, 0xE9B7, 0xF9B7, 0xF176, 0xF135, 0xF114, 0xE913, 0xE0D1, 0xE0EF, 0xE12F, 0xD88D, 0xA827, 0xA004, 0xC088, 0xF3DB, 0xF236, 0xE8D1, 0xE0D1, 0xE954, 
        0xD912, 0xD8F1, 0xD911, 0xD8F1, 0xD8D1, 0xD8F2, 0xD932, 0xF175, 0xF995, 0xF9B5, 0xF1B6, 0xF1B5, 0xF1F6, 0xF9F6, 0xF9B7, 0xFA3A, 0xFA19, 0xFA19, 0xFA19, 0xE0F2, 0xB84C, 0xA008, 0x9807, 0x9846, 0x9867, 0xA089, 0xA8AB, 0xA0AA, 0x7045, 0x6863, 
        0x80C5, 0x6024, 0x7045, 0x7845, 0x7825, 0x9089, 0x90AA, 0xA0AA, 0xA88A, 0x5846, 0x6025, 0x6826, 0x6847, 0x7825, 0x7027, 0x7828, 0x7826, 0x788A, 0x6847, 0x5024, 0x40C3, 0xCDD6, 0xF73B, 0xFFBE, 0xFFDF, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 
        0xFFDE, 0xFFFF, 0xFFFF, 0xFF7D, 0xFF3C, 0xF6FA, 0xEEB6, 0xDD74, 0xE656, 0xEF3A, 0xDEFB, 0x2104, 0x38C4, 0x81C8, 0xD2CD, 0xC14C, 0xD16B, 0xC949, 0x98A5, 0x3862, 0x38E3, 0x50C4, 0x7085, 0xD3D2, 0xF557, 0xFDB8, 0xF516, 0xD452, 0xD431, 0xDC72, 
        0xDCB4, 0xD411, 0xC3AF, 0xBB4D, 0xAAED, 0xBB4E, 0xBB4E, 0xB2CC, 0xA1E9, 0x99A8, 0xB22C, 0xBACF, 0xC371, 0xD472, 0xCBF1, 0xCBB0, 0xD411, 0xDCB5, 0xDCB4, 0xDC93, 0xD431, 0xB32D, 0xB32C, 0xBB4D, 0xC371, 0xE3F3, 0xAAAC, 0x5945, 0x28E4, 0xD5B7, 
        0x7ACA, 0x2881, 0x2042, 0xC1ED, 0xDA91, 0xB9EF, 0x808A, 0x6AA8, 0x8BC8, 0x8B47, 0x6145, 0x6827, 0x7027, 0x7048, 0x7068, 0x7047, 0x7867, 0x7868, 0x7028,
  0x9AF8, 0x9AF8, 0x9AF8, 0x9AF8, 0x9AF8, 0x9B18, 0x9B18, 0xA2F8, 0xA339, 0x9B18, 0x9B18, 0xA319, 0xA319, 0xA319, 0xA339, 0xA33A, 0xA33A, 0xA33A, 0xA33A, 0xA33A, 0xA35A, 0xA35A, 0xA35A, 0xA35A, 0xA35A, 0xAB5A, 0xAB5B, 0xAB5C, 0xA33C, 0xB3FA, 0xC458, 
        0xD477, 0xED16, 0xE515, 0xE4F4, 0xE4B3, 0xD474, 0xC431, 0xBC0E, 0xBC0C, 0xA3AC, 0xA38C, 0xA38D, 0xAB8E, 0xA36F, 0xA373, 0xA356, 0xAB36, 0xBB35, 0xBB34, 0xB352, 0xB36F, 0xC34C, 0xC36D, 0xC38E, 0xCBAF, 0xCC31, 0xD490, 0xDCB1, 0xDCD2, 0xE511, 
        0xE511, 0xE511, 0xE511, 0xDCF1, 0xDCF0, 0xDCF0, 0xDCF1, 0xDCCE, 0xDCCF, 0xD4CF, 0xD4AF, 0xD4AF, 0xCCAE, 0xCC8E, 0xCC8E, 0xCC8E, 0xD48D, 0xD48D, 0xCC8E, 0xC40B, 0xBBCB, 0xB3AB, 0xAB8A, 0x82A6, 0x82A7, 0x7AA7, 0x7AA7, 0x7AC8, 0x8309, 0x8B2A, 
        0x8B6A, 0x8BAD, 0x93CE, 0x940E, 0x942E, 0x93EC, 0xA40D, 0xB40D, 0xBC0C, 0xCC0C, 0xC42D, 0xCC8E, 0xDD2F, 0xED53, 0xED74, 0xED72, 0xE550, 0xBC4E, 0x9BCC, 0x7B2A, 0x6288, 0x7AEB, 0x7B4B, 0x6B4A, 0x4B07, 0x932E, 0xD2F7, 0xFA7B, 0xF9BA, 0xFA7C, 
        0xFA9A, 0xFA58, 0xF9F6, 0xD8D2, 0xD8AF, 0xD8AE, 0xD8B0, 0xF0F2, 0xF175, 0xF1D6, 0xF1B6, 0xD8F3, 0xE976, 0xF1B7, 0xF176, 0xF114, 0xE8F3, 0xD8B1, 0xD04F, 0xE0B3, 0xF155, 0xF9B6, 0xF9B6, 0xF974, 0xE8F2, 0xD86F, 0xC84D, 0xE0F3, 0xF134, 0xF176, 
        0xF9B7, 0xE998, 0xF197, 0xF1B7, 0xF1B7, 0xF9B7, 0xF9B7, 0xF9F9, 0xFA1B, 0xF199, 0xF197, 0xE996, 0xE9B7, 0xF177, 0xF174, 0xF153, 0xE8F3, 0xC84C, 0xD04C, 0xD84D, 0xD04D, 0xA005, 0xA025, 0xC1CD, 0xF3F9, 0xF175, 0xE8F3, 0xE913, 0xE934, 0xE112, 
        0xD8F1, 0xD8D0, 0xD0D1, 0xD8F0, 0xD8F1, 0xE112, 0xE952, 0xF996, 0xF9B6, 0xF1B5, 0xF195, 0xF1B6, 0xF1B6, 0xF1B6, 0xF1B7, 0xF9D9, 0xF9FA, 0xF9FA, 0xF9F9, 0xF1B5, 0xD0CE, 0xB049, 0x9007, 0x9848, 0xA067, 0xB089, 0xB0CB, 0x982A, 0x6004, 0x6042, 
        0x90C5, 0x8046, 0x8847, 0x9047, 0x9047, 0xA0CA, 0xA0CB, 0xB0AB, 0xB88C, 0x7087, 0x6025, 0x6826, 0x7068, 0x7845, 0x7046, 0x6845, 0x6825, 0x7849, 0x7068, 0x5885, 0x38A2, 0x61A6, 0xC575, 0xF7BE, 0xFFFF, 0xFFBF, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFDF, 
        0xFFDF, 0xFFFF, 0xFFDF, 0xF71B, 0xF6D9, 0xF6B8, 0xEE76, 0xE5B4, 0xF6FB, 0xFFDE, 0xE71A, 0x3104, 0x91A8, 0xDA2C, 0xD1AD, 0xE26E, 0xB9CB, 0x9108, 0x6883, 0x4862, 0x5063, 0x7063, 0x9906, 0xDC55, 0xF558, 0xFD98, 0xFD57, 0xE4D3, 0xD411, 0xD432, 
        0xED14, 0xDCB4, 0xD431, 0xC38E, 0xB30D, 0xBB6E, 0xCBF0, 0xCBB1, 0xC2CE, 0x9967, 0x91A8, 0x920A, 0x9A6C, 0xBBD0, 0xDC72, 0xE453, 0xCBF3, 0xD472, 0xDCB3, 0xE4B4, 0xDC13, 0xB34B, 0xB2EC, 0xBAEE, 0xCB71, 0xD451, 0x9249, 0x58C3, 0x48C3, 0xDD74, 
        0x8289, 0x3041, 0x2062, 0xDB91, 0xE414, 0xAB10, 0x6167, 0x59C4, 0x82C8, 0x8A88, 0x60C5, 0x6027, 0x6828, 0x6827, 0x6846, 0x6866, 0x7086, 0x7066, 0x7007,
  0x9B18, 0x9B18, 0x9AF8, 0x9AF8, 0x9B18, 0x9B38, 0x9B18, 0x9B18, 0xA33B, 0xA33A, 0xA339, 0xA33A, 0xA339, 0xA33A, 0xA33A, 0xA33A, 0xA35A, 0xA33A, 0xA33B, 0xAB3B, 0xAB5A, 0xAB7B, 0xAB7B, 0xAB7B, 0xAB5B, 0xAB7B, 0xAB7B, 0xAB7C, 0xAB5C, 0xAB7C, 0xBBFC, 
        0xD4BB, 0xE536, 0xED36, 0xED56, 0xE556, 0xDC93, 0xCC33, 0xBBF1, 0xB3F0, 0xB3EF, 0xB3CE, 0xB3CF, 0xBC11, 0xABB1, 0xAB92, 0xA375, 0xA377, 0xBB99, 0xBB77, 0xBB95, 0xC3B2, 0xC3EE, 0xCC0F, 0xC40F, 0xC430, 0xDC91, 0xDCB0, 0xDCD0, 0xE4F0, 0xE531, 
        0xED31, 0xED11, 0xE4F1, 0xE4F1, 0xE4F1, 0xE4F1, 0xDCD0, 0xD4AF, 0xD4CF, 0xDCCF, 0xDC8F, 0xD4D0, 0xD4B0, 0xD4AF, 0xD4AE, 0xCC8E, 0xCC6D, 0xC44D, 0xBC4D, 0xC3EC, 0xBBEC, 0xABCB, 0x9B8B, 0x82C7, 0x82C7, 0x82E9, 0x7B0B, 0x8BCC, 0x93ED, 0x940D, 
        0x8C2F, 0x9C6F, 0x9C71, 0x9C71, 0x9C50, 0x93EE, 0x9BED, 0xA3ED, 0xABEC, 0xCC0A, 0xC40B, 0xC44D, 0xDCB0, 0xF511, 0xF553, 0xE553, 0xDCF1, 0xBCB1, 0xB470, 0x93AD, 0x6AC9, 0x834D, 0x7B8D, 0x738D, 0x6B2C, 0x6268, 0xB312, 0xEAF8, 0xFA18, 0xFA3B, 
        0xFA7C, 0xFA9A, 0xFA77, 0xF0F4, 0xE8B1, 0xE0AF, 0xE08F, 0xE931, 0xF133, 0xF975, 0xF1B6, 0xE8F3, 0xE914, 0xF114, 0xF134, 0xF936, 0xE8F3, 0xD890, 0xD04F, 0xF196, 0xF9B6, 0xF996, 0xF994, 0xE0B0, 0xD890, 0xD890, 0xD890, 0xE0B1, 0xE934, 0xF175, 
        0xF175, 0xE976, 0xF197, 0xF998, 0xF9B7, 0xF9D8, 0xF9B9, 0xF9DB, 0xFA3B, 0xFA38, 0xF9B6, 0xF175, 0xE975, 0xE913, 0xD8B1, 0xC84E, 0xB809, 0xB80A, 0xC00B, 0xB808, 0xA002, 0xC047, 0xE213, 0xFAF8, 0xFA76, 0xF0F5, 0xE914, 0xE952, 0xE931, 0xE112, 
        0xD8F1, 0xD8D0, 0xD8D1, 0xE0F2, 0xF153, 0xF994, 0xF993, 0xF9D5, 0xF9D6, 0xF9D7, 0xF996, 0xF9D6, 0xF1D6, 0xF1B6, 0xF9B7, 0xF9D7, 0xF9D8, 0xF9B9, 0xF9B8, 0xF9F7, 0xF994, 0xD910, 0xA86B, 0xB049, 0xB08A, 0xB8CC, 0xB0AD, 0x7024, 0x6002, 0x6842, 
        0x88A5, 0xA0AA, 0x906A, 0x906A, 0x98AC, 0xA8AC, 0xA88B, 0xA86B, 0xA88C, 0x98ED, 0x7067, 0x6024, 0x6825, 0x8087, 0x7066, 0x7046, 0x7046, 0x6847, 0x6846, 0x78C8, 0x81C9, 0x1862, 0x4984, 0x9C2E, 0xF79D, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFDF, 0xFFBF, 0xFF7D, 0xF73B, 0xF6D9, 0xF657, 0xFE76, 0xF71A, 0xA4F3, 0x18A2, 0x38A2, 0xAB2F, 0xCB92, 0xA18B, 0xB9CB, 0xB149, 0xA0A7, 0x8864, 0x4862, 0x4062, 0x5863, 0x8908, 0xEBF3, 0xFCB6, 0xFD37, 0xFD97, 0xFD9A, 0xF536, 0xECB2, 
        0xDC52, 0xECB4, 0xF536, 0xED15, 0xDC92, 0xE472, 0xE473, 0xE473, 0xEC54, 0xE3B2, 0xDB90, 0xCB6F, 0xAB2D, 0xA26C, 0xAAEE, 0xC370, 0xDBD2, 0xDC53, 0xDC52, 0xDC72, 0xDCD2, 0xE453, 0xB38E, 0xAB4B, 0xC34B, 0xBB50, 0xBBB1, 0x8A8B, 0x4904, 0xD5B3, 
        0x82A9, 0x5041, 0x6021, 0x9187, 0xAA6B, 0xA2AC, 0x820B, 0x6123, 0x6924, 0x68E4, 0x5864, 0x6807, 0x7028, 0x6827, 0x6825, 0x7886, 0x7065, 0x7046, 0x7048,
  0x9AF8, 0x9AF8, 0x9B18, 0x9B18, 0x9B18, 0x9B18, 0x9B18, 0x9B18, 0xA31A, 0xA31A, 0xA339, 0xA339, 0xA339, 0xA339, 0xA33A, 0xA35B, 0xA31A, 0xA33B, 0xAB3B, 0xAB3A, 0xA35A, 0xA35A, 0xA35B, 0xA35B, 0xAB3A, 0xAB5B, 0xAB7B, 0xAB7B, 0xA33B, 0xAB9B, 0xBC1B, 
        0xCCBB, 0xDD16, 0xE536, 0xE518, 0xDCD9, 0xCC78, 0xB3F5, 0xABB2, 0xABB1, 0xABD0, 0xB3F0, 0xB411, 0xB413, 0xAB94, 0xB3B7, 0xB3DA, 0xABBC, 0xBBBC, 0xC3FA, 0xC417, 0xC413, 0xBC50, 0xC46F, 0xCC90, 0xCCB1, 0xDCD0, 0xDCF1, 0xDCF1, 0xE511, 0xE511, 
        0xE532, 0xE511, 0xE4F1, 0xDCF1, 0xDCF1, 0xDCF1, 0xDCD1, 0xD4CF, 0xDCCF, 0xD4CF, 0xCCAF, 0xD48F, 0xD48F, 0xD48E, 0xCC8E, 0xCC4D, 0xCC6D, 0xCC4C, 0xC40C, 0xB3AB, 0xA3AB, 0x9B8B, 0x9B8B, 0x940C, 0x9C2E, 0xA44E, 0xA48F, 0xACAF, 0xACB0, 0xA4D1, 
        0xA4D2, 0xACD1, 0xA4F1, 0xA4D1, 0xA490, 0x944D, 0x9C0C, 0xA3CA, 0xABC8, 0xC42B, 0xCC4B, 0xCC8C, 0xCCAC, 0xDC8E, 0xDCB0, 0xDCF1, 0xE532, 0xE511, 0xD511, 0xB48E, 0x7B89, 0x736D, 0x734D, 0x6B2C, 0x5AEB, 0x62CB, 0xB353, 0xEAF8, 0xF9F9, 0xFA3C, 
        0xFA7B, 0xFA5A, 0xF9F7, 0xE912, 0xE0D0, 0xD88F, 0xD88D, 0xE112, 0xE934, 0xF155, 0xF196, 0xE953, 0xE913, 0xE0F3, 0xE914, 0xF975, 0xE913, 0xE0B2, 0xE0D2, 0xF9D7, 0xF996, 0xF154, 0xE912, 0xD86F, 0xD08F, 0xD08E, 0xD88D, 0xE0D1, 0xE933, 0xE933, 
        0xE113, 0xF156, 0xF175, 0xF176, 0xF177, 0xF978, 0xF9B8, 0xF9D9, 0xF9FB, 0xF1B9, 0xE956, 0xE114, 0xD8B2, 0xC86D, 0xB02A, 0xA809, 0xB00A, 0xB869, 0xA824, 0xA002, 0xB844, 0xF257, 0xFAB8, 0xFA37, 0xF936, 0xE933, 0xE112, 0xE0F2, 0xD8F1, 0xE111, 
        0xD912, 0xD0F1, 0xD0D1, 0xE0D1, 0xF174, 0xF1D5, 0xF1D5, 0xF9D7, 0xF9F7, 0xF9F7, 0xF9D8, 0xF1D6, 0xF1B6, 0xF9D6, 0xFA17, 0xF1B7, 0xF1B7, 0xF9B7, 0xF9B8, 0xF9F7, 0xE994, 0xD910, 0xC06B, 0xB089, 0xB0A9, 0xB08B, 0xB04C, 0x7004, 0x5821, 0x6842, 
        0x90A5, 0xA88B, 0x984A, 0x984A, 0xA0AB, 0x9028, 0x9009, 0x982A, 0xB06B, 0xA8CC, 0x8048, 0x6805, 0x6005, 0x7066, 0x7046, 0x6845, 0x6065, 0x6846, 0x6866, 0x6907, 0x61E6, 0x3941, 0x59E4, 0x8B8C, 0xCDF8, 0xF7BE, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFFF, 
        0xFFDF, 0xFF9F, 0xFF7F, 0xFF7C, 0xF71A, 0xF658, 0xF5D6, 0xF75C, 0xC533, 0x6A88, 0x2924, 0xDE9A, 0xCB91, 0xA8E7, 0x9844, 0xB94A, 0xA989, 0x8926, 0x5862, 0x4061, 0x5842, 0x88C7, 0xCA2E, 0xF4D4, 0xFD37, 0xFD78, 0xFDD9, 0xF536, 0xE493, 0xE494, 
        0xF516, 0xDCB4, 0xDCD4, 0xDCD4, 0xDC93, 0xE4D3, 0xDC93, 0xDC33, 0xE3F3, 0xDC13, 0xD390, 0xC32D, 0xBAEC, 0xC392, 0xBB2F, 0xBB2F, 0xC3B1, 0xDC31, 0xDC72, 0xDC93, 0xDC92, 0xC3AF, 0xBBAD, 0xB34C, 0xB2EE, 0xBBF2, 0x92AB, 0xA30B, 0xDCD0, 0x8186, 
        0x5862, 0x5841, 0x70A3, 0x8A28, 0x89E8, 0x8147, 0x70A5, 0x8107, 0x78E7, 0x70A7, 0x7087, 0x7069, 0x7068, 0x7087, 0x7088, 0x6827, 0x6827, 0x6827, 0x6848,
  0x9AF8, 0x9AF8, 0x9B18, 0x9AF8, 0x9B18, 0x9B18, 0xA318, 0xA319, 0xA31A, 0xA319, 0xA319, 0xA318, 0xA339, 0xA339, 0xA339, 0xA35A, 0xA33A, 0xA33A, 0xA33A, 0xAB3A, 0xA35A, 0xA35A, 0xA35A, 0xAB5A, 0xAB5A, 0xAB5B, 0xAB5C, 0xB37B, 0xAB5B, 0xB39C, 0xBBFC, 
        0xCC7C, 0xD4F8, 0xDD16, 0xDD16, 0xD4D7, 0xC436, 0xB3B4, 0xAB73, 0xA373, 0xABB0, 0xB3D1, 0xB412, 0xB433, 0xABD4, 0xB3D8, 0xB3DC, 0xB3BE, 0xBBBC, 0xC41B, 0xC439, 0xBC35, 0xD490, 0xD4AF, 0xD4B0, 0xCCD1, 0xCCB0, 0xDCD1, 0xE511, 0xE532, 0xDD32, 
        0xDD11, 0xE511, 0xE531, 0xDCF0, 0xDCF0, 0xDCF1, 0xDCF1, 0xDCEE, 0xD4EF, 0xD4CF, 0xD4CF, 0xD48F, 0xD48E, 0xCC8E, 0xCC6E, 0xCC4E, 0xC44D, 0xB40B, 0xB389, 0xAC0B, 0xA40C, 0x9C0C, 0x9C4D, 0xA46F, 0xAC90, 0xB4B1, 0xACD2, 0xB4D2, 0xB513, 0xBD33, 
        0xBD53, 0xB4F2, 0xA4F2, 0x9CF1, 0xA4D1, 0x946E, 0x942D, 0x9C0B, 0xAC2A, 0xCCAC, 0xD4ED, 0xDD2E, 0xE531, 0xDD12, 0xD4F2, 0xD4D2, 0xDCF2, 0xE512, 0xD530, 0xB4EE, 0x844D, 0x6AC9, 0x6AEB, 0x6B0C, 0x62EB, 0x6B4B, 0xA432, 0xD3B6, 0xF9F7, 0xF9FB, 
        0xFA7C, 0xFA7A, 0xF9F7, 0xE972, 0xE0EF, 0xE08E, 0xE08D, 0xE0B0, 0xE912, 0xF174, 0xF995, 0xE154, 0xE0F3, 0xE0F3, 0xE933, 0xF155, 0xE934, 0xE934, 0xF955, 0xF155, 0xF174, 0xE912, 0xE070, 0xD0AD, 0xC88E, 0xD08E, 0xD8AE, 0xD8F2, 0xE133, 0xE132, 
        0xE112, 0xF176, 0xF135, 0xF135, 0xF177, 0xF176, 0xF198, 0xF9FA, 0xFA3B, 0xF174, 0xE8D3, 0xD872, 0xC02F, 0xB809, 0xA806, 0xA827, 0xB868, 0x9801, 0xB024, 0xD0CA, 0xFA34, 0xFAB9, 0xFA17, 0xF9B7, 0xF198, 0xD8B0, 0xD8D1, 0xD8F2, 0xD8D1, 0xD8D1, 
        0xD8D1, 0xD0D1, 0xC8B0, 0xE933, 0xF194, 0xF1D5, 0xF1F5, 0xFA18, 0xFA39, 0xFA38, 0xFA18, 0xF1D7, 0xF9D6, 0xF9F6, 0xFA17, 0xF1B7, 0xF1D7, 0xF9B8, 0xF9B8, 0xFA18, 0xF9D6, 0xE933, 0xC88E, 0xB0A9, 0xB0AA, 0xA88B, 0xA06A, 0x6804, 0x5821, 0x6863, 
        0x98C8, 0xA08B, 0x9869, 0x9047, 0x9005, 0x9007, 0x9828, 0x9828, 0xA028, 0xB8CE, 0x9889, 0x7825, 0x5803, 0x6065, 0x6865, 0x6845, 0x5825, 0x5865, 0x6887, 0x68C7, 0x6165, 0x4A85, 0x2142, 0x3965, 0x9BAE, 0xF77D, 0xFFDF, 0xFFDF, 0xFFDF, 0xFFFF, 
        0xFFDF, 0xFFBF, 0xFF7F, 0xFF5D, 0xF6B9, 0xF6B8, 0xFF3B, 0xEF5C, 0x6B2C, 0x626A, 0xDCF5, 0xD32F, 0xB149, 0x98C7, 0xA189, 0xB96A, 0x9927, 0x78C4, 0x6021, 0x4842, 0x6906, 0x99CA, 0xD2D0, 0xFC95, 0xFD36, 0xFDB8, 0xF5FA, 0xF536, 0xE4B4, 0xDC73, 
        0xEC93, 0xF556, 0xED56, 0xED35, 0xED15, 0xDCD3, 0xDCB3, 0xDC73, 0xD432, 0xE473, 0xE473, 0xDC12, 0xC36F, 0xAACB, 0xBB0D, 0xBB50, 0xBB71, 0xD452, 0xD432, 0xDC73, 0xECF5, 0xC3EF, 0xBB8D, 0xB32B, 0xAAE9, 0xDC73, 0xC3D0, 0xAB6C, 0x9B2B, 0x4861, 
        0x5841, 0x70A3, 0x70E5, 0x5863, 0x5843, 0x6084, 0x68E5, 0x9905, 0x88C6, 0x78A7, 0x70C8, 0x7048, 0x8089, 0x90CA, 0x88CA, 0x6828, 0x7068, 0x7889, 0x7069,
  0x9B18, 0x9B18, 0x9B18, 0xA318, 0xA318, 0xA338, 0xA338, 0xA339, 0x9B1A, 0xA33A, 0xA33A, 0xA35A, 0xA35A, 0xA35A, 0xAB5A, 0xA35A, 0xA35A, 0xA35A, 0xA35A, 0xA35B, 0xAB7A, 0xAB7B, 0xAB7B, 0xAB7B, 0xB37C, 0xAB7C, 0xAB7C, 0xAB7C, 0xAB7C, 0xAB5C, 0xAB9C, 
        0xB45D, 0xE4BB, 0xDCD9, 0xD4F8, 0xD4B8, 0xBBFA, 0xABB9, 0xA377, 0xA355, 0x9B93, 0x9BB3, 0xA3D3, 0xAC15, 0xB3D6, 0xB3F9, 0xB3DB, 0xB3BE, 0xABDD, 0xB3DC, 0xBC1B, 0xC477, 0xCC72, 0xD4B1, 0xDCD0, 0xDCCF, 0xDCF2, 0xDD11, 0xDD31, 0xE511, 0xE532, 
        0xED32, 0xE532, 0xE511, 0xE511, 0xE4F1, 0xE4F1, 0xDCD0, 0xDCB0, 0xDCAF, 0xDC8F, 0xDC8E, 0xCC8F, 0xD48F, 0xDC6E, 0xDC6E, 0xC40B, 0xBC2C, 0xBC0C, 0xB3CB, 0xA44E, 0xA44D, 0xA46E, 0xA490, 0xACD0, 0xAD11, 0xB512, 0xB4F3, 0xB532, 0xB532, 0xB533, 
        0xB574, 0xBD95, 0xB554, 0xA512, 0x9CD1, 0x9C4D, 0x9C0B, 0xA3EA, 0xAC09, 0xDCCB, 0xED2E, 0xF56F, 0xF590, 0xFD90, 0xED4F, 0xE52E, 0xE54E, 0xE530, 0xD52F, 0xC50F, 0xACAE, 0x6B48, 0x7329, 0x730B, 0x6B0B, 0x63CB, 0x9430, 0xCB95, 0xF259, 0xFA1B, 
        0xFA5B, 0xFA7A, 0xFA78, 0xF194, 0xE912, 0xE0F0, 0xD8AE, 0xD88E, 0xE0F0, 0xE933, 0xF154, 0xF134, 0xF133, 0xE913, 0xE8F2, 0xF0D3, 0xF154, 0xF174, 0xF954, 0xF9B5, 0xF112, 0xE8AF, 0xD86E, 0xD88F, 0xD090, 0xD0AF, 0xD8AE, 0xD8B0, 0xE0F1, 0xE111, 
        0xE112, 0xF154, 0xF134, 0xF134, 0xF995, 0xF176, 0xF9B8, 0xFA1B, 0xFA5C, 0xF0D3, 0xD04E, 0xB80B, 0xB009, 0xA847, 0xB826, 0xB023, 0x9801, 0xB849, 0xE1F3, 0xFAF9, 0xFAD9, 0xF976, 0xF976, 0xF976, 0xF136, 0xE0D1, 0xE0F1, 0xE112, 0xE0F2, 0xD8D1, 
        0xD8F0, 0xD910, 0xE131, 0xF154, 0xF175, 0xF1D6, 0xFA57, 0xFA39, 0xFA18, 0xFA18, 0xFA38, 0xFA38, 0xFA37, 0xF217, 0xF9D7, 0xF9D7, 0xF9F7, 0xF9F7, 0xF9F9, 0xFA38, 0xFA37, 0xFA16, 0xF1B3, 0xC06C, 0xB86B, 0xB08C, 0xA86C, 0x6002, 0x5801, 0x7064, 
        0xA0EB, 0x98AA, 0x988A, 0x9069, 0x8808, 0x9006, 0xA047, 0xA068, 0xA088, 0xB06D, 0xB0CD, 0x90A9, 0x6023, 0x6045, 0x6846, 0x6045, 0x5004, 0x6826, 0x6886, 0x58E5, 0x4143, 0x49E4, 0x49E3, 0x3942, 0x3103, 0xE6DA, 0xFFDE, 0xFFFF, 0xFFDF, 0xFFFF, 
        0xFFDF, 0xFFFF, 0xFFFF, 0xFF7D, 0xF657, 0xF677, 0xF73C, 0xAB2C, 0x4945, 0x61A9, 0xE394, 0xB94A, 0xBA2C, 0xCACF, 0xDA70, 0xA909, 0x88A5, 0x7062, 0x5020, 0x4883, 0x8167, 0xB1EB, 0xCA6F, 0xE414, 0xF4F6, 0xFD58, 0xFDDB, 0xFE3B, 0xF5D9, 0xF557, 
        0xF4B5, 0xD432, 0xED15, 0xF597, 0xFD98, 0xF535, 0xECF4, 0xE4B4, 0xE472, 0xEC93, 0xEC73, 0xEC93, 0xECB3, 0xDBF1, 0xCBD1, 0xD413, 0xDC33, 0xAB2F, 0xBBD1, 0xD452, 0xE453, 0xD490, 0xDCAF, 0xCBED, 0xAACB, 0xBB6F, 0xBBF1, 0xC412, 0xBB50, 0x6862, 
        0x6842, 0x78C5, 0x8926, 0x7843, 0x8884, 0x88A4, 0x7862, 0x80A6, 0x996B, 0x99AC, 0x892A, 0x80A9, 0x88A9, 0x90CA, 0x98EC, 0x808A, 0x786A, 0x784A, 0x7029,
  0x9AF8, 0x9AF8, 0x9B18, 0x9B18, 0x9B18, 0xA318, 0xA318, 0xA31A, 0xA339, 0xA31A, 0xA33A, 0xA33A, 0xA339, 0xA33A, 0xA35A, 0xA33A, 0xA33B, 0xAB5B, 0xAB5B, 0xA35B, 0xA35A, 0xAB5B, 0xAB5B, 0xAB5C, 0xAB5C, 0xAB7B, 0xAB7B, 0xB39C, 0xB35C, 0xAB5B, 0xB39B, 
        0xBC5B, 0xC499, 0xCCB9, 0xCC79, 0xBC38, 0xB3B8, 0xB397, 0xAB76, 0xA336, 0x9B34, 0x9B74, 0x9BB3, 0xA3D3, 0xABF7, 0xB3F9, 0xB3FB, 0xB3DC, 0xAB7C, 0xAB7D, 0xB3DB, 0xBC77, 0xC473, 0xD491, 0xDCB0, 0xD4F1, 0xDCF1, 0xDD10, 0xDD31, 0xE512, 0xED32, 
        0xE512, 0xE512, 0xE4F1, 0xE4F1, 0xDCF1, 0xDCF1, 0xDCF1, 0xD490, 0xD46F, 0xD46E, 0xD48F, 0xCC6E, 0xCC8E, 0xCC6D, 0xC44D, 0xB44C, 0xB42D, 0xAC0C, 0x9C0C, 0xA46E, 0xA4AE, 0xACD0, 0xB4D2, 0xAD31, 0xBD72, 0xC594, 0xC5B4, 0xBD73, 0xC5B4, 0xC5B5, 
        0xBDB5, 0xBD53, 0xAD32, 0xA4F2, 0x9CB2, 0x9C6D, 0x942C, 0x9C0A, 0xB449, 0xE52F, 0xF5D0, 0xFE31, 0xFE33, 0xFE72, 0xF591, 0xED2F, 0xE52F, 0xE50F, 0xDCEE, 0xBCAD, 0x940B, 0x6AE8, 0x6B2A, 0x6B4B, 0x632C, 0x844D, 0x9CD0, 0xBC34, 0xF2D7, 0xF9FB, 
        0xFA3C, 0xFA9B, 0xFA98, 0xE933, 0xE8F3, 0xE0D1, 0xD88E, 0xD86E, 0xE0B0, 0xE912, 0xF174, 0xE933, 0xE932, 0xE912, 0xE8D2, 0xF0F3, 0xF155, 0xF995, 0xF993, 0xF932, 0xE0AF, 0xD06E, 0xD08E, 0xD08E, 0xC8AE, 0xC8AE, 0xD08D, 0xD88F, 0xE0F1, 0xE112, 
        0xE112, 0xE113, 0xE913, 0xF154, 0xF995, 0xF155, 0xF9B8, 0xF9FB, 0xF1DA, 0xB04D, 0xA809, 0xB008, 0xB829, 0xB048, 0xA827, 0xA806, 0xC869, 0xF2D6, 0xFAB8, 0xFA17, 0xF9B6, 0xF195, 0xF9B6, 0xF175, 0xE913, 0xE132, 0xE112, 0xE112, 0xD912, 0xD8D1, 
        0xD8D0, 0xD910, 0xE951, 0xE953, 0xF175, 0xF1D6, 0xF238, 0xFA59, 0xFA39, 0xFA19, 0xF9F8, 0xF9F7, 0xF1F7, 0xF1D7, 0xF1B6, 0xF9D6, 0xF9D7, 0xF9F7, 0xFA38, 0xFA19, 0xFA38, 0xFA17, 0xF196, 0xD88E, 0xB86C, 0xA84B, 0xA028, 0x5801, 0x6001, 0x8865, 
        0xB0EB, 0x986A, 0x9889, 0x9088, 0x8805, 0x9025, 0x9046, 0x9867, 0xA068, 0xB0AC, 0xB8CD, 0xA08A, 0x6805, 0x5824, 0x5845, 0x5865, 0x5844, 0x6024, 0x6886, 0x58C5, 0x40E3, 0x51E4, 0x41A3, 0x38E1, 0x48C3, 0xCDD6, 0xF75D, 0xFFDF, 0xFFBF, 0xFFDF, 
        0xFFDF, 0xFFFF, 0xFFDE, 0xF699, 0xFED9, 0xFF5B, 0xE71B, 0x2904, 0x6185, 0xB24A, 0xDA6D, 0xD1ED, 0xB98C, 0xA909, 0xA8A6, 0x98C5, 0x80A4, 0x6863, 0x4041, 0x5842, 0xA1A9, 0xD2CF, 0xEB72, 0xF476, 0xFD37, 0xFD78, 0xFD5A, 0xF5DA, 0xF578, 0xED16, 
        0xE4B3, 0xEC94, 0xF516, 0xF556, 0xF576, 0xECF5, 0xE4D4, 0xE4B4, 0xE4B4, 0xF494, 0xEC53, 0xE452, 0xE473, 0xD432, 0xDC12, 0xD3F2, 0xC3B2, 0xA2AC, 0xC3D0, 0xE493, 0xE473, 0xD472, 0xCC10, 0xCBAF, 0xC36F, 0xB2EC, 0xCBF1, 0xBBB0, 0x8A4A, 0x91E9, 
        0x8926, 0x80C5, 0x8106, 0x98C6, 0x88C6, 0x7885, 0x7863, 0xA9A8, 0xA169, 0x8909, 0x7887, 0x88C8, 0x88A9, 0x90A9, 0x90CA, 0x786A, 0x788A, 0x786A, 0x7049,
  0x9AF8, 0x9B18, 0x9B18, 0x9B18, 0xA2F9, 0xA319, 0xA319, 0xA319, 0xA2F9, 0xA31A, 0xA33A, 0xA339, 0xA319, 0xA339, 0xA33A, 0xA33A, 0xA33A, 0xA33B, 0xAB3B, 0xA33A, 0xA35B, 0xAB5A, 0xAB5A, 0xAB5A, 0xA35B, 0xAB7C, 0xB37C, 0xB37C, 0xAB5C, 0xAB7C, 0xAB9C, 
        0xAB9B, 0xBC58, 0xBC76, 0xBC36, 0xBBD7, 0xABB7, 0xAB78, 0xAB38, 0xA336, 0x9334, 0x9352, 0x9B91, 0xA3D2, 0xABD9, 0xB3DA, 0xB3BA, 0xAB9B, 0xAB9D, 0xAB9A, 0xB3B8, 0xBBF8, 0xBC75, 0xCCB4, 0xD4D2, 0xD4F1, 0xD4F1, 0xDCF2, 0xE512, 0xE532, 0xE532, 
        0xE532, 0xE512, 0xE511, 0xDCF0, 0xD4F1, 0xD4D1, 0xDCB1, 0xD48E, 0xD48E, 0xCC6E, 0xCC6D, 0xBC6D, 0xBC0C, 0xB3EC, 0xB42D, 0xAC4D, 0xA42C, 0xA44E, 0xA490, 0xA4AE, 0xACF0, 0xAD12, 0xAD32, 0xBD73, 0xBD73, 0xBD93, 0xBDF3, 0xD5D5, 0xD5D6, 0xCDD5, 
        0xCDD4, 0xBD52, 0xA533, 0x9CF1, 0x9C6D, 0x946F, 0x9C2C, 0xAC2B, 0xC48E, 0xE591, 0xEE13, 0xF614, 0xFDB5, 0xF5B2, 0xED30, 0xDCCF, 0xCCAE, 0xCCED, 0xBCCE, 0xA46E, 0x7B8B, 0x52E8, 0x630B, 0x734D, 0x8BAD, 0x9C8D, 0x9D31, 0xB4B3, 0xD314, 0xF9BA, 
        0xFA5C, 0xFA9C, 0xFA3B, 0xF132, 0xE0F2, 0xD8D1, 0xD88E, 0xD88D, 0xE0F0, 0xE912, 0xE0F2, 0xE0F2, 0xE113, 0xE0F3, 0xE8B3, 0xF9B6, 0xF134, 0xE8F2, 0xE8F0, 0xD86E, 0xD88F, 0xD88F, 0xD06F, 0xC08D, 0xC08D, 0xC8AD, 0xC8CE, 0xE08F, 0xE0F2, 0xE0F2, 
        0xE0D1, 0xE112, 0xE934, 0xF154, 0xF154, 0xF976, 0xF9DA, 0xE999, 0xD0B3, 0xA009, 0xB008, 0xB808, 0xB828, 0xA005, 0xB828, 0xD90E, 0xFA77, 0xFAB7, 0xFA17, 0xF196, 0xF174, 0xF1F4, 0xF1B5, 0xF154, 0xE8F3, 0xE932, 0xE132, 0xE112, 0xD8F2, 0xD0B1, 
        0xD8D0, 0xD8F0, 0xE0F1, 0xE973, 0xF196, 0xF1D6, 0xFA37, 0xFA5B, 0xFA3A, 0xFA19, 0xF9F8, 0xF9B7, 0xF1B7, 0xF9D7, 0xF9D7, 0xF1D5, 0xF1D6, 0xF9D7, 0xF9F8, 0xFA59, 0xFA39, 0xFA19, 0xF217, 0xD852, 0xB80D, 0xA009, 0x8826, 0x6002, 0x6821, 0x8064, 
        0xB0CA, 0xA04B, 0xA04A, 0x9047, 0x8023, 0x9085, 0x9887, 0xA067, 0xA847, 0xA8AB, 0xC0ED, 0xA8AC, 0x7026, 0x5023, 0x5845, 0x5845, 0x5023, 0x5025, 0x6086, 0x6106, 0x49A4, 0x41E3, 0x41E3, 0x3142, 0x1882, 0xABCE, 0xE679, 0xFFBE, 0xFF9F, 0xFFFF, 
        0xFFDF, 0xFFDF, 0xF79D, 0xDD31, 0xE677, 0xAD53, 0x3962, 0x3861, 0xA209, 0xCAAD, 0xB9AA, 0xA8A7, 0xA086, 0xA0C6, 0x9946, 0x60C3, 0x5062, 0x5842, 0x6823, 0xC18A, 0xCA6F, 0xD312, 0xEBF4, 0xFD38, 0xFD99, 0xFDD9, 0xFDF9, 0xFDB9, 0xED56, 0xDCB3, 
        0xDC52, 0xF579, 0xF557, 0xED36, 0xED36, 0xE4F5, 0xDCD3, 0xDCB3, 0xDC94, 0xE492, 0xE474, 0xDC34, 0xD3F3, 0xECB5, 0xD3D2, 0xB2CD, 0x9A49, 0xBB70, 0xD432, 0xE493, 0xECB4, 0xE494, 0xCBD1, 0xCB6F, 0xD38F, 0xAACC, 0xB32E, 0xC390, 0xC390, 0x80E7, 
        0x7845, 0x8845, 0x98C6, 0x88A5, 0x78A4, 0x7884, 0x8084, 0x90E6, 0x90E7, 0x9107, 0x9107, 0x8888, 0x8088, 0x78A9, 0x70E9, 0x7028, 0x8089, 0x80A9, 0x7048,
  0xA2F8, 0xA318, 0xA319, 0xA31A, 0xA339, 0x9B1A, 0xA319, 0xA339, 0xA33A, 0xA33A, 0xA33A, 0xA33A, 0xA35B, 0xAB5B, 0xA35A, 0xA35A, 0xAB5B, 0xAB5B, 0xAB5B, 0xA33C, 0xA35B, 0xAB7B, 0xB39B, 0xAB9B, 0xAB7C, 0xAB7D, 0xAB7D, 0xAB5C, 0xB3DC, 0xB3BC, 0xB37C, 
        0xAB7D, 0xB3BD, 0xBBD9, 0xBC16, 0xB434, 0xB398, 0xAB7C, 0xA37E, 0xAB5D, 0x9335, 0x9333, 0x9391, 0x9BF1, 0xA3B6, 0xA397, 0xABB8, 0xAB9B, 0xB39E, 0xAB9C, 0xAB9A, 0xABB7, 0xCC76, 0xD4B4, 0xDCD3, 0xDCD2, 0xDCF2, 0xE513, 0xE512, 0xE510, 0xED12, 
        0xED11, 0xE511, 0xE512, 0xDCF1, 0xDCD1, 0xE4D0, 0xDCCF, 0xDC6E, 0xD46E, 0xDC6E, 0xDC8E, 0xBC2D, 0xB3ED, 0xB3CD, 0xB3EE, 0x9BEC, 0x9C2C, 0xA44D, 0x9C8E, 0xAC91, 0xACF1, 0xAD11, 0xB531, 0xBDB3, 0xBDD4, 0xBDD3, 0xC5F4, 0xCE36, 0xD616, 0xCDF5, 
        0xC5D4, 0xAD94, 0xAD13, 0xA4D1, 0x9C91, 0x948E, 0x9C4C, 0xA42C, 0xB46D, 0xED51, 0xF591, 0xF5D2, 0xF654, 0xFE93, 0xFDF3, 0xF571, 0xE54D, 0xB4A9, 0xBC8B, 0xBC6D, 0xA40D, 0x6B6A, 0x636B, 0x6B6D, 0x7B90, 0xAC91, 0xA50F, 0xBD31, 0xECB7, 0xF9FA, 
        0xFA3B, 0xFABA, 0xFAB8, 0xF1B4, 0xF133, 0xE0F2, 0xD8AF, 0xD88E, 0xE0D0, 0xE0D1, 0xE0B0, 0xE913, 0xF134, 0xF914, 0xF933, 0xF9F8, 0xF114, 0xE04F, 0xD04C, 0xD08E, 0xC8AD, 0xC8AD, 0xC86D, 0xD08E, 0xD08E, 0xD06E, 0xD08E, 0xD0EF, 0xD0AF, 0xD8B0, 
        0xE0D2, 0xE912, 0xF153, 0xF153, 0xF153, 0xF9F9, 0xF157, 0xD092, 0xB02B, 0xB829, 0xB026, 0xA804, 0xB005, 0xE8AD, 0xF214, 0xFAB8, 0xFA98, 0xF174, 0xF9B6, 0xF9B6, 0xF153, 0xF174, 0xF174, 0xE933, 0xE8F2, 0xE934, 0xE933, 0xE912, 0xE0F1, 0xD092, 
        0xD8D0, 0xE110, 0xE152, 0xF954, 0xF996, 0xF9D7, 0xFA38, 0xFA7B, 0xFA19, 0xF9D7, 0xF9D7, 0xF9B8, 0xF9B8, 0xF9F8, 0xFA17, 0xF996, 0xF1B6, 0xF1D6, 0xF1F6, 0xF9F8, 0xFA19, 0xFA3B, 0xFA5C, 0xF976, 0xE932, 0xC8AD, 0x9005, 0x6001, 0x7043, 0x90A7, 
        0xB90C, 0xA04A, 0xA06A, 0x9848, 0x8024, 0x9065, 0x9867, 0xA068, 0xA089, 0xA84B, 0xC08D, 0xC8CF, 0xB0EE, 0x5022, 0x5864, 0x6085, 0x5864, 0x5023, 0x48A3, 0x4963, 0x49E3, 0x4162, 0x4183, 0x51A4, 0x51C3, 0x18A2, 0x7B6D, 0xD617, 0xFFBE, 0xFFDF, 
        0xFFFF, 0xFFDF, 0xFFBF, 0xF79D, 0xB531, 0x7326, 0x5201, 0x50A4, 0x8168, 0x99AA, 0x9109, 0x98C5, 0xB129, 0xB96B, 0xB929, 0x9064, 0x7022, 0x6022, 0x6083, 0x91A8, 0xC28D, 0xE331, 0xF3B4, 0xFCD6, 0xFCF8, 0xFD39, 0xFDBB, 0xFE3C, 0xF63C, 0xF61A, 
        0xED98, 0xFD35, 0xF4B4, 0xF4F5, 0xF5B8, 0xF578, 0xF536, 0xF515, 0xF514, 0xDCB4, 0xE495, 0xECD5, 0xF4F4, 0xDBF2, 0xD371, 0xC310, 0xAACE, 0xAA8C, 0xA2CC, 0xBB8F, 0xEC74, 0xF4F3, 0xECB3, 0xE452, 0xDC31, 0xCBF0, 0xB2ED, 0xB2EE, 0xCBF2, 0xDBD1, 
        0xBAED, 0x8988, 0x6042, 0x88E6, 0x8084, 0x80A3, 0x9905, 0x8865, 0x8064, 0x8864, 0x90A4, 0x9909, 0x90E8, 0x90A8, 0x8089, 0x7887, 0x7889, 0x7889, 0x7889,
  0xA318, 0xA318, 0x9B18, 0x9B17, 0xA31A, 0xA33A, 0xA339, 0xA31A, 0xA33A, 0xA33A, 0xA33A, 0xA33A, 0xA35B, 0xA35A, 0xAB3A, 0xA33B, 0xAB5B, 0xAB5B, 0xA35B, 0xAB3B, 0xAB7B, 0xAB7B, 0xAB7B, 0xAB7B, 0xB37C, 0xAB7C, 0xAB7C, 0xAB7C, 0xBBBC, 0xB37C, 0xB37C, 
        0xB3BB, 0xB3B7, 0xABD4, 0xABF3, 0xB3F2, 0xBB98, 0xBB9C, 0xB39D, 0xA379, 0x9312, 0x8B2F, 0x8B4D, 0x8B6C, 0x9B93, 0x9B75, 0xA376, 0xA399, 0xAB9C, 0xAB9B, 0xA379, 0xA378, 0xC477, 0xCCB5, 0xCCB4, 0xDCD3, 0xECD2, 0xE4F2, 0xDD12, 0xDD11, 0xECF2, 
        0xE4F1, 0xE511, 0xDCF1, 0xE4D2, 0xDCD1, 0xDCAF, 0xD48F, 0xC48D, 0xC44D, 0xC44E, 0xBC4E, 0xB40C, 0x9BEB, 0x93EB, 0x9C2C, 0x942B, 0x9C4C, 0xA46D, 0xA4CF, 0xACF1, 0xB552, 0xBD73, 0xBD74, 0xC636, 0xD636, 0xD636, 0xD636, 0xD676, 0xD656, 0xCE15, 
        0xB5B4, 0xACF1, 0x9CF2, 0x94D1, 0x9470, 0x9CCD, 0xA46D, 0xAC4E, 0xBC90, 0xED53, 0xF574, 0xF595, 0xEDB6, 0xED73, 0xE553, 0xD4F2, 0xBC4F, 0xA44D, 0xA44D, 0x9C2D, 0x8BEC, 0x62EA, 0x6B4C, 0x73AE, 0x83F0, 0xB552, 0xAD72, 0xB592, 0xCD12, 0xF199, 
        0xF9DD, 0xFA7D, 0xFA9A, 0xF1B3, 0xE932, 0xE0D1, 0xD8AE, 0xD88E, 0xD8B0, 0xE0B1, 0xE8B1, 0xE933, 0xF133, 0xF934, 0xF934, 0xF9D7, 0xF175, 0xE0B1, 0xC82C, 0xC84C, 0xC86C, 0xC86C, 0xC88B, 0xC86D, 0xD06D, 0xD08D, 0xC8AD, 0xD8AF, 0xD0D0, 0xD0F1, 
        0xD8D2, 0xE0D2, 0xF112, 0xF174, 0xF996, 0xF156, 0xD091, 0xB80C, 0xB009, 0xB003, 0xB004, 0xB847, 0xE0CC, 0xFA97, 0xFA78, 0xFA17, 0xF1B6, 0xF195, 0xF9B6, 0xF9B5, 0xF174, 0xE934, 0xE933, 0xE933, 0xE113, 0xE913, 0xE0F3, 0xE112, 0xE133, 0xD8B1, 
        0xD8B1, 0xE111, 0xE993, 0xF175, 0xF996, 0xF9F8, 0xFA59, 0xFA38, 0xF9D7, 0xF197, 0xF998, 0xFA18, 0xF9F8, 0xF9F8, 0xF9F7, 0xF9B6, 0xF195, 0xF1B5, 0xF9D5, 0xF997, 0xF9D8, 0xFA19, 0xFA3B, 0xF999, 0xF174, 0xD90F, 0xA08A, 0x6022, 0x7844, 0xA0A8, 
        0xB90B, 0xA06A, 0xA08A, 0x9068, 0x6823, 0x8884, 0x9866, 0xA068, 0xA889, 0xA84A, 0xB08C, 0xC0AE, 0xC0CF, 0x4823, 0x4823, 0x5043, 0x5864, 0x5824, 0x5084, 0x4903, 0x4183, 0x4163, 0x3942, 0x4162, 0x4983, 0x2082, 0x7ACC, 0xCD76, 0xF7BE, 0xFFDF, 
        0xFFDF, 0xFFDF, 0xF7BD, 0xB511, 0x4A06, 0x2923, 0x5226, 0x70A5, 0x9128, 0xA168, 0x98C6, 0xB12A, 0xA94A, 0xA928, 0xA8C6, 0x7063, 0x6021, 0x6842, 0x78A5, 0xB1CC, 0xD311, 0xEBF5, 0xFC76, 0xF4D7, 0xFD19, 0xFD7A, 0xFDFC, 0xFE7C, 0xF63B, 0xEDB9, 
        0xED36, 0xFD36, 0xF556, 0xF536, 0xF515, 0xF597, 0xED56, 0xED14, 0xECF2, 0xED16, 0xECD6, 0xECD5, 0xE4F5, 0xDBF2, 0xD391, 0xBB0F, 0x9A6C, 0xCBCF, 0xBB0E, 0xAAAD, 0xAB2E, 0xF4F6, 0xECB4, 0xDC11, 0xD3AF, 0xD430, 0xBB8E, 0xBB4E, 0xCB90, 0xBB70, 
        0xBAEF, 0xAA6D, 0x89C9, 0x7042, 0x8063, 0x90C5, 0x98E6, 0x90A5, 0x90A5, 0x90A4, 0x9084, 0xA12A, 0x90C8, 0x88A8, 0x88CA, 0x6848, 0x7048, 0x7868, 0x8089,
  0xA319, 0x9B18, 0x9B17, 0x9B18, 0xA319, 0xA339, 0xA339, 0xA33A, 0xA31A, 0xA319, 0xA339, 0xA33A, 0xA33A, 0xA33A, 0xA33A, 0xA35B, 0xAB5A, 0xAB3A, 0xAB3B, 0xAB5B, 0xAB5B, 0xAB5A, 0xAB7A, 0xAB7B, 0xAB7C, 0xAB7C, 0xAB7B, 0xAB9B, 0xB39A, 0xBB9B, 0xB39C, 
        0xB3DC, 0xAB7B, 0xAB98, 0xABD4, 0xABF1, 0xBBB8, 0xBB9B, 0xB37C, 0xAB1C, 0x8AD6, 0x7290, 0x6AAD, 0x72CD, 0x8B2C, 0x9371, 0x9B55, 0x9B37, 0xAB7B, 0xAB5B, 0xA35A, 0x9B58, 0xBBF7, 0xBC56, 0xC475, 0xD494, 0xD492, 0xDCD1, 0xE4F1, 0xE4F2, 0xDCF2, 
        0xDCF2, 0xDCD1, 0xDCAF, 0xDCB0, 0xD4AF, 0xD48E, 0xD48E, 0xC44D, 0xB42D, 0xB40D, 0xABCC, 0xA3CB, 0xA40C, 0x9C4C, 0x9C4D, 0xACEE, 0xB4F0, 0xB511, 0xB552, 0xC593, 0xC5B3, 0xC5B4, 0xCDD5, 0xDE36, 0xD636, 0xD636, 0xD656, 0xC615, 0xBDF5, 0xBDB4, 
        0xB573, 0xAD12, 0xAD33, 0xA532, 0x94F1, 0xA510, 0xBD12, 0xC533, 0xD555, 0xF554, 0xED34, 0xE515, 0xDD15, 0xD473, 0xC452, 0xB450, 0xABEF, 0xAB8F, 0x9B8C, 0x8B69, 0x6B29, 0x634B, 0x73AD, 0x8C0F, 0xA492, 0xB574, 0xB592, 0xAD6F, 0xA4EF, 0xE296, 
        0xF21A, 0xFA5B, 0xFADA, 0xF132, 0xE0F1, 0xD8F1, 0xD0AF, 0xC88D, 0xD8CE, 0xE0CF, 0xE090, 0xF152, 0xF153, 0xF134, 0xF134, 0xFA17, 0xF1F7, 0xE154, 0xD02D, 0xC84B, 0xD04B, 0xC02B, 0xB00B, 0xC88C, 0xC08C, 0xC0AB, 0xC8AC, 0xD8D0, 0xD0AF, 0xD0CF, 
        0xD8D0, 0xE0B1, 0xE913, 0xF175, 0xF175, 0xC051, 0xB80C, 0xB007, 0xB023, 0xB002, 0xD88A, 0xF152, 0xFA36, 0xFA98, 0xF218, 0xF1B7, 0xF1B6, 0xF1B5, 0xF174, 0xF154, 0xF155, 0xE934, 0xE113, 0xD912, 0xE133, 0xD912, 0xE0F2, 0xE0F2, 0xE0F2, 0xD8B0, 
        0xD8F1, 0xE152, 0xF194, 0xF196, 0xF1B7, 0xF1F7, 0xFA18, 0xF9F8, 0xF1B8, 0xF1B8, 0xF9F8, 0xFA18, 0xFA19, 0xF9F8, 0xFA16, 0xF1D7, 0xF195, 0xF174, 0xF194, 0xF995, 0xF9B7, 0xFA18, 0xFA79, 0xFA18, 0xF196, 0xD8F2, 0xB02C, 0x6002, 0x8084, 0xA8C8, 
        0xB8CA, 0x988A, 0xA86A, 0x8847, 0x5822, 0x8863, 0x9866, 0xA868, 0xB087, 0xA049, 0xB06B, 0xD0AE, 0xD8EF, 0x5822, 0x4802, 0x4843, 0x5084, 0x5824, 0x50C4, 0x4924, 0x3143, 0x3943, 0x3963, 0x4183, 0x3963, 0x18A2, 0x9C0F, 0xEEB9, 0xFFDE, 0xFFFF, 
        0xFFFF, 0xFF9D, 0xDE16, 0x2924, 0x6328, 0x6348, 0x2102, 0x9A8A, 0x99A9, 0x8906, 0x9105, 0xB128, 0xA0C6, 0x9885, 0x9885, 0x6801, 0x5821, 0x68E4, 0xA24A, 0xD351, 0xEBF3, 0xFC55, 0xFCB7, 0xF4F8, 0xFD59, 0xFDBB, 0xFE3C, 0xFE9C, 0xF63B, 0xF5BA, 
        0xED18, 0xE493, 0xF556, 0xFD98, 0xFD37, 0xED18, 0xE515, 0xE513, 0xF4F5, 0xF535, 0xECF5, 0xF4D5, 0xF4B6, 0xD3D2, 0xCB71, 0xB2AE, 0x8189, 0x89A8, 0x9A89, 0xAB2B, 0xC3AF, 0xE4D6, 0xE493, 0xDC32, 0xDC12, 0xB32E, 0xB30E, 0xB30D, 0xB32B, 0xDC14, 
        0xD3D2, 0xB2CD, 0x7987, 0x6044, 0x78C5, 0x9926, 0xA127, 0x90A7, 0x88A5, 0x8884, 0x8884, 0xB129, 0x98C8, 0x8886, 0x8866, 0x7025, 0x7028, 0x7829, 0x7869,
  0xA31A, 0xA338, 0xA339, 0xA33A, 0xA359, 0xA33A, 0xA33A, 0xA31A, 0xA35A, 0xA35A, 0xA35A, 0xAB5A, 0xAB5B, 0xAB5B, 0xAB5B, 0xAB5B, 0xAB5B, 0xAB5B, 0xAB5B, 0xAB5C, 0xAB7B, 0xAB7B, 0xAB9B, 0xAB9B, 0xAB7C, 0xAB7C, 0xAB9C, 0xAB9B, 0xB3BA, 0xBBDB, 0xBBFA, 
        0xBBF7, 0xBC36, 0xB413, 0xB3F1, 0xB3F2, 0xB3D6, 0xB3BB, 0xB39D, 0xA37A, 0x8B33, 0x7B0D, 0x72E9, 0x72E7, 0x6AC8, 0x72ED, 0x8311, 0x8B15, 0xA358, 0x9B38, 0x9B37, 0x9B56, 0xAB76, 0xB3D5, 0xB434, 0xC453, 0xDC93, 0xDCB2, 0xDCB2, 0xDCB1, 0xDCF2, 
        0xDCD2, 0xDCB1, 0xD490, 0xD470, 0xCC70, 0xD46F, 0xD44E, 0xCC2D, 0xBC4D, 0xB44D, 0xAC2C, 0xB44D, 0xAC90, 0xA4B0, 0xA490, 0xB552, 0xB572, 0xBD92, 0xC5B3, 0xBDD5, 0xC5F5, 0xD616, 0xDE56, 0xD656, 0xD636, 0xCE56, 0xCE55, 0xBDD4, 0xBDD4, 0xBDB4, 
        0xB594, 0xB574, 0xB574, 0xB573, 0xB573, 0xBD53, 0xB553, 0xB553, 0xBD54, 0xE554, 0xED54, 0xE553, 0xD553, 0xDD34, 0xC492, 0xA430, 0x8C2F, 0x8CAC, 0x840C, 0x838C, 0x736C, 0x6B8C, 0x738D, 0x7BCF, 0x9450, 0xB511, 0xAD10, 0xA4EF, 0xB44F, 0xEABB, 
        0xFA5D, 0xFA9B, 0xFAD8, 0xF1D6, 0xE913, 0xE8F2, 0xE8F1, 0xE06F, 0xD88D, 0xD88D, 0xE0AF, 0xF993, 0xF954, 0xF8F3, 0xF0D2, 0xFA99, 0xFB1D, 0xFAFC, 0xFA56, 0xE8AF, 0xE8CF, 0xE0CF, 0xD86D, 0xD04B, 0xC04B, 0xB86C, 0xB88D, 0xD84D, 0xD88F, 0xE0F1, 
        0xE932, 0xF111, 0xF974, 0xF153, 0xD88F, 0xC80B, 0xB008, 0xA805, 0xB023, 0xF132, 0xFA17, 0xFA7A, 0xFA79, 0xF9B6, 0xF9B7, 0xF1B7, 0xF176, 0xF175, 0xE933, 0xE912, 0xE913, 0xF154, 0xE913, 0xE0F2, 0xE932, 0xE934, 0xE933, 0xE932, 0xE112, 0xE090, 
        0xD8F0, 0xE132, 0xF954, 0xF9F7, 0xFA17, 0xFA38, 0xFA79, 0xF198, 0xF9B8, 0xF9D8, 0xF9F7, 0xFA1A, 0xFA19, 0xFA39, 0xFA38, 0xF9D7, 0xF9B6, 0xF175, 0xF134, 0xF953, 0xF194, 0xF1F6, 0xFA59, 0xFA5C, 0xFA9C, 0xFA5A, 0xE9B4, 0x9845, 0x9846, 0xA889, 
        0xB0AB, 0x988B, 0xA8AB, 0x9888, 0x7024, 0x6842, 0x9064, 0xA847, 0xB049, 0xB06A, 0xA88A, 0xB0AC, 0xC0CF, 0xA0CC, 0x6045, 0x4822, 0x5864, 0x5823, 0x5084, 0x4903, 0x3943, 0x3942, 0x4122, 0x3942, 0x3142, 0x3061, 0x40E3, 0x8B6D, 0xEF5D, 0xF73C, 
        0xBD34, 0x6ACB, 0x18C2, 0x840A, 0x946C, 0x83CA, 0x6AA6, 0x80C5, 0x9107, 0x9947, 0xA106, 0xB107, 0xA8E6, 0xA8E6, 0xA0C7, 0x7062, 0x7063, 0x78A5, 0x8947, 0xD2F0, 0xEBF4, 0xF476, 0xFCD7, 0xFD37, 0xFD59, 0xFD9B, 0xFDFC, 0xFE5E, 0xFE7D, 0xFE7C, 
        0xFE3B, 0xECF8, 0xF4F6, 0xF4F6, 0xF517, 0xFDD9, 0xF5B7, 0xF576, 0xFD16, 0xECF6, 0xF4F5, 0xF4F5, 0xECF5, 0xEC74, 0xE454, 0xECB5, 0xED15, 0xA2EC, 0x6925, 0x60A4, 0x8968, 0xAAAC, 0xD391, 0xECB4, 0xF576, 0xDBD1, 0xDBB0, 0xCB8F, 0xAB0D, 0xC370, 
        0xE492, 0xECD4, 0xD3D2, 0x6082, 0x7042, 0x88A5, 0x9907, 0xA148, 0x98E7, 0x90C6, 0x98C5, 0x90A6, 0x98E7, 0x88A6, 0x7045, 0xB9AF, 0x996E, 0x80CB, 0x7028,
  0xA339, 0xA339, 0xA339, 0xA339, 0xA339, 0xA33A, 0xA33A, 0xA33A, 0xA35A, 0xA35B, 0xA35B, 0xA33A, 0xAB5B, 0xAB5B, 0xAB5B, 0xAB5B, 0xA35B, 0xAB5C, 0xAB7C, 0xAB7C, 0xAB5C, 0xAB7C, 0xAB7C, 0xAB7C, 0xAB7C, 0xB37C, 0xB39C, 0xABBC, 0xB3F8, 0xBBF8, 0xBBF7, 
        0xB3F5, 0xB454, 0xB412, 0xB411, 0xB452, 0xB3D5, 0xB3B8, 0xB39B, 0xA35C, 0x82F3, 0x7AED, 0x72CA, 0x6A87, 0x6266, 0x6A89, 0x72CD, 0x82F2, 0x9356, 0x9B35, 0x9B35, 0x9B76, 0x9375, 0xA3B5, 0xB415, 0xBC53, 0xC454, 0xCC73, 0xD492, 0xD4B2, 0xDCB2, 
        0xDCD2, 0xD4D0, 0xD4AF, 0xD48F, 0xD46F, 0xC44E, 0xBC2D, 0xB42D, 0xB44D, 0xAC4D, 0xA42D, 0xAC6E, 0xAD11, 0xAD33, 0xB534, 0xC5B3, 0xC5F4, 0xBDF5, 0xBDF5, 0xD655, 0xD656, 0xD657, 0xD697, 0xCE35, 0xD635, 0xCE15, 0xBDD5, 0xBDD4, 0xBDB4, 0xBDB4, 
        0xBDF5, 0xC615, 0xCE36, 0xCE36, 0xCE36, 0xC5D5, 0xCDD5, 0xD5D5, 0xDDB6, 0xE577, 0xE556, 0xDD34, 0xCCD3, 0xCCB3, 0xC4F2, 0xC512, 0xC4F2, 0x84AD, 0x842D, 0x83CD, 0x73AE, 0x6B6D, 0x7B8E, 0x83D0, 0x8C31, 0x946F, 0x946F, 0x8C2D, 0x83EC, 0xDB59, 
        0xF27D, 0xFA5E, 0xFADC, 0xE9D5, 0xE131, 0xE8EF, 0xE8CF, 0xD86D, 0xD86D, 0xE0AE, 0xF130, 0xF154, 0xF0D2, 0xF8D2, 0xF9B5, 0xFAFE, 0xFABE, 0xF25D, 0xF25B, 0xF9F8, 0xF996, 0xF955, 0xF933, 0xE112, 0xD8D0, 0xD06D, 0xC82B, 0xD06E, 0xE0EF, 0xE931, 
        0xE933, 0xE912, 0xE8F1, 0xD8AF, 0xB84C, 0xB007, 0xB004, 0xC886, 0xF190, 0xFA3A, 0xFA19, 0xF9F7, 0xF9F6, 0xF996, 0xF996, 0xF175, 0xE914, 0xF113, 0xE912, 0xE132, 0xE133, 0xE0F2, 0xE913, 0xE0F2, 0xE0F1, 0xE954, 0xE954, 0xE913, 0xE0F2, 0xE0D1, 
        0xD8D1, 0xE113, 0xF195, 0xFA17, 0xFA37, 0xFA59, 0xFA5A, 0xF9F7, 0xF9D8, 0xF9B8, 0xF996, 0xF9D9, 0xFA19, 0xFA59, 0xFA59, 0xF9D6, 0xF1B5, 0xF174, 0xF113, 0xE932, 0xE953, 0xF195, 0xFA18, 0xFA7A, 0xFA7B, 0xFA7A, 0xF257, 0xC06B, 0xB069, 0xA88A, 
        0xA86A, 0x98AA, 0xA8AA, 0xA089, 0x8025, 0x7042, 0x9864, 0xA866, 0xA869, 0xA869, 0xB04A, 0xB86C, 0xC08D, 0xC8EE, 0x7867, 0x4843, 0x4863, 0x5823, 0x5063, 0x48E3, 0x4163, 0x4141, 0x3922, 0x4123, 0x4944, 0x1881, 0x4164, 0x836D, 0xCDB6, 0x6A65, 
        0x4102, 0x4984, 0x6B0A, 0x7326, 0x83EA, 0x7369, 0x49A3, 0x7864, 0x9928, 0xA98A, 0xB149, 0xA8C9, 0xB0C8, 0xB0C7, 0xA085, 0x5821, 0x6063, 0x7926, 0x9A2A, 0xDB11, 0xF3F4, 0xFCB6, 0xFD37, 0xFD1B, 0xFD5A, 0xFD9A, 0xFDFB, 0xFE1C, 0xFE3D, 0xFE5D, 
        0xFE5D, 0xED79, 0xF558, 0xFD56, 0xF516, 0xFD38, 0xF597, 0xF5B7, 0xFD77, 0xECD4, 0xECB5, 0xECB5, 0xECB4, 0xED16, 0xECF6, 0xECB6, 0xE475, 0xAB2D, 0x6A06, 0x61E4, 0x8247, 0xA1E8, 0xBAED, 0xBB8F, 0xB36F, 0xDBB2, 0xDC11, 0xD3F0, 0xCB50, 0xCBD0, 
        0xDC11, 0xCBD1, 0xA2CE, 0x5862, 0x7064, 0x88A6, 0x90C7, 0x90E6, 0x90E7, 0x90C8, 0x98A8, 0x98A6, 0x98E7, 0x98A7, 0xA066, 0x9AB0, 0x91AD, 0x80A9, 0x7005,
  0xA319, 0x9B19, 0x9B19, 0xA318, 0x9B39, 0xA319, 0xA33A, 0xA35A, 0xA31A, 0xA31A, 0xA33A, 0xA31A, 0xA35A, 0xA35A, 0xA33A, 0xAB3A, 0xAB5C, 0xAB5C, 0xAB5B, 0xAB5B, 0xB37B, 0xAB7B, 0xAB7B, 0xAB7C, 0xAB7B, 0xB39C, 0xB3BB, 0xB3BB, 0xC459, 0xBC17, 0xB3D4, 
        0xB3D2, 0xABD0, 0xAC0F, 0xB44D, 0xB44C, 0xB413, 0xB397, 0xB359, 0xA338, 0x7A8D, 0x6A89, 0x6268, 0x6267, 0x6AA6, 0x6AA7, 0x72AA, 0x82EF, 0x9B15, 0x9B53, 0x9B52, 0x9B53, 0x9312, 0x9B53, 0xA3B3, 0xB3F3, 0xABB3, 0xB3D2, 0xBC13, 0xBC33, 0xC454, 
        0xBC32, 0xBC12, 0xBC13, 0xC3F2, 0xB3CE, 0xABAC, 0xA3CC, 0x9BCE, 0xA42E, 0xA44E, 0xA44E, 0xACD1, 0xB574, 0xBDB5, 0xBDD4, 0xCE56, 0xCE77, 0xCE56, 0xCE56, 0xD677, 0xCE57, 0xCE56, 0xCE56, 0xBDF5, 0xC5F5, 0xC5F5, 0xC5F5, 0xCE36, 0xCE77, 0xD678, 
        0xDE98, 0xD6D8, 0xE6F9, 0xE6D9, 0xDEB7, 0xDE98, 0xDE57, 0xD637, 0xDDF6, 0xD5F6, 0xD575, 0xCD14, 0xC4F4, 0xDE58, 0xDE37, 0xD5D6, 0xC5B6, 0x9D0E, 0x946E, 0x8C0E, 0x73CD, 0x7C0E, 0x7BAE, 0x7B6E, 0x7B8D, 0x83AD, 0x7BAC, 0x6329, 0x5AA9, 0xE35B, 
        0xFA9C, 0xFA5A, 0xF2D9, 0xE933, 0xD931, 0xC910, 0xC8D1, 0xE04D, 0xD86C, 0xD8CD, 0xF111, 0xF0F3, 0xF0D2, 0xF954, 0xFA59, 0xFABD, 0xFA7D, 0xFA7D, 0xFABD, 0xF9D8, 0xF1B6, 0xF1D6, 0xF9F5, 0xF9D4, 0xE932, 0xE0B1, 0xD890, 0xD8AD, 0xD8CD, 0xD0CD, 
        0xC88D, 0xD86D, 0xD02C, 0xB00A, 0x9008, 0xB024, 0xD96C, 0xFA53, 0xFA78, 0xF996, 0xF996, 0xF995, 0xF174, 0xE113, 0xD8D1, 0xD8D0, 0xE0F1, 0xE0D1, 0xE0F1, 0xE112, 0xD912, 0xE0F2, 0xD8D2, 0xE0F2, 0xE132, 0xE153, 0xE934, 0xE113, 0xD8D3, 0xD890, 
        0xE112, 0xE974, 0xF1D5, 0xFA18, 0xFA39, 0xFA18, 0xF9F8, 0xF9F9, 0xF9B8, 0xF997, 0xF996, 0xF9D8, 0xFA18, 0xFA39, 0xFA39, 0xF1D5, 0xE973, 0xE952, 0xE953, 0xD8F2, 0xE934, 0xF1B6, 0xFA18, 0xFAB9, 0xFA7B, 0xFA5B, 0xF1F7, 0xC04B, 0xB069, 0xB08A, 
        0xA86B, 0xA08A, 0xA08A, 0x9869, 0x8026, 0x8062, 0x9065, 0xA086, 0xA8A5, 0xB86A, 0xB049, 0xB08B, 0xC8CD, 0xB8ED, 0x8867, 0x6024, 0x4823, 0x4843, 0x4863, 0x48C3, 0x4944, 0x3141, 0x3922, 0x4123, 0x3903, 0x2141, 0x3922, 0x5163, 0x6205, 0x6264, 
        0x6245, 0x6A66, 0x72A8, 0x8368, 0x8389, 0x5266, 0x2082, 0xA9A8, 0xB9CA, 0xC18A, 0xC909, 0xA886, 0xA0A6, 0x9084, 0x7002, 0x5021, 0x8946, 0xBA6C, 0xDB92, 0xFC97, 0xFCD8, 0xFCF8, 0xFD39, 0xF57A, 0xF57A, 0xFD7A, 0xFDDB, 0xFE5D, 0xFE5D, 0xFE3C, 
        0xF5DB, 0xECD6, 0xECB6, 0xF517, 0xFDBA, 0xF578, 0xF577, 0xED36, 0xE4F6, 0xED14, 0xED15, 0xE4D4, 0xDC53, 0xF5F9, 0xFD99, 0xECD6, 0xC3B0, 0x6225, 0x59A2, 0x61A4, 0x79C7, 0x80E5, 0xB24B, 0xC34F, 0xC3D0, 0xE454, 0xD3D1, 0xCB6F, 0xCB4E, 0xC3AE, 
        0xDC31, 0xB2ED, 0x6064, 0x6005, 0x80A6, 0x90C6, 0x88C5, 0x90E6, 0x90C7, 0x98C8, 0xA0A7, 0x8864, 0x90C5, 0xBA4C, 0xDBD4, 0x8089, 0x7026, 0x7026, 0x7025,
  0xA319, 0xA339, 0xA339, 0xA319, 0xA33A, 0xA35A, 0xA33A, 0xA33A, 0xA33A, 0xA33B, 0xAB5B, 0xAB5B, 0xA37B, 0xAB5B, 0xAB5B, 0xAB5B, 0xAB7A, 0xAB7B, 0xAB7C, 0xAB5C, 0xAB9B, 0xB39C, 0xB39C, 0xAB9C, 0xB37C, 0xB3DD, 0xBBFD, 0xB41C, 0xB459, 0xBC35, 0xBC12, 
        0xB42E, 0xAC2D, 0xAC0C, 0xAC0B, 0xAC2B, 0xB3F0, 0xBBF4, 0xB3B6, 0xA375, 0x930D, 0x7AE9, 0x72A8, 0x7AA8, 0x8BAA, 0x836A, 0x834B, 0x8B4D, 0x9351, 0x9B70, 0xA390, 0xABB2, 0xA312, 0xA372, 0xABB2, 0xABD1, 0xAB71, 0xAB90, 0xB392, 0xBB95, 0xBC14, 
        0xBC12, 0xBC11, 0xB3F1, 0xBBD1, 0xABD1, 0xA3D0, 0x9BCE, 0x93CE, 0x942E, 0x9C4F, 0xA451, 0xA531, 0xB594, 0xBDD5, 0xC615, 0xCE97, 0xD697, 0xD697, 0xD677, 0xD697, 0xD697, 0xD677, 0xD657, 0xBE36, 0xC5F5, 0xC615, 0xCE76, 0xDE98, 0xE6D8, 0xE6F8, 
        0xE6F8, 0xE71A, 0xE6FA, 0xE6FA, 0xEEDA, 0xE6B7, 0xE697, 0xDE77, 0xD656, 0xDE16, 0xDDD5, 0xD5B4, 0xCD93, 0xDDF8, 0xE618, 0xDE17, 0xD5F5, 0xAD33, 0x94D1, 0x8490, 0x742F, 0x7BEF, 0x73CF, 0x73AE, 0x7BAE, 0x736E, 0x736C, 0x6B09, 0x6288, 0xCAF8, 
        0xEA9C, 0xFA9C, 0xFAFA, 0xF9D5, 0xE932, 0xD8D0, 0xE06E, 0xD88E, 0xE0AF, 0xE8D0, 0xF8F2, 0xF115, 0xF9D8, 0xFA5B, 0xFA7D, 0xFA7C, 0xFA5C, 0xFA5C, 0xFA5C, 0xFA7C, 0xFA7B, 0xFA59, 0xFA38, 0xFA19, 0xFA5A, 0xFA99, 0xFA97, 0xF1D3, 0xE0CF, 0xD86D, 
        0xD84C, 0xC809, 0xB808, 0xB008, 0xC049, 0xF252, 0xFA75, 0xF9F6, 0xF934, 0xF153, 0xF132, 0xE0F1, 0xD0B1, 0xD0AF, 0xD08E, 0xD08F, 0xD8B1, 0xD8AF, 0xE110, 0xE111, 0xD8D0, 0xE0F1, 0xE0D1, 0xE0F2, 0xE913, 0xE953, 0xE933, 0xE933, 0xE152, 0xD8D1, 
        0xE132, 0xF175, 0xF9B6, 0xFA57, 0xFA38, 0xFA38, 0xFA58, 0xF998, 0xF177, 0xF176, 0xF9B7, 0xFA39, 0xFA3A, 0xFA3A, 0xF9F8, 0xF155, 0xF154, 0xF153, 0xF153, 0xE912, 0xE912, 0xF154, 0xF9B6, 0xFA59, 0xFA7B, 0xFA7C, 0xFA7C, 0xF9F4, 0xD8ED, 0xB88A, 
        0xA8AB, 0xA84B, 0xB08C, 0xA88A, 0x8826, 0x8044, 0x9065, 0xA086, 0xA8C8, 0xB049, 0xB86A, 0xB08B, 0xB08C, 0xE951, 0xB0CC, 0x7045, 0x3801, 0x4822, 0x5044, 0x4885, 0x40E3, 0x3942, 0x4164, 0x4944, 0x4901, 0x28C1, 0x5226, 0x730A, 0x8BAB, 0xB4AE, 
        0x93CA, 0x6AA6, 0x51E5, 0x8BEB, 0x6A87, 0x4103, 0x2862, 0xA9CA, 0xB9CB, 0xB149, 0xA8C7, 0xA025, 0xA045, 0x9044, 0x6821, 0x7883, 0x9928, 0xBA0D, 0xDB52, 0xF454, 0xFC75, 0xFCB8, 0xFD1A, 0xFD5A, 0xF57A, 0xF57A, 0xFD5A, 0xFDBC, 0xFE1D, 0xFE5D, 
        0xFE7C, 0xF5FB, 0xF558, 0xF537, 0xF557, 0xFD37, 0xFD98, 0xF5BA, 0xED79, 0xF514, 0xED34, 0xE535, 0xED36, 0xED38, 0xED16, 0xE495, 0xCBD3, 0xAB8D, 0xA3AC, 0xA3CB, 0x9B48, 0x48C2, 0x5041, 0x70E4, 0x9A09, 0xB2ED, 0xDC73, 0xF4F5, 0xE411, 0xBAED, 
        0xC36F, 0xC38F, 0xAAED, 0x6885, 0x7046, 0x7867, 0x8066, 0x7884, 0x88C7, 0x88C8, 0x88A7, 0x98A8, 0x9108, 0x99AA, 0xB22D, 0xA10B, 0x8088, 0x7068, 0x788A,
  0xA339, 0xA339, 0xA33A, 0xA33A, 0xA35A, 0xA33A, 0xA33A, 0xA35A, 0xAB3B, 0xAB5B, 0xAB5B, 0xA35B, 0xAB5B, 0xAB5B, 0xAB7C, 0xAB7C, 0xAB5B, 0xAB7C, 0xAB7C, 0xAB7C, 0xAB9C, 0xAB9C, 0xB39C, 0xB39C, 0xBBDC, 0xB3DC, 0xBC1C, 0xC47C, 0xBC55, 0xB412, 0xB40F, 
        0xA40D, 0x9B8D, 0xA3CC, 0xAC0B, 0xAC6B, 0xBC4F, 0xBC11, 0xABD2, 0xA3B3, 0x932C, 0x8B0A, 0x8B09, 0x92EA, 0x9B8B, 0x9B6B, 0xA34C, 0xA32D, 0xA38F, 0xB3B0, 0xBBD1, 0xBBD1, 0xB3D0, 0xB3AE, 0xAB8D, 0xA34D, 0x9B0E, 0xA32E, 0xA350, 0xAB71, 0xB351, 
        0xB392, 0xB3D3, 0xA3D3, 0x9BB2, 0x9B74, 0x9B73, 0x9BB0, 0x834D, 0x8BAE, 0x940F, 0x9C71, 0xA4F2, 0xAD53, 0xB595, 0xBDF6, 0xCE36, 0xDE77, 0xDE98, 0xD697, 0xDE98, 0xDE98, 0xD677, 0xD657, 0xD677, 0xD656, 0xD656, 0xE6B7, 0xE71A, 0xE6F9, 0xEF1A, 
        0xEF7B, 0xF73B, 0xEF1A, 0xEEF8, 0xDEB7, 0xE6D6, 0xE6F7, 0xE6F6, 0xDEF5, 0xD5B4, 0xD5D4, 0xDE35, 0xE6B6, 0xDE36, 0xE677, 0xE697, 0xE656, 0xD595, 0xAD12, 0x9C91, 0x9C4F, 0x6BCE, 0x7BCF, 0x738E, 0x630C, 0x732D, 0x7B0E, 0x6B2E, 0x632E, 0xC2D6, 
        0xEA5B, 0xFA3D, 0xFA9C, 0xF9F6, 0xE931, 0xE0AF, 0xD86E, 0xD88E, 0xE0AF, 0xF0F0, 0xF953, 0xF9FB, 0xFA5C, 0xFA9D, 0xFA7D, 0xFA3C, 0xFA7D, 0xFA7D, 0xFA3C, 0xFA3B, 0xFA5C, 0xFA5C, 0xFA7C, 0xFA5C, 0xFA7A, 0xFA58, 0xFA16, 0xFA39, 0xFA39, 0xF9B7, 
        0xF0F1, 0xE04A, 0xD04B, 0xD8AF, 0xF994, 0xFA16, 0xE952, 0xE8F0, 0xE8F1, 0xD0B0, 0xD88F, 0xD08E, 0xC88E, 0xD08E, 0xD8CF, 0xD0B0, 0xC890, 0xC8B0, 0xD0B0, 0xD8AF, 0xD8CF, 0xD8D1, 0xD8B1, 0xD8D1, 0xD8F2, 0xE934, 0xF155, 0xF174, 0xE933, 0xD891, 
        0xE8F2, 0xF174, 0xF9D7, 0xF279, 0xFA59, 0xFA18, 0xF1F8, 0xF956, 0xF976, 0xF977, 0xF999, 0xFA3B, 0xFA3B, 0xFA3A, 0xFA38, 0xF135, 0xF134, 0xF134, 0xF113, 0xF152, 0xF952, 0xF932, 0xF933, 0xFA59, 0xFA7B, 0xFA3B, 0xF9FB, 0xF21A, 0xE972, 0xD0CD, 
        0xB08B, 0xB08B, 0xB0AB, 0xA88A, 0x9827, 0x9044, 0x9084, 0x9886, 0xA069, 0xB849, 0xB86B, 0xB86B, 0xB04B, 0xE8F0, 0xC0ED, 0x8887, 0x5001, 0x4822, 0x5024, 0x4865, 0x40C5, 0x4162, 0x4142, 0x40E2, 0x48A1, 0x61E6, 0x7B2A, 0x7329, 0x5A66, 0x9C0B, 
        0x8B6A, 0x7B4A, 0x83CC, 0x7A89, 0x3904, 0x4082, 0x9966, 0xCB6F, 0xA189, 0x9064, 0x90A5, 0x98E6, 0xA0A5, 0x9064, 0x7023, 0x8106, 0x916A, 0xA1CB, 0xAA6C, 0xEBD4, 0xFC77, 0xFCFA, 0xFD5B, 0xFD5B, 0xFD7B, 0xFD7B, 0xFD5A, 0xFE1D, 0xFDFD, 0xFDFC, 
        0xFE1B, 0xF63A, 0xF5D9, 0xF599, 0xFD78, 0xF516, 0xF536, 0xF597, 0xF5FA, 0xFD37, 0xE4D5, 0xE4D6, 0xF538, 0xDC95, 0xDCD5, 0xD4B3, 0xBC0E, 0x936A, 0x9BA9, 0x9368, 0x82E7, 0xAB2B, 0x9A6A, 0x91E9, 0x99C9, 0xAA8D, 0xCBB1, 0xDC33, 0xE433, 0xDBD0, 
        0xC36E, 0xB30C, 0xA26B, 0xAA2F, 0x912A, 0x7886, 0x70A4, 0x80C6, 0x80C5, 0x80C6, 0x90C8, 0x9909, 0x9108, 0x9928, 0xA128, 0x8088, 0x810C, 0x892D, 0x88EC,
  0xA319, 0xA319, 0xA319, 0x9B19, 0xA319, 0xA339, 0xA35A, 0xA35A, 0xAB3B, 0xA33B, 0xA35B, 0xAB5A, 0xA35B, 0xAB5B, 0xAB5B, 0xAB5B, 0xAB5C, 0xAB5C, 0xAB5B, 0xAB5C, 0xAB7C, 0xAB7B, 0xAB7B, 0xB3BC, 0xB3DC, 0xBBFC, 0xBC1C, 0xBC3B, 0xBC78, 0xB3F3, 0xA38E, 
        0x8B4A, 0x8B48, 0x93A9, 0x9BCA, 0xA3CA, 0xBC4D, 0xB42E, 0xB3EF, 0xAB8F, 0x934C, 0x934B, 0x9B6C, 0xAB8D, 0xAC0D, 0xABCD, 0xB38D, 0xB3AD, 0xB38E, 0xBBCF, 0xC430, 0xCC71, 0xBBCE, 0xAB6E, 0xA34D, 0x9B0B, 0x9ACC, 0x9AEE, 0xA330, 0xAB72, 0xAB71, 
        0xAB92, 0xAB93, 0x9B94, 0x9B54, 0x92F3, 0x8AD2, 0x8ACF, 0x6B2C, 0x7B6A, 0x83CC, 0x7C51, 0xA492, 0xA4F3, 0xA553, 0xB573, 0xC5D6, 0xC616, 0xCE36, 0xCE37, 0xCE57, 0xCE57, 0xCE56, 0xCE56, 0xD677, 0xD697, 0xDE98, 0xE6B8, 0xE6F9, 0xDED9, 0xDEFA, 
        0xE73B, 0xDE98, 0xDEB7, 0xDEB6, 0xDED7, 0xDED7, 0xE6D6, 0xEEF6, 0xEF17, 0xE716, 0xE6D7, 0xDEB8, 0xDF18, 0xEF58, 0xDEB6, 0xCE15, 0xB572, 0xAD92, 0xAD11, 0x948F, 0x7BEE, 0x7BED, 0x736D, 0x6B4D, 0x736F, 0x7B2E, 0x8AEF, 0x7AB0, 0x62AF, 0xABD8, 
        0xE35A, 0xFABB, 0xFA5B, 0xF154, 0xE0D1, 0xD890, 0xD08E, 0xE08D, 0xE8CF, 0xF131, 0xF974, 0xFA9C, 0xFA7B, 0xFA5A, 0xFA5B, 0xF9FB, 0xFA3B, 0xFA5B, 0xFA1C, 0xF9FA, 0xFA3B, 0xFA5C, 0xFA5B, 0xFA39, 0xFA19, 0xF9D9, 0xF959, 0xFA7D, 0xFA7C, 0xFA39, 
        0xF9B5, 0xE04F, 0xE8F0, 0xF172, 0xF194, 0xD851, 0xD06F, 0xD08D, 0xD86B, 0xD04E, 0xC86E, 0xC88D, 0xC8AC, 0xC08E, 0xC08D, 0xC08D, 0xC88F, 0xD0AF, 0xD0B0, 0xC890, 0xD090, 0xD891, 0xC8B0, 0xD0D0, 0xD8D0, 0xE934, 0xE975, 0xE975, 0xE974, 0xE0F2, 
        0xE934, 0xF196, 0xF1D7, 0xF238, 0xFA38, 0xF9F8, 0xF1B7, 0xF137, 0xF978, 0xF9D8, 0xFA17, 0xFA1A, 0xFA1A, 0xFA19, 0xF1F7, 0xE913, 0xE933, 0xE933, 0xE8F2, 0xF9B3, 0xF173, 0xF154, 0xF195, 0xFA78, 0xF9FA, 0xF9DB, 0xFA3B, 0xF1D6, 0xD932, 0xC8AE, 
        0xB86B, 0xB08A, 0xA889, 0xA067, 0x9025, 0x8864, 0x9085, 0x9886, 0xA867, 0xB868, 0xB869, 0xB86A, 0xC06B, 0xD90E, 0xC8CD, 0xA069, 0x6804, 0x4802, 0x4842, 0x5043, 0x5866, 0x48E6, 0x28E2, 0x30E1, 0x5102, 0x72C7, 0x7B09, 0x6AA7, 0x5204, 0xAC2D, 
        0x93CB, 0x8349, 0x7AE9, 0x4943, 0x5984, 0x8A67, 0xC30B, 0x90C7, 0x9886, 0xA885, 0xB065, 0xA0A4, 0x8082, 0x7041, 0x6862, 0x5982, 0xAB0A, 0xCBEF, 0xC451, 0xE537, 0xF578, 0xFD7A, 0xFD5C, 0xF4F7, 0xF519, 0xF53A, 0xFD1A, 0xFE3C, 0xFE3D, 0xFE3D, 
        0xFE1C, 0xF599, 0xED38, 0xED37, 0xED97, 0xFDB9, 0xF558, 0xECF6, 0xDCB5, 0xE517, 0xED16, 0xED15, 0xE536, 0xED37, 0xD474, 0xAB2E, 0x79E8, 0x92AC, 0xBC4F, 0xB46D, 0x8B47, 0xA2CA, 0x8A07, 0x71C4, 0x8204, 0xDC31, 0xED35, 0xED16, 0xD454, 0xC36C, 
        0xCBCE, 0xD3D0, 0xBB0D, 0x68A4, 0x6085, 0x6065, 0x6023, 0x6865, 0x8886, 0x98A7, 0x98E9, 0x80A5, 0x90E7, 0xA96A, 0xA98A, 0x6845, 0x80C7, 0x80C8, 0x7048,
  0xA33A, 0xA33A, 0xA33A, 0xA33A, 0xAB59, 0xA35A, 0xA35B, 0xA35A, 0xA33B, 0xA35B, 0xAB5B, 0xAB5B, 0xAB7B, 0xAB7B, 0xAB7B, 0xAB5C, 0xB37C, 0xAB7C, 0xAB7C, 0xAB7C, 0xB39D, 0xAB7C, 0xAB7C, 0xB39D, 0xC3FD, 0xC45C, 0xC45B, 0xC47A, 0xC476, 0xBC14, 0x9BAF, 
        0x7B49, 0x8305, 0x8B27, 0x9369, 0x9BCA, 0xAC2A, 0xB40D, 0xB3EE, 0xA3CE, 0xAB8E, 0xABAD, 0xAB8D, 0xB36E, 0xBC2E, 0xC3EE, 0xBBAD, 0xB38D, 0xB3AE, 0xBBCD, 0xBBED, 0xBC0E, 0xC470, 0xBC30, 0xB3EF, 0xAB8E, 0xA32D, 0xA32E, 0xA34F, 0xB36F, 0xA392, 
        0xAB93, 0xA393, 0x9B93, 0x8B10, 0x82AF, 0x7A6D, 0x6A2A, 0x72EB, 0x6B2C, 0x6B6D, 0x7BEE, 0x9CAF, 0x9CD1, 0x9CF2, 0xAD34, 0xB595, 0xBDB5, 0xC5F6, 0xCE16, 0xD698, 0xD677, 0xCE56, 0xD656, 0xD677, 0xD676, 0xD676, 0xDE97, 0xDE97, 0xD696, 0xDEB6, 
        0xE6D8, 0xDEF8, 0xE6F7, 0xE6F7, 0xE717, 0xEF39, 0xEF59, 0xEF59, 0xF759, 0xFFBA, 0xFF9A, 0xF779, 0xEF57, 0xD695, 0xD655, 0xDEB7, 0xEF18, 0xBDD3, 0x9491, 0x83AF, 0x7B6E, 0x736E, 0x7B4F, 0x7B30, 0x8331, 0x7B32, 0x8312, 0x7B11, 0x6330, 0x7AD0, 
        0xCAF7, 0xF2DC, 0xFA5D, 0xF9D8, 0xF134, 0xE8B0, 0xD86D, 0xE0CE, 0xF0D0, 0xF8F1, 0xF953, 0xFA5C, 0xFA9D, 0xFA7C, 0xFA1B, 0xFA5B, 0xFA5D, 0xFA3C, 0xF9FA, 0xFA1B, 0xFA3B, 0xFA5C, 0xFA7C, 0xFA3B, 0xF9D9, 0xF9F9, 0xFA7B, 0xFA9E, 0xFA9D, 0xFA7C, 
        0xFA5B, 0xFA15, 0xF994, 0xF0F1, 0xE06E, 0xC82D, 0xC80C, 0xC80B, 0xC82B, 0xD84D, 0xC86C, 0xC06C, 0xD08D, 0xC08D, 0xC06D, 0xC86E, 0xC86F, 0xD08E, 0xC86E, 0xD08E, 0xD8D0, 0xD8D1, 0xE0F1, 0xE112, 0xE954, 0xF173, 0xF175, 0xF9B6, 0xF9F5, 0xE8F3, 
        0xF154, 0xF995, 0xF9B7, 0xFA38, 0xF9F8, 0xF9D7, 0xF196, 0xF976, 0xF9B8, 0xFA19, 0xFA5A, 0xF9F7, 0xFA18, 0xFA39, 0xFA38, 0xF175, 0xE913, 0xE8F2, 0xF0F1, 0xF112, 0xF132, 0xF173, 0xF9D5, 0xF9FB, 0xF9FB, 0xFA1B, 0xFA1B, 0xFA37, 0xF1B5, 0xE131, 
        0xC08B, 0xA069, 0xA0A9, 0xA088, 0x9045, 0x9886, 0x9865, 0xA847, 0xB869, 0xB089, 0xB069, 0xB04A, 0xB06B, 0xD0ED, 0xD10F, 0xC0CD, 0x9047, 0x3842, 0x3041, 0x3842, 0x4023, 0x30A2, 0x3962, 0x5A04, 0x7A85, 0x7AE8, 0x7B28, 0x7308, 0x6AA8, 0x8327, 
        0x9B8A, 0x93CC, 0x6BAA, 0x41E5, 0x9B0A, 0xC34C, 0xA22A, 0xA085, 0xA8A7, 0xB0E7, 0xA0C5, 0x98A3, 0x8864, 0x7843, 0x6861, 0x58E2, 0x8227, 0xA2EC, 0xBB70, 0xE456, 0xF4F9, 0xF51A, 0xECD9, 0xFDBC, 0xF55A, 0xF539, 0xFD5A, 0xFD9B, 0xFE1C, 0xFE3D, 
        0xFE1D, 0xFE9D, 0xF61B, 0xF57A, 0xF538, 0xFD57, 0xFD57, 0xF558, 0xED79, 0xED16, 0xED35, 0xED35, 0xED16, 0xE4F5, 0xD473, 0xB38F, 0x8ACC, 0xABAD, 0xABCC, 0xA3AA, 0xA3CA, 0xB3CB, 0xABAC, 0x934B, 0x7A88, 0x8986, 0x9A29, 0xB38E, 0xDCF3, 0xD412, 
        0xD3AF, 0xD3CF, 0xDC32, 0xB2CF, 0xA24D, 0x91AB, 0x8909, 0x7826, 0x8866, 0x90C7, 0x9906, 0x88A7, 0x9108, 0x9909, 0x90E9, 0xA18A, 0xB1CE, 0xA9AE, 0x894B,
  0xA35A, 0xA33A, 0xA33A, 0xAB5A, 0xA33B, 0xA35B, 0xA35B, 0xAB3B, 0xA35B, 0xAB5B, 0xAB5B, 0xAB5C, 0xAB7B, 0xAB7C, 0xAB7D, 0xAB9C, 0xAB7C, 0xAB7C, 0xAB7C, 0xAB9D, 0xB39C, 0xB39C, 0xB39C, 0xB39D, 0xBBDD, 0xBC3D, 0xCC9D, 0xDCDC, 0xDC97, 0xC454, 0xABF1, 
        0x8B4B, 0x6A84, 0x7AC4, 0x8B26, 0x8B49, 0xA40B, 0xABEB, 0xABCB, 0xA3CB, 0xABEB, 0xABAB, 0xB3AD, 0xBBEF, 0xC410, 0xC3EF, 0xC3CF, 0xC38F, 0xBB8C, 0xB3AD, 0xB3CD, 0xBC0D, 0xCC4F, 0xC46F, 0xBC4F, 0xBBEF, 0xAB8D, 0xAB8E, 0xABAE, 0xABCD, 0xABD1, 
        0xABD2, 0xA3D3, 0x9393, 0x8AAE, 0x828D, 0x724B, 0x6228, 0x730A, 0x732C, 0x7B2D, 0x838E, 0xA471, 0x9CB1, 0x94D2, 0xA4F3, 0xA552, 0xB574, 0xBD95, 0xB5B4, 0xCE56, 0xD677, 0xD677, 0xD657, 0xD656, 0xD656, 0xD656, 0xCE56, 0xD697, 0xDE96, 0xD695, 
        0xDE95, 0xE6D7, 0xE6F8, 0xE6F7, 0xEED6, 0xEF3C, 0xF79B, 0xF799, 0xEF57, 0xF75A, 0xF75B, 0xF73A, 0xEF18, 0xEF5A, 0xF77A, 0xDEB7, 0xA550, 0x7B8B, 0x734D, 0x7B50, 0x8331, 0x7B0E, 0x8351, 0x8352, 0x7B11, 0x7B31, 0x8332, 0x8332, 0x7331, 0x72D0, 
        0xAAF3, 0xDAF8, 0xFABC, 0xFA5A, 0xF996, 0xF112, 0xE0AF, 0xE0AE, 0xF0F0, 0xF8F0, 0xF8D1, 0xFA59, 0xFA9B, 0xFA7B, 0xFA7B, 0xFA9C, 0xFA7B, 0xFA1B, 0xF9DB, 0xFA3B, 0xFA3C, 0xFA5C, 0xFA7C, 0xFA7C, 0xF9B9, 0xF9B9, 0xFA5B, 0xFADE, 0xFABE, 0xFA9C, 
        0xFA7B, 0xFA15, 0xF9B5, 0xF974, 0xF132, 0xE0CF, 0xE0EE, 0xE0CE, 0xE0AE, 0xC84B, 0xC86C, 0xD08D, 0xD06D, 0xC88E, 0xD06E, 0xD06E, 0xD06E, 0xC86D, 0xD08E, 0xD8AF, 0xE0D0, 0xE911, 0xF153, 0xF975, 0xF975, 0xF954, 0xF9B5, 0xF9D5, 0xF995, 0xF0D2, 
        0xF975, 0xFA17, 0xFA57, 0xF9F8, 0xF9D7, 0xF996, 0xF955, 0xF9F8, 0xF9F8, 0xF9D8, 0xF9B8, 0xF9DA, 0xF9F8, 0xFA38, 0xFA38, 0xF975, 0xF132, 0xE912, 0xE0F2, 0xE0F0, 0xE8F1, 0xF113, 0xF195, 0xFAB9, 0xFA7A, 0xFA1B, 0xF9DB, 0xF9B8, 0xF9F7, 0xE994, 
        0xD0AE, 0xA84A, 0xA889, 0xA088, 0x9867, 0x9889, 0xA089, 0xA868, 0xB828, 0xB0AA, 0xB08A, 0xB06A, 0xB04B, 0xC0AD, 0xC8EE, 0xC8CE, 0xB06B, 0x6024, 0x4022, 0x3001, 0x3000, 0x50A3, 0x6A06, 0x72C7, 0x7306, 0x7B07, 0x7B08, 0x834A, 0x834B, 0x5A42, 
        0x7B07, 0x8B6A, 0x6AE8, 0x20E2, 0x8A47, 0xC32B, 0xB2CC, 0x9884, 0x9883, 0x98A4, 0xA0C4, 0xA085, 0xA045, 0x9044, 0x6881, 0x5083, 0x71C7, 0x92EB, 0xA3ED, 0xAC0E, 0xCC52, 0xDC96, 0xF4B9, 0xE4D7, 0xF518, 0xFD39, 0xFD1A, 0xFD5C, 0xFDBC, 0xFDBC, 
        0xFDDC, 0xFE7D, 0xFE9D, 0xF63D, 0xF5BC, 0xFD99, 0xFD57, 0xFD36, 0xFD57, 0xED99, 0xED76, 0xED35, 0xE4F6, 0xE515, 0xED15, 0xDCB4, 0xB3B1, 0x92AA, 0x8AC9, 0x9BAB, 0xBC8D, 0x79C3, 0x81E6, 0x92CA, 0xA3AD, 0xA30B, 0x9268, 0x81C7, 0x8167, 0xA2ED, 
        0xBB8F, 0xC3B0, 0xCB91, 0xE3F3, 0xDB91, 0xCB0F, 0xC2AE, 0xA1EA, 0x9149, 0x88E8, 0x90E6, 0x9149, 0x996A, 0xA16B, 0xA12A, 0xA9AA, 0x990A, 0xA1AD, 0xCB32,
  0xA339, 0xA339, 0xA339, 0xA35A, 0xA33A, 0xA33A, 0xA33A, 0xAB5A, 0xAB5B, 0xAB5B, 0xAB3B, 0xA33A, 0xAB5B, 0xAB5B, 0xAB5B, 0xAB7B, 0xB37A, 0xAB7B, 0xB35C, 0xB35C, 0xAB9C, 0xAB9C, 0xB39C, 0xB39C, 0xB3BB, 0xCC5C, 0xDCBC, 0xDCFA, 0xD4B7, 0xBC32, 0xABAE, 
        0x9B29, 0x5A84, 0x6AA4, 0x7AE5, 0x8306, 0x93AA, 0x9BAB, 0xA3AA, 0xA3AA, 0xA3AE, 0xB3AF, 0xBBCF, 0xC3AE, 0xCB6E, 0xCB8E, 0xC36D, 0xBB2B, 0xC3AD, 0xC3CE, 0xBBEF, 0xB40F, 0xB42E, 0xB44E, 0xBC6F, 0xC491, 0xCC92, 0xC452, 0xB3F2, 0xABB0, 0xABAF, 
        0x9B8F, 0x936E, 0x8B2E, 0x730E, 0x6ACA, 0x6AA7, 0x6AC7, 0x7AE9, 0x7B2A, 0x734B, 0x6B6B, 0x6B4C, 0x8C0D, 0x948F, 0x9490, 0x9CF1, 0xAD32, 0xB553, 0xB595, 0xADB3, 0xB5B3, 0xBDB4, 0xB5B4, 0xB593, 0xB5B3, 0xB593, 0xB573, 0xB593, 0xC5F5, 0xCE36, 
        0xD697, 0xDED7, 0xEF39, 0xFF9A, 0xFFDB, 0xFFBC, 0xFFDE, 0xFFDE, 0xFFFE, 0xF77A, 0xEEF8, 0xEF3A, 0xF79D, 0xC5D5, 0x942F, 0x736D, 0x7B6E, 0x5ACF, 0x6B0F, 0x7350, 0x7B52, 0x7AF1, 0x7AF1, 0x7B11, 0x7B52, 0x7B10, 0x7B10, 0x7B11, 0x8311, 0x6AB0, 
        0xAB14, 0xE2F9, 0xFA7C, 0xF23B, 0xF197, 0xE0D2, 0xD02D, 0xE8EE, 0xF0F0, 0xF0F1, 0xF112, 0xFABA, 0xFA7B, 0xFA5B, 0xFA5B, 0xFA5B, 0xFA3C, 0xFA3B, 0xFA1B, 0xFA3B, 0xFA3B, 0xFA5C, 0xFA3C, 0xF9B7, 0xF997, 0xFA1A, 0xFB1E, 0xFA5E, 0xF9DB, 0xF9BA, 
        0xF9DA, 0xF9D9, 0xF996, 0xF153, 0xE932, 0xE952, 0xE110, 0xE0EE, 0xD8AC, 0xD88E, 0xD08D, 0xD08C, 0xC86D, 0xC04C, 0xC04C, 0xD04C, 0xD86D, 0xC8CE, 0xE110, 0xE932, 0xE132, 0xE934, 0xE953, 0xE933, 0xE933, 0xF994, 0xF175, 0xE954, 0xF154, 0xFA57, 
        0xFA17, 0xF9F6, 0xFA16, 0xF9D7, 0xF195, 0xF194, 0xF9D6, 0xF997, 0xF998, 0xF997, 0xF997, 0xF9DA, 0xFA3A, 0xFA39, 0xF217, 0xF194, 0xF153, 0xE132, 0xD931, 0xD8AF, 0xE0F0, 0xE992, 0xFA35, 0xFA59, 0xF9F9, 0xF9B9, 0xF977, 0xF9BA, 0xF177, 0xE0F2, 
        0xC84D, 0xB089, 0xA068, 0xA048, 0xA048, 0xA089, 0xA869, 0xA848, 0xA847, 0xB869, 0xC08A, 0xC089, 0xB869, 0xB08C, 0xC0CD, 0xD0CD, 0xC84B, 0x5004, 0x2801, 0x1800, 0x2861, 0x7245, 0x6A67, 0x6AA7, 0x7306, 0x72C4, 0x6AA5, 0x6265, 0x6245, 0x8B69, 
        0x9368, 0x82C6, 0x6A25, 0xC44E, 0xC32B, 0xA9E8, 0x90E4, 0x9843, 0x9885, 0xA0A5, 0xB0A5, 0x88A3, 0x8042, 0x7002, 0x6043, 0x6244, 0x6AA5, 0x82E7, 0xBB2C, 0xDC94, 0xDC56, 0xE416, 0xEC76, 0xF539, 0xF518, 0xF4D8, 0xFCB9, 0xFDDC, 0xFE1C, 0xFE5D, 
        0xFEBE, 0xFDFC, 0xF5BA, 0xED58, 0xE4D5, 0xFDBA, 0xFDFB, 0xF599, 0xE4F5, 0xDCD4, 0xED16, 0xED36, 0xE515, 0xD4B4, 0xCC52, 0xAB8D, 0x7286, 0x6205, 0x9B09, 0x9B09, 0x69E5, 0x9A8B, 0xC40D, 0xBC4C, 0x8B07, 0x6146, 0x79A7, 0x9A8B, 0xC390, 0xC370, 
        0xCBD3, 0xD3F3, 0xCB90, 0xCB0D, 0xD390, 0xC32F, 0x99E9, 0x9969, 0x80E7, 0x78C7, 0x88E8, 0x98C6, 0xA0C6, 0x90C5, 0x8926, 0xDBD5, 0xAA8E, 0x99AA, 0xB1EE,
  0xA33A, 0xA33A, 0xA339, 0xA33A, 0xA33B, 0xAB5B, 0xAB5B, 0xA35B, 0xA33B, 0xA35B, 0xAB7B, 0xAB7B, 0xAB7B, 0xAB7B, 0xAB9B, 0xB37B, 0xAB7B, 0xAB7C, 0xB37D, 0xAB7C, 0xAB9C, 0xAB9C, 0xB39D, 0xBBBD, 0xBBFD, 0xC43C, 0xCC7B, 0xDC7B, 0xD4D7, 0xC454, 0xB3F1, 
        0x9B8C, 0x6AA5, 0x6AC5, 0x6AC5, 0x72A5, 0x8B69, 0x9389, 0x9B89, 0x9B89, 0xB38D, 0xB3AE, 0xBBAE, 0xBBAD, 0xDB8E, 0xCB6D, 0xC34D, 0xC34D, 0xBB4D, 0xBB4E, 0xB36E, 0xA38D, 0xAB8E, 0xABEE, 0xB46F, 0xC4B0, 0xC4B0, 0xC471, 0xBC11, 0xA3CF, 0x938D, 
        0x936D, 0x834C, 0x7B0B, 0x7AC9, 0x7AA8, 0x7AA7, 0x82A6, 0x82CA, 0x7AE9, 0x7328, 0x7387, 0x7B2E, 0x8BAF, 0x8C0F, 0x8C6E, 0xA4F2, 0xA4F2, 0xA512, 0xB553, 0xB574, 0xB594, 0xBD93, 0xBD93, 0xAD73, 0xB593, 0xBDB4, 0xBDB3, 0xC614, 0xCE55, 0xDE96, 
        0xE6F7, 0xEF39, 0xF779, 0xF79A, 0xFFBC, 0xF79C, 0xFFBD, 0xF79D, 0xF79B, 0xFFDE, 0xFFDE, 0xDEBA, 0xA4B1, 0x7370, 0x6B0F, 0x6AAE, 0x6AAE, 0x93B5, 0x8373, 0x7B31, 0x8331, 0x7AF2, 0x7B11, 0x7B11, 0x7B11, 0x7B11, 0x7AF1, 0x82F2, 0x9332, 0x6AB1, 
        0x8292, 0xB2F6, 0xF39D, 0xFABC, 0xFA1A, 0xE955, 0xD86E, 0xD88D, 0xE931, 0xF952, 0xF0F2, 0xF9D7, 0xFA19, 0xFA3A, 0xFA59, 0xFA7B, 0xFA7B, 0xFA9C, 0xFA7C, 0xFA5C, 0xFA7C, 0xFA7C, 0xFA5C, 0xFA1B, 0xFA9C, 0xFADD, 0xFA9D, 0xF0D3, 0xF0F4, 0xF976, 
        0xF9F7, 0xFA57, 0xFA37, 0xFA16, 0xF9B6, 0xF173, 0xF154, 0xF154, 0xF952, 0xE8EF, 0xE8EF, 0xE8EF, 0xE8EF, 0xE110, 0xE110, 0xE90F, 0xE92F, 0xE110, 0xE931, 0xE931, 0xF132, 0xF994, 0xF174, 0xF174, 0xF174, 0xF9B5, 0xF1B5, 0xF1D6, 0xFA37, 0xFA77, 
        0xF1D4, 0xF133, 0xF913, 0xF1D5, 0xF9D6, 0xF9B5, 0xF174, 0xF196, 0xF9D7, 0xF9D7, 0xF1B6, 0xFABC, 0xFA9B, 0xFA5A, 0xFA18, 0xF193, 0xF132, 0xE932, 0xE111, 0xD8AF, 0xD8B0, 0xE112, 0xF1B6, 0xFA99, 0xFA18, 0xF197, 0xF156, 0xF997, 0xF9D8, 0xF175, 
        0xE0D0, 0xB06A, 0xA04A, 0xA049, 0xA049, 0xB0A9, 0xB089, 0xB049, 0xB829, 0xB868, 0xB869, 0xB86A, 0xB86A, 0xC06C, 0xD0CE, 0xD90F, 0xD0CE, 0x9826, 0x4802, 0x3882, 0x6186, 0x7266, 0x7AA6, 0x7AC6, 0x7AE6, 0x6242, 0x8B08, 0x9349, 0x72A6, 0x72C6, 
        0x8B06, 0x9367, 0x93C8, 0xA36B, 0x9287, 0x9185, 0xA0A5, 0xA0C6, 0xA0E6, 0xA106, 0xA907, 0x9863, 0x9823, 0x8042, 0x60C2, 0x81A7, 0x69C5, 0x59E4, 0x6A45, 0x82A7, 0xA34C, 0xB3AF, 0xC3F2, 0xF477, 0xFD18, 0xF4F7, 0xEC96, 0xFD7A, 0xFD9B, 0xFDDD, 
        0xFE3E, 0xFE7D, 0xFE7D, 0xF63C, 0xF5DA, 0xF579, 0xFD77, 0xFD76, 0xF576, 0xF596, 0xF575, 0xED56, 0xED16, 0xE515, 0xBBD0, 0xA34D, 0x9B4C, 0x71E6, 0x7267, 0x936B, 0xBC2E, 0x5122, 0x6103, 0x81C7, 0xB2EB, 0xCBEF, 0x9AAA, 0x79E7, 0x71E8, 0x9A49, 
        0x9AAC, 0xB370, 0xDC96, 0xF456, 0xEC75, 0xECB4, 0xF4B2, 0xC34E, 0xB2AB, 0xAA2A, 0xA1C9, 0x9988, 0x9188, 0x8928, 0x88E7, 0xA1A8, 0xAA0C, 0xAA2E, 0xAA4E,
  0xA35A, 0xAB5A, 0xA35A, 0xA31A, 0xAB7C, 0xAB7B, 0xAB5B, 0xA35B, 0xA35B, 0xAB5C, 0xAB7C, 0xB39B, 0xB37C, 0xAB9B, 0xAB9B, 0xAB9C, 0xAB7C, 0xAB7D, 0xB37D, 0xB37D, 0xB39C, 0xB3BD, 0xB3BD, 0xB3BD, 0xBBFD, 0xBC3D, 0xCC7C, 0xDC7C, 0xDCDB, 0xC478, 0xB416, 
        0xABD2, 0x832A, 0x7AC6, 0x7AA5, 0x82C6, 0x8B4A, 0x9369, 0xA369, 0xA34A, 0xA34B, 0xBB4C, 0xC38D, 0xCBAE, 0xC36F, 0xCB6E, 0xCB4E, 0xBB6E, 0xBB6F, 0xA30F, 0x92CE, 0x8AEC, 0x936D, 0xA3EE, 0xB44E, 0xB48F, 0xBC92, 0xC494, 0xC473, 0xB42F, 0x938D, 
        0x836C, 0x834C, 0x834C, 0x6AEA, 0x7AC8, 0x82A6, 0x8A85, 0x8B09, 0x830B, 0x7B0B, 0x7B2C, 0x7B2E, 0x838E, 0x8BEE, 0x8C2F, 0x9CB1, 0x9CD2, 0xA512, 0xAD32, 0xB574, 0xB574, 0xBD74, 0xB5B4, 0xAD93, 0xB593, 0xB594, 0xB5B4, 0xC656, 0xD696, 0xDED7, 
        0xE739, 0xFF9B, 0xFFDD, 0xFFBD, 0xFF5B, 0xF7DD, 0xFFFF, 0xFFFF, 0xF7BD, 0xAD72, 0x9490, 0x7B8E, 0x5A6D, 0x524C, 0x7B32, 0x8BB4, 0x8BB4, 0x7B34, 0x7B32, 0x7B51, 0x8351, 0x7B32, 0x7B31, 0x8331, 0x8332, 0x8311, 0x7AF2, 0x82D3, 0x8AD2, 0x7330, 
        0x72D0, 0x9A93, 0xF2D8, 0xFAFD, 0xFABB, 0xFA38, 0xF194, 0xD84D, 0xE8CF, 0xF952, 0xF973, 0xF956, 0xF9D7, 0xFA59, 0xFA7C, 0xFA9B, 0xFA7B, 0xFA7C, 0xFA7C, 0xFA9C, 0xFA9D, 0xFA7D, 0xFA9C, 0xFAFE, 0xFADE, 0xFA1B, 0xF0B5, 0xF093, 0xF177, 0xF9F9, 
        0xFA19, 0xF1F7, 0xFA38, 0xFA18, 0xF9D7, 0xF155, 0xF933, 0xF132, 0xE910, 0xE08E, 0xE0CF, 0xE10F, 0xE130, 0xF192, 0xE951, 0xE90F, 0xE8EE, 0xE0AF, 0xE930, 0xF171, 0xF131, 0xF152, 0xF9B4, 0xF9B5, 0xF994, 0xF995, 0xF9D6, 0xFA37, 0xFA58, 0xF0F1, 
        0xF0D1, 0xF0F2, 0xF953, 0xF952, 0xF953, 0xF974, 0xF973, 0xF9B3, 0xF9B5, 0xF9B6, 0xF9F5, 0xF9F8, 0xF9D8, 0xF9D8, 0xF9F7, 0xE913, 0xD8F1, 0xD8F0, 0xE0F2, 0xE0CF, 0xE0F0, 0xE932, 0xF975, 0xFA59, 0xF9D7, 0xF956, 0xF916, 0xF997, 0xFA18, 0xFA17, 
        0xF1B5, 0xB08B, 0xA86A, 0xA84A, 0xA869, 0xB8AC, 0xB8AB, 0xB86B, 0xB82A, 0xB86A, 0xC06A, 0xB84A, 0xB06B, 0xD0AD, 0xD8EF, 0xE110, 0xD8CF, 0xB049, 0x7044, 0x5943, 0x72E7, 0x6A66, 0x7AA5, 0x7AA4, 0x72A4, 0x9C2C, 0x9BCC, 0x8308, 0x5A44, 0x59E1, 
        0x82E5, 0xBC4C, 0xECF3, 0x99C9, 0x9106, 0x98C5, 0xB0A5, 0xA0A5, 0xA8E5, 0xA8C5, 0xA084, 0x9883, 0xA864, 0x9023, 0x5862, 0x6225, 0x59E3, 0x6204, 0x72C6, 0x8228, 0x920A, 0x9A4B, 0x9AAC, 0xDB52, 0xF477, 0xFCD8, 0xF4B8, 0xF517, 0xF539, 0xFD5B, 
        0xFD9B, 0xFE7E, 0xFEBE, 0xFEDE, 0xFE9D, 0xF5B9, 0xFD77, 0xFD55, 0xFD56, 0xF5F8, 0xF5D8, 0xF597, 0xED56, 0xED16, 0xE4B4, 0xCC52, 0xB42F, 0xB40E, 0x8AA8, 0x69C3, 0x6A23, 0xDC91, 0x9A08, 0x6022, 0x6043, 0x8265, 0x8A67, 0x79C7, 0x6167, 0xB34F, 
        0xAAAD, 0x918A, 0x8108, 0xCBB1, 0xEC73, 0xF4F4, 0xF534, 0xF4F2, 0xF4D2, 0xEC72, 0xDBD2, 0xD431, 0xD3F0, 0xD32E, 0xD26E, 0xB22E, 0xBB10, 0xBB10, 0xAA6D,
  0xA33A, 0xA319, 0xA31A, 0xA35A, 0xA339, 0xA35A, 0xA35B, 0xA33B, 0xAB5B, 0xAB3B, 0xAB5B, 0xAB7B, 0xAB5B, 0xAB5B, 0xAB7B, 0xAB7B, 0xB37D, 0xB37D, 0xB37C, 0xB37C, 0xAB9C, 0xAB9C, 0xAB9C, 0xAB7C, 0xB3FC, 0xC43C, 0xCC7C, 0xD49C, 0xCC7A, 0xB3F7, 0xAB96, 
        0xA354, 0x82CB, 0x7AA7, 0x7AE6, 0x8326, 0x82E8, 0x8B08, 0x8B08, 0x9308, 0xB32A, 0xBB4C, 0xC36C, 0xCB6D, 0xC34D, 0xC34D, 0xCB4D, 0xC34E, 0xBB30, 0xA2AE, 0x8A4C, 0x7A6A, 0x7B0B, 0x936D, 0xA3ED, 0xB48D, 0xB491, 0xB451, 0xAC11, 0x9BAF, 0x8B4A, 
        0x7309, 0x6AE9, 0x6AE7, 0x6AE6, 0x7AC5, 0x8AC5, 0x92C6, 0x8AA7, 0x7AC9, 0x6ACA, 0x62AB, 0x6B0B, 0x734C, 0x738D, 0x83EE, 0x948F, 0xA4D0, 0xA4F2, 0xA4F2, 0xB553, 0xB552, 0xB553, 0xAD53, 0xADB3, 0xBDD3, 0xC5F5, 0xC636, 0xCE96, 0xDEF7, 0xEF18, 
        0xEF39, 0xEF7B, 0xEF59, 0xF75A, 0xF79C, 0xFFDE, 0xFF9C, 0xE6D9, 0xBDB5, 0x8C6B, 0x62E7, 0x4A48, 0x5AAD, 0x7BF6, 0x7B73, 0x7B12, 0x7B12, 0x6AD1, 0x7332, 0x7353, 0x7312, 0x9352, 0x8351, 0x7331, 0x7AF0, 0x72F0, 0x82F3, 0x92F4, 0x92F3, 0x7310, 
        0x7AB0, 0x92D2, 0xB358, 0xF2D8, 0xFABA, 0xEA18, 0xE0B4, 0xE88E, 0xF111, 0xF153, 0xF152, 0xF9D5, 0xF9F6, 0xFA36, 0xFA57, 0xFA3A, 0xFA5B, 0xFA5B, 0xFA7B, 0xFA9C, 0xFA9C, 0xFA9C, 0xFA9B, 0xFABB, 0xF1D8, 0xE8D4, 0xE853, 0xF9F9, 0xFA59, 0xFA38, 
        0xF9D7, 0xF1D8, 0xF218, 0xFA18, 0xF1B6, 0xE914, 0xE0F4, 0xE0D3, 0xD890, 0xD8CE, 0xD8EF, 0xD8EF, 0xD0EE, 0xC8AD, 0xC84C, 0xC84C, 0xC86C, 0xD8AD, 0xE90F, 0xF152, 0xF174, 0xF994, 0xF994, 0xF174, 0xF954, 0xF9B5, 0xFA16, 0xF194, 0xE04F, 0xE8D1, 
        0xF194, 0xF9B5, 0xF153, 0xE932, 0xF132, 0xF153, 0xF173, 0xF194, 0xF194, 0xF195, 0xF197, 0xF153, 0xF9F6, 0xF1D6, 0xE8F2, 0xD0B1, 0xD0D1, 0xD8F2, 0xD8F1, 0xD8D1, 0xE933, 0xF9B6, 0xFA38, 0xF956, 0xF156, 0xF176, 0xF996, 0xFA18, 0xFA39, 0xF1F7, 
        0xE112, 0xB84B, 0xA829, 0xA009, 0xA829, 0xB8EB, 0xB0EA, 0xB08A, 0xC04B, 0xC04A, 0xC069, 0xC069, 0xC069, 0xC06C, 0xD0EE, 0xD90F, 0xD8CD, 0xA82B, 0x9048, 0x8128, 0x7A48, 0x6B24, 0x8368, 0x9C0C, 0xACCD, 0x7AC4, 0x3121, 0x2903, 0x6AC9, 0xE5F0, 
        0xBD8D, 0x8B87, 0x68C1, 0xA822, 0xA085, 0x98C7, 0xB0E9, 0xC0C5, 0xB8C5, 0xA0A5, 0x9063, 0x9021, 0x9882, 0x8082, 0x5861, 0x6A06, 0x59E4, 0x5244, 0x6B07, 0x9267, 0xAAEB, 0xBB8F, 0xCC13, 0xC2EE, 0xD3B2, 0xEC96, 0xFD19, 0xF559, 0xFD9B, 0xFDDD, 
        0xFDFE, 0xFE5D, 0xFE3C, 0xF61B, 0xEDDA, 0xED15, 0xF578, 0xFDB9, 0xFD98, 0xED56, 0xE555, 0xE535, 0xE536, 0xDCF5, 0xAB6E, 0x92AA, 0x92AB, 0xB42E, 0x7286, 0x6A04, 0x9AE8, 0x8AEA, 0x69A6, 0x58A2, 0x5881, 0xA1E7, 0xBAAC, 0xB26C, 0x8167, 0x5143, 
        0x8A6A, 0xC3D0, 0xDCF4, 0xCBB3, 0xD372, 0xDBD3, 0xE474, 0xF536, 0xED16, 0xDC94, 0xC3F0, 0xB2CD, 0x924A, 0x8A4B, 0xAA8E, 0xAA2C, 0xD3F1, 0xD3F1, 0xA24B,
  0xA35A, 0xA33A, 0xA33A, 0xA33A, 0xA33A, 0xAB5B, 0xAB5B, 0xA35B, 0xAB5B, 0xAB5B, 0xAB5B, 0xAB7B, 0xAB5B, 0xAB5B, 0xAB7B, 0xAB7B, 0xB37D, 0xB37D, 0xAB7D, 0xAB5D, 0xB37D, 0xB39C, 0xB39B, 0xB39B, 0xAB9E, 0xABBD, 0xB41D, 0xC43E, 0xBBBE, 0xB3DD, 0xB3D9, 
        0xAB94, 0x8B4D, 0x8309, 0x82C7, 0x82C6, 0x82E5, 0x8AE8, 0x9AE9, 0xA309, 0xB32C, 0xBB2D, 0xBB2D, 0xC32D, 0xBB6D, 0xBB6C, 0xC36D, 0xC370, 0xA331, 0x92F0, 0x7A8D, 0x6209, 0x628C, 0x72AC, 0x8B2E, 0xAC13, 0xB454, 0xAC13, 0xA3B1, 0x934D, 0x5AEA, 
        0x62CA, 0x6AC9, 0x6AC9, 0x7266, 0x7225, 0x7204, 0x71E4, 0x6A23, 0x7245, 0x6A66, 0x5A67, 0x5A8B, 0x6B0B, 0x838D, 0x8C0F, 0x946E, 0x9CB0, 0xA4D1, 0xACD1, 0x9CB1, 0xA513, 0xAD34, 0xB553, 0xBE16, 0xB5B4, 0xBDD4, 0xCE56, 0xCE16, 0xCE56, 0xD676, 
        0xDE97, 0xDE96, 0xE6F8, 0xEF7B, 0xEF7D, 0x9C72, 0x8BD0, 0x62CD, 0x2929, 0x628C, 0x8351, 0x8B93, 0x8373, 0x7B33, 0x7B53, 0x7B53, 0x7353, 0x8373, 0x8B33, 0x8312, 0x7AF2, 0x7B32, 0x7B11, 0x7AF1, 0x7B12, 0x8B10, 0x8AF1, 0x82F2, 0x82F2, 0x82B2, 
        0x7A90, 0x5ACF, 0x4B2F, 0xE2BC, 0xFA7D, 0xFA3A, 0xF1B5, 0xE04D, 0xE0CE, 0xF153, 0xF997, 0xF973, 0xF9B5, 0xF9F7, 0xFA38, 0xFA7B, 0xFA7B, 0xFA7A, 0xFA9A, 0xFA5B, 0xFA5B, 0xFABC, 0xFADC, 0xF177, 0xF0F5, 0xF0F6, 0xF998, 0xFA17, 0xF9F7, 0xF1B6, 
        0xF176, 0xFA58, 0xFA7A, 0xFA59, 0xF1F6, 0xE974, 0xE913, 0xE8D3, 0xE092, 0xE0EF, 0xD8CE, 0xD8AE, 0xD0AE, 0xD08D, 0xD0AD, 0xD08D, 0xC86D, 0xC84B, 0xE0EE, 0xF151, 0xF973, 0xE953, 0xF154, 0xF954, 0xF9B4, 0xFA78, 0xE111, 0xE04E, 0xE8D2, 0xFA99, 
        0xF257, 0xF1D6, 0xF9B5, 0xF1B6, 0xF9F6, 0xF9D5, 0xF195, 0xF1F6, 0xF9B5, 0xF995, 0xF9B8, 0xFA39, 0xF9B6, 0xE933, 0xD8D1, 0xD8D2, 0xE112, 0xE0F1, 0xD8D1, 0xF134, 0xF995, 0xF9D6, 0xF9F7, 0xF9F7, 0xF9B6, 0xF996, 0xF998, 0xF9F9, 0xFA3A, 0xFA19, 
        0xF195, 0xD06D, 0xB02B, 0xA84A, 0xB08A, 0xB10B, 0xC0CC, 0xC0AC, 0xB8CB, 0xB84A, 0xB86A, 0xB88A, 0xB86A, 0xD90C, 0xD90E, 0xD8EF, 0xD8CF, 0xB8CC, 0xA8EA, 0x9109, 0x7966, 0x92A8, 0x92C9, 0x71E6, 0x3061, 0x3861, 0xB36D, 0xF596, 0xF617, 0xA165, 
        0x9084, 0x8083, 0x8882, 0xC8E7, 0xC106, 0xB105, 0xB0E6, 0xA8C5, 0xA0A4, 0x9883, 0x90A3, 0x98A4, 0x7883, 0x58E2, 0x5161, 0x58E4, 0x4963, 0x4A44, 0x6B65, 0x73C5, 0x7AC5, 0x7A28, 0x8A2E, 0xBAAE, 0xD371, 0xE455, 0xFD39, 0xECB6, 0xF51A, 0xFD9C, 
        0xF61C, 0xFEBF, 0xFE9D, 0xFE5C, 0xF5FA, 0xF5B8, 0xF5B7, 0xF5B7, 0xFD98, 0xF5B7, 0xED77, 0xED37, 0xED36, 0xE514, 0xBC11, 0x8AAC, 0x5926, 0x7A27, 0x6A27, 0x49C4, 0x51A2, 0xB3ED, 0x8207, 0x68C3, 0x78E5, 0x6824, 0x5822, 0x60C3, 0x8227, 0xA2CC, 
        0x71E7, 0x5925, 0x7127, 0xC2B0, 0xBAF2, 0xC353, 0xDBF4, 0xE517, 0xEDB8, 0xF67B, 0xFF3E, 0xFF3E, 0xFF3F, 0xFEFF, 0xFE3D, 0xDDB4, 0xCD53, 0xB431, 0x9A8A,
  0xA33A, 0xA35B, 0xA35B, 0xA33B, 0xAB5B, 0xAB5B, 0xAB5B, 0xA33C, 0xA35B, 0xAB7C, 0xAB7D, 0xB37C, 0xB39C, 0xB39C, 0xAB9B, 0xAB7A, 0xAB7B, 0xAB7B, 0xA35C, 0xA37C, 0xB39C, 0xAB9B, 0xAB9B, 0xA39C, 0xB3BE, 0xB39D, 0xB3BE, 0xBBDF, 0xB3DD, 0xB3FE, 0xB41D, 
        0xABF9, 0xA391, 0x9B4D, 0x930A, 0x8AE8, 0x8B06, 0x8AE7, 0x8AC8, 0x8AC9, 0xB34B, 0xBB4C, 0xC32C, 0xCAEE, 0xB3F1, 0xB3AF, 0xBB6E, 0xBB70, 0xA351, 0x8B30, 0x72CE, 0x5A6D, 0x5A8B, 0x62CB, 0x6B2E, 0x8BB1, 0x9432, 0x940F, 0x8BCE, 0x8B4E, 0x6B0C, 
        0x62CB, 0x6AAA, 0x7AC9, 0x7A27, 0x8227, 0x8206, 0x71C4, 0x7A63, 0x7243, 0x6A44, 0x6A66, 0x6ACC, 0x732C, 0x7B6C, 0x8B8E, 0x8C6F, 0x9C70, 0x9C90, 0xA4D1, 0xA4B1, 0xAD13, 0xAD53, 0xAD53, 0xBDD5, 0xC656, 0xCE77, 0xD676, 0xDE57, 0xD678, 0xD678, 
        0xE6BA, 0xF7BD, 0xD679, 0xB596, 0x9CD4, 0x51EA, 0x49CA, 0x6AAE, 0x9BD4, 0x83B7, 0x8374, 0x8353, 0x8355, 0x8354, 0x8394, 0x8394, 0x8374, 0x8B52, 0x8372, 0x8373, 0x8B52, 0x9353, 0x8332, 0x8333, 0x9B73, 0x8B12, 0x8331, 0x8331, 0x8B32, 0x8AD2, 
        0x7AF1, 0x72F0, 0x82D0, 0xC338, 0xEB1C, 0xFADE, 0xF29C, 0xF131, 0xF0D0, 0xF0F0, 0xF952, 0xF1D5, 0xF9D5, 0xF9F5, 0xFA37, 0xFA58, 0xFA79, 0xFA79, 0xFA5A, 0xFA7B, 0xFA7A, 0xFA5A, 0xF9F9, 0xF0D3, 0xF915, 0xF977, 0xF997, 0xF9F9, 0xF9B7, 0xF976, 
        0xF996, 0xFA78, 0xFA5A, 0xFA39, 0xFA56, 0xF997, 0xF934, 0xF113, 0xE912, 0xE0AF, 0xE0CF, 0xE0CF, 0xD8AF, 0xE0AE, 0xD88E, 0xD8AE, 0xD8CE, 0xC82A, 0xE0AE, 0xF951, 0xF993, 0xF133, 0xF934, 0xF994, 0xF9F5, 0xE871, 0xE890, 0xF193, 0xFA99, 0xF134, 
        0xF113, 0xF154, 0xF9B6, 0xFA59, 0xF9F7, 0xF9B6, 0xF9D6, 0xF996, 0xF996, 0xF9D6, 0xF9F8, 0xF9D7, 0xF114, 0xE8B2, 0xE0B3, 0xE912, 0xE912, 0xE912, 0xE932, 0xF134, 0xF975, 0xF9F7, 0xFA38, 0xF9D6, 0xF996, 0xF977, 0xF977, 0xF978, 0xF9B8, 0xF9F8, 
        0xFA36, 0xE8F0, 0xC86D, 0xB04A, 0xA849, 0xC08B, 0xB8AC, 0xC90D, 0xE18F, 0xC86A, 0xC069, 0xC869, 0xD88A, 0xD151, 0xD930, 0xD90F, 0xE111, 0xC84D, 0xB86C, 0xA048, 0x7022, 0x20C4, 0x2882, 0x6985, 0xCBEE, 0xDE19, 0xEC96, 0xE2CF, 0xC169, 0xA0A7, 
        0xA867, 0xB067, 0xB8A8, 0xC129, 0xC908, 0xC8E7, 0xC8E5, 0xA8E6, 0xA0C5, 0x9883, 0x9082, 0x98A4, 0x8863, 0x7863, 0x70E3, 0x40E1, 0x3921, 0x5204, 0x8368, 0x6AE2, 0x6AE3, 0x7AC6, 0x8A08, 0x6086, 0x68C6, 0x818A, 0xB2CF, 0xF518, 0xFD7A, 0xFD7A, 
        0xF57B, 0xFDDD, 0xFE5E, 0xFEBE, 0xFEDE, 0xF67D, 0xFE7D, 0xFE3B, 0xFD98, 0xFD56, 0xF598, 0xF5D9, 0xF5D7, 0xD494, 0xDCB4, 0xDCB4, 0xCC12, 0x4124, 0x50E3, 0x69A5, 0x72A6, 0x61C2, 0x7A25, 0x71A5, 0x6042, 0x7085, 0x7065, 0x6064, 0x4062, 0x6125, 
        0x7186, 0x71E7, 0x6A28, 0x6A06, 0x79C7, 0x91AA, 0xA98E, 0x998C, 0x9A0E, 0xA26F, 0xB310, 0xBC73, 0xC413, 0xCC15, 0xDCD7, 0xE619, 0xE5F8, 0xDD16, 0xCBF2,
  0xA33A, 0xA33A, 0xA33A, 0xA33A, 0xA35B, 0xA33B, 0xA33B, 0xA35B, 0xB35B, 0xAB5B, 0xAB5B, 0xAB5B, 0xAB7B, 0xAB7C, 0xAB7C, 0xB37C, 0xAB7B, 0xAB7D, 0xAB5E, 0xAB5D, 0xB398, 0xAB79, 0xAB7B, 0xB35E, 0xAB5E, 0xAB5D, 0xB39D, 0xB3BD, 0xB3BA, 0xB3BB, 0xB3DB, 
        0xABDB, 0x9B73, 0x936E, 0x8B2B, 0x82E8, 0x82C7, 0x8AC7, 0x92A7, 0x92A8, 0xB36D, 0xBB30, 0xBB12, 0xC334, 0xAB72, 0xB371, 0xB371, 0xAB50, 0x9B12, 0x7AAF, 0x6A6D, 0x6A6B, 0x5A8C, 0x72CD, 0x7AED, 0x730E, 0x93AE, 0x838D, 0x7B6D, 0x6B4E, 0x6ACA, 
        0x62A9, 0x6AA8, 0x7287, 0x71E6, 0x7985, 0x7964, 0x6963, 0x6A02, 0x6203, 0x59E4, 0x5A05, 0x5247, 0x6309, 0x736B, 0x8B8F, 0x846E, 0x94B1, 0xA4D1, 0xA4F0, 0x9CB3, 0xA4F2, 0xAD32, 0xB554, 0xB594, 0xB593, 0xB594, 0xBDB5, 0xBDB3, 0xCE36, 0xE71A, 
        0xF79C, 0xB554, 0xACF3, 0x838F, 0x39A9, 0x7B95, 0x93B6, 0x8B94, 0x7B54, 0x7314, 0x7B53, 0x8353, 0x7B54, 0x7353, 0x8B74, 0x9374, 0x8B34, 0x8B74, 0x8B53, 0x8B53, 0x9374, 0x8353, 0x8B72, 0x9352, 0x8B13, 0x9352, 0x8B12, 0x8AF2, 0x8B33, 0x8B73, 
        0x8332, 0x82D1, 0x8AB0, 0xDBD9, 0xF31B, 0xFA9C, 0xFA5C, 0xE933, 0xE910, 0xF0F0, 0xF914, 0xF1B4, 0xF1D5, 0xF1D6, 0xF9D7, 0xF9D6, 0xF1D6, 0xF1F7, 0xF1D8, 0xF1D6, 0xF9D6, 0xF996, 0xF114, 0xF0B4, 0xF136, 0xF998, 0xF9F9, 0xF9D7, 0xF176, 0xF196, 
        0xF9F7, 0xF218, 0xFA19, 0xF9F9, 0xF997, 0xF197, 0xE955, 0xE913, 0xE0D2, 0xD8EF, 0xD8AE, 0xD08E, 0xD08F, 0xD0AD, 0xD0AC, 0xD08C, 0xC86C, 0xD8AC, 0xE94F, 0xF1B2, 0xF1B2, 0xF951, 0xF952, 0xF994, 0xF994, 0xD86B, 0xE9F3, 0xF237, 0xF113, 0xE8F1, 
        0xF173, 0xF9B5, 0xF1F6, 0xF1F9, 0xF1D7, 0xF1B6, 0xF1B7, 0xF1D6, 0xF217, 0xFA18, 0xF9D7, 0xF154, 0xE0F2, 0xD8F2, 0xE0F2, 0xD8D1, 0xD911, 0xE111, 0xE912, 0xF9B6, 0xF9F8, 0xFA18, 0xF9D8, 0xF9B8, 0xF156, 0xF134, 0xF955, 0xF978, 0xF9B9, 0xF9D9, 
        0xF1D7, 0xE0CF, 0xC08B, 0xB06A, 0xA86A, 0xB88A, 0xC0CC, 0xC8ED, 0xD12E, 0xD0CD, 0xD08C, 0xC86B, 0xC86B, 0xD90E, 0xD951, 0xD931, 0xD0AE, 0xD10D, 0xC9AE, 0xB98C, 0xA1A8, 0xE6FB, 0xEFBD, 0xF65A, 0xF3B4, 0xD1ED, 0xA8A8, 0x8805, 0x8824, 0xD9AA, 
        0xD1AA, 0xC989, 0xD18A, 0xC8E7, 0xB907, 0xB106, 0xA905, 0xA063, 0x9883, 0xA0A4, 0x98A3, 0x7022, 0x7063, 0x6103, 0x3981, 0x38A2, 0x4923, 0x6245, 0x6B47, 0x7305, 0x7A45, 0x6945, 0x48A4, 0x9A2A, 0xBAF0, 0xC311, 0xBACF, 0xDCD8, 0xF57B, 0xFDDC, 
        0xFE1E, 0xFE5E, 0xFEBE, 0xFEBD, 0xFE3B, 0xED98, 0xF5D9, 0xFE3A, 0xFE7A, 0xF535, 0xED15, 0xE556, 0xED56, 0xE4D5, 0xAB6F, 0x8249, 0x6966, 0x5123, 0x59A5, 0x59E5, 0x51E3, 0x72A6, 0x69C4, 0x6103, 0x5883, 0x7026, 0x6825, 0x6064, 0x48C3, 0x5126, 
        0x7A28, 0x8A27, 0x78E4, 0x6065, 0x80C8, 0x90C9, 0x8068, 0x91CD, 0xBAD1, 0xD3B3, 0xD433, 0xCBB2, 0xC3F2, 0xC432, 0xC472, 0xDC98, 0xBB32, 0xBB31, 0xDCD4,
  0xA33A, 0xA33A, 0xA33A, 0xA33B, 0xAB5A, 0xAB5A, 0xAB5B, 0xAB5B, 0xAB7B, 0xAB7B, 0xAB7B, 0xAB7B, 0xAB7B, 0xB37C, 0xB37C, 0xAB9B, 0xB39A, 0xAB79, 0xAB79, 0xA398, 0xA396, 0x9B95, 0xA396, 0xABB9, 0xA3BB, 0xABBC, 0xB3BD, 0xBB9D, 0xBBBE, 0xABBC, 0xB3DC, 
        0xBBDC, 0xA395, 0x9371, 0x8B2E, 0x82EB, 0x92C8, 0x8AC7, 0x8AC7, 0x92C9, 0xB36D, 0xBB70, 0xBB33, 0xC315, 0xABB5, 0xAB74, 0xB353, 0xB333, 0x92EF, 0x72AE, 0x628D, 0x62AC, 0x6B0C, 0x6B0C, 0x6B0C, 0x6B0B, 0x6B4D, 0x734C, 0x732C, 0x732D, 0x730B, 
        0x730A, 0x72E9, 0x72A8, 0x7205, 0x71C5, 0x79A5, 0x79A4, 0x69C1, 0x59C2, 0x49C3, 0x3982, 0x4205, 0x5AA8, 0x630A, 0x6B4C, 0x9C70, 0x9C90, 0x9C90, 0xA491, 0xACF3, 0xAD12, 0xAD33, 0xAD53, 0xAD73, 0xB5B4, 0xBDB5, 0xCDB4, 0xE75B, 0xF77C, 0xD69A, 
        0x9CF4, 0x520C, 0x418A, 0x5A8F, 0x8C57, 0x7B54, 0x8333, 0x8334, 0x7335, 0x8B75, 0x8B74, 0x9374, 0x9375, 0x9B95, 0x9BB5, 0x93B5, 0x93B5, 0x9BD4, 0x93B4, 0x9394, 0x93B4, 0x8B53, 0x9373, 0x9394, 0x93B4, 0x8B53, 0x8B33, 0x8B33, 0x9333, 0x9353, 
        0x9354, 0x8B73, 0x8373, 0xAB32, 0xCB55, 0xEB7A, 0xFB3E, 0xFA1C, 0xF156, 0xE8F2, 0xF0F2, 0xF994, 0xF9B5, 0xF995, 0xF196, 0xF236, 0xF1F6, 0xF9B6, 0xF975, 0xF9D6, 0xF996, 0xF155, 0xF114, 0xF9D8, 0xF9D9, 0xF9B8, 0xF997, 0xF156, 0xF156, 0xF996, 
        0xF9F7, 0xFA37, 0xFA18, 0xF1D7, 0xF1B6, 0xF9F7, 0xF9B6, 0xF194, 0xF153, 0xD8CF, 0xD8AE, 0xD0AE, 0xD0CD, 0xD08C, 0xD0AD, 0xD08C, 0xD08B, 0xD8EE, 0xE930, 0xF953, 0xF975, 0xF174, 0xF132, 0xE8AF, 0xE08E, 0xFB58, 0xF235, 0xE0D2, 0xD050, 0xE112, 
        0xE933, 0xE954, 0xF1B6, 0xFA17, 0xF9F7, 0xF1D7, 0xF996, 0xF1F8, 0xFA19, 0xF9F8, 0xF996, 0xE113, 0xE113, 0xE112, 0xD8D2, 0xE112, 0xE953, 0xF194, 0xF9B5, 0xF9F7, 0xFA38, 0xFA17, 0xF175, 0xE8F3, 0xF114, 0xF155, 0xF996, 0xF9D8, 0xFA19, 0xFA39, 
        0xFA18, 0xE914, 0xD08F, 0xC04C, 0xB02B, 0xB06A, 0xB8AC, 0xC10D, 0xD16D, 0xC86B, 0xC82A, 0xD06B, 0xE10E, 0xC8CD, 0xC86D, 0xC86D, 0xC8CE, 0xDA73, 0xEB15, 0xF3D7, 0xF419, 0xCA2A, 0xB107, 0xA8E8, 0xA18A, 0xEA2F, 0xE1CE, 0xD16C, 0xD96B, 0xDA0D, 
        0xD9EC, 0xD1CB, 0xC96A, 0xC928, 0xB8E6, 0xB0C5, 0xA8A4, 0x9885, 0x9884, 0x9882, 0x9062, 0x8842, 0x8063, 0x78C4, 0x6103, 0x50C0, 0x4942, 0x51E3, 0x62A5, 0x72E4, 0x5A63, 0x4961, 0x3820, 0x3821, 0x6946, 0x926B, 0xB34F, 0xDC14, 0xF518, 0xFDBB, 
        0xFDFC, 0xFE3E, 0xFE7E, 0xFE9E, 0xFE9E, 0xFE3B, 0xF61B, 0xF61A, 0xF5B8, 0xFD36, 0xF555, 0xED56, 0xED58, 0xE555, 0xB3AF, 0x928B, 0x81C9, 0x3863, 0x40E2, 0x61E5, 0x7AC8, 0x49A2, 0x59A3, 0x6163, 0x60A3, 0x6025, 0x6845, 0x68A5, 0x5924, 0x48A3, 
        0x4882, 0x6905, 0x99E9, 0x89A8, 0x7105, 0x6884, 0x6825, 0x5003, 0x4001, 0x3000, 0x2800, 0x4802, 0x6003, 0x5803, 0x3802, 0x6022, 0x7967, 0x926C, 0xB2F0,
  0xAB5B, 0xAB5B, 0xAB5B, 0xA35B, 0xAB5B, 0xAB7B, 0xAB7C, 0xAB7C, 0xAB7C, 0xAB7C, 0xAB7B, 0xAB7B, 0xB3BD, 0xB39D, 0xB37D, 0xB37D, 0xA37C, 0xA35B, 0x9B5A, 0x9339, 0x8AD3, 0x92D3, 0x92D5, 0x92D7, 0xA35B, 0xA39A, 0xA399, 0xA359, 0xA35B, 0x9B78, 0xA397, 
        0xABD8, 0xABB7, 0x9B94, 0x9351, 0x9B2F, 0x8B2D, 0x8B2B, 0x82E9, 0x7AA8, 0xA38E, 0xAB52, 0xB316, 0xBB18, 0xA416, 0xABF5, 0xB3B3, 0xAB91, 0x8B50, 0x7310, 0x6B0F, 0x6B0D, 0x7B4E, 0x7B6E, 0x7B8D, 0x7B8D, 0x6B4B, 0x736C, 0x7B6C, 0x7B4D, 0x732C, 
        0x7B4C, 0x832C, 0x82AA, 0x7A26, 0x71C5, 0x7184, 0x79A3, 0x69A4, 0x59C3, 0x49A3, 0x4183, 0x31E5, 0x4A67, 0x62CA, 0x7B4D, 0x8410, 0x9450, 0x9470, 0x9470, 0x9C92, 0xACF3, 0xB554, 0xBDB5, 0xB575, 0xBDB5, 0xD699, 0xEF7D, 0xA535, 0x8C52, 0x6AED, 
        0x4167, 0x8393, 0x8BF6, 0x8375, 0x7AD2, 0x7B54, 0x7B53, 0x7B53, 0x8B94, 0x8395, 0x93B4, 0x9BF5, 0xA416, 0xAC37, 0xAC37, 0xAC57, 0xAC78, 0xB476, 0xAC56, 0xA436, 0x9BF5, 0x9BF4, 0x9BD5, 0x9BB5, 0xA394, 0x9B94, 0x9394, 0x8B93, 0x8B53, 0x9373, 
        0xA3B4, 0xA3F5, 0xA3F5, 0x9372, 0xB2F4, 0xDAB8, 0xFA9E, 0xFABD, 0xFA79, 0xF1D4, 0xF0D0, 0xE973, 0xF193, 0xF9B4, 0xF9D6, 0xF998, 0xF9D9, 0xFA18, 0xFA16, 0xFA58, 0xF9D7, 0xF977, 0xF197, 0xFA5C, 0xF9DA, 0xF997, 0xF976, 0xF976, 0xF996, 0xF996, 
        0xF9B6, 0xFA37, 0xF9D5, 0xF995, 0xF976, 0xF9B7, 0xF9D6, 0xF9D6, 0xF995, 0xE0EE, 0xD8AE, 0xD8AF, 0xD8CE, 0xD8CD, 0xD8CD, 0xD8AD, 0xD8AD, 0xE0EF, 0xF172, 0xF9B3, 0xF9B3, 0xF912, 0xF0B1, 0xF0D1, 0xF995, 0xFAD9, 0xF174, 0xE890, 0xE0AF, 0xE0D0, 
        0xE0D0, 0xE8F1, 0xF153, 0xFA17, 0xF9F7, 0xF9B7, 0xF9B8, 0xF1F7, 0xF9D7, 0xF996, 0xF134, 0xE934, 0xE933, 0xE913, 0xE0F4, 0xE912, 0xF154, 0xF955, 0xF995, 0xFAB8, 0xFA78, 0xF9B6, 0xF0B3, 0xF936, 0xF9B7, 0xFA18, 0xFA3A, 0xFA3A, 0xFA3A, 0xFA3A, 
        0xFA59, 0xF9F5, 0xE952, 0xD0CE, 0xB06A, 0xB06A, 0xC0CC, 0xC90D, 0xD90D, 0xD8EE, 0xD08D, 0xD0AD, 0xE10E, 0xE86E, 0xE8F0, 0xD930, 0xC8CE, 0xC0EB, 0xB869, 0xA828, 0x9848, 0xA92A, 0xC9AC, 0xE20D, 0xEA6E, 0xDA4D, 0xE26E, 0xEAB0, 0xFAF0, 0xEA6E, 
        0xDA2D, 0xD9EC, 0xD9AB, 0xB0A5, 0xA8C6, 0xB0E6, 0xB906, 0xA0A3, 0x98A4, 0x98A4, 0x9864, 0x90C5, 0x7905, 0x6144, 0x5163, 0x4182, 0x3941, 0x41A1, 0x5282, 0x6AA4, 0x69A3, 0x58E2, 0x4882, 0x4822, 0x5022, 0x68A5, 0x8928, 0x7907, 0xAAAF, 0xDC15, 
        0xFD39, 0xFDBE, 0xFE5F, 0xFEBE, 0xFEDD, 0xFE9D, 0xFEDD, 0xF6FD, 0xF6BB, 0xFD38, 0xF536, 0xF596, 0xFDF7, 0xECD6, 0xDCB3, 0xD4D3, 0xC453, 0x6946, 0x48C2, 0x4902, 0x59C5, 0x72A4, 0x61A3, 0x60E3, 0x60A4, 0x6045, 0x6065, 0x6864, 0x7044, 0x60A5, 
        0x60A4, 0x60C3, 0x6102, 0x91C7, 0x8126, 0x70A5, 0x7065, 0x7826, 0x8047, 0x8047, 0x7846, 0x6886, 0x8149, 0x91AA, 0x8969, 0x8A0B, 0xAB0E, 0xB350, 0xB2D0,
  0xA35B, 0xA33A, 0xA33A, 0xAB5A, 0xA37B, 0xAB5B, 0xAB3C, 0xAB5B, 0xAB7B, 0xAB7B, 0xAB7B, 0xB37B, 0xAB7C, 0xB37C, 0xB37D, 0xAB7D, 0xA35C, 0xA35B, 0xA35A, 0x9B59, 0x92F5, 0x9313, 0x8B11, 0x7ACF, 0x9332, 0x9354, 0x9335, 0x92F6, 0x8AF7, 0x8B15, 0x8B34, 
        0x9B54, 0xA336, 0x9335, 0x9355, 0xA355, 0x9B50, 0x930D, 0x92CA, 0x92CA, 0x9B8C, 0xA371, 0xAB16, 0xB2D9, 0x93B3, 0x9B92, 0x9B72, 0x934F, 0x830D, 0x6AEE, 0x62EF, 0x6AED, 0x6B2D, 0x6B2C, 0x6B2C, 0x6B6D, 0x736C, 0x734B, 0x734B, 0x734C, 0x732C, 
        0x834C, 0x932B, 0x92CA, 0x6227, 0x6A06, 0x71C6, 0x6986, 0x61A5, 0x49A3, 0x3982, 0x2942, 0x1943, 0x31A4, 0x4A06, 0x5A8A, 0x738D, 0x83AE, 0x8BEE, 0x942E, 0xA513, 0xA534, 0xA513, 0xB554, 0xE6FA, 0xF73B, 0xEF3B, 0xC6B8, 0x6AED, 0x51EB, 0x6A8F, 
        0x93F7, 0x6B31, 0x7B33, 0x7B55, 0x7374, 0x9394, 0x9394, 0x8B73, 0x8B73, 0x9BB6, 0x9BB5, 0x9BF5, 0xA476, 0xB477, 0xB498, 0xB4D9, 0xB4DA, 0xCCDA, 0xCCDA, 0xCCFA, 0xC51B, 0xAC57, 0x9BD6, 0x9BD5, 0x9BF5, 0xAB75, 0xA353, 0x9B33, 0x9B33, 0x9BB5, 
        0xA3D6, 0xABB5, 0xA393, 0x9372, 0xAB73, 0xC374, 0xD356, 0xF2DB, 0xF27C, 0xF21B, 0xF197, 0xF113, 0xF194, 0xF9D6, 0xF9D7, 0xF994, 0xFA15, 0xFA57, 0xF9F9, 0xF9D7, 0xF197, 0xF198, 0xF9B9, 0xF9B7, 0xF176, 0xF1D7, 0xFA79, 0xF156, 0xF176, 0xF9D6, 
        0xFA16, 0xF995, 0xF1B4, 0xF1D5, 0xF1D7, 0xF9B6, 0xF996, 0xF995, 0xF132, 0xD86F, 0xD8AE, 0xD8AD, 0xD0AE, 0xD90E, 0xD8CD, 0xD88D, 0xD0AD, 0xF14F, 0xF9B3, 0xF9B4, 0xF972, 0xE84F, 0xF0F2, 0xF1F6, 0xFA99, 0xF9B5, 0xE8F2, 0xD890, 0xD84E, 0xD8AE, 
        0xE0CF, 0xE111, 0xE9B3, 0xF9D7, 0xF9B6, 0xF1B6, 0xF1B6, 0xF177, 0xE956, 0xE955, 0xF175, 0xF174, 0xE934, 0xE934, 0xE934, 0xF154, 0xF174, 0xF9D5, 0xFA98, 0xFA3A, 0xF135, 0xF0B3, 0xE8D4, 0xFABB, 0xFA9B, 0xFA7A, 0xFA5A, 0xFA1B, 0xFA39, 0xFA58, 
        0xFA39, 0xF197, 0xE0F2, 0xD08E, 0xD06C, 0xB08B, 0xC0CC, 0xD0ED, 0xD12E, 0xE94F, 0xE10F, 0xD90F, 0xE151, 0xE970, 0xD92E, 0xD110, 0xE153, 0xE9D0, 0xD16D, 0xB8EB, 0xA8AA, 0xB94B, 0xE250, 0xF250, 0xE98D, 0xF22F, 0xEA4F, 0xE22E, 0xDA2D, 0xE22D, 
        0xD16A, 0xC128, 0xC169, 0xB066, 0xB064, 0xA884, 0x9885, 0x9863, 0x9022, 0x8801, 0x8022, 0x98C6, 0x90C5, 0x70A3, 0x48C1, 0x5963, 0x3962, 0x39E3, 0x5AA5, 0x59E2, 0x4181, 0x3921, 0x4081, 0x4801, 0x5022, 0x7127, 0xAACF, 0xCBF2, 0xBB70, 0xC391, 
        0xDC96, 0xFE7D, 0xFE9F, 0xFE9F, 0xFE9F, 0xFE5C, 0xF61B, 0xF61B, 0xF5FB, 0xFD59, 0xF517, 0xED37, 0xF558, 0xED13, 0xB3AE, 0x92CC, 0x828A, 0x3061, 0x40C2, 0x5185, 0x61E6, 0x5163, 0x5142, 0x5102, 0x6082, 0x5865, 0x58A5, 0x60C4, 0x68C3, 0x6845, 
        0x68A5, 0x60C4, 0x60E4, 0x8A88, 0x5945, 0x4863, 0x6886, 0x6045, 0x7026, 0x7846, 0x7887, 0x8087, 0x9108, 0x90E6, 0x7864, 0xB291, 0xA2AE, 0xA2AC, 0xAAAE,
  0xAB5A, 0xA33B, 0xA33A, 0xA37A, 0xAB5B, 0xAB5B, 0xAB5C, 0xAB5C, 0xB37B, 0xB37B, 0xAB7B, 0xAB9B, 0xAB7C, 0xAB7C, 0xAB7C, 0xA3BA, 0xA379, 0x9B57, 0x9B56, 0x9B56, 0x7AD1, 0x7ACF, 0x72AD, 0x626A, 0x82EE, 0x8311, 0x8312, 0x8AF3, 0x82B2, 0x626E, 0x5A6D, 
        0x72CF, 0x72F3, 0x9376, 0xA3B8, 0xA398, 0xA355, 0x8B10, 0x72CC, 0x6A89, 0x9B4C, 0x9B4E, 0x9B52, 0x9B35, 0x8B52, 0x832F, 0x82ED, 0x82CB, 0x6B0C, 0x6B0D, 0x62ED, 0x62EB, 0x732A, 0x732B, 0x734C, 0x7B8D, 0x736C, 0x734C, 0x732D, 0x6B2C, 0x936B, 
        0x934B, 0x932C, 0x9B0B, 0x7245, 0x69E5, 0x61A5, 0x5965, 0x5145, 0x4966, 0x3965, 0x2945, 0x31A5, 0x31A4, 0x39C5, 0x4A27, 0x630B, 0x736D, 0x83AE, 0x8C0E, 0xACF5, 0xB554, 0xAD73, 0xADD4, 0xEF9D, 0xCE59, 0x8410, 0x39A7, 0x5A6E, 0x8B74, 0x8B95, 
        0x6AF3, 0x7B54, 0x72F2, 0x7AF2, 0x8353, 0x7353, 0x8B94, 0x9BB5, 0xA3D6, 0x9C35, 0xA496, 0xAC97, 0xB478, 0xBCF9, 0xC519, 0xC53A, 0xCD7B, 0xE59D, 0xE59D, 0xE59D, 0xE5BC, 0xCD5B, 0xCD5A, 0xCD3B, 0xC4DA, 0xA456, 0xA416, 0xABD6, 0xB3B5, 0x9B74, 
        0x9B94, 0x9BB3, 0x9371, 0xC354, 0xA372, 0x9B72, 0xBB36, 0xF27C, 0xFA9E, 0xFA9C, 0xFA18, 0xE933, 0xF172, 0xF992, 0xF172, 0xF1F5, 0xF9D5, 0xF9D6, 0xF996, 0xF135, 0xF0F4, 0xF934, 0xF995, 0xF998, 0xFA18, 0xF9F7, 0xF976, 0xFA17, 0xF9F6, 0xF9B6, 
        0xF976, 0xF1B4, 0xF1D5, 0xF9B5, 0xF175, 0xF1D6, 0xF995, 0xF974, 0xF133, 0xD8AE, 0xD8AD, 0xD8CE, 0xE10F, 0xE0EF, 0xD8CE, 0xD8AD, 0xE0AE, 0xF9D5, 0xF993, 0xF0F1, 0xE870, 0xF9B5, 0xF9F7, 0xFA17, 0xFA37, 0xE9D5, 0xD8B0, 0xD04E, 0xD08F, 0xE0B3, 
        0xE0D1, 0xE0F0, 0xF152, 0xF196, 0xF195, 0xF1B6, 0xF9D8, 0xF196, 0xF156, 0xE935, 0xE934, 0xF193, 0xE154, 0xE134, 0xE934, 0xF176, 0xFA37, 0xFA58, 0xF9F8, 0xE8B3, 0xF114, 0xFA18, 0xFB1D, 0xFA39, 0xF9F9, 0xFA19, 0xFA1A, 0xFA7A, 0xFA59, 0xFA3A, 
        0xFA5B, 0xF9F8, 0xE953, 0xD0AE, 0xB84B, 0xC0AB, 0xC0CB, 0xD10D, 0xE18E, 0xD12D, 0xE150, 0xE950, 0xE12E, 0xD10F, 0xD910, 0xD930, 0xD96E, 0xB0EB, 0xA8A9, 0xB0CA, 0xC12B, 0xC8A9, 0xC8CA, 0xC92B, 0xC9AC, 0xDA0C, 0xE22D, 0xD9EB, 0xC148, 0xB928, 
        0xC949, 0xC949, 0xB0E7, 0xA085, 0x9884, 0x9043, 0x8822, 0x9084, 0x8844, 0x98A6, 0xB969, 0x89C7, 0x71A6, 0x5984, 0x3962, 0x2942, 0x3162, 0x41C3, 0x5A24, 0x5A63, 0x59C3, 0x50E2, 0x4842, 0x4863, 0x4043, 0x4022, 0x5062, 0xBA8F, 0xD3B3, 0xDC75, 
        0xDCD7, 0xFE3E, 0xFE9F, 0xFE9F, 0xFEBF, 0xFEFD, 0xF61B, 0xF599, 0xFDBA, 0xF5B7, 0xF576, 0xED55, 0xDD56, 0xED16, 0xB3CF, 0x8AAA, 0x71C9, 0x4903, 0x48A3, 0x50C3, 0x5144, 0x41A4, 0x4162, 0x5123, 0x5905, 0x5124, 0x5104, 0x58E4, 0x68C4, 0x60C5, 
        0x68C6, 0x6906, 0x5124, 0x3061, 0x50E4, 0x68E5, 0x6885, 0x6845, 0x7046, 0x7046, 0x7047, 0x7067, 0x6845, 0x70C6, 0x99EA, 0xAA6E, 0xC352, 0xBB31, 0x9A2C,
  0xAB7B, 0xAB7B, 0xAB7B, 0xA35B, 0xAB7C, 0xAB7C, 0xAB7D, 0xAB5D, 0xAB9B, 0xAB9B, 0xAB9B, 0xB39C, 0xABBD, 0xB39D, 0xB3DD, 0xAC1E, 0xAB7B, 0xAB7A, 0xAB9B, 0xABBB, 0x9315, 0x8B12, 0x8B10, 0x82EF, 0x6AB0, 0x72CD, 0x72EC, 0x7AAA, 0x5A49, 0x5A0A, 0x624C, 
        0x7ACE, 0x8335, 0x9BDA, 0xB41C, 0xB3FC, 0xAB79, 0x9334, 0x7AEF, 0x6AAA, 0x930B, 0x930D, 0x9310, 0x9314, 0x8B6F, 0x8B4D, 0x832C, 0x7B4B, 0x7B2A, 0x6B0C, 0x6B2D, 0x734D, 0x736C, 0x7B6D, 0x836E, 0x838E, 0x7B6D, 0x738D, 0x738D, 0x834D, 0x934C, 
        0x9B6C, 0xA36B, 0x9B4A, 0x9AE9, 0x8268, 0x61E7, 0x4945, 0x5126, 0x5187, 0x4986, 0x3945, 0x29A6, 0x29C5, 0x39E5, 0x5248, 0x5AEB, 0x6B2C, 0x7B4D, 0x838E, 0x9CB2, 0xB555, 0xD638, 0xEEDA, 0x9C92, 0x5A8A, 0x4A49, 0x736F, 0x8BD7, 0x7B95, 0x7353, 
        0x7AF4, 0x8374, 0x9BB5, 0x9396, 0x8355, 0xA435, 0xA415, 0xA436, 0x9C76, 0xAC77, 0xB497, 0xB496, 0xB496, 0xD55C, 0xDD7C, 0xDD7C, 0xD59D, 0xE5DE, 0xEDFE, 0xEE1F, 0xF5FF, 0xF61E, 0xEE1E, 0xE5DE, 0xE57C, 0xD55E, 0xC55D, 0xB53A, 0xAC98, 0xBC15, 
        0xB3F5, 0xA3B4, 0x9371, 0xABB6, 0xABB4, 0xA3B3, 0x9B72, 0xCB16, 0xEAD8, 0xFADB, 0xFADE, 0xFA3B, 0xF9F6, 0xF9B4, 0xF975, 0xF9D4, 0xF9B5, 0xF176, 0xF934, 0xF0D2, 0xF975, 0xF9F7, 0xFA18, 0xF955, 0xF976, 0xF9F9, 0xF25B, 0xF9F8, 0xF9F8, 0xF9D8, 
        0xF997, 0xF9D6, 0xFA16, 0xF9F6, 0xF995, 0xF9B5, 0xE933, 0xE8F2, 0xF0F1, 0xE8CF, 0xE911, 0xE951, 0xE94F, 0xE0F0, 0xD8AF, 0xE0CF, 0xF132, 0xF992, 0xF973, 0xF933, 0xF934, 0xF9D8, 0xF9F8, 0xFA38, 0xFA59, 0xD870, 0xD870, 0xD88F, 0xD06F, 0xE0F0, 
        0xE8D0, 0xE8D1, 0xF114, 0xE952, 0xF173, 0xF195, 0xF1B6, 0xF995, 0xF975, 0xF155, 0xE933, 0xF133, 0xE954, 0xE954, 0xF156, 0xFA17, 0xFA79, 0xFA38, 0xF196, 0xF9D7, 0xFA79, 0xFABA, 0xFA79, 0xF997, 0xF999, 0xF9D9, 0xFA39, 0xFA7B, 0xFA3B, 0xFA3A, 
        0xFA5A, 0xFA3A, 0xF9F7, 0xF194, 0xE910, 0xC04B, 0xB86A, 0xB88A, 0xB06A, 0xD8F0, 0xD90F, 0xD90E, 0xD90F, 0xD8F0, 0xD931, 0xD950, 0xD92F, 0xC08C, 0xC0CC, 0xB8CB, 0xA889, 0xA887, 0xA045, 0xB046, 0xD0CA, 0xC10B, 0xC14B, 0xC98C, 0xD9AC, 0xD16A, 
        0xC149, 0xB928, 0xC0C7, 0xA8A5, 0x9064, 0x9865, 0xB0E7, 0xB26B, 0xDB4F, 0xF3F2, 0xEC33, 0x91AB, 0x7127, 0x5944, 0x3181, 0x1142, 0x3943, 0x5142, 0x5941, 0x6307, 0x6285, 0x59A4, 0x50E2, 0x4821, 0x5021, 0x5023, 0x4824, 0x68A3, 0x8147, 0x89AA, 
        0x81CA, 0xA28F, 0xDC56, 0xFDFC, 0xFF1F, 0xFF5E, 0xFF3E, 0xF6FD, 0xF6BE, 0xFE7D, 0xF5DA, 0xF557, 0xECD6, 0xFD96, 0xED55, 0xC472, 0x830D, 0x5883, 0x4841, 0x48C2, 0x5144, 0x5143, 0x4984, 0x51A4, 0x59A4, 0x59C6, 0x59E4, 0x59A3, 0x5964, 0x5905, 
        0x5905, 0x5945, 0x5985, 0x58E2, 0x6944, 0x7125, 0x7845, 0x6865, 0x6865, 0x7026, 0x7827, 0x78A6, 0x80E7, 0x8107, 0x7105, 0x898D, 0x898A, 0x922B, 0xB34F,
  0xAB5B, 0xA35B, 0xA35A, 0xAB3B, 0xAB7B, 0xAB7C, 0xAB7C, 0xAB5C, 0xAB7B, 0xAB7C, 0xAB7C, 0xB37C, 0xAB9C, 0xB39D, 0xAB9C, 0xAB7A, 0x9B7A, 0xA379, 0xA377, 0x9B54, 0x9336, 0x9353, 0x9371, 0x8B8E, 0x8B6C, 0x938A, 0x93AA, 0x83AA, 0x9328, 0x8328, 0x7B08, 
        0x72A7, 0x830B, 0x936E, 0xA3B2, 0xA3B5, 0x8B32, 0x830D, 0x72CA, 0x6289, 0x732B, 0x732A, 0x7329, 0x732A, 0x6B0E, 0x732C, 0x730A, 0x6AEA, 0x6B2A, 0x734B, 0x734C, 0x736D, 0x7B4D, 0x736D, 0x736C, 0x6B4B, 0x7B2D, 0x734D, 0x7B6C, 0x8B6D, 0x9BAC, 
        0xA3AB, 0xA38A, 0xA349, 0x9B49, 0x9B2C, 0x8AAC, 0x6A09, 0x5A29, 0x5229, 0x4A09, 0x49E7, 0x3966, 0x4A05, 0x5246, 0x4A67, 0x62EB, 0x6B0B, 0x6B4C, 0x840E, 0xAD94, 0xC614, 0xCE76, 0xBDF6, 0x39A7, 0x62EF, 0x83D5, 0x7395, 0x8393, 0x7354, 0x7B35, 
        0x9375, 0x8B74, 0x8394, 0x8BD5, 0x93D6, 0x9BD5, 0x9BF5, 0x9C16, 0xA456, 0xBC99, 0xB4B8, 0xBCB6, 0xC4B6, 0xB519, 0xCD5B, 0xDD9C, 0xE5DC, 0xEDBE, 0xE5DE, 0xE61E, 0xEE5F, 0xEE5F, 0xE63E, 0xE5FE, 0xE59C, 0xDDBB, 0xD57A, 0xD53A, 0xCC99, 0xAC35, 
        0xABD4, 0xAB94, 0xA393, 0x8B72, 0x9B92, 0x9B92, 0x9392, 0xAB51, 0xDB55, 0xF319, 0xFA9C, 0xF9DF, 0xFA5D, 0xFA7A, 0xFA17, 0xF974, 0xF935, 0xF955, 0xF174, 0xF1B8, 0xFA38, 0xFA18, 0xF977, 0xF136, 0xF239, 0xFA7A, 0xFA1A, 0xFA9B, 0xFA5B, 0xFA18, 
        0xF9D6, 0xF996, 0xF175, 0xF1B5, 0xF1F5, 0xF995, 0xE112, 0xD8F1, 0xE0F1, 0xE131, 0xE132, 0xE111, 0xE110, 0xD8CE, 0xE0AE, 0xE8AE, 0xF110, 0xF9B5, 0xF974, 0xF194, 0xF1D5, 0xFA38, 0xF9F8, 0xE955, 0xD0B1, 0xD891, 0xE8D2, 0xE8D1, 0xE0CF, 0xD08E, 
        0xE0CF, 0xE912, 0xE934, 0xE131, 0xE932, 0xF173, 0xF1D5, 0xF1F6, 0xF175, 0xE954, 0xE155, 0xE934, 0xF155, 0xF1B6, 0xF1F7, 0xFA79, 0xFA18, 0xF1D7, 0xF9F7, 0xFA57, 0xFA37, 0xF9D7, 0xF977, 0xF196, 0xF239, 0xFA7A, 0xFA7A, 0xFA3D, 0xFA1C, 0xFA3C, 
        0xFA5C, 0xFA5A, 0xFA18, 0xF195, 0xE0B0, 0xC04B, 0xB86A, 0xB8AA, 0xC0CB, 0xC8CE, 0xD0EE, 0xD10E, 0xD10F, 0xE192, 0xD90F, 0xD0CE, 0xD0AF, 0xC8ED, 0xC8AC, 0xB8AB, 0xA8CA, 0xA868, 0xB909, 0xB909, 0xA087, 0xA8C7, 0xC18B, 0xC9ED, 0xB98B, 0xA0E6, 
        0xA0C7, 0x98A5, 0x88A3, 0xA8E9, 0xB9CA, 0xC2AD, 0xCBB1, 0xF3D2, 0xD2CE, 0x9188, 0x5042, 0x58C3, 0x48E2, 0x4922, 0x51A3, 0x48E1, 0x3942, 0x39A2, 0x41E3, 0x62A5, 0x59E4, 0x5102, 0x5021, 0x4043, 0x4883, 0x6083, 0x7084, 0x5886, 0x91CB, 0xBAEF, 
        0xC372, 0x8ACE, 0xCD98, 0xF75E, 0xFF7F, 0xFE5E, 0xF5DC, 0xF5DB, 0xF63B, 0xF5FA, 0xFD57, 0xFD15, 0xFD35, 0xE537, 0x934E, 0x6A28, 0x6A06, 0x5123, 0x5924, 0x6105, 0x60A4, 0x3962, 0x39A3, 0x41C4, 0x49C4, 0x49E1, 0x51C3, 0x51C4, 0x51A4, 0x5205, 
        0x5245, 0x51E4, 0x5961, 0x49C5, 0x5183, 0x50E2, 0x4862, 0x6927, 0x6885, 0x7044, 0x8086, 0x704C, 0x70A9, 0x7106, 0x7167, 0xB2AD, 0xA2EC, 0x928C, 0x99ED,
  0xAB5B, 0xAB5A, 0xA35A, 0xAB5A, 0xAB3B, 0xAB5B, 0xAB7B, 0xB37B, 0xB37B, 0xAB5B, 0xAB5C, 0xAB7C, 0xAB7C, 0xAB9B, 0xB37C, 0xBB1D, 0xAB7C, 0xA39A, 0xA379, 0xA37A, 0x9318, 0x9B76, 0xA396, 0xA3B6, 0xB4B3, 0xBCB1, 0xB48E, 0xB46B, 0x9C68, 0x9BCB, 0x9B6D, 
        0x938D, 0xA391, 0x9B72, 0x9334, 0x82D6, 0x8312, 0x730C, 0x62A8, 0x5A48, 0x62C9, 0x62E9, 0x6B48, 0x6BA7, 0x6ACC, 0x730C, 0x732B, 0x6B0A, 0x6B2B, 0x6B2C, 0x736C, 0x7BAD, 0x736E, 0x6B6D, 0x734C, 0x732D, 0x736C, 0x736D, 0x7B6D, 0x838D, 0x938C, 
        0xA3AC, 0xABAC, 0xABAB, 0xABAA, 0xA38B, 0xA36E, 0xA370, 0x9B6E, 0x7AED, 0x6ACD, 0x6AED, 0x31E6, 0x41E5, 0x4206, 0x4227, 0x52C9, 0x6B6C, 0x7BCD, 0x8C4E, 0xE6DC, 0x9CD6, 0x4A4E, 0x20C9, 0x8C18, 0x83B6, 0x8335, 0x8B37, 0x6B33, 0x8354, 0x9B75, 
        0x9B95, 0x83B4, 0x8BB5, 0x9395, 0x93B5, 0x9BF6, 0xA457, 0xAC97, 0xACB7, 0xBCB7, 0xC4F7, 0xC519, 0xCD3B, 0xC559, 0xCD7A, 0xDD7A, 0xDD5A, 0xEDDE, 0xEDDE, 0xE5DD, 0xDE3D, 0xE61E, 0xEE3F, 0xEE5F, 0xE65F, 0xDDDD, 0xE5DD, 0xE5DC, 0xD59A, 0xBC35, 
        0xABF5, 0xABF5, 0xB3B5, 0x9B91, 0x9392, 0x9393, 0x9B72, 0xAB52, 0xC2F5, 0xDB38, 0xF39A, 0xFABD, 0xFA9E, 0xF29C, 0xEA58, 0xF177, 0xF156, 0xF976, 0xF997, 0xFA9A, 0xF1F8, 0xF176, 0xF136, 0xF23B, 0xFA1A, 0xFA39, 0xFA99, 0xFA7D, 0xFA5C, 0xFA1A, 
        0xF1B8, 0xE996, 0xF1B7, 0xF9D7, 0xF9F6, 0xD8D0, 0xE0D1, 0xE0F2, 0xE0F2, 0xD951, 0xD8F1, 0xD8D1, 0xD8B1, 0xD8AF, 0xD8AE, 0xE8EF, 0xF972, 0xF133, 0xF195, 0xF9F7, 0xFA18, 0xF175, 0xE0D2, 0xD071, 0xD070, 0xF174, 0xE933, 0xE0D1, 0xE08F, 0xD0AE, 
        0xD8F0, 0xE111, 0xE931, 0xF154, 0xE933, 0xE953, 0xF154, 0xF176, 0xF155, 0xF174, 0xF193, 0xF155, 0xF196, 0xF1F7, 0xFA18, 0xF1D7, 0xF1B7, 0xF997, 0xF997, 0xF9D8, 0xF1B7, 0xF1B7, 0xF9F8, 0xFA9B, 0xFA7A, 0xFA3A, 0xFA5B, 0xF9FB, 0xFA3C, 0xFA5C, 
        0xFA7B, 0xFA7C, 0xFA39, 0xF1B6, 0xE111, 0xC04A, 0xB849, 0xB86A, 0xB86A, 0xC0CC, 0xC8CD, 0xD0CD, 0xD8EE, 0xD92E, 0xD90F, 0xD0EE, 0xC8CD, 0xC88D, 0xC0CB, 0xB90B, 0xB10A, 0x9826, 0xA026, 0xA8A8, 0xB96A, 0xB147, 0xA0C5, 0x9865, 0x9065, 0xA0C4, 
        0xA085, 0x8025, 0x5002, 0x5821, 0x8906, 0x8948, 0x50E5, 0x3821, 0x2820, 0x30C2, 0x51A5, 0x41A5, 0x39C2, 0x39A1, 0x3942, 0x4161, 0x3941, 0x3162, 0x39C3, 0x52A4, 0x51C3, 0x50C2, 0x5821, 0x5822, 0x5023, 0x5043, 0x5064, 0x6063, 0x4042, 0x5926, 
        0xBB10, 0xE536, 0xF5F9, 0xF67C, 0xFEDE, 0xFE9B, 0xFEBC, 0xEE9B, 0xDDF8, 0xF57A, 0xFD79, 0xF556, 0xE4D4, 0xB32F, 0x81A9, 0x6106, 0x6145, 0x68E5, 0x6084, 0x5883, 0x6083, 0x4924, 0x4985, 0x41C4, 0x39C2, 0x41C2, 0x5202, 0x5203, 0x51C4, 0x5284, 
        0x4A02, 0x41C2, 0x4A04, 0x49E2, 0x49C2, 0x5202, 0x5A43, 0x4921, 0x59E4, 0x5A05, 0x4182, 0x58E3, 0x70E6, 0x80E9, 0x914C, 0xB26D, 0xAAAD, 0x9A8D, 0x99EB,
  0xAB7C, 0xAB5B, 0xAB5B, 0xAB7B, 0xAB7C, 0xAB7B, 0xAB7B, 0xAB7C, 0xB39C, 0xAB7C, 0xAB9C, 0xB39C, 0xB3BD, 0xB39D, 0xB39D, 0xAB9E, 0xABBC, 0xABBC, 0xABBC, 0xA39C, 0xB3F8, 0xB416, 0xB455, 0xBC94, 0xB4B0, 0xBCCF, 0xC4EF, 0xBD0E, 0xA4AD, 0xACAB, 0xB489, 
        0xA429, 0xA42C, 0x9BEB, 0x93CB, 0x8BAA, 0x8B4B, 0x7B0A, 0x6AA9, 0x6268, 0x6AE9, 0x6AE9, 0x730A, 0x7B2B, 0x736D, 0x736D, 0x736C, 0x736B, 0x732C, 0x7B6C, 0x7B8D, 0x83AE, 0x736E, 0x736D, 0x7B4D, 0x7B4D, 0x732C, 0x7B6D, 0x838D, 0x936C, 0x8B8B, 
        0xA3AB, 0xABCB, 0xA3CB, 0xB3EB, 0xABCC, 0xABCD, 0xABCF, 0xA410, 0x7B4D, 0x6B0B, 0x732C, 0x5A29, 0x41C6, 0x41C7, 0x4A4B, 0x52AA, 0x5ACB, 0x7BAF, 0xACD3, 0x5AAC, 0x628F, 0x7B34, 0x9BF8, 0x8B35, 0x8B54, 0x8394, 0x7BB5, 0x8354, 0x9B75, 0x9B96, 
        0x9B97, 0x8416, 0x9C56, 0xAC58, 0xAC59, 0xAC96, 0xBC98, 0xBCBA, 0xBCDA, 0xBD39, 0xC53A, 0xCD5A, 0xD55B, 0xD57B, 0xD57A, 0xDD5A, 0xDD7B, 0xDD9C, 0xE59E, 0xEDBE, 0xE5FD, 0xDE3F, 0xE65F, 0xEE5F, 0xE63F, 0xE67F, 0xE63F, 0xE5FE, 0xDDBD, 0xDD5A, 
        0xCCF7, 0xBC76, 0xBC16, 0xA3B3, 0xB3B4, 0xB3B4, 0xABD3, 0xAB92, 0xB372, 0xCB34, 0xE2F8, 0xFADE, 0xFADF, 0xFABE, 0xFA7D, 0xFA38, 0xF9D8, 0xF9D9, 0xFA5A, 0xFA7B, 0xF23A, 0xF27B, 0xFAFE, 0xFAFC, 0xF1D8, 0xF176, 0xF9F7, 0xFA9E, 0xFA9D, 0xFABD, 
        0xFABD, 0xF195, 0xF996, 0xF997, 0xF195, 0xE0D2, 0xE0D2, 0xE0D1, 0xE0D0, 0xE911, 0xE932, 0xE912, 0xE8EF, 0xE8CF, 0xE8F0, 0xF0F0, 0xF112, 0xF1B4, 0xF9F6, 0xF1B5, 0xE8F1, 0xD892, 0xD8D2, 0xE113, 0xE133, 0xE0B0, 0xF133, 0xF995, 0xF155, 0xD06D, 
        0xD8AE, 0xE0D0, 0xE0D1, 0xE932, 0xE953, 0xF153, 0xF973, 0xF155, 0xF155, 0xF975, 0xF9B5, 0xF9D6, 0xF9F7, 0xF9D7, 0xF996, 0xF996, 0xF996, 0xF9B7, 0xF1D7, 0xFA16, 0xFA17, 0xFA59, 0xFABB, 0xFA7B, 0xFA7B, 0xFA7B, 0xFA7C, 0xFA7B, 0xFA7B, 0xFA7C, 
        0xFA5C, 0xFA5B, 0xFA7B, 0xFA7B, 0xFA19, 0xE110, 0xC8AB, 0xB88A, 0xB86B, 0xB8AB, 0xC0AC, 0xC8AD, 0xC8CD, 0xE0CF, 0xD8EF, 0xD90F, 0xE130, 0xD8AF, 0xC0CD, 0xB8EC, 0xB90B, 0xC14B, 0xB0EA, 0xA087, 0x9824, 0x8003, 0x8823, 0x9024, 0x9025, 0x7884, 
        0x9968, 0x9A09, 0x7A2A, 0x7909, 0x5904, 0x4123, 0x3964, 0x5924, 0x5182, 0x49A3, 0x4986, 0x39E4, 0x4183, 0x4983, 0x51E3, 0x41A1, 0x4962, 0x4162, 0x39A2, 0x6223, 0x6183, 0x60E3, 0x5863, 0x5082, 0x5862, 0x5862, 0x5882, 0x6823, 0x5002, 0x5041, 
        0x6943, 0xCC14, 0x9AED, 0x8ACC, 0xB473, 0xD5F8, 0xEEBD, 0xFF1E, 0xF6FE, 0xF65D, 0xFDDB, 0xFD99, 0xF536, 0xC412, 0xC3D1, 0xB370, 0x92AB, 0x7104, 0x6924, 0x6124, 0x58C3, 0x48E2, 0x4162, 0x41C3, 0x41C4, 0x51E1, 0x49A2, 0x49E3, 0x4A64, 0x51C3, 
        0x5222, 0x5AA4, 0x6B26, 0x7327, 0x8388, 0x8BA8, 0x8B66, 0x72E5, 0x6B06, 0x6B46, 0x6B06, 0x7A08, 0x79C6, 0x8207, 0x926B, 0x71C8, 0x68E5, 0x7086, 0x80E9,
  0xAB7B, 0xAB7B, 0xAB7B, 0xB37B, 0xA37B, 0xAB7C, 0xB37C, 0xAB7B, 0xAB9C, 0xB39C, 0xAB9C, 0xAB9C, 0xB3BD, 0xB39D, 0xB37C, 0xBB5C, 0xBBBD, 0xB3BB, 0xABBA, 0xABBA, 0xABDA, 0xB43C, 0xBC5B, 0xBC39, 0xBCD4, 0xC513, 0xCD33, 0xCD72, 0xC54F, 0xC4CC, 0xBC8B, 
        0xB46C, 0xAC8C, 0x9BEB, 0x936A, 0x934B, 0x732C, 0x6ACA, 0x6288, 0x5A88, 0x5A68, 0x62A9, 0x6AEB, 0x732C, 0x7349, 0x6B6A, 0x6B6C, 0x734C, 0x736C, 0x736C, 0x7B8D, 0x7BAD, 0x738E, 0x7B6D, 0x7B6D, 0x834D, 0x736C, 0x736D, 0x734D, 0x7B4C, 0x9B6A, 
        0xA369, 0xAB6A, 0xAB8A, 0xB42B, 0xB42D, 0xB3EF, 0xB412, 0xB4D4, 0x93F0, 0x836E, 0x838E, 0x6269, 0x5207, 0x4A28, 0x528A, 0x5AAA, 0x6B4D, 0x83F0, 0x9C32, 0x6311, 0x7B55, 0x8B95, 0x8372, 0x8336, 0x8B56, 0x8B55, 0x8B54, 0x8BD7, 0x93B6, 0x9376, 
        0x9375, 0xA4D8, 0xACB8, 0xAC77, 0xAC56, 0xB4DB, 0xB4DA, 0xB4D8, 0xC4D9, 0xCD3B, 0xCD3B, 0xCD1B, 0xCD3A, 0xD55A, 0xD55A, 0xD53A, 0xD53A, 0xDDDB, 0xDDDC, 0xDDBD, 0xDDDE, 0xE5BE, 0xDE1E, 0xE65E, 0xEE7E, 0xEE3E, 0xEDFE, 0xEDBF, 0xED9E, 0xB5FA, 
        0xC558, 0xCCB6, 0xBC75, 0xA3F4, 0x9BD3, 0x9BF2, 0x93F2, 0x9393, 0xB373, 0xBB74, 0xB396, 0xC316, 0xE339, 0xFB1C, 0xFABD, 0xF27B, 0xFA9B, 0xFA9C, 0xFA7B, 0xFA7B, 0xFABC, 0xFAFD, 0xFB3E, 0xFA9E, 0xF198, 0xF136, 0xF9B9, 0xFA7B, 0xFABE, 0xFA9E, 
        0xFA1C, 0xF23B, 0xF9F8, 0xF174, 0xE8D1, 0xD84F, 0xE8F0, 0xF152, 0xF952, 0xF934, 0xF973, 0xF973, 0xF953, 0xF132, 0xF132, 0xF174, 0xF9F6, 0xFA57, 0xE112, 0xD06F, 0xD0AF, 0xE151, 0xE131, 0xE912, 0xF0F3, 0xE913, 0xE933, 0xF153, 0xF173, 0xD8F0, 
        0xD8CE, 0xD8CF, 0xD8D1, 0xE912, 0xF153, 0xF174, 0xF174, 0xF114, 0xF174, 0xF1D5, 0xF216, 0xF9F6, 0xF9B6, 0xF976, 0xF175, 0xF136, 0xF9B6, 0xF9F7, 0xF9F7, 0xFA39, 0xFA3A, 0xFA3A, 0xFA5B, 0xFA7C, 0xFA9C, 0xFA9C, 0xFA7B, 0xFA7B, 0xFA5C, 0xFA5C, 
        0xFA5B, 0xFA9B, 0xFA3A, 0xFA19, 0xF1F9, 0xE134, 0xD8CF, 0xC88C, 0xB089, 0xB0AA, 0xB8CC, 0xC8AD, 0xD08D, 0xC8EE, 0xD10E, 0xD10F, 0xD910, 0xE0EE, 0xC8AD, 0xC0AC, 0xB8CB, 0xB8EA, 0xD10C, 0xD10C, 0xC12B, 0xEB10, 0xF330, 0xFB92, 0xFC55, 0xFB71, 
        0xD2AE, 0xA1EC, 0x6109, 0x5063, 0x58E4, 0x61A6, 0x5A07, 0x51E5, 0x4204, 0x49C4, 0x6165, 0x3143, 0x51A4, 0x59A4, 0x4943, 0x4182, 0x4161, 0x4181, 0x49C1, 0x51C4, 0x5984, 0x60E2, 0x6022, 0x5043, 0x5062, 0x5843, 0x5844, 0x6061, 0x7083, 0x8128, 
        0x9A8E, 0xDD34, 0xC3F1, 0xA2ED, 0x930C, 0xB4B3, 0xD5B8, 0xE5D8, 0xE596, 0xF61A, 0xF65A, 0xF65A, 0xF5DA, 0xC32E, 0xAACD, 0x9A6C, 0x81C8, 0x69C5, 0x6164, 0x5903, 0x58C2, 0x50C3, 0x5125, 0x4985, 0x41A4, 0x4A42, 0x4A03, 0x49C4, 0x41A3, 0x39C1, 
        0x6AE7, 0x93EA, 0x9C69, 0x73C5, 0x7B86, 0x8B66, 0x8345, 0x7B05, 0x7AE5, 0x7AC5, 0x72A4, 0x6307, 0x6305, 0x6AC4, 0x72A4, 0x7AC8, 0x7A48, 0x71C8, 0x6947,
  0xAB7B, 0xAB5B, 0xAB5B, 0xAB5B, 0xAB7A, 0xAB7B, 0xAB7B, 0xB39C, 0xB37B, 0xAB7C, 0xAB7C, 0xB39C, 0xB39C, 0xB39B, 0xB39C, 0xAB7E, 0xAB7E, 0xB3BD, 0xB3BD, 0xB3BD, 0xB47A, 0xBC97, 0xBC95, 0xBCB4, 0xD552, 0xD551, 0xD54F, 0xD58D, 0xBD50, 0xCD0D, 0xCD0A, 
        0xCD29, 0xAC6A, 0xB488, 0xAC67, 0x9BE6, 0x9326, 0x82E6, 0x7AE7, 0x72C7, 0x6284, 0x62A6, 0x62A8, 0x6288, 0x5ACA, 0x5AEA, 0x632A, 0x6B4B, 0x738B, 0x6B6C, 0x6B6C, 0x736D, 0x734C, 0x734C, 0x734C, 0x6B2D, 0x6AEA, 0x62EB, 0x6AEB, 0x7B2A, 0x832B, 
        0x8B4A, 0x938B, 0xA3CC, 0xC48C, 0xBC8D, 0xB48F, 0xBC91, 0xA42F, 0x940E, 0x83AC, 0x6AC9, 0x5209, 0x49C7, 0x49E7, 0x4229, 0x5AAB, 0x7352, 0x7373, 0x6312, 0x8335, 0x8B35, 0x8B35, 0x8355, 0x8B74, 0x8B54, 0x8B76, 0x93D8, 0x9396, 0x93F7, 0x9456, 
        0x9C75, 0xACB8, 0xAC78, 0xB478, 0xBCD7, 0xB4D8, 0xBD1A, 0xCD5B, 0xCD5B, 0xCD39, 0xD559, 0xD55A, 0xD57A, 0xD59A, 0xD57A, 0xD59A, 0xDDBA, 0xD57B, 0xD59B, 0xD59B, 0xD55C, 0xDDDE, 0xDDFE, 0xE61F, 0xE67F, 0xE67F, 0xE67E, 0xE63F, 0xDDDF, 0xCD9D, 
        0xD57C, 0xCD1A, 0xBC96, 0xA414, 0xA3F3, 0xAB93, 0xAB33, 0xAB53, 0xA372, 0xA352, 0xB312, 0xDB35, 0xF2F7, 0xFADB, 0xFAFE, 0xFADE, 0xFABE, 0xFA9D, 0xFA9B, 0xFABD, 0xFABD, 0xFABD, 0xFABD, 0xE0F5, 0xE8F5, 0xF196, 0xFA58, 0xFA9E, 0xFA5D, 0xFA3C, 
        0xFA5C, 0xFA5B, 0xF1F9, 0xF197, 0xF175, 0xF114, 0xF174, 0xF9B5, 0xF9B5, 0xF9B4, 0xF994, 0xF1B5, 0xF9B5, 0xF1D6, 0xF9F7, 0xFA17, 0xF1B5, 0xD04E, 0xD8AF, 0xD911, 0xE112, 0xE112, 0xE111, 0xD8F1, 0xE0B1, 0xE132, 0xF194, 0xF9D6, 0xF196, 0xD8AE, 
        0xD8B0, 0xD8B1, 0xE0D0, 0xE973, 0xE954, 0xE934, 0xF134, 0xF994, 0xF9B6, 0xF9D6, 0xF9D7, 0xF196, 0xF196, 0xF196, 0xF1D7, 0xFA38, 0xFA17, 0xF9F7, 0xF9F8, 0xFA37, 0xFA19, 0xFA1A, 0xFA5A, 0xFA39, 0xFA18, 0xF9F7, 0xF9D7, 0xF998, 0xFA17, 0xFA37, 
        0xF9F7, 0xFA1B, 0xFA3B, 0xFA1B, 0xF9FB, 0xD911, 0xC88D, 0xB84A, 0xB84A, 0xC0CB, 0xC0CB, 0xC8CB, 0xC8CC, 0xC0CD, 0xC8ED, 0xD12E, 0xD96F, 0xD8D0, 0xC86D, 0xB84B, 0xB04A, 0xC0AB, 0xA929, 0xA20A, 0xB30F, 0xAAED, 0x9A6C, 0x8168, 0x6062, 0x6127, 
        0x58A5, 0x3822, 0x0821, 0x3106, 0x3925, 0x3184, 0x2A03, 0x4902, 0x51E3, 0x49E3, 0x3924, 0x41A3, 0x51C4, 0x4983, 0x3141, 0x41E2, 0x3962, 0x3942, 0x4183, 0x5983, 0x6102, 0x58A1, 0x5841, 0x5023, 0x5042, 0x5062, 0x5062, 0x6043, 0x7166, 0x8208, 
        0x81C7, 0x68C4, 0xA2EC, 0xCC93, 0xD556, 0xDE5B, 0xE69A, 0xF67A, 0xFE19, 0xFCF8, 0xED18, 0xED59, 0xED18, 0x8A4A, 0x61C7, 0x5A07, 0x6287, 0x69A5, 0x5103, 0x40E2, 0x4902, 0x58C4, 0x4944, 0x41C4, 0x4A23, 0x41C4, 0x41E3, 0x39A2, 0x3182, 0x8C2A, 
        0x9428, 0x7BA5, 0x6303, 0x7365, 0x7B85, 0x73A5, 0x63C4, 0x6364, 0x5322, 0x4B02, 0x5302, 0x52E6, 0x6B06, 0x6AC6, 0x6225, 0x7AA6, 0x7AE7, 0x72A6, 0x6A04,
  0xAB9B, 0xAB7B, 0xAB7B, 0xAB7C, 0xAB9B, 0xAB7C, 0xAB7C, 0xB39C, 0xAB7C, 0xB39C, 0xB39D, 0xB3BD, 0xB3BD, 0xB3BD, 0xB39D, 0xB37E, 0xBBBE, 0xBBBD, 0xB3BD, 0xABDF, 0xBC3E, 0xBC9B, 0xC4D9, 0xD516, 0xD511, 0xD511, 0xD530, 0xD52E, 0xC54F, 0xCD2C, 0xD52A, 
        0xD52C, 0xBCCA, 0xB469, 0xAC28, 0x9C07, 0x8B46, 0x7B06, 0x7B06, 0x7B26, 0x62E8, 0x6AC9, 0x6AAB, 0x6AAD, 0x6B2A, 0x6B4B, 0x736C, 0x734C, 0x736D, 0x738C, 0x7B8D, 0x7B6E, 0x738D, 0x736D, 0x736D, 0x736E, 0x730B, 0x732C, 0x7B8E, 0x93EF, 0x9BCC, 
        0xAC2D, 0xB44D, 0xB44C, 0xB44D, 0xB44D, 0xB44E, 0xB42E, 0xA40F, 0x9BED, 0x93CC, 0x7B4A, 0x5A28, 0x49C8, 0x5209, 0x6B0B, 0x9453, 0x8BB4, 0x7B54, 0x7335, 0x9335, 0x9355, 0x8B96, 0x93D6, 0x93D6, 0x9BD6, 0x9BB7, 0x9BB8, 0x9C36, 0xA497, 0xAC99, 
        0xAC9A, 0xB519, 0xB4F9, 0xB4F9, 0xB51A, 0xCD1A, 0xD55B, 0xD57B, 0xDD9C, 0xDD5A, 0xD57B, 0xD59B, 0xDDBB, 0xD57B, 0xE5BB, 0xE5BB, 0xDDBB, 0xDDBC, 0xD59B, 0xCD7B, 0xC55B, 0xD59D, 0xDDBE, 0xDDDF, 0xE61F, 0xEE7F, 0xE65F, 0xE65F, 0xEE9F, 0xE5BE, 
        0xE57C, 0xDD5B, 0xCCFB, 0xAC75, 0xB454, 0xAC34, 0x9BF3, 0xA3B1, 0x9BB2, 0x9BB2, 0xABD2, 0xBB52, 0xBB53, 0xC335, 0xD2F7, 0xF2D9, 0xFAFC, 0xFAFE, 0xFABE, 0xFABC, 0xFA9D, 0xFA7D, 0xFA5C, 0xF999, 0xF9B8, 0xF9F8, 0xFA39, 0xFA7B, 0xFA7C, 0xFA9D, 
        0xFA9E, 0xFA3D, 0xFA5C, 0xFA5B, 0xFA5A, 0xFA5A, 0xF9D7, 0xF995, 0xF994, 0xF9D5, 0xF9B5, 0xF9B5, 0xF9D6, 0xF9D6, 0xF196, 0xF134, 0xE8D2, 0xE151, 0xE111, 0xE8F2, 0xE912, 0xE0F2, 0xE913, 0xE8F2, 0xE8F1, 0xE953, 0xF174, 0xF9D6, 0xFA16, 0xE912, 
        0xD8AF, 0xD88F, 0xD8D0, 0xE933, 0xF155, 0xF954, 0xF954, 0xF9B7, 0xF9B7, 0xF9B7, 0xF9B7, 0xF9B7, 0xF9F7, 0xFA37, 0xFA38, 0xFA38, 0xFA38, 0xFA38, 0xFA58, 0xFA59, 0xF9F8, 0xF9D8, 0xF9F9, 0xF156, 0xF175, 0xF975, 0xF995, 0xF177, 0xF9B6, 0xF9B6, 
        0xF9B7, 0xF9D8, 0xF9F8, 0xFA1A, 0xFA1B, 0xF9F6, 0xE932, 0xD08E, 0xB04A, 0xB089, 0xC0AC, 0xC8AD, 0xD0AD, 0xC88D, 0xD0CE, 0xD90F, 0xE150, 0xD90F, 0xD8CE, 0xC88D, 0xB04C, 0xB90C, 0x9867, 0x7803, 0x5000, 0x2800, 0x4822, 0x70E5, 0x9209, 0x58E5, 
        0x4063, 0x2042, 0x1063, 0x50A4, 0x50C3, 0x4963, 0x4A04, 0x6164, 0x59C4, 0x49A3, 0x3121, 0x49A4, 0x4183, 0x3141, 0x2121, 0x6A66, 0x51E3, 0x4161, 0x4182, 0x5225, 0x59A3, 0x5902, 0x58A2, 0x6022, 0x6042, 0x6043, 0x5863, 0x6082, 0x68C4, 0x7106, 
        0x7106, 0x4821, 0x5803, 0x6844, 0x68E4, 0x9A49, 0xABB0, 0xB4D4, 0xCD95, 0xDD75, 0xEE18, 0xF659, 0xEDB9, 0xDC31, 0xC3B0, 0xA38E, 0x830A, 0x5983, 0x58A2, 0x6042, 0x6842, 0x48E3, 0x5105, 0x5965, 0x61C5, 0x5223, 0x51E2, 0x51A3, 0x59E3, 0x8BE8, 
        0x83E7, 0x73C5, 0x73E4, 0x7BE7, 0x7B86, 0x7B85, 0x73A5, 0x6B26, 0x6B45, 0x6B25, 0x62C4, 0x62C6, 0x6B05, 0x7326, 0x7B08, 0x8B67, 0x8B8A, 0x938B, 0x932A,
  0xAB7C, 0xAB7B, 0xAB7B, 0xAB7B, 0xAB9B, 0xAB7B, 0xAB7C, 0xAB7C, 0xB37D, 0xAB9C, 0xAB9C, 0xAB9D, 0xBBBC, 0xB3BD, 0xB3BC, 0xABDB, 0xB3DD, 0xB3BC, 0xB3DB, 0xB43B, 0xBC55, 0xC4B5, 0xC4D5, 0xCD13, 0xCD51, 0xC52D, 0xC52D, 0xBD4E, 0xBD2F, 0xCD0C, 0xDD0B, 
        0xDD4B, 0xBD29, 0xB4A5, 0xAC63, 0xA443, 0x9362, 0x8B24, 0x9325, 0x9B25, 0x6B04, 0x6AE5, 0x72C6, 0x6AA8, 0x62C9, 0x6B0A, 0x6B2B, 0x6B4C, 0x738D, 0x738D, 0x6B8C, 0x738B, 0x836D, 0x7B4C, 0x734B, 0x6B4C, 0x730B, 0x838D, 0x9430, 0xA4D2, 0xAD12, 
        0xB4D1, 0xBC90, 0xB44D, 0xB42C, 0xBC2D, 0xB40D, 0x9BAC, 0x93CF, 0x8BAF, 0x836D, 0x7B0A, 0x624B, 0x5A49, 0x730B, 0x9C51, 0x8B74, 0x7333, 0x6B34, 0x7B36, 0x8B96, 0x93D6, 0x8BB5, 0x8374, 0x8BB6, 0x9BB7, 0x9BF8, 0x9C37, 0xAC9B, 0xB4DA, 0xC4DA, 
        0xC4DB, 0xB57A, 0xC55B, 0xCD5B, 0xD57B, 0xDD9B, 0xDD9B, 0xDD9B, 0xD57B, 0xDD9C, 0xD59B, 0xDD9B, 0xE5BB, 0xDD9B, 0xDD9B, 0xDDBB, 0xDD9C, 0xDD7C, 0xCD5B, 0xCD5B, 0xE55C, 0xCD3C, 0xD59E, 0xDDDF, 0xEE1F, 0xE63F, 0xEE3F, 0xEE5F, 0xE65E, 0xE5FF, 
        0xDDBE, 0xCD9D, 0xB55C, 0xC433, 0xB434, 0xAC55, 0xAC75, 0xAC13, 0xA392, 0xA372, 0xA390, 0x9BD1, 0xAB93, 0xB374, 0xAB34, 0xF1F7, 0xFA39, 0xFA5A, 0xFA5B, 0xFABE, 0xFA7C, 0xFA3A, 0xF21B, 0xF9DB, 0xF9F9, 0xFA18, 0xFA37, 0xFA7A, 0xFA9C, 0xFA9D, 
        0xFA5C, 0xF9FD, 0xFA3D, 0xFA5D, 0xFA7D, 0xFA9A, 0xFA5A, 0xFA3A, 0xFA3A, 0xF195, 0xF176, 0xF9B9, 0xF9FA, 0xF975, 0xF955, 0xF154, 0xE912, 0xD8D1, 0xE0F1, 0xE911, 0xE911, 0xE911, 0xE112, 0xE0F1, 0xE0F0, 0xF152, 0xF9D4, 0xFA16, 0xF9F5, 0xE912, 
        0xD8B0, 0xD8AF, 0xE911, 0xF913, 0xF913, 0xF155, 0xF1B7, 0xF9D6, 0xF9D7, 0xF9D7, 0xF9B6, 0xF9D7, 0xFA17, 0xFA17, 0xFA17, 0xFA17, 0xFA58, 0xFA18, 0xF1B6, 0xF996, 0xF954, 0xF933, 0xF153, 0xF154, 0xF175, 0xF195, 0xF1B5, 0xF237, 0xF9F6, 0xF9B5, 
        0xF9B5, 0xF196, 0xF9F9, 0xF9FA, 0xF9B9, 0xF194, 0xE132, 0xD8CF, 0xC84D, 0xB0AB, 0xC0CA, 0xC0CB, 0xC0AB, 0xD8AC, 0xD0AD, 0xD0EE, 0xE130, 0xE92F, 0xD0EE, 0xC0AD, 0xB08B, 0xB06A, 0xB0EC, 0x98C9, 0x6025, 0x6826, 0x78A7, 0x78E7, 0x6885, 0x4021, 
        0x3063, 0x28C5, 0x2927, 0x2841, 0x40C2, 0x4984, 0x4A65, 0x7285, 0x69E3, 0x4962, 0x2941, 0x5182, 0x3901, 0x3942, 0x5A64, 0x62C5, 0x5204, 0x49A3, 0x49C3, 0x51C2, 0x6183, 0x7104, 0x7863, 0x5883, 0x6042, 0x6042, 0x5862, 0x6883, 0x6864, 0x6884, 
        0x60C4, 0x58E4, 0x5063, 0x58A4, 0x6986, 0x7B28, 0xAC6F, 0xB492, 0xB3D2, 0xDC13, 0xF4D5, 0xFD36, 0xF4F5, 0xCC72, 0xB3CF, 0xA34E, 0xA2AC, 0x5904, 0x50E3, 0x5924, 0x6165, 0x58A4, 0x5965, 0x5A04, 0x5263, 0x6244, 0x49C2, 0x5201, 0x6B02, 0x6384, 
        0x6B84, 0x73A5, 0x73C7, 0x6B85, 0x7B65, 0x83A6, 0x83E6, 0x7385, 0x7B85, 0x83A5, 0x7BC5, 0x7C24, 0x7BE6, 0x7BA8, 0x83C7, 0x7C28, 0x83C7, 0x83A7, 0x7BC7,
  0xAB5B, 0xAB5B, 0xAB5B, 0xAB7C, 0xAB7C, 0xAB7B, 0xB37C, 0xB37C, 0xB37D, 0xB37D, 0xB37D, 0xB39C, 0xB37D, 0xB39D, 0xB39D, 0xB35B, 0xBBBC, 0xB3BD, 0xBBDD, 0xC41E, 0xBC1D, 0xBC7A, 0xBC98, 0xB475, 0xB4EC, 0xACAA, 0xACAC, 0xBCCE, 0xBCEE, 0xC4CD, 0xD4EC, 
        0xDD2C, 0xC549, 0xBCE6, 0xB484, 0xA463, 0xA487, 0xAC48, 0xAC0A, 0xAC0C, 0x93A9, 0x732A, 0x62EC, 0x62AC, 0x4A84, 0x52A7, 0x52A9, 0x52C9, 0x6B2A, 0x6B6B, 0x6B6C, 0x734D, 0x6B6B, 0x6B4B, 0x734C, 0x8BAE, 0xB512, 0xB553, 0xB574, 0xBDB6, 0xCDB5, 
        0xC554, 0xC512, 0xBCD0, 0xB44C, 0xA38A, 0xA34A, 0x9B8C, 0x834B, 0x732B, 0x62CB, 0x5248, 0x41E6, 0x8B90, 0x9BF5, 0x6AD2, 0x8376, 0x8335, 0x8335, 0x8B96, 0x8376, 0x8355, 0x8B75, 0x8B95, 0xA3DA, 0xA3F8, 0xA457, 0xACB9, 0xB4DA, 0xACBA, 0xACB9, 
        0xB4F9, 0xC51A, 0xC51B, 0xCD5B, 0xCDBC, 0xD57C, 0xD5BC, 0xDDDC, 0xDDDB, 0xDDBB, 0xDDBB, 0xD59B, 0xD57A, 0xDDDB, 0xDDDB, 0xDD9B, 0xCD5B, 0xCD3A, 0xC51A, 0xB4DA, 0xB4D9, 0xD57B, 0xD57C, 0xD59E, 0xD5DF, 0xE61F, 0xE63F, 0xE65F, 0xEE3F, 0xDDBF, 
        0xDDDE, 0xD5BD, 0xD55B, 0xBCF9, 0xC496, 0xBC14, 0xAB92, 0x9B92, 0xA373, 0xAB94, 0xABD4, 0xB392, 0xA311, 0x9AF0, 0x92F0, 0xAAF3, 0xAB13, 0xC336, 0xEB3B, 0xFA99, 0xF23C, 0xF21C, 0xF21A, 0xF239, 0xF1B8, 0xF978, 0xF9B8, 0xFA9B, 0xFA7C, 0xFA5C, 
        0xFA1B, 0xFA5B, 0xFA1D, 0xFA1C, 0xFA7A, 0xF9FB, 0xF9FC, 0xF1BB, 0xF158, 0xF9F8, 0xFA18, 0xF217, 0xF1D8, 0xF197, 0xE914, 0xE0D2, 0xD8F1, 0xE932, 0xE0F2, 0xE0D1, 0xE0F1, 0xE0D1, 0xE0D1, 0xE0F2, 0xF154, 0xF995, 0xF1D7, 0xF197, 0xF0F4, 0xE0CF, 
        0xD8AF, 0xD88F, 0xD8AF, 0xF174, 0xF9B5, 0xF9B6, 0xF996, 0xFA17, 0xF9B6, 0xF975, 0xF995, 0xF197, 0xF1B7, 0xF1B6, 0xF996, 0xF155, 0xF134, 0xF134, 0xF915, 0xF155, 0xF195, 0xF1B6, 0xF996, 0xFA17, 0xFA17, 0xFA38, 0xFA39, 0xFA17, 0xF9F8, 0xF1D7, 
        0xF1B5, 0xFA16, 0xF196, 0xF157, 0xF1B7, 0xF114, 0xE0D1, 0xD0AC, 0xC088, 0xB869, 0xB8AC, 0xB88B, 0xB829, 0xD0AC, 0xD0CC, 0xD8EC, 0xE14F, 0xD0CE, 0xC0AC, 0xB8AB, 0xB8CD, 0xB82B, 0xB8EA, 0x98E9, 0x6047, 0x5004, 0x5043, 0x58C4, 0x7145, 0x5044, 
        0x3824, 0x3064, 0x28C5, 0x5043, 0x5944, 0x5225, 0x4AA4, 0x8264, 0x4162, 0x2942, 0x51E4, 0x3922, 0x4942, 0x59E5, 0x72C7, 0x4201, 0x39E2, 0x41C3, 0x4983, 0x51C5, 0x59E5, 0x5983, 0x4881, 0x6084, 0x6043, 0x5842, 0x5862, 0x60A3, 0x78E4, 0x68A4, 
        0x5023, 0x7064, 0x68A3, 0x6904, 0x8187, 0xA22B, 0xBBAF, 0xD4F3, 0xF5D6, 0xEE78, 0xD5D6, 0xD596, 0xDD37, 0xA24B, 0x8165, 0x7144, 0x7966, 0x7886, 0x78E7, 0x7968, 0x7967, 0x50C3, 0x6985, 0x6A27, 0x52A5, 0x4242, 0x5242, 0x6AA5, 0x8369, 0x83C7, 
        0x7BE7, 0x73C6, 0x7384, 0x7BA6, 0x73C7, 0x6BE9, 0x6BE9, 0x8407, 0x73A6, 0x6B85, 0x6365, 0x6305, 0x6AE4, 0x6AC5, 0x72E6, 0x6B24, 0x6BA6, 0x73A7, 0x7345,
  0xAB9C, 0xAB7C, 0xAB7C, 0xAB9D, 0xAB7C, 0xAB7D, 0xAB7D, 0xB39D, 0xAB7D, 0xB39D, 0xB39D, 0xB39D, 0xB3BD, 0xB3BD, 0xB3BE, 0xB3BF, 0xB39D, 0xB3BD, 0xBBFD, 0xBC3A, 0xB499, 0xBCB6, 0xBCD3, 0xB4EF, 0xA4ED, 0x9C8B, 0x9C4A, 0x9C2C, 0xA44D, 0xB4AC, 0xBCEB, 
        0xBD0B, 0xC4E8, 0xC4C7, 0xC4A6, 0xC466, 0xB444, 0xAC63, 0xA423, 0xA3A4, 0x9C05, 0x9B65, 0x9305, 0x82C6, 0x6281, 0x5A43, 0x6245, 0x6A66, 0x62E9, 0x6B0A, 0x6B2C, 0x6B4D, 0x834D, 0x8B8D, 0x8BEE, 0x9450, 0xBD56, 0xBD96, 0xC5B6, 0xCDD7, 0xD616, 
        0xD5B5, 0xCD52, 0xC50F, 0xBC0C, 0xAB88, 0xAB87, 0xB409, 0xAB4A, 0x9309, 0x72A9, 0x6A69, 0x9B4B, 0x93F1, 0x8BD4, 0x8374, 0x7B54, 0x8375, 0x8B76, 0x8B75, 0x93B6, 0x8BB7, 0x8BB6, 0x8BD5, 0xB49C, 0xB4DB, 0xB4DA, 0xB4DA, 0xB4FA, 0xBD1B, 0xBD3B, 
        0xBD5C, 0xDD9C, 0xD59C, 0xCD7C, 0xD59B, 0xDDDD, 0xDDBC, 0xDDBC, 0xDDDC, 0xE5DC, 0xDDBB, 0xDDBB, 0xDD9B, 0xE5BB, 0xDD9B, 0xD57B, 0xD55A, 0xCD3B, 0xBCD9, 0xAC96, 0xA474, 0xC4FB, 0xD57E, 0xD5BF, 0xD5BF, 0xDE1E, 0xE65F, 0xEE7F, 0xF69F, 0xDE1F, 
        0xEDFE, 0xF5BE, 0xE55E, 0xAD5A, 0xACD8, 0xB477, 0xB457, 0xA3B2, 0xA3D2, 0xA3B2, 0x9B52, 0xB356, 0xA352, 0xA370, 0xA391, 0x9331, 0x9AB1, 0xA250, 0xA1F0, 0x990E, 0xD214, 0xFB1B, 0xFB9E, 0xFABD, 0xF9DB, 0xF99A, 0xFA1B, 0xFA1C, 0xFA7D, 0xFA9D, 
        0xFA3C, 0xFA1B, 0xFA7C, 0xFA9D, 0xFA7C, 0xFA9D, 0xFA3B, 0xF9FB, 0xF9FC, 0xFA57, 0xFA36, 0xF9F7, 0xF9D8, 0xF156, 0xF114, 0xF0F3, 0xE8F2, 0xE8CF, 0xE8F1, 0xE912, 0xF0F1, 0xE911, 0xE8D1, 0xE0D1, 0xE0F1, 0xF177, 0xF9B9, 0xF9D8, 0xF9B6, 0xF0F1, 
        0xE0AE, 0xD8AF, 0xE8F3, 0xF974, 0xF995, 0xF9D6, 0xFA17, 0xF995, 0xF174, 0xF174, 0xF9B4, 0xFA17, 0xF9B5, 0xF174, 0xF154, 0xF976, 0xF976, 0xF996, 0xF9F7, 0xF9D7, 0xFA18, 0xFA38, 0xFA38, 0xFA5A, 0xFA7A, 0xFA9A, 0xFA9A, 0xFA39, 0xFA39, 0xFA7A, 
        0xFABA, 0xF9F8, 0xF935, 0xF114, 0xF975, 0xF9D8, 0xF9B8, 0xE933, 0xD08A, 0xB867, 0xB868, 0xB86A, 0xB86B, 0xC8AB, 0xD0CC, 0xD0ED, 0xD8EE, 0xE932, 0xE130, 0xD0CD, 0xC06B, 0xB88D, 0xB08C, 0xA08A, 0x8888, 0x5842, 0x6043, 0x7044, 0x7824, 0x6086, 
        0x4864, 0x3022, 0x1841, 0x59C5, 0x6A26, 0x7287, 0x8306, 0x6224, 0x4962, 0x3942, 0x29A3, 0x30C1, 0x4923, 0x6A25, 0x7B26, 0x3121, 0x28E1, 0x4944, 0x69C7, 0x7205, 0x7285, 0x7265, 0x69A3, 0x6062, 0x6042, 0x6842, 0x6822, 0x7083, 0x6883, 0x6884, 
        0x7085, 0x78C5, 0x8085, 0x8865, 0x90A3, 0x8987, 0xA1EA, 0xB2AC, 0x9BCD, 0x9431, 0xC515, 0xED55, 0xF513, 0xD413, 0xCB91, 0xD391, 0xDBB1, 0x70C5, 0x8907, 0x9928, 0x90E6, 0x59A5, 0x6A26, 0x6A85, 0x5283, 0x51C1, 0x59C2, 0x61C5, 0x71E7, 0x7B06, 
        0x8406, 0x8465, 0x83E3, 0x83CB, 0x83C9, 0x73C7, 0x63A6, 0x7385, 0x6B63, 0x5B23, 0x4AC2, 0x4AE2, 0x52E3, 0x5AE4, 0x6304, 0x5AA2, 0x6323, 0x6324, 0x5AE3,
  0xAB9C, 0xAB9C, 0xAB9B, 0xAB9C, 0xB37D, 0xAB7D, 0xAB9D, 0xB39D, 0xAB7E, 0xB39E, 0xBBBD, 0xB3BD, 0xB3BE, 0xB3BE, 0xB3BE, 0xABDE, 0xB3BE, 0xB3DE, 0xB3FE, 0xB43E, 0xC494, 0xCCD5, 0xC4B6, 0xBC75, 0xACAE, 0x944C, 0x8C2A, 0x8C48, 0x8BEA, 0x9C69, 0xA4C9, 
        0xACCA, 0xC52C, 0xC4EA, 0xC4A7, 0xBC44, 0xB3E5, 0xAC27, 0xA446, 0xA403, 0xB448, 0xA3A7, 0x9326, 0x7AC6, 0x8308, 0x6245, 0x51E4, 0x5205, 0x4A4A, 0x62CD, 0x732C, 0x7B28, 0x7BAC, 0x9431, 0xA492, 0xA4D2, 0xC595, 0xC5B5, 0xCDF6, 0xDE39, 0xE5F4, 
        0xDDB1, 0xD570, 0xC4CE, 0xB38C, 0xA32B, 0xAB6B, 0xCC6D, 0xF6DB, 0xD513, 0xA32C, 0x7A0B, 0xABB2, 0x8392, 0x7373, 0x8395, 0x8354, 0x8394, 0x8BB4, 0x93B5, 0x8BB7, 0x9C19, 0xA43B, 0xAC3B, 0xA4B6, 0xB4D9, 0xBCFB, 0xBD5B, 0xBCFB, 0xC53B, 0xCD5C, 
        0xCD7C, 0xD5BC, 0xDDBC, 0xDD9C, 0xD57C, 0xDDDD, 0xDDBD, 0xDD9D, 0xDD9C, 0xDD9C, 0xDDBC, 0xE5DC, 0xE5DC, 0xDDBB, 0xD57A, 0xC53A, 0xBD1A, 0xC4FB, 0xBCB9, 0xB499, 0xAC7B, 0xB4DA, 0xD53C, 0xE57D, 0xE5BE, 0xEE1F, 0xEDFF, 0xEE1F, 0xEE7F, 0xE65F, 
        0xDE3F, 0xDDFE, 0xDD9C, 0xDD9A, 0xCD39, 0xBCD7, 0xB475, 0xAC35, 0xABF4, 0x9BB2, 0x9371, 0xA394, 0xA392, 0x9B50, 0x930F, 0x92F2, 0x92D2, 0x8A90, 0x826D, 0xCB93, 0xD275, 0xD195, 0xD975, 0xF938, 0xFADC, 0xFB3D, 0xF9FB, 0xF9FC, 0xFA7D, 0xFA9D, 
        0xFA7E, 0xF9BA, 0xFA7C, 0xFABD, 0xFA3D, 0xF9DB, 0xFA7D, 0xFADE, 0xFABD, 0xFA1B, 0xF218, 0xFA17, 0xF9D6, 0xF934, 0xF0F3, 0xE8F2, 0xE8F2, 0xE912, 0xF112, 0xF0F2, 0xE8F1, 0xE0B1, 0xE8D1, 0xE8F0, 0xE111, 0xF953, 0xF995, 0xF9D8, 0xF9F9, 0xF0F5, 
        0xE090, 0xE08F, 0xE930, 0xF994, 0xF9F6, 0xF9F7, 0xF9B7, 0xF1B5, 0xF9D6, 0xFA17, 0xF9F7, 0xF153, 0xF175, 0xF1B6, 0xF1B5, 0xF9F7, 0xFA17, 0xFA17, 0xFA17, 0xFA58, 0xFA37, 0xFA16, 0xFA16, 0xFABD, 0xFA9C, 0xFA7B, 0xFA7C, 0xFA7C, 0xFA7D, 0xFA7C, 
        0xFA38, 0xE8AF, 0xE8D0, 0xF196, 0xFA9D, 0xFA38, 0xE911, 0xE08F, 0xD8B1, 0xC02C, 0xB86A, 0xB889, 0xC06A, 0xB86B, 0xC88D, 0xD08D, 0xD08E, 0xF172, 0xE930, 0xD8CE, 0xB84D, 0xA8CB, 0xB0AC, 0xB06B, 0x9828, 0x8085, 0x7063, 0x7844, 0x8845, 0x7047, 
        0x5865, 0x3863, 0x1862, 0x7A6A, 0x7AA6, 0x7AC5, 0x8327, 0x51E4, 0x2962, 0x3141, 0x5142, 0x10E1, 0x4123, 0x7A87, 0x8C0B, 0x18A2, 0x4081, 0x60C2, 0x60E4, 0x728A, 0x8ACB, 0x92EB, 0x7ACA, 0x4862, 0x58A3, 0x70A4, 0x7022, 0x6063, 0x7082, 0x7082, 
        0x6882, 0x7864, 0x7085, 0x78C4, 0x7903, 0x81A4, 0xB205, 0xC268, 0xB2AC, 0x7A6A, 0x8A4B, 0xB34F, 0xE4F5, 0xDC11, 0xE4F5, 0xD432, 0x99E9, 0x5841, 0x7083, 0x90E5, 0x9126, 0x81A6, 0x6163, 0x59E3, 0x72E6, 0x61C2, 0x4921, 0x50E2, 0x60A4, 0x4861, 
        0x8247, 0x9BA9, 0x7407, 0x5BE2, 0x63A2, 0x7BA6, 0x9BAB, 0x7348, 0x7B68, 0x8347, 0x6AE6, 0x4243, 0x5263, 0x62A4, 0x5AC4, 0x5A82, 0x5283, 0x5AA4, 0x5AA4,
  0xAB5C, 0xAB5B, 0xAB5B, 0xAB5C, 0xAB7B, 0xAB7C, 0xB37C, 0xB39C, 0xBB9D, 0xB39C, 0xAB9D, 0xB39D, 0xB37D, 0xB39D, 0xB39D, 0xB3BD, 0xB3BE, 0xB3BE, 0xB3DC, 0xB439, 0xAC15, 0xA410, 0x9C0C, 0x93E8, 0x7BA8, 0x7B68, 0x7B47, 0x8367, 0x942A, 0xB4AB, 0xBCEB, 
        0xB4EB, 0xBCA9, 0xBCA9, 0xC4A9, 0xCCC7, 0xCD45, 0xCD66, 0xCD47, 0xC4E6, 0xBCC5, 0xB4A5, 0xAC64, 0xA403, 0x8B24, 0x7A84, 0x6A22, 0x59E1, 0x5A22, 0x6264, 0x62A6, 0x62E9, 0x6BAE, 0x8C70, 0xA4D1, 0xA4F1, 0xD576, 0xCDD6, 0xCDF5, 0xCDF5, 0xD5B5, 
        0xC551, 0xB48C, 0x9BC8, 0xB3C9, 0xDCED, 0xFDEF, 0xFE90, 0xF6B2, 0xCD0F, 0x9BAD, 0x82AC, 0x8313, 0x7B36, 0x7B55, 0x7B93, 0x7334, 0x8B55, 0x8B56, 0x8355, 0x93F7, 0x9C38, 0xA458, 0xAC78, 0xA49A, 0xB4FA, 0xC51A, 0xBD1A, 0xCD7C, 0xCD7C, 0xCD9C, 
        0xD59D, 0xD57B, 0xCD9C, 0xD5BD, 0xDDBD, 0xCD9B, 0xD5BC, 0xDDBC, 0xDD9B, 0xDDFB, 0xDDDB, 0xDDBB, 0xDDBA, 0xDD9B, 0xCD39, 0xBCF9, 0xBCFA, 0xB4B7, 0xAC76, 0xA416, 0xABF6, 0xC53A, 0xC57B, 0xC57C, 0xCDBE, 0xDDFF, 0xE63F, 0xE63F, 0xDE3F, 0xF67F, 
        0xE61F, 0xD5BF, 0xD57E, 0xC55B, 0xC4F9, 0xBC97, 0xB455, 0xBBD6, 0xB354, 0xAB72, 0xABF2, 0xAB72, 0xAB71, 0xAB50, 0x9B31, 0x9AF0, 0x92B0, 0xA332, 0xBBD4, 0x908B, 0x980B, 0xB84D, 0xD112, 0xEC3D, 0xF2D9, 0xFA59, 0xFB1E, 0xFA7B, 0xFA7C, 0xFA7C, 
        0xFA3A, 0xFA1B, 0xFA3B, 0xFA5C, 0xFA1C, 0xFA7B, 0xFA7C, 0xFA3C, 0xFA3C, 0xFA5C, 0xFA5B, 0xF1F8, 0xE955, 0xE954, 0xE954, 0xE113, 0xE0F2, 0xF132, 0xE953, 0xE914, 0xE8D2, 0xE8F1, 0xE0F1, 0xE0D0, 0xE8F0, 0xF1D7, 0xFA39, 0xFA19, 0xF198, 0xD06F, 
        0xD88F, 0xE8F1, 0xF954, 0xF1B5, 0xF1D6, 0xF1B6, 0xE996, 0xF996, 0xF996, 0xF997, 0xF9D8, 0xF9F7, 0xFA17, 0xFA37, 0xFA38, 0xFA16, 0xFA38, 0xFA39, 0xFA59, 0xFA19, 0xFA1A, 0xFA3B, 0xFA9B, 0xFA79, 0xFA5A, 0xFA5B, 0xFA7B, 0xFA5B, 0xF1F9, 0xF134, 
        0xF070, 0xF238, 0xFB9C, 0xFB9D, 0xF278, 0xC84C, 0xC86E, 0xD08E, 0xC86C, 0xC089, 0xB849, 0xB869, 0xB8A9, 0xB047, 0xC089, 0xC8CA, 0xD8EC, 0xE14E, 0xD0CE, 0xC88D, 0xC08C, 0xC06E, 0xB06B, 0xA889, 0xA888, 0x6023, 0x5863, 0x6083, 0x6864, 0x98C9, 
        0x6844, 0x4801, 0x4062, 0x8368, 0x7329, 0x6AC6, 0x6A63, 0x28E1, 0x30E2, 0x3122, 0x2922, 0x40A1, 0x72A7, 0x6B07, 0x31A2, 0x48C3, 0x5102, 0x5983, 0x6205, 0x6AE6, 0x836A, 0x82A8, 0x6902, 0x6864, 0x6062, 0x5062, 0x5024, 0x7021, 0x7062, 0x7084, 
        0x7065, 0x6883, 0x6842, 0x7863, 0x9907, 0x91C9, 0xA9C8, 0xBB0B, 0xCD94, 0xF73C, 0xEDD6, 0xE471, 0xD38D, 0xAAAC, 0x5905, 0x3821, 0x5822, 0x8126, 0x70C5, 0x68A4, 0x8105, 0xA22A, 0xA2EB, 0x8B0A, 0x6A85, 0x59A1, 0x4160, 0x30E0, 0x3861, 0x82CA, 
        0x8389, 0x73A5, 0x6382, 0x93EC, 0x93EB, 0x7BA7, 0x5324, 0x83E6, 0x6BA5, 0x6304, 0x62A4, 0x5AA4, 0x4A83, 0x4A61, 0x4A40, 0x4242, 0x5282, 0x5AA3, 0x62A4,
  0xAB9D, 0xAB7C, 0xAB7C, 0xB39C, 0xB37D, 0xB39D, 0xB39D, 0xB39D, 0xB3BD, 0xB39D, 0xB3BE, 0xB3DD, 0xB3DD, 0xB3DD, 0xB3BD, 0xB3BE, 0xBBDD, 0xB3BE, 0xB3BD, 0xBBDC, 0xB435, 0xAC32, 0xA3EF, 0x9BAB, 0x9C2A, 0x8BE9, 0x83C8, 0x83A8, 0x8BE9, 0x944B, 0xA46B, 
        0xB48B, 0xB50C, 0xC4ED, 0xC4CC, 0xC4CA, 0xC4A9, 0xCCE8, 0xCD06, 0xCD04, 0xB487, 0xBC66, 0xBC26, 0xB3E6, 0x9345, 0x8AC4, 0x7AA4, 0x72C5, 0x6265, 0x62E9, 0x6B4A, 0x7B48, 0x8BCB, 0x9450, 0x9CB2, 0xAD13, 0xC594, 0xC5B3, 0xC593, 0xC575, 0xCD92, 
        0xBCEE, 0xB44A, 0xAC07, 0xC429, 0xDD90, 0xEE77, 0xF69A, 0xCCB3, 0x92EF, 0x7A4E, 0x82B2, 0xA3D9, 0x8BB6, 0x7B94, 0x8374, 0x93B5, 0x8B75, 0x8354, 0x8354, 0x9C38, 0x9C59, 0xA458, 0xA458, 0xB4D8, 0xB4FA, 0xBD3B, 0xC57C, 0xD5BD, 0xDDDD, 0xDDDE, 
        0xDDDE, 0xDDFD, 0xDDDD, 0xDDDD, 0xDDBD, 0xD5BD, 0xDDBD, 0xDDBC, 0xDD9C, 0xE5BC, 0xDDBC, 0xE5BC, 0xEDBC, 0xCD39, 0xBD19, 0xBCF9, 0xC4D8, 0xAC57, 0xB477, 0xB498, 0xB479, 0xC51B, 0xCD3B, 0xD53B, 0xD57C, 0xD5BE, 0xE5FF, 0xE63F, 0xE67F, 0xEE7F, 
        0xEE7F, 0xEE5F, 0xDDDF, 0xDD9E, 0xD57C, 0xC51A, 0xB498, 0xB3F6, 0xB3F4, 0xABF4, 0xABF4, 0xB3B3, 0xAB51, 0xA351, 0xA370, 0x9290, 0xAB10, 0xB2CF, 0xA18D, 0xD0AE, 0xD8D1, 0xD912, 0xC8F0, 0xB02C, 0xD0D0, 0xE134, 0xE196, 0xFBFE, 0xFBBF, 0xFADD, 
        0xF9FA, 0xFA3C, 0xFABD, 0xFADC, 0xFA7B, 0xFA1C, 0xFA5D, 0xFA7D, 0xFA5C, 0xFA7E, 0xFA1C, 0xF1F9, 0xF9B6, 0xF176, 0xF176, 0xF975, 0xF933, 0xE953, 0xF133, 0xF113, 0xE8F2, 0xE8F0, 0xE8D1, 0xE0B0, 0xE08F, 0xF0F1, 0xF9D5, 0xFA58, 0xFA39, 0xE0B6, 
        0xE0B2, 0xE932, 0xF9F4, 0xF9D6, 0xF196, 0xF196, 0xF9B7, 0xF9B6, 0xF9D7, 0xF9F7, 0xF9B7, 0xF997, 0xF9F8, 0xFA18, 0xF9F7, 0xF9B8, 0xF9F7, 0xFA37, 0xFA58, 0xFA18, 0xFA5B, 0xFA7B, 0xFA5A, 0xFA5B, 0xFA5A, 0xFA9B, 0xFAFD, 0xF1FA, 0xF0D3, 0xF0B2, 
        0xF9D8, 0xFBFE, 0xFADB, 0xD151, 0xA025, 0xC02D, 0xE0D2, 0xE934, 0xD912, 0xC04E, 0xB86B, 0xB86A, 0xC04A, 0xB82C, 0xC86C, 0xD08C, 0xD8AC, 0xE930, 0xE130, 0xD0EE, 0xC06D, 0xB8CD, 0xB8AB, 0xB86B, 0xB04A, 0x80C6, 0x68E4, 0x60E4, 0x70A4, 0x8886, 
        0x8847, 0x7826, 0x6085, 0x7B07, 0x7307, 0x6285, 0x5203, 0x4983, 0x3962, 0x3122, 0x28E2, 0x4102, 0x6AC6, 0x8368, 0x6AA6, 0x4922, 0x6125, 0x70E6, 0x78A6, 0x82A8, 0x8BAA, 0x83A9, 0x62A5, 0x50C1, 0x6881, 0x6862, 0x6062, 0x6863, 0x7083, 0x70A4, 
        0x78A4, 0x6883, 0x6863, 0x6882, 0x78E2, 0xA1EA, 0x9B09, 0x7A67, 0x50A6, 0xB332, 0xBB31, 0xB32E, 0xAB0D, 0x7085, 0x5822, 0x5021, 0x5863, 0x6064, 0x70C5, 0x68A4, 0x5020, 0x4021, 0x81C8, 0x926B, 0x6A09, 0x7A25, 0x8325, 0x6A83, 0x4061, 0x50E3, 
        0x82C8, 0x9BEC, 0x9C2D, 0x8346, 0x7B86, 0x7C07, 0x7C27, 0x73A7, 0x7B85, 0x6B64, 0x4B45, 0x4B41, 0x52C3, 0x5A64, 0x5A44, 0x62A5, 0x6265, 0x6225, 0x59E5,
  0xB39D, 0xAB9D, 0xAB9D, 0xB37D, 0xB3BE, 0xB39E, 0xB39D, 0xB39D, 0xB39D, 0xB39E, 0xBBDE, 0xB3FE, 0xB3DE, 0xBBBE, 0xBBBE, 0xB3DE, 0xB3BE, 0xB3FE, 0xB41D, 0xB3FC, 0xBC76, 0xB451, 0xA42C, 0x9407, 0x7BC7, 0x83A7, 0x8388, 0x8B8A, 0x8BCB, 0x9C0B, 0xA42C, 
        0xA44D, 0xBCCB, 0xC4CA, 0xC4CA, 0xBCCA, 0xDD03, 0xDD45, 0xDD67, 0xDD87, 0xCCE4, 0xC4A4, 0xBCA4, 0xBC64, 0x8B61, 0x8B21, 0x9302, 0x8AE1, 0x72E2, 0x72E2, 0x72C3, 0x6AC6, 0x73F2, 0x8C93, 0xA4D4, 0xBD15, 0xCDF4, 0xBD92, 0xB552, 0xAD72, 0xAD11, 
        0xBCEF, 0xBCAC, 0xB468, 0xBC28, 0xE650, 0xEEB1, 0xD50B, 0x7AA8, 0x8B90, 0x9BF5, 0x8B96, 0x7B74, 0x7B94, 0x8394, 0x9373, 0x8BB6, 0x8BB5, 0x93D6, 0xA3F9, 0x9416, 0x9416, 0x9C57, 0xA4B7, 0xC51C, 0xC53B, 0xBD5B, 0xBD7C, 0xDD9E, 0xDD9D, 0xD59D, 
        0xD5DE, 0xDDBC, 0xE5DD, 0xE5DE, 0xDDBD, 0xD5DD, 0xDDDC, 0xDDBD, 0xE57D, 0xE5BC, 0xE5DC, 0xDDBC, 0xD57B, 0xD53A, 0xD539, 0xC519, 0xB4B8, 0xB4D7, 0xB4B6, 0xB497, 0xBCB9, 0xBD5A, 0xC55C, 0xD55D, 0xE59E, 0xDDFF, 0xD5FF, 0xE5FF, 0xF63F, 0xEE7F, 
        0xE67F, 0xE67F, 0xF65F, 0xD61F, 0xD59E, 0xD51D, 0xBCDA, 0xBC74, 0xB3F4, 0xB3F4, 0xB414, 0xB350, 0xAB93, 0x9B52, 0x8ACE, 0xAB90, 0xAB0F, 0xA9ED, 0xB0AD, 0xD091, 0xD0D1, 0xD0F0, 0xD8EF, 0xE0EF, 0xC86D, 0xD0F0, 0xE1F6, 0x9870, 0xD136, 0xFA7B, 
        0xFB7E, 0xFA1A, 0xFA5D, 0xFA7E, 0xFA3D, 0xFA5C, 0xFA9D, 0xFADD, 0xFABE, 0xF1DA, 0xF9D8, 0xFA39, 0xFA9B, 0xF9F9, 0xF9D7, 0xF9B6, 0xF155, 0xF114, 0xF153, 0xF153, 0xE112, 0xE8B3, 0xE8F1, 0xE911, 0xF112, 0xD8F2, 0xE914, 0xF198, 0xFA3B, 0xE1D4, 
        0xF132, 0xF8D2, 0xF936, 0xFA37, 0xF218, 0xF9B8, 0xF958, 0xFA55, 0xFA37, 0xF9F8, 0xF9D7, 0xF9D7, 0xFA38, 0xFA79, 0xFA39, 0xF937, 0xF997, 0xF9B7, 0xF996, 0xFA5A, 0xFA9B, 0xFABB, 0xFA9C, 0xFA3A, 0xFABD, 0xFB1F, 0xFADD, 0xE08E, 0xF1B7, 0xFBBE, 
        0xFD1E, 0xF0D6, 0xA00A, 0x8805, 0xB028, 0xE8EE, 0xF955, 0xF976, 0xF970, 0xD8AD, 0xC04B, 0xB86B, 0xB8AB, 0xC087, 0xB8A9, 0xC0AB, 0xD08C, 0xD90E, 0xE90F, 0xD8EF, 0xB8AE, 0xB8CC, 0xB88B, 0xB86C, 0xB06C, 0x7905, 0x6144, 0x5144, 0x6105, 0x90E8, 
        0x8085, 0x78E5, 0x8A29, 0x6A65, 0x6244, 0x5A44, 0x5A03, 0x3963, 0x3902, 0x3902, 0x3903, 0x38C2, 0x93AB, 0x9BAB, 0x40A2, 0x4084, 0x6168, 0x7987, 0x7924, 0x834D, 0x8BEE, 0x83A9, 0x62A3, 0x8886, 0x8084, 0x7083, 0x6083, 0x60A2, 0x7084, 0x7865, 
        0x7865, 0x6864, 0x7084, 0x7866, 0x804A, 0xA1CD, 0x8245, 0x49A0, 0x2861, 0x81A8, 0x9AAC, 0xBB50, 0xCB10, 0x3062, 0x4843, 0x6043, 0x6022, 0x5843, 0x4822, 0x4823, 0x5046, 0x6863, 0x4842, 0x50C3, 0x8207, 0x7B29, 0x5224, 0x6A87, 0xB3CE, 0x58A4, 
        0x60C3, 0x71A3, 0x72C2, 0x5402, 0x7467, 0x8448, 0x83C5, 0x8BC9, 0x8429, 0x7BC7, 0x72E3, 0x5AA3, 0x6B25, 0x7305, 0x6A25, 0x59A3, 0x6184, 0x6164, 0x5943,
  0xB37C, 0xAB5C, 0xAB5B, 0xB39B, 0xAB9C, 0xB37C, 0xB37C, 0xB37D, 0xB39E, 0xAB9D, 0xB37D, 0xB35C, 0xB39C, 0xB3BD, 0xB3BD, 0xB3BC, 0xBBDE, 0xBBDE, 0xB3BD, 0xAB9B, 0xABD4, 0x9B91, 0x936E, 0x936B, 0x9388, 0x93C9, 0x8C29, 0x8C69, 0xA42C, 0xA46C, 0xA4AC, 
        0xAC8C, 0xAC8E, 0xB4CD, 0xC50C, 0xDD4C, 0xDDE9, 0xE5C8, 0xE587, 0xE568, 0xDD87, 0xCD47, 0xC4E6, 0xBCA5, 0xC529, 0xC4A7, 0xBC47, 0xB407, 0x9BE7, 0x9388, 0x9367, 0x9344, 0x8B05, 0x8BA8, 0x8C6A, 0x9D2B, 0xE596, 0xE5B5, 0xD5B2, 0xD572, 0xCD51, 
        0xC50F, 0xB4AD, 0xAC69, 0xA367, 0x9B8D, 0x9392, 0x8B34, 0x51B1, 0x7231, 0x82B1, 0x7AF1, 0x5A92, 0x7B13, 0x9375, 0x8B96, 0x8B53, 0x8B74, 0x93F5, 0xA476, 0x8B96, 0x93D6, 0x9C35, 0xA456, 0xACF8, 0xB4FA, 0xC53B, 0xCD7C, 0xD5DC, 0xD5DE, 0xD5DE, 
        0xD5DC, 0xDDDC, 0xDDBC, 0xCDBC, 0xC5FB, 0xDD9D, 0xDD9C, 0xDDBC, 0xD5FC, 0xE5FC, 0xD5BB, 0xD57B, 0xDD5B, 0xC53A, 0xBD18, 0xBCF8, 0xBCB8, 0xB498, 0xB497, 0xB4B8, 0xBCF8, 0xD53A, 0xD51A, 0xCD5B, 0xD5FC, 0xD57C, 0xDD9D, 0xDDDE, 0xDE5F, 0xEE5F, 
        0xEE5F, 0xDE5F, 0xCE1E, 0xD57E, 0xD53D, 0xC51B, 0xB519, 0xAC77, 0xAC55, 0xABF5, 0xB395, 0x9B91, 0x9B31, 0xA351, 0xB3D3, 0xE3D7, 0xB1AE, 0xB08B, 0xD8ED, 0xD952, 0xC8F0, 0xC0D0, 0xC8F0, 0xC02B, 0xC0AD, 0xB0AA, 0x9866, 0xEAB6, 0xEAB6, 0xEA15, 
        0xF996, 0xFB3E, 0xFB1C, 0xFA9B, 0xFA1C, 0xFA9C, 0xFABD, 0xFABE, 0xFABE, 0xFA1B, 0xF1D9, 0xF21A, 0xFA9B, 0xFA7A, 0xF196, 0xF114, 0xF114, 0xE974, 0xE934, 0xE913, 0xF0F2, 0xE0B2, 0xE0F1, 0xE111, 0xE910, 0xE932, 0xF1B4, 0xFA37, 0xF279, 0xF117, 
        0xF177, 0xFA17, 0xFA76, 0xF977, 0xF996, 0xF9B6, 0xF9D6, 0xFA3A, 0xF9D9, 0xF9B7, 0xF9B7, 0xF9F7, 0xF996, 0xF136, 0xF116, 0xF196, 0xF9F6, 0xFA17, 0xF9F8, 0xFA59, 0xFA19, 0xF9D9, 0xF9DA, 0xFB1E, 0xFA9B, 0xF175, 0xF08E, 0xFAFD, 0xFB9E, 0xFA79, 
        0xE84D, 0x8003, 0xB84A, 0xD86E, 0xD8AE, 0xF9B9, 0xFA17, 0xE9B5, 0xD0D3, 0xC02F, 0xC06C, 0xC06A, 0xC04A, 0xB86C, 0xC86C, 0xC86B, 0xC08B, 0xE94F, 0xE10F, 0xD8EE, 0xC8CD, 0xB84D, 0xB88D, 0xB88B, 0xB049, 0x9047, 0x68C4, 0x5163, 0x5A03, 0x48A1, 
        0x6904, 0x7124, 0x5902, 0x8389, 0x5A44, 0x3101, 0x1880, 0x49C4, 0x6288, 0x49E7, 0x20C3, 0xA46E, 0x8C09, 0x5A64, 0x4882, 0x9A2B, 0x79C9, 0x6127, 0x6909, 0xBB2B, 0x9B08, 0x72A7, 0x5A66, 0x41A1, 0x5102, 0x6083, 0x6842, 0x6883, 0x7084, 0x7085, 
        0x7086, 0x7085, 0x8905, 0x88E4, 0x7863, 0xB1CD, 0x50C6, 0x3042, 0x6084, 0x4985, 0x40E2, 0x3041, 0x3021, 0x6886, 0x6064, 0x5863, 0x58A5, 0x3821, 0x3821, 0x5905, 0x924B, 0x7108, 0x8109, 0x7929, 0x6108, 0x6083, 0x9B0B, 0xA3CC, 0x6A85, 0x4161, 
        0x4141, 0x59A4, 0x8248, 0x9A2A, 0x8A88, 0x7306, 0x5B67, 0x7BA7, 0x9BA7, 0xA388, 0x8369, 0x62A4, 0x6183, 0x60E4, 0x60A5, 0x5825, 0x6867, 0x7068, 0x7007,
  0xB39D, 0xB39C, 0xAB7C, 0xAB7D, 0xB39D, 0xB3BD, 0xB39D, 0xB39D, 0xB3BE, 0xBB9E, 0xB3BD, 0xB3DD, 0xBBDE, 0xBBDE, 0xBBBE, 0xB3BF, 0xB3DE, 0xB3FE, 0xBBFE, 0xBC1D, 0xAC38, 0xB412, 0xAC2D, 0x9469, 0x9448, 0x9C49, 0x9C2B, 0x9C0C, 0x940D, 0x9C4C, 0x9C6C, 
        0x9C8C, 0xBCEA, 0xC4EA, 0xC509, 0xD547, 0xE587, 0xE586, 0xE5A6, 0xE5C6, 0xE546, 0xD525, 0xD505, 0xD4E5, 0xACA4, 0xB484, 0xB444, 0xAC24, 0xAC63, 0xA443, 0x9BC3, 0x8B65, 0x940C, 0x946C, 0x9CAE, 0xB4F2, 0xDDF4, 0xE5F4, 0xD5D3, 0xCDB2, 0xDD92, 
        0xC510, 0xB4AD, 0xAC6C, 0xCCD4, 0xC495, 0xBC95, 0xB4D6, 0xA479, 0x8C39, 0x7BB8, 0x6AF8, 0x5A7A, 0x8334, 0x9392, 0x8354, 0x93B5, 0x93D6, 0x93F7, 0x9C37, 0x9C56, 0xAC57, 0xB498, 0xBCD9, 0xB51A, 0xC53B, 0xCD5C, 0xCD7C, 0xD5BD, 0xD59D, 0xDDBD, 
        0xDDFE, 0xD5DC, 0xDDFD, 0xE5FD, 0xDDDD, 0xDDDD, 0xDDDD, 0xDDDC, 0xDDBC, 0xE5DD, 0xDD9B, 0xDD7B, 0xD57B, 0xC519, 0xC4F8, 0xBCD8, 0xBCB8, 0xB497, 0xB497, 0xB4B8, 0xBD1A, 0xDD9D, 0xD55C, 0xDD5C, 0xDDBE, 0xCD7E, 0xD5BE, 0xDDDF, 0xE5FE, 0xE67F, 
        0xEEBF, 0xEEBF, 0xE67F, 0xDDFF, 0xD5BE, 0xCD7D, 0xB55C, 0xBCD9, 0xB458, 0xB416, 0xB414, 0xAC34, 0xAC14, 0xB435, 0xC414, 0x88A6, 0xC0CC, 0xE111, 0xE0B2, 0xB82D, 0xC06F, 0xD8D2, 0xE8F3, 0xC8CF, 0xC86E, 0xC88D, 0xB8EC, 0xC029, 0xC00A, 0xC08F, 
        0xC954, 0xC9F5, 0xEA3A, 0xFB1E, 0xFC1F, 0xFB1F, 0xFA7D, 0xFA1C, 0xFA1B, 0xF23B, 0xFA5C, 0xFABD, 0xFADD, 0xF1D7, 0xF196, 0xF176, 0xF155, 0xF996, 0xF174, 0xF134, 0xF135, 0xE8F1, 0xF132, 0xF153, 0xF132, 0xE953, 0xE954, 0xF196, 0xFA19, 0xFA59, 
        0xF996, 0xF976, 0xF9D8, 0xFA38, 0xF9F8, 0xF9F8, 0xFA3A, 0xFA38, 0xFA18, 0xF9D7, 0xF9B6, 0xF9B8, 0xF9B7, 0xF996, 0xF997, 0xF1B6, 0xF1B6, 0xF197, 0xF977, 0xFA58, 0xFA7B, 0xFA9C, 0xFABC, 0xFA9C, 0xF177, 0xF116, 0xF9B9, 0xFC7D, 0xEA16, 0xD02E, 
        0xB009, 0xA807, 0xD06C, 0xE911, 0xF1B6, 0xF134, 0xF957, 0xF999, 0xF198, 0xD0AE, 0xC08C, 0xB88B, 0xB08A, 0xC06B, 0xB88A, 0xC08A, 0xC86A, 0xE0EF, 0xE930, 0xE12F, 0xC8EE, 0xC08E, 0xB8AD, 0xB8AC, 0xB86C, 0x9066, 0x78C4, 0x6144, 0x5985, 0x5182, 
        0x69C4, 0x7206, 0x6A47, 0x3901, 0x4181, 0x49E2, 0x49E3, 0x834B, 0x59E7, 0x30A2, 0x28A2, 0xAC2C, 0xA40B, 0x7A86, 0x5041, 0x6002, 0x3001, 0x1800, 0x2841, 0x79E7, 0xA3CB, 0xA44B, 0x7B48, 0x79A7, 0x8926, 0x78C5, 0x6083, 0x7884, 0x7885, 0x7885, 
        0x78A6, 0x78A5, 0x7865, 0x88C8, 0xA98D, 0x7A2B, 0x8AC9, 0x8AC9, 0x7A0A, 0x3042, 0x4083, 0x6946, 0x91C9, 0x70A4, 0x68C5, 0x58A4, 0x4821, 0x48A3, 0x6988, 0x920C, 0xAA0E, 0x91AC, 0x916C, 0x894B, 0x6907, 0x3861, 0x4183, 0x8349, 0xD50F, 0x7A28, 
        0x6927, 0x5085, 0x3821, 0x4122, 0x59A4, 0x69E6, 0x8226, 0x8366, 0x7324, 0x62C2, 0x5A42, 0x8A0A, 0x6105, 0x4882, 0x5064, 0x6065, 0x6825, 0x6826, 0x7049,
  0xB3BD, 0xB39D, 0xB39D, 0xBBBD, 0xB3BD, 0xB3BD, 0xB3BE, 0xB39E, 0xB3BE, 0xB3BE, 0xB3DE, 0xBBDE, 0xBBDE, 0xBBDE, 0xBBDE, 0xB3DE, 0xBBDF, 0xBBFF, 0xBC1F, 0xBC5E, 0xC496, 0xBC74, 0xB472, 0xB450, 0xAC8D, 0xA48C, 0xA46C, 0xA46D, 0xAC2F, 0xA48C, 0xA4AC, 
        0xACAE, 0xB50C, 0xB50B, 0xC52A, 0xD569, 0xE5C5, 0xEDA6, 0xED88, 0xEDA9, 0xE5A5, 0xE586, 0xE566, 0xDD46, 0xD526, 0xCD06, 0xC4E5, 0xCCC5, 0xBD05, 0xB4A5, 0xBC65, 0xBC24, 0x9C23, 0xA467, 0xACC9, 0xB54A, 0xDDF4, 0xDDD3, 0xDDB2, 0xD5B0, 0xD54F, 
        0xC510, 0xB46F, 0x9BCE, 0xBC1B, 0xABF8, 0x93F4, 0x83F2, 0xA414, 0xB497, 0xBD3B, 0xC55E, 0xB4FE, 0xAC79, 0x9C15, 0x93D5, 0x8BD5, 0x93F5, 0x9BF5, 0x93D4, 0xB4FB, 0xBD1B, 0xC53B, 0xCD5B, 0xC57B, 0xCD9C, 0xD59C, 0xDD9D, 0xD59D, 0xD5BD, 0xDDDD, 
        0xDDFE, 0xDDBC, 0xDDDD, 0xDDDD, 0xDDDD, 0xE5FE, 0xE5FD, 0xE5DD, 0xE5DD, 0xDDDB, 0xDD9B, 0xDD9C, 0xD57C, 0xBD3A, 0xBD19, 0xBCF8, 0xBCD7, 0xBCB9, 0xB4B8, 0xB4D8, 0xB519, 0xE57B, 0xDD7B, 0xD57B, 0xDD9B, 0xD59C, 0xD59D, 0xDD9E, 0xDD9F, 0xE65F, 
        0xEE9F, 0xEE9F, 0xEE9F, 0xE65F, 0xDDFF, 0xD59F, 0xD57E, 0xBD1B, 0xB4DA, 0xAC57, 0xA3B5, 0xBC15, 0xCBF6, 0xCAB2, 0xB8CD, 0xF171, 0xF912, 0xF0B3, 0xE8D4, 0xE092, 0xE0B1, 0xD091, 0xB872, 0xB8CB, 0xC0AC, 0xC06C, 0xC04C, 0xC04B, 0xB8AB, 0xB88A, 
        0xC02A, 0xC8AE, 0xC8AF, 0xC06F, 0xB86F, 0xF1B7, 0xFA9B, 0xFABD, 0xFA7C, 0xFADF, 0xFB1E, 0xFABC, 0xF9BA, 0xF976, 0xF977, 0xF977, 0xF998, 0xF1D8, 0xF1D6, 0xF995, 0xF974, 0xF175, 0xF153, 0xF152, 0xF152, 0xF132, 0xF153, 0xF174, 0xF174, 0xF9D7, 
        0xF9D7, 0xFA18, 0xFABA, 0xF978, 0xF9B8, 0xFA18, 0xFA58, 0xF9FB, 0xF9F9, 0xF9F7, 0xFA16, 0xFA57, 0xF9F6, 0xF1B5, 0xF175, 0xF9B6, 0xF9B6, 0xF9B7, 0xF9F7, 0xFA3A, 0xFA3A, 0xFA9B, 0xFADC, 0xF958, 0xF97A, 0xFABD, 0xFBDD, 0xE08E, 0xB80A, 0xB02A, 
        0xB84B, 0xE0AE, 0xF111, 0xF174, 0xF9D8, 0xF0D4, 0xF978, 0xF9FB, 0xF9FB, 0xE051, 0xC84E, 0xC88C, 0xD0AB, 0xB8AC, 0xC88C, 0xD08C, 0xD0AD, 0xD0AE, 0xE0EF, 0xE130, 0xD90F, 0xE10F, 0xD0CE, 0xC0AD, 0xB88B, 0x986A, 0x8866, 0x8064, 0x78A3, 0x69E4, 
        0x7286, 0x6A65, 0x49E2, 0x72E7, 0x72C6, 0x72E7, 0x72E8, 0x1861, 0x0800, 0x2881, 0x61C4, 0xC570, 0x72C7, 0x50E4, 0x7949, 0xEC34, 0xECF8, 0xECD8, 0xE3D4, 0x5A07, 0x4142, 0x4162, 0x5A64, 0x8B08, 0x81E6, 0x70C4, 0x7022, 0x60A3, 0x70A2, 0x78A3, 
        0x7886, 0x78A4, 0x80E6, 0x9129, 0xA98E, 0x89C9, 0x6127, 0x6147, 0x7A08, 0x5988, 0x50E5, 0x4862, 0x4821, 0x5883, 0x5863, 0x5884, 0x58E6, 0x6125, 0x58C5, 0x5844, 0x6804, 0x7026, 0x88E9, 0x996D, 0x91CE, 0x69E9, 0x4965, 0x6206, 0x9B4A, 0x5962, 
        0x61C5, 0x7A69, 0x8AAB, 0x48C6, 0x5845, 0x6826, 0x6809, 0x7867, 0x68E4, 0x5963, 0x59E3, 0x6868, 0x792A, 0x7929, 0x6848, 0x788A, 0x7049, 0x7029, 0x7049
};

#endif /* __RGB565_320X240_H */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
