/**
  ******************************************************************************
  * @file    camera_res.c
  * @author  MCD Application Team
  * @brief   resources define for camera module
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2017 STMicroelectronics International N.V. 
  * All rights reserved.</center></h2>
  *
  * Redistribution and use in source and binary forms, with or without 
  * modification, are permitted, provided that the following conditions are met:
  *
  * 1. Redistribution of source code must retain the above copyright notice, 
  *    this list of conditions and the following disclaimer.
  * 2. Redistributions in binary form must reproduce the above copyright notice,
  *    this list of conditions and the following disclaimer in the documentation
  *    and/or other materials provided with the distribution.
  * 3. Neither the name of STMicroelectronics nor the names of other 
  *    contributors to this software may be used to endorse or promote products 
  *    derived from this software without specific written permission.
  * 4. This software, including modifications and/or derivative works of this 
  *    software, must execute solely and exclusively on microcontroller or
  *    microprocessor devices manufactured by or for STMicroelectronics.
  * 5. Redistribution and use of this software other than as permitted under 
  *    this license is void and will automatically terminate your rights under 
  *    this license. 
  *
  * THIS SOFTWARE IS PROVIDED BY STMICROELECTRONICS AND CONTRIBUTORS "AS IS" 
  * AND ANY EXPRESS, IMPLIED OR STATUTORY WARRANTIES, INCLUDING, BUT NOT 
  * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
  * PARTICULAR PURPOSE AND NON-INFRINGEMENT OF THIRD PARTY INTELLECTUAL PROPERTY
  * RIGHTS ARE DISCLAIMED TO THE FULLEST EXTENT PERMITTED BY LAW. IN NO EVENT 
  * SHALL STMICROELECTRONICS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
  * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, 
  * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
  * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
  * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
  * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  *
  ******************************************************************************
  */
/* Includes ------------------------------------------------------------------*/
#include <stdlib.h>
#include "GUI.h"

/** @addtogroup CAMERA_MODULE
  * @{
  */

/** @defgroup CAMERA_RES
  * @brief camera resources
  * @{
  */

#ifndef GUI_CONST_STORAGE
  #define GUI_CONST_STORAGE const
#endif

extern GUI_CONST_STORAGE GUI_BITMAP bmcamera;
extern GUI_CONST_STORAGE GUI_BITMAP bmwizard;
extern GUI_CONST_STORAGE GUI_BITMAP bmcapturebutton_not_pressed;
extern GUI_CONST_STORAGE GUI_BITMAP bmcapturebutton_pressed;

static GUI_CONST_STORAGE unsigned long _accamera[] = {
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xF9444444, 0xE5626262, 0xB66F6F6F, 0x83727272, 0x6B6A6A6A, 0x6C646464, 0xA0666666, 0xF6343434, 0xFE000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xF7454545, 0xBF707070, 0x5C848484, 0x149C9C9C, 0x00959595, 0x00696969, 0x002B2B2B, 0x000D0D0D, 0x06323232, 0x955E5E5E, 0xF42E2E2E, 0xFE000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFC232323, 0xF2474747, 0xE94B4B4B, 0xE04D4D4D, 0xD64F4F4F, 0xC44F4F4F, 0xAA505050, 0x96575757, 0xB34E4E4E, 0xE63F3F3F, 0xFC181818, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xF23B3B3B, 0x6F737373, 0x0B787878, 0x009E9E9E, 0x00B0B0B0, 0x008F8F8F, 0x00707070, 0x005F5F5F, 0x00515151, 0x00414141, 0x0D4E4E4E, 0x4C505050, 0x9C595959, 
        0xD9575757, 0xF62A2A2A, 0xDD484848, 0x58525252, 0x394F4F4F, 0x28525252, 0x185B5B5B, 0x06676767, 0x00767676, 0x00888888, 0x00949494, 0x02898989, 0x24686868, 0x67525252, 0xBC424242, 0xEB353535, 0xFD030303, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFB000000, 0xA7626262, 0x04484848, 0x00494949, 0x00676767, 0x00666666, 0x006A6A6A, 0x007C7C7C, 0x008A8A8A, 0x00939393, 0x00919191, 0x007C7C7C, 0x00595959, 0x00545454, 
        0x19777878, 0x3F727373, 0x35626262, 0x003C3C3C, 0x002E2E2E, 0x00393939, 0x00515151, 0x00666666, 0x00797979, 0x00888888, 0x00909090, 0x00919191, 0x008A8A8A, 0x00757575, 0x075B5B5B, 0x2F484848, 0x793F3F3F, 0xC7393939, 0xF61F1F1F, 0xFE000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF2060606, 0x59646464, 0x00121212, 0x00151515, 0x001E1E1E, 0x00262626, 0x003D3D3D, 0x00545454, 0x00696969, 0x008D8D8D, 0x00BBBBBB, 0x00C9C9CA, 0x00C5C6C6, 0x00C1C1C2, 
        0x00B8B9BA, 0x00ACADAE, 0x00A0A1A2, 0x009A9A9B, 0x00888888, 0x006F6F6F, 0x005D5D5D, 0x00575757, 0x00616161, 0x006D6D6D, 0x00747474, 0x00757575, 0x006F6F6F, 0x00656565, 0x00565656, 0x00434343, 0x00303030, 0x0E282828, 0x3A2E2E2E, 0x8D363636, 
        0xD6313131, 0xFB0B0B0B, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xE70A0A0A, 0x3F606060, 0x00020202, 0x00070707, 0x00252525, 0x00171717, 0x00131313, 0x00242424, 0x004A4A4A, 0x00A2A2A2, 0x00C9C9C9, 0x00DDDDDD, 0x00DDDDDD, 0x00D6D6D7, 
        0x00CECFCF, 0x00C7C7C7, 0x00BEBEBF, 0x00B5B5B6, 0x00ACADAD, 0x00A1A1A2, 0x00939393, 0x008D8D8D, 0x007F7F7F, 0x006B6B6B, 0x005B5B5B, 0x00575757, 0x00535353, 0x004A4A4A, 0x003D3D3D, 0x002D2D2D, 0x00191919, 0x00070707, 0x00040404, 0x010E0E0E, 
        0x121F1F1F, 0x492C2C2C, 0x9F2F2F2F, 0xEB202020, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xE3090909, 0x3C5D5D5D, 0x00010101, 0x00141414, 0x00595959, 0x00464646, 0x002E2E2E, 0x00171717, 0x004A4A4A, 0x00828282, 0x00909090, 0x009F9F9F, 0x00BCBCBC, 0x00DCDDDD, 
        0x00E0E1E1, 0x00DADBDB, 0x00D3D4D4, 0x00CBCCCD, 0x00C3C4C4, 0x00BABBBC, 0x00A8A9A9, 0x00727272, 0x00676767, 0x008A8A8A, 0x008C8C8C, 0x00727272, 0x00505050, 0x00303030, 0x00232323, 0x00141414, 0x00060606, 0x00010101, 0x00010101, 0x00010101, 
        0x00010101, 0x00040404, 0x03101010, 0x131E1E1E, 0x602A2A2A, 0xBA262626, 0xF70A0A0A, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xE10A0A0A, 0x375D5D5D, 0x00010101, 0x001F1F1F, 0x00838383, 0x00737373, 0x005F5F5F, 0x006D6D6D, 0x00E9E9E9, 0x00C0C0C0, 0x00969696, 0x008A8A8A, 0x008D8D8D, 0x00949494, 
        0x00C3C3C3, 0x00E7E7E7, 0x00DEDEDE, 0x00B3B3B3, 0x009D9D9D, 0x00A6A6A6, 0x00B2B2B2, 0x00BABBBB, 0x00919292, 0x00575858, 0x00494949, 0x00656565, 0x007F7F7F, 0x007B7B7B, 0x00535353, 0x00242424, 0x00060606, 0x00010101, 0x00010101, 0x00010101, 
        0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00040404, 0x00121212, 0x211D1D1D, 0x77212121, 0xCF1D1D1D, 0xF6131313, 0xFE030303, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xE3040404, 0x47575757, 0x00090909, 0x001A1A1A, 0x00888888, 0x00909090, 0x00888888, 0x00E4E4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00FCFCFC, 0x00DEDEDE, 0x00B0B0B0, 0x008A8A8A, 
        0x007B7B7B, 0x009E9E9E, 0x009D9D9D, 0x00C9C9C9, 0x00E7E7E7, 0x00E2E2E3, 0x00DCDCDD, 0x00D5D6D6, 0x00CECFCF, 0x00C6C6C7, 0x00AEAFB0, 0x00727373, 0x003C3C3D, 0x003E3E3E, 0x005F5F5F, 0x00767676, 0x006B6B6B, 0x00464646, 0x001D1D1D, 0x00090909, 
        0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00070707, 0x05121212, 0x3E191919, 0x96191919, 0xE1151515, 0xFA0B0B0B, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xE9000000, 0x79444444, 0x01292929, 0x00020202, 0x001E1E1E, 0x005B5B5B, 0x00B2B2B2, 0x00FDFDFD, 0x00FEFEFE, 0x00FDFDFD, 0x00FDFDFD, 0x00FDFDFD, 0x00FEFEFE, 0x00F0F0F0, 
        0x00C4C4C4, 0x00ADADAD, 0x00EFEFF0, 0x00F6F6F6, 0x00F3F3F3, 0x00EFEFEF, 0x00EAEBEB, 0x00E6E6E6, 0x00E0E0E0, 0x00D9DADA, 0x00D2D3D3, 0x00CBCBCC, 0x00C0C1C2, 0x00989999, 0x005B5B5B, 0x00353536, 0x003E3E3E, 0x00636363, 0x00747474, 0x00666666, 
        0x00454545, 0x001E1E1E, 0x000A0A0A, 0x00020202, 0x00080808, 0x00111111, 0x001C1C1C, 0x00323232, 0x004B4B4B, 0x00595959, 0x00444444, 0x171D1D1D, 0x7D141414, 0xF7040404, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF2000000, 0xB8141414, 0x324C4C4C, 0x04313131, 0x00232323, 0x00222222, 0x00C3C3C3, 0x00FCFCFC, 0x00FBFBFB, 0x00FAFAFA, 0x00F9F9F9, 0x00F8F8F8, 0x00F8F8F8, 0x00FAFAFA, 
        0x00FDFDFD, 0x00FEFEFE, 0x00FEFEFE, 0x00FCFCFC, 0x00FBFBFB, 0x00F8F8F8, 0x00F5F5F5, 0x00F1F2F2, 0x00EEEEEE, 0x00E8E9E9, 0x00E3E4E4, 0x00DDDEDE, 0x00D7D8D8, 0x00D0D0D0, 0x00B6B6B7, 0x00858686, 0x00595959, 0x00353535, 0x002E2E2E, 0x00434343, 
        0x00646464, 0x00737373, 0x00656565, 0x005A5A5A, 0x00656565, 0x00757575, 0x00828282, 0x00858585, 0x00858585, 0x007D7D7D, 0x00767676, 0x00535353, 0x0D151515, 0xC30E0E0E, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFB000000, 0xDE000000, 0xA90B0B0B, 0x73272727, 0x53343434, 0x12767676, 0x00F0F0F0, 0x00F9F9F9, 0x00F8F8F8, 0x00F7F7F7, 0x00F6F6F6, 0x00F5F5F5, 0x00F4F4F4, 0x00F3F3F3, 
        0x00F3F3F3, 0x00F5F5F5, 0x00FAFAFA, 0x00FEFEFE, 0x00FEFEFE, 0x00FDFDFD, 0x00FCFCFC, 0x00FAFAFA, 0x00F7F7F7, 0x00F4F4F4, 0x00F0F0F0, 0x00EFEFEF, 0x00F4F4F4, 0x00EFEFEF, 0x00D9D9D9, 0x00B4B4B4, 0x009C9C9C, 0x00A6A7A7, 0x009E9F9F, 0x00707171, 
        0x00393939, 0x00292929, 0x00454545, 0x00525252, 0x00535353, 0x00484848, 0x00393939, 0x00292929, 0x001B1B1B, 0x00131313, 0x000C0C0C, 0x00030303, 0x01050505, 0x800F0F0F, 0xF6000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xF7000000, 0xE3000000, 0xCB000000, 0x951F1F1F, 0x0FA0A0A0, 0x00F6F6F6, 0x00F6F6F6, 0x00F5F5F5, 0x00F4F4F4, 0x00F3F3F3, 0x00F2F2F2, 0x00F1F1F1, 0x00F0F0F0, 
        0x00EFEFEF, 0x00EEEEEE, 0x00EDEDED, 0x00EFEFEF, 0x00F4F4F4, 0x00FBFBFB, 0x00FEFEFE, 0x00FEFEFE, 0x00FDFDFD, 0x00FAFAFA, 0x00F3F3F4, 0x00F6F6F6, 0x00FBFBFB, 0x00FCFCFC, 0x00F0F0F0, 0x00E5E5E5, 0x00DFDFDF, 0x00D8D9D9, 0x00D1D2D2, 0x00C9CACB, 
        0x00BBBBBC, 0x00989999, 0x00535454, 0x00282828, 0x002A2A2A, 0x003E3E3F, 0x00636363, 0x00767676, 0x00606060, 0x00434343, 0x001D1D1D, 0x00010101, 0x00020202, 0x550C0C0C, 0xEE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFC000000, 0xF3000000, 0xB32F2F2F, 0x18838383, 0x00C8C8C8, 0x00F0F0F0, 0x00F2F2F2, 0x00F1F1F1, 0x00F0F0F0, 0x00F0F0F0, 0x00EEEEEE, 0x00EDEDED, 
        0x00ECECEC, 0x00EBEBEB, 0x00EAEAEA, 0x00E9E9E9, 0x00E8E8E8, 0x00E9E9E9, 0x00EDEDED, 0x00F7F7F7, 0x00FEFEFE, 0x00ECECEC, 0x00DEDEDE, 0x00E7E7E7, 0x00F3F3F3, 0x00F8F8F8, 0x00F5F5F5, 0x00F1F1F1, 0x00EDEDED, 0x00E8E8E9, 0x00E3E3E3, 0x00DCDDDD, 
        0x00D6D6D6, 0x00CECFCF, 0x00C5C6C7, 0x00B7B8B8, 0x00AFB0B1, 0x00ACADAD, 0x00B3B4B5, 0x00C6C6C7, 0x00D3D3D3, 0x00CDCDCD, 0x00C5C5C5, 0x00969696, 0x00212121, 0x370A0A0A, 0xE7000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFA000000, 0xDC010101, 0x9F0B0B0B, 0x54363636, 0x1A676767, 0x02ADADAD, 0x00DEDEDE, 0x00ECECEC, 0x00ECECEC, 0x00EBEBEB, 0x00EAEAEA, 
        0x00E9E9E9, 0x00E8E8E8, 0x00E7E7E7, 0x00E6E6E6, 0x00E5E5E5, 0x00E4E4E4, 0x00E3E3E3, 0x00E2E2E2, 0x00DADADA, 0x00BEBEBE, 0x00C8C8C8, 0x00E1E1E1, 0x00FDFDFD, 0x00FDFDFD, 0x00FCFCFC, 0x00F9F9F9, 0x00F7F7F7, 0x00F3F4F4, 0x00F0F0F0, 0x00EBEBEC, 
        0x00E6E6E7, 0x00E0E1E1, 0x00DADBDB, 0x00D4D5D5, 0x00D2D3D3, 0x00CECECE, 0x00C3C4C4, 0x00ABABAB, 0x009C9C9D, 0x00A4A4A4, 0x00B0B0B0, 0x00BBBBBB, 0x00909090, 0x25080808, 0xE1000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0xF3000000, 0xDA000000, 0xBC000000, 0x9B000000, 0x4C313131, 0x00292929, 0x005A5A5A, 0x00BFBFBF, 0x00E7E7E7, 0x00E7E7E7, 
        0x00E6E6E6, 0x00E5E5E5, 0x00E4E4E4, 0x00E3E3E3, 0x00E2E2E2, 0x00E1E1E1, 0x00E0E0E0, 0x00DEDEDE, 0x00A5A5A5, 0x00A3A3A3, 0x00B9B9B9, 0x00EEEEEE, 0x00F9F9F9, 0x00FDFDFD, 0x00FEFEFE, 0x00FEFEFE, 0x00FDFDFD, 0x00FBFBFB, 0x00F8F9F9, 0x00F6F6F6, 
        0x00F2F2F2, 0x00EDEDED, 0x00E9E9E9, 0x00EBEBEB, 0x00EEEEEE, 0x00F2F2F2, 0x00F2F2F2, 0x00EDEDED, 0x00DADADA, 0x00B0B0B0, 0x00A7A7A7, 0x00B3B3B3, 0x00ADADAD, 0x1E080808, 0xDC000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFA000000, 0xF0000000, 0xD8000000, 0x772F2F2F, 0x001C1C1C, 0x00010101, 0x005F5F5F, 0x00C6C6C6, 0x00D2D2D2, 
        0x00DEDEDE, 0x00E2E2E2, 0x00E1E1E1, 0x00E0E0E0, 0x00DFDFDF, 0x00DEDEDE, 0x00DDDDDD, 0x00BCBCBC, 0x007B7B7B, 0x00888888, 0x00C3C3C3, 0x00E1E1E1, 0x00E8E8E8, 0x00EFEFEF, 0x00F6F6F6, 0x00FBFBFB, 0x00FEFEFE, 0x00FEFEFE, 0x00FDFDFD, 0x00FBFBFB, 
        0x00EFEFEF, 0x00E5E5E5, 0x00E4E4E4, 0x00EBEBEB, 0x00DFDFDF, 0x009D9D9D, 0x00727272, 0x006A6A6A, 0x00858585, 0x00C3C3C3, 0x00BEBEBE, 0x00ABABAB, 0x00A9A9A9, 0x16171717, 0xBC020202, 0xF4010101, 0xFE000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xF1000000, 0x88343434, 0x001B1B1B, 0x00010101, 0x005D5D5D, 0x00BCBCBC, 0x00B5B5B5, 
        0x00B4B4B4, 0x00C0C0C0, 0x00D2D2D2, 0x00DCDCDC, 0x00DCDCDC, 0x00DBDBDB, 0x00D9D9D9, 0x009C9C9C, 0x00747474, 0x007F7F7F, 0x00C6C6C6, 0x00CECECE, 0x00D5D5D5, 0x00DCDCDC, 0x00E3E3E3, 0x00EAEAEA, 0x00F1F1F1, 0x00F8F8F8, 0x00FCFCFC, 0x00EDEDED, 
        0x00DCDCDC, 0x00DCDCDC, 0x00E7E7E7, 0x00B6B6B6, 0x004B4B4B, 0x003D3D3D, 0x00414141, 0x00434343, 0x00494949, 0x00525252, 0x009D9D9D, 0x00B4B4B4, 0x00818181, 0x03555555, 0x1E555555, 0x542F2F2F, 0xCB040404, 0xFC000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF3000000, 0x8A353535, 0x001F1F1F, 0x00010101, 0x005D5D5D, 0x00B9B9B9, 0x00B3B3B3, 
        0x00ACACAC, 0x00A4A4A4, 0x00A0A0A0, 0x00AAAAAA, 0x00C0C0C0, 0x00D6D6D6, 0x00CECECE, 0x009E9E9E, 0x008D8D8D, 0x00969696, 0x00B4B4B4, 0x00BBBBBB, 0x00C2C2C2, 0x00C9C9C9, 0x00D0D0D0, 0x00D8D8D8, 0x00DFDFDF, 0x00E6E6E6, 0x00E5E5E5, 0x00D4D4D4, 
        0x00D3D3D3, 0x00E0E0E0, 0x00ADADAD, 0x00434343, 0x00545453, 0x00665D58, 0x00534E4C, 0x003D3D3D, 0x003A3A3A, 0x004C4C4C, 0x005E5E5E, 0x00AEAEAE, 0x009D9D9D, 0x00CCCCCC, 0x00B6B6B6, 0x00B7B7B7, 0x234B4B4B, 0xDA000000, 0xFD000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF3000000, 0x8A353535, 0x00222222, 0x00010101, 0x00565656, 0x00B8B8B8, 0x00B0B0B0, 
        0x00AAAAAA, 0x00A2A2A2, 0x009B9B9B, 0x00949494, 0x008F8F8F, 0x00C1C1C1, 0x00C6C6C6, 0x00AFAFAF, 0x00A6A6A6, 0x009D9D9D, 0x00A2A2A2, 0x00A8A8A8, 0x00B0B0B0, 0x00B7B7B7, 0x00BEBEBE, 0x00C5C5C5, 0x00CCCCCC, 0x00D3D3D3, 0x00CDCDCD, 0x00CACACA, 
        0x00D0D0D0, 0x00C6C6C6, 0x004A4A4A, 0x00816F64, 0x00CFA085, 0x00E0B298, 0x00D39F81, 0x007A5845, 0x002E2D2D, 0x00353535, 0x005C5C5C, 0x00838383, 0x00C8C8C8, 0x007E7E7E, 0x006F6F6F, 0x009B9B9B, 0x00A3A3A3, 0x8D111111, 0xF8000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF3000000, 0x9B2A2A2A, 0x00212121, 0x00010101, 0x00464646, 0x00B6B6B6, 0x00AFAFAF, 
        0x00A8A8A8, 0x00A0A0A0, 0x00989898, 0x00929292, 0x008A8A8A, 0x00AFAFAF, 0x00C8C8C8, 0x00C3C3C3, 0x00BCBCBC, 0x00A0A0A0, 0x009A9A9A, 0x009B9B9B, 0x009E9E9E, 0x00A4A4A4, 0x00ABABAB, 0x00B2B2B2, 0x00BABABA, 0x00C0C0C0, 0x00C1C1C1, 0x00C1C1C1, 
        0x00D7D7D7, 0x00707070, 0x007E6D63, 0x00EBB99A, 0x00F7D0B6, 0x00F7D0B7, 0x00F7CEB5, 0x00E7B292, 0x004F3B2F, 0x002F2F2F, 0x00474747, 0x00797979, 0x00B5B5B5, 0x00868686, 0x008A8A8A, 0x00ABABAB, 0x00AFAFAF, 0x6A191919, 0xF1000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0xF2000000, 0x992B2B2B, 0x00212121, 0x00010101, 0x00454545, 0x00B9B9B9, 0x00B6B6B6, 
        0x00B2B2B2, 0x00ACACAC, 0x00A3A3A3, 0x00949494, 0x00787878, 0x00676767, 0x005D5D5D, 0x00C8C8C8, 0x00D0D0D0, 0x00A7A7A7, 0x009F9F9F, 0x009C9C9C, 0x00A0A0A0, 0x00A2A2A2, 0x009E9E9E, 0x00A0A0A0, 0x00A7A7A7, 0x00B4B4B4, 0x00B8B8B8, 0x00BEBEBE, 
        0x00BEBEBE, 0x005B5957, 0x00DEAF8F, 0x00F8CBAC, 0x00F8CDAF, 0x00F8CDAE, 0x00F8CBAC, 0x00F7C7A7, 0x0091684E, 0x00262626, 0x00393939, 0x00818181, 0x00BDBDBD, 0x00A4A4A4, 0x00B6B6B6, 0x00D9D9D9, 0x009B9B9B, 0x6D0F0F0F, 0xED000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE070707, 0xF83B3B3B, 0xF03F3F3F, 0xDB474747, 0xAD505050, 0x7D555555, 0x4E5D5D5D, 0x206E6E6E, 0x00838383, 0x008B8B8B, 0x00A6A6A6, 0x00C2C2C2, 0x00BDBDBD, 0x009E9E9E, 
        0x007D7D7D, 0x005F5F5F, 0x00464646, 0x00343434, 0x00323232, 0x00313131, 0x00303030, 0x00CFCFCF, 0x00E0E0E0, 0x00B8B8B8, 0x00A8A8A8, 0x00A4A4A4, 0x00A1A1A1, 0x009B9B9B, 0x00959595, 0x00909090, 0x00919191, 0x00ADADAD, 0x00B0B0B0, 0x00C3C3C3, 
        0x008D8D8D, 0x008D7B6D, 0x00F6C49E, 0x00FACCA8, 0x00FBCFAB, 0x00FBCEAB, 0x00FACBA7, 0x00F8C39D, 0x00AF7A55, 0x00202020, 0x00393939, 0x00838383, 0x00BCBCBC, 0x009F9F9F, 0x00BEBEBE, 0x00BCBCBC, 0x0F525252, 0xA8000000, 0xF1000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFA3A3A3A, 0xE7505050, 0xD2525252, 0xA4545454, 0x71575757, 0x475A5A5A, 0x1E606060, 0x026B6B6B, 0x007A7A7A, 0x008A8A8A, 0x009A9A9A, 0x009B9B9B, 0x008D8D8D, 0x007A7A7A, 0x00676767, 0x004E4E4E, 0x003E3E3E, 0x003C3C3C, 
        0x003B3B3B, 0x00393939, 0x00373737, 0x00333333, 0x00282828, 0x00232323, 0x00353535, 0x00D6D6D6, 0x00EBEBEB, 0x00CECECE, 0x00B6B6B6, 0x00AFAFAF, 0x00959595, 0x00888888, 0x00818181, 0x007A7A7A, 0x00757575, 0x00A7A7A7, 0x00A7A7A7, 0x00C7C7C7, 
        0x00717171, 0x00B79B85, 0x00FBC79C, 0x00FDD0A7, 0x00FED5AD, 0x00FED4AC, 0x00FDCDA3, 0x00F9B680, 0x00A16D47, 0x001E1E1E, 0x003B3B3B, 0x008F8F8F, 0x00C2C2C2, 0x007E7E7E, 0x00878787, 0x06656565, 0x600B0B0B, 0xD0000000, 0xF8000000,
  0xFF000000, 0xFE000000, 0xF4292929, 0x86545454, 0x1E4A4A4A, 0x02474747, 0x00494949, 0x00515151, 0x005C5C5C, 0x00636363, 0x00656565, 0x00606060, 0x005A5A5A, 0x00505050, 0x00474747, 0x00464646, 0x00454545, 0x00454545, 0x00454545, 0x00484848, 0x004B4B4B, 
        0x004C4C4C, 0x004D4D4D, 0x00494949, 0x003C3C3C, 0x00232323, 0x00191919, 0x003B3B3B, 0x00BFBFBF, 0x00E0E0E0, 0x00E3E3E3, 0x00C8C8C8, 0x00C0C0C0, 0x00A2A2A2, 0x00747474, 0x006A6A6A, 0x00636363, 0x005D5D5D, 0x009F9F9F, 0x009F9F9F, 0x00C4C4C4, 
        0x006B6B6B, 0x00BEA087, 0x00FDCA9C, 0x00FFD9B0, 0x00FFE3BE, 0x00FFE1B9, 0x00FFD09D, 0x00FCBB81, 0x006E5037, 0x00262626, 0x00404040, 0x00A6A6A6, 0x00ACACAC, 0x04232323, 0x29242424, 0x68020202, 0xBB000000, 0xEB000000, 0xFD000000,
  0xFF000000, 0xFB000000, 0xAD4C4C4C, 0x09393939, 0x00212121, 0x003D3D3D, 0x004D4D4D, 0x00515151, 0x00515151, 0x00505050, 0x004F4F4F, 0x004E4E4E, 0x004E4E4E, 0x004F4F4F, 0x00545454, 0x005E5E5E, 0x006A6A6A, 0x00757575, 0x007D7D7D, 0x00808080, 0x00808080, 
        0x007B7B7B, 0x00766E6A, 0x006E5F56, 0x003B3B3B, 0x00272727, 0x001F1F1F, 0x00404040, 0x00A9A9A9, 0x00828282, 0x00B2B2B2, 0x00D4D4D4, 0x00D5D5D5, 0x00CACACA, 0x00A4A4A4, 0x00727272, 0x004F4F4F, 0x00444444, 0x00929292, 0x00969696, 0x00C5C5C5, 
        0x006A6A6A, 0x00AB937D, 0x00FECD9B, 0x00FFE4BB, 0x00FFF2D5, 0x00FFF0D1, 0x00FFE0B3, 0x00E0B081, 0x00261E17, 0x00353535, 0x00575757, 0x00B8B8B8, 0x00A5A5A5, 0x14010101, 0x99000000, 0xC5000000, 0xE8000000, 0xFB000000, 0xFF000000,
  0xFE000000, 0xED181818, 0x48494949, 0x00151515, 0x001A1A1A, 0x004A4A4A, 0x00585858, 0x00575757, 0x00515151, 0x00515151, 0x00575757, 0x00626262, 0x00717171, 0x00828282, 0x008F8F8F, 0x00999999, 0x009E9D9D, 0x00A09792, 0x00A18C7F, 0x00A78D7E, 0x00B39380, 
        0x00C19C87, 0x00D4B6A5, 0x00B77D5D, 0x00414141, 0x00333333, 0x00292929, 0x00464646, 0x003B3B3B, 0x00474747, 0x00616161, 0x00949494, 0x00E2E2E2, 0x00E2E2E2, 0x00DBDBDB, 0x00CDCDCD, 0x00ACACAC, 0x006D6D6D, 0x00828282, 0x008E8E8E, 0x00C0C0C0, 
        0x00747474, 0x00797067, 0x00F0C595, 0x00FFE9C1, 0x00FFF8E7, 0x00FFF7E4, 0x00F6DFB7, 0x006A5845, 0x00131212, 0x003A3A3A, 0x008C8C8C, 0x00D5D5D5, 0x007B7B7B, 0x1B010101, 0xCA000000, 0xF1000000, 0xFC000000, 0xFF000000, 0xFF000000,
  0xFD000000, 0xD32B2B2B, 0x19393939, 0x00070707, 0x00131313, 0x004C4C4C, 0x005E5E5E, 0x003A3A3A, 0x00515151, 0x00676767, 0x00787878, 0x00888786, 0x00978C86, 0x00A28778, 0x00B0907E, 0x00BF9983, 0x00CCA38B, 0x00DAB6A2, 0x00E8D0C2, 0x00F0DBD1, 0x00F5E7E0, 
        0x00F8EEE9, 0x00F8EEE9, 0x00C48D6E, 0x004D4D4D, 0x003E3E3E, 0x00343434, 0x004B4B4B, 0x000A0A0A, 0x000F0F0F, 0x00383838, 0x00595959, 0x009A9A9A, 0x00D2D2D2, 0x00E5E5E5, 0x00E5E5E6, 0x00E0E0E0, 0x00D6D6D6, 0x00A9A9A9, 0x00858585, 0x00B7B7B7, 
        0x00868686, 0x00545454, 0x0082715F, 0x00EACFA8, 0x00FEEECD, 0x00DACDB1, 0x00635A4B, 0x000A0908, 0x002B2B2B, 0x00525252, 0x00C3C3C3, 0x00D7D7D7, 0x00666666, 0x1E010101, 0xDA000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFB000000, 0xC3292929, 0x0A333333, 0x00020202, 0x000B0B0B, 0x004D4D4D, 0x00636363, 0x003B3B3B, 0x00525252, 0x006E645E, 0x00AE7C5F, 0x00C9987C, 0x00D7AD95, 0x00E5C6B5, 0x00EACFC0, 0x00EDD5C8, 0x00EFDACE, 0x00EFDACE, 0x00EFDACE, 0x00EFDACE, 0x00EFDACE, 
        0x00EFDACE, 0x00EFDACE, 0x00C08563, 0x00575757, 0x00484848, 0x003D3D3D, 0x00505050, 0x000C0C0C, 0x00191919, 0x003C3C3C, 0x00585858, 0x00727272, 0x009D9D9D, 0x00CECECF, 0x00D8D9D9, 0x00E1E1E1, 0x00E6E6E6, 0x00D8D8D8, 0x00858585, 0x009A9A9A, 
        0x00ADADAD, 0x00636363, 0x00292929, 0x002B2825, 0x00272521, 0x00141311, 0x00040404, 0x001E1E1E, 0x00393939, 0x00ADADAD, 0x00E4E4E4, 0x00A4A4A4, 0x005C5C5C, 0x28000000, 0xDB000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xF9000000, 0xB92A2A2A, 0x002C2C2C, 0x00010101, 0x00040404, 0x004F4F4F, 0x00686868, 0x00474747, 0x005B5B5B, 0x00736259, 0x00D29A79, 0x00E5C4B1, 0x00E5C4B2, 0x00E5C4B2, 0x00E5C4B2, 0x00E5C4B2, 0x00E5C4B2, 0x00E5C4B2, 0x00E5C4B2, 0x00E5C4B2, 0x00E5C4B2, 
        0x00E5C4B2, 0x00E4C3B0, 0x00B66E44, 0x00616161, 0x00515151, 0x00444444, 0x00565656, 0x000F0F0F, 0x00232323, 0x00444444, 0x00606060, 0x00797979, 0x00929292, 0x00AFB0B0, 0x00BEBFBF, 0x00C8C8C9, 0x00D2D2D2, 0x00DBDCDC, 0x00B0B0B0, 0x007C7C7C, 
        0x00C9C9C9, 0x00868686, 0x00595959, 0x00131313, 0x00070707, 0x000C0C0C, 0x001E1E1E, 0x00434343, 0x00ADADAD, 0x00DDDDDD, 0x00BFBFBF, 0x007E7E7E, 0x00242424, 0x31000000, 0xDE000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xF8000000, 0xB6272727, 0x002A2A2A, 0x00010101, 0x00010101, 0x00515151, 0x006E6E6E, 0x00505050, 0x00626262, 0x007A6960, 0x00CC8C67, 0x00DCAF95, 0x00DCAF95, 0x00DCAF95, 0x00DCAF95, 0x00DCAF95, 0x00DCAF95, 0x00DCAF95, 0x00DCAF95, 0x00DCAF95, 0x00DCAF95, 
        0x00DCAF95, 0x00C9865F, 0x00A4430B, 0x00696969, 0x00585858, 0x004A4A4A, 0x005B5B5B, 0x00161616, 0x002D2D2D, 0x004D4D4D, 0x00676767, 0x00808080, 0x00959595, 0x004A4A4A, 0x00868687, 0x00ACADAE, 0x00B8B8B9, 0x00C2C2C3, 0x00C9C9CA, 0x00999999, 
        0x00929292, 0x00CDCDCD, 0x008C8C8C, 0x00808080, 0x00686868, 0x006A6A6A, 0x00888888, 0x00BDBDBD, 0x00DBDBDB, 0x00C5C5C5, 0x007D7D7D, 0x005A5A5A, 0x00010101, 0x32000000, 0xDF000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xF8000000, 0xB6262626, 0x002A2A2A, 0x00010101, 0x00010101, 0x00555555, 0x00737373, 0x00535353, 0x00686868, 0x007F6E65, 0x00C67E55, 0x00D39B7B, 0x00D39B7B, 0x00D39B7B, 0x00D39B7B, 0x00D39B7B, 0x00D39B7B, 0x00D39B7B, 0x00D39B7B, 0x00D39B7B, 0x00D29A7A, 
        0x00C67F57, 0x00AB4307, 0x00A4430C, 0x006E6E6E, 0x005D5D5D, 0x004F4F4F, 0x00616161, 0x001F1F1F, 0x00363636, 0x00545454, 0x006E6E6E, 0x00868686, 0x007D7D7D, 0x000C0C0C, 0x00090909, 0x00404041, 0x00777778, 0x00979899, 0x00B0B1B2, 0x00B9B9BA, 
        0x009C9D9D, 0x00A4A4A4, 0x00D7D7D7, 0x00BABABA, 0x00ABABAB, 0x00B6B6B6, 0x00CDCDCD, 0x00DCDCDC, 0x00AFAFAF, 0x00757575, 0x00717171, 0x00535353, 0x00010101, 0x3A000000, 0xE1000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xF8000000, 0xB6262626, 0x00292929, 0x00010101, 0x00010101, 0x00585858, 0x00797979, 0x00555555, 0x006C6C6C, 0x00827268, 0x00BF7042, 0x00C98660, 0x00C98660, 0x00C98660, 0x00C98660, 0x00C98660, 0x00C98660, 0x00C98660, 0x00C98660, 0x00C8845E, 0x00BC693A, 
        0x00AB4307, 0x00A93E01, 0x00A5430C, 0x00727272, 0x00616161, 0x00525252, 0x00666666, 0x00292929, 0x003F3F3F, 0x005C5C5C, 0x00767676, 0x008C8C8C, 0x004A4A4A, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x000F0F0F, 0x00444545, 0x007E7F80, 
        0x009D9D9E, 0x00A6A7A7, 0x00ADADAD, 0x00C6C6C7, 0x00C5C5C5, 0x00BFBFBF, 0x00A2A2A2, 0x00797979, 0x00666666, 0x00666666, 0x00666666, 0x00454545, 0x00010101, 0x47010101, 0xE3000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xF8000000, 0xB6252525, 0x00282828, 0x00010101, 0x00010101, 0x005C5C5C, 0x007E7E7E, 0x00575757, 0x006D6D6D, 0x0084736A, 0x00B9612F, 0x00C07245, 0x00C07245, 0x00C07245, 0x00C07245, 0x00C17345, 0x00C17346, 0x00C17245, 0x00BD6A3B, 0x00B2521B, 0x00AA3F03, 
        0x00A93E01, 0x00A93E01, 0x00A5440C, 0x00747474, 0x00626262, 0x00545454, 0x006B6B6B, 0x00333333, 0x00474747, 0x00636363, 0x007C7C7C, 0x00848484, 0x00171717, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00050505, 
        0x00171718, 0x003A3A3A, 0x00696969, 0x00606060, 0x005C5C5C, 0x005C5C5C, 0x005C5C5C, 0x005C5C5C, 0x005C5C5C, 0x005C5C5C, 0x005C5C5C, 0x00393939, 0x00010101, 0x53010101, 0xE6000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xF8000000, 0xB6242424, 0x00272727, 0x00010101, 0x00010101, 0x00606060, 0x00838383, 0x00575757, 0x006D6D6D, 0x00837369, 0x00B2531C, 0x00B75D29, 0x00B85E2B, 0x00BA622E, 0x00BC6531, 0x00BE6733, 0x00BC632E, 0x00B7581F, 0x00B04A0E, 0x00AD4306, 0x00AB4003, 
        0x00A93E01, 0x00A93E01, 0x00A5440C, 0x00737373, 0x00616161, 0x00545454, 0x00707070, 0x003C3C3C, 0x004F4F4F, 0x006B6B6B, 0x00838383, 0x005E5E5E, 0x00020202, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 
        0x00010101, 0x001C1C1C, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x00323232, 0x01010101, 0x78000000, 0xEA000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xF8000000, 0xB6232323, 0x00262626, 0x00010101, 0x00010101, 0x00646464, 0x00888888, 0x00555555, 0x006A6A6A, 0x00817066, 0x00AD450A, 0x00B14D13, 0x00B55419, 0x00B9591E, 0x00BB5C20, 0x00BB5B1E, 0x00BB591B, 0x00B95719, 0x00B75416, 0x00B55012, 0x00B14A0D, 
        0x00AD4306, 0x00A93F02, 0x00A4430C, 0x00707070, 0x005F5F5F, 0x004F4F4F, 0x00737373, 0x00444444, 0x00575757, 0x00727272, 0x00747474, 0x00171717, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 
        0x00010101, 0x00181818, 0x00454545, 0x00454545, 0x00454545, 0x00454545, 0x00454545, 0x00454545, 0x00454545, 0x00454545, 0x00454545, 0x00242424, 0x0D010101, 0xAC000000, 0xF1000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xF8000000, 0xB6222222, 0x00252525, 0x00010101, 0x00010101, 0x00686868, 0x008E8E8E, 0x00525252, 0x00656565, 0x007D6D63, 0x00AF470A, 0x00B45012, 0x00B95819, 0x00BD5E1F, 0x00C06323, 0x00C26626, 0x00C36727, 0x00C26526, 0x00C06223, 0x00BD5D1E, 0x00B95718, 
        0x00B44F11, 0x00AC4A10, 0x0098532C, 0x006C6C6C, 0x005A5A5A, 0x004B4B4B, 0x00777777, 0x00333333, 0x00393939, 0x003D3D3D, 0x00141414, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 
        0x00010101, 0x00141414, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00353535, 0x00090909, 0x4F000000, 0xD2000000, 0xF8000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xF8000000, 0xB6212121, 0x00262626, 0x00010101, 0x00010101, 0x006C6C6C, 0x00949494, 0x004E4E4E, 0x005E5E5E, 0x0077675E, 0x00B55214, 0x00BC5B1D, 0x00C16425, 0x00C56B2C, 0x00C97131, 0x00CB7434, 0x00CB7536, 0x00C97638, 0x00C5763E, 0x00BB7E55, 0x00B0896F, 
        0x00A89589, 0x00A3A3A3, 0x00A7A7A7, 0x00A4A4A4, 0x007A7A7A, 0x004D4D4D, 0x007D7D7D, 0x1E222222, 0x59080808, 0x3E0C0C0C, 0x150B0B0B, 0x03070707, 0x00020202, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 
        0x00010101, 0x000F0F0F, 0x002A2A2A, 0x002A2A2A, 0x002A2A2A, 0x002A2A2A, 0x002A2A2A, 0x002A2A2A, 0x00292929, 0x001D1D1D, 0x02070707, 0x35000000, 0xB3000000, 0xEA000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xF8000000, 0xBB1B1B1B, 0x0B282828, 0x00010101, 0x00010101, 0x007D7D7D, 0x00989898, 0x00484848, 0x00555555, 0x00706157, 0x00BC5B1D, 0x00C26627, 0x00C77031, 0x00C9793D, 0x00C9824C, 0x00C29069, 0x00C0A087, 0x00BFB1A6, 0x00C1BFBF, 0x00C3C3C3, 0x00C0C0C0, 
        0x00B0B0B0, 0x00969696, 0x00818181, 0x00737373, 0x00757575, 0x00848484, 0x00838383, 0x2F212121, 0xAB010101, 0xAF000000, 0x96000000, 0x68050505, 0x31070707, 0x0D050505, 0x01020202, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 
        0x00010101, 0x000A0A0A, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001A1A1A, 0x00171717, 0x040F0F0F, 0x0F050505, 0x28000000, 0x5C000000, 0xAC000000, 0xDF000000, 0xF9000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xF9000000, 0xC0191919, 0x10292929, 0x00010101, 0x00010101, 0x00818181, 0x00999999, 0x00414141, 0x004B4B4B, 0x00665951, 0x00B16634, 0x00AB7853, 0x00AA8D77, 0x00B0A398, 0x00B9B8B7, 0x00C2C2C2, 0x00C0C0C0, 0x00B5B5B5, 0x00A2A2A2, 0x00949494, 0x00898989, 
        0x00878787, 0x008E8E8E, 0x008F8F8F, 0x008C8C8C, 0x00808080, 0x01646464, 0x133B3B3B, 0x73101010, 0xDB000000, 0xEB000000, 0xDC000000, 0xC5000000, 0xA9000000, 0x84010101, 0x53020202, 0x26020202, 0x0C010101, 0x02010101, 0x00010101, 0x00010101, 
        0x00010101, 0x00030303, 0x00090909, 0x02080808, 0x0E060606, 0x23030303, 0x45000000, 0x68000000, 0x8C000000, 0xA6000000, 0xC1000000, 0xE2000000, 0xF8000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFA000000, 0xC9121212, 0x202D2D2D, 0x00010101, 0x00010101, 0x00818181, 0x00999999, 0x003A3A3A, 0x00434343, 0x00767574, 0x009F9D9B, 0x00A9A9A9, 0x00A6A6A6, 0x009F9F9F, 0x00939393, 0x008E8E8E, 0x008E8E8E, 0x00909090, 0x00969696, 0x00989898, 0x00979797, 
        0x008C8C8C, 0x007A7A7A, 0x025D5D5D, 0x113E3E3E, 0x2A222222, 0x570C0C0C, 0x8D040404, 0xC8000000, 0xF1000000, 0xFE000000, 0xFB000000, 0xF4000000, 0xE7000000, 0xD3000000, 0xBB000000, 0xA3000000, 0x7F000000, 0x62000000, 0x47000000, 0x3C000000, 
        0x3C000000, 0x3C000000, 0x47000000, 0x62000000, 0x83000000, 0xA1000000, 0xB4000000, 0xC7000000, 0xD8000000, 0xE5000000, 0xF2000000, 0xFB000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFC000000, 0xD6080808, 0x34303030, 0x00050505, 0x00010101, 0x00818181, 0x00999999, 0x00464646, 0x00595959, 0x00737373, 0x00707070, 0x00747474, 0x00838383, 0x008C8C8C, 0x00969696, 0x00999999, 0x00989898, 0x00888888, 0x00777777, 0x025F5F5F, 0x10434343, 
        0x252C2C2C, 0x45151515, 0x690A0A0A, 0x87040404, 0xA5000000, 0xBD000000, 0xD7000000, 0xEE000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0xF9000000, 0xF0000000, 0xE3000000, 0xD3000000, 0xC3000000, 0xB7000000, 0xB1000000, 
        0xB0000000, 0xB1000000, 0xB7000000, 0xC4000000, 0xD4000000, 0xE3000000, 0xEE000000, 0xF5000000, 0xFB000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFD000000, 0xE1000000, 0x572C2C2C, 0x000C0C0C, 0x00010101, 0x00818181, 0x00999999, 0x006F6F6F, 0x00767676, 0x00888888, 0x00939393, 0x00999999, 0x00979797, 0x00858585, 0x00717171, 0x03565656, 0x17393939, 0x30272727, 0x4E161616, 0x700A0A0A, 0x88050505, 
        0xA0010101, 0xB4000000, 0xC6000000, 0xD7000000, 0xE5000000, 0xF1000000, 0xFA000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0xFA000000, 0xF5000000, 0xF0000000, 0xED000000, 
        0xEC000000, 0xED000000, 0xF0000000, 0xF5000000, 0xFA000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFE000000, 0xEB000000, 0x8B222222, 0x03212121, 0x00040404, 0x00818181, 0x00999999, 0x00999999, 0x008F8F8F, 0x00797979, 0x00656565, 0x024D4D4D, 0x17333333, 0x36242424, 0x56151515, 0x7B080808, 0x92040404, 0xA8000000, 0xB9000000, 0xC9000000, 0xD7000000, 
        0xE4000000, 0xEE000000, 0xF6000000, 0xFB000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xF5000000, 0xC9010101, 0x6F1C1C1C, 0x18282828, 0x024B4B4B, 0x03494949, 0x09343434, 0x1E282828, 0x3C222222, 0x5D141414, 0x81060606, 0x98020202, 0xAC000000, 0xBE000000, 0xCF000000, 0xDD000000, 0xE9000000, 0xF1000000, 0xF8000000, 0xFB000000, 
        0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFC000000, 0xEA000000, 0xC5000000, 0x98060606, 0x70141414, 0x7C0A0A0A, 0x92000000, 0xA0000000, 0xB1000000, 0xC2000000, 0xD2000000, 0xDF000000, 0xEA000000, 0xF3000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFC000000, 0xF1000000, 0xDE000000, 0xCF000000, 0xD0000000, 0xD9000000, 0xE3000000, 0xEC000000, 0xF4000000, 0xFA000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFB000000, 0xF9000000, 0xF9000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000
};

static GUI_CONST_STORAGE unsigned long _acwizard[] = {
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000102, 0xFF044056, 0xFF0A5470, 0xFF1697C6, 0xFF21C2FA, 0xF41DC1FB, 0xFF1FC2FB, 0xFF128EBA, 0xFF000305, 0xFF000101, 0xFF000000, 0xFF000000, 0xFF010101, 0xFF313131, 0xFFD0D0D0, 0xFED7D7D7, 0xD6D7D7D7, 0x8CD5D5D5, 0x93CFCFCF, 0xE6C4C4C4, 
        0xFFBBBBBB, 0xFFA0A0A0, 0xFF0B0B0B, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000203, 0xFF109BD1, 0xFF23B7F2, 0xFE21B9F4, 0xE31DBBF7, 0x2828C4FB, 0xF417BAF8, 0xFF20B8F3, 0xFF1478A2, 0xFF022738, 0xFF000101, 0xFF010101, 0xFF1A1A1A, 0xFFC1C1C1, 0xFED6D6D6, 0xABD7D7D7, 0x0BDADADA, 0x02D8D8D8, 0x03CCCCCC, 0x1CBEBEBE, 
        0xDFB5B5B5, 0xFFADADAD, 0xFF262626, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000001, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000204, 0xFF0C99D2, 0xA214B2F3, 0x4625B8F4, 0x1D20B9F5, 0x0402B2F6, 0x9021B7F4, 0xFD18ACEF, 0xFF1CAAEB, 0xFF0878AE, 0xFF010203, 0xFF0A0A0A, 0xFFA6A6A6, 0xFFD6D6D6, 0xCCD6D6D6, 0x0CD9D9D9, 0x02D3D3D3, 0x01C8C8C8, 0x02B9B9B9, 0x03B3B3B3, 
        0x77B2B2B2, 0xFEADADAD, 0xFF363636, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000001, 0xFF00151C, 0xFF003040, 0xFF003041, 0xFF003040, 0xFF000A0C, 0xFF000001, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000203, 0xFF0B96D1, 0xEF0EA6ED, 0x1A00A1EC, 0x0100A1EC, 0x0100A1EC, 0x030EA5ED, 0x351FACEE, 0xF613A6EB, 0xFF077AB0, 0xFF030607, 0xFF8B8B8B, 0xFFD5D5D5, 0xE4D7D7D7, 0x20D9D9D9, 0x01D4D4D4, 0x01CACACA, 0x01BCBCBC, 0x01B0B0B0, 0x02ACACAC, 
        0x5EAEAEAE, 0xFEACACAC, 0xFF363636, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000102, 0xFF096B8C, 0xFF22C0F7, 0xFF20C1F8, 0xFF22C0F7, 0xFF0D8BB7, 0xFF000608, 0xFF000102, 0xFF000101, 0xFF000001, 
        0xFF000203, 0xFF045E8D, 0xFD0896E3, 0x350B96E5, 0x020090E2, 0x020090E2, 0x2D0091E3, 0xDF0698E5, 0xFF11A2E9, 0xFF097AB0, 0xFF636565, 0xFFD5D5D5, 0xF5D7D7D7, 0x3DD8D8D8, 0x02D5D5D5, 0x02CCCCCC, 0x01BEBEBE, 0x01B1B1B1, 0x02ACACAC, 0x03ABABAB, 
        0x9DACACAC, 0xFFAAAAAA, 0xFF333333, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000304, 0xFF1190BD, 0xED20C1F9, 0x7C2CC5FB, 0xFD26C2FA, 0xFF29C0F7, 0xFF097AA3, 0xFF03455E, 0xFF04445E, 0xFF01425C, 
        0xFF000304, 0xFF05476F, 0xE30A8EDE, 0x2D0A8EDF, 0x5A0088DD, 0x120087DD, 0x7B0088DE, 0xFE008BDD, 0xFF027ABC, 0xFF426070, 0xFFD2D3D3, 0xFED7D7D7, 0x62D8D8D8, 0x03D7D7D7, 0x01CFCFCF, 0x01C0C0C0, 0x01B3B3B3, 0x01ACACAC, 0x03ABABAB, 0x49ABABAB, 
        0xFAABABAB, 0xFFA6A6A6, 0xFF131313, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000001, 0xFF000203, 0xFF012E41, 0xFF19B6F3, 0xB61EBEF9, 0x0422C1FA, 0x752FC3F9, 0xFC2DBEF6, 0xFE3ABFF4, 0xFE34BDF3, 0xFF2DBBF3, 0xFF15B1EF, 
        0xFF000305, 0xFF04456D, 0xFF0889D9, 0xFE0488DA, 0xFD0187DB, 0xD60086DC, 0xB80087DD, 0xFF0186DB, 0xFF203541, 0xFFCBCCCD, 0xFED6D7D7, 0x8DD7D7D7, 0x02D8D8D8, 0x01D0D0D0, 0x01C2C2C2, 0x01B5B5B5, 0x01ADADAD, 0x01ACACAC, 0x2AABABAB, 0xECABABAB, 
        0xFFAAAAAA, 0xFF666666, 0xFF010101, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000001, 0xFF011C29, 0xFF1174A2, 0xFF29ACE7, 0xFE28B6F1, 0x791EB8F5, 0x0301B1F5, 0x031DB8F6, 0x3A3EC2F6, 0x5841C2F5, 0x3D3EC2F6, 0xA519B6F4, 0xFF0FAFEF, 
        0xFF000305, 0xFF001522, 0xFF002A45, 0xFF002C49, 0xFF0064A5, 0xFF0083D7, 0xFF0185DA, 0xFF0B89D9, 0xFFB7BFC4, 0xFED6D6D6, 0xB6D6D6D6, 0x08D9D9D9, 0x02D2D2D2, 0x01C4C4C4, 0x01B7B7B7, 0x01ADADAD, 0x02ABABAB, 0x12ABABAB, 0xD5AAAAAA, 0xFFA9A9A9, 
        0xFF858585, 0xFF060606, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000102, 0xFF0A7CB7, 0xFF2CACEA, 0xF827ADED, 0x9A2EB4F0, 0x0D25B4F1, 0x0200A7F0, 0x0100A7EF, 0x0201A7EF, 0x0303A8EF, 0x1301A7F0, 0xE312ADF0, 0xFF0EAEEF, 
        0xFF000304, 0xFF000000, 0xFF000001, 0xFF000101, 0xFF000306, 0xFF000A11, 0xFF050F16, 0xFF9EA6AC, 0xFFD6D7D7, 0xD7D6D6D6, 0x15D9D9D9, 0x01D3D3D3, 0x02C7C7C7, 0x01B9B9B9, 0x01AEAEAE, 0x02ABABAB, 0x06ABABAB, 0xB4ABABAB, 0xFEAAAAAA, 0xFF969696, 
        0xFF101010, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000203, 0xFF097EBA, 0xCC1AA4E9, 0x1C3BB5EF, 0x0220A8EB, 0x01009CE9, 0x01009CE9, 0x01009BE9, 0x01009BE9, 0x01009CE9, 0x81019DE9, 0xFE06A0EA, 0xFF0288C2, 
        0xFF000203, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF020202, 0xFF797A7A, 0xFFD5D5D5, 0xEED7D7D7, 0x29D9D9D9, 0x01D4D4D4, 0x01C9C9C9, 0x01BBBBBB, 0x01B0B0B0, 0x01ACACAC, 0x03ABABAB, 0x8AABABAB, 0xFEABABAB, 0xFFA4A4A4, 0xFF232323, 
        0xFF010101, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000102, 0xFF087DB9, 0xF81BA2E8, 0x8D0797E5, 0x140091E3, 0x020090E2, 0x020090E2, 0x010091E2, 0x010090E2, 0x030090E2, 0xA00F98E4, 0xFE139AE3, 0xFF07517D, 
        0xFF000203, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF010101, 0xFF2E2E2E, 0xFFAEAEAE, 0xFACCCCCC, 0x4CD8D8D8, 0x02D6D6D6, 0x02CCCCCC, 0x01BDBDBD, 0x01B1B1B1, 0x02ACACAC, 0x02ACACAC, 0x5FABABAB, 0xFDAAAAAA, 0xFFA9A9A9, 0xFF3B3B3B, 0xFF010101, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000101, 0xFF013D5E, 0xFF0288D2, 0xFE008FE0, 0xD6008ADE, 0x0F0088DD, 0x020088DD, 0x010088DD, 0x020088DD, 0x030088DD, 0x49209BE3, 0xFE1594E0, 0xFF0971B2, 
        0xFF000103, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1B1B1B, 0xFF6F6F6F, 0xFE868686, 0x76B6B6B6, 0x03D6D6D6, 0x01CECECE, 0x01C0C0C0, 0x01B3B3B3, 0x02ACACAC, 0x02ABABAB, 0x39ABABAB, 0xF5AAAAAA, 0xFFA9A9A9, 0xFF5C5C5C, 0xFF020202, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000102, 0xFF00121D, 0xFF0066A5, 0xFE0086DB, 0x490087DC, 0x020087DC, 0x0D0087DC, 0x450087DC, 0x2A0087DD, 0x0C1291DF, 0xDC1090DF, 0xFF0870B2, 
        0xFF000203, 0xFF000000, 0xFF000000, 0xFF0F0F0F, 0xFF676767, 0xFE727272, 0xA0747474, 0x04717171, 0x01989898, 0x01C0C0C0, 0x01B4B4B4, 0x01ACACAC, 0x01ACACAC, 0x1FABABAB, 0xE3ABABAB, 0xFFAAABAC, 0xFF737E82, 0xFF041217, 0xFF000E13, 0xFF000A0C, 
        0xFF000101, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000001, 0xFF001B2C, 0xFE0084D9, 0x620086DC, 0x210086DC, 0xD30086DC, 0xFD0085DB, 0xFD0387DB, 0xE90587DA, 0xFC098ADB, 0xFF066EB0, 
        0xFF000102, 0xFF000000, 0xFF030303, 0xFF5B5B5B, 0xFF737373, 0xC66C6C6C, 0x0B727272, 0x023E3E3E, 0x01212121, 0x015F5F5F, 0x01A8A8A8, 0x01ABABAB, 0x0DAAAAAA, 0xC7AAAAAA, 0xFFAAABAB, 0xFF889093, 0xFF12B6F0, 0xFF0ABCFA, 0xFF0ABBF9, 0xFF08AEE8, 
        0xFF00202B, 0xFF000203, 0xFF000102, 0xFF000001, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000203, 0xFF0083D7, 0xCA0085DA, 0xE10085DA, 0xFF0085DA, 0xFF0079C7, 0xFF003C64, 0xFF003B60, 0xFF003B60, 0xFF002F4D, 
        0xFF000101, 0xFF010101, 0xFF4B4B4B, 0xFF727272, 0xE26B6B6B, 0x1E767676, 0x01444444, 0x02222222, 0x01121212, 0x01121212, 0x02404040, 0x039F9F9F, 0xA39F9F9F, 0xFEA8A9A9, 0xFF9C9E9F, 0xFF1A5469, 0xFF12BCF9, 0xC410BEFC, 0xDE12BEFB, 0xFF18BDF9, 
        0xFF0BA4DC, 0xFF05668B, 0xFF026389, 0xFF001F2B, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000102, 0xFF005D99, 0xFF0063A2, 0xFF0063A2, 0xFF005B95, 0xFF000D15, 0xFF000102, 0xFF000101, 0xFF000101, 0xFF000001, 
        0xFF010101, 0xFF393939, 0xFF727272, 0xF46B6B6B, 0x38757575, 0x014B4B4B, 0x01252525, 0x01131313, 0x01111111, 0x01111111, 0x02121212, 0x78333333, 0xFE717172, 0xFF9BA6AA, 0xFF307B9C, 0xFF10A4E1, 0xFE14B7F5, 0x4B1ABEFA, 0x2E21C1FA, 0xDE14B8F7, 
        0xFB17B6F5, 0xFB15B4F4, 0xFF0BAFF1, 0xFF004C6A, 0xFF000101, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000102, 0xFF000103, 0xFF000103, 0xFF000102, 0xFF000001, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF010101, 
        0xFF252525, 0xFF6F6F6F, 0xFD6C6C6C, 0x5B737373, 0x03545454, 0x02292929, 0x01141414, 0x01111111, 0x02101010, 0x02101010, 0x4E111111, 0xFA171717, 0xFF28292A, 0xFF317B9D, 0xFF12A7EB, 0xFE16ACEF, 0xBE12B0F2, 0x0A12B5F5, 0x0306B2F5, 0x0A21B9F5, 
        0x1F20B8F5, 0x5D0DB2F4, 0xFF07ADF1, 0xFF004D6B, 0xFF000102, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF181818, 
        0xFF696969, 0xFE6D6D6D, 0x886F6F6F, 0x025E5E5E, 0x012D2D2D, 0x01161616, 0x01111111, 0x01111111, 0x01101010, 0x2D101010, 0xEE111111, 0xFF101010, 0xFF0A0B0C, 0xFF005076, 0xF60BA2EB, 0x4718ABEE, 0x081DAEEF, 0x0100A4ED, 0x0100A4EE, 0x0100A4EE, 
        0x0200A4EE, 0xC607A6EE, 0xFF06A9EE, 0xFF004B6A, 0xFF000101, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF0C0C0C, 0xFF5F5F5F, 
        0xFE6E6E6E, 0xB16A6A6A, 0x06666666, 0x01313131, 0x01171717, 0x01111111, 0x01111111, 0x02101010, 0x15101010, 0xDA101010, 0xFF0F0F0F, 0xFF0B0B0B, 0xFF000102, 0xFF004F75, 0xFF0BA1E9, 0x9B049CE8, 0x100097E6, 0x010097E6, 0x010097E6, 0x020097E6, 
        0x170499E7, 0xFD0599E7, 0xFF0396E3, 0xFF001722, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF050505, 0xFF515151, 0xFF6E6E6E, 
        0xD2676767, 0x126D6D6D, 0x02373737, 0x011A1A1A, 0x01111111, 0x01101010, 0x01101010, 0x08101010, 0xB8101010, 0xFE101010, 0xFF0D0D0D, 0xFF010101, 0xFF000001, 0xFF002538, 0xFF018DD4, 0xFE0092E2, 0x99008DE0, 0x02008BDF, 0x02008BDF, 0x03008BDF, 
        0x051194E1, 0xD8058FE0, 0xFF0389DB, 0xFF000A10, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF010101, 0xFF414141, 0xFF6E6E6E, 0xED656565, 
        0x266F6F6F, 0x013D3D3D, 0x011D1D1D, 0x01111111, 0x01111111, 0x01101010, 0x03101010, 0x90101010, 0xFE101010, 0xFF0F0F0F, 0xFF030303, 0xFF000000, 0xFF000000, 0xFF000101, 0xFF001623, 0xFF007FCC, 0xCF0086DC, 0x040087DD, 0x570087DD, 0x9F0088DD, 
        0x710188DD, 0xC3048ADD, 0xFF0387DA, 0xFF000A10, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF010101, 0xFF2C2C2C, 0xFF6D6D6D, 0xF8656565, 0x476E6E6E, 
        0x02454545, 0x021F1F1F, 0x01111111, 0x01111111, 0x02101010, 0x03101010, 0x65101010, 0xFE0F0F0F, 0xFF0F0F0F, 0xFF050505, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000103, 0xFF005389, 0xF20085DA, 0xA60086DC, 0xFE0085DA, 0xFE0085D9, 
        0xFF0085D9, 0xFF0084D8, 0xFF007DCD, 0xFF00070C, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF6A6A6A, 0xFE656565, 0x6F6B6B6B, 0x034F4F4F, 
        0x01232323, 0x01121212, 0x01101010, 0x01101010, 0x02101010, 0x3F101010, 0xF7101010, 0xFF0F0F0F, 0xFF080808, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000001, 0xFF003E67, 0xFF0073BC, 0xFF0074BD, 0xFF0073BD, 0xFF003E66, 
        0xFF00121E, 0xFF00111E, 0xFF000C14, 0xFF000001, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF101010, 0xFF636363, 0xFE666666, 0x9A666666, 0x04595959, 0x01272727, 
        0x01131313, 0x01111111, 0x01101010, 0x01101010, 0x21101010, 0xE6101010, 0xFF101010, 0xFF0A0A0A, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000101, 0xFF000103, 0xFF000203, 0xFF000103, 0xFF000102, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF070707, 0xFF545454, 0xFE666666, 0xC1616161, 0x08606060, 0x022A2A2A, 0x01141414, 
        0x01111111, 0x01101010, 0x02101010, 0x0F101010, 0xCC101010, 0xFF0F0F0F, 0xFF0C0C0C, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF020202, 0xFF474747, 0xFF656565, 0xDD5E5E5E, 0x1A656565, 0x012F2F2F, 0x02161616, 0x01111111, 
        0x01111111, 0x02101010, 0x04101010, 0xA9101010, 0xFE0F0F0F, 0xFF0E0E0E, 0xFF010101, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF010101, 0xFF323232, 0xFF646464, 0xF35C5C5C, 0x34656565, 0x01383838, 0x01181818, 0x01111111, 0x01111111, 
        0x01101010, 0x02101010, 0x7D101010, 0xFE101010, 0xFF0F0F0F, 0xFF040404, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF222222, 0xFF626262, 0xFD5B5B5B, 0x55646464, 0x033F3F3F, 0x021B1B1B, 0x01111111, 0x01101010, 0x02101010, 
        0x02101010, 0x54101010, 0xFC0F0F0F, 0xFF0F0F0F, 0xFF060606, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF111111, 0xFF5D5D5D, 0xFE5B5B5B, 0x815F5F5F, 0x02494949, 0x021D1D1D, 0x01111111, 0x01111111, 0x02101010, 0x02101010, 
        0x32101010, 0xF0101010, 0xFF0F0F0F, 0xFF080808, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF080808, 0xFF535353, 0xFE5C5C5C, 0xAC595959, 0x06535353, 0x01212121, 0x01121212, 0x01111111, 0x01101010, 0x01101010, 0x17101010, 
        0xDC101010, 0xFF101010, 0xFF0B0B0B, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF030303, 0xFF474747, 0xFF5B5B5B, 0xCE555555, 0x0F595959, 0x02252525, 0x01121212, 0x01101010, 0x01101010, 0x01101010, 0x09101010, 0xBE101010, 
        0xFE101010, 0xFF0D0D0D, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF010101, 0xFF363636, 0xFF5A5A5A, 0xE9535353, 0x225B5B5B, 0x022B2B2B, 0x02141414, 0x01111111, 0x01101010, 0x02101010, 0x04101010, 0x96101010, 0xFE0F0F0F, 
        0xFF0F0F0F, 0xFF020202, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF272727, 0xFF575757, 0xF8525252, 0x435A5A5A, 0x02323232, 0x01151515, 0x01111111, 0x01111111, 0x01101010, 0x02101010, 0x6A101010, 0xFE101010, 0xFF101010, 
        0xFF040404, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF171717, 0xFF545454, 0xFD515151, 0x68575757, 0x023B3B3B, 0x02171717, 0x01111111, 0x01101010, 0x01101010, 0x03101010, 0x44101010, 0xF9101010, 0xFF0F0F0F, 0xFF080808, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF0D0D0D, 0xFF4D4D4D, 0xFE515151, 0x94525252, 0x03454545, 0x01191919, 0x01111111, 0x01101010, 0x02101010, 0x01101010, 0x25101010, 0xE90F0F0F, 0xFF101010, 0xFF090909, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF030303, 0xFF444444, 0xFE515151, 0xBD4C4C4C, 0x074E4E4E, 0x021C1C1C, 0x01111111, 0x01101010, 0x01101010, 0x02101010, 0x10101010, 0xCF101010, 0xFF0F0F0F, 0xFF0C0C0C, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF010101, 0xFF383838, 0xFF515151, 0xDA494949, 0x17525252, 0x011F1F1F, 0x01111111, 0x01111111, 0x01101010, 0x01101010, 0x05101010, 0xAF101010, 0xFE101010, 0xFF0E0E0E, 0xFF010101, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF2A2A2A, 0xFF4F4F4F, 0xEF484848, 0x30515151, 0x02272727, 0x01121212, 0x01101010, 0x01101010, 0x02101010, 0x03101010, 0x83101010, 0xFE101010, 0xFF0F0F0F, 0xFF030303, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF121212, 0xFF484848, 0xFD474747, 0x50505050, 0x022F2F2F, 0x01131313, 0x01111111, 0x01101010, 0x01101010, 0x02101010, 0x58101010, 0xFC101010, 0xFF101010, 0xFF060606, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF202020, 0xFE3E3E3E, 0x7E484848, 0x02373737, 0x02141414, 0x01111111, 0x01101010, 0x02101010, 0x01101010, 0x36101010, 0xF30F0F0F, 0xFF0F0F0F, 0xFF080808, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF1B1B1B, 0xE9323232, 0x0C3A3A3A, 0x01161616, 0x01111111, 0x01101010, 0x01101010, 0x02101010, 0x1A111111, 0xE0101010, 0xFF111111, 0xFF0D0D0D, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 
        0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF020202, 0xFF020202, 0xFF020202, 0xFF1A1A1A, 0xC9252525, 0x031B1B1B, 0x01111111, 0x01111111, 0x01101010, 0x01111111, 0x0A111111, 0xC21C1C1C, 0xFE2D2D2D, 0xFF525252, 0xFF5C5C5C, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 
        0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF5B5B5B, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF3D3D3D, 0xFF393939, 
        0xFF202020, 0xFF1F1F1F, 0xFF1F1F1F, 0xFF040404, 0xFF020202, 0xFF020202, 0xFF020202,
  0xFF616161, 0xFF838383, 0xFF999999, 0xFF858585, 0xEC494949, 0x10131313, 0x01111111, 0x02101010, 0x02101010, 0x04121212, 0x9C333333, 0xFD676767, 0xFE8D8D8D, 0xFEA0A0A0, 0xFEA1A1A1, 0xFDA2A2A2, 0xFCA1A1A1, 0xFCA1A1A1, 0xFCA2A2A2, 0xFCA1A1A1, 0xFCA1A1A1, 
        0xFCA2A2A2, 0xFCA1A1A1, 0xFCA1A1A1, 0xFCA2A2A2, 0xFCA1A1A1, 0xFCA1A1A1, 0xFCA2A2A2, 0xFCA1A1A1, 0xFCA1A1A1, 0xFCA2A2A2, 0xFCA1A1A1, 0xFDA2A2A2, 0xFEA1A1A1, 0xFEA1A1A1, 0xFEA2A2A2, 0xFEA1A1A1, 0xFEA1A1A1, 0xFFA2A2A2, 0xFFA1A1A1, 0xFFA0A0A0, 
        0xFFA1A1A1, 0xFFA0A0A0, 0xFFA0A0A0, 0xFFA1A1A1, 0xFF9E9E9E, 0xFF838383, 0xFF6D6D6D,
  0xFFA2A2A2, 0xFEA2A2A2, 0xFAA2A2A2, 0xF79F9F9F, 0xF18C8C8C, 0x91585858, 0x0A161616, 0x02121212, 0x07151515, 0x6B525252, 0xCF989898, 0xCF9E9E9E, 0xD0A2A2A2, 0xCEA2A2A2, 0xC4A3A3A3, 0xBAA3A3A3, 0xB9A3A3A3, 0xB9A3A3A3, 0xB9A3A3A3, 0xB9A3A3A3, 0xB9A3A3A3, 
        0xB9A3A3A3, 0xB9A3A3A3, 0xB9A3A3A3, 0xB9A3A3A3, 0xB9A3A3A3, 0xB9A3A3A3, 0xB9A3A3A3, 0xB9A3A3A3, 0xB9A3A3A3, 0xB9A3A3A3, 0xB9A3A3A3, 0xBAA3A3A3, 0xC4A3A3A3, 0xCEA3A3A3, 0xD0A3A3A3, 0xD0A3A3A3, 0xD1A3A3A3, 0xDAA3A3A3, 0xE0A3A3A3, 0xE2A3A3A3, 
        0xE7A3A3A3, 0xEEA3A3A3, 0xF2A3A3A3, 0xF7A3A3A3, 0xFAA2A2A2, 0xFEA2A2A2, 0xFFA2A2A2,
  0xF8A3A3A3, 0xD4A3A3A3, 0xAFA3A3A3, 0x98A3A3A3, 0x84A3A3A3, 0x76A2A2A2, 0x58929292, 0x387E7E7E, 0x4B919191, 0x4EA2A2A2, 0x43A3A3A3, 0x40A3A3A3, 0x40A3A3A3, 0x3FA3A3A3, 0x36A3A3A3, 0x2DA3A3A3, 0x2CA3A3A3, 0x2CA3A3A3, 0x2CA3A3A3, 0x2BA3A3A3, 0x2BA3A3A3, 
        0x2BA3A3A3, 0x2BA3A3A3, 0x2BA3A3A3, 0x2BA3A3A3, 0x2BA3A3A3, 0x2BA3A3A3, 0x2BA3A3A3, 0x2BA3A3A3, 0x2CA3A3A3, 0x2CA3A3A3, 0x2CA3A3A3, 0x2DA3A3A3, 0x36A3A3A3, 0x3FA3A3A3, 0x40A3A3A3, 0x40A3A3A3, 0x43A3A3A3, 0x4FA3A3A3, 0x5AA3A3A3, 0x5CA3A3A3, 
        0x68A3A3A3, 0x77A3A3A3, 0x84A3A3A3, 0x98A3A3A3, 0xAFA3A3A3, 0xD4A3A3A3, 0xF8A3A3A3,
  0xEFA3A3A3, 0xA8A3A3A3, 0x69A3A3A3, 0x4CA3A3A3, 0x39A3A3A3, 0x2BA2A2A2, 0x24A3A3A3, 0x1DA2A2A2, 0x17A2A2A2, 0x15A3A3A3, 0x13A3A3A3, 0x0FA3A3A3, 0x0CA3A3A3, 0x0CA3A3A3, 0x0BA3A3A3, 0x0AA3A3A3, 0x0AA3A3A3, 0x0AA3A3A3, 0x08A3A3A3, 0x06A3A3A3, 0x05A3A3A3, 
        0x05A3A3A3, 0x05A3A3A3, 0x05A3A3A3, 0x05A3A3A3, 0x05A3A3A3, 0x05A3A3A3, 0x05A3A3A3, 0x06A3A3A3, 0x08A3A3A3, 0x0AA3A3A3, 0x0AA3A3A3, 0x0AA3A3A3, 0x0BA3A3A3, 0x0CA3A3A3, 0x0CA3A3A3, 0x0FA3A3A3, 0x13A3A3A3, 0x15A3A3A3, 0x17A3A3A3, 0x1DA3A3A3, 
        0x24A3A3A3, 0x2BA3A3A3, 0x39A3A3A3, 0x4CA3A3A3, 0x69A3A3A3, 0xA8A3A3A3, 0xEFA3A3A3,
  0xFCA3A3A3, 0xE9A3A3A3, 0xD4A3A3A3, 0xC3A3A3A3, 0xB5A3A3A3, 0xA5A3A3A3, 0x9CA3A3A3, 0x8FA3A3A3, 0x83A3A3A3, 0x81A3A3A3, 0x7EA3A3A3, 0x6EA3A3A3, 0x64A3A3A3, 0x63A3A3A3, 0x63A3A3A3, 0x63A3A3A3, 0x63A3A3A3, 0x60A3A3A3, 0x51A3A3A3, 0x49A3A3A3, 0x48A3A3A3, 
        0x48A3A3A3, 0x48A3A3A3, 0x48A3A3A3, 0x48A3A3A3, 0x48A3A3A3, 0x48A3A3A3, 0x48A3A3A3, 0x49A3A3A3, 0x51A3A3A3, 0x60A3A3A3, 0x63A3A3A3, 0x63A3A3A3, 0x63A3A3A3, 0x63A3A3A3, 0x64A3A3A3, 0x6EA3A3A3, 0x7EA3A3A3, 0x81A3A3A3, 0x83A3A3A3, 0x8FA3A3A3, 
        0x9CA3A3A3, 0xA5A3A3A3, 0xB5A3A3A3, 0xC3A3A3A3, 0xD4A3A3A3, 0xE9A3A3A3, 0xFCA3A3A3,
  0xFFA3A3A3, 0xFFA3A3A3, 0xFEA3A3A3, 0xFDA3A3A3, 0xFCA3A3A3, 0xFAA3A3A3, 0xF8A3A3A3, 0xF5A3A3A3, 0xF2A3A3A3, 0xF1A3A3A3, 0xEFA3A3A3, 0xE9A3A3A3, 0xE6A3A3A3, 0xE5A3A3A3, 0xE5A3A3A3, 0xE5A3A3A3, 0xE5A3A3A3, 0xE3A3A3A3, 0xDAA3A3A3, 0xD5A3A3A3, 0xD5A3A3A3, 
        0xD5A3A3A3, 0xD5A3A3A3, 0xD5A3A3A3, 0xD5A3A3A3, 0xD5A3A3A3, 0xD5A3A3A3, 0xD5A3A3A3, 0xD5A3A3A3, 0xDAA3A3A3, 0xE3A3A3A3, 0xE5A3A3A3, 0xE5A3A3A3, 0xE5A3A3A3, 0xE5A3A3A3, 0xE6A3A3A3, 0xE9A3A3A3, 0xEFA3A3A3, 0xF1A3A3A3, 0xF2A3A3A3, 0xF5A3A3A3, 
        0xF8A3A3A3, 0xFAA3A3A3, 0xFCA3A3A3, 0xFDA3A3A3, 0xFEA3A3A3, 0xFFA3A3A3, 0xFFA3A3A3
};

static GUI_CONST_STORAGE unsigned long _accapturebutton_not_pressed[] = {
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFA341601, 0xD22E1201, 
        0xA12B0F00, 0x7E2A0F00, 0x642C0F00, 0x5E290D00, 0x5E290D00, 0x642C0F00, 0x7E2A0F00, 0xA02B0F00, 0xD22E1201, 0xFA341601, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF9341601, 0xB32D1100, 0x5B2C0F00, 0x162F1000, 0x00321201, 
        0x00452513, 0x00674C3D, 0x00826B5F, 0x00917D72, 0x00907B70, 0x0080695D, 0x00664B3C, 0x00442413, 0x00321101, 0x162E1000, 0x5A2C0F00, 0xB32C1000, 0xF9331601, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF6341501, 0x982D1100, 0x242F1000, 0x00351301, 0x004D2915, 0x00876D5D, 0x00C2B3AA, 
        0x00E7E1DC, 0x00F3EFEC, 0x00F9F7F5, 0x00FCFCFB, 0x00FBF9F8, 0x00F6F2F0, 0x00EFEAE6, 0x00E3DBD6, 0x00BEAEA4, 0x00846A59, 0x004C2814, 0x00341301, 0x242E1000, 0x982C1000, 0xF6331601, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xB72F1200, 0x282F1101, 0x00391501, 0x004F270E, 0x00927663, 0x00CDBEB2, 0x00DDD1C7, 0x00E6DCD3, 
        0x00EDE6DF, 0x00F3EDE8, 0x00F7F3F0, 0x00F9F6F3, 0x00F8F5F2, 0x00F5F0EC, 0x00F0E9E3, 0x00EAE0D8, 0x00E2D6CC, 0x00D8CABF, 0x00C8B7AA, 0x008E715E, 0x004D260D, 0x00371501, 0x282E1100, 0xB72E1200, 0xFE462202, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF4361701, 0x662F1101, 0x02361401, 0x00461C01, 0x0070482B, 0x00B79E8B, 0x00CDB9A7, 0x00D8C6B5, 0x00E0D2C2, 0x00E7DBCE, 
        0x00EDE3D9, 0x00F1EAE1, 0x00F4EEE7, 0x00F6F0EA, 0x00F5F0E9, 0x00F3ECE4, 0x00EFE7DD, 0x00EADFD3, 0x00E4D6C7, 0x00DCCCBB, 0x00D3C0AD, 0x00C8B29F, 0x00B19783, 0x006D4528, 0x00441B01, 0x02341301, 0x662D1100, 0xF4351701, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xE5331501, 0x37311201, 0x003E1801, 0x00512302, 0x00855C3C, 0x00B99D83, 0x00C8AE94, 0x00D2BBA2, 0x00DBC7AF, 0x00E1D1BC, 0x00E7D9C7, 
        0x00ECE0D0, 0x00EFE5D8, 0x00F1E9DD, 0x00F2EBE0, 0x00F2EADF, 0x00F0E7DB, 0x00EDE3D4, 0x00E9DCCB, 0x00E4D5C1, 0x00DECCB5, 0x00D7C1A8, 0x00CEB59A, 0x00C3A78B, 0x00B4967B, 0x00815938, 0x004F2202, 0x003C1801, 0x362F1201, 0xE5321501, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xE1331601, 0x24331401, 0x00441C01, 0x00592802, 0x00895D37, 0x00B49371, 0x00C2A27F, 0x00CCB08E, 0x00D4BB9B, 0x00DBC5A8, 0x00E1CEB3, 0x00E5D5BE, 
        0x00E9DBC7, 0x00ECE0CD, 0x00EEE3D2, 0x00EEE4D4, 0x00EEE4D3, 0x00EDE1D0, 0x00EADECA, 0x00E7D8C2, 0x00E3D2B8, 0x00DECAAD, 0x00D8C1A0, 0x00D1B693, 0x00C8AA86, 0x00BE9C77, 0x00B08C68, 0x00855932, 0x00572702, 0x00411B01, 0x24311301, 0xE1321601, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEB361801, 0x27341401, 0x00461E01, 0x005E2C02, 0x00845224, 0x00AE875D, 0x00BB976B, 0x00C5A479, 0x00CDAF86, 0x00D4B993, 0x00D9C29F, 0x00DECAAA, 0x00E2D0B3, 
        0x00E6D6BB, 0x00E8DAC1, 0x00EADCC5, 0x00EADDC7, 0x00EADDC6, 0x00E9DBC3, 0x00E7D8BE, 0x00E4D4B7, 0x00E0CDAE, 0x00DCC7A4, 0x00D7BF98, 0x00D1B68C, 0x00CBAB7F, 0x00C29F71, 0x00B89263, 0x00A98155, 0x00805021, 0x005C2B02, 0x00441D01, 0x26321401, 
        0xEB351701, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFB401E02, 0x41341501, 0x00461E01, 0x005F2D02, 0x007B4510, 0x00A67947, 0x00B48B57, 0x00BE9864, 0x00C6A471, 0x00CDAE7D, 0x00D2B68A, 0x00D7BE94, 0x00DBC59F, 0x00DFCBA7, 
        0x00E2D0AF, 0x00E4D4B4, 0x00E6D6B8, 0x00E6D7BA, 0x00E6D7B9, 0x00E5D5B6, 0x00E3D2B1, 0x00E1CEAB, 0x00DDC9A3, 0x00DAC399, 0x00D5BB8E, 0x00D0B383, 0x00CAAA77, 0x00C4A06A, 0x00BC945D, 0x00B1874F, 0x00A27541, 0x0079440E, 0x005D2C02, 0x00441D01, 
        0x40321401, 0xFA3F1F02, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x7F351601, 0x00421C01, 0x005D2C02, 0x00753D04, 0x009A682E, 0x00AD7F43, 0x00B78C50, 0x00BF985C, 0x00C5A268, 0x00CBAB74, 0x00D0B37F, 0x00D4BA8A, 0x00D8C193, 0x00DCC69B, 
        0x00DFCAA2, 0x00E0CEA7, 0x00E2D0AA, 0x00E2D1AB, 0x00E2D0AB, 0x00E1CFA8, 0x00E0CCA4, 0x00DDC99E, 0x00DBC497, 0x00D7BE8E, 0x00D3B884, 0x00CEB079, 0x00C9A86E, 0x00C49F62, 0x00BD9555, 0x00B58949, 0x00AA7B3D, 0x00976529, 0x00743D04, 0x005B2B02, 
        0x00401B01, 0x7F331501, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xD1371801, 0x073D1A01, 0x00582902, 0x00723B03, 0x008C5412, 0x00A67331, 0x00B0813D, 0x00B88C48, 0x00BE9654, 0x00C49F5F, 0x00C9A86A, 0x00CEAF74, 0x00D2B67E, 0x00D6BC86, 0x00D9C18E, 
        0x00DBC594, 0x00DDC899, 0x00DECA9C, 0x00DFCA9D, 0x00DECA9C, 0x00DEC99A, 0x00DCC796, 0x00DAC391, 0x00D7BF8A, 0x00D4BA82, 0x00D1B479, 0x00CCAD6E, 0x00C8A564, 0x00C29D59, 0x00BD944D, 0x00B68A42, 0x00AE7E37, 0x00A3702B, 0x008A5310, 0x00703A03, 
        0x00552802, 0x073A1901, 0xD0351801, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE4B2602, 0x45391901, 0x004F2402, 0x006B3703, 0x00824805, 0x009C641D, 0x00A9752B, 0x00B18135, 0x00B78B40, 0x00BD944B, 0x00C29C55, 0x00C7A45F, 0x00CBAB69, 0x00CFB272, 0x00D3B77A, 0x00D5BC80, 
        0x00D8BF86, 0x00D9C28A, 0x00DAC48D, 0x00DBC48E, 0x00DBC48E, 0x00DAC38C, 0x00D9C188, 0x00D7BE83, 0x00D5BA7D, 0x00D2B675, 0x00CEB06D, 0x00CAAA64, 0x00C6A25A, 0x00C19B50, 0x00BC9245, 0x00B78A3B, 0x00B08030, 0x00A87426, 0x009A6319, 0x00814805, 
        0x00693603, 0x004C2302, 0x44361701, 0xFE4A2702, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xBF391A01, 0x02431E01, 0x00613003, 0x007B4304, 0x00905509, 0x00A26B1C, 0x00AA7625, 0x00B1802E, 0x00B68938, 0x00BC9242, 0x00C19A4B, 0x00C5A155, 0x00C9A85D, 0x00CDAE65, 0x00D0B36D, 0x00D2B773, 
        0x00D4BA78, 0x00D6BD7C, 0x00D7BE7E, 0x00D7BF7F, 0x00D7BF7F, 0x00D7BE7D, 0x00D6BC7A, 0x00D4B975, 0x00D2B670, 0x00CFB169, 0x00CCAC61, 0x00C8A759, 0x00C4A050, 0x00C09946, 0x00BB913C, 0x00B68933, 0x00B08029, 0x00AA7620, 0x00A16A17, 0x008F5508, 
        0x007A4304, 0x005E2F03, 0x01401D01, 0xBF371901, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x4F3C1B01, 0x00532802, 0x00713C03, 0x00884D05, 0x00995E0B, 0x00A46C16, 0x00AB771E, 0x00B07F27, 0x00B68830, 0x00BA9039, 0x00BF9741, 0x00C39E4A, 0x00C7A452, 0x00CAAA59, 0x00CDAE60, 0x00D0B265, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CDAD5C, 0x00CAA955, 0x00C6A34D, 0x00C39D45, 0x00BF973D, 0x00BA9034, 0x00B6882B, 0x00B18023, 0x00AB771A, 0x00A46D12, 0x00995F0A, 
        0x00884E05, 0x006F3B03, 0x00502702, 0x4E391A01, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xE53E1E02, 0x07431F01, 0x00623203, 0x007E4604, 0x00915606, 0x009D630A, 0x00A56E11, 0x00AA7618, 0x00B07F20, 0x00B58728, 0x00B98E30, 0x00BE9537, 0x00C29B3F, 0x00C5A147, 0x00C8A74E, 0x00CBAB54, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C8A64A, 0x00C5A143, 0x00C19B3B, 0x00BE9533, 0x00B98E2B, 0x00B58724, 0x00B07F1C, 0x00AB7715, 0x00A66F0E, 0x009E6508, 
        0x00925806, 0x007C4604, 0x005F3103, 0x07401E01, 0xE43C1E02, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x983C1C01, 0x004F2602, 0x006F3B04, 0x00884E05, 0x00985D06, 0x00A06608, 0x00A66E0C, 0x00AA7612, 0x00AF7E19, 0x00B48520, 0x00B88D27, 0x00BD942F, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B98D23, 0x00B4861C, 0x00B07F16, 0x00AB780F, 0x00A7700A, 0x00A26908, 
        0x00996007, 0x00875005, 0x006C3B04, 0x004C2502, 0x98391B01, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x52411F01, 0x005A2E03, 0x00794304, 0x008F5606, 0x009D6207, 0x00A36A08, 0x00A77009, 0x00AB760D, 0x00AF7E13, 0x00B4851A, 0x00B98D21, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B48616, 0x00B07F10, 0x00AC790B, 0x00A97309, 0x00A56E08, 
        0x009E6607, 0x00905806, 0x00774404, 0x00572D02, 0x513D1D01, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFC4D2902, 0x1C452202, 0x00643503, 0x00814A05, 0x00955B06, 0x00A06708, 0x00A56D08, 0x00A87209, 0x00AC780A, 0x00B07F0F, 0x00B58715, 0x00B98E1C, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CEAF47, 0x00CEAF46, 0x00CEAE45, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B58712, 0x00B1800D, 0x00AE7B0A, 0x00AB7609, 0x00A87109, 
        0x00A26A08, 0x00965E07, 0x00804B05, 0x00613503, 0x1C422102, 0xFC4C2A03, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xE9412102, 0x044B2502, 0x006C3B04, 0x00875005, 0x00996007, 0x00A36A08, 0x00A77009, 0x00AB760A, 0x00AF7D0C, 0x00B2830E, 0x00B68913, 0x00BB8F18, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00CDAD3E, 0x00CEAE40, 0x00CEAE40, 0x00CEAE40, 0x00CEAE3F, 0x00CDAD3D, 0x00CCAB3A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B78A11, 0x00B4850E, 0x00B07F0C, 0x00AD790A, 0x00A97409, 
        0x00A56E08, 0x009B6307, 0x00875105, 0x006A3B04, 0x03472402, 0xE93F2002, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xCB452302, 0x00502902, 0x00724004, 0x008C5506, 0x009C6407, 0x00A56D08, 0x00A9740A, 0x00AE7B0C, 0x00B2810F, 0x00B58711, 0x00B98D14, 0x00BC9217, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00CDAD39, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CCAB36, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00BA8E13, 0x00B78911, 0x00B3830E, 0x00AF7D0C, 0x00AB770A, 
        0x00A77109, 0x009E6708, 0x008C5606, 0x00704004, 0x004D2802, 0xCA422302, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xB9432202, 0x00552D03, 0x00764404, 0x008F5806, 0x009F6708, 0x00A7710A, 0x00AC780C, 0x00B17F0F, 0x00B58612, 0x00B88C15, 0x00BC9118, 0x00BF961B, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00CDAC35, 0x00CEAE37, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CDAC33, 0x00CCAA30, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00BD9217, 0x00B98D14, 0x00B68811, 0x00B2820E, 0x00AE7B0C, 
        0x00A9740A, 0x00A16A08, 0x008F5A06, 0x00744404, 0x00522C03, 0xB93F2102, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xB5412102, 0x00582F03, 0x00784605, 0x00915B07, 0x00A16A09, 0x00AA750C, 0x00AF7C0E, 0x00B38311, 0x00B78A15, 0x00BB9018, 0x00BF961C, 0x00C29A1F, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00CEAE34, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CDAC30, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00BF961B, 0x00BC9117, 0x00B88C14, 0x00B48511, 0x00B07F0E, 
        0x00AC780B, 0x00A36D09, 0x00925D07, 0x00774705, 0x00552E03, 0xB63E2002, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xB7442402, 0x00593103, 0x007A4805, 0x00935D07, 0x00A46E0B, 0x00AC780E, 0x00B18011, 0x00B68714, 0x00BA8E18, 0x00BE941C, 0x00C29A20, 0x00C59F24, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00D1B138, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D0AF35, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C29A1F, 0x00BE951B, 0x00BB8F17, 0x00B78914, 0x00B28210, 
        0x00AE7B0D, 0x00A5700A, 0x00935F07, 0x00794905, 0x00563003, 0xB7412302, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xC34A2802, 0x00583103, 0x007A4905, 0x00946009, 0x00A5710C, 0x00AE7C10, 0x00B38413, 0x00B88B17, 0x00BD921B, 0x00C09820, 0x00C49E24, 0x00C7A328, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00D4B63E, 0x00D4B63F, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D3B53D, 0x00D2B43B, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49E23, 0x00C1991F, 0x00BD931A, 0x00B98C16, 0x00B58613, 
        0x00B07E0F, 0x00A6730C, 0x00946108, 0x00784905, 0x00563003, 0xC2472702, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xE2492802, 0x01563003, 0x00794906, 0x0094610A, 0x00A6730E, 0x00B07F12, 0x00B68716, 0x00BA8E1A, 0x00BF951F, 0x00C39C23, 0x00C7A128, 0x00CAA62D, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00D7BB46, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D6B943, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C7A127, 0x00C39C22, 0x00BF961E, 0x00BB9019, 0x00B78915, 
        0x00B18111, 0x00A7750D, 0x00946209, 0x00774905, 0x01532F03, 0xE1472802, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xF7532F03, 0x13553003, 0x00764906, 0x0093610B, 0x00A6740F, 0x00B18114, 0x00B88A18, 0x00BD921D, 0x00C19922, 0x00C59F27, 0x00C9A52C, 0x00CCAA31, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00DABF4C, 0x00DBC04D, 0x00DBC04E, 0x00DBC04D, 0x00DBC04D, 0x00DABF4B, 0x00D9BE4A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C9A52B, 0x00C59F26, 0x00C19921, 0x00BD921C, 0x00B88B17, 
        0x00B28313, 0x00A7760F, 0x0092620A, 0x00744806, 0x12512E03, 0xF7512F03, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x40543004, 0x00714707, 0x0090600B, 0x00A67511, 0x00B28315, 0x00BA8C1B, 0x00BF9420, 0x00C39C25, 0x00C7A22B, 0x00CBA830, 0x00CFAE36, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC554, 0x00DEC554, 0x00DEC453, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CBA82F, 0x00C7A229, 0x00C39C24, 0x00BF951F, 0x00BA8E1A, 
        0x00B38415, 0x00A67610, 0x008F600B, 0x006F4506, 0x3F502F03, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x81523004, 0x006B4307, 0x008B5E0C, 0x00A37411, 0x00B28417, 0x00BB8F1D, 0x00C09722, 0x00C59E28, 0x00C9A52E, 0x00CDAB34, 0x00D1B13A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CDAB33, 0x00C9A52D, 0x00C59E27, 0x00C09721, 0x00BB901C, 
        0x00B38517, 0x00A37511, 0x008A5D0B, 0x00684106, 0x814F2F04, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xCF533205, 0x02623E07, 0x0085590C, 0x009F7212, 0x00B18418, 0x00BB901E, 0x00C29925, 0x00C7A12B, 0x00CBA831, 0x00CFAE37, 0x00D3B43E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CFAD36, 0x00CBA730, 0x00C6A12A, 0x00C29924, 0x00BB911E, 
        0x00B18418, 0x009F7211, 0x0083580B, 0x025F3C06, 0xCF503004, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD5D3B06, 0x325C3A06, 0x007B530B, 0x00996D12, 0x00AE8219, 0x00BB9020, 0x00C39B26, 0x00C8A32D, 0x00CDAA34, 0x00D1B03A, 0x00D5B641, 0x00D8BC48, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D4B540, 0x00D0B039, 0x00CCA932, 0x00C8A32C, 0x00C29B25, 0x00BB911F, 
        0x00AE8218, 0x00986D11, 0x0079510B, 0x31593806, 0xFD5B3A06, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x9D593907, 0x006F4A0A, 0x00906711, 0x00A87E19, 0x00B88F21, 0x00C29B28, 0x00C9A42F, 0x00CEAC36, 0x00D2B33D, 0x00D6B944, 0x00DABE4B, 0x00DDC351, 0x00E0C757, 0x00E2CB5D, 0x00E4CE62, 0x00E6D165, 
        0x00E8D369, 0x00E9D56B, 0x00E9D66C, 0x00EAD66D, 0x00EAD66D, 0x00E9D56C, 0x00E8D46A, 0x00E7D267, 0x00E5D064, 0x00E3CD5F, 0x00E1CA5B, 0x00DFC656, 0x00DCC250, 0x00D9BD49, 0x00D5B842, 0x00D2B23C, 0x00CDAB35, 0x00C9A42E, 0x00C29B27, 0x00B88F20, 
        0x00A87E18, 0x008E6510, 0x006B480A, 0x9D563706, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF75F3E08, 0x2364430A, 0x00835D10, 0x00A07718, 0x00B48C20, 0x00C19A28, 0x00C9A530, 0x00CFAD38, 0x00D4B43F, 0x00D8BB46, 0x00DBC04E, 0x00DFC554, 0x00E2CA5B, 0x00E4CE61, 0x00E7D266, 0x00E8D46A, 
        0x00EAD76D, 0x00EBD870, 0x00ECDA72, 0x00ECDA73, 0x00ECDA72, 0x00ECD971, 0x00EBD76F, 0x00E9D66C, 0x00E8D368, 0x00E5D064, 0x00E3CC5F, 0x00E1C959, 0x00DEC453, 0x00DABF4C, 0x00D7B945, 0x00D3B33E, 0x00CEAC36, 0x00C9A42F, 0x00C09A28, 0x00B38B20, 
        0x009E7717, 0x00805B0F, 0x22604009, 0xF75B3C08, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xA95F410A, 0x0172510E, 0x00936D16, 0x00AB851F, 0x00BD9728, 0x00C8A430, 0x00CFAD38, 0x00D4B540, 0x00D9BC48, 0x00DDC24F, 0x00E0C757, 0x00E3CC5E, 0x00E6D164, 0x00E8D469, 0x00EAD76E, 
        0x00ECDA72, 0x00EEDC75, 0x00EEDD77, 0x00EFDE78, 0x00EFDD77, 0x00EEDC76, 0x00EDDB74, 0x00EBD970, 0x00EAD66C, 0x00E7D367, 0x00E5CF62, 0x00E2CB5C, 0x00DFC655, 0x00DBC14E, 0x00D8BB46, 0x00D4B43F, 0x00CEAC37, 0x00C7A32F, 0x00BC9627, 0x00AB841E, 
        0x00916C15, 0x016F4E0D, 0xA85C3E09, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE6A4B0D, 0x4C66480C, 0x00816013, 0x009F7B1D, 0x00B49026, 0x00C3A02F, 0x00CDAC38, 0x00D4B540, 0x00D9BD48, 0x00DDC350, 0x00E1C958, 0x00E4CE5F, 0x00E7D266, 0x00EAD66C, 0x00ECDA71, 
        0x00EEDD75, 0x00F0DF78, 0x00F1E07B, 0x00F1E17C, 0x00F1E17B, 0x00F0E07A, 0x00EFDE77, 0x00EDDB73, 0x00EBD86F, 0x00E9D56A, 0x00E6D164, 0x00E3CC5D, 0x00E0C756, 0x00DCC24F, 0x00D8BB47, 0x00D3B43F, 0x00CDAB37, 0x00C39F2F, 0x00B48F25, 0x009D791C, 
        0x007F5D12, 0x4C63450B, 0xFE6A4A0C, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xE660450C, 0x1A6F5110, 0x008C6C18, 0x00A78523, 0x00BB992D, 0x00C9A836, 0x00D2B33F, 0x00D9BC48, 0x00DEC450, 0x00E2CA58, 0x00E5CF60, 0x00E8D467, 0x00EBD86D, 0x00EEDC72, 
        0x00F0DF77, 0x00F1E17B, 0x00F2E37E, 0x00F3E47F, 0x00F3E37E, 0x00F2E27C, 0x00F0E079, 0x00EFDD75, 0x00ECDA70, 0x00EAD66B, 0x00E7D265, 0x00E4CD5E, 0x00E1C857, 0x00DDC24F, 0x00D8BB47, 0x00D1B23E, 0x00C8A736, 0x00BA982C, 0x00A68322, 0x008A6917, 
        0x1A6C4E0F, 0xE65D420C, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xC263490F, 0x0A775A14, 0x0094751E, 0x00AD8D28, 0x00BFA033, 0x00CDAE3D, 0x00D6BA46, 0x00DDC24F, 0x00E2C957, 0x00E6CF5F, 0x00E9D466, 0x00ECD96D, 0x00EFDD72, 
        0x00F1E078, 0x00F3E37C, 0x00F4E57F, 0x00F5E681, 0x00F4E680, 0x00F3E47E, 0x00F2E27A, 0x00F0DF76, 0x00EDDB70, 0x00EBD76B, 0x00E8D264, 0x00E4CD5D, 0x00E0C856, 0x00DBC14E, 0x00D5B845, 0x00CCAD3C, 0x00BE9E32, 0x00AB8B27, 0x0092721C, 0x0A735713, 
        0xC260460E, 0xFC000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFB000000, 0xF9000000, 0xF7000000, 0xA9634B11, 0x087C6017, 0x00987A22, 0x00AF912D, 0x00C1A438, 0x00CFB342, 0x00D8BE4B, 0x00E0C754, 0x00E5CE5D, 0x00E9D464, 0x00ECD96B, 0x00EFDD71, 
        0x00F1E176, 0x00F3E47C, 0x00F5E780, 0x00F6E882, 0x00F6E881, 0x00F4E57E, 0x00F2E279, 0x00F0DF75, 0x00EDDB6F, 0x00EBD769, 0x00E8D263, 0x00E3CC5B, 0x00DEC553, 0x00D7BC4A, 0x00CDB141, 0x00C0A237, 0x00AE902C, 0x00957821, 0x07795D16, 0xA9604910, 
        0xF7000000, 0xFA000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xF9000000, 0xF6000000, 0xF1000000, 0xEC000000, 0xA35B4711, 0x0D7D631A, 0x00977C25, 0x00AE9330, 0x00C0A63B, 0x00CEB445, 0x00D9C04F, 0x00E0CA58, 0x00E6D160, 0x00EBD767, 0x00EEDC6E, 
        0x00F1E174, 0x00F4E479, 0x00F5E77E, 0x00F7E981, 0x00F6E880, 0x00F4E57C, 0x00F2E277, 0x00F0DF72, 0x00EDDA6C, 0x00E9D566, 0x00E5CF5F, 0x00DFC857, 0x00D7BE4E, 0x00CDB244, 0x00BFA43A, 0x00AD912F, 0x00957A24, 0x0D7A6119, 0xA3594510, 0xED000000, 
        0xF2000000, 0xF6000000, 0xFA000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFC000000, 0xFA000000, 0xF6000000, 0xF2000000, 0xEB000000, 0xE4000000, 0xDB000000, 0xAA42340E, 0x1E79621B, 0x00937B25, 0x00AA9131, 0x00BCA33C, 0x00CAB246, 0x00D5BF50, 0x00DEC959, 0x00E5D161, 0x00EAD767, 
        0x00EEDD6E, 0x00F1E174, 0x00F3E478, 0x00F4E67A, 0x00F4E57A, 0x00F2E376, 0x00F0DF71, 0x00EDDB6C, 0x00E8D666, 0x00E3CF5F, 0x00DCC758, 0x00D4BD4F, 0x00C9B045, 0x00BAA13B, 0x00A88E30, 0x00917825, 0x1E765F1A, 0xAB41340D, 0xDD000000, 0xE5000000, 
        0xED000000, 0xF3000000, 0xF7000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0xFC000000, 0xF8000000, 0xF4000000, 0xEE000000, 0xE6000000, 0xDD000000, 0xD2000000, 0xC7000000, 0xB0161205, 0x4A645318, 0x038A7425, 0x00A0892F, 0x00B29C3A, 0x00C1AB44, 0x00CDB84D, 0x00D6C256, 0x00DDCB5D, 
        0x00E3D163, 0x00E7D669, 0x00EAD96D, 0x00EBDB6F, 0x00EBDB6E, 0x00E9D86B, 0x00E6D567, 0x00E2CF62, 0x00DCC95C, 0x00D5C055, 0x00CBB64D, 0x00BFA943, 0x00B19A39, 0x009E872E, 0x03887124, 0x4B635117, 0xB2161205, 0xC9000000, 0xD4000000, 0xDF000000, 
        0xE8000000, 0xEF000000, 0xF5000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0xFB000000, 0xF8000000, 0xF3000000, 0xEC000000, 0xE3000000, 0xD8000000, 0xCD000000, 0xC0000000, 0xB3000000, 0xA4000000, 0x782E260C, 0x276E5D1E, 0x01917D2B, 0x00A38F35, 0x00B29E3E, 0x00BEAB47, 0x00C7B54E, 
        0x00CEBD54, 0x00D3C259, 0x00D7C65D, 0x00D8C85E, 0x00D8C85E, 0x00D6C65C, 0x00D2C158, 0x00CDBB53, 0x00C6B34D, 0x00BCA946, 0x00B09C3D, 0x00A18D34, 0x018E7A2A, 0x286C5C1D, 0x7A2E260C, 0xA7000000, 0xB5000000, 0xC3000000, 0xCF000000, 0xDB000000, 
        0xE5000000, 0xED000000, 0xF4000000, 0xF8000000, 0xFB000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0xFB000000, 0xF8000000, 0xF3000000, 0xEC000000, 0xE3000000, 0xD9000000, 0xCD000000, 0xC0000000, 0xB3000000, 0xA4000000, 0x95000000, 0x84000000, 0x5D26210B, 0x275F531C, 0x0787772B, 0x009B8934, 0x00A6953B, 
        0x00AF9E41, 0x00B6A546, 0x00BAAA49, 0x00BCAC4B, 0x00BCAC4B, 0x00B9A949, 0x00B5A446, 0x00AE9D41, 0x00A5933B, 0x00998733, 0x0786752A, 0x275E511C, 0x5F26210B, 0x86000000, 0x98000000, 0xA7000000, 0xB5000000, 0xC3000000, 0xCF000000, 0xDB000000, 
        0xE5000000, 0xED000000, 0xF4000000, 0xF8000000, 0xFB000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFC000000, 0xF8000000, 0xF4000000, 0xEE000000, 0xE6000000, 0xDD000000, 0xD2000000, 0xC7000000, 0xBA000000, 0xAD000000, 0x9F000000, 0x90000000, 0x7E000000, 0x6B000000, 0x55050502, 0x3629240D, 0x1E4B4218, 
        0x0F665B22, 0x077A6D2A, 0x03897B30, 0x028E8032, 0x028D7F32, 0x03887A30, 0x07796C2A, 0x0F655A22, 0x1E4A4118, 0x3728230D, 0x57050502, 0x6D000000, 0x80000000, 0x92000000, 0xA2000000, 0xB0000000, 0xBD000000, 0xC9000000, 0xD4000000, 0xDF000000, 
        0xE8000000, 0xEF000000, 0xF5000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFC000000, 0xFA000000, 0xF6000000, 0xF2000000, 0xEB000000, 0xE4000000, 0xDB000000, 0xD2000000, 0xC8000000, 0xBD000000, 0xB1000000, 0xA4000000, 0x95000000, 0x84000000, 0x71000000, 0x5F000000, 0x4E000000, 
        0x40000000, 0x35000000, 0x2E000000, 0x2A000000, 0x2B000000, 0x2E000000, 0x35000000, 0x40000000, 0x4F000000, 0x60000000, 0x73000000, 0x85000000, 0x97000000, 0xA6000000, 0xB3000000, 0xBF000000, 0xCA000000, 0xD4000000, 0xDD000000, 0xE5000000, 
        0xED000000, 0xF3000000, 0xF7000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xF9000000, 0xF6000000, 0xF1000000, 0xEC000000, 0xE6000000, 0xDF000000, 0xD7000000, 0xCF000000, 0xC6000000, 0xBC000000, 0xB0000000, 0xA2000000, 0x93000000, 0x83000000, 0x73000000, 
        0x65000000, 0x5A000000, 0x52000000, 0x4E000000, 0x4E000000, 0x53000000, 0x5B000000, 0x66000000, 0x74000000, 0x84000000, 0x94000000, 0xA4000000, 0xB2000000, 0xBD000000, 0xC7000000, 0xD0000000, 0xD8000000, 0xE0000000, 0xE7000000, 0xED000000, 
        0xF2000000, 0xF6000000, 0xFA000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xF9000000, 0xF7000000, 0xF3000000, 0xEF000000, 0xEB000000, 0xE5000000, 0xE0000000, 0xDA000000, 0xD3000000, 0xCB000000, 0xC1000000, 0xB6000000, 0xA9000000, 0x9D000000, 
        0x91000000, 0x87000000, 0x80000000, 0x7C000000, 0x7C000000, 0x80000000, 0x87000000, 0x91000000, 0x9D000000, 0xAA000000, 0xB7000000, 0xC2000000, 0xCC000000, 0xD4000000, 0xDB000000, 0xE1000000, 0xE6000000, 0xEC000000, 0xF0000000, 0xF4000000, 
        0xF7000000, 0xFA000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xFA000000, 0xF9000000, 0xF6000000, 0xF4000000, 0xF1000000, 0xED000000, 0xEA000000, 0xE5000000, 0xE0000000, 0xDA000000, 0xD3000000, 0xCB000000, 0xC2000000, 
        0xBA000000, 0xB3000000, 0xAD000000, 0xAA000000, 0xAA000000, 0xAD000000, 0xB3000000, 0xBA000000, 0xC3000000, 0xCC000000, 0xD4000000, 0xDB000000, 0xE1000000, 0xE6000000, 0xEA000000, 0xEE000000, 0xF1000000, 0xF4000000, 0xF7000000, 0xF9000000, 
        0xFB000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFD000000, 0xFC000000, 0xFB000000, 0xFA000000, 0xF9000000, 0xF8000000, 0xF7000000, 0xF5000000, 0xF3000000, 0xF1000000, 0xEE000000, 
        0xEC000000, 0xE9000000, 0xE7000000, 0xE7000000, 0xE7000000, 0xE8000000, 0xE9000000, 0xEC000000, 0xEE000000, 0xF1000000, 0xF3000000, 0xF5000000, 0xF7000000, 0xF8000000, 0xFA000000, 0xFB000000, 0xFB000000, 0xFC000000, 0xFD000000, 0xFD000000, 
        0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000
};

static GUI_CONST_STORAGE unsigned long _accapturebutton_pressed[] = {
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFA341601, 0xD22E1201, 
        0xA02B0F00, 0x7E2A0F00, 0x642C0F00, 0x5E290D00, 0x5E290D00, 0x642C0F00, 0x7E2A0F00, 0xA12B0F00, 0xD22E1201, 0xFA341601, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF9331601, 0xB32C1000, 0x5A2C0F00, 0x162E1000, 0x00321101, 
        0x00442413, 0x00664B3C, 0x0080695D, 0x00907B70, 0x00917D72, 0x00826B5F, 0x00674C3D, 0x00452513, 0x00321201, 0x162F1000, 0x5B2C0F00, 0xB32D1100, 0xF9341601, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF6331601, 0x982C1000, 0x242E1000, 0x00341301, 0x004C2814, 0x00846A59, 0x00BEAEA4, 
        0x00E3DBD6, 0x00EFEAE6, 0x00F6F2F0, 0x00FBF9F8, 0x00FCFCFB, 0x00F9F7F5, 0x00F3EFEC, 0x00E7E1DC, 0x00C2B3AA, 0x00876D5D, 0x004D2915, 0x00351301, 0x242F1000, 0x982D1100, 0xF6341501, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE462202, 0xB72E1200, 0x282E1100, 0x00371501, 0x004D260D, 0x008E715E, 0x00C8B7AA, 0x00D8CABF, 0x00E2D6CC, 
        0x00EAE0D8, 0x00F0E9E3, 0x00F5F0EC, 0x00F8F5F2, 0x00F9F6F3, 0x00F7F3F0, 0x00F3EDE8, 0x00EDE6DF, 0x00E6DCD3, 0x00DDD1C7, 0x00CDBEB2, 0x00927663, 0x004F270E, 0x00391501, 0x282F1101, 0xB72F1200, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF2FEFEFE, 0xEEFEFEFE, 0xEAFEFEFE, 0xE6FEFEFE, 0xE0FEFEFE, 0xD2D6D0CB, 0x55614C3F, 0x025A4031, 0x006B4B37, 0x008F705A, 0x00C5B1A2, 0x00D6C7B9, 0x00D5CBC1, 0x00CDC8C4, 0x00C5C4C2, 
        0x00C3C3C3, 0x00C7C7C7, 0x00C8C8C8, 0x00C9C9C9, 0x00C9C9C9, 0x00C8C8C8, 0x00C7C7C7, 0x00C3C3C3, 0x00C5C4C3, 0x00CECAC6, 0x00D8CEC5, 0x00DACCBF, 0x00C9B6A8, 0x0091725C, 0x006D4C37, 0x025C4031, 0x55624C40, 0xD2D6D0CB, 0xE0FEFEFE, 0xE6FEFEFE, 
        0xEAFEFEFE, 0xEEFEFEFE, 0xF2FEFEFE, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEFFEFEFE, 0xEAFEFEFE, 0xE5FEFEFE, 0xDFFEFEFE, 0xC4B2A7A0, 0x2D5A4336, 0x00624533, 0x0076533A, 0x00A0826A, 0x00C8B39F, 0x00CBBFB2, 0x00C4C1BE, 0x00C7C7C7, 0x00CECECE, 0x00D3D3D3, 
        0x00D6D6D6, 0x00D9D9D9, 0x00DCDCDC, 0x00DDDDDD, 0x00DDDDDD, 0x00DCDCDC, 0x00D9D9D9, 0x00D6D6D6, 0x00D3D3D3, 0x00CECECE, 0x00C7C7C7, 0x00C5C2BF, 0x00CDC2B6, 0x00CBB7A5, 0x00A3856D, 0x0078543A, 0x00644533, 0x2E5C4436, 0xC4B2A7A0, 0xDFFEFEFE, 
        0xE5FEFEFE, 0xEAFEFEFE, 0xEFFEFEFE, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEBFEFEFE, 0xE6FEFEFE, 0xDFFEFEFE, 0xBFABA097, 0x1E5A4234, 0x00684935, 0x007E5A3D, 0x00A58468, 0x00C3AF9A, 0x00C3BEB9, 0x00C8C8C8, 0x00D2D2D2, 0x00D8D8D8, 0x00DEDEDE, 0x00E4E4E4, 
        0x00ECECEC, 0x00F1F1F1, 0x00F4F4F4, 0x00F6F6F6, 0x00F6F6F6, 0x00F5F5F5, 0x00F2F2F2, 0x00ECECEC, 0x00E5E5E5, 0x00DEDEDE, 0x00D8D8D8, 0x00D2D2D2, 0x00C8C8C8, 0x00C4BFBA, 0x00C6B3A0, 0x00A8876B, 0x00805A3D, 0x006A4A35, 0x1E5C4334, 0xBFACA097, 
        0xDFFEFEFE, 0xE6FEFEFE, 0xEBFEFEFE, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xE7FEFEFE, 0xE0FEFEFE, 0xC9BFB5AE, 0x1F5B4334, 0x006A4B35, 0x00835D3E, 0x00A27F5D, 0x00BFAF9D, 0x00C4C3C2, 0x00CFCFCF, 0x00D9D9D9, 0x00DFDFDF, 0x00E8E8E8, 0x00F2F2F2, 0x00F7F7F7, 
        0x00FAFAFA, 0x00FCFCFC, 0x00FCFCFC, 0x00FCFCFC, 0x00FCFCFC, 0x00FCFCFC, 0x00FCFCFC, 0x00FAFAFA, 0x00F8F8F8, 0x00F2F2F2, 0x00E8E8E8, 0x00DFDFDF, 0x00D9D9D9, 0x00D0D0D0, 0x00C4C3C2, 0x00C1B1A0, 0x00A58160, 0x00845E3E, 0x006C4C35, 0x205D4334, 
        0xC9BFB6AE, 0xE0FEFEFE, 0xE7FEFEFE, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xE2FEFEFE, 0xD7EBE8E5, 0x355E4738, 0x006A4B35, 0x00845E3E, 0x009E7851, 0x00BCAE9D, 0x00C6C6C6, 0x00D3D3D3, 0x00DCDCDC, 0x00E4E4E4, 0x00EEEEEE, 0x00F6F6F6, 0x00F9F9F9, 0x00FAFAFA, 
        0x00FAFAFA, 0x00F9F9F9, 0x00F8F8F8, 0x00F8F8F8, 0x00F8F8F8, 0x00F8F8F8, 0x00F9F9F9, 0x00F9F9F9, 0x00FAFAFA, 0x00F9F9F9, 0x00F6F6F6, 0x00EFEFEF, 0x00E4E4E4, 0x00DCDCDC, 0x00D3D3D3, 0x00C6C6C6, 0x00BDAF9F, 0x009F7953, 0x00855F3E, 0x006C4C35, 
        0x36604838, 0xD8EFEDEB, 0xE2FEFEFE, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xDDFEFEFE, 0x6A6C5748, 0x00654833, 0x00815D3D, 0x009A7248, 0x00B7A895, 0x00C6C6C5, 0x00D4D4D4, 0x00DDDDDD, 0x00E5E5E5, 0x00F0F0F0, 0x00F6F6F6, 0x00F7F7F7, 0x00F6F6F6, 0x00F5F5F5, 
        0x00F3F3F3, 0x00F2F2F2, 0x00F1F1F1, 0x00F1F1F1, 0x00F1F1F1, 0x00F1F1F1, 0x00F2F2F2, 0x00F3F3F3, 0x00F5F5F5, 0x00F6F6F6, 0x00F7F7F7, 0x00F6F6F6, 0x00F1F1F1, 0x00E5E5E5, 0x00DDDDDD, 0x00D4D4D4, 0x00C6C6C5, 0x00B8A997, 0x009A7248, 0x00835D3D, 
        0x00674833, 0x6A6E5748, 0xDDFEFEFE, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xB0988A7E, 0x06604532, 0x007B583A, 0x00956D45, 0x00B19B80, 0x00C4C4C3, 0x00D3D3D3, 0x00DDDDDD, 0x00E4E4E4, 0x00EEEEEE, 0x00F4F4F4, 0x00F4F4F4, 0x00F3F3F3, 0x00F1F1F1, 0x00EFEFEF, 
        0x00EDEDED, 0x00EDEDED, 0x00ECECEC, 0x00ECECEC, 0x00ECECEC, 0x00ECECEC, 0x00EDEDED, 0x00EDEDED, 0x00EFEFEF, 0x00F1F1F1, 0x00F3F3F3, 0x00F4F4F4, 0x00F4F4F4, 0x00EFEFEF, 0x00E4E4E4, 0x00DDDDDD, 0x00D3D3D3, 0x00C4C4C3, 0x00B29B81, 0x00976E45, 
        0x007D593A, 0x06624632, 0xB19B8B80, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE4A2702, 0x38624A39, 0x00725137, 0x008E6842, 0x00A88761, 0x00BFBEBC, 0x00D0D0D0, 0x00DBDBDB, 0x00E2E2E2, 0x00EBEBEB, 0x00F1F1F1, 0x00F2F2F2, 0x00F1F1F1, 0x00EFEFEF, 0x00EEEEEE, 0x00EDEDED, 
        0x00ECECEC, 0x00ECECEC, 0x00ECECEC, 0x00ECECEC, 0x00ECECEC, 0x00ECECEC, 0x00ECECEC, 0x00ECECEC, 0x00EDEDED, 0x00EEEEEE, 0x00EFEFEF, 0x00F0F0F0, 0x00F2F2F2, 0x00F2F2F2, 0x00ECECEC, 0x00E2E2E2, 0x00DBDBDB, 0x00D0D0D0, 0x00BFBEBC, 0x00A98862, 
        0x00906942, 0x00745237, 0x39654C39, 0xFE4B2602, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xBF371901, 0x01654832, 0x0084603E, 0x009E784B, 0x00B9B0A5, 0x00CBCBCB, 0x00D8D8D8, 0x00E0E0E0, 0x00E6E6E6, 0x00EEEEEE, 0x00F0F0F0, 0x00EFEFEF, 0x00EEEEEE, 0x00EDEDED, 0x00EEEEEE, 0x00EEEEEE, 
        0x00EEEEEE, 0x00EEEEEE, 0x00EEEEEE, 0x00EEEEEE, 0x00EEEEEE, 0x00EEEEEE, 0x00EEEEEE, 0x00EEEEEE, 0x00EEEEEE, 0x00EEEEEE, 0x00EDEDED, 0x00EEEEEE, 0x00EFEFEF, 0x00F0F0F0, 0x00EFEFEF, 0x00E7E7E7, 0x00E0E0E0, 0x00D8D8D8, 0x00CBCBCB, 0x00B9B0A5, 
        0x00A0784C, 0x0086603E, 0x02674932, 0xBF391A01, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x4E391A01, 0x00755537, 0x00946D44, 0x00AF9676, 0x00C4C4C4, 0x00D4D4D4, 0x00DEDEDE, 0x00E2E2E2, 0x00EAEAEA, 0x00EEEEEE, 0x00F0F0F0, 0x00EFEFEF, 0x00EEEEEE, 0x00EDEDED, 0x00EEEEEE, 0x00EEEEEE, 
        0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00EEEEEE, 0x00EDEDED, 0x00EEEEEE, 0x00EFEFEF, 0x00F0F0F0, 0x00EEEEEE, 0x00EBEBEB, 0x00E3E3E3, 0x00DEDEDE, 0x00D4D4D4, 0x00C4C4C4, 
        0x00AF9576, 0x00956E44, 0x00775537, 0x4F3C1B01, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xE43C1E02, 0x07401E01, 0x0084603D, 0x00A07A4B, 0x00BAB4AB, 0x00CDCDCD, 0x00DADADA, 0x00E1E1E1, 0x00E5E5E5, 0x00EBEBEB, 0x00EDEDED, 0x00EEEEEE, 0x00EDEDED, 0x00EDEDED, 0x00EEEEEE, 0x00EEEEEE, 0x00AA7625, 
        0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00FFFFFF, 0x00FFFFFF, 0x00EDEDED, 0x00EEEEEE, 0x00ECECEC, 0x00EBEBEB, 0x00E5E5E5, 0x00E1E1E1, 0x00DADADA, 0x00CDCDCD, 
        0x00BBB4AC, 0x00A17A4B, 0x0086613D, 0x07431F01, 0xE53E1E02, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x98391B01, 0x004C2502, 0x00906B42, 0x00AC906A, 0x00C4C4C3, 0x00D4D4D4, 0x00DEDEDE, 0x00E3E3E3, 0x00E7E7E7, 0x00EBEBEB, 0x00ECECEC, 0x00ECECEC, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 
        0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00ECECEC, 0x00EBEBEB, 0x00E7E7E7, 0x00E3E3E3, 0x00DEDEDE, 0x00D4D4D4, 
        0x00C4C4C3, 0x00AD8F6A, 0x00926B42, 0x004F2602, 0x983C1C01, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x513D1D01, 0x00572D02, 0x009A7546, 0x00B7A892, 0x00CCCCCC, 0x00DADADA, 0x00E2E2E2, 0x00E5E5E5, 0x00E8E8E8, 0x00EBEBEB, 0x00ECECEC, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 
        0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00EBEBEB, 0x00E8E8E8, 0x00E5E5E5, 0x00E2E2E2, 0x00DADADA, 
        0x00CCCCCC, 0x00B7A792, 0x009B7446, 0x005A2E03, 0x52411F01, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFC4C2A03, 0x1C422102, 0x00613503, 0x00A27D4B, 0x00BEBAB3, 0x00D2D2D2, 0x00DFDFDF, 0x00E5E5E5, 0x00E7E7E7, 0x00E9E9E9, 0x00ECECEC, 0x00EDEDED, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 
        0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00F8F8F8, 0x00F8F8F8, 0x00F8F8F8, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00ECECEC, 0x00E9E9E9, 0x00E7E7E7, 0x00E5E5E5, 0x00DFDFDF, 
        0x00D2D2D2, 0x00BEB9B2, 0x00A37C4B, 0x00643503, 0x1C452202, 0xFC4D2902, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xE93F2002, 0x03472402, 0x006A3B04, 0x00A98859, 0x00C4C4C3, 0x00D7D7D7, 0x00E2E2E2, 0x00E7E7E7, 0x00E9E9E9, 0x00EBEBEB, 0x00EEEEEE, 0x00EFEFEF, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 
        0x00AA7625, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00EEEEEE, 0x00EBEBEB, 0x00E9E9E9, 0x00E7E7E7, 0x00E2E2E2, 
        0x00D7D7D7, 0x00C4C4C3, 0x00A98758, 0x006C3B04, 0x044B2502, 0xE9412102, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xCA422302, 0x004D2802, 0x00704004, 0x00AF946C, 0x00C9C9C9, 0x00DBDBDB, 0x00E6E6E6, 0x00E9E9E9, 0x00EBEBEB, 0x00EDEDED, 0x00EFEFEF, 0x00F1F1F1, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 
        0x00AA7625, 0x00FFFFFF, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00FFFFFF, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00EFEFEF, 0x00EDEDED, 0x00EBEBEB, 0x00E9E9E9, 0x00E5E5E5, 
        0x00DBDBDB, 0x00C9C9C9, 0x00AF946C, 0x00724004, 0x00502902, 0xCB452302, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xB93F2102, 0x00522C03, 0x00744404, 0x00B29C79, 0x00CDCDCD, 0x00DEDEDE, 0x00E8E8E8, 0x00ECECEC, 0x00EEEEEE, 0x00F0F0F0, 0x00F2F2F2, 0x00F4F4F4, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 
        0x00FFFFFF, 0x00FFFFFF, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00FFFFFF, 0x00FFFFFF, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00F2F2F2, 0x00F0F0F0, 0x00EEEEEE, 0x00ECECEC, 0x00E8E8E8, 
        0x00DEDEDE, 0x00CDCDCD, 0x00B29B79, 0x00764404, 0x00552D03, 0xB9432202, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xB63E2002, 0x00552E03, 0x00774705, 0x00B5A181, 0x00CFCFCF, 0x00E1E1E1, 0x00EBEBEB, 0x00EEEEEE, 0x00F0F0F0, 0x00F2F2F2, 0x00F4F4F4, 0x00F6F6F6, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 
        0x00FFFFFF, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00FFFFFF, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00F4F4F4, 0x00F2F2F2, 0x00F0F0F0, 0x00EEEEEE, 0x00EBEBEB, 
        0x00E1E1E1, 0x00CFCFCF, 0x00B5A081, 0x00784605, 0x00582F03, 0xB5412102, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xB7412302, 0x00563003, 0x00794905, 0x00B5A281, 0x00D0D0D0, 0x00E1E1E1, 0x00EBEBEB, 0x00EFEFEF, 0x00F1F1F1, 0x00F3F3F3, 0x00F6F6F6, 0x00F8F8F8, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 
        0x00FFFFFF, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00FFFFFF, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00F6F6F6, 0x00F3F3F3, 0x00F1F1F1, 0x00EFEFEF, 0x00EBEBEB, 
        0x00E1E1E1, 0x00D0D0D0, 0x00B5A181, 0x007A4805, 0x00593103, 0xB7442402, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xC2472702, 0x00563003, 0x00784905, 0x00B39F7A, 0x00CECECE, 0x00E0E0E0, 0x00EAEAEA, 0x00EFEFEF, 0x00F1F1F1, 0x00F3F3F3, 0x00F5F5F5, 0x00F7F7F7, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 
        0x00FFFFFF, 0x00FFFFFF, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00FFFFFF, 0x00FFFFFF, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00F5F5F5, 0x00F3F3F3, 0x00F1F1F1, 0x00EFEFEF, 0x00EAEAEA, 
        0x00E0E0E0, 0x00CECECE, 0x00B39E7B, 0x007A4905, 0x00583103, 0xC34A2802, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xE1472802, 0x01532F03, 0x00774905, 0x00AF986D, 0x00CBCBCB, 0x00DEDEDE, 0x00E9E9E9, 0x00EEEEEE, 0x00F0F0F0, 0x00F2F2F2, 0x00F4F4F4, 0x00F6F6F6, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 
        0x00AA7625, 0x00FFFFFF, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00FFFFFF, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00F4F4F4, 0x00F2F2F2, 0x00F0F0F0, 0x00EEEEEE, 0x00E9E9E9, 
        0x00DEDEDE, 0x00CBCBCB, 0x00AF976E, 0x00794906, 0x01563003, 0xE2492802, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xF7512F03, 0x12512E03, 0x00744806, 0x00AA8E5C, 0x00C7C7C7, 0x00DBDBDB, 0x00E7E7E7, 0x00EEEEEE, 0x00F0F0F0, 0x00F2F2F2, 0x00F4F4F4, 0x00F6F6F6, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 
        0x00AA7625, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00F4F4F4, 0x00F2F2F2, 0x00F0F0F0, 0x00EEEEEE, 0x00E7E7E7, 
        0x00DBDBDB, 0x00C7C7C7, 0x00AA8D5C, 0x00764906, 0x13553003, 0xF7532F03, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x3F502F03, 0x006F4506, 0x00A48650, 0x00C1BDB6, 0x00D7D7D7, 0x00E5E5E5, 0x00ECECEC, 0x00EFEFEF, 0x00F1F1F1, 0x00F4F4F4, 0x00F6F6F6, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 
        0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00F4F4F4, 0x00F1F1F1, 0x00EFEFEF, 0x00ECECEC, 0x00E5E5E5, 
        0x00D7D7D7, 0x00C1BDB6, 0x00A58650, 0x00714707, 0x40543004, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x814F2F04, 0x00684106, 0x009E804A, 0x00B9AF98, 0x00D1D1D1, 0x00E2E2E2, 0x00EBEBEB, 0x00EFEFEF, 0x00F1F1F1, 0x00F3F3F3, 0x00F6F6F6, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 
        0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00F4F4F4, 0x00F1F1F1, 0x00EFEFEF, 0x00EBEBEB, 0x00E2E2E2, 
        0x00D1D1D1, 0x00B9AE98, 0x009E814B, 0x006B4307, 0x81523004, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xCF503004, 0x025F3C06, 0x00967946, 0x00AF9B70, 0x00CACAC9, 0x00DCDCDC, 0x00E8E8E8, 0x00EFEFEF, 0x00F2F2F2, 0x00F4F4F4, 0x00F6F6F6, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 
        0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00F4F4F4, 0x00F2F2F2, 0x00EFEFEF, 0x00E8E8E8, 0x00DCDCDC, 
        0x00CACAC9, 0x00AF9B70, 0x00977A46, 0x02623E07, 0xCF533205, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD5B3A06, 0x31593806, 0x008D7242, 0x00A48A53, 0x00BFBBB2, 0x00D5D5D5, 0x00E5E5E5, 0x00EDEDED, 0x00F1F1F1, 0x00F4F4F4, 0x00F6F6F6, 0x00F8F8F8, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 
        0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00AA7625, 0x00F6F6F6, 0x00F4F4F4, 0x00F1F1F1, 0x00EDEDED, 0x00E5E5E5, 0x00D5D5D5, 
        0x00BFBBB2, 0x00A48A53, 0x008E7342, 0x325C3A06, 0xFD5D3B06, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x9D563706, 0x0080683D, 0x009A804B, 0x00B2A37F, 0x00CCCCCC, 0x00DEDEDE, 0x00EBEBEB, 0x00F0F0F0, 0x00F4F4F4, 0x00F6F6F6, 0x00F8F8F8, 0x00FAFAFA, 0x00FBFBFB, 0x00FDFDFD, 0x00FDFDFD, 0x00FEFEFE, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F8F8, 0x00F6F6F6, 0x00F4F4F4, 0x00F0F0F0, 0x00EBEBEB, 0x00DEDEDE, 0x00CCCCCC, 
        0x00B2A37F, 0x009B814B, 0x0083693D, 0x9D593907, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF75B3C08, 0x1878623D, 0x008E7645, 0x00A38D56, 0x00BEBAAD, 0x00D5D5D5, 0x00E5E5E5, 0x00EEEEEE, 0x00F4F4F4, 0x00F7F7F7, 0x00F9F9F9, 0x00FAFAFA, 0x00FCFCFC, 0x00FEFEFE, 0x00FEFEFE, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FAFAFA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F9F9F9, 0x00F7F7F7, 0x00F4F4F4, 0x00EEEEEE, 0x00E5E5E5, 0x00D5D5D5, 0x00BFBAAD, 
        0x00A48D56, 0x00907745, 0x197B643D, 0xF75F3E08, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x7B817359, 0x017F693E, 0x0098814C, 0x00AD9B6E, 0x00C9C8C6, 0x00DCDCDC, 0x00EAEAEA, 0x00F2F2F2, 0x00F6F6F6, 0x00F9F9F9, 0x00FBFBFB, 0x00FCFCFC, 0x00FEFEFE, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FEFEFE, 0x00FEFEFE, 0x00FEFEFE, 0x00FEFEFE, 0x00FEFEFE, 0x00FEFEFE, 0x00FEFEFE, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFEFE, 0x00FCFCFC, 0x00FBFBFB, 0x00F9F9F9, 0x00F6F6F6, 0x00F2F2F2, 0x00EAEAEA, 0x00DCDCDC, 0x00C9C8C6, 0x00AD9C6E, 
        0x0099824D, 0x01816B3F, 0x7B83745A, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xBE9B9B9A, 0x34786642, 0x00897445, 0x009E8953, 0x00B5A989, 0x00CFCFCE, 0x00E1E1E1, 0x00EDEDED, 0x00F4F4F4, 0x00F9F9F9, 0x00FBFBFB, 0x00FCFCFC, 0x00FEFEFE, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FEFEFE, 0x00FEFEFE, 0x00FEFEFE, 0x00FEFEFE, 0x00FEFEFE, 0x00FEFEFE, 0x00FEFEFE, 0x00FEFEFE, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFEFE, 0x00FCFCFC, 0x00FBFBFB, 0x00F9F9F9, 0x00F4F4F4, 0x00EDEDED, 0x00E1E1E1, 0x00CFCFCE, 0x00B5AA89, 0x009F8A54, 
        0x008B7645, 0x347A6843, 0xBE9B9B9A, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xC4929292, 0xA4888277, 0x117A673F, 0x008F7B49, 0x00A28E58, 0x00BBB399, 0x00D2D2D2, 0x00E3E3E3, 0x00EFEFEF, 0x00F5F5F5, 0x00FAFAFA, 0x00FCFCFC, 0x00FDFDFD, 0x00FEFEFE, 0x00FEFEFE, 
        0x00FEFEFE, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFEFE, 0x00FEFEFE, 0x00FEFEFE, 0x00FDFDFD, 0x00FCFCFC, 0x00FAFAFA, 0x00F5F5F5, 0x00EFEFEF, 0x00E3E3E3, 0x00D2D2D2, 0x00BBB39A, 0x00A39059, 0x00907C49, 
        0x117C6940, 0xA4888377, 0xC4929292, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xC98A8A8A, 0xBB878787, 0x857C7360, 0x067D6C41, 0x0093804D, 0x00A4935D, 0x00BCB49B, 0x00D3D3D2, 0x00E3E3E3, 0x00EEEEEE, 0x00F5F5F5, 0x00F9F9F9, 0x00FCFCFC, 0x00FDFDFD, 0x00FDFDFD, 
        0x00FEFEFE, 0x00FEFEFE, 0x00FEFEFE, 0x00FEFEFE, 0x00FEFEFE, 0x00FEFEFE, 0x00FEFEFE, 0x00FEFEFE, 0x00FDFDFD, 0x00FDFDFD, 0x00FCFCFC, 0x00F9F9F9, 0x00F5F5F5, 0x00EEEEEE, 0x00E3E3E3, 0x00D3D3D2, 0x00BCB59C, 0x00A5945D, 0x0094824E, 0x06806D42, 
        0x857D7460, 0xBB878787, 0xC98A8A8A, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xCF838383, 0xC07C7C7C, 0xB0797979, 0x71766D56, 0x04806E43, 0x00938250, 0x00A4945D, 0x00BAB191, 0x00D0D0CE, 0x00DFDFDF, 0x00EBEBEB, 0x00F2F2F2, 0x00F7F7F7, 0x00FAFAFA, 0x00FCFCFC, 
        0x00FCFCFC, 0x00FDFDFD, 0x00FDFDFD, 0x00FCFCFC, 0x00FCFCFC, 0x00FDFDFD, 0x00FDFDFD, 0x00FCFCFC, 0x00FCFCFC, 0x00FAFAFA, 0x00F7F7F7, 0x00F2F2F2, 0x00EBEBEB, 0x00E0E0E0, 0x00D0D0CE, 0x00BAB191, 0x00A5945E, 0x00958350, 0x05817044, 0x71776E56, 
        0xB0797979, 0xBF7A7A7A, 0xCE818181, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xD4777777, 0xC46E6E6E, 0xB46B6B6B, 0xA56C6C6C, 0x6A706853, 0x087F7045, 0x00928250, 0x00A2935D, 0x00B3A77B, 0x00C9C6BA, 0x00D8D8D8, 0x00E3E3E3, 0x00EBEBEB, 0x00F1F1F1, 0x00F4F4F4, 
        0x00F7F7F7, 0x00F8F8F8, 0x00F9F9F9, 0x00F9F9F9, 0x00F9F9F9, 0x00F9F9F9, 0x00F8F8F8, 0x00F7F7F7, 0x00F4F4F4, 0x00F1F1F1, 0x00EBEBEB, 0x00E3E3E3, 0x00D8D8D8, 0x00C9C6BA, 0x00B3A87B, 0x00A3945E, 0x00938351, 0x08817145, 0x6A716953, 0xA46B6B6B, 
        0xB46B6B6B, 0xC46E6E6E, 0xD3747474, 0xFC000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFB000000, 0xD7686868, 0xC9616161, 0xB85D5D5D, 0xA75C5C5C, 0x975D5D5D, 0x6E666153, 0x127B6E46, 0x008E7F4F, 0x009D8F5A, 0x00AB9E68, 0x00BCB491, 0x00CCCAC1, 0x00D8D8D7, 0x00DFDFDF, 0x00E6E6E6, 
        0x00EAEAEA, 0x00ECECEC, 0x00EEEEEE, 0x00EFEFEF, 0x00EFEFEF, 0x00EEEEEE, 0x00ECECEC, 0x00EAEAEA, 0x00E6E6E6, 0x00DFDFDF, 0x00D8D8D8, 0x00CCCAC1, 0x00BDB592, 0x00AC9F69, 0x009F915B, 0x008F814F, 0x127D7046, 0x6D666153, 0x955B5B5B, 0xA65B5B5B, 
        0xB65B5B5B, 0xC85F5F5F, 0xD6656565, 0xFA000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFC000000, 0xF9000000, 0xDC5C5C5C, 0xCC525252, 0xBB4F4F4F, 0xAA4E4E4E, 0x984D4D4D, 0x884E4E4E, 0x7255534F, 0x2E6F6546, 0x0286784B, 0x00958855, 0x00A39660, 0x00ADA16C, 0x00BAB28A, 0x00C6C2AD, 0x00CECDC6, 
        0x00D4D4D4, 0x00D8D8D8, 0x00DBDBDB, 0x00DCDCDC, 0x00DCDCDC, 0x00DADADA, 0x00D8D8D8, 0x00D4D4D4, 0x00CECDC6, 0x00C6C2AD, 0x00BBB289, 0x00AEA26C, 0x00A39761, 0x00978956, 0x02877A4C, 0x2E6F6647, 0x7154534E, 0x874D4D4D, 0x974C4C4C, 0xA84C4C4C, 
        0xBA4D4D4D, 0xCB505050, 0xDB5A5A5A, 0xF8000000, 0xFC000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFB000000, 0xF8000000, 0xE0515151, 0xD1484848, 0xC0434343, 0xAE404040, 0x9C404040, 0x8B414141, 0x7B424242, 0x6C454545, 0x4C555145, 0x18736A47, 0x01897E4F, 0x00978B58, 0x00A19661, 0x00AA9F69, 0x00B1A771, 
        0x00B7AF7E, 0x00BDB68F, 0x00C0BB99, 0x00C2BD9E, 0x00C2BD9E, 0x00C1BB99, 0x00BDB78F, 0x00B8B07F, 0x00B1A872, 0x00ABA069, 0x00A29761, 0x00988C59, 0x018B7F4F, 0x18756B48, 0x4B545145, 0x6A444444, 0x79414141, 0x89404040, 0x9A3F3F3F, 0xAC3F3F3F, 
        0xBF424242, 0xD0464646, 0xDF4E4E4E, 0xF8000000, 0xFB000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFB000000, 0xF8000000, 0xE5484848, 0xD83F3F3F, 0xC73A3A3A, 0xB6373737, 0xA3373737, 0x92373737, 0x81383838, 0x723A3A3A, 0x643C3C3C, 0x553D3D3D, 0x3B4D4B3F, 0x186B6346, 0x04847A4E, 0x00908655, 0x00998E5C, 
        0x009F9662, 0x00A49A66, 0x00A79E68, 0x00A9A06A, 0x00A9A06A, 0x00A79E68, 0x00A49B66, 0x00A09662, 0x00998F5C, 0x00918756, 0x04847B4E, 0x186B6446, 0x3A4D4A3F, 0x543C3C3C, 0x623B3B3B, 0x70393939, 0x80373737, 0x90363636, 0xA2363636, 0xB4363636, 
        0xC6393939, 0xD73D3D3D, 0xE4454545, 0xF8000000, 0xFB000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFC000000, 0xF9000000, 0xE9404040, 0xDE383838, 0xD1343434, 0xC1313131, 0xAF2F2F2F, 0x9E2F2F2F, 0x8E313131, 0x7F323232, 0x70333333, 0x62343434, 0x53353535, 0x45363636, 0x36393937, 0x224A483C, 0x125E5941, 
        0x096F6848, 0x047B744D, 0x02857C51, 0x01888053, 0x01898053, 0x02857D51, 0x047C744D, 0x096F6948, 0x125F5941, 0x214B483B, 0x35383837, 0x44363636, 0x52353535, 0x61343434, 0x6E333333, 0x7D313131, 0x8C303030, 0x9D2F2F2F, 0xAE2F2F2F, 0xC0303030, 
        0xCF313131, 0xDD373737, 0xE9404040, 0xF8000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFB000000, 0xEF3C3C3C, 0xE7383838, 0xDB313131, 0xCE2D2D2D, 0xBF2C2C2C, 0xAF2B2B2B, 0xA02C2C2C, 0x912C2C2C, 0x832E2E2E, 0x752E2E2E, 0x68303030, 0x59303030, 0x4B303030, 0x3E303030, 0x32303030, 
        0x282F2F2F, 0x21303030, 0x1D303030, 0x1B303030, 0x1A303030, 0x1D303030, 0x21303030, 0x282F2F2F, 0x32303030, 0x3D303030, 0x4A303030, 0x59303030, 0x662F2F2F, 0x742E2E2E, 0x812D2D2D, 0x902C2C2C, 0x9E2B2B2B, 0xAE2B2B2B, 0xBD2A2A2A, 0xCD2C2C2C, 
        0xD92E2E2E, 0xE6363636, 0xEE383838, 0xFA000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xFA000000, 0xF6000000, 0xF2000000, 0xED000000, 0xE7000000, 0xE0000000, 0xD8000000, 0xD0000000, 0xC7000000, 0xBD000000, 0xB2000000, 0xA4000000, 0x94000000, 0x84000000, 0x74000000, 
        0x66000000, 0x5B000000, 0x53000000, 0x4E000000, 0x4E000000, 0x52000000, 0x5A000000, 0x65000000, 0x73000000, 0x83000000, 0x93000000, 0xA2000000, 0xB0000000, 0xBC000000, 0xC6000000, 0xCF000000, 0xD7000000, 0xDF000000, 0xE6000000, 0xEC000000, 
        0xF1000000, 0xF6000000, 0xF9000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xFA000000, 0xF7000000, 0xF4000000, 0xF0000000, 0xEC000000, 0xE6000000, 0xE1000000, 0xDB000000, 0xD4000000, 0xCC000000, 0xC2000000, 0xB7000000, 0xAA000000, 0x9D000000, 
        0x91000000, 0x87000000, 0x80000000, 0x7C000000, 0x7C000000, 0x80000000, 0x87000000, 0x91000000, 0x9D000000, 0xA9000000, 0xB6000000, 0xC1000000, 0xCB000000, 0xD3000000, 0xDA000000, 0xE0000000, 0xE5000000, 0xEB000000, 0xEF000000, 0xF3000000, 
        0xF7000000, 0xF9000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xFB000000, 0xF9000000, 0xF7000000, 0xF4000000, 0xF1000000, 0xEE000000, 0xEA000000, 0xE6000000, 0xE1000000, 0xDB000000, 0xD4000000, 0xCC000000, 0xC3000000, 
        0xBA000000, 0xB3000000, 0xAD000000, 0xAA000000, 0xAA000000, 0xAD000000, 0xB3000000, 0xBA000000, 0xC2000000, 0xCB000000, 0xD3000000, 0xDA000000, 0xE0000000, 0xE5000000, 0xEA000000, 0xED000000, 0xF1000000, 0xF4000000, 0xF6000000, 0xF9000000, 
        0xFA000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFD000000, 0xFC000000, 0xFB000000, 0xFB000000, 0xFA000000, 0xF8000000, 0xF7000000, 0xF5000000, 0xF3000000, 0xF1000000, 0xEE000000, 
        0xEC000000, 0xE9000000, 0xE8000000, 0xE7000000, 0xE7000000, 0xE7000000, 0xE9000000, 0xEC000000, 0xEE000000, 0xF1000000, 0xF3000000, 0xF5000000, 0xF7000000, 0xF8000000, 0xF9000000, 0xFA000000, 0xFB000000, 0xFC000000, 0xFD000000, 0xFD000000, 
        0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000
};


GUI_CONST_STORAGE GUI_BITMAP bmcamera = {
  60,                          /* x Size */
  60,                          /* y Size */
  240,                         /* Bytes Per Line */
  32,                          /* Bits Per Pixel */
  (unsigned char *)_accamera,  /* Pointer to picture data */
  NULL,                        /* Pointer to palette */
  GUI_DRAW_BMP8888
};

GUI_CONST_STORAGE GUI_BITMAP bmwizard = {
  48,                          /* x Size */
  48,                          /* y Size */
  192,                         /* Bytes Per Line */
  32,                          /* Bits Per Pixel */
  (unsigned char *)_acwizard,  /* Pointer to picture data */
  NULL,                        /* Pointer to palette */
  GUI_DRAW_BMP8888
};

GUI_CONST_STORAGE GUI_BITMAP bmcapturebutton_not_pressed = {
  50,                                            /* x Size */
  50,                                            /* y Size */
  200,                                           /* Bytes Per Line */
  32,                                            /* Bits Per Pixel */
  (unsigned char *)_accapturebutton_not_pressed, /* Pointer to picture data */
  NULL,                                          /* Pointer to palette */
  GUI_DRAW_BMP8888
};

GUI_CONST_STORAGE GUI_BITMAP bmcapturebutton_pressed = {
  50,                                        /* x Size */
  50,                                        /* y Size */
  200,                                       /* Bytes Per Line */
  32,                                        /* Bits Per Pixel */
  (unsigned char *)_accapturebutton_pressed, /* Pointer to picture data */
  NULL,                                      /* Pointer to palette */
  GUI_DRAW_BMP8888
};

/**
  * @}
  */

/**
  * @}
  */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
