/**
  ******************************************************************************
  * @file    video_player_res.c
  * @author  MCD Application Team
  * @brief   resources define for video player module
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright © 2017 STMicroelectronics International N.V. 
  * All rights reserved.</center></h2>
  *
  * Redistribution and use in source and binary forms, with or without 
  * modification, are permitted, provided that the following conditions are met:
  *
  * 1. Redistribution of source code must retain the above copyright notice, 
  *    this list of conditions and the following disclaimer.
  * 2. Redistributions in binary form must reproduce the above copyright notice,
  *    this list of conditions and the following disclaimer in the documentation
  *    and/or other materials provided with the distribution.
  * 3. Neither the name of STMicroelectronics nor the names of other 
  *    contributors to this software may be used to endorse or promote products 
  *    derived from this software without specific written permission.
  * 4. This software, including modifications and/or derivative works of this 
  *    software, must execute solely and exclusively on microcontroller or
  *    microprocessor devices manufactured by or for STMicroelectronics.
  * 5. Redistribution and use of this software other than as permitted under 
  *    this license is void and will automatically terminate your rights under 
  *    this license. 
  *
  * THIS SOFTWARE IS PROVIDED BY STMICROELECTRONICS AND CONTRIBUTORS "AS IS" 
  * AND ANY EXPRESS, IMPLIED OR STATUTORY WARRANTIES, INCLUDING, BUT NOT 
  * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
  * PARTICULAR PURPOSE AND NON-INFRINGEMENT OF THIRD PARTY INTELLECTUAL PROPERTY
  * RIGHTS ARE DISCLAIMED TO THE FULLEST EXTENT PERMITTED BY LAW. IN NO EVENT 
  * SHALL STMICROELECTRONICS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
  * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, 
  * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
  * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
  * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
  * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  *
  ******************************************************************************
  */

/* Includes ------------------------------------------------------------------*/
#include <stdlib.h>
#include "GUI.h"

#ifndef GUI_CONST_STORAGE
  #define GUI_CONST_STORAGE const
#endif

/** @addtogroup VIDEO_PLAYER_MODULE
  * @{
  */

/** @defgroup VIDEO_PLAYER_RES
  * @brief video player resources
  * @{
  */
extern GUI_CONST_STORAGE GUI_BITMAP bmvideo5;
extern GUI_CONST_STORAGE GUI_BITMAP bmvideo_exit;

#if defined ( __ICCARM__ )
#pragma location="ExtQSPIFlashSection" 
#else
__attribute__((section(".ExtQSPIFlashSection")))  
#endif
static GUI_CONST_STORAGE unsigned short _acvideo5[] = { 
  0xB41E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0xA29E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 
        0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 
        0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 
        0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E, 0x9A9E,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x789C, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0xA29E, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x80BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x80BC, 0x80BC, 0x809C, 0x789C, 0x80BC, 0x789C, 0x78BC, 
        0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x809C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x80BC, 0x78BC, 0x78BC, 0x809C, 0xA29E, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 
        0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x80BC, 0x78BC, 0x78BC, 0x789C, 0x921D, 0xB3FF, 0xCD5F, 0xE6BF, 0xFFFF, 0xFFFF, 0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x80BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x789C, 0x78BC, 0x789C, 0x78BC, 0x809C, 0x91BD, 0xAB9E, 0xC4DF, 0xDE3F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF79F, 0xFFFF, 0xFFFF, 0xB3FF, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x789C, 0x809C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x809C, 0x78BC, 0x78BC, 0x78BC, 0x809C, 0x78BC, 0x89BD, 0xAB1E, 0xBC7F, 0xDE3F, 0xF79F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xDE3F, 0xC4FF, 0xAB9E, 0x919D, 0x789C, 0xEF1F, 0xFFFF, 0xD55F, 0x789C, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x789C, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x80BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x789C, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x811C, 0x9ABD, 0xBC7F, 0xD5BF, 0xEF1F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xDE3F, 0xAB9E, 0x923D, 0x809C, 0x809C, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0xD5BF, 0xFFFF, 0xE69F, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x789C, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0xA29E, 0xB3FF, 0xD55F, 0xE6BF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF7FF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF79F, 0x811D, 0x78BC, 0x78BC, 0x78BC, 0x809C, 0x789C, 0x78BC, 0x78BC, 0xBC7F, 0xFFFF, 0xFFFF, 0x813C, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x9A3D, 0xB39E, 0xC4DF, 0xDE3F, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xE6BF, 0x813C, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x809C, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0x9A9E, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x89BD, 0xAB1E, 0xBC7F, 0xDE3F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xDE3F, 
        0xBC7F, 0xA31E, 0xB39E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xEE9F, 0x813D, 0x78BC, 0x809C, 0x78BC, 0x80BC, 0x78BC, 0x813C, 0xFFFF, 0xFFFF, 0xBC7F, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x809C, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x80BC, 0x789C, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 
        0x789C, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x811D, 0xA29D, 0xBC7F, 0xDDBF, 0xF79F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xE6BF, 0xC4FF, 0xB39E, 0x9A3D, 0x78BC, 0x78BC, 
        0x78BC, 0x789C, 0x78BC, 0xAB9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD55F, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0xE69F, 0xFFFF, 0xD5BF, 0x78BC, 0x78BC, 0x789C, 
        0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789D, 0x80BC, 0x78BC, 0x78BC, 0x809C, 0x78BC, 0x78BC, 0xA29D, 0xB41E, 0xD55F, 0xEF1F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD55F, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0xB41E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD55F, 0x78BC, 0x78BC, 0x78BC, 0x809C, 0x78BC, 0xCD5F, 0xFFFF, 0xEF1F, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x789C, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x809C, 0x809C, 0x789C, 0x78BC, 0x80BC, 0x923D, 0xB39E, 0xCD7F, 0xE69F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBC7F, 0x78BC, 0x78BC, 0x80BC, 0x78BC, 0x80BC, 
        0x809C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0xD55F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB41E, 0x80BC, 0x789C, 0x80BC, 0x789C, 0xB41F, 0xFFFF, 0xFFFF, 0x813D, 0x789C, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x789C, 0x78BC, 0x789C, 0x789C, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x789C, 0x91BD, 0xA31E, 0xC4FF, 0xDE3F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF79F, 0xDE3F, 0xD5DF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB39E, 0x78BC, 0x789C, 0x809C, 0x789C, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0xD57F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB39E, 0x78BC, 0x78BC, 0x789C, 0xA29D, 0xFFFF, 0xFFFF, 0xAB1E, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x80BC, 0x78BC, 0x789C, 0x80BC, 0x78BC, 0x809C, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x813C, 0x9A9E, 0xC47F, 0xDE3F, 
        0xF79F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xDE3F, 0xC4FF, 0xB37E, 0x9A3D, 0x78BC, 0x78BC, 0x78BC, 0xE63F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB39E, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x789C, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0xE6BF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xA33E, 0x789C, 0x789C, 0x78BC, 0xFFFF, 0xFFFF, 0xC47F, 0x78BC, 0x789C, 
        0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x809C, 0x789C, 0x78BC, 0xA29E, 0xB3FE, 0xDDBF, 0xEF1F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xCD5F, 0xA29E, 0x78BC, 0x78BC, 0x80BD, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x813C, 0xE69F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF79F, 0x921D, 0x789C, 0x78BC, 
        0x789C, 0x78BC, 0x78BC, 0x80BC, 0x78BC, 0x78BC, 0x789C, 0x813D, 0xE6BF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF79F, 0x923D, 0x78BC, 0x78BC, 0xDE5F, 0xFFFF, 0xDE3F, 0x78BC, 0x78BC, 
        0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0xB3FE, 0xCD5F, 0xE6BF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xF79F, 0x9A3D, 0x78BC, 0x80BC, 0x789C, 0x80BC, 0x78BC, 0x789C, 0x78BC, 0x789C, 0x789C, 0x813D, 0xEF1F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF77F, 0x9A3D, 0x78BC, 
        0x78BC, 0x80BC, 0x809C, 0x78BC, 0x809C, 0x78BC, 0x789C, 0x78BC, 0x813D, 0xF79F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF77F, 0x923D, 0x78BC, 0xC4DF, 0xFFFF, 0xF79F, 0x789C, 0x789C, 
        0x789C, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x80BC, 0x78BC, 0x78BC, 0xDE3F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xF77F, 0x813D, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x921D, 0xF79F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xEF1F, 0x813C, 
        0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x921D, 0xF79F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xEF1F, 0x813D, 0xB39E, 0xFFFF, 0xFFFF, 0x91BD, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x80BC, 0x78BC, 0x78BC, 0xC4FF, 0xFFFF, 0xFFFF, 0xFF9F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xE6BF, 0x813D, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x809C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A3D, 0xF79F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xE6BF, 
        0x811C, 0x78BC, 0x78BC, 0x789C, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x923D, 0xF79F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xE6BF, 0x9ABD, 0xFFFF, 0xFFFF, 0xB39E, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0xAB1E, 0xFFFF, 0xFFFF, 0xBC7F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xE69F, 0x811D, 0x809C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0xA31E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xE6BF, 0x78BC, 0x809C, 0x809C, 0x80BC, 0x78BC, 0x78BC, 0x809C, 0x78BC, 0x80BC, 0x78BC, 0xB39E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF7FF, 0xFFFF, 0xFFFF, 0xFFFF, 0xDE3F, 0xFFFF, 0xFFFF, 0xC4FF, 0x78BC, 
        0x78BC, 0x809C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x91BD, 0xFFFF, 0xFFFF, 0xB39E, 0xAB9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCD5F, 0x78BC, 0x809C, 0x78BC, 0x789C, 0x80BC, 0x78BC, 0x78BC, 0x789C, 0x80BC, 0x78BC, 0xAB9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xCD5F, 0x78BC, 0x78BC, 0x78BC, 0x809C, 0x78BC, 0x789C, 0x809C, 0x809C, 0x78BC, 0x78BC, 0xAB9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xDE3F, 0x809C, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x80BC, 0x789C, 0x78BC, 0xF79F, 0xFFFF, 0xCCFE, 0x78BC, 0xB3FE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD55F, 0x789C, 0x789C, 0x78BC, 0x809C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x80BC, 0x78BC, 0xBC7F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xD55F, 0x78BC, 0x809C, 0x789C, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0xC4FF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x80BC, 
        0x809C, 0x78BC, 0x80BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x789C, 0x78BC, 0x78BC, 0xDE3F, 0xFFFF, 0xE6BF, 0x789C, 0x78BC, 0xD55F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB41F, 0x80BC, 0x78BC, 0x789C, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x80BC, 0xCD5F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xAB9E, 0x789C, 0x78BC, 0x78BC, 0x80BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x80BC, 0x78BC, 0xD55F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xE6BF, 0xC4DF, 0xB39E, 0x9A3D, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x80BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0xBC7F, 0xFFFF, 0xFFFF, 0x78BC, 0x789C, 0x78BC, 0xCD5F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAB9E, 0x78BC, 0x78BC, 0x78BC, 0x80BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x809C, 0xCD5F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB39E, 0x78BC, 0x78BC, 0x78BC, 0x80BC, 0x789C, 0x78BC, 0xA29E, 0xB41F, 0xD55F, 0xEF1F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xEF1F, 0xD55F, 0xB41E, 0x9A9E, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x80BC, 0x789C, 0x789C, 0x789C, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x80BC, 0x78BC, 0xA31E, 0xFFFF, 0xFFFF, 0xA29D, 0x78BC, 0x78BC, 0x78BC, 0xE6BF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAB1E, 0x789C, 0x78BC, 0x809C, 0x80BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x891D, 0xE6BF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x9A9E, 0x9A1E, 0xB39E, 0xC4DF, 0xE6BF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF79F, 0xD5BF, 0xBC7F, 0xA2BE, 0x811D, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x809C, 0x78BC, 0x789C, 0x78BC, 
        0x80BC, 0x78BC, 0x789C, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x893D, 0xFFFF, 0xFFFF, 0xB3FE, 0x78BC, 0x78BC, 0x78BC, 0x813D, 0xE6BF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF79F, 0x923D, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x813C, 0xE69F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xDE3F, 0xBC7F, 0xAB1E, 0x91BD, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x809C, 0x78BC, 0x78BC, 0x809C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 
        0x78BC, 0x789C, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x80BC, 0x78BC, 0xEF1F, 0xFFFF, 0xCD5F, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x813D, 0xF77F, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF77F, 0x923D, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x80BC, 0x78BC, 0x78BC, 0x78BC, 0x89BD, 0xFF7F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xDE3F, 0xC4FF, 0xB39E, 0x923D, 0x78BC, 0x80BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x789C, 0x78BC, 0x78BC, 0xD5BF, 0xFFFF, 0xEF1F, 0x78BC, 0x809C, 0x78BC, 0x78BC, 0x78BC, 0x923D, 0xF79F, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xE6BF, 0x891D, 0x80BC, 0x809C, 0x789C, 0x789C, 0x80BC, 0x78BC, 0x78BC, 0x78BC, 0xA29D, 0xD55F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xE6BF, 0xD55F, 0xB3FE, 0xA29D, 0x789C, 0x78BC, 0x80BC, 0x809C, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x809C, 0x809C, 0x78BC, 0xBC9F, 0xFFFF, 0xFFFF, 0x813D, 0x78BC, 0x78BC, 0x78BC, 0x809C, 0x809C, 0x923E, 
        0xF77F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xE69F, 0x813C, 0x78BC, 0x80BC, 0x923D, 0xB39E, 0xCD5F, 0xE69F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xEF1F, 0xD5BF, 0xC49F, 0x9A9E, 0x811D, 
        0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x809C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0xA29E, 0xFFFF, 0xFFFF, 0x9A9E, 0x789C, 0x78BC, 0x78BC, 0x80BC, 0x78BC, 0x80BC, 
        0xAB9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xEF1F, 0xDE3F, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFFF, 0xF79F, 0xDE3F, 0xBC7E, 0xAB3E, 0x89BD, 0x789C, 0x78BC, 0x789C, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x809C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x80BC, 0x809C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0xFFFF, 0xFFFF, 0xBC7E, 0x78BC, 0x789C, 0x78BC, 0x789C, 0x789C, 0x80BC, 
        0x78BC, 0xAB9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xDE3F, 0xCCDF, 0xB39E, 0x919D, 0x78BC, 0x789C, 0x78BC, 0x809C, 0x789C, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x789C, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x80BC, 0x78BC, 0x809C, 0x80BC, 0xE69F, 0xFFFF, 0xD5BF, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x80BC, 0x78BC, 0xCCDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xE6BF, 0xCD5F, 0xB3FE, 0x923E, 0x789C, 0x78BC, 0x80BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x809C, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x809C, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x789C, 0x78BC, 0x809C, 0x80BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x809C, 0x789C, 0x78BC, 0x789C, 0x78BC, 0x89BD, 0xEF1F, 0xFFFF, 0xEF1F, 0x78BC, 0x78BC, 0x78BC, 0x80BC, 0x923D, 0xB3FE, 
        0xD55F, 0xE69F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xEF1F, 0xD5BF, 0xC47F, 0x9ABD, 0x789C, 0x78BC, 0x80BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 
        0x80BD, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x80BC, 0x789C, 0xA31E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBC1E, 0xC4FF, 0xDE3F, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xF79F, 0xDE3F, 0xBC7F, 0xA31E, 0x813D, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x80BC, 0x789C, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0xEF1F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xDE3F, 0xC4FF, 0xAB1E, 
        0x91BD, 0x78BC, 0x789C, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x80BC, 0x78BC, 0x78BC, 0x80BC, 0x78BC, 0x80BC, 0x78BC, 0x80BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x809C, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x80BC, 0x789C, 0x78BC, 0x78BC, 0x80BC, 0x809C, 0x78BC, 0x78BC, 0x80BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x809C, 0x789C, 0x78BC, 0x78BC, 0x78BC, 
        0x80BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x809C, 0x809C, 0x78BC, 0x78BC, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF77F, 0xDE3F, 0xDE3F, 0xE65F, 0xDE3F, 
        0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 
        0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xE63F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xE63F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xE65F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 
        0x923D, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0xEF1F, 0xFFFF, 0xF7FF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF7FF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xA2BD, 0x80BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x80BC, 0x78BC, 0xA31E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xE6BF, 0xE63F, 0xDE3F, 0xDE5F, 0xDE3F, 0xDE3F, 
        0xDE3F, 0xDE3F, 0xDE3F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xE6BF, 0xDE5F, 0xDE3F, 0xDE3F, 0xDE3F, 0xE63F, 0xDE3F, 0xDE3F, 0xDE3F, 0xEF1F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF79F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xDE3F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x80BC, 0x78BC, 0x789C, 0x78BC, 0x80BC, 0x89BD, 0xD55F, 0xFFFF, 0xFFFF, 0x9ABD, 0x789C, 0x78BC, 0x80BC, 0x789C, 0x78BC, 
        0x78BC, 0x809C, 0x9ABD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xDE3F, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x809C, 0xE6BF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xA2BE, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x789C, 0xA31E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF79F, 0xFFFF, 0xFFFF, 
        0x9A9E, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x789C, 0x80BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x809C, 0x78BC, 0xEF1F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x9A9E, 0x78BC, 0x789C, 0x78BC, 0x809C, 0x809C, 0x78BC, 0x78BC, 0x78BC, 0xB39E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD5BF, 0x809C, 0x78BC, 0x809C, 0x80BC, 0x789C, 0x78BC, 0x809C, 0x80BC, 0x80BC, 0xEF1F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB41E, 0xFFFF, 0xFFFF, 
        0x9A9D, 0x78BC, 0x789C, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9D, 0xFFFF, 0xFFFF, 0x9ABD, 0x78BC, 0x789C, 0x78BC, 0x80BC, 0x78BC, 
        0x809C, 0xBC7F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCD5F, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x813D, 0xF77F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x919D, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0xBC7E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD55F, 0x9A9E, 0xFFFF, 0xFFFF, 
        0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x809C, 0x78BC, 0x80BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0x9A9E, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x813D, 0xF79F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF79F, 0x813C, 0x789C, 0x80BC, 0x78BC, 0x789C, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0xBC7F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBC7F, 0x78BC, 0x789C, 0x78BC, 0x809C, 0x789C, 0x78BC, 0x789C, 0x78BC, 0x91BD, 0xF79F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF79F, 0x811D, 0x9A9E, 0xFFFF, 0xFFFF, 
        0xA29E, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0xA29D, 0x78BC, 0x80BC, 0x78BC, 0x789C, 0x78BC, 
        0xCD5F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBC7E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x789C, 0x78BC, 0x89BD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xF79F, 0x813C, 0x78BC, 0x809C, 0x789C, 0x789C, 0x78BC, 0x80BC, 0x78BC, 0x78BC, 0xCD5F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xBC7F, 0x80BC, 0x9A9E, 0xFFFF, 0xFFFF, 
        0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A1E, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xEF1F, 0x78BC, 0x789C, 0x78BC, 0x809C, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0xD5BF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xB39E, 0x78BC, 0x78BC, 0x78BC, 0x80BC, 0x78BC, 0x809C, 0x78BC, 0x80BC, 0x9ABD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xEF1F, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 
        0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0x9ABD, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0xE63F, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xA31E, 0x80BC, 0x789C, 0x78BC, 0x80BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xE69F, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x789C, 0x80BC, 0x78BC, 0x78BC, 0xDE3F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x9A9E, 0x78BC, 0x789C, 0x9A9E, 0xFFFF, 0xFFFF, 
        0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0xA29E, 0x789C, 0x78BC, 0x789C, 0xA31E, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xDE3F, 0x78BC, 0x78BC, 0x78BC, 0x809C, 0x789C, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0xEF1F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0x9A9E, 0x80BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x789C, 0x809C, 0xAB9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xDE3F, 0x80BC, 0x789C, 0x789C, 0x9A9E, 0xFFFF, 0xFFFF, 
        0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0xA29E, 0x78BC, 0x78BC, 0x811C, 0xEF1F, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x923D, 0x789C, 0x78BC, 0x789C, 0x80BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0xBBFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xCD5F, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x809C, 0x78BC, 0x78BC, 0x813D, 0xEF1F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x91BD, 0x789C, 0x80BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 
        0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0x9A9E, 0x78BC, 0x789C, 0xBC7F, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xCCFF, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x813C, 0xF77F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xF79F, 0x89BD, 0x78BC, 0x78BC, 0x809C, 0x789C, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0xBC7F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC4FF, 0x78BC, 0x809C, 0x78BC, 0x80BC, 0x9A9E, 0xFFFF, 0xFFFF, 
        0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0xA29D, 0x78BC, 0x89BD, 0xF79F, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFF7F, 0x811D, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x809C, 0x78BC, 0xC4DF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xBC7F, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x809C, 0x78BC, 0x80BC, 0x89BD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF77F, 0x811D, 0x78BC, 0x78BC, 0x80BC, 0x789C, 0x9A9E, 0xFFFF, 0xFFFF, 
        0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0x9A9E, 0x80BC, 0xCD5F, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB41F, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x91BD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xEF1F, 
        0x813D, 0x78BC, 0x809C, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0xDDBF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB41F, 0x78BC, 0x809C, 0x78BC, 0x789C, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 
        0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0xA2BE, 0x9A9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xEF1F, 0x78BC, 0x809C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x809C, 0x78BC, 0x78BC, 0xDE3F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xAB9E, 
        0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xE69F, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x789C, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 
        0x9A9D, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0x9A9E, 0xDE3F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x9A9E, 0x789C, 0x78BC, 0x789C, 0x809C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0xA31E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xDE3F, 0x789C, 
        0x78BC, 0x78BC, 0x80BC, 0x78BC, 0x809C, 0x78BC, 0x78BC, 0x78BC, 0xE6BF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x9ABE, 0x789C, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 
        0xA29D, 0x809C, 0x809C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0xCD5F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xDE3F, 0x78BC, 0x78BC, 0x80BC, 0x78BC, 0x789C, 0x809C, 0x78BC, 0x78BC, 0x78BC, 0xEF1F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x923D, 0x78BC, 
        0x78BC, 0x78BC, 0x809C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0xB39E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xDDBF, 0x80BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0xA29E, 0xFFFF, 0xFFFF, 
        0x9A9E, 0x789C, 0x78BC, 0x78BC, 0x809C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x91BD, 0x789C, 0x809C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0xC47E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD57F, 0x789C, 0x78BC, 
        0x78BC, 0x809C, 0x78BC, 0x78BC, 0x78BC, 0x809C, 0x813D, 0xF79F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x89BD, 0x78BC, 0x78BC, 0x809C, 0x78BC, 0x80BC, 0x789C, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 
        0x9A9E, 0x789C, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xA29E, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0x9ABD, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0x9A9E, 0x789C, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xA2BD, 0x809C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x9A9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x80BC, 0x78BC, 0x78BC, 0x78BC, 0xF77F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0x89BD, 0x809C, 0x789C, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x809C, 0x789C, 0x809C, 0x78BC, 0x78BC, 0x80BC, 0xAB9E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB39E, 
        0x78BC, 0x789C, 0x80BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x80BC, 0x78BC, 0x78BC, 0x78BC, 0x89BD, 0xBBFE, 0xC49F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 
        0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 
        0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xBC7F, 0xB41F, 0x923D, 0x78BC, 
        0x78BC, 0x80BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x80BC, 0x809C, 0x789C, 0x789C, 0x78BC, 0x78BC, 0x789C, 0x80BC, 0x78BC, 
        0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x809C, 0x80BC, 
        0x78BC, 0x78BC, 0x789C, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x789C, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x809C, 0x80BC, 0x78BC, 0x78BC, 0x789C, 0x80BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BD, 0x78BC, 
        0x789C, 0x789C, 0x789C, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 0x789C, 0x78BC, 0x78BC, 0x809C, 0x78BC, 0x78BC, 0x789C, 0x809C, 0x809C, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x809C, 0x809C, 0x78BC, 
        0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x80BC, 0x809C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x809C, 0x78BC, 
        0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x789C, 0x78BC, 
        0x78BC, 0x789C, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC,
  0x9A9E, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 
        0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC, 0x78BC
};

GUI_CONST_STORAGE GUI_BITMAP bmvideo5 = {
  110,                         /* xSize                   */
  110,                         /* ySize                   */
  220,                         /* BytesPerLine            */
  16,                          /* BitsPerPixel            */
  (unsigned char *)_acvideo5,  /* Pointer to picture data */
  NULL,                        /* Pointer to palette      */
  GUI_DRAW_BMP565
};

#if defined ( __ICCARM__ )
#pragma location="ExtQSPIFlashSection" 
#else
__attribute__((section(".ExtQSPIFlashSection")))  
#endif
static GUI_CONST_STORAGE unsigned long _acvideo_exit[] = {
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
	0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
	0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
	0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
	0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
	0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
	0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
	0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
	0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
	0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
	0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
	0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
	0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20,
	0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20, 0xFF5B3E20
};

GUI_CONST_STORAGE GUI_BITMAP bmvideo_exit = {
	30,                             /* xSize                   */
	30,                             /* ySize                   */
	120,                            /* BytesPerLine            */
	32,                             /* BitsPerPixel            */
	(unsigned char *)_acvideo_exit, /* Pointer to picture data */
	NULL,                           /* Pointer to palette      */
	GUI_DRAW_BMP8888
};

#if defined ( __ICCARM__ )
#pragma location="ExtQSPIFlashSection" 
#else
__attribute__((section(".ExtQSPIFlashSection")))  
#endif
static GUI_CONST_STORAGE unsigned long _acback[] = {
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFCE79617, 0xF5E89818, 0xE3E99A1A, 0xC7EB9D21, 0xAAEC9B2A, 
        0x78EEA338, 0x3DED7810, 0x82EC7612, 0xDCEB8C16, 0xF6EB9317, 0xFEEB9617, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFCE69517, 0xF4E79617, 0xDFE89818, 0xBBE99A1B, 0x94EA9D22, 0x57ECA02C, 
        0x04EFAE4A, 0x00EB4E09, 0x2BEB7110, 0xD1EA8F16, 0xF2EA9517, 0xFEEA9718, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFCE59317, 0xF3E69517, 0xDEE79617, 0xBBE89819, 0x93E99B1D, 0x58EA9C1D, 0x03EDA632, 
        0x00EC8621, 0x00EA4708, 0x2AEA9016, 0xD0E89317, 0xF2E89717, 0xFEE89818, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFCE49216, 0xF4E59317, 0xDFE69517, 0xBCE79618, 0x95E8991B, 0x58E99A1B, 0x04E99917, 0x00ECA430, 
        0x00EC9316, 0x00EA6F10, 0x2AE99918, 0xD0E89617, 0xF2E89617, 0xFEE89717, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFCE39016, 0xF3E49116, 0xDFE59317, 0xBBE69518, 0x94E7971B, 0x58E8981B, 0x04E89717, 0x00EA9E25, 0x00EB9E1C, 
        0x00EB9D19, 0x00EA9B19, 0x2AE89818, 0xD0E79517, 0xF2E79517, 0xFEE79517, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFCE28E16, 0xF4E39016, 0xDFE49117, 0xBCE59319, 0x94E6961C, 0x59E7971B, 0x04E79617, 0x00E99D24, 0x00EA9C1B, 0x00EA9B18, 
        0x00EA9B18, 0x00E99918, 0x29E79617, 0xD1E59417, 0xF2E59417, 0xFEE59417, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFCE18C15, 0xF3E28E16, 0xDFE39017, 0xBBE49219, 0x95E5941C, 0x59E6951B, 0x04E69416, 0x00E89B24, 0x00E99A1C, 0x00E99918, 0x00E99918, 
        0x00E99918, 0x00E79718, 0x28E69517, 0xD1E59217, 0xF2E59217, 0xFEE59217, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFCE08B15, 0xF4E18C15, 0xDEE28E16, 0xBDE39119, 0x95E4931D, 0x5AE5941C, 0x04E59316, 0x00E79A24, 0x00E8981B, 0x00E89717, 0x00E89717, 0x00E89717, 
        0x00E89717, 0x00E69617, 0x28E59317, 0xD1E39116, 0xF2E39016, 0xFEE39016, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFCDF8A15, 0xF4E08B15, 0xE0E18C16, 0xBBE28F19, 0x95E3931D, 0x5AE4931C, 0x05E49115, 0x00E79A27, 0x00E7971B, 0x00E79517, 0x00E79517, 0x00E79517, 0x00E79517, 
        0x00E79517, 0x00E59317, 0x28E49216, 0xD1E28F16, 0xF2E28F16, 0xFEE28E16, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFCDE8814, 0xF4DF8915, 0xDFDF8B16, 0xBDE18E18, 0x94E2911E, 0x5BE3921C, 0x03E28F15, 0x00E69A2B, 0x00E6951B, 0x00E59317, 0x00E59317, 0x00E59317, 0x00E59317, 0x00E59317, 
        0x00E59317, 0x00E49217, 0x28E28F16, 0xD1E18D15, 0xF2E18D15, 0xFEE08C15, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFCDC8614, 0xF4DE8814, 0xE0DF8915, 0xBCDF8C18, 0x95E1901E, 0x5AE2911D, 0x05E28E14, 0x00E59A2E, 0x00E5941D, 0x00E49216, 0x00E49216, 0x00E49216, 0x00E49216, 0x00E49216, 0x00E49216, 
        0x00E49216, 0x00E39016, 0x28E28E16, 0xD0E08A15, 0xF1DF8A15, 0xFDDE8914, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFCDB8513, 0xF4DC8614, 0xDFDD8815, 0xBDDF8A18, 0x94E08E1E, 0x5CE18F1D, 0x04E18C14, 0x00E59A30, 0x00E3931D, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 
        0x00E28F16, 0x00E28E16, 0x27E18C15, 0xCADF8314, 0xE9DE8514, 0xF5DD8714, 0xF7DD8714, 0xF7DD8714, 0xF7DD8714, 0xF7DD8714, 0xF7DD8714, 0xF7DD8714, 0xF7DD8714, 0xF7DD8714, 0xF7DD8714, 0xF7DD8714, 0xF7DD8714, 0xF7DD8714, 0xF7DD8714, 0xF7DD8714, 
        0xF7DD8714, 0xF7DD8714, 0xF9DD8714, 0xF9DD8714, 0xFADD8714, 0xFBDD8714, 0xFBDD8714, 0xFCDD8714, 0xFDDD8714,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFCDA8313, 0xF4DB8413, 0xE0DC8614, 0xBCDD8918, 0x96DF8D1D, 0x5BE08E1D, 0x05DF8A14, 0x00E49931, 0x00E3921E, 0x00E18E15, 0x00E18E15, 0x00E18E15, 0x00E18E15, 0x00E18E15, 0x00E18E15, 0x00E18E15, 0x00E18E15, 
        0x00E18E15, 0x00E18C15, 0x23DF8A15, 0xB3DE7A15, 0xCCDD7F15, 0xD6DD8615, 0xD6DD8715, 0xD6DD8815, 0xD6DD8815, 0xD6DD8815, 0xD6DD8815, 0xD6DD8815, 0xD6DD8815, 0xD6DD8815, 0xD6DD8815, 0xD6DD8815, 0xD6DD8815, 0xD6DD8815, 0xD6DD8815, 0xD6DD8815, 
        0xD8DD8815, 0xDCDD8815, 0xE0DD8815, 0xE4DD8815, 0xE8DD8815, 0xEBDD8815, 0xEEDD8815, 0xF2DD8815, 0xF5DD8815,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFCD98113, 0xF4DA8313, 0xE0DB8514, 0xBDDC8717, 0x95DD8B1D, 0x5CDF8C1C, 0x04DE8913, 0x00E39832, 0x00E18F1D, 0x00E08C15, 0x00E08C15, 0x00E08C15, 0x00E08C15, 0x00E08C15, 0x00E08C15, 0x00E08C15, 0x00E08C15, 0x00E08C15, 
        0x00E08C15, 0x00E08A15, 0x1DDF8715, 0x8CDF791E, 0x9ADE821C, 0xA0DE891C, 0xA1DE8B1C, 0xA1DE8B1C, 0xA1DE8B1C, 0xA1DE8B1C, 0xA1DE8B1C, 0xA1DE8B1C, 0xA1DE8B1C, 0xA1DE8B1C, 0xA1DE8B1C, 0xA1DE8B1C, 0xA1DE8B1C, 0xA1DE8B1C, 0xA1DE8B1C, 0xA1DE8B1C, 
        0xA4DE8B1C, 0xAEDE8B1C, 0xB7DE8B1C, 0xC0DE8B1C, 0xC8DE8B1C, 0xD1DE8B1C, 0xD8DE8B1C, 0xDFDE8B1C, 0xE6DE8B1E,
  0xFF000000, 0xFF000000, 0xFCD88012, 0xF4D98113, 0xE0DA8313, 0xBCDB8516, 0x95DC891C, 0x5BDE8A1C, 0x05DD8713, 0x00E29732, 0x00E08F1E, 0x00DF8A15, 0x00DF8A15, 0x00DF8A15, 0x00DF8A15, 0x00DF8A15, 0x00DF8A15, 0x00DF8A15, 0x00DF8A15, 0x00DF8A15, 0x00DF8A15, 
        0x00DF8A15, 0x00DF8B1E, 0x08DE580B, 0x5DDF7B25, 0x6EDF8D2C, 0x70DF922C, 0x71DF932C, 0x71DF932C, 0x71DF932C, 0x71DF932C, 0x71DF932C, 0x71DF932C, 0x71DF932C, 0x71DF932C, 0x71DF932C, 0x71DF932C, 0x71DF932C, 0x71DF932C, 0x71DF932C, 0x71DF932C, 
        0x76DF932C, 0x84DF932C, 0x92DF932C, 0x9FDF932C, 0xACDF932C, 0xB8DF932C, 0xC3DF932C, 0xCFDF932C, 0xD9DF942D,
  0xFF000000, 0xFCD77E12, 0xF4D88012, 0xE0D98113, 0xBDDA8316, 0x95DB871B, 0x5DDC881B, 0x05DC8513, 0x00E19531, 0x00DF8D1D, 0x00DE8814, 0x00DE8814, 0x00DE8814, 0x00DE8814, 0x00DE8814, 0x00DE8814, 0x00DE8814, 0x00DE8814, 0x00DE8814, 0x00DE8814, 0x00DE8814, 
        0x00DE8914, 0x00E16E1C, 0x00DC3B05, 0x01DC7510, 0x04DC8613, 0x05DC8613, 0x05DC8613, 0x05DC8613, 0x05DC8613, 0x05DC8613, 0x05DC8613, 0x05DC8613, 0x05DC8613, 0x05DC8613, 0x05DC8613, 0x05DC8613, 0x05DC8613, 0x05DC8613, 0x05DC8613, 0x05DC8613, 
        0x0BDC8715, 0x18DC8817, 0x29DD8919, 0x3DDD8A1B, 0x52DD8B1D, 0x69DD8C1E, 0x81DD8D20, 0x99DE8E22, 0xB2DE8E24,
  0xFCD67D12, 0xF5D77E12, 0xE0D88013, 0xBED98215, 0x96DA851A, 0x5CDB861A, 0x05DB8412, 0x00E09330, 0x00DE8B1D, 0x00DC8614, 0x00DC8614, 0x00DC8614, 0x00DC8614, 0x00DC8614, 0x00DC8614, 0x00DC8614, 0x00DC8614, 0x00DC8614, 0x00DC8614, 0x00DC8614, 0x00DC8614, 
        0x00DC8614, 0x00E08E28, 0x00E7A25E, 0x00E4AA55, 0x00E4A954, 0x00E4AA56, 0x00E4AB56, 0x00E4AB56, 0x00E4AB56, 0x00E4AB56, 0x00E4AB57, 0x00E4AB57, 0x00E4AB57, 0x00E4AB57, 0x00E4AB57, 0x00E4AB57, 0x00E4AB57, 0x00E4AB57, 0x00E4AB57, 0x01E4AB57, 
        0x09E4A954, 0x17E3A852, 0x28E3A64F, 0x3BE3A54D, 0x51E3A34A, 0x67E1A147, 0x7FE1A045, 0x98E19F43, 0xB0E19E41,
  0xF4D67C12, 0xE0D77E12, 0xBDD88015, 0x96D98319, 0x5DDA8419, 0x05DA8212, 0x00DF912E, 0x00DD891C, 0x00DB8513, 0x00DB8513, 0x00DB8513, 0x00DB8513, 0x00DB8513, 0x00DB8513, 0x00DB8513, 0x00DB8513, 0x00DB8513, 0x00DB8513, 0x00DB8513, 0x00DB8513, 0x00DB8513, 
        0x00DB8513, 0x00DC8717, 0x00E09C3A, 0x00E09C39, 0x00E09C39, 0x00E09C39, 0x00E09C39, 0x00E09C39, 0x00E09C39, 0x00E09C39, 0x00E09C39, 0x00E09C39, 0x00E09C39, 0x00E09C39, 0x00E09C39, 0x00E09C39, 0x00E09C39, 0x00E09C39, 0x00E09C39, 0x01E09C39, 
        0x09DF9A37, 0x17DF9935, 0x28DF9834, 0x3BDE9732, 0x51DE9631, 0x67DE9530, 0x7FDD942F, 0x98DD932E, 0xB0DD922C,
  0xE1D67D12, 0xBFD77E14, 0x96D88118, 0x5ED98318, 0x04D98112, 0x00DD8E2B, 0x00DB871B, 0x00DA8313, 0x00DA8313, 0x00DA8313, 0x00DA8313, 0x00DA8313, 0x00DA8313, 0x00DA8313, 0x00DA8313, 0x00DA8313, 0x00DA8313, 0x00DA8313, 0x00DA8313, 0x00DA8313, 0x00DA8313, 
        0x00DA8313, 0x00DA8313, 0x00DB8517, 0x00DB8618, 0x00DB8618, 0x00DB8618, 0x00DB8618, 0x00DB8618, 0x00DB8618, 0x00DB8618, 0x00DB8618, 0x00DB8618, 0x00DB8618, 0x00DB8618, 0x00DB8618, 0x00DB8618, 0x00DB8618, 0x00DB8618, 0x00DB8618, 0x01DB8618, 
        0x09DB8618, 0x17DB8518, 0x28DB8518, 0x3BDB8518, 0x51DA8517, 0x67DA8417, 0x7FDA8417, 0x98DA8417, 0xB0DA8417,
  0xC4D67D14, 0x99D78118, 0x5ED88217, 0x06D87F11, 0x00DC8B29, 0x00DA851B, 0x00D98113, 0x00D98113, 0x00D98113, 0x00D98113, 0x00D98113, 0x00D98113, 0x00D98113, 0x00D98113, 0x00D98113, 0x00D98113, 0x00D98113, 0x00D98113, 0x00D98113, 0x00D98113, 0x00D98113, 
        0x00D98113, 0x00D98113, 0x00D98114, 0x00D98316, 0x00D98316, 0x00D98316, 0x00D98316, 0x00D98316, 0x00D98316, 0x00D98316, 0x00D98316, 0x00D98316, 0x00D98316, 0x00D98316, 0x00D98316, 0x00D98316, 0x00D98316, 0x00D98316, 0x00D98316, 0x01D98316, 
        0x09D98316, 0x17D98316, 0x28DA8316, 0x3BDA8315, 0x51DA8315, 0x67DA8315, 0x7FDA8315, 0x98DA8315, 0xB0DA8415,
  0xADD67E16, 0x67D78017, 0x05D77D11, 0x00DA8825, 0x00D9831A, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 
        0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x01D87F12, 
        0x09D87F12, 0x17D98012, 0x28D98012, 0x3BD98112, 0x51D98113, 0x67D98213, 0x7FDA8213, 0x98DA8213, 0xB0DA8313,
  0x86D67D14, 0x07D67C11, 0x00D88421, 0x00D78019, 0x00D67C12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 
        0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D77E12, 0x00D87F12, 0x00D88013, 0x01D98113, 
        0x09DA8213, 0x17DB8413, 0x28DC8513, 0x3BDC8614, 0x51DD8714, 0x67DE8714, 0x7FDE8814, 0x98DE8914, 0xB0DE8914,
  0x33D57B11, 0x00D88421, 0x00E18F1E, 0x00DF8A15, 0x00DF8A15, 0x00DF8A15, 0x00DF8915, 0x00DE8815, 0x00DE8815, 0x00DE8815, 0x00DD8714, 0x00DD8714, 0x00DD8614, 0x00DD8614, 0x00DD8614, 0x00DC8514, 0x00DC8514, 0x00DC8514, 0x00DC8514, 0x00DC8514, 0x00DC8514, 
        0x00DC8514, 0x00DC8514, 0x00DC8514, 0x00DC8514, 0x00DC8514, 0x00DD8614, 0x00DD8614, 0x00DD8614, 0x00DD8714, 0x00DE8815, 0x00DE8815, 0x00DE8915, 0x00DF8A15, 0x00DF8A15, 0x00DF8A15, 0x00E08B15, 0x00E08B15, 0x00E08B15, 0x00E08B15, 0x01E08B15, 
        0x09E08B15, 0x17E08C15, 0x28E18C15, 0x3BE18C15, 0x51E18D15, 0x67E18D15, 0x7FE18D15, 0x98E28D15, 0xB0E28E15,
  0x91D47911, 0x02D57D17, 0x00E69F3A, 0x00E28F14, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 
        0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x01E28F16, 
        0x09E28F16, 0x17E39016, 0x28E39016, 0x3BE39016, 0x51E39116, 0x67E49116, 0x7FE49116, 0x98E49216, 0xB0E49216,
  0xF3D47912, 0x86D37811, 0x01D78322, 0x00E8A138, 0x00E59316, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 
        0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x01E59417, 
        0x09E59417, 0x17E69517, 0x28E69517, 0x3BE69517, 0x51E69617, 0x67E79617, 0x7FE79617, 0x98E79617, 0xB0E79617,
  0xFBD37811, 0xF4D37812, 0x85D2760F, 0x02D68222, 0x00EAA53A, 0x00E89716, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 
        0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x01E89718, 
        0x09E89718, 0x17E89818, 0x28E99818, 0x3BE99818, 0x51E99918, 0x67E99918, 0x7FE99918, 0x98E99918, 0xB0E99918,
  0xFF000000, 0xFCD27711, 0xF3D27611, 0x84D07410, 0x01D68223, 0x00EDA93C, 0x00EB9B17, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 
        0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x01EB9C18, 
        0x09EB9C18, 0x17EB9B18, 0x28EA9B18, 0x3CEA9B19, 0x51EA9B19, 0x68EA9A19, 0x80EA9B19, 0x98EA9B19, 0xB1E99A19,
  0xFF000000, 0xFF000000, 0xFCD17510, 0xF4D07511, 0x84CF720F, 0x02D68327, 0x00EFAB3A, 0x00EDA018, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 
        0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x01EEA01A, 
        0x0BED9F19, 0x1AEC9E1A, 0x2CEB9D1A, 0x40EA9C1A, 0x56EA9C1A, 0x6DE99B1A, 0x84E99A1B, 0x9DE8991B, 0xB4E7971B,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFCD07410, 0xF3CF7310, 0x83CE700E, 0x01D58227, 0x00F1AF3C, 0x00F0A419, 0x00F0A51A, 0x00F0A51A, 0x00F0A51A, 0x00F0A51A, 0x00F0A51A, 0x00F0A51A, 0x00F0A51A, 0x00F0A51A, 0x00F0A51A, 0x00F0A51A, 0x00F0A51A, 0x00F0A51A, 
        0x00F0A51A, 0x00F1A51B, 0x00F3A71B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x01F3A81B, 
        0x0FF1A61B, 0x21F0A41B, 0x36EFA31C, 0x4CEEA21C, 0x62EDA01C, 0x79EC9F1C, 0x90EB9D1C, 0xA8EA9C1C, 0xBEE89A1C,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFCCF7210, 0xF4CE7211, 0x82CD6F0E, 0x02D5832B, 0x00F3B23B, 0x00F3A71A, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 
        0x00F3A81B, 0x00EB9C19, 0x00DC9746, 0x00DC913B, 0x00DC913A, 0x00DC913B, 0x00DC913B, 0x00DC913B, 0x00DC913C, 0x00DC923C, 0x00DC923C, 0x00DC923C, 0x00DC923C, 0x00DC923C, 0x00DC923C, 0x00DC923C, 0x00DC923C, 0x00DC923C, 0x00DC923C, 0x01DC923C, 
        0x11DC913B, 0x29DB903A, 0x41DB9039, 0x59DB8F38, 0x70DB8F38, 0x88DB8E36, 0x9EDA8D36, 0xB4DA8C35, 0xC9D98C33,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFCCE700F, 0xF3CD7010, 0x81CB6D0E, 0x02D6852D, 0x00F6B63B, 0x00F6AD1B, 0x00F6AD1C, 0x00F6AD1C, 0x00F6AD1C, 0x00F6AD1C, 0x00F6AD1C, 0x00F6AD1C, 0x00F6AD1C, 0x00F6AD1C, 0x00F6AD1C, 0x00F6AD1C, 
        0x00F6AD1C, 0x00F1B240, 0x01F2DCC7, 0x6CD48434, 0xA3CB6A08, 0xACCA6A06, 0xADCA6A07, 0xADCA6A07, 0xADCA6A07, 0xADCA6A07, 0xADCA6A06, 0xADCA6A06, 0xADCA6A06, 0xADCA6A06, 0xADCA6A06, 0xADCA6A06, 0xADCA6A06, 0xADCA6A06, 0xADCA6A06, 0xADCA6A06, 
        0xB1CB6A07, 0xB8CB6A07, 0xC1CB6A07, 0xCACB6A07, 0xD2CB6A07, 0xD9CB6A08, 0xE1CB6A08, 0xE8CA6B08, 0xEFCB6B08,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFCCD6F0F, 0xF3CC6F11, 0x81CB6B0D, 0x01D5842E, 0x00F8BA3C, 0x00F9B01C, 0x00F9B01D, 0x00F9B01D, 0x00F9B01D, 0x00F9B01D, 0x00F9B01D, 0x00F9B01D, 0x00F9B01D, 0x00F9B01D, 0x00F9B01D, 
        0x00F9B11D, 0x00E89817, 0x23D28131, 0xCFCE7211, 0xEFCB6D11, 0xFCCA6C0F, 0xFDCB6D0F, 0xFECC6E0F, 0xFECC6E0F, 0xFECC6E0F, 0xFECC6E0F, 0xFECC6E0F, 0xFECC6E0F, 0xFECC6E0F, 0xFECC6E0F, 0xFECC6E0F, 0xFECC6E0F, 0xFECC6E0F, 0xFECC6E0F, 0xFECC6E0F, 
        0xFECC6E0F, 0xFECC6E0F, 0xFECC6E0F, 0xFECC6E0F, 0xFECC6E0F, 0xFECC6E0F, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFCCC6D0F, 0xF4CC6E11, 0x7FCA690D, 0x02D68634, 0x00FABD3A, 0x00FBB51D, 0x00FBB51E, 0x00FBB51E, 0x00FBB51E, 0x00FBB51E, 0x00FBB51E, 0x00FBB51E, 0x00FBB51E, 0x00FBB51E, 
        0x00FBB51E, 0x00E99B19, 0x28CA6B0F, 0xD1CD700F, 0xF1C9690E, 0xFEC96A0E, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFCCA6C0E, 0xF2CA6D10, 0x7FC8670C, 0x01D58633, 0x00FCC13B, 0x00FEB91E, 0x00FEB91F, 0x00FEB91F, 0x00FEB91F, 0x00FEB91F, 0x00FEB91F, 0x00FEB91F, 0x00FEB91F, 
        0x00FEB91F, 0x00EA9D19, 0x28C9680E, 0xD1CC6E0E, 0xF2C8680D, 0xFEC7670D, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFDC96A0E, 0xF4C96A0F, 0x7EC7660B, 0x02D48737, 0x00FDC23A, 0x00FFBA1E, 0x00FFBA1F, 0x00FFBA1F, 0x00FFBA1F, 0x00FFBA1F, 0x00FFBA1F, 0x00FFBA1F, 
        0x00FFBA1F, 0x00E99D19, 0x28C7670D, 0xD1CB6C0E, 0xF2C7650D, 0xFEC6640D, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFDC9690E, 0xF2C8690F, 0x7EC6640B, 0x00D5883A, 0x00FDC138, 0x00FFBA1F, 0x00FFBA1F, 0x00FFBA1F, 0x00FFBA1F, 0x00FFBA1F, 0x00FFBA1F, 
        0x00FFBA1F, 0x00E99D19, 0x28C6650D, 0xD1CA6B0D, 0xF2C6640C, 0xFEC5630C, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFDC7670D, 0xF4C7680F, 0x7DC5620A, 0x02D48739, 0x00FDC137, 0x00FFBA1E, 0x00FFBA1F, 0x00FFBA1F, 0x00FFBA1F, 0x00FFBA1F, 
        0x00FFBA1F, 0x00E89C18, 0x28C5630C, 0xD1C9690D, 0xF2C5630C, 0xFEC4620C, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFDC6660D, 0xF3C6660F, 0x7CC3600A, 0x01D68B3F, 0x00FEC134, 0x00FFBA1F, 0x00FFBA1F, 0x00FFBA1F, 0x00FFBA1F, 
        0x00FFBA1F, 0x00E89B18, 0x28C4620C, 0xD1C8680D, 0xF2C3610C, 0xFEC3600C, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFDC5640D, 0xF4C5640E, 0x7BC25E0A, 0x01D58A40, 0x00FEC033, 0x00FFBA1F, 0x00FFBA1F, 0x00FFBA1F, 
        0x00FFBA1F, 0x00E79B18, 0x28C3600C, 0xD1C7660D, 0xF2C25F0B, 0xFEC25E0B, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFDC4620D, 0xF2C4640E, 0x7AC25D09, 0x01D58A40, 0x00FEC134, 0x00FFBA1F, 0x00FFBA1F, 
        0x00FFBA1F, 0x00E79A18, 0x28C25E0C, 0xD1C6650D, 0xF2C15E0B, 0xFEC15D0B, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFEC3610C, 0xF3C4620E, 0x79C05B09, 0x01D68C42, 0x00FEC030, 0x00FFBA1F, 
        0x00FFBA1F, 0x00E79918, 0x28C15D0B, 0xD2C46410, 0xF2C05C0B, 0xFEC05B0B, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFEC25F0C, 0xF3C2600D, 0x79BF5908, 0x01D68C42, 0x00FEC030, 
        0x00FFBA1F, 0x00E59717, 0x29C05C0B, 0xD4C36416, 0xF3BF5B0C, 0xFEBE590A, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFEC15E0C, 0xF3C15E0D, 0x78BE5808, 0x01D58C45, 
        0x00EAA732, 0x00CD741F, 0x2CBF5A0A, 0xDCC26218, 0xF5BE5A0D, 0xFEBE580A, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFEC05D0C, 0xF4C05C0D, 0x79BD5607, 
        0x01C87336, 0x00E8C4AB, 0x33C05D14, 0xEDC05E14, 0xF9BE590C, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFEBF5A0C, 0xF7BF5A0D, 
        0x83BB5209, 0x12DBA179, 0x83C1621E, 0xF8BE590D, 0xFDBD570B, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000
};

GUI_CONST_STORAGE GUI_BITMAP bmback = {
  50,                       /* xSize                   */
  45,                       /* ySize                   */
  200,                      /* BytesPerLine            */
  32,                       /* BitsPerPixel            */
  (unsigned char *)_acback, /* Pointer to picture data */
  NULL,                     /* Pointer to palette      */
  GUI_DRAW_BMP8888
};


#if defined ( __ICCARM__ )
#pragma location="ExtQSPIFlashSection" 
#else
__attribute__((section(".ExtQSPIFlashSection")))  
#endif
static GUI_CONST_STORAGE unsigned long _acnext[] = {
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFDBD570B, 0xF8BE590D, 0x84C1621E, 0x12DBA179, 0x83BB5209, 0xF7BF5A0D, 0xFEBF5A0C, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xF9BE590C, 0xEDC05E14, 0x33C05D14, 0x00E8C4AB, 0x01C87336, 0x79BD5607, 0xF4C05C0D, 0xFEC05D0C, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFEBE580A, 0xF5BE5A0D, 0xDCC26218, 0x2DBF5A0A, 0x00CD741F, 0x00EAA732, 0x01D58C45, 0x78BE5808, 0xF3C15E0D, 0xFEC15E0C, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFEBE590A, 0xF3BF5B0C, 0xD4C36416, 0x29C05C0B, 0x00E59717, 0x00FFBA1F, 0x00FEC030, 0x01D68B42, 0x79BF5908, 0xF3C2600D, 0xFEC25F0C, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFEC05B0B, 0xF2C05C0B, 0xD2C46410, 0x29C15D0B, 0x00E69918, 0x00FFBA1F, 0x00FFBA1F, 0x00FEC030, 0x01D68C42, 0x79C05B09, 0xF3C4620E, 0xFEC3610C, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFEC15D0B, 0xF2C15E0B, 0xD1C6650D, 0x28C25E0C, 0x00E79A18, 0x00FFBA1F, 0x00FFBA1F, 0x00FFBA1F, 0x00FEC134, 0x01D58A40, 0x7AC25D09, 0xF2C4640E, 0xFDC4620D, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFEC25E0B, 0xF2C25F0B, 0xD1C7660D, 0x28C3600C, 0x00E79B18, 0x00FFBA1F, 0x00FFBA1F, 0x00FFBA1F, 0x00FFBA1F, 0x00FEC033, 0x01D58A40, 0x7BC25E0A, 0xF4C5640E, 0xFDC5640D, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFEC3600C, 0xF2C3610C, 0xD1C8680D, 0x28C4620C, 0x00E89B18, 0x00FFBA1F, 0x00FFBA1F, 0x00FFBA1F, 0x00FFBA1F, 0x00FFBA1F, 0x00FEC134, 0x01D68B3F, 0x7CC3600A, 0xF3C6660F, 0xFDC6660D, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFEC4620C, 0xF2C5630C, 0xD1C9690D, 0x28C5630C, 0x00E89C18, 0x00FFBA1F, 0x00FFBA1F, 0x00FFBA1F, 0x00FFBA1F, 0x00FFBA1F, 0x00FFBA1E, 0x00FDC137, 0x02D4873A, 0x7DC5620A, 0xF4C7680F, 0xFDC7670D, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFEC5630C, 0xF2C6640C, 0xD1CA6B0D, 0x28C6650D, 0x00E99C18, 0x00FFBA1F, 0x00FFBA1F, 0x00FFBA1F, 0x00FFBA1F, 0x00FFBA1F, 0x00FFBA1F, 0x00FFBA1F, 0x00FDC137, 0x00D5883A, 0x7EC6640B, 0xF2C8690F, 0xFDC9690E, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFEC6640D, 0xF2C7650D, 0xD1CB6C0E, 0x28C7670D, 0x00E99D18, 0x00FFBA1F, 0x00FFBA1F, 0x00FFBA1F, 0x00FFBA1F, 0x00FFBA1F, 0x00FFBA1F, 0x00FFBA1F, 0x00FFBA1E, 0x00FDC23A, 0x02D48737, 0x7EC7660B, 0xF4C96A0F, 0xFDC96A0E, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFEC7670D, 0xF2C8680D, 0xD1CC6E0E, 0x28C9680E, 0x00EA9C19, 0x00FEB91F, 0x00FEB91F, 0x00FEB91F, 0x00FEB91F, 0x00FEB91F, 0x00FEB91F, 0x00FEB91F, 0x00FEB91F, 0x00FEB91E, 0x00FCC13B, 0x01D58633, 0x7FC8670C, 0xF2CA6D10, 
        0xFCCA6C0E, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFEC96A0E, 0xF2C9690E, 0xD1CD700F, 0x28CA6B0F, 0x00E99B18, 0x00FBB51E, 0x00FBB51E, 0x00FBB51E, 0x00FBB51E, 0x00FBB51E, 0x00FBB51E, 0x00FBB51E, 0x00FBB51E, 0x00FBB51E, 0x00FBB51D, 0x00FABD3A, 0x02D68634, 0x80CA690D, 
        0xF3CC6E11, 0xFCCC6D0F, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFECC6E0F, 0xFECC6E0F, 0xFECC6E0F, 0xFECC6E0F, 0xFECC6E0F, 0xFECC6E0F, 0xFECC6E0F, 0xFECC6E0F, 0xFECC6E0F, 0xFECC6E0F, 0xFECC6E0F, 0xFECC6E0F, 0xFECC6E0F, 0xFECC6E0F, 0xFECC6E0F, 0xFECC6E0F, 0xFECC6E0F, 0xFECC6E0F, 
        0xFECC6E0F, 0xFECB6D0F, 0xFCCA6C0F, 0xEFCB6D11, 0xCFCE7211, 0x23D28131, 0x00E89817, 0x00F9B11D, 0x00F9B11D, 0x00F9B11D, 0x00F9B11D, 0x00F9B11D, 0x00F9B11D, 0x00F9B11D, 0x00F9B11D, 0x00F9B11D, 0x00F9B11D, 0x00F9B01C, 0x00F8BA3C, 0x01D5842E, 
        0x81CB6B0D, 0xF3CC6F11, 0xFCCD6F0F, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xEFCB6B08, 0xE8CA6B08, 0xE1CB6A08, 0xDACB6A08, 0xD2CB6A07, 0xCACB6A07, 0xC1CB6A07, 0xB9CB6A07, 0xB2CA6A07, 0xAECA6A06, 0xADCA6A06, 0xADCA6A06, 0xADCA6A06, 0xADCA6A06, 0xADCA6A06, 0xADCA6A06, 0xADCA6A06, 0xADCA6A06, 0xADCA6A06, 0xADCA6A07, 0xADCA6A07, 
        0xADCA6A07, 0xADCA6A07, 0xADCA6A06, 0xA4CA6A08, 0x6CD48434, 0x01F2DCC7, 0x00F1B240, 0x00F6AD1C, 0x00F6AD1C, 0x00F6AD1C, 0x00F6AD1C, 0x00F6AD1C, 0x00F6AD1C, 0x00F6AD1C, 0x00F6AD1C, 0x00F6AD1C, 0x00F6AD1C, 0x00F6AD1C, 0x00F6AD1B, 0x00F6B63B, 
        0x02D6852D, 0x81CB6D0E, 0xF3CD7010, 0xFCCE700F, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xC9D98C33, 0xB4DA8D35, 0x9EDA8D36, 0x88DB8E36, 0x70DB8F38, 0x59DB9038, 0x41DB9039, 0x29DB903A, 0x11DC913B, 0x01DC923C, 0x00DC923C, 0x00DC923C, 0x00DC923C, 0x00DC923C, 0x00DC923C, 0x00DC923C, 0x00DC923C, 0x00DC923C, 0x00DC923C, 0x00DC923C, 0x00DC913C, 
        0x00DC913B, 0x00DC913B, 0x00DC913B, 0x00DC913A, 0x00DC913B, 0x00DC9746, 0x00EB9C19, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81A, 
        0x00F3B23B, 0x02D5832B, 0x82CD6F0E, 0xF4CE7211, 0xFCCF7210, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xBEE89A1C, 0xA8EA9C1C, 0x90EB9D1C, 0x79EC9F1C, 0x62EDA01C, 0x4CEEA21C, 0x36EFA31C, 0x22F0A41B, 0x0FF2A61B, 0x01F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 
        0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F3A81B, 0x00F1A51B, 0x00F1A51A, 0x00F1A51A, 0x00F1A51A, 0x00F1A51A, 0x00F1A51A, 0x00F1A51A, 0x00F1A51A, 0x00F1A51A, 0x00F1A51A, 0x00F1A51A, 0x00F1A51A, 0x00F1A51A, 0x00F1A51A, 
        0x00F1A419, 0x00F1AF3C, 0x01D58227, 0x83CE700E, 0xF3CF7310, 0xFCD07410, 0xFF000000, 0xFF000000, 0xFF000000,
  0xB4E7971B, 0x9DE8991B, 0x84E99A1B, 0x6DE99B1A, 0x56EA9C1A, 0x40EA9C1A, 0x2CEB9D1A, 0x1AEC9E1A, 0x0BED9F19, 0x01EEA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 
        0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 0x00EDA01A, 
        0x00EDA01A, 0x00EDA018, 0x00EFAB3A, 0x02D68327, 0x84CF720F, 0xF4D07511, 0xFCD17510, 0xFF000000, 0xFF000000,
  0xB1E99A19, 0x98EA9B19, 0x80EA9B19, 0x68EA9A19, 0x51EA9B19, 0x3CEA9B19, 0x29EA9B18, 0x17EB9B18, 0x09EB9C18, 0x01EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 
        0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 0x00EB9C18, 
        0x00EB9C18, 0x00EB9C18, 0x00EB9B17, 0x00EDA93C, 0x01D68223, 0x84D07410, 0xF3D27611, 0xFCD27711, 0xFF000000,
  0xB0E99918, 0x98E99918, 0x7FE99918, 0x67E99918, 0x51E99918, 0x3BE99818, 0x28E99818, 0x17E89818, 0x09E89718, 0x01E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 
        0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 0x00E89718, 
        0x00E89718, 0x00E89718, 0x00E89718, 0x00E89716, 0x00EAA53A, 0x02D68222, 0x85D2760F, 0xF4D37812, 0xFBD37811,
  0xB0E79617, 0x98E79617, 0x7FE79617, 0x67E79617, 0x51E69617, 0x3BE69517, 0x28E69517, 0x17E69517, 0x09E59417, 0x01E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 
        0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 
        0x00E59417, 0x00E59417, 0x00E59417, 0x00E59417, 0x00E59316, 0x00E8A138, 0x01D78322, 0x86D37811, 0xF3D47912,
  0xB0E49216, 0x98E49216, 0x7FE49116, 0x67E49116, 0x51E39116, 0x3BE39016, 0x28E39016, 0x17E39016, 0x09E28F16, 0x01E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 
        0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 
        0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F14, 0x00E69F3A, 0x02D57D17, 0x91D47911,
  0xB0E28E15, 0x98E28D15, 0x7FE18D15, 0x67E18D15, 0x51E18D15, 0x3BE18C15, 0x28E18C15, 0x17E08C15, 0x09E08B15, 0x01E08B15, 0x00E08B15, 0x00E08B15, 0x00E08B15, 0x00E08B15, 0x00DF8B15, 0x00DF8A15, 0x00DF8A15, 0x00DE8915, 0x00DE8815, 0x00DE8815, 0x00DD8714, 
        0x00DD8714, 0x00DD8614, 0x00DD8614, 0x00DC8514, 0x00DC8514, 0x00DC8514, 0x00DC8514, 0x00DC8514, 0x00DC8514, 0x00DC8514, 0x00DC8514, 0x00DC8514, 0x00DC8514, 0x00DC8514, 0x00DD8614, 0x00DD8614, 0x00DD8614, 0x00DD8714, 0x00DD8714, 0x00DE8815, 
        0x00DE8815, 0x00DE8815, 0x00DF8915, 0x00DF8A15, 0x00DF8A15, 0x00DF8A15, 0x00E18F1E, 0x00D88421, 0x32D57B11,
  0xB0DE8914, 0x98DE8914, 0x7FDE8814, 0x67DE8714, 0x51DD8714, 0x3BDC8614, 0x28DC8513, 0x17DB8413, 0x09DA8213, 0x01D98113, 0x00D88013, 0x00D87F12, 0x00D77E12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 
        0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 
        0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67D12, 0x00D67C12, 0x00D78019, 0x00D88421, 0x07D67C11, 0x86D67D14,
  0xB0DA8313, 0x98DA8213, 0x7FDA8213, 0x67D98213, 0x51D98113, 0x3BD98112, 0x28D98012, 0x17D98012, 0x09D87F12, 0x01D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 
        0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 
        0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D87F12, 0x00D9831A, 0x00DA8825, 0x05D77D11, 0x66D78017, 0xADD67E16,
  0xB0DA8415, 0x98DA8315, 0x7FDA8315, 0x67DA8315, 0x51DA8315, 0x3BDA8315, 0x28DA8316, 0x17D98316, 0x09D98316, 0x01D98316, 0x00D98316, 0x00D98316, 0x00D98316, 0x00D98316, 0x00D98316, 0x00D98316, 0x00D98316, 0x00D98316, 0x00D98316, 0x00D98316, 0x00D98316, 
        0x00D98316, 0x00D98316, 0x00D98316, 0x00D98316, 0x00D98316, 0x00D98114, 0x00D98113, 0x00D98113, 0x00D98113, 0x00D98113, 0x00D98113, 0x00D98113, 0x00D98113, 0x00D98113, 0x00D98113, 0x00D98113, 0x00D98113, 0x00D98113, 0x00D98113, 0x00D98113, 
        0x00D98113, 0x00D98113, 0x00D98113, 0x00DA851B, 0x00DC8B29, 0x06D87F11, 0x5ED88217, 0x99D78118, 0xC4D67D14,
  0xB0DA8417, 0x98DA8417, 0x7FDA8417, 0x67DA8417, 0x51DA8517, 0x3BDB8518, 0x28DB8518, 0x17DB8518, 0x09DB8618, 0x01DB8618, 0x00DB8618, 0x00DB8618, 0x00DB8618, 0x00DB8618, 0x00DB8618, 0x00DB8618, 0x00DB8618, 0x00DB8618, 0x00DB8618, 0x00DB8618, 0x00DB8618, 
        0x00DB8618, 0x00DB8618, 0x00DB8618, 0x00DB8618, 0x00DB8618, 0x00DB8517, 0x00DA8313, 0x00DA8313, 0x00DA8313, 0x00DA8313, 0x00DA8313, 0x00DA8313, 0x00DA8313, 0x00DA8313, 0x00DA8313, 0x00DA8313, 0x00DA8313, 0x00DA8313, 0x00DA8313, 0x00DA8313, 
        0x00DA8313, 0x00DA8313, 0x00DB871B, 0x00DD8E2C, 0x04D98112, 0x5ED98318, 0x96D88118, 0xBFD77E14, 0xE1D67D12,
  0xB0DD922C, 0x98DD932E, 0x7FDD942F, 0x67DE9530, 0x51DE9631, 0x3BDE9732, 0x28DF9834, 0x17DF9935, 0x09DF9A37, 0x01E09C39, 0x00E09C39, 0x00E09C39, 0x00E09C39, 0x00E09C39, 0x00E09C39, 0x00E09C39, 0x00E09C39, 0x00E09C39, 0x00E09C39, 0x00E09C39, 0x00E09C39, 
        0x00E09C39, 0x00E09C39, 0x00E09C39, 0x00E09C39, 0x00E09C39, 0x00E09C3A, 0x00DC8717, 0x00DB8513, 0x00DB8513, 0x00DB8513, 0x00DB8513, 0x00DB8513, 0x00DB8513, 0x00DB8513, 0x00DB8513, 0x00DB8513, 0x00DB8513, 0x00DB8513, 0x00DB8513, 0x00DB8513, 
        0x00DB8513, 0x00DD891C, 0x00DF912E, 0x05DA8212, 0x5DDA8419, 0x96D98319, 0xBDD88015, 0xE0D77E12, 0xF4D67C12,
  0xB0E19E41, 0x98E19F43, 0x7FE1A045, 0x67E1A147, 0x51E3A34A, 0x3BE3A54D, 0x28E3A64F, 0x17E3A852, 0x09E4A954, 0x01E4AB57, 0x00E4AB57, 0x00E4AB57, 0x00E4AB57, 0x00E4AB57, 0x00E4AB57, 0x00E4AB57, 0x00E4AB57, 0x00E4AB57, 0x00E4AB57, 0x00E4AB56, 0x00E4AB56, 
        0x00E4AB56, 0x00E4AB56, 0x00E4AA56, 0x00E4A954, 0x00E4AA55, 0x00E7A25E, 0x00E08E29, 0x00DC8614, 0x00DC8614, 0x00DC8614, 0x00DC8614, 0x00DC8614, 0x00DC8614, 0x00DC8614, 0x00DC8614, 0x00DC8614, 0x00DC8614, 0x00DC8614, 0x00DC8614, 0x00DC8614, 
        0x00DE8B1D, 0x00E09330, 0x05DB8412, 0x5CDB861A, 0x96DA851A, 0xBED98215, 0xE0D88013, 0xF5D77E12, 0xFCD67D12,
  0xB2DE8E24, 0x99DE8E22, 0x81DD8D20, 0x69DD8C1E, 0x52DD8B1D, 0x3DDD8A1B, 0x29DD8919, 0x18DC8817, 0x0BDC8715, 0x05DC8613, 0x05DC8613, 0x05DC8613, 0x05DC8613, 0x05DC8613, 0x05DC8613, 0x05DC8613, 0x05DC8613, 0x05DC8613, 0x05DC8613, 0x05DC8613, 0x05DC8613, 
        0x05DC8613, 0x05DC8613, 0x05DC8613, 0x04DC8613, 0x01DC7510, 0x00DC3B05, 0x00E16D1C, 0x00DE8914, 0x00DE8814, 0x00DE8814, 0x00DE8814, 0x00DE8814, 0x00DE8814, 0x00DE8814, 0x00DE8814, 0x00DE8814, 0x00DE8814, 0x00DE8814, 0x00DE8814, 0x00DF8D1D, 
        0x00E19531, 0x05DC8513, 0x5CDC881B, 0x95DB871B, 0xBDDA8316, 0xE0D98113, 0xF4D88012, 0xFCD77E12, 0xFF000000,
  0xD9DF942D, 0xCFDF932C, 0xC3DF932C, 0xB8DF932C, 0xACDF932C, 0x9FDF932C, 0x92DF932C, 0x84DF932C, 0x76DF932C, 0x70DF932C, 0x71DF932C, 0x71DF932C, 0x71DF932C, 0x71DF932C, 0x71DF932C, 0x71DF932C, 0x71DF932C, 0x71DF932C, 0x71DF932C, 0x71DF932C, 0x71DF932C, 
        0x71DF932C, 0x71DF932C, 0x70DF922C, 0x6EDF8D2C, 0x5DDF7B25, 0x08DE570B, 0x00DF8B1E, 0x00DF8A15, 0x00DF8A15, 0x00DF8A15, 0x00DF8A15, 0x00DF8A15, 0x00DF8A15, 0x00DF8A15, 0x00DF8A15, 0x00DF8A15, 0x00DF8A15, 0x00DF8A15, 0x00E08F1E, 0x00E29732, 
        0x05DD8713, 0x5BDE8A1C, 0x95DC891C, 0xBCDB8516, 0xE0DA8313, 0xF4D98113, 0xFCD88013, 0xFF000000, 0xFF000000,
  0xE6DE8C1E, 0xDFDE8B1C, 0xD8DE8B1C, 0xD1DE8B1C, 0xC8DE8B1C, 0xC0DE8B1C, 0xB7DE8B1C, 0xAEDE8B1C, 0xA4DE8B1C, 0xA1DE8B1C, 0xA1DE8B1C, 0xA1DE8B1C, 0xA1DE8B1C, 0xA1DE8B1C, 0xA1DE8B1C, 0xA1DE8B1C, 0xA1DE8B1C, 0xA1DE8B1C, 0xA1DE8B1C, 0xA1DE8B1C, 0xA1DE8B1C, 
        0xA1DE8B1C, 0xA1DE8B1C, 0xA0DE891C, 0x9ADE821C, 0x8CDF791E, 0x1DDF8715, 0x00E08A15, 0x00E08C15, 0x00E08C15, 0x00E08C15, 0x00E08C15, 0x00E08C15, 0x00E08C15, 0x00E08C15, 0x00E08C15, 0x00E08C15, 0x00E08C15, 0x00E18F1D, 0x00E39832, 0x04DE8913, 
        0x5CDF8C1C, 0x95DD8B1D, 0xBDDC8717, 0xE0DB8514, 0xF4DA8313, 0xFCD98113, 0xFF000000, 0xFF000000, 0xFF000000,
  0xF5DD8815, 0xF2DD8815, 0xEEDD8815, 0xEBDD8815, 0xE8DD8815, 0xE4DD8815, 0xE0DD8815, 0xDCDD8815, 0xD8DD8815, 0xD6DD8815, 0xD6DD8815, 0xD6DD8815, 0xD6DD8815, 0xD6DD8815, 0xD6DD8815, 0xD6DD8815, 0xD6DD8815, 0xD6DD8815, 0xD6DD8815, 0xD6DD8815, 0xD6DD8815, 
        0xD6DD8815, 0xD6DD8715, 0xD5DD8615, 0xCCDD7F15, 0xB3DE7A15, 0x23DF8A15, 0x00E18C15, 0x00E18E15, 0x00E18E15, 0x00E18E15, 0x00E18E15, 0x00E18E15, 0x00E18E15, 0x00E18E15, 0x00E18E15, 0x00E18E15, 0x00E2921D, 0x00E49931, 0x05DF8A14, 0x5BE08E1D, 
        0x96DF8D1D, 0xBCDD8918, 0xE0DC8614, 0xF4DB8413, 0xFCDA8313, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFDDD8714, 0xFCDD8714, 0xFBDD8714, 0xFBDD8714, 0xFADD8714, 0xF9DD8714, 0xF9DD8714, 0xF7DD8714, 0xF7DD8714, 0xF7DD8714, 0xF7DD8714, 0xF7DD8714, 0xF7DD8714, 0xF7DD8714, 0xF7DD8714, 0xF7DD8714, 0xF7DD8714, 0xF7DD8714, 0xF7DD8714, 0xF7DD8714, 0xF7DD8714, 
        0xF7DD8714, 0xF7DD8714, 0xF5DD8714, 0xE9DE8514, 0xCADF8314, 0x27E18C15, 0x00E28E16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E28F16, 0x00E3931D, 0x00E59A30, 0x04E18C14, 0x5CE18F1D, 0x94E08E1E, 
        0xBDDF8A18, 0xDFDD8815, 0xF4DC8614, 0xFCDB8513, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFDDE8914, 0xF1DF8A15, 0xD1E08A15, 0x28E28E16, 0x00E39016, 0x00E49216, 0x00E49216, 0x00E49216, 0x00E49216, 0x00E49216, 0x00E49216, 0x00E49216, 0x00E5941D, 0x00E59A2E, 0x05E28E14, 0x5AE2911D, 0x95E1901E, 0xBCDF8C18, 
        0xE0DF8915, 0xF4DE8814, 0xFCDC8614, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFEE08C15, 0xF2E18D15, 0xD1E18D15, 0x28E28F16, 0x00E49217, 0x00E59317, 0x00E59317, 0x00E59317, 0x00E59317, 0x00E59317, 0x00E59317, 0x00E6951B, 0x00E69A2B, 0x03E28F15, 0x5BE3921C, 0x94E2911E, 0xBDE18E18, 0xDFDF8B16, 
        0xF4DF8915, 0xFCDE8814, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFEE28E16, 0xF2E28F16, 0xD1E28F16, 0x28E49216, 0x00E59317, 0x00E79517, 0x00E79517, 0x00E79517, 0x00E79517, 0x00E79517, 0x00E7971B, 0x00E79A27, 0x05E49115, 0x5AE4931C, 0x95E3931D, 0xBBE28F19, 0xE0E18C16, 0xF4E08B15, 
        0xFCDF8A15, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFEE39016, 0xF2E39016, 0xD1E39116, 0x28E59317, 0x00E69617, 0x00E89717, 0x00E89717, 0x00E89717, 0x00E89717, 0x00E8981B, 0x00E79A24, 0x03E59316, 0x5AE5941C, 0x95E4931D, 0xBDE39119, 0xDEE28E16, 0xF4E18C15, 0xFCE08B15, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFEE59217, 0xF2E59217, 0xD1E59217, 0x28E69517, 0x00E79718, 0x00E99918, 0x00E99918, 0x00E99918, 0x00E99A1C, 0x00E89B24, 0x04E69416, 0x58E6951B, 0x95E5941C, 0xBBE49219, 0xDFE39017, 0xF3E28E16, 0xFCE18C15, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFEE59417, 0xF2E59417, 0xD1E59417, 0x29E79617, 0x00E99918, 0x00EA9B18, 0x00EA9B18, 0x00EA9C1B, 0x00E99D24, 0x04E79617, 0x58E7961B, 0x94E6961C, 0xBCE59319, 0xDFE49117, 0xF4E39016, 0xFCE28E16, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFEE79517, 0xF2E79517, 0xD0E79517, 0x2AE89818, 0x00EA9B19, 0x00EB9D19, 0x00EB9E1C, 0x00EA9E25, 0x04E89717, 0x58E8981B, 0x94E7971B, 0xBBE69518, 0xDEE59317, 0xF3E49116, 0xFCE39016, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFEE89717, 0xF2E89617, 0xD0E89617, 0x2AE99918, 0x00EA6F10, 0x00EC9316, 0x00ECA430, 0x04E99917, 0x58E99A1B, 0x95E8991B, 0xBCE79618, 0xDFE69517, 0xF4E59317, 0xFCE49216, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFEE89818, 0xF2E89717, 0xD0E89317, 0x2AEA9016, 0x00EA4708, 0x00EC8621, 0x03EDA632, 0x57EA9C1D, 0x93E99B1D, 0xBBE89819, 0xDEE79617, 0xF3E69517, 0xFCE59317, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFEEA9718, 0xF2EA9517, 0xD1EA8F16, 0x2BEB7110, 0x00EB4E09, 0x04EFAE4A, 0x57ECA02C, 0x94EA9D22, 0xBBE99A1B, 0xDFE89818, 0xF4E79617, 0xFCE69517, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFEEB9617, 0xF6EB9317, 0xDCEB8C16, 0x82EC7612, 0x3CED7810, 0x78EEA338, 0xA9EC9B2A, 0xC7EB9D21, 0xE3E99A1A, 0xF5E89818, 0xFCE79617, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000
};

GUI_CONST_STORAGE GUI_BITMAP bmnext = {
  50,                        /* xSize                   */
  45,                        /* ySize                   */
  200,                       /* BytesPerLine            */
  32,                        /* BitsPerPixel            */
  (unsigned char *)_acnext,  /* Pointer to picture data */
  NULL,                      /* Pointer to palette      */
  GUI_DRAW_BMP8888
};

/**
  * @}
  */

/**
  * @}
  */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
