/**
  ******************************************************************************
  * This file is part of the TouchGFX 4.10.0 distribution.
  *
  * <h2><center>&copy; Copyright (c) 2018 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under Ultimate Liberty license
  * SLA0044, the "License"; You may not use this file except in compliance with
  * the License. You may obtain a copy of the License at:
  *                             www.st.com/SLA0044
  *
  ******************************************************************************
  */
  

#ifndef GAME_2048_VIEW_HPP
#define GAME_2048_VIEW_HPP

#include <gui/common/DemoView.hpp>
#include <gui/game2048_screen/Game2048Presenter.hpp>
#include <touchgfx/widgets/Image.hpp>
#include <touchgfx/widgets/TextAreaWithWildcard.hpp>
#include <touchgfx/widgets/Box.hpp>
#include <touchgfx/widgets/Button.hpp>
#include <touchgfx/widgets/ToggleButton.hpp>
#include <touchgfx/mixins/MoveAnimator.hpp>
#include <touchgfx/mixins/FadeAnimator.hpp>
#include <gui/game2048_screen/GameBoard.hpp>
#include <touchgfx/mixins/FadeAnimator.hpp>
#include <touchgfx/mixins/MoveAnimator.hpp>
#include <gui/common/SwipeContainer.hpp>
#include <touchgfx/containers/ListLayout.hpp>

class Game2048View : public DemoView<Game2048Presenter>
{
public:
    Game2048View();
    virtual ~Game2048View();

    virtual void setupScreen();
    virtual void tearDownScreen();

    virtual void screenSaverMinorTick();

private:
    static const int NUMBER_OF_INSTRUCTIONS = 3;

    Image background;

    GameBoard gameBoard;
    int currentScore;

    TextAreaWithOneWildcard scoreTxt;
    Unicode::UnicodeChar scoreTxtbuf[10];

    FadeAnimator<MoveAnimator<TextAreaWithOneWildcard> > deltaScoreTxt;
    Unicode::UnicodeChar deltaScoreTxtbuf[10];

    Button newGameButton;
    ToggleButton autoPlayButton;
    Button howToPlayButton;

    Box overlay;
    Image popUp;

    SwipeContainer howToPlayInstructionContainer;
    Container howToPlayInstructionExtraSpaceContainer[NUMBER_OF_INSTRUCTIONS];
    Image howToPlayInstruction[NUMBER_OF_INSTRUCTIONS];
    
    Button closeHowToPlayButton;

    Image endGameStatus;

    Callback<Game2048View, const GameBoard& > moveCompletedCallback;
    Callback<Game2048View, const GameBoard& > gameWonCallback;
    Callback<Game2048View, const GameBoard& > gameLostCallback;
    Callback<Game2048View, const AbstractButton& > buttonPressedCallback;

    void moveCompletedHandler(const GameBoard& gb);
    void gameWonHandler(const GameBoard& gb);    
    void gameLostHandler(const GameBoard& gb);

    void buttonPressedHandler(const AbstractButton& button);
 
    void updateScoreText();
    void showDeltaScoreText(int deltaScore);
    void showHowToPlayPopUp(bool visible);

    void startNewGame();
};

#endif // GAME_2048_VIEW_HPP
