/**
  ******************************************************************************
  * This file is part of the TouchGFX 4.10.0 distribution.
  *
  * <h2><center>&copy; Copyright (c) 2018 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under Ultimate Liberty license
  * SLA0044, the "License"; You may not use this file except in compliance with
  * the License. You may obtain a copy of the License at:
  *                             www.st.com/SLA0044
  *
  ******************************************************************************
  */
  

#include <gui/graph_screen/Graph.hpp>
#include <touchgfx/Color.hpp>
#include <touchgfx/EasingEquations.hpp>
#include <math.h>

Graph::Graph() :
    myAlpha(255)
{
}

Graph::~Graph()
{
}

void Graph::setup(int newWidth, int newHeight, uint16_t lineColor, uint16_t backgroundColor)
{
    setWidth(newWidth);
    setHeight(newHeight);
    
    graphLinePainter.setColor(lineColor);
    graphAreaPainter.setColor(lineColor, getHeight());
    graphDotsPainter.setColor(lineColor);
    graphDotsBackgroundPainter.setColor(backgroundColor);

    graphLine.setLinkedGraph(graphArea);
    graphLine.setLinkedGraph(graphDots);
    graphLine.setLinkedGraph(graphDotsBackground);

    graphLine.setPosition(0, 0, getWidth(), getHeight());
    graphLine.setPainter(graphLinePainter);
    graphLine.setBuffer(graphBuffer, NUMBER_OF_POINTS);
    graphLine.setLineWidth(1);
    graphLine.setRange(-1, 77, 400, 0);

    graphArea.setPainter(graphAreaPainter);
    graphArea.setLineWidth(0);

    graphDots.setPainter(graphDotsPainter);
    graphDots.setLineWidth(7);
    graphDots.setDotShape(0, 90);

    graphDotsBackground.setPainter(graphDotsBackgroundPainter);
    graphDotsBackground.setLineWidth(9);
    graphDotsBackground.setDotShape(0, 30);

    add(graphArea);
    add(graphLine);
    add(graphDotsBackground);
    add(graphDots);
}

void Graph::setRange(int left, int right, int top, int bottom) 
{ 
    graphLine.setRange(left, right, top, bottom); 
}

void Graph::setLineVisible(bool lineVisible)
{
    graphLine.setVisible(lineVisible);
}

void Graph::setDotsVisible(bool dotsVisible)
{
    graphDots.setVisible(dotsVisible);
}

void Graph::setDotsBackgroundVisible(bool dotsBackgroundVisible)
{
    graphDotsBackground.setVisible(dotsBackgroundVisible);
}

void Graph::setAreaVisible(bool areaVisible)
{
    graphArea.setVisible(areaVisible);
}

void Graph::setDotShape(int startAngle, int angleStep, int lineWidth)
{
    graphDots.setDotShape(startAngle, angleStep);
    graphDots.setLineWidth(lineWidth);
    graphDots.invalidate();
}

void Graph::setDotBackgroundShape(int startAngle, int angleStep, int lineWidth)
{
    graphDotsBackground.setDotShape(startAngle, angleStep);
    graphDotsBackground.setLineWidth(lineWidth);
    graphDots.invalidate();
}

void Graph::setAlpha(uint8_t alpha)
{
    myAlpha = alpha;
    graphLine.setAlpha(myAlpha);
    graphArea.setAlpha(myAlpha);
    graphDots.setAlpha(myAlpha);
    graphDotsBackground.setAlpha(myAlpha);
    invalidate();
}

uint8_t Graph::getAlpha()
{
    return myAlpha;
}
