#include "mod_proc.h"

ssize_t proc_node_read( char *buffer, char **start, off_t off,
                        int count, int *eof, void *data ) {
   static int offset = 0, i;
   printk( KERN_INFO "read: %d\n", count );
   for( i = 0; offset <= LEN_MSG && '\0' != buf_msg[ offset ]; offset++, i++ )
      *( buffer + i ) = buf_msg[ offset ];
   *( buffer + i ) = '\n';
   i++;
   if( offset >= LEN_MSG || '\0' == buf_msg[ offset ] ) {
      offset = 0;
      *eof = 1;
   }
   else *eof = 0;
   printk( KERN_INFO "return bytes: %d\n", i );
   if( *eof != 0 ) printk( KERN_INFO "EOF\n" );
   return i;
};

static int __init proc_init( void ) {
   if( create_proc_read_entry( NAME_NODE, 0, NULL, proc_node_read, NULL ) == 0 ) {
      printk( KERN_ERR "can't create /proc/%s\n", NAME_NODE );
      return -ENOMEM;
   }
   printk( KERN_INFO "module : success!\n");
   return 0;
}

static void __exit proc_exit( void ) {
  remove_proc_entry( NAME_NODE, NULL );
  printk(KERN_INFO "/proc/%s removed\n", NAME_NODE );
}

