#include "mod_proc.h"

static int mode = 0; 
module_param( mode, int, S_IRUGO );

ssize_t proc_node_read( char *buffer, char **start, off_t off,
                        int count, int *eof, void *data ) {
   static char buf_msg1[ LEN_MSG + 1 ] = "функция из struct proc_dir_entry";
   static int offset = 0, i;
   printk( KERN_INFO "read: %d\n", count );
   for( i = 0; offset <= LEN_MSG && '\0' != buf_msg1[ offset ]; offset++, i++ )
      *( buffer + i ) = buf_msg1[ offset ];
   *( buffer + i ) = '\n';
   i++;
   if( offset >= LEN_MSG || '\0' == buf_msg1[ offset ] ) {
      offset = 0;
      *eof = 1;
   }
   else *eof = 0;
   printk( KERN_INFO "return bytes: %d\n", i );
   if( *eof != 0 ) printk( KERN_INFO "EOF\n" );
   return i;
};

static ssize_t node_read( struct file *file, char *buf,
                          size_t count, loff_t *ppos ) {
   static char buf_msg1[ LEN_MSG + 1 ] = "функция из таблицы файловых операций";
   static int odd = 0;
   printk( KERN_INFO "read: %d\n", count );
   if( 0 == odd ) {
      int res = copy_to_user( (void*)buf, &buf_msg1, strlen( buf_msg1 ) );
      odd = 1;
      put_user( '\n', buf + strlen( buf_msg1 ) );
      res = strlen( buf_msg1 ) + 1;
      printk( KERN_INFO "return bytes :  %d\n", res );
      return res;
   }
   odd = 0;
   printk( KERN_INFO "EOF\n" );
   return 0;
}

static const struct file_operations node_fops = {
   .owner = THIS_MODULE,
   .read  = node_read,
};

static int __init proc_init( void ) {
   int ret;
   struct proc_dir_entry *own_proc_node;
   own_proc_node = create_proc_entry( NAME_NODE, S_IFREG | S_IRUGO | S_IWUGO, NULL );
   if( NULL == own_proc_node ) {
      ret = -ENOMEM;
      printk( KERN_ERR "can't create /proc/%s\n", NAME_NODE );
      goto err_node;
   }
   own_proc_node->uid = 0;
   own_proc_node->gid = 0;
   if( mode !=1 )
      own_proc_node->read_proc = proc_node_read;
   if( mode !=2 )
      own_proc_node->proc_fops = &node_fops;
   printk( KERN_INFO "module : success!\n");
   return 0;
err_node:
  return ret;
}

static void __exit proc_exit( void ) {
  remove_proc_entry( NAME_NODE, NULL );
  printk(KERN_INFO "/proc/%s removed\n", NAME_NODE );
}

