#include <linux/fs.h>
#include <linux/init.h>
#include <linux/module.h>
#include <asm/uaccess.h>

MODULE_LICENSE( "GPL" );
MODULE_AUTHOR( "Oleg Tsiliuric <olej@front.ru>" );
MODULE_VERSION( "5.2" );

static char *hello_str = "Hello, world!\n";   // buffer!

static ssize_t hello_read( struct file * file, char * buf,
                           size_t count, loff_t *ppos ) {
   int len = strlen( hello_str );
   if( count < len ) return -EINVAL;
   if( *ppos != 0 ) return 0;
   if( copy_to_user( buf, hello_str, len ) ) return -EINVAL;
   *ppos = len;
   return len;
}

static int __init hello_init( void );
module_init( hello_init );

static void __exit hello_exit( void );
module_exit( hello_exit );

