;----------------------------------------------------------------------------------- ---- --- -- - -  -  player constants
ini_indexed_mask = 1
ini_indexmask_size = 32
ini_relative = 1
ini_mus_loop = 1

ini_mus_stack = #6000
mus_data_adr  = #c000

max_inner_call = 7

;----------------------------------------------------------------------------------- ---- --- -- - -  -  description
; psg_player_fast_v1.0  by  tmk & bfox
;-------------------------------------
; speed-optimized player for psg-packer v1.0 (zx-spectrum) with self-modifyed code (use in RAM only)
;
; there're 3 entry points:  <mus_init> - initialise the player
;                           <mus_play> - unpack and play one frame of music
;                           <mus_stop> - shut down the playback (only <in ini_mus_loop=0> mode!)
;
; trashed regs:	HL,DE,BC,AF,AF'
;
; WARNING: in <ini_indexed_mask=1> mode <mus_data_adr> must be aligned to 256 bytes
;          in <ini_relative=0> mode <mus_data_adr> must be placed at #c000 (49152) only!
;
;----------------------------------------------------------------------------------- ---- --- -- - -  -  test code
		device	zxspectrum128

		org	#8000
code_run
		ld	hl,mus_data_adr
		call	mus_init

loop		xor a : out (#fe),a
		ei : halt

		ld	bc,850
1		dec	bc
		inc	b
		djnz	1b

		ld a,4 : out (#fe),a
		call	mus_play

		jp	loop
;----------------------------------------------------------------------------------- ---- --- -- - -  -  initialization
mus_init
;------------------------------------------ ---- --- -- - -  -   -    -

		  ld	hl,ini_mus_stack
		  ld	(mus_stack_adr),hl
		if ini_indexed_mask = 1
		  ld	hl,ini_indexmask_size * 2 + mus_data_adr
		else
		  ld	hl,mus_data_adr
		endif
		  ld	(mus_adr),hl
		if ini_mus_loop = 1
		  ld	(mus_loop_adr),hl
		else

;----------------------------------------------------------------------------------- ---- --- -- - -  -  shut'em up
mus_stop
;------------------------------------------ ---- --- -- - -  -   -    -
		ld	c,#fd
		ld	h,#bf
		ld	de,#0d00
1		ld	b,c
		out	(c),d
		ld	b,h
		out	(c),e
		dec	d
		jp	p,1b
	endif
		ret
;___________________________________________________________________________________ ____ ___ __ _ _  _

mus_wait	dec	a
		ld	(mus_pause),a
		ret
;----------------------------------------------------------------------------------- ---- --- -- - -  -  music playback
mus_play	
;------------------------------------------ ---- --- -- - -  -   -    -
		ld	a,0
mus_pause	  equ $-1
		or	a
		jr	nz,mus_wait

;----------------------------------------------------------------------------------------- ----- ---- --- -- - -  -   -
;11hhhhhh , llllllll , nnnnnnnn - mus_call_n - play  N frames from mus_adr-00hhhhhh llllllll
;10hhhhhh , llllllll            - call_1 - play one frame from mus_adr-00hhhhhh llllllll
;01mmmmmm , mmmmmmmm ,  ......  - playback of psg2, where mmmmmm mmmmmmmm is a binary mask of AY-registers, then values
;001nnnnn                       - number of indexed mask in table (first 32 bytes of data block)
;0001pppp               - pause16 pppp+1 (1..16)
;0000hhhh , vvvvvvvv    - playback of psg1 (0000hhhh - register number + 1, vvvvvvvv - value)
;00001111               - end of playback (shutdown AY-chip or loop track)
;00000000 , nnnnnnnn    - wait for nnnnnnnn+1 frames (put nothing to registers)
;----------------------------------------------------------------------------------------- ----- ---- --- -- - -  -   -

		if ini_indexed_mask = 1
		  ld	hl,mus_data_adr + ini_indexmask_size * 2
		else
		  ld	hl,mus_data_adr
		endif
mus_adr		  equ $-2
		or	(hl)
		inc	hl
		jp	m,mus_links
mus_adr_loop	jr	z,mus_pause_n
	if ini_indexed_mask = 1
		sub	64
		jr	nc,mus_psg2
		sub	224
		jp	nc,mus_psg2_index
		add	a,17
		  if ini_mus_loop = 1
		     jr	z,mus_loop
		  else
		     jr	z,mus_stop
		  endif
		jp	nc,mus_psg1
		dec	a
	else
		cp	64
		jp	nc,mus_psg2
		cp	15
		  if ini_mus_loop = 1
		     jr	z,mus_loop
		  else
		     jr	z,mus_stop
		  endif
		jr	c,mus_psg1
		and	15
	endif
;-----------------------------------------------------------------------------------------
;0001pppp - pause16 pppp+1 (1..16)
;-----------------------------------------------------------------------------------------
mus_pause16
		ld	(mus_pause),a
		jp	mus_com_exit

;-----------------------------------------------------------------------------------------
;0000hhhh , vvvvvvvv	- playback psg1 (0000hhhh - register number + 1, vvvvvvvv - value)
;-----------------------------------------------------------------------------------------
mus_psg1
	if ini_indexed_mask = 1
		sub	#f2
	else
		dec	a
	endif
		ld	bc,#fdfd
		out	(c),a
		ld	b,#bf
		outi
		jp	mus_com_exit
;-----------------------------------------------------------------------------------------
;00000000 , nnnnnnnn - wait for nnnnnnnn+1 frames (put nothing to registers)
;-----------------------------------------------------------------------------------------
mus_pause_n
		ld	a,(hl)		;7
		inc	hl		;6
		ld	(mus_pause),a	;13
		jp	mus_com_exit
;-----------------------------------------------------------------------------------------
;00001111 - end of playback (shutdown AY-chip or loop track)
;-----------------------------------------------------------------------------------------
	  if ini_mus_loop = 1
mus_loop	
	  if ini_indexed_mask = 1
		ld	hl,ini_indexmask_size * 2 + mus_data_adr
	  else
		ld	hl,mus_data_adr
	  endif
mus_loop_adr	equ $-2

		or	(hl)
		inc	hl
		jp	mus_adr_loop
	endif
;-----------------------------------------------------------------------------------------------------------
;01mmmmmm , mmmmmmmm - playback of psg2, where mmmmmm mmmmmmmm is a binary mask of AY-registers, then values
;-----------------------------------------------------------------------------------------------------------
mus_psg2
		ex	af,af
		ld	a,(hl)
		inc	hl
	if ini_indexed_mask = 1
		jp	mus_psg2_
;-----------------------------------------------------------------------------------------------------------
;001nnnnn - number of indexed mask in table (first 2*ini_indexmask_size bytes of data block)
;-----------------------------------------------------------------------------------------------------------
mus_psg2_index
		add	a,a
		ld	e,a
		ld	d,high mus_data_adr
		ld	a,(de)
		inc	e
		ex	af,af
		ld	a,(de)
	endif
;______________________________________ _____ ____ ___ __ _ _  _   _    _
mus_psg2_
		ld	bc,#fdfd
		ld	de,#00bf

		rra
		jr	nc,1F
		out	(c),d
		ld	b,e
		outi
1		inc	d

		   dup	7
		rra
		jr	nc,1F
		ld	b,c
		out	(c),d
		ld	b,e
		outi
1		inc	d
		   edup
		ex	af,af
		   dup	5
		rra
		jr	nc,1F
		ld	b,c
		out	(c),d
		ld	b,e
		outi
1		inc	d
		   edup
		rra
		jr	nc,1f
		ld	b,c
		out	(c),d
		ld	b,e
		outi
1
;--------------------------------------------------------------------- ----- ---- --- -- - -  -   -   -    -
mus_com_exit
		ld	(mus_adr),hl

		ld	a,(mus_stack_adr)
		ld	hl,ini_mus_stack + 2

		if   max_inner_call > 1
		dup  max_inner_call - 1
		  cp	L
		  ret	c
		  dec	(hl)
		  jr	z,mus_call_ret
		  inc	L,L,L
		edup
		endif
		  cp	L
		  ret	c
		  dec	(hl)
		  ret	nz
mus_call_ret
		dec	L
		ld	d,(hl)
		dec	L
		ld	e,(hl)

		ld	(mus_stack_adr),hl
		ld	(mus_adr),de
		ret
;----------------------------------------------------------------------------------------------------- ----- ---- --- -- - -  -   -   -    -
;                  :

; PORT      MASK FOR 48k        MASK FOR 128k/+2       MASK FOR +2a/+2b/+3 
;#fe     xxxxxxxx xxxxxxx0      xxxxxxxx xxxxxxx0       xxxxxxxx xxxxxxx0
;#7ffd          n/a             0xxxxxxx xxxxxx0x       01xxxxxx xxxxxx0x
;#1ffd          n/a                    n/a              0001xxxx xxxxxx0x
;#bffd          n/a             10xxxxxx xxxxxx0x       10xxxxxx xxxxxx0x
;#fffd          n/a             11xxxxxx xxxxxx0       11xxxxxx xxxxxx0

;---------------------------------------------------------------------------------------
;11hhhhhh , llllllll , nnnnnnnn	- call_n - play  N frames from mus_adr-00hhhhhh llllllll
;10hhhhhh , llllllll		- call_1 - play one frame from mus_adr-00hhhhhh llllllll
;---------------------------------------------------------------------------------------
mus_links
		ld	c,(hl)
		inc	hl
		ld	de,ini_mus_stack
mus_stack_adr	  equ $-2

	if ini_relative = 0
		ld	b,a
	endif
		sub	%11000000
		jr	c,mus_call_one
;.......................................................................................
mus_call_n
	if ini_relative = 1
		ld	b,a
	endif
		ld	a,(hl)
		inc	hl

		ex	de,hl
		ld	(hl),e
		inc	L
		ld	(hl),d
		inc	L
		ld	(hl),a
		inc	L
		ld	(mus_stack_adr),hl
	if ini_relative = 1
		ex	de,hl
		sbc	hl,bc
	else
		ld	h,b,l,c
	endif
		xor	a
		jp	mus_adr + 2
;.......................................................................................
mus_call_one
	if ini_relative = 1
		sub	%11000000
		ld	b,a
	endif
		ex	de,hl
		ld	(hl),e
		inc	L
		ld	(hl),d
		inc	L
		ld	(hl),01
		inc	L
		ld	(mus_stack_adr),hl

	if ini_relative = 1
		ex	de,hl
		sbc	hl,bc
	else
		ld	h,a,l,c
	endif
		xor	a
		jp	mus_adr + 2

;----------------------------------------------------------------------------------------------------- ----- ---- --- -- - -  -   -   -    -
code_end

	display "------------------------------------------"
	display	"mus_stack: ", /a, ini_mus_stack, " ... ", /a, max_inner_call*3+ini_mus_stack
	display "------------------------------------------"
	display "start:  ", /a, code_run, " bytes"
	display "total:  ", /a, code_end - code_run, " bytes"
	display "player: ", /a, code_end - mus_init, " bytes"
	display "------------------------------------------"

	org	mus_data_adr

	INCBIN	"music.psg.packed"

;	savesna "c:\Program Files\UnrealSpeccy\Qsave1.sna", code_run
;	savesna "c:\Program Files (x86)\UnrealSpeccy\Qsave1.sna", code_run
