;----------------------------------------------------------------------------------- ---- --- -- - -  -  player constants
ini_indexed_mask = 0
ini_indexmask_size = 32
ini_relative = 0
ini_mus_loop = 1

ini_mus_stack = #6000
mus_data_adr  = #c000

max_inner_call = 7
;------------------------------------------------------- ---- --- -- - -  -   -    -
	if max_inner_call < 2
max_inner_call=2
	endif
;----------------------------------------------------------------------------------- ---- --- -- - -  -  description
; psg_player_direct_v1.0  by  tmk & bfox
;---------------------------------------
; speed-optimized player for psg-packer v1.0 (zx-spectrum) with self-modifyed code (use in RAM only),
; designed to be used in border, multicolor and other precisely timed effects.
;
; there're 3 entry points:  <mus_init> - initialise the player
;                           <mus_play> - unpack and play one frame of music (always constant time!)
;                           <mus_stop> - shut down the playback (only <in ini_mus_loop=0> mode!)
;
; the number of t-states in <mus_play> is 1086 + max_inner_call*41 + ini_relative*13 + ini_indexed_mask*34 (without call)
;
; trashed regs:	HL,DE,BC,AF,AF'
;
; WARNING: in <ini_indexed_mask=1> mode <mus_data_adr> must be aligned to 256 bytes.
;          in <ini_relative=0> mode <mus_data_adr> must be placed at #c000 (49152) only!
;          player can be used only if <call-to-call> packing option is disabled!
;
;----------------------------------------------------------------------------------- ---- --- -- - -  -  test code
	device	zxspectrum128

		org	#8000
code_run
		call	mus_init

		di
		ld hl,#c9fb	; ei:ret
		ld (#5c77),hl
		ld a,37,i,a
		im 2
		ei

loop		halt

		ld	bc,893+max_inner_call-ini_indexed_mask*2+ini_relative

1		dec	bc
		inc	b
		djnz	1b

		ld	a,2 : out (#fe),a	;18
		call	mus_play		;17
		xor	a   : out (#fe),a	;15

		jr	loop			;12

;----------------------------------------------------------------------------------- ---- --- -- - -  -  initialization
mus_init
;------------------------------------------------------- ---- --- -- - -  -   -    -

		  ld	hl,ini_mus_stack
		  ld	(mus_stack_adr),hl
		if ini_indexed_mask = 1
		  ld	hl,ini_indexmask_size * 2 + mus_data_adr
		else
		  ld	hl,mus_data_adr
		endif
		  ld	(mus_adr),hl
		if ini_mus_loop = 1
		  ld	(mus_loop_adr),hl
		else

;----------------------------------------------------------------------------------- ---- --- -- - -  -  shut'em up
mus_stop
		ld	c,#fd
		ld	h,#bf
		ld	de,#0d00
1		ld	b,c
		out	(c),d
		ld	b,h
		out	(c),e
		dec	d
		jp	p,1b

	if ini_indexed_mask = 1					
		cp	(hl) : xor a
		ld	b,18 : djnz $
	else
		xor a
		ld	b,17 : djnz $
	endif
		if	max_inner_call>2
		dup 	max_inner_call-2
		ld	b,3 : djnz $
		edup
		endif
	endif
		ret
;__________________________________________________________________________ ____ ___ __ _ _  _   _    _

mus_wait	dec	a
		ld	(mus_pause),a

	if ini_indexed_mask = 1
	  if ini_relative = 1
		ld	b,89
	  else
		ld	b,88
	  endif
		djnz	$
		inc	bc
	else
	  if ini_relative = 1
		ld	b,86
	  else
		ld	b,85
	  endif
		djnz	$
		cp (hl) : xor a
	endif
		if	max_inner_call>2
		dup	max_inner_call-2
		ld	b,3
		djnz	$
		edup
		endif

		ret

;----------------------------------------------------------------------------------- ---- --- -- - -  -  music playback
mus_play	
;------------------------------------------------------- ---- --- -- - -  -   -    -

		ld	a,0			;7
mus_pause	  equ $-1
		or	a			;4
		jr	nz,mus_wait		;7/12

;----------------------------------------------------------------------------------------- ----- ---- --- -- - -  -   -
;11hhhhhh , llllllll , nnnnnnnn - mus_call_n - play  N frames from mus_adr-00hhhhhh llllllll
;10hhhhhh , llllllll            - call_1 - play one frame from mus_adr-00hhhhhh llllllll
;01mmmmmm , mmmmmmmm ,  ......  - playback of psg2, where mmmmmm mmmmmmmm is a binary mask of AY-registers, then values
;001nnnnn                       - number of indexed mask in table (first 32 bytes of data block)
;0001pppp               - pause16 pppp+1 (1..16)
;0000hhhh , vvvvvvvv    - playback of psg1 (0000hhhh - register number + 1, vvvvvvvv - value)
;00001111               - end of playback (shutdown AY-chip or loop track)
;00000000 , nnnnnnnn    - wait for nnnnnnnn+1 frames (put nothing to registers)
;----------------------------------------------------------------------------------------- ----- ---- --- -- - -  -   -

		call	mus_go		;17
muz_nolink	

	if ini_relative = 1
		ld	b,11
	else
		ld	b,10
	endif
		djnz	$
		inc	bc
		pop	hl
		jp	(hl)
mus_go
;.............................................................................. ..... .... ... .. . .  .   .
	if ini_indexed_mask = 1
		ld	hl,mus_data_adr + ini_indexmask_size * 2	;10
	else
		ld	hl,mus_data_adr					;..
	endif
mus_adr		  equ $-2

		or	(hl)			;7
		inc	hl			;6
		jp	m,mus_links		;10
		;-------------------------------	<--- 68
mus_links_cycle	jr	z,mus_pause_n		;7/12
		;-------------------------------	<--- 75

	if ini_indexed_mask = 1					
		sub	64			;7
		jr	nc,mus_psg2		;7/12
		;-------------------------------	<--- 89
		sub	224			;7	
		jp	nc,mus_psg2_index	;10
		;-------------------------------	<--- 106
		add	a,17			;7		
		  if ini_mus_loop = 1			;<-- 113
		     jr	z,mus_loop		;7/12
		  else
		     jr	z,mus_stop		;-	--
		  endif
		;------------------------------- 	<--- 120
		jr	nc,mus_psg1		;7/12
		dec	a			;4
	else						;<== 131
		cp	64			;7
		jp	nc,mus_psg2		;10
		;-------------------------------	<--- 92
		cp	15			;7
		  if ini_mus_loop = 1			;<-- 99
		     jr	z,mus_loop		;7/12
		  else
		     jr	z,mus_stop		;-	--
		  endif
		;------------------------------- 	<--- 106
		jr	c,mus_psg1		;7/12
		and	15			;7
	endif					;	<=== 120

;-----------------------------------------------------------------------------------------------------------
;0001pppp - pause16 pppp+1 (1..16)
;-----------------------------------------------------------------------------------------------------------
mus_pause16
		ld (mus_pause),a	;13

	if  ini_indexed_mask = 1

		ld b,54			;7
		djnz $			;53*13+8=697
		ld c,b			;4
		add hl,bc		;11
	else
		ld b,53
		djnz $
		ret c
	endif
		jp  mus_com_exit		;10

;-----------------------------------------------------------------------------------------------------------
;0000hhhh , vvvvvvvv	- playback psg1 (0000hhhh - register number + 1, vvvvvvvv - value)
;-----------------------------------------------------------------------------------------------------------
mus_psg1
	if ini_indexed_mask = 1
		sub	#f2		;7

		cp (hl)	: cp (hl)	;14
		ld b,51	: djnz $	;7 + 50*13 + 8 = 665
	else
		dec	a		;4

		ret nc  : ret nc	;10	C is always set here
		ld b,50 : djnz $	;652
	endif
		ld	bc,#fdfd	;10
		out	(c),a		;12
		ld	b,#bf		;7
		outi			;16
		jp	mus_com_exit	;10

;-----------------------------------------------------------------------------------------------------------
;00000000 , nnnnnnnn - wait for nnnnnnnn+1 frames (put nothing to registers)
;-----------------------------------------------------------------------------------------------------------
mus_pause_n
		ld	de,mus_pause	;10
		ldi			;16

		  if ini_indexed_mask = 1
			ld b,57
			djnz $
			cp (hl)
			cp (hl)
		  else
		  	ld b,55
		  	djnz $
		  	inc bc
		  endif

		jp	mus_com_exit	;10

;-----------------------------------------------------------------------------------------------------------
;00001111 - end of playback (shutdown AY-chip or loop track)
;-----------------------------------------------------------------------------------------------------------
		if ini_mus_loop = 1
mus_loop
		  if ini_indexed_mask = 1
			ld	hl,ini_indexmask_size * 2 + mus_data_adr
mus_loop_adr		equ $-2
			or	(hl)
			inc	l
		  else
			pop	hl
			ld	hl,mus_data_adr
mus_loop_adr		equ $-2
			or	(hl)
			inc	l
			
		    if ini_relative = 1
			ld	b,5
		    else
			ld	b,4
		    endif
			djnz	$
			cp (hl):cp (hl)
		  endif
			jp	mus_links_cycle
		endif
;-----------------------------------------------------------------------------------------------------------
w0r	cp (hl):cp (hl)		;14
	djnz	r0r		;13
w1r	cp	(iy)		;19
	jr	r1r		;12
w2r	cp	(iy)		;19
	jr	r2r		;12
w3r	cp	(iy)		;19
	jr	r3r		;12
w4r	cp	(iy)		;19
	jr	r4r		;12
w5r	cp	(iy)		;19
	jr	r5r		;12
w6r	cp	(iy)		;19
	jr	r6r		;12
w7r	cp	(iy)		;19
	jr	r7r		;12
w8r	cp	(iy)		;19
	jr	r8r		;12
w9r	cp	(iy)		;19
	jr	r9r		;12
;-----------------------------------------------------------------------------------------------------------
;01mmmmmm , mmmmmmmm - playback of psg2, where mmmmmm mmmmmmmm is a binary mask of AY-registers, then values
;-----------------------------------------------------------------------------------------------------------
mus_psg2
		ex	af,af		;4
		ld	a,(hl)		;7
		inc	hl		;6 //17		//109

	if ini_indexed_mask = 1

		cp (hl) : cp (hl) : inc bc	;20
		jr mus_psg2_			;12

;-----------------------------------------------------------------------------------------------------------
;001nnnnn - number of indexed mask in table (first 2*ini_indexmask_size bytes of data block)
;-----------------------------------------------------------------------------------------------------------
mus_psg2_index
		add	a,a			;4
		ld	e,a			;4
		ld	d,high mus_data_adr	;7
		ld	a,(de)			;7
		inc	e			;4
		ex	af,af			;4
		ld	a,(de)			;7 //37
	endif
;-----------------------------------------------------------------------------------------------------------
mus_psg2_
	ld	bc,#fdfd	;10
	ld	de,#00bf	;10
	;---------------------------- //20
	rra			;4
	jr	nc,w0r		;7/12
	out	(c),d		;12
	ld	b,e		;4
	outi			;16
r0r	inc	d		;4
	;---------------------------- //47
	rra			;4
	jr	nc,w1r		;7/12
	ld	b,c		;4
	out	(c),d		;12
	ld	b,e		;4
	outi			;16
r1r	inc	d		;4	
	;---------------------------- //51
	rra			;4
	jr	nc,w2r		;7/12
	ld	b,c		;4
	out	(c),d		;12
	ld	b,e		;4
	outi			;16
r2r	inc	d		;4	
	;---------------------------- //51
	rra			;4
	jr	nc,w3r		;7/12
	ld	b,c		;4
	out	(c),d		;12
	ld	b,e		;4
	outi			;16
r3r	inc	d		;4
	;---------------------------- //51
	rra			;4
	jr	nc,w4r		;7/12
	ld	b,c		;4
	out	(c),d		;12
	ld	b,e		;4
	outi			;16
r4r	inc	d		;4
	;---------------------------- //51
	rra			;4
	jr	nc,w5r		;7/12
	ld	b,c		;4
	out	(c),d		;12
	ld	b,e		;4
	outi			;16
r5r	inc	d		;4	
	;---------------------------- //51
	rra			;4
	jr	nc,w6r		;7/12
	ld	b,c		;4
	out	(c),d		;12
	ld	b,e		;4
	outi			;16
r6r	inc	d		;4
	;---------------------------- //51
	rra			;4
	jr	nc,w7r		;7/12
	ld	b,c		;4
	out	(c),d		;12
	ld	b,e		;4
	outi			;16
r7r	inc	d		;4
	;---------------------------- //51
	ex	af,af		;4
	;---------------------------- //4
	rra			;4
	jr	nc,w8r		;7/12
	ld	b,c		;4
	out	(c),d		;12
	ld	b,e		;4
	outi			;16
r8r	inc	d		;4
	;---------------------------- //51
	rra			;4
	jr	nc,w9r		;7/12
	ld	b,c		;4
	out	(c),d		;12
	ld	b,e		;4
	outi			;16
r9r	inc	d		;4
	;---------------------------- //51
	rra			;4
	jr	nc,w10r		;7/12
	ld	b,c		;4
	out	(c),d		;12
	ld	b,e		;4
	outi			;16
r10r	inc	d		;4
	;---------------------------- //51
	rra			;4
	jr	nc,w11r		;7/12
	ld	b,c		;4
	out	(c),d		;12
	ld	b,e		;4
	outi			;16
r11r	inc	d		;4
	;---------------------------- //51
	rra			;4
	jr	nc,w12r		;7/12
	ld	b,c		;4
	out	(c),d		;12
	ld	b,e		;4
	outi			;16
r12r	inc	d		;4
	;---------------------------- //51
	rra			;4
	jr	nc,w13r		;7/12
	ld	b,c		;4
	out	(c),d		;12
	ld	b,e		;4
	outi			;16
r13r	;---------------------------- //47
;----------------------------------------------------------------------------------------------------------- 839
mus_com_exit
		ld	(mus_adr),hl		;16
		ld	a,(mus_stack_adr)	;13
		ld	hl,ini_mus_stack + 2	;10
						;  //39		878
mus_wait_cnt = 0
		dup  max_inner_call - 1
		  cp	L					;4
		  jr	c,mus_waitexit_ret + mus_wait_cnt	;7 / 12	 //->16
		  dec	(hl)					;11
		  jr	z,mus_waitcall_ret + mus_wait_cnt	;7 / 12  //->34
		  inc	L,L,L					;12			// 41 tacts
mus_wait_cnt=mus_wait_cnt+4
		edup
		  cp	L				;4
		  jr	c,1f				;7 / 12		//->16
		  dec	(hl)				;11
		  jr	nz,2f				;7 / 12		//->34		//29 tacts
mus_call_ret
		dec	L			;4
		ld	d,(hl)			;7
		dec	L			;4
		ld	e,(hl)			;7

		ld	(mus_stack_adr),hl	;16
		ld	(mus_adr),de		;20	//58

		ret				;10
;-----------------------------------------------------------------------------------------------------------
w10r	cp	(iy)		;19
	jr	r10r		;12
w11r	cp	(iy)		;19
	jr	r11r		;12
w12r	cp	(iy)		;19
	jr	r12r		;12
w13r	cp	(iy)		;19
	jr	r13r		;12
;-----------------------------------------------------------------------------------------------------------
mus_waitcall_ret			;<-- +34

		if max_inner_call>2
		dup  max_inner_call-2
		ld b,3 : djnz $		;41
		edup
		endif

		cp (hl)			;7 + 34 = 41

		inc de : cp (hl)	;6+7
		xor a			;4
		jr mus_call_ret		;12	//29
;...........................................................................................................
mus_waitexit_ret

		dup  max_inner_call-1
		ld b,3 : djnz $		;(n-1)*41
		edup
1						;<-- +16
		cp (hl) : cp (hl)	;14	//16+14 = 30
		xor a			;4	//30+4  = 34
2						;<-- +34
		ld b,3			;7
		djnz $			;34
		inc bc:dec bc		;12		//53 + 34 = 87
							//87 is needed
		ret			;10

;-----------------------------------------------------------------------------------------------------------
;11hhhhhh , llllllll , nnnnnnnn	- call_n - play  N frames from mus_adr-00hhhhhh llllllll
;10hhhhhh , llllllll		- call_1 - play one frame from mus_adr-00hhhhhh llllllll
;-----------------------------------------------------------------------------------------------------------
mus_links
		ld	c,(hl)			;7
		inc	hl			;6
		pop	de			;10 disable nolinks ret
		ld	de,ini_mus_stack	;10 //33
mus_stack_adr	  equ $-2

	if ini_relative = 0
		ld	b,a		;4
	endif
		sub	%11000000	;7
		jr	c,mus_call_one	;7 / 12
mus_call_n				;<-- 50
	if ini_relative = 1
		ld	b,a		;4	
	endif
		ld	a,(hl)		;7
		inc	hl		;6 	 //64

		ex	de,hl			;4
		ld	(hl),e			;7
		inc	L			;4
		ld	(hl),d			;7
		inc	L			;4
		ld	(hl),a			;7
	if ini_relative = 1
		inc	HL			;6
		ld	(mus_stack_adr),hl	;16
		ex	de,hl		;4
		sbc	hl,bc		;15		//138
	else
		inc	L			;4
		ld	(mus_stack_adr),hl	;16
		ld	h,b,l,c			;8	//125
	endif

		xor	a		;4
		or	(hl)		;7
		inc	hl		;6
		jp	mus_links_cycle	;10	we ignore <jp m,mus_links> because "allow call to call" option is disabled by default
;....................................................................................................................................
mus_call_one
	if ini_relative = 1
		and	%00111111		;7
		ld	b,a			;4
	endif
		ex	de,hl			;4
		ld	(hl),e			;7
		inc	L			;4
		ld	(hl),d			;7
		inc	L			;4
		ld	(hl),01			;10
		inc	L			;4
		ld	(mus_stack_adr),hl	;16

	if ini_relative = 1
		ex	de,hl		;4
		sbc	hl,bc		;15		;//138
	else
		ld	h,a,l,c				;//120
		ret	nc		;5	CY is always set
	endif

		xor	a		;4
		or	(hl)		;7
		inc	hl		;6
		jp	mus_links_cycle	;10	we ignore <jp m,mus_links> because "allow call to call" option is disabled by default
;------------------------------------------------------------------------------------------------------------------------------------
;------------------------------------------------------------------------------------------------------------------------------------
code_end

	display "------------------------------------------"
	display	"mus_stack: ", /a, ini_mus_stack, " ... ", /a, max_inner_call*3+ini_mus_stack
	display "------------------------------------------"
	display "start:  ", /a, code_run, " bytes"
	display "total:  ", /a, code_end - code_run, " bytes"
	display "player: ", /a, code_end - mus_init, " bytes"
	display "------------------------------------------"

	org	mus_data_adr

	INCBIN	"music.psg.packed"

;	savesna "c:\Program Files\UnrealSpeccy\Qsave1.sna", code_run
;	savesna "c:\Program Files (x86)\UnrealSpeccy\Qsave1.sna", code_run
