/***********************************************
 **** File Converter     	 	****************
 **** MAXIOL 2020            	****************
 ***********************************************/


// C
#include <sys/types.h>
#include <sys/mman.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <strings.h>
#include <execinfo.h>
#include <unistd.h>
#include <errno.h>
#include <wait.h>
#include <unistd.h>
#include <time.h>
#include <err.h>
#include <netdb.h>
#include <assert.h>
#include <limits.h>


// части проекта
#include "definitions.h"  	// настройки


int main(int argc, char** argv)
{
    //char 	        *buf=new char[MAX_FILE_SIZE];               // буфер под файл
    long            file_in_size=0,file_out_size=0;             // размеры файлов
    FILE            *file_in,*file_out;                         // дескрипторы файлов
    size_t          result=0;
    char            *begpoz;


    // проверка параметров запуска
    if(argc == 1)  // при запуске нет параметров
    {
        // выводим справку
        printf((char*)"HTML ucoz converter v%s\n usage:\n\tconverter %%filename%% \n",VERSION_PROG);
        printf("(c) MAXIOL 2020\n");

//strcmp(argv[1],"start")==0

        return 0;
    }
    else // есть параметры запуска
    {
        // в качестве параметра нам нужен только файл который мы собираемся конвертировать
        // этапы
        // 1. открываем файл на чтение, проверяем есть ли в нем необходимые аттрибуты файла для конвертации , если нет - выходим. по завершению этапа файл закрываем безусловно.
        // 2. переименовываем файл
        // 3. снова открываем файл - переименованный + открываем на запись новый файл
        // 4. находим позицию с которой копируем данные в новый файл
        // 5. закрываем файл

        // 1. открываем файл на чтение
        file_in = fopen(argv[1], "rb");
        if (file_in==NULL )
        {
            printf("Error: cannot open file for read '%s'\n",argv[1]);
            return 0;
        }
        // определяем размер файла
        fseek(file_in , 0 , SEEK_END);                                      // устанавливаем позицию в конец файла
        file_in_size = ftell(file_in);                                      // получаем размер в байтах
        rewind (file_in);                                                   // устанавливаем указатель в конец файла
        char *buffer = (char*) malloc(sizeof(char) * file_in_size);         // выделить память для хранения содержимого файла
        if (buffer == NULL)
        {
            printf("Error: cannot allocate memory '%d'\n",file_in_size);    //fputs("Ошибка памяти", stderr);
            return 0;//exit(2);
        }
        // читаем файл в память
        result = fread(buffer, 1, file_in_size, file_in);       // считываем файл в буфер
        if (result != file_in_size)
        {
            printf("Error: cannot read file '%d'\n",file_in_size);//fputs("Ошибка чтения", stderr);
            return 0;//exit (3);
        }
        // закрываем файл
        fclose(file_in);

        // надо проверить есть ли основания для конвертации и пригоден ли он вообще
        begpoz=strstr(buffer,BEGIN_HTML );
        if (begpoz==NULL  ) // нет заголовка по которому будем резать
        {
            printf("Error: not need head \n");
            return 0;
        }

        file_in = fopen(argv[1], "w+b");
        if (file_in==NULL )
        {
            printf("Error: cannot open file for write '%s'\n",argv[1]);
            return 0;
        }
        file_out_size=file_in_size-(begpoz-buffer);

        result = fwrite(begpoz, 1, file_out_size, file_in);       // пишем файл

        if (result != file_out_size)
        {
            printf("Error: cannot write file '%d'\n",file_out_size);
            return 0;
        }
        fclose (file_in);

        return 1;
    }  // есть параметры запуска

}      // main






