; : BK Turbo8 Cross Assembler

;
;16'o177320;		// 100000-107777
;16'o177322;		// 110000-117777
;16'o177324;		// 120000-127777
;16'o177326;		// 130000-137777
;16'o177330;		// 140000-147777
;16'o177332;		// 150000-157777
;16'o177334;		// 160000-167777
;16'o177336;		// 170000-177777
;16'o177340;		//   -    ,   -  
;16'o177342;		//   -   r/o 		    ,   -  
;16'o177344;		//   -    ,   -    =1    
;16'o177346;		//    

;  
;  1000  -  12  - 1 
;  1100  -  12  - 2 

; 2000 - 1   
; 2001 - 2   

; 3000-3005 - c  
; 3006 - c  -
; 3007 -    
;------------------------------------------------------------------------------

Begin:          mov     @#177230,-(SP)
                mov     @#177232,-(SP)
                mov     @#177324,-(SP)
                mov     @#177326,-(SP)
                mov     @#100, -(SP)            ;   
                mov     @#102, -(SP)
                mov     @#177340, -(SP)         ;   
                mov     @#177342, -(SP)
                mov     @#177344, -(SP)
                mov     @#177352, -(SP)
                mov     @#177346, -(SP)

; ******************************************************************************
                bis     #100,@#177660       ;    
; ******************************************************************************
                mov		#14020,@#177716		;       11
                bis     #6000,@#177340      ;    120 130
                bic     #6000,@#177342      ;  R/O    
; ******************************************************************************

                mov     #063223,@#177230    ;   256192 256 ( 48)
                mov     #1000,@#177232      ;    


; ******************************************************************************

                ;     
                mov     #frame1,R0
                mov     #1800.,R1           ; 1800 ! 6060 = 3600 
                mov     #3000,@#177324      ;   3000   120000-127777
                mov     #120000,R2
$aa1:           mov     (R0)+,(R2)+
                sob     R1,$aa1

                ;     
                mov     #frame2,R0
                mov     #1800.,R1               ;    30.60.=1800.
                mov     #3001,@#177324
                mov     #120000,R2
$aa2:           mov     (R0)+,(R2)+
                sob     R1,$aa2

                ;     
                mov     #frame3,R0
                mov     #1800.,R1
                mov     #3002,@#177324
                mov     #120000,R2
$aa3:           mov     (R0)+,(R2)+
                sob     R1,$aa3

                mov     #frame4,R0
                mov     #1800.,R1
                mov     #3003,@#177324
                mov     #120000,R2
$aa4:           mov     (R0)+,(R2)+
                sob     R1,$aa4

                ;     
                mov     #frame5,R0
                mov     #1800.,R1
                mov     #3004,@#177324
                mov     #120000,R2
$aa5:           mov     (R0)+,(R2)+
                sob     R1,$aa5

                ;     
                mov     #frame6,R0
                mov     #1800.,R1
                mov     #3005,@#177324
                mov     #120000,R2
$aa6:           mov     (R0)+,(R2)+
                sob     R1,$aa6

; ******************************************************************************

                ;     
                mov     #backgrnd,R0
                mov     #2048.,R1               ; 32.64.=2048.
                mov     #3006,@#177324
                mov     #120000,R2
$aa7:           mov     (R0)+,(R2)+
                sob     R1,$aa7


; ******************************************************************************
                ;  
                mov		#177234,R0		;  
                mov		#177236,R1
                mov		#newpal,R2
                mov		#256.,R3
                clr		R4
$rp0:		    mov		R4,(R0)
                mov		(R2)+,(R1)
                inc		R4
                sob		R3,$rp0

; ******************************************************************************
;    64x64  - 4    3   -  1000....

                ;  
                mov     #2000,@#177324      ;   2000   120000-127777

                mov     #30020,@#120000
                mov     #30000,@#120002
                mov     #0,@#120004
                mov     #11,@#120006 ;  
                ;5 
                ;  -        1
                ;  -  c
                movb    #31.,@#120010 ; 32-1
                movb    #64.,@#120011 ;
                ;6  -       
                ; -  256px  ,  128 :  128.-31.=97.
                mov     #97.,@#120012 ;
                ;7  -  Y=0
                mov     #0,@#120014 ;
                ;8  -  
                mov     #177,@#120016 ;

                mov     #2000,@#177272      ;     
                mov     #1,@#177270         ; 

                mov     #TIMER1,@#100            ;    ()
                bic     #4,@#177346              ; c  -      48
                bis     #10,@#177346             ;   60

                wait        ;   
                wait        ;   
                mov     #32.,@#120004
                wait        ;   
                mov     #64.,@#120004
                wait        ;   
                mov     #96.,@#120004
                wait        ;   

                mov     #8192.,@#120004  ; 128*64 + offcet
                wait        ;   
                mov     #8192.+32.,@#120004  ;
                wait        ;   
                mov     #8192.+64.,@#120004  ;
                wait        ;   
                mov     #8192.+96.,@#120004  ;
                wait        ;   

                mov     #16384.,@#120004  ; 128*64*2 + offcet
                wait        ;   
                mov     #16384.+32.,@#120004  ;
                wait        ;   
                mov     #16384.+64.,@#120004  ;
                wait        ;   
                mov     #16384.+96.,@#120004  ;
                wait        ;   
                wait        ;   
                bic     #10,@#177346            ;  
                mov     #0,@#177270     ;  


; ******************************************************************************

;    64x64  - 4    3    1100....

                ;  
                mov     #2000,@#177324      ;   2000   120000-127777

                mov     #30022,@#120000
                mov     #30000,@#120002
                mov     #0,@#120004
                mov     #11,@#120006 ;  
                ;5 
                ;  -        1
                ;  -  c
                movb    #31.,@#120010 ; 32-1
                movb    #64.,@#120011 ;
                ;6  -       
                ; -  256px  ,  128 :  128.-31.=97.
                mov     #97.,@#120012 ;
                ;7  -  Y=0
                mov     #0,@#120014 ;
                ;8  -  
                mov     #177,@#120016 ;

                mov     #2000,@#177272      ;     
                mov     #1,@#177270         ; 

                mov     #TIMER1,@#100            ;    ()
                bic     #4,@#177346              ; c  -      48
                bis     #10,@#177346             ;   60

                wait        ;   
                wait        ;   
                mov     #32.,@#120004
                wait        ;   
                mov     #64.,@#120004
                wait        ;   
                mov     #96.,@#120004
                wait        ;   

                mov     #8192.,@#120004  ; 128*64 + offcet
                wait        ;   
                mov     #8192.+32.,@#120004  ;
                wait        ;   
                mov     #8192.+64.,@#120004  ;
                wait        ;   
                mov     #8192.+96.,@#120004  ;
                wait        ;   

                mov     #16384.,@#120004  ; 128*64*2 + offcet
                wait        ;   
                mov     #16384.+32.,@#120004  ;
                wait        ;   
                mov     #16384.+64.,@#120004  ;
                wait        ;   
                mov     #16384.+96.,@#120004  ;
                wait        ;   
                wait        ;   
                bic     #10,@#177346            ;  
                mov     #0,@#177270     ;  


; ******************************************************************************

                ;     4000
                ;  
                mov     #2000,@#177324      ;   2000   120000-127777

                mov     #30020,@#120000
                mov     #34000,@#120002
                mov     #0,@#120004
                mov     #42,@#120006 ;
                ;5 
                ;  -        1
                ;  -  c
                movb    #29.,@#120010 ; 30-1
                movb    #60.,@#120011 ;
                ;6  -       
                ; -  256px  ,  128 :  128.-29.=1.
                mov     #99.,@#120012 ;
                ;7  -  Y=0
                mov     #0,@#120014 ;
                ;8  -  
                mov     #0,@#120016 ; //         

                mov     #2000,@#177272      ;    
                mov     #1,@#177270         ; 

                mov     #TIMER1,@#100            ;   
                bis     #10,@#177346            ;    (       )

                wait        ;   
                wait        ;   
                wait        ;   

                bic     #10,@#177346            ;  
                mov     #0,@#177270     ;  


; ******************************************************************************

                mov     #2000,@#177324      ;   2000   120000-127777

                ;   1  -     4000
                mov     #30020,@#120000
                mov     #34000,@#120002
                mov     #0,@#120004
                ;4  -  
                mov     #11,@#120006 ;   SRC
                ;5 
                ;  -        1
                ;  -  c
                movb    #29.,@#120010 ; 30-1
                movb    #60.,@#120011 ;
                ;6  -       
                ; -  256px  ,  128 :  128.-29.=99.
                mov     #99.,@#120012 ;
                ;7  -  Y=0
                mov     #0,@#120014 ;
                ;8  -  
                mov     #0,@#120016 ;   


                ;   2  -     
                mov     #30020,@#120020
                mov     #34000,@#120022
                mov     #0,@#120024
                mov     #42,@#120026 ;
                ;5 
                ;  -        1
                ;  -  c
                movb    #29.,@#120030 ; 30-1
                movb    #60.,@#120031 ;
                ;6  -       
                ; -  256px  ,  128 :  128.-29.=1.
                mov     #99.,@#120032 ;
                ;7  -  Y=0
                mov     #0.,@#120034 ;
                ;8  -  
                mov     #0,@#120036 ; //         


                ;   3 -   
                mov     #30020,@#120040
                mov     #0,@#120042
                mov     #0,@#120044
                ;4  -  
                mov     #33,@#120046 ;   
                ;5 
                ;  -        1
                ;  -  c
                movb    #29.,@#120050 ; 30-1
                movb    #60.,@#120051 ;
                ;6  -       
                ; -  256px  ,  128 :  128.-29.=99.
                mov     #99.,@#120052 ;
                ;7  -  Y=0
                mov     #0.,@#120054 ;
                ;8  -  
                mov     #0x6300,@#120056 ;
                ;   -      -  0
                ;   -      -  143 = 63h


                ;  
                clr     @#clk
                clr     R0
                clr     R1
                clr     R2
                clr     R3
                mov     #120004,R4
                mov     #120024,R5

                mov     #1006,@#177326      ;   1000   130000-137777

                ;  
                mov     #TIMER,@#100            ;   
                mov     #340,@#102              ; 
                bic     #4,@#177346             ; 60 !
                bis     #10,@#177346            ;   60  (       )

                ; 
                mov     #2000,@#177272      ;    
                mov     #3,@#177270     ;  

                ;  
$sa00:          wait
                ;br      $sa00

                ;   
$sa0:           bit     #200,@#177660       ;  
                bne     KBpressed
                bit     #100, @#177716      ;   
                beq     KBpressed
                br      $sa0


                ;  
KBpressed:      mov     #0,@#177270     ;  
; ******************************************************************************
                ;  
                bic     #10,@#177346            ;  
                clr     @#177250                ;     
                clr     @#177252                ;     
                ;  
                mov     (SP)+,@#177346
                mov     (SP)+,@#177716
                mov     (SP)+,@#177344
                mov     (SP)+,@#177342
                mov     (SP)+,@#177340
                mov     (SP)+,@#102
                mov     (SP)+,@#100
                mov     (SP)+,@#177326
                mov     (SP)+,@#177324
                mov     (SP)+,@#177232
                mov     (SP)+,@#177230
                bic     #100,@#177660       ;    
                JMP     @#100000
; ******************************************************************************


; ************************   100 *****************************
TIMER:          ;mov     #200,@#177716

; ****************     **************************
                tst     @#hdir          ; =0  =1    
                beq     1a$         ; =0 
                br      2a$

1a$:            mov     R0,@#120004
                inc     R0          ;   
                mov     R0,@#120024
                mov     R0,@#120044
                cmp     #98.,R0                ; 128-30.=98.
                bne     0b$
                com     hdir          ;     
                br      0b$

2a$:            mov     R0,@#120004
                dec     R0          ;  
                mov     R0,@#120024
                mov     R0,@#120044
                tst     R0
                bne     0b$
                clr     hdir          ;   

; ****************     **************************
0b$:            tst     R3          ; =0  =1    
                beq     1b$         ; =0 
                br      2b$

1b$:            add     R2,@#120004
                add     #128.,R2     ;   
                add     R2,@#120024
                add     R2,@#120044
                cmp     #16896.,R2  ; 192-60.=132. x 128 
                bne     3c$
                com     R3          ;     
                br      3c$

2b$:            add     R2,@#120004
                sub     #128.,R2    ;  
                add     R2,@#120024
                add     R2,@#120044
                tst     R2
                bne     3c$
                clr     R3          ;   

3c$:            ;mov     #300,@#177716

TIMER1:         RTI


clk:            .word   0
hdir:           .word   0
vdir:           .word   0


newpal:   .word 000000,002041,004102,006143,010204,012245,014306,016347,020410,022451,024512,026553,030614,032655,034716,036757
          .word 041020,043061,045122,047163,051224,053265,055326,057367,061430,063471,065532,067573,071634,073675,075736,077777
          .word 000000,000037,001740,001777,076000,076037,077740,077777,000000,000006,000014,000023,000031,000037,000300,000306
          .word 000314,000323,000331,000337,000600,000606,000614,000623,000631,000637,001140,001146,001154,001163,001171,001177
          .word 001440,001446,001454,001463,001471,001477,001740,001746,001754,001763,001771,001777,014000,014006,014014,014023
          .word 014031,014037,014300,014306,014314,014323,014331,014337,014600,014606,014614,014623,014631,014637,015140,015146
          .word 015154,015163,015171,015177,015440,015446,015454,015463,015471,015477,015740,015746,015754,015763,015771,015777
          .word 030000,030006,030014,030023,030031,030037,030300,030306,030314,030323,030331,030337,030600,030606,030614,030623
          .word 030631,030637,031140,031146,031154,031163,031171,031177,031440,031446,031454,031463,031471,031477,031740,031746
          .word 031754,031763,031771,031777,046000,046006,046014,046023,046031,046037,046300,046306,046314,046323,046331,046337
          .word 046600,046606,046614,046623,046631,046637,047140,047146,047154,047163,047171,047177,047440,047446,047454,047463
          .word 047471,047477,047740,047746,047754,047763,047771,047777,062000,062006,062014,062023,062031,062037,062300,062306
          .word 062314,062323,062331,062337,062600,062606,062614,062623,062631,062637,063140,063146,063154,063163,063171,063177
          .word 063440,063446,063454,063463,063471,063477,063740,063746,063754,063763,063771,063777,076000,076006,076014,076023
          .word 076031,076037,076300,076306,076314,076323,076331,076337,076600,076606,076614,076623,076631,076637,077140,077146
          .word 077154,077163,077171,077177,077440,077446,077454,077463,077471,077477,077740,077746,077754,077763,077771,077777



            ;  6060
frame1:   .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,212,330,330,366,264,155,155,221,156,214,267,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,212,144,152,107,042,262,046,046,264,110,111,111,111,112,267,036,036,267,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,330,373,262,042,042,042,042,042,042,262,046,374,212,110,111,111,111,223,376,036,267,043,157,215,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,212,255,046,046,046,262,042,042,042,042,042,216,326,374,330,155,111,111,112,156,333,036,333,043,043,043,043,214,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,264,154,042,152,262,046,046,046,262,042,042,042,042,042,216,373,374,264,111,111,104,043,267,036,333,223,043,043,043,156,033,023,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,221,110,110,107,042,042,216,326,046,046,262,042,042,042,042,152,330,374,367,155,111,104,112,267,371,371,215,105,043,105,156,376,367,367,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,221,111,110,110,110,107,042,042,152,262,046,046,262,042,042,042,042,211,374,374,257,103,104,105,151,371,371,267,105,105,105,151,033,367,257,155,221,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,033,367,367,257,212,110,110,107,042,042,042,042,262,046,046,262,100,100,100,144,250,366,361,147,076,077,151,317,363,267,105,105,105,214,033,367,257,110,102,212,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,033,033,033,367,367,367,257,212,110,107,042,042,042,042,262,364,364,254,100,072,073,204,366,361,023,076,076,077,317,363,317,077,077,076,214,367,367,257,102,102,110,154,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,214,151,214,267,267,376,367,367,367,264,154,107,042,042,042,100,254,364,364,202,072,073,074,250,361,362,142,077,077,317,363,363,142,077,076,207,361,367,250,102,102,101,100,255,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,267,105,105,043,043,112,221,257,367,367,367,374,264,144,042,100,100,100,312,356,356,202,073,073,204,361,353,207,071,077,252,363,363,207,077,076,205,361,361,250,074,101,101,210,320,373,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,105,105,043,043,043,043,043,112,111,221,257,367,366,330,211,100,100,072,136,312,356,312,174,066,066,353,353,243,134,071,200,355,355,200,071,071,023,361,361,204,074,073,072,202,364,364,366,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,151,105,043,043,043,043,043,043,043,112,112,111,221,374,366,360,246,136,072,072,174,304,350,240,131,066,243,353,354,135,071,200,355,355,200,071,067,243,353,360,204,073,073,072,246,356,364,254,204,000,000,000,000,000
          .byte 000,000,000,000,000,267,267,267,215,223,043,043,043,043,043,043,112,112,111,147,257,360,360,313,202,064,064,174,350,350,014,060,163,345,302,173,063,173,347,347,200,071,067,353,353,352,066,073,072,202,356,356,356,210,100,000,000,000,000,000
          .byte 000,000,000,000,000,371,371,371,036,036,333,333,267,223,157,043,112,112,104,103,075,204,360,360,350,174,064,064,224,335,277,060,053,273,045,231,041,173,045,347,173,053,177,353,352,352,066,064,072,246,356,356,246,136,100,204,000,000,000,000
          .byte 000,000,000,000,317,371,371,033,036,036,036,036,036,036,036,333,267,215,076,076,075,075,066,352,305,342,232,056,003,270,335,162,053,230,340,275,041,165,045,045,164,053,163,345,344,242,131,064,174,312,356,356,202,072,072,100,000,000,000,000
          .byte 000,000,000,267,252,267,215,215,223,223,223,267,267,333,333,036,371,371,363,252,205,067,067,066,226,342,044,224,002,114,335,300,053,163,045,275,041,165,045,045,164,053,227,336,344,167,057,064,240,350,356,312,136,072,072,072,202,000,000,000
          .byte 000,000,000,076,103,104,104,112,043,043,043,043,043,043,157,223,267,267,363,363,363,310,177,053,060,161,044,044,114,002,225,336,163,053,045,045,121,121,045,045,053,053,272,336,277,122,056,122,350,350,350,240,064,072,072,136,246,000,000,000
          .byte 000,000,000,075,103,103,103,111,111,112,112,043,043,043,043,105,105,077,142,252,311,355,345,273,163,052,114,044,044,003,114,336,227,053,275,045,121,121,045,273,053,162,272,335,224,002,056,232,342,350,304,064,064,072,072,246,357,366,000,000
          .byte 000,000,147,075,075,075,111,103,111,111,112,112,112,112,043,105,105,077,077,071,071,200,236,340,337,226,052,114,044,224,002,272,337,053,231,045,121,165,340,273,053,162,335,335,114,002,114,270,270,350,174,064,064,072,246,313,357,360,000,000
          .byte 000,000,147,074,147,154,221,221,221,221,257,257,257,267,267,267,267,252,207,200,135,054,041,165,230,337,272,002,160,342,122,167,353,172,200,347,127,164,340,163,052,226,335,224,003,002,224,044,342,232,122,064,131,174,360,356,360,360,023,000
          .byte 000,023,250,250,366,366,366,374,367,374,367,367,367,367,367,367,362,362,355,355,347,045,231,165,041,163,337,300,056,240,304,073,353,207,200,355,071,245,345,163,052,270,044,160,002,114,044,044,270,003,056,064,167,352,352,360,360,204,075,000
          .byte 000,360,357,366,360,366,374,374,330,264,264,212,212,221,147,221,205,205,200,245,236,275,045,045,275,164,053,242,312,072,312,137,023,207,142,363,076,243,353,057,161,044,270,002,002,270,044,044,160,051,057,167,352,352,352,360,250,075,075,000
          .byte 000,360,357,357,373,255,262,211,107,107,107,107,110,102,102,102,075,075,067,053,062,054,041,165,231,347,311,075,246,210,211,211,221,215,151,267,076,361,014,064,277,342,114,002,224,044,044,224,051,052,162,300,344,352,352,243,067,075,075,252
          .byte 000,313,312,246,136,100,042,042,042,042,042,042,042,107,101,211,250,250,242,272,273,273,227,230,173,135,207,267,154,216,216,211,221,223,223,222,155,360,072,174,350,240,056,114,044,335,225,052,052,162,272,344,345,353,243,067,067,075,076,207
          .byte 250,202,136,072,100,100,042,042,042,042,042,152,216,262,364,356,356,305,305,344,300,272,273,227,245,317,215,223,221,216,216,212,214,223,223,221,264,216,100,312,304,064,122,342,335,225,115,052,162,272,337,337,345,227,067,067,067,067,076,252
          .byte 204,072,072,072,100,100,042,042,152,216,262,046,046,046,320,246,202,174,064,002,002,002,114,162,014,205,222,223,222,204,246,014,252,215,221,154,262,042,254,364,072,064,305,335,300,060,060,163,273,337,337,273,227,062,062,070,070,207,317,317
          .byte 137,072,072,072,100,100,210,262,326,046,046,326,262,152,100,072,072,064,174,224,270,044,044,224,240,210,212,221,207,227,224,227,173,243,204,254,152,216,326,100,072,313,352,226,060,053,163,273,337,337,273,164,041,062,070,135,245,310,363,363
          .byte 137,072,072,136,210,320,364,046,046,262,216,042,042,042,100,100,202,304,350,342,224,114,003,167,202,210,216,210,226,173,202,245,164,226,240,202,216,326,042,107,250,360,014,067,067,227,337,337,340,236,165,041,041,127,200,245,355,355,355,363
          .byte 137,131,246,312,356,364,364,326,216,042,042,042,042,042,210,312,356,304,174,122,051,224,277,225,174,211,211,204,226,204,205,204,232,224,167,202,255,110,154,367,367,075,075,134,236,340,045,275,165,041,041,041,165,231,347,347,355,355,355,317
          .byte 246,304,356,356,356,364,254,152,042,042,042,042,152,262,046,320,246,073,066,167,336,336,162,163,353,207,222,215,164,014,177,212,204,227,230,205,147,267,267,222,104,076,252,355,347,347,231,121,041,041,121,165,275,045,347,347,355,311,245,142
          .byte 313,350,356,356,312,202,100,100,042,042,042,216,046,046,255,154,074,074,243,353,227,053,164,275,173,252,223,221,202,243,242,221,207,165,231,245,252,157,043,043,215,371,363,311,245,121,041,041,121,165,275,045,045,045,347,355,245,200,071,071
          .byte 313,350,356,246,136,072,100,100,042,042,262,374,373,212,110,110,075,023,361,243,063,231,045,121,236,245,204,210,216,222,221,210,226,230,230,200,215,215,333,333,333,267,142,071,071,063,165,231,275,045,045,045,045,275,236,173,135,071,071,071
          .byte 313,350,246,137,073,072,101,101,211,330,374,374,154,111,111,111,367,362,207,071,245,347,121,231,236,163,240,174,204,215,252,174,224,160,162,023,222,222,156,043,105,077,077,134,200,275,347,045,045,045,045,275,231,165,127,063,071,071,071,142
          .byte 250,240,131,073,073,073,074,212,366,374,366,110,111,111,111,267,371,215,077,207,355,200,127,340,163,225,160,224,227,231,165,226,160,224,240,246,212,155,221,221,214,252,361,355,354,355,045,275,275,231,165,121,121,041,041,063,063,135,200,252
          .byte 000,066,066,073,074,074,250,366,374,367,111,111,111,112,267,376,223,105,077,317,317,071,245,273,162,270,160,224,227,231,231,163,225,174,137,210,262,255,264,330,367,361,361,243,310,230,164,165,120,054,041,054,041,041,120,173,200,245,310,317
          .byte 000,066,066,074,075,250,361,361,367,221,111,112,112,222,036,267,043,043,215,363,142,075,353,014,167,224,114,225,163,231,173,302,067,304,312,210,042,042,042,107,102,074,074,067,053,053,053,053,053,053,164,164,164,230,273,302,353,354,355,361
          .byte 000,204,066,014,023,361,361,361,205,103,104,112,223,036,333,043,043,043,036,267,104,205,360,066,240,240,174,277,053,355,135,245,023,074,210,262,326,262,216,210,144,137,074,066,014,162,163,163,227,227,273,273,337,337,345,345,345,353,353,000
          .byte 000,205,177,243,353,361,361,252,076,104,043,157,036,036,223,043,043,267,376,156,103,250,360,072,246,246,064,352,075,252,317,077,317,367,107,042,152,262,326,046,356,356,350,305,344,344,336,336,336,337,337,337,337,337,337,345,353,353,243,000
          .byte 000,000,243,353,353,361,252,075,077,077,105,267,036,267,043,043,043,333,267,111,110,330,254,100,254,246,072,360,205,077,371,215,104,257,374,211,042,042,042,136,246,246,304,305,277,335,335,336,336,336,336,336,336,272,272,243,243,177,243,000
          .byte 000,000,353,353,353,310,142,077,077,077,267,371,371,157,043,043,223,376,221,111,110,373,216,042,262,254,042,264,367,112,223,036,157,112,221,374,326,216,100,072,072,064,064,122,174,114,160,161,162,161,162,162,162,162,060,060,066,066,000,000
          .byte 000,000,361,354,310,245,071,077,077,207,363,363,267,105,043,043,267,367,155,110,154,046,216,042,262,326,042,154,367,156,043,267,333,112,111,110,264,373,312,246,202,131,064,064,002,002,002,002,002,002,051,051,052,052,060,066,060,066,000,000
          .byte 000,000,000,354,311,135,071,071,077,317,363,363,207,105,105,156,367,257,110,110,216,046,152,042,216,326,042,110,257,267,043,043,333,333,111,111,102,204,360,356,350,350,277,232,160,114,114,003,003,003,003,003,115,115,057,057,066,014,000,000
          .byte 000,000,000,252,173,071,071,071,245,363,363,317,077,076,076,267,367,257,110,107,216,046,152,042,216,046,152,110,221,367,157,043,043,036,033,214,103,074,074,246,304,350,342,342,044,044,270,270,224,224,224,224,224,224,232,232,242,000,000,000
          .byte 000,000,000,000,135,071,071,200,311,355,355,207,077,076,076,361,361,212,110,101,262,046,152,042,152,046,216,110,111,376,267,043,043,151,371,362,023,075,066,066,131,167,224,044,044,044,044,044,044,044,044,044,342,270,342,342,242,000,000,000
          .byte 000,000,000,000,200,063,135,245,355,355,355,207,077,076,214,361,361,212,101,101,254,364,210,042,042,326,326,110,111,221,371,267,105,105,142,363,361,361,177,066,066,057,122,114,224,270,270,044,044,044,044,044,044,342,342,305,000,000,000,000
          .byte 000,000,000,000,000,135,165,311,355,355,311,071,070,075,023,361,361,074,073,072,254,364,210,100,100,320,373,154,075,103,033,371,207,077,077,207,310,353,353,243,162,060,052,051,002,003,114,160,224,224,270,270,270,342,305,000,000,000,000,000
          .byte 000,000,000,000,000,000,245,347,355,355,245,070,070,067,353,353,360,137,073,072,312,356,246,072,072,246,360,250,075,076,205,363,363,207,071,071,200,354,353,345,337,272,162,115,051,002,002,002,002,003,003,114,160,167,352,000,000,000,000,000
          .byte 000,000,000,000,000,000,317,347,347,302,200,070,067,177,353,352,352,137,072,072,312,356,246,072,072,202,357,360,075,075,076,317,363,355,200,071,071,127,236,345,337,337,336,300,224,162,003,002,002,002,002,002,056,014,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,311,347,275,172,053,053,177,352,352,352,131,064,064,304,356,312,072,072,137,360,360,023,067,070,200,355,355,311,173,063,063,120,230,273,337,336,336,336,225,225,161,114,003,002,056,122,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,310,236,054,053,053,243,352,352,352,131,064,131,304,350,350,174,064,064,352,352,352,177,070,071,245,355,347,347,173,041,062,120,163,227,337,337,336,336,336,335,270,224,224,167,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,200,053,053,053,226,344,344,277,131,064,131,240,350,350,174,064,064,242,352,353,243,070,062,127,275,347,347,045,165,121,054,054,164,163,273,337,336,336,336,336,335,277,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,200,053,163,272,344,344,277,122,056,064,224,350,342,240,064,064,014,344,353,353,164,054,041,173,275,045,045,045,231,121,054,054,053,163,163,273,336,336,336,352,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,177,163,272,336,335,270,122,056,122,232,350,342,270,122,057,052,300,344,345,273,164,041,041,165,275,045,045,045,236,165,054,053,053,053,163,226,226,344,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,300,335,335,224,114,002,003,224,044,342,044,114,051,052,162,337,337,337,230,121,041,041,165,275,045,045,045,275,164,120,053,053,053,053,243,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,243,344,270,114,002,002,160,044,044,044,224,115,052,162,272,337,337,273,165,041,041,041,231,275,045,045,045,275,230,164,053,172,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,242,167,002,002,160,270,044,044,224,115,052,060,226,273,337,340,236,165,041,041,121,231,275,045,045,045,045,245,245,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,014,115,114,270,044,044,270,161,052,052,163,273,337,337,340,236,165,041,041,121,165,275,045,347,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,242,240,277,044,044,225,162,052,060,163,337,337,340,340,231,121,041,041,173,245,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,360,352,242,162,060,060,162,227,337,345,302,245,245,200,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .even



frame2:   .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,264,204,204,204,212,204,250,367,033,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,264,254,327,364,254,144,100,100,072,100,246,357,357,250,205,205,207,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,221,146,101,042,254,364,364,364,246,072,072,072,072,202,356,357,360,204,074,075,076,207,316,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,257,155,110,110,102,101,100,246,356,356,356,246,072,072,072,136,357,357,360,250,075,075,075,142,317,363,316,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,367,367,367,257,146,102,102,101,073,136,246,356,356,312,202,064,072,072,246,352,352,360,067,075,067,142,354,363,363,317,252,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,207,214,333,376,367,367,367,221,074,074,073,072,202,312,356,350,312,131,064,064,174,352,352,352,177,067,070,135,310,355,355,245,077,207,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,215,043,043,157,267,033,367,367,361,250,074,074,073,072,202,350,350,350,240,064,064,131,305,352,352,243,067,070,134,245,355,355,245,135,071,142,252,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,215,043,043,043,043,104,214,316,361,361,361,250,074,064,064,064,240,350,350,304,174,064,064,226,344,353,301,067,070,134,245,355,355,245,135,071,071,200,317,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,215,043,043,043,043,105,105,104,075,252,361,361,360,250,014,064,064,131,276,350,342,232,056,057,162,344,344,345,163,063,127,237,355,347,245,071,071,071,245,354,316,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,333,267,267,215,157,105,105,077,077,076,076,243,361,353,352,352,014,064,056,167,342,342,276,114,051,115,300,337,345,164,054,127,231,347,347,237,127,071,135,245,354,353,353,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,376,036,036,036,036,325,267,215,077,077,077,076,070,177,353,353,344,300,167,056,003,224,044,044,224,051,052,226,337,337,164,041,041,231,045,347,237,127,063,127,274,354,353,353,023,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,214,267,267,333,036,036,371,363,363,252,252,142,071,071,070,177,301,344,300,276,115,002,114,270,044,044,115,052,162,337,337,227,041,041,231,045,045,231,041,063,165,346,354,353,227,066,023,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,214,111,112,112,157,214,267,325,363,363,363,363,317,245,135,070,053,053,226,336,336,270,003,002,224,044,044,160,052,162,337,337,230,041,041,231,045,045,165,041,041,227,345,345,353,162,066,066,023,000,000,000,000,000
          .byte 000,000,000,000,000,221,111,111,111,111,112,112,105,151,207,252,363,355,355,355,311,236,126,053,053,226,336,335,224,002,003,270,044,225,052,060,273,337,231,041,041,231,045,045,165,041,054,230,337,345,301,162,060,066,014,000,000,000,000,000
          .byte 000,000,000,000,000,155,111,111,111,111,111,104,104,076,077,077,207,245,311,355,347,347,230,164,053,053,226,335,044,114,002,160,044,335,116,060,227,340,231,041,041,275,045,045,165,041,164,273,337,337,226,060,060,057,232,242,000,000,000,000
          .byte 000,000,000,000,221,110,110,111,111,111,111,103,076,076,076,077,071,071,135,245,275,045,045,340,164,053,060,226,044,270,002,003,044,335,162,053,227,340,231,041,121,275,045,231,121,054,164,337,337,336,162,060,057,005,232,305,000,000,000,000
          .byte 000,000,000,000,264,264,264,264,264,257,257,023,023,207,205,135,135,071,063,063,121,231,275,045,337,227,060,060,271,044,224,002,232,342,226,053,163,340,231,041,121,045,045,231,054,054,227,337,336,272,116,052,051,232,342,342,352,000,000,000
          .byte 000,000,000,322,046,374,374,374,374,366,374,367,361,361,361,353,310,245,173,121,041,041,121,231,045,340,227,060,115,044,276,056,005,343,300,067,177,347,237,063,165,045,045,164,053,163,273,336,336,162,051,051,114,270,342,342,304,000,000,000
          .byte 000,000,000,326,326,326,326,327,327,322,322,360,360,360,361,353,353,354,340,045,231,165,041,041,165,274,337,226,057,240,350,174,064,305,352,067,200,354,245,063,173,347,045,164,053,163,336,336,226,116,051,003,224,044,044,342,224,242,000,000
          .byte 000,000,264,216,152,152,152,042,042,042,153,101,074,204,014,243,227,301,274,340,045,045,275,165,041,126,346,353,014,064,312,312,072,246,360,075,200,355,245,071,245,354,230,053,053,273,336,336,160,002,002,160,044,044,044,270,160,131,000,000
          .byte 000,000,153,042,042,042,042,042,042,100,100,073,073,073,066,066,066,053,053,163,231,274,045,045,275,135,071,243,360,136,136,356,136,211,360,075,207,363,207,077,311,354,177,053,162,336,336,225,115,002,114,270,044,044,044,224,003,056,014,000
          .byte 000,000,042,042,042,042,042,042,042,100,100,072,136,136,131,131,162,116,116,053,053,053,121,173,355,355,207,076,257,255,100,262,216,107,367,104,215,363,077,077,316,354,067,066,226,344,271,114,051,002,224,044,044,044,224,003,002,002,014,000
          .byte 000,212,042,042,042,042,042,042,152,210,254,246,312,304,350,342,343,335,336,300,226,227,163,126,071,207,363,267,111,255,216,152,262,110,367,043,223,325,105,207,361,205,066,014,352,342,232,002,002,160,044,044,044,224,114,002,002,003,167,000
          .byte 000,153,042,042,152,216,262,262,326,364,356,356,356,350,350,350,342,044,270,271,336,336,337,353,252,142,043,267,257,110,262,042,262,110,257,043,267,223,112,267,361,074,074,242,350,232,056,002,160,044,044,044,224,114,002,002,003,160,270,360
          .byte 000,211,216,262,326,046,046,046,046,364,312,246,246,174,174,005,003,003,002,002,002,051,131,014,023,033,267,157,223,221,211,216,262,155,267,043,267,157,111,367,212,074,202,356,304,131,064,114,270,044,044,270,114,002,002,003,224,271,335,352
          .byte 000,326,046,046,046,046,326,262,216,144,144,072,072,064,064,056,002,114,114,224,224,224,240,202,202,146,156,267,214,023,202,202,014,205,252,157,267,111,257,264,107,144,364,356,131,064,131,276,044,044,224,114,002,002,115,225,335,335,336,344
          .byte 322,046,046,326,262,216,042,042,042,100,100,072,072,131,240,232,044,044,044,044,044,276,304,246,210,216,212,221,252,236,226,224,226,245,207,252,221,155,374,042,042,326,320,136,072,136,304,350,342,224,003,051,051,115,226,271,336,336,336,336
          .byte 327,326,262,152,042,042,042,042,042,100,100,202,246,350,350,342,044,225,160,003,002,056,131,202,216,216,216,202,164,231,162,224,227,231,173,243,074,327,152,042,262,326,144,072,136,312,350,350,232,005,051,051,162,226,336,336,336,336,226,163
          .byte 255,152,042,042,042,042,042,042,042,153,246,357,357,352,305,162,116,052,060,162,226,344,352,202,211,216,210,174,160,200,204,246,237,165,227,162,312,202,042,262,262,042,042,144,312,356,305,174,066,057,116,162,336,336,336,336,336,226,163,053
          .byte 153,042,107,107,107,107,110,153,264,366,366,360,360,204,066,066,060,227,273,337,273,163,067,205,257,221,221,227,226,212,204,221,221,167,224,224,174,136,364,262,042,042,216,364,356,204,074,066,066,162,226,336,336,337,337,273,163,053,053,053
          .byte 212,110,110,110,110,110,212,374,374,374,264,205,075,075,067,177,345,337,337,164,041,165,355,252,151,223,223,245,227,204,177,014,216,240,224,160,232,312,144,107,216,255,374,264,146,074,074,067,014,337,337,337,337,273,163,163,053,053,053,053
          .byte 212,110,110,110,212,264,374,374,367,221,111,075,075,075,245,354,346,231,041,041,231,347,173,135,267,157,221,204,160,227,162,252,221,205,227,227,162,067,204,264,367,257,146,111,103,075,205,353,353,353,337,337,227,164,053,054,054,054,164,164
          .byte 221,110,146,257,367,367,367,257,111,111,103,104,142,316,354,310,245,041,121,275,045,165,165,354,142,264,216,216,204,200,246,212,223,200,231,231,237,310,316,221,112,111,111,111,214,361,361,354,354,310,236,164,054,054,054,054,164,164,231,274
          .byte 221,155,367,367,367,367,221,112,111,112,112,215,325,363,317,200,071,127,275,045,165,121,337,163,242,202,210,216,221,223,212,216,250,227,231,165,172,142,105,043,157,223,267,036,371,363,317,252,200,135,041,041,041,041,165,231,231,275,045,045
          .byte 257,367,367,367,367,156,112,112,043,043,157,325,371,252,142,077,135,311,347,165,054,337,227,116,276,174,246,204,215,215,204,240,232,162,227,231,311,310,325,036,333,333,333,267,215,151,077,071,071,071,063,127,165,231,275,045,045,045,045,347
          .byte 000,376,376,367,156,112,043,043,043,157,333,036,325,151,077,077,245,355,236,053,227,336,116,224,224,160,232,177,245,245,177,224,160,224,162,163,134,142,151,157,043,043,043,043,105,077,077,077,135,200,237,275,045,045,045,045,045,045,045,311
          .byte 000,033,267,156,043,043,043,043,157,333,036,267,105,105,077,252,363,310,067,053,344,226,002,044,114,224,226,227,165,231,164,226,224,114,270,305,250,023,147,112,112,043,043,157,151,207,252,245,355,355,347,045,045,045,045,045,275,275,231,245
          .byte 000,267,156,043,043,043,043,157,333,036,333,157,043,043,151,363,363,075,067,242,344,114,114,044,003,225,226,164,231,165,274,116,270,224,064,131,202,322,367,367,367,376,376,371,363,363,363,355,355,355,347,045,275,231,231,231,165,121,127,000
          .byte 000,215,105,043,043,043,157,267,036,333,157,043,043,043,267,367,205,075,074,357,305,064,232,044,003,300,226,164,045,041,275,227,057,304,350,202,072,101,110,146,221,221,221,257,267,252,252,245,245,245,173,165,165,165,121,041,041,041,127,000
          .byte 000,000,105,043,043,043,267,036,036,223,043,043,112,214,367,367,103,074,250,356,174,064,240,342,056,226,301,041,045,173,127,353,014,064,246,356,320,216,042,107,110,110,111,103,075,076,076,070,071,071,063,041,041,041,041,041,041,041,172,000
          .byte 000,000,151,105,105,267,036,036,267,043,043,112,112,367,367,221,110,074,246,356,136,072,304,304,131,242,353,071,245,355,071,177,352,204,072,144,262,046,326,262,216,153,146,102,075,075,067,067,070,070,126,041,121,121,121,165,165,165,252,000
          .byte 000,000,215,105,215,036,036,333,157,043,112,112,221,367,257,110,110,100,364,320,072,072,312,312,074,177,353,135,142,355,207,076,023,366,210,042,042,042,262,326,046,046,327,264,250,023,243,243,243,227,227,230,230,230,230,274,275,346,000,000
          .byte 000,000,000,215,325,371,371,223,112,112,111,111,367,374,212,110,042,216,046,262,100,100,356,246,074,205,361,207,077,252,363,104,103,212,046,262,042,042,042,042,216,254,364,357,360,360,352,353,353,337,345,337,337,337,340,340,340,310,000,000
          .byte 000,000,000,325,371,371,267,156,112,112,111,221,374,264,110,107,042,262,046,216,042,100,364,254,102,103,033,267,105,151,371,267,111,111,212,046,326,152,042,042,042,100,100,202,246,357,352,352,352,344,337,337,337,337,337,337,345,000,000,000
          .byte 000,000,000,000,325,371,214,104,111,111,111,367,374,264,107,042,042,262,046,152,042,042,046,255,110,111,257,325,157,043,223,036,221,111,110,153,326,046,262,152,100,100,072,072,064,131,014,174,226,226,272,273,226,273,273,273,353,000,000,000
          .byte 000,000,000,000,267,316,075,104,103,111,221,374,374,153,042,042,042,326,326,152,042,042,326,255,110,111,221,036,157,043,043,333,376,147,110,110,042,262,046,364,254,202,136,072,064,064,064,057,057,052,116,116,116,163,162,163,000,000,000,000
          .byte 000,000,000,000,000,215,076,103,103,103,367,366,327,107,042,042,152,046,326,042,042,042,326,374,110,111,147,036,267,043,043,157,376,367,155,110,110,042,210,364,356,356,312,312,174,131,064,056,051,051,052,052,060,052,053,177,000,000,000,000
          .byte 000,000,000,000,000,000,075,075,103,212,322,374,255,042,042,042,216,046,262,042,042,042,262,374,146,111,111,267,036,157,043,043,223,376,367,155,110,101,100,136,312,356,356,350,350,304,232,232,160,114,115,116,052,052,014,000,000,000,000,000
          .byte 000,000,000,000,000,000,207,075,075,264,366,357,210,042,042,042,216,046,262,042,042,042,255,374,146,111,112,214,036,267,043,043,043,267,367,367,212,102,073,072,072,202,312,350,350,350,342,342,044,270,224,224,224,162,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,147,204,360,360,327,211,100,100,100,254,046,262,042,042,042,255,374,257,111,112,157,333,036,215,043,043,112,257,367,361,204,074,073,072,064,174,240,304,342,342,342,044,044,044,044,335,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,023,360,357,312,136,072,100,100,254,364,326,100,042,042,211,374,257,111,111,043,267,371,325,105,105,104,104,316,361,360,250,074,064,064,064,064,005,224,276,044,044,044,044,044,360,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,360,357,312,136,072,072,144,320,364,320,100,100,100,212,374,367,147,104,104,151,036,371,267,105,077,076,205,361,360,360,352,242,131,064,056,056,056,003,160,224,270,270,360,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,360,246,072,072,072,136,312,356,312,144,100,101,212,322,367,257,104,105,105,267,363,363,207,077,076,076,205,353,361,352,352,232,167,005,002,002,002,002,003,167,250,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,250,136,072,072,136,356,356,312,136,072,073,074,360,361,361,076,076,077,207,363,363,363,207,077,076,070,177,353,352,352,344,344,232,114,003,002,002,005,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,204,136,072,202,356,356,356,202,073,074,074,250,361,361,207,077,077,077,317,363,363,317,135,071,067,067,177,272,352,344,344,335,271,224,114,014,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,202,202,350,356,356,202,073,074,074,023,361,361,023,077,077,077,135,363,355,355,310,135,070,070,053,177,226,344,336,335,335,343,250,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,250,312,312,350,240,073,074,066,014,361,353,354,200,071,071,071,245,355,355,355,245,172,070,053,053,053,226,300,300,353,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,360,357,246,131,066,066,205,353,353,353,245,071,071,071,200,311,355,355,347,245,172,053,053,053,163,243,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,367,204,066,066,177,243,353,354,354,200,135,071,063,200,347,347,347,045,230,172,134,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,023,205,023,353,354,354,245,127,063,127,127,237,347,311,310,317,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .even


frame3:   .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,023,014,242,352,250,305,352,242,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,361,353,177,066,066,066,174,342,342,342,276,233,131,005,005,242,352,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,252,310,310,354,353,243,066,124,060,005,233,342,342,044,224,003,002,002,160,276,344,352,353,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,252,142,135,135,245,354,354,353,353,227,124,060,052,167,270,044,044,270,160,002,002,114,271,335,336,272,163,200,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,252,077,071,071,071,135,245,353,345,345,337,226,124,052,051,160,044,044,044,224,003,002,003,224,336,336,272,162,053,164,245,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,316,363,245,200,135,071,071,071,127,237,346,345,337,273,162,052,051,003,270,044,044,270,114,002,002,225,335,336,336,163,053,053,164,245,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,363,363,355,355,355,245,173,135,063,063,121,230,337,337,337,272,162,051,002,224,044,044,044,160,002,002,161,336,336,272,163,053,053,164,274,347,316,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,252,207,252,311,355,355,355,355,311,237,127,041,041,121,230,337,337,336,226,051,051,003,270,044,044,224,002,002,161,271,336,337,227,053,062,164,275,045,045,311,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,267,075,075,142,200,245,311,355,355,347,347,231,165,041,041,120,227,337,336,336,162,051,002,224,044,044,270,003,002,162,272,336,337,227,053,054,165,275,045,045,231,200,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,252,075,075,075,067,070,134,200,236,347,045,045,045,275,165,041,054,120,227,337,336,271,114,002,114,270,044,270,114,002,114,272,336,337,163,053,054,165,045,045,045,231,121,200,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,023,205,074,075,067,067,070,070,071,127,173,231,045,045,045,045,231,054,054,053,273,336,336,225,051,002,224,044,044,160,002,052,272,336,337,163,054,041,231,045,045,045,231,041,041,200,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,366,250,250,250,014,177,067,067,062,063,041,121,165,275,045,045,045,231,120,053,163,336,336,271,114,002,160,044,044,224,051,052,226,336,337,163,054,041,231,045,045,275,165,041,041,165,252,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,360,357,357,360,352,352,352,353,227,163,120,054,041,041,165,231,045,045,045,231,054,053,163,336,343,233,002,003,276,342,232,057,060,226,337,337,163,041,121,231,045,045,231,121,041,121,231,274,000,000,000,000,000,000
          .byte 000,000,000,000,000,360,356,357,357,360,352,352,352,344,345,345,273,230,164,041,041,041,165,275,045,045,230,053,053,226,343,304,131,064,240,350,276,131,060,226,345,346,164,041,121,275,045,045,231,041,041,121,231,340,354,000,000,000,000,000
          .byte 000,000,000,000,000,202,202,202,246,240,352,352,352,344,344,337,337,337,274,230,165,041,041,165,275,347,346,172,067,014,352,350,174,064,174,350,305,131,066,243,353,301,127,063,173,045,045,045,165,041,041,165,274,340,337,310,000,000,000,000
          .byte 000,000,000,000,212,072,072,072,072,064,130,131,167,162,226,272,337,337,337,340,045,231,121,041,127,236,347,354,067,066,014,356,246,072,130,356,357,131,074,243,353,310,135,071,173,347,347,275,121,041,121,231,337,337,337,227,000,000,000,000
          .byte 000,000,000,212,100,072,072,072,072,064,064,056,057,051,052,124,162,227,273,273,340,340,275,173,063,071,245,355,361,075,074,312,356,072,072,312,356,074,075,243,361,245,071,071,245,347,347,237,041,041,164,340,337,337,273,162,177,000,000,000
          .byte 000,000,000,211,100,072,072,072,064,064,131,131,056,003,051,051,052,052,052,163,227,274,347,355,245,071,077,252,361,205,074,210,364,202,100,246,364,204,103,023,363,207,077,135,311,355,311,127,063,120,227,337,337,273,227,052,124,000,000,000
          .byte 000,000,250,144,202,246,246,246,240,240,304,304,232,224,224,224,161,114,052,052,052,053,243,310,355,252,077,077,267,367,102,042,326,262,100,216,365,102,103,023,363,207,077,142,355,355,245,071,062,172,301,337,337,272,162,052,052,014,000,000
          .byte 000,000,365,364,356,356,356,356,350,350,350,342,044,044,044,044,335,271,271,226,162,053,070,134,252,363,316,105,112,367,264,042,262,262,042,216,374,110,103,033,371,077,077,252,363,311,135,070,067,353,337,337,273,162,124,052,051,226,000,000
          .byte 000,000,364,364,364,356,356,356,350,350,304,342,044,270,044,044,044,044,044,335,344,352,243,075,076,151,333,267,112,155,330,042,152,326,042,216,330,111,112,036,267,105,105,316,363,207,075,067,177,353,344,272,226,052,052,051,161,271,352,000
          .byte 000,366,364,320,312,246,246,240,240,174,174,114,114,114,114,114,114,114,160,224,232,305,360,360,023,112,043,267,267,111,264,262,042,326,042,216,330,111,156,036,157,105,215,371,316,142,075,067,353,352,352,226,060,051,051,161,270,044,352,000
          .byte 000,211,210,144,100,072,072,064,064,064,064,056,002,002,002,002,002,002,002,056,064,064,136,211,330,367,223,043,267,223,155,326,100,320,100,212,257,112,223,333,043,043,267,033,156,075,075,023,352,352,352,005,057,057,114,224,044,044,276,000
          .byte 000,144,101,101,073,073,072,074,064,131,131,114,161,224,224,224,224,270,270,232,240,202,202,100,107,110,257,267,105,316,075,246,202,312,136,257,257,043,333,223,043,157,367,267,103,110,204,360,360,352,131,064,056,167,232,044,044,044,271,360
          .byte 000,102,102,074,074,074,074,074,014,242,343,344,335,335,335,335,335,044,342,342,350,312,320,326,262,216,102,222,252,200,243,174,174,240,014,023,207,151,371,043,112,267,367,111,111,102,366,357,357,136,064,064,131,232,342,044,044,270,224,242
          .byte 257,102,110,074,074,204,250,352,352,352,344,344,336,336,226,226,161,162,005,131,072,072,100,042,152,216,246,205,237,237,227,225,224,233,163,310,077,252,267,104,222,367,111,110,110,254,364,312,136,072,072,174,304,342,342,342,276,224,003,174
          .byte 212,110,102,212,250,361,361,352,361,353,344,227,163,124,053,052,053,052,162,014,250,250,262,262,216,210,202,240,227,231,230,225,161,226,230,231,200,355,076,214,374,212,110,107,262,046,262,072,072,072,136,240,350,350,342,276,160,003,002,005
          .byte 221,221,361,367,367,361,361,361,243,177,053,053,053,053,164,163,273,337,345,353,361,204,212,102,212,211,240,160,225,237,205,240,233,163,231,165,045,200,075,360,212,107,042,262,046,216,100,100,072,202,312,350,350,350,232,114,002,002,002,005
          .byte 367,367,367,361,367,361,252,205,067,070,070,062,172,230,274,340,340,275,230,135,071,076,222,267,257,214,163,226,174,264,221,216,221,245,165,274,163,162,352,202,100,152,326,046,216,042,042,100,210,356,356,356,304,174,131,002,002,002,114,233
          .byte 367,367,033,033,252,076,076,076,071,071,200,236,045,045,045,275,165,041,063,200,311,363,267,043,223,207,245,165,207,204,226,205,223,207,243,162,161,335,174,072,246,364,262,152,042,042,042,262,364,356,356,246,130,064,064,056,056,160,224,271
          .byte 033,033,222,104,105,077,077,077,077,245,355,347,045,045,231,041,041,165,231,355,311,077,043,267,223,214,243,227,204,204,205,226,211,216,174,224,233,003,174,356,356,210,042,042,042,216,326,364,364,246,136,072,064,064,064,174,233,271,335,343
          .byte 267,043,043,105,105,077,077,142,245,355,355,347,236,165,041,041,231,045,045,173,071,207,033,155,212,211,246,224,226,205,243,163,211,216,240,160,224,270,342,240,072,100,042,216,326,046,046,262,144,100,072,072,072,131,242,271,344,335,336,272
          .byte 151,043,043,105,105,077,207,363,363,355,355,173,127,063,121,231,045,045,164,054,243,353,075,211,262,216,210,204,237,227,160,252,223,214,177,226,162,162,005,131,204,246,373,046,262,216,107,107,101,101,074,074,204,352,352,352,344,344,336,272
          .byte 214,043,043,043,105,215,363,363,363,311,135,071,063,165,275,045,274,164,053,227,344,014,136,312,152,262,211,221,215,212,216,212,223,215,237,230,230,273,345,352,361,366,264,102,110,110,110,110,102,074,204,360,360,352,352,352,344,344,226,227
          .byte 215,043,043,043,267,371,363,363,252,077,071,071,200,303,045,274,164,053,227,336,161,064,350,202,202,211,221,223,223,212,216,216,205,200,173,165,165,165,200,200,075,103,111,111,111,111,111,221,257,361,361,360,353,353,353,272,227,163,053,177
          .byte 000,043,043,267,371,371,371,215,077,077,077,200,354,345,301,163,053,162,336,271,051,224,350,064,312,204,257,215,215,221,210,246,202,227,275,231,231,165,200,135,142,215,214,222,257,257,367,367,367,367,361,361,023,243,177,067,067,053,053,200
          .byte 000,223,267,036,036,333,215,105,077,076,142,310,353,353,163,052,162,336,044,114,003,044,224,005,352,067,245,207,252,205,240,130,276,226,053,165,231,045,355,363,363,371,036,036,333,333,333,257,222,214,142,075,075,070,067,070,053,062,053,252
          .byte 000,267,333,036,333,214,105,104,104,142,023,353,353,243,066,060,226,335,224,002,224,044,003,161,273,053,303,200,236,163,233,224,003,271,272,163,054,070,071,207,207,151,157,157,043,043,043,043,105,105,076,076,070,070,070,070,134,053,172,000
          .byte 000,371,036,333,223,112,104,104,103,023,361,361,250,066,066,174,342,044,114,002,270,044,051,226,273,054,045,165,237,273,052,044,224,002,225,336,345,245,200,076,105,043,043,043,043,043,043,043,105,077,077,077,077,135,200,245,236,274,311,000
          .byte 000,000,333,222,112,112,111,103,155,367,361,360,074,066,131,304,350,232,002,114,044,224,052,272,301,041,275,231,120,337,162,114,044,224,002,005,242,353,361,316,267,267,223,157,157,157,157,157,151,215,207,252,316,311,355,355,347,347,311,000
          .byte 000,000,222,112,112,111,111,155,367,366,360,204,073,073,174,350,350,174,056,224,044,161,052,273,274,041,231,045,041,227,272,005,114,044,304,174,131,074,205,023,033,033,036,036,036,036,036,036,371,363,363,363,363,355,355,355,347,347,000,000
          .byte 000,000,214,112,111,111,111,264,366,366,264,101,072,072,312,350,240,064,064,304,343,167,052,273,274,041,231,045,165,163,336,226,056,174,350,350,202,074,102,103,111,155,222,222,267,267,333,033,371,363,363,363,355,355,355,355,347,311,000,000
          .byte 000,000,000,111,111,111,155,330,374,330,144,100,100,202,356,356,202,064,130,305,352,014,053,301,346,041,165,347,231,053,226,352,240,064,130,312,356,312,211,110,110,111,111,112,112,112,043,151,151,207,207,207,200,200,245,173,173,245,000,000
          .byte 000,000,000,221,110,110,264,374,373,211,042,100,100,246,356,312,136,072,202,350,305,066,067,310,355,135,071,355,355,067,067,352,350,202,072,072,210,364,046,262,212,110,111,111,111,112,104,104,105,077,077,077,077,071,071,063,135,000,000,000
          .byte 000,000,000,000,110,212,374,373,262,042,042,042,100,320,364,246,072,072,202,360,250,066,067,245,355,200,071,245,355,200,075,014,357,356,202,100,100,152,262,046,046,330,264,155,111,155,104,104,076,076,077,071,071,071,071,063,207,000,000,000
          .byte 000,000,000,000,257,264,373,046,216,042,042,042,216,364,364,210,100,100,202,357,250,074,075,023,363,207,071,207,363,316,075,074,204,356,364,210,042,042,042,152,262,373,374,374,330,257,023,221,214,142,142,135,134,135,135,200,000,000,000,000
          .byte 000,000,000,000,000,330,046,262,042,042,042,042,216,046,046,152,100,100,211,357,366,075,076,252,363,252,077,077,252,361,205,102,102,210,046,046,216,042,042,042,042,152,254,330,374,374,367,361,361,361,316,316,310,245,236,252,000,000,000,000
          .byte 000,000,000,000,000,367,046,216,042,042,042,042,262,046,262,042,100,100,254,366,257,103,076,215,363,267,105,077,215,371,367,111,102,107,216,046,046,216,042,042,042,042,042,107,211,250,366,361,361,361,353,353,354,346,316,000,000,000,000,000
          .byte 000,000,000,000,000,000,330,152,042,042,042,152,326,046,262,042,042,042,264,374,257,111,111,151,371,371,151,105,105,267,367,257,110,107,042,216,046,046,262,152,042,042,042,100,101,102,204,204,361,360,353,353,353,310,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,212,042,042,042,216,046,046,216,042,042,107,264,374,257,111,112,112,267,036,223,043,043,156,367,367,212,110,042,042,152,326,046,326,216,152,042,100,100,073,074,074,074,177,023,243,353,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,212,042,042,216,046,326,216,042,042,107,264,374,257,111,112,043,267,036,267,043,043,112,222,367,367,110,107,042,042,152,326,046,046,320,210,144,072,072,073,074,074,066,066,067,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,212,042,262,046,326,152,042,107,107,212,367,257,111,112,043,223,036,333,043,043,112,111,257,374,264,107,042,042,042,152,262,364,364,364,320,246,136,072,074,131,066,066,023,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,211,326,046,326,042,042,107,110,264,367,367,111,112,043,043,333,036,223,043,043,112,155,367,374,264,107,042,042,042,042,210,364,356,356,356,312,246,174,130,066,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,330,046,326,042,042,107,110,221,367,367,112,112,043,043,267,036,333,043,112,112,111,221,374,374,254,042,042,100,100,100,202,312,356,356,356,356,350,357,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,330,254,042,107,110,110,212,367,367,156,043,043,043,223,036,036,223,043,112,111,111,257,374,374,254,144,100,100,072,072,136,246,356,350,356,357,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,212,107,110,110,221,367,367,222,043,043,043,043,333,036,333,043,112,112,111,155,330,366,365,246,144,072,072,072,072,072,174,312,360,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,257,212,111,221,367,367,267,112,043,043,043,267,036,036,222,104,111,155,103,212,366,366,357,312,202,072,072,072,136,204,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,221,221,367,367,033,043,043,043,043,223,371,036,033,151,104,103,103,103,250,366,357,357,312,202,136,204,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,033,033,215,105,105,105,105,267,371,371,267,076,103,103,103,074,250,360,360,357,366,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,214,215,151,105,252,363,371,363,215,076,075,075,075,023,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .even


frame4:   .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,252,310,353,353,353,163,014,014,014,242,360,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,245,200,127,121,231,275,340,340,337,227,053,052,052,162,271,343,305,352,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,317,311,275,231,121,041,041,121,231,340,337,337,337,162,052,052,115,224,044,044,044,224,174,014,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,245,303,045,045,045,045,231,121,041,041,121,230,340,337,337,226,116,052,116,225,044,044,044,224,002,002,005,242,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,126,172,230,340,045,045,045,045,231,121,041,041,164,274,337,337,337,162,052,051,167,270,044,044,224,003,002,002,224,343,353,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,177,053,053,053,120,165,231,045,045,045,045,231,121,041,041,165,337,337,337,226,052,051,003,270,044,044,270,003,002,002,224,335,271,352,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,301,162,162,053,053,053,120,165,231,045,045,045,045,231,041,041,120,230,337,337,344,162,051,056,232,342,342,276,114,056,002,232,343,336,336,226,177,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,344,336,344,226,163,053,053,053,054,121,231,045,045,045,275,165,041,062,126,301,345,352,226,064,064,167,350,342,276,167,056,056,232,335,344,344,162,053,200,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,023,335,335,336,336,336,336,227,163,120,054,041,121,165,275,045,045,303,127,063,062,243,353,352,305,131,064,131,305,350,350,174,064,064,232,343,344,344,163,053,053,200,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,242,233,270,271,335,336,336,336,336,337,227,163,054,054,041,172,303,347,347,311,135,071,067,243,352,352,174,065,064,240,350,350,174,064,064,014,352,352,352,163,053,062,164,310,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,005,003,114,114,225,224,336,336,336,336,337,301,227,120,041,063,200,311,355,355,245,070,070,177,360,360,240,072,072,246,350,350,174,064,065,240,352,352,352,053,067,062,172,346,311,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,131,056,002,002,002,003,003,115,225,272,336,336,337,337,302,172,071,071,200,311,355,355,207,075,075,023,360,246,072,072,202,356,356,202,072,072,242,352,352,243,067,070,126,245,347,347,311,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,174,003,003,002,002,002,002,002,002,051,115,162,272,336,345,353,310,200,071,071,207,317,363,252,076,075,204,360,312,136,072,136,356,356,202,072,073,250,360,353,243,070,070,135,311,355,347,303,252,000,000,000,000,000
          .byte 000,000,000,000,000,352,276,276,224,224,224,160,114,003,002,002,051,051,116,162,345,353,353,354,200,077,077,207,363,033,150,103,102,322,364,144,100,100,312,364,202,072,074,250,361,361,205,070,070,200,355,355,355,236,200,000,000,000,000,000
          .byte 000,000,000,000,000,305,342,342,044,044,044,044,044,270,224,160,003,051,051,060,060,014,353,361,363,207,077,077,215,363,267,103,110,212,364,216,100,100,320,364,144,101,074,360,361,023,076,076,071,245,355,355,311,200,063,200,000,000,000,000
          .byte 000,000,000,000,305,350,044,044,044,044,044,044,044,044,044,044,270,224,167,131,066,066,075,023,316,371,215,105,105,267,376,221,110,153,046,262,042,042,262,046,144,107,102,360,367,023,076,076,142,317,355,355,245,135,071,063,207,000,000,000
          .byte 000,000,000,000,305,276,276,224,270,270,270,044,044,044,044,044,044,342,350,305,174,066,074,075,147,033,376,157,043,043,376,257,111,107,326,262,042,042,262,326,042,110,146,367,367,150,076,077,207,363,363,311,200,071,071,063,245,000,000,000
          .byte 000,000,000,014,005,005,005,115,003,114,114,114,114,160,224,224,276,342,350,350,350,357,204,102,103,150,333,333,157,043,223,376,110,107,262,326,042,042,262,326,107,110,221,367,267,104,105,105,252,363,363,252,077,071,071,200,311,361,000,000
          .byte 000,000,000,066,060,052,052,051,051,051,002,002,002,002,056,002,002,131,174,174,312,356,356,264,110,111,112,333,333,043,112,367,264,110,216,326,042,042,326,262,110,111,221,367,214,043,105,151,363,363,252,142,077,071,134,245,346,354,000,000
          .byte 000,000,014,066,060,066,060,116,116,116,116,115,115,003,003,003,056,064,064,072,072,144,210,046,374,221,111,112,333,267,043,221,322,101,216,046,042,042,326,264,110,111,367,376,043,043,043,267,371,371,207,077,077,077,245,354,354,353,000,000
          .byte 000,000,177,066,163,226,226,226,226,272,272,272,272,335,271,276,276,240,240,136,072,100,042,042,216,374,257,112,157,371,151,150,360,145,144,364,100,100,046,212,111,147,376,223,112,043,157,036,371,252,105,077,076,142,361,354,353,353,023,000
          .byte 000,000,353,353,353,345,345,337,336,337,336,336,336,344,336,336,305,350,350,356,364,262,216,042,042,042,264,033,105,207,317,075,353,202,136,356,072,202,366,103,111,267,036,157,043,043,267,036,267,105,104,077,076,316,361,361,353,243,177,000
          .byte 000,354,353,353,345,337,337,337,337,337,337,301,227,226,226,226,242,014,202,202,254,262,326,326,262,152,102,023,316,071,311,200,242,240,174,350,072,250,361,103,112,371,267,043,043,223,036,333,043,043,104,104,023,361,361,361,242,177,066,000
          .byte 000,361,354,346,346,340,274,230,227,163,164,053,053,053,053,053,066,066,074,102,101,042,042,042,216,320,246,066,243,236,172,230,162,224,114,276,065,352,023,076,267,371,157,043,157,333,036,156,112,112,103,221,367,361,360,023,074,066,066,204
          .byte 000,354,355,310,236,172,164,120,054,054,054,054,054,120,164,177,177,243,023,257,264,212,216,216,144,072,202,276,163,230,165,230,162,224,160,224,162,345,134,134,363,252,105,043,267,376,214,112,111,111,221,367,367,366,250,074,074,066,065,204
          .byte 000,245,200,135,063,063,041,041,041,121,165,165,231,274,346,347,355,316,361,367,257,257,257,264,312,246,232,160,226,165,231,227,225,224,224,162,227,275,071,311,317,077,077,267,376,214,111,111,111,221,374,374,322,204,074,074,074,065,131,250
          .byte 207,071,071,071,063,063,121,165,231,231,045,045,045,045,045,311,245,207,077,105,043,112,111,147,205,014,160,224,160,243,200,243,174,174,226,163,274,121,231,355,200,077,252,367,257,111,111,110,212,374,374,264,154,101,073,073,072,136,240,356
          .byte 207,071,071,071,071,172,231,275,045,045,045,045,045,231,172,063,071,077,077,215,267,333,267,267,207,236,227,162,240,211,223,221,210,246,177,231,231,165,045,172,071,245,361,023,111,110,110,212,374,373,255,107,100,100,100,072,136,312,356,350
          .byte 207,077,071,200,245,303,347,045,045,045,275,231,165,041,041,135,200,317,363,371,267,157,043,151,207,172,231,172,221,216,252,202,216,221,252,245,165,045,164,053,302,353,204,074,102,153,255,373,326,216,042,042,100,100,100,202,356,356,350,350
          .byte 207,134,245,311,347,347,045,045,275,231,121,041,041,121,231,303,355,355,252,105,112,156,267,267,207,236,227,236,214,014,014,227,207,223,215,207,302,163,163,337,344,014,066,074,211,046,046,262,042,042,042,042,042,144,254,364,356,356,356,304
          .byte 252,311,355,355,355,347,303,231,165,041,041,121,165,275,045,346,245,067,075,076,257,367,147,146,250,240,225,232,255,204,075,242,177,212,212,204,014,226,335,225,005,064,174,312,356,320,216,042,042,042,042,042,216,320,364,356,356,312,246,174
          .byte 317,363,355,355,355,245,165,121,041,041,165,230,340,340,340,163,067,067,023,360,264,107,152,262,144,240,160,225,236,204,205,227,240,216,210,246,240,160,003,002,224,342,350,356,202,100,042,042,042,042,216,262,046,046,364,320,202,136,072,072
          .byte 317,363,355,311,245,126,063,054,120,165,274,337,337,274,163,053,060,242,352,250,100,216,326,042,262,202,014,231,231,225,226,231,205,211,216,202,174,224,270,044,044,276,174,072,072,100,100,042,216,326,046,046,046,262,210,144,072,072,072,072
          .byte 317,317,252,200,070,070,070,053,227,337,337,337,301,116,052,116,344,305,240,072,202,364,152,152,262,212,252,207,200,240,240,205,223,223,221,204,233,225,160,114,002,064,064,072,202,210,262,046,046,046,326,216,152,042,100,100,072,072,072,072
          .byte 252,252,142,070,070,070,134,227,301,337,337,226,116,052,162,271,044,276,064,064,356,202,100,326,154,221,214,215,221,210,216,212,223,223,252,245,163,162,162,162,225,233,304,356,356,356,364,326,262,152,042,042,042,042,100,100,100,072,136,202
          .byte 000,075,075,067,067,177,243,345,344,336,226,116,052,116,271,044,044,003,064,350,350,072,202,264,111,267,157,223,212,216,216,153,257,215,134,200,274,337,337,336,344,352,352,360,246,211,152,042,042,042,042,042,042,042,100,100,136,202,246,360
          .byte 000,075,075,067,075,242,352,352,344,226,116,052,116,270,044,044,114,002,224,350,174,064,360,205,150,267,043,267,154,262,216,254,075,252,311,165,121,041,041,120,053,067,067,074,102,102,102,107,107,107,042,042,042,152,211,254,320,357,357,360
          .byte 000,207,075,075,242,352,352,352,226,005,051,002,224,044,044,224,002,114,044,044,005,014,353,134,207,325,077,361,102,254,136,246,352,067,172,045,045,275,231,165,172,067,067,075,075,103,111,146,110,154,212,264,264,322,366,366,366,360,360,000
          .byte 000,205,075,250,360,360,305,352,131,005,056,160,044,044,270,002,002,224,044,225,052,243,353,071,245,311,077,316,014,202,304,064,240,344,120,041,165,275,045,347,355,354,316,316,361,367,367,367,367,374,374,374,374,374,366,366,360,322,250,000
          .byte 000,000,250,360,360,352,305,174,065,064,167,270,044,044,160,002,114,044,335,162,052,301,302,041,245,303,071,353,242,064,342,232,002,272,336,227,121,041,121,172,245,311,317,316,033,033,367,367,367,367,367,257,257,264,221,212,204,204,205,000
          .byte 000,000,360,360,357,357,202,064,064,131,240,342,044,224,002,002,224,335,272,052,163,337,231,041,231,045,063,227,336,005,160,044,160,051,226,337,337,231,127,071,071,077,077,077,151,151,112,156,112,111,111,111,111,111,103,103,075,075,000,000
          .byte 000,000,361,356,357,202,072,064,064,174,350,350,342,167,002,003,044,336,226,053,163,340,231,041,231,045,120,163,336,225,002,270,044,160,052,163,301,346,347,311,200,077,077,105,105,043,043,043,112,112,112,111,111,111,103,103,075,150,000,000
          .byte 000,000,000,366,246,072,072,072,072,304,350,350,276,056,002,232,336,336,163,053,227,340,231,041,231,045,164,053,336,271,003,003,044,044,160,052,053,227,353,354,363,317,252,215,151,043,043,043,043,043,043,112,112,112,104,076,076,150,000,000
          .byte 000,000,000,250,136,072,072,072,202,350,350,350,174,064,056,233,336,272,163,053,230,045,231,041,231,045,230,053,226,335,224,002,160,044,044,225,066,067,067,200,317,363,371,371,333,267,267,223,223,223,157,157,157,150,150,214,207,000,000,000
          .byte 000,000,000,000,145,100,072,072,246,356,356,240,064,064,131,344,344,301,053,053,275,045,231,041,165,045,274,053,162,272,044,114,002,160,342,350,242,014,075,075,076,150,267,325,036,036,036,036,036,036,036,333,036,033,371,325,325,000,000,000
          .byte 000,000,000,000,204,072,072,202,356,356,356,174,064,065,014,352,352,227,067,062,303,045,231,041,165,045,340,163,052,226,044,276,056,056,174,350,350,352,204,075,103,104,104,043,157,223,267,333,333,036,036,036,371,371,363,363,000,000,000,000
          .byte 000,000,000,000,000,211,100,254,356,356,246,136,073,065,242,352,353,177,070,062,245,347,303,063,127,302,346,227,053,005,342,350,240,064,064,174,356,360,360,023,103,103,111,112,043,043,043,043,157,223,223,267,267,325,325,267,000,000,000,000
          .byte 000,000,000,000,000,000,211,320,356,356,202,072,073,073,360,352,353,177,070,135,311,355,245,071,063,245,346,353,060,066,240,350,350,174,072,072,136,246,366,360,322,221,111,111,112,043,043,043,043,043,043,105,105,151,215,000,000,000,000,000
          .byte 000,000,000,000,000,000,322,320,364,320,136,073,073,074,360,361,353,134,070,071,311,355,311,071,071,200,353,353,014,066,131,246,350,356,136,072,072,072,210,366,374,374,367,221,111,112,112,112,043,043,043,105,105,151,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,322,320,254,100,073,101,074,360,361,361,075,076,077,311,363,317,134,071,134,354,353,242,074,073,136,356,356,312,136,100,100,100,153,264,374,367,367,367,221,156,112,112,043,043,105,151,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,322,210,100,102,102,204,367,361,361,076,077,077,252,363,363,207,077,077,252,361,361,074,073,072,202,356,364,320,144,100,042,042,107,154,264,367,367,367,367,267,223,156,043,151,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,212,101,102,102,212,367,367,252,104,077,077,252,363,363,207,077,076,205,361,360,250,073,100,072,210,364,364,254,042,042,042,042,107,154,212,264,367,367,367,367,376,267,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,212,102,110,221,367,367,267,105,105,077,207,363,363,207,077,076,103,023,367,360,145,101,100,100,262,046,046,262,152,042,042,042,107,110,146,221,257,367,367,367,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,257,102,221,367,367,267,105,105,105,151,371,371,267,105,104,103,221,374,366,264,042,042,042,042,262,046,046,326,152,042,042,107,107,110,110,110,221,257,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,257,257,367,376,267,104,043,105,151,325,371,325,105,112,103,111,367,366,374,152,042,042,042,042,216,046,046,326,216,042,042,107,110,110,110,221,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,361,033,223,043,043,043,043,267,371,333,151,112,111,103,221,374,374,262,042,042,042,042,042,262,046,046,046,262,042,042,107,154,257,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,267,043,043,043,043,267,036,036,223,112,111,111,111,264,374,373,216,042,042,042,042,042,262,046,046,046,262,216,212,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,214,157,043,223,036,036,267,112,111,111,111,212,374,373,326,152,042,042,042,042,042,216,326,373,322,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,215,215,333,036,333,156,111,111,111,110,264,373,046,262,042,042,042,042,152,153,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,325,033,214,156,111,111,110,154,264,373,373,264,212,212,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .even

frame5:   .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,317,311,200,135,135,200,245,361,354,361,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,200,245,303,347,347,303,237,135,063,063,200,311,346,353,353,177,177,204,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,053,053,053,163,236,347,347,355,311,200,071,071,071,245,354,353,353,014,066,066,066,174,360,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,361,300,226,053,053,053,062,173,245,347,355,355,245,135,071,071,135,354,353,361,023,066,066,131,174,350,312,360,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,343,343,336,336,227,163,053,053,070,200,311,355,355,355,200,071,071,076,245,361,361,353,074,074,074,137,312,350,350,246,250,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,242,233,044,335,336,344,344,226,177,067,070,071,135,311,355,355,317,077,077,076,142,361,361,361,204,074,073,072,312,356,356,246,072,137,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,057,003,114,160,224,344,344,352,352,353,177,070,070,077,207,363,363,363,207,077,077,076,023,361,361,204,073,073,072,246,356,356,246,072,072,072,204,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,242,122,002,002,002,002,167,166,343,352,352,352,353,205,076,076,077,207,363,363,325,151,077,077,221,367,361,212,102,072,072,246,356,356,202,072,072,072,202,360,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,352,233,160,114,003,002,056,056,064,174,242,352,352,353,361,205,076,076,077,267,371,371,215,104,104,103,367,366,264,101,100,100,210,364,364,202,072,072,072,202,356,360,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,360,270,044,044,270,224,166,122,064,064,064,131,014,360,360,361,361,076,104,077,077,267,371,267,043,112,103,257,366,264,107,042,100,210,364,364,210,100,072,072,246,357,357,367,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,352,044,044,044,044,044,342,276,276,174,064,064,072,073,137,250,361,367,367,104,105,105,157,036,036,157,112,111,155,374,330,042,042,042,216,364,364,144,100,100,100,254,357,360,250,221,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,232,270,270,044,044,044,342,342,350,350,240,174,072,072,073,102,204,367,367,267,043,043,043,223,036,267,112,111,155,374,373,152,042,042,216,046,326,152,042,100,100,321,366,360,204,075,205,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,124,115,115,115,224,224,276,276,350,350,350,350,312,246,136,072,101,102,155,367,367,223,043,043,043,333,333,112,111,111,264,373,152,042,042,216,046,262,042,042,042,216,366,366,360,147,075,075,000,000,000,000,000,000
          .byte 000,000,000,000,000,014,052,052,052,051,051,003,122,167,174,240,350,356,356,356,254,210,100,110,110,155,367,376,157,043,043,223,036,221,111,111,264,373,216,042,042,216,046,262,042,042,042,211,366,374,212,111,103,075,076,000,000,000,000,000
          .byte 000,000,000,000,243,053,052,052,052,052,052,051,064,064,064,064,136,202,246,356,364,364,262,042,110,110,155,376,333,043,043,157,036,267,111,111,212,046,216,042,042,216,046,216,042,042,042,264,374,330,155,103,103,103,207,267,000,000,000,000
          .byte 000,000,000,000,243,227,227,227,226,162,162,162,057,066,064,064,072,072,072,100,210,326,046,262,153,110,111,221,376,267,043,043,267,376,111,110,212,046,216,042,042,262,046,216,042,042,107,330,374,257,111,111,103,104,267,032,000,000,000,000
          .byte 000,000,000,353,337,337,337,337,337,337,300,300,352,242,240,174,136,072,100,100,042,042,216,046,326,212,110,111,267,036,215,043,215,376,221,102,211,046,210,042,042,262,046,152,042,107,212,374,367,155,111,112,112,156,325,371,325,000,000,000
          .byte 000,000,000,353,337,337,337,337,337,337,345,345,352,352,360,360,312,246,216,100,042,042,042,152,262,046,212,111,104,032,325,077,077,361,023,074,202,364,210,100,100,046,326,042,107,110,264,367,257,111,112,112,043,267,371,371,325,000,000,000
          .byte 000,000,354,340,340,340,340,337,273,273,353,353,353,353,360,360,360,366,364,046,262,152,042,042,042,262,366,205,104,207,363,207,077,317,361,074,202,357,202,072,144,364,262,107,110,212,367,367,111,112,112,112,223,036,371,371,215,151,000,000
          .byte 000,000,236,231,231,165,165,165,164,172,163,126,067,177,177,146,204,212,211,262,046,046,262,216,042,100,202,366,205,077,245,355,070,245,352,066,202,356,202,072,246,356,211,102,110,221,367,257,112,112,043,043,333,036,036,223,105,151,000,000
          .byte 000,000,173,121,121,041,041,041,041,041,070,070,070,076,075,075,103,102,110,110,042,216,262,046,326,136,072,014,353,135,200,347,173,163,352,066,174,350,174,072,312,357,074,102,146,367,032,156,112,043,043,267,036,036,267,043,105,105,215,000
          .byte 000,200,041,041,041,041,041,041,121,126,126,200,200,207,142,142,147,147,111,111,110,107,042,144,246,356,240,131,226,340,041,275,231,053,336,115,224,342,064,130,350,250,074,075,257,367,267,112,043,043,223,036,036,267,043,043,043,105,151,000
          .byte 000,173,041,121,121,165,165,231,231,303,303,355,355,363,363,363,376,376,032,367,257,264,212,137,072,130,350,270,052,273,231,165,274,053,336,003,224,044,056,233,352,014,075,205,363,325,043,043,043,157,333,036,267,043,043,043,043,043,215,000
          .byte 000,165,165,231,275,275,045,045,045,347,355,355,355,363,317,267,267,267,223,267,267,257,367,360,304,233,002,224,271,053,275,165,274,163,271,003,270,224,003,336,300,067,067,361,361,207,105,105,157,333,036,267,157,043,043,043,112,156,267,032
          .byte 000,275,045,045,045,045,045,045,045,347,303,245,200,142,077,077,043,043,043,043,043,105,076,075,177,233,270,114,224,226,237,172,236,162,232,003,044,003,162,336,163,053,245,355,252,077,077,151,333,036,333,157,043,043,043,112,156,267,367,032
          .byte 311,045,045,045,045,045,045,275,231,173,135,071,071,071,077,105,043,157,223,267,267,267,325,245,236,163,162,224,166,242,252,207,023,014,240,166,270,052,337,227,054,237,355,311,071,077,142,325,371,333,157,043,112,112,112,156,376,367,367,367
          .byte 355,045,045,045,275,231,165,121,041,063,071,071,135,207,207,267,371,036,036,267,267,223,207,200,237,236,227,014,246,211,221,223,212,210,202,240,162,227,340,054,165,045,303,135,071,207,317,371,325,151,112,112,112,112,221,367,367,367,257,257
          .byte 311,275,275,231,165,121,041,041,041,126,172,245,354,363,363,367,267,156,112,112,043,077,207,245,231,231,231,245,212,216,221,223,211,216,210,204,177,346,121,165,045,275,121,063,200,355,363,252,151,104,112,111,111,221,367,367,367,257,155,146
          .byte 236,231,164,054,054,053,054,053,163,274,353,353,353,353,023,147,111,111,111,221,367,367,361,177,163,227,236,215,223,246,163,243,202,211,212,214,317,135,165,045,231,041,041,237,355,353,252,076,075,103,111,221,367,367,367,374,221,110,110,110
          .byte 172,053,053,053,053,053,163,273,337,337,345,353,243,075,075,075,102,212,330,374,212,102,073,242,226,226,233,211,204,227,205,226,226,214,223,223,077,245,347,231,041,165,340,340,353,177,067,075,075,074,257,367,374,374,264,110,110,110,110,110
          .byte 163,053,053,053,163,227,337,337,337,336,227,014,066,066,074,204,321,373,216,042,042,210,356,174,166,224,233,202,212,177,074,023,231,252,223,214,267,245,062,053,273,337,337,227,053,067,067,204,250,330,374,374,264,212,110,110,107,107,107,107
          .byte 053,053,162,163,336,336,336,336,336,226,124,060,066,130,246,356,364,152,042,042,262,326,072,202,232,160,226,237,207,254,221,174,224,204,212,212,074,204,226,336,336,226,124,052,060,014,242,360,360,360,330,211,107,107,042,042,042,042,042,042
          .byte 163,163,300,336,336,336,336,271,162,052,051,057,240,304,356,312,072,100,152,326,262,042,216,312,066,236,165,231,162,240,237,227,233,202,216,216,254,246,233,167,051,051,115,225,343,343,350,357,312,210,100,042,042,042,042,042,042,042,216,262
          .byte 243,300,336,336,336,336,226,115,051,002,003,224,350,350,240,072,072,144,046,262,042,152,330,102,023,245,237,227,225,224,227,200,205,211,216,216,136,136,122,166,224,270,044,044,342,304,240,174,072,072,100,100,042,042,042,152,216,326,046,046
          .byte 353,336,336,335,271,225,115,002,002,114,224,044,342,240,136,072,202,364,364,042,042,330,155,221,267,207,252,177,240,166,243,207,267,221,212,254,246,350,342,044,044,044,224,224,166,122,064,072,072,072,100,100,152,216,262,326,046,046,046,321
          .byte 000,336,335,271,225,003,002,002,114,270,044,044,276,122,064,130,312,356,136,073,264,257,111,267,223,223,221,204,202,202,212,267,157,267,221,074,074,131,122,003,003,002,002,002,056,064,064,136,136,202,254,254,326,046,046,046,046,326,262,264
          .byte 000,343,270,160,003,002,002,114,270,044,044,270,114,056,064,304,350,246,074,146,367,221,043,333,043,223,221,216,216,262,212,221,223,043,215,317,353,300,226,225,160,224,160,224,240,240,240,312,356,356,364,046,046,046,326,262,216,152,042,212
          .byte 000,242,160,003,002,002,114,224,044,044,044,167,002,122,232,350,352,066,074,023,367,105,157,333,043,267,146,216,216,042,254,111,267,267,077,077,200,227,337,336,336,335,335,044,342,350,350,356,356,364,254,254,216,216,042,042,042,042,042,000
          .byte 000,242,003,002,002,114,224,044,044,044,224,002,002,160,335,344,014,066,177,361,252,077,267,325,043,257,212,152,326,042,254,264,103,252,363,245,135,054,053,053,163,226,226,225,240,240,240,202,202,136,100,042,042,042,042,042,042,042,152,000
          .byte 000,000,056,056,003,224,044,044,044,224,003,002,114,271,336,300,124,067,245,355,200,077,317,252,076,257,264,100,326,202,100,360,023,070,200,355,347,275,165,053,053,053,053,060,060,131,066,072,072,100,100,100,042,042,042,042,042,042,212,000
          .byte 000,000,131,002,224,044,044,044,270,114,002,051,225,336,336,227,053,053,354,355,135,071,363,252,075,023,360,072,246,312,072,204,352,245,063,121,231,045,045,045,273,227,163,163,066,066,066,073,073,100,100,100,042,042,042,042,042,152,000,000
          .byte 000,000,242,166,276,044,044,044,160,002,051,115,336,336,337,053,053,227,045,303,071,135,355,354,067,242,352,130,136,350,240,131,242,345,274,121,041,165,231,045,340,340,346,353,353,353,250,250,250,212,212,211,216,216,216,262,262,254,000,000
          .byte 000,000,000,240,342,044,044,224,003,051,052,226,336,336,227,053,054,231,045,231,062,173,347,245,067,014,352,174,064,240,342,167,052,227,337,045,165,041,041,121,231,231,346,353,353,353,361,361,366,366,374,374,374,373,373,373,046,330,000,000
          .byte 000,000,000,352,342,342,270,167,051,051,162,336,336,337,163,054,165,045,045,231,041,165,045,274,053,162,344,276,056,114,342,270,124,052,227,340,045,231,165,041,041,063,135,200,245,023,361,361,361,367,366,374,374,374,374,373,330,000,000,000
          .byte 000,000,000,000,304,342,233,057,052,052,226,336,337,273,053,054,165,045,045,165,041,165,045,273,053,124,336,044,114,002,224,044,271,052,053,227,045,045,045,231,173,063,071,071,077,076,076,075,147,147,155,155,155,212,146,212,257,000,000,000
          .byte 000,000,000,000,304,240,115,060,052,162,300,337,337,227,054,041,231,045,045,165,041,165,340,337,053,052,271,044,224,002,114,044,335,226,052,053,163,275,045,347,347,245,200,071,077,077,076,076,104,103,103,111,111,111,110,155,000,000,000,000
          .byte 000,000,000,000,000,242,066,060,060,226,337,337,337,163,041,041,231,045,045,165,041,165,340,337,163,052,162,044,044,003,002,224,044,336,226,053,053,053,237,355,355,355,355,317,207,142,077,105,112,112,111,111,111,111,111,000,000,000,000,000
          .byte 000,000,000,000,000,000,066,060,066,227,337,337,274,164,041,121,275,045,045,165,041,165,337,337,226,052,115,044,044,224,002,003,224,335,336,226,053,053,062,200,311,355,355,363,363,325,267,215,151,112,112,112,111,111,214,000,000,000,000,000
          .byte 000,000,000,000,000,000,205,066,014,301,345,346,236,126,041,165,275,045,045,165,041,165,337,337,226,052,115,224,044,044,114,002,003,271,336,300,227,053,070,070,071,200,252,363,363,363,371,371,333,267,223,221,156,156,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,177,177,353,353,346,236,063,063,165,045,045,045,165,041,121,337,337,300,124,051,160,044,044,224,003,002,115,343,344,352,353,177,070,071,077,077,207,267,325,371,371,036,036,036,333,267,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,353,353,353,346,200,071,063,173,303,347,303,165,041,053,273,337,336,162,051,115,270,044,044,166,056,056,174,343,352,353,353,207,076,077,077,077,105,151,215,267,333,036,036,036,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,353,354,311,200,071,071,172,347,347,347,173,063,126,227,337,336,162,051,056,224,342,342,276,122,064,131,014,352,352,353,361,023,076,076,105,105,105,043,043,157,157,267,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,317,245,135,071,071,200,355,355,355,200,062,053,227,353,300,300,131,056,122,276,350,350,240,130,064,131,014,360,361,361,361,023,215,104,105,043,043,043,043,157,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,252,135,071,071,200,355,355,355,200,070,070,177,353,352,352,174,064,064,174,350,350,350,174,073,064,073,074,250,361,361,367,032,214,112,043,043,043,215,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,142,071,200,355,355,354,200,070,067,177,353,352,352,240,064,064,130,240,356,350,312,202,072,073,073,074,257,367,361,367,032,267,156,157,214,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,207,252,363,355,363,200,070,070,067,352,352,352,240,130,064,072,202,312,356,356,246,136,073,073,102,074,221,367,367,367,367,032,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,317,363,363,207,076,075,075,243,360,352,356,202,072,072,072,202,356,356,356,246,072,101,101,102,110,146,257,367,023,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,317,252,075,075,075,074,360,360,357,246,072,072,072,072,246,356,364,364,254,100,101,102,102,155,221,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,207,205,075,075,250,357,357,312,136,072,072,072,100,246,364,364,326,210,101,212,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,023,361,367,360,312,202,072,100,100,100,211,321,360,360,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .even


frame6:   .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,150,075,075,076,215,325,363,325,215,151,151,215,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,360,360,360,250,074,075,075,103,150,252,371,371,325,105,077,105,105,215,033,033,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,073,246,356,357,357,360,264,102,103,103,104,151,033,371,371,223,043,043,043,043,033,367,367,221,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,073,072,072,072,202,312,357,366,366,205,075,111,104,104,267,371,036,267,043,043,043,043,267,367,367,221,111,212,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,357,202,064,072,072,072,072,144,320,360,374,366,155,111,111,112,043,333,036,333,043,043,043,112,222,367,367,221,110,110,110,153,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,360,312,350,312,246,136,072,072,072,100,144,254,374,374,257,111,111,112,112,223,036,036,223,043,043,043,156,033,367,264,110,110,107,042,254,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,250,304,356,356,356,356,312,144,100,100,100,042,042,254,374,374,221,111,112,112,043,333,036,267,043,043,112,156,367,367,212,110,110,042,042,262,046,366,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,204,174,240,312,356,356,356,356,312,210,100,042,042,042,042,264,374,367,155,112,112,043,223,036,333,043,043,112,112,367,367,257,110,107,042,042,262,046,326,211,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,066,066,074,072,136,202,246,356,364,364,364,262,042,042,042,042,107,264,374,257,111,112,043,157,333,036,223,043,112,111,257,367,264,110,107,042,042,326,046,262,042,153,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,177,066,066,074,074,073,072,072,144,246,046,046,046,262,042,042,042,107,110,374,367,222,112,043,043,267,036,267,043,112,112,257,367,264,107,042,042,152,326,046,262,042,042,153,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,361,243,177,074,066,074,074,073,100,100,100,152,262,046,046,262,152,042,042,110,212,367,367,156,043,043,223,036,333,043,112,111,257,374,264,107,042,042,216,046,046,216,042,042,042,212,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,361,353,353,353,361,250,204,074,102,101,042,042,042,042,152,326,046,326,152,042,107,110,257,367,267,043,043,151,371,371,157,103,111,257,374,264,042,042,042,216,046,326,152,042,042,042,042,264,000,000,000,000,000,000
          .byte 000,000,000,000,000,361,346,353,353,353,361,361,361,360,250,153,042,042,042,042,042,042,262,046,326,216,107,110,146,367,367,215,105,105,325,371,214,104,103,257,374,254,101,042,042,262,046,326,042,042,042,042,216,326,000,000,000,000,000,000
          .byte 000,000,000,000,000,311,311,310,355,361,361,361,361,367,374,366,264,216,042,042,042,042,042,216,046,364,210,102,102,205,371,252,077,077,207,363,252,103,075,250,366,254,100,100,100,262,046,262,042,042,042,042,262,046,374,000,000,000,000,000
          .byte 000,000,000,000,200,200,200,135,200,207,207,023,257,257,367,374,374,374,326,216,042,042,042,042,210,364,364,073,074,075,361,363,207,077,207,363,252,075,075,250,360,246,072,100,210,364,046,216,042,042,042,152,326,046,327,221,000,000,000,000
          .byte 000,000,000,000,071,071,071,071,077,076,076,076,104,103,155,155,221,264,374,046,326,216,042,100,100,210,356,357,074,067,023,355,245,071,135,355,361,067,067,360,357,202,072,072,246,364,320,144,042,042,042,262,374,374,212,146,000,000,000,000
          .byte 000,000,000,135,071,071,071,071,077,077,077,077,104,104,111,111,111,111,146,264,327,046,320,210,072,072,202,350,352,067,067,310,355,135,135,355,310,067,066,352,350,202,072,072,312,356,254,100,100,042,216,365,374,264,110,111,221,000,000,000
          .byte 000,000,000,173,173,200,200,207,207,142,142,105,105,043,112,112,111,111,110,110,110,254,364,356,246,136,064,240,352,243,053,237,347,173,063,303,345,053,066,305,305,174,064,202,356,356,202,100,100,100,264,374,374,212,111,111,111,000,000,000
          .byte 000,000,311,303,311,311,311,355,363,363,363,325,325,267,267,222,214,111,111,111,102,074,073,312,350,304,131,056,271,336,053,121,045,231,054,274,337,052,124,343,304,131,064,240,350,312,072,072,101,211,366,366,264,111,111,111,112,150,000,000
          .byte 000,000,347,347,355,355,355,363,363,363,363,371,371,036,036,036,036,036,333,257,221,155,074,074,174,342,342,003,115,336,227,054,275,275,041,230,337,052,162,342,270,056,131,304,350,246,072,074,102,360,374,367,155,111,111,111,112,214,000,000
          .byte 000,311,347,347,355,355,355,355,252,252,252,223,223,223,223,223,222,267,267,371,361,361,243,014,057,003,270,044,003,162,337,121,231,045,041,230,301,052,225,044,160,056,233,350,350,131,074,074,250,361,367,221,111,111,112,112,156,033,000,000
          .byte 000,311,045,311,245,245,200,142,142,077,077,105,043,043,043,043,043,043,043,105,142,207,353,353,336,167,002,224,270,052,301,230,165,045,120,301,272,051,270,044,003,002,270,342,240,066,066,242,361,361,023,075,103,104,104,156,333,036,333,000
          .byte 000,230,164,127,070,070,070,076,076,076,105,105,112,043,043,043,043,043,043,105,077,071,070,053,227,336,224,003,224,225,163,303,127,347,053,301,225,003,044,224,002,160,044,271,124,066,014,353,353,361,150,076,104,105,150,333,036,036,333,000
          .byte 000,053,053,067,067,067,070,076,076,076,150,214,222,267,267,267,333,036,371,363,363,355,303,165,120,053,226,270,131,304,014,252,135,311,067,344,167,114,044,114,003,270,336,162,052,053,353,353,353,207,076,076,077,151,267,036,036,333,223,000
          .byte 067,053,053,053,067,067,177,023,361,367,361,367,367,367,367,267,267,267,267,207,252,245,231,275,045,230,163,174,246,210,204,267,215,267,074,305,064,276,270,002,225,336,226,052,053,301,346,354,200,077,077,077,215,325,371,036,333,157,043,215
          .byte 053,053,053,163,243,353,353,361,360,361,367,257,221,221,111,111,111,111,103,076,070,135,121,165,165,165,245,204,210,216,212,223,223,221,211,246,136,350,122,115,336,272,053,053,230,340,346,245,071,071,077,207,363,363,371,325,157,043,043,215
          .byte 162,226,227,344,352,352,352,360,360,250,212,110,110,110,110,111,110,212,250,023,353,345,273,274,230,237,207,215,212,216,212,223,222,212,262,152,312,202,066,344,337,053,053,230,340,045,165,063,071,135,245,363,363,363,267,151,043,043,043,151
          .byte 272,336,344,344,352,352,352,242,074,074,074,102,107,107,152,262,327,365,366,246,014,124,124,162,227,177,215,223,222,174,226,245,204,216,216,216,254,074,353,353,053,120,275,045,045,165,041,063,200,311,355,363,363,252,105,105,043,043,043,156
          .byte 344,336,344,343,343,242,174,074,072,073,100,100,216,262,046,046,262,152,100,072,131,304,270,224,224,174,211,212,245,226,177,227,224,202,216,212,111,367,252,071,127,275,045,275,165,041,121,237,355,355,355,355,207,077,077,105,043,043,043,214
          .byte 300,335,335,232,167,131,064,064,072,072,202,320,046,046,262,042,042,042,144,312,356,232,003,160,224,240,216,216,233,205,205,174,226,177,205,214,267,215,077,200,355,045,231,041,041,165,231,045,347,355,245,142,077,077,077,105,104,214,267,367
          .byte 271,270,224,122,056,064,064,064,202,312,364,364,320,152,042,042,042,216,364,312,136,064,224,224,162,242,205,222,207,226,204,205,165,231,215,223,043,157,363,363,245,063,041,121,231,045,045,045,303,200,135,071,076,077,076,214,267,033,367,367
          .byte 233,160,003,002,056,064,131,304,356,356,356,246,100,042,042,152,262,046,210,100,202,352,226,053,273,165,245,222,216,221,212,240,227,243,252,222,267,267,215,076,071,173,230,045,340,340,274,164,127,062,067,070,076,205,252,367,367,367,367,367
          .byte 122,002,002,002,122,174,350,350,350,356,202,072,100,042,152,046,046,152,042,153,360,023,070,346,165,231,230,242,202,205,245,160,224,240,211,146,110,155,075,243,310,345,337,340,227,164,053,053,053,053,067,243,361,361,361,361,367,367,257,221
          .byte 131,051,002,114,232,342,350,350,304,202,072,072,100,210,046,326,107,107,146,367,257,075,311,245,165,231,163,224,224,230,231,227,233,174,210,262,262,327,366,360,242,162,162,053,053,053,053,163,227,243,353,352,353,361,361,367,257,221,102,221
          .byte 122,003,160,224,044,342,342,304,174,064,072,072,210,364,327,153,110,110,367,367,104,215,363,071,245,163,225,224,225,227,237,165,243,246,216,042,042,100,072,072,066,060,052,124,162,226,272,272,336,344,352,352,360,360,250,074,102,102,102,212
          .byte 242,160,270,044,342,342,276,174,064,064,072,246,357,360,212,110,111,257,033,112,043,325,215,142,361,014,240,224,233,243,200,252,214,146,262,262,326,254,246,304,304,276,044,335,335,335,335,335,344,344,352,242,014,074,074,074,102,102,110,000
          .byte 000,270,044,044,044,270,160,064,064,065,240,357,360,204,102,103,214,367,222,043,223,036,043,222,023,073,312,136,246,205,252,151,267,257,110,042,152,246,246,304,342,044,044,044,270,270,224,225,160,167,131,065,065,073,074,073,101,101,101,000
          .byte 000,343,044,044,270,160,051,057,057,242,352,352,360,075,075,103,367,333,043,043,267,267,112,257,264,042,320,100,320,102,267,267,043,222,367,264,153,072,072,064,056,002,003,003,003,003,002,051,056,064,064,064,072,072,072,072,100,144,211,000
          .byte 000,305,044,270,160,115,051,060,162,352,352,353,205,075,076,267,363,223,043,043,036,214,112,367,212,042,326,042,216,264,112,333,267,043,156,257,360,357,240,240,114,003,003,003,003,003,003,003,122,122,131,174,174,202,246,246,312,320,327,000
          .byte 000,352,270,225,115,052,052,162,344,344,345,243,067,067,207,363,325,151,105,223,036,156,111,264,216,042,326,152,042,366,111,043,333,267,105,076,205,243,352,344,044,342,044,270,270,270,270,270,276,304,304,304,356,356,356,356,364,364,000,000
          .byte 000,000,233,115,052,052,162,226,345,345,301,067,070,071,311,363,252,077,105,267,325,111,111,374,216,042,262,262,042,264,367,112,151,325,363,207,070,067,053,226,271,335,044,044,044,044,044,044,342,350,350,350,356,356,356,356,364,364,000,000
          .byte 000,000,014,052,052,052,226,337,337,301,227,070,071,200,355,355,207,077,142,363,367,103,102,365,210,042,262,320,042,110,367,267,077,077,363,355,245,177,053,053,052,124,162,225,224,270,270,270,304,350,304,304,312,312,312,246,210,250,000,000
          .byte 000,000,000,052,052,162,337,337,337,273,120,063,127,245,355,355,142,071,207,363,023,075,102,365,254,100,144,364,210,074,205,361,207,077,071,245,355,346,273,163,053,052,052,052,051,002,003,122,122,131,174,131,136,072,072,100,100,000,000,000
          .byte 000,000,000,163,052,273,337,337,340,230,062,041,165,347,355,311,135,070,245,353,023,067,074,356,312,072,072,356,312,074,074,310,363,245,071,071,237,045,340,340,273,227,162,124,052,052,051,057,064,064,072,072,072,072,072,100,211,000,000,000
          .byte 000,000,000,000,227,301,337,337,230,165,041,121,231,347,347,237,071,071,310,353,243,066,066,356,356,136,072,246,356,014,066,177,354,355,237,063,041,165,231,340,340,337,337,272,272,226,162,131,131,065,064,072,072,072,100,100,000,000,000,000
          .byte 000,000,000,000,353,337,340,340,231,121,041,165,275,045,347,165,063,135,303,353,243,066,065,304,350,174,064,174,350,305,066,067,163,355,347,231,121,041,041,165,274,337,337,337,337,344,344,300,352,240,240,202,202,136,144,204,000,000,000,000
          .byte 000,000,000,000,000,346,340,274,165,041,041,165,045,045,045,165,041,120,345,345,243,060,131,276,350,240,064,122,304,344,226,053,053,230,045,045,275,165,041,041,121,164,230,273,337,344,352,352,352,305,305,357,312,312,250,000,000,000,000,000
          .byte 000,000,000,000,000,000,340,231,121,041,121,231,045,045,231,121,041,164,337,345,226,060,057,232,342,276,122,056,232,343,344,163,053,120,230,045,045,045,231,121,041,041,120,120,227,301,353,353,352,352,360,360,357,357,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,310,165,041,041,165,275,045,045,231,121,054,163,337,337,272,052,051,224,044,044,160,002,114,271,336,272,163,053,120,231,045,045,045,274,165,121,041,063,062,067,067,177,242,361,360,360,360,361,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,200,041,041,165,275,045,045,231,121,054,164,337,337,272,115,002,160,044,044,224,002,002,225,336,336,227,053,054,120,231,045,045,045,045,231,165,063,063,070,067,067,067,075,074,204,023,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,173,041,231,045,045,045,231,054,053,163,337,336,272,115,051,114,270,044,270,114,002,114,300,336,337,227,053,054,041,231,045,045,045,045,303,237,135,070,070,067,075,075,075,075,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,173,231,045,045,045,165,054,053,163,337,336,272,167,002,003,270,044,044,224,002,051,162,336,336,337,230,120,041,041,165,275,347,347,347,355,311,245,200,075,075,075,205,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,311,045,045,045,165,053,053,163,336,336,336,162,002,003,224,044,044,224,003,051,115,226,336,337,337,230,120,041,041,173,237,347,355,355,355,355,311,252,207,207,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,311,045,274,164,053,053,163,272,336,335,160,002,002,160,044,044,044,224,002,051,162,272,337,337,273,165,120,063,063,127,200,311,355,355,355,363,363,252,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,303,164,053,053,163,336,336,336,225,003,002,114,270,044,044,224,003,051,052,162,337,337,337,345,164,127,063,071,071,135,245,311,363,363,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,200,053,053,162,272,336,336,224,003,002,003,224,044,044,044,224,051,052,124,226,345,345,345,346,245,071,071,071,071,071,207,363,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,053,163,300,336,335,271,114,002,002,160,270,044,044,224,114,057,052,124,227,353,345,354,354,245,135,071,135,142,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,353,336,335,271,160,002,002,003,224,044,044,342,233,057,060,066,124,353,353,353,354,310,245,207,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,352,233,122,056,002,160,350,342,342,304,167,060,066,067,177,243,353,310,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,014,174,305,304,304,305,242,204,014,014,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .even

          ;  6464px
backgrnd: .byte 370,043,143,143,143,143,143,143,143,143,143,143,143,143,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,151,071,041,053,053,041,071,151,143,143,143,143,143,143,143,143,151,071,041,053
          .byte 043,135,143,143,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,376,052,041,071,151,143,143,143,143,143,143,151,071,041,052,376
          .byte 143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,043,043,376,052,041,071,151,143,143,143,143,151,071,041,052,376,043
          .byte 143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,043,135,135,043,376,052,041,071,151,143,143,151,071,041,052,376,043,135
          .byte 143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,043,135,143,143,135,043,376,052,041,071,151,151,071,041,052,376,043,135,143
          .byte 143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,043,135,143,143,143,143,135,043,376,052,041,071,071,041,052,376,043,135,143,143
          .byte 143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,043,135,143,143,143,143,143,143,135,043,376,052,041,041,052,376,043,135,143,143,143
          .byte 143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,043,135,143,143,143,143,143,143,143,143,135,043,376,052,052,376,043,143,143,143,143,143
          .byte 143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,071,041,052,052,041,071,151,143,143,143,143,143,143,143,143,151,071,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,143,143,143,143,143
          .byte 143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,376,052,041,071,151,143,143,143,143,143,143,151,071,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,151,143,143,143
          .byte 143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,043,043,376,052,041,071,151,143,143,143,143,151,071,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,151,143,143
          .byte 143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,043,135,135,043,376,052,041,071,151,143,143,151,071,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,151,143
          .byte 143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,043,135,143,143,135,043,376,052,041,071,151,151,071,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,151
          .byte 143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,043,135,143,143,143,143,135,043,376,052,041,071,071,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071
          .byte 071,151,143,143,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,043,135,143,143,143,143,143,143,135,043,376,052,041,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041
          .byte 041,071,151,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,043,135,143,143,143,143,143,143,143,143,135,043,376,052,052,376,043,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,043,376,053
          .byte 052,041,071,151,143,143,143,143,143,143,143,143,151,071,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,071,041,053
          .byte 376,052,041,071,151,143,143,143,143,143,143,151,071,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376
          .byte 043,376,052,041,071,151,143,143,143,143,151,071,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,043
          .byte 135,043,376,052,041,071,151,143,143,151,071,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,043,135
          .byte 143,135,043,376,052,041,071,151,151,071,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,043,135,143
          .byte 143,143,135,043,376,052,041,071,071,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,043,135,143,143
          .byte 143,143,143,135,043,376,052,041,063,052,376,043,135,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,043,135,143,143,143
          .byte 143,143,143,143,135,043,376,052,053,052,043,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,043,135,143,143,143,143
          .byte 143,143,143,143,143,135,043,376,052,041,071,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,071,041,052,052,041,071,151,143,143,143,143,143,143,143,143,151,071,041,052,376,043,135,143,143,143,143,143
          .byte 143,143,143,143,143,143,135,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,376,052,041,071,151,143,143,143,143,143,143,151,071,041,052,376,043,135,143,143,143,143,143,143
          .byte 143,143,143,143,143,143,143,135,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,043,043,376,052,041,071,151,143,143,143,143,151,071,041,052,376,043,135,143,143,143,143,143,143,143
          .byte 143,143,143,143,143,143,143,143,135,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,043,135,135,043,376,052,041,071,151,143,143,151,071,041,052,376,043,135,143,143,143,143,143,143,143,143
          .byte 143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,043,135,143,143,135,043,376,052,041,071,151,151,071,041,052,376,043,135,143,143,143,143,143,143,143,143,143
          .byte 143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,043,135,143,143,143,143,135,043,376,052,041,071,071,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143
          .byte 143,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,043,135,143,143,143,143,143,143,135,043,376,052,041,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,143
          .byte 143,143,143,143,143,143,143,143,143,143,143,143,143,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,043,135,143,143,143,143,143,143,143,143,135,043,376,052,052,376,043,143,143,143,143,143,143,143,143,143,143,143,143,143
          .byte 143,143,143,143,143,143,143,143,143,143,143,143,143,071,041,052,052,041,071,151,143,143,143,143,143,143,143,143,151,071,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,143,143,143,143,143,143,143,143,143,143,143,143,143
          .byte 143,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,376,052,041,071,151,143,143,143,143,143,143,151,071,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,143
          .byte 143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,043,043,376,052,041,071,151,143,143,143,143,151,071,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143
          .byte 143,143,143,143,143,143,143,143,143,151,071,041,052,376,043,135,135,043,376,052,041,071,151,143,143,151,071,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143
          .byte 143,143,143,143,143,143,143,143,151,071,041,052,376,043,135,143,143,135,043,376,052,041,071,151,151,071,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,151,143,143,143,143,143,143,143,143
          .byte 143,143,143,143,143,143,143,151,071,041,052,376,043,135,143,143,143,143,135,043,376,052,041,071,071,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,151,143,143,143,143,143,143,143
          .byte 143,143,143,143,143,143,151,071,041,052,376,043,135,143,143,143,143,143,143,135,043,376,052,041,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,151,143,143,143,143,143,143
          .byte 143,143,143,143,143,151,071,041,052,376,043,135,143,143,143,143,143,143,143,143,135,043,376,052,052,376,043,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,043,376,052,041,071,151,143,143,143,143,143
          .byte 143,143,143,143,151,071,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,071,041,052,052,041,071,151,143,143,143,143
          .byte 143,143,143,151,071,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,376,052,041,071,151,143,143,143
          .byte 143,143,151,071,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,043,043,376,052,041,071,151,143,143
          .byte 143,151,071,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,043,135,135,043,376,052,041,071,151,143
          .byte 151,071,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,043,135,143,143,135,043,376,052,041,071,151
          .byte 071,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,043,135,143,143,143,143,135,043,376,052,041,071
          .byte 041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,043,135,143,143,143,143,143,143,135,043,376,052,041
          .byte 041,376,043,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,043,043,052,041,071,151,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,043,135,143,143,143,143,143,143,143,143,135,043,376,052
          .byte 052,041,071,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,071,041,052,052,041,071,151,143,143,143,143,143,143,143,143,151,071,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,135,043,376
          .byte 376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,376,052,041,071,151,143,143,143,143,143,143,151,071,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,143,143,135,043
          .byte 043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,043,043,376,052,041,071,151,143,143,143,143,151,071,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143
          .byte 135,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,043,135,135,043,376,052,041,071,151,143,143,151,071,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143
          .byte 143,135,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,043,135,143,143,135,043,376,052,041,071,151,151,071,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143
          .byte 143,143,135,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,043,135,143,143,143,143,135,043,376,052,041,071,071,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143
          .byte 143,143,143,135,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,043,135,143,143,143,143,143,143,135,043,376,052,041,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143
          .byte 143,143,143,143,143,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,151,071,041,052,376,043,135,143,143,143,143,143,143,143,143,135,043,376,052,052,376,043,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143
          .byte 143,143,143,143,143,071,041,052,052,041,071,151,143,143,143,143,143,143,143,143,151,071,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143
          .byte 143,143,143,151,071,041,052,376,376,052,041,071,151,143,143,143,143,143,143,151,071,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143
          .byte 143,143,151,071,041,052,376,043,043,376,052,041,071,151,143,143,143,143,151,071,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143
          .byte 143,151,071,041,052,376,043,135,135,043,376,052,041,071,151,143,143,151,071,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143
          .byte 151,071,041,052,376,043,135,143,143,135,043,376,052,041,071,151,151,071,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143
          .byte 071,041,052,376,043,135,143,143,143,143,135,043,376,052,041,071,071,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143
          .byte 041,052,376,043,135,143,143,143,143,143,143,135,043,376,052,041,041,052,376,043,135,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,151,143,143,143,143,143,143,143,143,143,143,143,143,151,071
          .byte 053,376,043,135,143,143,143,143,143,143,143,143,135,043,376,053,053,376,043,135,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,143,135,043,376,052,041,071,143,143,143,143,143,143,143,143,143,143,143,143,071,041
          .even

                .END


