
; Processor:        1801VM1
; Target assembler: BK Turbo8 Cross Assembler
; Файл: ADRES

.include "inc/dx_fcb.asm"
.include "inc/dx_sys.asm"

START:          mov     #START, SP
                iot
                .word   60              ; Получить версию DOS.
                                        ; выход: R0-версия:
                                        ;       ст.байт номер версии, мл.байт номер подверсии.
                cmp     #DOSVER, R0
                beq     1$
                .addr   R1, DOSERR
                br      1EX$

1$:             .addr   R1, TITLE
                iot
                .word   11              ; Вывод строки символов на устройство вывода
                                        ; (по умолчанию - консоль).
                                        ; вход: R1-адрес строки символов.
                                        ; (Строка должна оканчиваться нулевым байтом)
                call    SKIPWS
                cmpb    (R3), #'/
                bne     2$
                inc     R3
                call    SKIPWS
                cmpb    (R3), #'?
                bne     2$
                .addr   R1, HLPTXT
                br      1EX$

2$:             .addr   R4, FCBBUF
                mov     R3, R1
                iot
                .word   51              ; Произвести синтаксический разбор строки.
                                        ; вход: R1-адрес обрабатываемой строки.
                                        ;      R4-адрес формируемого FCB-блока.
                                        ;      R2-тип разбора:если 0,то обычный разбор.
                                        ;         если не 0,то если встретится первым код 0,
                                        ;         FCB  примет вид:_???????????
                                        ; выход: R2-количество символов '?'.
                mov     R1, R3
                bcc     3$
                .addr   R1, BADFIL
1EX$:           iot
                .word   11              ; Вывод строки символов на устройство вывода
                                        ; (по умолчанию - консоль).
                                        ; вход: R1-адрес строки символов.
                                        ; (Строка должна оканчиваться нулевым байтом)
                iot
                .word   0               ; Завершение программы пользователя.

3$:             iot
                .word   17              ; Открыть файл методом FCB.
                                        ; вход: R4-адрес FCB.
                bcc     4$
                .addr   R1, FILENF
                br      1EX$

4$:             call    SKIPWS
                .addr   R1, LODADR
                iot
                .word   11              ; Вывод строки символов на устройство вывода
                                        ; (по умолчанию - консоль).
                                        ; вход: R1-адрес строки символов.
                                        ; (Строка должна оканчиваться нулевым байтом)
                mov     F$FLLD(R4), R1
                call    OUT8
                tstb    (R3)
                beq     5$
                clr     R5
6$:             movb    (R3)+, R0
                tstb    R0
                beq     7$
                cmpb    R0, #'0
                blo     8$
                cmpb    #'7, R0
                blo     8$
                asl     R5
                asl     R5
                asl     R5
                sub     #'0, R0
                add     R0, R5
                br      6$

7$:             mov     R5, F$FLLD(R4)
                .addr   R1, NWLADR
                iot
                .word   11              ; Вывод строки символов на устройство вывода
                                        ; (по умолчанию - консоль).
                                        ; вход: R1-адрес строки символов.
                                        ; (Строка должна оканчиваться нулевым байтом)
                mov     R5, R1
                call    OUT8
                incb    F$FWRT(R4)
5$:             iot
                .word   20              ; Закрыть файл.
                                        ; вход: R4-адрес FCB.
                iot
                .word   0               ; Завершение программы пользователя.

8$:             .addr   R1, SNTERR
                iot
                .word   11              ; Вывод строки символов на устройство вывода
                                        ;(по умолчанию - консоль).
                                        ; вход: R1-адрес строки символов.
                                        ;(Строка должна оканчиваться нулевым байтом)
                br      5$

; ███████████████ S U B R O U T I N E ███████████████████████████████████████


OUT8:           mov     #6, R2
                clr     R0
1$:             rol     R1
                rol     R0
                add     #'0, R0
                iot
                .word   2               ; Вывод символа на стандартное устройство вывода
                                        ;(по умолчанию - консоль).
                                        ; вход: R0-код символа.
                dec     R2
                beq     CRLFOU
                clr     R0
                rol     R1
                rol     R0
                rol     R1
                rol     R0
                br      1$

CRLFOU:         mov     #5015, R0
                iot
                .word   2               ; Вывод символа на стандартное устройство вывода
                                        ;(по умолчанию - консоль).
                                        ; вход: R0-код символа.
                swab    R0
                iot
                .word   2               ; Вывод символа на стандартное устройство вывода
                                        ;(по умолчанию - консоль).
                                        ; вход: R0-код символа.
                return

; ███████████████ S U B R O U T I N E ███████████████████████████████████████


SKIPWS:         cmpb    (R3), #40
                bne     1$
                inc     R3
                br      SKIPWS

1$:             ccc
                return
; End of function SKIPWS

; ───────────────────────────────────────────────────────────────────────────
FCBBUF:         .blkb   FCB$SZ+2
FILENF:         .asciz "File not found"<12><15>
                .even
BADFIL:         .asciz "Bad file name"<12><15>
SNTERR:         .asciz "Syntax error"<12><15>
                .even
LODADR:         .asciz "Адрес загрузки файла: "
                .even
NWLADR:         .asciz "Новый адрес загрузки: "
                .even
TITLE:          .asciz <12><15>"Address version 1.00"<12><15><12><15>
DOSERR:         .asciz "Incorrect DOS version"<12><15><12><15>
HLPTXT:         .ascii " ADRES - просмотр/изменение"<12><15>
                .ascii "адреса загрузки файла в память"<12><15><12><15>
                .ascii "вызов для просмотра адреса :"<12><15>
                .ascii "   ADRES ИМЯ ФАЙЛА"<12><15><12><15>
                .ascii "вызов для изменения адреса :"<12><15>
                .ascii "   ADRES ИМЯ ФАЙЛА новый адрес"<12><15><12><15>
                .ascii "вызов этой инструкции:"<12><15>
                .asciz "   ADRES /?"
                .even


                .END

