; Processor:        1801VM1
; Target assembler: BK Turbo8 Cross Assembler
; Файл: BK_IBM

.include "inc/dx_fcb.asm"
.include "inc/dx_sys.asm"
.include "inc/dx_cmd.asm"
.include "inc/dx_wrkbuf.asm"

START:          mov     #START, SP
                mov     #6, R1
                mov     R3, -(SP)
                call    OUTSTN
                .addr   R3, WRKBUF
                mov     (SP)+, W$CMDA(R3)   ; адрес начала аргументов командной строки
                iot
                .word   61                  ; Доступ к внутрисистемной информации.
                                            ; выход: R1-адрес области DOS.
                .addr   R0, EOF
                mov     R0, (R3)            ; начало свободного ОЗУ, адрес буфера источника
                mov     S$HRAM(R1), R2      ; верхний адрес пользовательского ОЗУ.
                sub     R0, R2              ; размер доступного ОЗУ
                asr     R2                  ; половина для источника и половина для приёмника
                mov     R2, W$BUFS(R3)      ; сохраним тут размер буфера источника и приёмника
                add     R2, R0              ; начало ОЗУ для приёмника
                mov     R0, W$BFDA(R3)      ; сохраним  тут, это начало буфера приёмника
                mov     R0, W$PDBF(R3)      ; и тут, а это указатель в буфере приёмника
                .addr   R4, FCBSRC
                mov     W$CMDA(R3), R1      ; обрабатываем командную строку
                call    SKIPWS
                clr     R2
                iot
                .word   51                  ; Произвести синтаксический разбор строки.
                                            ; вход: R1-адрес обрабатываемой строки.
                                            ;      R4-адрес формируемого FCB-блока.
                                            ;      R2-тип разбора:если 0,то обычный разбор.
                                            ;         если не 0,то если встретится первым код 0,
                                            ;         FCB  примет вид:_???????????
                                            ; выход: R2-количество символов '?'.
                bcs     1EX$
                mov     R4, W$SFCB(R3)      ; адрес FCB файла источника
                mov     R4, R5              ;!!! бессмысленная команда
                .addr   R4, FCBDST
                call    SKIPWS
                clr     R2
                iot
                .word   51                  ; Произвести синтаксический разбор строки.
                                            ; вход: R1-адрес обрабатываемой строки.
                                            ;      R4-адрес формируемого FCB-блока.
                                            ;      R2-тип разбора:если 0,то обычный разбор.
                                            ;         если не 0,то если встретится первым код 0,
                                            ;         FCB  примет вид:_???????????
                                            ; выход: R2-количество символов '?'.
                bcs     1EX$
                mov     R4, W$DFCB(R3)      ; адрес FCB файла приёмника
                mov     R4, R1
                mov     W$SFCB(R3), R0      ;!!! если R5 не портится, то та команда не бессмысленна, зато эту можно оптимизировать
                mov     #14, R2
4$:             cmpb    (R0)+, (R1)+        ; проверим, не совпадает ли источник с приёмником
                bne     1$
                sob     R2, 4$
                mov     #4, R1              ; если да, то дальше продолжать невозможно.
                call    OUTSTN
                iot
                .word   0                   ; Завершение программы пользователя.

1$:             mov     W$SFCB(R3), R4      ; адрес FCB файла источника
                mov     R4, R5              ;!!! эта
                iot
                .word   17                  ; Открыть файл методом FCB.
                bcs     1EX$
                mov     R4, R5              ;!!! или эта команда не нужна
                mov     W$DFCB(R3), R4      ; адрес FCB файла приёмника
                iot
                .word   26                  ; Создать файл.
                bcs     1EX$
                mov     F$FLSZ(R5), W$FILS(R3)  ; размер файла в байтах. мл
                mov     F$FLSZ+2(R5), W$FILS+2(R3)  ; размер файла в байтах. ст
3$:             mov     #1, F$RCSZ(R4)      ; размер записи в байтах. для приёмника
                mov     #1, F$RCSZ(R5)      ; размер записи в байтах. для источника
                mov     (R3), F$DTAD(R5)    ; адрес обмена
                mov     W$BUFS(R3), R0      ; размер буфера для источника
                tst     W$FILS+2(R3)        ; размер больше 64кб?
                bne     2$                  ; да - буфер заведомо меньше остатка размера файла
                cmp     R0, W$FILS(R3)      ; буфер меньше остатка размера файла?
                blos    2$                  ; да
                mov     W$FILS(R3), R0      ; нет, берём столько, сколько надо
                beq     1END$               ; если ничего не осталось - то выход
2$:             mov     R4, -(SP)
                mov     R5, R4
                iot
                .word   47                  ; Считать несколько записей.
                bcs     1END$
                mov     (SP)+, R4
                bcs     1END$
                iot
                .word   15                  ; Инициализировать драйвер (контроллер) дисковода.
                sub     R0, W$FILS(R3)      ; вычтем прочитанное из размера.
                sbc     W$FILS+2(R3)
                mov     R0, W$SDBS(R3)
                clr     W$BCSB(R3)
                call    WORK
                bcs     1EX$
                br      3$

1EX$:           movb    @#52, R0            ; номер ошибки
                .addr   R1, CTCHER          ; адрес массива
11$:            tstb    (R1)                ; массив кончился?
                beq     1END$               ; да
                cmpb    R0, (R1)            ; номер ошибки тот, что нам нужен?
                beq     12$                 ; да
                tst     (R1)+               ; двигаемся дальше по массиву
                br      11$

12$:            movb    1(R1), R1           ; берём номер сообщения, которое надо вывести
                call    OUTSTN
1END$:          call    FLUSHD
                mov     W$DFCB(R3), R4
                iot
                .word   20                  ; Закрыть файл. приёмник
                mov     W$SFCB(R3), R4
                iot
                .word   20                  ; Закрыть файл. источник
                iot
                .word   15                  ; Инициализировать драйвер (контроллер) дисковода.
                iot
                .word   0                   ; Завершение программы пользователя.

WORK:           mov     W$PDBF(R3), R2      ; указатель в буфере приёмника
                mov     (R3), W$PSBF(R3)    ; указатель в буфере источника
4$:             movb    @W$PSBF(R3), R0     ; берём очередной символ
                inc     W$PSBF(R3)
                inc     W$BCSB(R3)
                cmp     W$BCSB(R3), W$SDBS(R3)
                blos    1$
2$:             return

1$:             cmpb    #32, R0             ; если это ^Z, то делаем что-то непонятное
                ;beq     L1756
                beq     2$                  ; то выходим
                tstb    R0                  ; если это 0
                bne     3$
9$:             movb    #15, R0             ; то это ибмский перевод строки
                iot
                .word   2
                call    FPUTCH
                bcs     2$
                movb    #12, R0
                iot
                .word   2
                call    FPUTCH
                bcs     2$
                br      4$

3$:             cmpb    R0, #11             ; если это таб
                bhi     5$
                tst     W$FTBF(R3)          ; это первый таб в строке?
                beq     6$                  ; да
                asl     R0                  ; иначе умножим его на 8
                asl     R0                  ; не очень понятна логика
                asl     R0
6$:             mov     R5, -(SP)
                movb    R0, R5
                inc     W$FTBF(R3)
7$:             movb    #40, R0
                iot
                .word   2
                call    FPUTCH
                bcs     8$                  ; при ошибке прервём цикл
                sob     R5, 7$
8$:             mov     (SP)+, R5
                bcs     2$
                br      4$

5$:             cmpb    #12, R0             ; если это перевод строки
                beq     9$
                iot
                .word   2
                mov     R5, -(SP)
                cmpb    #177, R0
                bhis    10$
                .addr   R5, XLTTBL          ;!!! решать такую задачу методом перебора, не самое умное решение
                                            ; можно оптимизировать, брать содержимое массива по индексу
13$:            tstb    (R5)                ; таблица кончилась?
                beq     10$                 ; да
                cmpb    R0, (R5)            ; нужный символ?
                beq     12$                 ; да, пойдём перекодируем
                tst     (R5)+               ; нет - подвинемся дальше по таблице
                br      13$

12$:            movb    1(R5), R0           ; возьмём ибмский символ
10$:            call    FPUTCH
                bcs     11$
                clr     W$FTBF(R3)          ; сбрасываем счётчик табов
11$:            mov     (SP)+, R5
                bcs     2$
                br      4$
; ───────────────────────────────────────────────────────────────────────────
; вывод строки из массива строк.
; вход:  R1 - номер строки
OUTSTN:         .addr   R2, FILENF
L1752:          dec     R1
                ble     1$
L1756:          tstb    (R2)+
                bne     L1756
                br      L1752

1$:             mov     R2, R1
                iot
                .word   11
                sec
                return

; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; пропуск пробелов

SKIPWS:         cmpb    (R1), #40
                bhi     1$
                tstb    (R1)+
                bne     SKIPWS
1$:             return
; End of function SKIPWS

; ───────────────────────────────────────────────────────────────────────────
; заполняем буфер, и по мере заполнения скидываем его на диск
FPUTCH:         movb    R0, (R2)+
                mov     R2, W$PDBF(R3)
                inc     W$BCDB(R3)          ; увеличиваем счётчик байтов
                cmp     W$BUFS(R3), W$BCDB(R3)  ; пока не достигнем конца буфера
                bhis    1RET$               ; если не достигли - выйдем, иначе запишем буфер

FLUSHD:         mov     W$BFDA(R3), F$DTAD(R4)  ; адрес буфера приёмника
                mov     W$BCDB(R3), R0      ; сколько байтов в буфере
                beq     1RET$               ; если нисколько, то и делать нечего
                clr     W$BCDB(R3)          ; сбросим счётчик байтов
                iot
                .word   50                  ; Записать несколько записей.
                bcs     1RET$
                iot
                .word   15                  ; Инициализировать драйвер (контроллер) дисковода.
                mov     W$BFDA(R3), R2      ; адрес буфера приёмника
                mov     R2, W$PDBF(R3)      ; указатель на начало буфера
                mov     W$BUFS(R3), R1      ; размер буфера
1RET$:          return
; ───────────────────────────────────────────────────────────────────────────
; таблица БКшный символ, ИБМский символ
XLTTBL:         .byte  340, 236
                .byte  341, 200
                .byte  342, 201
                .byte  343, 226
                .byte  344, 204
                .byte  345, 205
                .byte  346, 224
                .byte  347, 203
                .byte  350, 225
                .byte  351, 210
                .byte  352, 211
                .byte  353, 212
                .byte  354, 213
                .byte  355, 214
                .byte  356, 215
                .byte  357, 216
                .byte  360, 217
                .byte  361, 237
                .byte  362, 220
                .byte  363, 221
                .byte  364, 222
                .byte  365, 223
                .byte  366, 206
                .byte  367, 202
                .byte  370, 234
                .byte  371, 233
                .byte  372, 207
                .byte  373, 230
                .byte  374, 235
                .byte  375, 231
                .byte  376, 227
                .byte  377, 232

                .byte  300, 356
                .byte  301, 240
                .byte  302, 241
                .byte  303, 346
                .byte  304, 244
                .byte  305, 245
                .byte  306, 344
                .byte  307, 243
                .byte  310, 345
                .byte  311, 250
                .byte  312, 251
                .byte  313, 252
                .byte  314, 253
                .byte  315, 254
                .byte  316, 255
                .byte  317, 256
                .byte  320, 257
                .byte  321, 357
                .byte  322, 340
                .byte  323, 341
                .byte  324, 342
                .byte  325, 343
                .byte  326, 246
                .byte  327, 242
                .byte  330, 354
                .byte  331, 353
                .byte  332, 247
                .byte  333, 350
                .byte  334, 355
                .byte  335, 351
                .byte  336, 347
                .byte  337, 352

                .byte  241, 301
                .byte  243, 277
                .byte  244, 265
                .byte  245, 303
                .byte  246, 300
                .byte  247, 315
                .byte  250, 321
                .byte  252, 332
                .byte  253, 302
                .byte  254, 320
                .byte  255, 371
                .byte  256, 305
                .byte  257, 272
                .byte  260, 264
                .byte  261, 367
                .byte  262, 316
                .byte  263, 370
                .byte  265, 304
                .byte  266, 327
                .byte  267, 263
                .byte  271, 331
                .byte  272, 330
                .byte  273, 322
                .byte  274, 317
                .byte  275, 306
                .byte  276, 366
                .byte  277, 333
                .byte    0,   0

CTCHER:         .byte 25, 1
                .byte 24, 5
                .byte 22, 5
                .byte 35, 2
                .byte 30, 3
                .byte 21, 7
                .byte 0
                .even
WRKBUF:         .blkb CMDLSZ

FCBSRC:         .blkb FCB$SZ+2

FCBDST:         .blkb FCB$SZ+2

FILENF:         .asciz "File not found"<12><15>                 ; 1
                .asciz "Missing operand"<12><15>                ; 2
                .asciz "Bad file name"<12><15>                  ; 3
                .asciz "Content of destination lost before copy"<12><15>    ; 4
                .asciz "Disk full"<12><15>                      ; 5
                .asciz <12><15>"    BK_IBM  version 1.00"<12><15><12><15>   ; 6
                .asciz "Invalid drive specification"<12><15>    ; 7
                .even
EOF:            .word   0

                .END

