
; Processor:        1801VM1
; Target assembler: BK Turbo8 Cross Assembler
; Файл: COPYM

.include "inc/dx_fcb.asm"
.include "inc/dx_sys.asm"
.include "inc/dx_fat.asm"

KBLEN=100
START:          mov     #START, SP
                movb    R0, FCBCPH
                mov     @#4, OLDV4
                mov     #220, KSTOP
                mov     #120, KBIT11
                mov     #20, KPUSK
                mov     #60, KBIT10
                mov     #160, KBIT01
                iot
                .word   61                  ; Доступ к внутрисистемной информации.
                                            ; выход: R1-адрес области DOS.
                cmpb    #2, S$BRDT(R1)      ; тип машины 0-БК0010, 1-БК0011М, 2-БК0011.
                bne     1$                  ; не БК0011
                mov     @#66, R0            ; а если БК0011, надо поправить константы драйвера магнитофона
                bis     R0, KBIT11
                bis     R0, KBIT01
                bis     R0, KBIT10
                bis     R0, KSTOP
                bis     R0, KPUSK
1$:             cmpb    #1, S$MONT(R1)      ; тип монитора 0-БК0010, 1-БК0011М, 2-БК0011.
                bne     V4$3
                mov     #104000, EMTCLS     ; для БК11М - правим EMT

V4$3:           .addr   R1, V4$3
                mov     R1, @#4
                mov     #13, R1             ; title
                call    OUTERS              ; вывод сообщений из массива
                                            ; Вход: R1 - индекс в массиве
1$:             call    OutPrompt
                mov     #1, Repeats$
                .addr   R1, KEYBUF
                mov     #KBLEN, R2
                iot
                .word   6                   ; Буферизованный ввод с клавиатуры с возможностью редактирования.
                                            ; вход: R1-адрес буфера,
                                            ;       R2-размер буфера в байтах.
                bcs     EMTCLS
                mov     R1, R5              ; адрес буфера
2$:             tstb    (R5)                ; есть что-нибудь?
                beq     4$                  ; нету - конец введённого
                bitb    #200, (R5)          ; буквы русские?
                bne     3$                  ; да
                cmpb    #100, (R5)          ; нет - латинские?
                bhi     3$                  ; нет
                bicb    #40, (R5)           ; да - сделаем большими
3$:             inc     R5                  ; дальше по буферу
                br      2$

4$:             cmpb    (R1), #40           ; первый символ - не символ?
                blos    1$                  ; да - попросим заново ввести что-нибудь

                mov     R1, R2              ; адрес буфера
                .addr   R1, CMDTBL
                call    CMDNUM              ; получение по имени команды её номер
                                            ; Вход: R1 - адрес списка команд
                                            ;       R2 - адрес буфера текста
                                            ; Выход: C = 1 - не нашли такую команду в списке
                                            ;       С = 0 - нашли, тогда R0 == номер * 2, R5 - указатель на текст за командой
                bcs     5$                  ; не нашли такой команды
                mov     R5, R1              ; указатель на текст за командой
                .addr   R5, CMDSUB
                add     R0, R5              ; индекс в таблице
                add     (R5), R5            ; получаем адрес п/п
                call    (R5)                ; выполняем
                br      1$

5$:             mov     #2, R1              ; Неверная команда
                call    OUTERS              ; вывод сообщений из массива
                                            ; Вход: R1 - индекс в массиве
                br      1$
; ═══════════════════════════════════════════════════════════════════════════
; обработка команды EXIT
CMDEXI:
EMTCLS:         emt     14
                mov     OLDV4, @#4
                iot
                .word   0
; ═══════════════════════════════════════════════════════════════════════════
; обработка команды COPY
; Вход: R1 - указатель на параметры за командой
;       R2 - указатель на имя команды
CMDCPY:         call    SKIPWS              ; Пропуск пробельных символов
                                            ; Вход: R1 - указатель в буфере текста
                .addr   R4, FCBFIL
                inc     R2
                iot
                .word   51                  ; Произвести синтаксический разбор строки.
                                            ; вход: R1-адрес обрабатываемой строки.
                                            ;       R4-адрес формируемого FCB-блока.
                                            ;       R2-тип разбора:если 0,то обычный разбор.
                                            ;          если не 0,то если встретится первым код 0,
                                            ;          FCB  примет вид:_???????????
                                            ; выход: R2-количество символов '?'.
                bcs     17$
                .addr   R5, FCBTMP
                call    SKIPWS              ; Пропуск пробельных символов
                                            ; Вход: R1 - указатель в буфере текста
                tstb    (R1)                ; хоть что-то есть?
                beq     1$                  ; ничего нету
                cmpb    (R1), #'/           ; а может ключ есть?
                bne     2$                  ; нету
1$:             jmp     PutToTape$          ; есть

2$:             .addr   R0, EOF             ; тут будет буфер
                mov     R0, BUFSTA          ; сохраним его
                mov     R5, -(SP)           ; FCBTMP
                mov     R4, -(SP)           ; FCBFIL
                mov     R5, R4
                call    SKIPWS              ; Пропуск пробельных символов
                                            ; Вход: R1 - указатель в буфере текста
                mov     R1, R0              ; это указатель в буфере на второй параметр - имя диска
                .addr   R1, TMPFIL
                movb    (R0)+, (R1)         ; вот, скопируем имя диска туда
                movb    (R0)+, 1(R1)        ; а что будет, если там его нету?
                iot
                .word   51                  ; Произвести синтаксический разбор строки.
                                            ; вход: R1-адрес обрабатываемой строки.
                                            ;       R4-адрес формируемого FCB-блока.
                                            ;       R2-тип разбора:если 0,то обычный разбор.
                                            ;          если не 0,то если встретится первым код 0,
                                            ;          FCB  примет вид:_???????????
                                            ; выход: R2-количество символов '?'.
                mov     (SP)+, R5           ; FCBFIL
                bcs     3$
                inc     R5                  ; имя файла в FCBFIL
                mov     #20, R2
                .addr   R1, IMMAS
                mov     R1, R0
4$:             movb    #40, (R0)+          ; сперва заполним пробелами
                sob     R2, 4$
                mov     #13, R2
5$:             movb    (R5)+, R0           ; затем из FCB скопируем
                cmpb    #40, R0             ; игнорируя пробелы
                beq     6$
                movb    R0, (R1)+           ; только это неправильно там надо расширение формировать
6$:             sob     R2, 5$

7$:             movb    #3, TAPCMD          ; команда "чтение"
                call    TapeIO
                mov     (SP)+, R4           ; FCBTMP
                mov     PROH, R0            ; как прочиталось?
                beq     8$                  ; отлично
                cmpb    R0, #4              ; нажали СТОП?
                bne     9$                  ; нет
10$:            return                      ; да - просто выход

9$:             cmpb    #2, R0              ; ошибка КС?
                bne     11$                 ; нет
                mov     #3, R1              ; Ошибка КС
                call    OUTERS              ; вывод сообщений из массива
                                            ; Вход: R1 - индекс в массиве
                br      10$                 ;  и тоже выход

11$:            mov     #7, R1              ; Файл
                call    OUTERS              ; вывод сообщений из массива
                                            ; Вход: R1 - индекс в массиве
                mov     #16, R1             ; найден 
                call    OUTERS              ; вывод сообщений из массива
                                            ; Вход: R1 - индекс в массиве
                mov     ABP, R1
                add     #32, R1             ; и выведем имя найденного файла
                iot
                .word   11                  ; Вывод строки символов на устройство вывода
                                            ; (по умолчанию - консоль).
                                            ; вход: R1-адрес строки символов.
                                            ; (Строка должна оканчиваться нулевым байтом)
                call    OUCRLF              ; перевод строки
                mov     R4, -(SP)
                br      7$                  ; и повторим чтение
; выход. С отловом нужных ошибок
3$:             tst     (SP)+
17$:            movb    @#52, R0
                cmpb    #21, R0
                bne     12$
                mov     #15, R1             ; неверное имя диска
13$:            jmp     OUTERS              ; вывод сообщений из массива
                                            ; Вход: R1 - индекс в массиве

12$:            cmpb    #22, R0
                bne     14$
15$:            mov     #14, R1             ; нет места на диске
                br      13$

14$:            cmpb    #24, R0
                beq     15$
                return
; файл с магнитофона прочитали
8$:             iot
                .word   26                  ; Создать файл.
                                            ; (если файл существовал ,то размер его устанавливается равным 0).
                                            ; вход: R4-адрес FCB.
                bcs     17$
                mov     ADRTM, F$FLLD(R4)   ; адрес загрузки файла в память
                mov     BUFSTA, F$DTAD(R4)  ; адрес обмена
                mov     BUFDL, F$RCSZ(R4)   ; размер записи в байтах.
                iot
                .word   42                  ; Прямой доступ,запись.
                                            ; вход: R4-адрес FCB.
                                            ; выход: R0-сколько байт записано.
                                            ; Поля FCB не изменяются.
                bcs     17$
                iot
                .word   20                  ; Закрыть файл.
                                            ; вход: R4-адрес FCB.
                iot
                .word   15                  ; Инициализировать драйвер (контроллер) дисковода.
                                            ; что-то это просто остановка двигателя.
                mov     BUFSTA, R0          ; очищаем буфер
                mov     BUFDL, R1
16$:            clrb    (R0)+
                sob     R1, 16$

                mov     ABP, R1
                add     #32, R1             ; имя прочитанного с ленты файла
18$:            mov     #13, R0
                mov     R1, R2              ; имя прочитанного с ленты файла
19$:            cmpb    (R1), #40           ; пробел ?
                beq     20$                 ; да - пропускаем
                tstb    (R1)                ; 0?
                beq     21$                 ; конец цикла
                cmpb    (R1), #'.           ; 41..55
                blo     22$                 ; переход туда
                cmpb    (R1), #':           ; 56..71
                blo     20$                 ; пропускаем
                cmpb    (R1), #'?           ; 72..77
                blos    22$                 ; переход туда
                cmpb    (R1), #177          ; 100..177
                blo     20$                 ; пропускаем
                cmpb    (R1), #277          ; 200..277
                blos    22$                 ; переход туда
20$:            inc     R1
                sob     R0, 19$
                ; все символы безопасные
21$:            mov     R2, R1
                mov     R4, -(SP)           ; FCBTMP
                add     #F$MDRV, R4
                clr     R2
                iot
                .word   51                  ; Произвести синтаксический разбор строки.
                                            ; вход: R1-адрес обрабатываемой строки.
                                            ;       R4-адрес формируемого FCB-блока.
                                            ;       R2-тип разбора:если 0,то обычный разбор.
                                            ;          если не 0,то если встретится первым код 0,
                                            ;          FCB  примет вид:_???????????
                                            ; выход: R2-количество символов '?'.
                bcs     22$
                mov     (SP)+, R4
                iot
                .word   27                  ; Переименовать файл.
                                            ; вход: R4-адрес модифицированного FCB.
                                            ;(Разрешается использовать символ групповой операции '?').
                bcs     23$                 ; не смогли переименовать
                mov     ABP, R1
                add     #32, R1             ; имя прочитанного с ленты файла
                clr     14(R1)              ; выведем на экран имя сохранённого файла
                iot
                .word   11                  ; Вывод строки символов на устройство вывода
                                            ; (по умолчанию - консоль).
                                            ; вход: R1-адрес строки символов.
                                            ; (Строка должна оканчиваться нулевым байтом)
                mov     #5, R1              ; - ОК
                call    OUTERS              ; вывод сообщений из массива
                                            ; Вход: R1 - индекс в массиве
                return
                ; в имени есть страшные символы
22$:            mov     R2, -(SP)
                mov     #10, R1             ; плохое имя файла
                call    OUTERS              ; вывод сообщений из массива
                                            ; Вход: R1 - индекс в массиве
                mov     (SP), R1            ; выведем на экран имя страшного файла
                iot
                .word   11                  ; Вывод строки символов на устройство вывода
                                            ; (по умолчанию - консоль).
                                            ; вход: R1-адрес строки символов.
                                            ; (Строка должна оканчиваться нулевым байтом)
                call    OUCRLF
                mov     #11, R1             ; попросим ввести новое имя файла
                call    OUTERS              ; вывод сообщений из массива
                                            ; Вход: R1 - индекс в массиве
24$:            mov     (SP)+, R1
                mov     #15, R2
                iot
                .word   6                   ; Буферизованный ввод с клавиатуры с возможностью редактирования.
                                            ; вход: R1-адрес буфера,
                                            ;       R2-размер буфера в байтах.
                br      18$                 ; и пойдём проверять заново
                ; не смогли переименовать временный файл
23$:            cmpb    #33, @#52           ; ошибка 33?
                bne     25$                 ; нет
                mov     #7, R1              ; да - такой Файл
                call    OUTERS              ; вывод сообщений из массива
                                            ; Вход: R1 - индекс в массиве
                mov     ABP, R1
                add     #32, R1
                mov     R1, -(SP)           ; выведем имя файла
                iot
                .word   11                  ; Вывод строки символов на устройство вывода
                                            ; (по умолчанию - консоль).
                                            ; вход: R1-адрес строки символов.
                                            ; (Строка должна оканчиваться нулевым байтом)
                mov     #12, R1             ; уже есть
                call    OUTERS              ; вывод сообщений из массива
                                            ; Вход: R1 - индекс в массиве
                mov     #11, R1             ; попросим ввести новое имя
                call    OUTERS              ; вывод сообщений из массива
                                            ; Вход: R1 - индекс в массиве
                br      24$                 ; идём вводить

25$:            clrb    F$FOPN(R4)
                iot
                .word   23                  ; Удалить файл.
                                            ; вход: R4-адрес FCB.
                                            ; (файл должен быть закрытым,допускается использовать символ
                                            ; групповой операции '?').
                return

InvalidSwitch$: mov     #1, R1              ; неверный ключ и выход
                jmp     OUTERS              ; вывод сообщений из массива
                                            ; Вход: R1 - индекс в массиве

PutToTape$:     tstb    (R1)                ; параметры есть?
                beq     1$                  ; вообще никаких нету
                cmpb    (R1), #'/           ; ключ есть?
                bne     InvalidSwitch$      ; нету, непонятно что есть
                inc     R1                  ; пропустим слеш
                call    SKIPWS              ; Пропуск пробельных символов
                                            ; Вход: R1 - указатель в буфере текста
                movb    (R1), R0            ; берём имя ключа
                sub     #'0, R0             ; если это не цифра
                beq     InvalidSwitch$      ; то ошибка
                cmp     R0, #9.             ;
                bhi     InvalidSwitch$      ;
                mov     R0, Repeats$        ; количество повторов

1$:             iot
                .word   21                  ; Найти первый файл по образцу.
                                            ; вход: R4-адрес FCB.
                                            ; выход: R1 - указатель на найденную запись каталога в буфере каталога.
                                            ; если R1 == -1, то в поле имени FCB задано стандартное устройство
                bcs     FileNotFound
2$:             mov     R4, -(SP)           ; FCBFIL
                mov     R5, -(SP)           ; FCBTMP
                inc     R5
                mov     #13, R0
3$:             movb    (R1)+, (R5)+        ; имя найденного файла
                sob     R0, 3$
                mov     (SP), R4            ; FCBTMP
                iot
                .word   17                  ; Открыть файл методом FCB.
                                            ; вход: R4-адрес FCB.
                .addr   R0, EOF
                mov     R0, F$DTAD(R4)      ; адрес обмена
                mov     F$FLSZ(R4), F$RCSZ(R4) ; размер файла в байтах -> размер записи в байтах.
                iot
                .word   41                  ; Прямой доступ,чтение.
                                            ; вход: R4-адрес FCB.
                                            ; выход: R0-сколько байт считано.
                                            ; Поля FCB не изменяются.
                iot
                .word   20                  ; Закрыть файл.
                                            ; вход: R4-адрес FCB.
                iot
                .word   15                  ; Инициализировать драйвер (контроллер) дисковода.
                                            ; что-то это просто остановка двигателя.
                mov     Repeats$, TmpRepts$ ; количество повторов в счётчик
                movb    #2, TAPCMD          ; команда "запись"
                .addr   R0, IMMAS           ; формируем имя
                mov     R0, R2
                mov     #20, R1
4$:             movb    #40, (R2)+
                sob     R1, 4$
                mov     #13, R1
                inc     R4
5$:             movb    (R4)+, R2
                cmpb    #40, R2
                beq     6$
                movb    R2, (R0)+
6$:             sob     R1, 5$

7$:             call    TapeIO              ; записываем
                tstb    PROH                ; ошибки были?
                bne     8$                  ; да - прекращаем
                dec     TmpRepts$           ; число повторов
                bgt     7$                  ; пока нужно - повторим
8$:             mov     (SP)+, R5           ; FCBTMP
                mov     (SP)+, R4           ; FCBFIL
                tstb    PROH
                bne     9$
                mov     R5, R1
                inc     R1                  ; Выведем имя файла
                iot
                .word   11                  ; Вывод строки символов на устройство вывода
                                            ; (по умолчанию - консоль).
                                            ; вход: R1-адрес строки символов.
                                            ; (Строка должна оканчиваться нулевым байтом)
                mov     #5, R1              ; - ОК
                call    OUTERS              ; вывод сообщений из массива
                                            ; Вход: R1 - индекс в массиве
                iot
                .word   22                  ; Продолжить поиск файлов.
                                            ; (перед вызовом вызвать функцию 21, FCB не не изменять)
                                            ; вход: R4- адрес FCB.
                bcc     2$
9$:             iot
                .word   15                  ; Инициализировать драйвер (контроллер) дисковода.
                                            ; что-то это просто остановка двигателя.
                return
; ───────────────────────────────────────────────────────────────────────────

FileNotFound:   mov     #4, R1              ; Файл не найден.
                jmp     OUTERS              ; вывод сообщений из массива
                                            ; Вход: R1 - индекс в массиве
; ═══════════════════════════════════════════════════════════════════════════
; обработка команды DIR
; Вход: R1 - указатель на параметры за командой
;       R2 - указатель на имя команды
CMDDIR:         call    SKIPWS              ; Пропуск пробельных символов
                                            ; Вход: R1 - указатель в буфере текста
                inc     R2      ; чтобы R2 был гарантированно не 0
                .addr   R4, FCBFIL
                iot
                .word   51                  ; Произвести синтаксический разбор строки.
                                            ; вход: R1-адрес обрабатываемой строки.
                                            ;       R4-адрес формируемого FCB-блока.
                                            ;       R2-тип разбора:если 0,то обычный разбор.
                                            ;          если не 0,то если встретится первым код 0,
                                            ;          FCB  примет вид:_???????????
                                            ; выход: R2-количество символов '?'.
                clr     R5      ; счётчик имён файлов в строке
                iot
                .word   21                  ; Найти первый файл по образцу.
                                            ; вход: R4-адрес FCB.
                                            ; выход: R1 - указатель на найденную запись каталога в буфере каталога.
                                            ; если R1 == -1, то в поле имени FCB задано стандартное устройство
                bcs     FileNotFound
1$:             clrb    K$ATTR(R1)          ; записываем 0 в конец имени
                iot
                .word   11                  ; Вывод строки символов на устройство вывода
                                            ; (по умолчанию - консоль).
                                            ; вход: R1-адрес строки символов.
                                            ; (Строка должна оканчиваться нулевым байтом)
                mov     #40, R0
                iot
                .word   2                   ; Вывод символа на стандартное устройство вывода
                                            ; (по умолчанию - консоль).
                                            ; вход: R0-код символа.
                inc     R5
                cmp     R5, #5              ; вывели 5 файлов?
                bne     2$                  ; нет
                clr     R5                  ; да - перевод строке
                call    OUCRLF
2$:             iot
                .word   22                  ; Продолжить поиск файлов.
                                            ; (перед вызовом вызвать функцию 21, FCB не не изменять)
                                            ; вход: R4- адрес FCB.
                bcc     1$
                jmp     OUCRLF
; ───────────────────────────────────────────────────────────────────────────
Repeats$:       .word   0
TmpRepts$:      .word   0
OLDV4:          .word   0
; ═══════════════════════════════════════════════════════════════════════════

OutPrompt:      mov     #6, R1              ; prompt
                call    OUTERS              ; вывод сообщений из массива
                                            ; Вход: R1 - индекс в массиве
                iot
                .word   15                  ; Инициализировать драйвер (контроллер) дисковода.
                                            ; что-то это просто остановка двигателя.
                return

; ═══════════════════════════════════════════════════════════════════════════

OUCRLF:         mov     #5015, R0
                iot
                .word   2
                swab    R0
                iot
                .word   2
                return

; ═══════════════════════════════════════════════════════════════════════════
; обработка команды HELP

CMDHLP:         .addr   R4, FCBCPH
                iot
                .word   17                  ; Открыть файл методом FCB.
                                            ; вход: R4-адрес FCB.
                bcc     1$
                jmp     FileNotFound

1$:             mov     #1, F$RCSZ(R4)      ; размер записи в байтах.
                clr     F$DTAD(R4)          ; адрес обмена
                iot
                .word   24                  ; Последовательное чтение из файла.
                                            ; вход: R4-адрес FCB.
                                            ; После чтения соответствующие поля FCB модифицируются.
                ; прочитали байт в ячейку 0
                movb    @#0, R0             ; смотрим, что прочитали
                cmpb    #32, R0             ; конец файла?
                beq     2$                  ; да - выход
                iot
                .word   2                   ; Вывод символа на стандартное устройство вывода
                                            ; (по умолчанию - консоль).
                                            ; вход: R0-код символа.
                br      1$

2$:             iot
                .word   20                  ; Закрыть файл.
                                            ; вход: R4-адрес FCB.
                return

; ───────────────────────────────────────────────────────────────────────────
FCBCPH:         .byte 0
                .ascii "COPYM   HLP"
                .blkb FCB$SZ-F$MDRV+2

; ═══════════════════════════════════════════════════════════════════════════
; Пропуск пробельных символов
; Вход: R1 - указатель в буфере текста

SKIPWS:         cmpb    #40, (R1)
                bne     1$
                inc     R1
                br      SKIPWS

1$:             ccc
                return

; ═══════════════════════════════════════════════════════════════════════════
; обработка команды FIND
; Вход: R1 - указатель на параметры за командой

CMDFND:         mov     #4, R0
                mov     R3, -(SP)
                mov     (R0), -(SP)
                mov     SP, SP$BUF
                mov     PC, (R0)
                add     #VEC4$1-., (R0)
                mov     #1, INCADR
1$:             mov     #40, R5
                .addr   R1, TAPCMD
                mov     R1, ABP
                mov     #177716, R3
                mov     KPUSK, (R3)
                clr     PROH
                clr     PRINV
                call    PPNF
                call    PCTIM
                mov     ABP, R1
                clr     52(R1)              ; очистка 20-го байта, сразу за именем найденного файла
                add     #32, R1             ; указывает на имя найденного файла
                iot
                .word   11                  ; Вывод строки символов на устройство вывода
                                            ; (по умолчанию - консоль).
                                            ; вход: R1-адрес строки символов.
                                            ; (Строка должна оканчиваться нулевым байтом)
                call    OUCRLF
                br      1$
; ───────────────────────────────────────────────────────────────────────────

VEC4$1:         mov     SP$BUF, SP
                mov     (SP)+, @#4
                mov     (SP)+, R3
                clr     PROH
                return

; ═══════════════════════════════════════════════════════════════════════════

; получение по имени команды её номер
; Вход: R1 - адрес списка команд
;       R2 - адрес буфера текста
; Выход: C = 1 - не нашли такую команду в списке
;       С = 0 - нашли, тогда R0 == номер * 2, R5 - указатель на текст за командой

CMDNUM:         clr     R0
1$:             cmpb    (R1), #'$       ; список кончился?
                beq     2$              ; да выход с ошибкой
                mov     R2, R5          ; адрес буфера текста
3$:             tstb    (R1)            ; команда кончилась?
                beq     5$              ; да - ОК
                cmpb    (R5)+, (R1)+    ; сравниваем команду
                beq     3$              ; пока совпадает
                ; не совпала
4$:             tstb    (R1)+           ; переходим к следующей команде
                bne     4$              ; в списке
                tst     (R0)+           ; увеличиваем номер
                br      1$

2$:             sec
5$:             return

; ═══════════════════════════════════════════════════════════════════════════

; вывод сообщений из массива
; Вход: R1 - индекс в массиве

OUTERS:         .addr   R2, STRARR
                br      3$

2$:             tstb    (R2)+
                bne     2$
3$:             dec     R1
                bgt     2$

1$:             mov     R2, R1
                iot
                .word   11                  ; Вывод строки символов на устройство вывода
                                            ; (по умолчанию - консоль).
                                            ; вход: R1-адрес строки символов.
                                            ; (Строка должна оканчиваться нулевым байтом)
                sec
                iot
                .word   15                  ; Инициализировать драйвер (контроллер) дисковода.
                                            ; что-то это просто остановка двигателя.
                return

; ═══════════════════════════════════════════════════════════════════════════

TapeIO:         mov     R3, -(SP)
                mov     #177716, R3
                .addr   R1, TAPCMD
                clr     PROH
                mov     R1, ABP
                clr     PRINV
                mov     #4, R0
                mov     (R0), -(SP)
                mov     PC, (R0)
                add     #VEC4$2-., (R0)
                mov     SP, SP$BUF
                movb    (R1), R0
                dec     R0
                dec     R0
                bne     1$
                call    BZMAS
                br      2Ex2$

1$:             call    BCTMAS
                br      2Ex2$

VEC4$2:         mov     SP$BUF, SP
                movb    #4, PROH
2Ex2$:          mov     KSTOP, (R3)
                mov     (SP)+, @#4
                mov     (SP)+, R3
                return

; ═══════════════════════════════════════════════════════════════════════════
; ==============================
; *** 1. БЛОК ЗАПИСИ МАССИВА ***
; ==============================

BZMAS:          mov     KPUSK, (R3)             ; пуск двигателя
                mov     FCBTMP+F$DTAD, R5       ; адрес массива
                mov     FCBTMP+F$FLSZ, R4       ; длина массива на запись
                beq     1$
                mov     R4, DLMAS
                mov     FCBTMP+F$FLLD, ADRMAS
                call    CHKCS
                mov     R0, @#312
                mov     #10000, R0              ; запись настроечной последовательности
                call    PZNP
                mov     (R1)+, R0               ; R1+=2, значение R0 не используется
                mov     #24, R2                 ; запись имени
                call    PZBL
                mov     ABP, R1                 ; запись массива
                mov     FCBTMP+F$FLSZ, R2
                mov     FCBTMP+F$DTAD, R1
                call    PZBL
                mov     #312, R1                ; запись KS
                mov     #2, R2
                call    PZBL1
                mov     #400, R0
                mov     R0, R4
                mov     R0, R5
                call    PZNP
1$:             mov     KSTOP, (R3)             ; - останов двигателя
                return

; ═══════════════════════════════════════════════════════════════════════════
;    ------------------------------------------------
;    ** 1.1. запись настроечной последовательности **
;    ------------------------------------------------
;   ВХОД:   R0 - счётчик нулевых импульсов
;           R5 - фактор случайности (рандомная пауза между первым импульсом и вторым)
;           R4 - 0

PZNP:           mov     KBIT01, (R3)        ;  запись +0
                add     #27, R5             
                sob     R5, .               
                mov     KPUSK, (R3)         ;  запись -0
                add     #26, R4             
                sob     R4, .               
                sob     R0, PZNP            ;  запись 0 в цикле
;  запись маркера(+1,-1)
                mov     KBIT11, (R3)        ;  запись +1
                mov     #151, R5            
                sob     R5, .               
                mov     KBIT10, (R3)        ;  запись -1
                mov     #144, R5
                sob     R5, .

                inc     R4
                mov     R2, R0
                mov     R4, R2
                call    ZPBIT1
                mov     R0, R2
                return

; ═══════════════════════════════════════════════════════════════════════════
; -----------------------
; ** 1.2. ЗАПИСЬ БЛОКА **
; -----------------------
;
; ВХОД:   R1  - АДРЕС БЛОКА
;         R2  - ДЛИНА БЛОКА
; R0 - R2,R4,R5  - РАБОЧИЕ

PZBL:           mov     #10, R0
                call    PZNP

; ═══════════════════════════════════════════════════════════════════════════
; запись байтов

PZBL1:          movb    (R1)+, R0
                mov     #8., R4
                
PZB:            asr     R0                  ;  запись байта
                bcs     ZPBIT1              
                mov     KBIT01, (R3)        ;  запись +0
                mov     #30, R5             
                sob     R5, .               
                mov     KPUSK, (R3)         ;  запись -0
                mov     #27, R5
                sob     R5, .
                br      ZPMIN

; ═══════════════════════════════════════════════════════════════════════════
; запись бита, плавно переходящая в запись байтов

ZPBIT1:         mov     KBIT11, (R3)        ;  запись +1
                mov     #63, R5             
                sob     R5, .               
                mov     KBIT10, (R3)        ;  запись -1
                mov     #63, R5             
                sob     R5, .               
                                            
ZPMIN:          mov     KBIT01, (R3)        ;  запись +0
                mov     #30, R5             
                sob     R5, .               
                mov     KPUSK, (R3)         ;  запись -0
                mov     #26, R5             
                sob     R5, .               
                sob     R4, PZB             ;  конец записи байта
                sob     R2, PZBL1           ;  конец записи блока
                return

; ═══════════════════════════════════════════════════════════════════════════
; Подсчёт контрольной суммы. 116622
; Вход:  R4 - длина массива
;        R5 - адрес начала массива
; Выход: R0 - контрольная сумма
;        R4 == 0
;        R5 - адрес за концом массива
CHKCS:          clr     R0
1$:             clr     R2
                bisb    (R5)+, R2
                add     R2, R0
                adc     R0
                sob     R4, 1$
                return

; ═══════════════════════════════════════════════════════════════════════════
; чтение с ленты

BCTMAS:         mov     #40, R5             ; подготовка парам. и пуск двигателя
                clr     R0
1$:             mov     KPUSK, (R3)
                sob     R0, 1$
                mov     #1, INCADR
RETRY:          clr     PRINV
                call    PPNF                ; поиск начала файла
                call    PCTIM               ; чтение IMMAS
                tstb    PROH
                bne     2$
                call    PCTMAS              ; чтение блока информации
                mov     KSTOP, (R3)
2$:             return

; ═══════════════════════════════════════════════════════════════════════════
; чтение настроечной последовательности и автоподстройка
; -----------------------------
; ** 2.1. Поиск начала файла **
; -----------------------------

PPNF:           mov     #4000, R2           ; поиск нулей
                clr     R0                  ; длительность предыдущего импульса
                ; - чтение импульса
1$:             clr     R4                  ; длительность текущего импульса
2$:             bit     R5, (R3)            ; ждём сигнала
                beq     2$
3$:             inc     R4                  ; считаем длительность сигнала
                bit     R5, (R3)
                bne     3$
                ; определение разброса
                sub     R4, R0              ; вычисляем разницу в длине импульсов
                bmi     4$                  ; если текущий длиньше предыдущего - переход
                cmp     R0, #2              ; если разница слишком велика
                bhi     PPNF                ; начнём сначала
4$:             mov     R4, R0              ; текущий -> предыдущий
                sob     R2, 1$              ; и так много раз
                ; настройка на скорость
                clr     R0                  ; аккумулятор
                mov     #200, R2            ; читаем 128 импульсов
5$:             call    PCTBIT              ; чтение бита
                                            ; Выход: R4 - длительность импульса
                add     R4, R0              ; суммируем
                sob     R2, 5$
                ; - вычисление границы 0
                mov     #7, R2              ; делим на 128
6$:             asr     R0
                sob     R2, 6$
                mov     R0, R4              ;
                asr     R4                  ;
                add     R4, R0              ; прибавляем L/2
                mov     R0, GRDL0           ; граница нуля: (среднее арифметическое 128 импульсов) * 1.5
;    ------------------------
;    ** 2.6. Поиск маркера **
;    ------------------------
7$:             clr     R4
8$:             inc     R4                  ; считаем длительность сигнала
                bit     R5, (R3)
                bne     8$
                cmp     R4, R0              ; сигнал больше чем нулевой импульс?
                bhi     10$                 ; да - переход
                clr     R4                  ; нет - считаем длительность отсутствия сигнала
9$:             inc     R4
                bit     R5, (R3)
                beq     9$
                cmp     R4, R0              ; отсутствие сигнала больше чем нулевой импульс?
                blo     7$                  ; нет - переход
                incb    PRINV               ; да - у нас инверсное чтение

10$:            asl     R0                  ;
                cmp     R4, R0              ; импульс больше чем 2*L0 ?
                bhi     0RETR               ; да - начнём поиск с начала
                call    PCTBIT              ; иначе - читаем бит
                return                      ; и идём дальше

RETRY1:         tst     (SP)+
0RETR:          tst     (SP)+
                br      RETRY

; ═══════════════════════════════════════════════════════════════════════════
; -------------------------------
; ** 2.2. ЧТЕНИЕ ИМЕНИ МАССИВА **
; -------------------------------
; чтение заголовка с магнитофона

PCTIM:          mov     ABP, R1         ; чтение имени
                add     #26, R1
                mov     R0, -(SP)
                mov     R1, -(SP)
                mov     #24, R2
                call    PPM

                mov     (SP)+, R1
                tst     (R1)+
                mov     (R1)+, BUFDL
                mov     #13, R2         ;  сравнение имён
                mov     ABP, R0
                add     #6, R0
1$:             cmpb    #'?, (R0)
                beq     2$
                cmpb    (R0), (R1)
                bne     3$
2$:             inc     R0
                inc     R1
                sob     R2, 1$
                br      4$

3$:             incb    PROH
4$:             mov     (SP)+, R0
                return

; ═══════════════════════════════════════════════════════════════════════════
; чтение файла с магнитофона
;    -------------------------
;    ** 2.3. ЧТЕНИЕ МАССИВА **
;    -------------------------

PCTMAS:         mov     BUFSTA, R1
                mov     BUFDL, R2
                call    PPM             ; считываем файл
                mov     #312, R1
                mov     #2, R2
                call    PCTBL           ; считываем контрольную сумму
                mov     BUFSTA, R5
                mov     BUFDL, R4
                call    CHKCS
                cmp     R0, @#312
                beq     1$
                movb    #2, PROH
1$:             return

; ═══════════════════════════════════════════════════════════════════════════
; загрузка данных с ленты
;    ------------------------
;    ** 2.6. Поиск маркера **
;    ------------------------

PPM:            mov     GRDL0, R0       ; длительность нуля
                tstb    PRINV           ; инверсное чтение?
                bne     3$              ; да
                ; прямое чтение
1$:             clr     R4              ; счётчик
2$:             inc     R4              ; считаем длительность импульса
                bit     R5, (R3)
                bne     2$
                cmp     R4, R0          ; если импульс короче нуля
                blo     1$              ; всё сначала
                br      5$
                ; инверсное чтение
3$:             clr     R4              ; счётчик
4$:             inc     R4              ; считаем длительность отсутствия импульса
                bit     R5, (R3)
                beq     4$
                cmp     R4, R0          ; если импульс короче нуля
                blo     3$              ; всё сначала

5$:             asl     R0              ;
                cmp     R4, R0          ; импульс длиньше 2*L0
                bhi     RETRY1          ; да - идём заново искать начало файла
                call    PCTBIT          ; нет - нашли маркер, за ним читаем бит.

; ═══════════════════════════════════════════════════════════════════════════
;    -----------------------
;    ** 2.4. Чтение блока **
;    -----------------------
; Вход: R1  - адрес ОЗУ
;       R2  - длина блока

PCTBL:          mov     #8., R0
1$:             call    PCTBIT          ; читаем бит
                cmp     R4, GRDL0
                bhi     2$
                clc
                br      3$

2$:             sec
3$:             rorb    (R1)
                sob     R0, 1$
                add     INCADR, R1
                sob     R2, PCTBL
                return

; ═══════════════════════════════════════════════════════════════════════════
;    ----------------------
;    ** 2.5. Чтение бита **
;    ----------------------
;   Выход:  R4 - длительность бита

PCTBIT:         clr     R4              ; счётчик длины бита
                tstb    PRINV           ; инверсное чтение?
                bne     5$              ; да

1$:             bit     R5, (R3)        ; ждём пропадания сигнала (пропускаем синхроимпульс)
                bne     1$
2$:             bit     R5, (R3)        ; ждём появления сигнала
                beq     2$
3$:             inc     R4              ; считаем длительность сигнала
                bit     R5, (R3)
                bne     3$
4$:             inc     R4              ; считаем длительность отсутствия сигнала
                bit     R5, (R3)
                beq     4$
                return

5$:             bit     R5, (R3)        ; ждём появления сигнала (пропускаем синхроимпульс)
                beq     5$
6$:             bit     R5, (R3)        ; ждём пропадания сигнала
                bne     6$
7$:             inc     R4              ; считаем длительность отсутствия сигнала
                bit     R5, (R3)
                beq     7$
8$:             inc     R4              ; считаем длительность сигнала
                bit     R5, (R3)
                bne     8$
                return
; End of function PCTBIT

; ───────────────────────────────────────────────────────────────────────────
CMDTBL:         .asciz "HELP"
                .asciz "DIR"
                .asciz "FIND"
                .asciz "EXIT"
                .asciz "COPY"
                .asciz "$"  ; конец списка
                .even

KEYBUF:         .blkb   KBLEN
                .even
; ───────────────────────────────────────────────────────────────────────────
FCBFIL:         .blkb   FCB$SZ+2        ; FCB шаблона для DIR и COPY
; ───────────────────────────────────────────────────────────────────────────
FCBTMP:         .blkb   FCB$SZ+2        ; FCB временного файла, создаваемого при записи на диск
; ───────────────────────────────────────────────────────────────────────────
TMPFIL:         .asciz "A:COPYM.TMP"    ; временное имя файла, создаваемое при записи на диск
                .even

; блок параметров магнитофона
TAPCMD:         .word   0               ; команда драйвера магнитофона
ADRMAS:         .word   0               ; адрес загрузки/записи
DLMAS:          .word   0               ; длина массива
IMMAS:          .blkb   20              ; имя файла прочитанного с магнитофона
ADRTM:          .blkw   25              ; адрес обнаруженного на ленте массива, а так же остаток блока параметров
; конец блока параметров магнитофона
ABP:            .word   0               ; адрес блока параметров драйвера магнитофона
PRINV:          .word   0               ; флаг инверсного сигнала
PROH:           .word   0               ; ошибка драйвера магнитофона
INCADR:         .word   0               ; шаг при чтении байтов
SP$BUF:         .word   0               ; указатель стека при обработке вектора 4
GRDL0:          .word   0               ; средневзвешенное значение сигнала
BUFDL:          .word   0               ; размер прочитанного массива
BUFSTA:         .word   0               ; адрес буфера
; константы для записи звука в 177716
KSTOP:          .word   0
KPUSK:          .word   0
KBIT01:         .word   0
KBIT11:         .word   0
KBIT10:         .word   0

CMDSUB:         .word   @CMDHLP         ; смещения к подпрограммам команд
                .word   @CMDDIR
                .word   @CMDFND
                .word   @CMDEXI
                .word   @CMDCPY
                .word   0

STRARR:         .asciz "Invalid switch"<12><15>                 ; 1
                .asciz "Bad command or file name"<12><15>       ; 2
                .asciz "Check sum error"<12><15>                ; 3
                .asciz "File not found"<12><15>                 ; 4
                .asciz " - ok"<12><15>                          ; 5
                .asciz "M>>"                                    ; 6
                .asciz "File "                                  ; 7
                .asciz <14>"Bad file name :  "                  ; 10
                .asciz <12><15>"Input new file name :"          ; 11
                .asciz "already exists"<12><15>                 ; 12
                .asciz <12><15>"Copym version 1.00"<12><15>     ; 13
                .asciz "Disk full"<12><15>                      ; 14
                .asciz "Invalid drive specification"<12><15>    ; 15
                .asciz "found: "                                ; 16
                .even
EOF:            .word   0


                .END
