﻿; Processor:        1801VM1
; Target assembler: BK Turbo8 Cross Assembler
; Файл: DXDOS.SYS

; ═══════════════════════════════════════════════════════════════════════════
.include "inc/dx_fcb.asm"
.include "inc/dx_pdb.asm"
.include "inc/dx_fat.asm"
.include "inc/dx_sys.asm"
.include "inc/dx_cmd.asm"
.include "inc/FDDParam.asm"

; ───────────────────────────────────────────────────────────────────────────
TOPSTACK = 1000 ; Вершина стека

MemRegVal=117770    ; какая-то по непонятной логике выбранная ячейка в ОЗУ БК11 в стр.4
                    ; предполагается, что там по адресам 100000-120000 находится монитор БК10
                    ; и уже сейчас она перекрывается буферами.

; !!! Думаю, что надо заменить IOT num на резервные опкоды .word 7000+num. num = {0..777}
;                                                              107000+num. num = {0..777}
;                                              или CIS диапазон 76000+num. num = {0..777}
; !!! Заодно некоторые п/п тоже заменить.
; !!! Проблема только в том, что внешние вызовы при этом будут выглядеть очень некрасиво
; !!! и надо как-то разделить внутренние вызовы от внешних.
; ═══════════════════════════════════════════════════════════════════════════

.LA LoADDOS


                nop         ; традиционно, всё самое важное нужно начинать с этой команды.
                br      START

DXVERS:         .ascii "DX-DOS Version 1.01"<15><12>
                .asciz "Copyright 1995 by SENDY CORP.,"<15><12>"(c) 2014,2023 by gid prod."<15><12>
ERRMEM:         .asciz "Fatal error: Cannot allocate Memory for DOS"<15><12>
NOMEMR:         .asciz "Configuration too large for memory"<15><12>
                .even

; ═══════════════════════════════════════════════════════════════════════════
$OutS1$:        call    OUTCHR
; вывод строки.
; вход:  R1 - адрес строки, конец строки - 0
OUTSTR:         movb    (R1)+, R0
                bne     $OutS1$
                return

; обработка фатальной ошибки
FTLERR:         mov     @#STORV4, @#4       ; возвращаем вектор 4 как было
                halt                        ; и переходим к обработке кем было
; ───────────────────────────────────────────────────────────────────────────
; эту часть не обязательно оптимизировать по размеру.
START:          mov     @#4, @#STORV4       ; сохраним вектор 4
                mov     #TOPSTACK, SP
                mfps    @#6                 ; у прерывания по вектору 4 сделаем такой же приоритет, как и у основной программы.
                clr     @#BKMONT            ; 0 - мон.БК10
                clr     @#62                ; PSW векторов прерывания
                clr     @#276               ; чтобы обработку их могли прерывать другие прерывания
                clr     @#BKTYPE            ; 0 - БК10
                mov     #400, @#PRNSTB      ; зададим стробирующий бит для принтера на БК10
                mov     @#177716, R0        ; берём адрес запуска БК
                clrb    R0                  ; оставляем от него старший байт
                cmp     #100000, R0         ; это БК10 ?
                beq     1$                  ; да
                ; БК11(М)
                mov     #40000, @#PRNSTB    ; зададим стробирующий бит для принтера на БК11
                inc     @#BKTYPE            ; 1 - БК11М
                cmp     #167, @#140004      ; это БК11М?
                beq     1$                  ; да
                inc     @#BKTYPE            ; 2 - БК11
                cmp     #12706, @#140004    ; это БК11(не М)?
                bne     FTLERR              ; нет - неопознанная БКшка, на такой не работаем
1$:             mov     #40000, @#HIRAML    ; зададим верхний адрес пользовательского ОЗУ для БК10
                cmp     @#30, #100112       ; а это у нас монитор БК10?
                beq     22$                 ; да, даже если мы на БК11 пользуемся монитором от 10ки, будем считать, что работаем на БК10
                inc     @#BKMONT            ; 1 - мон.БК11М
                cmp     @#30, #152112       ; а это у нас монитор БК11М?
                bne     3$                  ; нет
                ; БК11М
                mov     #104033, INPCHR     ; да, тогда поменяем емт команды ввода-вывода для монитора БК11М
                mov     #104063, OUTCHR
                mov     #104000, AE14$1
                mov     #104000, AE14$2
                mov     #3, R0              ; стр.3 в окно 0
                emt     12                  ; подключение страницы ОЗУ/ПЗУ
                mov     #404, R0            ; стр.4 в окно 1
                emt     12                  ; подключение страницы ОЗУ/ПЗУ
                mov     #100000, @#HIRAML   ; зададим верхний адрес пользовательского ОЗУ для БК11
                mov     #6305, M1$11M       ; номера емтов могут быть нечётными, потому надо умножать на 2
                br      2$
                ; БК11 без М
3$:             cmp     @#30, #147552       ; а это у нас монитор БК11?
                bne     FTLERR              ; нет - неопознанный монитор БКшки, на таком не работаем
                inc     @#BKMONT            ; 2 - мон.БК11
                mov     #3, R0              ; стр.3 в окно 0
                emt     52                  ; подключение страницы ОЗУ/ПЗУ
                mov     #404, R0            ; стр.4 в окно 1
                emt     52                  ; подключение страницы ОЗУ/ПЗУ
2$:             clr     @#MemRegVal         ; обнуляем что-то в странице 4
22$:            .addr   R1, DXVERS
                call    OUTSTR              ; выведем заголовок
; ───────────────────────────────────────────────────────────────────────────
                ; определение количества ОЗУ под ДОС
                mov     #160000, R5         ; ищем конец ОЗУ, начнём отсюда
                mov     #4, R4
                mov     (R4), -(SP)         ; сохраним старый вектор 4 в стеке
                .addr   R0, HLT4M1
                mov     R0, (R4)            ; новый вектор 4

FFM1$:          clr     (R5)                ; это ОЗУ?, если нет - то будет HLT4M1
                mov     R5, @#ENDRAM
                cmp     R5, #100000         ; дошли досюда, а ОЗУ так и не нашли?
                bhi     FFM4$               ; не, пока не дошли
FFM2$:          .addr   R1, ERRMEM          ; да, а памяти для ДОС то нету.
FFM3$:          call    OUTSTR              ; скажем об этом
                jmp     FTLERR              ; и выходим с ошибкой

HLT4M1:         cmp     (SP)+, (SP)+        ; обработаем прерывание по вектору 4
                tst     -(R5)
                br      FFM1$               ; пойдём искать дальше

HLT4M2:         cmp     (SP)+, (SP)+        ; наш новый вектор
                .addr   R1, NOMEMR          ; скажем, что ядро не перемещается, места нету
                br      FFM3$

FFM4$:          .addr   R0, FFM2$           ; нашли.
                mov     R0, (R4)
                mov     #7777, R1           ; это нужный нам теоретический размер в словах под ДОС - 8 кБ ОЗУ
1$:             clr     -(R5)               ; проверим, если случится trap to 4, значит нужного размера ОЗУ нету
                sob     R1, 1$
                mov     (SP)+, (R4)         ; восстанавливаем старый вектор
; ───────────────────────────────────────────────────────────────────────────
                ; определение количества и типа дисководов
                mov     #DRVSTT, R0         ; таблица статусов дисководов длиной до 4х слов
                clr     R4
                clr     @#DRVCNT            ; адрес счётчика рабочих дисководов
                mov     #1, R1              ; начнём с привода А
11$:            mov     #177130, R5
                mov     R1, -(SP)
                bis     #20, R1             ; выставим команду включения двигателя
                mov     R1, (R5)            ; включим двигатель
                sob     R4, .               ; подождём, пока контроллер среагирует
                mov     #128., R2           ; будем делать цикл столько раз.
                bis     #200, R1            ; выставим команду ШАГ и направление к 0
2$:             mov     #1000, R4
                sob     R4, .               ; небольшая пауза (для драматизму)
                bit     #1, (R5)            ; мы уже на нулевой?
                bne     3$                  ; да
                mov     R1, (R5)            ; нет, шагнём
                mov     #4000, R4
                sob     R4, .               ; подождём, пока контроллер среагирует
                sob     R2, 2$              ; в цикле, пока не дойдём до 0
                br      6$                  ; цикл кончился, а до дорожки 0 так и не дошли, что-то не так

3$:             mov     #48., R2
                bis     #100, R1            ; зададим направление движения к центру
4$:             mov     R1, (R5)            ; шагнём, теперь понятно, зачем была нужна та драматическая пауза, это чтобы тут, контроллер воспринял команду.
                mov     #2000, R4
                sob     R4, .               ; подождём, пока контроллер среагирует
                sob     R2, 4$              ; и так в цикле 48 раз.
                mov     #64., R2
                bic     #100, R1            ; направление к 0
5$:             mov     R1, (R5)            ; шагнём
                mov     #2000, R4
                sob     R4, .               ; подождём, пока контроллер среагирует
                bit     #1, (R5)            ; дошли до нулевой?
                bne     7$                  ; да
                mov     #1000, R4           ; нет ещё
                sob     R4, .               ; небольшая пауза
                sob     R2, 5$              ; и так в цикле 64 раза
6$:             mov     #-1, R2             ; если не смогли вернуться на 0 дор. - значит что-то не так
                br      8$

7$:             cmp     #17., R2            ; если в счётчике осталось не 17
                bne     9$                  ; то дисковод был 40 дорожечный
                clr     R2                  ; иначе всё корректно
                br      8$

9$:             mov     #1, R2              ; дисковод 40 дорожечный
8$:             mov     (SP)+, R1           ; восстановим номер привода
                tst     R2                  ; какой статус?
                bmi     10$                 ; не смогли достичь дорожки 0, прерываем цикл
                mov     R2, (R0)+           ; сохраним статус привода
                inc     @#DRVCNT            ; увеличим счётчик работающих приводов
                asl     R1                  ; переходим к следующему приводу
                cmp     #20, R1             ; пока приводы не кончились,
                bne     11$                 ; повторим процедуру

10$:            clr     @#177130            ; а раз не смогли достичь дор.0, то значит не что-то не так,
                sob     R5, .               ; а просто оказывается приводы кончились
                sob     R5, .               ; !!!а как быть, если приводы начинаются с буквы B: ?
                                            ; т.е. дисковода А: нет физически?
; ───────────────────────────────────────────────────────────────────────────
                .addr   R5, HLT4M2
                mov     R5, @#4             ; новый вектор 4
                add     #ENKRNL-HLT4M2, R5  ; адрес конца основного ядра DOS
                mov     @#ENDRAM, R4        ; адрес ОЗУ, куда перемещать
                .addr   R3, BGKRNL          ; адрес начала основного ядра DOS
21$:            mov     -(R5), R0           ; читаем очередное слово
                cmp     R5, R3              ; дошли до начала?
                blo     22$                 ; да, значит хватит
                mov     R0, -(R4)           ; нет, сохраним в новом месте
                br      21$                 ; повторим

22$:            .addr   R5, RUNBLK          ; а этот блок
                mov     #TOPSTACK, R2       ; разместим по этому адресу
                mov     #/RUNBLE-/RUNBLK, R3 ; размер блока
23$:            mov     (R5)+, (R2)+        ; переместим
                sob     R3, 23$

                jmp     (R4)                ; переходим в ядро

; ═══════════════════════════════════════════════════════════════════════════
; блок запускателя коммандкома, размещается по адресу 1000, тоже необязательно оптимизировать. максимальный размер блока - 4000 байтов
; запускается после инициализации переменных ядра ОС.

RUNBLK:         .addr   R4, FCBCMD          ; адрес FCB
                iot
                .word 21                    ; Найти первый файл по образцу. вход: R4-адрес FCB.
                bcs     6$                  ; не найден комманнд.ком
                iot
                .word 61                    ; Доступ к внутрисистемной информации. выход: R1-адрес области DOS.
                tstb    S$BRDT(R1)          ; какой тип машины? тип машины 0-БК0010, 1-БК0011М, 2-БК0011.
                beq     5$                  ; бк10
                mov     @#MemRegVal, R5     ; ранее эту ячейку в стр 4 обнулили
                cmp     #16000, R5
                beq     3$
                mov     #56000, @#177716    ; стр.7 в о.0, стр.4 в о.1
                mov     #76000, R4          ; по этому адресу в стр 7 у БК11М ничего нет
                cmpb    #1, S$BRDT(R1)      ; бк11м?
                beq     1$                  ; да
                mov     @#66, R5            ; нет, у БК11 копия ССП тут
                br      2$

1$:             mov     @#114, R5           ; у БК11М копия ССП тут

2$:             cmp     #52652, (R4)        ; это проверка на драйвер БК0010 на БК11М
                bne     4$                  ; не загружен.
                clr     (R4)+               ; загружен - отменяем.
                mov     (R4)+, R5           ; это код для подключения страниц 16000
                mov     R5, @#MemRegVal
                tstb    F$FOPN+2(R4)        ; +2 - это с учётом первого слова - уровня вложенности бат файлов
                beq     3$
                iot
                .word 30                    ; Доступ к буферам DOS. выход: R0 - адрес области BAT-файлов.
                                            ; R1 - адрес FCB стандартного устройства ввода.
                                            ; R2 - адрес FCB стандартного устройства вывода.
                mov     R0, -(SP)           ; R0 - адрес области BAT-файлов.
                mov     #BAT$SZ, R1
7$:             movb    (R4)+, (R0)+
                sob     R1, 7$
                mov     (SP)+, R4           ; адрес области BAT-файлов.
                mov     R5, -(SP)
                mov     (R4)+, R5           ; уровень вложенности BAT-файла.
                beq     8$
9$:             movb    (R4), R0            ; номер текущего устройства
                beq     8$
                tstb    F$FOPN(R4)          ; файл уже открыт?
                beq     8$                  ; нет
                iot
                .word 34                    ; Получить параметры заданного устройства.
                                            ; вход: R0-номер устройства (1-дисковод "А"...)
                                            ; выход:  R2-адрес списка параметров.
                add     #BATLBF, R4
                sob     R5, 9$
8$:             mov     (SP)+, R5
3$:             mov     R5, @#177716
                br      10$

4$:             mov     R5, @#177716
                ; БК10
5$:             iot
                .word 30                    ; Доступ к буферам DOS. выход: R0 - адрес области BAT-файлов.
                                            ; R1 - адрес FCB стандартного устройства ввода.
                                            ; R2 - адрес FCB стандартного устройства вывода.
                mov     R0, -(SP)           ; адрес области BAT-файлов.
                tst     (R0)+               ; первое слово - уровень вложенности ( 0 - область пуста).
                .addr   R1, AUTOEX
                mov     R0, R4
                iot
                .word 51                    ; Произвести синтаксический разбор строки.
                                            ; вход: R1-адрес обрабатываемой строки.
                                            ;       R4-адрес формируемого FCB-блока.
                                            ;       R2-тип разбора:если 0,то обычный разбор.
                                            ;          если не 0,то если встретится первым код 0,
                                            ;          FCB  примет вид:_???????????
                                            ; выход: R2-количество символов '?'.
                iot
                .word 17                    ; Открыть файл методом FCB.
                                            ; вход: R4-адрес FCB.
                mov     (SP)+, R0           ; адрес области BAT-файлов.
                bcs     10$
                mov     #1, (R0)            ; изменим уровень вложенности
10$:            iot
                .word 0                     ; Завершение программы пользователя.
                                            ; Управление передаётся в DOS, вызывается оболочка имя которой
                                            ; записано в переменной COMSPEC

6$:             .addr   R1, MISSAE          ; "Missing command interpreter,\n\rsystem halted."
                iot
                .word 11                    ; Вывод строки символов на устройство вывода (по умолчанию - консоль).
                                            ; вход: R1-адрес строки символов. (Строка должна оканчиваться нулевым байтом)
                iot
                .word 15                    ; Инициализировать драйвер (контроллер) дисковода.
                .addr   R0, HLT4ST
                mov     R0, @#4
HLT4ST:         br      HLT4ST              ; и всё. полный стоп. !!! сделать выход в монитор БК

; ───────────────────────────────────────────────────────────────────────────
AUTOEX:         .asciz   "AUTOEXEC.BAT"
MISSAE:         .ascii "Missing command interpreter,"<12><15>
                .asciz "system halted."
                .even
; -------начало FCB
FCBCMD:         .byte    0              ; номер дисковода: 0-текущий,1-'А',2-'В'...
                .ascii   "COMMAND COM"  ; имя файла + суффикс файла
                .blkb    FCB$SZ-F$MDRV  ; всё остальное
; -------конец FCB
RUNBLE:         ; конец блока запускателя.

; ══════ядро DOS═════════════════════════════════════════════════════════════
; сперва идёт одноразовый код, который потом затирается буферами.
; !!! У меня есть подозрение, что код затирается значениями буферов и не доходит до конца.
; !!! Пока всё нормально.
BGKRNL:         call    INIIOT              ; инициализируем вектор IOT и в R3 адрес буфера внутрисистемной информации
                movb    @#BKTYPE, S$BRDT(R3) ; тип машины 0-БК0010, 1-БК0011М, 2-БК0011.
                .addr   R0, EMTTRP
                mov     R0, V30NEW
                add     #SYSOFS-EMTTRP, R0
                mov     #/IOTTEN-/SYSOFS, R1
1$:             mov     R0, R2              ; в таблице смещений
                add     (R0), R2            ; все смещения преобразуем в
                mov     R2, (R0)+           ; абсолютные адреса
                sob     R1, 1$
                mov     @#30, V30OLD        ; сохраним старый вектор емт диспетчера
                mov     @#HIRAML, S$HRAM(R3) ; верхний адрес пользовательского ОЗУ.
                mov     #177714, S$PPAD(R3) ; адрес параллельного порта
                movb    #-1, S$ER52(R3)     ; номер прошлой ошибки в ячейке 52
                mov     #20041, S$DATE(R3)  ; текущая дата
                .addr   R1, OUTDOS
                mov     R1, S$EXSY(R3)      ; адрес функции выхода в DOS
                mov     @#PRNSTB, S$STBP(R3) ; значение стробирующего бита для принтера
                movb    @#BKMONT, S$MONT(R3) ; тип монитора 0-БК0010,1-БК0011М,2-БК0011.
                .addr   R0, BUFERS          ; адрес конца участка, выделенного под буферы
                mov     #DOSASZ, R1         ; длина области окружения DOS
                mov     R1, S$DOSZ(R3)      ; длина области окружения DOS
2$:             clrb    -(R0)
                sob     R1, 2$              ; R0=BUFERS-120
                clr     -(R0)               ; первое слово не входит в длину.
                mov     R0, S$DOSA(R3)      ; адрес начала области окружения DOS. R0=BUFERS-122
                mov     #CMDLSZ, R1
                mov     R1, S$CMLS(R3)      ; длина буфера командной строки
3$:             clrb    -(R0)
                sob     R1, 3$              ; R0=BUFERS-262
                clr     -(R0)               ; первое слово не входит в длину.
                mov     R0, S$CMLA(R3)      ; адрес буфера командной строки. R0=BUFERS-264
                mov     #NBE36L, R1
                sub     R1, R0              ; R0=BUFERS-364
                mov     R0, S$BE36(R3)      ; адрес буфера копии имени в перехватчике emt36 (NBE36L байтов)
                mov     R1, S$LE36(R3)      ; размер буфера копии имени в перехватчике emt36 (NBE36L байтов)
                sub     #BAT$SZ, R0         ; длина области BAT файлов
                mov     R0, S$BTFA(R3)      ; адрес области BAT файлов. R0=BUFERS-600
                sub     #14, R0
                mov     R0, S$NMBF(R3)      ; адрес буфера длиной 14 байтов имени для поиска. R0=BUFERS-614
                sub     #70, R0
                mov     R0, S$FWBF(R3)      ; адрес рабочей области драйвера дисковода (длина 70 байтов, реальная - 66 байтов). R0=BUFERS-704
                clr     -(R0)
                mov     R0, S$BINA(R3)      ; адрес буфера устройства ввода, длиной 2 байта. R0=BUFERS-706
                clr     -(R0)
                mov     R0, S$BOUA(R3)      ; адрес буфера устройства вывода, длиной 2 байта. R0=BUFERS-710
                sub     #1000, R0           ; R0=BUFERS-1710
                                            ; вот в этом месте мы уже попадаем на участок кода, который уже
                                            ; выполнился, так что можем спокойно его затирать
                mov     R0, S$BIOA(R3)      ; адрес области обмена с диском (адрес чтения/записи физического сектора) изменяемый
                mov     R0, S$SIOA(R3)      ; адрес области обмена с диском (адрес чтения/записи физического сектора) не изменяемый
                movb    @#SYSDRV, S$CRDN(R3) ; номер текущего устройства прямого доступа (дисковода).
                decb    S$CRDN(R3)
                movb    @#DRVCNT, R5
                movb    R5, S$FLPN(R3)      ; количество дисководов в системе.
                movb    R5, S$DRVN(R3)      ; количество устройств прямого доступа в системе.
                cmpb    #1, R5              ; в системе больше одного дисковода?
                blo     4$                  ; да
                mov     @#DRVSTT, @#DRVSTT+2 ; а если только один
                movb    #2, S$DRVN(R3)      ; немного поправим переменные
                movb    #1, S$ONED(R3)      ; Укажем, что в системе всего один дисковод - A:
4$:             mov     R0, -(SP)           ; адрес области обмена с диском
                .addr   R4, IOTTBL
                mov     R4, S$IOTA(R3)      ; адрес таблицы подпрограмм IOT диспетчера
                add     #DEVFCB-IOTTBL, R4
                mov     R4, S$TFCB(R3)      ; адрес буфера FCB под параметры устройства и промежуточных данных.
                add     #STDNAM-DEVFCB, R4
                mov     R4, S$SDNM(R3)      ; адрес списка имён символьных устройств.
                add     #SYSOFS-STDNAM, R4
                mov     R4, S$SDJA(R3)      ; адрес таблицы переходов для символьных устройств.
                add     #DSKERR-SYSOFS, R4 
                mov     R4, S$ERMA(R3)      ; адрес таблицы символьных сообщений об ошибке
                add     #FCBIN-DSKERR, R4
                mov     R4, S$FCIA(R3)      ; адрес FCB стандартного устройства ввода
                iot
                .word 26                    ; Создать файл. вход: R4-адрес FCB.
                add     #FCBOUT-FCBIN, R4
                mov     R4, S$FCOA(R3)      ; адрес FCB стандартного устройства вывода
                iot
                .word 26                    ; Создать файл. вход: R4-адрес FCB.
                movb    @#SYSDRV, R5
                add     #100, R5            ; делаем из номера привода букву
                .addr   R1, CMDCOM
                movb    R5, 10(R1)          ; поместим букву на её место. "COMSPEC=A:COMMAND.COM"
                iot
                .word 70                    ; Записать переменную в область окружения DOS. вход: R1-адрес строки.
                mov     (SP)+, R0           ; адрес области обмена с диском
                mov     #50, R1             ; максимальный номер ЕМТ команды для БК10 (так то их 110, включая зарезервированные)
                movb    S$MONT(R3), R5      ; какой у нас монитор?
                beq     5$                  ; БК10
                mov     #130, R1            ; максимальный номер ЕМТ команды для БК11
                dec     R5                  ; БК11
                bne     5$                  ; да
                inc     R1                  ; максимальный номер ЕМТ команды для БК11М
                mov     R1, R5
                br      6$

5$:             mov     R1, R5
                asr     R5                  ; у БК10 и БК11 емты только чётные
6$:             mov     R1, S$EMCN(R3)      ; максимальный номер ЕМТ команды
61$:            clr     -(R0)
                sob     R5, 61$             ; R0=BUFERS-1700-[50|132|264] == BUFFERS-2174
                clr     -(R0)
                mov     R0, S$CEMB(R3)      ; адрес буфера перехвата ЕМТ команд, для монитора БК11 * 2. R0=BUFERS-2174
                mov     #4, R1              
                mov     R1, R2              
7$:             mov     #160004, -(R0)      ; сформируем таблицу подпрограмм чтения логического блока с устройства
                sob     R1, 7$              ; для всех 4х устройств. R0=BUFERS-2204
                mov     R0, S$RSFA(R3)      ; адрес таблицы подпр.чтения логического блока с устройства
                .addr   R5, SECTRD          ; сформируем таблицу подпрограмм чтения секторов на логическом уровне
8$:             mov     R5, -(R0)           ; для всех 4х устройств
                sob     R2, 8$              ; R0=BUFERS-2214
                mov     R0, S$RSLA(R3)      ; адрес таблицы подпр.чтения секторов на логическом уровне.(на уровне DOS)
                mov     #AFATTB, R4
                mov     R4, R2
                movb    S$DRVN(R3), R1      ; возьмём количество устройств прямого доступа системе.
9$:             sub     #1002, R0           ; и сформируем таблицу адресов буферов под ФАТ
                mov     R0, (R4)+
                sob     R1, 9$              ; R0=BUFERS-2214-1002*n, при n==4 R0=BUFERS-6224
                sub     #10, R0             ; R0=BUFERS-6234
                mov     R0, S$DBLA(R3)      ; адрес списка дисковых блоков (макс. 4 устройства прямого доступа)
                mov     R0, R5
                movb    S$DRVN(R3), R1
11$:            mov     #PDB$SZ, R4         ; сформируем дисковые блоки
10$:            clrb    -(R0)
                sob     R4, 10$
                mov     R0, (R5)+
                movb    DRVSTT-AFATTB(R2), P$PDRV(R0) ; статус дисковода из таблицы статусов
                mov     (R2)+, P$AFAT(R0)   ; адрес буфера под ФАТ
                sob     R1, 11$             ; R0=BUFERS-6234-54*n, при n==4 R0=BUFERS-6514
                mov     R0, S$PDOS(R3)      ; вот наш адрес начала ДОС, тут начинаются всяческие буферы
; ───────────────────────────────────────────────────────────────────────────
                .addr   R0, INNERSTACK
                mov     R0, S$ISSP(R3)      ; вершина внутрисистемного указателя стека для перехватчика emt 36
                mov     R3, -(SP)
                mov     S$FWBF(R3), R3      ; адрес рабочей области драйвера дисковода (длина 70 байтов).
                call    @#160010            ; инициализируем рабочую область драйвера дисковода
                mov     #1600, D$TSTEP(R3)  ; задержка перехода с дорожки на дорожку
                mov     #10., D$MAXSEC(R3)  ; число секторов по умолчанию
                mov     (SP)+, R3
                mov     S$EXSY(R3), @#4     ; адрес функции выхода в ДОС
                .addr   R1, EMT14$
                mov     #14, R0
                iot
                .word 37                    ; Перехват EMT. вход: R0-номер EMT, R1-абсолютный адрес программы обработки данного EMT.
                .addr   R1, EMT36$
                mov     #36, R0
                iot
                .word 37                    ; Перехват EMT. вход: R0-номер EMT, R1-абсолютный адрес программы обработки данного EMT.
                jmp     @#TOPSTACK          ; всё, инициализацию провели, теперь исполнение полезной части
; конец одноразового кода
; ───────────────────────────────────────────────────────────────────────────
CMDCOM:         .asciz "COMSPEC=A:COMMAND.COM"
                .org   CMDCOM + 1000
BUFERS: ; ниже адреса этой метки размещаются рабочие буферы. максимальный размер буферов 6520 байтов.
; это при условии БК11М и 4 устройства прямого доступа в наличии.
; ═══════════════════════════════════════════════════════════════════════════
; буфер внутрисистемной информации и внутрисистемный стек (начиная от COMSPK-2 и выше, размером макс. 156 байтов)
SYSBUF:         .blkb   S$BLSZ
                .blkb   160 ; размер внутреннего стека
INNERSTACK:     ; внутренний стек
; ───────────────────────────────────────────────────────────────────────────
FCBOUT:         .byte    0
                .ascii   "CON        "
                .blkb    FCB$SZ-F$MDRV
; ───────────────────────────────────────────────────────────────────────────
FCBIN:          .byte    0
                .ascii   "CON        "
                .blkb    FCB$SZ-F$MDRV
; ───────────────────────────────────────────────────────────────────────────
DEVFCB:         .blkb    FCB$SZ         ; буфер под параметры устройства (наверно под стандартные)
; ───────────────────────────────────────────────────────────────────────────
COMSPK:         .asciz "COMSPEC="
                .even

V30OLD:         .word 0
V30NEW:         .word 0
; далее, чем код компактнее, тем лучше.
; ═══════════════════════════════════════════════════════════════════════════
; функция выхода в ДОС
OUTDOS:         iot
                .word 0

; ═══════════════════════════════════════════════════════════════════════════

OUTCHR:         emt     16
                return

; ═══════════════════════════════════════════════════════════════════════════

INPCHR:         emt     6
                return

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 0(0).
; Завершение программы пользователя.
; Управление передаётся в DOS, вызывается оболочка имя которой
; записано в переменной COMSPEC
FIOT00:         mov     #TOPSTACK, SP
                mov     V30NEW, @#30
                mov     S$FCOA(R3), R4  ; адрес FCB стандартного устройства вывода
                iot
                .word 20                ; Закрыть файл. вход: R4-адрес FCB.
                mov     S$FCIA(R3), R4  ; адрес FCB стандартного устройства ввода
                iot
                .word 20                ; Закрыть файл. вход: R4-адрес FCB.
                call    SETALD          ; инициализация всех буферов приводов
                call    CRCCHK          ; выход: R0 - адрес загрузки файла
                                        ;        R1 - размер файла
                                        ;        R5 - CRC файла
                cmp     S$FCRC(R3), R5  ; командная оболочка на месте и не повреждена?
                beq     2$              ; да, сразу идём запускать её
                .addr   R1, COMSPK
                iot
                .word 67                ; Получить переменную из области окружения DOS.
                                        ; вход:  R1-адрес имени переменной.
                                        ; выход: R2-указывает на значение переменной в окружении DOS.
                                        ;        R0-указывает на имя переменной в области окружения DOS.
                                        ;        если переменной нет, то С=1 и R2-указывает на свободную
                                        ;        строку в области окружения DOS.
                bcs     1$
                mov     R2, R1          ; значение переменной в окружении DOS
                clr     R2
                mov     S$TFCB(R3), R4  ; адрес буфера FCB под параметры устройства и промежуточных данных.
                iot
                .word 51                ; Произвести синтаксический разбор строки.
                                        ; вход: R1-адрес обрабатываемой строки.
                                        ;       R4-адрес формируемого FCB-блока.
                                        ;       R2-тип разбора:если 0, то обычный разбор.
                                        ;          если не 0,то если встретится первым код 0,
                                        ;          FCB  примет вид:_???????????
                                        ; выход: R2-количество символов '?'.
                bcs     1$
                iot
                .word 17                ; Открыть файл методом FCB. вход: R4-адрес FCB.
                mov     S$HRAM(R3), R0  ; верхний адрес пользовательского ОЗУ.
                mov     F$FLSZ(R4), R5  ; размер файла в байтах. (используем младшую часть)
                mov     R5, F$RCSZ(R4)  ; размер записи в байтах.
                mov     R5, S$FSZE(R3)  ; буфер размера файла
                sub     R5, R0          ; получим адрес начала файла
                mov     R0, F$DTAD(R4)  ; адрес обмена
                mov     R0, S$FADR(R3)  ; буфер адреса загрузки командной оболочки
                iot
                .word 41                ; Прямой доступ, чтение.
                                        ; вход: R4-адрес FCB.
                                        ; выход: R0-сколько байт считано.
                                        ; Поля FCB не изменяются.
                bcs     1$
                iot
                .word 20                ; Закрыть файл. вход: R4-адрес FCB.
                bcs     1$
                iot
                .word 15                ; Инициализировать драйвер (контроллер) дисковода.
                call    CRCCHK          ; выход: R0 - адрес загрузки файла
                                        ;        R1 - размер файла
                                        ;        R5 - CRC файла
                mov     R5, S$FCRC(R3)  ; сохраняем
2$:             jmp     (R0)            ; и идём выполнять.

1$:             mov     V30OLD, @#30
AE14$1:         emt     14
                jmp     @#160000

; ═══════════════════════════════════════════════════════════════════════════
; выход: R0 - адрес загрузки файла
;        R1 - размер файла
;        R5 - CRC файла
CRCCHK:         clr     R5
                mov     S$FSZE(R3), R1  ; буфер размера файла в байтах
                beq     2$
                mov     S$FADR(R3), R0  ; буфер адреса загрузки командной оболочки
                beq     2$
                mov     R0, -(SP)
                mov     R1, R2
                asr     R2              ; размер в словах
1$:             add     (R0)+, R5       ; считаем CRC
                adc     R5
                sob     R2, 1$
                mov     (SP)+, R0
                return

2$:             com     R5              ; при неудаче CRC == -1
                return

; ═══════════════════════════════════════════════════════════════════════════
; увеличиваем счётчик открытых файлов для заданного устройства
; вход:  R4 - FCB
; выход: R5 - PDB текущего устройства
;        С - какая-либо ошибка
INCOPN:         call    FFLUSH          ; сброс текущего буфера на диск
                                        ; выход: С - не удалось записать
                                        ; портит R0, R2
                bcs     1$
                call    SDRFCB          ; задать текущим устройство, которое указано в FCB
                                        ; вход:  R4 - адрес FCB
                                        ; выход: R5 - адрес параметров устройства
                                        ;        R0 - текущее устройство
                                        ;        C - ошибка
                bcs     1$
                tst     P$FLCT(R5)      ; счётчик открытых файлов для этого устройства
                bne     2$              ; если есть открытые файлы, то просто увеличим счётчик
                call    PARLS$          ; Получить параметры устройства, номер которого задан в R0
                bcs     1$
2$:             inc     P$FLCT(R5)      ; увеличиваем счётчик
1$:             return

; ═══════════════════════════════════════════════════════════════════════════
; уменьшаем счётчик открытых файлов для заданного устройства
; вход:  R4 - FCB
; выход: R5 - PDB текущего устройства
; флаги не изменяются
DECOPN:         mfps    (R3)            ; сохраним флаги PSW
                call    SDRFCB          ; задать текущим устройство, которое указано в FCB
                                        ; вход:  R4 - адрес FCB
                                        ; выход: R5 - адрес параметров устройства
                                        ;        R0 - текущее устройство
                                        ;        C - ошибка
                tst     P$FLCT(R5)      ; счётчик открытых файлов для этого устройства
                beq     1$              ; если открытых файлов нет, то выйдем
                dec     P$FLCT(R5)      ; иначе, уменьшим счётчик открытых файлов
1$:             mtps    (R3)            ; восстановим флаги PSW
                return

; ═══════════════════════════════════════════════════════════════════════════
; сброс текущего буфера на диск
; выход: С - не удалось записать
; портит R0, R2
FFLUSH:         ccc     ; сюда можно попасть, когда бит С установлен, и начинаются проблемы
                mov     R1, -(SP)
                mov     S$CSNW(R3), R1  ; номер сектора в буфере, который надо сохранить
                beq     1$              ; 0 - ничего сохранять не надо
                movb    S$FLUF(R3), R0  ; сохранять надо?
                beq     1$              ; не надо
                ; надо
                mov     S$BIOA(R3), R2  ; адрес области обмена с диском (адрес чтения/записи физического сектора), который можно изменить пользователем
                clr     S$CSNW(R3)
                clrb    S$FLUF(R3)      ; сбросим флаг
                clrb    S$DNSB(R3)      ; номер устройства, сектор которого в буфере чтения/записи
                iot
                .word 55                ; Абсолютно записать логический блок.
                                        ; вход: R0 - номер дисковода (1-дисковод "А"...)
                                        ;       R1 - номер логического блока.
                                        ;       R2 - адрес загрузки.
                                        ; Для нормальной работы область параметров данного устройства должна быть заполненной.
1$:             mov     (SP)+, R1
                return


; ═══════════════════════════════════════════════════════════════════════════
; вычисление нужного номера блока в кластере, который будет обработан
; изменяются F$CWCL(R4), корректируются S$SCLC(R3) и S$BIOO(R3)
; вход: R0 - номер кластера
;       R4 - FCB, R5 - PDB
; выход: R0 - номер блока в кластере
CL2SEC:         mov     R0, F$CWCL(R4)  ; сохраняем номер кластера
                sub     #2, R0          ; от номера кластера отнимем 2
                clr     R1
                movb    P$CLSZ(R5), R2  ; количество блоков в кластере
                call    MULTIP          ; R1:R0 = R1:R0 * R2
                add     P$ENDS(R5), R0  ; конечный сектор каталога
1$:             cmp     S$BIOO(R3), (R5) ; смещение в буфере меньше размера сектора в байтах?
                blo     0OK$            ; да, все в норме
                inc     R0              ; иначе увеличим номер сектора
                incb    S$SCLC(R3)      ; и счётчик секторов в кластере
                sub     (R5), S$BIOO(R3) ; скорректируем смещение, т.к. размер буфера == сектору, а не кластеру
                br      1$              ; и проверим, а теперь влазим? (алгоритм рассчитан на любой размер кластера)

; ═══════════════════════════════════════════════════════════════════════════
; вычисление нужного кластера по номеру записи, а заодно и положение указателя в файле
; вход:  R4 - FCB
; выход: R0 - смещение в кластере
;       C - ошибка, тогда результат не определён
SZ2CLU:         tstb    F$FOPN(R4)      ; файл открыт?
                bne     1$              ; да
                movb    #20, @#ERRFDD   ; нет - ошибка
                clr     R0
                br      LRC1$

1$:             tstb    F$IDEV(R4)      ; идентификатор устройства.
                bmi     2$              ; если стандартное - выход
                call    SDRFCB          ; задать текущим устройство, которое указано в FCB
                                        ; вход:  R4 - адрес FCB
                                        ; выход: R5 - адрес параметров устройства
                                        ;        R0 - текущее устройство
                                        ;        C - ошибка
                bcs     2$
                movb    #1, S$SCLC(R3)  ; установим счётчик секторов в кластере, счёт начинается с 1
                clr     S$BSCC(R3)      ; счётчик прочитанных/записанных байтов
                mov     F$DTAD(R4), S$MBPT(R3) ; зададим указатель в памяти на обрабатываемые данные
                mov     F$RECN(R4), R0  ; берём из FCB номер записи (для функций прямого доступа) мл.
                mov     F$RECN+2(R4), R1 ; ст.
                mov     F$RCSZ(R4), R2  ; берём из FCB размер записи в байтах.
                call    MULTIP          ; R1:R0 = R1:R0 * R2
                mov     R0, S$FPTR(R3)  ; получим положение указателя в файле в байтах, мл.
                mov     R1, S$FPTR+2(R3) ; ст.
                mov     P$CLBZ(R5), R2  ; размер кластера в байтах
                mov     R4, -(SP)
                call    DIVIDE          ; R4 = R1:R0 / R2, R0 = R1:R0 % R2
                mov     R0, S$BIOO(R3)  ; остаток - смещение в кластере
                mov     R4, S$NCLS(R3)  ; а это количество кластеров от начала файла до текущего указателя файла S$FPTR
                mov     (SP)+, R4
0OK$:           tst     (PC)+
LRC1$:          sec
2$:             return


; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 50(40).
; Записать несколько записей.
; вход:  R4 - адрес FCB.
;        R0 - количество записей.
; выход: R0 - сколько записей действительно записано.
;        C - ошибка
; Поле FCB "номер записи" модифицируется.
FIOT50:         mov     R3, (R3)        ; флаг записи
                mov     R0, -(SP)
                cmpb    S$FLUF(R3), (R4) ; буфер сохранить надо?
                beq     12240$          ; надо, но привод тот же, значит не надо пока
                br      12232$          ; привод изменился, сохранить буфер надо

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 47(39).
; Считать несколько записей.
; вход:  R4 - адрес FCB.
;        R0 - количество записей.
; выход: R0 - сколько записей действительно считано.
;        C - ошибка
; Поле FCB "номер записи" модифицируется.
FIOT47:         clr     (R3)            ; флаг чтения
                mov     R0, -(SP)
                ; перед чтением сохраним буфер
12232$:         call    FFLUSH          ; сброс текущего буфера на диск
                                        ; выход: С - не удалось записать
                                        ; портит R0, R2
                bcc     12240$          ; при ошибке - выход
3$:             mov     (SP)+, R0
                return

12240$:         call    SZ2CLU          ; вычисление нужного кластера по номеру записи, а заодно и положение указателя в файле
                                        ; вход:  R4 - FCB
                                        ; выход: R0 - смещение в кластере
                                        ;       C - ошибка, тогда результат не определён
                bcs     3$
                mov     (SP)+, R0
                mov     F$RCSZ(R4), R2  ; размер записи в байтах.
                beq     1$              ; если 0 - то ошибка
                mov     R2, -(SP)
                clr     R1
                call    MULTIP          ; R1:R0 = R1:R0 * R2
                tst     R1              ; если результат влазит в 16 бит
                beq     2$              ; то норма
                mov     (SP)+, R2
1$:             movb    #36, @#ERRFDD   ; иначе - ошибка
                br      LRC1$

2$:             mov     R0, F$RCSZ(R4)  ; размер записи в байтах подменяем размером, который надо прочитать
                call    DAD$            ; подпрограмма реализации прямого доступа к диску
                mfps    (R3)
                mov     (SP)+, R2
                mov     R2, F$RCSZ(R4)  ; восстанавливаем размер записи в байтах.
                clr     R1
                mov     R4, -(SP)
                call    DIVIDE          ; R4 = R1:R0 / R2, R0 = R1:R0 % R2
                mov     R4, R0          ; сколько целых записей прочиталось
                mov     (SP)+, R4
                add     R0, F$RECN(R4)  ; изменяем номер записи (для функций прямого доступа)
                adc     F$RECN+2(R4)
                mtps    (R3)
LR2$:           return

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 41(33).
; Прямой доступ,чтение.
; вход:  R4 - адрес FCB.
; выход: R0 - сколько байт считано.
; Поля FCB не изменяются.
FIOT41:         clr     (R3)            ; флаг чтения
                br      12372$

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 42(34).
; Прямой доступ,запись.
; вход:  R4 - адрес FCB.
; выход: R0 - сколько байт записано.
; Поля FCB не изменяются.
FIOT42:         mov     R3, (R3)        ; флаг записи
                cmpb    S$FLUF(R3), (R4) ; буфер сохранить надо?
                beq     1$              ; надо, но привод тот же, значит не надо пока
                ; привод изменился, сохранить буфер надо
12372$:         call    FFLUSH          ; сперва сбросим данные на диск
                                        ; выход: С - не удалось записать
                                        ; портит R0, R2
                bcs     LR2$
1$:             call    SZ2CLU          ; вычисление нужного кластера по номеру записи,
                                        ; а заодно и положение указателя в файле,
                                        ; там же вычисляется S$NCLS(R3)
                                        ; вход:  R4 - FCB
                                        ; выход: R0 - смещение в кластере
                                        ;       C - ошибка, тогда результат не определён
                bcs     LR2$

; вход: R4-адрес FCB.
DAD$:           clr     R0
                bisb    F$IDEV(R4), R0  ; идентификатор устройства.
                cmpb    R0, #373        ; это символьное устройство?
                blo     1$              ; нет
                sub     #373, R0        ; да - получим его номер
                asl     R0
                add     S$SDJA(R3), R0  ; адрес таблицы переходов для символьных устройств.
                jmp     @(R0)+          ; перейдём к п/п его обработки

1$:             mov     S$NCLS(R3), R2  ; расстояние в кластерах от начала файла до текущего указателя файла S$FPTR
                tst     (R3)            ; что делаем
                bne     WRITE$          ; пишем
                ; читаем
; вход  R2 - расстояние в кластерах от начала файла до текущего указателя файла S$FPTR
READ$:          tst     F$CWCL(R4)      ; текущий обрабатываемый кластер задан?
                bne     2$              ; да, значит продолжаем
                mov     F$STCL(R4), F$CWCL(R4) ; нет - значит текущим станет начальный
2$:             cmp     F$NWCL(R4), R2  ; счётчик обрабатываемых кластеров
                beq     3$              ; равен кластеру, соответствующему указателю
                blo     0GoForward$     ; меньше - надо продвинуться вперёд
                clr     F$CWCL(R4)      ; больше - надо вернуться назад
                clr     F$NWCL(R4)      ; т.е. будем двигаться вперёд от начала файла
                br      READ$           ; и начнём с начала файла
                ; счётчик обрабатываемых кластеров равен кластеру, соответствующему указателю
                ; значит никуда перемещаться не надо и мы на месте
3$:             mov     F$CWCL(R4), R0  ; берём текущий кластер
                br      0Calc$          ; и идём дальше

0GoForward$:    sub     F$NWCL(R4), R2  ; на сколько кластеров надо продвинуться
0NextCluster$:  mov     F$CWCL(R4), R0  ; это текущий обрабатываемый кластер
                ; перемещаемся от текущей позиции, к новой по цепочке ФАТ
0LoopForw$:     mov     R2, -(SP)
                call    GETFAT          ; получить содержимое ячейки ФАТ
                                        ; вход:  R0 - номер ячейки
                                        ; выход: R1 - содержимое ячейки
                mov     (SP)+, R2
                bcs     0FatalErr$
                inc     F$NWCL(R4)      ; увеличим счётчик обрабатываемых кластеров
                tst     R1              ; что за кластер, не пустой?
                bne     8$              ; нет
                movb    #34, @#ERRFDD   ; пустой - ошибка обрыв цепочки кластеров
                mov     #6, R1
                jmp     ERROUT

8$:             cmp     #7770, R1       ; последний? !!! для фат16 тут будет другое число
                blo     0BoundErr$      ; да - попытка чтения за концом файла, ошибка
                mov     R1, R0          ; нет - его обработаем
                sob     R2, 0LoopForw$  ; и так, пока не дойдём до нужного места
                ; всё, переместились куда надо.
0Calc$:         call    CL2SEC          ; вычисление нужного номера блока в кластере, который будет обработан
                                        ; изменяются F$CWCL(R4), корректируются S$SCLC(R3) и S$BIOO(R3)
                                        ; вход: R0 - номер кластера
                                        ;       R4 - FCB, R5 - PDB
                                        ; выход: R0 - номер блока в кластере
0WorkClust$:    mov     S$BIOA(R3), R2  ; адрес области обмена с диском
                cmpb    S$DNSB(R3), (R4) ; устройство совпадает с тем, откуда читаем/пишем?
                beq     0NoChgDev$      ; да
                movb    (R4), S$DNSB(R3) ; нет - запомним новое устройство
                br      0ReadNew$       ; и номер сектора, и прочитаем его в буфер

0NoChgDev$:     cmp     S$CSNB(R3), R0  ; номер сектора совпадает с тем, что в буфере?
                beq     0NoRead$        ; да, незачем повторно читать тот же самый сектор
                ; нет - прочитаем нужный сектор
0ReadNew$:      mov     R0, S$CSNB(R3)  ; буфер номера сектора
                mov     R0, R1          ; номер сектора
                movb    (R4), R0        ; номер дисковода
                iot
                .word 54                ; Абсолютно считать логический блок.
                                        ; вход: R0 - номер дисковода (1-дисковод "А"...)
                                        ;       R1 - номер логического блока.
                                        ;       R2 - адрес загрузки.
                                        ; Для нормальной работы область параметров данного устройства должна быть заполненной.
                bcs     0FatalErr$

0NoRead$:       mov     R2, R1          ; адрес загрузки
                add     (R5), R2        ; прибавим размер сектора в байтах, получим адрес конца буфера
                mov     S$MBPT(R3), R0  ; указатель в памяти на обрабатываемые данные
                add     S$BIOO(R3), R1  ; адрес начала нужной записи в буфере
0LoopBuf$:      movb    (R1)+, (R0)+    ; копируем байт из буфера на место
                inc     S$BSCC(R3)      ; увеличиваем счётчик прочитанных/записанных байтов
                add     #1, S$FPTR(R3)  ; сдвигаем указатель на одну позицию
                adc     S$FPTR+2(R3)
                cmp     S$BSCC(R3), F$RCSZ(R4) ; уже прочитали сколько надо?
                bhis    0OkExit$        ; да - выходим из функции
                cmp     S$FPTR+2(R3), F$FLSZ+2(R4) ; за пределы файла ещё не вышли?
                blo     14$
                bhi     0BoundErr$
                cmp     S$FPTR(R3), F$FLSZ(R4)
                bhis    0BoundErr$      ; да - вышли
14$:            cmp     R1, R2          ; буфер закончился?
                blo     0LoopBuf$       ; нет ещё - продолжаем
                ; надо читать следующий сектор или даже кластер
                mov     R0, S$MBPT(R3)  ; сдвигаем указатель в памяти на обрабатываемые данные
                clr     S$BIOO(R3)      ; чистим смещение в буфере текущего сектора чтения
                cmpb    S$SCLC(R3), P$CLSZ(R5) ; счётчик блоков в кластере достиг количества блоков в кластере?
                bhis    0Next$          ; да
                mov     S$CSNB(R3), R0  ; а если нет - номер сектора, который находится в буфере чтения
                inc     R0              ; следующий сектор
                incb    S$SCLC(R3)      ; увеличим счётчик секторов в кластере
                br      0WorkClust$     ; продолжим обработку кластера
                ; переходим к следующему кластеру
0Next$:         mov     #1, R2          ; на сколько кластеров продвигаемся вперёд
                movb    R2, S$SCLC(R3)  ; инициализируем счётчик секторов в кластере
                br      0NextCluster$   ; и пойдём продвигаться
                ; штатный выход
0OkExit$:       mov     S$BSCC(R3), R0  ; счётчик прочитанных/записанных байтов
                clc
                return
                ; ошибка выхода за пределы файла
0BoundErr$:     movb    #26, @#ERRFDD
                mov     S$BSCC(R3), R0  ; сколько байтов прочитали?
                beq     0FatalErr$      ; 0 - ошибка 26
                movb    #27, @#ERRFDD   ; !0 - ошибка 27
0FatalErr$:     sec
                return
; ───────────────────────────────────────────────────────────────────────────
; вход  R2 - расстояние в кластерах от начала файла до текущего указателя файла S$FPTR
WRITE$:         movb    #1, F$FWRT(R4)  ; установим признак, что была запись.
                tst     F$STCL(R4)      ; начальный кластер уже задан?
                bne     1$              ; файл уже есть, т.е. продолжаем запись
                ; начального кластера нету, поэтому его нужно найти
                mov     R2, -(SP)
                call    FNDFCL          ; поиск свободного кластера
                                        ; вход:  R4 - адрес FCB
                                        ; выход: R0, P$LFCL(R5) - найденный свободный кластер
                bcs     2FatalErr$
                ; нашли, теперь сделаем его финальным
                mov     #7777, R1       ; !!!для фат16 тут будет другое число
                call    SETFAT          ; задать содержимое ячейки ФАТ
                                        ; вход: R0 - номер ячейки
                                        ;       R1 - содержимое ячейки
                bcs     2FatalErr$
                mov     (SP)+, R2
                ; и вот он, первый кластер нашего файла.
                mov     R0, F$STCL(R4)  ; теперь начальный кластер такой

1$:             tst     F$CWCL(R4)      ; текущий обрабатываемый кластер задан?
                bne     2$              ; да, подозрительно
                mov     F$STCL(R4), F$CWCL(R4) ; нет - значит будет начальный кластер текущим
2$:             cmp     F$NWCL(R4), R2  ; счётчик обрабатываемых кластеров 
                beq     3$              ; равен кластеру, соответствующему указателю
                blo     0GoForward$     ; меньше - надо продвинуться вперёд
                clr     F$CWCL(R4)      ; больше - надо вернуться назад
                clr     F$NWCL(R4)      ; т.е. будем двигаться вперёд от начала файла
                br      1$              ; и начнём с начала файла
                ; счётчик обрабатываемых кластеров равен кластеру, соответствующему указателю
                ; значит никуда перемещаться не надо и мы на месте
3$:             mov     F$CWCL(R4), R0  ; берём текущий кластер
                br      0Calc$          ; и идём дальше

0GoForward$:    sub     F$NWCL(R4), R2  ; на сколько кластеров надо продвинуться
0NextCluster$:  mov     F$CWCL(R4), R0  ; это текущий обрабатываемый кластер
                ; перемещаемся от текущей позиции, к новой по цепочке ФАТ
0LoopForw$:     mov     R2, -(SP)
                call    GETFAT          ; получить содержимое ячейки ФАТ
                                        ; вход:  R0 - номер ячейки
                                        ; выход: R1 - содержимое ячейки
                mov     (SP)+, R2
                bcs     0FatalErr$
                inc     F$NWCL(R4)      ; увеличим счётчик обрабатываемых кластеров
                tst     R1              ; что за кластер, не пустой?
                beq     28$             ; да
                cmp     #7770, R1       ; или последний?  !!!для фат16 тут будет другое число
                bhis    29$             ; нет - движемся дальше
                ; если пусто или последний кластер,
                ; то пробуем выделить новый кластер
28$:            mov     R2, -(SP)
                mov     R0, -(SP)
                call    FNDFCL          ; поиск свободного кластера
                                        ; вход:  R4 - адрес FCB
                                        ; выход: R0, P$LFCL(R5) - найденный свободный кластер
                bcs     3FatalErr$
                ; нашли, добавим его в цепочку
                mov     R0, R1
                mov     (SP)+, R0
                call    SETFAT          ; задать содержимое ячейки ФАТ
                                        ; вход: R0 - номер ячейки
                                        ;       R1 - содержимое ячейки
                bcs     2FatalErr$
                ; и сделаем последним
                mov     R1, -(SP)
                mov     R1, R0
                mov     #7777, R1       ; !!!для фат16 тут будет другое число
                call    SETFAT          ; задать содержимое ячейки ФАТ
                                        ; вход: R0 - номер ячейки
                                        ;       R1 - содержимое ячейки
                mov     (SP)+, R1
                bcs     2FatalErr$
                mov     (SP)+, R2
29$:            mov     R1, R0          ; теперь он текущий
                sob     R2, 0LoopForw$         ; и так, пока не дойдём до нужного места
                ; всё, переместились куда надо.
0Calc$:         call    CL2SEC          ; вычисление нужного номера блока в кластере, который будет обработан
                                        ; изменяются F$CWCL(R4), корректируются S$SCLC(R3) и S$BIOO(R3)
                                        ; вход: R0 - номер кластера
                                        ;       R4 - FCB, R5 - PDB
                                        ; выход: R0 - номер блока в кластере
0WorkClust$:    mov     S$BIOA(R3), R2  ; адрес области обмена с диском
                tst     S$BIOO(R3)      ; смещение в буфере текущего сектора чтения есть?
                bne     33$             ; да, мы не в начале, и уже делали чтение
                mov     F$RCSZ(R4), R1  ; нет - инициализируем значения, размер записи в байтах
                sub     S$BSCC(R3), R1  ; счётчик прочитанных/записанных байтов
                cmp     R1, (R5)        ; осталось записать ещё больше сектора?
                bhis    0NoRead$        ; да
33$:            cmpb    S$DNSB(R3), (R4) ; нет, устройство совпадает с тем, откуда читаем/пишем?
                beq     0NoChgDev$      ; да
                movb    (R4), S$DNSB(R3) ; нет - запомним новое устройство
                br      0ReadNew$

3FatalErr$:     mov     (SP)+, R0
2FatalErr$:     mov     (SP)+, R2
0FatalErr$:     br      1FatalErr$

0NoChgDev$:     cmp     S$CSNB(R3), R0  ; номер сектора совпадает с тем, что в буфере?
                beq     0NoRead$        ; да, незачем повторно читать тот же самый сектор
                ; нет - прочитаем нужный сектор
0ReadNew$:      mov     R0, R1          ; номер сектора
                mov     R0, -(SP)       ; ещё и в стеке сохраним
                call    FFLUSH          ; сброс текущего буфера на диск
                                        ; выход: С - не удалось записать
                                        ; портит R0, R2
                ; на выходе из функции R2 = S$BIOA(R3) - адрес области обмена с диском
                bcs     37$
                movb    (R4), R0        ; номер дисковода
                movb    R0, S$DNSB(R3)  ; номер устройства, сектор которого в буфере чтения/записи
                iot
                .word 54                ; Абсолютно считать логический блок.
                                        ; вход: R0 - номер дисковода (1-дисковод "А"...)
                                        ;       R1 - номер логического блока.
                                        ;       R2 - адрес загрузки.
                                        ; Для нормальной работы область параметров данного устройства должна быть заполненной.
37$:            mov     (SP)+, R0       ; номер сектора
                bcs     1FatalErr$
0NoRead$:       mov     R0, S$CSNB(R3)  ; номер сектора, который находится в буфере чтения/записи
                mov     R0, S$CSNW(R3)  ; номер сектора в буфере, который надо сохранить
                movb    (R4), S$FLUF(R3) ; флаг необходимости операции сохранения сектора на диск == номеру привода
                mov     R2, R1          ; адрес загрузки
                add     (R5), R2        ; прибавим размер сектора в байтах, получим адрес конца буфера
                mov     S$MBPT(R3), R0  ; указатель в памяти на обрабатываемые данные
                add     S$BIOO(R3), R1  ; адрес начала нужной записи в буфере
0LoopBuf$:      movb    (R0)+, (R1)+    ; копируем сохраняемый байт в буфер
                inc     S$BSCC(R3)      ; увеличиваем счётчик прочитанных/записанных байтов
                add     #1, S$FPTR(R3)  ; сдвигаем указатель на одну позицию
                adc     S$FPTR+2(R3)
                cmp     S$BSCC(R3), F$RCSZ(R4) ; записали уже сколько надо?
                beq     0OkExit$        ; да - выходим из функции
                cmp     R1, R2          ; буфер закончился?
                blo     0LoopBuf$       ; нет ещё - продолжаем
                ; надо писать следующий сектор или даже кластер
                mov     R0, S$MBPT(R3)  ; изменяем указатель в памяти на обрабатываемые данные
                call    FFLUSH          ; сброс текущего буфера на диск
                                        ; выход: С - не удалось записать
                                        ; портит R0, R2
                bcs     1OkExit$
                clr     S$BIOO(R3)      ; чистим смещение в буфере текущего сектора чтения/записи
                cmpb    S$SCLC(R3), P$CLSZ(R5) ; счётчик блоков в кластере достиг количества блоков в кластере?
                bhis    0Next$             ; да
                mov     S$CSNB(R3), R0  ; а если нет - номер сектора, который находится в буфере чтения/записи
                inc     R0              ; следующий сектор
                incb    S$SCLC(R3)      ; увеличим счётчик секторов в кластере
                br      0WorkClust$     ; продолжим обработку кластера
                ; переходим к следующему кластеру
0Next$:         mov     #1, R2          ; на сколько кластеров продвигаемся вперёд
                movb    R2, S$SCLC(R3)  ; инициализируем счётчик секторов в кластере
                br      0NextCluster$   ; и пойдём продвигаться
                ; штатный выход
0OkExit$:       cmp     S$FPTR+2(R3), F$FLSZ+2(R4)   ; если вышли за конец файла
                blo     1OkExit$
                bhi     0CorrectLen$
                cmp     S$FPTR(R3), F$FLSZ(R4)
                blos    1OkExit$
0CorrectLen$:   mov     S$FPTR(R3), F$FLSZ(R4)  ; то скорректируем его длину
                mov     S$FPTR+2(R3), F$FLSZ+2(R4)
1OkExit$:       ccc
                br      2OkExit$
                ; выход с ошибкой
1FatalErr$:     cmpb    @#ERRFDD, #22
                bne     44$
                iot
                .word 20                    ; Закрыть файл.
                iot
                .word 23                    ; Удалить файл.
                movb    #22, @#ERRFDD
44$:            sec
2OkExit$:       mov     S$BSCC(R3), R0
                return


; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 20(16).
; Закрыть файл.
; вход: R4-адрес FCB.
FIOT20:         tstb    F$IDEV(R4)      ; какой идентификатор устройства?
                bmi     1$              ; стандартный
                tstb    F$FOPN(R4)      ; дисковод, а файл открыт?
                beq     2$              ; нет
                tstb    F$FWRT(R4)      ; да, открыт, запись в него была?
                beq     1$              ; нет
                mov     F$DIRP(R4), -(SP) ; да, была, положение имени файла в каталоге.
                iot
                .word 21                ; Найти первый файл по образцу.
                mov     (SP)+, R0
                bcs     4$
                cmp     F$DIRP(R4), R0  ; это тот файл что нам нужен?
                bne     5$              ; нет
                call    CHDREC          ; модифицируем запись в каталоге
                call    FlushFAT$
1$:             clrb    F$FWRT(R4)      ; сбрасываем признак записи и атрибуты файла
                clrb    F$FOPN(R4)      ; снимем признак открытого файла
4$:             jmp     DECOPN          ; уменьшаем счётчик открытых файлов для заданного устройства и выйдем
                                        ; вход:  R4 - FCB
                                        ; выход: R5 - PDB текущего устройства
                                        ; флаги не изменяются

2$:             movb    #20, @#ERRFDD   ; нет - ошибка 20
                br      FCRER$

5$:             movb    #23, @#ERRFDD   ; нет - ошибка 23
                br      FCRER$
; ───────────────────────────────────────────────────────────────────────────
FERR30:         movb    #30, @#ERRFDD
                br      FCRER$

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 26(22).
; Создать файл.
; (если файл существовал ,то размер его устанавливается равным 0).
; вход: R4-адрес FCB.
FIOT26:         call    CLRFCB          ; очистка FCB от всего лишнего
                call    GETDVN          ; получение номера устройства FCB и делание идентификатора устройства
                bcc     2$              ; в стандартных символьных устройствах создать файл нельзя
                call    CHKTPL          ; проверка на валидность имени файла
                                        ; вход:  R4 - адрес FCB.
                bcs     26Err$
                bne     FERR30
                call    INCOPN          ; увеличиваем счётчик открытых файлов для заданного устройства
                                        ; вход:  R4 - FCB
                                        ; выход: R5 - PDB текущего устройства
                                        ;        С - какая-либо ошибка
                bcs     26Err$
                call    DELFLN          ; удалить файл
                bcc     1$              ; если удалился - норма
                cmpb    @#ERRFDD, #25   ; если ошибка - конец каталога
                bne     FCRER$          ; то тоже норма, значит такого файла и не было, а иначе - что-то не так
1$:             mov     S$DATE(R3), F$FLDT(R4)  ; дата создания файла - текущая дата
                mov     S$DIRP(R3), F$DIRP(R4)  ; положение имени файла в каталоге.
                clr     S$CDSN(R3)
                call    CHDREC          ; изменить запись в каталоге
                bcs     26Err$
2$:             incb    F$FOPN(R4)      ; установка признака открытия файла
                tst     (PC)+
FCRER$:         sec
26Err$:         return
; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 17(15).
; Открыть файл методом FCB.
; вход: R4-адрес FCB.
FIOT17:         call    CHKTPL          ; проверка на валидность имени файла
                                        ; вход:  R4 - адрес FCB.
                bcs     17Err$
                bne     FERR30
                call    CLRFCB          ; очистка FCB от всего лишнего
                call    GETDVN          ; получение номера устройства FCB и делание идентификатора устройства
                bcc     2$              ; в стандартных символьных устройствах открыть файл нельзя
                call    INCOPN          ; увеличиваем счётчик открытых файлов для заданного устройства
                                        ; вход:  R4 - FCB
                                        ; выход: R5 - PDB текущего устройства
                                        ;        С - какая-либо ошибка
                bcs     17Err$
                iot
                .word 21                ; Найти первый файл по образцу.
                bcs     17Err$
                mov     R4, R5          ; FCB
                inc     R5              ; пропустим номер устройства
                mov     #13, R0
1$:             movb    (R1)+, (R5)+    ; скопируем в FCB имя файла
                sob     R0, 1$
                movb    (R1)+, F$ATTR(R4)   ; атрибуты
                                                ; !!!! Если менять структуру FCB, то тут надо будет корректировать всё
                mov     K$SIZE-14(R1), (R5)+    ; размер файла в байтах.    14
                mov     K$SIZE+2-14(R1), (R5)+  ;                           16
                inc     (R5)+                   ; размер записи в байтах.   20
                mov     K$DLWR-14(R1), (R5)+    ; дата создания файла.      22
                mov     K$TLWR-14(R1), (R5)+    ; адрес загрузки файла в память 24
                mov     K$CLNL-14(R1), (R5)+    ; начальный кластер.        26
                clr     (R5)+                   ; номер текущего блока      30
                clr     (R5)+
                mov     F$FLLD(R4), F$DTAD(R4)
2$:             incb    F$FOPN(R4)
17Err$:         return

; ═══════════════════════════════════════════════════════════════════════════
; Нерациональным способом сохраняем изменения в фат
FlushFAT$:      call    SDRFCB          ; задать текущим устройство, которое указано в FCB
                                        ; вход:  R4 - адрес FCB
                                        ; выход: R5 - адрес параметров устройства
                                        ;        R0 - текущее устройство
                                        ;        C - ошибка
                tst     P$FSCH(R5)      ; изменения в фат были?
                beq     1$              ; нет
                mov     #2, R0          ; получим первый кластер
                call    GETFAT          ; получить содержимое ячейки ФАТ
                                        ; вход:  R0 - номер ячейки
                                        ; выход: R1 - содержимое ячейки
                bcs     1$
                mov     #600, R0        ; получим 600й кластер. зачем? непонятно.
                                        ; !!! тут надо получать последний кластер 
                call    GETFAT          ; получить содержимое ячейки ФАТ
                                        ; вход:  R0 - номер ячейки
                                        ; выход: R1 - содержимое ячейки
1$:             return

; ═══════════════════════════════════════════════════════════════════════════
; чистим рабочие ячейки FCB. начиная со смещения F$MDRV и до конца
CLRFCB:         mov     R4, R5
                add     #F$MDRV, R5
                mov     #/FCB$SZ-/F$MDRV, R0
1$:             clr     (R5)+
                sob     R0, 1$
                return

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 25(21).
; Последовательная запись в файл.
; вход: R4-адрес FCB.
; После записи соответствующие поля FCB модифицируются.
FIOT25:         mov     (PC)+, (R3)     ; флаг запись
; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 24(20).
; Последовательное чтение из файла.
; вход: R4-адрес FCB.
; После чтения соответствующие поля FCB модифицируются.
FIOT24:         clr     (R3)            ; флаг чтение
                mov     F$RECN(R4), -(SP) ; номер записи (для функций прямого доступа)
                mov     F$RECN+2(R4), -(SP)
                iot
                .word 44                ; Задать позицию прямого доступа.
                tst     (R3)
                beq     1READ$
                iot
                .word 42                ; Прямой доступ, запись.
                                        ; вход:  R4 - адрес FCB.
                                        ; выход: R0 - сколько байт записано.
                                        ; Поля FCB не изменяются.
                br      2$

1READ$:         iot
                .word 41                ; Прямой доступ,чтение.
                                        ; вход:  R4 - адрес FCB.
                                        ; выход: R0 - сколько байт считано.
                                        ; Поля FCB не изменяются.
2$:             mov     (SP)+, F$RECN+2(R4)
                mov     (SP)+, F$RECN(R4)
                bcs     3$
                incb    F$CURR(R4)      ; текущая запись (последов.доступ к файлам)
                bpl     3$              ; если > 0, то норма (диапазон 0..0177, размер записи 200)
                clrb    F$CURR(R4)      ; иначе обнулим
                add     #1, F$CBLK(R4)  ; и перейдём к следующему блоку
                adc     F$CBLK+2(R4)
3$:             return

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 44(36).
; Задать позицию прямого доступа.
; Т.е. перейти от последовательного доступа к прямому доступу.
; Вычисляется номер записи по номеру блока и номеру записи
; при последовательном доступе.
; вход R4 - адрес FCB
FIOT44:         mov     F$CBLK(R4), R0  ; берём номер текущего блока
                mov     F$CBLK+2(R4), R1
                mov     #StdRecSize, R2 ; и умножаем его на 200, это из какой-то древней традиции,
                                        ; когда размер записи по умолчанию считается равным 200 байтов?
                call    MULTIP          ; R1:R0 = R1:R0 * R2
                mov     F$CURR(R4), R2  ; берём текущую запись
                add     R2, R0
                adc     R1
                mov     R0, F$RECN(R4)
                mov     R1, F$RECN+2(R4)
                return

; ═══════════════════════════════════════════════════════════════════════════
; получение номера устройства в FCB
; вход: R4 - FCB
; выход: R0 и F$IDEV(R4) - номер устройства
;       С=1 - обычное устройство
;       С=0 - задано символьное устройство
GETDVN:         call    CHKCUR      ; если задано текущее, то делаем из текущего реальное
                movb    (R4), R0    ; номер привода в FCB
                add     #100, R0
                movb    R0, F$IDEV(R4)  ; делаем из него идентификатор устройства
                mov     R4, R2
                inc     R2
                mov     S$SDNM(R3), R1  ; адрес списка имён символьных устройств
                call    STDNUM      ; получение номера стандартного устройства
                                    ; вход:  R1 - адрес таблицы
                                    ;        R2 - адрес имени устройства, номер которого получаем
                                    ; выход: R0 - номер устройства * 2
                                    ;        С - дошли до конца и совпадений не нашли, значит не стандартное
                bcs     1$
                ; если задано имя стандартного устройства, получим его номер
                asr     R0
                add     #373, R0
                movb    R0, F$IDEV(R4)
1$:             return

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 27(23).
; Переименовать файл.
; вход: R4-адрес модифицированного FCB.
;(Разрешается использовать символ групповой операции '?').
FIOT27:         call    GETDVN          ; получение номера устройства FCB и делание идентификатора устройства
                bcc     1ERR$           ; в стандартных символьных устройствах переименовать файл нельзя
                call    INCOPN          ; увеличиваем счётчик открытых файлов для заданного устройства
                                        ; вход:  R4 - FCB
                                        ; выход: R5 - PDB текущего устройства
                                        ;       С - какая-либо ошибка
                bcs     2ERR$
                clrb    S$TPLF(R3)      ; очистим признак, что имя задано шаблоном
                incb    S$RENF(R3)      ; устанавливаем флаг переименования
                iot
                .word 21                ; Найти первый файл по образцу.
                clrb    S$RENF(R3)      ; сбрасываем флаг переименования
                bcc     1ERR$
                cmpb    @#ERRFDD, #25
                bne     2ERR$
                cmp     #-1, R1
                beq     1ERR$
                iot
                .word 21                ; Найти первый файл по образцу.
                bcs     2ERR$
1$:             movb    (R4), S$DNSB(R3) ; номер устройства сектор которого в буфере
                mov     S$DSTW(R3), S$CDSN(R3) ; номер сектора каталога, который надо обработать -> номер обрабатываемого сектора каталога при удалении файла
                mov     #13, R0
                mov     R4, R2
                add     #F$MFNM, R2     ; подводим указатель к новому имени
2$:             cmpb    #'?, (R2)
                bne     3$
                incb    S$TPLF(R3)      ; установим признак, что имя задано шаблоном
                br      4$

3$:             movb    (R2), (R1)
4$:             inc     R2
                inc     R1
                sob     R0, 2$
                tstb    S$TPLF(R3)      ; был шаблон?
                beq     3ERR$           ; нет
                iot                     ; а если да -
                .word 22                ; Продолжить поиск файлов.
                bcc     1$
                cmpb    #25, @#ERRFDD
                beq     3ERR$
1ERR$:          movb    #33, @#ERRFDD
2ERR$:          br      4ERR$

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 23(19).
; Удалить файл.
; вход: R4-адрес FCB.
; (файл должен быть закрытым,допускается использовать символ
; групповой операции '?').
FIOT23:         call    GETDVN          ; получение номера устройства FCB и делание идентификатора устройства
                bcc     3LR$            ; в стандартных символьных устройствах удалить файл нельзя
                call    CHKTPL          ; проверка на валидность имени файла
                                        ; вход:  R4 - адрес FCB.
                bcs     4ERR$
                tstb    F$FOPN(R4)      ; файл открыт?
                beq     1$              ; нет
                movb    #37, @#ERRFDD   ; да - ошибка
                br      4ERR$

1$:             call    INCOPN          ; увеличиваем счётчик открытых файлов для заданного устройства
                                        ; вход:  R4 - FCB
                                        ; выход: R5 - PDB текущего устройства
                                        ;       С - какая-либо ошибка
                bcs     4ERR$
                call    DELFLN          ; удалить файл
                bcs     4ERR$
                call    FlushFAT$
3ERR$:          mov     S$CDSN(R3), R1  ; номер обрабатываемого сектора каталога при удалении файла
                beq     2$
                clr     S$CDSN(R3)      ; сектор почистим
                mov     S$SIOA(R3), R2  ; адрес загрузки сектора каталога
                movb    (R4), R0
                iot
                .word 55                ; Абсолютно записать логический блок.
                                        ; вход: R0 - номер дисковода (1-дисковод "А"...)
                                        ;       R1 - номер логического блока.
                                        ;       R2 - адрес загрузки.
                                        ; Для нормальной работы область параметров данного устройства должна быть заполненной.
                bcc     2$
4ERR$:          sec
2$:             jmp     DECOPN          ; уменьшаем счётчик открытых файлов для заданного устройства
                                        ; вход:  R4 - FCB
                                        ; выход: R5 - PDB текущего устройства
                                        ; флаги не изменяются

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 21(17).
; Найти первый файл по образцу.
; вход:  R4 - адрес FCB.
; выход: R1 - указатель на найденную запись каталога в буфере каталога.
; если ошибка, С=1 и R1 не определён
; если R1 == -1, то в поле имени FCB задано стандартное устройство
FIOT21:         call    CHKTPL          ; проверка на валидность имени файла
                                        ; вход:  R4 - адрес FCB.
                bcs     3LR$
                call    GETDVN          ; получение номера устройства FCB и делание идентификатора устройства
                bcc     4LR$            ; в стандартных символьных устройствах искать нечего
                call    INCOPN          ; увеличиваем счётчик открытых файлов для заданного устройства
                                        ; вход:  R4 - FCB
                                        ; выход: R5 - PDB текущего устройства
                                        ;       С - какая-либо ошибка
                bcs     3LR$
                call    DECOPN          ; уменьшаем счётчик открытых файлов для заданного устройства
                                        ; вход:  R4 - FCB
                                        ; выход: R5 - PDB текущего устройства
                                        ; флаги не изменяются
                clr     F$DIRP(R4)      ; положение имени файла в каталоге.
                mov     #-1, S$DIRP(R3) ; номер записи в каталоге, для создаваемых файлов.
                clr     S$DSTW(R3)      ; номер сектора каталога, который надо обработать
                clr     S$CSNB(R3)      ; номер сектора, который находится в буфере чтения/записи
                br      3LL3$

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 22(18).
; Продолжить поиск файлов.
; (перед вызовом вызвать функцию 21, FCB не не изменять)
; вход: R4- адрес FCB.
; выход: R1 - указатель на найденную запись каталога в буфере каталога.
; если ошибка, С=1 и R1 не определён
; если R1 == -1, то в поле имени FCB задано стандартное устройство
FIOT22:         call    GETDVN          ; получение номера устройства FCB и делание идентификатора устройства
                bcs     0$
4LR$:           mov     #-1, R1         ; если в поле имени FCB задано стандартное устройство
3LR$:           return

0$:             inc     F$DIRP(R4)      ; положение имени файла в каталоге.
3LL3$:          mov     R4, R5
                mov     #13, R2
                inc     R5
                tstb    S$RENF(R3)      ; функция вызывается из переименования?
                beq     1$              ; нет
                add     #14, R5         ; да
1$:             mov     S$NMBF(R3), R1  ; адрес буфера
2$:             movb    (R5)+, (R1)+    ; копируем то что ищем в буфер
                sob     R2, 2$
                tstb    S$IONC(R3)      ; флаг, что буфер S$BIOA и S$SIOA не совпадают.
                bne     3$
                mov     S$CSNB(R3), S$DSTW(R3)  ; номер сектора, который находится в буфере чтения/записи -> номер сектора каталога, который надо обработать
3$:             call    RC2SEC          ; вычисление номера сектора по номеру записи в каталоге
                                        ; вход:  параметры в FCB
                                        ; выход: R1 - нужный номер сектора в каталоге
                bcs     4$
                cmpb    S$CDDN(R3), (R4) ; номер дисковода, каталог которого в буфере совпадает с тем что обрабатываем?
                bne     5$
                cmp     S$DSTW(R3), R1  ; а сектор тот, что надо?
                beq     6$
5$:             movb    (R4), R0        ; если нет. сперва сохраним сектор
                movb    R0, S$CDDN(R3)  ; номер дисковода, каталог которого в буфере
                mov     S$SIOA(R3), R2  ; адрес загрузки сектора каталога
                mov     R1, -(SP)
                clc                     ; при R1 == 0, C гарантированно должно быть 0
                mov     S$CDSN(R3), R1  ; номер обрабатываемого сектора каталога
                beq     7$              ; если номера нет, то и не пишем ничего
                clr     S$CDSN(R3)      ; почистим номер
                iot
                .word 55                ; Абсолютно записать логический блок.
                                        ; вход: R0 - номер дисковода (1-дисковод "А"...)
                                        ;       R1 - номер логического блока.
                                        ;       R2 - адрес загрузки.
                                        ; Для нормальной работы область параметров данного устройства должна быть заполненной.
7$:             mov     (SP)+, R1
                bcs     4$
                tstb    S$IONC(R3)      ; флаг, что буфер S$BIOA и S$SIOA не совпадают.
                bne     8$
                mov     R1, S$CSNB(R3)  ; номер сектора, который находится в буфере чтения/записи
8$:             iot                     ; прочитаем нужный сектор
                .word 54                ; Абсолютно считать логический блок.
                                        ; вход: R0 - номер дисковода (1-дисковод "А"...)
                                        ;       R1 - номер логического блока.
                                        ;       R2 - адрес загрузки.
                                        ; Для нормальной работы область параметров данного устройства должна быть заполненной.
                bcs     4$
6$:             call    RN2POS          ; вычисление положения в секторе по номеру записи в секторе
                                        ; вход:  S$BIOO(R3) - номер записи в секторе
                                        ;        R1 - номер сектора каталога, который надо обработать
                                        ; выход: R0 - смещение в буфере
                cmpb    (R0), #37       ; если первый символ - 0..37
                blos    9$              ; то вроде как нашли конец каталога
                cmpb    #345, (R0)      ; если нашли удалённый файл
                bne     10$
                tst     S$DIRP(R3)      ; если номер записи в каталоге (для создаваемых файлов) уже задан,
                bpl     0$              ; то продолжим поиск
                mov     F$DIRP(R4), S$DIRP(R3)  ; запомним номер записи в каталоге (для создаваемых файлов)
                br      0$              ; и продолжим поиск

10$:            mov     R0, R1          ; проверим на совпадение найденное
                mov     S$NMBF(R3), R2
                mov     #13, R5
11$:            cmpb    #'?, (R2)
                beq     12$
                cmpb    (R0), (R2)
                bne     0$              ; если не совпадает - продолжим поиск
12$:            inc     R2
                inc     R0
                sob     R5, 11$
                mov     R1, R0          ; иначе - выйдем с указателем на найденное
4$:             return

9$:             tst     S$DIRP(R3)      ; если номер записи в каталоге (для создаваемых файлов) уже задан,
                bpl     LER4$           ; то просто выход с ошибкой
                mov     F$DIRP(R4), S$DIRP(R3)  ; запомним номер записи в каталоге (для создаваемых файлов)
LER4$:          movb    #25, @#ERRFDD   ; и выйдем с ошибкой
                sec
                return

; ═══════════════════════════════════════════════════════════════════════════
; вычисление номера сектора по номеру записи в каталоге
; вход:  параметры в FCB
; выход: R1 - нужный номер сектора в каталоге
RC2SEC:         call    SDRFCB          ; задать текущим устройство, которое указано в FCB
                                        ; вход:  R4 - адрес FCB
                                        ; выход: R5 - адрес параметров устройства
                                        ;        R0 - текущее устройство
                                        ;        C - ошибка
                bcs     1$
                mov     F$DIRP(R4), R0  ; положение имени файла в каталоге.
                cmp     R0, P$DIRZ(R5)  ; максимальное количество элементов в каталоге
                bhis    LER4$
                clr     R1
                mov     R4, -(SP)
                mov     #20, R2         ; количество записей каталога в секторе
                call    DIVIDE          ; R4 = R1:R0 / R2, R0 = R1:R0 % R2
                mov     R0, S$BIOO(R3)  ; номер записи в секторе
                mov     R4, R1
                mov     (SP)+, R4
                add     P$DIRS(R5), R1  ; получим нужный сектор каталога
1$:             return

; ═══════════════════════════════════════════════════════════════════════════
; вычисление положения в секторе по номеру записи в секторе
; вход:  S$BIOO(R3) - номер записи в секторе
;        R1 - номер сектора каталога, который надо обработать
; выход: R0 - смещение в буфере
RN2POS:         mov     S$BIOO(R3), R0  ; номер записи в секторе
                mov     R1, S$DSTW(R3)  ; номер сектора каталога, который надо обработать
                clr     R1
                mov     #K$RECSZ, R2    ; размер записи каталога
                call    MULTIP          ; R1:R0 = R1:R0 * R2
                add     S$SIOA(R3), R0  ; положение в текущем буфере записи
                return

; ═══════════════════════════════════════════════════════════════════════════
; поиск свободного кластера
; вход:  R4 - адрес FCB
; выход: R0, P$LFCL(R5) - найденный свободный кластер
FNDFCL:         call    SDRFCB          ; задать текущим устройство, которое указано в FCB
                                        ; вход:  R4 - адрес FCB
                                        ; выход: R5 - адрес параметров устройства
                                        ;        R0 - текущее устройство
                                        ;        C - ошибка
                bcs     5LR$
                mov     #2, P$TMP4(R5)  ; искать с самого начала

; ═══════════════════════════════════════════════════════════════════════════
; поиск свободного кластера на текущем устройстве
; вход:  R4 - адрес FCB
;        P$TMP4(R5) - начальное значение
; выход: R0, P$LFCL(R5) - найденный свободный кластер
FNFCL$:         mov     R4, -(SP)
6$:             mov     P$TSEC(R5), R0  ; возьмём общее число секторов
                sub     P$ENDS(R5), R0  ; вычтем конечный сектор каталога, получим число рабочих секторов
                clr     R1
                movb    P$CLSZ(R5), R2  ; количество блоков в кластере
                call    DIVIDE          ; R4 = R1:R0 / R2, R0 = R1:R0 % R2
                mov     R4, S$CLSZ(R3)  ; количество кластеров на диске
                mov     #2, R0          ; первый кластер на диске
                tst     P$LFCL(R5)      ; последний свободный кластер на диске есть?
                beq     1$              ; нету
                mov     P$LFCL(R5), R0  ; есть - начнём с него
                sub     R0, R4          ; сколько кластеров осталось
                add     #2, R4          ; с учётом, что начало с двух
                beq     2$              ; нисколько - пропускаем
                ; последовательно просмотрим все кластеры
1$:             call    GETFAT          ; получить содержимое ячейки ФАТ
                                        ; вход:  R0 - номер ячейки
                                        ; выход: R1 - содержимое ячейки
                bcs     3$              ; ошибка ввода-вывода
                tst     R1              ; кластер свободен?
                beq     4$              ; да - нашли
                inc     R0              ; нет - смотрим дальше
                sob     R4, 1$
2$:             dec     P$TMP4(R5)      ; попытки кончились?
                beq     5$              ; да - выходим с ошибкой - не нашли
                clr     P$LFCL(R5)      ; нет - будем искать с самого начала
                br      6$              ; повторяем

5$:             movb    #22, @#ERRFDD
3$:             sec
4$:             mov     R0, P$LFCL(R5)  ; найденный свободный кластер
                mov     (SP)+, R4
5LR$:           return

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 43(35).
; Получить размер файла в байтах.
; вход:  R4 - адрес FCB
; выход: R0 - младшее слово размера,
;        R1 - старшее слово размера.
FIOT43:         iot
                .word 21                ; Найти первый файл по образцу.
                add     #K$SIZE, R1
                mov     (R1)+, R0
                mov     (R1), R1
                return

; ═══════════════════════════════════════════════════════════════════════════
; удаление файлов.
; выход: C=1 - ничего не найдено ошибка фат
DELFLN:         iot
                .word 21                ; Найти первый файл по образцу.
                bcs     1$
                mov     F$DIRP(R4), S$DIRP(R3) ; пометим текуще положение файла как свободное. !!! с целью возможности восстановления удалённого файла. эту команду надо убрать. Хотя и при поиске удалённые записи помечаются как кандидаты на перезапись.
2$:             bitb    #A$DIR, K$ATTR(R1) ; это каталог?
                bne     3$              ; да - каталоги игнорируем
                movb    #345, (R1)      ; пометим запись как удалённую
                mov     S$DSTW(R3), S$CDSN(R3)  ; номер сектора каталога, который надо обработать -> номер обрабатываемого сектора каталога при операциях с каталогом
                mov     K$CLNL(R1), R0  ; начальный кластер
                beq     3$              ; если пусто, то пропустим
4$:             call    GETFAT          ; получить содержимое ячейки ФАТ
                                        ; вход:  R0 - номер ячейки
                                        ; выход: R1 - содержимое ячейки
                bcs     1$
                tst     R1              ;
                beq     3$              ; обрыв цепочки - выходим из цикла
                mov     R1, -(SP)       ; старое содержимое ячейки сохраним
                clr     R1              ; зададим новое
                call    SETFAT          ; задать содержимое ячейки ФАТ
                                        ; вход: R0 - номер ячейки
                                        ;       R1 - содержимое ячейки
                mov     (SP)+, R0       ; достаём старое
                bcs     1$
                cmp     #7770, R0       ; ещё не последний кластер? !!! для фат16 тут будет другое число
                bhi     4$              ; да
3$:             iot
                .word 22                ; Продолжить поиск файлов.
                bcc     2$
                cmpb    @#ERRFDD, #25   ; если достигли конца каталоги, то это не ошибка
1$:             return

; ═══════════════════════════════════════════════════════════════════════════
; получение номера стандартного устройства
; вход:  R1 - адрес таблицы
;        R2 - адрес имени устройства, номер которого получаем
; выход: R0 - номер устройства * 2
;        С - дошли до конца и совпадений не нашли, значит не стандартное
STDNUM:         clr     R0
5$:             cmpb    (R1), #'$       ; конец?
                beq     1$              ; да
                mov     R2, R5          ; имя в FCB
2$:             tstb    (R1)            ; имя в таблице кончилось?
                beq     3$              ; да - всё ОК
                cmpb    (R5)+, (R1)+    ; ещё нет, оно совпадает с тем, что ищем?
                beq     2$              ; да - продолжаем сравнение
4$:             tstb    (R1)+           ; нет - пропускаем
                bne     4$              ; переходим к следующему имени в таблице
                tst     (R0)+           ; увеличиваем номер на 2
                br      5$              ; проверяем дальше

1$:             sec
3$:             return

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 70(56).
; Записать переменную в область окружения DOS.
; вход: R1-адрес строки.
FIOT70:         iot
                .word 67                ; Получить переменную из области окружения DOS.
                                        ; вход:  R1 - адрес имени переменной.
                                        ; выход: R2 - указывает на значение переменной в окружении DOS.
                                        ;        R0 - указывает на имя переменной в области окружения DOS.
                                        ;        если переменной нет, то С=1 и R2-указывает на свободную
                                        ;        строку в области окружения DOS.
                bcs     1$              ; такой переменной нет
                mov     R0, R4          ; указывает на имя переменной в области окружения DOS
2$:             tstb    (R4)+           ; ищем конец имени
                bne     2$
                mov     R1, -(SP)       ; адрес имени переменной
                iot
                .word 40                ; Получить адрес области окружения DOS.
                add     R1, R2          ; адрес начала области + размер области в байтах = адрес конца области
                mov     R2, (R3)        ; сохраним во временной переменной
                sub     R4, R2
3$:             movb    (R4)+, (R0)+
                sob     R2, 3$
                mov     (SP)+, R1       ; адрес имени переменной
1$:             mov     R1, R5
                mov     #'=, R0
4$:             cmpb    (R1)+, R0       ; ищем знак равно
                beq     5$
                tstb    (R1)
                bne     4$
                movb    #41, @#ERRFDD
                br      6$
                ; нашли равно
5$:             tstb    (R1)            ; за ним пусто?
                beq     7$              ; да
                mov     R5, R1
                iot
                .word 67                ; Получить переменную из области окружения DOS.
                                        ; вход:  R1 - адрес имени переменной.
                                        ; выход: R2 - указывает на значение переменной в окружении DOS.
                                        ;        R0 - указывает на имя переменной в области окружения DOS.
                                        ;        если переменной нет, то С=1 и R2-указывает на свободную
                                        ;        строку в области окружения DOS.
8$:             movb    (R1)+, R0
                beq     9$
                movb    R0, (R2)+
                cmp     (R3), R2
                bhi     8$
                movb    #40, @#ERRFDD
6$:             sec
                return

9$:             clrb    (R2)+
7$:             return

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 67(55).
; Получить переменную из области окружения DOS.
; вход:  R1 - адрес имени переменной.
; выход: R2 - указывает на значение переменной в окружении DOS.
;        R0 - указывает на имя переменной в области окружения DOS.
;        если переменной нет, то С=1 и R2-указывает на свободную
;        строку в области окружения DOS.
FIOT67:         mov     #'=, R0
                mov     R1, -(SP)
                iot
                .word 40                      ; Получить адрес области окружения DOS.
                mov     R1, R5
                mov     R2, (R3)
                add     R5, (R3)
                mov     (SP)+, R1
                br      1$

4$:             cmp     (R3), R5
                blo     5$
                tstb    (R5)+
                bne     4$

1$:             tstb    (R5)
                beq     2$
                mov     R1, R2
                mov     R5, R4
3$:             cmpb    (R2)+, (R5)+
                bne     4$
                cmpb    R0, (R2)
                bne     3$
                cmpb    R0, (R5)
                bne     3$
                mov     R4, R0
                inc     R5
                tst     (PC)+
2$:             sec
5$:             mov     R5, R2
                return


; ═══════════════════════════════════════════════════════════════════════════
; изменить запись в каталоге
CHDREC:         ; найдём сектор, которому принадлежит запись
                call    RC2SEC          ; вычисление номера сектора по номеру записи в каталоге
                                        ; вход:  параметры в FCB
                                        ; выход: R1 - нужный номер сектора в каталоге
                bcc     1$
                movb    #24, @#ERRFDD
                sec
                return

1$:             cmpb    S$CDDN(R3), (R4) ; это тот же дисковод, каталог которого уже читали?
                bne     2$
                tstb    S$IONC(R3)      ; флаг, что буфер S$BIOA и S$SIOA не совпадают.
                beq     3$
                cmp     R1, S$DSTW(R3)  ; номер сектора каталога, с которым работаем
                beq     4$              ; если тот же, то сразу на обработку
                br      2$              ; если нет - то читать

3$:             cmp     R1, S$CSNB(R3)  ; номер сектора тот же?
                beq     4$              ; да
                mov     R1, S$CSNB(R3)  ; нет, запомним
2$:             mov     S$SIOA(R3), R2  ; адрес загрузки
                movb    (R4), R0        ; номер дисковода
                iot
                .word 54                ; Абсолютно считать логический блок.
                                        ; вход: R0 - номер дисковода (1-дисковод "А"...)
                                        ;       R1 - номер логического блока.
                                        ;       R2 - адрес загрузки.
                                        ; Для нормальной работы область параметров данного устройства должна быть заполненной.
                bcs     5$

4$:             ; теперь найдём позицию в секторе нужной нам записи
                call    RN2POS          ; вычисление положения в секторе по номеру записи в секторе
                                        ; вход:  S$BIOO(R3) - номер записи в секторе
                                        ;        R1 - номер сектора каталога, который надо обработать
                                        ; выход: R0 - смещение в буфере
                mov     R4, R5          ; адрес FCB
                inc     R5              ; пропустим номер устройства
                mov     #13, R1
6$:             movb    (R5)+, (R0)+    ; скопируем имя файла
                sob     R1, 6$
                movb    F$ATTR(R4), (R0)+ ; атрибут файла
                mov     #12, R1
7$:             clrb    (R0)+           ; пропустим расширенные параметры
                sob     R1, 7$
                mov     F$FLLD(R4), (R0)+ ; адрес загрузки в поле времени обращения
                mov     F$FLDT(R4), (R0)+ ; дата создания в поле даты обращения
                mov     F$STCL(R4), (R0)+ ; начальный кластер
                mov     F$FLSZ(R4), (R0)+ ; размер файла
                mov     F$FLSZ+2(R4), (R0)+
                mov     S$SIOA(R3), R2  ; адрес загрузки
                mov     S$DSTW(R3), R1  ; номер сектора каталога, с которым работаем
                movb    (R4), R0        ; и сохраним изменения в каталоге
                iot
                .word 55                ; Абсолютно записать логический блок.
                                        ; вход: R0 - номер дисковода (1-дисковод "А"...)
                                        ;       R1 - номер логического блока.
                                        ;       R2 - адрес загрузки.
                                        ; Для нормальной работы область параметров данного устройства должна быть заполненной.
5$:             return

; ═══════════════════════════════════════════════════════════════════════════
; получить содержимое ячейки ФАТ !!!для фат16 другой алгоритм.
; вход:  R0 - номер ячейки
; выход: R1 - содержимое ячейки
GETFAT:         mov     R4, -(SP)
                mov     R0, -(SP)
                mov     R0, R4          ; R0 *= 3
                asl     R4
                add     R4, R0
                ror     R0              ; R0 /= 2 и сохраняем С - чтобы узнать чётное/нечётное
                mfps    -(SP)
                call    FATADR          ; вход:  R0 - смещение в ФАТ
                                        ; выход: R0 - адрес ячейки ФАТ в буфере
                bcs     2$
                mov     R0, P$TMP4(R5)  ; сохраним адрес ячейки ФАТ во временной ячейке
                clr     R1
                bisb    (R0)+, R1
                swab    R1
                bisb    (R0)+, R1
                swab    R1
                ;movb    (R0)+, -(SP)   вот это на слово короче
                ;movb    (R0)+, 1(SP)
                ;mov     (SP)+, R1
                mtps    (SP)            ; для чётного/нечётного разная обработка, убирать из стека потом надо
                bcc     1$
                asr     R1
                asr     R1
                asr     R1
                asr     R1
1$:             bic     #170000, R1
                clc
2$:             mov     (SP)+, R0       ; убираем из стека PS, чтобы бит С не потерять
                mov     (SP)+, R0
                mov     (SP)+, R4
                return


; ═══════════════════════════════════════════════════════════════════════════
; задать содержимое ячейки ФАТ
; вход: R0 - номер ячейки
;       R1 - содержимое ячейки
SETFAT:         mov     R1, -(SP)       ; новое содержимое пока сохраним
                call    GETFAT          ; получим значение ячейки и попутно рассчитаем нужные параметры
                                        ; вход:  R0 - номер ячейки
                                        ; выход: R1 - содержимое ячейки
                bcs     1$              ; неудача - выходим
                ; старое значение пока не используем
                mov     R0, -(SP)
                mov     R0, R1          ; R0 *= 3
                asl     R1
                add     R1, R0
                ror     R0              ; R0 /= 2 и сохраняем С - чтобы узнать чётное/нечётное
                mov     P$TMP4(R5), R1  ; адрес ячейки ФАТ
                mov     2(SP), -(SP)    ; новое содержимое для манипуляций
                bcc     2$              ; адрес чётный
                ; нечётный
                bicb    #360, (R1)+
                bicb    #377, (R1)
                asl     (SP)
                asl     (SP)
                asl     (SP)
                asl     (SP)
                br      3$
                ; чётный
2$:             bicb    #377, (R1)+
                bicb    #17,  (R1)
                bic     #170000, (SP)
3$:             bisb    1(SP),  (R1)
                bisb    (SP)+, -(R1)
                mov     P$FSNB(R5), P$FSCH(R5)  ;зададим признак изменения в ФАТ
                mov     (SP)+, R0
                clc
1$:             mov     (SP)+, R1
                return


; ═══════════════════════════════════════════════════════════════════════════
; вход:  R0 - смещение в ФАТ
; выход: R0 - адрес ячейки ФАТ в буфере
;       при ошибке С=1, R0 - не определено (просто смещение в секторе)
FATADR:         clr     R1
                mov     (R5), R2        ; размер сектора в байтах
                call    DIVIDE          ; R4 = R1:R0 / R2, R0 = R1:R0 % R2
                inc     R4              ; результат деления, номер сектора фат
                mov     R0, -(SP)       ; а это смещение в секторе
                mov     P$AFAT(R5), R2  ; адрес FAT в памяти
                cmp     P$FSNB(R5), R4  ; этот сектор уже в буфере?
                beq     1$              ; да - ну и делать нечего
                mov     R4, P$FSNB(R5)  ; нет - нам будет нужен этот сектор

                mov     P$FSCH(R5), R1  ; изменения в ФАТ были?
                beq     2$              ; нет - идём сразу читать 
                ; да, тогда в R1 номер сектора фат, где были изменения
                movb    P$NDRV(R5), R0  ; номер устройства
                iot                     ; запишем первую копию фат
                .word 55                ; Абсолютно записать логический блок.
                                        ; вход: R0 - номер дисковода (1-дисковод "А"...)
                                        ;       R1 - номер логического блока.
                                        ;       R2 - адрес загрузки.
                                        ; Для нормальной работы область параметров данного устройства должна быть заполненной.
                bcs     5err$
                cmpb    P$NFAT(R5), #2  ; если копий две
                bne     3$              ; не, не две
                ; сохраняем вторую копию
                add     P$FATZ(R5), R1  ; размер FAT в секторах
                iot                     ; запишем вторую копию фат
                .word 55                ; Абсолютно записать логический блок.
                                        ; вход: R0 - номер дисковода (1-дисковод "А"...)
                                        ;       R1 - номер логического блока.
                                        ;       R2 - адрес загрузки.
                                        ; Для нормальной работы область параметров данного устройства должна быть заполненной.
                bcs     5err$
                sub     P$FATZ(R5), R1
3$:             inc     R1              ; следующий сектор первой копии
                ; и прочитаем следующий сектор, если текущий был не последним
                cmp     R1, P$FATZ(R5)  ; размер FAT в секторах
                bhi     4$
                iot                     ; прочитаем сектор
                .word 54                ; Абсолютно считать логический блок.
                                        ; вход: R0 - номер дисковода (1-дисковод "А"...)
                                        ;       R1 - номер логического блока.
                                        ;       R2 - адрес загрузки.
                                        ; Для нормальной работы область параметров данного устройства должна быть заполненной.
                bcs     5err$
                ; делаем модификацию, там на стыке секторов может слово модифицироваться
                mov     R2, R4          ; адрес FAT в памяти
                add     (R5), R4        ; прибавим размер сектора
                mov     (R4), (R2)      ; сделаем непонятную модификацию
                ; и сохраняем следующий сектор
                iot                     ; и сохраним сектор
                .word 55                ; Абсолютно записать логический блок.
                                        ; вход: R0 - номер дисковода (1-дисковод "А"...)
                                        ;       R1 - номер логического блока.
                                        ;       R2 - адрес загрузки.
                                        ; Для нормальной работы область параметров данного устройства должна быть заполненной.
                bcs     5err$
                cmpb    P$NFAT(R5), #2  ; если копий две
                bne     4$              ; не, не две
                ; сохраняем вторую копию
                add     P$FATZ(R5), R1  ; размер FAT в секторах
                iot                     ; запишем вторую копию фат
                .word 55                ; Абсолютно записать логический блок.
                                        ; вход: R0 - номер дисковода (1-дисковод "А"...)
                                        ;       R1 - номер логического блока.
                                        ;       R2 - адрес загрузки.
                                        ; Для нормальной работы область параметров данного устройства должна быть заполненной.
                bcs     5err$
4$:             clr     P$FSCH(R5)      ; сбросим флаг изменений
                ; теперь прочитаем нужный нам сектор 
2$:             mov     P$FSNB(R5), R1  ; нужный сектор
                movb    P$NDRV(R5), R0  ; номер устройства
                inc     R1              ; сперва прочитаем следующий сектор, если текущий не последний
                cmp     R1, P$FATZ(R5)  ; размер FAT в секторах
                bhi     6$
                iot
                .word 54                ; Абсолютно считать логический блок.
                                        ; вход: R0 - номер дисковода (1-дисковод "А"...)
                                        ;       R1 - номер логического блока.
                                        ;       R2 - адрес загрузки.
                                        ; Для нормальной работы область параметров данного устройства должна быть заполненной.
                bcs     5err$
                mov     R2, R4          ; адрес FAT в памяти
                add     (R5), R4        ; прибавим размер сектора
                mov     (R2), (R4)      ; и сохраним первое слово за концом буфера.
                ; теперь понятно, что за непонятная модификация была выше, это восстановление
                ; первого слова второго сектора, видимо оно портится
6$:             dec     R1              ; теперь прочитаем нужный сектор
                iot
                .word 54                ; Абсолютно считать логический блок.
                                        ; вход: R0 - номер дисковода (1-дисковод "А"...)
                                        ;       R1 - номер логического блока.
                                        ;       R2 - адрес загрузки.
                                        ; Для нормальной работы область параметров данного устройства должна быть заполненной.
                bcs     5err$
1$:             mov     (SP)+, R0       ; смещение в секторе
                add     R2, R0          ; получаем адрес ячейки ФАТ в буфере 
                return

5err$:          mov     (SP)+, R0
                return

; ═══════════════════════════════════════════════════════════════════════════
; умножение
; вход: R1:R0 - множимое
;       R2 - множитель
; выход:R1:R0 - результат
MULTIP:         mov     R5, -(SP)
                mov     R3, -(SP)
                mov     R4, -(SP)
                mov     #16., R5
                clr     R3
                clr     R4
2$:             asr     R2
                bcc     1$
                add     R0, R3
                adc     R4
                add     R1, R4
1$:             asl     R0
                rol     R1
                sob     R5, 2$
                mov     R4, R1
                mov     R3, R0
                mov     (SP)+, R4
                mov     (SP)+, R3
                mov     (SP)+, R5
                return

; ═══════════════════════════════════════════════════════════════════════════
; деление
; вход: R1:R0 - делимое
;       R2 - делитель
; выход:R4 - результат
;       R0 - остаток от деления
DIVIDE:         tst     R2
                beq     1$
                mov     R5, -(SP)
                clr     R5
                clr     R4
2$:             inc     R5
                asl     R2
                bcc     2$
3$:             ror     R2
4$:             inc     R4
                sub     R2, R0
                sbc     R1
                bcc     4$
                add     R2, R0
                adc     R1
                dec     R4
                asl     R4
                sob     R5, 3$
                ror     R4
                mov     (SP)+, R5
                return

1$:             movb    #31, @#ERRFDD
                mov     #12, R1
                jmp     ERROUT

; ═══════════════════════════════════════════════════════════════════════════
; задать текущим устройство, которое указано в FCB
; вход:  R4 - адрес FCB
; выход: R5 - адрес параметров устройства
;        R0 - текущее устройство
;        C - ошибка
SDRFCB:         movb    (R4), R0        ; номер дисковода, причём 0 (текущий) быть не может.

; ═══════════════════════════════════════════════════════════════════════════
; вход:  R0 - номер устройства прямого доступа
; выход: R5 - адрес структуры параметров устройства PDB
;        C - ошибка
SETDRV:         tstb    R0              ; номер == 0?
                beq     FERR21          ; да - ошибка
                cmpb    R0, S$DRVN(R3)  ; номер больше количества устройств прямого доступа в системе?
                bhi     FERR21          ; да ошибка
                mov     R0, R5
                dec     R5
                asl     R5
                add     S$DBLA(R3), R5  ; адрес списка дисковых блоков.(адреса абсолютные)
                mov     (R5), R5        ; получим адрес параметров устройства нужного нам устройства
                movb    R0, P$NDRV(R5)  ; номер устройства
                return

FERR21:         movb    #21, @#ERRFDD
                sec
                return

; ═══════════════════════════════════════════════════════════════════════════
; проверка на текущее устройство,
; и если да - получение номера текущего устройства
CHKCUR:         tstb    (R4)            ; какое устройство в FCB, текущее?
                bne     1$              ; нет, задано конкретное
                movb    S$CRDN(R3), (R4) ; да - тогда возьмём текущее из системной области
                incb    (R4)            ; преобразуем в номер привода
1$:             cmpb    S$DRVN(R3), (R4) ; если получилось больше максимального, то ошибка, нет такого устройства
                blo     FERR21
                return

; ═══════════════════════════════════════════════════════════════════════════
; подпр.чтения секторов на логическом уровне.(на уровне DOS) !!! переделано под функцию 160004
; вход:  R0 - номер устройства
;        R1 - номер блока
;        R2 - адрес массива.
;        R5 - адрес структуры параметров устройства PDB
SECTRD:         dec     R0              ; получим из номера устройства
                cmpb    S$FLPN(R3), #1  ; количество дисководов в системе
                bhi     1$              ; больше 1
                clr     R0              ; меньше 2
1$:             mov     R0, R4
                asl     R4
                add     S$RSFA(R3), R4  ; адрес таблицы подпр.чтения сектора с устройства
                mov     S$FWBF(R3), R3  ; адрес рабочей области драйвера дисковода
                movb    R0, D$UNIT(R3)  ; заполняем рабочую область, номер устройства
                add     R3, R0
                add     #D$FLGTAB, R0   ; указатель на в таблицу байтов признаков
                mov     R0, D$FLGPTR(R3) ; сохраним
                movb    P$PSET(R5), (R0) ; биты настройки контроллера на своё место
                mov     R1, R0          ; номер блока, который надо прочитать/записать
                mov     (R5), R1        ; размер сектора в байтах
                bne     2$              ; если задан, то берём его
                mov     #512., R1       ; иначе - значение по умолчанию
2$:             asr     R1              ; делаем размер в словах
                mov     R1, D$SECLEN(R3)
                mov     P$NSEC(R5), D$MAXSEC(R3) ; число секторов на дорожке
                tstb    P$OPTP(R5)      ; Тип операции : 0-чтение, иначе запись
                beq     3$
                neg     R1              ; при записи - отрицательное число
3$:             jmp     @(R4)+          ; и идём выполнять стандартную п/п обработки блока

; ═══════════════════════════════════════════════════════════════════════════
; Получить параметры устройства, номер которого задан в R0
PARLST:         call    SETDRV          ; вход:  R0 - номер устройства прямого доступа
                                        ; выход: R5 - адрес параметров устройства
                                        ;        C - ошибка
                bcs     6$
PARLS$:         mov     R4, -(SP)
                ; чистим переменные
                clr     P$LFCL(R5)      ; последний свободный кластер на диске
                clr     P$FSNB(R5)      ; Номер сектора фат в буфере
                mov     #10., P$NSEC(R5) ; число секторов на дорожке по умолчанию
                clr     S$CSNB(R3)      ; номер сектора, который находится в буфере чтения/записи
                clrb    S$DNSB(R3)      ; номер устройства, сектор которого в буфере чтения/записи
                mov     S$BIOA(R3), R2  ; адрес области обмена с диском
                clr     R1              ; номер блока.
                iot
                .word 54                ; Абсолютно считать логический блок.
                                        ; вход: R0 - номер дисковода (1-дисковод "А"...)
                                        ;       R1 - номер логического блока.
                                        ;       R2 - адрес загрузки.
                                        ; Для нормальной работы область параметров данного устройства должна быть заполненной.
                bcs     5$
                ; прочли нулевой блок, там у нас BPB !!! для FAT16 будет немного по-другому
                mov     R5, R4          ; заполняем PDB
                add     #13, R2         ; получим Число байт в секторе
                call    GetOddWord$     ; Число байт в блоке
                bmi     1$
                mov     R0, (R4)+       ; 0 =P$SECZ запомним в PDB размер сектора в байтах
                movb    (R2)+, (R4)+    ; 2 =P$CLSZ количество блоков в кластере
                mov     (R2)+, P$TMP4(R5) ; сохраним Число блоков в загрузчике во временную ячейку
                movb    (R2)+, (R4)+    ; 3 =P$NFAT количество копий FAT
                call    GetOddWord$     ; Максимальное число файлов в корневом каталоге
                mov     R0, (R4)+       ; 4 =P$DIRZ и её в максимальное количество элементов в корневом каталоге
                call    GetOddWord$     ; Общее число блоков на диске
                mov     R0, (R4)+       ; 6 =P$TSEC общее число блоков
                clr     (R4)+           ; 10
                clr     R0
                bisb    (R2)+, R0       ; Media descriptor
                mov     R0, (R4)+       ; 12 =P$FMTI идентификатор формата
                cmpb    #0xF0, R0
                blos    2$
1$:             movb    #17, @#ERRFDD
                mov     #2, R1
                call    ERROUT
                sec
                br      5$

2$:             mov     (R2)+, (R4)+    ; 14 =P$FATZ Число блоков в одной фат -> размер FAT в блоках
                mov     (R2)+, (R4)+    ; 16 =P$NSEC Число секторов на дорожке -> число секторов на дорожке
                mov     (R2)+, (R4)+    ; 20 =P$NSID Число головок -> количество сторон диска
                movb    P$NFAT(R5), R0
                clr     R1
                mov     P$FATZ(R5), R2
                call    MULTIP          ; R1:R0 = R1:R0 * R2
                add     P$TMP4(R5), R0  ; найдём начало каталога, прибавим Число блоков в загрузчике
                mov     R0, P$DIRS(R5)
                mov     P$DIRZ(R5), R0
                clr     R1
                mov     #20, R2
                call    DIVIDE          ; R4 = R1:R0 / R2, R0 = R1:R0 % R2
                ; R4 - количество секторов, занимаемых каталогом
                add     P$DIRS(R5), R4  ; а теперь - конечный сектор каталога
                mov     R4, P$ENDS(R5)
                mov     (R5), R0        ; размер сектора в байтах
                clr     R1
                movb    P$CLSZ(R5), R2  ; количество блоков в кластере
                call    MULTIP          ; R1:R0 = R1:R0 * R2
                mov     R0, P$CLBZ(R5)  ; размер кластера в байтах
                clr     R4
                cmp     P$NSID(R5), #2  ; у диска 2 стороны?
                beq     3$
                bisb    #2, R4
3$:             cmpb    P$FMTI(R5), #0xFB
                blos    4$
                bitb    #1, P$PDRV(R5)
                bne     4$
                bisb    #1, R4
4$:             movb    R4, P$PSET(R5)
                ccc
5$:             mov     (SP)+, R4
6$:             return

GetOddWord$:    clr     R0
                bisb    (R2)+, R0
                swab    R0
                bisb    (R2)+, R0
                swab    R0
                return

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 5(5).
; Вывод символа на принтер.
; вход: R0-код символа.(стробирующий бит на БК0010 - 400, на остальных - 40000)
FIOT05:         mov     S$PPAD(R3), R5  ; адрес параллельного порта
                mov     S$STBP(R3), R4  ; значение стробирующего бита для принтера
1$:             bit     R4, (R5)
                beq     1$
                bis     R4, R0
                mov     R0, (R5)
2$:             bit     R4, (R5)
                bne     2$
                bic     R4, R0
                clr     (R5)
                return

; ═══════════════════════════════════════════════════════════════════════════
; зарезервированная функция, выдаёт ошибку #011
FIOT13:         mov     #11, R1

; ═══════════════════════════════════════════════════════════════════════════
; вывод сообщения об ошибке, инициализация драйвера дисковода, инициализация всех буферов приводов
; вход: R1 - номер сообщения, 1..., нельзя 0 и меньше нуля
ERROUT:         mov     S$ERMA(R3), R2  ; адрес таблицы символьных сообщений об ошибке, строки разделяются 0
                br      3$

2$:             tstb    (R2)+
                bne     2$
3$:             sob     R1, 2$

1$:             movb    (R2)+, R0
                beq     4$
                call    OUTCHR
                br      1$

4$:             iot
                .word 15                ; Инициализировать драйвер (контроллер) дисковода.

                ; не думаю, что это правильно - при ошибке на одном дисководе, сбрасывать 
                ; счётчики открытых файлов на других дисководах
; ═══════════════════════════════════════════════════════════════════════════
; инициализация всех буферов приводов
SETALD:         movb    S$DRVN(R3), R0
2$:             call    SETDRV          ; вход:  R0 - номер устройства прямого доступа
                                        ; выход: R5 - адрес параметров устройства
                                        ;        C - ошибка
                bcs     3$              ; если ошибка, то R5 не определён
                clr     P$FLCT(R5)      ; счётчик открытых файлов для этого устройства
3$:             sob     R0, 2$
                return

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 56.
; Обработка критических ошибок.
; вход: R2 - если 0, то игнорировать.
; выход:R0 - символ:
;               I-игнорировать,
;               R-повторить,
;               А-отменить.
FIOT56:         mov     R1, -(SP)
                mov     R2, -(SP)
                beq     1$
                .addr   R0, CRTCLE
3$:             tstb    (R0)            ; список кончился?
                beq     1$              ; да
                cmpb    S$ER52(R3), (R0)+   ; номер прошлой ошибки в ячейке 52
                beq     2$
                inc     R0
                br      3$

2$:             movb    (R0), R1
                call    ERROUT
                mov     #10, R1
                call    ERROUT
4$:             call    INPCHR
                bic     #177240, R0
                cmp     #'R, R0
                beq     5$
                cmp     #'I, R0
                beq     5$
                cmp     #'A, R0
                bne     4$
5$:             call    OUTCHR
                mov     R0, -(SP)
                mov     #7, R1
                call    ERROUT
                mov     (SP)+, R0
1$:             mov     (SP)+, R2
                mov     (SP)+, R1
                return

; ═══════════════════════════════════════════════════════════════════════════
; получение аргумента командной строки типа %0..%9
S20462:         cmpb    2(R1), #40      ; за цифрой какой то символ есть?
                bhi     1$              ; да - это ошибка
                inc     R1              ; пропускаем процент
                movb    (R1)+, R0       ; берём цифру
                sub     #'0, R0         ; делаем из неё номер
                mov     R1, -(SP)       ; адрес запомним
                mov     S$CMLA(R3), R1  ; адрес командной строки
                mov     R1, R2
                add     S$CMLS(R3), R2  ; конец командной строки
2$:             tstb    (R1)            ; кончилась?
                beq     3$              ; да - ошибка
                tst     R0              ; дошли до нужного аргумента
                beq     4$              ; да - идём обрабатывать
                ; нет - пропускаем, и подводим указатель к следующему
                cmpb    #40, (R1)+      ; не пробел?
                bne     5$              ; да - идём пропускать
6$:             cmpb    #40, (R1)+      ; пробел - пропустим все пробелы
                beq     6$              ; !!! здесь над тоже конец командной строки проверять
                dec     R1              ; вернёмся к не пробельному символу
7$:             dec     R0              ; следующий аргумент
                br      2$              ; продолжим цикл

5$:             cmp     R1, R2          ; командная строка кончилась?
                blo     2$              ; нет ещё
3$:             movb    #35, @#ERRFDD   ; да - ошибка
                sec
                br      8$

4$:             call    S20612
8$:             mov     (SP)+, R1
                return

1$:             jmp     FERR30

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 51(41).
; Произвести синтаксический разбор строки.
; вход: R1 - адрес обрабатываемой строки.
;       R4 - адрес формируемого FCB-блока.
;       R2 - тип разбора:если 0,то обычный разбор.
;          если не 0,то если встретится первым код 0,
;          FCB  примет вид:_???????????
; выход: R2 - количество символов '?'.
FIOT51:         cmpb    #'%, (R1)       ; обработка конструкций
                beq     S20462          ; типа %цифра

; ═══════════════════════════════════════════════════════════════════════════

S20612:         clr     R0
                mov     R4, -(SP)
                cmpb    1(R1), #':      ; если это имя привода
                bne     1$
                movb    (R1)+, R0       ; то получим
                sub     #100, R0        ; его номер
                inc     R1
1$:             movb    R0, (R4)+       ; формируем номер привода
                tst     R2
                beq     2$
                cmpb    #40, (R1)
                beq     3$
                tstb    (R1)
                bne     2$
3$:             mov     #13, R0
                mov     #'?, R2
                call    FillSymb
                br      4$

2$:             mov     #10, R0
                mov     #2, R5
11$:            cmpb    (R1), #'.
                bne     5$
                mov     #40, R2
                call    FillSymb
                inc     R1
                br      6$

5$:             cmpb    #'*, (R1)
                bne     7$
                mov     #'?, R2
                call    FillSymb
                inc     R1
                br      8$

7$:             cmpb    (R1), #40
                bhi     9$
                mov     #40, R2
                call    FillSymb
                br      6$

9$:             movb    (R1)+, R2
                cmpb    R2, #173
                bhi     10$
                cmpb    R2, #140
                blo     10$
                bicb    #240, R2
10$:            movb    R2, (R4)+
                sob     R0, 11$
8$:             cmpb    (R1), #'.
                bne     6$
                inc     R1
6$:             mov     #3, R0
                sob     R5, 5$
4$:             mov     (SP)+, R4
                call    CHKTPL          ; проверка на валидность имени файла
                                        ; вход:  R4 - адрес FCB.
                mov     (R3), R2
                return

; ═══════════════════════════════════════════════════════════════════════════
; заполняем буфер символом
; Вход: R0 - количество
;       R2 - символ
;       R4 - адрес буфера
FillSymb:       movb    R2, (R4)+
                sob     R0, FillSymb
                return

; ═══════════════════════════════════════════════════════════════════════════
; проверка на валидность имени файла
; вход:  R4 - адрес FCB.
CHKTPL:         call    CHKCUR          ; проверка на текущее устройство,
                                        ; и если да - получение номера текущего устройства
                bcs     1$
                clr     (R3)
                mov     R4, R5
                inc     R5
                tstb    S$RENF(R3)      ; мы в режиме переименования?
                beq     2$
                add     #F$MDRV, R5     ; да обрабатываем второе имя
2$:             mov     #13, R0
                cmpb    (R5), #40
                blos    3$
4$:             movb    (R5)+, R2
                cmpb    #'?, R2
                bne     5$
                inc     (R3)
5$:             cmpb    #40, R2
                beq     6$
                cmpb    R2, #60
                blo     3$
                cmpb    R2, #73
                blo     6$
                cmpb    R2, #177
                blo     6$
                cmpb    R2, #277
                blo     3$
6$:             sob     R0, 4$
                tst     (R3)
1$:             return

3$:             jmp     FERR30

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 64.
; Получить доступ к командной строке.
; Вых: R1 - адрес командной строки.
;      R2 - размер командной строки в байтах.
FIOT64:         mov     S$CMLA(R3), R1
                mov     S$CMLS(R3), R2
                return

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 6(6).
; Буферизованный ввод с клавиатуры с возможностью редактирования.
; вход: R1 - адрес буфера,
;       R2 - размер буфера в байтах.
FIOT06:         mov     S$FCIA(R3), R4  ; адрес FCB стандартного устройства ввода
                movb    F$IDEV(R4), R4  ; идентификатор устройства 101-'А',102-'В'...
                sub     #377, R4        ; 377 == CON
                movb    R4, S$INKF(R3)  ; если R0==0, то будем вводить с устройства ввода, иначе - с других устройств.

INKEY:          clr     R4
                mov     R1, R5          ; адрес буфера
I06$1:          tstb    S$INKF(R3)      ; откуда вводим?
                beq     1$              ; с CON
                iot                     ; с прочих устройств
                .word 1                 ; Ввод символа со стандартного устройства ввода. выход: R0-код символа.
                bcs     I06$2
                br      2$

1$:             call    INPCHR
2$:             cmp     #6, R0          ; код 6
                bne     3$
                comb    S$PRNF(R3)      ; вкл./выкл. вывод на принтер
                br      I06$1

3$:             mov     PC, -(SP)
                add     (PC)+, (SP)
                .word   @I06$1+2
                cmp     #12, R0
                beq     4$
                cmp     #15, R0
                beq     4$
                cmp     #10, R0
                beq     DELSYM
                sub     #30, R0
                beq     DELSYM
                dec     R0
                beq     OUTSM$
                dec     R0
                beq     6$
                dec     R0
                beq     7$
                add     #33, R0
                movb    R0, (R5)+
                inc     R4
                call    CTSOUT
                cmp     R4, R2
                blo     I06$2

4$:             clrb    (R5)            ; перевод строки
                tst     (SP)+
                tstb    S$INKF(R3)      ; откуда вводим?
                beq     5$              ; с клавиатуры
                iot                     ; с устройства ввода
                .word 1                 ; Ввод символа со стандартного устройства ввода. выход: R0-код символа.
5$:             mov     #5015, R0
                iot
                .word 2                 ; Вывод символа на стандартное устройство вывода. вход: R0-код символа.
                swab    R0
                br      STDOUT

6$:             call    DELSYM
                tst     R4
                bne     6$
                return

7$:             call    OUTSM$
                bne     7$
I06$3:          return

; удаление последнего символа из буфера
DELSYM:         tst     R4
                beq     I06$3
                dec     R4
                call    DELSM$
                movb    -(R5), R0
                cmp     R0, #30
                bhis    I06$3

; удаление последнего символа на экране
DELSM$:         mov     #10, R0
                call    STDOUT
                mov     #40, R0
                call    STDOUT
                mov     #10, R0
                br      STDOUT

; вывод введённого символа на экран
OUTSM$:         movb    (R5), R0
                beq     I06$2
                inc     R5
                inc     R4
; вывод символа, если управляющий - то в виде ^символ
CTSOUT:         cmp     R0, #30
                bhis    STDOUT
                mov     R0, -(SP)
                mov     #'^, R0
                iot
                .word 2                 ; Вывод символа на стандартное устройство вывода. вход: R0-код символа.
                mov     (SP)+, R0
                add     #100, R0
; стандартный вывод символа на стандартное устройство
STDOUT:         iot
                .word 2                 ; Вывод символа на стандартное устройство вывода. вход: R0-код символа.
I06$2:          return

; ═══════════════════════════════════════════════════════════════════════════
; обработка устройства PRN
PRNPRC:         mov     F$DTAD(R4), R1  ; адрес обмена
                mov     F$RCSZ(R4), R2  ; размер записи в байтах.
                tst     (R3)            ; какая операция?
                beq     1$              ; чтение - выход
                ; запись
2$:             movb    (R1)+, R0
                iot
                .word 5                 ; Вывод символа на принтер.
                                        ; вход: R0-код символа.(стробирующий бит на БК0010-400, на остальных - 40000)
                sob     R2, 2$
1$:             br      NULPRC

; ═══════════════════════════════════════════════════════════════════════════
; обработка устройства CON
CONPRC:         mov     F$DTAD(R4), R1  ; адрес обмена
                mov     F$RCSZ(R4), R2  ; размер записи в байтах.
                mov     R4, -(SP)
                tst     (R3)            ; какая операция?
                bne     1$              ; запись
                ; чтение - приём кода с клавиатуры
                dec     R2
2$:             clrb    S$INKF(R3)      ; устанавливаем флаг, что будем вводить с клавиатуры
                call    INKEY
                mov     R1, R5
                dec     R5
                mov     R2, R0          ; размер
                add     R1, R0          ; конец буфера
3$:             inc     R5              ; двигаем указатель
                cmp     R5, R0          ; дошли до конца буфера?
                bhis    4$              ; да
                movb    (R5), R4        ; нет - берём код
                tstb    R4              ; это чё?
                beq     5$              ; 0 - идём заменим на \r\n
                dec     R2
                cmpb    #13, R4         ; код 13 (Ctrl-K) - конец ввода
                bne     3$
                clrb    (R5)
                tst     (R2)+
4$:             mov     (SP)+, R4
                mov     F$RCSZ(R4), R0  ; размер записи в байтах.
                sub     R2, R0          ; сколько осталось свободно байтов
                return

5$:             movb    #15, (R5)+      ; меняем 0 на \r\n
                movb    #12, (R5)+      ; и при этом портим буфер, код который после 0
                sub     #2, R2
                mov     R5, R1
                br      2$
                ; запись - это просто вывод на экран
1$:             clr     R5
6$:             movb    (R1)+, R0
                call    OUTCHR
                sob     R2, 6$
                mov     (SP)+, R4

; ═══════════════════════════════════════════════════════════════════════════
; обработка устройства NUL
NULPRC:         mov     F$RCSZ(R4), R0  ; размер записи в байтах.
                ccc
; обработка устройства AUX
AUXPRC:         return

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 1(1).
; Ввод символа со стандартного устройства ввода
; (по умолчанию - консоль).
; выход: R0 - код символа.
FIOT01:         mov     R1, -(SP)
                mov     R2, -(SP)
                mov     S$FCIA(R3), R4  ; получим адрес FCB
                mov     #1, F$RCSZ(R4)  ; размер записи в байтах
                mov     S$BINA(R3), F$DTAD(R4)  ; адрес буфера ввода
                iot
                .word 24                ; Последовательное чтение из файла. вход: R4-адрес FCB.
                                        ; После чтения соответствующие поля FCB модифицируются.
                mov     (SP)+, R2
                mov     (SP)+, R1
                movb    @S$BINA(R3), R0 ; адрес буфера устройства ввода, длиной 2 байта - то, что прочитали
                return

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 2(2).
; Вывод символа на стандартное устройство вывода
; (по умолчанию - консоль).
; вход: R0-код символа.
FIOT02:         mov     R1, -(SP)
                mov     R2, -(SP)
                mov     R0, -(SP)
                mov     S$FCOA(R3), R4  ; получим адрес FCB
                mov     #1, F$RCSZ(R4)  ; размер записи в байтах
                mov     S$BOUA(R3), F$DTAD(R4)  ; адрес буфера вывода
                movb    R0, @S$BOUA(R3) ; адрес буфера устройства вывода, длиной 2 байта
                tstb    S$PRNF(R3)      ; дублировать вывод на принтер?
                beq     1$              ; нет
                iot                     ; да
                .word 5                 ; Вывод символа на принтер.
                                        ; вход: R0-код символа.(стробирующий бит на БК0010 - 400, на остальных - 40000)
1$:             iot
                .word 25                ; Последовательная запись в файл. вход: R4-адрес FCB.
                                        ; После записи соответствующие поля FCB модифицируются.
                mov     (SP)+, R0
                mov     (SP)+, R2
                mov     (SP)+, R1
                return

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 11(9).
; Вывод строки символов на устройство вывода
; (по умолчанию - консоль).
; вход: R1 - адрес строки символов.
; (Строка должна оканчиваться нулевым байтом)
FIOT11:         mov     R1, R5
1$:             movb    (R5)+, R0       ; берём очередной символ
                beq     2$              ; если конец строки, то завершим вывод
                iot
                .word 2                 ; Вывод символа на стандартное устройство вывода вход: R0-код символа.
                bcc     1$              ; если ошибок не произошло, то продолжим
2$:             return

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 14(12).
; Очистить буфер командной строки.
; выход: R0 - адрес буфера командной строки
FIOT14:         mov     S$CMLA(R3), R0  ; адрес командной строки
                mov     S$CMLS(R3), R1  ; длина командной строки (длина 140 байтов)
                mov     R0, -(SP)
1$:             clrb    (R0)+
                sob     R1, 1$
                mov     (SP)+, R0
                return

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 15(13).
; Инициализировать драйвер (контроллер) дисковода.
; что-то это просто остановка двигателя.
FIOT15:         clr     @S$FWBF(R3)     ; адрес рабочей области драйвера дисковода
                clr     @#177130
                return

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 16(14).
; Задать текущий дисковод.
; вход:  R0 - номер дисковода.
;        0 - дисковод "А" и т. д.
FIOT16:         inc     R0
                call    SETDRV          ; вход:  R0 - номер устройства прямого доступа
                                        ; выход: R5 - адрес параметров устройства
                                        ;        C - ошибка
                bcs     1$
                dec     R0
                movb    R0, S$CRDN(R3)  ; номер текущего устройства прямого доступа (дисковода).
1$:             return

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 31(25).
; Получение номера текущего устройства прямого доступа (дисковода).
; выход: R0 - номер дисковода.
FIOT31:         movb    S$CRDN(R3), R0  ; номер текущего устройства прямого доступа (дисковода).
                return

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 52(42).
; Получить текущую дату.
; выход: R0 - дата
FIOT52:         mov     S$DATE(R3), R0  ; текущая дата
                return

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 53(43).
; Установить дату.
; вход: R0 - дата
FIOT53:         mov     R0, S$DATE(R3)  ; текущая дата
                return

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 33(27).
; Получить параметры текущего устройства (кроме символьных).
; выход: R2 - адрес списка параметров. (изменять данные запрещается).
FIOT33:         iot
                .word 31                ; Получение номера текущего устройства прямого доступа (дисковода).
                                        ; выход: R0 - номер дисковода.
                bcs     1$
                inc     R0

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 34(28).
; Аналогична функции 33(27),но для заданного устройства.
; вход: R0 - номер устройства (1-дисковод "А"...)
; выход: R2 - адрес списка параметров.
FIOT34:         call    PARLST          ; Получить параметры устройства, номер которого задан в R0
                mov     R5, R2
1$:             return

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 55(45).
; Абсолютно записать логический блок.
; вход: R0 - номер дисковода (1-дисковод "А"...)
;       R1 - номер логического блока.
;       R2 - адрес загрузки.
; Для нормальной работы область параметров данного устройства должна быть заполненной.
FIOT55:         mov     (PC)+, R4       ; флаг - запись

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 54(44).
; Абсолютно считать логический блок.
; вход: R0 - номер дисковода (1-дисковод "А"...)
;       R1 - номер логического блока.
;       R2 - адрес загрузки.
; Для нормальной работы область параметров данного устройства должна быть заполненной.
FIOT54:         clr     R4              ; флаг - чтение
                cmpb    S$FLPN(R3), #1  ; количество дисководов в системе.
                bhi     1$              ; больше 1
                ; меньше двух
                cmpb    S$ONED(R3), R0  ; Флаг, указывающий, что в системе всего один дисковод (1, если всего 1 дисковод, иначе 0)
                beq     1$
                mov     R2, -(SP)       ; если диск не тот, то попросим вставить тот диск
                mov     R1, -(SP)
                mov     R0, -(SP)
                mov     #13, R1
                call    ERROUT
                mov     (SP), R0
                add     #100, R0
                call    OUTCHR
                mov     #14, R1
                call    ERROUT
                call    INPCHR
                mov     (SP)+, R0
                mov     (SP)+, R1
                mov     (SP)+, R2
                movb    R0, S$ONED(R3)

1$:             call    SETDRV          ; вход:  R0 - номер устройства прямого доступа
                                        ; выход: R5 - адрес параметров устройства
                                        ;        C - ошибка
                bcs     2$
                movb    R4, P$OPTP(R5)  ; Тип операции : 0 - чтение, иначе запись
                mov     R4, -(SP)
                mov     R3, -(SP)
                mov     R2, -(SP)
                mov     R1, -(SP)
                mov     R0, -(SP)
                mov     R0, R4
                dec     R4
                asl     R4
                add     S$RSLA(R3), R4  ; адрес таблицы подпр.чтения секторов на логическом уровне.(на уровне DOS)
                                        ; вход:  R0 - номер устройства
                                        ;        R1 - номер блока
                                        ;        R2 - адрес массива.
                                        ;        R5 - адрес структуры параметров устройства PDB
                call    @(R4)+
                mov     (SP)+, R0
                mov     (SP)+, R1
                mov     (SP)+, R2
                mov     (SP)+, R3
                mov     (SP)+, R4
                bcc     3$
2$:             mov     R0, -(SP)
                iot
                .word 56                ; Обработка критических ошибок.
                                        ; вход: R2 - если 0, то игнорировать.
                                        ; выход:R0 - символ:
                                        ;               I-игнорировать,
                                        ;               R-повторить,
                                        ;               А-отменить.
                mov     R0, R5
                mov     (SP)+, R0
                cmp     #'R, R5
                beq     1$
                cmp     #'A, R5
                beq     4$
3$:             tst     (PC)+
4$:             sec
                return

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 32(26).
; Установление адреса области обмена с диском
; (адрес чтения/записи физического сектора)
; вход: R0 - адрес обмена.
FIOT32:         mov     R0, S$BIOA(R3)
                clrb    S$IONC(R3)
                cmp     S$SIOA(R3), R0  ; если совпадает с системным адресом
                beq     1$
                incb    S$IONC(R3)
1$:             return

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 57(47).
; Получить адрес обмена с диском (адрес чтения/записи сектора).
; выход: R0 - адрес.
FIOT57:         mov     S$BIOA(R3), R0
                return

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 45(37).
; Задать новую подпрограмму обработки функции.
; вход: R0 - номер функции.
;       R1 - абсолютный адрес подпрограммы.
; выход: R1 - старый абсолютный адрес подпрограммы.
FIOT45:         mov     R1, -(SP)
                call    FIOT65
                mov     (SP)+, (R0)
                return

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 65(53).
; Получить абсолютный адрес подпрограммы обработки функции.
; вход:  R0 - номер функции.
; выход: R1 - абсолютный адрес в памяти.
FIOT65:         asl     R0
                add     S$IOTA(R3), R0
                mov     (R0), R1
                return

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 60(48).
; Получить версию DOS.
; выход: R0 - версия:
;        ст.байт номер версии, мл.байт номер подверсии.
FIOT60:         mov     #DOSVER, R0
                return

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 66(54).
; Получить размер свободного пространства на диске.
; вход:  R0 - номер дисковода(1-дисковод "А"...).
; выход: R1 - секторов в кластере.
;        R2 - общее количество кластеров на диске.
;        R0 - количество свободных кластеров.
FIOT66:         call    PARLST          ; Получить параметры устройства, номер которого задан в R0
                bcs     1$
                clr     P$LFCL(R5)      ; последний свободный кластер на диске
                clr     R4              ; счётчик свободных кластеров
2$:             mov     #1, P$TMP4(R5)  ; искать от текущего
                call    FNFCL$          ; поиск свободного кластера на текущем устройстве
                                        ; P$LFCL(R5) модифицируется там
                bcs     3$              ; пока поиск не закончится неудачей
                inc     R4              ; посчитаем найденное
                inc     P$LFCL(R5)      ; сдвинемся со свободного кластера
                br      2$              ; и идём искать дальше

3$:             clc
                mov     S$CLSZ(R3), R2  ; количество кластеров на диске
                movb    P$CLSZ(R5), R1  ; количество блоков в кластере
                mov     R4, R0
1$:             return

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 30(24).
; Доступ к буферам DOS.
; выход: R0 - адрес области BAT-файлов.
;        первое слово - уровень вложенности (0 - область пуста).
;        R1 - адрес FCB стандартного устройства ввода.
;        R2 - адрес FCB стандартного устройства вывода.
FIOT30:         mov     S$BTFA(R3), R0
                mov     S$FCIA(R3), R1
                mov     S$FCOA(R3), R2
                return

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 61(49).
; Доступ к внутрисистемной информации.
; выход: R1 - адрес области DOS.
FIOT61:         mov     R3, R1
                return

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 62(50).
; Получить адрес дисковой области PDB.
; вход: R0 - номер устр.
; выход:R1 - адрес области.
FIOT62:         call    SETDRV          ; вход:  R0 - номер устройства прямого доступа
                                        ; выход: R5 - адрес параметров устройства
                                        ;        C - ошибка
                mov     R5, R1
                return

; ═══════════════════════════════════════════════════════════════════════════
; диспетчер EMT
EMTTRP:         mov     R5, -(SP)
                mov     R4, -(SP)
                mov     R3, -(SP)
                mov     6(SP), R5   ; адрес возврата
                mov     -(R5), R5   ; команда емт
                bic     #177400, R5 ; номер емта
                call    INIIOT
                call    CHKEMN
                bcs     2$          ; неверный номер - ошибка
                tst     (R5)        ; команда перехвачена? сбрасывает бит C
                beq     2$          ; нет - выполним стандартную функцию
                call    @(R5)+      ; да, выполним перехваченную функцию
                br      EMTEX$

2$:             mov     (SP)+, R3
                mov     (SP)+, R4
                mov     (SP)+, R5
                bcs     3$
                jmp     @V30OLD     ; нет, выполним обычную функцию

3$:             iot
                .word 63            ; Вызывается при неверном ЕМТ, на БК0010 >50, на БК0011 >130, на БК0011М >131.
                                    ; пока этот вызов зарезервирован, выдаёт сообщение - неверная инструкция
                rti

; ═══════════════════════════════════════════════════════════════════════════
; диспетчер IOT
IOTTRP:         mov     R5, -(SP)
                mov     R4, -(SP)
                mov     R3, -(SP)
                mov     6(SP), R3   ; адрес возврата
                mov     (R3)+, R5   ; номер функции
                mov     R3, 6(SP)   ; скорректируем адрес возврата
                call    GETSBF      ; получим в R3 адрес системной области
                movb    @#ERRFDD, S$ER52(R3) ; сохраним прошлый номер ошибки
                clrb    @#ERRFDD    ; очистим ячейку, где содержится номер ошибки
                asl     R5
                add     S$IOTA(R3), R5 ; адрес таблицы подпрограмм IOT диспетчера
                call    @(R5)+      ; выполним п/п функции
                bcs     EMTEX$      ; если все нормально
                clrb    @#ERRFDD    ; снова очистим ячейку, где содержится номер ошибки
EMTEX$:         mov     (SP)+, R3
                mov     (SP)+, R4
                mov     (SP)+, R5
                bic     #1, 2(SP)   ; очистим бит С в PSW
                adc     2(SP)       ; и установим бит С в PSW, если он сейчас установлен
2$:             rti

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 37(31).
; Перехват EMT.
; вход:  R0-номер EMT (на БК0010 от 0 до 50, на БК0011(М) от 0 до 130)
;        R1-абсолютный адрес программы обработки данного EMT.
;        (если R1=0,то адрес восстанавливается)
FIOT37:         mov     R0, R5
                call    CHKEMN
                bcs     1$
                mov     R1, (R5)
1$:             return

CHKEMN:         cmp     R5, S$EMCN(R3)  ; если номер больше максимального
                bhi     111$            ; то ошибка
M1$11M:         nop     ; для БК11М сюда помещается asl, т.к. там есть и нечётные емты
                add     S$CEMB(R3), R5
                tst     (PC)+
111$:           sec
                return

; ═══════════════════════════════════════════════════════════════════════════
; перехват обработки ЕМТ 14
EMT14$:         mov     V30OLD, @#30
                mov     R3, R5
AE14$2:         emt     14
                mov     S$EXSY(R5), @#4 ; восстановим векторы после выполнения
                mov     V30NEW, @#30

; ═══════════════════════════════════════════════════════════════════════════
; восстановим диспетчер IOT
INIIOT:         .addr   R3, IOTTRP
                mov     R3, @#20
GETSBF:         .addr   R3, SYSBUF
                return

; ═══════════════════════════════════════════════════════════════════════════
; перехват обработки ЕМТ 36
; используем ячейку 2, как будто в буфере системных переменных места нет.
EMT36$:         mov     R1, R5          ; адрес блока параметров emt 36
                add     #6, R1
                clrb    S$36SF(R3)
EM36$1:         mov     SP, S$SP36(R3)  ; сохраняем текущий указатель стека
                mov     S$ISSP(R3), SP  ; вершина внутрисистемного указателя стека для перехватчика emt 36
                                        ; (макс. размер 156 байтов, дальше будет портиться внутрисистемная таблица данных)
                mov     S$TFCB(R3), R4
                clr     R2
                iot
                .word 51                ; Произвести синтаксический разбор строки.
                                        ; вход: R1-адрес обрабатываемой строки.
                                        ;       R4-адрес формируемого FCB-блока.
                                        ;       R2-тип разбора:если 0,то обычный разбор.
                                        ;          если не 0,то если встретится первым код 0,
                                        ;          FCB  примет вид:_???????????
                                        ; выход: R2-количество символов '?'.
                bcs     1$
                tstb    S$36SF(R3)
                bne     2$
                mov     S$BE36(R3), R0  ; адрес буфера копии имени в перехватчике emt36 (NBE36L байтов)
                mov     S$LE36(R3), R2  ; длина буфера копии имени в перехватчике emt36 (NBE36L байтов)
3$:             movb    (R1)+, (R0)+    ; копируем имя обрабатываемого файла в буфер
                beq     2$
                sob     R2, 3$
2$:             tstb    (R5)            ; команда?
                beq     1$              ; 0 - ничего не делать
                cmpb    (R5), #2        ; Запись?
                beq     4$
                ; всё остальное - чтение
                iot
                .word 17                ; Открыть файл методом FCB.
                                        ; вход: R4-адрес FCB.
                bcs     1$
                mov     2(R5), R0       ; адрес загрузки
                bne     5$              ; если не задан,
                mov     F$FLLD(R4), R0  ; то берём из FCB
5$:             mov     R0, F$DTAD(R4)  ; помещаем в адрес обмена
                mov     R0, @#264       ; помещаем в ячейку адреса загруженного файла
                mov     R0, 26(R5)      ; помещаем в адрес обнаруженного файла блока параметров МФ
                mov     F$FLSZ(R4), R0  ; размер файла в байтах.
                mov     R0, F$RCSZ(R4)  ; помещаем в размер записи в байтах.
                mov     R0, @#266       ; помещаем в ячейку размера загруженного файла
                mov     R0, 30(R5)      ; помещаем в размер обнаруженного файла блока параметров МФ
                iot
                .word 41                ; Прямой доступ,чтение.
                                        ; вход: R4-адрес FCB.
                                        ; выход: R0-сколько байт считано.
                                        ; Поля FCB не изменяются.
                br      6$
                ;запись
4$:             iot
                .word 26                ; Создать файл.
                                        ; (если файл существовал ,то размер его устанавливается равным 0).
                                        ; вход: R4-адрес FCB.
                bcs     1$
                mov     2(R5), F$FLLD(R4)   ; адрес загрузки файла в память
                beq     6$                  ; если не задан, то и писать нечего
                mov     2(R5), F$DTAD(R4)   ; адрес обмена
                mov     4(R5), F$RCSZ(R4)   ; размер записи в байтах.
                iot
                .word 42                ; Прямой доступ,запись.
                                        ; вход: R4-адрес FCB.
                                        ; выход: R0-сколько байт записано.
                                        ; Поля FCB не изменяются.
6$:             iot
                .word 20                ; Закрыть файл.
                                        ; вход: R4-адрес FCB.
                movb    (R4), R0
1$:             movb    @#ERRFDD, 1(R5)
                iot
                .word 15                ; Инициализировать драйвер (контроллер) дисковода.
                                        ; что-то это просто остановка двигателя.
                mov     R5, R1
                mov     S$SP36(R3), SP
                return

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 46(38).
; Исполнить программу.(Автозапуск работает корректно).
; вход: R1 - адрес строки содержащей имя файла.
;       R2 мл. байт - флаг: !0-запуска не происходит, 0 - файл запускается
;          на исполнение.
FIOT46:         mov     #320, R5
                movb    R2, S$36SF(R3)
                mov     R5, R4
                mov     #3, (R4)+
                clr     (R4)+
                clr     (R4)+
                call    EM36$1
                movb    1(R5), @#ERRFDD
                bne     1$
                tstb    S$36SF(R3)
                bne     2$
                mov     S$BE36(R3), R3  ; передаёт программе через R3 её имя
                mov     #776, SP
                mov     @#264, R5
                cmp     R5, #764
                bhis    3$
                mov     @#766, R5
3$:             jmp     (R5)

1$:             sec
2$:             return

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 40(32).
; Получить адрес области окружения DOS.
; выход: R1-адрес начала области.
;        R2-размер области в байтах.
FIOT40:         mov     S$DOSA(R3), R1
                mov     S$DOSZ(R3), R2
                return

; список имён символьных устройств.(имена разделены нулевым байтом).
STDNAM:         .asciz "PRN"
                .asciz "LST"
                .asciz "NUL"
                .asciz "AUX"
                .asciz "CON"
                .asciz "$"
                .even

; ───────────────────────────────────────────────────────────────────────────
; массив смещений, длиной 076 слов, которые преобразуются в абсолютные адреса
; ───────────────────────────────────────────────────────────────────────────
; таблица переходов для символьных устройств.
; список которых в STDNAM
SYSOFS:         .word @PRNPRC
                .word @PRNPRC
                .word @NULPRC
                .word @AUXPRC
                .word @CONPRC
; ───────────────────────────────────────────────────────────────────────────
; начало таблицы iotов
IOTTBL:         .word @FIOT00
                .word @FIOT01
                .word @FIOT02
                .word @FIOT13           ; 3 зарезервировано
                .word @FIOT13           ; 4 зарезервировано
                .word @FIOT05
                .word @FIOT06
                .word @FIOT01           ; 7 зарезервировано
                .word @FIOT01           ; 10 зарезервировано
                .word @FIOT11
                .word @FIOT13           ; 12 зарезервировано
                .word @FIOT13           ; 13 зарезервировано
                .word @FIOT14
                .word @FIOT15
                .word @FIOT16
                .word @FIOT17
                .word @FIOT20
                .word @FIOT21
                .word @FIOT22
                .word @FIOT23
                .word @FIOT24
                .word @FIOT25
                .word @FIOT26
                .word @FIOT27
                .word @FIOT30
                .word @FIOT31
                .word @FIOT32
                .word @FIOT33
                .word @FIOT34
                .word @FIOT13           ; 35 зарезервировано
                .word @FIOT13           ; 36 зарезервировано
                .word @FIOT37
                .word @FIOT40
                .word @FIOT41
                .word @FIOT42
                .word @FIOT43
                .word @FIOT44
                .word @FIOT45
                .word @FIOT46
                .word @FIOT47
                .word @FIOT50
                .word @FIOT51
                .word @FIOT52
                .word @FIOT53
                .word @FIOT54
                .word @FIOT55
                .word @FIOT56
                .word @FIOT57
                .word @FIOT60
                .word @FIOT61
                .word @FIOT62
                .word @FIOT13           ; 63 зарезервировано, используется для выдачи сообщения об ошибке - неверный вызов емт
                .word @FIOT64
                .word @FIOT65
                .word @FIOT66
                .word @FIOT67
                .word @FIOT70
IOTTEN:
; ───────────────────────────────────────────────────────────────────────────
DSKERR:         .asciz "Sector not found"<12><15>                       ; 1
                .asciz "Non-DOS disk"<12><15>                           ; 2
                .asciz "Disk write protected or disk error"<12><15>     ; 3
                .asciz "Disk not ready"<12><15>                         ; 4
                .asciz "Disk error reading"<12><15>                     ; 5
                .asciz "Bad fat"<12><15>                                ; 6
                .asciz <15><12>                                         ; 7
                .asciz "Abort,Retry,Ignore "                            ; 10
                .asciz "Illegal instruction"<12><15>                    ; 11
                .asciz "Division by zero"<12><15>                       ; 12
                .asciz "Insert diskette for drive "                     ; 13
                .asciz ":"<12><15>"Press any key when ready"<12><15>    ; 14
                .even
; ───────────────────────────────────────────────────────────────────────────

CRTCLE:         .byte 1,3   ; таблица: номер ошибки, номер сообщения из списка DSKERR
                .byte 2,5
                .byte 3,5
                .byte 4,5
                .byte 5,1
                .byte 6,4
                .byte 7,4
                .byte 10,5
                .byte 11,5
                .byte 12,2
                .byte 0,0 ; конец таблицы
ENKRNL:
                .END
