
; Processor:        1801VM1
; Target assembler: BK Turbo8 Cross Assembler
; Файл: FORMAT

.include "inc/FDDParam.asm"
.include "inc/dx_fcb.asm"
.include "inc/dx_pdb.asm"
.include "inc/dx_fat.asm"
.include "inc/dx_sys.asm"

; переменные рабочего буфера
;        0      ; временная ячейка, счётчик
T$LSDN = 2      ; номер последней стороны
T$LTRN = 4      ; номер последней дорожки
T$SNTR = 6      ; число секторов на дорожке
T$DRVN = 10     ; (1b) номер рабочего устройства
T$VRFY = 12     ; (1b) флаг верификации, если ключ /Q, то без верификации
T$RETR = 16     ; количество попыток форматирования дорожки / и что-то ещё
T$FLGD = 22     ; (1b) флаги-признаки привода для драйвера дисковода для таблицы D$FLGTAB
T$ITOA = 24     ; адрес буфера ItoABuf размером 16 байтов
T$BCNT = 26     ; счётчик плохих цилиндров, даже не дорожек
T$SCSZ = 30     ; размер сектора в байтах
T$ASCN = 32     ; общее количество секторов на диске
T$FTSC = 34     ; Число секторов в одной фат
T$MDSR = 36     ; медиадескриптор
T$RDFN = 40     ; Максимальное число файлов в корневом каталоге
T$CLSC = 42     ; (2b) количество секторов в кластере
T$MKSY = 44     ; 1 если ключ /B, 2 если ключ /S, 0 если ни один из них
T$FLSZ = 46     ; размер файла в байтах
T$TBUF = 50     ; адрес буфера чтения данных
T$SYUS = 52     ; сколько байтов используется системой
T$FLPN = 54     ; (1б) количество дисководов в системе.
T$SYDN = 56     ; (1б) номер системного устройства
T$DFLG = 60     ; (1б) 0 - просьба системного диска !0 - просьба целевого диска
T$RSFA = 62     ; адрес подпр.чтения сектора с устройства из таблицы S$RSFA
T$MONT = 64     ; (1б) тип монитора 0-БК0010, 1-БК0011М, 2-БК0011
T$BS11 = 66     ; адрес буфера BUF$11 размером 16 байтов для получения параметров экрана
T$SCRM = 70     ; слово режима драйвера экрана для БК11(М)
T$OWND = 72     ; 0, если ключ /D, то 1
T$BFV4 = 74     ; буфер хранения вектора 4
T$TRSZ = 76     ; размер дорожки в словах
T$CMDA = 100    ; адрес начала аргументов командной строки

START:          mov     #START, SP
                iot
                .word 60                ; Получить версию DOS.
                                        ; выход: R0-версия:
                                        ;        ст.байт номер версии, мл.байт номер подверсии.
                cmp     #DOSVER, R0     ; чё за версия?
                beq     1$              ; наша, все в норме
                mov     #2, R1          ; неверная версия
2ERRO$:         call    OUTSTR
3$:             iot
                .word 0

4ERRO$:         mov     #27, R1         ; comspec не найден
                call    OUTSTR
                br      3$

1$:             .addr   R4, SYSPAR      ; рабочий буфер. разбираться и расписывать значения переменных лень.
                mov     R3, T$CMDA(R4)  ; адрес начала аргументов командной строки
                mov     R3, R5          ; адрес начала аргументов командной строки
                mov     #1, T$LSDN(R4)
                .addr   R0, EOF
                mov     R0, T$TBUF(R4)  ; адрес буфера чтения данных
                mov     #10., T$SNTR(R4)
                clr     T$BCNT(R4)
                clr     T$OWND(R4)
                mov     #1000, T$SCSZ(R4) ; размер сектора в байтах
                movb    #1, T$VRFY(R4)  ; по умолчанию - делать верификацию
                mov     #2, T$RETR(R4)
                mov     #79., T$LTRN(R4)
                clrb    T$FLGD(R4)
                .addr   R0, ItoABuf
                mov     R0, T$ITOA(R4)
                ; начинаем разбор командной строки
                call    SKIPWS
                cmpb    #'/, (R5)       ; ключ ?
                bne     5$              ; нет
                inc     R5              ; да, а какой?
                call    SKIPWS
                cmpb    #'?, (R5)       ; help?
                bne     5$              ; нет, но тут ведь не сюда переходить надо
                mov     #34, R1         ; да - вывод справки и выход
                br      2ERRO$

5$:             movb    (R5)+, R0       ; берём символ или ключ
                bic     #240, R0        ; делаем лат.загл.
                sub     #'A, R0         ; получим номер устройства.
                bmi     7$              ; если неверное - выход
                movb    R0, T$DRVN(R4)  ; сохраним
                cmpb    #':, (R5)+      ; а за ним двоеточие?
                beq     6$
7$:             mov     #1, R1          ; несовместимые параметры!
                br      2ERRO$

6$:             inc     R0
                iot
                .word 62                ; Получить адрес дисковой области PDB.
                                        ; вход: R0-номер устр.
                                        ; выход:R1-адрес области.
                tstb    P$PDRV(R1)      ; параметры дисковода
                beq     8$
                asr     T$LTRN(R4)           ; номер последней дорожки уменьшим вдвое
8$:             iot
                .word 61                ; Доступ к внутрисистемной информации.
                                        ; выход: R1-адрес области DOS.
                movb    S$FLPN(R1), T$FLPN(R4) ; количество дисководов в системе.
                mov     S$RSFA(R1), R2  ; адрес таблицы подпр.чтения сектора с устройства (при старте устанавливается 160006 для всех устройств).
                asl     R0
                add     R0, R2          ; индекс в таблице
                mov     (R2), T$RSFA(R4) ; сохраним адрес п/п
                .addr   R0, BUF$11
                mov     R0, T$BS11(R4)
                movb    S$MONT(R1), T$MONT(R4) ; тип монитора 0-БК0010,1-БК0011М,2-БК0011.
                clr     R0
                call    SCRSET          ; манипуляции с режимами экрана
                                        ; Вход: R0 - код операции:
                                        ; 0 - сохранение текущего режима экрана
                                        ; 1 - переключение ширины символов
                                        ; 2 - переключение режима отображения курсора
                                        ; 3 - восстановление режима экрана
                .addr   R1, COMSPK
                iot
                .word 67                ; Получить переменную из области окружения DOS.
                                        ; вход:  R1-адрес имени переменной.
                                        ; выход: R2-указывает на значение переменной в окружении DOS.
                                        ;        R0-указывает на имя переменной в области окружения DOS.
                                        ;        если переменной нет, то С=1 и R2-указывает на свободную
                                        ;        строку в области окружения DOS.
                bcs     4ERRO$
                movb    (R2)+, R0       ; имя привода, где находится command.com
                sub     #100, R0        ; сделаем номер
                cmpb    #':, (R2)       ; а это точно имя привода?
                beq     9$              ; да
                iot                     ; нет
                .word 31                ; Получение номера текущего устройства прямого доступа (дисковода).
                                        ; выход: R0 - номер дисковода.
                inc     R0              ; тогда будет текущий
9$:             movb    R0, T$SYDN(R4)  ; сохраним
81$:            call    SKIPWS
                cmpb    (R5), #40       ; коды 0..37
                blo     10$             ; да - конец командной строки
                cmpb    (R5), #'/       ; ключ?
                bne     7$              ; нет - несовместимые параметры!
                inc     R5              ; да, узнаем параметр
                cmpb    #'1, (R5)       ; форматировать только 1 сторону?
                bne     11$             ; нет
                clr     T$LSDN(R4)      ; да
                bisb    #2, T$FLGD(R4)  ; установим бит обработки только одной стороны
                br      12$

11$:            cmpb    #'4, (R5)       ; обрабатывать как 40 дор. дискету?
                bne     13$             ; нет
                cmp     #39., T$LTRN(R4) ; да, а дисковод и так 40 дорожечный?
                beq     12$             ; да - игнорируем
                asr     T$LTRN(R4)      ; уменьшаем число дорожек вдвое
                bisb    #1, T$FLGD(R4)      ; установим бит пропуска дорожек на 80 дор. дисководе
                br      12$

13$:            cmpb    #'8, (R5)       ; 8 секторов на дорожке?
                bne     14$             ; нет
                mov     #8., T$SNTR(R4) ; да
                br      12$

14$:            cmpb    #'9, (R5)       ; 9 секторов на дорожке?
                bne     15$             ; нет
                mov     #9., T$SNTR(R4) ; да
                br      12$

15$:            cmpb    #'Q, (R5)       ; быстрый?
                bne     16$             ; нет
                clrb    T$VRFY(R4)      ; да - не делать верификацию
                br      12$

16$:            cmpb    #'B, (R5)       ; загрузочный?
                bne     17$             ; нет
                mov     #1, T$MKSY(R4)      ; да
                br      12$

17$:            cmpb    #'S, (R5)       ; системный?
                bne     18$             ; нет
                mov     #2, T$MKSY(R4)      ; да
                br      12$

18$:            cmpb    #'D, (R5)       ; свой драйвер?
                bne     7$              ; нет - несовместимые параметры!
                inc     T$OWND(R4)
12$:            inc     R5
                br      81$

19$:            br      7$              ; несовместимые параметры!

10$:            .addr   R3, CustFDDBPB  ; адрес рабочей области драйвера дисковода
                call    INIT            ; инициализируем рабочую область
                mov     T$LTRN(R4), R0  ; номер последней дорожки
                inc     R0              ; сделаем число дорожек
                tst     T$LSDN(R4)      ; сколько сторон?
                beq     20$             ; одна
                asl     R0              ; две - дорожек в 2 раза больше
20$:            mov     T$SNTR(R4), R2  ; число секторов на дорожке
                clr     R1
                call    MULTIP          ; умножение R1:R0 = R1:R0 * R2
                mov     R0, T$ASCN(R4)  ; общее количество секторов на диске

                .addr   R0, FMTTBL      ; адрес таблицы параметров
21$:            cmp     T$LTRN(R4), (R0) ; количество дорожек совпадает?
                bne     22$             ; нет - переход
                mov     T$LSDN(R4), R1  ; номер последней стороны
                inc     R1              ; число сторон
                cmp     2(R0), R1       ; совпадает?
                bne     22$             ; нет - к следующей
                cmp     T$SNTR(R4), 4(R0) ; число секторов на дорожке совпадает?
                beq     23$             ; да - нашли
22$:            add     #20, R0         ; перейдём к следующей структуре
                tst     (R0)            ; таблицы кончилась?
                bne     21$             ; нет - продолжаем
                br      19$             ; несовместимые параметры!

23$:            cmpb    T$DRVN(R4), T$FLPN(R4) ; номер рабочего привода укладывается в число приводов
                blo     24$             ; да - ОК
                mov     #24, R1         ; неверное имя диска
                call    OUTSTR
                jmp     V4$1            ; всякие ещё сообщения и выход

24$:            .addr   R5, BUTSEC
                add     #13, R5         ; заполним bios parameters block
                add     #6, R0          ; заданные параметры формата
                mov     T$SCSZ(R4), R1  ; возьмём размер сектора
                movb    R1, (R5)+       ; поместим в BPB
                swab    R1
                movb    R1, (R5)+
                movb    (R0), (R5)+     ; количество секторов в кластере в BPB
                mov     (R0)+, T$CLSC(R4) ; и туда тоже сохраним
                mov     #1, (R5)+       ; Число секторов в загрузчике в BPB
                movb    #2, (R5)+       ; Число фат в BPB
                mov     (R0)+, R1       ; Максимальное число файлов в корневом каталоге
                mov     R1, T$RDFN(R4)  ; и туда сохраним
                movb    R1, (R5)+       ; и в BPB сохраним
                swab    R1
                clrb    R1
                movb    R1, (R5)+
                mov     T$ASCN(R4), R1  ; общее количество секторов на диске
                movb    R1, (R5)+       ; Общее число блоков на диске в BPB
                swab    R1
                movb    R1, (R5)+
                movb    (R0), (R5)+     ; Media descriptor в BPB
                mov     (R0)+, T$MDSR(R4) ; и туда сохраним
                mov     (R0), (R5)+     ; Число секторов в одной фат в BPB
                mov     (R0)+, T$FTSC(R4) ; и туда сохраним
                mov     T$SNTR(R4), (R5)+ ; Число секторов на дорожке  в BPB
                mov     T$LSDN(R4), (R5) ; номер последней головки
                inc     (R5)            ; количество головок в BPB
                mov     (R0), R5        ; размер в килобайтах
                mov     #5, R1          ; вставьте новую дискету в дисковод
                call    OUTSTR
                movb    T$DRVN(R4), R0  ; номер рабочего устройства
                add     #'A, R0         ; делаем имя привода
                iot
                .word 2                 ; Вывод символа на стандартное устройство вывода
                                        ; (по умолчанию - консоль).
                                        ; вход: R0-код символа.
                mov     #6, R1          ; и нажмите ввод, когда будете готовы
                call    OUTSTR
                iot
                .word 1                 ; Ввод символа со стандартного устройства ввода
                                        ; (по умолчанию - консоль).
                                        ; выход: R0-код символа.
                cmpb    R0, #15         ; если код 0..15
                blos    25$             ; то считаем, что это ввод
                iot                     ; иначе - выход
                .word 0

25$:            mov     #1, R0
                call    SCRSET          ; манипуляции с режимами экрана
                                        ; Вход: R0 - код операции:
                                        ; 0 - сохранение текущего режима экрана
                                        ; 1 - переключение ширины символов
                                        ; 2 - переключение режима отображения курсора
                                        ; 3 - восстановление режима экрана
                mov     #4, R0
                mov     (R0), T$BFV4(R4) ; сохраняем вектор 4
                mov     PC, (R0)
                add     #V4$1-., (R0)   ; задаём свой

                mov     #17, R1         ; форматирование
                call    OUTSTR
                mov     R5, R0          ; размер в килобайтах
                clr     R1
                call    ITOA            ; конвертирование числа в текстовую форму и вывод на экран
                                        ; Вход: R1:R0 - число
                mov     #'K, R0         ; выведем размер в килобайтах
                iot
                .word 2
                call    CRLFOU          ; сделать перевод строки
                call    CRLFOU          ; сделать перевод строки
                call    CRLFOU          ; сделать перевод строки
                clrb    D$FILLB(R3)     ; код заполнения при форматировании
                mov     T$RETR(R4), (R4) ; количество попыток
32$:            clr     D$SIDE(R3)      ; обнуляем сторону и дорожку
                clrb    D$UNIT(R3)      ; номер привода тоже обнуляем
                cmpb    T$FLPN(R4), #1  ; количество дисководов в системе 1?
                beq     26$             ; да - переход
                movb    T$DRVN(R4), D$UNIT(R3) ; иначе - задаём номер привода
26$:            mov     #400, D$SECLEN(R3) ; длина сектора в словах
                mov     T$SNTR(R4), D$MAXSEC(R3) ; число секторов на дорожке

                mov     T$SCSZ(R4), R0  ; размер сектора в байтах
                clr     R1
                mov     T$SNTR(R4), R2  ; число секторов на дорожке
                call    MULTIP          ; умножение R1:R0 = R1:R0 * R2
                asr     R0              ; получим размер дорожки в словах
                mov     R0, T$TRSZ(R4)
                ; форматируем и проверяем нулевую дорожку отдельно
                call    FORMAT          ; форматирование цилиндра. Форматируются все головки.
                bcs     27$
                clrb    D$SIDE(R3)      ; номер стороны диска 0/1
                call    VERIFY          ; Проверка цилиндра чтением. Читаются дорожки целиком со всех головок.
                bcc     28$             ; всё ОК - идём дальше
27$:            cmpb    #7, @#ERRFDD    ; ошибка 7 - Прерывание по вектору 4 во время операции?
                bne     29$             ; нет
31$:            jmp     V4$1            ; да - выходим

29$:            cmpb    #1, @#ERRFDD    ; ошибка 1?
                bne     30$
                mov     #22, R1         ; скажем, что диск защищён от записи
                call    OUTSTR
                br      31$             ; и выходим

30$:            dec     (R4)            ; попытки кончились?
                bne     32$             ; нет - повторим
                mov     #4, R1          ; форматирование не удалось
                call    OUTSTR
                mov     #3, R1          ; дор.0 плохая, диск неюзабельный
                call    OUTSTR
                br      31$             ; и выходим

                ; форматируем и проверяем остальные дорожки
28$:            movb    T$FLGD(R4), @D$FLGPTR(R3)
                movb    #345, D$FILLB(R3) ; код заполнения при форматировании
35$:            mov     T$RETR(R4), (R4)    ; количество попыток
                incb    D$TRK(R3)       ; следующая дорожка
                cmpb    D$TRK(R3), T$LTRN(R4)  ; дорожки кончились?
                bhi     33$             ; да - завершаем цикл
                movb    D$TRK(R3), R0   ; номер дорожки
                call    PROGRS
36$:            movb    #1, D$SECTOR(R3)
                call    FORMAT          ; форматирование цилиндра. Форматируются все головки.
                bcs     34$             ; ошибка - переходим
                tstb    T$VRFY(R4)      ; без ошибок, верификацию делать?
                beq     35$             ; нет
                call    VERIFY          ; Проверка цилиндра чтением. Читаются дорожки целиком со всех головок.
                bcc     35$             ; без ошибок - продолжаем
34$:            cmpb    #7, @#ERRFDD    ; ошибка 7 - Прерывание по вектору 4 во время операции?
                beq     31$             ; да - выходим
                dec     (R4)            ; попытки кончились?
                bne     36$             ; нет - повторим
                inc     T$BCNT(R4)      ; увеличим счётчик плохих цилиндров
                br      35$             ; и продолжаем

                ; всё, закончили форматирование
33$:            ; записываем бутблок
                clr     R0 ; номер блока на диске
                mov     #-400, R1 ; длина пересылаемого массива в словах
                .addr   R2, BUTSEC ; начальный адрес массива данных
                mov     R4, -(SP)
                call    @T$RSFA(R4)     ; !!! 160004
                mov     (SP)+, R4

                mov     T$SCSZ(R4), R0  ; размер сектора в байтах
                mov     T$FTSC(R4), R2  ; Число секторов в одной фат
                clr     R1
                call    MULTIP          ; умножение R1:R0 = R1:R0 * R2
                                        ; получим размер фат в байтах
                asr     R0
                mov     R0, -(SP)
                neg     (SP)            ; это размер фат в словах для записи
                ; записываем ФАТ
                mov     T$TBUF(R4), R1  ; адрес буфера чтения данных
                mov     R1, R2
                mov     R1, R5
37$:            clr     (R5)+
                sob     R0, 37$         ; формируем фат
                mov     #177400, (R1)
                bis     T$MDSR(R4), (R1)+
                mov     #377, (R1)
                mov     #1, R0          ; номер блока на диске
                mov     (SP), R1        ; длина пересылаемого массива в словах
                mov     R2, -(SP)       ; начальный адрес массива данных
                mov     R0, -(SP)
                mov     R4, -(SP)
                call    @T$RSFA(R4)     ; сохраняем первую копию ФАТ ; !!! 160004
                mov     (SP)+, R4
                mov     (SP)+, R0
                mov     (SP)+, R2
                bcc     38$
                jmp     WrtFailure$

38$:            add     T$FTSC(R4), R0  ; Число секторов в одной фат
                mov     (SP)+, R1
                mov     R4, -(SP)
                call    @T$RSFA(R4)     ; сохраняем вторую копию ФАТ ; !!! 160004
                mov     (SP)+, R4
                bcc     39$
                jmp     WrtFailure$

39$:            mov     #7, R1          ; форматирование завершено
                call    OUTSTR
                tst     T$MKSY(R4)      ; чё делать дальше?
                beq     40$             ; ничего
                call    COPSYS          ; копировать системные файлы
                bcs     40$             ; если ошибка - не выводить сообщение
                mov     #25, R1         ; системные файлы скопированы
                call    OUTSTR
40$:            mov     T$FTSC(R4), R0  ; Число секторов в одной фат
                asl     R0              ; умножим на 2
                inc     R0              ; + бут блок
                sub     R0, T$ASCN(R4)  ; отнимем от общего кол-ва секторов на диске
                mov     T$RDFN(R4), R0  ; число файлов в корневом каталоге
                clr     R1
                mov     #16., R2        ; в один сектор влазит 16 записей
                mov     R4, -(SP)
                call    DIVIDE          ; Деление
                                        ; Вход: R1:R0 - делимое
                                        ;       R2 - делитель
                                        ; Выход: R2:R4 - частное
                                        ;        R0 - остаток
                mov     R4, R0          ; сколько секторов занимает каталог
                mov     (SP)+, R4
                sub     R0, T$ASCN(R4)  ; отнимем от общего кол-ва секторов на диске
                mov     T$ASCN(R4), R0  ; сколько секторов осталось
                clr     R1
                mov     T$SCSZ(R4), R2  ; размер сектора в байтах
                call    MULTIP          ; умножение R1:R0 = R1:R0 * R2
                mov     R0, -(SP)
                mov     R1, -(SP)
                call    ITOA            ; конвертирование числа в текстовую форму и вывод на экран
                                        ; Вход: R1:R0 - число
                mov     #11, R1         ; размер диска в байтах
                call    OUTSTR
                mov     T$SYUS(R4), R0  ; сколько байтов используется системой
                beq     41$             ; нисколько
                clr     R1
                call    ITOA            ; конвертирование числа в текстовую форму и вывод на экран
                                        ; Вход: R1:R0 - число
                mov     #21, R1         ; используется системой
                call    OUTSTR
41$:            mov     T$BCNT(R4), R0  ; счётчик плохих цилиндров
                clr     R1
                mov     T$SCSZ(R4), R2  ; размер сектора в байтах
                call    MULTIP          ; умножение R1:R0 = R1:R0 * R2
                tst     R0              ; 0 ?
                beq     42$             ; игнорируем
                call    ITOA            ; конвертирование числа в текстовую форму и вывод на экран
                                        ; Вход: R1:R0 - число
                mov     #12, R1         ; байтов в плохих секторах !!! тут забраковывается цилиндр целиком!!! но в фат не помечается
                call    OUTSTR
42$:            mov     T$CLSC(R4), R0  ; количество секторов в кластере
                clr     R1
                mov     T$SCSZ(R4), R2  ; размер сектора в байтах
                call    MULTIP          ; умножение R1:R0 = R1:R0 * R2
                mov     R0, -(SP)
                call    ITOA            ; конвертирование числа в текстовую форму и вывод на экран
                                        ; Вход: R1:R0 - число
                mov     #15, R1         ; байтов в каждом кластере
                call    OUTSTR
                mov     (SP)+, R2       ; размер кластера
                mov     (SP)+, R1       ; размер используемого места на диске в байтах
                mov     (SP)+, R0
                sub     T$SYUS(R4), R0  ; сколько байтов используется системой
                mov     R4, -(SP)
                call    DIVIDE          ; Деление
                                        ; Вход: R1:R0 - делимое
                                        ;       R2 - делитель
                                        ; Выход: R2:R4 - частное
                                        ;        R0 - остаток
                mov     R4, R0          ; сколько кластеров доступно
                mov     (SP)+, R4
                clr     R1
                call    ITOA            ; конвертирование числа в текстовую форму и вывод на экран
                                        ; Вход: R1:R0 - число
                mov     #16, R1         ; доступно кластеров
                call    OUTSTR
                call    CRLFOU          ; сделать перевод строки
                mov     #2, R0
                call    SCRSET          ; манипуляции с режимами экрана
                                        ; Вход: R0 - код операции:
                                        ; 0 - сохранение текущего режима экрана
                                        ; 1 - переключение ширины символов
                                        ; 2 - переключение режима отображения курсора
                                        ; 3 - восстановление режима экрана
                mov     #10, R1         ; ещё форматировать?
                call    OUTSTR
                mov     T$BFV4(R4), @#4
                iot
                .word 15                ; Инициализировать драйвер (контроллер) дисковода.
                                        ; что-то это просто остановка двигателя.
                iot
                .word 1                 ; Ввод символа со стандартного устройства ввода
                                        ; (по умолчанию - консоль).
                                        ; выход: R0-код символа.
                bic     #240, R0
                cmpb    #'Y, R0         ; Y - да
                bne     L43$            ; всё остальное - нет
                call    CRLFOU          ; сделать перевод строки
                mov     T$CMDA(R4), R3
                jmp     START

L43$:           call    CRLFOU          ; сделать перевод строки
                mov     #3, R0
                call    SCRSET          ; манипуляции с режимами экрана
                                        ; Вход: R0 - код операции:
                                        ; 0 - сохранение текущего режима экрана
                                        ; 1 - переключение ширины символов
                                        ; 2 - переключение режима отображения курсора
                                        ; 3 - восстановление режима экрана
                mov     T$BFV4(R4), @#4
                iot
                .word 0

; ═══════════════════════════════════════════════════════════════════════════
; вывод  на экран прогресса форматирования
; Вход: R0 - номер дорожки

PROGRS:         clr     R1
                mov     #100., R2
                call    MULTIP          ; умножение R1:R0 = R1:R0 * R2
                                        ; t = CurTrk * 100
                mov     T$LTRN(R4), R2
                mov     R4, -(SP)
                call    DIVIDE          ; Деление
                                        ; Вход: R1:R0 - делимое
                                        ;       R2 - делитель
                                        ; Выход: R2:R4 - частное
                                        ;        R0 - остаток
                mov     R4, R0          ; t = t / LastTrkNum
                mov     (SP)+, R4
                clr     R1
                call    ITOA            ; конвертирование числа в текстовую форму и вывод на экран
                                        ; Вход: R1:R0 - число
                mov     #'%, R0
                iot
                .word 2

                mov     #13, R1         ; процентов завершено
                call    OUTSTR
                mov     #32, R5         ; и двигаем курсор назад
                mov     #10, R0
1$:             iot
                .word 2
                sob     R5, 1$
                return

; ═══════════════════════════════════════════════════════════════════════════
; сделать перевод строки

CRLFOU:         mov     #5015, R0
                iot
                .word 2
                swab    R0
                iot
                .word 2
                return

; ═══════════════════════════════════════════════════════════════════════════
; форматирование цилиндра. Форматируются все головки.

FORMAT:         mov     R4, -(SP)
                tst     T$OWND(R4)      ; как форматируем?
                bne     1$              ; нестандартно
                call    @#160012        ; стандартно
                br      2$

1$:             call    FRMTR$          ; форматирование своим драйвером
2$:             mov     (SP)+, R4
                bcs     4$              ; если ошибка - сразу выход
                cmpb    D$SIDE(R3), T$LSDN(R4) ; сторона последняя?
                beq     3$              ; да - закончим цикл
                incb    D$SIDE(R3)      ; нет - увеличим номер стороны
                br      FORMAT          ; и идём форматировать.

3$:             clrb    D$SIDE(R3)      ; снова нулевая головка
4$:             return

; ═══════════════════════════════════════════════════════════════════════════
; Проверка цилиндра чтением. Читаются дорожки целиком со всех головок.

VERIFY:         ; вычислим из номера текущей дорожки и стороны номер блока
                ; по формуле (c * H + h) * S, где c - номер текущей дорожки,
                ; H - количество сторон, h - номер текущей стороны, S - количество секторов на дорожке
                ;movb    D$TRK(R3), R0
                ;clr     R1
                ;mov     T$LSDN(R4), R2
                ;inc     R2
                ;call    MULTIP  ; умножение R1:R0 = R1:R0 * R2
                ;movb    D$SIDE(R3), R2
                ;add     R2, R0
                ;mov     D$MAXSEC(R3), R2
                ;call    MULTIP  ; умножение R1:R0 = R1:R0 * R2
                ;mov     T$TRSZ(R4), R1 ; размер дорожки в словах
                ;mov     T$TBUF(R4), R2 ; адрес буфера чтения данных
                ;mov     R4, -(SP)
                ;call    @T$RSFA(R4)     ; читаем дорожку ; !!! 160004
                ;mov     (SP)+, R4

                movb    #1, D$SECTOR(R3)    ; начальный сектор
                mov     T$TRSZ(R4), D$WCNT(R3) ; размер дорожки в словах
                mov     T$TBUF(R4), D$ADDR(R3) ; адрес буфера чтения данных
                mov     R4, -(SP)
                ; вот здесь проще так делать, чем через 160004
                call    @#160006        ; читаем дорожку через 160006
                mov     (SP)+, R4
                bcs     1$              ; ошибки были - переход
                cmpb    D$SIDE(R3), T$LSDN(R4) ; сторона последняя?
                beq     2$              ; да - закончим цикл
                incb    D$SIDE(R3)      ; нет - увеличим номер стороны
                br      VERIFY          ; и идём проверять.

2$:             clrb    D$SIDE(R3)      ; снова нулевая головка
1$:             return

; ───────────────────────────────────────────────────────────────────────────

WrtFailure$:    mov     #23, R1         ; ошибка записи на диск
                call    OUTSTR
V4$1:           mov     #START, SP
                .addr   R4, SYSPAR      ; рабочий буфер
                mov     #20, R1         ; форматирование прервано
                call    OUTSTR
                jmp     L43$

; ═══════════════════════════════════════════════════════════════════════════
; манипуляции с режимами экрана
; Вход: R0 - код операции:
; 0 - сохранение текущего режима экрана
; 1 - переключение ширины символов
; 2 - переключение режима отображения курсора
; 3 - восстановление режима экрана
SCRSET:         movb    T$MONT(R4), R1  ; тип монитора 0-БК0010,1-БК0011М,2-БК0011.
                asl     R1
                asl     R1
                asl     R1
                asl     R0
                add     R1, R0
                add     R0, PC          ; pc += (R1*4 + R0) * 2
                ; команды для БК10
                br      10$RES          ; сохранение текущего режима экрана
                br      10$SYW          ; переключение ширины символов
                br      10$CUR          ; переключение режима отображения курсора
                br      10$RES          ; восстановление режима экрана
                ; команды для БК11М
                br      11M$SSM         ; сохранение текущего режима экрана
                br      11M$SYW         ; переключение ширины символов
                br      11M$CUR         ; переключение режима отображения курсора
                br      11M$RSM         ; восстановление режима экрана
                ; команды для БК11
                br      11$SSM          ; сохранение текущего режима экрана
                br      11$SYW          ; переключение ширины символов
                br      11$CUR          ; переключение режима отображения курсора
                br      11$RSM          ; восстановление режима экрана
; ───────────────────────────────────────────────────────────────────────────

10$SYW:         movb    #377, @#56      ; Гашение курсора (0 - выкл., 377 - вкл.)
                tstb    @#40            ; режим?
                beq     1$              ; 64 символа в строке
                mov     #233, R0        ; Переключение режима "32/64 символа в строке"
                emt     16              ; включаем 64 символа в строке
1$:             return

10$CUR:         comb    @#56            ; Гашение курсора (0 - выкл., 377 - вкл.)
10$RES:         return
; ───────────────────────────────────────────────────────────────────────────

11M$SSM:        emt     52              ; чтение режима драйвера экрана
                mov     R0, T$SCRM(R4)
                return

11M$RSM:        mov     T$SCRM(R4), R0
                br      11M$1

11M$SYW:        emt     52              ; чтение режима драйвера экрана
                bic     #20007, R0
                br      11M$1

11M$CUR:        emt     52              ; чтение режима драйвера экрана
                bic     #20000, R0
11M$1:          emt     51              ; установка режима драйвера экрана
                return

; ───────────────────────────────────────────────────────────────────────────

11$SSM:         mov     T$BS11(R4), R0
                emt     34
                mov     (R0), T$SCRM(R4)
                return

11$SYW:         mov     T$SCRM(R4), R0
                bis     #20002, R0
                br      11$1

11$CUR:         mov     T$SCRM(R4), R0
                bis     #2, R0
                br      11$1

11$RSM:         mov     T$BS11(R4), R0
                mov     T$SCRM(R4), (R0)
11$1:           emt     64
                return

BUF$11:        .blkb 16                     ; буфер для БК11
; ───────────────────────────────────────────────────────────────────────────
; копирование системных файлов
COPSYS:         cmp     #1, T$MKSY(R4)      ; только резервируем место?
                beq     1$                  ; да
                mov     #32, R1             ; нет - копируем системные файлы и коммандком
                call    OUTSTR
1$:             mov     #2, R5
                mov     R4, R3              ; рабочий буфер будет тут теперь
                .addr   R4, FCBSYS          ; DXDOS.SYS
L4310:          movb    T$SYDN(R3), R0      ; номер системного устройства
                clrb    T$DFLG(R3)          ; просим вставить системный диск
                call    INSDSK
                movb    R0, (R4)
                iot
                .word 17                    ; Открыть файл методом FCB.
                                            ; вход: R4-адрес FCB.
                bcs     0Error$
                mov     F$FLSZ(R4), T$FLSZ(R3) ; размер файла в байтах.
                cmp     #2, T$MKSY(R3)      ; копировать?
                bne     3$                  ; нет
                mov     T$TBUF(R3), F$DTAD(R4) ; да
                mov     F$FLSZ(R4), F$RCSZ(R4)
                iot
                .word 41                    ; Прямой доступ,чтение.
                                            ; вход: R4-адрес FCB.
                                            ; выход: R0-сколько байт считано.
                                            ; Поля FCB не изменяются.
                bcs     0Error$
3$:             iot
                .word 20                    ; Закрыть файл.
                                            ; вход: R4-адрес FCB.
                bcs     0Error$
                mov     T$DRVN(R3), R0      ; номер рабочего устройства
                inc     R0
                incb    T$DFLG(R3)          ; просим вставить целевой диск
                call    INSDSK
                movb    R0, (R4)
                iot
                .word 26                    ; Создать файл.
                                            ; (если файл существовал ,то размер его устанавливается равным 0).
                                            ; вход: R4-адрес FCB.
                bcs     0Error$
                mov     T$FLSZ(R3), F$RCSZ(R4)
                mov     T$TBUF(R3), F$DTAD(R4)
                ;!!! охренеть. если в T$MKSY число 2, тут мы записываем мусор!!!
                iot
                .word 42                    ; Прямой доступ,запись.
                                            ; вход: R4-адрес FCB.
                                            ; выход: R0-сколько байт записано.
                                            ; Поля FCB не изменяются.
                cmp     #1, R5              ; это коммандком?
                beq     4$                  ; да
                movb    #A$RDONLY|A$HIDDEN|A$SYSTEM, F$ATTR(R4) ; нет - ставим атрибуты
4$:             iot
                .word 20                    ; Закрыть файл.
                                            ; вход: R4-адрес FCB.
                .addr   R4, FCBCOM          ; коммандком
                add     T$FLSZ(R3), T$SYUS(R3) ; сколько байтов используется системой
                cmp     #1, T$MKSY(R3)      ; только резервировать?
                beq     5$                  ; да - выход, не копируем
                dec     R5                  ; уменьшаем счётчик
                tst     R5                  ; всё скопировали?
                beq     5$                  ; да - выход
                jmp     L4310               ; копируем второй файл

5$:             mov     R3, R4
                return
; какая-то хрень получается. При резервировании места под системные файлы,
; они реально создаются, но содержат внутри мусор.
; однако ничем не отличаясь от реально скопированных.

0Error$:        cmpb    #25, @#ERRFDD
                bne     6$
                mov     #26, R1         ; системные файлы не найдены
                br      7$

6$:             mov     #23, R1         ; ошибка записи диск неюзабельный
7$:             call    OUTSTR
                clr     T$SYUS(R3)      ; сколько байтов используется системой
                mov     R3, R4          ; возвращаем как было
                sec
                return
; ───────────────────────────────────────────────────────────────────────────
; просьба вставить нужный диск в дисковод и нажать любую клавишу
INSDSK:         cmp     #1, T$FLPN(R3)  ; в системе только 1 дисковод?
                beq     1$              ; да
                mov     T$DRVN(R3), R1  ; нет - берём номер рабочего устройства
                inc     R1
                cmpb    R1, T$SYDN(R3)  ; оно равно системному?
                bne     2$              ; нет - выход
1$:             mov     #30, R1         ; вставьте системный диск
                tstb    T$DFLG(R3)
                beq     3$
                mov     #31, R1         ; вставьте целевой диск
3$:             call    OUTSTR
                iot
                .word 15                ; Инициализировать драйвер (контроллер) дисковода.
                                        ; что-то это просто остановка двигателя.
                movb    T$SYDN(R3), R0
                add     #100, R0        ; делаем из номера диска букву
                iot
                .word 2                 ; Вывод символа на стандартное устройство вывода
                mov     #33, R1         ; и нажмите любую клавишу, когда будете готовы
                call    OUTSTR
                iot
                .word 1                 ; Ввод символа со стандартного устройства ввода
                                        ; (по умолчанию - консоль).
                                        ; выход: R0-код символа.
                movb    T$SYDN(R3), R0
2$:             return

; ═══════════════════════════════════════════════════════════════════════════

SKIPWS:         cmpb    #40, (R5)
                bne     1$
                inc     R5
                br      SKIPWS

1$:             ccc
                return

; ═══════════════════════════════════════════════════════════════════════════
; умножение R1:R0 = R1:R0 * R2
MULTIP:         mov     R5, -(SP)
                mov     R3, -(SP)
                mov     R4, -(SP)
                mov     #16., R5
                clr     R3
                clr     R4
2$:             asr     R2
                bcc     1$
                add     R0, R3
                adc     R4
                add     R1, R4
1$:             asl     R0
                rol     R1
                sob     R5, 2$
                mov     R4, R1
                mov     R3, R0
                mov     (SP)+, R4
                mov     (SP)+, R3
                mov     (SP)+, R5
                return

; ═══════════════════════════════════════════════════════════════════════════

OUTSTR:         .addr   R2, STRARR
                br      1$
3$:             tstb    (R2)+
                bne     3$
1$:             dec     R1
                bgt     3$

2$:             movb    (R2)+, R0
                beq     4$
                iot
                .word 2
                br      2$

4$:             return

; ───────────────────────────────────────────────────────────────────────────
; конвертирование числа в текстовую форму и вывод на экран
; Вход: R1:R0 - число
ITOA:           mov     R3, -(SP)
                mov     R4, -(SP)
                mov     R5, -(SP)
                mov     R4, R3
                mov     T$ITOA(R3), R5      ; буфер формирования строки
                mov     #6, R4              ; сперва заполним пробелами
1$:             movb    #40, (R5)+
                sob     R4, 1$
2$:             tst     R1                  ; число больше 10.?
                bne     3$
                cmp     #10., R0
                bhi     4$                  ; нет - завершаем цикл
3$:             mov     #10., R2            ; да - делим на 10.
                call    DIVIDE              ; Деление
                                            ; Вход: R1:R0 - делимое
                                            ;       R2 - делитель
                                            ; Выход: R2:R4 - частное
                                            ;        R0 - остаток
                add     #'0, R0             ; формируем разряд
                movb    R0, -(R5)           ; сохраняем в буфер
                mov     R4, R0              ; то, что осталось
                mov     R2, R1              ; будем снова делить
                br      2$

4$:             add     #'0, R0             ; формируем разряд
                movb    R0, -(R5)           ; сохраняем в буфер
                mov     T$ITOA(R3), R1      ; и выводим на экран
                clr     6(R1)
                iot
                .word 11
                mov     (SP)+, R5
                mov     (SP)+, R4
                mov     (SP)+, R3
                return

; ═══════════════════════════════════════════════════════════════════════════
; Деление
; Вход: R1:R0 - делимое
;       R2 - делитель
; Выход: R2:R4 - частное
;        R0 - остаток
DIVIDE:         tst     R2
                beq     1$
                mov     R3, -(SP)
                mov     R5, -(SP)
                clr     R3
                clr     R5
                clr     R4
2$:             inc     R5
                asl     R2
                bcc     2$
3$:             ror     R2
4$:             add     #1, R4
                adc     R3
                sub     R2, R0
                sbc     R1
                bcc     4$
                add     R2, R0
                adc     R1
                sub     #1, R4
                sbc     R3
                asl     R4
                rol     R3
                sob     R5, 3$
                ror     R3
                ror     R4
                mov     (SP)+, R5
                mov     R3, R2
                mov     (SP)+, R3
                return

1$:             movb    #31, @#ERRFDD
                sec
                return


; ═══════════════════════════════════════════════════════════════════════════


INIT:           clr     (R3)                    ; Очистим копию РС КНГМД
                mov     #-1, D$TRKTAB(R3)       ; Заполним таблицу текущих дорожек
                mov     #-1, D$TRKTAB+2(R3)
                mov     #2000, D$TSTEP(R3)      ; Время перехода дорожки
                mov     #10000., D$TDOWN(R3)    ; Время опускания головки
                movb    #32., D$TRKCOR(R3)      ; Дорожка начала предкомпенсации
                movb    #20., D$BRETRY(R3)      ; Число повторов при ошибке
                clrb    D$FLAGS(R3)             ; Очистим флаги
                clr     D$FLGTAB(R3)            ;    и таблицу признаков
                clr     D$FLGTAB+2(R3)
                mov     #400, D$SECLEN(R3)
                mov     #10., D$MAXSEC(R3)      ; Занесём число секторов на дорожке = 10
                return

; ═══════════════════════════════════════════════════════════════════════════
; ENGINE: П/п выбора устройства

ENGINE:         mov     #177130, R4             ; Заполняем рабочие регистры
                mov     R4, R5                  ;    адресами PC
                tst     (R5)+                   ;    РД КНГМД
                bicb    #4, D$FLAGS(R3)         ; Очистим признак работы двигателя
                bit     #20, (R3)               ; Двигатель уже включён?
                beq     1$                      ; Нет - включим
                bisb    #4, D$FLAGS(R3)         ; Да - установим признак
1$:             bis     #20, (R3)               ; Включим двигатель
                mov     (R3), (R4)              ;    и запишем в регистр
                bic     #57, (R3)               ; Сбросим все другие регистры
                tstb    D$SIDE(R3)              ; Сторона верхняя?
                beq     2$                      ; Да - идём дальше
                bis     #40, (R3)               ; Нет - включим нижнюю
2$:             bicb    #177774, D$UNIT(R3)     ; Сбросим лишние биты
                movb    D$UNIT(R3), R1          ; Получим номер привода
                mov     PC, R0                  ; Получим базовый адрес
                add     #DMASK-., R0            ;    таблицы масок для приводов
                add     R1, R0                  ; Получим адрес нужной маски
                bisb    (R0), (R3)              ; Установим бит нужного привода
                add     R3, R1                  ; Получим базовый адрес
                add     #D$TRKTAB, R1           ;    таблицы D$TRKTAB
                mov     R1, D$CURTRK(R3)        ; Настроим указатель D$CURTRK
                call    SETPTR                  ; SETPTR: Настроим указатель D$FLGPTR
                bitb    #4, D$FLAGS(R3)         ; Мотор включён только что?
                bne     3$                      ; Нет - выходим
                clr     R1                      ; Да - подождём раскручивания
                sob     R1, .
                sob     R1, .
3$:             mov     (R3), (R4)              ; Записываем установки в регистр
                mov     D$TDOWN(R3), R1         ; Подождём опускания головки
                sob     R1, .
                return

; ───────────────────────────────────────────────────────────────────────────
DMASK:          .byte 1,2,4,10

; ═══════════════════════════════════════════════════════════════════════════
; SETPTR: П/п настройки указателя D$FLGPTR

SETPTR:         clr     D$FLGPTR(R3)            ; Очистим указатель D$FLGPTR
                bicb    #177774, D$UNIT(R3)     ; Отбросим лишние биты
                movb    D$UNIT(R3), D$FLGPTR(R3) ; Перешлём номер привода в D$FLGPTR
                add     R3, D$FLGPTR(R3)
                add     #D$FLGTAB, D$FLGPTR(R3) ;    получаем искомый адрес
                return

; ═══════════════════════════════════════════════════════════════════════════

GOTRK:          tstb    D$TRK(R3)               ; Нужна дорожка 00?
                beq     GOTO00                  ; Да - позиционируем прямо на нее
                tstb    @D$CURTRK(R3)           ; Положение головки известно?
                bpl     1$                      ; Да - будем искать требуемую
                call    GOTO00                  ; Нет - придётся сориентироваться
1$:             cmpb    @D$CURTRK(R3), D$TRK(R3)    ; Нужная дорожка совпадает с текущей?
                beq     2$                      ; Да - так что же мы тут делаем?
                bhi     3$                      ; Нет - искомая ближе к центру?
                call    GOUP                    ; Да - шагаем к центру
                br      1$                      ; Проверим, дошли ли

3$:             call    GODOWN                  ; Нет - шагнём к периферии
                br      1$                      ; Проверим, дошли ли

2$:             mov     #10000., R0             ; Подождём успокоения головки
                sob     R0, .
                return                          ; Теперь можно и выйти

; ═══════════════════════════════════════════════════════════════════════════
; GOUP: Шаг к центру

GOUP:           incb    @D$CURTRK(R3)           ; Номер дорожки станет на 1 больше
                bmi     1$                      ; Таких дорожек нет - выходим с ошибкой
                bis     #100, (R3)              ; Все в порядке - шагать будем вперёд
                br      3$                      ; Пойдём шагать

1$:             mov     #4, R0                  ; Выход с ошибкой 4
                jmp     ERROR

; ═══════════════════════════════════════════════════════════════════════════
; GODOWN: Шаг к периферии

GODOWN:         decb    @D$CURTRK(R3)           ; Номер дорожки станет на 1 меньше
                bit     #1, (R4)                ; Дошли до дорожки 00?
                beq     2$                      ; Нет - можно шагать
                clrb    @D$CURTRK(R3)           ; Дошли: теперь текущая - 00
                return                          ;    и можно выйти

2$:             bic     #100, (R3)              ; Шагать будем назад
3$:             mov     #200., R0               ; Подготовим задержку
                mov     (R3), (R4)              ; Перешлём направление шага в регистр
                sob     R0, .                   ; Подождём, пока контроллер "переварит"
                bis     #200, (R3)              ; Установим признак шага
                mov     (R3), (R4)              ;    и запишем в регистр
                mov     D$TSTEP(R3), R0         ; Получим задержку перехода дорожки
                sob     R0, .                   ;    и задержимся
                bitb    #1, @D$FLGPTR(R3)       ; Двойной шаг?
                beq     4$                      ; Нет - можно выходить
                bitb    #100, D$FLAGS(R3)       ; Мы возвращаемся на 00?
                bne     4$                      ; Да - возвращаться надо одинарным шагом
                mov     (R3), (R4)              ; Нет - придётся шагнуть ещё
                mov     D$TSTEP(R3), R0         ; Получим задержку перехода дорожки
                sob     R0, .                   ;    и задержимся
4$:             bic     #200, (R3)              ; Очистим признак шага
                return

; ═══════════════════════════════════════════════════════════════════════════
; GOTO00: П/п возврата на дорожку 00

GOTO00:         movb    #200, @D$CURTRK(R3)     ; Установим счётчик дорожек
                bisb    #100, D$FLAGS(R3)       ; Возвращаться надо одинарным шагом
1$:             call    GODOWN                  ; GODOWN: Шагнём к периферии
                bit     #1, (R4)                ; Дошли до 00?
                bne     2$                      ; Да - выходим
                tstb    @D$CURTRK(R3)           ; На какой дорожке должны находиться?
                bne     1$                      ; Не на нулевой - ещё шагнём
                mov     #3, R0                  ; На нулевой, а ее нет - ошибка 3
                bicb    #100, D$FLAGS(R3)       ; Сбросим режим одинарного шага
                jmp     ERROR                   ; Выходим с ошибкой

2$:             clrb    @D$CURTRK(R3)           ; Дошли - текущая теперь нулевая
                bicb    #100, D$FLAGS(R3)       ; Сбросим режим одинарного шага
                return

; ═══════════════════════════════════════════════════════════════════════════
; WRMAR: П/п записи маркера данных
; Входные данные: R0 - число записываемых слов 4E4E
WRMAR:          tstb    (R4)                    ; Готовность есть?
                bpl     WRMAR                   ; Нет - дождёмся
                mov     #47116, (R5)            ; Запишем 4E4E
                sob     R0, WRMAR               ; Повторим заданное число раз
                mov     #6, R0                  ; Запишем 12. нулевых байтов
1$:             tstb    (R4)                    ; Готовность есть?
                bpl     1$                      ; Нет - ожидаем
                mov     #0, (R5)                ; Записываем нули
                sob     R0, 1$                  ;    в нужном количестве
                bis     #1000, (R3)             ; Подготовим признак записи маркера
4$:             tstb    (R4)                    ; Контроллер готов?
                bpl     4$                      ; Нет - ждём
                mov     #120641, (R5)           ; Записываем маркер A1A1
                mov     (R3), (R4)              ; Передаём признак в контроллер
                bic     #1000, (R3)             ; Заранее снимем признак
5$:             tstb    (R4)                    ; Готовность есть?
                bpl     5$                      ; Нет - ожидаем
                mov     D$MARKER(R3), (R5)      ; Записываем маркер из буфера
                return

; ═══════════════════════════════════════════════════════════════════════════
; CORR: П/п установки прекоррекции

CORR:           bic     #2000, (R3)             ; Снимем прекоррекцию
                cmpb    D$TRKCOR(R3), @D$CURTRK(R3) ; Надо включать на текущей дорожке?
                bhi     1$                      ; Нет - пропустим
                bis     #2000, (R3)             ; Пора - включим
1$:             mov     (R3), (R4)              ; Перешлём управляющее слово
                mov     #200., R0
                sob     R0, .                   ; Подождём, пока контроллер воспримет
                return

; ───────────────────────────────────────────────────────────────────────────
; FORMAT: П/п форматирования
FRMTR$:         mov     SP, D$BUFSP(R3)         ; Сохраним SP,
                mov     #4, R0
                mov     (R0), D$BUF4(R3)        ;  @#4 в соответствующих буферах
                mov     PC, (R0)                ; Переназначаем вектор @#4 на себя,
                add     #VECT4-., (R0)          ;    теперь он равен 161512
                call    ENGINE                  ; Запустим двигатель
                call    GOTRK                   ; Позиционируем на нужную дорожку
                call    CORR                    ; Установим прекоррекцию
                bit     #4, (R4)                ; Защита записи включена?
                beq     1$                      ; Нет - начинаем форматировать
                mov     #1, R0                  ; Да - ошибка 1
2$:             jmp     ERROR                   ; Выходим с ошибкой

1$:             swab    D$SIDE(R3)              ; Обмениваем номера стороны и дорожки
                movb    D$FILLB(R3), D$WRTVAR(R3)   ; Делаем слово-заполнитель
                movb    D$FILLB(R3), D$WRTVAR+1(R3) ;    из байта-заполнителя
                movb    D$MAXSEC(R3), R1        ; Получим длину сектора
                mov     #1001, R2               ; Запомним номер сектора и код длины
                mov     #1000., R0              ; Время ожидания индекса
3$:             tst     (R4)                    ; Индекс есть?
                bpl     4$                      ; Исчез - начинаем записывать
                sob     R0, 3$                  ; Есть - ждём исчезновения
5$:             tst     (R5)                    ; Так и не исчез - прекратим запись
                mov     #6, R0                  ; Диск не вращается - ошибка 6
                swab    D$SIDE(R3)              ; Вернём все на место
                br      2$                      ; Выходим с ошибкой
; Запись на дорожку кода 4E4E
4$:             mov     #3200., R0              ; Установим максимальную длину
                mtps    #340                    ; При записи нам не мешать
                mov     #47116, (R5)            ; Записываем 4E4E
6$:             tst     (R4)                    ; Индекс появился?
                bmi     7$                      ; Да - начинаем запись
8$:             tstb    (R4)                    ; Готовность есть?
                bpl     8$                      ; Нет - ждём
                mov     #47116, (R5)            ; Записываем 4E4E
                sob     R0, 6$                  ; И так до конца дорожки
                br      5$                      ; Дорожка длинная, ошибка!

7$:             mov     #28., R0                ; В маркере будет 28. 4E4E (GAP1)
9$:             mov     #177241, D$MARKER(R3)   ; Адресный маркер (FEA1) - в буфер
                call    WRMAR                   ; WRMAR: Записываем адресный маркер
10$:            tstb    (R4)                    ; Готовность есть?
                bpl     10$                     ; Нет - ожидаем
                mov     D$SIDE(R3), (R5)        ; Записываем номер стороны и дорожки
                mov     (R3), (R4)              ; Перешлём управляющее слово
11$:            tstb    (R4)                    ; Готовность есть?
                bpl     11$                     ; Нет - дождёмся
                mov     R2, (R5)                ; Записываем номер сектора и код длины
                mov     #11., R0                ; В маркере будет 11. 4E4E (GAP2)
                mov     #175641, D$MARKER(R3)   ; Маркер данных (FBA1) - в буфер
12$:            bit     #40000, (R4)            ; Ждём записи CRC
                beq     12$
                call    WRMAR                   ; WRMAR: Записываем маркер данных
                mov     D$SECLEN(R3), R0        ; Получаем длину сектора
                dec     R0                      ; Одно слово запишем сейчас
13$:            tstb    (R4)                    ; Готовность есть?
                bpl     13$                     ; Нет - ожидаем
                mov     D$WRTVAR(R3), (R5)      ; Записываем заполнитель
                mov     (R3), (R4)              ; Перешлём управляющее слово
14$:            tstb    (R4)                    ; Готовность есть?
                bpl     14$                     ; Нет - дождёмся
                mov     D$WRTVAR(R3), (R5)      ; Записываем заполнитель
                sob     R0, 14$                 ; И так до конца сектора
                inc     R2                      ; Увеличим номер сектора
                mov     #18., R0                ; В маркере будет 18. 4E4E (GAP3)
;    Примечание. Если увеличить GAP3 до 24-27 слов, то запись будет производиться так
; же быстро, как и чтение (обычно заголовок очередного сектора проскакивает, и дорожка
; записывается не за один, а за 10 оборотов). Однако при превышении этой величиной
; определённого значения конец последнего сектора дорожки может наложиться на ее
; же начало.
16$:            bit     #40000, (R4)            ; Ждём записи CRC
                beq     16$
                sob     R1, 9$                  ; И так все сектора до конца дорожки
; Окончание записи дорожки
17$:            tstb    (R4)                    ; Готовность есть?
                bpl     17$                     ; Нет - ждём
                mov     #47116, (R5)            ; Запишем 4E4E
                tst     (R4)                    ; Индекс есть?
                bpl     17$                     ; Нет - продолжим запись до появления
18$:            tstb    (R4)                    ; Готовность есть?
                bpl     18$                     ; Нет - дождёмся
                mov     #47116, (R5)            ; Запишем 4E4E
                tst     (R5)                    ; Прекратим запись
                swab    D$SIDE(R3)              ; Вернём все на место
                clr     R0
                tst     (PC)+
ERROR:          sec
                movb    R0, @#ERRFDD
                mov     D$BUF4(R3), @#4         ; Восстановить вектор 4
                mov     D$BUFSP(R3), SP         ; Восстановить SP
                return
; ───────────────────────────────────────────────────────────────────────────

VECT4:          mov     #7, R0
                br      ERROR
; ============== начало загрузчика ==========================================
.include "dxdos_boot_v2.asm"
;============= конец загрузчика =============================================
COMSPK:         .asciz "COMSPEC="
                .even

FCBSYS:         .byte 0
                .ascii "DXDOS   SYS"
                .blkb FCB$SZ-F$MDRV

FCBCOM:         .byte 0
                .ascii "COMMAND COM"
                .blkb FCB$SZ-F$MDRV

SYSPAR:         .blkb 102

CustFDDBPB:     .blkb 74    ; рабочая область драйвера дисковода

ItoABuf:        .blkb 16    ; буфер, куда конвертируется число в текст
; таблица форматов
; 0 - дорожек
; 2 - сторон,
; 4 - секторов на дорожке
; 6 - количество секторов в кластере
; 10 - максимальное число файлов в корневом каталоге
; 12 - медиадескриптор
; 14 - число секторов в одной фат
; 16 - ёмкость в килобайтах
; 20 - размер структуры
FMTTBL:         .word 39., 1, 8.,  1, 64.,  376, 1, 160.
                .word 39., 1, 9.,  1, 64.,  374, 2, 180.
                .word 39., 2, 8.,  2, 112., 377, 1, 320.
                .word 39., 2, 9.,  2, 112., 375, 2, 360.
                .word 79., 1, 8.,  2, 112., 367, 1, 320.
                .word 79., 1, 9.,  2, 112., 370, 2, 360.
                .word 79., 2, 8.,  2, 112., 373, 2, 640.
                .word 79., 2, 9.,  2, 112., 371, 3, 720.
                .word 79., 2, 10., 1, 224., 360, 5, 800.
                .word 39., 2, 10., 1, 224., 360, 3, 400.
                .word 0 ; конец таблицы
STRARR:         .asciz "Parameters not compatible."<12><15>                         ; 1
                .asciz "Incorrect DOS version."<12><15>                             ; 2
                .asciz "Track 0 bad - disk unusable."<12><15>                       ; 3
                .asciz "Format failure."<12><15>                                    ; 4
                .asciz "Insert new diskette for drive "                             ; 5
                .asciz ":"<12><15>"and strike ENTER when ready..."<12><15>          ; 6
                .asciz "Format complete.               "<12><15><12><15><12><15>    ; 7
                .asciz "Format another (Y/N)? "                                     ; 10
                .asciz " bytes total disk space."<12><15>                           ; 11
                .asciz " bytes in bad sectors."<12><15>                             ; 12
                .asciz " percent completed."                                        ; 13
                .asciz " bytes available on disk."<12><15>                          ; 14
                .asciz " bytes in each allocation unit."<12><15>                    ; 15
                .asciz " allocation units available on disk."<12><15>               ; 16
                .asciz "Formatting  "                                               ; 17
                .asciz <15><12>"Format terminated."                                 ; 20
                .asciz " byte used by system."<12><15>                              ; 21
                .asciz "Disk write protected."<12><15>                              ; 22
                .asciz "Write failure, disk unusable."<12><15>                      ; 23
                .asciz "Invalid drive specification."<12><15>                       ; 24
                .asciz <12><15>"System transferred."<12><15><12><15>                ; 25
                .asciz "System files not found."<12><15>                            ; 26
                .asciz "Fatal error: COMSPEC not found !"                           ; 27
                .asciz "Insert system disk in drive "                               ; 30
                .asciz <12><15>"Insert target disk in drive "                       ; 31
                .asciz "Copies DX-DOS system files and command interpreter."<12><15><12><15> ; 32
                .asciz ":"<12><15>"and strike any key then ready."<12><15>          ; 33
                .ascii " FORMAT диск:/параметры"<12><15>
                .ascii "                    - форматирование дисков(внешняя команда)"<12><15>
                .ascii " Параметры :"<12><15>
                .ascii " /1                 Форматирование одной стороны дискеты."<12><15>
                .ascii " /4                 На 80-ти дорожечном дисководе дискета"<12><15>
                .ascii "                    форматируется на 40 дорожек."<12><15>
                .ascii " /8                 При форматировании на каждой дорожке"<12><15>
                .ascii "                    размещается 8 секторов."<12><15>
                .ascii " /9                 При форматировании на каждой дорожке"<12><15>
                .ascii "                    размещается 9 секторов."<12><15>
                .ascii "                   (По молчанию 10 секторов на дорожке)"<12><15>
                .ascii " /B                 После форматирования на диске"<12><15>
                .ascii "                    резервируется место для записи системы."<12><15>
                .ascii " /S                 После форматирования на диск переносится"<12><15>
                .ascii "                    система,диск становится системным."<12><15>
                .ascii " /?                 Вывод справочной информации."<12><15>
                .ascii " /D                 При форматировании используется"<12><15>
                .ascii "                     нестандартный драйвер."<12><15>
                .ascii "Возможно совместное использование ключей кроме /B /S"<12><15>
                .ascii "Ключи /8 /9 можно использовать только с ПЗУ 326,"<12><15>
                .asciz "либо с ключом /D."<12><15>                                  ; 34
                .even
EOF:            .word 0


                .END
