
; Processor:        1801VM1
; Target assembler: BK Turbo8 Cross Assembler
; Файл: MODE

.include "inc/dx_fcb.asm"

START:          mov     #START, SP
2$:             tstb    (R3)            ; сперва выполним код пропуска слова
                beq     1$
                cmpb    #40, (R3)
                beq     1$              ; найдём пробел
                inc     R3
                br      2$

1$:             call    SKIPWS          ; а затем пропустим пробелы
                mov     R3, R1
                .addr   R4, FCB
                iot
                .word 51                ; Произвести синтаксический разбор строки.
                mov     R1, R3
                iot
                .word 26                ; Создать файл.
                call    SKIPWS
                mov     #1, F$RCSZ(R4)  ; размер записи в байтах.
                .addr   R0, BUFFER
                mov     R0, F$DTAD(R4)  ; адрес обмена
3$:             cmpb    (R3), #40
                blo     7$
                cmpb    #'[, (R3)
                beq     5$
                cmpb    #'#, (R3)
                bne     4$
                inc     R3
                call    SKIPWS
                call    ATOI
                dec     R3
                mov     R1, BUFFER
                br      6$

4$:             movb    (R3), BUFFER
                br      6$

5$:             mov     #33, BUFFER
6$:             iot
                .word 25                ; Последовательная запись в файл.
                inc     R3
                call    SKIPWS
                br      3$

7$:             mov     #12, BUFFER
                iot
                .word 25                ; Последовательная запись в файл.
                iot
                .word 20                ; Закрыть файл.
                iot
                .word 0

; ═══════════════════════════════════════════════════════════════════════════
; пропуск пробелов

SKIPWS:         tstb    (R3)
                beq     1$
                cmpb    (R3), #40
                bne     1$
                inc     R3
                br      SKIPWS

1$:             ccc
                return

; ═══════════════════════════════════════════════════════════════════════════

ATOI:           clr     R1
1$:             movb    (R3)+, R2
                cmp     R2, #'0
                blo     3$
                cmp     #'9, R2
                blo     3$
                sub     #'0, R2
                add     R2, R1
                bmi     3$
                cmpb    (R3), #'0
                blo     2$
                cmpb    #'9, (R3)
                blo     2$
                asl     R1
                bmi     3$
                mov     R1, R2
                asl     R1
                bmi     3$
                asl     R1
                bmi     3$
                add     R2, R1
                bmi     3$
                br      1$

2$:             tst     (pc)+
3$:             sec
                return

; ───────────────────────────────────────────────────────────────────────────
BUFFER:         .word 0
FCB:            .blkb FCB$SZ+2


                .END
