; Processor:        1801VM1
; Target assembler: BK Turbo8 Cross Assembler

; ===========================================================================

.include "inc/FDDParam.asm"
.include "inc/dx_fat.asm"
.include "inc/dx_sys.asm"

BUTSEC:         nop
                br      START$
; ---------------------------------------------------------------------------
                .ascii  "DX-DOS"<0>
                .byte   0,2         ; 0x0b (013)    WORD    
                .byte   1           ; 0x0d (015)    BYTE    
                .word   1           ; 0x0e (016)    WORD    
FATNUM:         .byte   2           ; 0x10 (020)    BYTE  
MAXRFL:         .byte   224.,0      ; 0x11 (021)    WORD      ,  32 - 0
                .byte   100,6       ; 0x13 (023)    WORD      (16)
MEDIAD:         .byte   360         ; 0x15 (025)    BYTE Media descriptor - F0
FATSZE:         .word   5           ; 0x16 (026)    WORD      (16),  32 - 0
TRKSEC:         .word   10.         ; 0x18 (030)    WORD    
HEDNUM:         .word   2           ; 0x1a (032)    WORD  
                .byte   0           ; 0x1c (034)    DWORD    (.   )
                .byte   0
                .byte   0
                .byte   0
                .byte   0           ; 0x20 (040)    DWORD      (32),    > 32
                .byte   0
                .byte   0
                .byte   0
                .byte   0           ; 0x24 (044)    BYTE   .
                .byte   0           ; 0x25 (045)    BYTE /  .
                .byte   51          ; 0x26 (046)    BYTE   
                .byte   0           ; 0x27 (047)    DWORD ID ( )
                .byte   0
                .byte   0
                .byte   0
LABEL:          .ascii  "NO NAME    "   ; 0x2b (053)     , 11 
FAT12:          .ascii  "FAT12   "      ; 0x36 (066)      , 8 
                .word 0
; ---------------------------------------------------------------------------

START$:         movb    FATNUM, R2  ;   
                mov     FATSZE, R1  ;      
                inc     R0          ;    R0 -  ,  
                mov     R0, @#SYSDRV ;  
                call    IMULB       ;  R2  R1
                                    ; : R4 - 
                mov     R4, R0      ;      
                inc     R0          ;  
                clr     R2
                bisb    MAXRFL, R2  ;     
                mov     #16., R1    ;    
                call    IDIVB       ;  R2  R1, : R4 - ; 224./16. = 14. 
                add     R0, R4      ;  
                mov     R4, -(SP)
                mov     R3, R2      ;     
                add     #70, R2     ; ,    
                mov     #1, R1      ;    
                call    READD       ;    
                bcs     ERRLD1

                .addr   R5, DXDOSS  ;"DXDOS   SYS"
                mov     R2, R4
                mov     #13, R0     ;        DXDOS   SYS
1$:             cmpb    (R5)+, (R4)+
                bne     NOSYS$      ;    
                sob     R0, 1$
                mov     K$SIZE(R2), R2 ;   DXDOS.SYS
                mov     #1000, R1   ;  .    
                call    IDIVB       ;  R2  R1, : R4 - 
                mov     R4, R1      ; - 
                inc     R1
                mov     (SP)+, R0   ;    DXDOS.SYS,     
                mov     #LoADDOS, R2 ;  
                call    READD       ;   DXDOS.SYS
                bcs     NOSYS$
                jmp     @#LoADDOS

ERRLD1:         tst     (SP)+       ;   
                return              ;   
; ===========================================================================

;   
; :
; R0 -  
; R1 -  
; R2 -  
READD:          cmpb    MEDIAD, #373 ;     FB
                blos    4$          ;    
                mov     #1, R5      ;  ,  40 
                call    READ$
                bcc     0NOER$
4$:             clr     R5          ;  
                call    READ$
                bcs     NOSYS$
0NOER$:         return

NOSYS$:                             ;    
                .addr   R1, NOSYSD  ; "Non system disk or disk error"
3$:             movb    (R1)+, R0
                cmp     @#30, #152112 ; , 11  10, 11?
                bne     1$
                emt     63
                br      2$

1$:             emt     16
2$:             tst     R0
                bne     3$
                clr     @#177130
                halt

; ===========================================================================

; :
; R0 -  
; R1 -  
; R2 -  
; R5 -  
READ$:          mov     R2, D$ADDR(R3) ;      
                cmp     #2, HEDNUM  ;   ?
                beq     1$          ; ?
                bis     #2, R5      ; ,  

1$:             movb    R5, @D$FLGPTR(R3)  ;     
                mov     R1, -(SP)
                mov     R2, -(SP)
                mov     R0, -(SP)

6$:             mov     R0, -(SP)
                mov     R2, -(SP)
                mov     R1, -(SP)
                mov     #400, D$WCNT(R3) ;    .  1 
                mov     #10, R4     ;         ,   
                mov     TRKSEC, R5  ;    
                mov     R5, D$MAXSEC(R3) ;     ,    .
                swab    R5          ;  .  R0  .  R5

3$:             cmp     R5, R0
                bhi     2$
                sub     R5, R0
                sec
2$:             rol     R0          ;    .  R0
                sob     R4, 3$
                movb    R0, R4      ;  .   ,  
                clrb    R0
                swab    R0
                inc     R0          ;     
                clrb    D$SIDE(R3)  ;     
                cmp     R0, TRKSEC  ;     ?
                ble     4$          ;  -  
                incb    D$SIDE(R3)  ;  -     
                sub     TRKSEC, R0  ;     
4$:             bitb    #2, @D$FLGPTR(R3)
                beq     5$
                asrb    D$SIDE(R3)
                rolb    R4
5$:             movb    R4, D$TRK(R3) ;  
                movb    R0, D$SECTOR(R3) ;  
                call    @#160006    ; /   
                mov     (SP)+, R1
                mov     (SP)+, R2
                mov     (SP)+, R0
                bcs     10$
                inc     R0
                add     #1000, D$ADDR(R3)  ;   ,    
                sob     R1, 6$
10$:            mov     (SP)+, R0
                mov     (SP)+, R2
                mov     (SP)+, R1
                return

; ===========================================================================

;  R2  R1
; : R4 - 
IDIVB:          clr     R5
                clr     R4
0$:             inc     R5
                asl     R1
                bcc     0$
2$:             ror     R1
1$:             inc     R4
                sub     R1, R2
                bcc     1$
                add     R1, R2
                dec     R4
                asl     R4
                sob     R5, 2$
                ror     R4
                return

; ===========================================================================

;  R2  R1
; : R4 - 
IMULB:          mov     #8., R5
                clr     R4
0$:             asr     R1
                bcc     1$
                add     R2, R4
1$:             asl     R2
                sob     R5, 0$
                return

; ---------------------------------------------------------------------------
DXDOSS:         .asciz  "DXDOS   SYS"
NOSYSD:         .asciz  "Non system disk or disk error"
                .even
                .blkw   26
                .word   125125  ;  0xAA55

                .end

