; Processor:        1801VM1
; Target assembler: BK Turbo8 Cross Assembler

; ===========================================================================

.include "inc/FDDParam.asm"
.include "inc/dx_fat.asm"
.include "inc/dx_sys.asm"
;       .  1  == 1 
;     
BUTSEC:         nop
                br      START$
; ---------------------------------------------------------------------------
                .ascii  "DX-DOS"<0>
                .byte   0,2         ; 0x0b (013)    WORD    
                .byte   1           ; 0x0d (015)    BYTE    
LDRSZ:          .word   1           ; 0x0e (016)    WORD    
FATNUM:         .byte   2           ; 0x10 (020)    BYTE  
MAXRFL:         .byte   224.,0      ; 0x11 (021)    WORD      ,  32 - 0
                .byte   100,6       ; 0x13 (023)    WORD      (16)
MEDIAD:         .byte   360         ; 0x15 (025)    BYTE Media descriptor - F0
FATSZE:         .word   5           ; 0x16 (026)    WORD      (16),  32 - 0
TRKSEC:         .word   10.         ; 0x18 (030)    WORD    
HEDNUM:         .word   2           ; 0x1a (032)    WORD  
                .byte   0           ; 0x1c (034)    DWORD    (.   )
                .byte   0
                .byte   0
                .byte   0
                .byte   0           ; 0x20 (040)    DWORD      (32),    > 32
                .byte   0
                .byte   0
                .byte   0
                .byte   0           ; 0x24 (044)    BYTE   .
                .byte   0           ; 0x25 (045)    BYTE /  .
                .byte   51          ; 0x26 (046)    BYTE   
                .byte   0           ; 0x27 (047)    DWORD ID ( )
                .byte   0
                .byte   0
                .byte   0
LABEL:          .ascii  "NO NAME    "   ; 0x2b (053)     , 11 
FAT12:          .ascii  "FAT12   "      ; 0x36 (066)      , 8 
                .word 0
; ---------------------------------------------------------------------------
;  11  ,    R3,        , ..   
; .
; !!!,   11      160000G,     ,   10  11!  !
;  11  10 -    R0,       -  R3
; ,  11()    B,      0   .7
START$:         ;   
                clr     R5
                bit     #40000, @#177716
                beq     10$
                cmp     @#30, #152112
                beq     11m$
                cmp     @#30, #147552
                bne     10$         ;   EMT   -    11  
                                    ;     ,  ,   10,  ,  
                dec     R5
                ;  ,  ,   B   160000G
                cmp     R1, #2012
                bne     10$         ;    
                ;    
                mov     R3, R1      ;   R0  R3
                mov     R0, R3
                mov     R1, R0
                call    @#160010    ;   
                add     #D$FLGTAB, R1 ;     
                add     R3, R1
                mov     R1, D$FLGPTR(R3)
                movb    R0, D$UNIT(R3)
                br      10$

11m$:           inc     R5
10$:            mov     R5, (PC)+
BKType$:        .word   0           ; 0 - 10, 1 - 11, -1 - 11  
                inc     R0          ;    R0 -  ,  
                mov     R0, @#SYSDRV ;  
                mov     TRKSEC, D$MAXSEC(R3) ;     
                movb    FATNUM, R2  ;   
                mov     FATSZE, R1  ;      
                call    IMULB       ;  R2  R1
                                    ; : R4 - 
                mov     R4, R0      ;      
                add     LDRSZ, R0   ;  
                clr     R2
                bisb    MAXRFL, R2  ;     
                mov     #16., R1    ;    
                call    IDIVB       ;  R2  R1;
                                    ; : R4 - 
                ; R4 = 224./16. = 14. 
                mov     R4, R1
                add     R0, R4      ;  
                mov     R4, -(SP)
4$:             mov     R1, -(SP)   ;    
                mov     R3, R2      ;     
                add     #70, R2     ; ,    
                mov     #1000, R1   ;      
                call    READD       ;    
                bcs     ERRLD1
                mov     R0, -(SP)   ;  
                mov     #16., R1    ;    
3$:             tst     (R2)        ;  ?
                beq     NOSYS$      ; ,      
                mov     R2, R4      ;     DXDOS   SYS
                ;       ,       
                .addr   R5, DXDOSS  ; "DXDOS   SYS"
                mov     #13, R0     ; ?
1$:             cmpb    (R5)+, (R4)+
                bne     2$          ;  , 
                sob     R0, 1$
                ; 
                cmp     (SP)+, (SP)+ ;     
                mov     K$SIZE(R2), R1 ;   DXDOS.SYS
                mov     (SP)+, R0   ;    DXDOS.SYS,     
                mov     #LoADDOS, R2 ;  
                call    READD       ;   DXDOS.SYS
                bcs     RDERR$
                jmp     @#LoADDOS

2$:             add     #K$RECSZ, R2 ;      
                sob     R1, 3$      ;    
                mov     (SP)+, R0   ;  
                inc     R0          ;   
                mov     (SP)+, R1   ;     
                sob     R1, 4$
                br      NOSYS$

ERRLD1:         cmp     (SP)+, (SP)+ ;   
                return              ;   
; ===========================================================================


;   
; :
; R0 -  
; R1 -      
; R2 -  
; R3 -     
READD:          asr     R1          ;    
                adc     R1          ;    
                cmpb    MEDIAD, #373 ;     FB
                blos    4$          ;    
                mov     #1, R5      ;  ,  40 
                call    READ$
                bcc     0NOER$
4$:             clr     R5          ;  
                call    READ$
                bcs     RDERR$
0NOER$:         return

RDERR$:         .addr   R1, ERRRD
                br      3$

NOSYS$:         .addr   R1, NOSYSD  ;    
                                    ; "Non system disk or disk error"
3$:             movb    (R1)+, R0
                beq     2$
                tst     BKType$     ; , 11  10, 11?
                ble     1$
                emt     63
                br      3$

1$:             emt     16
                br      3$

2$:             clr     @#177130
                halt

; ===========================================================================

; :
; R0 -  
; R1 -      
; R2 -  
; R3 -     
; R5 -  
READ$:          cmp     #2, HEDNUM  ;   ?
                beq     1$          ; ?
                bis     #2, R5      ; ,  

1$:             movb    R5, @D$FLGPTR(R3)  ;     
                mov     R1, -(SP)
                mov     R2, -(SP)
                mov     R0, -(SP)
                call    @#160004   ; -  
                mov     (SP)+, R0
                mov     (SP)+, R2
                mov     (SP)+, R1
                return

; ===========================================================================

;  R2  R1
; : R4 - 
IDIVB:          clr     R5
                clr     R4
0$:             inc     R5
                asl     R1
                bcc     0$
2$:             ror     R1
1$:             inc     R4
                sub     R1, R2
                bcc     1$
                add     R1, R2
                dec     R4
                asl     R4
                sob     R5, 2$
                ror     R4
                return

; ===========================================================================

;  R2  R1
; : R4 - 
IMULB:          mov     #8., R5
                clr     R4
0$:             asr     R1
                bcc     1$
                add     R2, R4
1$:             asl     R2
                sob     R5, 0$
                return

; ---------------------------------------------------------------------------
DXDOSS:         .asciz  "DXDOS   SYS"
NOSYSD:         .asciz  "Non system disk."
ERRRD:          .asciz  "Disk read error."
                .even

.org BUTSEC + 776
                .word   0xAA55  ;  

                .end

