
; Processor:        1801VM1
; Target assembler: Turbo8 Assembler
; Файл: ADRES

;структура FCB, размер 52 байта
F$NDRV=0 	;номер дисковода: 0-текущий,1-'А',2-'В'...
F$FLNM=1 	;имя файла + суффикс файла
F$CBLK=14	;номер текущего блока(для функций последовательного доступа.
F$RCSZ=16	;размер записи в байтах.
F$FLSZ=20	;размер файла в байтах.
F$FLDT=24	;дата создания файла.
F$FLLD=26	;адрес загрузки файла в память (для исполняемых файлов)
F$IDEV=30	;идентификатор устройства.
F$DIRP=31	;положение имени файла в каталоге.
F$STCL=32	;начальный кластер .
F$TMP1=34	;используется DOS под разные нужды. как seek
F$TMP2=36	;так и как временный буфер всяких данных
F$CURR=40	;текущая запись (последов.доступ к файлам)
F$FOPN=41	;признак открытия файла?
F$RECN=42	;номер записи (для функций прямого доступа)
F$TMP3=46	;используется DOS
F$ATTR=47	;атрибуты файла
F$DTAD=50	;адрес обмена
FCB$SZ=52	;размер FCB

                mov     #1000, SP
                iot
                .word   60				;Получить версию DOS. 
                cmp     #400, R0
                beq     1$
                .addr   R1, DOSERR
                br      1EX$

1$:             .addr   R1, TITLE
                iot
                .word   11				;Вывод строки символов на устройство вывода 
                call    SKIPWS
                cmpb    (R3), #'/
                bne     2$
                inc     R3
                call    SKIPWS
                cmpb    (R3), #'?
                bne     2$
                .addr   R1, HLPTXT
                br      1EX$

2$:             .addr   R4, FCBBUF
                mov     R3, R1
                iot
                .word   51				;Произвести синтаксический разбор строки. 
                mov     R1, R3
                bcc     3$
                .addr   R1, BADFIL
1EX$:           iot
                .word   11				;Вывод строки символов на устройство вывода 
                iot
                .word   0				;Завершение программы пользователя. 

3$:             iot
                .word   17				;Открыть файл методом FCB.
                bcc     4$
                .addr   R1, FILENF
                br      1EX$

4$:             call    SKIPWS
                .addr   R1, LODADR
                iot
                .word   11				;Вывод строки символов на устройство вывода 
                mov     F$FLLD(R4), R1
                call    OUT8
                tstb    (R3)
                beq     5$
                clr     R5
6$:             movb    (R3)+, R0
                tstb    R0
                beq     7$
                cmpb    R0, #'0
                blo     8$
                cmpb    #'7, R0
                blo     8$
                asl     R5
                asl     R5
                asl     R5
                sub     #'0, R0
                add     R0, R5
                br      6$

7$:             mov     R5, F$FLLD(R4)
                .addr   R1, NWLADR
                iot
                .word   11				;Вывод строки символов на устройство вывода 
                mov     R5, R1
                call    OUT8
                incb    F$TMP3(R4)
5$:             iot
                .word   20				;Закрыть файл.
                iot
                .word   0				;Завершение программы пользователя. 

8$:             .addr   R1, SNTERR
                iot
                .word   11				;Вывод строки символов на устройство вывода 
                br      5$

; ███████████████ S U B R O U T I N E ███████████████████████████████████████


OUT8:           mov     #6, R2
                clr     R0
1$:             rol     R1
                rol     R0
                add     #'0, R0
                iot
                .word   2
                dec     R2
                beq     CRLFOU
                clr     R0
                rol     R1
                rol     R0
                rol     R1
                rol     R0
                br      1$

CRLFOU:         mov     #5015, R0
                iot
                .word   2
                swab    R0
                iot
                .word   2
                return

; ███████████████ S U B R O U T I N E ███████████████████████████████████████


SKIPWS:         cmpb    (R3), #40
                bne     1$
                inc     R3
                br      SKIPWS

1$:             ccc
                return
; End of function SKIPWS

; ───────────────────────────────────────────────────────────────────────────
FCBBUF:         .blkb	56
FILENF:         .asciz "File not found"<12><15>
                .even
BADFIL:         .asciz "Bad file name"<12><15>
SNTERR:         .asciz "Syntax error"<12><15>
                .even
LODADR:         .asciz "Aдpec зaгpyзки фaйлa: "
                .even
NWLADR:         .asciz "Hoвый aдpec зaгpyзки: "
                .even
TITLE:          .asciz <12><15>"Adress version 1.00"<12><15><12><15>
DOSERR:         .asciz "Incorrect DOS version"<12><15><12><15>
HLPTXT:         .ascii " ADRES - пpocмoтp/измeнeниe"<12><15>
                .ascii "aдpeca зaгpyзки фaйлa в пaмять"<12><15><12><15>
                .ascii "вызoв для пpocмoтpa aдpeca :"<12><15>
                .ascii "   ADRES ИMЯ ФAЙЛA"<12><15><12><15>
                .ascii "вызoв для измeнeния aдpeca :"<12><15>
                .ascii "   ADRES ИMЯ ФAЙЛA нoвый aдpec"<12><15><12><15>
                .ascii "вызoв этoй инcтpyкции:"<12><15>
                .asciz "   ADRES /?"
                .even


                .END

