
; Processor:        1801VM1
; Target assembler: Turbo8 Assembler
; Файл: BK_IBM

; ───────────────────────────────────────────────────────────────────────────
;структура FCB, размер 52 байта
F$NDRV=0 	;номер дисковода: 0-текущий,1-'А',2-'В'...
F$FLNM=1 	;имя файла + суффикс файла
F$CBLK=14	;номер текущего блока(для функций последовательного доступа.
F$RCSZ=16	;размер записи в байтах.
F$FLSZ=20	;размер файла в байтах.
F$FLDT=24	;дата создания файла.
F$FLLD=26	;адрес загрузки файла в память (для исполняемых файлов)
F$IDEV=30	;идентификатор устройства.
F$DIRP=31	;положение имени файла в каталоге.
F$STCL=32	;начальный кластер .
F$TMP1=34	;используется DOS под разные нужды. как seek
F$TMP2=36	;так и как временный буфер всяких данных
F$CURR=40	;текущая запись (последов.доступ к файлам)
F$FOPN=41	;признак открытия файла?
F$RECN=42	;номер записи (для функций прямого доступа)
F$TMP3=46	;используется DOS
F$ATTR=47	;атрибуты файла
F$DTAD=50	;адрес обмена
FCB$SZ=52	;размер FCB
; ───────────────────────────────────────────────────────────────────────────
; Полная таблица внутрисистемной информации:
S$BUFT=0		;		буфер для сохранения PSW, а так же флаг чтение-запись
S$DOSA=2		;		адрес начала области окружения DOS
S$CLSZ=4		;		количество кластеров на диске
S$DBLA=6		;*		адрес списка дисковых блоков.(адреса абсолютные)
S$DOSZ=10		;		длина области окружения DOS (120 байтов)
S$ER52=12		;		номер прошлой ошибки в ячейке 52
S$CRDN=14		;(1б)	номер текущего устройства прямого доступа (дисковода).
S$DRVN=15		;*(1б)	количество устройств прямого доступа в системе.
S$FLPN=16		;*(1б)	количество дисководов в системе.
S$IONC=17		;(1б)	флаг, что буфер S$BIOA и S$SIOA не совпадают.
S$FWBF=20		;*		адрес рабочей области драйвера дисковода (длина 70 байтов).
S$STBP=22		;*		значение стробирующего бита для принтера : 400-для БК0010, 40000-для БК0011.
S$DATE=24		;		текущая дата
S$NMBF=26		;		адрес буфера длиной 14 байтов имени для поиска
S$BIOA=30		;		адрес области обмена с диском (адрес чтения/записи физического сектора), который можно изменить пользователем
S$TFCB=32		;		адрес буфера FCB под параметры устройства и промежуточных данных.
S$SIOA=34		;		системный адрес области обмена с диском (адрес чтения/записи физического сектора) не изменяемый
S$PRNF=36		;(1б)	флаг вывода на принтер. !0 - выводить, 0 - не выводить
S$INKF=37		;(1б)	флаг: 0 - ввод с клавиатуры, иначе - ввод с устройства ввода
S$BINA=40		;		адрес буфера устройства ввода, длиной 2 байта
S$DSTW=42		;		номер сектора каталога, который надо обработать
S$DIRP=44		;(1б)	номер записи в каталоге (для создаваемых файлов)
S$TPLF=45		;(1б)	признак, что имя задано шаблоном (для переименования)
S$FCIA=46		;		адрес FCB стандартного устройства ввода
S$BOUA=50		;		адрес буфера устройства вывода, длиной 2 байта
S$ISSP=52		;		вершина внутрисистемного указателя стека для перехватчика emt 36
S$RENF=54		;(1б)	флаг режима переименования (используется для внутренних целей)
				;55 - свободно
S$CDSN=56		;		номер обрабатываемого сектора каталога при операциях с каталогом
S$PDOS=60		;*		адрес начала DOS.
S$ONED=62		;(1б)	Флаг, указывающий, что в системе всего один дисковод (1, если всего 1 дисковод, иначе 0)
S$RSFA=64		;*		адрес таблицы подпр.чтения сектора с устройства (при старте устанавливается 160006 для всех устройств).
S$RSLA=66		;*		адрес таблицы подпр.чтения секторов на логическом уровне.(на уровне DOS)
S$CSNW=70		;		номер сектора в буфере, который надо сохранить
S$CSNB=72		;		номер сектора, который находится в буфере чтения/записи
S$DNWS=74		;		номер дисковода, на который надо сохранить сектор
S$DNSB=76		;(1б)	номер устройства, сектор которого в буфере чтения/записи
				;		76 иногда используется как слово, а иногда как байт
S$CDDN=100		;(1б)	номер дисковода, каталог которого в буфере
S$FCOA=102		;		адрес FCB стандартного устройства вывода
S$BRDT=104		;*(1б)	тип машины 0-БК0010, 1-БК0011М,2-БК0011.
S$MONT=105		;*(1б)	тип монитора 0-БК0010,1-БК0011М,2-БК0011.
S$BTFA=106		;		адрес области BAT файлов длиной 204 байта, первое слово - уровень вложенности
S$MBPT=110		;		указатель в памяти на обрабатываемые данные (куда читать с диска, откуда писать на диск)
S$FPTR=112		;(4б)	текущее положение указателя в файле
S$NCLS=116		;		количество обрабатываемых кластеров
S$BSCC=120		;		счётчик прочитанных/записанных байтов
S$SCLC=122		;		счётчик секторов в кластере
S$BIOO=124		;		смещение в буфере текущего сектора чтения/записи
S$SDNM=126		;*		адрес списка имён символьных устройств.(имена разделены нулевым байтом).
S$SDJA=130		;*		адрес таблицы переходов для символьных устройств.
S$IOTA=132		;		адрес таблицы подпрограмм IOT диспетчера
S$ERMA=134		;		адрес таблицы символьных сообщений об ошибке, строки разделяются 0
S$FADR=136		;		адрес загрузки/записи файла
S$FCRC=140		;		CRC файла
S$FSZE=142		;		размер файла
S$CMLA=144		;		адрес командной строки
S$CMLS=146		;		длина командной строки (длина 140 байтов)
S$CEMB=150		;		адрес буфера, перехвата ЕМТ команд, для монитора БК11 * 2
S$EMCN=152		;		количество ЕМТ команд, 132 для монитора БК11 и 50 для монитора БК10
S$EXSY=154		;		адрес функции выхода в ДОС
S$OV30=156		;		адрес адреса старого вектора 30, потом нигде не используется
S$BE36=160		;		адрес буфера копии имени в перехватчике emt36 (100 байтов)
S$LE36=162		;		длина буфера копии имени в перехватчике emt36 (100 байтов)
S$HRAM=164		;*		верхний адрес пользовательского ОЗУ.
S$PPAD=166		;*		адрес параллельного порта (при старте устанавливается значение 177714).
S$BLSZ=170		;размер таблицы внутрисистемной информации. резервируется 346 байтов
;* помечены официально описанные в документации ячейки

;переменные рабочего буфера
W$BFSA=0 	;адрес буфера источника
W$BUFS=2 	;размер буфера источника и приёмника
W$BFDA=4 	;адрес буфера приёмника
W$FILS=6	;размер файла в байтах. мл
;10	;размер файла в байтах. ст
W$SDBS=12	;размер прочитанного в буфер
W$FTBF=14	;флаг первого таба в строке
W$BCSB=16	;счётчик прочитанного в буфере
W$BCDB=20	;счётчик байтов в выходном буфере
W$PSBF=22	;указатель в буфере источника
;24 не используется
W$SFCB=26	;адрес FCB файла источника
W$DFCB=30	;адрес FCB файла приёмника
W$PDBF=32	;указатель в буфере приёмника
W$CMDA=34	;адрес начала аргументов командной строки
W$BLSZ=36	;размер рабочего буфера

                mov     #1000, SP
                mov     #6, R1
                mov     R3, -(SP)
                call    OUTSTN
                .addr   R3, WRKBUF
                mov     (SP)+, W$CMDA(R3)	;адрес начала аргументов командной строки
                iot
                .word   61				;Доступ к внутрисистемной информации.
                .addr   R0, EOF
                mov     R0, (R3)		;начало свободного ОЗУ, адрес буфера источника
                mov     S$HRAM(R1), R2	;верхний адрес пользовательского ОЗУ.
                sub     R0, R2			;размер доступного ОЗУ
                asr     R2				;половина для источника и половина для приёмника
                mov     R2, W$BUFS(R3)	;сохраним тут размер буфера источника и приёмника
                add     R2, R0			;начало ОЗУ для приёмника
                mov     R0, W$BFDA(R3)	;сохраним  тут, это начало буфера приёмника
                mov     R0, W$PDBF(R3)	;и тут, а это указатель в буфере приёмника
                .addr   R4, FCBSRC
                clr     R2
                mov     W$CMDA(R3), R1	;обрабатываем командную строку
                call    SKIPWS
                iot
                .word   51				;Произвести синтаксический разбор строки.
                bcs     1EX$
                mov     R4, W$SFCB(R3)	;адрес FCB файла источника
                mov     R4, R5			;!!! бессмысленная команда
                .addr   R4, FCBDST
                call    SKIPWS
                clr     R2
                iot
                .word   51				;Произвести синтаксический разбор строки.
                bcs     1EX$
                mov     R4, W$DFCB(R3)	;адрес FCB файла приёмника
                mov     R4, R1
                mov     W$SFCB(R3), R0	;!!! если R5 не портится, то та команда не бессмысленна, зато эту можно оптимизировать
                mov     #14, R2
4$:             cmpb    (R0)+, (R1)+	;проверим, не совпадает ли источник с приёмником
                bne     1$
                sob     R2, 4$
                mov     #4, R1			;если да, то дальше продолжать невозможно.
                call    OUTSTN
                iot
                .word   0				;Завершение программы пользователя.

1$:             mov     W$SFCB(R3), R4	;адрес FCB файла источника
                mov     R4, R5			;!!! эта
                iot
                .word   17				;Открыть файл методом FCB.
                bcs     1EX$
                mov     R4, R5			;!!! или эта команда не нужна
                mov     W$DFCB(R3), R4	;адрес FCB файла приёмника
                iot
                .word   26				;Создать файл.
                bcs     1EX$
                mov     F$FLSZ(R5), W$FILS(R3)	;размер файла в байтах. мл
                mov     F$FLSZ+2(R5), W$FILS+2(R3)	;размер файла в байтах. ст
3$:             mov     #1, F$RCSZ(R4)	;размер записи в байтах. для приёмника
                mov     #1, F$RCSZ(R5)	;размер записи в байтах. для источника
                mov     (R3), F$DTAD(R5)	;адрес обмена
                mov     W$BUFS(R3), R0	;размер буфера для источника
                tst     W$FILS+2(R3)	;размер больше 64кб?
                bne     2$				;да - буфер заведомо меньше остатка размера файла
                cmp     R0, W$FILS(R3)	;буфер меньше остатка размера файла?
                blos    2$				;да
                mov     W$FILS(R3), R0	;нет, берём столько, сколько надо
                beq     1END$			;если ничего не осталось - то выход
2$:             mov     R4, -(SP)
                mov     R5, R4
                iot
                .word   47				;Считать несколько записей.
                bcs     1END$
                mov     (SP)+, R4
                bcs     1END$
                iot
                .word   15				;Инициализировать драйвер (контроллер) дисковода.
                sub     R0, W$FILS(R3)	;вычтем прочитанное из размера.
                sbc     W$FILS+2(R3)
                mov     R0, W$SDBS(R3)
                clr     W$BCSB(R3)
                call    WORK
                bcs     1EX$
                br      3$

1EX$:           movb    @#52, R0		;номер ошибки
                .addr   R1, CTCHER		;адрес массива
11$:            tstb    (R1)			;массив кончился?
                beq     1END$			;да
                cmpb    R0, (R1)		;номер ошибки тот, что нам нужен?
                beq     12$				;да
                tst     (R1)+			;двигаемся дальше по массиву
                br      11$

12$:            movb    1(R1), R1		;берём номер сообщения, которое надо вывести
                call    OUTSTN
1END$:          call    FLUSHD
                mov     W$DFCB(R3), R4
                iot
                .word   20				;Закрыть файл. приёмник
                mov     W$SFCB(R3), R4
                iot
                .word   20				;Закрыть файл. источник
                iot
                .word   15				;Инициализировать драйвер (контроллер) дисковода.
                iot
                .word   0				;Завершение программы пользователя.

WORK:           mov     W$PDBF(R3), R2	;указатель в буфере приёмника
                mov     (R3), W$PSBF(R3)	;указатель в буфере источника
4$:             movb    @W$PSBF(R3), R0		;берём очередной символ
                inc     W$PSBF(R3)
                inc     W$BCSB(R3)
                cmp     W$BCSB(R3), W$SDBS(R3)
                blos    1$
2$:             return

1$:             cmpb    #32, R0			;если это ^Z, то делаем что-то непонятное
                beq     L1756
                tstb    R0				;если это 0
                bne     3$
9$:             movb    #15, R0			;то это ибмский перевод строки
                iot
                .word   2
                call    FPUTCH
                bcs     2$
                movb    #12, R0
                iot
                .word   2
                call    FPUTCH
                bcs     2$
                br      4$

3$:             cmpb    R0, #11			;если это таб
                bhi     5$
                tst     W$FTBF(R3)		;это первый таб в строке?
                beq     6$				;да
                asl     R0				;иначе умножим его на 8
                asl     R0				;не очень понятна логика
                asl     R0
6$:             mov     R5, -(SP)
                movb    R0, R5
                inc     W$FTBF(R3)
7$:             movb    #40, R0
                iot
                .word   2
                call    FPUTCH
                bcs     8$				;при ошибке прервём цикл
                sob     R5, 7$
8$:             mov     (SP)+, R5
                bcs     2$
                br      4$

5$:             cmpb    #12, R0			;если это перевод строки
                beq     9$
                iot
                .word   2
                mov     R5, -(SP)
                cmpb    #177, R0
                bhis    10$
                .addr   R5, XLTTBL		;!!! решать такую задачу методом перебора, не самое умное решение
                                        ;можно оптимизировать, брать содержимое массива по индексу
13$:            tstb    (R5)			;таблица кончилась?
                beq     10$				;да
                cmpb    R0, (R5)		;нужный символ?
                beq     12$				;да, пойдём перекодируем
                tst     (R5)+			;нет - подвинемся дальше по таблице
                br      13$

12$:            movb    1(R5), R0		;возьмём ибмский символ
10$:            call    FPUTCH
                bcs     11$
                clr     W$FTBF(R3)		;сбрасываем счётчик табов
11$:            mov     (SP)+, R5
                bcs     2$
                br      4$
; ───────────────────────────────────────────────────────────────────────────
;вывод строки из массива строк.
;вход:	R1 - номер строки
OUTSTN:         .addr   R2, FILENF
L1752:          dec     R1
                ble     1$
L1756:          tstb    (R2)+
                bne     L1756
                br      L1752

1$:             mov     R2, R1
                iot
                .word   11
                sec
                return

; ███████████████ S U B R O U T I N E ███████████████████████████████████████
;пропуск пробелов

SKIPWS:         cmpb    (R1), #40
                bhi     1$
                tstb    (R1)+
                bne     SKIPWS
1$:             return
; End of function SKIPWS

; ───────────────────────────────────────────────────────────────────────────
;заполняем буфер, и по мере заполнения скидываем его на диск
FPUTCH:         movb    R0, (R2)+
                mov     R2, W$PDBF(R3)
                inc     W$BCDB(R3)		;увеличиваем счётчик байтов
                cmp     W$BUFS(R3), W$BCDB(R3)	;пока не достигнем конца буфера
                bhis    1RET$			;если не достигли - выйдем, иначе запишем буфер

FLUSHD:         mov     W$BFDA(R3), F$DTAD(R4)	;адрес буфера приёмника
                mov     W$BCDB(R3), R0	;сколько байтов в буфере
                beq     1RET$			;если нисколько, то и делать нечего
                clr     W$BCDB(R3)		;сбросим счётчик байтов
                iot
                .word   50				;Записать несколько записей.
                bcs     1RET$
                iot
                .word   15				;Инициализировать драйвер (контроллер) дисковода.
                mov     W$BFDA(R3), R2	;адрес буфера приёмника
                mov     R2, W$PDBF(R3)	;указатель на начало буфера
                mov     W$BUFS(R3), R1		;размер буфера
1RET$:          return
; ───────────────────────────────────────────────────────────────────────────
;таблица БКшный символ, ИБМский символ
XLTTBL:         .byte  340, 236
                .byte  341, 200
                .byte  342, 201
                .byte  343, 226
                .byte  344, 204
                .byte  345, 205
                .byte  346, 224
                .byte  347, 203
                .byte  350, 225
                .byte  351, 210
                .byte  352, 211
                .byte  353, 212
                .byte  354, 213
                .byte  355, 214
                .byte  356, 215
                .byte  357, 216
                .byte  360, 217
                .byte  361, 237
                .byte  362, 220
                .byte  363, 221
                .byte  364, 222
                .byte  365, 223
                .byte  366, 206
                .byte  367, 202
                .byte  370, 234
                .byte  371, 233
                .byte  372, 207
                .byte  373, 230
                .byte  374, 235
                .byte  375, 231
                .byte  376, 227
                .byte  377, 232

                .byte  300, 356
                .byte  301, 240
                .byte  302, 241
                .byte  303, 346
                .byte  304, 244
                .byte  305, 245
                .byte  306, 344
                .byte  307, 243
                .byte  310, 345
                .byte  311, 250
                .byte  312, 251
                .byte  313, 252
                .byte  314, 253
                .byte  315, 254
                .byte  316, 255
                .byte  317, 256
                .byte  320, 257
                .byte  321, 357
                .byte  322, 340
                .byte  323, 341
                .byte  324, 342
                .byte  325, 343
                .byte  326, 246
                .byte  327, 242
                .byte  330, 354
                .byte  331, 353
                .byte  332, 247
                .byte  333, 350
                .byte  334, 355
                .byte  335, 351
                .byte  336, 347
                .byte  337, 352

                .byte  241, 301
                .byte  243, 277
                .byte  244, 265
                .byte  245, 303
                .byte  246, 300
                .byte  247, 315
                .byte  250, 321
                .byte  252, 332
                .byte  253, 302
                .byte  254, 320
                .byte  255, 371
                .byte  256, 305
                .byte  257, 272
                .byte  260, 264
                .byte  261, 367
                .byte  262, 316
                .byte  263, 370
                .byte  265, 304
                .byte  266, 327
                .byte  267, 263
                .byte  271, 331
                .byte  272, 330
                .byte  273, 322
                .byte  274, 317
                .byte  275, 306
                .byte  276, 366
                .byte  277, 333
                .byte    0,   0

CTCHER:         .byte 25, 1
                .byte 24, 5
                .byte 22, 5
                .byte 35, 2
                .byte 30, 3
                .byte 21, 7
                ;!!! тут ошибка, эта таблица должна оканчиваться нулём, не стоит полагаться на волю случая,
                ; что в рабочем буфере будет 0 достаточно близко, чтобы не возникло глюков с
                ; неправильной обработкой номеров ошибок
WRKBUF:         .blkb 36

FCBSRC:         .blkb 54

FCBDST:         .blkb 54

FILENF:         .asciz "File not found"<12><15>					;1
                .asciz "Missing operand"<12><15>				;2
                .asciz "Bad file name"<12><15>					;3
                .asciz "Content of destination lost defore copy"<12><15>	;4
                .asciz "Disk full"<12><15>						;5
                .asciz <12><15>"    BK_IBM  version 1.00"<12><15><12><15>	;6
                .asciz "Invalid drive specification"<12><15>	;7
                .even
EOF:            .word   0

                .END

