
; Processor:        1801VM1
; Target assembler: Turbo8 Assembler
; Файл: CBOOT

; ───────────────────────────────────────────────────────────────────────────
;структура FCB, размер 52 байта
F$NDRV=0 	;номер дисковода: 0-текущий,1-'А',2-'В'...
F$FLNM=1 	;имя файла + суффикс файла
F$CBLK=14	;номер текущего блока(для функций последовательного доступа.
F$RCSZ=16	;размер записи в байтах.
F$FLSZ=20	;размер файла в байтах.
F$FLDT=24	;дата создания файла.
F$FLLD=26	;адрес загрузки файла в память (для исполняемых файлов)
F$IDEV=30	;идентификатор устройства.
F$DIRP=31	;положение имени файла в каталоге.
F$STCL=32	;начальный кластер .
F$TMP1=34	;используется DOS под разные нужды. как seek
F$TMP2=36	;так и как временный буфер всяких данных
F$CURR=40	;текущая запись (последов.доступ к файлам)
F$FOPN=41	;признак открытия файла?
F$RECN=42	;номер записи (для функций прямого доступа)
F$TMP3=46	;используется DOS
F$ATTR=47	;атрибуты файла
F$DTAD=50	;адрес обмена
FCB$SZ=52	;размер FCB

                mov     #1000, SP
                call    SKIPWS
                .addr   R4, FCBBTR
                iot
                .word   31				;Получение номера текущего устройства прямого доступа  
                inc     R0
                movb    R0, (R4)
                cmpb    #':, 1(R3)		;второй символ :? 
                bne     1$				;нет
                movb    (R3)+, (R4)		;да, значит первый - имя диска
                bic     #240, (R4)
                sub     #100, (R4)		;вот из него сделаем номер диска
                inc     R3
                call    SKIPWS
1$:             cmpb    #'/, (R3)
                bne     2$
                inc     R3
                call    SKIPWS
                cmpb    #'I, (R3)
                beq     3IBM$
                cmpb    #'B, (R3)
                beq     4BK$
                cmpb    #'?, (R3)
                beq     5HLP$
2$:             .addr   R1, ERRCML
                iot
                .word   11
                iot
                .word   0

4BK$:           iot
                .word   17				;Открыть файл методом FCB. 
                bcs     6$
                .addr   R5, BUFFER
                mov     R5, F$DTAD(R4)	;куда загружать
                mov     #1000, F$RCSZ(R4)	;размер буфера
                iot
                .word   41				;Прямой доступ,чтение.
                iot
                .word   20				;Закрыть файл
                movb    (R4), R0		;номер дисковода !!! получается пишем на тот диск, откуда читали?
                mov     R5, R2			;адрес буфера
                clr     R1				;номер сектора
                iot
                .word   55				;Абсолютно записать сектор. 
                iot
                .word   23				;Удалить файл. 
                .addr   R1, aOk
                iot
                .word   11
7$:             iot
                .word   0

6$:             .addr   R1, FILENF
                iot
                .word   11
                br      7$

3IBM$:          iot
                .word   21				;Найти первый файл по образцу. 
                bcc     8$
                iot
                .word   26				;Создать файл.
                bcs     9$
                .addr   R5, BUFFER
                mov     R5, F$DTAD(R4)
                mov     #1000, F$RCSZ(R4)
                movb    (R4), R0
                mov     R5, R2
                clr     R1
                iot
                .word   54				;Абсолютно считать сектор. 
                iot
                .word   42				;Прямой доступ,запись. 
                movb    #6, F$ATTR(R4)	;атрибуты файла
                iot
                .word   20				;Закрыть файл
                mov     #36353, (R5)
                mov     #42220, 2(R5)
                movb    (R4), R0
                mov     R5, R2
                clr     R1
                iot
                .word   55				;Абсолютно записать сектор. 
                .addr   R1, aOk
                iot
                .word   11
9$:             iot
                .word   0

8$:             .addr   R1, FILEEX
                iot
                .word   11
                br      9$

5HLP$:          .addr   R1, HELP
                iot
                .word   11
                iot
                .word   0

; ███████████████ S U B R O U T I N E ███████████████████████████████████████
;пропуск пробелов

SKIPWS:         cmpb    #40, (R3)
                bne     1$
                inc     R3
                br      SKIPWS

1$:             return
; End of function SKIPWS

; ───────────────────────────────────────────────────────────────────────────
FCBBTR:         .byte 0
                .ascii "BOOT    REC"
                .blkb 46

BUFFER:         .blkb 1002

ERRCML:         .asciz "Syntax error in command line."
FILENF:         .asciz "File BOOT.REC not found."
                .even
FILEEX:         .asciz "File BOOT.REC already exists."
aOk:            .asciz " Ok"
HELP:           .ascii "KOPPEKЦИЯ ЗAГPУЗOЧHOГO"<12><15>
                .ascii "CEKTOPA ДЛЯ PAБOTЫ HA"<12><15>
                .ascii "   IBM KOMЬЮTEPE."<12><15>
                .ascii "ПPABИЛO BЫЗOBA :"<12><15>
                .ascii " CBOOT <имя диcкa> /пapaмeтp"<12><15><12><15>
                .ascii "  ПAPAMETPЫ:"<12><15>
                .ascii " /IBM  - ПPEOБPAЗOBAHИE ДЛЯ IBM"<12><15>
                .ascii " /BK - ПPEOБPAЗOBAHИE ДЛЯ BK"<12><15>
                .ascii "ПOCЛE ПPEOБPAЗOBAHИЯ ДЛЯ IBM,"<12><15>
                .ascii "ДИCK CTAHOBИTCЯ HE CИCTEMHЫM !!!"<12><15>
                .ascii "БEЗ ФAЙЛA BOOT.REC BOCTAHOBЛEHИE"<12><15>
                .asciz "ЗAГPУЗOЧHOГO CEKTOPA HEBOЗMOЖHO!"
                .even

                .END
Принцип работы проги
Берем БКшную системную дискету, на которой есть файл cboot и
преобразуем ее в ибмский формат, следующим образом:
1. сохраняем копию загрузчика в файле boot.rec
если такой файл уже есть, то ничего не делаем, т.к. диск уже в ибмском формате
2. модифицируем загрузчик и записываем его обратно
преобразование обратно в БКшный формат:
1. ищем файл boot.rec
если его нет, то и не преобразовываем, т.к. никак
2. читаем файл boot.rec, и сохраняем его как загрузчик

Логика проги не очень правильная. Проще преобразовывать из формата в формат читая
первые 2 слова загрузчика.
Код выглядит так, будто его писали не на ассемблере, а на чем-то другом.



