
; Processor:        1801VM1
; Target assembler: Turbo8 Assembler
; Файл: COMMAND.COM

; Подозреваю, что эта прога была написана на Си, слишком много неоптимального кода
; и буфер глобальных переменных, которые используются как попало.
; ═══════════════════════════════════════════════════════════════════════════
;переменные системного буфера
;0		;флаг. если !0, то код 1..11 не первый идущий подряд. / и для дир - состояние ключей ком.строки
C$CLNM=2	;количество столбцов помещающихся на экране для дир
C$SFBF=2	;адрес текущего буфера FCB источников при склейке файлов !!! поменять адрес
C$SENV=4	;флаг установки переменной окружения значения по умолчанию !!! поменять адрес
C$TMP1=4	;для разных целей
C$TMP2=6	;для разных целей / для дир
C$STNM=10	;счётчик строк помещающихся на экране для дир. для постраничного вывода
C$FLCN=12	;для копирования - счётчик скопированных файлов / для дир - счётчик обработанных файлов в каталоге
C$OFCF=14	;(1б) флаг, что выходной файл уже создан для копирования
C$NMEV=15	;(1б)тип выравнивания числа 0 - по правому краю, !0 - по левому.
C$UNU1=16	;!!! не используется
C$FATR=17	;(1б)атрибуты записи для вывода дир.
C$AIOB=20	;буфер хранения старого адреса области обмена с диском
C$UNU2=22	;!!! не используется
C$STDO=24	;адрес FCB стандартного устройства вывода.
C$USED=26	;адрес START - C$CCSZ - 2 - 1000 - 200 - 14 - 16 - 2 - адрес начала занятой коммандкомом памяти
C$PSTI=30	;(1б)флаг перенаправления стандартного устройства ввода
C$PSTO=31	;(1б)флаг перенаправления стандартного устройства вывода
C$FRES=32	;количество свободного места в байтах (мл.слово)
;34		;количество свободного места в байтах (ст.слово)
C$QNSS=36	;(1б) количество '?' в шаблоне источника для копирования
C$QNSD=37	;(1б) количество '?' в шаблоне приёмника для копирования
C$PENV=40	;указатель в буфере переменной окружения
C$CPBF=42	;адрес начала буфера для копирования
C$CPBS=44	;размер буфера для копирования
C$FCST=46	;буфер временного FCB источника для копирования
C$BSNM=50	;счётчик прочитанных строк бат файла, если 0 - то не бат файл, а командная строка
C$STDI=52	;адрес FCB стандартного устройства ввода.
C$UNU3=54	;!!! не используется
C$ABAR=56	;адрес области BAT-файлов.
C$BFBF=60	;адрес буфера, куда читаются строки из бат файла
C$ECHO=62	;(1б) состояние переменной окружения ECHO, 0 = ON, >0 = OFF
C$EORF=63	;(1б) флаг, указывающий, что прочли неполный буфер, и хватит делать чтение
C$ENNM=64	;адрес списка имён переменных окружения
C$ENVL=66	;адрес списка значений констант
C$UNU4=70	;!!! не используется
C$NADF=72	;счётчик открываемых файлов при их склейке при копировании
C$FCBD=74	;конец области буферов FCB источников для копирования при склейке файлов, и по идее буфер FCB приёмника
C$FNFL=76	;флаг замены ведущих нулей пробелами при выводе числа
C$IADS=76	;(1б)счётчик FCB шаблонов для склейки при копировании
C$FSFL=77	;(1б)флаг этапа обработки шаблонов 0 - первый раз !0 - следующие разы при копировании
C$FCDT=100 	;буфер временного FCB приёмника для копирования
C$UNU5=102	;!!! не используется
C$NMBF=104	;адрес буфера для формирования числа в ITOA, чтобы потом его вывести на экран
C$DTBF=106	;адрес буфера под ввод даты
C$UNU6=110	;число 100 !!! не используется
C$MONT=112	;(1б) тип монитора БК
C$V4BF=114	;буфер хранения старого вектора 4 (можно поменять на 110)
C$VOLS=114	;общий размер диска в байтах (мл.слово) !!!ОШИБКА 114 это же адрес хранения старого вектора 4.
;116	;общий размер диска в байтах (ст.слово)
C$CCSZ=120	;размер системного буфера коммандкома
;----------------------------
BATBSZ=200	;размер буфера для чтения строк из бат файла
NMBFSZ=14	;размер буфера для формирования числа в ITOA, чтобы потом его вывести на экран
DTBFSZ=16	;размер буфера ввода даты
WRKBUF=1000	;рабочий буфер. размер как минимум 1000+1000
IOBFSZ=1000	;размер буфера ввода-вывода (да и блока чтения тоже.)
BATLBF=54	;размер буфера вложенностей области бат файлов
;область бат файлов. размер 204 байта. == 54 * 3
;максимальная вложенность бат файлов - 3
;первое слово - уровень вложенности, размер буфера уровня вложенности - 54
;но т.к. буфер уровня вложенности - это обычный FCB, то совсем непонятно,
;зачем надо было делать размер 54. Разве что было задумано сделать первое
;слово - уровень вложенности в каждом буфере. Но ведь нет.

;структура FCB, размер 52 байта
F$NDRV=0 	;номер дисковода: 0-текущий,1-'А',2-'В'...
F$FLNM=1 	;имя файла + суффикс файла
F$CBLK=14	;номер текущего блока(для функций последовательного доступа.
F$RCSZ=16	;размер записи в байтах.
F$FLSZ=20	;размер файла в байтах.
F$FLDT=24	;дата создания файла.
F$FLLD=26	;адрес загрузки файла в память (для исполняемых файлов)
F$IDEV=30	;идентификатор устройства.
F$DIRP=31	;положение имени файла в каталоге.
F$STCL=32	;начальный кластер .
F$TMP1=34	;используется DOS под разные нужды. как seek
F$TMP2=36	;так и как временный буфер всяких данных
F$CURR=40	;текущая запись (последов.доступ к файлам)
F$FOPN=41	;признак открытия файла?
F$RECN=42	;номер записи (для функций прямого доступа)
F$TMP3=46	;используется DOS
F$ATTR=47	;атрибуты файла
F$DTAD=50	;адрес обмена
FCB$SZ=52	;размер FCB

;Структура элемента каталога
D$NAME=0	;Короткое имя файла
D$ATTR=13	;Атрибуты файла
D$RSV1=14	;*Зарезервировано под Windows NT (должно содержать 0)
D$RSV2=15	;*Поле, уточняющее время создания файла (в десятках миллисекунд).
			; Значение поля может находиться в пределах от 0 до 199
D$TIME=16	;*Время создания файла
D$DATE=20	;*Дата создания файла
D$DLUS=22	;*Дата последнего обращения к файлу для записи или считывания данных
D$CLNH=24	;*Старшее слово номера первого кластера файла
D$TLWR=26	;Время выполнения последней операции записи в файл
D$DLWR=30	;Дата выполнения последней операции записи в файл
D$CLNL=32	;Младшее слово номера первого кластера файла
D$SIZE=34	;Размер файла в байтах (32-разрядное число)
;Знак "*" означает, что поле обрабатывается только в файловой системе FAT32. В системах FAT12 и FAT16 поле считается ;зарезервированным и содержит значение 0.


;START - C$CCSZ - 2 - 1000 - 200 - 14 - 16 - и опять буфер - под ввод даты
;START - C$CCSZ - 2 - 1000 - 200 - 14 - и ещё буфер - для формирования числа в ITOA, чтобы потом его вывести на экран
;START - C$CCSZ - 2 - 1000 - 200 - ещё буфер - для чтения строки бат файла
;START - C$CCSZ - 2 - 1000 - адрес области обмена с диском коммандкома
;START - C$CCSZ - 2 - адрес начала системного буфера коммандкома

START:          nop		;коммандком грузится в верхние адреса.
                br      1STRT$
;адрес вектора 4, обработка кнопки стоп
CMDV4:          .addr   R3, START-2
                sub     #C$CCSZ, R3		;указатель на системный буфер коммандкома
                mov     C$AIOB(R3), R0	;буфер хранения старого адреса области обмена с диском
                iot						;восстановим оригинальный адрес области обмена с диском
                .word   32				;Установление адреса области обмена с диском
                mov     C$V4BF(R3), @#4	;восстановим оригинальный адрес вектора 4
1STRT$:         mov     #WRKBUF, SP		;выставляем стек
                .addr   R3, START-2
                mov     #WRKBUF, R1		;очищаем всю память 
1$:             clr     (R1)+			;от начала буферов
                cmp     R1, R3			;до начала коммандкома.
                bne     1$
                sub     #C$CCSZ, R3		;указатель на системный буфер коммандкома
                mov     R3, R5			;сохраним для дальнейшего использования
                iot
                .word   57				;Получить адрес обмена с диском (адрес чтения/записи сектора).
                mov     R0, C$AIOB(R3)	;сохраним оригинальный адрес области обмена с диском
                mov     #4, R1
                mov     (R1), C$V4BF(R3)	;сохраним оригинальный адрес вектора 4
                mov     PC, (R1)
                add     #CMDV4-., (R1)	;перенаправим вектор 4 в нужную точку
				;начинаем инициализацию переменных системного буфера коммандкома
                mov     #26, C$STNM(R3)	;количество строк, помещающихся на экране для постраничного вывода дир 
                sub     #IOBFSZ, R5
                mov     R5, R0
                iot
                .word   32				;Установление адреса области обмена с диском
                iot
                .word   30				;Доступ к буферам DOS.
                mov     R0, C$ABAR(R3)	;адрес области BAT-файлов.
                mov     R2, C$STDO(R3)	;адрес FCB стандартного устройства вывода.
                mov     R1, C$STDI(R3)	;адрес FCB стандартного устройства ввода.
                sub     #BATBSZ, R5
                mov     R5, C$BFBF(R3)	;буфер чтения строк из бат файла
                mov     #100, C$UNU6(R3)	;!!!нигде не используется
                sub     #NMBFSZ, R5
                mov     R5, C$NMBF(R3)	;буфер для формирования числа в ITOA, чтобы потом его вывести на экран
                sub     #DTBFSZ, R5
                mov     R5, C$DTBF(R3)	;буфер ввода даты
                tst     -(R5)
                mov     R5, C$USED(R3)	;адрес начала занятой коммандкомом памяти
                .addr   R0, ENVNML
                mov     R0, C$ENNM(R3)
                .addr   R0, ENVVLL
                mov     R0, C$ENVL(R3)
                com     C$PSTI(R3)		;изначально буфер обнулён, поэтому команда выставляет флаги пересоздания стандартных устройств ввода-вывода
                clrb    C$ECHO(R3)		;выставляем значение ECHO ON
                mov     #4, C$CLNM(R3)
                iot
                .word   61				;Доступ к внутрисистемной информации.
                movb    105(R1), C$MONT(R3)	;тип монитора БК
                call    ECHOST			;получим состояние переменной окружения ECHO
                tst     C$SENV(R3)		;в процессе получения задавали значение по умолчанию?
                beq     L11$			;нет - сразу в рабочий цикл
                .addr   R1, CMDVER		;а иначе - выведем версию коммандкома
2$:             movb    (R1)+, R0
                beq     L11$
                cmp     #1, C$MONT(R3)
                bne     3$
                emt     63
                br      2$

3$:             emt     16
                br      2$

L11$:           mov     #WRKBUF, R4		;чистим рабочие буферы
                mov     R4, R5			;тут предполагается, что буферы начинаются с адреса 1000 и их размер 1000 слов, что может поменяться когда-нибудь
1$:             clr     (R5)+
                sob     R4, 1$
                tstb    C$PSTI(R3)		;стандартное устройство ввода пересоздавать надо?
                beq     2$				;нет
                mov     C$STDI(R3), R4	;адрес FCB стандартного устройства ввода.
                iot						;закроем стандартное устройство ввода
                .word   20				;Закрыть файл.
                .addr   R1, CONNME		;консоль
                iot						;формируем FCB консоли. R2 не определено, наверное лучше обнулить перед использованием. 
                .word   51				;Произвести синтаксический разбор строки.
                iot						;создаём стандартное устройство ввода - консоль
                .word   26				;Создать файл.
2$:             tstb    C$PSTO(R3)		;стандартное устройство вывода пересоздавать надо?
                beq     3$				;нет
                mov     C$STDO(R3), R4	;адрес FCB стандартного устройства вывода.
                iot						;закроем стандартное устройство вывода
                .word   20				;Закрыть файл.
                .addr   R1, CONNME		;консоль
                iot						;формируем FCB консоли. R2 не определено, наверное лучше обнулить перед использованием. 
                .word   51				;Произвести синтаксический разбор строки.
                iot						;создаём стандартное устройство вывода - консоль
                .word   26				;Создать файл.
                call    CRLFOU			;сделать перевод строки
3$:             clr     C$PSTI(R3)		;сбрасываем флаги
                mov     C$ABAR(R3), R4	;адрес области BAT-файлов.
                mov     (R4)+, R0		;первое слово - уровень вложенности
                tst     R0	;лишнее слово
                beq     9$				;вообще нет бат файла - обработаем командную строку
                dec     R0				;вычисляем вложенность
4$:             tst     R0				;максимальная вложенность - 3, т.к. размер области бат файлов == 204 байта
                beq     5$				;но тут никаких проверок не проводится, и мы спокойно можем портить память.
                add     #BATLBF, R4		;и по вложенности - нужное место в области бат файлов
                dec     R0	;лишнее слово
                br      4$	;тут переход надо на dec перед tst
;очень похоже, что буфер уровня вложенности бат файлов - обычный блок FCB
5$:             mov     #1, F$RCSZ(R4)	;размер записи в байтах.
                mov     C$BFBF(R3), F$DTAD(R4) ;адрес обмена - адрес буфера длиной BATBSZ
6$:             iot
                .word   24				;Последовательное чтение из файла.
                bcs     1$ERR
                mov     F$DTAD(R4), R5	;адрес обмена
                inc     F$DTAD(R4)
                cmpb    (R5), #15		;что прочитали? CR?
                beq     7$
                cmpb    (R5), #12		;LF?
                bne     6$				;нет - читаем дальше, пока не встретим перевод строки
7$:             iot						;вхолостую прочтём символ. по умолчанию предполагается, что за CR всегда идёт LF. иные варианты даже не рассматриваются. 
                .word   24				;Последовательное чтение из файла.
                bcs     1$ERR
                clrb    (R5)+			;формируем конец строки - 0
                clr     (R5)+			;!!! непонятный финт, предположительно хотели сделать event.
;я так понимаю, тут мы читаем в буфер очередную строку из бат файла. размер буфера - 200 байтов
;т.е. размер строки - не более 176 символов + перевод строки \r\n
;никаких проверок на переполнение не делается.
                inc     C$BSNM(R3)		;счётчик прочитанных строк
                mov     C$BFBF(R3), R1	;адрес буфера чтения бат файлов
                cmpb    #'@, (R1)		;строка начинается с собаки?
                bne     8$				;нет
                inc     R1				;да - символ пропустим
                br      10$				;и идём на обработку строки

8$:             tstb    C$ECHO(R3)		;эхо на экран нужно?
                bne     10$				;нет
                call    PREFIX			;выведем префикс командной строки
                iot						;выведем строку, адрес строки в R1 
                .word   11				;Вывод строки символов на устройство вывода
                call    CRLFOU			;сделать перевод строки
                br      10$				;и идём на обработку строки

9$:             call    PREFIX			;выведем префикс командной строки
                iot
                .word   64				;Получить доступ к командной строке.
                iot
                .word   6				;Буферизованный ввод с клавиатуры с возможностью редактирования.
                clr     C$BSNM(R3)		;обнулим счётчик прочитанных строк - значит не из бат файла чтение
10$:            tstb    (R1)			;а вообще обрабатываемая строка есть?
                beq     L11$			;нету - нечего обрабатывать
                call    PARSER			;парсим и обрабатываем команды
                br      L11$
;если произошла ошибка при чтении бат файла, то прекращаем его обработку
1$ERR:          dec     @C$ABAR(R3)		;уменьшаем уровень вложенности бат файлов
                iot
                .word   20				;Закрыть файл.
                br      L11$

; ═══════════════════════════════════════════════════════════════════════════
;разбор очередной строки бат файла /или командной строки
;вход:	R1 - адрес начала строки
PARSER:         mov     R1, R5			;адрес начала строки
1$:             tstb    (R5)			;если строка закончилась
                beq     3$				;то пойдём дальше
                bitb    #200, (R5)		; а пока проверим, что за символы
                bne     2$				;если 200..377, их игнорируем
                cmpb    #100, (R5)		; а из остальных делаем из маленьких букв
                bhi     2$
                bicb    #40, (R5)		;большие
2$:             inc     R5				;перейдём к следующему символу
                br      1$				;и так, пока строка не кончится

3$:             cmpb    1(R1), #':		;если второй символ :, то первый - имя диска
                bne     4$
                tstb    2(R1)			;если третий символ не конец строки, то это не задание текущего диска
                bne     4$
                movb    (R1), R0		;из имени диска
                sub     #'A, R0			;сделаем его номер.
                iot
                .word   16				;Задать текущий дисковод.
                br      5$				;и всё

4$:             mov     R1, R2
                .addr   R1, CMDSET		;поищем среди команд встреченное слово
                call    STRNUM			;вход:	R1 - адрес начала массива строк
										;		R2 - адрес эталонной строки
										;выход: R0 - номер строки * 2
										; если ошибок нет,
										;		R1 - указатель на конец строки
										;если ошибки есть
										;		R1 - указатель на начало эталонной строки
                bcs     1NOCMD			;не нашли - значит это не команда
                add     PC, R0			;а иначе
                add     (PC)+, R0		;пойдём обработаем команду
                .word     @CMDADR+2
                add     (R0), R0
                mov     R0, R5			;!!! для чего дублировать R0 и R5 ?
                call    (R5)
5$:             jmp     ERCTCH			;выходим, и если нужно - выведем сообщение об ошибке

1NOCMD:         mov     R1, -(SP)		;если не команда, то наверное имя файла
                mov     R1, R2			;проверим
                mov     #13, R0			;имена файлов только короткие.
7$:             cmpb    #'., (R2)+		;если точка - то нашли расширение
                beq     6$
                cmpb    (R2), #40		;если код <= пробела
                blos    8$				;то конец строки
                sob     R0, 7$
                br      8$
				;!!!тут можно немного оптимизировать
6$:             mov     C$ENVL(R3), R1	;адрес списка значений констант
                call    STRNUM			;если расширение == какое либо значение констант - ON, OFF или BAT
                bcc     9$				;то туда
				;!!! здесь какая-то глупость сделана. нужно обязательно разделить списки значений констант
				;и список нужных расширений.
8$:             mov     C$AIOB(R3), R0	;буфер хранения старого адреса области обмена с диском
                iot
                .word   32				;Установление адреса области обмена с диском
                mov     (SP)+, R1		;адрес строки имени файла
                call    REDIRC			;проверка перенаправления входного/выходного контекста
                bcs     1$EX
                mov     C$V4BF(R3), @#4	;восстановим вектор 4
                clr     R2				;флаг - не запускать файл ??? что за фигня?
                iot
                .word   46				;Исполнить программу.(Автозапуск работает корректно).
                br      1$EX
				;сюда по замыслу авторов попадаем, если запускаем бат файл. а заодно и он файл и офф файл
9$:             mov     C$ABAR(R3), R4	;адрес области BAT-файлов.
                mov     (R4)+, R5		;уровень вложенности
10$:            tst     R5				;если 0
                beq     11$				;то пора
                dec     R5				;а иначе, поищем нужный 
                add     #BATLBF, R4		;буфер уровня вложенности
                br      10$

11$:            clr     R2				;флаг - обычный разбор
                mov     (SP)+, R1		;адрес обрабатываемой строки - там имя бат файла
                iot
                .word   51				;Произвести синтаксический разбор строки.
                bcs     1$EX			;если фигня какая-то, а не файл то выход
                iot
                .word   17				;Открыть файл методом FCB.
                bcs     1$EX
                inc     @C$ABAR(R3)		;увеличиваем уровень вложенности.
1$EX:           jmp     ERCTCH			;и выходим

; ═══════════════════════════════════════════════════════════════════════════
;проверка перенаправления входного/выходного контекста
REDIRC:         mov     R1, -(SP)
4$:             tstb    (R1)
                beq     1$
                cmpb    #'>, (R1)		;если встретился такой знак
                bne     2$
                call    REDOUT			;то это перенаправление выходного контекста
                bcs     1$
                br      3$

2$:             cmpb    #'<, (R1)		;если встретился такой знак
                bne     3$
                call    REDINP			;то это перенаправление входного контекста
                bcs     1$
3$:             inc     R1
                br      4$

1$:             mov     (SP)+, R1
                return

; ═══════════════════════════════════════════════════════════════════════════
;перенаправление входного потока
REDINP:         tstb    C$PSTI(R3)		;входное устройство уже перенаправлено?
                beq     1$				;нет
RED$ER:         movb    #43, @#52		;да - скажем, что ошибка
                sec
                return

1$:             incb    C$PSTI(R3)		;установим флаг
                mov     C$STDI(R3), R4	;адрес FCB стандартного устройства ввода.
                mov     R1, -(SP)
                iot
                .word   20				;Закрыть файл.
                mov     (SP)+, R1
                inc     R1				;указатель сразу за <
                call    SKIPWS			;пропустим пробелы
                clr     R2				;обычный разбор
                iot
                .word   51				;Произвести синтаксический разбор строки.
                bcs     2$				;если какая-то неведома фигня, то ошибка
                mov     R1, -(SP)		;а иначе - это файл, который надо открыть.
                iot
                .word   17				;Открыть файл методом FCB.
                mov     (SP)+, R1
2$:             return

; ═══════════════════════════════════════════════════════════════════════════
;перенаправление выходного потока
REDOUT:         tstb    C$PSTO(R3)		;выходной поток уже перенаправлен?
                bne     RED$ER			;да - значит ошибка.
                incb    C$PSTO(R3)		;установим флаг
                mov     C$STDO(R3), R4	;адрес FCB стандартного устройства вывода.
                mov     R1, -(SP)
                iot
                .word   20				;Закрыть файл.
                mov     (SP)+, R1
                inc     R1				;указатель сразу за >
                cmpb    #'>, (R1)		;а там за ним второй >
                bne     1$				;нет - значит всё просто
				;иначе - открываем файл для дозаписи.
                inc     R1				;пропустим второй >
                call    SKIPWS			;пропустим пробелы
                clr     R2
                iot
                .word   51				;Произвести синтаксический разбор строки.
                bcs     2$
                mov     R1, -(SP)
                iot
                .word   17				;Открыть файл методом FCB.
                bcs     3$				;если не открывается, то пойдём создавать
                mov     F$FLSZ(R4), R0	;размер файла в байтах
                mov     F$FLSZ+2(R4), R1
                mov     #200, R2		;размер записи
                mov     R4, -(SP)
                call    DIVIDE
                mov     R4, R2
                mov     (SP)+, R4
                movb    R0, F$CURR(R4)	;текущая запись (последов.доступ к файлам)
                mov     R2, F$CBLK(R4)	;номер текущего блока(для функций последовательного доступа).
                mov     (SP)+, R1		;это мы так в конец файла переместились.
                br      4$				;!!! ну вот нафига?

                cmpb    #25, @#52		;!!!кусок мёртвого кода, видимо планировалось если файл не открылся
                beq     3$				;то идти создавать.
2$:             sec
                return

4$:             clc						;!!! оптимизировать. чуваки явно это не на асме писали. на си наверное.
                return

1$:             call    SKIPWS			;пропустим пробелы
                clr     R2				;обычный разбор
                iot
                .word   51				;Произвести синтаксический разбор строки.
                bcs     2$
3$:             mov     R1, -(SP)
                iot
                .word   26				;Создать файл.
                mov     (SP)+, R1
                bcc     4$
;обработка команды REM, комментарий !!! перенести куда-нибудь к другим командам, returnов везде хватает
CM$REM:         return

; ═══════════════════════════════════════════════════════════════════════════
;отрисовка префикса командной строки
PREFIX:         iot
                .word   31				;Получение номера текущего устройства прямого доступа
                add     #'A, R0
                iot
                .word   2				;Вывод символа на стандартное устройство вывода
                iot
                .word   15				;Инициализировать драйвер (контроллер) дисковода.
                mov     #'>, R0
                iot
                .word   2				;Вывод символа на стандартное устройство вывода
                return

; ═══════════════════════════════════════════════════════════════════════════
;обработка команды ECHO
CM$ECH:         mov     R1, R4			;адрес в строке за командой
                call    SKIPWS			;пропустим пробелы
                tstb    (R1)			;если за командой ничего нет
                beq     1$				;то туда пойдём
                mov     R1, R2			;а иначе проверим
                mov     C$ENVL(R3), R1	;что там такое написано
                call    STRNUM			;получим номер константы
                mov     R2, R1
                bcs     2$				;если не номер, то пойдём и просто выведем на консоль
                asr     R0				;а иначе номер * 2
                inc     R0				;превратим в номер по порядку, счёт начинается с 1
                mov     R0, -(SP)
                mov     #1, R1			;получим в буфере имя переменной окружения ECHO
                call    VARNAM
                mov     (SP)+, R1
                call    SETVAR			;и пойдём установим её новое значение
                bcs     3$				;если что-то не так
                call    ECHOST			;то там кроме получения статуса, ещё и значение по умолчанию устанавливается
3$:             return

1$:             tst     C$BSNM(R3)		;это мы в батнике?
                bne     4$				;да - просто игнорируем команду, выводить то нечего
                mov     #24, R1			;нет - в командной строке
                call    OUTERS			;выведем "Echo is"
                call    ECHOST			;получим состояние
                br      5$				;и выведем его

2$:             mov     R4, R1			;выведем то, что было за командой
                inc     R1
5$:             iot
                .word   11				;Вывод строки символов на устройство вывода
4$:             jmp     CRLFOU

; ═══════════════════════════════════════════════════════════════════════════
;Получение состояния переменной окружения ECHO
;выход:	R0 - числовое значение состояния
;		R1 - строковое значение переменной окружения
ECHOST:         mov     #1, R1			;номер переменной окружения ECHO
                call    VARNAM			;получим в буфере нужную переменную
                mov     #WRKBUF, R1		;адрес буфера нужной нам переменной
                iot
                .word   67				;Получить переменную из области окружения DOS.
										;выход: R2 указывает на значение переменной в окружении DOS.
										;R0 указывает на имя переменной в области окружения DOS.
										;если переменной нет ,то С=1 и R2 указывает на свободную строку в области окружения DOS.
                bcs     1$				;если такой переменной нету, пойдём устанавливать

                mov     C$ENVL(R3), R1		;адрес списка значений констант
                call    STRNUM			;получим номер константы
										;вход:	R1 - адрес начала массива строк
										;		R2 - адрес эталонной строки
										;выход: R0 - номер строки * 2
										; если ошибок нет,
										;		R1 - указатель на конец строки
										;если ошибки есть
										;		R1 - указатель на начало эталонной строки
                bcs     1$
                movb    R0, C$ECHO(R3)	;номер значения переменной окружения
                mov     R2, R1			;строковое значение переменной окружения
                return

1$:             mov     #1, R1			;номер значения ON для переменной окружения ECHO
                call    SETVAR			;устанавливаем значение
                inc     C$SENV(R3)		;отмечаем, что установили
                br      ECHOST			;повторим попытку получения переменной ECHO

; ═══════════════════════════════════════════════════════════════════════════
;обработка команды TYPE
CM$TYP:         mov     #WRKBUF, R4		;буфер для временного FCB
                call    NEXTTK			;пропустим пробелы, вроде ничего другого тут сделать не получится.
                clr     R2				;флаг - простой разбор
                iot
                .word   51				;Произвести синтаксический разбор строки.
                bcs     1$				;если не получилось - выход
                iot
                .word   17				;Открыть файл методом FCB.
                bcs     1$
                mov     #WRKBUF+BATLBF, F$DTAD(R4)	;адрес обмена - сразу за временным FCB
                mov     #1, F$RCSZ(R4)	;размер записи в байтах.
4$:             iot
                .word   24				;Последовательное чтение из файла.
                bcs     2$				;если неудача - выход
                iot
                .word   15				;Инициализировать драйвер (контроллер) дисковода.
                movb    @F$DTAD(R4), R0	;что прочитали
                cmpb    #32, R0			;это ^Z ?
                beq     2$				;да - конец файла
                tstb    R0				; 0 ?
                bne     3$				;нет
8$:             call    CRLFOU			;сделать перевод строки, т.к. 0 - бкшный перевод строки
                br      4$				;и продолжим

3$:             cmpb    R0, #11			;это что ?
                bhi     5$				;код больше 11
                tst     (R3)			;а коды 1..11 обрабатываются по особому.
                beq     6$				;первый 
                asl     R0
                asl     R0
                asl     R0
6$:             movb    R0, R5
                inc     (R3)
7$:             mov     #40, R0
                iot
                .word   2				;Вывод символа на стандартное устройство вывода
                sob     R5, 7$
                br      4$
;в общем. коды 1..11. Если это первый код, то он означает количество пробелов.
;а второй и все следующие идущие подряд коды 1..11 означают количество пробелов * 8.

5$:             cmpb    #12, R0			;это \n ?
                beq     8$				;да - делаем перевод строки. !!! Тут ошибка, этот код тоже должен очищать (R3)
                iot						;а все остальные символы - выводим средствами ДОС
                .word   2				;Вывод символа на стандартное устройство вывода
                clr     (R3)			;очищаем флаг.
                br      4$

2$:             iot
                .word   20				;Закрыть файл.
1$:             return

; ═══════════════════════════════════════════════════════════════════════════
;обработка команды REName
CM$REN:         mov     #WRKBUF, R4		;буфер для временного FCB
                call    SKIPWS			;пропустим ненужные пробелы, имя - что переименовываем
                clr     R2				;флаг - простой разбор
                iot
                .word   51				;Произвести синтаксический разбор строки.
                bcs     1$
                call    SKIPWS			;пропустим ненужные пробелы, имя - на что переименовываем
                add     #14, R4			;буфер для получения модифицированного временного FCB
                clr     R2				;флаг - простой разбор
                iot
                .word   51				;Произвести синтаксический разбор строки.
                bcs     1$
                mov     #WRKBUF, R4		;буфер для модифицированного временного FCB для переименования
                iot
                .word   27				;Переименовать файл.
1$:             return

; ═══════════════════════════════════════════════════════════════════════════
;обработка команды DEL и ERASE
CM$DEL:         call    REDIRC			;проверка перенаправления входного/выходного контекста
                bcs     1$				;если было, но не удалось, выйдем
                call    SKIPWS			;пропустим пробелы
                mov     #WRKBUF, R4
                clr     R2				;флаг - простой разбор
                iot
                .word   51				;Произвести синтаксический разбор строки.
                bcs     1$
                cmp     #13, R2			;по идее - это кол-во символов '?', но при R2==0 не входе, по документации, так быть не должно
                bne     2$				;какое-то условие
                mov     #5, R1			;вывод надписи "Аре ыоу суре?"
                call    OUTERS
                iot
                .word   1				;Ввод символа со стандартного устройства ввода
                bcs     1$
                bic     #177240, R0
                cmp     #'Y, R0			;и если ответили утвердительно
                bne     1$				;то только тогда удалять.
2$:             iot
                .word   23				;Удалить файл.
1$:             return

; ═══════════════════════════════════════════════════════════════════════════
;обработка команды SET
CM$SET:         call    REDIRC			;проверка перенаправления входного/выходного контекста
                bcs     1$				;если было, но не удалось, выйдем
                call    SKIPWS			;пропустим пробелы
                tstb    (R1)			;строка закончилась
                beq     4$				;да
                iot						;нет
                .word   70				;Записать переменную в область окружения DOS.
                return
;SET без параметров тупо выводит на экран список переменных окружения
4$:             iot
                .word   40				;Получить адрес области окружения DOS.
                add     R1, R2			;адрес конца области окружения
2$:             tstb    (R1)			;если в начале области окружения DOS 0
                beq     1$				;то просто выйдем
                movb    (R1)+, R0		;иначе получим очередной символ
                iot
                .word   2				;Вывод символа на стандартное устройство вывода
                tstb    (R1)			;дошли до конца строки?
                bne     3$				;нет
                call    CRLFOU			;сделать перевод строки
                inc     R1				;пропустим конец строки
3$:             cmp     R1, R2			;дошли до конца области окружения?
                blos    2$				;нет.
1$:             return

; ═══════════════════════════════════════════════════════════════════════════
;обработка команды COPY
CM$COP:         clr     C$QNSS(R3)		;чистим счётчики '?' в шаблонах
                clr     C$FLCN(R3)		;счётчик скопированных файлов
                clrb    C$OFCF(R3)		;сбрасываем флаг, что выходной файл уже создан
                call    REDIRC			;проверка перенаправления входного/выходного контекста
                bcs     1$				;если было, но не удалось, выйдем
                call    SKIPWS
                mov     R1, -(SP)
2$:             mov     #17, R5
3$:             movb    (R1), R0
                tstb    R0				;!!!лишняя команда
                beq     4$
                cmpb    #40, R0
                bne     5$
                call    NEXTTK
                bcs     6$
                cmpb    (R1), #'+
                beq     7$
                br      2$

5$:             inc     R1
                sob     R5, 3$
                movb    #2, R1			;строка "Bad command or file name"
                call    OUTERS
6$:             mov     (SP)+, R1
1$:             return

7$:             jmp     CPY$AD			;склейка
;копирование типа шаблон1 -> шаблон2
4$:             mov     (SP)+, R1
                mov     #WRKBUF, R4		;тут FCB источника
                inc     R2				;формирование шаблона источника
                iot
                .word   51				;Произвести синтаксический разбор строки.
                bcs     ERR1$
                movb    R2, C$QNSS(R3)	;количество символов '?' в шаблоне источнике
                add     #FCB$SZ, R4		;тут FCB приёмника
                call    NEXTTK			;ищем следующий токен
                bcs     ERR1$			;если нету - то ошибка, конец строки - не ошибка
                inc     R2				;формирование шаблона приёмника
                iot
                .word   51				;Произвести синтаксический разбор строки.
                bcs     ERR1$
                movb    R2, C$QNSD(R3)	;количество символов '?' в шаблоне приёмнике
                mov     R4, -(SP)
                mov     R4, R5			;проверим
                sub     #FCB$SZ, R5		;не копируем ли
                mov     #13, R0			;сами в себя
8$:             cmpb    (R5)+, (R4)+
                bne     9$				;если нет - то продолжим
                sob     R0, 8$
                mov     (SP)+, R4
                mov     #7, R1			;строка "File cannot be copied onto itself"
                call    OUTERS
                jmp     CPY$EX			;и выходим.

9$:             mov     (SP)+, R4
                mov     #WRKBUF+300, C$CPBF(R3)	;адрес начала буфера для копирования
                mov     C$USED(R3), R0	;адрес конца буфера для копирования
                sub     C$CPBF(R3), R0
                mov     R0, C$CPBS(R3)	;размер доступного буфера для копирования
                add     #FCB$SZ, R4
                mov     R4, C$FCST(R3)	;буфер временного FCB источника
                add     #FCB$SZ, R4
                mov     R4, C$FCDT(R3)	;буфер временного FCB приёмника
                mov     #WRKBUF, R4		;FCB источника
                iot
                .word   21				;Найти первый файл по образцу.
                bcs     ERR1$			;ничего не нашлось - выйдем с ошибкой
                cmp     #-1, R1			;указатель получился ?
                bne     10$				;да
                tstb    C$QNSD(R3)		;нет. а для приёмника задавали шаблон?
                beq     10$				;нет, полное имя - значит норма
                mov     #2, R1			;да, шаблон - значит ошибка "Bad command or file name"
                jmp     OUTERS

ERR1$:          sec
                return

10$:            mov     R1, -(SP)
                tstb    C$QNSS(R3)		;в шаблоне источника были "?"
                beq     11$				;нет
                mov     #13, R5			;да
12$:            movb    (R1)+, R0		;выведем имя найденного файла
                iot
                .word   2				;Вывод символа на стандартное устройство вывода
                sob     R5, 12$
                call    CRLFOU			;сделать перевод строки
11$:            mov     (SP)+, R1
                mov     C$FCST(R3), R5	;временный FCB шаблона источника
                mov     #13, R0
                mov     R5, -(SP)
                movb    (R4), (R5)+		;скопируем привод из FCB источника в новый FCB источника
                cmp     #-1, R1			;указатель есть?
                bne     13$				;да - имя берём из найденной записи
                mov     #WRKBUF+1, R1	;нет - имя берём из FCB источника
13$:            movb    (R1)+, (R5)+
                sob     R0, 13$
                br      14$

15$:            cmp     #-1, R1
                bne     10$
                br      16$

14$:            mov     #WRKBUF+FCB$SZ, R2	;FCB приёмника
                mov     (SP)+, R4		;временный FCB шаблона источника
                mov     C$FCDT(R3), R5	;буфер временного FCB приёмника
                movb    (R2)+, (R5)+	;копируем туда из FCB приёмника привод
                inc     R4				;
                mov     #13, R0			;формируем выходное имя
19$:            cmpb    #'?, (R2)		;если не вопрос
                bne     17$
                movb    (R4), (R5)+		;берём символ из временного FCB шаблона источника
                br      18$

17$:            movb    (R2), (R5)+		;берём символ из FCB приёмника
18$:            inc     R4
                inc     R2
                sob     R0, 19$
                call    COPYFL			;выполняем собственно процедуру копирования данных
                bcs     20$
                mov     C$FCDT(R3), R4	;буфер временного FCB приёмника 
                tstb    C$QNSD(R3)		;приёмник задавали шаблоном
                beq     21$				;нет
                clrb    C$OFCF(R3)		;да - сбрасываем флаг, что выходной файл уже создан
                iot
                .word   20				;Закрыть файл.
                bcs     ERR1$
21$:            mov     #WRKBUF, R4
                iot
                .word   22				;Продолжить поиск файлов.
                bcc     15$				;если ещё что-то нашлось - продолжаем
                cmpb    #25, @#52		;если не ошибка 25
                bne     22$				;молча выходим
16$:            tstb    C$OFCF(R3)		;иначе, выходной файл создан?
                beq     CPY$EX			;нет, наверное уже закрыт
20$:            mov     C$FCDT(R3), R4	;закроем результирующий файл
                iot
                .word   20				;Закрыть файл.
CPY$EX:         mov     C$FLCN(R3), R0	;счётчик скопированных файлов
                clr     R1
                call    ITOA			;вывод числа из R1:R0
                mov     #12, R1			;строка " file "
                call    OUTERS
                mov     #23, R1			;строка " copied"
                call    OUTERS
                call    CRLFOU			;сделать перевод строки
22$:            return
; ───────────────────────────────────────────────────────────────────────────
;собственно процедура копирования содержимого файла
COPYFL:         mov     C$FCST(R3), R4	;буфер временного FCB источника - тут сформирован конкретный файл из найденного по шаблону
                tstb    C$OFCF(R3)		;выходной файл уже создан ?
                bne     1$				;да - пропускаем проверку, делали уже
                mov     R4, R1
                mov     C$FCDT(R3), R2	;проверим
                mov     #14, R0			;не копируем ли
2$:             cmpb    (R1)+, (R2)+	;файл сам в себя
                bne     1$
                sob     R0, 2$
                movb    #7, R1
                call    OUTERS
                sec
                return

1$:             iot
                .word   17				;Открыть файл методом FCB.
                bcs     ERR2$
                clrb    C$EORF(R3)		;очищаем флаг что прочли неполный буфер
                mov     F$FLSZ(R4), C$TMP1(R3)	;размер файла в байтах (мл.слово)
                mov     F$FLSZ+2(R4), C$TMP2(R3)	;(ст.слово)
10$:            mov     #1, F$RCSZ(R4)	;размер записи в байтах
                mov     C$CPBF(R3), F$DTAD(R4)	;адрес обмена
                mov     C$CPBS(R3), R0	;размер буфера для копирования
                tstb    F$IDEV(R4)		;идентификатор устройства.
                bmi     3$
                tst     C$TMP2(R3)		;если файл меньше
                bne     3$
                cmp     R0, C$TMP1(R3)	;чем размер буфера
                blos    3$
                mov     C$TMP1(R3), R0	;то читаем столько, сколько байтов в файле
                beq     4$
3$:             iot
                .word   47				;Считать несколько записей.
                bcs     ERR2$
                tst     R0				;что прочиталось?
                beq     5$				;ничего - выйдем
                mov     R0, -(SP)
                tstb    F$IDEV(R4)		;идентификатор устройства.
                bpl     6$
                cmp     R0, C$CPBS(R3)	;прочитался полный буфер?
                beq     6$				;да
                incb    C$EORF(R3)		;нет - отметим этот факт.
6$:             mov     R4, R5			;временный FCB источника
                mov     C$FCDT(R3), R4	;буфер временного FCB приёмника для копирования
                tstb    C$OFCF(R3)		;выходной файл уже создан ?
                bne     7$				;да - пропускаем создание
                incb    C$OFCF(R3)		;нет - помечаем, что создан
                iot
                .word   26				;Создать файл.
7$:             mov     (SP)+, R0
                bcs     ERR2$
                mov     F$FLDT(R5), F$FLDT(R4)	;дата создания файла.
                mov     F$FLLD(R5), F$FLLD(R4)	;адрес загрузки файла в память (для исполняемых файлов)
                mov     #1, F$RCSZ(R4)	;размер записи в байтах.
                mov     C$CPBF(R3), F$DTAD(R4)	;адрес обмена
                tstb    F$IDEV(R4)		;идентификатор устройства.
                bpl     8$
                iot
                .word   15				;Инициализировать драйвер (контроллер) дисковода.
8$:             iot
                .word   50				;Записать несколько записей.
                bcs     ERR2$
                mov     R5, R4			;временный FCB источника
                tstb    F$IDEV(R4)		;идентификатор устройства.
                bpl     9$				;если не системные стандартные устройства
                tstb    C$EORF(R3)		;прочитали неполный буфер
                bne     4$				;да - значит всё
                br      10$				;а иначе повторим

9$:             sub     R0, C$TMP1(R3)	;отнимаем буфер от размера файла
                sbc     C$TMP2(R3)
                tst     C$TMP2(R3)		;ещё там осталось копировать?
                bne     10$
                tst     C$TMP1(R3)		;да, осталось.
                bne     10$				;и продолжим.
4$:             inc     C$FLCN(R3)		;сосчитаем скопированный файл.
5$:             iot
                .word   20				;Закрыть файл.
ERR2$:          jmp     ERCTCH
; ───────────────────────────────────────────────────────────────────────────

CPY1EX:         jmp     CPY$EX
;копирование со склейкой нескольких файлов в один
CPY$AD:         clrb    C$QNSD(R3)		;снова чистим флаг !!!лишняя команда
                clr     R5				;счётчик склеиваемых файлов, заданных в командной строке
                clr     C$NADF(R3)		;счётчик открываемых файлов
                mov     (SP)+, R1
                mov     #WRKBUF, R4		;начало буферов FCB источников
3$:             cmpb    #'+, (R1)		;нашли "+" ?
                bne     1$				;нет - значит должно быть имя файла
                inc     R5				;да - подсчитаем найденное имя файла
                inc     R1				;двинемся за "+"
                br      2$				;идём искать начало имени файла

1$:             inc     C$NADF(R3)		;подсчитаем открываемый файл
                clr     R2				;простой разбор
                iot
                .word   51				;Произвести синтаксический разбор строки.
                bcs     CPY1EX			;если ошибка - выйдем
                add     #FCB$SZ, R4		;указатель на следующий буфер FCB
2$:             call    NEXTTK			;ищем следующий токен - имя файла или "+"
                bcs     CPY1EX
                cmpb    (R1), #40		;если что-то нашли, то 
                bhis    3$				;пойдём обработаем
                inc     R5				;первый файл перед "+" тоже надо сосчитать
                sub     C$NADF(R3), R5	;узнаем, скока файлов склеивать и скока из них надо открыть
                mov     R4, C$FCST(R3)	;буфер временного FCB источника для копирования
                add     #FCB$SZ, R4
                mov     R4, C$FCDT(R3)	;буфер временного FCB приёмника для копирования
                add     #FCB$SZ, R4
                mov     R4, C$CPBF(R3)	;адрес начала буфера для копирования
                mov     C$USED(R3), R0	;адрес начала занятой коммандкомом памяти
                sub     R4, R0			;узнаем, сколько памяти осталось под буфер копирования
                mov     R0, C$CPBS(R3)	;размер буфера для копирования
                tst     R5				;какие наши дальнейшие действия?
                bne     4$				;такие
                jmp     L5374			;или другие

4$:             mov     #WRKBUF, R4		;начало буферов FCB источников
                mov     #FCB$SZ, R0		;размер буферов
                clr     R1
                mov     C$NADF(R3), R2	;сколько буферов зарезервировали
                dec     R2
                call    MULTIP			;умножение
										;вход:	R1:R0 - множимое
										;		R2 - множитель
										;выход:	R1:R0 - результат
                add     R0, R4			;получим конец области буферов
                mov     R4, C$FCBD(R3)	;конец области буферов FCB источников для копирования при склейке файлов, и по идее буфер FCB приёмника
                mov     #WRKBUF, R4
                mov     C$NADF(R3), R5	;сколько буферов зарезервировали
                dec     R5				;!!! можно оптимизировать
                mov     C$FCBD(R3), R2	;!!! можно оптимизировать
                cmp     R4, R2			;начало совпадает с концом?
                bne     5$				;нет
8$:             add     #FCB$SZ, R4		;а если да, то в C$NADF(R3) было 1 и мы охренеть как зациклимся!!!
5$:             mov     R4, -(SP)
                mov     R2, -(SP)
                mov     #14, R0			;проверка на копирование источников
6$:             cmpb    (R2)+, (R4)+	;в один из источников
                bne     7$
                sob     R0, 6$
                cmp     (SP)+, (SP)+
                mov     #20, R1			;если да - то не дадим делать такое действие
                call    OUTERS
                jmp     CPY$EX

7$:             mov     (SP)+, R2
                mov     (SP)+, R4
                sob     R5, 8$			;и далее по списку. если в C$NADF(R3) было 1 тут будет зацикливание с крашем!!!
				;так что тут вместо sob надо использовать dec R5 bpl 8$

19$:            mov     #WRKBUF, C$SFBF(R3)	;начало буферов FCB источников
                movb    #1, C$IADS(R3)	;счётчик позиций в массиве буферов FCB источников
18$:            mov     C$SFBF(R3), R4	;берём буфер очередного FCB
                tstb    C$FSFL(R3)		;первый раз?
                bne     9$				;нет
                iot						;да - ищем первый файл
                .word   21				;Найти первый файл по образцу.
                bcs     11$				;неудача - конец копирования
                br      10$

9$:             iot						;ищем следующие файлы
                .word   22				;Продолжить поиск файлов.
                bcs     11$				;неудача - конец копирования
                cmp     #-1, R1			;конкретную запись получить не удалось?
                beq     11$				;конец копирования (почему при первом поиске можно, а при последующем нельзя, непонятно)
10$:            mov     C$FCST(R3), R2	;буфер временного FCB источника для копирования
                cmp     #-1, R1			;если при начале копирования конкретную запись получить не удалось
                bne     12$				;
                mov     C$SFBF(R3), R1	;то используем текущий буфер FCB источника.
                inc     R1
12$:            movb    (R4)+, (R2)+
                mov     R2, -(SP)
                mov     #13, R5
13$:            movb    (R1)+, (R2)+
                movb    -1(R2), R0
                iot
                .word   2				;Вывод символа на стандартное устройство вывода
                sob     R5, 13$			;формируем временный FCB источника для копирования
                call    CRLFOU			;сделать перевод строки
                mov     (SP)+, R2
                cmp     #WRKBUF, C$SFBF(R3)	;сейчас обрабатываем первый файл?
                bne     14$				;уже нет
                mov     C$FCDT(R3), R4	;буфер временного FCB приёмника для копирования
                mov     C$FCBD(R3), R1	;буфер FCB приёмника для копирования
                mov     #13, R5			;формируем выходное имя 
                movb    (R1)+, (R4)+
17$:            cmpb    #'?, (R1)		;шаблон?
                beq     15$
                movb    (R1), (R4)+
                br      16$

15$:            movb    (R2), (R4)+
                incb    C$QNSD(R3)		;(1б) количество '?' в шаблоне приёмника для копирования
16$:            inc     R2
                inc     R1
                sob     R5, 17$
14$:            call    COPYFL			;просто копируем файл источник в файл приёмник
                bcs     11$
                add     #FCB$SZ, C$SFBF(R3)	;переходим к следующему файлу источнику
                incb    C$IADS(R3)		;увеличиваем счётчик
                cmpb    C$IADS(R3), C$NADF(R3)	;ещё не конец?
                blo     18$				;продолжим. Вот это классический сишный цикл for (i=1;i<n;i++)
                incb    C$FSFL(R3)		;выставляем флаг следующего захода
                tstb    C$QNSD(R3)		;приёмник был задан шаблоном?
                beq     19$				;нет - повторим заход.
                mov     C$FCDT(R3), R4	;да - буфер временного FCB приёмника для копирования
                clrb    C$OFCF(R3)		;(1б) флаг, что выходной файл уже создан для копирования
                iot						;закроем текущий выходной файл
                .word   20				;Закрыть файл.
                bcc     19$				;и если всё в порядке - повторим заход, чтобы скопировать в следующий файл по шаблону
				;!!!тут забыли jmp     CPY$EX, т.к. если неудача при закрытии, не нужно ещё раз закрывать, надо сразу выходить.
11$:            mov     C$FCDT(R3), R4	;буфер временного FCB приёмника для копирования
                iot
                .word   20				;Закрыть файл.
                jmp     CPY$EX			;выход
; ───────────────────────────────────────────────────────────────────────────
;обработка операции типа COPY <шаблон1> + <шаблон2> + ... + <шаблон N> 
;- приклеивание к файлу < шаблон1> остальных. 
L5374:          clr     C$IADS(R3)		;чистим флаги. !!!эту команду надо перенести к метке CPY$AD
                mov     #WRKBUF, R4
                mov     R4, C$FCBD(R3)	;конец области буферов FCB источников для копирования при склейке файлов, и по идее буфер FCB приёмника
                mov     C$FCDT(R3), R5	;буфер временного FCB приёмника для копирования
                mov     #13, R0
                mov     R5, -(SP)
                movb    (R4)+, (R5)+
1$:             cmpb    #'?, (R4)
                bne     2$
                incb    C$QNSD(R3)		;(1б) количество '?' в шаблоне приёмника для копирования
2$:             movb    (R4)+, (R5)+	;формируем FCB приёмника
                sob     R0, 1$
                mov     (SP)+, R4
3$:             mov     #WRKBUF+FCB$SZ, C$SFBF(R3)	;начало буферов FCB источников
                movb    #1, C$IADS(R3)	;счётчик позиций в массиве буферов FCB источников
4$:             mov     C$SFBF(R3), R4	;берём буфер очередного FCB
                tstb    C$FSFL(R3)		;первый раз?
                bne     5$				;нет
                iot						;да - ищем первый файл
                .word   21				;Найти первый файл по образцу.
                bcs     6$				;неудача - конец копирования
                br      7$

5$:             iot						;ищем следующие файлы
                .word   22				;Продолжить поиск файлов.
                bcs     6$				;неудача - конец копирования
                cmp     #-1, R1			;конкретную запись получить не удалось?
                beq     6$				;конец копирования (почему при первом поиске можно, а при последующем нельзя, непонятно)
7$:             mov     C$FCST(R3), R5	;буфер временного FCB источника для копирования
                cmp     #-1, R1			;если при начале копирования конкретную запись получить не удалось
                bne     8$
                mov     C$SFBF(R3), R1	;то используем текущий буфер FCB источника.
                inc     R1
8$:             movb    (R4)+, (R5)+
                mov     #13, R2
9$:             movb    (R1)+, (R5)+
                movb    -1(R5), R0
                iot
                .word   2				;Вывод символа на стандартное устройство вывода
                sob     R2, 9$			;формируем временный FCB источника для копирования
                call    CRLFOU			;сделать перевод строки
                tstb    C$QNSD(R3)		;выходной файл задавался шаблоном?
                beq     10$				;нет
                mov     C$FCST(R3), R4	;буфер временного FCB источника для копирования
                mov     C$FCDT(R3), R4	;буфер временного FCB приёмника для копирования !!!ОШИБКА, должно быть R5
                mov     #WRKBUF, R2		;буфер FCB начального шаблона
                movb    (R2)+, (R5)+
                mov     #13, R0
                inc     R4
11$:            cmpb    #'?, (R2)
                bne     12$
                movb    (R4), (R5)+		;формируем окончательное FCB приёмника
                br      13$

12$:            movb    (R2), (R5)+
13$:            inc     R2
                inc     R4
                sob     R0, 11$

10$:            tstb    C$OFCF(R3)		;(1б) флаг, что выходной файл уже создан для копирования
                bne     14$				;да, создан
                incb    C$OFCF(R3)		;нет - создадим
                mov     C$FCDT(R3), R4	;буфер временного FCB приёмника для копирования
                iot
                .word   17				;Открыть файл методом FCB.
                mov     F$FLSZ(R4), F$RECN(R4)	;указатель seek в конец файла
                mov     F$FLSZ+2(R4), F$RECN+2(R4)
                bcc     14$				;если открылся, то норма
                cmpb    #25, @#52		;случилась ошибка 25?
                bne     15$				;нет - входим
                iot						;да - создадим файл
                .word   26				;Создать файл.
                bcs     15$
14$:            call    COPYFL			;копируем
                bcs     6$
                incb    C$IADS(R3)		;увеличиваем счётчик
                add     #FCB$SZ, C$SFBF(R3)	;переходим к следующему файлу источнику
                cmpb    C$IADS(R3), C$NADF(R3)	;ещё не конец?
                blo     4$				;продолжим. 
                incb    C$FSFL(R3)		;выставляем флаг следующего захода
                tstb    C$QNSD(R3)		;приёмник был задан шаблоном?
                beq     3$				;нет - повторим заход.
                mov     C$FCDT(R3), R4	;да - буфер временного FCB приёмника для копирования
                clrb    C$OFCF(R3)		;(1б) флаг, что выходной файл уже создан для копирования
                iot						;закроем текущий выходной файл
                .word   20				;Закрыть файл.
                bcc     3$				;и если всё в порядке - повторим заход, чтобы скопировать в следующий файл по шаблону
                br      15$				;а вот тут не забыли jmp     CPY$EX

6$:             mov     C$FCDT(R3), R4	;буфер временного FCB приёмника для копирования
                iot
                .word   20				;Закрыть файл.
15$:            jmp     CPY$EX			;выход

; ═══════════════════════════════════════════════════════════════════════════
;обработка параметров командной строки команды DIR?
DIRCMD:         call    SKIPWS			;пропустим пробелы
                call    DIRKEY			;поищем ключи
                bcs     ERR3$
                call    SKIPWS
                bit     #100000, (R3)
                beq     1$
                cmpb    #40, (R1)
                bhi     RET1$
1$:             bis     #100000, (R3)
                mov     R1, R5
                cmpb    #'>, (R1)
                bne     2$
                clrb    (R1)
                bis     #40000, (R3)
2$:             mov     #WRKBUF+IOBFSZ, R4	;тут будет шаблон вывода дир.
                inc     R2				;непростой разбор
                iot
                .word   51				;Произвести синтаксический разбор строки.
                bcs     RET1$
                bit     #40000, (R3)
                beq     3$
                movb    #'>, (R5)
3$:             call    SKIPWS
				;!!! похоже, тут сэкономили на returne, т.к. после знака > искать ключи бессмысленно
; ═══════════════════════════════════════════════════════════════════════════
;обработка ключей командной строки команды DIR
;слово состояния ключей
;бит 0 (01) - P
;бит 1 (02) - W
;бит 2 (04) - H
;бит 3 (10) - F
;бит 14 - наличие перенаправления
;бит 15 - наличие шаблона ???
DIRKEY:         cmpb    #'/, (R1)		;есть слеш?
                bne     1$				;нет - конец
                inc     R1				;пропустим
                call    SKIPWS			;между слешем и ключом оказывается можно ставить пробелы
                movb    (R1)+, R0		;посмотрим ключ.
                cmpb    #'P, R0
                bne     2$
                bis     #1, (R3)
                br      3$

2$:             cmpb    #'W, R0
                bne     4$
                bis     #2, (R3)
                br      3$

4$:             cmpb    #'H, R0
                bne     5$
                bis     #4, (R3)
                br      3$

5$:             cmpb    #'F, R0
                bne     ERR3$
                bis     #10, (R3)
3$:             call    SKIPWS			;снова пропустим пробелы
                br      DIRKEY			;и поищем следующий ключ

1$:             ccc
                return

ERR3$:          movb    #46, @#52		;ошибка параметров команды DIR
                sec
RET1$:          return

; ═══════════════════════════════════════════════════════════════════════════
;обработка команды DIR
CM$DIR:         clr     C$FLCN(R3)		;счётчик файлов в каталоге
                call    REDIRC			;проверка перенаправления входного/выходного контекста
                bcs     RET1$			;!!! подходящий  ret есть и чуть ниже
                mov     #4, C$CLNM(R3)	;кол-во столбцов, умещающихся на экране
                tst     C$MONT(R3)		;что за монитор?
                bne     1$				;БК11
                emt     34				;чтение слова состояния дисплея. БК10
                bit     #1, R0			;32 символа в строке?
                beq     2$				;нет
                br      3$				;да

1$:             cmpb    #2, C$MONT(R3)	;это БК11?
                beq     4$				;да
                emt     52				;чтение режима драйвера экрана БК11М
                bic     #177770, R0		;что там?
                beq     2$				;обычный 64 символа в строке
                cmp     #4, R0			;80 символов в строке?
                beq     2$				;да
                br      3$				;иначе - 32 символа в строке

4$:             mov     #WRKBUF, R0		;для БК11 всё посложнее
                emt     34				;чтение слова состояния дисплея. БК11
                bit     #2, (R0)		;режим 64 символа в строке?
                bne     2$				;да
3$:             asr     C$CLNM(R3)		;нет - 32 символа, значит на экране в ширину помещается в 2 раза меньше
2$:             mov     C$CLNM(R3), C$TMP1(R3)
                clr     (R3)
                mov     C$STNM(R3), C$TMP2(R3)	;тут 26 - счётчик строк помещающихся на экране
                mov     R1, -(SP)
                mov     #2, R1			;имя переменной окружения DIRCMD
                call    VARNAM			;получим
                mov     #WRKBUF, R1
                iot
                .word   67				;Получить переменную из области окружения DOS.
                bcs     5$				;если нету - то обработаем параметры командной строки
                mov     R2, R1			;если есть - сперва обработаем её значение
                call    DIRCMD			;разбор параметров
                bcs     6$
5$:             mov     (SP)+, R1
                call    DIRCMD			;разбор параметров
                bcc     7$
6$:             return
;собственно процедура вывода каталога на экран
7$:             mov     #WRKBUF+IOBFSZ, R4	;FCB шаблона
                movb    (R4), R0		;номер дисковода
                iot
                .word   66				;Получить размер свободного пространства на диске.
                bcs     6$
										;R0 количество свободных кластеров.
                mov     R2, -(SP)		;общее количество кластеров на диске.
                mov     R1, -(SP)		;секторов в кластере.
                mov     R1, R2
                clr     R1				;умножаем количество свободных кластеров на количество секторов в кластере.
										;получим количество свободных секторов.
                call    MULTIP			;вход:	R1:R0 - множимое
										;		R2 - множитель
										;выход:	R1:R0 - результат
                mov     #512., R2		;потом умножаем на 512.
                call    MULTIP			;и получим количество свободного места в байтах
                mov     R0, C$FRES(R3)	;и сохраним, это мл. слово
                mov     R1, C$FRES+2(R3)	;это ст. слово
                mov     (SP)+, R2		;секторов в кластере.
                mov     (SP)+, R0		;общее количество кластеров на диске.
                clr     R1
                call    MULTIP
                mov     #512., R2
                call    MULTIP			;теперь получим общий размер диска в байтах
                mov     R0, C$VOLS(R3)	;и сохраним, это мл. слово
                mov     R1, C$VOLS+2(R3)	;это ст. слово
                bit     #10, (R3)		;был ключ /F ?
                bne     8$				;да - пойдём просто выведем размер свободного пространства.
										;безо всяких каталогов.
				;вона оно как оказывается. а я думал будет просто более полный вид в виде доп. инфы в конце.
                iot
                .word   21				;Найти первый файл по образцу.
                bcs     6$				;ничего не найдено - молча выйдем. ничего не выводя.
9$:             mov     #13, R2
                movb    D$ATTR(R1), R5	;атрибуты найденной записи
                bic     #177400, R5		;!!!оптимизировать
                movb    R5, C$FATR(R3)	;сохраним
                bit     #20, R5			;это каталог? !!!ненужная проверка на каталог тут
                bne     10$				;!!! тут или ошибка, или чего-то не хватает
10$:            bit     #2, R5			;скрытый?
                beq     11$				;нет
                bit     #4, (R3)		;да, системный?
                beq     12$				;нет - пропустим запись.
11$:            movb    (R1)+, R0		;скрытые, но не системные пропускаем,
										;скрытые, но системные и обычные - выводим.
                iot
                .word   2				;Вывод символа на стандартное устройство вывода
                cmp     #4, R2			;пора выводить расширение?
                bne     13$				;нет ещё
                bit     #2, R5			;скрытый?
                beq     14$				;нет - выведем пробел
                mov     #277, R0		;а иначе выведем кирпич, чтобы обозначить скрытость
                iot
                .word   2				;Вывод символа на стандартное устройство вывода
                br      13$

8$:             br      15$				;да-да, идём-идём

14$:            call    SPSOUT			;выведем пробел, чтобы отделить расширение.
13$:            sob     R2, 11$
                inc     C$FLCN(R3)		;сосчитаем запись
                call    SPSOUT
                mov     R1, R5			;сейчас указывает на атрибуты
                dec     C$TMP1(R3)		;счётчик столбцов умещающихся на экране
                bit     #2, (R3)		;ключ /W был ?
                bne     16$				;да - пропустим подробности
                bitb    #20, C$FATR(R3)	;нет, запись - каталог ?
                beq     17$				;нет
                dec     C$FLCN(R3)		;да - не считается.
                mov     #22, R1			;строка " <DIR> "
                call    OUTERS
                br      18$				;и идём дальше

17$:            add     #21, R1			;а если не каталог, то
                mov     (R1)+, R0		;надо вывести размер файла
                mov     (R1), R1
                call    ITOA			;вывод числа из R1:R0
                call    SPSOUT			;пробел
18$:            add     #13, R5			;указатель на время создания файла
                mov     (R5)+, R1		;в оригинале - время создания, а у нас - адрес загрузки файла
                call    OUT8			;выводим адрес загрузки
                call    SPSOUT
                mov     (R5)+, R0		;затем дата создания
                cmp     #2, C$CLNM(R3)	;вывод в 2 столбца?
                beq     16$				;да - дата не полезает тогда
                call    DATOUT			;иначе выводим дату
16$:            bit     #1, (R3)		;ключ /P был ?
                beq     19$				;нет - не проверяем, сколько чего вывелось
                tst     C$TMP2(R3)		;строки все заполнились?
                bne     20$				;нет ещё
                mov     C$STNM(R3), C$TMP2(R3)	;да - восстановим значение
                call    CRLFOU			;сделать перевод строки
                call    PRANYK			;попросим нажать любую клавишу
                br      19$				;и продолжаем вывод

20$:            bit     #2, (R3)		;ключ /W был ?
                bne     21$				;да - тогда вывод в несколько столбцов
                call    CRLFOU			;сделать перевод строки
                dec     C$TMP2(R3)		;уменьшаем счётчик строк !!!можно оптимизировать
                br      12$				;и продолжим

19$:            bit     #2, (R3)		;ключ /W был ?
                beq     22$				;нет
21$:            tst     C$TMP1(R3)		;столбцы кончились?
                bne     12$				;нет ещё
                mov     C$CLNM(R3), C$TMP1(R3)	;восстановим значение
                dec     C$TMP2(R3)		;и уменьшаем счётчик строк !!!можно оптимизировать
22$:            call    CRLFOU			;сделать перевод строки
12$:            iot
                .word   22				;Продолжить поиск файлов.
                bcc     9$				;если что-то нашлось - продолжим
                cmpb    #25, @#52		;есть ошибка 25?
                bne     RET2$			;нет - молча выходим
                call    CRLFOU			;сделать перевод строки
                mov     C$FLCN(R3), R0	;количество найденных файлов
                clr     R1
                call    ITOA			;вывод числа из R1:R0
                mov     #12, R1			;строка " file "
                call    OUTERS
15$:            mov     C$FRES(R3), R0	;свободное место
                mov     C$FRES+2(R3), R1
                call    ITOA			;вывод числа из R1:R0
                mov     #13, R1			;строка "byte free"
                call    OUTERS
                call    CRLFOU			;сделать перевод строки
                mov     C$VOLS(R3), R0		;общий размер
                mov     C$VOLS+2(R3), R1
                call    ITOA			;вывод числа из R1:R0
                mov     #17, R1			;строка " bytes total disk space"
                jmp     OUTERS

; ═══════════════════════════════════════════════════════════════════════════
;вывод пробела
SPSOUT:         mov     #40, R0
                iot
                .word   2
                return

; ═══════════════════════════════════════════════════════════════════════════
;вывод перевода строки
CRLFOU:         mov     #5015, R0
                iot
                .word   2
                swab    R0
                iot
                .word   2
                return

; ═══════════════════════════════════════════════════════════════════════════
;обработка команды PAUSE
CM$PAU:         call    REDIRC			;проверка перенаправления входного/выходного контекста
                bcs     RET2$
                call    NEXTTK			;пропустим пробелы
                tstb    (R1)			;за командой что-нибудь есть?
                beq     PRANYK			;нет - выведем стандартное сообщение
                iot
                .word   11				;Вывод строки символов на устройство вывода
L7312:          iot
                .word   15				;Инициализировать драйвер (контроллер) дисковода.
                iot
                .word   1				;Ввод символа со стандартного устройства ввода
                jmp     CRLFOU			;!!!можно оптимизировать

; ═══════════════════════════════════════════════════════════════════════════
;вывод сообщения, чтобы нажали любую клавишу
PRANYK:         mov     #3, R1
                call    OUTERS
                br      L7312

; ═══════════════════════════════════════════════════════════════════════════
;обработка команды CLS
CM$CLS:         cmpb    #2, C$MONT(R3)
                bne     1$
                emt     62				;очистка экрана на БК11М
                return

1$:             emt     14				;очистка экрана на БК10, БК11
RET2$:          return

; ═══════════════════════════════════════════════════════════════════════════
;обработка команды VER
CM$VER:         call    REDIRC			;проверка перенаправления входного/выходного контекста
                bcs     RET2$
                mov     #31, R1
                call    OUTERS			;вывод строки "DXDOS version"
                iot
                .word   60				;Получить версию DOS.
                mov     R0, R5
                clrb    R0
                clr     R1
                swab    R0
                call    ITOA			;вывод числа из R1:R0
                mov     #'., R0
                incb    C$NMEV(R3)
                iot
                .word   2				;Вывод символа на стандартное устройство вывода
                mov     R5, R0
                bic     #177400, R0
                clr     R1
                call    ITOA			;вывод числа из R1:R0
                clrb    C$NMEV(R3)
                jmp     CRLFOU

; ═══════════════════════════════════════════════════════════════════════════
;вход:	R1 - номер выводимой строки
OUTERS:         .addr   R2, ERRTXT
                call    GETSTR
                iot
                .word   11				;Вывод строки символов на устройство вывода
                return

; ═══════════════════════════════════════════════════════════════════════════
;получение адреса строки из массива по ее номеру
;вход:	R1 - номер строки, счёт начинается с 1: 1..n
;		R2 - адрес массива строк
;выход:	R0 - номер строки, счёт начинается с 0.
;		R1 - адрес строки
GETSTR:         clr     R0			;тут формируется номер выдаваемой строки
3$:             dec     R1			;уменьшаем входной номер.
                ble     1$			;если <= 0, то нашли то, что надо
2$:             tstb    (R2)+		;перейдём к следующей строке в массиве
                bne     2$
                inc     R0			;счётчик номера выдаваемой строки увеличим
                br      3$

1$:             mov     R2, R1		;нужный нам адрес, в выходной регистр
                return

; ═══════════════════════════════════════════════════════════════════════════
;формирование в буфере имени переменной окружения
;вход:	R1 - номер переменной в массиве переменных, счёт начинается с 1: 1..n
;выход:	R1 - адрес конца строки в буфере
VARNAM:         mov     #WRKBUF, C$PENV(R3)	;адрес буфера, где будет формироваться строка
                mov     C$ENNM(R3), R2	;адрес списка имён переменных окружения
                call    GETSTR			;получим в R1 и R2 адрес нужной переменной окружения
                call    STRBUF			;скопируем строку в буфер
                movb    #'=, (R1)+		;допишем знак =
                mov     R1, C$PENV(R3)	;и сохраним адрес.
                return

; ═══════════════════════════════════════════════════════════════════════════
;копирование строки в буфер
;вход:	R2 - адрес строки
;выход:	R1 - адрес конца строки в буфере
STRBUF:         mov     C$PENV(R3), R1	;получим буфер, где надо формировать строку
2$:             movb    (R2)+, R0		;копируем её в буфер
                beq     1$				;завершающий 0 не копируем.
                movb    R0, (R1)+
                br      2$

1$:             return

; ═══════════════════════════════════════════════════════════════════════════
;установка значения переменной окружения
;вход:	R1 - номер значения в массиве значений, счёт начинается с 1: 1..n
SETVAR:         mov     C$ENVL(R3), R2	;адрес списка значений констант
                call    GETSTR			;получим в R1 и R2 адрес нужной константы
                call    STRBUF			;скопируем строку в буфер
                clrb    (R1)+			;формируем конец строки
                mov     #WRKBUF, R1		;буфер
                iot
                .word   70				;Записать переменную в область окружения DOS.
                return
; ───────────────────────────────────────────────────────────────────────────
;таблица имён переменных окружения
								;входной номер -> выходной номер
ENVNML:         .asciz "ECHO"	;1 -> 0
                .asciz "DIRCMD"	;2 -> 1
                .asciz "$"
;таблица значений констант
ENVVLL:         .asciz "ON"		;1 -> 0
                .asciz "OFF"	;2 -> 1
                .asciz "BAT"	;3 -> 2
                .asciz "$"
                .even

; ═══════════════════════════════════════════════════════════════════════════
;если пробелы, то пропускаем
;если конец строки, то выход
;иначе - говорим что ошибка и выходим с битом C
NEXTTK:         cmpb    (R1), #40
                beq     SKIPWS
                tstb    (R1)
                beq     1$
                movb    #2, R1			;вывод сообщения
                call    OUTERS			;bad command or file name
                sec
1$:             return

; ═══════════════════════════════════════════════════════════════════════════
;пропуск пробелов. !!! дописать, чтобы пропускались остальные символы типа tab, cr, lf
SKIPWS:         cmpb    (R1), #40
                bne     1$
                inc     R1
                br      SKIPWS

1$:             clc
                return

; ═══════════════════════════════════════════════════════════════════════════
;преобразование строки в десятичное число
;вход:	R0 - адрес строки десятичных символов
;выход	R1 - распознанное число
ATOI:           clr     R1				;тут накапливается результат
1$:             movb    (R0), R5		;берём очередной символ
                tst     R5				;если 0 - то конец
                beq     2$
                cmp     #':, R5			;если : - то тоже конец (для ввода даты)
                beq     2$
                cmp     R5, #57			;если меньше кода 0
                blos    3$				;то конец с ошибкой
                cmp     R5, #72			;если больше кода 9
                bhis    3$				;то конец с ошибкой
                sub     #'0, R5			;получим цифру
                mov     #9., R2			;умножаем R1 на 10
                mov     R1, R4			;это занимает 5 слов
4$:             add     R4, R1			;нормальное умножение на 10 через asl mov asl asl add
                sob     R2, 4$			;тоже занимает 5 слов !!! оптимизировать
                add     R5, R1			;прибавим цифру к результату
                inc     R0
                br      1$				;и дальше, обработаем следующий символ

2$:             inc     R0
                tst     (PC)+
3$:             sec
                return

; ═══════════════════════════════════════════════════════════════════════════
;вывод десятичного числа в виде строки
;вход: R1:R0 - число
ITOA:           mov     R5, -(SP)
                mov     R4, -(SP)
                mov     C$NMBF(R3), R5	;адрес буфера длиной 14
                mov     #8., R4			;!!!число 32 разрядное может занимать 10 знаков, а не 8
1$:             movb    #40, (R5)+
                sob     R4, 1$

4$:             tst     R1
                bne     2$
                cmp     #10., R0
                bhi     3$
2$:             mov     #10., R2
                call    DIVIDE
                add     #'0, R0
                movb    R0, -(R5)
                mov     R4, R0
                mov     R2, R1
                br      4$

3$:             add     #'0, R0
                movb    R0, -(R5)
                mov     C$NMBF(R3), R1
                tstb    C$NMEV(R3)		;какое у нас выравнивание
                beq     5$				;по правому краю
6$:             cmpb    (R1), #40		;по левому краю
                blo     7$				;вообще строки не получилось - выход
                bne     5$				;нашли начало числа
                inc     R1				;ищем начало числа
                br      6$

5$:             iot
                .word   11				;Вывод строки символов на устройство вывода
7$:             mov     (SP)+, R4
                mov     (SP)+, R5
                return

; ═══════════════════════════════════════════════════════════════════════════
;деление
;вход:	R1:R0 - делимое
;		R2 - делитель
;выход:	R2:R4 - результат
;		R1:R0 - остаток от деления
DIVIDE:         tst     R2
                beq     1$
                mov     R3, -(SP)
                mov     R5, -(SP)
                clr     R3
                clr     R5
                clr     R4
2$:             inc     R5
                asl     R2
                bcc     2$
3$:             ror     R2
4$:             add     #1, R4
                adc     R3
                sub     R2, R0
                sbc     R1
                bcc     4$
                add     R2, R0
                adc     R1
                sub     #1, R4
                sbc     R3
                asl     R4
                rol     R3
                sob     R5, 3$
                ror     R3
                ror     R4
                mov     (SP)+, R5
                mov     R3, R2
                mov     (SP)+, R3
                return

1$:             movb    #31, @#52
                sec
RET3$:          return

; ═══════════════════════════════════════════════════════════════════════════
;обработка команды DATE
CM$DAT:         call    REDIRC			;проверка перенаправления входного/выходного контекста
                bcs     RET3$			;если было, но не получилось - выйдем
                mov     #14, R1
                mov     R4, -(SP)
                mov     R5, -(SP)
                call    OUTERS			;вывод строки "Current date is "
                iot
                .word   52				;Получить текущую дату.
                call    DATOUT			;вывод даты
                mov     #15, R1
                call    OUTERS			;вывод строки "Enter new date "
                mov     C$DTBF(R3), R1	;буфер ввода даты
                mov     #DTBFSZ-1, R2	;длина буфера
                iot
                .word   6				;Буферизованный ввод с клавиатуры с возможностью редактирования.
                bcs     1$				;если какая-то ошибка
                tstb    (R1)			;или пустая строка
                beq     1$				;выйдем
                mov     R1, R0
                call    ATOI			;опознаем первую группу цифр, это будет число.
                bcs     2$
                cmp     R1, #32.		;больше 32 ?
                bhi     2$				;да - ошибка (а 32 значит не ошибка!)
                tst     R1				;0 ?
                beq     2$				;тоже ошибка
                mov     R0, -(SP)
                iot
                .word   52				;Получить текущую дату.
                mov     R1, R0			;установим день.
                iot
                .word   53				;Установить дату.
                mov     (SP)+, R0
                call    ATOI			;опознаем следующую группу цифр, это будет месяц.
                bcs     2$
                cmp     R1, #16.		;больше 16 ?
                bhi     2$				;да - ошибка (т.е. месяцы 13..16 не ошибка!)
                tst     R1				;0 ?
                beq     2$				;тоже ошибка
                mov     #5, R2
3$:             asl     R1
                sob     R2, 3$
                mov     R0, -(SP)
                iot
                .word   52				;Получить текущую дату.
                bis     R1, R0			;установим месяц.
                iot
                .word   53				;Установить дату.
                mov     (SP)+, R0
                call    ATOI			;опознаем следующую группу цифр, это будет год.
                bcs     2$
                cmp     R1, #2107.		;больше предела, в которые влазят биты года ?
                bhi     2$				;да - ошибка
                sub     #1980., R1		;меньше нижнего предела?
                bmi     2$				;да - тоже ошибка
                swab    R1
                asl     R1
                iot
                .word   52				;Получить текущую дату.
                bis     R1, R0			;установим год
                iot
                .word   53				;Установить дату.
                br      1$
;!!! у алгоритма 2 изъяна:
;1. неправильные граничные условия проверки элементов даты
;2. зачем-то три раза устанавливается дата, и в случае ошибки где-то в середине
;дата останется неправильной, вместо полного отказа принять неправильную дату.
;!!! надо переделать.
2$:             mov     #16, R1			;выведем строку "инжалид дате"
                call    OUTERS
1$:             mov     (SP)+, R5
                mov     (SP)+, R4
                jmp     CRLFOU

; ═══════════════════════════════════════════════════════════════════════════
;вывод даты
;вход:	R0 - дата
DATOUT:         mov     R4, -(SP)
                mov     R5, -(SP)
                mov     R0, -(SP)
                beq     1$
                incb    C$NMEV(R3)		;выставляем выравнивание по левому краю
                bic     #177740, R0		;день
                clr     R1
                call    ITOA			;вывод числа из R1:R0
                mov     #':, R0
                iot
                .word   2
                mov     (SP), R0
                bic     #177037, R0		;месяц
                mov     #5, R1
2$:             asr     R0
                sob     R1, 2$
                clr     R1				;!!! лишняя команда
                call    ITOA			;вывод числа из R1:R0
                mov     #':, R0
                iot
                .word   2
                mov     (SP), R0
                bic     #777, R0
                swab    R0
                asr     R0
                add     #1980., R0		;год
                clr     R1
                call    ITOA			;вывод числа из R1:R0
                clrb    C$NMEV(R3)
1$:             mov     (SP)+, R0
                mov     (SP)+, R5
                mov     (SP)+, R4
                return

; ═══════════════════════════════════════════════════════════════════════════
;поиск строки в массиве
;вход:	R1 - адрес начала массива строк
;		R2 - адрес эталонной строки
;выход: R0 - номер строки * 2
; если ошибок нет,
;		R1 - указатель на конец строки
;если ошибки есть
;		R1 - указатель на начало эталонной строки
STRNUM:         clr     R0
5$:             cmpb    (R1), #'$		;конец массива
                beq     1$
                mov     R2, R5
4$:             tstb    (R1)
                beq     2$
                cmpb    (R5)+, (R1)+
                bne     3$				;!!! непонятно, почему автор строит такие
                br      4$				;!!! конструкции. Оптимизировать

3$:             inc     R1
                tstb    -1(R1)
                bne     3$
                tst     (R0)+
                br      5$

1$:             sec
                mov     R2, R1
                return

2$:             mov     R5, R1
                cmpb    #40, (R1)
                blo     1$
                return

; ═══════════════════════════════════════════════════════════════════════════
;вывод на экран восьмеричного числа
;вход:	R1 - число
OUT8:           clr     C$FNFL(R3)		;флаг замены ведущих нулей пробелами
                mov     #6, R2			;количество выводимых цифр
                clr     R0				;приёмник
1$:             rol     R1				;принимаем в приёмник бит
                rol     R0
                add     #'0, R0			;делаем число
                tst     C$FNFL(R3)			;нули подменять?
                bne     2$				;уже нет
                cmpb    #'0, R0			;да, а у нас 0?
                bne     2$				;нет
                call    SPSOUT			;вместо 0 выведем пробел
                br      3$				;переходим к следующей цифре

2$:             iot						;выведем цифру
                .word   2
                inc     C$FNFL(R3)		;всё, нули больше не ведущие и их подменять нельзя
3$:             dec     R2				;все цифры вывели?
                beq     4$				;да - выход
                clr     R0				;нет
                rol     R1				;примем 2 бита
                rol     R0
                rol     R1
                rol     R0
                br      1$				;пойдём принимать ещё один бит
;!!! алгоритм можно оптимизировать
4$:             jmp     SPSOUT			;в конце выведем пробел

; ═══════════════════════════════════════════════════════════════════════════
;умножение
;вход:	R1:R0 - множимое
;		R2 - множитель
;выход:	R1:R0 - результат
MULTIP:         mov     R5, -(SP)
                mov     R3, -(SP)
                mov     R4, -(SP)
                mov     #16., R5
                clr     R3
                clr     R4
1$:             asr     R2
                bcc     2$
                add     R0, R3
                adc     R4
                add     R1, R4
2$:             asl     R0
                rol     R1
                sob     R5, 1$
                mov     R4, R1
                mov     R3, R0
                mov     (SP)+, R4
                mov     (SP)+, R3
                mov     (SP)+, R5
                return

; ───────────────────────────────────────────────────────────────────────────
; список встроенных команд
CMDSET:         .asciz "SET"		;1
                .asciz "PAUSE"		;2
                .asciz "CLS"		;3
                .asciz "VER"		;4
                .asciz "DATE"		;5
                .asciz "DIR"		;6
                .asciz "DEL"		;7
                .asciz "COPY"		;8
                .asciz "TYPE"		;9
                .asciz "REN"		;10
                .asciz "ERA"		;11
                .asciz "REM"		;12
                .asciz "ECHO"		;13
                .asciz "$"
                .even
; смещения до п/п встроенных команд
CMDADR:         .word   @CM$SET		;1
                .word   @CM$PAU		;2
                .word   @CM$CLS		;3
                .word   @CM$VER		;4
                .word   @CM$DAT		;5
                .word   @CM$DIR		;6
                .word   @CM$DEL		;7
                .word   @CM$COP		;8
                .word   @CM$TYP		;9
                .word   @CM$REN		;10
                .word   @CM$DEL		;11
                .word   @CM$REM		;12
                .word   @CM$ECH		;13
                .word   0
; ═══════════════════════════════════════════════════════════════════════════
;подменяем некоторые номера ошибок другими, соответствующими номерам строк сообщений об ошибках
ERCTCH:         .addr   R0, ERRNMS
                movb    @#52, R2		;получим номер ошибки
                beq     1$				;если ошибок не было, то сразу выйдем
3$:             cmp     R2, (R0)		;если ошибка, которую ищем
                beq     2$				;то нашли
                tst     (R0)			;таблица кончилась?
                beq     1$				;да - выход
                cmp     (R0)+, (R0)+	;к следующему коду
                br      3$

2$:             mov     2(R0), R1		;номер строки, которую надо вывести для данной ошибки
                call    OUTERS
                sec
1$:             return
; ───────────────────────────────────────────────────────────────────────────
;!!! массив слов надо заменить на массив байтов, и соответственно поправить ERCTCH
ERRNMS:         .word   21,1
                .word   22,10
                .word   23,20
                .word   24,21
                .word   25,4
                .word   30,11
                .word   33,6
                .word   40,25
                .word   41,27
                .word   43,27
                .word   44,2
                .word   45,16
                .word   46,26
                .word   35,30
                .word   0,0
CONNME:         .asciz "CON"
ERRTXT:         .asciz "Invalid drave specification"<12><15>	;1 *
                .asciz "Bad command or file name"<12><15>		;2 *
                .asciz "Strike any key to continue ..."			;3
                .asciz "File not found"<12><15>					;4 *
                .asciz "Are you sure (Y/N)?"					;5
                .asciz "Rename error"<12><15>					;6 *
                .asciz "File cannot be copied onto itself"<12><15>	;7
                .asciz "Insufficient disk space"<12><15>		;10 *
                .asciz "Bad file name"<12><15>					;11 *
                .asciz " file "									;12
                .asciz " byte free"								;13
                .asciz "Current date is "						;14
                .asciz <12><15>"Enter new date "				;15
                .asciz "Invalid date"<12><15>					;16 *
                .asciz " bytes total disk space"<12><15>		;17
                .asciz "Content of destination lost before copy"<12><15>	;20 *
                .asciz "Disk full"<12><15>						;21 *
                .asciz " <DIR> "								;22
                .asciz " copied"								;23
                .asciz "Echo is "								;24
                .asciz "Out of environment space"<15><12>		;25 *
                .asciz "Invalid switch"<15><12>					;26 *
                .asciz "Syntax error"<15><12>					;27 *
                .asciz "Missing operand"<15><12>				;30 *
                .asciz <15><12>" "" DXDOS version"				;31
CMDVER:         .asciz <12><15>"COMMAND version 1.00"<12><15>
                .even

                .END

