; Processor:        1801VM1
; Target assembler: Turbo8 Assembler

; ===========================================================================

		NOP
		BR		START$
; ---------------------------------------------------------------------------
		.ASCII	"DX-DOS"<0>
		.BYTE	0			; WORD    
		.BYTE	2
		.BYTE	1			; BYTE    
		.WORD	1			; WORD    
FATNUM:	.BYTE	2			; BYTE  
MAXRFL:	.BYTE	224.		; WORD      
		.BYTE	0
		.BYTE	100			; WORD     
		.BYTE	6
MEDIAD:	.BYTE	360			; BYTE Media descriptor
FATSZE:	.WORD	5			; WORD     
TRKSEC:	.WORD	10.			; WORD    
HEDNUM:	.WORD	2			; WORD  
		.BYTE	0
		.BYTE	0
		.BYTE	0
		.BYTE	0
		.BYTE	0
		.BYTE	0
		.BYTE	0
		.BYTE	0
		.BYTE	0
		.BYTE	0
		.BYTE	51
		.BYTE	0
		.BYTE	0
		.BYTE	0
		.BYTE	0
LABEL:	.ASCII	"NO NAME    "	; 
FAT12:	.ASCII	"FAT12   "		;  
		.WORD 0
; ---------------------------------------------------------------------------

START$:	MOVB	FATNUM,R2
		MOV		FATSZE,R1
		INC		R0			;  
		MOV		R0,@#416	; FAT
		CALL	IMULB
		MOV		R4,R0
		INC		R0			; 
		MOVB	MAXRFL,R2	;   
		BIC		#177400,R2
		MOV		#20,R1		;   
		CALL	IDIVB		;224./20 = 16 
		ADD		R0,R4		; 
		MOV		R4,-(SP)
		MOV		R3,R2		;    
		ADD		#70,R2		;,    
		MOV		#1,R1		;   
		CALL	READD		;   
		BCS		ERRLOD

		.ADDR	R5,DXDOSS	;"DXDOS   SYS"
		MOV		R2,R4
		MOV		#13,R0		;       DXDOS   SYS
1$:		CMPB	(R5)+,(R4)+
		BNE		NOSYS$		;   
		SOB		R0,1$
		MOV		34(R2),R2	;  DXDOS.SYS
		MOV		#1000,R1	;  ==  
		CALL	IDIVB
		MOV		R4,R1		;- 
		INC		R1
		MOV		(SP)+,R0	;   DXDOS.SYS,     
		MOV		#5000,R2	; 
		CALL	READD		;  DXDOS.SYS
		BCS		NOSYS$
		JMP		@#5000

; =============== S U B R O U T I N E =======================================

;  
;: 
;R0 -  
;R1 -  
;R2 -  
READD:	CMPB	MEDIAD,#373
		BLOS	4$
		MOV		#1,R5		; ,  40 
		CALL	READ$
		BCC		0NOER$
		CLR		R5			; 
4$:		CALL	READ$
		BCS		NOSYS$
0NOER$:	RETURN

; End of function READD

NOSYS$:						;    
		.ADDR	R1,NOSYSD	; "Non system disk or disk error"
3$:		MOVB	(R1)+,R0
		CMP		@#30,#152112	;, 11  10, 11?
		BNE		1$
		EMT		63
		BR		2$

1$:		EMT		16
2$:		TST		R0
		BNE		3$
		CLR		@#177130
		HALT


; =============== S U B R O U T I N E =======================================

;:
;R0 -  
;R1 -  
;R2 -  
;R5 -  
READ$:	MOV		R2,26(R3)	;     
		CMP		#2,HEDNUM	;  ?
		BEQ		1$			;?
		BIS		#2,R5		;,  

1$:		MOVB	R5,@20(R3)	;    
		MOV		R1,-(SP)
		MOV		R2,-(SP)
		MOV		R0,-(SP)

6$:		MOV		R0,-(SP)
		MOV		R2,-(SP)
		MOV		R1,-(SP)
		MOV		#400,30(R3)	;   .  1 
		MOV		#10,R4		;    
		MOV		TRKSEC,R5	;    ,   
		SWAB	R5

3$:		CMP		R5,R0
		BHI		2$
		SUB		R5,R0
		SEC
2$:		ROL		R0
		SOB		R4,3$
		MOVB	R0,R4
		CLRB	R0
		SWAB	R0
		INC		R0
		CLRB	32(R3)
		CMP		R0,TRKSEC
		BLE		4$
		INCB	32(R3)
		SUB		TRKSEC,R0
4$:		BITB	#2,@20(R3)
		BEQ		5$
		ASRB	32(R3)
		ROLB	R4
5$:		MOVB	R4,33(R3)	; 
		MOVB	R0,35(R3)	; 
		CALL	@#160006	;/   
		MOV		(SP)+,R1
		MOV		(SP)+,R2
		MOV		(SP)+,R0
		BCS		ERRLOD
		INC		R0
		ADD		#1000,26(R3)	;  ,    
		SOB		R1,6$
ERRLOD:	MOV		(SP)+,R0
		MOV		(SP)+,R2
		MOV		(SP)+,R1
		RETURN
; End of function READ$


; =============== S U B R O U T I N E =======================================

; R2  R1
;: R4 - 
IDIVB:	CLR		R5
		CLR		R4
0$:		INC		R5
		ASL		R1
		BCC		0$
2$:		ROR		R1
1$:		INC		R4
		SUB		R1,R2
		BCC		1$
		ADD		R1,R2
		DEC		R4
		ASL		R4
		SOB		R5,2$
		ROR		R4
		RETURN
; End of function IDIVB


; =============== S U B R O U T I N E =======================================

; R2  R1
;: R4 - 
IMULB:	MOV		#8.,R5
		CLR		R4
0$:		ASR		R1
		BCC		1$
		ADD		R2,R4
1$:		ASL		R2
		SOB		R5,0$
		RETURN
; End of function IMULB

; ---------------------------------------------------------------------------
DXDOSS:	.ASCIZ	"DXDOS   SYS"
NOSYSD:	.ASCIZ	"Non system disk or disk error"
		.EVEN
		.BLKW	31
		.WORD	125125

		.END

