
; Processor:        1801VM1
; Target assembler: BK Turbo8 Cross Assembler
; Файл: BK0010

.include "inc/dx_fcb.asm"
.include "inc/dx_sys.asm"
.include "inc/dx_cmd.asm"
; !!! ВНИМАНИЕ! эта штука не работает.
; в страницу 4 по адресу 100000-120000 грузится стандартный монитор БК10,
; но хвост монитора забивается системными буферами ДОС

START:          mov     #START, SP
                movb    R0, FCBM10          ; привод, с которого загрузились
                iot
                .word   60                  ; Получить версию DOS.
                cmp     #DOSVER, R0
                beq     1$
                .addr   R1, BADVER
                br      1EX$

1$:             iot
                .word   61                  ; Доступ к внутрисистемной информации.
                tstb    S$BRDT(R1)          ; тип машины 0-БК0010, 1-БК0011М,2-БК0011.
                bne     2$
                .addr   R1, BADBKT
                br      1EX$

2$:             tstb    S$MONT(R1)          ; тип монитора 0-БК0010,1-БК0011М,2-БК0011.
                bne     3$
                .addr   R1, ALREDY
1EX$:           iot
                .word   11
2EX$:           iot
                .word   0

3$:             .addr   R4, FCBM10
                iot
                .word   17                  ; Открыть файл методом FCB.
                bcc     4$
                cmpb    #25, @#52
                bne     2EX$
                .addr   R1, FILENF
                br      1EX$

4$:             mov     R4, -(SP)
                cmpb    #2, S$BRDT(R1)      ; это БК0011?
                beq     5$                  ; да
                                            ; а для БК0011М делать так
                mov     #40000, @#177662    ; включим палитру 0 и выключим таймер
                mov     #5, R0
                emt     12                  ; подключение страницы ОЗУ/ПЗУ; стр.5 в окно 0
                mov     #404, R0
                emt     12                  ; подключение страницы ОЗУ/ПЗУ; стр.4 в окно 1
                mov     @#114, R5           ; возьмём копию ССП
                br      6$

5$:             mov     #5, R0
                emt     52                  ; подключение страницы ОЗУ/ПЗУ; стр.5 в окно 0
                mov     #404, R0
                emt     52                  ; подключение страницы ОЗУ/ПЗУ; стр.4 в окно 1
                mov     #40000, @#177662    ; включим палитру 0 и выключим таймер
                mov     @#66, R5            ; возьмём копию ССП

6$:             iot
                .word   30                  ; Доступ к буферам DOS.
                                            ; выход: R0 - адрес области BAT-файлов.
                                            ;       первое слово - уровень вложенности (0 - область пуста).
                                            ;       R1 - адрес FCB стандартного устройства ввода.
                                            ;       R2 - адрес FCB стандартного устройства вывода.
                mov     #BAT$SZ, R3
                mov     R5, R4
                bic     #20000, R4
                bis     #50000, R4          ; в окно 0 подключаем стр.7
                mov     R4, @#177716
                mov     #76000, R4          ; в стр.7 пометим, что установлен драйвер БК10 sys
                mov     #52652, (R4)+       ; сигнатура драйвера
                mov     R5, (R4)+           ; код для подключения страниц стр.5 в окно 0, стр.4 в окно 1
7$:             movb    (R0)+, (R4)+        ; копируем область бат файлов
                sob     R3, 7$
                mov     R5, @#177716        ; обратно в окно 0 включаем стр.5
                mov     (SP)+, R4
                .addr   R0, EOF
                mov     R0, F$DTAD(R4)      ; адрес обмена
                mov     F$FLSZ(R4), F$RCSZ(R4)  ; размер файла в байтах. -> размер записи в байтах.
                iot
                .word   41                  ; Прямой доступ,чтение.
                iot
                .word   20                  ; Закрыть файл.
                .addr   R1, INSSYS
                iot
                .word   11
                iot
                .word   15
                iot
                .word   1
                mov     F$DTAD(R4), R0      ; адрес обмена
                mov     F$FLSZ(R4), R1      ; размер файла в байтах.
                mov     #100000, R2
8$:             movb    (R0)+, (R2)+
                sob     R1, 8$
                jmp     @#100000
; ───────────────────────────────────────────────────────────────────────────
FCBM10:         .byte 0
                .ascii "MBK0010 SYS"
                .blkb FCB$SZ-F$MDRV+2

INSSYS:         .ascii "Insert system disk"<12><15>
                .asciz "and strike any key then ready."<12><15>
                .even
ALREDY:         .asciz "BK0010 already installed."<12><15>
                .even
BADVER:         .asciz "Incorrect DOS version."<12><15>
                .even
FILENF:         .asciz "File MBK0010.SYS not found."<12><15>
BADBKT:         .asciz "This program is only"<12><15>"for БК-0011(М) !"<12><15>
                .even
EOF:            .word   0

                .END

; структура по адресу 76000
; смещение  размер  Назначение
;   0       2       52652 - сигнатура, означает, что загружен монитор БК10 и включён режим
;                   эмуляции БК10 на БК11
;   2       2       код для подключения страниц стр.5 в окно 0, стр.4 в окно 1
;   4       BAT$SZ  копия области БАТ файлов