﻿;переменные блока параметров драйвера дисковода

DefBootLoad=1000    ; адрес загрузки бутсектора по умолчанию
DefFDDBPB = 2000    ; адрес рабочей области драйвера дисковода по умолчанию
                    ; для загрузчика

ERRFDD  = 52    ; адрес, куда сохраняется номер ошибки
; Коды ошибок:
; 1 - при чтении: ошибка CRC
;     при записи: Установлена защита записи
; 2 - ошибка CRC в зоне заголовка сектора
; 3 - нет позиционирования на нулевую дорожку
; 4 - ошибка позиционирования
; 5 - не найден сектор
; 6 - нет диска или диск не вращается
; 7 - прерывание по вектору 4 во время выполнения операции
; 10 - не найден адресный маркер
; 11 - не найден маркер данных
; 12 - недопустимые параметры команды или нестандартный формат диска
; 13 - попытка чтения скрытых данных без соответствующего разрешения

; ячейки рабочей области драйвера дисковода
D$CSRW    = 0     ; копия по записи регистра состояния КНГМД
D$CURTRK  = 2     ; адрес текущей дорожки (адрес одного из следующих байтов из таблицы)
D$TRKTAB  = 4     ; таблица текущих дорожек (старший бит каждого байта при
                  ; установке в '1' задаёт возврат на соответствующем дисководе
                  ; к нулевой дорожке перед операцией позиционирования
D$TDOWN   = 10    ; задержка опускания головки
D$TSTEP   = 12    ; задержка перехода с дорожки на дорожку
D$TRKCOR  = 14    ; дорожка начала предкомпенсации
D$BRETRY  = 15    ; число попыток повтора при ошибке
D$FLAGS   = 16    ; рабочая ячейка драйвера
                  ; xxxxxxxx
                  ; │││ │ └ разрешение писать/читать скрытые данные;
                  ; │││ └── двигатель уже был включен перед операцией;
                  ; ││└──── признак записи информации на диск;
                  ; │└───── текущее состояние индекса;
                  ; └────── отмена двойного шага при
                  ;         возврате на нулевую дорожку.
D$FILLB   = 17    ; код заполнения при форматировании
D$FLGPTR  = 20    ; указатель на байт признаков (адрес одного из следующих байтов из таблицы)
D$FLGTAB  = 22    ; таблица признаков, по байту на привод
                  ;xxxxxxxx
                  ;    │││└─ при установке в '1' драйвер производит пропуск доро-
                  ;    │││     жек при  поиске,  т.е.  фактически  обрабатываются
                  ;    │││     лишь чётные дорожки. Используется для обработки на
                  ;    │││     80-дорожечном дисководе 40-дорожечных дисков;
                  ;    ││└── при установке в  '1'  драйвер  производит  обращение
                  ;    ││      только к нижней стороне  диска.  Используется  при
                  ;    ││      подключении одностороннего дисковода, а так же при
                  ;    ││      обработке на двустороннем дисководе  односторонних
                  ;    ││      дисков;
                  ;    │└─── при установке в '1'  обрабатываются  сектора  длиной
                  ;    │       2000 байт, иначе 1000. Однако в самом драйвере ра-
                  ;    │       бота с секторами длиной 2000 байт реализована  не-
                  ;    │       верно;
                  ;    └──── при установке в '1' начало первого сектора  задаётся
                  ;            задержкой HOLTIN от индекса, иначе -  своим  заго-
                  ;            ловком.
D$ADDR    = 26    ; адрес начала массива данных в ОЗУ (обязательно чётный)
D$WCNT    = 30    ; количество слов для пересылки
D$SIDE    = 32    ; номер стороны диска 0/1
D$TRK     = 33    ; номер дорожки 0..79
D$UNIT    = 34    ; номер привода 0..3
D$SECTOR  = 35    ; номер сектора 0..MAXSEC
D$WRTVAR  = 36    ; значение, записываемое при форматировании
D$MARKER  = 40    ; буфер маркера при записи
D$FREE    = 42    ; длина пустого остатка сектора
D$INTIME  = 44    ; счётчик длительности индекса
D$BUF4    = 46    ; буфер для сохранения вектора 4
D$BUFSP   = 50    ; буфер для сохранения SP
D$BUFPSW  = 52    ; буфер для сохранения PSW
D$CRETRY  = 54    ; счётчик повторов при ошибке
D$TURNS   = 55    ; число оборотов диска при поиске сектора
D$SECRET  = 56    ; число повторных попыток поиска сектора
D$ERRNUM  = 57    ; буфер для номера ошибки
D$MAXSEC  = 60    ; число секторов на дорожке
D$HOLTIN  = 62    ; время задержки после индекса до первого сектора
D$SECLEN  = 64    ; длина сектора в словах
