
; Processor:        1801VM1
; Target assembler: Turbo8 Assembler
; Файл: COPYM

; ───────────────────────────────────────────────────────────────────────────
;структура FCB, размер 52 байта
F$NDRV=0 	;номер дисковода: 0-текущий,1-'А',2-'В'...
F$FLNM=1 	;имя файла + суффикс файла
F$CBLK=14	;номер текущего блока(для функций последовательного доступа.
F$RCSZ=16	;размер записи в байтах.
F$FLSZ=20	;размер файла в байтах.
F$FLDT=24	;дата создания файла.
F$FLLD=26	;адрес загрузки файла в память (для исполняемых файлов)
F$IDEV=30	;идентификатор устройства.
F$DIRP=31	;положение имени файла в каталоге.
F$STCL=32	;начальный кластер .
F$TMP1=34	;используется DOS под разные нужды. как seek
F$TMP2=36	;так и как временный буфер всяких данных
F$CURR=40	;текущая запись (последов.доступ к файлам)
F$FOPN=41	;признак открытия файла?
F$RECN=42	;номер записи (для функций прямого доступа)
F$TMP3=46	;используется DOS
F$ATTR=47	;атрибуты файла
F$DTAD=50	;адрес обмена
FCB$SZ=52	;размер FCB

KBLEN=100
                mov     #1000, SP
                movb    R0, FCBCPH
                mov     @#4, OLDV4
                mov     #220, TAPEOF
                mov     #120, LEVEL2
                mov     #20, TAPEON
                mov     #60, LEVEL1
                mov     #160, LEVEL3
                iot
                .word   61				;Доступ к внутрисистемной информации. 
                cmpb    #2, 104(R1)		;тип машины 0-БК0010, 1-БК0011М,2-БК0011. 
                bne     1$				;не БК0011
                mov     @#66, R0		;а если БК0011, надо поправить константы драйвера магнитофона
                bis     R0, LEVEL2
                bis     R0, LEVEL3
                bis     R0, LEVEL1
                bis     R0, TAPEOF
                bis     R0, TAPEON
1$:             cmpb    #1, 105(R1)		;тип монитора 0-БК0010,1-БК0011М,2-БК0011. 
                bne     V4$3
                mov     #104000, EMTCLS
V4$3:           .addr   R1, V4$3
                mov     R1, @#4
                mov     #13, R1
                call    OUTERS
1$:             call    S2736
                mov     #1, W2730
                .addr   R1, KEYBUF
                mov     #KBLEN, R2
                iot
                .word   6					;Буферизованный ввод с клавиатуры с возможностью редактирования. 
                bcs     EMTCLS
                mov     R1, R5
2$:             tstb    (R5)
                beq     4$
                bitb    #200, (R5)
                bne     3$
                cmpb    #100, (R5)
                bhi     3$
                bicb    #40, (R5)
3$:             inc     R5
                br      2$

4$:             cmpb    (R1), #40
                blos    1$
                mov     R1, R2
                .addr   R1, CMDTBL
                call    CMDNUM
                bcs     5$
                mov     R5, R1
                .addr   R5, CMDSUB
                add     R0, R5
                add     (R5), R5
                call    (R5)
                br      1$

5$:             mov     #2, R1
                call    OUTERS
                br      1$
; ───────────────────────────────────────────────────────────────────────────
;обработка команды EXIT
CMDEXI:
EMTCLS:         emt     14   
                mov     OLDV4, @#4
                iot
                .word   0
; ───────────────────────────────────────────────────────────────────────────
;обработка команды COPY
CMDCPY:         call    SKIPWS
                .addr   R4, FCBFIL
                inc     R2
                iot
                .word   51				;Произвести синтаксический разбор строки. 
                bcs     17$
                .addr   R5, FCBTMP
                call    SKIPWS
                tstb    (R1)
                beq     1$
                cmpb    (R1), #'/
                bne     2$
1$:             jmp     L2324

2$:             .addr   R0, EOF
                mov     R0, BUFADR
                mov     R5, -(SP)
                mov     R4, -(SP)
                mov     R5, R4
                call    SKIPWS
                mov     R1, R0
                .addr   R1, TMPFIL
                movb    (R0)+, (R1)
                movb    (R0)+, 1(R1)
                iot
                .word   51				;Произвести синтаксический разбор строки. 
                mov     (SP)+, R5
                bcs     3$
                inc     R5
                mov     #20, R2
                .addr   R1, TAPFNM
                mov     R1, R0
4$:             movb    #40, (R0)+
                sob     R2, 4$
                mov     #13, R2
5$:             movb    (R5)+, R0
                cmpb    #40, R0
                beq     6$
                movb    R0, (R1)+
6$:             sob     R2, 5$
7$:             movb    #3, TAPCMD
                call    S3422
                mov     (SP)+, R4
                mov     TAPERR, R0
                beq     8$
                cmpb    R0, #4
                bne     9$
10$:            return

9$:             cmpb    #2, R0
                bne     11$
                mov     #3, R1
                call    OUTERS
                br      10$

11$:            mov     #7, R1
                call    OUTERS
                mov     #16, R1
                call    OUTERS
                mov     TAPBLK, R1
                add     #32, R1
                iot
                .word   11
                call    OUCRLF
                mov     R4, -(SP)
                br      7$

3$:             tst     (SP)+
17$:            movb    @#52, R0
                cmpb    #21, R0
                bne     12$
                mov     #15, R1
13$:            jmp     OUTERS

12$:            cmpb    #22, R0
                bne     14$
15$:            mov     #14, R1
                br      13$

14$:            cmpb    #24, R0
                beq     15$
                return

8$:             iot
                .word   26
                bcs     17$
                mov     TAPLDA, F$FLLD(R4)
                mov     BUFADR, F$DTAD(R4)
                mov     LOADSZ, F$RCSZ(R4)
                iot
                .word   42
                bcs     17$
                iot
                .word   20
                iot
                .word   15
                mov     BUFADR, R0
                mov     LOADSZ, R1
16$:            clrb    (R0)+
                sob     R1, 16$
                mov     TAPBLK, R1
                add     #32, R1
18$:            mov     #13, R0
                mov     R1, R2
19$:            cmpb    (R1), #40
                beq     20$
                tstb    (R1)
                beq     21$
                cmpb    (R1), #56
                blo     22$
                cmpb    (R1), #72
                blo     20$
                cmpb    (R1), #77
                blos    22$
                cmpb    (R1), #177
                blo     20$
                cmpb    (R1), #277
                blos    22$
20$:            inc     R1
                sob     R0, 19$
21$:            mov     R2, R1
                mov     R4, -(SP)
                add     #14, R4
                clr     R2
                iot
                .word   51
                bcs     22$
                mov     (SP)+, R4
                iot
                .word   27
                bcs     23$
                mov     TAPBLK, R1
                add     #32, R1
                clr     14(R1)
                iot
                .word   11
                mov     #5, R1
                call    OUTERS
                return

22$:            mov     R2, -(SP)
                mov     #10, R1
                call    OUTERS
                mov     (SP), R1
                iot
                .word   11
                call    OUCRLF
                mov     #11, R1
                call    OUTERS
24$:            mov     (SP)+, R1
                mov     #15, R2
                iot
                .word   6
                br      18$

23$:            cmpb    #33, @#52
                bne     25$
                mov     #7, R1
                call    OUTERS
                mov     TAPBLK, R1
                add     #32, R1
                mov     R1, -(SP)
                iot
                .word   11
                mov     #12, R1
                call    OUTERS
                mov     #11, R1
                call    OUTERS
                br      24$

25$:            clrb    F$FOPN(R4)
                iot
                .word   23
                return

L2314:          mov     #1, R1
                jmp     OUTERS

L2324:          tstb    (R1)
                beq     1$
                cmpb    (R1), #'/
                bne     L2314
                inc     R1
                call    SKIPWS
                movb    (R1), R0
                sub     #60, R0
                beq     L2314
                cmp     R0, #11
                bhi     L2314
                mov     R0, W2730

1$:             iot
                .word   21
                bcs     EXCMD1
2$:             mov     R4, -(SP)
                mov     R5, -(SP)
                inc     R5
                mov     #13, R0
3$:             movb    (R1)+, (R5)+
                sob     R0, 3$
                mov     (SP), R4
                iot
                .word   17
                .addr   R0, EOF
                mov     R0, F$DTAD(R4)
                mov     F$FLSZ(R4), F$RCSZ(R4)
                iot
                .word   41
                iot
                .word   20
                iot
                .word   15
                mov     W2730, W2732
                movb    #2, TAPCMD
                .addr   R0, TAPFNM
                mov     R0, R2
                mov     #20, R1
4$:             movb    #40, (R2)+
                sob     R1, 4$
                mov     #13, R1
                inc     R4
5$:             movb    (R4)+, R2
                cmpb    #40, R2
                beq     6$
                movb    R2, (R0)+
6$:             sob     R1, 5$
7$:             call    S3422
                tstb    TAPERR
                bne     8$
                dec     W2732
                bne     7$
8$:             mov     (SP)+, R5
                mov     (SP)+, R4
                mov     R5, R1
                tstb    TAPERR
                bne     9$
                iot
                .word   11
                mov     #5, R1
                call    OUTERS
                iot
                .word   22
                bcc     2$
9$:             iot
                .word   15
                return
; ───────────────────────────────────────────────────────────────────────────

EXCMD1:         mov     #4, R1
                jmp     OUTERS
; ───────────────────────────────────────────────────────────────────────────
;обработка команды DIR
CMDDIR:         call    SKIPWS
                inc     R2
                .addr   R4, FCBFIL
                iot
                .word   51
                clr     R5
                iot
                .word   21
                bcs     EXCMD1
1$:             clrb    14(R1)
                iot
                .word   11
                mov     #40, R0
                iot
                .word   2
                inc     R5
                cmp     R5, #5
                bne     2$
                clr     R5
                call    OUCRLF
2$:             iot
                .word   22
                bcc     1$
                jmp     OUCRLF
; ───────────────────────────────────────────────────────────────────────────
W2730:          .word   0
W2732:          .word   0
OLDV4:          .word   0
; ───────────────────────────────────────────────────────────────────────────

S2736:          mov     #6, R1
                call    OUTERS
                iot
                .word   15				;Инициализировать драйвер (контроллер) дисковода. 
                return

; ═══════════════════════════════════════════════════════════════════════════

OUCRLF:         mov     #5015, R0
                iot
                .word   2
                swab    R0
                iot
                .word   2
                return

; ───────────────────────────────────────────────────────────────────────────
;обработка команды HELP
CMDHLP:         .addr   R4, FCBCPH
                iot
                .word   17				;Открыть файл методом FCB. 
                bcc     1$
                jmp     EXCMD1

1$:             mov     #1, F$RCSZ(R4)
                clr     F$DTAD(R4)
                iot
                .word   24				;Последовательное чтение из файла. 
                movb    @#0, R0
                cmpb    #32, R0
                beq     2$
                iot
                .word   2				;Вывод символа на стандартное устройство вывода 
                br      1$

2$:             iot
                .word   20
                return
; ───────────────────────────────────────────────────────────────────────────
FCBCPH:         .byte 0
                .ascii "COPYM   HLP"
                .blkb 42

; ═══════════════════════════════════════════════════════════════════════════


SKIPWS:         cmpb    #40, (R1)
                bne     1$
                inc     R1
                br      SKIPWS

1$:             ccc
                return

; ───────────────────────────────────────────────────────────────────────────
;обработка команды FIND
CMDFND:         mov     #4, R0
                mov     R3, -(SP)
                mov     (R0), -(SP)
                mov     SP, SP$BUF
                mov     PC, (R0)
                add     #VEC4$1-., (R0)
                mov     #1, TAPSTP
1$:             mov     #40, R5
                .addr   R1, TAPCMD
                mov     R1, TAPBLK
                mov     #177716, R3
                mov     TAPEON, (R3)
                clr     TAPERR
                clr     TAPINV
                call    RDSYNC
                call    RDHEAD
                mov     TAPBLK, R1
                add     #32, R1
                clr     52(R1)		;!!!вероятно ошибка. тут очищается ячейка TAPERR. вроде бы задумано не это действие, а очистка 20-го байта, сразу за именем найденного файла 
                iot
                .word   11
                call    OUCRLF
                br      1$
; ───────────────────────────────────────────────────────────────────────────

VEC4$1:         mov     SP$BUF, SP
                mov     (SP)+, @#4
                mov     (SP)+, R3
                clr     TAPERR
                return

; ═══════════════════════════════════════════════════════════════════════════
;получение по имени команды ее номер

CMDNUM:         clr     R0
1$:             cmpb    (R1), #'$
                beq     2$
                mov     R2, R5
3$:             tstb    (R1)
                beq     5$
                cmpb    (R5)+, (R1)+
                bne     4$
                br      3$

4$:             inc     R1
                tstb    -1(R1)
                bne     4$
                tst     (R0)+
                br      1$

2$:             sec
5$:             return

; ───────────────────────────────────────────────────────────────────────────
;вывод ошибок из массива, индекс в R1
OUTERS:         .addr   R2, STRARR
3$:             dec     R1
                ble     1$
2$:             tstb    (R2)+
                bne     2$
                br      3$

1$:             mov     R2, R1
                iot
                .word   11
                sec
                iot
                .word   15
                return

; ═══════════════════════════════════════════════════════════════════════════

S3422:          mov     R3, -(SP)
                mov     #177716, R3
                .addr   R1, TAPCMD
                clr     TAPERR
                mov     R1, TAPBLK
                clr     TAPINV
                mov     #4, R0
                mov     (R0), -(SP)
                mov     PC, (R0)
                add     #VEC4$2-., (R0)
                mov     SP, SP$BUF
                movb    (R1), R0
                dec     R0
                dec     R0
                bne     1$
                call    S3544
                br      L2V4$2

1$:             call    READTP
                br      L2V4$2

VEC4$2:         mov     SP$BUF, SP
                movb    #4, TAPERR
L2V4$2:         mov     TAPEOF, (R3)
                mov     (SP)+, @#4
                mov     (SP)+, R3
                return

; ═══════════════════════════════════════════════════════════════════════════

S3544:          mov     TAPEON, (R3)
                mov     TMPBUF, R5
                mov     TMPLEN, R4
                beq     1$
                mov     R4, TAPLEN
                mov     TMPADR, TAPADR
                call    TAPCRC
                mov     R0, @#312
                mov     #10000, R0
                call    S3704
                mov     (R1)+, R0
                mov     #24, R2
                call    S3774
                mov     TAPBLK, R1
                mov     TMPLEN, R2
                mov     TMPBUF, R1
                call    S3774
                mov     #312, R1
                mov     #2, R2
                call    SAVBYT
                mov     #400, R0
                mov     R0, R4
                mov     R0, R5
                call    S3704
1$:             mov     TAPEOF, (R3)
                return

; ═══════════════════════════════════════════════════════════════════════════

S3704:          mov     LEVEL3, (R3)
                add     #27, R5
                sob     R5, .
                mov     TAPEON, (R3)
                add     #26, R4
                sob     R4, .
                sob     R0, S3704
                mov     LEVEL2, (R3)
                mov     #151, R5
                sob     R5, .
                mov     LEVEL1, (R3)
                mov     #144, R5
                sob     R5, .
                inc     R4
                mov     R2, R0
                mov     R4, R2
                call    SAVBIT
                mov     R0, R2
                return

; ═══════════════════════════════════════════════════════════════════════════

S3774:          mov     #10, R0
                call    S3704

; ═══════════════════════════════════════════════════════════════════════════
;запись байтов

SAVBYT:         movb    (R1)+, R0
                mov     #8., R4
L4012:          asr     R0
                bcs     SAVBIT
                mov     LEVEL3, (R3)
                mov     #30, R5
                sob     R5, .
                mov     TAPEON, (R3)
                mov     #27, R5
                sob     R5, .
                br      L4070

; ═══════════════════════════════════════════════════════════════════════════
;запись бита, плавно переходящая в запись байтов

SAVBIT:         mov     LEVEL2, (R3)
                mov     #63, R5
                sob     R5, .
                mov     LEVEL1, (R3)
                mov     #63, R5
                sob     R5, .
L4070:          mov     LEVEL3, (R3)
                mov     #30, R5
                sob     R5, .
                mov     TAPEON, (R3)
                mov     #26, R5
                sob     R5, .
                sob     R4, L4012
                sob     R2, SAVBYT
                return

; ═══════════════════════════════════════════════════════════════════════════


TAPCRC:         clr     R0
1$:             clr     R2
                bisb    (R5)+, R2
                add     R2, R0
                adc     R0
                sob     R4, 1$
                return

; ═══════════════════════════════════════════════════════════════════════════
;чтение с ленты

READTP:         mov     #40, R5
                clr     R0
1$:             mov     TAPEON, (R3)
                sob     R0, 1$
                mov     #1, TAPSTP
L4162:          clr     TAPINV
                call    RDSYNC
                call    RDHEAD
                tstb    TAPERR
                bne     2$
                call    RDFILE
                mov     TAPEOF, (R3)
2$:             return

; ═══════════════════════════════════════════════════════════════════════════
;чтение настроечной последовательности и автоподстройка

RDSYNC:         mov     #4000, R2
                clr     R0
1$:             clr     R4
2$:             bit     R5, (R3)
                beq     2$
3$:             inc     R4
                bit     R5, (R3)
                bne     3$
                sub     R4, R0
                bmi     4$
                cmp     R0, #2
                bhi     RDSYNC
4$:             mov     R4, R0
                sob     R2, 1$
                clr     R0
                mov     #200, R2
5$:             call    RDBIT
                add     R4, R0
                sob     R2, 5$
                mov     #7, R2
6$:             asr     R0
                sob     R2, 6$
                mov     R0, R4
                asr     R4
                add     R4, R0
                mov     R0, TAPAVG
7$:             clr     R4
8$:             inc     R4
                bit     R5, (R3)
                bne     8$
                cmp     R4, R0
                bhi     10$
                clr     R4
9$:             inc     R4
                bit     R5, (R3)
                beq     9$
                cmp     R4, R0
                blo     7$
                incb    TAPINV
10$:            asl     R0
                cmp     R4, R0
                bhi     L4370
                call    RDBIT
                return

L4366:          tst     (SP)+
L4370:          tst     (SP)+
                br      L4162

; ═══════════════════════════════════════════════════════════════════════════
;чтение заголовка с магнитофона

RDHEAD:         mov     TAPBLK, R1
                add     #26, R1
                mov     R0, -(SP)
                mov     R1, -(SP)
                mov     #24, R2
                call    RDDATA
                mov     (SP)+, R1
                tst     (R1)+
                mov     (R1)+, LOADSZ
                mov     #13, R2
                mov     TAPBLK, R0
                add     #6, R0
1$:             cmpb    #'?, (R0)
                beq     2$
                cmpb    (R0), (R1)
                bne     3$
2$:             inc     R0
                inc     R1
                sob     R2, 1$
                br      4$

3$:             incb    TAPERR
4$:             mov     (SP)+, R0
                return

; ═══════════════════════════════════════════════════════════════════════════
;чтение файла с магнитофона

RDFILE:         mov     BUFADR, R1
                mov     LOADSZ, R2
                call    RDDATA			;считываем файл
                mov     #312, R1
                mov     #2, R2
                call    RDBYTE			;считываем контрольную сумму
                mov     BUFADR, R5
                mov     LOADSZ, R4
                call    TAPCRC
                cmp     R0, @#312
                beq     1$
                movb    #2, TAPERR
1$:             return

; ═══════════════════════════════════════════════════════════════════════════
;загрузка данных с ленты

RDDATA:         mov     TAPAVG, R0
                tstb    TAPINV
                bne     3$
1$:             clr     R4
2$:             inc     R4
                bit     R5, (R3)
                bne     2$
                cmp     R4, R0
                blo     1$
                br      5$

3$:             clr     R4
4$:             inc     R4
                bit     R5, (R3)
                beq     4$
                cmp     R4, R0
                blo     3$
5$:             asl     R0
                cmp     R4, R0
                bhi     L4366
                call    RDBIT

; ═══════════════════════════════════════════════════════════════════════════
;читаем байты с магнитофона
;вход:	R1 - адрес буфера, куда читать
;		R2 - количество читаемых байтов

RDBYTE:         mov     #8., R0
1$:             call    RDBIT
                cmp     R4, TAPAVG
                bhi     2$
                clc
                br      3$

2$:             sec
3$:             rorb    (R1)
                sob     R0, 1$
                add     TAPSTP, R1
                sob     R2, RDBYTE
                return

; ═══════════════════════════════════════════════════════════════════════════
;читаем бит с магнитофона

RDBIT:          clr     R4
                tstb    TAPINV
                bne     5$
1$:             bit     R5, (R3)
                bne     1$
2$:             bit     R5, (R3)
                beq     2$
3$:             inc     R4
                bit     R5, (R3)
                bne     3$
4$:             inc     R4
                bit     R5, (R3)
                beq     4$
                return

5$:             bit     R5, (R3)
                beq     5$
6$:             bit     R5, (R3)
                bne     6$
7$:             inc     R4
                bit     R5, (R3)
                beq     7$
8$:             inc     R4
                bit     R5, (R3)
                bne     8$
                return
; End of function RDBIT

; ───────────────────────────────────────────────────────────────────────────
CMDTBL:         .asciz "HELP"
                .asciz "DIR"
                .asciz "FIND"
                .asciz "EXIT"
                .asciz "COPY"
                .asciz "$"

                .blkb 20
KEYBUF:         .blkb 100				;KBLEN
; ───────────────────────────────────────────────────────────────────────────
FCBFIL:         .blkb 54
; ───────────────────────────────────────────────────────────────────────────
FCBTMP:         .blkb   20				;FCB временного файла, создаваемого при записи на диск
TMPLEN:         .blkw   3				;размер файла в байтах, не может быть больше 64кб, поэтому только младшее слово
										;а дата вообще не используется, или сама генерируется
TMPADR:         .blkw   11				;адрес загрузки в память
TMPBUF:         .word   0				;адрес буфера, где находится файл
                .word   0
; ───────────────────────────────────────────────────────────────────────────
TMPFIL:         .asciz "A:COPYM.TMP"	;временное имя файла, создаваемое при записи на диск
                .even
;блок параметров магнитофона
TAPCMD:         .word   0				;команда драйвера магнитофона
TAPADR:         .word   0				;адрес загрузки/записи
TAPLEN:         .word   0				;длина массива
TAPFNM:         .blkb   20				;имя файла прочитанного с магнитофона
TAPLDA:         .blkw   25				;адрес обнаруженного на ленте массива, а так же остаток блока параметров
;конец блока параметров магнитофона
TAPBLK:         .word   0				;адрес блока параметров драйвера магнитофона
TAPINV:         .word   0				;флаг инверсного сигнала
TAPERR:         .word   0				;ошибка драйвера магнитофона
TAPSTP:         .word   0				;шаг при чтении байтов
SP$BUF:         .word   0				;указатель стека при обработке вектора 4
TAPAVG:         .word   0				;средневзвешенное значение сигнала
LOADSZ:         .word   0				;размер прочитанного массива
BUFADR:         .word   0				;адрес буфера
;константы для записи звука в 177716
TAPEON:         .word   0
TAPEOF:         .word   0
LEVEL3:         .word   0
LEVEL2:         .word   0
LEVEL1:         .word   0

CMDSUB:         .word   @CMDHLP			; смещения к подпрограммам команд
                .word   @CMDDIR
                .word   @CMDFND
                .word   @CMDEXI
                .word   @CMDCPY
                .word   0

STRARR:         .asciz "Invalid swich"<12><15>
                .asciz "Bad command or file name"<12><15>
                .asciz "Check sum error"<12><15>
                .asciz "File not found"<12><15>
                .asciz " - ok"<12><15>
                .asciz "M>>"
                .asciz "File "
                .asciz <14>"Bad file name :  "
                .asciz <12><15>"Input new file name :"
                .asciz "already exists"<12><15>
                .asciz <12><15>"Copym version 1.00"<12><15>
                .asciz "Disk full"<12><15>
                .asciz "Invalid drave specification"<12><15>
                .asciz "found: "
                .even
EOF:            .word   0


                .END
