﻿.LA 5000
; Processor:        1801VM1
; Target assembler: Turbo8 Assembler
; Файл: DXDOS.SYS

; ═══════════════════════════════════════════════════════════════════════════
ERRFDD=52	;адрес, куда сохраняется номер ошибки
;ячейки, используемые в начале при определении параметров
PRNSTB=256	;значение стробирующего бита для принтера: 400-для БК0010, 40000-для БК0011.
BKMONT=400	;тип монитора 0-БК0010,1-БК0011М,2-БК0011.
ENDRAM=402	;адрес последней ячейки ОЗУ
DRVCNT=404	;счётчик рабочих дисководов
DRVSTT=406	;таблица статусов дисководов длиной до 4х слов
SYSDRV=416	;буква привода, с которого загрузилась система
AFATTB=420	;таблица адресов буферов под ФАТ длиной до 4х слов
STORV4=430	;ячейка хранения вектора 4
HIRAML=432	;верхний адрес пользовательского ОЗУ.
BKTYPE=434	;тип машины 0-БК0010, 1-БК0011М,2-БК0011.
; ───────────────────────────────────────────────────────────────────────────
;структура FCB, размер 52 байта
F$NDRV=0 	;номер дисковода: 0-текущий,1-'А',2-'В'...
F$FLNM=1 	;имя файла + суффикс файла
F$CBLK=14	;номер текущего блока(для функций последовательного доступа.
F$RCSZ=16	;размер записи в байтах.
F$FLSZ=20	;размер файла в байтах.
F$FLDT=24	;дата создания файла.
F$FLLD=26	;адрес загрузки файла в память (для исполняемых файлов)
F$IDEV=30	;идентификатор устройства.
F$DIRP=31	;положение имени файла в каталоге.
F$STCL=32	;начальный кластер .
F$TMP1=34	;используется DOS под разные нужды. как seek
F$TMP2=36	;так и как временный буфер всяких данных
F$CURR=40	;текущая запись (последов.доступ к файлам)
F$FOPN=41	;признак открытия файла?
F$RECN=42	;номер записи (для функций прямого доступа)
F$TMP3=46	;используется DOS
F$ATTR=47	;атрибуты файла
F$DTAD=50	;адрес обмена
FCB$SZ=52	;размер FCB
; ───────────────────────────────────────────────────────────────────────────
;структура параметров устройства, размер 56 байтов
P$SECZ=0 	;размер сектора в байтах
P$CLSZ=2 	;размер кластера в секторах
P$NFAT=4 	;количество копий FAT
P$DIRZ=6 	;максимальное количество элементов в каталоге
P$TSEC=10	;общее число секторов
P$FMTI=12	;идентификатор формата
P$FATZ=14	;размер FAT в секторах
P$NSEC=16	;число секторов на дорожке
P$NSID=20	;количество сторон диска
P$TMP1=22	;зарезервировано
P$CLBZ=24	;размер кластера в байтах
P$FLCT=26	;счётчик открытых файлов для этого устройства
P$ENDS=30	;конечный сектор каталога
P$DIRS=32	;начальный сектор каталога
P$LFCL=34	;последний свободный кластер на диске
P$PSET=36	;биты настройки контроллера.
P$PDRV=40	;параметры дисковода
P$NDRV=42	;номер устройства
P$TMP2=44	;Используется DOS
P$AFAT=46	;адрес FAT в памяти
P$TMP3=50	;Используется DOS
P$TMP4=52	;Используется DOS
P$OPTP=54	;Тип операции :0-чтение,иначе запись
DPB$SZ=56	;размер блока параметров устройства
; ───────────────────────────────────────────────────────────────────────────
;Структура элемента каталога
D$NAME=0	;Короткое имя файла
D$ATTR=13	;Атрибуты файла
D$RSV1=14	;*Зарезервировано под Windows NT (должно содержать 0)
D$RSV2=15	;*Поле, уточняющее время создания файла (в десятках миллисекунд).
			; Значение поля может находиться в пределах от 0 до 199
D$TIME=16	;*Время создания файла
D$DATE=20	;*Дата создания файла
D$DLUS=22	;*Дата последнего обращения к файлу для записи или считывания данных
D$CLNH=24	;*Старшее слово номера первого кластера файла
D$TLWR=26	;Время выполнения последней операции записи в файл
D$DLWR=30	;Дата выполнения последней операции записи в файл
D$CLNL=32	;Младшее слово номера первого кластера файла
D$SIZE=34	;Размер файла в байтах (32-разрядное число)
;Знак "*" означает, что поле обрабатывается только в файловой системе FAT32. В системах FAT12 и FAT16 поле считается ;зарезервированным и содержит значение 0.
; ───────────────────────────────────────────────────────────────────────────
; Полная таблица внутрисистемной информации:
S$BUFT=0		;		буфер для сохранения PSW, а так же флаг чтение-запись
S$DOSA=2		;		адрес начала области окружения DOS
S$CLSZ=4		;		количество кластеров на диске
S$DBLA=6		;*		адрес списка дисковых блоков.(адреса абсолютные)
S$DOSZ=10		;		длина области окружения DOS (120 байтов)
S$ER52=12		;		номер прошлой ошибки в ячейке 52
S$CRDN=14		;(1б)	номер текущего устройства прямого доступа (дисковода).
S$DRVN=15		;*(1б)	количество устройств прямого доступа в системе.
S$FLPN=16		;*(1б)	количество дисководов в системе.
S$IONC=17		;(1б)	флаг, что буфер S$BIOA и S$SIOA не совпадают.
S$FWBF=20		;*		адрес рабочей области драйвера дисковода (длина 70 байтов).
S$STBP=22		;*		значение стробирующего бита для принтера : 400-для БК0010, 40000-для БК0011.
S$DATE=24		;		текущая дата
S$NMBF=26		;		адрес буфера длиной 14 байтов имени для поиска
S$BIOA=30		;		адрес области обмена с диском (адрес чтения/записи физического сектора), который можно изменить пользователем
S$TFCB=32		;		адрес буфера FCB под параметры устройства и промежуточных данных.
S$SIOA=34		;		системный адрес области обмена с диском (адрес чтения/записи физического сектора) не изменяемый
S$PRNF=36		;(1б)	флаг вывода на принтер. !0 - выводить, 0 - не выводить
S$INKF=37		;(1б)	флаг: 0 - ввод с клавиатуры, иначе - ввод с устройства ввода
S$BINA=40		;		адрес буфера устройства ввода, длиной 2 байта
S$DSTW=42		;		номер сектора каталога, который надо обработать
S$DIRP=44		;(1б)	номер записи в каталоге (для создаваемых файлов)
S$TPLF=45		;(1б)	признак, что имя задано шаблоном (для переименования)
S$FCIA=46		;		адрес FCB стандартного устройства ввода
S$BOUA=50		;		адрес буфера устройства вывода, длиной 2 байта
S$ISSP=52		;		вершина внутрисистемного указателя стека для перехватчика emt 36
S$RENF=54		;(1б)	флаг режима переименования (используется для внутренних целей)
				;55 - свободно
S$CDSN=56		;		номер обрабатываемого сектора каталога при операциях с каталогом
S$PDOS=60		;*		адрес начала DOS.
S$ONED=62		;(1б)	Флаг, указывающий, что в системе всего один дисковод (1, если всего 1 дисковод, иначе 0)
S$RSFA=64		;*		адрес таблицы подпр.чтения сектора с устройства (при старте устанавливается 160006 для всех устройств).
S$RSLA=66		;*		адрес таблицы подпр.чтения секторов на логическом уровне.(на уровне DOS)
S$CSNW=70		;		номер сектора в буфере, который надо сохранить
S$CSNB=72		;		номер сектора, который находится в буфере чтения/записи
S$DNWS=74		;		номер дисковода, на который надо сохранить сектор
S$DNSB=76		;(1б)	номер устройства, сектор которого в буфере чтения/записи
				;		76 иногда используется как слово, а иногда как байт
S$CDDN=100		;(1б)	номер дисковода, каталог которого в буфере
S$FCOA=102		;		адрес FCB стандартного устройства вывода
S$BRDT=104		;*(1б)	тип машины 0-БК0010, 1-БК0011М,2-БК0011.
S$MONT=105		;*(1б)	тип монитора 0-БК0010,1-БК0011М,2-БК0011.
S$BTFA=106		;		адрес области BAT файлов длиной 204 байта, первое слово - уровень вложенности
S$MBPT=110		;		указатель в памяти на обрабатываемые данные (куда читать с диска, откуда писать на диск)
S$FPTR=112		;(4б)	текущее положение указателя в файле
S$NCLS=116		;		количество обрабатываемых кластеров
S$BSCC=120		;		счётчик прочитанных/записанных байтов
S$SCLC=122		;		счётчик секторов в кластере
S$BIOO=124		;		смещение в буфере текущего сектора чтения/записи
S$SDNM=126		;*		адрес списка имён символьных устройств.(имена разделены нулевым байтом).
S$SDJA=130		;*		адрес таблицы переходов для символьных устройств.
S$IOTA=132		;		адрес таблицы подпрограмм IOT диспетчера
S$ERMA=134		;		адрес таблицы символьных сообщений об ошибке, строки разделяются 0
S$FADR=136		;		адрес загрузки/записи файла
S$FCRC=140		;		CRC файла
S$FSZE=142		;		размер файла
S$CMLA=144		;		адрес командной строки
S$CMLS=146		;		длина командной строки (длина 140 байтов)
S$CEMB=150		;		адрес буфера, перехвата ЕМТ команд, для монитора БК11 * 2
S$EMCN=152		;		количество ЕМТ команд, 132 для монитора БК11 и 50 для монитора БК10
S$EXSY=154		;		адрес функции выхода в ДОС
S$OV30=156		;		адрес адреса старого вектора 30, потом нигде не используется
S$BE36=160		;		адрес буфера копии имени в перехватчике emt36 (100 байтов)
S$LE36=162		;		длина буфера копии имени в перехватчике emt36 (100 байтов)
S$HRAM=164		;*		верхний адрес пользовательского ОЗУ.
S$PPAD=166		;*		адрес параллельного порта (при старте устанавливается значение 177714).
S$BLSZ=170		;размер таблицы внутрисистемной информации. резервируется 346 байтов
;* помечены официально описанные в документации ячейки

; ───────────────────────────────────────────────────────────────────────────
;ячейки рабочей области драйвера дисковода
CSRW=0		;копия по записи регистра состояния КНГМД
CURTRK=2	;адрес текущей дорожки (адрес одного из следующих байтов из таблицы)
TRKTAB=4	;таблица текущих дорожек
TDOWN=10	;задержка опускания головки
TSTEP=12	;задержка перехода с дорожки на дорожку
TRKCOR=14	;дорожка начала предкомпенсации
BRETRY=15	;число попыток повтора при ошибке
FLAGS=16	;рабочая ячейка драйвера
FILLB=17	;код заполнения при форматировании
FLGPTR=20	;указатель на байт признаков (адрес одного из следующих байтов из таблицы)
FLGTAB=22	;таблица признаков
ADDR=26		;адрес начала массива данных в ОЗУ (обязательно чётный)
WCNT=30		;количество слов для пересылки
SIDE=32		;номер стороны диска
TRK=33		;номер дорожки
UNIT=34		;номер привода
SECTOR=35	;номер сектора
WRTVAR=36	;значение, записываемое при форматировании
MARKER=40	;буфер маркера при записи
FREE=42		;длина пустого остатка сектора
INTIME=44	;счётчик длительности индекса
BUF4=46		;буфер для сохранения вектора 4
BUFSP=50	;буфер для сохранения SP
BUFPSW=52	;буфер для сохранения PSW
CRETRY=54	;счётчик повторов при ошибке
TURNS=55	;число оборотов диска при поиске сектора
SECRET=56	;число повторных попыток поиска сектора
ERRNUM=57	;буфер для номера ошибки
MAXSEC=60	;число секторов на дорожке
HOLTIN=62	;время задержки после индекса
SECLEN=64	;длина сектора в словах

;переменные, связанные с бат файлами
BATLBF=54	;размер буфера вложенностей области бат файлов
BAT$SZ=204	;размер области бат файлов

CMDLSZ=140	;размер буфера командной строки
DOSASZ=120	;длина области окружения ДОС
NBE36L=100	;размер буфера копии имени в перехватчике emt36

; ═══════════════════════════════════════════════════════════════════════════
                br      START

DXVERS:         .ascii "DX-DOS Version 1.00"<15><12>
                .asciz "Copyright 1995 by SENDY CORP."<15><12>
                .even
ERRMEM:         .asciz "Fatal error:Cannot allocate Memory for DOS"<15><12>
                .even
NOMEMR:         .asciz "Configuration too large for memory"<15><12>
                .even

; ═══════════════════════════════════════════════════════════════════════════
;вывод строки.
;вход:	R1 - адрес строки, конец строки - 0

OUTSTR:         movb    (R1)+, R0
                beq     1$
                call    OUTCHR
                br      OUTSTR
1$:             return

;обработка фатальной ошибки
FTLERR:         mov     @#STORV4, @#4
                halt
; ───────────────────────────────────────────────────────────────────────────

START:          mov     @#4, @#STORV4
                mov     #1000, SP
                clr     @#BKMONT			;0 - мон.БК10
                clr     @#62				;psw векторов прерывания
                clr     @#276
                clr     @#BKTYPE			;0 - БК10
                mov     #400, @#PRNSTB		;зададим стробирующий бит для принтера на БК10
                mov     @#177716, R0		;берём адрес запуска БК
                bic     #377, R0			;оставляем от него старший байт
                cmp     #100000, R0			;это БК10 ?
                beq     1$					;да
                mov     #40000, @#PRNSTB	;зададим стробирующий бит для принтера на БК11
                inc     @#BKTYPE			;1 - БК11М
                cmp     #167, @#140004		;это БК11М?
                beq     1$					;да
                inc     @#BKTYPE			;2 - БК11
                cmp     #12706, @#140004	;это БК11(не М)?
                bne     FTLERR				;нет - неопознанная БКшка, на такой не работаем
1$:             mov     #40000, @#HIRAML	;зададим верхний адрес пользовательского ОЗУ для БК10
                cmp     @#30, #100112		;а это у нас монитор БК10?
                beq     2$					;да, даже если мы на БК11 пользуемся монитором от 10ки, будем считать, что работаем на БК10
                inc     @#BKMONT			;1 - мон.БК11М
                cmp     @#30, #152112		;а это у нас монитор БК11М?
                bne     3$					;нет
                mov     #104033, INPCHR		;да, тогда поменяем емт команды ввода-вывода для монитора БК11М
                mov     #104063, OUTCHR
                mov     #104000, AE14$1
                mov     #104000, AE14$2
                mov     #404, R0			;стр.4 в окно 1
                emt     12					;подключение страницы озу/пзу
                mov     #3, R0				;стр.3 в окно 0
                emt     12					;подключение страницы озу/пзу
                mov     #100000, @#HIRAML	;зададим верхний адрес пользовательского ОЗУ для БК11
                mov     #6300, FIOT37
                mov     #6305, M2$11M
                clr     @#117770
                br      2$

3$:             cmp     @#30, #147552		;а это у нас монитор БК11?
                bne     FTLERR				;нет - неопознанный монитор БКшки, на таком не работаем
                inc     @#BKMONT			;2 - мон.БК11
                mov     #3, R0				;стр.3 в окно 0
                emt     52					;подключение страницы озу/пзу
                mov     #404, R0			;стр.4 в окно 1
                emt     52					;подключение страницы озу/пзу
                clr     @#117770

2$:             .addr   R1, DXVERS
                call    OUTSTR				;выведем заголовок
                mov     #160000, R5			;ищем конец ОЗУ, начнём отсюда
                mov     @#4, -(SP)
                .addr   R0,HLT4M1
                mov     R0, @#4

FFM1$:          clr     (R5)				;это ОЗУ, если нет - то будет HLT4M1
                mov     R5, @#ENDRAM
                cmp     R5, #100000			;дошли досюда, а ОЗУ так и не нашли?
                bhi     FFM4$				;не, пока не дошли
FFM2$:          .addr   R1, ERRMEM			;да, а памяти для ДОС то нету.
FFM3$:          call    OUTSTR				;скажем об этом
                jmp     FTLERR				;и выходим с ошибкой

HLT4M1:         cmp     (SP)+, (SP)+		;обработаем прерывание по вектору 4
                tst     -(R5)
                br      FFM1$				;пойдём искать дальше

FFM4$:          .addr   R0, FFM2$			;нашли.
                mov     R0, @#4
                mov     #7777, R1			;это нужный нам размер в словах под ДОС
1$:             clr     -(R5)				;проверим, если случится trap to 4, значит нужного участка ОЗУ нету
                sob     R1, 1$				;в R5 адрес начала свободного участка ОЗУ, но он нам тупо не нужен.
; ───────────────────────────────────────────────────────────────────────────
                mov     #DRVSTT, R0
                clr     @#DRVCNT
                mov     #1, R1				;начнём с привода А
11$:            mov     #177130, R5
                mov     R1, -(SP)
                bis     #20, R1				;выставим команду включения двигателя
                mov     R1, (R5)			;включим двигатель
                sob     R4, .				;подождём, пока контроллер среагирует
                mov     #128., R2			;будем делать цикл столько раз.
                bis     #200, R1			;выставим команду ШАГ и направление к 0
2$:             mov     #1000, R4
                sob     R4, .				;небольшая пауза (для драматизму)
                bit     #1, (R5)			;мы уже на нулевой?
                bne     3$					;да
                mov     R1, (R5)			;нет, шагнём
                mov     #4000, R4
                sob     R4, .				;подождём, пока контроллер среагирует
                sob     R2, 2$				;в цикле, пока не дойдём до 0
                br      6$					;цикл кончился, а до дорожки 0 так и не дошли, что-то не так

3$:             mov     #48., R2
                bic     #200, R1			;сбросим ШАГ
                bis     #300, R1			;а затем обратно установим, и зададим направление движения к центру
4$:             mov     R1, (R5)			;шагнём, теперь понятно, зачем была нужна та драматическая пауза, это чтобы тут, контроллер воспринял команду.
                mov     #2000, R4
                sob     R4, .				;подождём, пока контроллер среагирует
                sob     R2, 4$				;и так в цикле 48 раз.
                mov     #64., R2
                bic     #300, R1			;сбросим ШАГ и направление
                bis     #200, R1			;выставим команду ШАГ и направление к 0
5$:             mov     R1, (R5)			;шагнём
                mov     #2000, R4
                sob     R4, .				;подождём, пока контроллер среагирует
                bit     #1, (R5)			;дошли до нулевой?
                bne     7$					;да
                mov     #1000, R4			;нет ещё
                sob     R4, .				;небольшая пауза
                sob     R2, 5$				;и так в цикле 64 раза
6$:             mov     #-1, R2				;если не смогли вернуться на 0 дор. - значит что-то не так
                br      8$

7$:             cmp     #17., R2			;если в счётчике осталось не 17
                bne     9$					;то какая-то фигня творится
                clr     R2					;иначе все корректно
                br      8$

9$:             mov     #1, R2				;возврат на 0 дор. делается быстрее, чем от нее
8$:             mov     (SP)+, R1			;восстановим номер привода
                tst     R2					;какой статус?
                bmi     10$					;не смогли достичь дорожки 0
                mov     R2, (R0)+			;сохраним статус привода
                inc     @#DRVCNT			;увеличим счётчик работающих приводов
                asl     R1					;переходим к следующему приводу
                br      11$					;повторим процедуру для него

10$:            clr     @#177130			;а раз не смогли достичь дор.0, то значит не что-то не так,
                sob     R5, .				;а просто оказывается приводы кончились
                sob     R5, .
; ───────────────────────────────────────────────────────────────────────────
                .addr   R5, HLT4M2
                mov     R5, @#4				;новый вектор 4
                .addr   R5, ENKRNL			;адрес конца основного ядра DOS
                mov     @#ENDRAM, R4		;адрес ОЗУ, куда перемещать
                .addr   R3, BGKRNL			;адрес начала основного ядра DOS
21$:            mov     -(R5), R0			;читаем очередное слово
                cmp     R5, R3				;дошли до начала?
                blo     22$					;да, значит хватит
                mov     R0, -(R4)			;нет, сохраним в новом месте
                br      21$					;повторим

22$:            .addr   R5, RUNBLK			;а этот блок
                mov     #1000, R2			;разместим по этому адресу
23$:            cmp     #-1, (R5)			;признак конца блока достигнут?
                beq     24$					;да - хватит перемещать
                mov     (R5)+, (R2)+		;нет - переместим
                br      23$					;продолжим

24$:            jmp     (R4)				;переходим в ядро
; ───────────────────────────────────────────────────────────────────────────

HLT4M2:         cmp     (SP)+, (SP)+		;наш новый вектор
                .addr   R1, NOMEMR			;скажем, что ядро не перемещается, места нету
                jmp     FFM3$
; ═══════════════════════════════════════════════════════════════════════════
;блок запускателя, размещается по адресу 1000
RUNBLK:         .addr   R4, FCBCMD			;адрес FCB
                iot
                .word 21					;Найти первый файл по образцу. вход: R4-адрес FCB.
                bcs     6$
                iot
                .word 61					;Доступ к внутрисистемной информации. выход: R1-адрес области DOS.
                tstb    S$BRDT(R1)			;какой тип машины? тип машины 0-БК0010, 1-БК0011М,2-БК0011.
                beq     5$					;бк10
                mov     @#117770, R5
                cmp     #16000, R5
                beq     3$
                mov     #56000, @#177716	;стр.7 в о.0, стр.4 в о.1
                mov     #76000, R4
                cmpb    #1, S$BRDT(R1)		;бк11м?
                beq     1$					;да
                mov     @#66, R5			;нет, у БК11 копия ССП тут
                br      2$

1$:             mov     @#114, R5			;у БК11М копия ССП тут
2$:             cmp     #52652, (R4)		;какие-то таинственные манипуляции
                bne     4$
                clr     (R4)+
                mov     (R4)+, R5			;что это, зачем, хер поймёшь
                mov     R5, @#117770
                tstb    43(R4)
                beq     3$
                iot
                .word 30					;Доступ к буферам DOS. выход: R0 - адрес области BAT-файлов.
											;R1 - адрес FCB стандартного устройства ввода.
											;R2 - адрес FCB стандартного устройства вывода.
                mov     R0, -(SP)			;R0 - адрес области BAT-файлов.
                mov     #BAT$SZ, R1
7$:             movb    (R4)+, (R0)+
                sob     R1, 7$
                mov     (SP)+, R4			;адрес области BAT-файлов.
                mov     R5, -(SP)
                mov     (R4)+, R5			;уровень вложенности BAT-файла.
9$:             movb    (R4), R0			;номер текущего устройства
                beq     8$
                tstb    F$FOPN(R4)			;файл уже открыт?
                beq     8$					;нет
                iot
                .word 34					;Получить параметры заданного устройства.
											;вход: R0-номер устройства (1-дисковод "А"...)
											;выход:  R2-адрес списка параметров.
                add     #BATLBF, R4
                sob     R5, 9$
8$:             mov     (SP)+, R5
3$:             mov     R5, @#177716
                br      10$

4$:             mov     R5, @#177716
5$:             iot
                .word 30					;Доступ к буферам DOS. выход: R0 - адрес области BAT-файлов.
											;R1 - адрес FCB стандартного устройства ввода.
											;R2 - адрес FCB стандартного устройства вывода.
                mov     R0, -(SP)			;адрес области BAT-файлов.
                tst     (R0)+				;первое слово - уровень вложенности ( 0 - область пуста).
                .addr   R1, AUTOEX
                mov     R0, R4
                iot
                .word 51					;Произвести синтаксический разбор строки.
											;вход: R1-адрес обрабатываемой строки.
											;	  R4-адрес формируемого FCB-блока.
											;	  R2-тип разбора:если 0,то обычный разбор.
											;		 если не 0,то если встретится первым код 0,
											;		 FCB  примет вид:_???????????
											;выход: R2-количество символов '?'.
                iot
                .word 17					;Открыть файл методом FCB. вход: R4-адрес FCB.
                mov     (SP)+, R0			;адрес области BAT-файлов.
                bcs     10$
                mov     #1, (R0)			;изменим уровень вложенности
10$:            iot
                .word 0						;Завершение программы пользователя.
											;Управление передаётся в DOS, вызывается оболочка имя которой
											;записано в переменной COMSPEC
; ───────────────────────────────────────────────────────────────────────────
6$:             .addr   R1, MISSAE			; "Missing command intepreter,\n\rsystem hal"...
                iot
                .word 11					;Вывод строки символов на устройство вывода (по умолчанию - консоль).
											;вход: R1-адрес строки символов. (Строка должна оканчиваться нулевым байтом)
                iot
                .word 15					;Инициализировать драйвер (контроллер) дисковода.
                .addr   R0, HLT4ST
                mov     R0, @#4
HLT4ST:         br      HLT4ST				;и всё. полный стоп.

; ───────────────────────────────────────────────────────────────────────────
MISSAE:         .ascii "Missing command intepreter,"<12><15>
                .asciz "system halted."
				.even
;-------начало FCB
FCBCMD:         .byte    0		;номер дисковода: 0-текущий,1-'А',2-'В'...
                .ascii   "COMMAND COM"	;имя файла + суффикс файла
                .blkb    36		;всё остальное
;-------конец FCB
                .word    0
                .word    0
AUTOEX:         .asciz   "AUTOEXEC.BAT"
                .even
                .word    0
                .word    177777	;признак конца блока запускателя.

; ══════ядро DOS═════════════════════════════════════════════════════════════
;сперва идёт одноразовый код, который потом затирается буферами.
BGKRNL:         call    INIIOT				;инициализируем вектор IOT и в R3 адрес буфера внутрисистемной информации
                .addr   R5, V30OLD
                mov     R5, S$OV30(R3)		;адрес адреса старого вектора 30
                movb    @#BKTYPE, S$BRDT(R3)	;тип машины 0-БК0010, 1-БК0011М,2-БК0011.
                .addr   R5, EMTTRP
                mov     R5, V30NEW
                .addr   R0, SYSOFS
                mov     #/IOTTEN-/SYSOFS, R1
1$:             mov     R0, R2				;в таблице смещений
                add     (R0), R2			;все смещения преобразуем в
                mov     R2, (R0)			;абсолютные адреса
                tst     (R0)+
                sob     R1, 1$
                mov     @#30, V30OLD		;сохраним старый вектор емт диспетчера
                mov     @#HIRAML, S$HRAM(R3)	;верхний адрес пользовательского ОЗУ.
                mov     #177714, S$PPAD(R3)	;адрес параллельного порта
                .addr   R0, BUFERS			;адрес конца участка, выделенного под буферы
                mov     @#20, S$ER52(R3)	;номер прошлой ошибки в ячейке 52 (заполняем старым вектором IOT)
                mov     #20041, S$DATE(R3)	;текущая дата
                .addr   R1, OUTDOS
                mov     R1, S$EXSY(R3)		;адрес функции выхода в DOS
                mov     @#PRNSTB, S$STBP(R3)	;значение стробирующего бита для принтера
                movb    @#BKMONT, S$MONT(R3)	;тип монитора 0-БК0010,1-БК0011М,2-БК0011.
                mov     #DOSASZ, R1
                mov     R1, S$DOSZ(R3)		;длина области окружения DOS
2$:             clrb    -(R0)
                sob     R1, 2$
                clr     -(R0)				;первое слово не входит в длину.
                mov     R0, S$DOSA(R3)		;адрес начала области окружения DOS
                mov     #CMDLSZ, R1
                mov     R1, S$CMLS(R3)		;длина буфера командной строки
3$:             clrb    -(R0)
                sob     R1, 3$
                clr     -(R0)				;первое слово не входит в длину.
                mov     R0, S$CMLA(R3)		;адрес буфера командной строки
                sub     #NBE36L, R0
                mov     R0, S$BE36(R3)		;адрес буфера копии имени в перехватчике emt36 (NBE36L байтов)
                mov     #NBE36L, S$LE36(R3)	;размер буфера копии имени в перехватчике emt36 (NBE36L байтов)
                sub     #BAT$SZ, R0			;длина области BAT файлов
                mov     R0, S$BTFA(R3)		;адрес области BAT файлов
                sub     #14, R0
                mov     R0, S$NMBF(R3)		;адрес буфера длиной 14 байтов
                sub     #70, R0
                mov     R0, S$FWBF(R3)		;адрес рабочей области драйвера дисковода (длина 70 байтов). 
                tst     -(R0)
                mov     R0, S$BINA(R3)		;адрес буфера устройства ввода, длиной 2 байта
                tst     -(R0)
                mov     R0, S$BOUA(R3)		;адрес буфера устройства вывода, длиной 2 байта
                sub     #1000, R0
                mov     R0, S$BIOA(R3)		;адрес области обмена с диском (адрес чтения/записи физического сектора) изменяемый
                mov     R0, S$SIOA(R3)		;адрес области обмена с диском (адрес чтения/записи физического сектора) не изменяемый
                movb    @#SYSDRV, S$CRDN(R3)	;номер текущего устройства прямого доступа (дисковода).
                decb    S$CRDN(R3)
                movb    @#DRVCNT, S$FLPN(R3)	;количество дисководов в системе. !!!оптимизировать
                movb    S$FLPN(R3), S$DRVN(R3)	;количество устройств прямого доступа в системе.
                cmpb    #1, S$FLPN(R3)			;в системе больше одного дисковода?
                blo     4$					;да
                mov     @#DRVSTT, @#DRVSTT+2	;а если только один
                movb    #2, S$DRVN(R3)		;немного поправим переменные
                movb    #1, S$ONED(R3)		;Укажем, что в системе всего один дисковод - A:
4$:             mov     R0, -(SP)
                .addr   R1, IOTTBL
                mov     R1, S$IOTA(R3)		;адрес таблицы подпрограмм IOT диспетчера
                .addr   R1, DEVFCB
                mov     R1, S$TFCB(R3)		;адрес буфера FCB под параметры устройства и промежуточных данных.
                .addr   R1, STDNAM
                mov     R1, S$SDNM(R3)		;адрес списка имён символьных устройств.
                .addr   R1, SYSOFS
                mov     R1, S$SDJA(R3)		;адрес таблицы переходов для символьных устройств.
                .addr   R1, DSKERR
                mov     R1, S$ERMA(R3)		;адрес таблицы символьных сообщений об ошибке
                .addr   R4, FCBIN
                mov     R4, S$FCIA(R3)		;адрес FCB стандартного устройства ввода
                iot
                .word 26					;Создать файл. вход: R4-адрес FCB.
                .addr   R4, FCBOUT
                mov     R4, S$FCOA(R3)		;адрес FCB стандартного устройства вывода
                iot
                .word 26					;Создать файл. вход: R4-адрес FCB.
                add     #100, @#SYSDRV		;делаем из номера привода букву
                .addr   R1, CMDCOM			;"COMSPEC=A:COMMAND.COM"
                movb    @#SYSDRV, CMDCOM+10	;!!!оптимизировать. у нас в R1 адрес CMDCOM
                iot
                .word 70					;Записать переменную в область окружения DOS. вход: R1-адрес строки.
                mov     (SP)+, R0
                mov     #50, R1
                tstb    S$MONT(R3)			;какой у нас монитор?
                beq     5$					;БК10
                mov     #132, R1
5$:             mov     R1, S$EMCN(R3)		;количество ЕМТ команд
                cmpb    #1, S$MONT(R3)		;монитор БК11М
                bne     6$					;нет
                asl     R1					;да, умножим ещё на 2
6$:             clrb    -(R0)
                sob     R1, 6$
                clr     -(R0)
                mov     R0, S$CEMB(R3)		;адрес буфера, перехвата ЕМТ команд, для монитора БК11 * 2
                tst     -(R0)
                mov     #4, R1				;сформируем
7$:             mov     #160006, -(R0)		;таблицу подпрограмм чтения сектора с устройства
                sob     R1, 7$				;для всех 4х устройств
                mov     R0, S$RSFA(R3)		;адрес таблицы подпр.чтения сектора с устройства 
                mov     #4, R2				;сформируем
                .addr   R5, SECTRD			;таблицу подпрограмм чтения секторов на логическом уровне
8$:             mov     R5, -(R0)			;для всех 4х устройств
                sob     R2, 8$
                mov     R0, S$RSLA(R3)		;адрес таблицы подпр.чтения секторов на логическом уровне.(на уровне DOS)
                mov     #AFATTB, R4
                tst     -(R0)
                movb    S$DRVN(R3), R1		;возьмём количество устройств прямого доступа системе.
9$:             sub     #1002, R0			;и сформируем таблицу адресов буферов под ФАТ
                mov     R0, (R4)+
                sob     R1, 9$
                mov     #AFATTB, R2
                sub     #4, R0
                mov     R0, S$DBLA(R3)		;адрес списка дисковых блоков.
                mov     R0, R5
                movb    S$DRVN(R3), R1
11$:            mov     #DPB$SZ, R4			;сформируем дисковые блоки 
10$:            clrb    -(R0)
                sob     R4, 10$
                mov     R0, (R5)+
                mov     DRVSTT-AFATTB(R2), P$PDRV(R0)	;статус дисковода из таблицы статусов
                mov     (R2)+, P$AFAT(R0)	;адрес буфера под ФАТ
                sob     R1, 11$
                mov     R0, S$PDOS(R3)		;вот наш адрес начала ДОС, тут начинаются всяческие буферы
; ───────────────────────────────────────────────────────────────────────────
                .addr   R0, COMSPK
                mov     R0, S$ISSP(R3)		;вершина внутрисистемного указателя стека для перехватчика emt 36
                mov     R3, -(SP)
                mov     S$FWBF(R3), R3		;адрес рабочей области драйвера дисковода (длина 70 байтов).
                call    @#160010			;инициализируем рабочую область драйвера дисковода
                mov     #1600, TSTEP(R3)	;задержка перехода с дорожки на дорожку
                mov     #10., MAXSEC(R3)	;число секторов
                mov     (SP)+, R3
                tst     (SP)+
                mov     S$EXSY(R3), @#4		;адрес функции выхода в ДОС
                .addr   R1, EMT14$
                mov     #14, R0
                iot
                .word 37					;Перехват EMT. вход: R0-номер EMT, R1-абсолютный адрес программы обработки данного EMT.
                .addr   R1, EMT36$
                mov     #36, R0
                iot
                .word 37					;Перехват EMT. вход: R0-номер EMT, R1-абсолютный адрес программы обработки данного EMT.
                jmp     @#1000				;всё, инициализацию провели, теперь исполнение полезной части
;конец одноразового кода
; ───────────────────────────────────────────────────────────────────────────
CMDCOM:         .asciz "COMSPEC=A:COMMAND.COM"
                .blkb   1000
BUFERS:
;буфер внутрисистемной информации и внутрисистемный стек (начиная от COMSPK-2 и выше, размером макс. 156 байтов)
SYSBUF:         .blkb   346

COMSPK:         .asciz "COMSPEC="
                .even
; ───────────────────────────────────────────────────────────────────────────
;                  Функция 0(0).
;Завершение программы пользователя.
;Управление передаётся в DOS, вызывается оболочка имя которой
;записано в переменной COMSPEC
FIOT00:         mov     #1000, SP
                mov     V30NEW, @#30
                mov     S$FCOA(R3), R4	;адрес FCB стандартного устройства вывода
                iot
                .word 20				;Закрыть файл. вход: R4-адрес FCB.
                mov     S$FCIA(R3), R4	;адрес FCB стандартного устройства ввода
                iot
                .word 20				;Закрыть файл. вход: R4-адрес FCB.
                call    SETALD			;инициализация всех буферов приводов
                call    CRCCHK
                cmp     R5, S$FCRC(R3)	;в буфере уже то, что надо?
                beq     2$				;да, сразу идём выполнять
                .addr   R1, COMSPK
                iot
                .word 67				;Получить переменную из области окружения DOS.
										;вход:  R1-адрес имени переменной.
										;выход: R2-указывает на значение переменной в окружении DOS.
										;       R0-указывает на имя переменной в области окружения DOS.
										;       если переменной нет ,то С=1 и R2-указывает на свободную
										;       строку в области окружения DOS.
                bcs     1$
                mov     R2, R1
                clr     R2
                mov     S$TFCB(R3), R4	;адрес буфера FCB под параметры устройства и промежуточных данных.
                iot
                .word 51				;Произвести синтаксический разбор строки.
										;вход: R1-адрес обрабатываемой строки.
										;      R4-адрес формируемого FCB-блока.
										;      R2-тип разбора:если 0,то обычный разбор.
										;         если не 0,то если встретится первым код 0,
										;         FCB  примет вид:_???????????
										;выход: R2-количество символов '?'.
                bcs     1$
                iot
                .word 17				;Открыть файл методом FCB. вход: R4-адрес FCB.
                mov     S$HRAM(R3), R0	;верхний адрес пользовательского ОЗУ.
                mov     F$FLSZ(R4), R5	;размер файла в байтах. (используем младшую часть)
                mov     R5, F$RCSZ(R4)	;размер записи в байтах.
                mov     R5, S$FSZE(R3)	;буфер размера файла
                sub     R5, R0			;получим адрес начала файла
                mov     R0, F$DTAD(R4)	;адрес обмена
                mov     R0, S$FADR(R3)	;буфер адреса файла
                iot
                .word 41				;Прямой доступ,чтение.
										;вход: R4-адрес FCB.
										;выход: R0-сколько байт считано.
										;Поля FCB не изменяются.
                bcs     1$
                iot
                .word 20				;Закрыть файл. вход: R4-адрес FCB.
                bcs     1$
                call    CRCCHK			;считаем CRC
                mov     R5, S$FCRC(R3)	;сохраняем
                iot
                .word 15				;Инициализировать драйвер (контроллер) дисковода.
2$:             jmp     (R0)			;и идём выполнять.

1$:             mov     V30OLD, @#30
AE14$1:         emt     14
                jmp     @#160000

; ═══════════════════════════════════════════════════════════════════════════

CRCCHK:         clr     R5
                mov     S$FSZE(R3), R1	;буфер размера файла в байтах
                beq     2$
                mov     S$FADR(R3), R0	;буфер адреса файла
                beq     2$
                mov     R0, -(SP)
                mov     R1, R2
                asr     R2				;размер в словах
1$:             add     (R0)+, R5		;считаем CRC
                adc     R5
                sob     R2, 1$
                mov     (SP)+, R0
                return

2$:             com     R5				;при неудаче CRC == -1
                return

; ───────────────────────────────────────────────────────────────────────────
;функция выхода в ДОС
OUTDOS:         iot
                .word 0

; ═══════════════════════════════════════════════════════════════════════════

OUTCHR:         emt     16
                return

; ═══════════════════════════════════════════════════════════════════════════

INPCHR:         emt     6
                return

; ═══════════════════════════════════════════════════════════════════════════
;увеличиваем счётчик открытых файлов для заданного устройства
;R4 - FCB, R5 - DPB
INCOPN:         call    FFLUSH			;сохранить текущий сектор.
                bcs     1$
                call    SDRFCB			;задать текущим устройство, которое указано в FCB
                bcs     1$
                tst     P$FLCT(R5)		;счётчик открытых файлов для этого устройства
                bne     2$				;если есть открытые файлы, то просто увеличим счётчик
                call    PARLS$			;Получить параметры устройства, номер которого задан в R0
                bcs     1$
2$:             inc     P$FLCT(R5)		;увеличиваем счётчик
1$:             return

; ═══════════════════════════════════════════════════════════════════════════
;уменьшаем счётчик открытых файлов для заданного устройства
;R4 - FCB, R5 - DPB
DECOPN:         mfps    (R3)			;сохраним флаги PSW
                call    SDRFCB			;задать текущим устройство, которое указано в FCB
                tst     P$FLCT(R5)		;счётчик открытых файлов для этого устройства
                beq     1$				;если открытых файлов нет, то выйдем
                dec     P$FLCT(R5)		;иначе, уменьшим счётчик открытых файлов
1$:             mtps    (R3)			;восстановим флаги PSW
                return

; ═══════════════════════════════════════════════════════════════════════════
;сброс текущего буфера на диск

FFLUSH:         tst     S$CSNW(R3)		;в буфере вообще есть что-то?
                beq     1$				;нету
                mov     S$DNWS(R3), R0	;номер дисковода
                beq     1$				;если не дисковод - то ничего не надо делать
                mov     R1, -(SP)
                mov     S$BIOA(R3), R2	;адрес сохранения
                mov     S$CSNW(R3), R1	;номер сектора
                clr     S$CSNW(R3)
                clr     S$DNWS(R3)
                clr     S$DNSB(R3)		;номер устройства, сектор которого в буфере чтения/записи
                iot
                .word 55				;Абсолютно записать сектор.
										;вход: R0-номер дисковода (1-дисковод "А"...)
										;      R1-номер сектора.
										;      R2-адрес сохранения.
										;Для нормальной работы область параметров данного устройства
										;должна быть заполненной.
                mov     (SP)+, R1
1$:             return

; ═══════════════════════════════════════════════════════════════════════════
;вычисление нужного номера сектора в кластере, который будет обработан
;вход:	R0 - номер кластера
;		R4 - FCB, R5 - DPB
CL2SEC:         mov     R0, F$TMP1(R4)	;сохраняем номер кластера
                sub     #2, R0			;от номера кластера отнимем 2
                clr     R1
                mov     P$CLSZ(R5), R2	;размер кластера в секторах
                call    MULTIP			;R1:R0 * R2
                add     P$ENDS(R5), R0	;конечный сектор каталога
1$:             cmp     S$BIOO(R3), (R5)	;смещение в буфере меньше размера сектора в байтах?
                blo     2$				;да, все в норме
                inc     R0				;иначе увеличим номер сектора
                inc     S$SCLC(R3)		;и счётчик секторов в кластере ?
                sub     (R5), S$BIOO(R3)	;скорректируем смещение, т.к. в размер буфера == сектору, а не кластеру
                br      1$				;и проверим, а теперь влазим? (алгоритм рассчитан на любой размер кластера)

2$:             return

; ═══════════════════════════════════════════════════════════════════════════
;вычисление нужного кластера по номеру записи, а заодно и положение указателя в файле
;R4 - FCB, R5 - DPB
SZ2CLU:         tstb    F$FOPN(R4)		;файл открыт?
                bne     1$				;да
                movb    #20, @#ERRFDD	;нет - ошибка
                clr     R0
LRC1$:          sec
                return

1$:             tstb    F$IDEV(R4)		;идентификатор устройства.
                bmi     LR1$			;если стандартное - выход
                call    SDRFCB
                bcs     LR1$
                mov     #1, S$SCLC(R3)	;установим счётчик, счёт начинается с 1?
                clr     S$BSCC(R3)		;счётчик прочитанных байтов
                mov     F$DTAD(R4), S$MBPT(R3)	;зададим указатель в памяти на обрабатываемые данные
                mov     F$RECN(R4), R0		;номер записи (для функций прямого доступа) мл.
                mov     F$RECN+2(R4), R1	;номер записи (для функций прямого доступа) ст.
                mov     F$RCSZ(R4), R2	;размер записи в байтах.
                call    MULTIP			;R1:R0 * R2
                mov     R0, S$FPTR(R3)		;получим положение указателя в файле, мл.
                mov     R1, S$FPTR+2(R3)		;ст.
                mov     P$CLBZ(R5), R2	;размер кластера в байтах
                mov     R4, -(SP)
                call    DIVIDE			;R1:R0 / R2
                mov     R0, S$BIOO(R3)	;остаток - смещение в кластере
                mov     R4, S$NCLS(R3)	;а это количество обрабатываемых кластеров
                mov     (SP)+, R4
LR1$:           return

; ───────────────────────────────────────────────────────────────────────────
;                  Функция 50(40).
;Записать несколько записей.
;вход:	R4-адрес FCB.
;		R0-количество записей.
;выход:	R0-сколько записей действительно записано.
;Поле FCB "номер записи" модифицируется.

FIOT50:         inc     (R3)			;флаг записи
                mov     R0, -(SP)
                br      12240$
; ───────────────────────────────────────────────────────────────────────────
;                  Функция 47(39).
;Считать несколько записей.
;вход:	R4-адрес FCB.
;		R0-количество записей.
;выход:	R0-сколько записей действительно считано.
;Поле FCB "номер записи" модифицируется.

FIOT47:         clr     (R3)			;флаг чтения
                mov     R0, -(SP)
                call    FFLUSH			;перед чтением сохраним буфер
                bcs     LR1$			;при ошибке - выход !!! тут ошибка со стеком

12240$:         call    SZ2CLU
                bcs     LR1$			;!!! тут ошибка со стеком
                mov     (SP)+, R0
                clr     R1
                mov     F$RCSZ(R4), R2	;размер записи в байтах.
                beq     1$				;если 0 - то ошибка, !!!при переходе ошибка со стеком
                mov     R2, -(SP)
                call    MULTIP			;R1:R0 * R2
                tst     R1				;если результат влазит в 16 бит
                beq     2$				;то норма
1$:             movb    #36, @#ERRFDD	;иначе - ошибка
                br      LRC1$			;!!! ошибка. эта команда не нужна

                tst     (SP)+
                br      LRC1$

2$:             mov     R0, F$RCSZ(R4)	;размер записи в байтах.
                call    DAD$			;подпрограмма реализации прямого доступа к диску
                mfps    (R3)
                mov     (SP)+, R2
                mov     R2, F$RCSZ(R4)
                clr     R1
                mov     R4, -(SP)
                call    DIVIDE			;R1:R0 / R2
                mov     R4, R0
                mov     (SP)+, R4
                add     R0, F$RECN(R4)	;номер записи (для функций прямого доступа)
                adc     F$RECN+2(R4)
                mtps    (R3)
LR2$:           return
; ───────────────────────────────────────────────────────────────────────────
;                  Функция 41(33).
;Прямой доступ,чтение.
;вход: R4-адрес FCB.
;выход: R0-сколько байт считано.
;Поля FCB не изменяются.

FIOT41:         clr     (R3)			;флаг чтения
                br      12372$
; ───────────────────────────────────────────────────────────────────────────
;                  Функция 42(34).
;Прямой доступ,запись.
;вход: R4-адрес FCB.
;выход: R0-сколько байт записано.
;Поля FCB не изменяются.

FIOT42:         inc     (R3)			;флаг записи
                cmpb    (R4), S$DNWS(R3)	;номер дисковода, на который надо сохранить сектор
                beq     1$				;тот же?
12372$:         call    FFLUSH			;нет - сперва сбросим данные на диск
                bcs     LR2$
1$:             call    SZ2CLU
                bcs     LR2$

DAD$:           movb    F$IDEV(R4), R0	;идентификатор устройства.
                bic     #177400, R0		;!!! можно оптимизировать до 3-х слов
                cmpb    R0, #373		;это символьное устройство?
                blo     1$				;нет
                sub     #373, R0		;да - получим его номер
                asl     R0
                add     S$SDJA(R3), R0	;адрес таблицы переходов для символьных устройств.
                jmp     @(R0)+			;перейдём к п/п его обработки

1$:             mov     S$NCLS(R3), R2	;количество обрабатываемых кластеров
                tst     (R3)			;что делаем
                bne     1WRITE			;пишем
				;читаем
1READ:          tst     F$TMP1(R4)		;есть че?
                bne     2$				;че-то есть
                mov     F$STCL(R4), F$TMP1(R4)	;иначе туда поместим начальный кластер
2$:             cmp     R2, F$TMP2(R4)	;количество обрабатываемых кластеров совпадает?
                bne     3$				;нет
                mov     F$TMP1(R4), R0	;а если да, то берём этот кластер
                br      4$

3$:             bhi     5$
                clr     F$TMP1(R4)
                clr     F$TMP2(R4)
                br      1READ

5$:             sub     F$TMP2(R4), R2	;тут количество обрабатываемых кластеров
6$:             mov     F$TMP1(R4), R0	;это начальный кластер
7$:             mov     R2, -(SP)
                call    GETFAT
                mov     (SP)+, R2
                bcs     1ERR$
                inc     F$TMP2(R4)
                tst     R1				;что за кластер, не пустой?
                bne     8$				;нет
                movb    #34, @#ERRFDD	;пустой - ошибка
                mov     #6, R1
                jmp     ERROUT

8$:             cmp     #7770, R1		;последний?
                blo     9$				;да
                mov     R1, R0			;нет - его обработаем
                sob     R2, 7$
4$:             call    CL2SEC
10$:            mov     S$BIOA(R3), R2	;адрес загрузки
                cmpb    S$DNSB(R3), (R4)	;устройство совпадает с тем, откуда читаем/пишем?
                beq     11$				;да
                movb    (R4), S$DNSB(R3)	;нет - запомним новое устройство
                br      12$				;и номер сектора, и прочитаем его в буфер

11$:            cmp     R0, S$CSNB(R3)	;номер сектора совпадает с тем, что в буфере?
                beq     13$				;да, незачем повторно читать тот же самый сектор
12$:            mov     R0, S$CSNB(R3)	;буфер номера сектора
                mov     R0, R1			;номер сектора
                movb    (R4), R0		;номер дисковода
                iot
                .word 54				;Абсолютно считать сектор.
										;вход: R0-номер дисковода (1-дисковод "А"...)
										;	  R1-номер сектора.
										;	  R2-адрес загрузки.
										;Для нормальной работы область параметров данного устройства
										;должна быть заполненной.
                bcs     1ERR$

13$:            mov     R2, R1			;адрес загрузки
                add     (R5), R2		;прибавим размер сектора в байтах
                mov     S$MBPT(R3), R0	;указатель в памяти на обрабатываемые данные
                add     S$BIOO(R3), R1	;адрес начала нужной записи
16$:            movb    (R1)+, (R0)+
                inc     S$BSCC(R3)		;увеличиваем счётчик прочитанных байтов
                add     #1, S$FPTR(R3)	;сдвигаем указатель на одну позицию
                adc     S$FPTR+2(R3)
                cmp     F$FLSZ(R4), S$FPTR(R3)	;за пределы файла ещё не вышли?
                bhis    14$
                cmp     F$FLSZ+2(R4), S$FPTR+2(R3)
                blos    9$				;да - вышли
14$:            cmp     F$RCSZ(R4), S$BSCC(R3)	;уже прочитали сколько надо?
                beq     15$				;да
                cmp     R1, R2
                blo     16$
                mov     R0, S$MBPT(R3)	;сдвигаем указатель в памяти на обрабатываемые данные
                clr     S$BIOO(R3)		;чистим смещение в буфере текущего сектора чтения
                cmp     S$SCLC(R3), P$CLSZ(R5)	;счётчик секторов в кластере достиг размер кластера в секторах
                bhis    17$				;да
                mov     S$CSNB(R3), R0	;а если нет - номер сектора, который находится в буфере чтения
                inc     R0				;следующий сектор
                inc     S$SCLC(R3)		;увеличим счётчик секторов в кластере
                br      10$				;продолжим обработку кластера

17$:            mov     #1, R2			;переходим к следующему кластеру
                mov     R2, S$SCLC(R3)	;инициализируем счётчик секторов в кластере
                br      6$				;и продолжим обработку

15$:            mov     S$BSCC(R3), R0	;счётчик прочитанных байтов
                clc
                return

9$:             movb    #26, @#ERRFDD
                mov     S$BSCC(R3), R0	;сколько байтов прочитали?
                tst     R0				;!!! лишняя команда
                beq     1ERR$			;0 - ошибка 26
                movb    #27, @#ERRFDD	;!0 - ошибка 27
1ERR$:          sec
                return
; ───────────────────────────────────────────────────────────────────────────

1WRITE:         movb    #1, F$TMP3(R4)	;что-то
                tst     F$STCL(R4)		;начальный кластер есть?
                bne     20$				;файл уже есть
                mov     R2, -(SP)
                call    FNDFCL			;кажется, ищем последний свободный кластер
                bcs     2ERR$
                mov     #7777, R1
                call    SETFAT			;записать кластер в фат
                bcs     2ERR$
                mov     (SP)+, R2
                mov     R0, F$STCL(R4)	;теперь начальный кластер такой

20$:            tst     F$TMP1(R4)
                bne     21$
                mov     F$STCL(R4), F$TMP1(R4)
21$:            cmp     R2, F$TMP2(R4)
                bne     22$
                mov     F$TMP1(R4), R0
                br      23$

22$:            bhi     24$
                clr     F$TMP1(R4)
                clr     F$TMP2(R4)
                br      20$

24$:            sub     F$TMP2(R4), R2
25$:            mov     F$TMP1(R4), R0
26$:            mov     R2, -(SP)
                call    GETFAT
                mov     (SP)+, R2
                bcs     27$
                inc     F$TMP2(R4)
                tst     R1
                beq     28$
                cmp     #7770, R1
                bhis    29$
28$:            mov     R2, -(SP)
                mov     R0, -(SP)
                call    FNDFCL
                bcs     30$
                mov     R0, R1
                mov     (SP)+, R0
                bcs     2ERR$			;!!! лишняя команда
                call    SETFAT
                bcs     2ERR$
                mov     R1, -(SP)
                mov     R1, R0
                mov     #7777, R1
                call    SETFAT
                mov     (SP)+, R1
                bcs     2ERR$
                mov     (SP)+, R2
29$:            mov     R1, R0
                sob     R2, 26$
23$:            call    CL2SEC
                br      31$

30$:            tst     (SP)+
2ERR$:          mov     (SP)+, R2
27$:            br      32$

31$:            mov     S$BIOA(R3), R2	;адрес области обмена с диском
                tst     S$BIOO(R3)		;смещение в буфере текущего сектора чтения есть?
                bne     33$				;да, мы не в начале, а уже делали чтение
                mov     F$RCSZ(R4), R1	;нет - инициализируем значения, размер записи в байтах
                sub     S$BSCC(R3), R1	;счётчик прочитанных байтов
                cmp     R1, (R5)		;размер сектора в байтах 
                bhis    34$
33$:            cmpb    S$DNSB(R3), (R4)
                beq     35$
                movb    (R4), S$DNSB(R3)
                br      36$

35$:            cmp     R0, S$CSNB(R3)	;номер сектора, который находится в буфере чтения/записи
                beq     34$
36$:            mov     R0, R1
                mov     R0, -(SP)
                call    FFLUSH
                bcs     37$
                movb    (R4), R0
                mov     R0, S$DNSB(R3)	;номер устройства, сектор которого в буфере чтения/записи
                iot
                .word 54			;Абсолютно считать сектор.
									;вход: R0-номер дисковода (1-дисковод "А"...)
									;	  R1-номер сектора.
									;	  R2-адрес загрузки.
									;Для нормальной работы область параметров данного устройства
									;должна быть заполненной.
37$:            mov     (SP)+, R0
                bcs     32$
34$:            mov     R0, S$CSNB(R3)	;номер сектора, который находится в буфере чтения/записи
                movb    (R4), S$DNWS(R3)	;номер дисковода, на который надо сохранить сектор
                mov     R0, S$CSNW(R3)	;номер сектора в буфере, который надо сохранить
                mov     R2, R1
                add     (R5), R2
                mov     S$MBPT(R3), R0	;указатель в памяти на обрабатываемые данные
                add     S$BIOO(R3), R1	;смещение в буфере текущего сектора чтения/записи
38$:            movb    (R0)+, (R1)+
                inc     S$BSCC(R3)		;счётчик прочитанных/записанных байтов
                add     #1, S$FPTR(R3)	;увеличиваем текущее положение указателя в файле
                adc     S$FPTR+2(R3)
                cmp     F$RCSZ(R4), S$BSCC(R3)	;записали уже сколько надо?
                beq     39$
                cmp     R1, R2
                blo     38$
                mov     R0, S$MBPT(R3)	; изменяем указатель в памяти на обрабатываемые данные
                call    FFLUSH
                bcs     40$
                clr     S$BIOO(R3)		;чистим смещение в буфере текущего сектора чтения/записи
                cmp     S$SCLC(R3), P$CLSZ(R5)	;счётчик секторов в кластере достиг размера кластера в секторах?
                bhis    41$				;да
                mov     S$CSNB(R3), R0	;нет, берём номер сектора, который находится в буфере чтения/записи
                inc     R0				;увеличиваем
                inc     S$SCLC(R3)		;и счётчик тоже увеличиваем
                br      31$

41$:            mov     #1, R2			;переходим к следующему кластеру
                mov     R2, S$SCLC(R3)	;инициализируем счётчик
                br      25$

39$:            cmp     F$FLSZ+2(R4), S$FPTR+2(R3)	;если вышли за конец файла
                blo     42$
                cmp     F$FLSZ(R4), S$FPTR(R3)
                bhi     40$
42$:            mov     S$FPTR(R3), F$FLSZ(R4)	;то скорректируем его длину
                mov     S$FPTR+2(R3), F$FLSZ+2(R4)
40$:            ccc
                br      43$

32$:            cmpb    #22, @#ERRFDD
                bne     44$
                iot
                .word 20					;Закрыть файл.
                iot
                .word 23					;Удалить файл.
                movb    #22, @#ERRFDD
44$:            sec
43$:            mov     S$BSCC(R3), R0
                return
; ───────────────────────────────────────────────────────────────────────────
;                  Функция 20(16).
;Закрыть файл.
;вход: R4-адрес FCB.
FIOT20:         tstb    F$IDEV(R4)		;какой идентификатор устройства?
                bmi     1$				;стандартный
                tstb    F$FOPN(R4)		;дисковод, файл открыт?
                bne     2$				;да
                movb    #20, @#ERRFDD	;нет - ошибка 20
3$:             br      FCRER$

2$:             tstb    F$TMP3(R4)
                beq     1$
                movb    F$DIRP(R4), -(SP)	;положение имени файла в каталоге.
                iot
                .word 21				;Найти первый файл по образцу.
                movb    (SP)+, R0
                bcs     4$
                cmpb    F$DIRP(R4), R0	;это тот файл что нам нужен?
                beq     5$				;да
                movb    #23, @#ERRFDD	;нет - ошибка 23
                br      3$

5$:             call    CHDREC			;модифицируем запись в каталоге
                call    S13752
1$:             clr     F$TMP3(R4)
                clrb    F$FOPN(R4)		;снимем признак открытого файла
4$:             jmp     DECOPN			;уменьшим счётчик открытых файлов и выйдем

; ═══════════════════════════════════════════════════════════════════════════
;что-то непонятное. зачем вхолостую получать фат? чтобы сохранить изменения?

S13752:         call    SDRFCB
                tst     P$TMP3(R5)
                beq     1$
                mov     #2, R0
                call    GETFAT
                bcs     1$
                mov     #600, R0
                call    GETFAT
1$:             return

; ───────────────────────────────────────────────────────────────────────────
;                  Функция 26(22).
;Создать файл.
;(если файл существовал ,то размер его устанавливается
; равным 0).
;вход: R4-адрес FCB.
FIOT26:         call    CLRFCB			;очистка FCB от всего лишнего
                call    GETDVN			;получение номера устройства FCB и делание идентификатора устройства
                bcc     2$
                call    CHKTPL			;проверка на валидность имени
                bcs     FCRER$
                bne     FERR30
                call    INCOPN			;увеличиваем счётчик открытых файлов для заданного устройства
                bcs     FCRER$
                call    DELFLN			;удалить файл
                bcc     1$
                cmpb    #25, @#ERRFDD
                bne     FCRER$
1$:             mov     S$DATE(R3), F$FLDT(R4)	;дата создания файла - текущая дата
                movb    S$DIRP(R3), F$DIRP(R4)	;положение имени файла в каталоге.
                clr     S$CDSN(R3)
                call    CHDREC			;изменить запись в каталоге
                bcs     FCRER$
2$:             incb    F$FOPN(R4)		;установка признака открытия файла
                tst     (PC)+
FCRER$:         sec
                return
; ───────────────────────────────────────────────────────────────────────────
FERR30:         movb    #30, @#ERRFDD
                br      FCRER$
; ───────────────────────────────────────────────────────────────────────────
;                  Функция 17(15).
;Открыть файл методом FCB.
;вход: R4-адрес FCB.
FIOT17:         call    CHKTPL			;проверка на валидность имени
                bcs     FCRER$
                bne     FERR30
                call    CLRFCB			;очистка FCB от всего лишнего
                call    GETDVN			;получение номера устройства FCB и делание идентификатора устройства
                bcc     2$
                call    INCOPN			;увеличиваем счётчик открытых файлов для заданного устройства
                bcs     FCRER$
                iot
                .word 21				;Найти первый файл по образцу.
                bcs     FCRER$
                mov     R4, R5			;FCB
                inc     R5				;пропустим номер устройства
                mov     #13, R0
1$:             movb    (R1)+, (R5)+	;скопируем в FCB имя файла
                sob     R0, 1$
                movb    (R1), F$ATTR(R4)	;атрибуты
                clr     (R5)+			;номер текущего блока
                inc     (R5)+			;размер записи в байтах.
                inc     R1				;!!! лишняя команда, выше можно использовать автоинкремент
                mov     D$SIZE-14(R1), (R5)+	;размер файла в байтах.
                mov     D$SIZE+2-14(R1), (R5)+
                mov     D$DLWR-14(R1), (R5)+	;дата создания файла. 
                mov     D$TLWR-14(R1), (R5)+	;адрес загрузки файла в память
                tst     (R5)+
                mov     D$CLNL-14(R1), (R5)+	;начальный кластер.
                mov     F$FLLD(R4), F$DTAD(R4)
2$:             incb    F$FOPN(R4)
                return

; ═══════════════════════════════════════════════════════════════════════════

;чистим рабочие ячейки FCB. начиная со смещения 14, 30 байтов
CLRFCB:         mov     #14, R0
                mov     R4, R5
                add     R0, R5
1$:             clr     (R5)+
                sob     R0, 1$
                return

; ───────────────────────────────────────────────────────────────────────────
;                  Функция 24(20).
;Последовательное чтение из файла.
;вход: R4-адрес FCB.
;После чтения соответствующие поля FCB модифицируются.
FIOT24:         mov     (PC)+, R5		;флаг: !0 == чтение
; ───────────────────────────────────────────────────────────────────────────
;                  Функция 25(21).
;Последовательная запись в файл.
;вход: R4-адрес FCB.
;После записи соответствующие поля FCB модифицируются.
FIOT25:         clr     R5				;флаг: 0 == запись
                mov     F$RECN(R4), -(SP)	;номер записи (для функций прямого доступа)
                mov     F$RECN+2(R4), -(SP)
                call    FIOT44			;Задать позицию прямого доступа.
                tst     R5
                bne     1READ$
                iot
                .word 42				;Прямой доступ,запись.
                br      2$

1READ$:         iot
                .word 41				;Прямой доступ,чтение.
2$:             mov     (SP)+, F$RECN+2(R4)
                mov     (SP)+, F$RECN(R4)
                bcs     3$
                incb    F$CURR(R4)
                bpl     3$
                clrb    F$CURR(R4)
                inc     F$CBLK(R4)
3$:             return

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 44(36).
;Задать позицию прямого доступа.
;Т.е. перейти от последовательного доступа к прямому доступу.
;Вычисляется номер записи по номеру блока и номеру записи
;при последовательном доступе.
;вход R4-адрес FCB
FIOT44:         mov     F$CBLK(R4), R0	;берём номер текущего блока
                clr     R1
                mov     #200, R2		;и умножаем его на 200, почему в блоке только 200 байтов?
                call    MULTIP			;R1:R0 * R2
                movb    F$CURR(R4), R2	;берём текущую запись
                add     R2, R0
                adc     R1
                mov     R0, F$RECN(R4)
                mov     R1, F$RECN+2(R4)
                return

; ═══════════════════════════════════════════════════════════════════════════
;получение номера устройства в FCB
;вход: R4 - FCB
GETDVN:         call    CHKCUR		;если задано текущее, то делаем из текущего реальное
                movb    (R4), R0	;номер привода в FCB
                add     #100, R0
                movb    R0, F$IDEV(R4)	;делаем из него идентификатор устройства
                mov     R4, R2
                inc     R2
                mov     S$SDNM(R3), R1	;адрес списка имён символьных устройств
                call    STDNUM		;если задано имя стандартного устройства, получим его номер
                bcs     RET1$
                asr     R0
                add     #373, R0
                movb    R0, F$IDEV(R4)
RET1$:          return

; ───────────────────────────────────────────────────────────────────────────
;                  Функция 27(23).
;Переименовать файл.
;вход: R4-адрес модифицированного FCB.
;(Разрешается использовать символ групповой операции '?').

FIOT27:         call    GETDVN			;получение номера устройства FCB и делание идентификатора устройства
                bcc     1ERR$
                call    INCOPN			;увеличиваем счётчик открытых файлов для заданного устройства
                bcs     2ERR$
                clrb    S$TPLF(R3)		;очистим признак, что имя задано шаблоном
                incb    S$RENF(R3)		;устанавливаем флаг переименования
                iot
                .word 21				;Найти первый файл по образцу.
                decb    S$RENF(R3)		;сбрасываем флаг переименования !!!надо бы делать clr 
                bcc     1ERR$
                cmpb    #25, @#ERRFDD
                bne     2ERR$
                cmp     R1, #-1
                beq     1ERR$
                iot
                .word 21				;Найти первый файл по образцу.
                bcs     2ERR$
1$:             movb    (R4), S$DNSB(R3)	;номер устройства сектор которого в буфере
                mov     S$DSTW(R3), S$CDSN(R3)	;номер сектора каталога, который надо обработать -> номер обрабатываемого сектора каталога при удалении файла
                mov     #13, R0
                mov     R4, R2
                add     #15, R2			;подводим указатель к новому имени
2$:             cmpb    #'?, (R2)
                bne     3$
                incb    S$TPLF(R3)		;установим признак, что имя задано шаблоном
                br      4$

3$:             movb    (R2), (R1)
4$:             inc     R2
                inc     R1
                sob     R0, 2$
                tstb    S$TPLF(R3)		;был шаблон?
                beq     3ERR$			;нет
                iot						;а если да - 
                .word 22				;Продолжить поиск файлов.
                bcc     1$
                cmpb    #25, @#ERRFDD
                beq     3ERR$
1ERR$:          movb    #33, @#ERRFDD
2ERR$:          br      4ERR$
; ───────────────────────────────────────────────────────────────────────────
;                  Функция 23(19).
;Удалить файл.
;вход: R4-адрес FCB.
;(файл должен быть закрытым,допускается использовать символ
; групповой операции '?').

FIOT23:         call    GETDVN			;получение номера устройства FCB и делание идентификатора устройства
                bcc     RET1$
                call    CHKTPL			;проверка на валидность имени
                bcs     4ERR$
                tstb    F$FOPN(R4)		;файл открыт?
                beq     1$				;нет
                movb    #37, @#ERRFDD	;да - ошибка
                br      4ERR$

1$:             call    INCOPN			;увеличиваем счётчик открытых файлов для заданного устройства
                bcs     4ERR$
                call    DELFLN			;удалить файл
                bcs     4ERR$
                call    S13752
3ERR$:          mov     S$CDSN(R3), R1	;номер обрабатываемого сектора каталога при удалении файла
                beq     2$
                clr     S$CDSN(R3)		;сектор почистим
                mov     S$SIOA(R3), R2	;адрес загрузки сектора каталога
                movb    (R4), R0
                iot
                .word 55				;Абсолютно записать сектор.
                bcc     2$
4ERR$:          sec
2$:             jmp     DECOPN			;уменьшаем счётчик открытых файлов для заданного устройства
; ───────────────────────────────────────────────────────────────────────────
;                  Функция 21(17).
;Найти первый файл по образцу.
;вход: R4-адрес FCB.

FIOT21:         call    CHKTPL			;проверка на валидность имени
                bcs     LR3$
                call    GETDVN			;получение номера устройства FCB и делание идентификатора устройства
                bcs     1$
LL4$:           mov     #-1, R1
LR3$:           return

1$:             call    INCOPN			;увеличиваем счётчик открытых файлов для заданного устройства
                call    DECOPN			;уменьшаем счётчик открытых файлов для заданного устройства
                bcs     LR3$
                clrb    F$DIRP(R4)		;положение имени файла в каталоге.
                movb    #377, S$DIRP(R3)	;номер записи в каталоге
                clr     S$DSTW(R3)		;номер сектора каталога, который надо обработать
                clr     S$CSNB(R3)		;номер сектора, который находится в буфере чтения/записи
                br      LL3$
; ───────────────────────────────────────────────────────────────────────────
;                  Функция 22(18).
;Продолжить поиск файлов.
;(перед вызовом вызвать функцию 21, FCB не не изменять)
;вход: R4- адрес FCB.

FIOT22:         call    GETDVN			;получение номера устройства FCB и делание идентификатора устройства
                bcc     LL4$
                incb    F$DIRP(R4)		;положение имени файла в каталоге.
LL3$:           mov     R4, R5
                mov     #13, R2
                inc     R5
                tstb    S$RENF(R3)		;функция вызывается из переименования?
                beq     1$				;нет
                add     #14, R5			;да
1$:             mov     S$NMBF(R3), R1	;адрес буфера
2$:             movb    (R5)+, (R1)+	;копируем то что ищем в буфер
                sob     R2, 2$
                tstb    S$IONC(R3)		;флаг, что буфер S$BIOA и S$SIOA не совпадают.
                bne     3$
                mov     S$CSNB(R3), S$DSTW(R3)	;номер сектора, который находится в буфере чтения/записи -> номер сектора каталога, который надо обработать
3$:             call    RC2SEC
                bcs     4$
                cmpb    S$CDDN(R3), (R4)	;номер дисковода, каталог которого в буфере совпадает с тем что обрабатываем?
                bne     5$
                cmp     R1, S$DSTW(R3)	;а сектор тот, что надо?
                beq     6$
5$:             movb    (R4), R0		;если нет. сперва сохраним сектор
                mov     R0, S$CDDN(R3)	;номер дисковода, каталог которого в буфере
                mov     S$SIOA(R3), R2	;адрес загрузки сектора каталога
                mov     R1, -(SP)
                mov     S$CDSN(R3), R1	;номер обрабатываемого сектора каталога 
                tst     R1				;нужна, чтобы при R1==0, бит C гарантированно был 0
                beq     7$				;если номера нет, то и не пишем ничего
                clr     S$CDSN(R3)		;почистим номер
                iot
                .word 55				;Абсолютно записать сектор.
7$:             mov     (SP)+, R1
                bcs     4$
                tstb    S$IONC(R3)		;флаг, что буфер S$BIOA и S$SIOA не совпадают.
                bne     8$
                mov     R1, S$CSNB(R3)	;номер сектора, который находится в буфере чтения/записи
8$:             iot						;прочитаем нужный сектор
                .word 54				;Абсолютно считать сектор.
                bcs     4$
6$:             call    RN2POS
                cmpb    (R0), #37		;если первый символ - 0..37
                blos    9$				;то вроде как нашли конец каталога
                cmpb    #345, (R0)		;если нашли удалённый файл
                bne     10$
                tstb    S$DIRP(R3)		;если номер записи в каталоге (для создаваемых файлов) уже задан,
                bpl     FIOT22			;то продолжим поиск
                movb    F$DIRP(R4), S$DIRP(R3)	;запомним номер записи в каталоге (для создаваемых файлов)
                br      FIOT22			;и продолжим поиск

10$:            mov     R0, R1			;проверим на совпадение найденное
                mov     S$NMBF(R3), R2
                mov     #13, R5
11$:            cmpb    #'?, (R2)
                beq     12$
                cmpb    (R0), (R2)
                bne     FIOT22			;если не совпадает - продолжим поиск
12$:            inc     R2
                inc     R0
                sob     R5, 11$
                mov     R1, R0			;иначе - выйдем с указателем на найденное
4$:             return

9$:             tstb    S$DIRP(R3)		;если номер записи в каталоге (для создаваемых файлов) уже задан,
                bpl     LER4$			;то просто выход с ошибкой
                movb    F$DIRP(R4), S$DIRP(R3)	;запомним номер записи в каталоге (для создаваемых файлов)
LER4$:          movb    #25, @#ERRFDD	;и выйдем с ошибкой
                sec
                return

; ═══════════════════════════════════════════════════════════════════════════
;вычисление номера сектора по номеру записи в каталоге
;вход:	параметры в FCB
;выход:	R1 - нужный номер сектора в каталоге
RC2SEC:         call    SDRFCB
                bcs     1$
                movb    F$DIRP(R4), R0	;положение имени файла в каталоге.
                cmp     R0, P$DIRZ(R5)	;максимальное количество элементов в каталоге
                bhis    LER4$
                clr     R1
                mov     R4, -(SP)
                mov     #20, R2			;количество записей в секторе
                call    DIVIDE			;R1:R0 / R2
                mov     R0, S$BIOO(R3)	;номер записи в секторе
                mov     R4, R1
                mov     (SP)+, R4
                add     P$DIRS(R5), R1	;получим нужный сектор каталога
1$:             return

; ═══════════════════════════════════════════════════════════════════════════
;вычисление положения в секторе по номеру записи в секторе
;выход:	R0 - смещение в буфере
RN2POS:         mov     S$BIOO(R3), R0	;номер записи в секторе
                mov     R1, S$DSTW(R3)	;номер сектора каталога, который надо обработать
                clr     R1
                mov     #40, R2			;размер записи каталога
                call    MULTIP			;R1:R0 * R2
                add     S$SIOA(R3), R0	;положение в текущем буфере записи
LR5$:           return

; ═══════════════════════════════════════════════════════════════════════════
;поиск свободного кластера

FNDFCL:         call    SDRFCB
                bcs     LR5$
                mov     #2, P$TMP4(R5)
;поиск свободного кластера на текущем устройстве
FNFCL$:         mov     R4, -(SP)
6$:             mov     P$TSEC(R5), R0	;возьмём общее число секторов
                sub     P$ENDS(R5), R0	;вычтем конечный сектор каталога, получим число рабочих секторов
                clr     R1
                mov     P$CLSZ(R5), R2	;размер кластера в секторах
                call    DIVIDE			;R1:R0 / R2
                mov     R4, S$CLSZ(R3)	;количество кластеров на диске
                mov     #2, R0
                tst     P$LFCL(R5)		;последний свободный кластер на диске есть?
                beq     1$				;нету
                mov     P$LFCL(R5), R0	;есть
                sub     R0, R4			;
                add     #2, R4			;
                beq     2$
1$:             call    GETFAT
                bcs     3$
                tst     R1
                beq     4$
                inc     R0
                sob     R4, 1$
2$:             dec     P$TMP4(R5)
                beq     5$
                clr     P$LFCL(R5)
                br      6$

5$:             movb    #22, @#ERRFDD
3$:             sec
4$:             mov     R0, P$LFCL(R5)
                mov     (SP)+, R4
                return

; ───────────────────────────────────────────────────────────────────────────
;                  Функция 43(35).
;Получить размер файла в байтах.
;вход: R4- адрес FCB
;выход: R0-младшее слово размера,
;       R1-старшее слово размера.

FIOT43:         iot
                .word 21				;Найти первый файл по образцу.
                mov     D$SIZE(R1), R0
                mov     D$SIZE+2(R1), R1
                return
; ───────────────────────────────────────────────────────────────────────────
;удаление файлов.
DELFLN:         iot
                .word 21				;Найти первый файл по образцу.
                bcs     1$
                movb    F$DIRP(R4), S$DIRP(R3)	;положение имени файла в каталоге.
2$:             bitb    #20, D$ATTR(R1)		;это каталог?
                bne     3$				;да
                movb    #345, (R1)		;пометим запись как удалённую
                mov     S$DSTW(R3), S$CDSN(R3)	;номер сектора каталога, который надо обработать -> номер обрабатываемого сектора каталога при операциях с каталогом
                mov     D$CLNL(R1), R0	;начальный кластер
                beq     3$				;если пусто, то пропустим
4$:             call    GETFAT
                bcs     1$
                tst     R1
                beq     3$
                mov     R1, -(SP)
                clr     R1
                call    SETFAT
                mov     (SP)+, R0
                bcs     1$
                cmp     #7770, R0		;еще не последний кластер?
                bhi     4$				;да
3$:             iot
                .word 22				;Продолжить поиск файлов.
                bcc     2$
                cmpb    @#ERRFDD, #25
1$:             return

; ═══════════════════════════════════════════════════════════════════════════
;получение номера стандартного устройства
;вход:	R1 - адрес таблицы
;		R2 - адрес имени устройства, номер которого получаем
;выход: R0 - номер устройства * 2
STDNUM:         clr     R0
5$:             cmpb    (R1), #'$		;конец?
                beq     1$				;да
                mov     R2, R5
2$:             tstb    (R1)
                beq     3$
                cmpb    (R5)+, (R1)+
                bne     4$				;!!! тут bne 4$ заменить на beq 2$ и убрать br
                br      2$

4$:             inc     R1				;!!!непонятная логика, почему нельзя использовать автоинкремент?
                tstb    -1(R1)
                bne     4$
                tst     (R0)+			;увеличиваем номер на 2
                br      5$

1$:             sec
3$:             return

; ───────────────────────────────────────────────────────────────────────────
;                  Функция 70(56).
;Записать переменную в область окружения DOS.
;вход: R1-адрес строки.

FIOT70:         iot
                .word 67				;Получить переменную из области окружения DOS.
                bcs     1$				;такой переменной нет
                mov     R0, R4			;указывает на имя переменной в области окружения DOS
2$:             tstb    (R4)+			;ищем конец имени
                bne     2$
                mov     R1, -(SP)		;адрес имени переменной
                iot
                .word 40				;Получить адрес области окружения DOS.
                add     R1, R2			;адрес начала области + размер области в байтах = адрес конца области
                mov     R2, (R3)
                sub     R4, R2
3$:             movb    (R4)+, (R0)+
                sob     R2, 3$
                mov     (SP)+, R1		;адрес имени переменной
1$:             mov     R1, R5
                mov     #'=, R0
4$:             cmpb    R0, (R1)+
                beq     5$
                tstb    (R1)
                bne     4$
                movb    #41, @#ERRFDD
                br      6$

5$:             tstb    (R1)
                beq     7$
                mov     R5, R1
                iot
                .word 67				;Получить переменную из области окружения DOS.
8$:             movb    (R1)+, R0
                tstb    R0
                beq     9$
                movb    R0, (R2)+
                cmp     (R3), R2
                bhi     8$
                movb    #40, @#ERRFDD
6$:             sec
                return

9$:             clrb    (R2)+
7$:             return
; ───────────────────────────────────────────────────────────────────────────
;                  Функция 67(55).
;Получить переменную из области окружения DOS.
;вход:  R1-адрес имени переменной.
;выход: R2-указывает на значение переменной в окружении DOS.
;       R0-указывает на имя переменной в области окружения DOS.
;       если переменной нет ,то С=1 и R2-указывает на свободную
;       строку в области окружения DOS.

FIOT67:         mov     #'=, R0
                mov     R1, -(SP)
                iot
                .word 40				;Получить адрес области окружения DOS.
                mov     R1, R5
                mov     R2, (R3)
                add     R5, (R3)
                mov     (SP)+, R1
1$:             tstb    (R5)
                beq     2$
                mov     R1, R2
                mov     R5, R4
3$:             cmpb    (R2)+, (R5)+
                bne     4$
                cmpb    R0, (R2)
                bne     3$
                cmpb    R0, (R5)
                bne     3$
                mov     R4, R0
                inc     R5
5$:             mov     R5, R2
                return

2$:             sec
                br      5$

4$:             cmp     (R3), R5
                blo     5$
                tstb    (R5)+
                bne     4$
                br      1$
; ───────────────────────────────────────────────────────────────────────────
;изменить запись в каталоге
CHDREC:         call    RC2SEC			;найдём сектор, которому принадлежит запись
                bcc     1$
                movb    #24, @#ERRFDD
                sec
                return

1$:             cmpb    S$CDDN(R3), (R4)	;это тот же дисковод, каталог которого уже читали?
                bne     2$
                tstb    S$IONC(R3)		;флаг, что буфер S$BIOA и S$SIOA не совпадают.
                beq     3$
                cmp     R1, S$DSTW(R3)	;номер сектора каталога, с которым работаем
                beq     4$				;если тот же, то сразу на обработку
                br      2$				;если нет - то читать

3$:             cmp     R1, S$CSNB(R3)	;номер сектора тот же?
                beq     4$				;да
                mov     R1, S$CSNB(R3)	;нет, запомним
2$:             mov     S$SIOA(R3), R2	;адрес загрузки
                movb    (R4), R0		;номер дисковода
                iot
                .word 54				;Абсолютно считать сектор.
                bcs     5$

4$:             call    RN2POS			;теперь найдём позицию в секторе нужной нам записи
                mov     R4, R5			;адрес FCB 
                inc     R5				;пропустим номер устройства
                mov     #13, R1
6$:             movb    (R5)+, (R0)+	;скопируем имя файла
                sob     R1, 6$
                movb    F$ATTR(R4), (R0)	;атрибут файла
                add     #13, R0			;пропустим расширенные параметры
				;!!!вот что это за фигня? у нас же есть R4, зачем такую херню городить?
                mov     F$FLLD-14(R5), (R0)+	;адрес загрузки в поле времени обращения
                mov     F$FLDT-14(R5), (R0)+	;дата создания в поле даты обращения
                mov     F$STCL-14(R5), (R0)+	;начальный кластер
                mov     F$FLSZ-14(R5), (R0)+	;размер файла
                mov     F$FLSZ+2-14(R5), (R0)+
                mov     S$SIOA(R3), R2	;адрес загрузки
                mov     S$DSTW(R3), R1	;номер сектора каталога, с которым работаем
                movb    (R4), R0		;и сохраним изменения в каталоге
                iot
                .word 55				;Абсолютно записать сектор.
5$:             return

; ═══════════════════════════════════════════════════════════════════════════
; получить содержимое ячейки ФАТ
;вход:	R0 - номер ячейки
;выход:	R1 - содержимое ячейки
GETFAT:         mov     R4, -(SP)
                mov     R0, -(SP)
                bit     #1, R0
                bne     1$
                call    MUL1.5
                call    FATADR
                bcs     2$
                movb    (R0)+, R1
                bic     #177400, R1
                movb    (R0), R2
                bic     #177760, R2
                swab    R2
                bis     R2, R1
                br      3$

1$:             dec     R0
                call    MUL1.5
                inc     R0
                call    FATADR
                bcs     2$
                movb    (R0)+, R2
                bic     #177400, R2
                movb    (R0), R1
                bic     #177400, R1
                mov     #4, R0
4$:             asl     R1
                asr     R2
                sob     R0, 4$
                bis     R2, R1
3$:             clc
2$:             br      LR6$

; ═══════════════════════════════════════════════════════════════════════════
; задать содержимое ячейки ФАТ
;вход:	R0 - номер ячейки
;		R1 - содержимое ячейки
SETFAT:         mov     R4, -(SP)
                mov     R0, -(SP)
                mov     R1, -(SP)
                bit     #1, R0
                bne     1$
                call    MUL1.5
                call    FATADR
                bcs     2$
                mov     (SP), R1
                mov     R1, R2
                bic     #177400, R2
                movb    R2, (R0)+
                swab    R1
                bic     #177760, R1
                bicb    #17, (R0)
                bisb    R1, (R0)
                br      3$

1$:             dec     R0
                call    MUL1.5
                inc     R0
                call    FATADR
                bcs     2$
                mov     (SP), R1
                mov     R1, R2
                bic     #177760, R1
                bic     #170017, R2
                mov     #4, R4
4$:             asr     R2
                asl     R1
                sob     R4, 4$
                bicb    #360, (R0)
                bisb    R1, (R0)+
                movb    R2, (R0)+
3$:             mov     P$TMP2(R5), P$TMP3(R5)	;зададим признак изменения в ФАТ
2$:             mov     (SP)+, R1
LR6$:           mov     (SP)+, R0
                mov     (SP)+, R4
                return

; ═══════════════════════════════════════════════════════════════════════════
;умножение на 1.5

MUL1.5:         mov     R0, -(SP)
                asl     R0
                add     (SP)+, R0
                asr     R0
                return

; ───────────────────────────────────────────────────────────────────────────
;вход:	R0 - смещение в ФАТ
;выход:	R0 - адрес ячейки ФАТ в буфере
FATADR:         clr     R1
                mov     (R5), R2		;размер сектора в байтах
                call    DIVIDE			;R1:R0 / R2
                inc     R4				;результат деления, номер сектора фат?
                mov     R0, -(SP)
                mov     P$AFAT(R5), R2	;адрес FAT в памяти
                cmp     R4, P$TMP2(R5)	;этот сектор уже в буфере?
                beq     1$				;да
                mov     R4, P$TMP2(R5)
                tst     P$TMP3(R5)		;изменения были
                beq     2$				;нет
                mov     P$TMP3(R5), R1	;иначе, тут номер сектора фат
                mov     P$NDRV(R5), R0	;номер устройства
                iot						;запишем первую копию фат
                .word 55				;Абсолютно записать сектор.
                bcs     5$
                cmp     #2, P$NFAT(R5)	;если копий две
                bne     3$				;не, не две
                add     P$FATZ(R5), R1	;размер FAT в секторах
                iot						;запишем вторую копию фат
                .word 55				;Абсолютно записать сектор.
                bcs     5$
                sub     P$FATZ(R5), R1
3$:             inc     R1				;следующий сектор первой копии
                cmp     R1, P$FATZ(R5)	;размер FAT в секторах
                bhi     4$
                iot						;прочитаем сектор
                .word 54				;Абсолютно считать сектор.
                bcs     5$
                mov     R2, R4			;адрес FAT в памяти
                add     (R5), R4		;прибавим размер сектора
                mov     (R4), (R2)		;сделаем непонятную модификацию
                iot						;и сохраним сектор
                .word 55				;Абсолютно записать сектор.
                bcs     5$
                cmp     #2, P$NFAT(R5)	;если копий две
                bne     4$				;не, не две
                add     P$FATZ(R5), R1	;размер FAT в секторах
                iot						;запишем вторую копию фат
                .word 55				;Абсолютно записать сектор.
                bcs     5$
4$:             clr     P$TMP3(R5)		;сбросим флаг изменений
2$:             mov     P$TMP2(R5), R1	;нужный сектор
                mov     P$NDRV(R5), R0	;номер устройства
                inc     R1				;сперва прочитаем следующий сектор
                iot
                .word 54				;Абсолютно считать сектор.
                bcs     5$
                mov     R2, R4			;адрес FAT в памяти
                add     (R5), R4		;прибавим размер сектора
                mov     (R2), (R4)		;и сохраним первое слово за концом буфера.
				;теперь понятно, что за непонятная модификация была выше, это восстановление
				;первого слова второго сектора, видимо оно портится
                dec     R1				;теперь прочитаем нужный сектор
                iot
                .word 54				;Абсолютно считать сектор.
                bcs     5$
1$:             mov     (SP)+, R0
                add     R2, R0			;получаем адрес ячейки ФАТ
                return

5$:             mov     (SP)+, R0
                return

; ═══════════════════════════════════════════════════════════════════════════
;умножение
;вход:	R1:R0 - множимое
;		R2 - множитель
;выход:	R1:R0 - результат

MULTIP:         mov     R5, -(SP)
                mov     R3, -(SP)
                mov     R4, -(SP)
                mov     #16., R5
                clr     R3
                clr     R4
2$:             asr     R2
                bcc     1$
                add     R0, R3
                adc     R4
                add     R1, R4
1$:             asl     R0
                rol     R1
                sob     R5, 2$
                mov     R4, R1
                mov     R3, R0
                mov     (SP)+, R4
                mov     (SP)+, R3
                mov     (SP)+, R5
                return

; ═══════════════════════════════════════════════════════════════════════════
;деление
;вход:	R1:R0 - делимое
;		R2 - делитель
;выход:	R4 - результат
;		R0 - остаток от деления
DIVIDE:         tst     R2
                beq     1$
                mov     R5, -(SP)
                clr     R5
                clr     R4
2$:             inc     R5
                asl     R2
                bcc     2$
3$:             ror     R2
4$:             inc     R4
                sub     R2, R0
                sbc     R1
                bcc     4$
                add     R2, R0
                adc     R1
                dec     R4
                asl     R4
                sob     R5, 3$
                ror     R4
                mov     (SP)+, R5
                return

1$:             movb    #31, @#ERRFDD
                mov     #12, R1
                jmp     ERROUT

; ═══════════════════════════════════════════════════════════════════════════
;вход:	R4 - адрес FCB
;выход:	R5 - адрес параметров устройства
SDRFCB:         movb    (R4), R0		;номер дисковода, причем 0 (текущий) быть не может.

; ═══════════════════════════════════════════════════════════════════════════
;вход:	R0 - номер устройства прямого доступа
;выход:	R5 - адрес параметров устройства
SETDRV:         tst     R0				;номер == 0?
                beq     FERR21			;да - ошибка
                cmpb    R0, S$DRVN(R3)	;номер больше количества устройств прямого доступа в системе?
                bhi     FERR21			;да ошибка
                mov     R0, R1
                dec     R1
                asl     R1
                mov     S$DBLA(R3), R5	;адрес списка дисковых блоков.(адреса абсолютные)
                add     R1, R5
                mov     (R5), R5		;получим адрес параметров устройства нужного нам устройства
                mov     R0, P$NDRV(R5)	;номер устройства
                return

FERR21:         movb    #21, @#ERRFDD
                sec
                return

; ═══════════════════════════════════════════════════════════════════════════
;проверка на текущее устройство,
;и если да - получение номера текущего устройства
CHKCUR:         tstb    (R4)			;какое устройство в FCB, текущее?
                bne     1$				;нет, задано конкретное
                movb    S$CRDN(R3), (R4)	;да - тогда возьмём текущее из системной области
                incb    (R4)			;преобразуем в номер привода
1$:             cmpb    S$DRVN(R3), (R4)	;если получилось больше максимального, то ошибка, нет такого устройства
                blo     FERR21
                return

; ───────────────────────────────────────────────────────────────────────────
;подпр.чтения секторов на логическом уровне.(на уровне DOS)
SECTRD:         dec     R0				;получим из
                mov     R0, R4			;номера устройства
                asl     R4
                add     S$RSFA(R3), R4	;адрес таблицы подпр.чтения сектора с устройства
                cmpb    #1, S$FLPN(R3)	;количество дисководов в системе
                blo     1$				;больше 1
                clr     R0				;меньше 2
1$:             mov     S$FWBF(R3), R3	;адрес рабочей области драйвера дисковода
                movb    R0, UNIT(R3)
                add     R3, R0
                add     #FLGTAB, R0
                mov     R0, FLGPTR(R3)
                movb    P$PSET(R5), (R0)	;биты настройки контроллера.
                mov     R1, R0
                mov     (R5), R1		;размер сектора в байтах
                bne     2$				;если задан, то берём его
                mov     #1000, R1		;иначе - значение по умолчанию
2$:             asr     R1				;делаем размер в словах
                tst     P$OPTP(R5)		;Тип операции :0-чтение,иначе запись
                beq     3$
                neg     R1
3$:             mov     P$NSEC(R5), R5	;число секторов на дорожке
                mov     R1, WCNT(R3)	;количество слов для пересылки
                mov     R2, ADDR(R3)	;адрес начала массива данных в ОЗУ (обязательно чётный)
                mov     #10, R1
                swab    R5				; делим ст. байт R0 на ст. байт R5
4$:             cmp     R5, R0
                bhi     5$
                sub     R5, R0
                sec
5$:             rol     R0				; Частное накапливается в мл. байте R0
                sob     R1, 4$
                movb    R0, R1			; В мл. байте номер дорожки, сохраним его
                clrb    R0
                swab    R0				; Получили остаток от деления
                swab    R5
                inc     R0				; Номер сектора на единичку больше
                clr     R2				; Пока мы на нижней стороне
                cmp     R0, R5			; Этот сектор за пределами дорожки?
                ble     6$				; Нет - полный порядок
                inc     R2				; Да - значит он на другой стороне
                sub     R5, R0			;    и номер у него другой
6$:             bitb    #2, @FLGPTR(R3)	; Диск односторонний?
                beq     7$				; Нет - оставим все как есть
                asr     R2				; Да - сторона всегда 0,
                rolb    R1				;    а дорожка уже другая
7$:             movb    R1, TRK(R3)		; Запишем результаты: дорожка,
                movb    R0, SECTOR(R3)	;    сектор,
                movb    R2, SIDE(R3)	;    сторона
                jmp     @(R4)+			;и идем выполнять стандартную п/п обработки секторов
; ───────────────────────────────────────────────────────────────────────────
;Получить параметры устройства, номер которого задан в R0
PARLST:         call    SETDRV
                bcs     6$
PARLS$:         mov     R4, -(SP)
				;чистим переменные
                clr     S$CSNB(R3)		;номер сектора, который находится в буфере чтения/записи
                clr     P$LFCL(R5)		;последний свободный кластер на диске
                clr     P$TMP2(R5)		;Используется DOS
                clr     S$DNSB(R3)		;номер устройства, сектор которого в буфере чтения/записи
                mov     S$BIOA(R3), R2	;адрес области обмена с диском
                mov     #10., P$NSEC(R5)	;число секторов на дорожке
                clr     R1				;номер сектора.
                iot						;странно,что номер с нуля начинается, скорее всего это номер блока
                .word 54				;Абсолютно считать сектор.
                bcs     5$
				;прочли нулевой блок, там у нас  BPB
                mov     R5, R4
                add     #13, R2			;получим Число байт в секторе
                movb    (R2)+, R0
                movb    (R2)+, R1
                swab    R1
                bis     R1, R0			;вот оно
                bmi     1$
                mov     R0, (R4)+		;запомним в DPB размер сектора в байтах
                movb    (R2)+, R0		;Количество секторов в кластере
                mov     R0, (R4)+		;размер кластера в секторах 
                tst     (R2)+			;пропустим Число секторов в загрузчике
                movb    (R2)+, R0		;Число фат
                mov     R0, (R4)+		;количество копий FAT 
                movb    (R2)+, R0		;Максимальное число файлов в корневом каталоге
                movb    (R2)+, R1
                bis     R1, R0			;!!!какая-то чушь. забыли сделать swab
                bic     #177400, R0		;в результате тут какая-то херня
                mov     R0, (R4)+		;и ее в максимальное количество элементов в каталоге
                movb    (R2)+, -(SP)	;Общее число блоков на диске
                bic     #177400, (SP)
                movb    (R2)+, R0
                swab    R0
                bis     (SP)+, R0
                mov     R0, (R4)+		;общее число секторов
                movb    (R2)+, R0		;Media descriptor
                bic     #177400, R0
                mov     R0, (R4)+		;идентификатор формата
                cmp     #360, R0
                blos    2$
1$:             movb    #17, @#ERRFDD
                mov     #2, R1
                call    ERROUT
                sec
                br      5$

2$:             mov     (R2)+, (R4)+	;Число секторов в одной фат -> размер FAT в секторах
                mov     (R2)+, (R4)+	;Число секторов на дорожке -> число секторов на дорожке 
                mov     (R2)+, (R4)+	;Число головок -> количество сторон диска
                mov     P$NFAT(R5), R0
                clr     R1
                mov     P$FATZ(R5), R2
                call    MULTIP			;R1:R0 * R2
                inc     R0				;найдём начало каталога, предполагаем,что загрузчик всегда 1 сектор
                mov     R0, P$DIRS(R5)
                mov     P$DIRZ(R5), R0
                clr     R1
                mov     #20, R2
                call    DIVIDE			;R1:R0 / R2
                mov     R4, P$ENDS(R5)	;количество секторов, занимаемых каталогом
                add     P$DIRS(R5), P$ENDS(R5)	;а теперь - конечный сектор каталога
                mov     (R5), R0		;размер сектора в байтах 
                clr     R1
                mov     P$CLSZ(R5), R2	;размер кластера в секторах
                call    MULTIP			;R1:R0 * R2
                mov     R0, P$CLBZ(R5)	;размер кластера в байтах
                clr     R4
                cmp     #2, P$NSID(R5)	;у диска 2 стороны?
                beq     3$
                bisb    #2, R4
3$:             cmp     P$FMTI(R5), #373
                blos    4$
                bit     #1, P$PDRV(R5)
                bne     4$
                bisb    #1, R4
4$:             mov     R4, P$PSET(R5)
                ccc
5$:             mov     (SP)+, R4
6$:             return
; ───────────────────────────────────────────────────────────────────────────
;                  Функция 5(5).
;Вывод символа на принтер.
;вход: R0-код символа.(стробир.бит на БК0010-400, на остальных
;- 40000)
FIOT05:         mov     S$PPAD(R3), R5	;адрес параллельного порта
                mov     S$STBP(R3), R4	;значение стробирующего бита для принтера
1$:             bit     R4, (R5)
                beq     1$
                bis     R4, R0
                mov     R0, (R5)
2$:             bit     R4, (R5)
                bne     2$
                bic     R4, R0
                clr     (R5)
                return
; ───────────────────────────────────────────────────────────────────────────
;зарезервированная функция, выдает ошибку №011
FIOT13:         mov     #11, R1

; ═══════════════════════════════════════════════════════════════════════════
;вывод сообщения об ошибке, инициализация драйвера дисковода, инициализация всех буферов приводов
;вход: R0 - номер сообщения
ERROUT:         mov     S$ERMA(R3), R2	;адрес таблицы символьных сообщений об ошибке, строки разделяются 0
3$:             dec     R1
                ble     1$
2$:             tstb    (R2)+
                bne     2$
                br      3$

1$:             movb    (R2)+, R0
                beq     4$
                call    OUTCHR
                br      1$

4$:             call    FIOT15			;Инициализировать драйвер (контроллер) дисковода.

; ═══════════════════════════════════════════════════════════════════════════
;инициализация всех буферов приводов
SETALD:         movb    S$DRVN(R3), R0
2$:             call    SETDRV
                clr     P$FLCT(R5)		;счётчик открытых файлов для этого устройства
                sob     R0, 2$
                return

; ───────────────────────────────────────────────────────────────────────────
;                  Функция 56.
;Обработка критических ошибок.
;выход:R0-символ:
;               I-игнорировать,
;               R-повторить,
;               А-отменить.

FIOT56:         mov     R1, -(SP)
                mov     R2, -(SP)
                beq     1$
                .addr   R0, CRTCLE
3$:             cmpb    S$ER52(R3), (R0)	;номер прошлой ошибки в ячейке 52
                beq     2$
                tstb    (R0)
                beq     1$
                tst     (R0)+
                br      3$

2$:             movb    1(R0), R1
                call    ERROUT
                mov     #10, R1
                call    ERROUT
4$:             call    INPCHR
                bic     #177240, R0
                cmp     #'R, R0
                beq     5$
                cmp     #'I, R0
                beq     5$
                cmp     #'A, R0
                bne     4$
5$:             call    OUTCHR
                mov     R0, -(SP)
                mov     #7, R1
                call    ERROUT
                mov     (SP)+, R0
1$:             mov     (SP)+, R2
                mov     (SP)+, R1
                return
; ───────────────────────────────────────────────────────────────────────────
;функция синтаксического разбора строки
L20462:         cmpb    #40, 2(R1)
                blo     1$
                inc     R1
                movb    (R1)+, R0
                sub     #'0, R0
                mov     R1, -(SP)
                mov     S$CMLA(R3), R1	;адрес командной строки
                mov     R1, R2
                add     S$CMLS(R3), R2	;длина командной строки
2$:             tstb    (R1)
                beq     3$
                tst     R0
                beq     4$
                cmpb    #40, (R1)+
                bne     5$
6$:             cmpb    #40, (R1)
                bne     7$
                inc     R1
                br      6$

7$:             dec     R0
                br      2$

5$:             cmp     R2, R1
                bhi     2$
3$:             movb    #35, @#ERRFDD
                sec
                br      8$

4$:             call    S20612
8$:             mov     (SP)+, R1
                return

1$:             jmp     FERR30
; ───────────────────────────────────────────────────────────────────────────
;                  Функция 51(41).
;Произвести синтаксический разбор строки.
;вход: R1-адрес обрабатываемой строки.
;      R4-адрес формируемого FCB-блока.
;      R2-тип разбора:если 0,то обычный разбор.
;         если не 0,то если встретится первым код 0,
;         FCB  примет вид:_???????????
;выход: R2-количество символов '?'.

FIOT51:         cmpb    #'%, (R1)		;обработка конструкций
                beq     L20462			;типа %цифра

; ═══════════════════════════════════════════════════════════════════════════

S20612:         clr     R0
                mov     R4, -(SP)
                cmpb    1(R1), #':		;если это имя привода
                bne     1$
                movb    (R1)+, R0		;то получим
                sub     #100, R0		;его номер
                inc     R1
1$:             movb    R0, (R4)+
                tst     R2
                beq     2$
                cmpb    #40, (R1)
                beq     3$
                tstb    (R1)
                bne     2$
3$:             mov     #13, R0
                mov     #'?, R2
                call    S21046
                br      4$

2$:             mov     #10, R0
                mov     #2, R5
11$:            cmpb    (R1), #'.
                bne     5$
                mov     #40, R2
                call    S21046
                inc     R1
                br      6$

5$:             cmpb    #'*, (R1)
                bne     7$
                mov     #'?, R2
                call    S21046
                inc     R1
                br      8$

7$:             cmpb    (R1), #40
                bhi     9$
                mov     #40, R2
                call    S21046
                br      6$

9$:             movb    (R1)+, R2
                cmpb    R2, #173
                bhi     10$
                cmpb    R2, #140
                blo     10$
                bicb    #240, R2
10$:            movb    R2, (R4)+
                sob     R0, 11$
8$:             cmpb    (R1), #'.
                bne     6$
                inc     R1
6$:             mov     #3, R0
                sob     R5, 5$
4$:             mov     (SP)+, R4
                call    CHKTPL
                mov     (R3), R2
                return

; ═══════════════════════════════════════════════════════════════════════════

S21046:         movb    R2, (R4)+
                sob     R0, S21046
                return

; ═══════════════════════════════════════════════════════════════════════════
;проверка на валидность имени файла

CHKTPL:         call    CHKCUR
                bcs     1$
                clr     (R3)
                mov     R4, R5
                inc     R5
                tstb    S$RENF(R3)		;мы в режиме переименования?
                beq     2$
                add     #14, R5			;да обрабатываем второе имя
2$:             mov     #13, R0
                cmpb    (R5), #40
                blos    3$
4$:             movb    (R5)+, R2
                cmp     #'?, R2
                bne     5$
                inc     (R3)
5$:             cmpb    R2, #40
                beq     6$
                cmpb    R2, #60
                blo     3$
                cmp     R2, #73
                blo     6$
                cmp     R2, #177
                blo     6$
                cmp     R2, #277
                blo     3$
6$:             sob     R0, 4$
                tst     (R3)
1$:             return

3$:             jmp     FERR30

; ───────────────────────────────────────────────────────────────────────────
;                  Функция 64.
;Получить доступ к командной строке.
;Вых: R1- адрес командной строки.
;     R2- размер командной строки в байтах.

FIOT64:         mov     S$CMLA(R3), R1
                mov     S$CMLS(R3), R2
                return
; ───────────────────────────────────────────────────────────────────────────
;                  Функция 6(6).
;Буферизованный ввод с клавиатуры с возможностью редактирования.
;вход: R1-адрес буфера,
;      R2-размер буфера в байтах.
FIOT06:         mov     S$FCIA(R3), R4	;адрес FCB стандартного устройства ввода
                movb    F$IDEV(R4), R4	;номер дисковода: 0-текущий,1-'А',2-'В'...
                sub     #377, R4
                movb    R4, S$INKF(R3)	;устанавливаем флаг, что будем вводить с устройства ввода

INKEY:          clr     R4
                mov     R1, R5			;адрес буфера
I06$1:          tstb    S$INKF(R3)		;откуда вводим?
                beq     1$				;с клавиатуры
                iot						;с устройства ввода (как правило это клавиатура, но не обязательно)
                .word 1					;Ввод символа со стандартного устройства ввода. выход: R0-код символа.
                bcs     I06$2
                br      2$

1$:             call    INPCHR
2$:             cmp     #6, R0			;код 6
                bne     3$
                comb    S$PRNF(R3)		;вкл./выкл. вывод на принтер
                br      I06$1

3$:             mov     PC, -(SP)
                add     (PC)+, (SP)
				.word	@I06$1+2
                cmp     #12, R0
                beq     4$
                cmp     #15, R0
                beq     4$
                cmp     #10, R0
                beq     DELSYM
                sub     #30, R0
                beq     DELSYM
                dec     R0
                beq     OUTSM$
                dec     R0
                beq     6$
                dec     R0
                beq     7$
                add     #33, R0
                movb    R0, (R5)+
                inc     R4
                call    CTSOUT
                cmp     R4, R2
                blo     I06$2

4$:             clrb    (R5)			;перевод строки
                tst     (SP)+
                tstb    S$INKF(R3)		;откуда вводим?
                beq     5$				;с клавиатуры
                iot						;с устройства ввода
                .word 1					;Ввод символа со стандартного устройства ввода. выход: R0-код символа.
5$:             mov     #5015, R0
                iot
                .word 2					;Вывод символа на стандартное устройство вывода. вход: R0-код символа.
                swab    R0
                br      STDOUT

6$:             call    DELSYM
                tst     R4
                bne     6$
                return

7$:             call    OUTSM$
                bne     7$
I06$3:          return

;удаление последнего символа из буфера
DELSYM:         tst     R4
                beq     I06$3
                dec     R4
                call    DELSM$
                movb    -(R5), R0
                cmp     R0, #30
                bhis    I06$3

;удаление последнего символа на экране
DELSM$:         mov     #10, R0
                call    STDOUT
                mov     #40, R0
                call    STDOUT
                mov     #10, R0
                br      STDOUT

;вывод введенного символа на экран
OUTSM$:         movb    (R5), R0
                beq     I06$2
                inc     R5
                inc     R4
;вывод символа, если управляющий - то в виде ^символ
CTSOUT:         cmp     R0, #30
                bhis    STDOUT
                mov     R0, -(SP)
                mov     #'^, R0
                iot
                .word 2					;Вывод символа на стандартное устройство вывода. вход: R0-код символа.
                mov     (SP)+, R0
                add     #100, R0
;стандартный вывод символа на стандартное устройство
STDOUT:         iot
                .word 2					;Вывод символа на стандартное устройство вывода. вход: R0-код символа.
I06$2:          return

; ───────────────────────────────────────────────────────────────────────────
;обработка устройства PRN
PRNPRC:         mov     F$DTAD(R4), R1	;адрес обмена
                mov     F$RCSZ(R4), R2	;размер записи в байтах.
                tst     (R3)
                beq     1$
2$:             movb    (R1)+, R0
                iot
                .word 5					;Вывод символа на принтер.
                sob     R2, 2$
1$:             br      NULPRC
; ───────────────────────────────────────────────────────────────────────────
;обработка устройства CON
CONPRC:         mov     F$DTAD(R4), R1	;адрес обмена
                mov     F$RCSZ(R4), R2	;размер записи в байтах.
                mov     R4, -(SP)
                tst     (R3)
                bne     1$
                dec     R2
2$:             clrb    S$INKF(R3)		;устанавливаем флаг, что будем вводить с клавиатуры
                call    INKEY
                mov     R1, R5
                dec     R5
                mov     R2, R0
                add     R1, R0
3$:             inc     R5
                cmp     R5, R0
                bhis    4$
                movb    (R5), R4
                tstb    R4
                beq     5$
                dec     R2
                cmpb    #13, R4
                bne     3$
                clrb    (R5)
                tst     (R2)+
4$:             mov     (SP)+, R4
                mov     F$RCSZ(R4), R0
                sub     R2, R0
                return

5$:             movb    #15, (R5)+
                movb    #12, (R5)+
                sub     #2, R2
                mov     R5, R1
                br      2$

1$:             clr     R5
6$:             movb    (R1)+, R0
                call    OUTCHR
                sob     R2, 6$
                mov     (SP)+, R4
; ───────────────────────────────────────────────────────────────────────────
;обработка устройства NUL
NULPRC:         mov     F$RCSZ(R4), R0	;размер записи в байтах.
                ccc
                return
; ───────────────────────────────────────────────────────────────────────────
;                  Функция 1(1).
;Ввод символа со стандартного устройства ввода
;(по умолчанию - консоль).
;выход: R0-код символа.
FIOT01:         mov     S$FCIA(R3), R4	;получим адрес FCB
                mov     R1, -(SP)
                mov     R2, -(SP)
                mov     #1, F$RCSZ(R4)	;размер записи в байтах
                mov     S$BINA(R3), F$DTAD(R4)	;адрес буфера ввода
                iot
                .word 24				;Последовательное чтение из файла. вход: R4-адрес FCB.
										;После чтения соответствующие поля FCB модифицируются.
                mov     (SP)+, R2
                mov     (SP)+, R1
                movb    @S$BINA(R3), R0	;адрес буфера устройства ввода, длиной 2 байта - то, что прочитали
                return
; ───────────────────────────────────────────────────────────────────────────
;                  Функция 2(2).
;Вывод символа на стандартное устройство вывода
;(по умолчанию - консоль).
;вход: R0-код символа.
FIOT02:         mov     S$FCOA(R3), R4	;получим адрес FCB
                mov     R1, -(SP)
                mov     R2, -(SP)
                mov     R0, -(SP)
                mov     #1, F$RCSZ(R4)	;размер записи в байтах
                mov     S$BOUA(R3), F$DTAD(R4)	;адрес буфера вывода
                movb    R0, @S$BOUA(R3)	;адрес буфера устройства вывода, длиной 2 байта
                tstb    S$PRNF(R3)		;дублировать вывод на принтер?
                beq     1$				;нет
                iot						;да
                .word 5					;Вывод символа на принтер. вход: R0-код символа.
1$:             iot
                .word 25				;Последовательная запись в файл. вход: R4-адрес FCB.
										;После записи соответствующие поля FCB модифицируются.
                mov     (SP)+, R0
                mov     (SP)+, R2
                mov     (SP)+, R1
                return
; ───────────────────────────────────────────────────────────────────────────
;                  Функция 11(9).
;Вывод строки символов на устройство вывода
;(по умолчанию - консоль).
;вход: R1-адрес строки символов.
;(Строка должна оканчиваться нулевым байтом)
FIOT11:         mov     R1, R5
1$:             movb    (R5)+, R0		;берем очередной символ
                beq     2$				;если конец строки, то завершим вывод
                iot
                .word 2					;Вывод символа на стандартное устройство вывода вход: R0-код символа.
                bcc     1$				;если ошибок не произошло, то продолжим
2$:             return
; ───────────────────────────────────────────────────────────────────────────
;                  Функция 14(12).
;Очистить буфер командной строки. ?!!! что-то не нравится мне это, не похоже на очистку буфера
FIOT14:         mov     R0, W22120
                emt     4				;БК10,БК11 - инициализация векторов клавиатуры, БК11М - управление обработкой EMT
                iot
W22120:         .word 0
                return

; ═══════════════════════════════════════════════════════════════════════════
;                  Функция 15(13).
;Инициализировать драйвер (контроллер) дисковода.
FIOT15:         clr     @S$FWBF(R3)		;адрес рабочей области драйвера дисковода
                clr     @#177130
                return

; ───────────────────────────────────────────────────────────────────────────
;                  Функция 16(14).
;Задать текущий дисковод.
;вход:  R0-номер дисковода.
;        0-дисковод "А" и т. д.
FIOT16:         inc     R0
                call    SETDRV
                bcs     1$
                dec     R0
                movb    R0, S$CRDN(R3)	;номер текущего устройства прямого доступа (дисковода).
1$:             return
; ───────────────────────────────────────────────────────────────────────────
;                  Функция 31(25).
;Получение номера текущего устройства прямого доступа (дисковода).
;выход: R0 - номер дисковода.
FIOT31:         movb    S$CRDN(R3), R0	;номер текущего устройства прямого доступа (дисковода).
                return
; ───────────────────────────────────────────────────────────────────────────
;                  Функция 52(42).
;Получить текущую дату.
;выход: R0 - дата
FIOT52:         mov     S$DATE(R3), R0	;текущая дата
                return
; ───────────────────────────────────────────────────────────────────────────
;                  Функция 53(43).
;Установить дату.
;вход: R0 - дата
FIOT53:         mov     R0, S$DATE(R3)	;текущая дата
                return
; ───────────────────────────────────────────────────────────────────────────
;                  Функция 33(27).
;Получить параметры текущего устройства (кроме символьных).
;выход: R2-адрес списка параметров.
;(изменять данные запрещается).
FIOT33:         iot
                .word 31				;Получение номера текущего устройства прямого доступа
                inc     R0
; ───────────────────────────────────────────────────────────────────────────
;                  Функция 34(28).
;Аналогична функции 33(27),но для заданного устройства.
;вход: R0-номер устройства (1-дисковод "А"...)
;выход:  R2-адрес списка параметров.
FIOT34:         bcs     1$    ; !!! ошибка, метка должна указывать на call
                call    PARLST
                mov     R5, R2
1$:             return
; ───────────────────────────────────────────────────────────────────────────
;                  Функция 55(45).
;Абсолютно записать сектор.
;вход: R0-номер дисковода (1-дисковод "А"...)
;      R1-номер сектора.
;      R2-адрес загрузки.
;Для нормальной работы область параметров данного устройства
;должна быть заполненой.

FIOT55:         mov     (PC)+, R4	;флаг - запись
; ───────────────────────────────────────────────────────────────────────────
;                  Функция 54(44).
;Абсолютно считать сектор.
;вход: R0-номер дисковода (1-дисковод "А"...)
;      R1-номер сектора.
;      R2-адрес загрузки.
;Для нормальной работы область параметров данного устройства
;должна быть заполненной.

FIOT54:         clr     R4			;флаг - чтение
                mov     R0, -(SP)
                cmpb    #1, S$FLPN(R3)
                blo     1$
                cmpb    R0, S$ONED(R3)
                beq     1$
                mov     R2, -(SP)	;если диск не тот, то попросим вставить тот диск
                mov     R1, -(SP)
                mov     R0, -(SP)
                mov     #13, R1
                call    ERROUT
                mov     (SP), R0
                add     #100, R0
                call    OUTCHR
                mov     #14, R1
                call    ERROUT
                call    INPCHR
                mov     (SP)+, R0
                mov     (SP)+, R1
                mov     (SP)+, R2
                movb    R0, S$ONED(R3)
                ccc
1$:             mov     R4, -(SP)
                mov     R3, -(SP)
                mov     R2, -(SP)
                mov     R1, -(SP)
                mov     R0, -(SP)
                call    SETDRV
                bcs     2$
                mov     R4, P$OPTP(R5)	;Тип операции :0-чтение,иначе запись 
                mov     R0, R4
                dec     R4
                asl     R4
                add     S$RSLA(R3), R4	;адрес таблицы подпр.чтения секторов на логическом уровне.(на уровне DOS)
                mov     4(SP), R2
                mov     2(SP), R1
                call    @(R4)+
2$:             mov     (SP)+, R0
                mov     (SP)+, R1
                mov     (SP)+, R2
                mov     (SP)+, R3
                mov     (SP)+, R4
                bcc     3$
                mov     R0, -(SP)
                mov     R1, -(SP)
                mov     R2, -(SP)
                iot
                .word 56				;Обработка критических ошибок.
                mov     R0, R5
                mov     (SP)+, R2
                mov     (SP)+, R1
                mov     (SP)+, R0
                cmp     #'R, R5
                beq     1$
                cmp     #'A, R5
                beq     4$
3$:             tst     (PC)+
4$:             sec
                mov     (SP)+, R0
                return
; ───────────────────────────────────────────────────────────────────────────
;                  Функция 32(26).
;Установление адреса области обмена с диском
;(адрес чтения/записи физического сектора)
;вход: R0-адрес обмена.

FIOT32:         mov     R0, S$BIOA(R3)
                sub     S$SIOA(R3), R0	;если совпадает с системным адресом
                movb    R0, S$IONC(R3)	;то туда заносится 0 !!!тут надо бы по конкретнее, а то ведь в мл байте может как раз 0 и получиться
                return
; ───────────────────────────────────────────────────────────────────────────
;                  Функция 57(47).
;Получить адрес обмена с диском (адрес чтения/записи сектора).
;выход: R0-адрес.

FIOT57:         mov     S$BIOA(R3), R0
                return
; ───────────────────────────────────────────────────────────────────────────
;                  Функция 45(37).
;Задать новую подпрограмму обработки функции.
;вход: R0-номер функции.
;      R1-абсолютный адрес подпрограммы.

FIOT45:         asl     R0
                add     S$IOTA(R3), R0
                mov     R1, (R0)
                return
; ───────────────────────────────────────────────────────────────────────────
;                  Функция 65(53).
;Получить абсолютный адрес подпрограммы обработки функции.
;вход:  R0-номер функции.
;выход: R0-абсолютный адрес в памяти.

FIOT65:         asl     R0
                add     S$IOTA(R3), R0
                mov     (R0), R0
                return
; ───────────────────────────────────────────────────────────────────────────
;                  Функция 60(48).
;Получить версию DOS.
;выход: R0-версия:
;       ст.байт номер версии,мл.байл номер подверсии.

FIOT60:         mov     #400, R0
                return
; ───────────────────────────────────────────────────────────────────────────
;                  Функция 66(54).
;Получить размер свободного пространства на диске.
;вход:  R0-номер дисковода(1-дисковод "А"...).
;выход: R1-секторов в кластере.
;       R2-общее количество кластеров на диске.
;       R0-количество свободных кластеров.

FIOT66:         call    PARLST
                bcs     1$
                clr     P$LFCL(R5)		;последний свободный кластер на диске
                mov     #1, P$TMP4(R5)
                clr     R4
2$:             call    FNFCL$			;P$LFCL(R5) модифицируется там
                bcs     3$
                inc     R4
                inc     P$LFCL(R5)		;последний свободный кластер на диске
                br      2$

3$:             ccc
                mov     S$CLSZ(R3), R2
                mov     P$CLSZ(R5), R1	;размер кластера в секторах
                mov     R4, R0
1$:             return
; ───────────────────────────────────────────────────────────────────────────
;                  Функция 30(24).
;Доступ к буферам DOS.
;выход: R0 - адрес области BAT-файлов.
;       первое слово - уровень вложенности ( 0 - область пуста).
;       R1 - адрес FCB стандартного устройства ввода.
;       R2 - адрес FCB стандартного устройства вывода.

FIOT30:         mov     S$BTFA(R3), R0
                mov     S$FCIA(R3), R1
                mov     S$FCOA(R3), R2
; ───────────────────────────────────────────────────────────────────────────
;обработка устройства NUL
AUXPRC:         return			;!!! перенести к NUL
; ───────────────────────────────────────────────────────────────────────────
;                  Функция 61(49).
;Доступ к внутрисистемной информации.
;выход: R1-адрес области DOS.

FIOT61:         mov     R3, R1
                return
; ───────────────────────────────────────────────────────────────────────────
;                  Функция 62(50).
;Получить адрес дисковой области.
;вход: R0-номер устр.
;выход:R1-адрес области.

FIOT62:         call    SETDRV
                mov     R5, R1
                return
; ───────────────────────────────────────────────────────────────────────────
;диспетчер EMT
EMTTRP:         mov     R5, -(SP)
                mov     2(SP), R5	;адрес возврата
                mov     R3, -(SP)
                call    INIIOT
                dec     R5
                movb    -(R5), R5	;номер емта
                cmp     R5, S$EMCN(R3)	;если номер больше максимального
                bhi     1$			;то ошибка
M2$11M:         nop					;для БК11 надо умножать на 2
                add     S$CEMB(R3), R5	;адрес буфера перехвата емт команд
                tst     (R5)		;команда перехвачена?
                beq     2$			;нет
                call    @(R5)+		;да, выполним перехваченную функцию
                mov     (SP)+, R3
                mov     (SP)+, R5
                br      EMTEX$

2$:             mov     (SP)+, R3	;нет, выполним обычную функцию
                mov     (SP)+, R5
                jmp     @V30OLD

1$:             mov     (SP)+, R3
                mov     R5, R4
                mov     (SP)+, R5
                iot
                .word 63			;Вызывается при неверном ЕМТ, на БК0010 >50, на БК0011(М) >130.
                rti
; ───────────────────────────────────────────────────────────────────────────
;диспетчер IOT
IOTTRP:         mov     R5, -(SP)
                mov     R3, -(SP)
                mov     R4, -(SP)
                call    GETSBF		;получим в R3 адрес системной области
                mov     6(SP), R5	;адрес возврата
                mov     (R5), R5	;номер функции
                movb    @#ERRFDD, S$ER52(R3)	;сохраним прошлый номер ошибки
                clrb    @#ERRFDD		;очистим ячейку, где содержится номер ошибки
                asl     R5
                add     S$IOTA(R3), R5	;адрес таблицы подпрограмм IOT диспетчера
                call    @(R5)+		;выполним п/п функции
                bcs     1$			;если все нормально
                clrb    @#ERRFDD	;снова очистим ячейку, где содержится номер ошибки
1$:             mov     (SP)+, R4
                mov     (SP)+, R3
                mov     (SP)+, R5
                inc     (SP)		;увеличим адрес возврата на 2
                inc     (SP)		;так, чтобы бит С не затрагивался
EMTEX$:         bic     #1, 2(SP)	;очистим бит С в PSW
                bcc     2$			;а если он сейчас установлен
                bis     #1, 2(SP)	;то установим бит С в PSW !!! можно заменить на adc 2(sp)
2$:             rti
; ───────────────────────────────────────────────────────────────────────────
;                  Функция 37(31). 
;Перехват EMT. 
;вход:	R0-номер EMT (на БК0010 от 0 до 50, на БК0011(М) от 0 до 130)
;		R1-абсолютный адрес программы обработки данного EMT. 
;		(если R1=0,то адрес восстанавливается) 
 
FIOT37:         nop		;для БК11М сюда помещается asl, т.к. там есть и нечётные емты
                add     S$CEMB(R3), R0
                mov     R1, (R0)
                return
; ───────────────────────────────────────────────────────────────────────────
;перехват обработки ЕМТ 14
EMT14$:         mov     V30OLD, @#30
                mov     R3, R5
AE14$2:         emt     14
                mov     S$EXSY(R5), @#4	;восстановим векторы после выполнения
                mov     V30NEW, @#30
				;и диспетчер IOT тоже
; ═══════════════════════════════════════════════════════════════════════════

INIIOT:         .addr   R3, IOTTRP
                mov     R3, @#20
GETSBF:         .addr   R3, SYSBUF
                return

; ───────────────────────────────────────────────────────────────────────────
;перехват обработки ЕМТ 36
;используем ячейки 0 и 2, как будто в буфере системных переменных места нет.
EMT36$:         mov     R1, R5			;адрес блока параметров emt 36
                add     #6, R1
EM36$1:         mov     SP, @#0			;в ячейке 0 сохраняем текущий указатель стека (это плохо, надо бы где-то в другом месте сохранять)
                mov     S$ISSP(R3), SP	;вершина внутрисистемного указателя стека для перехватчика emt 36
										;(макс. размер 156 байтов, дальше будет портиться внутрисистемная таблица данных)
                mov     S$TFCB(R3), R4
                clr     R2
                iot
                .word 51				;Произвести синтаксический разбор строки.
                bcs     1$
                tst     @#2
                bne     2$
                mov     S$BE36(R3), R0	;адрес буфера копии имени в перехватчике emt36 (NBE36L байтов)
                mov     S$LE36(R3), R2	;длина буфера копии имени в перехватчике emt36 (NBE36L байтов)
3$:             movb    (R1)+, (R0)+	;копируем имя обрабатываемого файла в буфер
                beq     2$
                sob     R2, 3$
2$:             tstb    (R5)
                beq     1$
                cmpb    (R5), #2
                beq     4$
                iot
                .word 17				;Открыть файл методом FCB.
                bcs     1$
                mov     2(R5), R0		;адрес загрузки
                bne     5$				;если не задан,
                mov     F$FLLD(R4), R0	;то берём из FCB
5$:             mov     R0, F$DTAD(R4)	;помещаем в адрес обмена
                mov     R0, @#264		;помещаем в ячейку адреса загруженного файла
                mov     R0, 26(R5)		;помещаем в адрес обнаруженного файла блока параметров МФ
                mov     F$FLSZ(R4), R0	;размер файла в байтах.
                mov     R0, F$RCSZ(R4)	;помещаем в размер записи в байтах.
                mov     R0, @#266		;помещаем в ячейку размера загруженного файла
                mov     R0, 30(R5)		;помещаем в размер обнаруженного файла блока параметров МФ
                iot
                .word 41				;Прямой доступ,чтение.
                br      6$

4$:             iot
                .word 26				;Создать файл.
                bcs     1$
                mov     2(R5), F$FLLD(R4)	;адрес загрузки файла в память
                beq     6$					;если не задан, то и писать нечего
                mov     2(R5), F$DTAD(R4)	;адрес обмена
                mov     4(R5), F$RCSZ(R4)	;размер записи в байтах.
                iot
                .word 42				;Прямой доступ,запись.
6$:             iot
                .word 20				;Закрыть файл.
                movb    (R4), R0
1$:             movb    @#ERRFDD, 1(R5)
                iot
                .word 15				;Инициализировать драйвер (контроллер) дисковода.
                mov     R5, R1
                mov     @#0, SP
                return
; ───────────────────────────────────────────────────────────────────────────
;                  Функция 46(38).
;Исполнить программу.(Автозапуск работает корректно).
;вход: R1-адрес строки содержащую имя файла.
;      R2-флаг :0-запуска не происходит, иначе файл запускается
;         на исполнение.

FIOT46:         mov     #320, R5
                mov     R2, @#2
                mov     R5, R4
                mov     #3, (R4)+
                clr     (R4)+
                clr     (R4)+
                call    EM36$1
                movb    1(R5), @#ERRFDD
                bne     1$
                tst     @#2
                bne     2$
                mov     S$BE36(R3), R3	;передаёт программе через R3 её имя
                mov     #776, SP
                mov     @#264, R5
                cmp     R5, #764
                bhis    3$
                mov     @#766, R5
3$:             jmp     (R5)

1$:             sec
2$:             return
; ───────────────────────────────────────────────────────────────────────────
;                  Функция 40(32).
;Получить адрес области окружения DOS.
;выход: R1-адрес начала области.
;       R2-размер области в байтах.

FIOT40:         mov     S$DOSA(R3), R1
                mov     S$DOSZ(R3), R2
                return
; ───────────────────────────────────────────────────────────────────────────
FCBOUT:         .byte    0
                .ascii   "CON        "
                .blkb    36
; ───────────────────────────────────────────────────────────────────────────
FCBIN:          .byte    0
                .ascii   "CON        "
                .blkb    36
; ───────────────────────────────────────────────────────────────────────────
DEVFCB:         .blkb    52				;буфер под параметры устройства (наверно под стандартные)
; ───────────────────────────────────────────────────────────────────────────
STDNAM:         .asciz "PRN"			;список имён символьных устройств.(имена разделены нулевым байтом).
                .asciz "LST"
                .asciz "NUL"
                .asciz "AUX"
                .asciz "CON"
                .asciz "$"
				.even
; массив смещений, длиной 076 слов, которые преобразуются в абсолютные адреса
SYSOFS:         .word @PRNPRC			;таблица переходов для символьных устройств.
                .word @PRNPRC			;список которых в STDNAM
                .word @NULPRC
                .word @AUXPRC
                .word @CONPRC
; ───────────────────────────────────────────────────────────────────────────
IOTTBL:         .word @FIOT00           ; начало таблицы iotов
                .word @FIOT01
                .word @FIOT02
                .word @FIOT13           ; 3 зарезервировано
                .word @FIOT13           ; 4 зарезервировано
                .word @FIOT05
                .word @FIOT06
                .word @FIOT01           ; 7 зарезервировано
                .word @FIOT01           ; 10 зарезервировано
                .word @FIOT11
                .word @FIOT06           ; 12 зарезервировано
                .word @FIOT13			; 13 зарезервировано
                .word @FIOT14
                .word @FIOT15
                .word @FIOT16
                .word @FIOT17
                .word @FIOT20
                .word @FIOT21
                .word @FIOT22
                .word @FIOT23
                .word @FIOT24
                .word @FIOT25
                .word @FIOT26
                .word @FIOT27
                .word @FIOT30
                .word @FIOT31
                .word @FIOT32
                .word @FIOT33
                .word @FIOT34
                .word @FIOT13           ; 35 зарезервировано
                .word @FIOT13           ; 36 зарезервировано
                .word @FIOT37
                .word @FIOT40
                .word @FIOT41
                .word @FIOT42
                .word @FIOT43
                .word @FIOT44
                .word @FIOT45
                .word @FIOT46
                .word @FIOT47
                .word @FIOT50
                .word @FIOT51
                .word @FIOT52
                .word @FIOT53
                .word @FIOT54
                .word @FIOT55
                .word @FIOT56
                .word @FIOT57
                .word @FIOT60
                .word @FIOT61
                .word @FIOT62
                .word @FIOT13           ; 63 зарезервировано
                .word @FIOT64
                .word @FIOT65
                .word @FIOT66
                .word @FIOT67
                .word @FIOT70
IOTTEN:
; ───────────────────────────────────────────────────────────────────────────
DSKERR:         .asciz "Sector not found"<12><15>						;1
                .asciz "Non-DOS disk"<12><15>							;2
                .asciz "Disk write protected or disk error"<12><15>		;3
                .asciz "Disk not ready"<12><15>							;4
                .asciz "Disk error reading"<12><15>						;5
                .asciz "Bad fat"<12><15>								;6
                .asciz <15><12>											;7
                .asciz "Abort,Retry,Ignore "							;10
                .asciz "Illegal instruction"<12><15>					;11
                .asciz "Division by zero"<12><15>						;12
                .asciz "Insert diskette for drive "						;13
				.asciz ":"<12><15>"Strike any key then ready"<12><15>	;14
                .even
; ───────────────────────────────────────────────────────────────────────────
V30OLD:         .word 0
V30NEW:         .word 0
CRTCLE:         .byte 1,3
                .byte 2,5
                .byte 3,5
                .byte 4,5
                .byte 5,1
                .byte 6,4
                .byte 7,4
                .byte 10,5
                .byte 11,5
                .byte 12,2
ENKRNL:         .word 0 ;конец таблицы

                .END
