﻿
;     СЛУЖЕБНЫЕ ЯЧЕЙКИ

;     400      70000 - конец памяти
;     402      1002  - начало текста
;     404      63000 - конец текста
;     406      1000  - начало программы
;     410      начало блока параметров
;     412      рабочие для установки регистров в 1ую и 3ю
;     414      при трансляции для подсчета кол-ва яч. на команд
;     416      длина кодового блока (номер отм. пр.)
;     420
;     422      копия 177662
;     424      адрес метки
;     426      подсчет пробелов ZAP
;     430      тек. адрес строки
;     432      адрес @#4
;     434
;     436      граница текста 37600 или 63000
;     440
;     442
;     444      3,27 в зависимости от РП
;     446      адрес SP
;     450      (406) - адрес компановки
;     452      длина поля локальных меток
;     454      печать при трансляции
;     456      номер строки при трансляции
;     460
;     462      счетчик ошибок
;     464      вспом. в T24, K12
;     466      0 - строка не ред., #0 - редактировалась
;     470      начало буфера шаблона
;     472      вставка - замена в UPU
;     474      служебная в печати, адр. SP в W11
;     476


TC:   .A:COLOSALISLSTSCL1LALSRSLFS1S2CNPEQAADNASM
      .E

; КОМАНДЫ МОНИТОРА

     .@C00   CO
     .@LO    LO
     .@SA    SA
     .@LI    LI
     .@SL    SL
     .@ST    ST
     .@WC    SC
     .@LL    L1
     .@LA    LA
     .@LS    LS
     .@STA   RS
     .@LF    LF
     .@SF    S1
     .@SS    S2
     .@C00N  CN
     .@WPC   PE
     .@A00   QA
     .@AD    AD
     .@NA    NA
     .@%SM   SM

TCH:  ASL      R0
      TST      (R0)+
      ADD      PC,R0
      ADD      (R0),R0
      RTS      R0

;      T R A P

     .@T2     T2   прокрутка (R3)+ до кода 12 или 0
     .@T4     T4   прокрутка (R3)+ до кода 12 и INC R3
     .@T6     T6   распечатка строки
     .@T10    T10  раздвижка -(R1),-(R2)
     .@T12    T12  сдвижка (R3)+,(R0)+
     .@T14    T14  курсор в начало
     .@T16    T16  курсор выключить
     .@T20    T20  включить
     .@T22    T22  запрос R0 с контр. длины файла и распечатка
     .@T24    T24  распечатка либо буфера, либо тек. строки
     .@W25    T26  запрос R0
     .@ENC    T30  распечатка таблицы переменных
     .@P12    T32  определение конца строки BEQ после BNE
     .@NOBM   T34
     .@P40    T36  распечатка пробелов и уход на KEY
     .@UPU    T40  упаковка в R3 и 472 до 6 символов REDIX
     .@ADR    T42  @A вычисление адреса в R1
     .@ADJ    T44  добавка смещения к (R3)  R0-R3-2 → (R3)
     .@ADB    T46  вычисление смещения в BR
     .@KEY    T50  BEQ - ошибка, BHI - буква, BLO - число
     .@ITT    T52  распечатка REDIX из R1
     .@SNA    T54  определение номера регистра
     .@PUP    T56  TRAP 36, TRAP 40
     .@FLA    T60  адрес метки в R0, либо BEQ
     .@M10    T62  прогон до конца строки
     .@PUN    T64  TRAP 56, TRAP 54
     .@NOO    T66  переход от первого ко второму адресу
     .@UPC    T70  считывание восм. числа из текста в R1
     .@J4     T72  компановка по яч. 450
     .@TEX    T74  распечатка текста
     .@PRO    T76  распечатка 8ичного числа из R1 (R3,R4-сох.)
     .@J3     T100 передача управления по R3= -1,-2,-3,-4
     .@WQ0    T102 MOV @#404,R5
     .@D42    T104 INC @#414
     .@T130   T106 EMT 26, MOV R1,-(SP), MOV R2,-(SP)
     .@J2     T110 компановка по (416)
     .@UST    T112 установка регистра (412)=0 - в 1, #0 в 3ю
     .@UPS    T114 нахождение адреса R3 по (414)
     .@PUS    T116 запоминание неизвестной метки
     .@MAD    T120 запрос адреса компановки в 450
     .@ARF    T122 считывание из (R5)+ числа со знаком
     .@Y1     T124 распечатка числа в служ. строку из R3
     .@T32    T126 запрос 8ичного числа в R5
     .@T64    T130
     .@T166   T132
     .@T170   T134
     .@T172   T136
     .@T174   T140
     .@INF    T142
     .@WUK    T144
     .@JS$$   T146
     .@MR$$   T150

DTR:  MOV      (SP)+,(SP)
      MOV      R0,-(SP)
      MOV      2(SP),R0
      MOV      -(R0),R0
      BIC      #177400,R0
      ASRB     R0
      BMI 7
      BCC      TCH
      INC      R0
      MOV      R0,-(SP)
      MOVB (R5)+,R0
      TRAP     74
      .@AS1
      MOV      @#456,R1
      TRAP     76
      TRAP 312
      MOV  @#470,R3
    COM R5
      TRAP     6
      MOV  (SP)+,R1
      JMP ERRRR
7:  ROLB R0
    BITB #100,R0
    BEQ 8
    BICB #300,R0
8:  EMT 16
    TST (SP)+
    RTS PC

TSN:   .R:R0 R1 R2 R3 R4 R5 SP PC R6 R7
       .#0

TZ1:.B:14.B:31.B:31.B:234.A:INI
    .B:31.B:234.A:CON
    .B:31.B:234.B:12.B:0
TEX0:.B:14.A:=M 21
AR:.A: A=
   .B:0
ASK:.B:14.A:УДAЛИTЬ?
AS0:.B:12.A:D/N?
    .B:0
LT:.B:12.A:Д=
   .B:0
ZV: .B:12.A:>
    .B:231.B:0
TER:.B:12.A:ERR
    .B:40.B:231.B:0
AS1:.B:14
NLN:.A:B CTP.
    .B:0
T%1:.B:23.B:5.B:6.B:1.B:15.B:1.B:1.B:2.B:4.B:2.B:1.B:14.B:5
    .B:2.B:2.E
DD$:.#0.#7.#77.#77.#377.#377.#377.#377.#777.#777.#777
    .#100077.#107777.#7777.#177777
TAC:  .R:HAL WAI RTI BPT IOT RES RTT RET NOP
      .R:CLC CLV CLZ CLN CCC SEC SEV SEZ SEN SCC
      .R:RTS FAD FSU FMU FDI
      .R:JMP SWA CAL SXT MTP MFP MAR
      .R:BR BNE BEQ BGE BLT BGT BLE
      .R:BPL BMI BVC BVS BCC BCS BHI BLO EMT TRA
      .R:MUL DIV ASH ASH JSR XOR SOB
      .R:CLR COM INC DEC NEG TST ROR ROL ASR ASL ADC SBC
      .R:MOV CMP BIT BIC BIS ADD SUB
      .R:END
TCC:  .#0       HALT
      .#1       WAIT
      .#2       RTI
      .#3       BPT
      .#4       IOT
      .#5       RESET
      .#6       RTT
      .#207     RET
      .#240     NOP
      .#241     CLC
      .#242     CLV
      .#244     CLZ
      .#250     CLN
      .#257     CCC
      .#261     SEC
      .#262     SEV
      .#264     SEZ
      .#270     SEN
      .#277     SCC
      .#200     RTS  7
      .#75000   FADD 7
      .#75010   FSUB 7
      .#75020   FMUL 7
      .#75030   FDIV 7
      .#100     JMP  77
      .#300     SWAB
      .#4700    CALL 77
      .#6700    SXT
      .#106400  MTPS
      .#106700  MFPS
      .#6400    MARK  77
      .#400     BR    377
      .#1000    BNE
      .#1400    BEQ
      .#2000    BGE
      .#2400    BLT
      .#3000    BGT
      .#3400    BLE
      .#100000  BPL
      .#100400  BMI
      .#102000  BVC
      .#102400  BVS
      .#103000  BCC,BHIS
      .#103400  BCS,BLO
      .#101000  BHI     377
      .#101400  BLOS
      .#104000  EMT     377
      .#104400  TRAP

      .#70000   MUL    777
      .#71000   DIV    777
      .#72000   ASH    777
      .#73000   ASHC   777

      .#4000    JSR     777
      .#74000   XOR
      .#77000   SOB     777
      .#5000    CLR  100077
      .#5100    COM
      .#5200    INC
      .#5300    DEC
      .#5400    NEG
      .#5700    TST
      .#6000    ROR
      .#6100    ROL
      .#6200    ASR
      .#6300    ASL
      .#5500    ADC
      .#5600    SBC
      .#10000   MOV  107777
      .#20000   CMP
      .#30000   BIT
      .#40000   BIC
      .#50000   BIS
      .#60000   ADD   7777
      .#160000  SUB
      .#777     END 177777
      .#0
TJC:  .@SPE     HAL
      .@RT      RTS
      .@F1      JMP
      .@MR     MARK
      .@BR      BR
      .@BH      BHI
      .@BL      BLOS
      .@MT      EMT
      .@ASHC    MUL-ASH
      .@JS      JSR
      .@SO      SOB
      .@MAB     CLR
      .@TAB     MOV
      .@TA      ADD
      .@ENC1


                 ;1. NEG%

; ИЗМЕНЕНИЕ ЗНАКА ЦЕЛОГО ДВОЙНОГО ЧИСЛА (R0,R1),
; ЕСЛИ (R0,R1)=(100000,0), TO C=1.
; NEG%%% И NEG%% - ДОБАВОЧНЫЕ ВХОДЫ ДЛЯ СЛУЖЕБНЫХ ЦЕЛЕЙ.
NEG%%%:CLR R4
      MOV R0,-(SP)
      MOV R1,-(SP)
      MOV R2,R0
      MOV R3,R1
      JSR PC,NEG%%
      MOV R0,R2
      MOV R1,R3
      MOV (SP)+,R1
      MOV (SP)+,R0
      BCS 7
NEG%%:TST R0
      BGE 1
      COM R4
NEG%:  COM R0
       NEG R1
       BNE 1
       INC R0
       BLT 7
1:     TST (PC)+
7:     SEC
       RTS PC

                 ;2. ADD%

;СЛОЖЕНИЕ ЦЕЛОГО ЧИСЛА (R0,R1) И (R2,R3), ПРИ ПЕРЕПОЛНЕНИИ
;УСТАНАВЛИВАЕТСЯ C=1.

ADD%:ADD R3,R1
     ADC R0
     BCC 9
     MOV R2,R0
     RTS PC
9:   ADD R2,R0
     RTS PC

                 ;3. SUB%

;ВЫЧИТАНИЕ ЦЕЛОГО ЧИСЛА (R0,R1) ИЗ (R2,R3), ПРИ ПЕРЕ-
;ПОЛНЕНИИ УСТАНАВЛИВАЕТСЯ C=1.

SUB%:SUB R3,R1
     SBC R0
     BCS 9
     SUB R2,R0
     RTS PC
9:   MOV R2,R0
     COM R0
     RTS PC

                 ;4. DIV%

; ДЕЛЕНИЕ ЦЕЛОГО ЧИСЛА (R0,R1) НА (R2,R3) РЕЗУЛЬТАТ В (R0,R1)
; ЕСЛИ ОДНО ИЗ ЧИСЕЛ РАВНО (100000,0) ИЛИ (R2,R3)=(0,0) ТО C=1.
DIV%:MOV R5,-(SP)
     JSR R4,@#110346
     JSR PC,NEG%%%
     BCS %7
     CLR -(SP)
     CLR -(SP)
     TST R2
     BNE 20
     TST R3
     BEQ 9
20:  MOV #1,R5
     CLR R4
     BR 2121

21:  ASL R5
     ROL R4
     JSR PC,ADD%
     ASL R3
     ROL R2
2121:JSR PC,SUB%
     BCS 22
     BPL 21
22:  JSR PC,ADD%
23:  TST R5
     BNE 223
     ROR R4
     BCS 223
     BEQ 110
223: ROR R5

     ROR R2
     ROR R3
     JSR PC,SUB%
     BMI 22
     BCS 22
     BIS R4,(SP)
     TST R4
     BNE 23
     BIS R5,2(SP)

     TST R5         ;ОКРУГЛЕНИЕ
     BNE 23
     INC 2(SP)
     BNE 110
     INC (SP)
     BMI 9          ;ОКРУГЛЕНИЕ

110: MOV (SP)+,R0
     MOV (SP)+,R1
     BR 100



                 ;6. MUL%

;УМНОЖЕНИЕ ЦЕЛОГО ЧИСЛА (R0,R1) НА (R2,R3),C=1 ПРИ ПЕРЕПОЛНЕНИИ
MUL%:MOV R5,-(SP)
     JSR R4,@#110346
     JSR PC,NEG%%%
     BCS %7
     MOV R2,-(SP)
     MOV R3,-(SP)
     MOV R0,R2
     MOV R1,R3
     TST R0
     BNE 10
     TST R1
     BEQ 1

10:  CLR R0
     CLR R1

90:  ASR 2(SP)
     ROR (SP)
     BCC 2

     JSR PC,ADD%
     BCS 9
     BMI 9

2:   TST 2(SP)
     BNE 22
     TST (SP)
     BEQ 1
22:  ASL R3
     ROL R2
     BPL 90

9:   CMP (SP)+,(SP)+
     BR %7
1:   CMP (SP)+,(SP)+
100: TST R4
     BEQ %11
     JSR PC,NEG%
%11:  MOV R0,(SP)
     MOV R1,2(SP)
     TST (PC)+
%7:   SEC
     JSR R4,@#110362
     MOV (SP)+,R5
     RTS PC


                 ;7. INTDEC

; ПРЕОБРАЗОВАНИЕ ДВОЙНОГО ЦЕЛОГО (R0,R1) В REAL (R0,R1)
; ЕСЛИ ВСЕ В ПОРЯДКЕ,ТО С=0; ИНАЧЕ,ЕСЛИ R0=100000,R1=0, TO C=1.
; R2 - КОЛИЧЕСТВО ДОБАВОЧНЫХ УМНОЖЕНИЙ (ДЕЛЕНИЙ ПРИ R2<0) НА 10
; КОТОРЫЕ НАДО СДЕЛАТЬ ПРИ ПЕРЕВОДЕ.
INTDEC:MOV R5,-(SP)
       JSR R4,@#110346
       MOV R2,R5
       CLR R4
       TST R0
       BGT 123
       BLT 10
       TST R1
       BEQ %11
       BR 123
10:    BIS #100000,R4
       JSR PC,NEG%
       BCS %7
123:   MOV #230,-(SP)
12:    BIT #176000,R0
       BNE 2
       ASL R1
       ROL R0
       DEC (SP)
       BR 12
627:   ASR R0
       ROR R1
       BCC 667    ;ОКРУГЛЕНИЕ
       INC R1
       BNE 667
       INC R0     ;ОКРУГЛЕНИЕ
667:   INC (SP)
2:    BIT #174000,R0
       BNE 627
62:    MOV #12,R3
       CLR R2
       TST R5
       BEQ 22
       BMI 63
       DEC R5
       JSR PC,MUL%
       BR 2

63:    INC R5
       JSR PC,DIV%
       BR 12

22:    ASR R0
       ROR R1
       ASR R0
       ROR R1
       ASR R0
       ROR R1
       BCC 622
       INC R1     ;ОКРУГЛЕНИЕ
       BNE 622
       INCB R0
       BNE 622
       INC (SP)   ;ОКРУГЛЕНИЕ
622:   BIS R4,R0
       ADD #3,(SP)
       SWAB (SP)
       BNE 70
       ROR (SP)
       BIC #200,R0
       BIS (SP)+,R0
11:    BR %11
70:    TST (SP)+
       BR %7


                 ;8. GETDEC

; ПОЛУЧЕНИЕ ЧИСЛА REAL В (R0,R1) ИЗ ТЕКСТА, НА КОТОРЫЙ УКАЗЫ-
; ВАЕТ R5 (R5 - СДВИГАЕТСЯ ЗА КОНЕЦ СЧИТАННОГО ТЕКСТА).
GETDEC:JSR R4,@#110346
       MOV #100000,R2
       JSR PC,GETINT
       MOVB (R5),-(SP)
       BIC #177640,(SP)
       CMP (SP)+,'E'
       BNE 5
       INC R5
       MOV R0,R3
       MOV R1,R4
       MOV R2,-(SP)
       MOV #-1,R2
       JSR PC,GETINT
       MOV (SP)+,R2
       BCS 700
70:    SUB R1,R2
       MOV R4,R1
       MOV R3,R0
5:     NEG R2
       JSR PC,INTDEC
       MOV R0,(SP)
       MOV R1,2(SP)
       BR 44


                 ;10. GETINT

; ПОЛУЧЕНИЕ ДВОЙНОГО ЦЕЛОГО (R0,R1) ИЗ ТЕКСТА,НА КОТОРЫЙ УКАЗЫ-
; ВАЕТ R5 (R5 - СДВИГАЕТСЯ ЗА КОНЕЦ СЧИТАННОГО ТЕКСТА).
; R2=-1 - ТОЧКА - КОНЕЦ ТЕКСТА, R2=100000, TOЧКА НЕ ПРЕРЫВАЕТ
; СЧИТЫВАНИЕ ЧИСЛА, В R2 ПОДСЧИТЫВАЕТСЯ КОЛ-ВО ЗНАКОВ, СЧИТАН-
; НЫХ ПОСЛЕ ТОЧКИ.
GETINT:JSR R4,@#110346
       CLR -(SP)
       CLR R0
       CLR R1
       MOV #12,R3
       CLR R2
2:     JSR PC,III%%%
       BCS 1
       MOV R0,-(SP)
       MOV R1,-(SP)
       JSR PC,MUL%
       BCS 90
       BMI 90
       ADD R4,R1
       ADC R0
       BMI 90
       CMP (SP)+,(SP)+
       BR 2
90:   MOV (SP)+,R1
      MOV (SP)+,R0
91:   INC R2
      JSR PC,III%%%
      BCC 91
93: MOV 6(SP),R3
    BPL 94
    INC R3
    BEQ 944
    CLR 6(SP)
94: SUB R2,6(SP)
944:JSR PC,%%%%%1
700: BR 7
1: TST 6(SP)
   BPL 22
   CMPB (R5)+,'.'
   BNE 21
   CMPB (R5)+,'0'
   BEQ 22
   CMPB -(R5),'.'
   BEQ 22
21: DEC R5
22: BIC #100000,6(SP)
    JSR PC,%%%%%1
100:TST (PC)+
7:  SEC
44: JSR R4,@#110362
    RTS PC

III%%:COM 2(SP)       ; СОДЕРЖИМОЕ ЯЧ. III%% КРОМЕ ОСНОВНОЙ
III%%%:MOVB (R5)+,R4  ; ФУНКЦИИ ИСПОЛЬЗУЕТСЯ КАК КОД 5166
       CMPB R4,'-'    ; КОНЦА МАССИВА КОНСТАНТ OUT%%% .
       BEQ III%%
       CMPB R4,#40
       BEQ III%%%
       CMPB R4,'.'
       BNE 2
       MOV 10(SP),R4
       BPL 23
       INC R4
       BEQ 23
       CLR 10(SP)
       BR III%%%
2:     SUB #60,R4
       CMP #11,R4
       BLO 23
       TST 10(SP)
       BLT 1
       INC 10(SP)
1:     RTS PC
23:    DEC R5
       SEC
       RTS PC
OUT%:CLR R4
       MOV R0,R5
       BGE 112
       COM R4
112:   ASL R5
       CLRB R5
       SWAB R5
       BIC #177400,R0
       BISB #200,R0
       RTS PC

%%%%%1:TST 2(SP)
       BEQ 11
       JSR PC,NEG%
11:    MOV (SP)+,(SP)
     MOV R0,2(SP)
     MOV R1,4(SP)
     RTS PC

%SM: EMT 4
     TRAP 340
     MOV #100724,R3
     JSR PC,@#100460
     MOV #5015,R2
     MOV #320,R1
     MOV #2,(R1)
     BIS WOF+2,(R1)+
       MOV #70000,R5
       MOV R5,(R1)+
       MOV #7000,(R1)+
       EMT 10
       DEC R1
43:    MOVB #40,(R1)+
       CMP R1,#346
       BLO 43
    TRAP 314
       MOV  R5,R0
       MOV #60,@#456
       MOV '=Д',(R0)+
       MOV  @#416,R1
       JSR PC,T%76
       MOV  @#410,R4
       MOV #5012,(R0)+
1000:  MOV #4,R4
1:     TST  -(R5)
    CMP @#410,R5
    BHIS 0
100:   MOVB #40,(R0)+
       CMP #-10,(R5)
       BHI 2
       TST -(R5)
       MOVB #52,-1(R0)
2:     MOV (R5),R1
    JSR PC,T%52
    MOV -(R5),R1
    JSR PC,T%52
       MOVB #75,(R0)+
       MOV  -(R5),-(SP)
      TST  (SP)
      BMI    111
      CMP  (SP),#1000
      BLO    111
      SUB  @#450,(SP)
111:   MOV (SP)+,R1
       JSR PC,T%76
4:     MOVB #40,(R0)+
       MOVB #40,(R0)+
       SOB R4,1
       DEC R0
       MOVB #12,-1(R0)
       CMP R0,#77600
       BLOS 1000
       JSR PC,%EMT36
       BNE 78
       MOV #100000,R0
61:    CLR -(R0)
       CMP R0,#70000
       BNE 61
       BR 1000
0:   JSR PC,%EMT36
     BEQ 77
78:  TRAP 314
     JSR PC,@#100644
     TRAP 26
77:    TRAP 314
       JMP       MO0
T%76:  MOV R4,-(SP)
       MOV R3,-(SP)
       MOV #6,R4
       CLR R3
1:     INC R3
      CLRB (R0)
3:    ROL       R1
5:    ROLB (R0)
      SOB R3,3
      BISB #60,(R0)+
      TST (R3)+
      SOB R4,1
      MOV (SP)+,R3
2:    MOV (SP)+,R4
      RTS  PC

%EMT36:MOV #324,R1
       SUB #70000,R0
       MOV R0,(R1)+
31:    CMPB (R1),#40
       BNE 32
       MOVB '.',(R1)
32:    CMPB (R1)+,'.'
       BNE 31
       MOVB @#456,(R1)
       INC @#456
       MOV #320,R1
       CLRB 1(R1)
       EMT 36
       TSTB 1(R1)
       RTS PC

T%52:  MOV  #3,R3
       MOV R5,-(SP)
3E:   CLR R5
       MOV  #20,R2
       CLR  -(SP)
1:     ROL   R1
       ROL R5
       ASL   (SP)
       CMP  R5,#50
       BLT   2
       INC (SP)
       SUB  #50,R5
2:     SOB R2,1
       MOV (SP)+,R1
       TST R5
       BEQ  33
       CMP R5,#35
       BGT  53
       ADD  #100,R5
       CMP R5,#132
    BLOS 63
    SUB #67,R5
       BR   63
53:    ADD #22,R5
       BR        63
33:    MOV #40,R5
63:    MOVB R5,(R0)+
       SOB R3,3E
       MOV (SP)+,R5
13: RTS PC


    END


