;
; ╔═════════════════════════════════════════════════════════════════════════╗
; ║     This file is generated by The Interactive Disassembler (IDA)        ║
; ║     Copyright (c) 2006 by DataRescue sa/nv, <ida@datarescue.com>        ║
; ║ Licensed to: Kon v Palto                                                ║
; ╚═════════════════════════════════════════════════════════════════════════╝
;
; Input MD5   : 4CF7C3AB3A9A560FF44C0977ECB89DC6

; ───────────────────────────────────────────────────────────────────────────
; File Name   : ANFORM

; Processor:        K1801VM1
; Target assembler: BK Turbo8 Cross Assembler

; ═══════════════════════════════════════════════════════════════════════════
.include "inc\FDDParam.asm"
.include "inc\ANDOS310Param.asm"

ShellAddr = 120000  ; адрес выхода в оболочку Андос
OwnDrvBuf = 124000  ; адрес буфера своего драйвера дисковода

Start:          cmp     @#VERS, #100000 + 310. ; Версия ANDOS, (для V3.1 - 100466)
                beq     1$
                jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz <12><12>"ANFORMAT работает только с ANDOS V3.1"<12>
                .even
                .blkb   10.
; ───────────────────────────────────────────────────────────────────────────

1$:             emt     14
                jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz  <232><233><224><236><233>
                .even
                mov     #KeyVec, @#60
                mov     @#60, @#274
                clr     DRVTAB + D$FLGTAB   ; таблица признаков, по байту на привод
                movb    DRVTAB + D$BRETRY, BRETRY  ; число попыток повтора при ошибке
                movb    #39., MAXTRK    ; максимальный номер дорожки
                tstb    DRV$A + 5       ; Таблица параметров дисковода A,
                                        ; Тип дисковода. Единица в старшем бите - 80 дорожек, в 7 бите - 1 сторона
                bpl     2$
                movb    #79., MAXTRK    ; максимальный номер дорожки

2$:             clrb    MAXSIDES        ; максимальный номер головки
                bitb    #100, DRV$A + 5
                bne     3$
                incb    MAXSIDES        ; максимальный номер головки

3$:             mov     #BlockTrapTo4, @#4
                add     #15, @#160      ; абсолютный адрес курсора +15
                jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz  <234>"ANFORMAT V2.2w (C)9.12.94 А.М.Надежин"<12>
                .even

                add     #15, @#160
                jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz "Программа форматирования дисков ANDOS"<234><12>
                .even

LOOP:           mov     #BlockTrapTo4, @#4
                mov     #Start, SP
                clr     @#177130
                tstb    @#56            ; курсор погашен?
                bne     1$              ; да - переход
                jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz  <232>
                .even

1$:             tstb    @#44            ; подчёркивание?
                beq     2$              ; нет - переход
                jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz  <237>
                .even

2$:             tstb    XchgFlag        ; Флаг, что данные заменены
                beq     3$
                call    PrepareWork

3$:             jsr     R5, OUTSI       ; Вывод инлайн строки
                .ascii <12><12>
                .ascii "Команда ["<237>"F"<237>"ormat,"
                .ascii <237>"V"<237>"erify,"
                .ascii <237>"I"<237>"nit,"
                .ascii <237>"D"<237>"ir,"
                .ascii <237>"C"<237>"onBoot,"
                .ascii <237>"M"<237>"akeBoot,"
                .ascii <237>"S"<237>"et,"
                .asciz <237>"E"<237>"xit]:"
                .even


4$:             call    CursorOff       ; Гашение курсора
                emt     6               ; Ждём код с клавиатуры
                jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz  <232>           ; Включаем курсор
                .even

                bic     #177640, R0
                clr     R5              ; смещение в таблице подпрограмм
                mov     #CMDS, R1       ; "FVIDCMSE"

5$:             tst     (R5)+
                tstb    (R1)            ; команды кончились?
                beq     4$              ; да - снова пойдём ждать команду
                cmpb    R0, (R1)+       ; нет - эта команда?
                bne     5$              ; нет - проверяем дальше
                emt     16              ; да - выводим на экран
                mov     #LOOP, -(SP)    ; адрес возврата из обработчика команды
                mov     CMDSUB-2(R5), -(SP) ; адрес перехода к обработчику команды
                asr     R5              ; это теперь номер команды (отсчёт с 1)
                jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz <12><12><12>
                .even
                jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz  <234>           ; Переключение режима инверсии символов
                .even

                add     #24, @#160
                mov     #CMDTitle, R1   ; Начало таблицы строк названий действий команды
                mov     R5, -(SP)       ; номер нам ещё пригодится

6$:             tstb    (R1)+           ; найдём нужную строку
                bne     6$
                sob     R5, 6$
                clr     R2
                emt     20              ; выведем  на экран
                mov     (SP)+, R5       ; восстановим номер
                jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz  <234>           ; Переключение режима инверсии символов
                .even

                call    @INIT1          ; Инициализ. рабочей области драйвера КНГМД
                                        ; Портит:    R2 - на выходе адрес области драйвера+10
                cmp     R5, #6          ; команда "MakeBoot"?
                blt     8$              ; нет, FVIDC
                beq     7$              ; да
                return                  ; нет, SE - просто идём выполнять
; ───────────────────────────────────────────────────────────────────────────
; для MakeBoot - нужен системный диск

7$:             jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz <12><12>"Установите системный диск и в"
                .even
                br      9$
; ───────────────────────────────────────────────────────────────────────────
; для простых команд - просто нужно выбрать диск

8$:             jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz <12><12>"В"
                .even

9$:             mov     #LOOP, @#4
                call    AskDrive        ; Запрос имени привода
                                        ; Выход: R0 - номер привода 0-A: 1-B: 2-C: ...
                bne     10$             ; не А:
                mov     #DRV$A, R4      ; Таблица параметров дисковода A:
                br      11$
; ───────────────────────────────────────────────────────────────────────────

10$:            mov     #DRV$B, R4      ; Таблица параметров остальных дисководов.

11$:            mov     R0, D$UNIT-10(R2) ; номер привода
                mov     (R4)+, (R2)+    ; Задержка опускания головки
                mov     (R4)+, (R2)+    ; Задержка шага
                movb    (R4)+, (R2)+    ; Дорожка прекоррекции
                movb    #1, (R2)+       ; число попыток повтора при ошибке
                clrb    (R2)+           ; рабочая ячейка драйвера
                movb    #377, (R2)+     ; код заполнения при форматировании
                mov     #DRVTAB, R3     ; Рабочая область драйвера НГМД
                clr     (R3)
                clrb    DRVTAB + D$TRK  ; номер дорожки
                cmp     R5, #6          ; команда "MakeBoot"?
                beq     14$             ; да - переход
                cmpb    MAXTRK, #50.    ; максимальный номер дорожки
                blo     13$             ; привод на 40 дорожек
                tstb    (R4)            ; тип привода
                bmi     14$             ; 80 дор. - переход
                jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz "Количество дорожек не соответствует типу дисковода"
                .even

12$:            tst     (SP)+
                return                  ; возврат к началу меню
; ───────────────────────────────────────────────────────────────────────────

13$:            tstb    (R4)            ; тип привода
                bpl     14$             ; 40 дор. - переход
                jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz <234>"Включен режим пропуска дорожек"<234><12><12>
                .even

                bis     #401, DRVTAB + D$FLGTAB    ; корректируем признаки в D$FLGTAB

14$:            bitb    #100, (R4)      ; тип привода
                beq     15$             ; двусторонний - переход
                tstb    MAXSIDES        ; максимальный номер головки
                beq     15$             ; и сторона тоже только одна - переход
                jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz "Количество сторон не соответствует типу дисковода"
                .even
                br      12$
; ───────────────────────────────────────────────────────────────────────────

15$:            cmp     R5, #4
                bge     16$             ; для команд DCM
                cmp     R5, #2          ; и V
                beq     16$             ; не надо ждать нажатия клавиши
                jsr     R5, OUTSI       ; для F и I - надо
                .asciz "Нажмите любую клавишу"<12><12>
                .even

                clr     @#104
                emt     6               ; (V1) .DELETE #6,...
                                        ; Delete File on Channel 6

16$:            mov     @#4, -(SP)
                mov     #BlockTrapTo4, @#4
                cmp     R5, #2          ; команды IDCM
                bhi     20$             ; да - переход
                                        ; FV - продолжаем
                mov     #177130, R4
                mov     #20, (R4)       ; включаем двигатель
                clr     R5              ; подождём, пока раскрутится
                sob     R5, .
                mov     #21, (R3)       ; выбор привода A:
                tstb    D$UNIT(R3)
                beq     17$             ; не А:
                mov     #22, (R3)       ; значит выбор привода B:

17$:            mov     (R3), (R4)
                tst     RWSEC           ; адрес адреса п/п чтения записи по номеру сектора
                bne     20$
                jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz "Настройка драйвера"<12><12>
                .even

                mov     #160000, R0     ; ПЗУ быстрее, чем ОЗУ
                call    CheckFDD        ; Проверка привода.
                                        ; Вход:  R0 - адрес влияющий на коэффициент счётчика
                                        ; Выход: C - нет дисковода или диска в нём
                                        ;        R2 - счётчик, сколько прошло времени за один оборот диска
                bcs     21$             ; ошибка - возврат в меню

18$:            mov     R2, R5          ; результат сохраним
                call    CheckFDD        ; Проверка привода.
                                        ; Вход:  R0 - адрес влияющий на коэффициент счётчика
                                        ; Выход: C - нет дисковода или диска в нём
                                        ;        R2 - счётчик, сколько прошло времени за один оборот диска
                bcs     21$             ; ошибка - возврат в меню
                cmp     R2, R5          ; получилось то же самое?
                bne     18$             ; нет - повторим
                mov     R2, R5          ; зачем-то ещё раз сохраним
                mov     #ShellAddr, R0     ; Теперь с ОЗУ
                call    CheckFDD        ; Проверка привода.
                                        ; Вход:  R0 - адрес влияющий на коэффициент счётчика
                                        ; Выход: C - нет дисковода или диска в нём
                                        ;        R2 - счётчик, сколько прошло времени за один оборот диска
                bcs     21$             ; ошибка - возврат в меню
                cmp     R5, R2          ; Если результат закономерен - с ПЗУ было быстрее
                bhi     19$             ; то переход - всё стандартно
                mov     #OwnDrvBuf, RWSEC  ; иначе будет свой драйвер
                jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz <234>"Драйвер турбирован"<234><12><12>
                .even
                br      20$
; ───────────────────────────────────────────────────────────────────────────

19$:            mov     #160006, RWSEC  ; стандартный адрес

20$:            mov     (SP)+, @#4
                return                  ; идём выполнять подпрограмму команды
; ───────────────────────────────────────────────────────────────────────────

21$:            cmp     (SP)+, (SP)+
                return
; ───────────────────────────────────────────────────────────────────────────
CMDSUB:         .word CMD$F         ; таблица адресов подпрограмм команд
                .word CMD$V
                .word CMD$I
                .word CMD$D
                .word CMD$C
                .word CMD$M
                .word CMD$S
                .word CMD$E
CMDS:           .ascii "FVIDCMSE"   ; список клавиш команд
                ; 0 - конец списка и начало заголовков
CMDTitle:       .byte   0           ; таблица заголовков команд
                .asciz "  Форматирование диска  "
                .asciz "Контрольное чтение диска"
                .asciz "  Инициализация диска  "
                .asciz " Просмотр каталога диска "
                .asciz "Преобразование загрузчика"
                .asciz " Копирование загрузчика "
                .asciz "  Настройка параметров  "
                .even

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Форматирование диска

CMD$F:          jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz "Форматирование:"<12>
                .even

1$:             clrb    DRVTAB + D$SIDE ; номер стороны диска
                call    FormatTrk       ; Форматирование дорожки
                tstb    MAXSIDES        ; максимальный номер головки
                beq     2$
                incb    DRVTAB + D$SIDE ;номер стороны диска
                call    FormatTrk       ; Форматирование дорожки

2$:             incb    DRVTAB + D$TRK          ; номер дорожки
                cmpb    DRVTAB + D$TRK, MAXTRK  ; максимальный номер дорожки
                ble     1$
                jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz  <12>
                .even

                call    CMD$V           ; Проверка после форматирования
                call    CheckFmtRes     ; Проверка результатов форматирования
                                        ; Выход: C - были сбойные дорожки
                bcc     12$             ; Всё в порядке - идём дальше
                mov     #3, R1          ; количество попыток повторного форматирования

3$:             jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz <12><12>"Повторное форматирование:"<12>
                .even

                mov     #MapTrk, R4
                movb    MAXTRK, R2      ; максимальный номер дорожки
                inc     R2              ; пройдёмся по всем дорожкам
                clrb    DRVTAB + D$TRK  ; начнём с нулевой

4$:             clrb    DRVTAB + D$SIDE ; сперва сторону 0
                tstb    (R4)+           ; сбой был?
                beq     5$              ; нет - пропускаем
                call    FormatTrk       ; Форматирование дорожки

5$:             tstb    MAXSIDES        ; вторая сторона есть?
                beq     6$              ; нет
                incb    DRVTAB + D$SIDE ; теперь вторую сторону
                tstb    (R4)+           ; сбой был?
                beq     6$              ; нет - пропускаем
                call    FormatTrk       ; Форматирование дорожки

6$:             incb    DRVTAB + D$TRK  ; следующая дорожка
                sob     R2, 4$          ; и так все
                jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz <12>"Контрольное чтение:"<12>
                .even

                mov     #MapTrk, R4
                movb    MAXTRK, R2      ; максимальный номер дорожки
                inc     R2              ; пройдёмся по всем дорожкам
                clrb    DRVTAB + D$TRK  ; начнём с нулевой

7$:             clrb    DRVTAB + D$SIDE ; сперва сторону 0
                tstb    (R4)            ; сбой был?
                beq     8$              ; нет - пропускаем
                call    ControlRdTrk    ; Контрольное чтение дорожки
                                        ; Вход: R4 - адрес в таблице состояний дорожек
                br      9$
; ───────────────────────────────────────────────────────────────────────────

8$:             inc     R4              ; двигаем указатель

9$:             tstb    MAXSIDES        ; максимальный номер головки
                beq     11$             ; сторона одна - переход
                incb    DRVTAB + D$SIDE ; следующая сторона
                tstb    (R4)            ; сбой был?
                beq     10$             ; нет - пропускаем
                call    ControlRdTrk    ; Контрольное чтение дорожки
                                        ; Вход: R4 - адрес в таблице состояний дорожек
                br      11$
; ───────────────────────────────────────────────────────────────────────────

10$:            inc     R4              ; двигаем указатель

11$:            incb    DRVTAB + D$TRK  ; следующая дорожка
                sob     R2, 7$          ; и так все
                call    CheckFmtRes     ; Проверка результатов форматирования
                                        ; Выход: C - были сбойные дорожки
                bcc     12$
                dec     R1              ; следующая попытка
                bne     3$              ; пока не закончатся
                br      13$
; ───────────────────────────────────────────────────────────────────────────

12$:            jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz  <12>
                .even

                call    CMD$I           ; Инициализация диска
13$:            jmp     LOOP
; End of function CMD$F


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Проверка результатов форматирования
; Выход: C - были сбойные дорожки

CheckFmtRes:    movb    MAXTRK, R0      ; максимальный номер дорожки
                inc     R0
                tstb    MAXSIDES        ; максимальный номер головки
                beq     1$
                asl     R0

1$:             mov     #MapTrk, R4

2$:             tstb    (R4)+
                bne     4$
                sob     R0, 2$

3$:             return
; ───────────────────────────────────────────────────────────────────────────

4$:             sec
                br      3$
; End of function CheckFmtRes


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Инициализация диска

CMD$I:          jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz "Создание системной области"
                .even

                mov     #FAT1, R1
                mov     R1, R5
                mov     #5400, R2       ; чистим буфер

1$:             clr     (R1)+
                sob     R2, 1$
                mov     #TotalBlocks, R1 ; сформируем значение общего кол-ва блоков на диске
                clr     R2
                movb    MAXTRK, R0      ; максимальный номер дорожки
                inc     R0

2$:             add     #10., R2
                sob     R0, 2$
                movb    MAXSIDES, R0    ; максимальный номер головки
                beq     3$
                asl     R2

3$:             movb    R2, (R1)+
                swab    R2
                movb    R2, (R1)+
                inc     R0
                mov     R0, TotalHeads
                mov     #-7, (R5)+      ; формируем FAT
                movb    #-1, (R5)+
                mov     #FAT2, R5       ; и вторую копию
                mov     #-7, (R5)+
                movb    #-1, (R5)+
                movb    #3, Retries     ; будем пытаться 3 раза записать

4$:             clr     R0
                mov     #BootBlock, R2
                mov     #-6000, R1
                call    @DRIVER         ; Адрес входа "чтение/запись блока" драйвера НГМД
                bcc     5$              ; нормально - выходим
                call    PullHead        ; Передёрнуть головку
                bis     #300, (R3)      ; снова сойти с нулевой дорожки
                mov     (R3), (R4)
                decb    Retries         ; попытки кончились?
                bne     4$              ; нет - повторим
                call    OutErrorWrt     ; Вывод текстового сообщения об ошибке при записи

5$:             return
; End of function CMD$I


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Верификация диска

CMD$V:          jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz "Контрольное чтение:"<12>
                .even

                mov     #MapTrk, R4
                clrb    DRVTAB + D$TRK  ; начнём с нулевой дорожки

1$:             clrb    DRVTAB + D$SIDE ; сначала нулевую сторону
                call    ControlRdTrk    ; Контрольное чтение дорожки
                                        ; Вход: R4 - адрес в таблице состояний дорожек
                tstb    MAXSIDES        ; вторая сторона есть?
                beq     2$              ; нет
                incb    DRVTAB + D$SIDE ; да - тогда читаем
                call    ControlRdTrk    ; Контрольное чтение дорожки
                                        ; Вход: R4 - адрес в таблице состояний дорожек

2$:             incb    DRVTAB + D$TRK  ; следующую дорожку
                cmpb    DRVTAB + D$TRK, MAXTRK  ; максимальный номер дорожки
                ble     1$              ; и так пока всё не прочтём
                return
; End of function CMD$V


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Настройка параметров

CMD$S:          mov     #BlockTrapTo4, @#4
                jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz <12><12>
                .even

1$:             jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz "Количество дорожек (40-43,80-86)"
                .even

                mov     #MAXTRK, R5     ; максимальный номер дорожки
                incb    (R5)
                call    InpDecNum
                decb    (R5)
                decb    R2
                cmpb    R2, #39.
                blt     1$
                cmpb    R2, #85.
                bgt     1$
                cmpb    R2, #79.
                bge     2$
                cmpb    R2, #42.
                bgt     1$

2$:             movb    R2, (R5)

3$:             jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz "Количество сторон (1,2)"
                .even

                mov     #MAXSIDES, R5   ; максимальный номер головки
                incb    (R5)
                call    InpDecNum
                decb    (R5)
                decb    R2
                blt     3$
                clr     DRVTAB + D$FLGTAB
                cmpb    R2, #1
                bgt     3$
                movb    R2, (R5)
                bne     4$
                mov     #1002, DRVTAB + D$FLGTAB ;обрабатывать диск как односторонний

4$:             return
; End of function CMD$S


; ███████████████ S U B R O U T I N E ███████████████████████████████████████


BlockTrapTo4:   sub     (PC), (SP)
                rti
; End of function BlockTrapTo4


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Просмотр каталога диска

CMD$D:          movb    DEVICE, R5      ; сохраним текущее устройство (0-@:, 1-32 - A:-Z:)
                inc     R0
                movb    R0, DEVICE      ; зададим своё
                mov     #320, R1
                mov     #204, (R1)
                clr     6(R1)
                emt     36              ; выведем на экран каталог стандартными средствами
                movb    R5, DEVICE      ; восстановим текущее устройство
                return
; End of function CMD$D


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Преобразование загрузчика

CMD$C:          call    LoadBoot
                bcs     2$
                clr     @#177130
                mov     IOBUFF, R1      ; Адрес буфера ANDOS (125000)
                cmp     (R1), #240
                bne     1$
                mov     #20220, -(SP)
                mov     #753, -(SP)
                jsr     R5, OUTSI       ; Вывод инлайн строки
                .ascii <12>"Дискета, загружаемая на БК."<12>
                .asciz "Преобразовать в формат чтения БК и IBM (Д/Н)? "
                .even
                br      4$
; ───────────────────────────────────────────────────────────────────────────

1$:             jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz <12>"Дискета, читаемая на БК и IBM."<12>
                .even

                cmp     100(R1), #12706
                beq     3$
                jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz <12>"Отсутствует загрузчик, преобразование невозможно!"
                .even

                tst     (SP)+
2$:             return
; ───────────────────────────────────────────────────────────────────────────

3$:             mov     #436, -(SP)
                mov     #240, -(SP)
                jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz "Преобразовать в формат загрузки на БК (Д/Н)? "
                .even

4$:             call    CursorOff       ; Гашение курсора
                emt     6
                jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz <232>
                .even

                bisb    #340, R0
                cmpb    R0, #'Д
                beq     5$
                cmpb    R0, #'Н
                bne     4$
                emt     16
                cmp     (SP)+, (SP)+
                return
; ───────────────────────────────────────────────────────────────────────────

5$:             emt     16
                mov     (SP)+, (R1)+
                mov     (SP)+, (R1)+
                jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz <12><12>"Запись загрузчика"
                .even

                clr     R0
                mov     IOBUFF, R2
                mov     #-400, R1
                call    @DRIVER
                bcc     6$
                call    OutErrorWrt     ; Вывод текстового сообщения об ошибке при записи
                return
; ───────────────────────────────────────────────────────────────────────────

6$:             jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz <12><12>"Загрузчик преобразован"<12>
                .even
                return
; End of function CMD$C


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Копирование загрузчика

CMD$M:          call    LoadBoot
                bcs     2$
                mov     IOBUFF, R2
                cmp     (R2), #240
                bne     1$
                nop
                cmp     104(R2), #106406
                beq     3$

1$:             jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz <12>"Загрузчик отсутствует или не та версия загрузчика"
                .even

2$:             return
; ───────────────────────────────────────────────────────────────────────────

3$:             mov     #NewBootBlk, R1
                mov     #240, (R1)+
                mov     #436, (R1)+
                cmp     (R2)+, (R2)+
                mov     #376, R0

4$:             mov     (R2)+, (R1)+
                sob     R0, 4$

5$:             clr     @#177130
                jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz <12>"Установите целевой диск и в"
                .even

                clr     @#104
                call    AskDrive        ; Запрос имени привода
                                        ; Выход: R0 - номер привода 0-A: 1-B: 2-C: ...
                movb    R0, DRVTAB + D$UNIT
                jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz "Анализ диска"<12>
                .even

                call    Analyse
                bcs     2$
                mov     IOBUFF, R1
                cmp     (R1), #240
                bne     6$
                jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz <12>"На этом диске уже есть загрузчик"<12>
                .even
                br      5$
; ───────────────────────────────────────────────────────────────────────────

6$:             mov     #NewBootBlk + 4, R2
                cmp     (R1)+, (R1)+
                mov     #27, R0

7$:             movb    (R1)+, (R2)+
                sob     R0, 7$
                clr     -(SP)
                mov     #324, R3
                decb    -(R1)
                bne     8$
                asr     R3
                mov     #1002, (SP)

8$:             mov     (SP), NewBootBlk + 1000 - 2
                beq     9$
                mov     #40000, (SP)

9$:             bis     #36, (SP)
                cmp     SIZE, R3        ; Общее количество кластеров на диске. Определяется
                                        ; подпрограммой INIDRV после считывания таблицы
                                        ; параметров из загрузчика
                blo     10$
                bis     #100074, (SP)

10$:            mov     #NAMBUF+13, R1
                mov     #StrAndosSys+13, R2

11$:            movb    -(R2), -(R1)
                cmp     R1, #NAMBUF
                bne     11$
                call    @FIND           ; Поиск файла в каталоге с выдачей сообщения
                                        ; Параметры: Имя в NAMBUF
                                        ;            R3 - Адрес блока параметров EMT36 (для файлера)
                                        ; Результат: R2 - Адрес начала элемента (бит "C" - файла нет),
                                        ;            R0 - Номер блока в буфере (блок каталога).
                                        ; Портит:    R0, R1, R2, R5
                cmp     34(R2), #134000 ; размер файла
                beq     14$

12$:            jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz  <12>"ANDOS.SYS испорчен, или не та версия"
                .even

13$:            tst     (SP)+
                return
; ───────────────────────────────────────────────────────────────────────────

14$:            mov     32(R2), R2      ; номер начального кластера
                cmp     R2, #2
                beq     16$

15$:            jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz <12>"ANDOS.SYS фрагментирован или находится не в начале диска"
                .even
                br      13$
; ───────────────────────────────────────────────────────────────────────────

16$:            call    @RDFAT          ; Чтение FAT с диска
                mov     #26, R1

17$:            mov     R2, R0
                inc     R2
                call    @GETFAT         ; Распаковка ячейки FAT
                                        ; Параметры: R0 - Номер ячейки FAT
                                        ; Результат: R0 - Содержимое ячейки
                cmp     R2, R0
                bne     15$
                sob     R1, 17$
                mov     #34, R0
                mov     #NewBootBlk + 1000, R2
                mov     #400, R1
                call    @RWBLOK
                cmp     170(R2), VERS
                bne     12$
                mov     (SP), 10(R2)
                mov     (SP)+, 16(R2)
                jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz <12>"Сохранение параметров и запись загрузчика"<12>
                .even
; ───────────────────────────────────────────────────────────────────────────
                neg     R1
                call    @RWBLOK
                clr     R0
                mov     #NewBootBlk, R2
                call    @RWBLOK
                jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz <12><234>"Новый системный диск готов"<234>
                .even
                return
; End of function CMD$M

; ───────────────────────────────────────────────────────────────────────────
StrAndosSys:    .asciz "ANDOS   SYS"
                .even

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Выход

CMD$E:          movb    BRETRY, DRVTAB + D$BRETRY  ; количество повторов при ошибке
                jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz <22>
                .even
                mov     #32, R1

1$:             jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz <32>
                .even
                sob     R1, 1$
                emt     130             ; выходим в оболочку
; End of function CMD$E


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Форматирование дорожки

FormatTrk:      call    OutCurrTrkNum   ; Вывод текущего номера дорожки
                call    CheckOwnDrv     ; Проверка, на месте ли свой драйвер
                jsr     R4, @#Push4
                mov     RWSEC, R5       ; адрес адреса п/п чтения записи по номеру сектора
                cmp     (R5)+, (R5)+    ; переходим к драйверу форматирования
                call    (R5)            ; вызываем форматирование дорожки
                jsr     R4, @#Pop4
                bcc     1$              ; если всё нормально - выходим
                mov     #LOOP, (SP)     ; иначе - заменяем адрес возврата выходом в начало меню
                jmp     OutErrorWrt     ; Вывод текстового сообщения об ошибке при записи
; ───────────────────────────────────────────────────────────────────────────

1$:             return
; End of function FormatTrk


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Контрольное чтение дорожки
; Вход: R4 - адрес в таблице состояний дорожек

ControlRdTrk:   call    CheckOwnDrv     ; Проверка, на месте ли свой драйвер
                call    OutCurrTrkNum   ; Вывод текущего номера дорожки
                clrb    (R4)            ; очищаем статус дорожки
                call    ReadTrk         ; Чтение текущей дорожки
                                        ; Выход: Z - ошибка 3,6,7
                                        ;        С - любая ошибка
                bcc     3$              ; без ошибок - выходим
                beq     1$              ; ошибки 3,6,7 - плохо
                jsr     R5, OUTSI       ; остальные ошибки - попробуем повторить
                .asciz " ?"<10><10>
                .even

                call    PullHead        ; Передёрнуть головку
                call    ReadTrk         ; Чтение текущей дорожки
                                        ; Выход: Z - ошибка 3,6,7
                                        ;        С - любая ошибка
                bcc     2$

1$:             call    OutError        ; Вывод текстового сообщения об ошибке при чтении
                sec

2$:             jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz "  "<10><10>
                .even

3$:             adcb    (R4)+           ; Зафиксируем статус чтения
                return
; End of function ControlRdTrk


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Чтение текущей дорожки
; Выход: Z - ошибка 3,6,7
;        С - любая ошибка

ReadTrk:        mov     #TrackBuffer, D$ADDR(R3)  ; адрес начала массива данных в ОЗУ (обязательно чётный)
                mov     #5000, D$WCNT(R3)   ; количество слов для пересылки
                movb    #1, D$SECTOR(R3)    ; D$SECTOR - номер сектора 1..MAXSEC
                jsr     R4, @#Push4
                call    @RWSEC          ; адрес адреса п/п чтения записи по номеру сектора
                jsr     R4, @#Pop4
                bcc     3$              ; ошибок нет - отлично
                movb    @#ERRFDD, R5    ; берём код ошибки
                sub     #3, R5          ; Это ошибка 3?
                beq     1$              ; да
                sub     #3, R5          ; это ошибка 6?
                beq     1$              ; да
                dec     R5              ; это ошибка 7?
                bne     2$              ; нет

1$:             mov     #LOOP, 2(SP)
                sez

2$:             sec
3$:             return
; End of function ReadTrk


; ███████████████ S U B R O U T I N E ███████████████████████████████████████


PrepareExit:    mov     #ShellAddr, -(SP)  ; адрес перехода при выходе
                movb    BRETRY, DRVTAB + D$BRETRY  ; восстанавливаем значение
                br      PrepareWork     ; пойдём восстановим данные
; End of function PrepareExit


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Проверка, на месте ли свой драйвер

CheckOwnDrv:    cmp     RWSEC, #160006  ; используем стандартный драйвер?
                beq     100$            ; да - выходим
                tstb    XchgFlag        ; а нестандартный на своём месте?
                bne     100$            ; да - выходим,
; End of function CheckOwnDrv           ; иначе - размещаем на нужном месте


; ███████████████ S U B R O U T I N E ███████████████████████████████████████


PrepareWork:    mov     @#4, -(SP)
                mov     #BlockTrapTo4, @#4
                comb    XchgFlag        ; Флаг, что данные заменены
                mov     #C$ENDDRV - C$DRV, R0
                asr     R0
                mov     #C$DRV, R1
                mov     #OwnDrvBuf, R2
                call    XchgMem         ; Обмен массивами данных.
                                        ; Вход: R1 - Откуда
                                        ;       R2 - Куда
                                        ;       R0 - Размер в словах
                mov     #ShellAddr, R1
                mov     #SafeExit, R2
                tst     (R0)+
                call    XchgMem         ; Обмен массивами данных.
                                        ; Вход: R1 - Откуда
                                        ;       R2 - Куда
                                        ;       R0 - Размер в словах
                mov     (SP)+, @#4
100$:           return
; End of function PrepareWork


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Обмен массивами данных.
; Вход: R1 - Откуда
;       R2 - Куда
;       R0 - Размер в словах

XchgMem:        mov     (R2), -(SP)
                mov     (R1), (R2)+
                mov     (SP)+, (R1)+
                sob     R0, XchgMem
                return
; End of function XchgMem


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Передёрнуть головку

PullHead:       mov     (R3), R5        ; берём содержимое регистра 177130
                bis     #300, R5        ; устанавливаем ШАГ и К центру
                mov     R5, @#177130    ; шагаем
                mov     #30000, R0      ; пауза

                sob     R0, .
                bic     #100, R5        ; сбрасываем направление шага
                mov     R5, @#177130    ; возвращаемся на место
                mov     D$TSTEP(R3), R0 ; задержка перехода с дорожки на дорожку

                sob     R0, .
                return
; End of function PullHead


; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; Ввод нового значения
; Вход: R5 - адрес значения
; Выход: R2 - новое значение

InpDecNum:      call    OutNumber       ; сперва выведем предыдущее значение
                call    CursorOff       ; Гашение курсора
                clr     R1

1$:             emt     6
                cmpb    #12, R0         ; конец ввода
                beq     3$
                cmpb    #30, R0         ; забой
                bne     2$
                tst     R1
                beq     1$
                emt     16
                dec     R1
                tst     (SP)+
                br      1$
; ───────────────────────────────────────────────────────────────────────────

2$:             cmpb    R0, #'0
                blo     1$
                cmpb    R0, #'9
                bhi     1$
                cmp     R1, #2
                bge     1$
                emt     16
                sub     #'0, R0
                mov     R0, -(SP)
                inc     R1
                br      1$
; ───────────────────────────────────────────────────────────────────────────

3$:             tst     R1              ; если ничего не ввели
                beq     6$              ; то переход
                mov     (SP)+, R2
                dec     R1
                beq     5$
                mov     (SP)+, R0
                beq     5$

4$:             add     #10., R2
                sob     R0, 4$

5$:             jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz <232><12>
                .even
                return
; ───────────────────────────────────────────────────────────────────────────

6$:             movb    (R5), R2        ; просто возьмём старое значение
                br      5$
; End of function InpDecNum


; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; Вывод предыдущего значения
; Вход: R5 - адрес значения

OutNumber:      jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz " ["
                .even

                movb    (R5), R2
                call    OutDec          ; Вход: R2 - число
                jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz "] :"
                .even

                return
; End of function OutNumber


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Вывод текстового сообщения об ошибке при записи

OutErrorWrt:    cmpb    @#ERRFDD, #1
                bne     OutError        ; Вывод текстового сообщения об ошибке при чтении
                jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz " - Диск защищен"<12>
                .even
                return
; End of function OutErrorWrt


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Вывод текстового сообщения об ошибке при чтении

OutError:       jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz " - "
                .even

                jsr     R4, @#Push4
                movb    @#ERRFDD, R2
                mov     #StrErrors, R1

1$:             tstb    (R1)+
                bne     1$
                sob     R2, 1$
                emt     20
                mov     #12, R0
                emt     16
                jsr     R4, @#Pop4
                return
; End of function OutError

; ───────────────────────────────────────────────────────────────────────────
StrErrors:      .byte 0
                .asciz "Ошибка контрольной суммы"
                .asciz "Ошибка в заголовке сектора"
                .asciz "Нет сигнала 0 дорожки"
                .asciz "Ошибка позиционирования"
                .asciz "Не найден сектор"
                .asciz "Дисковод открыт или нет диска"
                .asciz "Останов по клавише СТОП"
                .asciz "Не найден адресный маркер"
                .asciz "Не найден маркер данных"
                .asciz "Недопустимый формат диска"
                .asciz "Ошибка имени Саяпина"
                .even

; ███████████████ S U B R O U T I N E ███████████████████████████████████████


LoadBoot:       jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz "Чтение загрузчика"<12>
                .even
; End of function LoadBoot


; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; анализ диска

Analyse:        movb    DRVTAB + D$UNIT, DEVTEK
                incb    DEVTEK
                call    @INIDRV
                bcs     1$
                mov     IOBUFF, -(SP)
                add     #32, (SP)
                incb    @(SP)+
                br      2$
; ───────────────────────────────────────────────────────────────────────────

1$:             jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz "Диск не в формате ANDOS"
                .even

                sec
2$:             return
; End of function Analyse


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Запрос имени привода
; Выход: R0 - номер привода 0-A: 1-B: 2-C: ...

AskDrive:       jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz "ведите имя дисковода [A - x]: "<232>
                .even
                nop

1$:             emt     6
                bic     #177600, R0
                cmpb    R0, #'A
                blo     1$
                nop
                nop
                nop
                jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz <232>
                .even

                emt     16
                jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz ":"<12><12>
                .even

                sub     #'A, R0
                return
; End of function AskDrive


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Вывод инлайн строки

OUTSI:          mov     R0, -(SP)

1$:             movb    (R5)+, R0
                beq     2$
                emt     16
                br      1$
; ───────────────────────────────────────────────────────────────────────────

2$:             inc     R5
                bic     #1, R5
                mov     (SP)+, R0
                rts     R5
; End of function OUTSI


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Вывод текущего номера дорожки

OutCurrTrkNum:  jsr     R4, @#Push4
                jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz <32><12>" "
                .even

                movb    DRVTAB + D$TRK, R2  ; номер дорожки
                call    OutDec          ; Вход: R2 - число
                tstb    DRVTAB + D$SIDE ; номер стороны диска
                bne     1$              ; не нулевая
                jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz  <255>           ; символ стрелка вниз
                .even
                br      2$
; ───────────────────────────────────────────────────────────────────────────

1$:             jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz  <263>           ; символ стрелка вверх
                .even

2$:             jsr     R4, @#Pop4
                return
; End of function OutCurrTrkNum


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Вход: R2 - число

OutDec:         mov     PC, R1
                mov     #4, R3

1$:             mov     #'0, R0

2$:             cmp     R2, DecConst(R3)
                blt     3$
                inc     R0
                sub     DecConst(R3), R2
                br      2$
; ───────────────────────────────────────────────────────────────────────────

3$:             cmp     #'0, R0
                bne     4$
                tst     R1
                beq     5$
                tst     R3
                bne     6$

4$:             clr     R1
5$:             emt     16

6$:             tst     R3
                beq     7$
                tst     -(R3)
                br      1$
; ───────────────────────────────────────────────────────────────────────────

7$:             return
; End of function OutDec

; ───────────────────────────────────────────────────────────────────────────
DecConst:       .word 1
                .word 10.
                .word 100.

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Гашение курсора

CursorOff:      tstb    @#56            ; курсор погашен?
                beq     1$              ; да
                jsr     R5, OUTSI       ; Вывод инлайн строки
                .asciz <232>            ; гасим
                .even

1$:             return
; End of function CursorOff


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Проверка привода.
; Вход:  R0 - адрес влияющий на коэффициент счётчика
; Выход: C - нет дисковода или диска в нём
;        R2 - счётчик, сколько прошло времени за один оборот диска

CheckFDD:       clr     R2
                clr     R1

1$:             tst     (R4)            ; ждём индексного отверстия
                bmi     3$              ; появилось
                sob     R1, 1$          ; ждём

2$:             jsr     R5, OUTSI       ; так и не дождались
                .asciz "Дисковод открыт или не подключен"<12>
                .even
                br      5$
; ───────────────────────────────────────────────────────────────────────────

3$:             mov     #2000, R1

4$:             tst     (R4)            ; ждём, когда пропадёт
                bpl     6$              ; пропало
                sob     R1, 4$          ; ждём
                jsr     R5, OUTSI       ; так и не дождались
                .asciz "В дисководе нет диска"<12>
                .even

5$:             sec
                return
; ───────────────────────────────────────────────────────────────────────────

6$:             cmp     (R0), (R0)      ; задержка
                inc     R2              ; счётчик
                bmi     2$              ; слишком много - ошибка
                tst     (R4)            ; индексное отверстие появилось?
                bpl     6$              ; нет ещё - считаем
                add     #20, R2         ; округляем
                bic     #37, R2
                clc
                return
; End of function CheckFDD

; ───────────────────────────────────────────────────────────────────────────

KeyVec:         jsr     R4, @#Push4
                mov     R5, -(SP)
                call    @#102044
                jmp     @#101316
; ───────────────────────────────────────────────────────────────────────────
RWSEC:          .word 0                 ; адрес адреса п/п чтения записи по номеру сектора
; ───────────────────────────────────────────────────────────────────────────

SafeExit:       jmp     @#PrepareExit
; ───────────────────────────────────────────────────────────────────────────
MAXTRK:         .byte 79.               ; максимальный номер дорожки
MAXSIDES:       .byte 1                 ; максимальный номер головки
Retries:        .byte 0                 ; количество повторов записи системной области
XchgFlag:       .byte 0                 ; Флаг, что данные заменены
BRETRY:         .byte 10.               ; буфер хранения количества повторов при ошибке
                .even

; Карта сбойных дорожек
MapTrk:         .blkb   168.

; ───────────────────────────────────────────────────────────────────────────
; Свой драйвер форматирования и чтения/записи данных по номеру сектора
C$DRV:

;  SUBRW: П/п чтения-записи по номеру сектора
; Входные параметры:
; R3 - базовый адрес рабочей области драйвера
; ADDR - начальный адрес массива в словах
; WCNT - длина пересылаемого массива в словах (>0 - чтение <0 - запись)
; SIDE - номер стороны (0-нижняя, 1- верхняя)
; TRK - номер должки
; UNIT - номер привода (0 - А)
; SECTOR - номер сектора (1-10.)
C$SUBRW1:       jmp     C$SUBRW

; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; П/п форматирования

C$FORMAT:
                mov     SP, D$BUFSP(R3)     ; Сохраним SP,
                mfps    D$BUFPSW(R3)        ;    PSW,
                mov     #4, R0
                mov     (R0), D$BUF4(R3)    ;  @#4 в соответствующих буферах
                mov     PC, (R0)            ; Переназначаем вектор @#4 на себя,
                add     #VECT4-., (R0)      ;    теперь он равен VECT4
                call    C$ENGINE            ; Запустим двигатель
                call    C$GOTRK             ; Позиционируем на нужную дорожку
                call    C$CORR              ; Установим прекоррекцию
                bit     #4, (R4)            ; Защита записи включена?
                beq     1$                  ; Нет - начинаем форматировать
                mov     #1, R0              ; Да - ошибка 1

2$:             jmp     C$ERROR             ; Выходим с ошибкой
; ───────────────────────────────────────────────────────────────────────────

1$:             swab    D$SIDE(R3)          ; Обмениваем номера стороны и дорожки
                movb    D$FILLB(R3), D$WRTVAR(R3)   ; Делаем слово-заполнитель
                movb    D$FILLB(R3), D$WRTVAR+1(R3) ;    из байта-заполнителя
                movb    D$MAXSEC(R3), R1    ; Получим длину сектора
                mov     #1001, R2           ; Запомним номер сектора и код длины
                mov     #1000., R0          ; Время ожидания индекса

3$:             tst     (R4)                ; Индекс есть?
                bpl     4$                  ; Исчез - начинаем записывать
                sob     R0, 3$              ; Есть - ждём исчезновения

5$:             tst     (R5)                ; Так и не исчез - прекратим запись
                mov     #6, R0              ; Диск не вращается - ошибка 6
                swab    D$SIDE(R3)          ; Вернём всё на место
                br      2$                  ; Выходим с ошибкой
; ───────────────────────────────────────────────────────────────────────────
; Запись на дорожку кода 4E4E
4$:             mov     #6200, R0           ; Установим максимальную длину
                mtps    #340                ; При записи нам не мешать
                mov     #47116, (R5)        ; Записываем 4E4E

6$:             tst     (R4)                ; Индекс появился?
                bmi     7$                  ; Да - начинаем запись

8$:             tstb    (R4)                ; Готовность есть?
                bpl     8$                  ; Нет - ждём
                mov     #47116, (R5)        ; Записываем 4E4E
                sob     R0, 6$              ; И так до конца дорожки
                br      5$                  ; Дорожка длинная, ошибка!
; ───────────────────────────────────────────────────────────────────────────

7$:             mov     #16., R0            ; В маркере будет 16. 4E4E (GAP1)
                mov     #177241, D$MARKER(R3)   ; Адресный маркер (FEA1) - в буфер

9$:             call    C$WRMAR             ; WRMAR: Записываем адресный маркер

10$:            tstb    (R4)                ; Готовность есть?
                bpl     10$                 ; Нет - ожидаем
                mov     D$SIDE(R3), (R5)    ; Записываем номер стороны и дорожки
                mov     (R3), (R4)          ; Перешлём управляющее слово

11$:            tstb    (R4)                ; Готовность есть?
                bpl     11$                 ; Нет - дождёмся
                mov     R2, (R5)            ; Записываем номер сектора и код длины
                mov     #13, R0             ; В маркере будет 11. 4E4E (GAP2)
                mov     #175641, D$MARKER(R3)   ; Маркер данных (FBA1) - в буфер

12$:            bit     #40000, (R4)        ; Ждём записи CRC
                beq     12$
                call    C$WRMAR             ; WRMAR: Записываем маркер данных
                mov     D$SECLEN(R3), R0    ; Получаем длину сектора
                dec     R0                  ; Одно слово запишем сейчас

13$:            tstb    (R4)                ; Готовность есть?
                bpl     13$                 ; Нет - ожидаем
                mov     D$WRTVAR(R3), (R5)  ; Записываем заполнитель
                mov     (R3), (R4)          ; Перешлём управляющее слово

14$:            tstb    (R4)                ; Готовность есть?
                bpl     14$                 ; Нет - дождёмся
                mov     D$WRTVAR(R3), (R5)  ; Записываем заполнитель
                sob     R0, 14$             ; И так до конца сектора
                inc     R2                  ; Увеличим номер сектора
                mov     #21., R0            ; В маркере будет 21. 4E4E (GAP3)
;    Примечание. Если увеличить GAP3 до 24-27 слов, то запись будет производиться так
; же быстро, как и чтение (обычно заголовок очередного сектора проскакивает, и дорожка
; записывается не за один, а за 10 оборотов). Однако при превышении этой величиной
; определённого значения конец последнего сектора дорожки может наложиться на ее
; же начало.
                bit     #4, @D$FLGPTR(R3)   ; Сектора длинные?
                beq     15$                 ; Нет - все нормально
                mov     #61., R0            ; Да - будет 61. 4E4E (можно увеличить до 75)

15$:            mov     #177241, D$MARKER(R3)   ; Адресный маркер (FEA1) - в буфер

16$:            bit     #40000, (R4)        ; Ждём записи CRC
                beq     16$
                sob     R1, 9$              ; И так все сектора до конца дорожки
; Окончание записи дорожки
17$:            tstb    (R4)                ; Готовность есть?
                bpl     17$                 ; Нет - ждём
                mov     #47116, (R5)        ; Запишем 4E4E
                tst     (R4)                ; Индекс есть?
                bpl     17$                 ; Нет - продолжим запись до появления

18$:            tstb    (R4)                ; Готовность есть?
                bpl     18$                 ; Нет - дождёмся
                mov     #47116, (R5)        ; Запишем 4E4E
                tst     (R5)                ; Прекратим запись
                mtps    D$BUFPSW(R3)        ; Восстановим PSW
                swab    D$SIDE(R3)          ; Вернём все на место
                jmp     C$EXIT              ; EXIT: Выходим
; End of function C$FORMAT


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

;  SUBRW: П/п чтения-записи по номеру сектора
; Входные параметры:
; R3 - базовый адрес рабочей области драйвера
; ADDR - начальный адрес массива в словах
; WCNT - длина пересылаемого массива в словах (>0 - чтение <0 - запись)
; SIDE - номер стороны (0-нижняя, 1- верхняя)
; TRK - номер должки
; UNIT - номер привода (0 - А)
; SECTOR - номер сектора (1-10.)

C$SUBRW:        mov     SP, D$BUFSP(R3)     ; Сохраняем SP,
                mfps    D$BUFPSW(R3)        ;    PSW,
                mov     #4, R0
                mov     (R0), D$BUF4(R3)    ;    @#4 в соответствующих буферах
                mov     PC, (R0)            ; Переназначаем вектор @#4 на себя,
                add     #VECT4-., (R0)      ;    теперь он равен VECT4
                tstb    D$SECTOR(R3)        ; Какой сектор нужен?
                beq     C$ERR12             ; Нулевых у нас нет, ошибка 12
                cmpb    D$SECTOR(R3), D$MAXSEC(R3)  ; Сектор больше максимального?
                bgt     C$ERR12             ; Таких тоже нет, ошибка 12
                clrb    @#ERRFDD            ; Пока ошибок нет
                bicb    #30, D$FLAGS(R3)    ; Пока не записываем
                tst     D$WCNT(R3)          ; Сколько слов будем пересылать?
                beq     C$QUIT              ; 0 - ничего делать не надо, выход
                bpl     C$READ              ; больше 0 - будем читать
; П/п записи массива
                neg     D$WCNT(R3)          ; Нормализуем длину
                bisb    #20, D$FLAGS(R3)    ; Установим признак записи
                mov     #175641, D$MARKER(R3)   ; Запомним маркер данных
                bitb    #1, D$FLAGS(R3)     ; Записываем скрытно?
                beq     1$                  ; Нет - идём дальше
                mov     #174241, D$MARKER(R3)   ; Да - запомним специальный маркер

1$:             call    C$ENGINE            ; ENGINE: Включим двигатель, запомним привод
                bit     #4, (R4)            ; Защита записи есть?
                beq     C$MAIN              ; Нет - продолжить работу
                mov     #1, R0              ; Есть - ошибка 1
                br      C$ERR
; ───────────────────────────────────────────────────────────────────────────
; READ: П/п чтения массива
C$READ:         call    C$ENGINE            ; ENGINE: Включим двигатель, запомним привод
                mov     #400, D$SECLEN(R3)  ; Сектора стандартной длины
                bitb    #4, @D$FLGPTR(R3)   ; А они ли нам нужны?
                beq     C$MAIN              ; Да - продолжить работу
                mov     #1000, D$SECLEN(R3) ; Нет - сектора удвоенной длины
; MAIN: Основная часть п/п чтения/записи массива
C$MAIN:         call    C$GOTRK             ; GOTRK: Позиционируем на нужную дорожку
                call    C$CORR              ; CORR: Включим схему предкоррекции
                movb    D$BRETRY(R3), D$CRETRY(R3)  ; Число попыток - в буфер
; Получение заголовка сектора
                movb    #10, D$ERRNUM(R3)   ; Предполагаем ошибку 10
                movb    #20., D$TURNS(R3)   ; На операцию отводим 20. оборотов

1$:             call    C$FINDH             ; FINDH: Найдём маркер заголовка
                bcc     2$                  ; Нашли - идём дальше

3$:             movb    D$ERRNUM(R3), R0    ; Не нашли - выходим с ошибкой
                br      C$ERR
; ───────────────────────────────────────────────────────────────────────────

2$:             tstb    (R4)                ; Информация получена?
                bpl     2$                  ; Нет - подождём
                mov     (R5), R0            ; Теперь прочитаем её

4$:             tstb    (R4)                ; Хотим ещё информации!
                bpl     4$                  ; Дождёмся её появления
                mov     (R5), R1            ;    и заберём её
                call    C$TSTCRC            ; TSTCRC: Проверим CRC
                bne     5$                  ; Ошибки нет - идём дальше
                movb    #2, D$ERRNUM(R3)    ; Ошибка 2!
                decb    D$CRETRY(R3)        ; Остались ещё попытки?
                bne     1$                  ; Да - повторим чтение
                br      3$                  ; Видно, не судьба! Выходим с ошибкой
; ───────────────────────────────────────────────────────────────────────────

5$:             bic     #177774, R1         ; Выделяем код длины сектора
                bitb    #4, @D$FLGPTR(R3)   ; Какие сектора нам были нужны?
                bne     C$LONG              ; LONG: Длинные - посмотрим...
                cmpb    R1, #2              ; Короткие. А на диске какие?
                beq     C$WORK              ; WORK: Тоже короткие. Порядок, идём дальше
                decb    D$CRETRY(R3)        ; Как там дела с попытками?
                bne     1$                  ; Есть ещё - повторим все сначала
; ERR12: Выход с ошибкой
C$ERR12:        mov     #12, R0             ; Выходим с ошибкой 12
C$ERR:          jmp     C$ERROR             ; ERROR: Идём на обработку и выход
; ───────────────────────────────────────────────────────────────────────────

C$QUIT:         jmp     C$EXIT              ; EXIT: Идём на нормальный выход
; ───────────────────────────────────────────────────────────────────────────

C$LONG:         cmpb    R1, #2              ; Нужны длинные сектора, а какие здесь?
;    ОШИБКА: На самом деле код длинных секторов (1024 байта на сектор) - 3, а не 2
; вот сколько прошивок ни посмотрел, везде так. никто это не исправляет, значит это не ошибка,
; а фича такая - принципиальная неподдерживаемость длинных секторов
                bne     C$ERR12             ; ERR12: Длинные - выходим с ошибкой 12
; WORK: Собственно п/п чтения
C$WORK:         movb    D$BRETRY(R3), D$CRETRY(R3)  ; Восстановим счётчик по BRETRY
                movb    #6, D$SECRET(R3)    ; На поиск сектора - 6 попыток
                clr     D$FREE(R3)          ; Остаток сектора отсутствует
                cmp     D$WCNT(R3), D$SECLEN(R3)    ; Читать нужно больше одного сектора?
                bhi     1$                  ; Да - идём читать
                mov     D$SECLEN(R3), D$FREE(R3)
                sub     D$WCNT(R3), D$FREE(R3)  ; Вычислим длину остатка

1$:             movb    #5, D$ERRNUM(R3)    ; Прогнозируем ошибку 5

2$:             movb    #20., D$TURNS(R3)   ; На операцию отводим 20. оборотов

3$:             call    C$FINDH             ; FINDH: Ищем маркер заголовка
                bcc     4$                  ; Нашли - идём дальше
                movb    D$ERRNUM(R3), R0    ; Кончились обороты - выходим
                br      C$ERR               ;    с ошибкой
; ───────────────────────────────────────────────────────────────────────────

4$:             tstb    (R4)                ; Готовность данных есть?
                bpl     4$                  ; Нет - подождём
                cmp     D$SIDE(R3), (R5)    ; Нужная дорожка и сторона?
                beq     5$                  ; Да - идём дальше
                decb    D$SECRET(R3)        ; Минус одна попытка
                beq     6$                  ; Кончились - выход с ошибкой
                call    C$GOTO00            ; GOTO00: Позиционируем на дорожку 00,
                call    C$GOTRK             ; GOTRK:  вернёмся на нужную
                br      3$                  ;    и попытаемся ещё раз
; ───────────────────────────────────────────────────────────────────────────

6$:             mov     #4, R0              ; Выходим с ошибкой 4
                br      C$ERR               ; ERR
; ───────────────────────────────────────────────────────────────────────────

5$:             tstb    (R4)                ; Ждём готовности данных
                bpl     5$                  ; Не готовы - повторять...
                mov     (R5), R1            ; Получим номер сектора
                swab    R1                  ;    поместим его в младший байт
                cmpb    D$SECTOR(R3), R1    ; Этот сектор ищем?
                beq     7$                  ; Да - будем его читать
                mov     D$SECLEN(R3), R0    ; Нет - возьмём длину данных,
                add     #27, R0             ;    прибавим длину заголовка
                call    C$FICT              ; FICT:   и пропустим их
                br      3$                  ; Повторим процедуру ещё раз
; ───────────────────────────────────────────────────────────────────────────

7$:             call    C$TSTCRC            ; TSTCRC: Проверим CRC
                bne     8$                  ; Совпала - идём дальше
                movb    #2, D$ERRNUM(R3)    ; Если что, это будет ошибка 2
                decb    D$CRETRY(R3)        ; Одной попыткой меньше
                bne     2$                  ; Ещё остались - поищем снова
                movb    D$ERRNUM(R3), R0    ; Нет - выходим с ошибкой
                br      C$ERROR
; ───────────────────────────────────────────────────────────────────────────

8$:             mov     D$SECLEN(R3), R1    ; Получим длину сектора
                sub     D$FREE(R3), R1      ; Вычислим длину используемой части
; Чтение сектора
                bitb    #20, D$FLAGS(R3)    ; Будем записывать?
                beq     9$                  ; Нет - значит, читать
                jmp     C$WRSEC             ; Да - идём на запись сектора
; ───────────────────────────────────────────────────────────────────────────

9$:             call    C$FINDS             ; FINDS: Ищем зону синхронизации
                tstb    D$SECRET(R3)        ; Нашли?
                beq     10$                 ; Нет - пробуем снова
                call    C$STREAD            ; STREAD: Начинаем чтение!
                mov     #600., R0

12$:            tstb    (R4)                ; Данные готовы?
                bmi     11$                 ; Да - посмотрим их
                sob     R0, 12$             ; Больше ждать нельзя?

10$:            movb    #11, D$ERRNUM(R3)   ; Да - прогнозируем ошибку 11
                decb    D$CRETRY(R3)        ; Одной попыткой меньше
                bne     2$                  ; Попытки есть - повторим операцию
                movb    D$ERRNUM(R3), R0    ; Кончились - выйдем с ошибкой
                br      C$ERROR
; ───────────────────────────────────────────────────────────────────────────

11$:            tst     (R5)                ; Пропустим маркер A1A1

13$:            tstb    (R4)                ; Готовность данных есть?
                bpl     13$                 ; Нет - ждём
                mov     (R5), R0            ; Прочитаем данные
                cmp     #120773, R0         ; Обычный сектор?
                beq     14$                 ; Да - идём дальше
                cmp     #120770, R0         ; Скрытый сектор?
                bne     10$                 ; Что-то иное - ошибка
                bitb    #1, D$FLAGS(R3)     ; Можно читать скрытые данные?
                bne     14$                 ; Да - будем читать
                mov     #13, R0             ; Нельзя - выходим с ошибкой 13
                br      C$ERROR
; ───────────────────────────────────────────────────────────────────────────

14$:            call    C$RDSEC             ; RDSEC: Прочитаем сектор
                call    C$TSTCRC            ; TSTCRC: Проверим CRC
                bne     C$NEXT              ; Совпала - посмотрим следующий сектор
                movb    #1, D$ERRNUM(R3)    ; Не совпала - ошибка 1
                decb    D$CRETRY(R3)        ; Попытки кончились?
                bne     2$                  ; Нет - попробуем ещё раз
                movb    D$ERRNUM(R3), R0    ; Кончились - выходим с ошибкой
                br      C$ERROR
; ───────────────────────────────────────────────────────────────────────────
; Мультисекторные операции
C$NEXT:         sub     D$SECLEN(R3), D$WCNT(R3)    ; Сектор обработали, вычтем из длины
                ble     C$EXIT              ; Массив кончился - выход
                incb    D$SECTOR(R3)        ; Нет - следующий сектор
                cmpb    D$SECTOR(R3), D$MAXSEC(R3)  ; Конец дорожки?
                blos    1$                  ; Нет - продолжим обработку
                bit     #40, (R3)           ; Верхняя сторона?
                bne     2$                  ; Да - следующая дорожка
                bitb    #2, @D$FLGPTR(R3)   ; Диск односторонний?
                bne     2$                  ; Да - продолжим обработку
                movb    #1, D$SIDE(R3)      ; Нет - установим верхнюю сторону
                bis     #40, (R3)
                br      3$                  ; Перейдём к обработке
; ───────────────────────────────────────────────────────────────────────────

2$:             incb    D$TRK(R3)           ; Следующая дорожка
                call    C$GOTRK             ; Позиционируем на неё
                clrb    D$SIDE(R3)          ; Установим нижнюю сторону
                bic     #40, (R3)

3$:             movb    #1, D$SECTOR(R3)    ; Теперь сектор будет первым
                call    C$CORR              ; Переключить предкоррекцию

1$:             add     D$SECLEN(R3), D$ADDR(R3)    ; Получим новый начальный адрес
                add     D$SECLEN(R3), D$ADDR(R3)
                jmp     C$WORK              ; WORK: Идём на чтение очередного сектора
; End of function C$SUBRW


; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; Обработка прерывания по вектору 4

VECT4:          tst     (R5)                ; Сбросить данные
                mov     #7, R0              ; Заносим код ошибки 7
; End of function VECT4


; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; ERROR: Выход с ошибкой

C$ERROR:        movb    R0, @#ERRFDD        ; Код ошибки - на место!
                movb    #1, D$SECRET(R3)    ; Установим бит C в буфере
                br      C$EXIT1             ; EXIT1: Идём на выход
; End of function C$ERROR


; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; EXIT: Выход без ошибки

C$EXIT:         clrb    D$SECRET(R3)        ; Сбросим бит C в буфере

C$EXIT1:        mov     D$BUF4(R3), @#4     ; Восстановить вектор 4
                mtps    D$BUFPSW(R3)        ; Восстановить PSW
                ccc                         ; Сбросить все признаки
                rorb    D$SECRET(R3)        ; Бит C - из буфера в PSW
                mov     D$BUFSP(R3), SP     ; Восстановить SP
                return                      ; Возврат
; End of function C$EXIT


; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; TSTCRC: П/п проверки CRC

C$TSTCRC:       tstb    (R4)                ; Ждем готовности данных
                bpl     C$TSTCRC
                mov     #15., R2            ; CRC появится не позже 15. циклов

1$:             bit     #40000, (R4)        ; CRC сошлась?
                bne     2$                  ; Да - выход
                sob     R2, 1$              ; Нет - очередной цикл

2$:             return                      ; Если бит Z=1, то произошла ошибка
; End of function C$TSTCRC


; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; RDSEC: П/п чтения сектора в буфер; R1 - число слов для пересылки

C$RDSEC:        mtps    #340                ; Маскируем прерывания
                mov     D$ADDR(R3), R2      ; Получим адрес буфера

1$:             tstb    (R4)                ; Ожидаем данные
                bpl     1$
                mov     (R5), R0            ; Читаем два байта,
                swab    R0                  ; делаем из них нормальное слово,
                mov     R0, (R2)+           ;    которое помещаем в буфер
                sob     R1, 1$              ; Читаем заказанное число слов
                mov     D$FREE(R3), R1      ; Получаем длину остатка
                beq     2$                  ; Остатка нет - сразу выходим

3$:             tstb    (R4)                ; Ждем данные
                bpl     3$
                tst     (R5)                ; Вхолостую читаем остаток
                sob     R1, 3$              ;    требуемой длины
                mtps    D$BUFPSW(R3)        ; Восстанавливаем PSW

2$:             return
; End of function C$RDSEC


; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; FINDS: П/п поиска синхропоследовательности

C$FINDS:        tst     (R5)                ; Сбрасываем прочитанное значение
                movb    #100., D$SECRET(R3) ; Будем искать 100. циклов

1$:             tstb    (R4)                ; Ждем готовности
                bpl     1$
                mov     (R5), R0            ; Получим прочитанные данные
                beq     2$                  ; Это 0 - на выход
                inc     R0                  ; Это 177777?
                beq     2$                  ; Да - на выход
                decb    D$SECRET(R3)        ; Циклы кончились?
                bne     1$                  ; Нет - повторяем поиск

2$:             return
; End of function C$FINDS


; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; STREAD: П/п запуска чтения

C$STREAD:       bis     #400, (R3)          ; Установим признак "начало чтения"
                mov     (R3), (R4)          ;    и запишем в регистр
                bic     #400, (R3)          ; Снимем признак
                mov     #10, R0

                sob     R0, .               ; Небольшая задержка...
                mov     (R3), (R4)          ;    и снова запишем в регистр
                return
; End of function C$STREAD


; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; FINDH: П/п поиска адресного маркера

C$FINDH:        mov     #15., R0

1$:             tst     (R5)                ; Вхолостую прочитаем
                sob     R0, 1$              ;    15. слов
                clr     D$INTIME(R3)        ; Начинаем ожидание индекса
                bicb    #40, D$FLAGS(R3)    ; Пока индекса нет

2$:             bitb    #10, @D$FLGPTR(R3)  ; Сектор задан задержкой?
                beq     5$                  ; Нет - обрабатывать
                cmpb    D$SECTOR(R3), #1    ; Да - нужен первый сектор?
                bne     5$                  ; Второй и далее задаются заголовками
                bis     #400, (R3)          ; Установим признак "начало чтения"
                mov     (R3), (R4)          ;    и запишем в регистр

3$:             tst     (R4)                ; Индекс есть?
                bmi     3$                  ; Да - ждём исчезновения

4$:             tst     (R4)                ; Индекса ещё нет?
                bpl     4$                  ; Да - ждать появления
                decb    D$TURNS(R3)         ; обороты не кончились?
                bne     16$                 ; нет ещё
                sec                         ; кончились - выходим с ошибкой
                br      6$
; ───────────────────────────────────────────────────────────────────────────

16$:            mov     D$HOLTIN(R3), R0    ; Задержимся...
                sob     R0, .
                br      17$                 ; и идём обрабатывать
; ───────────────────────────────────────────────────────────────────────────

5$:             call    C$INDEX             ; INDEX: Проверим наличие диска и обороты
                bcs     6$                  ; Обороты кончились - выходим
                beq     5$                  ; Какие данные? Нули пропустим
                com     R0                  ; 177777?
                beq     5$                  ; Да - тоже пропустим

7$:             call    C$INDEX             ; INDEX: Проверим наличие диска и обороты
                bcs     6$                  ; Обороты кончились - выходим
                beq     8$                  ; Какие данные? Нули - синхро
                com     R0                  ; 177777?
                bne     7$                  ; Нет - пропустим
; Проверка адресного маркера
8$:             mov     #3, R1

9$:             mov     (R5), R0            ; Читаем данные
                beq     10$                 ; Нули - продолжаем
                com     R0                  ; 177777?
                bne     5$                  ; Нет - повторяем поиск

10$:            sob     R1, 9$              ; Да - повторяем 3 раза

17$:            call    C$STREAD            ; STREAD: Запускаем на чтение
                mov     #74, R0             ; берём задержку

11$:            tstb    (R4)                ; Готовность есть?
                bmi     12$                 ; Есть - считываем данные
                sob     R0, 11$             ; Нет - ждём
                br      2$                  ; Надоело ждать - повторяем поиск
; ───────────────────────────────────────────────────────────────────────────

12$:            tst     (R5)                ; Пропускаем A1A1

13$:            tstb    (R4)                ; Ждём готовности
                bpl     13$
                mov     (R5), R0            ; Есть - берём данные
                cmp     #120776, R0         ; Адресный маркер (A1FE)?
                beq     14$                 ; Да - нормальный выход
                cmp     #120773, R0         ; Нет - маркер данных (A1FB)?
                beq     15$                 ; Да - пропускаем сектор
                cmp     #120770, R0         ; Нет - маркер скрытых данных (A1F8)?
                bne     2$                  ; Нет - повторяем поиск сначала

15$:            call    C$FRESEC            ; FRESEC: Да - пропускаем сектор
                br      2$                  ; Повторяем поиск сначала
; ───────────────────────────────────────────────────────────────────────────

14$:            clc
6$:             return
; End of function C$FINDH


; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; INDEX: П/п проверки диска и числа оборотов

C$INDEX:        tst     (R4)                ; Индекс есть?
                bpl     1$                  ; Нет - идём проверять
                bitb    #40, D$FLAGS(R3)    ; Индекс есть - он уже был?
                bne     2$                  ; Был - идём увеличивать время
                clr     D$INTIME(R3)        ; Только что появился - очистим время
                bisb    #40, D$FLAGS(R3)    ;    и запомним факт появления
                decb    D$TURNS(R3)         ; Закончился последний оборот?
                bne     3$                  ; Нет - нормальный выход
                sec                         ; Да - выход с ошибкой
                return
; ───────────────────────────────────────────────────────────────────────────

3$:             clc
                mov     (R5), R0            ; Забираем данные
                return
; ───────────────────────────────────────────────────────────────────────────

1$:             bitb    #40, D$FLAGS(R3)    ; Индекса нет - а он был?
                beq     2$                  ; Нет и не было - идём считать время
                clr     D$INTIME(R3)        ; Только что исчез - очистим время
                bicb    #40, D$FLAGS(R3)    ;    и запомним факт исчезновения
                br      3$                  ; Нормально выходим
; ───────────────────────────────────────────────────────────────────────────

2$:             inc     D$INTIME(R3)        ; Ещё один такт индекс не менялся
                cmp     D$INTIME(R3), #60000    ; Ну сколько можно! Пора кончать?
                blos    3$                  ; Не пора - нормальный выход
                mov     #6, R0              ; Терпение кончилось -
                jmp     C$ERROR             ; ERROR:   значит диска нет - ошибка 6
; End of function C$INDEX


; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; ENGINE: П/п выбора устройства

C$ENGINE:       mov     #177130, R4         ; Заполняем рабочие регистры
                mov     R4, R5              ;    адресами PC
                tst     (R5)+               ;    РД КНГМД
                bicb    #4, D$FLAGS(R3)     ; Очистим признак работы двигателя
                bit     #20, (R3)           ; Двигатель уже включён?
                beq     1$                  ; Нет - включим
                bisb    #4, D$FLAGS(R3)     ; Да - установим признак

1$:             bis     #20, (R3)           ; Включим двигатель
                mov     (R3), (R4)          ;    и запишем в регистр
                bic     #57, (R3)           ; Сбросим все другие регистры
                tstb    D$SIDE(R3)          ; Сторона верхняя?
                beq     2$                  ; Да - идём дальше
                bis     #40, (R3)           ; Нет - включим нижнюю

2$:             bicb    #177774, D$UNIT(R3) ; Сбросим лишние биты
                movb    D$UNIT(R3), R1      ; Получим номер привода
                mov     PC, R0              ; Получим базовый адрес
                add     #DMASK-., R0        ;    таблицы масок для приводов
                add     R1, R0              ; Получим адрес нужной маски
                bisb    (R0), (R3)          ; Установим бит нужного привода
                add     R3, R1              ; Получим базовый адрес
                add     #D$TRKTAB, R1       ;    таблицы TRKTAB
                mov     R1, D$CURTRK(R3)    ; Настроим указатель CURTRK
                call    C$SETPTR            ; SETPTR: Настроим указатель FLGPTR
                bitb    #4, D$FLAGS(R3)     ; Мотор включён только что?
                bne     3$                  ; Нет - выходим
                clr     R1                  ; Да - подождём раскручивания
                sob     R1, .
                sob     R1, .

3$:             mov     (R3), (R4)          ; Записываем установки в регистр
                mov     D$TDOWN(R3), R1     ; Подождём опускания головки
                sob     R1, .
                return
; End of function C$ENGINE

; ───────────────────────────────────────────────────────────────────────────
; Таблица масок для включения приводов
DMASK:          .byte   1,2,4,10

; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; SETPTR: П/п настройки указателя FLGPTR

C$SETPTR:       clr     D$FLGPTR(R3)        ; Очистим указатель FLGPTR
                bicb    #177774, D$UNIT(R3) ; Отбросим лишние биты
                movb    D$UNIT(R3), D$FLGPTR(R3) ; Перешлём номер привода в FLGPTR
                add     R3, D$FLGPTR(R3)    ; Прибавим базовый адрес FLGTAB
                add     #D$FLGTAB, D$FLGPTR(R3) ;    получаем искомый адрес
                return
; End of function C$SETPTR


; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; GOTRK: П/п позиционирования

C$GOTRK:        tstb    D$TRK(R3)           ; Нужна дорожка 00?
                beq     C$GOTO00            ; Да - позиционируем прямо на неё
                tstb    @D$CURTRK(R3)       ; Положение головки известно?
                bpl     1$                  ; Да - будем искать требуемую
                call    C$GOTO00            ; Нет - придётся сориентироваться

1$:             cmpb    @D$CURTRK(R3), D$TRK(R3)    ; Нужная дорожка совпадает с текущей?
                beq     2$                  ; Да - так что же мы тут делаем?
                bhi     3$                  ; Нет - искомая ближе к центру?
                call    C$GOUP              ; Да - шагаем к центру
                br      1$                  ; Проверим, дошли ли
; ───────────────────────────────────────────────────────────────────────────

3$:             call    C$GODOWN            ; Нет - шагнём к периферии
                br      1$                  ; Проверим, дошли ли
; ───────────────────────────────────────────────────────────────────────────

2$:             mov     #10000., R0         ; Подождём успокоения головки
                sob     R0, .
                return                      ; Теперь можно и выйти
; End of function C$GOTRK


; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; GOUP: Шаг к центру

C$GOUP:         incb    @D$CURTRK(R3)       ; Номер дорожки станет на 1 больше
                bmi     1$                  ; Таких дорожек нет - выходим с ошибкой
                bis     #100, (R3)          ; Все в порядке - шагать будем вперёд
                br      3$                  ; Пойдём шагать
; ───────────────────────────────────────────────────────────────────────────

1$:             mov     #4, R0              ; Выход с ошибкой 4
                jmp     C$ERROR
; End of function C$GOUP


; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; GODOWN: Шаг к периферии

C$GODOWN:       decb    @D$CURTRK(R3)       ; Номер дорожки станет на 1 меньше
                bit     #1, (R4)            ; Дошли до дорожки 00?
                beq     2$                  ; Нет - можно шагать
                clrb    @D$CURTRK(R3)       ; Дошли: теперь текущая - 00
                return                      ;    и можно выйти
; ───────────────────────────────────────────────────────────────────────────

2$:             bic     #100, (R3)          ; Шагать будем назад

3$:             mov     #200., R0           ; Подготовим задержку
                mov     (R3), (R4)          ; Перешлём направление шага в регистр
                sob     R0, .               ; Подождём, пока контроллер "переварит"
                bis     #200, (R3)          ; Установим признак шага
                mov     (R3), (R4)          ;    и запишем в регистр
                mov     D$TSTEP(R3), R0     ; Получим задержку перехода дорожки
                sob     R0, .               ;    и задержимся
                bitb    #1, @D$FLGPTR(R3)   ; Двойной шаг?
                beq     4$                  ; Нет - можно выходить
                bitb    #100, D$FLAGS(R3)   ; Мы возвращаемся на 00?
                bne     4$                  ; Да - возвращаться надо одинарным шагом
                mov     (R3), (R4)          ; Нет - придётся шагнуть ещё
                mov     D$TSTEP(R3), R0     ; Получим задержку перехода дорожки
                sob     R0, .               ;    и задержимся

4$:             bic     #200, (R3)          ; Очистим признак шага
                return
; End of function C$GODOWN


; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; GOTO00: П/п возврата на дорожку 00

C$GOTO00:       movb    #200, @D$CURTRK(R3) ; Установим счётчик дорожек
                bisb    #100, D$FLAGS(R3)   ; Возвращаться надо одинарным шагом

1$:             call    C$GODOWN            ; GODOWN: Шагнём к периферии
                bit     #1, (R4)            ; Дошли до 00?
                bne     2$                  ; Да - выходим
                tstb    @D$CURTRK(R3)       ; На какой дорожке должны находиться?
                bne     1$                  ; Не на нулевой - ещё шагнём
                mov     #3, R0              ; На нулевой, а её нет - ошибка 3
                bicb    #100, D$FLAGS(R3)   ; Сбросим режим одинарного шага
                jmp     C$ERROR             ; Выходим с ошибкой
; ───────────────────────────────────────────────────────────────────────────

2$:             clrb    @D$CURTRK(R3)       ; Дошли - текущая теперь нулевая
                bicb    #100, D$FLAGS(R3)   ; Сбросим режим одинарного шага
                return
; End of function C$GOTO00


; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; FRESEC: П/п пропуска сектора

C$FRESEC:       mov     D$SECLEN(R3), R0    ; Получим длину сектора
; End of function C$FRESEC


; ███████████████ S U B R O U T I N E ███████████████████████████████████████


C$FICT:         tst     (R4)                ; Индекс есть?
                bmi     1$                  ; Да - ждём начала оборота

2$:             tst     (R4)                ; Индекс все ещё есть?
                bmi     3$                  ; Да - оборот завершён

4$:             tstb    (R4)                ; Данные готовы?
                bpl     2$                  ; Нет - снова
                tst     (R5)                ; Прочитаем данные вхолостую
                sob     R0, 2$              ;    требуемое число раз
                br      5$                  ;    и выйдем
; ───────────────────────────────────────────────────────────────────────────

3$:             decb    D$TURNS(R3)         ; Все обороты вышли?
                bne     6$                  ; Нет - попытаемся слова
                mov     #5, R0              ; Да - выходим с ошибкой 5
                jmp     C$ERROR
; ───────────────────────────────────────────────────────────────────────────

1$:             tst     (R4)                ; Индекс исчез?
                bpl     4$                  ; Да - оборот начался

6$:             tstb    (R4)                ; Данные готовы?
                bpl     1$                  ; Нет - проверим индекс
                tst     (R5)                ; Прочитаем данные вхолостую
                sob     R0, 1$              ;    требуемое число раз

5$:             return                      ;    и вернёмся к основной работе
; End of function C$FICT

; ───────────────────────────────────────────────────────────────────────────
; WRSEC: П/п записи сектора
; Входные параметры: R1 - число слов для записи
C$WRSEC:        mov     D$ADDR(R3), R2      ; Получим начальный адрес массива
                mov     #11., R0            ; В маркере будет 11. 4E4E
                mtps    #340                ; При записи нам не мешать!
                call    C$WRMAR             ; Запишем маркер данных

1$:             tstb    (R4)                ; Готовность есть?
                bpl     1$                  ; Нет - ждём
                mov     (R2)+, (R5)         ; Запишем первое слово данных
                mov     (R3), (R4)          ; Снимем признак записи маркера
                br      2$                  ;    и пойдём записывать данные
; ───────────────────────────────────────────────────────────────────────────

3$:             tstb    (R4)                ; Готовность есть?
                bpl     3$                  ; Нет - дождёмся
                mov     (R2)+, (R5)         ; Запишем слово данных

2$:             sob     R1, 3$              ;    и так до конца
                mov     D$FREE(R3), R1      ; Получим длину пустого остатка сектора
                beq     4$                  ; Остатка нет - выходим сразу

5$:             tstb    (R4)                ; Готовность есть?
                bpl     5$                  ; Дожидаемся
                mov     #0, (R5)            ; Записываем нули
                sob     R1, 5$              ;    в нужном количестве

4$:             bit     #40000, (R4)        ; Ждём записи CRC
                beq     4$
                mov     #47116, (R5)        ; Записываем 4E4E

6$:             tstb    (R4)                ; Готовность есть?
                bpl     6$                  ; Нет - ждём
                tst     (R5)                ; Прекращаем запись
                mtps    D$BUFPSW(R3)        ; Восстанавливаем PSW
                jmp     C$NEXT              ; NEXT: Продолжаем запись массива


; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; WRMAR: П/п записи маркера данных
; Входные данные: R0 - число записываемых слов 4E4E

C$WRMAR:        mov     #47116, (R5)        ; Запишем 4E4E
                br      1$                  ; Идём на повтор записи
; ───────────────────────────────────────────────────────────────────────────

2$:             tstb    (R4)                ; Готовность есть?
                bpl     2$                  ; Нет - дождёмся
                mov     #47116, (R5)        ; Запишем 4E4E

1$:             sob     R0, 2$              ; Повторим заданное число раз
                mov     #6, R0              ; Запишем 12. нулевых байтов

3$:             tstb    (R4)                ; Готовность есть?
                bpl     3$                  ; Нет - ожидаем
                mov     #0, (R5)            ; Записываем нули
                sob     R0, 3$              ;    в нужном количестве
                bis     #1000, (R3)         ; Подготовим признак записи маркера

4$:             tstb    (R4)                ; Контроллер готов?
                bpl     4$                  ; Нет - ждём
                mov     #120641, (R5)       ; Записываем маркер A1A1
                mov     (R3), (R4)          ; Передаём признак в контроллер
                bic     #1000, (R3)         ; Заранее снимем признак

5$:             tstb    (R4)                ; Готовность есть?
                bpl     5$                  ; Нет - ожидаем
                mov     D$MARKER(R3), (R5)  ; Записываем маркер из буфера
                return
; End of function C$WRMAR


; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; CORR: П/п установки прекоррекции

C$CORR:         bic     #2000, (R3)         ; Снимем прекоррекцию
                cmpb    D$TRKCOR(R3), @D$CURTRK(R3) ; Надо включать на текущей дорожке?
                bhi     1$                  ; Нет - пропустим
                bis     #2000, (R3)         ; Пора - включим

1$:             mov     (R3), (R4)          ; Перешлём управляющее слово
                mov     #200., R0
                sob     R0, .               ; Подождём, пока контроллер воспримет
                return
; End of function C$CORR
C$ENDDRV:

BUFFERS:
; ───────────────────────────────────────────────────────────────────────────
; Таблица параметров загрузчика, начало бутблока
BootBlock:      .word 753
                .word 20220
                .ascii "ANDOS  "
                .byte 0, 2              ; 512. Число байт в секторе
                .byte 4                 ; Количество блоков на кластер
                .word 1                 ; 1 Число блоков в загрузчике
                .byte 2                 ; Число FAT
                .byte 112., 0           ; Максимальное число файлов в каталоге
TotalBlocks:    .byte 100, 6            ; Общее число блоков на диске
                .byte 371               ; Media Descriptor (байт парам. диска)
                .word 2                 ; Число блоков в одной FAT
                .word 10.               ; Число секторов (блоков) на дорожке
TotalHeads:     .word 2                 ; Число головок
                .blkb   15.             ; Не используются
                .ascii "ANDOS V3.3 FAT12   " ; Метка тома
                .word 0                 ; Не используется

; переменные для инициализации диска
FAT1 = BootBlock + 1000
FAT2 = BootBlock + 3000

; переменные для чтения дорожки
TrackBuffer = BUFFERS + 1000
; переменные для создания загрузочного диска
NewBootBlk = BUFFERS + 1000
                .END
