﻿;переменные ядра АНДОС 3.10 для сторонних программ
; ── область переменных и параметров ────────────────────────────────────────
DRV$A       = 120004    ; таблица параметров дисковода A:
DRV$B       = 120012    ; таблица параметров дисковода B:
DRVTAB      = 120020    ; таблица параметров драйвера дисковода
DRIVER      = 120106    ; Адрес входа "чтение/запись блока " драйвера НГМД
                        ; (160004). Может использоваться для обслуживания
                        ; нестандартных устройств, например виртуального диска)
IOBUFF      = 120110    ; Адрес буфера ANDOS (125000)
E36STK      = 120112    ; Адрес вершины стека ANDOS (126476)
NAMBUF      = 120114    ; Буфер имени
NAMEXT      = 120124    ; расширение файла в буфере имени
ATTRIB      = 120127    ; Аттрибут файла, присваиваемый при записи
SUBDIR      = 120130    ; Номер каталога, в который будет помещён файл
DATE        = 120132    ; Системная дата (присв. файлу при записи).
PALET       = 120134    ; Палитра, устанавливаемая на БК11(М) при перезапуске
ADRFAT      = 120136    ; адрес текущей ячейки FAT в буфере
WREGIM      = 120140    ; Режим записи (код буквы "П" на любом регистре (120) -
                        ; перезапись, "Д" (104) - дубль, другой код - вывод запроса)
TEKREG      = 120141    ; Текущий режим записи. Эти две ячейки очень похожи по
                        ; своей работе на DEVICE и DEVTEK.
CONFIG      = 120142    ; Конфигурация ЭВМ (60000 - БК11(М), 140000 - БК10+16,
                        ; 140002 - БК10+8, 140001 - БК10+4)
BUFEMT      = 120144    ; буфер хранения вектора 30
USRERR      = 120146    ; Ячейка перехвата сообщений об ошибках. См. раздел
                        ; "Обработка ошибок"
SCREEN      = 120150    ; Ячейка перехвата вывода на экран сообщений
                        ; ANDOS (Значение по умолчанию 0)
ADRDIR      = 120152    ; Адрес, помещаемый в каталог.  Используется при
                        ; исполнении EMT36 с кодом операции 202
DEVICE      = 120154    ; Текущее устройство (0-@:, 1-32 - A:-Z:)
DEVTEK      = 120155    ; Временное текущее устройство. Совпадает с DEVICE при
                        ; запуске операции, изменяется при явном указании
USRESP      = 120156    ; здесь в ANDOS'е сохраняется SP в EMT-диспетчере
SIZE        = 120162    ; Общее количество кластеров на диске. Определяется
                        ; подпрограммой INIDRV после считывания таблицы
                        ; параметров из загрузчика
COMAND      = 120164    ; Мл.байт - команда EMT36. В эту ячейку заносится код
                        ; команды из первого байта блока параметров EMT36, он
                        ; может изменятся командами ANDOS
                        ; Ст.байт - дескриптор команды
TEKBLK      = 120166    ; Номер блока диска, находящегося в буфере
VERS        = 120170    ; Версия ANDOS (для V3.1 - 100466)
MASTER      = 120172    ; Признак включения/адрес оболочки
FILER       = 120174    ; Признак включения/адрес файлера
MDOSEM      = 120176    ; Признак включения/адрес эмулятора MicroDOS
USER        = 120244    ; Ячейки, восстанавливаемые при перезапуске или EMT14.
                        ; Значение первой ячейки  записывается по адресу из
                        ; второй, 3->@4, 5->@6

;таблица адресов подпрограмм
RWCLAS      = 120200    ; чтение/запись кластера
                        ; Параметры: R4 - номер первого обрабатываемого кластера
                        ;            R0 - признак чтения/записи (R0=0 - чтение)
                        ;            R2 - адрес начала обрабатываемого участка.
                        ;            R5 - сумма длин обрабатываемых кластеров
                        ;            R1 - ограничитель (остаток) длины
                        ; Результат: R1 - длина остатка файла (R1<=0 - файл кончился)
                        ;            R2 - адрес остатка файла в памяти
                        ; Портит:    R0, R4
FRCLAS      = 120202    ; поиск пустого кластера
                        ; Результат: Номер пустого кластера -> R0 (бит "C" - нет)
INIDRV      = 120204    ; инициализация работы с диском
                        ; Результат: Кол-во кластеров -> SIZE,
                        ;            бит "C" - диск не в формате ANDOS.
INIT1       = 120206    ; Инициализация рабочей области драйвера НГМД
                        ; Результат: Кол-во кластеров -> SIZE,
                        ;            бит "C" - диск не в формате ANDOS.
ERASE1      = 120210    ; Удаление файла
                        ; Параметры: R0 - номер блока в буфере,
                        ;            R2 - адрес записи о файле (в буфере)
                        ; Портит:    R0, R1, R2
DIRENT      = 120212    ; Поиск элементов каталога
                        ; Параметры: Перед первым запуском очистить R0
                        ; Результат: R4 - Адрес начала элемента (R4=0 - конец каталога)
                        ;            бит "Z" - конец каталога
                        ; Не портить R0, R4
DIREN2      = 120214    ; Поиск заполненных элементов каталога
                        ; Параметры: Перед первым запуском очистить R0
                        ; Результат: R4 - Адрес начала элемента
                        ;            бит "Z" - конец каталога
                        ; Не портить R0, R4
DIRFIN      = 120216    ; Поиск файла в каталоге
                        ; Параметры: R1 - Адрес буфера имени
                        ; Результат: R2 - Адрес начала элемента (бит "C" - файла нет),
                        ;            R0 - Номер блока в буфере (блок каталога).
                        ; Портит:    R0, R2, R5
DIRFRE      = 120220    ; Поиск свободного элемента каталога
                        ; Результат: R2 - Адрес начала элемента (бит "C" - нет элемента).
                        ; Портит:    R0 (номер блока диска в буфере)
RWBUF       = 120222    ; Чтение/запись в буфер ANDOS с кэшированием
                        ; Параметры: R0 - Номер блока на диске, R1 - Длина в словах
                        ; Портит:    R2
RWBUF1      = 120224    ; Чтение/запись в буфер без кэширования
                        ; Параметры: R0 - Номер блока на диске, R1 - Длина в словах
                        ; Портит:    R2
RWBLOK      = 120226    ; Чтение/запись
                        ; Параметры: R0 - Номер блока на диске, R2 - Адрес,
                        ;            R1 - Длина в словах
RDFAT       = 120230    ; Чтение FAT с диска
WRFAT       = 120232    ; Запись FAT на диск
GETFAT      = 120234    ; Распаковка ячейки FAT
                        ; Параметры: R0 - Номер ячейки FAT
                        ; Результат: R0 - Содержимое ячейки
SETFAT      = 120236    ; Запись в ячейку FAT
                        ; Параметры: R0 - номер ячейки, R1 - содержимое
                        ; Результат: R0 - старое содержимое ячейки
                        
DIRFI2      = 120260    ; Поиск файла в каталоге по имени из NAMBUF
                        ; Параметры: Имя в NAMBUF
                        ; Результат: R2 - Адрес начала элемента (бит "C" - файла нет),
                        ;            R0 - Номер блока в буфере (блок каталога).
                        ; Портит:    R0, R1, R2, R5
ENAME       = 120262    ; Поиск конца строки и точки
                        ; Параметры: R3 - начало строки, R1+22. - конец
                        ; Результат: Адрес последнего символа строки -> R0
                        ;            Адрес символа после "точки" -> R4
                        ;            Адрес последнего символа перед точкой -> R2
                        ;            бит "C" - нет имени и расширения
                        ;            бит "Z" - нет имени, есть расширение
                        ;            R4 > R0 - есть имя, нет расширения
                        ; Портит:    R0, R2, R4
DOUBLE      = 120264    ; Переименование файла в .BAK
                        ; Параметры: Имя в NAMBUF
                        ; параметры получаемые в функции EXIST:
                        ; R0 - номер блока каталога на диске
                        ; R2 - адрес записи каталога в буфере
                        ; Портит:    R0, R1, R2, R5
ENDWRT      = 120266    ; Закрытие файла
                        ; Параметры: Имя в NAMBUF
                        ;            ATTRIB - аттрибут
                        ;            SUBDIR - номер родительского подкаталога
                        ;            ADRDIR - адрес
                        ;            R1 - младшая часть 32-битной длины
                        ;            R3 - старшая часть длины (обычно 0)
                        ;            R2 - дата
                        ;            R4 - стартовый кластер
                        ; Портит:    R0 - R5
EXIST       = 120270    ; Открытие файла для записи (Перезапись/Дубль)
                        ; Параметры: Имя в NAMBUF
                        ; Результат: Бит "C" - файла нет
                        ; Портит:    R0 - R5
DONAME      = 120272    ; Поиск команд и перепаковка имени
                        ; Параметры: R1 - адрес блока параметров EMT36
                        ; Результат: Имя -> NAMBUF
                        ;            Бит "С" - операция с магнитофоном
                        ; Портит:    R0, R2, R3, R4, R5
CONNAM      = 120274    ; Перепаковка и логическая обработка имени
                        ; Параметры: R3 - начало строки, R1+22. - конец
                        ; Результат: Имя -> NAMBUF
                        ; Портит:    R0, R2, R3, R4, R5
FRCLA1      = 120276    ; Поиск пустого кластера, начиная от указанного
                        ; Параметры: R4 - кластер начала поиска
                        ; Результат: Номер пустого кластера -> R0 (бит "C" - нет)
FIND        = 120300    ; Поиск файла в каталоге с выдачей сообщения
                        ; Параметры: Имя в NAMBUF
                        ;            R3 - Адрес блока параметров EMT36 (для файлера)
                        ; Результат: R2 - Адрес начала элемента (бит "C" - файла нет),
                        ;            R0 - Номер блока в буфере (блок каталога).
                        ; Портит:    R0, R1, R2, R5
DIRFI1      = 120302    ; Поиск файла в каталоге (с файлером)
                        ; Параметры: Имя в NAMBUF
                        ;            R3 - Адрес блока параметров EMT36 (для файлера)
                        ; Результат: R2 - Адрес начала элемента (бит "C" - файла нет),
                        ;            R0 - Номер блока в буфере (блок каталога).
                        ; Портит:    R0, R1, R2, R5
RDBLOK      = 120304    ; Чтение блока в буфер
                        ; Параметры: R0 - Номер блока на диске
WRBLOK      = 120306    ; Запись блока из буфера
                        ; Параметры: R0 - номер блока на диске
ERASE2      = 120310    ; Удаление цепочки из FAT
                        ; Параметры: R0 - кластер начала цепочки
                        ; Портит:    R0, R1
RUNNER      = 120312    ; Вызов подпрограммы с проверкой целостности
                        ; Результат: Бит "C" - подпрограмма отключена или уничтожена
                        ; Портит:    R0, R5
INIPRN      = 120314    ; Адрес подпрограммы инициализации принтера. Вызов:
                        ; CALL @RUNNER .WORD P$INIPRN . Бит C означает отсутствие
                        ; драйвера принтера. Регистры не сохраняются
OUTPRN      = 120316    ; Адрес п/п вывода на принтер байта из R0 с перекодировкой
                        ; в соответствии с текущей кодовой таблицей. Перед
                        ; LF (12) автоматически выводится CR (15)
GRFPRN      = 120320    ; Адрес п/п вывода на принтер байта из R0 без перекодировки
                        ; (напр. для печати графики)
PRT1        = 120330    ; Вывод строки на экран
                        ; Параметры: R4 - Адрес строки.
; переменные файлёра
XY$FIL      = 120322    ; (Кол-во столбцов)X(кол-во строк в файлере)
ST$FIL      = 120323    ; Количество текстовых строк файлера.
W$FIL       = 120324    ; Ширина окна файлера в байтах
H$FIL       = 120325    ; Высота окна файлера в строках
AD$FIL      = 120326    ; Смещение левого верхнего угла файлера, от
                        ; начала экрана (в байтах)

BUFFER      = 125000    ; адрес буфера АНДОС
BUFFERLEN   = 1200      ; размер буфера АНДОС в байтах

OVERLAYADDR = 23200     ; адрес загрузки оверлеев оболочки

; часто используемые подпрограммы из монитора БК10
PUSH4   = 110346
POP4    = 110362
POP4R   = 102362 ; восстановить R0-R4 и ret
POP4I   = 101324 ; восстановить R0-R4 и RTI

