;
; ╔═════════════════════════════════════════════════════════════════════════╗
; ║     This file is generated by The Interactive Disassembler (IDA)        ║
; ║     Copyright (c) 2006 by DataRescue sa/nv, <ida@datarescue.com>        ║
; ║ Licensed to: Ded Pihto                                                  ║
; ╚═════════════════════════════════════════════════════════════════════════╝
;
; ───────────────────────────────────────────────────────────────────────────
; Ядро ANDOS 3.1

; Processor:        K1801VM1
; Target assembler: BK Turbo8 Cross Assembler

; ═══════════════════════════════════════════════════════════════════════════
.include "inc\Mon10Param.asm"
.include "inc\FDDParam.asm"
.include "inc\FATParam.asm"

        PUSH4   = 110346
        POP4    = 110362
        POP4R   = 102362 ; восстановить R0-R4 и ret
        POP4I   = 101324 ; восстановить R0-R4 и RTI

;точка входа в пользовательское дополнение
;U$ENTRY    = 137000
;точка входа в драйвер виртуального диска
V$ENTRY     = 116100

;SplashEntry = 126360 ; п/п выполняемая из заставки
; 3640 - точка входа продолжения выполнения заставки после инициализации
; 4626 - какая то переменная

OVERLAYADDR = 23200     ; адрес загрузки оверлеев оболочки
BlockSizeW  = 400
FATSizeW    = 500

.la 120000

START:          br      START$
EMT36:          br      EMT36$          ; 120002
; ───────────────────────────────────────────────────────────────────────────
; ── область переменных и параметров ────────────────────────────────────────
        ; таблица параметров дисковода A:
DRV$A:          .word 200               ; задержка опускания головки
                .word 400               ; задержка шага
                .byte 60.               ; дорожка начала прекоррекции
                .byte 200               ; тип: xxxxxxxx
                                        ;      │└0 - 2 стороны
                                        ;      │ 1 - 1 сторона
                                        ;      └─0 - 40 дорожек
                                        ;        1 - 80 дорожек
        ; таблица параметров дисковода B:
DRV$B:          .word 200               ; задержка опускания головки
                .word 400               ; задержка шага
                .byte 60.               ; дорожка начала прекоррекции
                .byte 200               ; тип: xxxxxxxx
                                        ;      │└0 - 2 стороны
                                        ;      │ 1 - 1 сторона
                                        ;      └─0 - 40 дорожек
                                        ;        1 - 80 дорожек
DRVTAB:         .blkw 6                 ; таблица параметров драйвера дисковода
                .word 5000
                .blkw 21
                .word 10.,0,400
DRIVER:         .word 160004            ; Адрес входа "чтение/запись блока " драйвера НГМД
                                        ; (160004). Может использоваться для обслуживания
                                        ; нестандартных устройств, например виртуального диска)
IOBUFF:         .word BUFFER            ; Адрес буфера ANDOS (125000)
E36STK:         .word StackTop          ; Адрес вершины стека ANDOS (126476)
NAMBUF:         .blkb 13                ; Буфер имени
NAMEXT = NAMBUF + 10                    ; Расширение в буфере имени
ATTRIB:         .byte 0                 ; Атрибут файла, присваиваемый при записи
SUBDIR:         .word 0                 ; Номер каталога, в который будет помещён файл
DATE:           .word 20515             ; Системная дата (присв. файлу при записи).
PALET:          .word 42000             ; Палитра, устанавливаемая на БК11(М) при перезапуске
ADRFAT:         .word 0                 ; адрес текущей ячейки FAT в буфере
WREGIM:         .byte 0                 ; Режим записи (код буквы "П" на любом регистре (120) -
                                        ; перезапись, "Д" (104) - дубль, другой код - вывод запроса)
TEKREG:         .byte 0                 ; Текущий режим записи. Эти две ячейки очень похожи по
                                        ; своей работе на DEVICE и DEVTEK.
CONFIG:         .word 0                 ; Конфигурация ЭВМ (60000 - БК11(М), 140000 - БК10+16,
                                        ; 140002 - БК10+8, 140001 - БК10+4)
BUFEMT:         .word 0                 ; буфер хранения вектора 30
USRERR:         .word 0                 ; Ячейка перехвата сообщений об ошибках. См. раздел
                                        ; "Обработка ошибок"
SCREEN:         .word 0                 ; Ячейка перехвата вывода на экран сообщений
                                        ; ANDOS (Значение по умолчанию 0)
ADRDIR:         .word 0                 ; Адрес, помещаемый в каталог.  Используется при
                                        ; исполнении EMT36 с кодом операции 202
DEVICE:         .byte 1                 ; Текущее устройство (0-@:, 1-32 - A:-Z:)
DEVTEK:         .byte 1                 ; Временное текущее устройство. Совпадает с DEVICE при
                                        ; запуске операции, изменяется при явном указании
                                        ; устройства в имени
USRESP:         .word 0                 ; здесь в ANDOS'е сохраняется SP в EMT-диспетчере
                .word 0                 ; это слово свободно
SIZE:           .word 0                 ; Общее количество кластеров на диске. Определяется
                                        ; подпрограммой INIDRV после считывания таблицы
                                        ; параметров из загрузчика
COMAND:         .word 171000            ; Мл.байт - команда EMT36. В эту ячейку заносится код
                                        ; команды из первого байта блока параметров EMT36, он
                                        ; может изменятся командами ANDOS
                                        ; Ст.байт - дескриптор команды
TEKBLK:         .word 0                 ; Номер блока диска, находящегося в буфере
VERS:           .word 100000+310.       ; Версия ANDOS (для V3.1 - 100466)
MASTER:         .word M$ENTRY           ; Признак включения/адрес оболочки
FILER:          .word F$ENTRY           ; Признак включения/адрес файлера
MDOSEM:         .word E$ENTRY           ; Признак включения/адрес эмулятора MicroDOS
;таблица адресов подпрограмм
RWCLAS:         .word K$RWCLAS          ; чтение/запись кластера
                                        ; Параметры: R4 - номер первого обрабатываемого кластера
                                        ;            R0 - признак чтения/записи (R0=0 - чтение)
                                        ;            R2 - адрес начала обрабатываемого участка.
                                        ;            R5 - сумма длин обрабатываемых кластеров
                                        ;            R1 - ограничитель (остаток) длины
                                        ; Результат: R1 - длина остатка файла (R1<=0 - файл кончился)
                                        ;            R2 - адрес остатка файла в памяти
                                        ; Портит:    R0, R4
FRCLAS:         .word K$FRCLAS          ; поиск пустого кластера
                                        ; Результат: Номер пустого кластера -> R0 (бит "C" - нет)
INIDRV:         .word K$INIDRV          ; инициализация работы с диском
                                        ; Результат: Кол-во кластеров -> SIZE,
                                        ;            бит "C" - диск не в формате ANDOS.
INIT1:          .word K$INIT1           ; Инициализация рабочей области драйвера НГМД
                                        ; Результат: Кол-во кластеров -> SIZE,
                                        ;            бит "C" - диск не в формате ANDOS.
ERASE1:         .word K$ERASE1          ; Удаление файла
                                        ; Параметры: R0 - номер блока в буфере,
                                        ;            R2 - адрес записи о файле (в буфере)
                                        ; Портит:    R0, R1, R2
DIRENT:         .word K$DIRENT          ; Поиск элементов каталога
                                        ; Параметры: Перед первым запуском очистить R0
                                        ; Результат: R4 - Адрес начала элемента (R4=0 - конец каталога)
                                        ;            бит "Z" - конец каталога
                                        ; Не портить R0, R4
DIREN2:         .word K$DIREN2          ; Поиск заполненных элементов каталога
                                        ; Параметры: Перед первым запуском очистить R0
                                        ; Результат: R4 - Адрес начала элемента
                                        ;            бит "Z" - конец каталога
                                        ; Не портить R0, R4
DIRFIN:         .word K$DIRFIN          ; Поиск файла в каталоге
                                        ; Параметры: R1 - Адрес буфера имени
                                        ; Результат: R2 - Адрес начала элемента (бит "C" - файла нет),
                                        ;            R0 - Номер блока в буфере (блок каталога).
                                        ; Портит:    R0, R2, R5
DIRFRE:         .word K$DIRFRE          ; Поиск свободного элемента каталога
                                        ; Результат: R2 - Адрес начала элемента (бит "C" - нет элемента).
                                        ; Портит:    R0 (номер блока диска в буфере)
RWBUF:          .word K$RWBUF           ; Чтение/запись в буфер ANDOS с кэшированием
                                        ; Параметры: R0 - Номер блока на диске, R1 - Длина в словах
                                        ; Портит:    R2
RWBUF1:         .word K$RWBUF1          ; Чтение/запись в буфер без кэширования
                                        ; Параметры: R0 - Номер блока на диске, R1 - Длина в словах
                                        ; Портит:    R2
RWBLOK:         .word K$RWBLOK          ; Чтение/запись
                                        ; Параметры: R0 - Номер блока на диске, R2 - Адрес,
                                        ;            R1 - Длина в словах
RDFAT:          .word K$RDFAT           ; Чтение FAT с диска
WRFAT:          .word K$WRFAT           ; Запись FAT на диск
GETFAT:         .word K$GETFAT          ; Распаковка ячейки FAT
                                        ; Параметры: R0 - Номер ячейки FAT
                                        ; Результат: R0 - Содержимое ячейки
SETFAT:         .word K$SETFAT          ; Запись в ячейку FAT
                                        ; Параметры: R0 - номер ячейки, R1 - содержимое
                                        ; Результат: R0 - старое содержимое ячейки
; ───────────────────────────────────────────────────────────────────────────
START$:         br      BEGIN
EMT36$:         br      USREMT          ; обработка EMT 36
; ───────────────────────────────────────────────────────────────────────────
USER:           .blkw   6               ; Ячейки, восстанавливаемые при перезапуске или EMT14.
                                        ; Значение первой ячейки  записывается по адресу из
                                        ; второй, 3->@4, 5->@6
;таблица адресов подпрограмм
DIRFI2:         .word K$DIRFI2          ; Поиск файла в каталоге по имени из NAMBUF
                                        ; Параметры: Имя в NAMBUF
                                        ; Результат: R2 - Адрес начала элемента (бит "C" - файла нет),
                                        ;            R0 - Номер блока в буфере (блок каталога).
                                        ; Портит:    R0, R1, R2, R5
ENAME:          .word K$ENAME           ; Поиск конца строки и точки
                                        ; Параметры: R3 - начало строки, R1+22. - конец
                                        ; Результат: Адрес последнего символа строки -> R0
                                        ;            Адрес символа после "точки" -> R4
                                        ;            Адрес последнего символа перед точкой -> R2
                                        ;            бит "C" - нет имени и расширения
                                        ;            бит "Z" - нет имени, есть расширение
                                        ;            R4 > R0 - есть имя, нет расширения
                                        ; Портит:    R0, R2, R4
DOUBLE:         .word K$DOUBLE          ; Переименование файла в .BAK
                                        ; Параметры: Имя в NAMBUF
                                        ; параметры получаемые в функции EXIST:
                                        ; R0 - номер блока каталога на диске
                                        ; R2 - адрес записи каталога в буфере
                                        ; Портит:    R0, R1, R2, R5
ENDWRT:         .word K$ENDWRT          ; Закрытие файла
                                        ; Параметры: Имя в NAMBUF
                                        ;            ATTRIB - аттрибут
                                        ;            SUBDIR - номер родительского подкаталога
                                        ;            ADRDIR - адрес
                                        ;            R1 - младшая часть 32-битной длины
                                        ;            R3 - старшая часть длины (обычно 0)
                                        ;            R2 - дата
                                        ;            R4 - стартовый кластер
                                        ; Портит:    R0 - R5
                                        ;
EXIST:          .word K$EXIST           ; Открытие файла для записи (Перезапись/Дубль)
                                        ; Параметры: Имя в NAMBUF
                                        ; Результат: Бит "C" - файла нет
                                        ; Портит:    R0 - R5
DONAME:         .word K$DONAME          ; Поиск команд и перепаковка имени
                                        ; Параметры: R1 - адрес блока параметров EMT36
                                        ; Результат: Имя -> NAMBUF
                                        ;            Бит "С" - операция с магнитофоном
                                        ; Портит:    R0, R2, R3, R4, R5
CONNAM:         .word K$CONNAM          ; Перепаковка и логическая обработка имени
                                        ; Параметры: R3 - начало строки, R1+22. - конец
                                        ; Результат: Имя -> NAMBUF
                                        ; Портит:    R0, R2, R3, R4, R5
FRCLA1:         .word K$FRCLA1          ; Поиск пустого кластера, начиная от указанного
                                        ; Параметры: R4 - кластер начала поиска
                                        ; Результат: Номер пустого кластера -> R0 (бит "C" - нет)
FIND:           .word K$FIND            ; Поиск файла в каталоге с выдачей сообщения
                                        ; Параметры: Имя в NAMBUF
                                        ;            R3 - Адрес блока параметров EMT36 (для файлера)
                                        ; Результат: R2 - Адрес начала элемента (бит "C" - файла нет),
                                        ;            R0 - Номер блока в буфере (блок каталога).
                                        ; Портит:    R0, R1, R2, R5
DIRFI1:         .word K$DIRFI1          ; Поиск файла в каталоге (с файлером)
                                        ; Параметры: Имя в NAMBUF
                                        ;            R3 - Адрес блока параметров EMT36 (для файлера)
                                        ; Результат: R2 - Адрес начала элемента (бит "C" - файла нет),
                                        ;            R0 - Номер блока в буфере (блок каталога).
                                        ; Портит:    R0, R1, R2, R5
RDBLOK:         .word K$RDBLOK          ; Чтение блока в буфер
                                        ; Параметры: R0 - Номер блока на диске
WRBLOK:         .word K$WRBLOK          ; Запись блока из буфера
                                        ; Параметры: R0 - номер блока на диске
ERASE2:         .word K$ERASE2          ; Удаление цепочки из FAT
                                        ; Параметры: R0 - кластер начала цепочки
                                        ; Портит:    R0, R1
RUNNER:         .word K$RUNNER          ; Вызов подпрограммы с проверкой целостности
                                        ; Результат: Бит "C" - подпрограмма отключена или уничтожена
                                        ; Портит:    R0, R5
INIPRN:         .word P$INIPRN          ; Адрес подпрограммы инициализации принтера. Вызов:
                                        ; CALL @RUNNER .WORD INIPRN . Бит C означает отсутствие
                                        ; драйвера принтера. Регистры не сохраняются
OUTPRN:         .word P$OUTPRN          ; Адрес п/п вывода на принтер байта из R0 с перекодировкой
                                        ; в соответствии с текущей кодовой таблицей. Перед
                                        ; LF (12) автоматически выводится CR (15)
GRFPRN:         .word P$GRFPRN          ; Адрес п/п вывода на принтер байта из R0 без перекодировки
                                        ; (напр. для печати графики)
XY$FIL:         .byte 36                ; (Кол-во столбцов)X(кол-во строк в файлере)
ST$FIL:         .byte 12                ; Количество текстовых строк файлера.
W$FIL:          .byte 46                ; Ширина окна файлера в байтах
H$FIL:          .byte 150               ; Высота окна файлера в строках
AD$FIL:         .word 10014             ; Смещение левого верхнего угла файлера, от
                                        ; начала экрана (в байтах)
PRT1:           .word K$PRT1            ; Вывод строки на экран
                                        ; Параметры: R4 - Адрес строки.
                .word 0
; ───────────────────────────────────────────────────────────────────────────

BEGIN:          clr     @#177130
                mov     #SCREEN, R0     ; Ячейка перехвата вывода на экран сообщений
                                        ; ANDOS (Значение по умолчанию 0)
                clr     (R0)            ; очищаем ячейку перехвата вывода сообщений
                clr     -(R0)           ; очищаем ячейку перехвата сообщений об ошибках
                clr     R0              ; аккумулятор КС
                mov     #K$CHKBGN, R5   ; проверяем целостность ядра
                mov     #/K$CHKEND - /K$CHKBGN, R4 ; столько слов
1$:             add     (R5)+, R0
                sob     R4, 1$
                cmp     R0, (PC)+
KernCS:         .word   12604           ; такая КС
                bne     4$

.script ;подсчёт КС
    mov #K$CHKBGN, R5
    mov R5, R4
    sub #K$CHKEND, R4
    asr R4
    clr R0
1$: add (R5)+, R0
    sob R4, 1$
    mov R0, KernCS
.ends

K$CHKBGN:       cmp     #EMT36, @#100036 ; EMT 36 на БК11 перехвачен?
                beq     2$
                mov     #EMTDISP, @#30  ; нет, тогда перехватываем обработчик EMT
2$:             tst     CONFIG          ; Конфигурация ЭВМ (60000 - БК11(М), 140000 - БК10+16,
                                        ; 140002 - БК10+8, 140001 - БК10+4)
                bmi     3$
                mov     PALET, @#177662 ; Палитра, устанавливаемая на БК11(М) при перезапуске

3$:             call    INIKEY          ; восстановление ячеек USER и ключей АР2-цифра
                jsr     R5, K$RUNNER    ; запускаем оболочку
                .word MASTER            ; Признак включения/адрес оболочки

                jsr     R4, PUTS        ; при выходе из оболочки выводим на экран
                .asciz <234>"ANDOS V3.1"<234>" "<12>
                .even

4$:             halt

; ── обработка EMT 36 ───────────────────────────────────────────────────────
USREMT:         mov     SP, @E36STK
                mov     E36STK, SP      ; Адрес вершины стека ANDOS (126476)
                mov     @#4, -(SP)
                mfps    -(SP)
                mtps    #340
                jsr     R4, PUSH4
                mov     R5, -(SP)
                mov     SP, USRESP
                mov     #EMTHLT, @#4    ; обработчик нажатия клавиши СТОП во время дисковых операций
                movb    (R1), COMAND    ; Мл.байт - команда EMT36. В эту ячейку заносится код
                                        ; команды из первого байта блока параметров EMT36, он
                                        ; может изменятся командами ANDOS
                                        ; Ст.байт - дескриптор команды
                cmpb    (R1), #203      ; это быстрое чтение файла?
                beq     2$              ; да - переходим сразу к операции
                movb    DEVICE, DEVTEK  ; Текущее устройство (0-@:, 1-32 - A:-Z:)
                movb    WREGIM, TEKREG  ; Режим записи (код буквы "П" на любом регистре (120) -
                                        ; перезапись, "Д" (104) - дубль, другой код - вывод запроса)
                call    K$DONAME        ; Поиск команд и перепаковка имени
                                        ; Параметры: R1 - адрес блока параметров EMT36
                                        ; Результат: Имя -> NAMBUF
                                        ;            Бит "С" - операция с магнитофоном
                                        ; Портит:    R0, R2, R3, R4, R5
                bcc     1$              ; идём работать с диском
                call    @#116076        ; работа с магнитофоном
                br      7$

1$:             cmpb    (R1), #1        ; команды 0,1 ?
                blos    5$              ; да, тогда больше ничего делать
                call    K$INIDRV        ; инициализация работы с диском
                                        ; Результат: Кол-во кластеров -> SIZE,
                                        ;            бит "C" - диск не в формате ANDOS.
                bcc     2$              ; всё нормально, идём обрабатывать диск андос
                jsr     R5, K$RUNNER    ; Вызов подпрограммы с проверкой целостности
                                        ; Результат: Бит "C" - подпрограмма отключена или уничтожена
                                        ; Портит:    R0, R5
                .word MDOSEM            ; Признак включения/адрес эмулятора MicroDOS

M$EERR1:        jsr     R5, OUTERR      ; Вывод сообщения об ошибке
                                        ; код ошибки в слове за вызовом.
                                        ; бит 15 - признак ожидания нажатия клавиши.
                                        ; в этом случае код нажатой клавиши возвращается в R5
                .word 1                 ; сообщение что диск не в понимаемом формате
; ───────────────────────────────────────────────────────────────────────────

2$:             mov     PC, R5          ; начиная отсюда ищем код дисковой операции,
                                        ; они начинаются с метки DISKOP
3$:             cmp     (R5)+, COMAND   ; Мл.байт - команда EMT36. В эту ячейку заносится код
                                        ; команды из первого байта блока параметров EMT36, он
                                        ; может изменятся командами ANDOS
                                        ; Ст.байт - дескриптор команды
                beq     4$
                cmp     R5, #ENDDISKOP
                blo     3$
                jmp     OUTDIR          ; если не нашли команду, выведем каталог на экран

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; обработчик нажатия клавиши СТОП во время дисковых операций

EMTHLT:         movb    #4, @#PROH
                br      6$

4$:             call    (R5)            ; выполним п/п операции
E$EHLT: ; выход из эмулятора Микродос
5$:             clrb    @#PROH          ; всё останавливаем
6$:             clr     @#177130
                clr     SUBDIR          ; Номер каталога, в который будет помещён файл
                clrb    ATTRIB          ; Атрибут файла, присваиваемый при записи

7$:             mov     USRESP, SP      ; и выходим
                mov     (SP)+, R5
                jsr     R4, POP4
                mtps    (SP)+
                mov     (SP)+, @#4
                mov     (SP), SP
                movb    @#PROH, OTWET-BPDMAG(R1)
                return
; End of function EMTHLT

; Конец обработчика EMT 36

; ── диспетчер EMT ──────────────────────────────────────────────────────────
EMTDISP:        mov     R5, -(SP)
                mov     2(SP), R5
                mov     -(R5), R5
                mov     @#30, BUFEMT
                cmp     R5, #104036     ; это EMT 36 ?
                beq     2$              ; да - перехватим
                cmp     R5, #104014     ; это EMT 14 ?
                beq     1$              ; да - перехватим
                call    @-4000(R5)      ; иначе, выполним как обычно
                br      3$

1$:             call    E14TRP          ; перехватчик EMT 14
                br      3$

2$:             call    USREMT          ; обработка EMT 36
3$:             mov     BUFEMT, @#30
                mov     (SP)+, R5
                rti
; ───────────────────────────────────────────────────────────────────────────

; перехватчик EMT 14

E14TRP:         call    @#100140        ; Инициализация монитора БК10

; восстановление ячеек USER и ключей АР2-цифра

INIKEY:         mov     #USER, R5       ; Ячейки, восстанавливаемые при перезапуске или EMT14.
                                        ; Значение первой ячейки  записывается по адресу из
                                        ; второй, 3->@4, 5->@6
                mov     (R5)+, @(R5)+
                mov     (R5)+, @(R5)+
                mov     (R5)+, @(R5)+
                mov     #ANKEYS, R5     ; Восстанавливаем ключи
                mov     #AKLC, R3       ; адрес хранения ключей
                mov     #10., R0        ; количество
1$:             mov     R5, (R3)+
                movb    (R5)+, R1
                add     R1, R5
                sob     R0, 1$
                return
; End of function INIKEY

; ── Дисковые операции перехватчика EMT 36 ──────────────────────────────────
DISKOP:         .word 171200            ; команда 200 - Удаление файла
                call    K$FIND          ; Поиск файла в каталоге с выдачей сообщения
                                        ; Параметры: Имя в NAMBUF
                                        ;            R3 - Адрес блока параметров EMT36 (для файлера)
                                        ; Результат: R2 - Адрес начала элемента (бит "C" - файла нет),
                                        ;            R0 - Номер блока в буфере (блок каталога).
                                        ; Портит:    R0, R1, R2, R5
                jsr     R5, OUTERR      ; Вывод сообщения об ошибке
                                        ; код ошибки в слове за вызовом.
                                        ; бит 15 - признак ожидания нажатия клавиши.
                                        ; в этом случае код нажатой клавиши возвращается в R5
                .word 100007            ; Запрос на удаление

                call    K$ERASE1        ; Удаление файла
                                        ; Параметры: R0 - номер блока в буфере,
                                        ;            R2 - адрес записи о файле (в буфере)
                                        ; Портит:    R0, R1, R2

DiskCancel:     halt
; ───────────────────────────────────────────────────────────────────────────
                .word 171203            ; команда 203 - Быстрое чтение файла
M$FASTREAD:     mov     R1, R3
                br      1$
; ───────────────────────────────────────────────────────────────────────────
                .word 171003            ; команда 3 - Чтение файла
                mov     R1, R3
                call    K$FIND          ; Поиск файла в каталоге с выдачей сообщения
                                        ; Параметры: Имя в NAMBUF
                                        ;            R3 - Адрес блока параметров EMT36 (для файлера)
                                        ; Результат: R2 - Адрес начала элемента (бит "C" - файла нет),
                                        ;            R0 - Номер блока в буфере (блок каталога).
                                        ; Портит:    R0, R1, R2, R5

1$:             add     #ADRTM$, R3     ; адрес текущего файла в блоке параметров
                add     #F$ADDR, R2     ; адрес файла в записи о файле
                mov     (R2), (R3)+     ; сохраним адрес файла
                mov     -ADRTM$(R3), -(SP) ; адрес загрузки в стек
                bne     2$              ; если есть
                mov     (R2), (SP)      ; если нет - то загрузка по адресу, указанному в записи о файле

2$:             cmp     (R2)+, (R2)+    ; сдвинем указатель к номеру начального кластера
                mov     (R2)+, R0       ; получим номер начального кластера
                mov     #100000, R4     ; предельный адрес загрузки
                mov     (R2)+, R1       ; длина файла мл.
                bmi     3$              ; если больше 32кб - переход
                tst     (R2)+           ; длина файла ст.
                beq     4$              ; если нет - то файл меньше 64 кб

3$:             tst     (SP)            ; если адрес загрузки
                bmi     DiskCancel      ; больше 100000, то переход на отмену
                mov     R4, R1          ; ограничим длину 32 кбайтами

4$:             mov     (SP)+, R2       ; достанем адрес загрузки
                bmi     5$              ; если больше 100000, то переход
                sub     R2, R4          ; вычислим максимальную длину от адреса загрузки, которую можно загрузить
                cmp     R1, R4          ; если длина файла умещается
                blos    5$              ; то переход

                mov     R4, R1          ; нет - ограничим тем, что помещается
                mov     #DiskCancel, (SP)

5$:             mov     R2, @#BUFSTA    ; адрес загрузки
                mov     R1, @#BUFDL     ; длина загрузки
                mov     R1, (R3)+       ; длину - в длину загруженного файла в блоке параметров
                mov     #NAMELEN, R4

6$:             movb    IMMAS$-IMTMAS$(R3), (R3)+  ; скопируем имя в имя загруженного файла в блоке параметров
                sob     R4, 6$

                mov     R2, R3          ; адрес загрузки
                add     R1, R3          ; получим конечный адрес
                mov     R3, -(SP)       ; его в стек
                movb    (R3), -(SP)     ; содержимое по конечному адресу тоже в стек
                mov     R0, R3          ; номер начального кластера

7$:             mov     R3, R0          ; номер текущего кластера
                mov     R3, R4          ; номер первого обрабатываемого кластера
                mov     #ClusterSize, R5 ; размер кластера
                cmp     R1, R5          ; файл умещается в один кластер?
                blos    9$              ; да - переход
                call    K$RDFAT         ; Чтение FAT с диска

8$:             call    K$GETFAT        ; Распаковка ячейки FAT
                                        ; Параметры: R0 - Номер ячейки FAT
                                        ; Результат: R0 - Содержимое ячейки
                inc     R3              ; следующий кластер
                cmp     R0, R3          ; прямо за предыдущим?
                bne     9$              ; нет - файл фрагментирован, идём читать фрагмент
                add     #ClusterSize, R5 ; да - прибавляем его к суммарной длине
                cmp     R5, R1          ; меньше чем длина файла?
                blo     8$              ; да, продолжим искать

9$:             mov     R0, R3          ; следующий кластер, который надо читать
                clr     R0
                call    K$RWCLAS        ; чтение/запись кластера
                                        ; Параметры: R4 - номер первого обрабатываемого кластера
                                        ;            R0 - признак чтения/записи (R0=0 - чтение)
                                        ;            R2 - адрес начала обрабатываемого участка.
                                        ;            R5 - сумма длин обрабатываемых кластеров
                                        ;            R1 - ограничитель (остаток) длины
                                        ; Результат: R1 - длина остатка файла (R1<=0 - файл кончился)
                                        ;            R2 - адрес остатка файла в памяти
                                        ; Портит:    R0, R4
                bhi     7$              ; если файл не кончился, идём читать следующий фрагмент
                movb    (SP)+, R0       ; достанем содержимое конечного адреса
                mov     (SP), R3        ; достанем конечный адрес
                ror     (SP)+           ; он чётный
                bcc     10$             ; да - переход
                movb    R0, (R3)        ; а если нечётный - то восстановим содержимое
10$:            return
; ───────────────────────────────────────────────────────────────────────────
                .word 171002            ; команда 2 - Запись файла
                mov     2(R1), ADRDIR   ; Адрес, помещаемый в каталог.  Используется при
                                        ; исполнении EMT36 с кодом операции 202
                br      12$
; ───────────────────────────────────────────────────────────────────────────

M$EERR2:        jsr     R5, OUTERR      ; Вывод сообщения об ошибке
                                        ; код ошибки в слове за вызовом.
                                        ; бит 15 - признак ожидания нажатия клавиши.
                                        ; в этом случае код нажатой клавиши возвращается в R5
                .word 2                 ; сообщение, что диск полон

; ───────────────────────────────────────────────────────────────────────────
                .word 171202            ; команда 202 - Запись по другому адресу
; алгоритм как-то переусложнён.
; стартовый кластер файла можно было хранить в R2,
; одновременно при этом он был бы флагом.
; алгоритм двухпроходный, одни и те же ветки алгоритма используются двояко в зависимости от R2
; сперва ищется дырка подходящего размера, если находится, фиксируется стартовый кластер
; и всё запускается заново, но уже с формированием цепочек фат.
; если дырка не находится, то файл сохраняется с фрагментацией с заполнением дырок от начала диска.

; и как то наоборот сделано, сперва файл записывается на диск, а потом ищется место в каталоге для имени.
; надо делать наоборот.

12$:            cmp     (R1)+, (R1)+    ; указатель на длину записываемого файла
                mov     R1, -(SP)       ; сохраним в стеке
                call    K$EXIST         ; Открытие файла для записи (Перезапись/Дубль)
                                        ; Параметры: Имя в NAMBUF
                                        ; Результат: Бит "C" - файла нет
                                        ; Портит:    R0 - R5
                call    K$RDFAT         ; Чтение FAT с диска
                mov     (SP)+, R1       ; достаём указатель на длину
                mov     (R1), R3        ; длина сохраняемого файла - значение флага стартового кластера
                mov     (R1), -(SP)     ; и в стек её, тут будет храниться стартовый кластер
                mov     -(R1), -(SP)    ; и адрес сохранения тоже в стек
                clr     R2              ; флаг стартового кластера файла
                clr     -(SP)           ; начальный кластер текущего обрабатываемого блока
                mov     #2, R4          ; начальный кластер поиска

13$:            call    K$FRCLA1        ; Поиск пустого кластера, начиная от указанного
                                        ; Параметры: R4 - кластер начала поиска
                                        ; Результат: Номер пустого кластера -> R0 (бит "C" - нет)
                bcs     18$             ; не нашлось пустых кластеров
                tst     (SP)            ; начальный кластер зафиксирован?
                beq     15$             ; 0 - нет ещё, переход
                tst     R2              ; стартовый кластер файла зафиксирован?
                beq     14$             ; 0 - нет ещё, переход
                mov     R0, -(SP)       ; добавляем очередной кластер в цепочку
                mov     R4, R0
                dec     R0
                mov     (SP), R1
                call    K$SETFAT        ; Запись в ячейку FAT
                                        ; Параметры: R0 - номер ячейки, R1 - содержимое
                                        ; Результат: R0 - старое содержимое ячейки
                mov     (SP)+, R0

14$:            cmp     R0, R4          ; найденный кластер сразу за предыдущим?
                beq     17$             ; да - продолжим считать единый блок кластеров
                                        ; нет - файл не влазит в эту дырку, попробуем поискать другую.

15$:            tst     R2              ; стартовый кластер файла зафиксирован?
                bne     22$             ; да, переход к записи блока кластеров в дырку
                mov     R0, (SP)        ; фиксируем начальный кластер блока кластеров

16$:            mov     (SP), R0        ; достаём начальный кластер блока кластеров
                clr     R5              ; начинаем считать размер блока кластеров

17$:            add     #ClusterSize, R5 ; добавляем длину кластера
                cmp     R3, R5          ; файл меньше получившегося блока кластеров?
                blos    19$             ; да, хватит искать
                mov     R0, R4          ; будем искать начиная от следующего за найденным
                inc     R4
                br      13$             ; идём искать дальше

18$:            tst     R2              ; стартовый кластер файла зафиксирован?
                bne     M$EERR2         ; да - не хватает места на диске, ошибка 2
                call    K$FRCLAS        ; поиск пустого кластера
                                        ; Результат: Номер пустого кластера -> R0 (бит "C" - нет)
                bcs     M$EERR2         ; не нашлось пустых кластеров - ошибка 2
                mov     R0, (SP)        ; сохраним найденный пустой кластер, это начальный кластер блока кластеров

19$:            tst     R2              ; стартовый кластер файла зафиксирован?
                bne     21$             ; да, переход к завершению цепочки ФАТ
                                        ; нет - фиксируем стартовый кластер файла и он же будет стартовый кластер блока
                mov     (SP)+, R0
                mov     (SP)+, R2       ; достанем адрес
                bne     20$             ; если он 0
                inc     R2              ; скорректируем, чтоб было не 0, это флаг фиксации стартового кластера файла

20$:            mov     R0, -(SP)       ; стартовый кластер файла
                mov     R0, -(SP)       ; начальный кластер блока кластеров
                br      16$

21$:            mov     R0, -(SP)       ; завершаем цепочку ФАТ
                mov     #7777, R1
                call    K$SETFAT        ; Запись в ячейку FAT
                                        ; Параметры: R0 - номер ячейки, R1 - содержимое
                                        ; Результат: R0 - старое содержимое ячейки
                mov     (SP)+, R0

22$:            mov     (SP), R4         ; номер первого обрабатываемого кластера
                mov     R3, R1          ; остаток длины
                mov     R0, (SP)         ; номер последнего кластера
                call    K$RWCLAS        ; чтение/запись кластера
                                        ; Параметры: R4 - номер первого обрабатываемого кластера
                                        ;            R0 - признак чтения/записи (R0=0 - чтение)
                                        ;            R2 - адрес начала обрабатываемого участка.
                                        ;            R5 - сумма длин обрабатываемых кластеров
                                        ;            R1 - ограничитель (остаток) длины
                                        ; Результат: R1 - длина остатка файла (R1<=0 - файл кончился)
                                        ;            R2 - адрес остатка файла в памяти
                                        ; Портит:    R0, R4
                sub     R5, R3          ; вычитаем записанное от оставшегося
                bhi     16$             ; если ещё что-то осталось, продолжим запись
                tst     (SP)+           ; последний кластер игнорируем
                mov     (SP)+, R4       ; стартовый кластер
                mov     (SP)+, R1       ; длина файла мл.
                clr     R3              ; длина файла ст.
                mov     DATE, R2        ; Системная дата (присв. файлу при записи).
ENDDISKOP:

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Закрытие файла
; Параметры: Имя в NAMBUF
;            ATTRIB - аттрибут
;            SUBDIR - номер родительского подкаталога
;            ADRDIR - адрес
;            R1 - младшая часть 32-битной длины
;            R3 - старшая часть длины (обычно 0)
;            R2 - дата
;            R4 - стартовый кластер
; Портит:    R0 - R5

K$ENDWRT:       mov     R2, -(SP)
                call    K$WRFAT         ; Запись FAT на диск
                call    K$DIRFRE        ; Поиск свободного элемента каталога
                                        ; Результат: R2 - Адрес начала элемента (бит "C" - нет элемента).
                                        ; Портит:    R0 (номер блока диска в буфере)
                bcc     1$              ; в каталоге место нашлось
                mov     R4, R0          ; в каталоге нет места
                call    K$ERASE2        ; Удаление цепочки из FAT
                                        ; Параметры: R0 - кластер начала цепочки
                                        ; Портит:    R0, R1

M$EERR3:        jsr     R5, OUTERR      ; Вывод сообщения об ошибке
                                        ; код ошибки в слове за вызовом.
                                        ; бит 15 - признак ожидания нажатия клавиши.
                                        ; в этом случае код нажатой клавиши возвращается в R5
                .word 3                 ; сообщение, что в каталоге нет места
; ───────────────────────────────────────────────────────────────────────────

1$:             mov     #NAMBUF, R5     ; Буфер имени

2$:             movb    (R5)+, (R2)+    ; копируем имя и атрибут
                cmp     R5, #NAMBUF+14  ; Номер каталога, в который будет помещён файл
                blo     2$
                mov     #12, R5

3$:             clr     (R2)+
                sob     R5, 3$
                mov     R3, -(R2)       ; длина ст.
                mov     R1, -(R2)       ; длина мл.
                mov     R4, -(R2)       ; стартовый кластер
                mov     (SP)+, -(R2)    ; дата
                mov     ADRDIR, -(R2)   ; Адрес, помещаемый в каталог.  Используется при
                                        ; исполнении EMT36 с кодом операции 202
                movb    SUBDIR, -(R2)   ; Номер каталога, в который будет помещён файл
; End of function K$ENDWRT


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Запись блока из буфера
; Параметры: R0 - номер блока на диске

K$WRBLOK:       mov     R1, -(SP)
                mov     #-BlockSizeW, R1
                br      0RDBLK$
; End of function K$WRBLOK


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Чтение блока в буфер
; Параметры: R0 - Номер блока на диске

K$RDBLOK:       mov     R1, -(SP)
                mov     #BlockSizeW, R1

0RDBLK$:        mov     R2, -(SP)
                call    K$RWBUF         ; Чтение/запись в буфер ANDOS с кэшированием
                                        ; Параметры: R0 - Номер блока на диске, R1 - Длина в словах
                                        ; Портит:    R2
                mov     (SP)+, R2
                mov     (SP)+, R1
                return
; End of function K$RDBLOK


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Открытие файла для записи (Перезапись/Дубль)
; Параметры: Имя в NAMBUF
; Результат: Бит "C" - файла нет
; Портит:    R0 - R5

K$EXIST:        call    K$DIRFI1        ; Поиск файла в каталоге (с файлером)
                                        ; Параметры: Имя в NAMBUF
                                        ;            R3 - Адрес блока параметров EMT36 (для файлера)
                                        ; Результат: R2 - Адрес начала элемента (бит "C" - файла нет),
                                        ;            R0 - Номер блока в буфере (блок каталога).
                                        ; Портит:    R0, R1, R2, R5
                bcs     0Ret$
                movb    F$PARD(R2), SUBDIR ; Номер каталога, в который будет помещён файл
                movb    TEKREG, R5      ; Текущий режим записи. Эти две ячейки очень похожи по
                                        ; своей работе на DEVICE и DEVTEK.
                bne     1$

L$Request:      jsr     R5, OUTERR      ; Вывод сообщения об ошибке
                                        ; код ошибки в слове за вызовом.
                                        ; бит 15 - признак ожидания нажатия клавиши.
                                        ; в этом случае код нажатой клавиши возвращается в R5
                .word 100006            ; запрос на перезапись/дубль существующего файла
; ───────────────────────────────────────────────────────────────────────────

1$:             bic     #177740, R5
                cmp     R5, #4          ; дублировать?
                bne     0Overwr$        ; нет, значит перезапись
; End of function K$EXIST


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Переименование файла в .BAK
; Параметры: Имя в NAMBUF
; параметры получаемые в функции EXIST:
; R0 - номер блока каталога на диске
; R2 - адрес записи каталога в буфере
; Портит:    R0, R1, R2, R5

K$DOUBLE:       mov     #NAMEXT, R1     ; Буфер расширения
                mov     (R1), -(SP)
                mov     #"BA, (R1)+
                movb    (R1), -(SP)
                movb    #'K, (R1)       ; сперва поищем файл *.bak
                mov     R2, -(SP)
                mov     R0, -(SP)
                call    K$DIRFI2        ; Поиск файла в каталоге по имени из NAMBUF
                                        ; Параметры: Имя в NAMBUF
                                        ; Результат: R2 - Адрес начала элемента (бит "C" - файла нет),
                                        ;            R0 - Номер блока в буфере (блок каталога).
                                        ; Портит:    R0, R1, R2, R5
                bcs     1$              ; не нашли
                                        ; а если нашли - удалим
                call    K$ERASE1        ; Удаление файла
                                        ; Параметры: R0 - номер блока в буфере,
                                        ;            R2 - адрес записи о файле (в буфере)
                                        ; Портит:    R0, R1, R2
1$:             mov     (SP)+, R0
                call    K$RDBLOK        ; Чтение блока в буфер
                                        ; Параметры: R0 - Номер блока на диске
                mov     (SP)+, R2
                mov     #NAMEXT, R1     ; Буфер расширения
                mov     (R1)+, 10(R2)   ; старому файлу даём имя *.bak
                movb    (R1)+, 12(R2)
                call    K$WRBLOK        ; Запись блока из буфера
                                        ; Параметры: R0 - номер блока на диске
                movb    (SP)+, -(R1)    ; восстанавливаем имя в буфере
                mov     (SP)+, -(R1)
0Ret$:          return
; End of function K$DOUBLE

; ───────────────────────────────────────────────────────────────────────────
0Overwr$:       cmp     R5, #20         ; перезапись?
                bne     L$Request       ; нет, пойдём спрашивать, что делать


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Удаление файла
; Параметры: R0 - номер блока в буфере,
;            R2 - адрес записи о файле (в буфере)
; Портит:    R0, R1, R2

K$ERASE1:       movb    #345, (R2)
                call    K$WRBLOK        ; Запись блока из буфера
                                        ; Параметры: R0 - номер блока на диске
                mov     F$CLUS(R2), R0
; End of function K$ERASE1


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Удаление цепочки из FAT
; Параметры: R0 - кластер начала цепочки
; Портит:    R0, R1

K$ERASE2:       clr     R1
                call    K$RDFAT         ; Чтение FAT с диска

1$:             call    K$SETFAT        ; Запись в ячейку FAT
                                        ; Параметры: R0 - номер ячейки, R1 - содержимое
                                        ; Результат: R0 - старое содержимое ячейки
                cmp     R0, #7777
                bne     1$
; End of function K$ERASE2


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Запись FAT на диск

K$WRFAT:        jsr     R4, PUSH4
                mov     #-FATSizeW, R1
                mov     #3, R0          ; сперва запишем вторую копию ФАТ
                call    K$RWBUF         ; Чтение/запись в буфер ANDOS с кэшированием
                                        ; Параметры: R0 - Номер блока на диске, R1 - Длина в словах
                                        ; Портит:    R2
                br      0RWFAT$         ; затем - первую
; End of function K$WRFAT


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Чтение FAT с диска

K$RDFAT:        jsr     R4, PUSH4
                mov     #FATSizeW, R1

0RWFAT$:        mov     #1, R0
                call    K$RWBUF         ; Чтение/запись в буфер ANDOS с кэшированием
                                        ; Параметры: R0 - Номер блока на диске, R1 - Длина в словах
                                        ; Портит:    R2
                br      1POP4$
; End of function K$RDFAT


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; инициализация работы с диском
; Результат: Кол-во кластеров -> SIZE,
;            бит "C" - диск не в формате ANDOS.

K$INIDRV:       call    K$INIT1         ; Инициализация рабочей области драйвера НГМД
                                        ; Результат: Кол-во кластеров -> SIZE,
                                        ;            бит "C" - диск не в формате ANDOS.
; точка входа из функции оболочки Disk Master
M$INIDRV:       jsr     R4, PUSH4
                mov     #DRVTAB+D$TDOWN, R2
                movb    DEVTEK, R0      ; Временное текущее устройство. Совпадает с DEVICE при
                                        ; запуске операции, изменяется при явном указании
                                        ; устройства в имени
                mov     #DRVTAB+D$FLGTAB, R3 ; адрес таблицы признаков
                mov     #DRV$A, R4
                dec     R0
                movb    R0, D$UNIT-D$TDOWN(R2) ; привод
                beq     1$
                inc     R3
                mov     #DRV$B, R4

1$:             clrb    (R3)            ; очистим признаки привода
                mov     (R4)+, (R2)+    ; задержка опускания головки
                mov     (R4)+, (R2)+    ; задержка перехода с дорожки на дорожку
                movb    (R4)+, (R2)+    ; дорожка начала прекоррекции
                clr     R0
                mov     #BlockSizeW, R1 ; читаем BOOT в буфер
                call    K$RWBUF1        ; Чтение/запись в буфер без кэширования
                                        ; Параметры: R0 - Номер блока на диске, R1 - Длина в словах
                                        ; Портит:    R2
                mov     #FSYS, R1       ; проверяем файловую систему
                add     #13, R2
                mov     #10, R5
                call    CMPSB
                bcs     1POP4$          ; не DOS - выход
                movb    (R2)+, -(SP)
                movb    (R2)+, 1(SP)
                inc     R2
                mov     #4, R5
                call    CMPSB
                bcs     4$
                mov     #1512, R0
                asrb    (R2)
                rolb    (R3)
                beq     2$
                asr     R0

2$:             tstb    (R4)
                bpl     3$
                cmp     (SP), R0

3$:             rolb    (R3)
                asr     (SP)
                asr     (SP)
                sub     #3, (SP)

4$:             mov     (SP)+, SIZE     ; Общее количество кластеров на диске. Определяется
                                        ; подпрограммой INIDRV после считывания таблицы
                                        ; параметров из загрузчика
1POP4$:         jmp     POP4R           ; восстановить R0-R4 и ret
; End of function K$INIDRV


; ███████████████ S U B R O U T I N E ███████████████████████████████████████


CMPSB:          cmpb    (R1)+, (R2)+
                bne     L$RetC
                sob     R5, CMPSB
                return
; End of function CMPSB


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Инициализация рабочей области драйвера НГМД
; Результат: Кол-во кластеров -> SIZE,
;            бит "C" - диск не в формате ANDOS.

K$INIT1:        mov     #DRVTAB, R2     ; таблица параметров драйвера дисковода
                clr     (R2)+           ; очистим копию рег. 177130 по записи
                clr     (R2)+           ; очистим адрес текущей дорожки
                mov     #-1, (R2)       ; инициализируем таблицу
                mov     (R2)+, (R2)+    ; текущих дорожек
                clrb    6(R2)           ; очистим флаги
                return
; End of function K$INIT1

; ───────────────────────────────────────────────────────────────────────────
; константы на определение принадлежности диска к ANDOS
FSYS:           .byte 0, 2,   4, 1
                .byte 0, 2, 160, 0
                .byte 2, 0,  12, 0

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; чтение/запись кластера
; Параметры: R4 - номер первого обрабатываемого кластера
;            R0 - признак чтения/записи (R0=0 - чтение)
;            R2 - адрес начала обрабатываемого участка.
;            R5 - сумма длин обрабатываемых кластеров
;            R1 - ограничитель (остаток) длины
; Результат: R1 - длина остатка файла (R1<=0 - файл кончился)
;            R2 - адрес остатка файла в памяти
; Портит:    R0, R4

K$RWCLAS:       mov     R1, -(SP)
                cmp     R1, R5
                blos    1$
                mov     R5, R1

1$:             inc     R4
                asl     R4
                asl     R4              ; № кластера в № блока
                inc     R1
                clc
                ror     R1              ; длину в байтах в длину в словах
                                        ; если длина нечётная - то в словах получается на 1 байт больше
                                        ; поэтому он портится и его надо восстанавливать.
                tst     R0
                beq     2$
                neg     R1

2$:             mov     R4, R0
                call    K$RWBLOK        ; Чтение/запись
                                        ; Параметры: R0 - Номер блока на диске, R2 - Адрес,
                                        ;            R1 - Длина в словах
                add     R5, R2
                mov     (SP)+, R1
                sub     R5, R1
                return
; End of function K$RWCLAS


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Поиск команд и перепаковка имени
; Параметры: R1 - адрес блока параметров EMT36
; Результат: Имя -> NAMBUF
;            Бит "С" - операция с магнитофоном
; Портит:    R0, R2, R3, R4, R5

K$DONAME:       mov     R1, R3
                add     #7, R3          ; начинаем поиск со второго символа имени
                cmpb    (R3), #'?       ; второй символ '?'
                bne     1$              ; нет
                mov     #TEKREG, R5     ; Текущий режим записи. Эти две ячейки очень похожи по
                                        ; своей работе на DEVICE и DEVTEK.
                call    SetNmParam      ; Вход: R5 - адрес устанавливаемого параметра
                                        ; R3 - адрес символа определителя параметра
                beq     2$              ; если нет имени, но есть расширение - переход
                inc     R3              ; если что-то есть или ничего нет

1$:             cmpb    (R3), #':       ; проверим, есть ли имя привода в имени
                bne     3$              ; нету
                mov     #DEVTEK, R5     ; Временное текущее устройство. Совпадает с DEVICE при
                                        ; запуске операции, изменяется при явном указании
                                        ; устройства в имени
                call    SetNmParam      ; Вход: R5 - адрес устанавливаемого параметра
                                        ; R3 - адрес символа определителя параметра
                bne     4$

2$:             movb    (R5), -(R5)
                halt                    ; выход по аварийной ситуации
; ───────────────────────────────────────────────────────────────────────────

3$:             dec     R3

4$:             tstb    DEVTEK          ; Временное текущее устройство. Совпадает с DEVICE при
                                        ; запуске операции, изменяется при явном указании
                                        ; устройства в имени
                beq     L$RetC
                cmpb    (R3), #'-       ; команда удаления есть?
                bne     5$              ; нету
                inc     R3              ; есть - зададим удаление
                movb    #200, COMAND    ; Мл.байт - команда EMT36. В эту ячейку заносится код
                                        ; команды из первого байта блока параметров EMT36, он
                                        ; может изменятся командами ANDOS
                                        ; Ст.байт - дескриптор команды

5$:             cmpb    (R3), #':       ; а если есть запрос на вывод каталога, отменим удаление
                bne     K$CONNAM        ; Перепаковка и логическая обработка имени
                                        ; Параметры: R3 - начало строки, R1+22. - конец
                                        ; Результат: Имя -> NAMBUF
                                        ; Портит:    R0, R2, R3, R4, R5
                clrb    COMAND          ; Мл.байт - команда EMT36. В эту ячейку заносится код
                                        ; команды из первого байта блока параметров EMT36, он
                                        ; может изменятся командами ANDOS
                                        ; Ст.байт - дескриптор команды
; End of function K$DONAME

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Перепаковка и логическая обработка имени
; Параметры: R3 - начало строки, R1+22. - конец
; Результат: Имя -> NAMBUF
; Портит:    R0, R2, R3, R4, R5

K$CONNAM:       mov     #NAMBUF+13, R5  ; очистим буфер имени

1$:             movb    #40, -(R5)
                cmp     R5, #NAMBUF     ; Буфер имени
                bhi     1$
                call    K$ENAME         ; Поиск конца строки и точки
                                        ; Параметры: R3 - начало строки, R1+22. - конец
                                        ; Результат: Адрес последнего символа строки -> R0
                                        ;            Адрес символа после "точки" -> R4
                                        ;            Адрес последнего символа перед точкой -> R2
                                        ;            бит "C" - нет имени и расширения
                                        ;            бит "Z" - нет имени, есть расширение
                                        ;            R4 > R0 - есть имя, нет расширения
                                        ; Портит:    R0, R2, R4
                bcs     10$
                beq     4$

2$:             cmp     R3, R2
                bhis    3$
                movb    (R3)+, (R5)+
                cmp     R5, #NAMBUF+7   ; Буфер имени
                blo     2$

3$:             movb    (R2), (R5)+

4$:             mov     #NAMEXT, R5     ; Буфер имени
                mov     #3, R3

5$:             cmp     R4, R0
                bhi     6$
                movb    (R4)+, (R5)+
                sob     R3, 5$
                movb    (R0), -(R5)
                nop

6$:             mov     #NAMBUF, R5     ; Буфер имени
                cmpb    (R5), #345      ; Русскую Е
                bne     7$
                movb    #105, (R5)      ; заменим на английскую, чтобы не считался файл удалённым

7$:             mov     #13, R0

8$:             bitb    #140, (R5)+     ; это печатный символ?
                bne     9$              ; да
                movb    #40, -1(R5)     ; непечатные заменим пробелами

9$:             sob     R0, 8$
10$:            tst     (PC)+
L$RetC:         sec
                return
; End of function K$CONNAM


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Вход: R5 - адрес устанавливаемого параметра
; R3 - адрес символа определителя параметра

SetNmParam:     movb    -(R3), (R5)
                bicb    #340, (R5)
                tst     (R3)+
; End of function SetNmParam


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Поиск конца строки и точки
; Параметры: R3 - начало строки, R1+22. - конец
; Результат: Адрес последнего символа строки -> R0
;            Адрес символа после "точки" -> R4
;            Адрес последнего символа перед точкой -> R2
;            бит "C" - нет имени и расширения
;            бит "Z" - нет имени, есть расширение
;            R4 > R0 - есть имя, нет расширения
; Портит:    R0, R2, R4

K$ENAME:        mov     R1, R2
                add     #22., R2        ; конец строки
                call    K$RTRIM         ; Вход: R3 - начало строки
                                        ;       R2 - конец буфера строки+1
                                        ; Выход:R2 - указатель на последний символ в строке
                                        ;       Z - пустая строка
                beq     L$RetC          ; строка пустая - выход
                mov     R2, R0
                mov     R3, R4

1$:             cmp     R4, R0
                bhi     1Ret$
                cmpb    (R4)+, #'.
                bne     1$
                mov     R4, R2
                dec     R2


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Вход: R3 - начало строки
;       R2 - конец буфера строки+1
; Выход:R2 - указатель на последний символ в строке
;       Z - пустая строка

K$RTRIM:        cmp     R2, R3          ; дошли до начала?
                beq     1Ret$           ; да - выход
                cmpb    -(R2), #40      ; замыкающий пробел ?
                beq     K$RTRIM         ; да - удаляем
                tstb    (R2)            ; 0?
                beq     K$RTRIM         ; да - удаляем
                bitb    #140, (R2)      ; непечатный символ?
                beq     K$RTRIM         ; да - тоже удаляем
1Ret$:          return
; End of function K$RTRIM
; End of function K$ENAME


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; поиск пустого кластера
; Результат: Номер пустого кластера -> R0 (бит "C" - нет)

K$FRCLAS:       mov     R4, -(SP)
                mov     #2, R4
                tst     (PC)+
; End of function K$FRCLAS


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Поиск пустого кластера, начиная от указанного
; Параметры: R4 - кластер начала поиска
; Результат: Номер пустого кластера -> R0 (бит "C" - нет)

K$FRCLA1:       mov     R4, -(SP)
                dec     R4

1$:             cmp     SIZE, R4        ; Общее количество кластеров на диске. Определяется
                                        ; подпрограммой INIDRV после считывания таблицы
                                        ; параметров из загрузчика
                blo     2$
                inc     R4
                mov     R4, R0
                call    K$GETFAT        ; Распаковка ячейки FAT
                                        ; Параметры: R0 - Номер ячейки FAT
                                        ; Результат: R0 - Содержимое ячейки
                tst     R0
                bne     1$
                mov     R4, R0
2$:             br      2Ret4$
; End of function K$FRCLA1


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Поиск элементов каталога
; Параметры: Перед первым запуском очистить R0
; Результат: R4 - Адрес начала элемента (R4=0 - конец каталога)
;            бит "Z" - конец каталога
; Не портить R0, R4

K$DIRENT:       tst     R0
                bne     3$
                mov     #5, R0

1$:             call    K$RDBLOK        ; Чтение блока в буфер
                                        ; Параметры: R0 - Номер блока на диске
                movb    #20, SUBDIR+1   ; Номер каталога, в который будет помещён файл
                mov     IOBUFF, R4      ; Адрес буфера ANDOS (125000)
                return

2$:             add     #40, R4
                return

3$:             decb    SUBDIR+1        ; Номер каталога, в который будет помещён файл
                bne     2$
                inc     R0
                cmp     R0, #13
                ble     1$
                clr     R4
                return
; End of function K$DIRENT


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Поиск заполненных элементов каталога
; Параметры: Перед первым запуском очистить R0
; Результат: R4 - Адрес начала элемента
;            бит "Z" - конец каталога
; Не портить R0, R4

K$DIREN2:       call    K$DIRENT        ; Поиск элементов каталога
                                        ; Параметры: Перед первым запуском очистить R0
                                        ; Результат: R4 - Адрес начала элемента (R4=0 - конец каталога)
                                        ;            бит "Z" - конец каталога
                                        ; Не портить R0, R4
                beq     1$
                cmpb    (R4), #345
                beq     K$DIREN2        ; Поиск заполненных элементов каталога
                                        ; Параметры: Перед первым запуском очистить R0
                                        ; Результат: R4 - Адрес начала элемента
                                        ;            бит "Z" - конец каталога
                                        ; Не портить R0, R4
                tstb    (R4)
                beq     1$
                tst     F$CLUS(R4)
                beq     K$DIREN2        ; Поиск заполненных элементов каталога
                                        ; Параметры: Перед первым запуском очистить R0
                                        ; Результат: R4 - Адрес начала элемента
                                        ;            бит "Z" - конец каталога
                                        ; Не портить R0, R4
1$:             return
; End of function K$DIREN2


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Поиск файла в каталоге по имени из NAMBUF
; Параметры: Имя в NAMBUF
; Результат: R2 - Адрес начала элемента (бит "C" - файла нет),
;            R0 - Номер блока в буфере (блок каталога).
; Портит:    R0, R1, R2, R5

K$DIRFI2:       mov     #NAMBUF, R1     ; Буфер имени


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Поиск файла в каталоге
; Параметры: R1 - Адрес буфера имени
; Результат: R2 - Адрес начала элемента (бит "C" - файла нет),
;            R0 - Номер блока в буфере (блок каталога).
; Портит:    R0, R2, R5

K$DIRFIN:       mov     R4, -(SP)
                clr     R0

1$:             call    K$DIREN2        ; Поиск заполненных элементов каталога
                                        ; Параметры: Перед первым запуском очистить R0
                                        ; Результат: R4 - Адрес начала элемента
                                        ;            бит "Z" - конец каталога
                                        ; Не портить R0, R4
                beq     2RetC$
                mov     R4, R2
                mov     R1, -(SP)
                mov     #13, R5
                call    CMPSB
                mov     (SP)+, R1
                bcs     1$
                br      2Ret$
; End of function K$DIRFIN
; End of function K$DIRFI2


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Поиск свободного элемента каталога
; Результат: R2 - Адрес начала элемента (бит "C" - нет элемента).
; Портит:    R0 (номер блока диска в буфере)

K$DIRFRE:       mov     R4, -(SP)
                clr     R0

1$:             call    K$DIRENT        ; Поиск элементов каталога
                                        ; Параметры: Перед первым запуском очистить R0
                                        ; Результат: R4 - Адрес начала элемента (R4=0 - конец каталога)
                                        ;            бит "Z" - конец каталога
                                        ; Не портить R0, R4
                beq     2RetC$
                tstb    (R4)
                beq     2Ret$
                cmpb    (R4), #345
                bne     1$

2Ret$:          mov     R4, R2
                tst     (PC)+
2RetC$:         sec
2Ret4$:         mov     (SP)+, R4
L$Ret2$:        return
; End of function K$DIRFRE


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Поиск файла в каталоге с выдачей сообщения
; Параметры: Имя в NAMBUF
;            R3 - Адрес блока параметров EMT36 (для файлера)
; Результат: R2 - Адрес начала элемента (бит "C" - файла нет),
;            R0 - Номер блока в буфере (блок каталога).
; Портит:    R0, R1, R2, R5

K$FIND:         call    K$DIRFI1        ; Поиск файла в каталоге (с файлером)
                                        ; Параметры: Имя в NAMBUF
                                        ;            R3 - Адрес блока параметров EMT36 (для файлера)
                                        ; Результат: R2 - Адрес начала элемента (бит "C" - файла нет),
                                        ;            R0 - Номер блока в буфере (блок каталога).
                                        ; Портит:    R0, R1, R2, R5
                bcc     L$Ret2$
E$EERR: ; выход из эмулятора МикроДос по ошибке
        ; а ещё в оболочке используется
                jsr     R5, OUTERR      ; Вывод сообщения об ошибке
                                        ; код ошибки в слове за вызовом.
                                        ; бит 15 - признак ожидания нажатия клавиши.
                                        ; в этом случае код нажатой клавиши возвращается в R5
                .word 4                 ; сообщение, что файл не найден
; End of function K$FIND


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Поиск файла в каталоге (с файлером)
; Параметры: Имя в NAMBUF
;            R3 - Адрес блока параметров EMT36 (для файлера)
; Результат: R2 - Адрес начала элемента (бит "C" - файла нет),
;            R0 - Номер блока в буфере (блок каталога).
; Портит:    R0, R1, R2, R5

K$DIRFI1:       mov     #NAMBUF, R1     ; Буфер имени
                mov     #10, R0

1$:             cmpb    (R1)+, #40
                bne     K$DIRFI2        ; Поиск файла в каталоге по имени из NAMBUF
                                        ; Параметры: Имя в NAMBUF
                                        ; Результат: R2 - Адрес начала элемента (бит "C" - файла нет),
                                        ;            R0 - Номер блока в буфере (блок каталога).
                                        ; Портит:    R0, R1, R2, R5
                sob     R0, 1$
                jsr     R5, K$RUNNER    ; Вызов подпрограммы с проверкой целостности
                                        ; Результат: Бит "C" - подпрограмма отключена или уничтожена
                                        ; Портит:    R0, R5
                .word FILER             ; Признак включения/адрес файлера
                bcc     L$Ret2$
; End of function K$DIRFI1


; ███████████████ S U B R O U T I N E ███████████████████████████████████████


OUTDIR:         clr     R0
                clr     R3
                clr     -(SP)

1$:             call    K$DIREN2        ; Поиск заполненных элементов каталога
                                        ; Параметры: Перед первым запуском очистить R0
                                        ; Результат: R4 - Адрес начала элемента
                                        ;            бит "Z" - конец каталога
                                        ; Не портить R0, R4
                beq     8$

2$:             bit     #100, @#177716
                bne     4$
                jsr     R5, GETCH       ; получение кода нажатой клавиши
                                        ; Выход: R5 - скан код клавиши в мл.байте, старший остаётся не затронутым
                movb    (R4), R1
                cmpb    R5, #40
                beq     2$
                bhi     3$
                movb    F$EXT(R4), R1
                sub     #100, R1
3$:             sub     R1, R5
                bic     #177640, R5
                bne     1$
4$:             mov     R0, -(SP)
                mov     R4, R1
                call    OUTNME          ; вывод имени файла.
                                        ; с точкой между именем и расширением
                mov     F$LEN(R4), R1
                mov     R1, -(SP)

5$:             inc     R2
                sub     #ClusterSize, R1
                bhi     5$
                mov     F$LENH(R4), R1
                beq     7$
                clr     (SP)

6$:             add     #40, R2
                sob     R1, 6$

7$:             add     R2, R3
                call    OUTDEC          ; вывод числа в десятичном формате, с подавлением ведущих нулей
                                        ; вход:  R2 - число
                mov     F$ADDR(R4), R2
                call    OUTNUM          ; вывод числа в восьмеричном формате, с подавлением ведущих нулей
                                        ; вход:  R2 - число
                mov     (SP)+, R2
                call    OUTNUM          ; вывод числа в восьмеричном формате, с подавлением ведущих нулей
                                        ; вход:  R2 - число
                mov     (SP)+, R0
                jsr     R4, PUTS
                .asciz <12>
                .even
                inc     (SP)
                br      1$
; ───────────────────────────────────────────────────────────────────────────

8$:             call    K$RDFAT         ; Чтение FAT с диска
                mov     (SP)+, R2
                call    OUTDEC          ; вывод числа в десятичном формате, с подавлением ведущих нулей
                                        ; вход:  R2 - число
                jsr     R4, PUTS
                .asciz " files"
                .even
                mov     R3, R2
                call    OUTDEC          ; вывод числа в десятичном формате, с подавлением ведущих нулей
                                        ; вход:  R2 - число
                jsr     R4, PUTS
                .asciz " used"
                .even
                clr     R2
                call    K$FRCLAS        ; поиск пустого кластера
                                        ; Результат: Номер пустого кластера -> R0 (бит "C" - нет)
                bcs     10$

9$:             inc     R2
                mov     R0, R4
                inc     R4
                call    K$FRCLA1        ; Поиск пустого кластера, начиная от указанного
                                        ; Параметры: R4 - кластер начала поиска
                                        ; Результат: Номер пустого кластера -> R0 (бит "C" - нет)
                bcc     9$

10$:            call    OUTDEC          ; вывод числа в десятичном формате, с подавлением ведущих нулей
                                        ; вход:  R2 - число
                jsr     R4, PUTS
                .asciz " free"<12>
                .even
L$Hlt:          halt
; End of function OUTDIR


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Чтение/запись в буфер ANDOS с кэшированием
; Параметры: R0 - Номер блока на диске, R1 - Длина в словах
; Портит:    R2

K$RWBUF:        tst     R1
                bmi     K$RWBUF1        ; Чтение/запись в буфер без кэширования
                                        ; Параметры: R0 - Номер блока на диске, R1 - Длина в словах
                                        ; Портит:    R2
                cmp     R0, TEKBLK      ; Номер блока диска, находящегося в буфере
                bne     K$RWBUF1        ; Чтение/запись в буфер без кэширования
                                        ; Параметры: R0 - Номер блока на диске, R1 - Длина в словах
                                        ; Портит:    R2
                return
; End of function K$RWBUF


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Чтение/запись в буфер без кэширования
; Параметры: R0 - Номер блока на диске, R1 - Длина в словах
; Портит:    R2

K$RWBUF1:       mov     IOBUFF, R2      ; Адрес буфера ANDOS (125000)
                mov     R0, TEKBLK      ; Номер блока диска, находящегося в буфере
; End of function K$RWBUF1


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Чтение/запись
; Параметры: R0 - Номер блока на диске, R2 - Адрес,
;            R1 - Длина в словах

K$RWBLOK:       mov     R5, -(SP)
                clr     -(SP)           ; флаг, будем делать две попытки при ошибке

1$:             jsr     R4, PUSH4
                mov     #DRVTAB, R3     ; таблица параметров драйвера дисковода
                call    @DRIVER         ; Адрес входа "чтение/запись блока " драйвера НГМД
                                        ; (160004). Может использоваться для обслуживания
                                        ; нестандартных устройств, например виртуального диска)
                bcc     4$
                mov     #DskErrNum, R2
                movb    @#ERRFDD, (R2)
                cmpb    (R2), #7        ; нажали кнопку СТОП?
                beq     L$Hlt           ; да - ну и стоп тогда
                bisb    #'0, (R2)       ; иначе, сформируем номер ошибки
                cmpb    D$UNIT(R3), #1
                bhi     2$
                mov     (R3), R2        ; дёрнем головкой
                bis     #300, R2        ; сперва на шаг к центру
                mov     R2, (R4)
                mov     D$TSTEP(R3), R0
                sob     R0, .
                bic     #100, R2        ; потом назад
                mov     R2, (R4)
                com     12(SP)          ; какая попытка?
                bne     3$              ; !0 - сделаем вторую попытку, 0 - всё равно ошибка
2$:             jsr     R5, OUTERR      ; Вывод сообщения об ошибке
                                        ; код ошибки в слове за вызовом.
                                        ; бит 15 - признак ожидания нажатия клавиши.
                                        ; в этом случае код нажатой клавиши возвращается в R5
                .word 100005            ; сообщение о номерной дисковой ошибке

                call    K$INIT1         ; Инициализация рабочей области драйвера НГМД
                                        ; Результат: Кол-во кластеров -> SIZE,
                                        ;            бит "C" - диск не в формате ANDOS.
3$:             sec
4$:             jsr     R4, POP4
                bcs     1$
                tst     (SP)+
                br      3Ret$
; End of function K$RWBLOK


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Распаковка ячейки FAT
; Параметры: R0 - Номер ячейки FAT
; Результат: R0 - Содержимое ячейки

K$GETFAT:       mov     R0, -(SP)
                asl     (SP)
                add     (SP)+, R0
                ror     R0
                mfps    -(SP)
                add     IOBUFF, R0      ; Адрес буфера ANDOS (125000)
                mov     R0, ADRFAT      ; адрес текущей ячейки FAT в буфере
                movb    (R0)+, -(SP)
                movb    (R0)+, 1(SP)
                mov     (SP)+, R0
                mtps    (SP)
                bcc     1$
                asr     R0
                asr     R0
                asr     R0
                asr     R0

1$:             bic     #170000, R0
                mtps    (SP)+
                return
; End of function K$GETFAT


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Запись в ячейку FAT
; Параметры: R0 - номер ячейки, R1 - содержимое
; Результат: R0 - старое содержимое ячейки

K$SETFAT:       call    K$GETFAT        ; Распаковка ячейки FAT
                                        ; Параметры: R0 - Номер ячейки FAT
                                        ; Результат: R0 - Содержимое ячейки
                mov     R5, -(SP)
                mov     ADRFAT, R5      ; адрес текущей ячейки FAT в буфере
                mov     R1, -(SP)
                bcc     1$
                bicb    #360, (R5)+
                bicb    #377, (R5)
                asl     (SP)
                asl     (SP)
                asl     (SP)
                asl     (SP)
                br      2$

1$:             bicb    #377, (R5)+
                bicb    #17, (R5)
                bic     #170000, (SP)
2$:             bisb    1(SP), (R5)
                bisb    (SP)+, -(R5)
3Ret$:          mov     (SP)+, R5
                return
; End of function K$SETFAT


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Вызов подпрограммы с проверкой целостности
; Результат: Бит "C" - подпрограмма отключена или уничтожена
; Портит:    R0, R5

K$RUNNER:       mov     @(R5)+, R0      ; получим адрес входа
                beq     3RetC$
                cmp     (R0)+, #104130  ; если первое слово такое
                bne     3RetC$
                mov     R5, (SP)        ; то адрес возврата в стек
                mov     R0, PC          ; и JMP (R0)
; End of function K$RUNNER


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Вывод сообщения об ошибке
; код ошибки в слове за вызовом.
; бит 15 - признак ожидания нажатия клавиши.
; в этом случае код нажатой клавиши возвращается в R5

OUTERR:         mov     #ERRTXT-2, R4   ; список сообщений об ошибках
                movb    (R5), R3        ; номер сообщения об ошибке

1$:             tstb    (R4)+
                bne     1$
                sob     R3, 1$          ; подведём указатель к началу сообщения
                mov     USRERR, R3      ; Ячейка перехвата сообщений об ошибках. См. раздел
                                        ; "Обработка ошибок"
                bne     0Jmp$           ; если пользователь не перехватил вывод, выведем сами
                jsr     R4, PUTS
                .asciz <12><7>"ANDOS - "
                .even

                call    K$PRT1          ; Вывод строки на экран
                                        ; Параметры: R4 - Адрес строки.
                tst     (R5)            ; ожидать нажатия клавиши?
                bpl     3$              ; нет

2$:             bit     #100, @#177716  ; ждём
                bne     2$

3$:             jsr     R4, PUTS
                .asciz <12>
                .even
                tst     (R5)+           ; ещё раз, ожидать нажатия клавиши?
                bpl     0Hlt$           ; нет - сразу стоп
                                        ; да  - получим в R5 код нажатой клавиши
; End of function OUTERR


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; получение кода нажатой клавиши
; Выход: R5 - скан код клавиши в мл.байте, старший остаётся не затронутым

GETCH:          movb    @#177662, (SP)
                clrb    @#105
                nop
                nop

3RetC$:         sec
                rts     R5
; End of function GETCH

0Jmp$:          mov     (R5)+, -(SP)
                rts     R3

; ███████████████ S U B R O U T I N E ███████████████████████████████████████


PUTS:           call    K$PRT1          ; Вывод строки на экран
                                        ; Параметры: R4 - Адрес строки.
                inc     R4
                bic     #1, R4
                rts     R4
; End of function PUTS


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Вывод строки на экран
; Параметры: R4 - Адрес строки.

K$PRT1:         mov     R0, -(SP)

1$:             movb    (R4)+, R0
                beq     3$              ; если строка закончилась - выход
                cmp     R0, #1          ; код 1 ?
                beq     2$              ; означает вывод имени файла
                call    OUTCHR
                br      1$

2$:             mov     R1, -(SP)
                mov     R2, -(SP)
                mov     #NAMBUF, R1     ; Буфер имени
                call    OUTNME          ; вывод имени файла.
                                        ; с точкой между именем и расширением
                mov     (SP)+, R2
                mov     (SP)+, R1
                br      1$

3$:             mov     (SP)+, R0
                return
; End of function K$PRT1


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; вывод имени файла.
; с точкой между именем и расширением

OUTNME:         mov     #14, R2

1$:             movb    #'., R0
                cmp     R2, #4
                beq     2$
                movb    (R1)+, R0

2$:             call    OUTCHR
                sob     R2, 1$
                return
; End of function OUTNME


; ███████████████ S U B R O U T I N E ███████████████████████████████████████


OUTCHR:         mov     SCREEN, -(SP)   ; Вывод сообщений перехвачен?
                bne     1$              ; да - выполним п/п перехвата
                tst     (SP)+           ; нет
                emt     16              ; просто выведем символ как обычно
1$:             return
; End of function OUTCHR


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; вывод числа в десятичном формате, с подавлением ведущих нулей
; вход:  R2 - число, максимум трёхзначное

OUTDEC:         jsr     R4, PUSH4
                mov     R2, R1
                mov     #DECCONST, R4   ; константы десятичных порядков
                br      3$

1$:             inc     R0
2$:             sub     R3, R1
                bpl     1$
                add     R3, R1
                cmp     R2, R3
                bhis    4$

3$:             mov     #40, R0
4$:             call    OUTCHR

                mov     #'0, R0
                movb    -(R4), R3
                bne     2$
                add     R1, R0
                call    OUTCHR
                jmp     POP4R          ; восстановить R0-R4 и ret
; End of function OUTDEC

; ───────────────────────────────────────────────────────────────────────────
0Hlt$:          halt    ; останов и одновременно - ограничитель
; ───────────────────────────────────────────────────────────────────────────
                .byte 10.
                .byte 100.
DECCONST:

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; вывод числа в восьмеричном формате, с подавлением ведущих нулей
; вход:  R2 - число

OUTNUM:         jsr     R4, PUTS
                .asciz " "
                .even
                clr     R0
                mov     #6, R1
                br      2$

1$:             clr     R0
                rol     R2
                rol     R0
                rol     R2
                rol     R0

2$:             rol     R2
                rol     R0
                add     #'0, R0
                call    OUTCHR
                sob     R1, 1$
                return
; End of function OUTNUM

; ── Список сообщений об ошибках ────────────────────────────────────────────
ERRTXT:         .asciz "Non-DOS disk"
                .asciz "Disk full"
                .asciz "DIR full"
                .asciz <1>" not found"
                .ascii "Disk error #"
K$CHKEND:
DskErrNum:      .byte 60,0
                .asciz <1>" exist P/D:"
                .asciz <1>", delete?"
                .even
; ───────────────────────────────────────────────────────────────────────────
BUFFERLEN   = 1200      ; размер буфера АНДОС в байтах
; Изначально в нём находится модуль начальной инициализации
BUFFER:
; ===========================================================================
; модуль начальной инициализации, который находится в буфере АНДОС
; Вход: R5 - Конфигурация ЭВМ (60000 - БК11(М), 140000 - БК10+16,
;                              140002 - БК10+8, 140001 - БК10+4)
StartIni:       movb    D$UNIT(R3), DEVICE
                incb    DEVICE          ; Текущее устройство (0-@:, 1-32 - A:-Z:)
                mov     #MASTER, R2     ; Признак включения/адрес оболочки
                cmp     R5, #140002     ; Это БК10+8кБ ?
                bne     1$              ; нет
                clr     (R2)+           ; да - для оболочки места нет

1$:             bit     #1, R5          ; это БК10+4кБ ?
                beq     2$              ; нет, есть 16 БК ОЗУ
                clr     (R2)+           ; очищаем признак наличия файлёра, для него места нет
                clr     (R2)+           ; очищаем признак наличия эмулятора микродос, для него места нет
                clr     @#INIPRN        ; очищаем адрес подпрограммы инициализации принтера, для драйвера принтера места нет
                br      3$
; ───────────────────────────────────────────────────────────────────────────

2$:             mov     R5, CONFIG      ; сохраняем конфигурацию
                                        ; Конфигурация ЭВМ (60000 - БК11(М), 140000 - БК10+16,
                                        ; 140002 - БК10+8, 140001 - БК10+4)
                bmi     3$              ; если БК10, переход
                tstb    @#DEVTEK        ; Временное текущее устройство. Совпадает с DEVICE при
                                        ; запуске операции, изменяется при явном указании
                                        ; устройства в имени
                beq     3$              ; 0 - не надо инициализировать виртуальный диск
                                        ; !0 - надо
                mov     #V$ENTRY, DRIVER ; Адрес входа "чтение/запись блока " драйвера НГМД
                                        ; (160004). Может использоваться для обслуживания
                                        ; нестандартных устройств, например виртуального диска)
                movb    #5, DEVTEK      ; Привод E - виртуальный диск на БК11
                mov     #INIERR, USRERR ; При любой ошибке будет выполнена инициализация виртуального диска
                mov     #2100, IOBUFF   ; Временный буфер будет там
                call    @INIDRV         ; инициализируем виртуальный диск E
                bcc     3$              ; если без ошибок - то он уже был
                ; создание структуры виртуального диска

INIERR:         mov     #776, SP
                mov     #6200, @#177716 ; окно 0 - стр.1, окно 1 - стр.4
                call    ClrPage         ; очищаем стр 1
                mov     #16200, @#177716 ; окно 0 - стр.5, окно 1 - стр.4
                mov     #1000, R2
                movb    #230, 23(R2)
                clrb    24(R2)
                mov     #-40, R1
                call    @RWBLOK         ; Чтение/запись
                                        ; Параметры: R0 - Номер блока на диске, R2 - Адрес,
                                        ;            R1 - Длина в словах

3$:             clr     USRERR          ; очищаем ячейку перехвата сообщений об ошибках.
                mov     #BUFFER, IOBUFF ; восстанавливаем стандартный адрес буфера ANDOS

                mov     DATE, (PC)+     ; Системная дата (присв. файлу при записи).
CURRDATE:       .word 0
                mov     #INIV60, @#60   ; обработка прерывания от клавиатуры в заставке
                mov     @#60, @#274
                clr     @#177660
                jmp     @#3640          ; продолжим выполнение заставки

; ───────────────────────────────────────────────────────────────────────────
                .ascii "Это кто еще тут копается? Кышшш!"
                .even
; ───────────────────────────────────────────────────────────────────────────
; обработка прерывания от клавиатуры в заставке
INIV60:         jsr     R4, @#PUSH4
                mov     R5, -(SP)
                mov     #1000, R0
                tst     @#4626
                blos    1$
                dec     R0

1$:             mov     R0, @#4626
                mov     #2, R2          ; длительность звука
                call    @#102056        ; звук и приём кода
                mov     #CURRDATE, R1
                cmpb    R0, #32         ; это стрелка вверх?
                bne     2$              ; нет
                ; увеличение даты
                cmp     (R1), #23637    ; дата 31.12.1999
                bhis    4$              ; если больше или столько же, всё, предел
                inc     (R1)            ; иначе - увеличиваем
                call    CorrectDate     ; корректируем
                br      4$

2$:             cmpb    R0, #33         ; это стрелка вниз?
                bne     3$              ; нет
                ; уменьшение даты
                cmp     (R1), #41       ; дата 01.01.1980
                blos    4$              ; если меньше или столько же, всё, предел
                dec     (R1)            ; иначе уменьшим
                call    CorrectDate     ; корректируем

4$:             call    DateOut         ; выводим текущую дату
                jmp     @#101322        ; восстановить R0-R5 и rti
; ───────────────────────────────────────────────────────────────────────────

3$:             tst     CONFIG          ; это БК10 ?
                                        ; Конфигурация ЭВМ (60000 - БК11(М), 140000 - БК10+16,
                                        ; 140002 - БК10+8, 140001 - БК10+4)
                bmi     5$              ; да - переход
                mov     #47000, @#177662 ; нет - устанавливаем палитру

5$:             mov     #1000, SP
                mtps    SP
                mov     R0, -(SP)       ; код сохраним
                call    ClrPage         ; очищаем экран
                call    @#100140        ; инициализация монитора БК10
                mov     #DATE, R4       ; Системная дата (присв. файлу при записи).
                cmp     (SP), #40       ; это пробел ?
                bne     6$              ; нет
                clr     (R4)            ; да - сбрасываем дату
                br      11$
; ───────────────────────────────────────────────────────────────────────────
BlockLoad = 2100
BlockPar = 2000
6$:             cmp     (R4), CURRDATE  ; дата была изменена?
                beq     8$              ; нет
                mov     CURRDATE, (R4)  ; да - сохраним новую дату
                mov     #BlockPar, R3   ; базовый адрес рабочей области драйвера
                clr     (R3)            ; очистим копию по записи регистра состояния КНГМД
                mov     #400, R1        ; длина пересылаемого массива в словах (>0 - чтение <0 - запись)
                call    RWDateBlk       ; прочитаем первый блок ядра
                mov     #BlockLoad + RWCLAS-START, R1 ; начало таблицы подпрограмм АНДОС
                mov     #300, R5
7$:             cmp     START-BlockLoad(R1), (R1)+
                bne     8$
                sob     R5, 7$
                mov     DATE, BlockLoad + DATE-START ; сохраним дату в прочитанном блоке
                mov     #-400, R1       ; длина пересылаемого массива в словах (>0 - чтение <0 - запись)
                call    RWDateBlk       ; и запишем его обратно

8$:             mov     (SP)+, R0       ; достанем код
                cmp     R0, #12         ; это ввод?
                beq     11$             ; да - запустим андос
                clr     MASTER          ; нет - оболочку не будем запускать
                cmp     R0, #3          ; это КТ ?
                beq     11$             ; да - запустим андос без оболочки
                cmp     #'/, R0         ; это не цифры?
                bhis    12$             ; да - переход
                cmp     R0, #':
                bhis    12$
                ; если нажали цифру
                mov     #ANKEYS, R1     ; найдём ключ соответствующий цифре
                bic     #177760, R0
                beq     10$

9$:             movb    (R1)+, R2
                add     R2, R1
                sob     R0, 9$

10$:            movb    (R1)+, @#SCKLC  ; Счётчик ключа
                mov     R1, @#TAKLC     ; Текущий адрес ключа

11$:            jmp     @#START         ; запускаем АНДОС
; ───────────────────────────────────────────────────────────────────────────
                ; если все остальные клавиши
12$:            mov     #U$ENTRY, R0    ; проверим, есть ли пользовательский модуль
                cmp     (R0)+, #240     ; есть ?
                bne     11$             ; нет - запустим андос без оболочки
                mov     R0, PC          ; есть - запустим пользовательский модуль

; ███████████████ S U B R O U T I N E ███████████████████████████████████████


RWDateBlk:      mov     #34, R0         ; номер блока на диске, первый блок ядра (с параметрами)
                mov     #BlockLoad, R2  ; начальный адрес массива в словах
                jmp     @DRIVER         ; Адрес входа "чтение/запись блока " драйвера НГМД
                                        ; (160004). Может использоваться для обслуживания
                                        ; нестандартных устройств, например виртуального диска)
; End of function RWDateBlk

; ███████████████ S U B R O U T I N E ███████████████████████████████████████


dtGetDay:       mov     CURRDATE, R4
                bic     #177740, R4     ; выделим день месяца 1-31
                return
; End of function dtGetDay


; ███████████████ S U B R O U T I N E ███████████████████████████████████████


dtGetMonth:     mov     CURRDATE, R4
                bic     #177037, R4     ; выделим месяц года, допускаются значения 1-12
                mov     #5, R0

1$:             asr     R4              ; и сдвинем её в мл биты
                sob     R0, 1$
                return
; End of function dtGetMonth


; ███████████████ S U B R O U T I N E ███████████████████████████████████████


dtGetYear:      mov     CURRDATE, R4
                clrb    R4
                swab    R4
                asr     R4              ; выделим год, считая от 1980 г.
                add     #80., R4        ; начало - 1980 г.
                return
; End of function dtGetYear


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; быстрая очистка страницы.
; если R2 == 1, то очистка только половины страницы

ClrPage:        mov     #40000, R1      ; адрес страницы
                mov     #4000, R0       ; всю страницу
                cmp     R2, #1          ; или не всю?
                bne     1$              ; всю.
                asr     R0              ; только половину

1$:             clr     R3
2$:             mov     R3, (R1)+
                mov     R3, (R1)+
                mov     R3, (R1)+
                mov     R3, (R1)+
                sob     R0, 2$
                return
; End of function ClrPage

; ───────────────────────────────────────────────────────────────────────────
; очистка строки, где дата выводится

ClrLine:        mov     #76600, R4
                mov     #400, R0

1$:             clr     (R4)+
                sob     R0, 1$

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Вывод даты на экран

DateOut:        mov     #76630, R3
                call    dtGetDay        ; Выход: R4 - номер дня
                call    Num2Out         ; Вывод двузначного числа на экран
                                        ; Вход: R4 - число
                                        ;       R3 - адрес экрана
                call    DotOut          ; Вывод точки на экран
                                        ; Вход: R3 - адрес экрана
                call    dtGetMonth      ; Выход: R4 - номер месяца
                call    Num2Out         ; Вывод двузначного числа на экран
                                        ; Вход: R4 - число
                                        ;       R3 - адрес экрана
                call    DotOut          ; Вывод точки на экран
                                        ; Вход: R3 - адрес экрана
                call    dtGetYear       ; Выход: R4 - год
; End of function DateOut


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Вывод двузначного числа на экран
; Вход: R4 - число
;       R3 - адрес экрана

Num2Out:        clr     R0

1$:             sub     #10., R4
                bmi     2$
                inc     R0
                br      1$

2$:             call    DigitOut        ; вывод цифры на экран.
                                        ; Вход: R3 - адрес экрана
                                        ;       R0 - аски код цифры
                add     #10., R4
                mov     R4, R0
; End of function Num2Out


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; вывод цифры на экран.
; Вход: R3 - адрес экрана
;       R0 - аски код цифры

DigitOut:       mov     #112536, R1
                asl     R0
                add     R0, R1
                asl     R0
                asl     R0
                add     R0, R1
                mov     #10, R0

1$:             movb    (R1)+, R5
                mov     #10, R2
                clr     -(SP)

2$:             rorb    R5
                ror     (SP)
                asr     (SP)
                sob     R2, 2$
                mov     (SP)+, (R3)
                add     #100, R3
                sob     R0, 1$
                sub     #776, R3
                return
; End of function DigitOut

; ───────────────────────────────────────────────────────────────────────────
                .word 0, 0
; == Конец буфера АНДОС =====================================================
; ── Буфер текстов ключей, начало 126200, размер 152 байта ──────────────────
ANKEYS:         .byte 2                 ; длина текста
ANKey1B:        .ascii "P"<12>
ANKey1E:
                .byte 62                ; длина текста
ANKey2B:        .ascii <237>"1:help 2:shell 3:ASM 4:filer 5:LoadHigh 0:reset"<237><12>
ANKey2E:
                .byte 10                ; длина текста
ANKey3B:        .ascii "S126502"<12>
ANKey3E:
                .byte 10                ; длина текста
ANKey4B:        .ascii "S126504"<12>
ANKey4E:
                .byte 3                 ; длина текста
ANKey5B:        .ascii "M"<12><12>
ANKey5E:
                .byte 10                ; длина текста
ANKey6B:        .ascii "M40000"<12><12>
ANKey6E:
                .byte 0
ANKey7B:
ANKey7E:
                .byte 0
ANKey8B:
ANKey8E:
                .byte 0
ANKey9B:
ANKey9E:
                .byte 0
ANKey10B:
ANKey10E:
                .byte 0
                .blkb   20

;Адреса 126352-126477 занимает внутренний стек ANDOS
                .blkb   6
; ───────────────────────────────────────────────────────────────────────────
;эта п/п вызывается из заставки
;126360

SplashEntry:    br      ClrLine

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Вывод точки на экран
; Вход: R3 - адрес экрана

DotOut:         mov     #-2, R0
                br      DigitOut        ; вывод цифры на экран.
; End of function DotOut

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; Коррекция даты

CorrectDate:    call    dtGetMonth      ; получим номер месяца
                mov     R4, R5          ; сохраним его в R5
                beq     2$              ; если 0 - то корректировать
                cmp     R4, #12.        ; если месяц вышел за пределы
                bhi     2$              ; тоже корректировать

                add     #DayMonths-1, R5 ;получим указатель на число дней в месяце

                call    dtGetYear       ; получим год.
                cmp     R5, #DayMonths+1 ;месяц - февраль?
                bne     1$              ; нет

                movb    #29., (R5)      ; предполагаем високосный год
                asr     R4              ; делим на 2
                bcs     1$              ; если нечётный - то не високосный
                asr     R4              ; ещё делим на два
1$:             sbcb    (R5)            ; в общем. если не делится нацело на 4, то не високосный

                call    dtGetDay        ; получим номер дня
                beq     2$              ; если 0 - то корректировать
                cmpb    R4, (R5)        ; если укладывается в число дней месяца
                blos    3$              ; то дата верная
                                        ; иначе - корректировать
2$:             sub     #6, (SP)        ; стек на команду перед вызовом.
3$:             return                  ; возвращаемся корректировать
; End of function CorrectDate

; ───────────────────────────────────────────────────────────────────────────
; количество дней в месяцах
DayMonths:      .byte   31., 28., 31.
                .byte   30., 31., 30.
                .byte   31., 31., 30.
                .byte   31., 30., 31.

                .word   400
StackTop:       .word   405
; ───────────────────────────────────────────────────────────────────────────

                .END
