;
; ╔═════════════════════════════════════════════════════════════════════════╗
; ║     This file is generated by The Interactive Disassembler (IDA)        ║
; ║     Copyright (c) 2006 by DataRescue sa/nv, <ida@datarescue.com>        ║
; ║ Licensed to: Ded Pihto                                                  ║
; ╚═════════════════════════════════════════════════════════════════════════╝
;
; ───────────────────────────────────────────────────────────────────────────
; Оболочка Disk Master II
;   набор оверлейных функций

; Processor:        K1801VM1
; Target assembler: BK Turbo8 Cross Assembler

; ═══════════════════════════════════════════════════════════════════════════

M$FNAMECOUNT = 372 ; счётчик символов имени файла, вводимого с командной строки
; 402
; 406
; 410
; 416 - размер файла в кластерах / текущий кластер
; 420
; 440
; 460 - буфер номеров директорий
M$EDITBUF = 500     ; размер 14 байтов буфер где редактируется имя файла/директории
M$EDITBUFSIZE = 14
M$NEWNAMEBUF = 540  ; размер 14 байтов буфер где формируется новое имя файла/директории
; 600 - буфер, где формируется путь к текущему подкаталогу в панели


.la 60000

                ; два слова, первое - размер оверлейной функции в байтах
                ;            второе - смещение до функции
                .word M$DRIV_end - M$DRIV   ; 107200
                .word M$DRIV - .        ; Меню "выбор привода"
                .word M$7201_end - M$7201   ; 107201
                .word M$7201 - .        ; инициализация панелей оболочки, их перерисовка и
                                        ; выход в режим работы с панелями оболочки
                .word M$PAG_end - M$PAG     ; 107202
                .word M$PAG - .         ; Вывод панели на экран
                .word M$INIT_end - M$INIT   ; 107203
                .word M$INIT - .        ; Инициализация диска (с установкой индикатора IMDOS)
                .word M$PAN_end - M$PAN     ; 107204
                .word M$PAN - .         ; Переход в режим работы с панелью. Можно использовать как
                                        ; выход в оболочку
                .word M$7205_end - M$7205   ; 107205
                .word M$7205 - .        ; Задать фильтр
                .word M$7206_end - M$7206   ; 107206
                .word M$7206 - .        ; удаление всех помеченных файлов/каталогов с содержимым этих каталогов
                .word M$TEST_end - M$TEST   ; 107207
                .word M$TEST - .        ; Проверка совпадения FAT диска с FAT текущей панели. Необходимо
                                        ; для обнаружения подмены диска перед записью каталога.
                .word M$7210_end - M$7210   ; 107210
                .word M$7210 - .        ; Rename File
                .word M$7211_end - M$7211   ; 107211
                .word M$7211 - .        ; Delete
                .word M$7212_end - M$7212   ; 107212
                .word M$7212 - .        ; Инициализация диска и чтение каталога для активной панели и
                                        ; переход в режим работы с панелью. Можно использовать как
                                        ; выход в оболочку
                .word M$7213_end - M$7213   ; 107213
                .word M$7213 - .        ; Make Dir
                .word M$SAVE_end - M$SAVE   ; 107214
                .word M$SAVE - .        ; Запись каталога активной панели на диск
                .word M$7215_end - M$7215   ; 107215
                .word M$7215 - .        ; Copy/Move Files
                                        ; R0=0  -  copy, !=0  -  move
                .word M$WPAN_end - M$WPAN   ; 107216
                .word M$WPAN - .        ; Перерисовка обеих панелей (выход в режим работы с панелями
                                        ; оболочки)
                .word M$WDP_end - M$WDP     ; 107217
                .word M$WDP - .         ; Дублирование панелей (выход в режим работы с панелями оболочки)
                .word M$7220_end - M$7220   ; 107220
                .word M$7220 - .        ; тело процедуры копирования/переноса
                .word M$7221_end - M$7221   ; 107221
                .word M$7221 - .        ; прорисовка панелей и строки меню
                .word M$INF_end - M$INF     ; 107222
                .word M$INF - .         ; Вывод на экран параметров диска (files, clust., free)
                .word M$LCAT_end - M$LCAT   ; 107223
                .word M$LCAT - .        ; Инициализация диска и чтение каталога для активной  панели.
                                        ; Автоматическое преобразование каталога из формата MicroDOS.
                .word M$7224_end - M$7224   ; 107224
                .word M$7224 - .        ; прорисовка окна копирования/переноса
                                        ; и процедура копирования/переноса
                .word M$7225_end - M$7225   ; 107225
                .word M$7225 - .        ; Просмотрщик файлов
                .word M$7226_end - M$7226   ; 107226
                .word M$7226 - .        ; Menu
                .word M$7227_end - M$7227   ; 107227
                .word M$7227 - .        ; прорисовка текста в рамках панелей и строки меню
                .word M$7230_end - M$7230   ; 107230
                .word M$7230 - .        ; Редактирование имени файла/директории
                .word M$INDDIR_end - M$INDDIR ; 107231
                .word M$INDDIR - .      ; Вывод пути подкаталогов
                .word M$7232_end - M$7232   ; 107232
                .word M$7232 - .        ; пометка файла/директории с рекурсивной пометкой всех файлов всех вложенных директорий


; ===========================================================================
; 107230
; Редактирование имени файла/директории

M$7230:         .word DM$PR + ':
                .word DM$PR + 234
                .word DM$PR + 033       ; стрелка вниз
                mov     R5, -(SP)
                mov     #M$EDITBUF, R5  ; начало буфера
                mov     R5, R0

                mov     #M$EDITBUFSIZE, R1
1$:             tstb    (R0)+           ; это 0 ?
                bne     2$              ; нет
                movb    #40, -1(R0)     ; 0 заменим пробелом
                clrb    (R0)            ; а следующим будет 0, затем мы его проверим и заменим пробелом
2$:             sob     R1, 1$          ; и так весь буфер до конца заполним пробелами
                clrb    (R0)            ; а это конец буфера

                mov     R5, R3          ; R3 - указатель на начало строки R5 - текущий указатель в строке
                call    O$StrOut1       ; теперь выведем это на экран
                .word DM$FN + 025       ; Ввод с клавиатуры в R0 с включением курсора и гашением после ввода
                bit     R0, #140        ; символ печатный?
                beq     6$              ; если нет - переход
                mov     R5, R1          ; если печатный
3$:             movb    #40, (R1)+      ; сотрём всю строку
                tstb    (R1)
                bne     3$
                br      5$              ; пойдём добавим символ в строку

4$:             .word DM$FN + 025       ; Ввод с клавиатуры в R0 с включением курсора и гашением после ввода
                bit     #140, R0        ; символ печатный?
                beq     6$              ; если нет - переход
5$:             tstb    (R5)            ; конец строки?
                beq     4$              ; да - игнорируем символ
                mov     R0, -(SP)
                call    O$InsertChr     ; раздвигаем строку
                mov     (SP)+, R0
                movb    R0, (R5)+       ; вставляем новый символ
                iot                     ; выводим его на экран
                .word DM$PR + 031       ; стрелка вправо
                br      4$

6$:             call    O$EdStrCtrl1    ; обработка символов управления
                br      4$

; ───────────────────────────────────────────────────────────────────────────
O$EdStrCtrl1:   .word DM$FN + 016       ; Переход по ветвлению
                return

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 010       ; Стрелка влево
                cmp     R5, R3          ; мы уже в начале строки?
                beq     O$EdStrRet1     ; да - некуда двигаться
                dec     R5              ; двинем указатель влево
O$ChrOut1:      .word DM$FN + 003       ; Вывод символа из R0 на экран
O$EdStrRet1:    return
; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 031       ; Стрелка вправо
                tstb    (R5)            ; мы в конце строки?
                beq     O$EdStrRet1     ; да - некуда двигаться
                inc     R5              ; двинем указатель вправо
                br      O$ChrOut1       ; и курсор тоже

; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; раздвижка строки в памяти и на экране
; Вход: R5 - адрес начала строки

O$InsertChr:    tstb    (R5)            ; конец строки?
                beq     O$ChrOut1       ; да - просто вывод символа
                mov     R5, R1
1$:             tstb    (R1)+           ; найдём конец строки
                bne     1$
                tst     -(R1)           ; указатель на последний символ
                br      3$

2$:             movb    -(R1), 1(R1)    ; теперь раздвинем строку
3$:             cmp     R1, R5
                bgt     2$
                movb    #40, (R5)       ; и вставим в это место пробел
; End of function O$InsertChr


; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; вывод строки на экран
; Вход: R5 - адрес начала строки

O$StrOut1:      mov     R5, R1
                br      2$

1$:             iot
2$:             movb    (R1)+, R0
                bne     1$
                emt     26              ; получение координат курсора: R1 = X, R2 = Y;
                emt     24              ; установка курсора по координатам X = R1, Y = R2;
                return
; End of function O$StrOut1

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 030       ; Забой
                cmp     R5, R3          ; мы уже в начале строки?
                beq     O$EdStrRet1     ; да - нечего удалять
                .word DM$PR + 010       ; курсор влево
                dec     R5              ; двинем указатель влево
                mov     R5, R1          ; сдвигаем строку
3$:             movb    1(R1), (R1)+
                bne     3$
                movb    #40, -(R1)      ; последний символ - пробел
                br      O$StrOut1       ; и обновим на экране

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 012       ; Ввод
                cmpb    (R3), #345      ; первый символ - русская Е загл?
                bne     4$              ; нет
                movb    #105, (R3)      ; да - заменим на латинскую Е загл
4$:             tst     (SP)+           ; адрес возврата из O$EdStrCtrl1 нам уже не нужен
                mov     #M$NEWNAMEBUF, R1 ; тут будем формировать имя файла в формате мсдос

                mov     R1, R2          ; начало буфера имени
                mov     R3, R4          ; начало буфера редактирования
                mov     #10, R0         ; формируем имя
5$:             cmpb    (R4), #'.       ; нашли точку?
                bne     6$              ; нет
                clrb    (R1)+           ; да - вместо неё 0
                br      7$              ; и остаток имени забивается нулями

6$:             movb    (R4)+, (R1)+    ; скопируем символ
7$:             sob     R0, 5$

8$:             tstb    (R4)            ; теперь пропустим лишние символы имени
                beq     9$              ; если они есть
                cmpb    (R4)+, #'.
                bne     8$

9$:             mov     #3, R0          ; формируем расширение
10$:            movb    (R4)+, (R1)+    ; скопируем символ
                bne     11$             ; если это конец строки
                dec     R4              ; то вернём указатель назад
11$:            sob     R0, 10$
                clrb    (R1)
                mov     (SP)+, R5
                return
; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 003       ; КТ
                halt
M$7230_end:     ; конец функции M$7230
; ===========================================================================



; ===========================================================================
; 107200
; Меню "выбор привода"

M$DRIV:         jsr     R2, O$Driv1     ; получим в R2 адрес блока параметров меню
                .word 177770            ; блок параметров меню
                .byte 2, 12
                .word 177773
                .byte 2, 12
                .word 177776
                .byte 2, 12

O$Driv1:        mov     #TSS, R5        ; адрес, где хранится имя третьего привода 
                movb    (R5), O$3DN
                .word DM$FN + 064       ; Вывод текста в рамке.
                .byte 12, 6, 36, 13
                .ascii "   Drive"<12>
                .ascii "  A: B: "
O$3DN:          .byte 'C
                .asciz ":"
                .even
                movb    (R4), R3
                cmpb    R3, #3
                blos    1$
                mov     #3, R3
1$:             dec     R3
                mov     SP, R0
                .word DM$FN + 114       ; вертикально-горизонтальное меню
                                        ; Вход: R0 == 0 - горизонтальное меню != 0 - вертикальное
                .asciz "ABC"
                .even
                cmp     R3, #2
                bne     3$
                sub     R3, @#AS
                bit     #100, R0
                beq     2$
                cmp     R0, #100
                beq     4$
                .word DM$PR + 237
                iot
                .word DM$PR + 237
                movb    R0, (R5)
2$:             movb    (R5), R3
                sub     #'A, R3
3$:             inc     R3
                movb    R3, (R4)
4$:             mov     (SP)+, R2
                return
M$DRIV_end: ; конец функции M$DRIV
; ===========================================================================



; ===========================================================================
; 107201
; инициализация панелей оболочки, их перерисовка и
; выход в режим работы с панелями оболочки

M$7201:         .word DM$FN + 017       ; защита функции, после нажатия на клавишу СТОП, начнётся повторное
                                        ; выполнение защищённой функции
                mov     #FILT, R2       ; буфер фильтра оболочки
                mov     #6, R0
1$:             clr     FILTP-FILT(R2)  ; очищаем фильтры обеих панелей
                clr     (R2)+
                sob     R0, 1$
                clrb    @#440
                movb    @#DEVICE, R0
                beq     2$
                movb    R0, @#DAB       ; устройство активной панели
2$:             mov     @#DRIVER, @#M$DRIVER ; п/п обработки чтения блока
                call    M$7221          ; прорисовка панелей и строки меню
                call    M$LCAT_Protect  ; выполнение функции 223 с защитой
                                        ; Инициализация диска и чтение каталога для активной  панели.
                                        ; Автоматическое преобразование каталога из формата MicroDOS.
                .word DM$FN + 042       ; Сравнение приводов панелей (если =0, значит приводы одинаковые)
                beq     M$WDP           ; одинаковые - идём дублировать панели (выход в режим работы с панелями оболочки)
                .word DM$FN + 014       ; нет - Смена активной панели
                call    M$LCAT_Protect  ; выполнение функции 223 с защитой
                                        ; Инициализация диска и чтение каталога для активной  панели.
                                        ; Автоматическое преобразование каталога из формата MicroDOS.
                br      0WPAN$          ; и идём перерисовывать обе панели


; ───────────────────────────────────────────────────────────────────────────
; 107217
; Дублирование панелей (выход в режим работы с панелями оболочки)

M$WDP:          mov     @#AFAT, R4      ; адрес FAT активной панели
                mov     @#AFATP, R1     ; адрес FAT пассивной панели
                mov     #4420, R5       ; копируем FAT и каталог
1$:             mov     (R4)+, (R1)+
                sob     R5, 1$
                mov     #NFIL, R4       ; копируем второй блок переменных панели
2$:             mov     (R4)+, FILTP-FILT-2(R4) ; исключая фильтры
                cmp     R4, #FILTP
                bne     2$


; ───────────────────────────────────────────────────────────────────────────
; 107216
; Перерисовка обеих панелей (выход в режим работы с панелями оболочки)

M$WPAN:         .word DM$FN + 014       ; Смена активной панели
0WPAN$:         .word DM$FN + 021       ; Блокировка прерывания по клавише СТОП
                .word DM$PR + 234
                call    M$INDDIR        ; Вывод пути подкаталогов
                call    M$INF           ; Вывод на экран параметров диска (files, clust., free)
                call    M$GetRecordPos  ; получение координат курсора и адреса записи в активной панели
                                        ; выход: R5 - текущий адрес записи в активной панели
                                        ;        R2 - текущая вертикальная координата указателя в активной панели
                call    M$PAG           ; Вывод панели на экран
                call    M$SetRecordPos  ; установка координат курсора и адреса записи в активной панели
                                        ; вход: R5 - адрес записи в активной панели
                                        ;       R2 - вертикальная координата указателя в активной панели
                .word DM$FN + 014       ; Смена активной панели
                br      M$PAN           ; Переход в режим работы с панелью. Можно использовать как
                                        ; выход в оболочку


; ───────────────────────────────────────────────────────────────────────────
; 107212
; Инициализация диска и чтение каталога для активной панели и
; переход в режим работы с панелью. Можно использовать как
; выход в оболочку

M$7212:         .word DM$FN + 017       ; защита функции, после нажатия на клавишу СТОП, начнётся повторное
                                        ; выполнение защищённой функции
                call    M$LCAT_Protect  ; выполнение функции 223 с защитой
                                        ; Инициализация диска и чтение каталога для активной панели.
                                        ; Автоматическое преобразование каталога из формата MicroDOS.

; ───────────────────────────────────────────────────────────────────────────
; 107204
; Переход в режим работы с панелью. Можно использовать как
; выход в оболочку

M$PAN:          .word DM$FN + 017       ; защита функции, после нажатия на клавишу СТОП, начнётся повторное
                                        ; выполнение защищённой функции
                .word DM$FN + 066       ; остановка двигателя дисковода и сброс кода клавиши
                clr     @#M$FNAMECOUNT
                mov     #74702, @#AS
                .word DM$PR + 231       ; Удаление правой от курсора части строки - очищаем командную строку
                .word DM$FN + 024       ; Включение/отключение курсора
                mov     @#M$SAVESCR, R5 ; берём адрес текущей записи, ещё там может быть совершенно постороннее значение
                beq     MP$2$           ; если адреса нету - переход
MP$1$:          mov     @#Y, R2         ; текущая вертикальная координата указателя в активной панели
                br      MP$4$           ; пойдём установим координаты

MP$2$:          call    M$INDDIR        ; Вывод пути подкаталогов
                call    M$INF           ; Вывод на экран параметров диска (files, clust., free)
                call    M$GetRecordPos  ; получение координат курсора и адреса записи в активной панели
                                        ; выход: R5 - текущий адрес записи в активной панели
                                        ;        R2 - текущая вертикальная координата указателя в активной панели
MP$3$:          clrb    @#M$CURSOR      ; признак гашения курсора оболочки
                call    M$PAG           ; Вывод панели на экран
MP$4$:          call    M$SetRecordPos  ; установка координат курсора и адреса записи в активной панели
                                        ; вход: R5 - адрес записи в активной панели
                                        ;       R2 - вертикальная координата указателя в активной панели
                mov     R5, @#M$SAVESCR ; сохраним адрес текущей записи
                tstb    @#M$CURSOR      ; признак гашения курсора оболочки
                bne     MP$5$
                .word DM$FN + 022       ; Инверсия указателя текущего файла (в R2 должна находиться
                                        ; вертикальная координата - содержимое ячейки Y)
MP$5$:          .word DM$FN + 002       ; Приём символа с клавиатуры в R0
                movb    @#XB, R1        ; горизонтальное координата панели (1 или 41)
                emt     24              ; установка курсора по координатам X = R1, Y = R2;
                bit     #140, R0        ; нажали печатный символ?
                beq     MP$7$           ; нет - переходим к обработке управляющих
                mov     @#M$FNAMECOUNT, R1 ; счётчик принятых символов имени файла в командной строке
                cmp     R1, #NAMELEN    ; предел достигнут?
                beq     MP$5$           ; да - больше не принимать
                inc     @#M$FNAMECOUNT  ; иначе - примем новый символ
                movb    R0, IMMAS(R1)
MP$6$:          add     #74702, R1      ; и выведем его на экран в командную строку
                mov     R1, @#AS
                .word DM$FN + 003       ; Вывод символа из R0 на экран
                .word DM$FN + 024       ; Включение/отключение курсора
                br      MP$5$

MP$7$:          mov     #40, R3
                mov     #1, R4
                .word DM$FN + 016       ; Переход по ветвлению (навигация по панели)
                br      MP$5$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 030       ; Забой
                mov     #231, R0        ; удаляем последний символ имени файла в командной строке
                mov     @#M$FNAMECOUNT, R1
                beq     MP$4$
                dec     R1
                dec     @#M$FNAMECOUNT
                movb    R3, IMMAS(R1)
                br      MP$6$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 231       ; АР2/стрелка вправо с гашением курсора
                mov     #22, R2
8$:             tstb    (R5)
                beq     MP$3$
                add     R3, R5
                br      8$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 011       ; Таб
                call    M$OutPanePaths  ; вывод путей подкаталогов обеих панелей
                mov     @#ADR, R5
                br      MP$1$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 010       ; стрелка влево
                mov     R2, R4
                dec     R4
                bne     9$
                mov     #21, R4
9$:             br      14$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 031       ; Стрелка вправо
                mov     #22, R4
                sub     R2, R4
                bne     10$
                mov     #21, R4
10$:            br      12$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 230       ; АР2/стрелка влево с гашением курсора
                mov     @#ADR1, R5
MP$11$:         br      MP$3$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 233       ; АР2/стрелка вниз с гашением курсора
                neg     R4
                br      12$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 232       ; АР2/стрелка вверх с гашением курсора
                neg     R4
                br      14$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 033       ; Стрелка вниз
12$:            tstb    (R5)
                bne     MP$15$
MP$13$:         br      MP$4$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 032       ; Стрелка вверх
14$:            neg     R3
MP$15$:         mov     R5, R1
16$:            add     R3, R1
                .word DM$FN + 015       ; Проверка совпадения имени файла (подкаталога) и фильтра
                bcs     16$
                beq     22$
                cmp     R1, @#ADR1
                blt     22$
                mov     R1, -(SP)
                tst     R4
                bpl     18$
                cmp     (R5), #"..
                beq     18$
                cmp     (R1), #"..
                beq     18$
                mov     #F$RecLen, R0
17$:            movb    (R5), -(SP)
                movb    (R1), (R5)+
                movb    (SP)+, (R1)+
                sob     R0, 17$
                sub     #F$RecLen, R5
                call    M$OutPaneRec    ; вывод на экран одной записи каталога

18$:            mov     (SP)+, R5
                dec     R4
                beq     19$
                .word DM$FN + 023       ; Гашение указателя текущего файла
19$:            tst     R3
                bmi     20$
                inc     R2
                br      21$

20$:            dec     R2
21$:            tst     R4
                bgt     MP$15$

22$:            mov     #252, R1
                cmp     R2, #23
                beq     23$
                blo     26$
                mov     @#Y, R2
                br      MP$11$

23$:            dec     R2
                .word DM$FN + 023       ; Гашение указателя текущего файла
                movb    @#XB, R0
                add     #43177, R0
24$:            mov     R0, R3
                add     #1200, R3
                mov     #10, R4
25$:            mov     (R3)+, (R0)+
                mov     (R3)+, (R0)+
                sob     R4, 25$
                add     #F$RecLen, R0
                sob     R1, 24$
                br      29$

26$:            tst     R2
                bne     31$
                inc     R2
                .word DM$FN + 023       ; Гашение указателя текущего файла
                movb    @#XB, R0
                add     #70337, R0
27$:            mov     R0, R3
                add     #1200, R3
                mov     #10, R4
28$:            mov     -(R0), -(R3)
                mov     -(R0), -(R3)
                sob     R4, 28$
                sub     #F$RecLen, R0
                sob     R1, 27$

29$:            call    M$OutPaneRec    ; вывод на экран одной записи каталога
30$:            tstb    @#PRZKB
                bne     MP$13$
                dec     @#M$ARPTDELAY
                bpl     30$
                bit     #100, @#177716
                bne     MP$13$
                call    @#101122        ; Получение кода с буфера клавиатуры и очистка флага кода в буфере
                jmp     MP$7$

31$:            tst     R4
                bpl     33$
                call    M$OutPaneRec    ; вывод на экран одной записи каталога
32$:            br      MP$13$

33$:            tstb    @#M$CURSOR
                beq     32$
                mov     @#AS, R4
                movb    @#XB, R1
                emt     24              ; установка курсора по координатам X = R1, Y = R2;
                mov     @#AS, R1
                cmp     R1, R4
                beq     32$
                mov     #12, R1
                asl     R3
                bpl     35$
34$:            add     R3, R4
35$:            mov     R4, -(SP)
                mov     #36, R0
36$:            comb    1200(R4)
                comb    (R4)+
                sob     R0, 36$
                mov     SP, R0
                sob     R0, .
                mov     (SP)+, R4
                sob     R1, 34$
                br      30$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 023       ; ВС
                .word DM$FN + 026       ; Контроль конца каталога (адрес записи в R5). Если (R5)=0, то
                                        ; происходит HALT-прерывание
                .word DM$FN + 023       ; Гашение указателя текущего файла
                comb    F$MARK(R5)
                call    M$OutPaneRec    ; вывод на экран одной записи каталога
                tstb    F$MARK(R5)
                beq     37$
                inc     @#NFIL
                br      38$

37$:            neg     R0
                dec     @#NFIL
                beq     39$
38$:            add     R0, @#NCL
                clr     @#AS
39$:            call    M$7232          ; пометка файла/директории с рекурсивной пометкой всех файлов всех вложенных директорий
                tstb    @#ITTB
                bne     MP$46$
                tstb    F$DIRN(R5)
                beq     40$
                tstb    @#ILIB
                bne     MP$46$
40$:            call    M$INF           ; Вывод на экран параметров диска (files, clust., free)
                jmp     MP$15$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 223       ; АР2/ВС
                mov     R5, R1
41$:            tstb    F$DIRN(R1)
                beq     43$
42$:            add     R3, R1
                .word DM$FN + 015       ; Проверка совпадения имени файла (подкаталога) и фильтра.
                bcs     42$
                bne     41$
43$:            movb    F$MARK(R1), R0
                comb    R0
44$:            .word DM$FN + 015       ; Проверка совпадения имени файла (подкаталога) и фильтра.
                beq     MP$46$
                bcs     45$
                tstb    F$DIRN(R1)
                bne     45$
                movb    R0, F$MARK(R1)
45$:            add     R3, R1
                br      44$

MP$46$:         jmp     MP$2$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 222       ; ИНД СУ
                com     @#ITEGB

47$:            movb    F$PARD(R5), @#DIRB
                br      MP$46$
; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 224       ; БЛОК РЕД
48$:            comb    @#ILIB
                br      47$
; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 221       ; ПОВТ
                .word DM$FN + 205       ; Задать фильтр
                tst     R4
                bne     48$
                br      47$
; ───────────────────────────────────────────────────────────────────────────
; запуск М файла
M$StartM:       mov     #IMMAS, R2
                mov     #6, R0
49$:            movb    (R1)+, (R2)+
                sob     R0, 49$
                br      59$
; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 212       ; АР2/Ввод
                br      50$
; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 012       ; Ввод
50$:            mov     @#M$FNAMECOUNT, R3
                bne     55$
                movb    F$DIRN(R5), R0
                bpl     53$
51$:            .word DM$FN + 031       ; Поиск подкаталога с номером, находящемся в DIRB
                movb    F$PARD(R1), @#DIRB
                beq     52$
                cmpb    @#BUFKL, #34
                beq     51$

52$:            mov     R1, @#ADR
                mov     #20, @#Y
                br      54$

53$:            .word DM$FN + 026       ; Контроль конца каталога (адрес записи в R5). Если (R5)=0, то
                                        ; происходит HALT-прерывание
                beq     55$
                movb    R0, @#DIRB
                .word DM$FN + 020       ; R1=ADR0-40
                mov     R1, @#ADR
54$:            clrb    @#ILIB
                br      MP$46$

55$:            tst     @#NFIL
                beq     56$
                .word DM$FN + 073       ; Меню YES/NO, если "YES", то программа продолжается, иначе -
                                        ; прерывание по HALT
                .byte 4
                .asciz "Execute "
                .even
56$:            movb    F$PARD(R5), @#DIRB
                mov     #BPDMAG, R0
                mov     #3, (R0)+
                clr     (R0)+
                clr     (R0)+
                mov     @#M$FNAMECOUNT, R2
                mov     R2, -(SP)
                bne     57$
                .word DM$FN + 030       ; Преобразование имени файла из формата каталога ANDOS
                                        ; в формат блока параметров EMT 36
                br      59$

57$:            add     #IMMAS, R2
58$:            movb    #40, (R2)+
59$:            cmp     R2, #IMMAS+NAMELEN
                blo     58$
                .word DM$FN + 131       ; Очистка флага сохранения содержимого экрана под окном
                                        ; Очистка признака записи кода в буфер
                .word DM$FN + 116       ; ANDOS-овская подпрограмма DONAM
                cmp     @#NAMEXT, #20115 ; "M "
                beq     62$
                .word DM$FN + 054       ; Проверка DOS (если ANDOS, то =0)
                bne     60$
                mov     #203, @#BPDMAG
                tst     (SP)+
                beq     61$
                .word DM$FN + 077       ; Инициализация диска. Если не ANDOS, то устанавливается бит "С".
                .word DM$FN + 117       ; ANDOS-овская подпрограмма DIRFI2
                bcs     65$
60$:            .word DM$FN + 101       ; Очень похоже на запуск файла
61$:            .word DM$FN + 207       ; Проверка совпадения FAT диска с FAT текущей панели. Необходимо
                                        ; для обнаружения подмены диска перед записью каталога.
                mov     @#ADR, R2
                .word DM$FN + 101       ; Очень похоже на запуск файла
                .word DM$KC + 034       ; СУ-Э (стрелка влево-вверх)
                tstb    @#DIRB
                beq     54$
                br      51$

62$:            cmpb    7(R1), #':
                beq     63$
                .word DM$FN + 014       ; Смена активной панели
                .word DM$FN + 043       ; Установка режима кеширования по чтению/записи каталога и FAT
                clr     @#TEKBLK
                .word DM$FN + 117       ; ANDOS-овская подпрограмма DIRFI2
                .word DM$FN + 014       ; Смена активной панели
                .word DM$FN + 044       ; Сброс режима кеширования
                bcc     64$
                movb    @#DAPB, @#DEVTEK
63$:            .word DM$FN + 077       ; Инициализация диска. Если не ANDOS, то устанавливается бит "С".
                .word DM$FN + 117       ; ANDOS-овская подпрограмма DIRFI2
                bcs     65$
64$:            mov     #ADRMAS, R1
                clr     (R1)
                mov     F$CLUS(R2), -(R1) ;что-то непонятное. номер начального кластера в команду для емт36
                call    @#M$FASTREAD    ; быстрое чтение
                jsr     R5, @#K$RUNNER
                .word BUFSTA
                .word DM$FN + 204       ; Переход в режим работы с панелью. Можно использовать как
                                        ; выход в оболочку
65$:            .word DM$FN + 122       ; установка вектора 4 на обработку ошибочной ситуации
                jmp     @#E$EERR

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 026       ; Сдвижка в строке
                movb    @#XB, R0
                br      66$
; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 027       ; Раздвижка в строке
                movb    @#XPB, R0
66$:            .word DM$FN + 023       ; Гашение указателя текущего файла
                dec     R0
                beq     67$
                call    M$OutPanePaths  ; вывод путей подкаталогов обеих панелей
                br      67$
; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 220       ; ШАГ
67$:            mov     #DAB, R4        ; устройство активной панели
                .word DM$FN + 200       ; Меню "выбор привода"
                br      68$
; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 014       ; СБР
68$:            .word DM$FN + 212       ; Инициализация диска и чтение каталога для активной панели и
                                        ; переход в режим работы с панелью. Можно использовать как
                                        ; выход в оболочку
; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 200       ; АР2/0 - Quit
                .word DM$FN + 105       ; отключение признака оболочки и запуск оболочки
; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 201       ; АР2/1 - Help
                jsr     R1, M$StartM
                .ascii "HELP.M"
                .even
; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 202       ; АР2/2 - User
                jsr     R1, M$StartM
                .ascii "USER.M"
                .even
; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 203       ; АР2/3 - View
                .word DM$FN + 225       ; Просмотрщик файлов
; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 204       ; АР2/4 - Move
                .word DM$FN + 215       ; Copy/Move Files
                                        ; R0=0  -  copy, !=0  -  move
; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 205       ; АР2/5 - Copy
                clr     R0
                .word DM$FN + 215       ; Copy/Move Files
                                        ; R0=0  -  copy, !=0  -  move
; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 206       ; АР2/6 - Rename
                .word DM$FN + 210       ; Rename File
; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 207       ; АР2/7 - Make Dir
                .word DM$FN + 213       ; Make Dir
; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 210       ; АР2/8 - Delete
                .word DM$FN + 211       ; Delete
; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 213       ; Удаление правой от курсора части строки
                comb    @#DATEB
                .word DM$FN + 227       ; прорисовка текста в рамках панелей и строки меню
                .word DM$FN + 204       ; Переход в режим работы с панелью. Можно использовать как
                                        ; выход в оболочку
; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 003       ; КТ
                .word DM$FN + 023       ; Гашение указателя текущего файла
                br      69$
; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 211       ; АР2/9 - Menu
69$:            .word DM$FN + 226       ; Menu
; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 006       ; СУ-F
                mov     #U$ENTRY, R0
                jsr     R5, @#K$RUNNER + 4
                halt
; End of function M$PAN


; ===========================================================================
; 107232
; пометка файла/директории с рекурсивной пометкой всех файлов всех вложенных директорий

M$7232:         mov     R5, R1          ; текущий адрес записи
                clr     R0              ; 0 - признак конца рекурсии, тут хранится номер директории
1$:             mov     R0, -(SP)
                movb    F$DIRN(R1), R0  ; берём номер директории
                beq     4$              ; это не директория
                mov     R0, @#AS        ; охренеть чё делаем
                mov     R1, -(SP)       ; сохраним в стеке адрес записи директории
                .word DM$FN + 020       ; R1=ADR0-40
2$:             add     #F$RecLen, R1   ; переходим к следующей записи
                tstb    (R1)            ; конец каталога ?
                beq     3$              ; да - выход из цикла
                cmpb    R0, F$PARD(R1)  ; запись принадлежит этой директории ?
                bne     2$              ; нет - ищем дальше
                movb    F$MARK(R5), F$MARK(R1)  ; да - помечаем её
                cmp     SP, #440        ; стек там не переполнился?
                bhi     1$              ; нет ещё - продолжим рекурсию
                .word DM$FN + 076       ; останов двигателя дисковода, звуковой сигнал, пауза и СТОП

3$:             mov     (SP)+, R1       ; достаём адрес записи директории
4$:             mov     (SP)+, R0       ; достаём её номер
                bne     2$              ; не 0 - ищем дальше
                return
M$7232_end: ; конец функции M$7232
; ===========================================================================

; ===========================================================================
; 107222
; Вывод на экран параметров диска (files, clust., free)

M$INF:          jsr     R4, @#PUSH4
                .word DM$FN + 020       ; R1=ADR0-40
                mov     #ITTB, R4       ; индикатор текущий (0 - режим неактивен)
                mov     #NFIL, R0
                mov     (R0)+, R2
                mov     (R0)+, R3
                mov     @#AS, -(SP)
                beq     5$
                clr     -(R0)
                clr     -(R0)
                clr     R3
                clr     R2

1$:             add     #F$RecLen, R1
                tstb    (R1)
                beq     4$
                tstb    (R4)
                bne     2$
                tstb    F$MARK(R1)
                beq     2$
                cmpb    (R1), #345
                beq     1$
                clr     R3
                comb    (R4)
                clr     R2
2$:             .word DM$FN + 015       ; Проверка совпадения имени файла (подкаталога) и фильтра
                bcs     1$
                tstb    F$DIRN(R1)
                beq     3$
                tstb    @#ILIB
                beq     1$
3$:             mov     F$LEN(R1), R0
                mov     F$LENH(R1), -(SP)
                add     #ClusterSize-1, R0
                adc     (SP)
                clrb    R0
                bisb    (SP)+, R0
                swab    R0
                ror     R0
                asr     R0
                asr     R0
                add     R0, R3
                inc     R2
                br      1$

4$:             tst     (R4)
                beq     5$
                clr     (SP)
5$:             movb    @#XB, R1
                add     #41513, R1
                mov     R1, @#AS
                tstb    -(R4)
                beq     6$
                .word DM$PR + 177       ; Закрашенный квадрат
                br      9$

6$:             mov     #13, R0
                mov     #FILT, R1
7$:             tstb    (R1)+
                beq     8$
                .word DM$PR + '%
                br      9$

8$:             sob     R0, 7$
                .word DM$PR + 040

9$:             add     #30564, @#AS
                tst     (SP)
                bne     10$
                mov     R3, @#NCL
                mov     R2, @#NFIL
                comb    @#PRPODC
                .word DM$FN + 004       ; Вывод текста на экран
                .asciz "Selected:"
                .even
10$:            .word DM$FN + 007       ; Десятичный вывод содержимого R2, (R2<1000.)
                .word DM$FN + 004       ; Вывод текста на экран
                .asciz " files "
                .even
                mov     R3, R2
                .word DM$FN + 007       ; Десятичный вывод содержимого R2, (R2<1000.)
                .word DM$FN + 004       ; Вывод текста на экран
                .asciz " clust. "
                .even
                tst     (SP)+
                beq     12$
                .word DM$FN + 054       ; Проверка DOS (если ANDOS, то =0)
                beq     11$
                .word DM$FN + 004       ; Вывод текста на экран
                .asciz "MicroDOS "
                .even
                br      12$

11$:            mov     @#FRECL, R2
                .word DM$FN + 007       ; Десятичный вывод содержимого R2, (R2<1000.)
                .word DM$FN + 004       ; Вывод текста на экран
                .asciz " free"
                .even
12$:            movb    (R4)+, (R4)
                clr     @#PRPODC
                jmp     @#POP4R
M$INF_end: ; конец функции M$INF
; ===========================================================================


; ───────────────────────────────────────────────────────────────────────────
; вывод путей подкаталогов обеих панелей

M$OutPanePaths: .word DM$FN + 131       ; Очистка флага сохранения содержимого экрана под окном
                                        ; Очистка признака записи кода в буфер
                .word DM$FN + 023       ; Гашение указателя текущего файла
                .word DM$PR + 234
                call    M$INDDIR        ; Вывод пути подкаталогов
                .word DM$FN + 014       ; Смена активной панели

; ===========================================================================
; 107231
; Вывод пути подкаталогов
M$INDDIR:       .word DM$FN + 066       ; остановка двигателя дисковода и сброс кода клавиши
                mov     @#AFAT, R2
                add     #F$RecLen, R2
                .word DM$FN + 054       ; Проверка DOS (если ANDOS, то =0)
                bne     1$
                add     #1740, R2
1$:             mov     R2, @#ADR0
2$:             .word DM$FN + 020       ; R1=ADR0-40
                mov     #377, F$DIRN(R1)    ; формируем запись ".."
                mov     #".., (R1)+
                mov     #5, R4
3$:             mov     #20040, (R1)+
                sob     R4, 3$
                add     #24, R1         ; указатель на следующую за ".." запись
                movb    @#DIRB, R0
                movb    R0, F$PARD-F$RecLen(R1) ; номер родительского подкаталога для ".."
                beq     4$
                tstb    @#ILIB          ; индикатор режима прозрачности (0 - реж.откл.)
                bne     8$
                .word DM$FN + 020       ; R1=ADR0-40
4$:             mov     R1, @#ADR1
                cmp     @#ADR, R1
                bge     5$
                mov     R1, @#ADR
5$:             mov     #600, R4
                clrb    (R4)
                clr     -(SP)
                tstb    R0
                bne     7$
                inc     (SP)
                br      11$

6$:             movb    #'\, -(R4)
7$:             mov     R4, -(SP)
                .word DM$FN + 020       ; R1=ADR0-40
                .word DM$FN + 032       ; Поиск подкаталога с номером, находящемся в R0, адрес записи
                                        ; помещается в R1. Если таковой не найден, то R1=0
                tstb    (R1)
                bne     9$
                cmp     (SP)+, (SP)+
8$:             clrb    @#DIRB
                br      2$

9$:             mov     #M$EDITBUF, R0
                mov     R1, R5
                .word DM$FN + 030       ; Преобразование имени файла из формата каталога ANDOS
                                        ; (адрес записи в R5) в формат блока параметров EMT 36
                mov     (SP)+, R4
                inc     (SP)
                mov     R2, R1
                sub     R3, R2
                mov     R2, R0
                beq     11$
                add     (SP), R2
                cmp     R2, #30
                bhis    11$
                mov     R2, (SP)
10$:            movb    -(R1), -(R4)
                sob     R0, 10$
                movb    F$PARD(R5), R0
                bne     6$
11$:            asr     (SP)
                adc     (SP)
                movb    @#XB, R1
                add     #40200, R1
                mov     R1, R3
                add     #16, R1
                sub     (SP)+, R1
                mov     R3, -(SP)
                mov     R1, @#AS
                call    sub_64272
                .word DM$PR + 234
                .word DM$FN + 051       ; Установка привода активной панели текущим
                                        ; Вывод имени привода на экран
                mov     (SP), R1
                mov     R0, (SP)
                mov     #'\, R0
                mov     R4, R3
                tstb    @#ILIB
                beq     12$
                mov     #'*, R0
12$:            iot
                movb    (R4)+, R0
                bne     12$
                mov     R3, R4
                mov     @#AS, R3
                add     #36, R1
                call    sub_64272
                mov     #377, @#PRPODC
                mov     (SP)+, R0
                mov     #74700, @#AS
                iot
                .word DM$PR + '>
                .word DM$PR + 237
                return

; ███████████████ S U B R O U T I N E ███████████████████████████████████████


sub_64272:      mov     #7, R0          ; количество байтов
                movb    1200(R3), R2
                jsr     R1, sub_64316
                .byte 0, 0, 0, 0, 252, 0, 252
                .even
; End of function sub_64272


; ███████████████ S U B R O U T I N E ███████████████████████████████████████


sub_64316:      movb    (R1)+, (R3)
                add     #100, R3
                sob     R0, sub_64316
                mov     (SP)+, R1
                mov     #3, R0
1$:             movb    R2, (R3)
                add     #100, R3
                sob     R0, 1$
                add     #-1177, R3
                cmp     R3, R1
                bne     sub_64272
                return
; End of function sub_64316

M$INDDIR_end: ; конец функции M$INDDIR
; ===========================================================================

; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; получение координат курсора и адреса записи в активной панели
; выход: R5 - текущий адрес записи в активной панели
;        R2 - текущая вертикальная координата указателя в активной панели

M$GetRecordPos: mov     @#ADR, R5       ; текущий адрес в активной панели
                mov     @#Y, R2         ; текущая вертикальная координата указателя в активной панели
                tstb    (R5)            ; запись пуста?
                bne     100$            ; нет - выход
                mov     @#ADR1, R5      ; адрес начала каталога (с учётом "..")
; End of function M$GetRecordPos


; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; установка координат курсора и адреса записи в активной панели
; вход: R5 - адрес записи в активной панели
;       R2 - вертикальная координата указателя в активной панели

M$SetRecordPos: mov     #ADR, R0
                mov     R5, (R0)+       ; установим текущий адрес в активной панели
                mov     R2, (R0)+       ; установим текущую вертикальную координату указателя в активной панели
                mov     (R5), (R0)      ; и контрольное слово
100$:           return
; End of function M$SetRecordPos

; ===========================================================================
; 107202
; Вывод панели на экран

M$PAG:          mov     R5, R1
                mov     #F$RecLen, R0
1$:             cmp     R1, @#ADR1
                ble     3$
                .word DM$FN + 015       ; Проверка совпадения имени файла (подкаталога)
                                        ; (адрес записи в R1) и фильтра.
                bhi     4$
                sub     R0, R1
                br      1$

2$:             add     R0, R1
3$:             .word DM$FN + 015       ; Проверка совпадения имени файла (подкаталога)
                                        ; (адрес записи в R1) и фильтра.
                bcs     2$

4$:             mov     R1, -(SP)
                mov     #23, R3
                sub     R2, R3
5$:             tstb    (R1)
                beq     6$
                add     R0, R1
                .word DM$FN + 015       ; Проверка совпадения имени файла (подкаталога)
                                        ; (адрес записи в R1) и фильтра.
                bcs     5$
                sob     R3, 5$

6$:             add     R3, R2
                mov     (SP), R1
                mov     R2, -(SP)
                br      8$

7$:             cmp     R1, @#ADR1
                blos    9$
                sub     R0, R1
                .word DM$FN + 015       ; Проверка совпадения имени файла (подкаталога)
                                        ; (адрес записи в R1) и фильтра.
                bcs     7$

8$:             mov     R1, R5
                sob     R2, 7$

9$:             sub     R2, (SP)
                clr     R2

10$:            inc     R2
                call    M$OutPaneRec    ; вывод на экран одной записи каталога
                tstb    (R5)
                beq     12$

11$:            add     #F$RecLen, R5
                mov     R5, R1
                .word DM$FN + 015       ; Проверка совпадения имени файла (подкаталога)
                                        ; (адрес записи в R1) и фильтра.
                bcs     11$
12$:            cmp     R2, #21
                blos    10$
                mov     (SP)+, R2
                mov     (SP)+, R5
                return
; ───────────────────────────────────────────────────────────────────────────
; вывод на экран одной записи каталога

M$OutPaneRec:   jsr     R4, @#PUSH4
                mov     R5, -(SP)
                movb    @#XB, R1
                emt     24              ; установка курсора по координатам X = R1, Y = R2;
                clr     R1
                mov     #100, R4
                clr     R0
                bisb    (R5)+, R0
                beq     9$
                bisb    13.(R5), R1
                swab    R1
                mov     #14, R2
                movb    19.(R5), -(SP)
                ble     1$
                clr     R0
                dec     R5
1$:             bisb    @#IMDOS, (SP)
                bne     3$
                mov     #10, R2
                call    sub_65340
                cmp     (R5), #20040
                beq     2$
                mov     #'., R0

2$:             mov     #4, R2
3$:             call    sub_65340
                tstb    (SP)+
                bne     4$
                cmp     -(R3), -(R3)
4$:             mov     (SP), R5
                tstb    F$DIRN(R5)
                bmi     10$
                mov     R3, -(SP)
                mov     #1, R2
                call    sub_65334
                mov     (SP)+, R0
                asl     R1
                bcc     6$
                mov     #11, R3
5$:             movb    #77, (R0)
                add     R4, R0
                sob     R3, 5$

6$:             tstb    F$DIRN(R5)
                beq     7$
                .word DM$PR + 'D
                .word DM$PR + 'I
                .word DM$PR + 'R
                br      11$

7$:             mov     F$LEN(R5), R2
                mov     R2, -(SP)
                mov     F$LENH(R5), R0
                beq     8$
                clr     (SP)
8$:             add     #ClusterSize-1, R2
                adc     R0
                clrb    R2
                bisb    R0, R2
                swab    R2
                ror     R2
                asr     R2
                asr     R2
                mov     R2, 4(SP)
                .word DM$FN + 007       ; Десятичный вывод содержимого R2, (R2<1000.)
                mov     F$ADDR(R5), R3
                call    sub_65266
                mov     (SP)+, R3
                tstb    @#DATEB
                bne     13$
                call    sub_65266
                br      19$

9$:             mov     #14, R2
                call    sub_65260
10$:            mov     #4, R2
                call    sub_65254
11$:            call    sub_65250
12$:            call    sub_65250
                br      19$

13$:            mov     (SP), R5
                mov     F$DATE(R5), R3
                beq     12$
                mov     #600, R5
                add     #120000, R3
                jsr     R4, sub_65214
                .byte 7, 4, 5, 0

MS$14$:         clr     R2
15$:            asl     R3
                rol     R2
                sob     R0, 15$
16$:            sub     #100., R2
                bpl     16$
                add     #100., R2
                mov     #'0 - 1, R0
17$:            inc     R0
                sub     #10., R2
                bpl     17$
                add     #'9 + 1, R2
                movb    R2, -(R5)
                movb    R0, -(R5)

sub_65214:      movb    (R4)+, R0
                bne     MS$14$
                mov     (SP)+, R4
                call    sub_65330
                bisb    #200, 773(R3)
                bisb    #200, 775(R3)
19$:            mov     (SP)+, R5
                jmp     @#POP4R
; End of function sub_65214


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

sub_65250:      mov     #7, R2
sub_65254:      mov     #200, R0
sub_65260:      mov     #76500, R5
                br      sub_65340


; ███████████████ S U B R O U T I N E ███████████████████████████████████████


sub_65266:      mov     #600, R5
                mov     #6, R1
1$:             mov     R3, R0
                bne     2$
                clrb    -(R5)
                br      3$

2$:             bic     #177770, R0
                add     #'0, R0
                ror     R3
                asr     R3
                asr     R3
                movb    R0, -(R5)
3$:             sob     R1, 1$
; End of function sub_65266


; ███████████████ S U B R O U T I N E ███████████████████████████████████████


sub_65330:      mov     #7, R2
sub_65334:      mov     #200, R0
sub_65340:      mov     R2, -(SP)
                mov     @#AS, R3
                bisb    @#COLORB, R1
                br      2$

1$:             clr     R0
                bisb    (R5)+, R0
2$:             aslb    R0
                bne     5$
                bcc     3$
                mov     #10, R0
3$:             mov     #5, R2
4$:             movb    R0, (R3)
                add     R4, R3
                movb    R0, (R3)
                add     R4, R3
                sob     R2, 4$
                br      9$

5$:             bcc     6$
                add     #300, R0
6$:             mov     R0, R2
                asl     R0
                asl     R0
                add     R2, R0
                add     #111576, R0
                mov     #5, R2
                tst     R1
                beq     8$
                asl     R2
                mov     R5, -(SP)
7$:             movb    (R0), R5
                aslb    R5
                bisb    (R0)+, R5
                bicb    R1, R5
                movb    R5, (R3)
                add     R4, R3
                sob     R2, 7$
                mov     (SP)+, R5
                br      9$

8$:             movb    (R0)+, (R3)
                add     R4, R3
                movb    (R0)+, (R3)
                add     R4, R3
                sob     R2, 8$

9$:             add     #-1177, R3
                dec     (SP)
                bne     1$
                mov     (SP)+, R0
                mov     R3, @#AS
                return
; End of function sub_65340

M$PAG_end: ; конец функции M$PAG
; ===========================================================================

; ===========================================================================
; 107221
; прорисовка панелей и строки меню

M$7221:         mov     #40000, R5      ; очистка экрана
1$:             clr     (R5)+
                tst     R5
                bpl     1$
                mov     #1330, @#177664 ; инициализация скроллинга
                mov     #2000, @#BAZVP  ; База видеопамяти
                clr     @#SCKOD         ; Счётчик кодов
                mov     #40600, R5
                call    sub_66106       ; выводим верхний бордюр панелей
                mov     #16, R2
                call    sub_66124       ; выводим верхнее поле панелей
                mov     #270, R2
                call    sub_66124       ; выводим поле файлов панелей

                mov     #15, R2
2$:             jsr     R1, M$PaneLine  ; выводим нижнее поле панелей
                .byte 12, 36, 0, 12
                sob     R2, 2$
                call    sub_66106       ; выводим нижний бордюр панелей

; ───────────────────────────────────────────────────────────────────────────
; 107227
; прорисовка текста в рамках панелей и строки меню

M$7227:         mov     #2, R3
                mov     #45, R4
                clr     (R4)
                mov     #XB, R2
1$:             movb    (R2)+, R1
                add     #41501, R1
                mov     R1, @#AS
                .word DM$FN + 004       ; Вывод текста на экран
                .asciz <237>"File Naмe  "<237><267><237>"Cl."<237><267><237>"Adress"<237><267><237>" "
                .even
                tstb    (R2)
                bne     2$
                .word DM$FN + 004       ; Вывод текста на экран
                .asciz "Size"<237>
                .even
                br      3$

2$:             .word DM$FN + 004       ; Вывод текста на экран
                .asciz "Date"<237>
                .even
3$:             mov     #XPB, R2
                sob     R3, 1$
                mov     #76600, @#AS
                jsr     R1, M$227S1$
                .asciz "1Help2User3View4Move5Copy6Renaмe7MkDir8Delet9Menu0Quit"
                .even

M$227S1$:       tst     (SP)+
                movb    (R1)+, R0
5$:             iot
                movb    (R1)+, R0
                movb    R0, (R4)
                beq     0Ret1$
                bicb    #77, (R4)
                bne     5$
                .word DM$PR + 040
                br      5$


; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; вывод верхнего и нижнего бордюра рамки панели

sub_66106:      call    sub_66150
                jsr     R1, M$PaneLine
                .byte 2, 36, 0, 10
                br      sub_66150
; End of function sub_66106


; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; вывод вертикальных разделителей столбцов панели

sub_66124:      jsr     R1, M$PaneLine
                .byte 12, 14, 0, 10
                .byte      3, 0, 10
                .byte      6, 0, 10
                .byte      6, 0, 12
                .even
                sob     R2, sub_66124   ;заданной высоты
; End of function sub_66124


; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; вывод полной горизонтальной строки

sub_66150:      jsr     R1, M$PaneLine
                .byte 252, 36, 252, 12
0Ret1$:         return
; End of function sub_66150


; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; прорисовка одной строки панели. рисуются обе панели за раз
; вход: R5 - адрес экрана

M$PaneLine:     mov     #40, R3         ; ширина панели
                add     R3, R5          ;
                br      3$

1$:             movb    (R1)+, R0       ; второй байт аргумента
                sub     R0, R3          ; это счётчик байтов - количество байт третьего аргумента
                movb    (R1)+, R4       ; третий байт аргумента
                bne     2$              ; если не 0
                add     R0, R5          ; если 0 - то просто прибавим счётчик к адресу
                br      3$              ; т.к. на экране и так нули

2$:             movb    R4, -40(R5)     ; если не 0
                movb    R4, (R5)+       ; то размножим его
                sob     R0, 2$

3$:             movb    (R1), -40(R5)   ; первый и 4й байт аргумента
                movb    (R1)+, (R5)+    ;
                sob     R3, 1$
                inc     R1
                bic     #1, R1
                rts     R1
; End of function M$PaneLine

M$7227_end: ; конец функции M$7227
M$7221_end: ; конец функции M$7221
; ===========================================================================

; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; выполнение функции 223 с защитой
; Инициализация диска и чтение каталога для активной  панели.
; Автоматическое преобразование каталога из формата MicroDOS.

M$LCAT_Protect: mov     (SP), @#M$CURRESFUN ; корректируем  адрес повторного
                                            ; выполнения защищаемой функции при ошибке

; ===========================================================================
; 107223
; Инициализация диска и чтение каталога для активной  панели.
; Автоматическое преобразование каталога из формата MicroDOS.

M$LCAT:         mov     @#AFAT, R2
                mov     R2, -(SP)
                mov     #4420, R1
1$:             clr     (R2)+
                sob     R1, 1$
                mov     #NFIL, R2
2$:             clr     (R2)+
                cmp     R2, #FILTP
                bne     2$
                call    M$INIT          ; Инициализация диска (с установкой индикатора IMDOS)
                mov     (SP), R2
                .word DM$FN + 054       ; Проверка DOS (если ANDOS, то =0)
                beq     3$
                add     #40, (SP)
                add     #1570, R2
                clr     R0
                mov     #3524, R1
                br      4$

3$:             add     #2000, (SP)
                mov     #3, R0
                mov     #4400, R1
4$:             mov     (SP)+, @#ADR0
                .addr   R4, M$OVLHLT1
                mov     R4, @#4
                .word DM$FN + 010       ; Вызов ANDOS-овской подпрограммы RWBLOK
                br      5$
; ───────────────────────────────────────────────────────────────────────────

M$OVLHLT1:      clr     M$OVLMorph1
5$:             .word DM$FN + 052       ; Отмена блокировки СТОП
                .word DM$FN + 054       ; Проверка DOS (если ANDOS, то =0)
                bne     6$
                .word DM$FN + 040       ; Копирование FAT с адреса AFAT в буфер ANDOS
                .word DM$FN + 037       ; Расчёт количества свободных кластеров (результат в R2)
                br      15$

6$:             mov     @#ADR0, R1
                mov     R1, R2
                add     #2230, R2
                mov     #BUFFER+32, R4
                mov     #217, R0
                cmp     -76(R2), #51414
                bne     8$
                cmp     R0, -(R4)
                blos    7$
                mov     (R4), R0
7$:             com     (R4)

8$:             cmp     20(R2), (R4)
                bhis    14$
                movb    (R2)+, 24(R1)
                bpl     9$
                add     #27, R2
                br      8$

9$:             movb    (R2)+, 25(R1)
                mov     #16, R3
                cmpb    (R2), #177
                bne     10$
                inc     R2
10$:            movb    (R2)+, (R1)+
                sob     R3, 10$
                bic     #1, R2
                clr     (R1)+
                clr     (R1)+
                clr     (R1)+
                mov     (R2)+, R3
                mov     (R2)+, R5
                beq     11$
                clrb    (R1)
11$:            tst     (R1)+
                mov     (R2)+, (R1)+
                clr     (R1)+
                mov     R3, (R1)+
                mov     (R2)+, (R1)+
                clr     (R1)
                bic     #177000, -(R1)
                beq     12$
                dec     R5
12$:            mov     #11, R3
13$:            asl     R5
                rol     2(R1)
                sob     R3, 13$
                add     R5, (R1)+
                tst     (R1)+
                sob     R0, 8$

14$:            clr     (R1)
15$:            mov     #ADR, R1
                cmp     @(R1)+, @#CWO
                beq     M$OVLMorph1
                mov     @#ADR0, -(R1)
                clrb    @#DIRB
M$OVLMorph1:    return
; End of function M$LCAT


; ===========================================================================
; 107203
; Инициализация диска (с установкой индикатора IMDOS)

M$INIT:         movb    @#DAB, @#DEVTEK
                clrb    @#IMDOS
                .word DM$FN + 131       ; Очистка флага сохранения содержимого экрана под окном
                                        ; Очистка признака записи кода в буфер
                .word DM$FN + 077       ; Инициализация диска. Если не ANDOS, то устанавливается бит "С".
                bcc     1$
                clr     R0
                mov     #201, R1
                call    @#K$RWBUF
                cmp     @#BUFFER+400, #123456
                bne     2$
                comb    @#IMDOS
1$:             mov     @#DRVTAB+D$FLGTAB, @#TDA
                return

2$:             .word DM$FN + 122       ; установка вектора 4 на обработку ошибочной ситуации
                jmp     @#M$EERR1
; End of function M$INIT

M$INIT_end: ; конец функции M$INIT
M$LCAT_end: ; конец функции M$LCAT
M$PAN_end:  ; конец функции M$PAN
M$7212_end: ; конец функции M$7212
M$WPAN_end: ; конец функции M$WPAN
M$WDP_end:  ; конец функции M$WDP
M$7201_end: ; конец функции M$7201
; ===========================================================================

; ===========================================================================
; 107213
; Make Dir
M$7213:         .word DM$FN + 027       ; Контроль MicroDOS (если MicroDOS, то HALT)
1$:             clrb    @#M$EDITBUF
                .word DM$FN + 065       ; Строчный редактор.
                .byte 202
                .asciz "Make DIR"
                .even
                clr     R5
                call    sub_67204
                bcs     1$
                .word DM$FN + 207       ; Проверка совпадения FAT диска с FAT текущей панели. Необходимо
                                        ; для обнаружения подмены диска перед записью каталога.
                .word DM$FN + 055       ; создание новой директории
                bcc     2$
                .word DM$FN + 064       ; Вывод текста в рамке.
                .byte 7, 10, 24, 22
                .asciz "Directory full"
                .even
                .word DM$FN + 076       ; останов двигателя дисковода, звуковой сигнал, пауза и СТОП

2$:             movb    @#DIRB, F$PARD(R1)
                mov     R1, @#ADR
                jmp     jmp_70010

; ===========================================================================
; Задать фильтр

M$7205:         clrb    @#M$EDITBUF
                .word DM$FN + 065       ; Строчный редактор.
                .byte 203
                .asciz "FILTER"
                .even
                mov     #FILT, R1
                mov     #13, R0
                clr     R4
                clrb    @#ILIB
1$:             cmp     R0, #3
                beq     2$
                cmpb    (R2), #40
                bne     2$
                clrb    (R2)
2$:             movb    (R2)+, (R1)
                bisb    (R1)+, R4
                sob     R0, 1$
                .word DM$FN + 072       ; Фрагмент, сохранённый подпрограммой RAMKA, из памяти на экран
                return
; End of function M$7205

; ───────────────────────────────────────────────────────────────────────────
; 107210
; Rename File
M$7210:         .word DM$FN + 027       ; Контроль MicroDOS (если MicroDOS, то HALT)
                .word DM$FN + 026       ; Контроль конца каталога (адрес записи в R5). Если (R5)=0, то происходит HALT-прерывание
                cmp     (R5), #"..
                beq     3$
                mov     R5, -(SP)

1$:             mov     (SP), R5
                mov     #M$EDITBUF, R0
                .word DM$FN + 030       ; Преобразование имени файла из формата каталога ANDOS в формат блока параметров EMT 36
                .word DM$FN + 065       ; Строчный редактор.
                .byte 203
                .asciz "RENAME"
                .even
                mov     (SP), R5
                call    sub_67176
                bcs     1$
                .word DM$FN + 207       ; Проверка совпадения FAT диска с FAT текущей панели. Необходимо
                                        ; для обнаружения подмены диска перед записью каталога.
                mov     (SP)+, R5
                mov     #14, R4
2$:             movb    (R2)+, (R5)+
                sob     R4, 2$
                .word DM$FN + 070       ; Запись текущего каталога на диск и перерисовка панелей
3$:             halt
; ───────────────────────────────────────────────────────────────────────────

sub_67176:      tstb    F$DIRN(R5)
                beq     100$

sub_67204:      mov     R3, R2
                movb    #10, F$ATTR(R3)
100$:           mov     R2, R4
                mov     #13, R0
1$:             tstb    (R4)+
                bne     2$
                movb    #40, -1(R4)
2$:             sob     R0, 1$
                cmp     (R2), #20040
                bne     3$
                movb    #137, (R2) ; '_'
3$:             .word DM$FN + 020       ; R1=ADR0-40
4$:             add     #F$RecLen, R1
                tstb    (R1)
                beq     6$
                cmp     R1, R5
                beq     4$
                mov     R1, R3
                mov     R2, R4
                mov     #14, R0
5$:             cmpb    (R3)+, (R4)+
                bne     4$
                sob     R0, 5$
                sec
6$:             return
M$7210_end: ; конец функции M$7210
M$7205_end: ; конец функции M$7205
; ===========================================================================


; ===========================================================================
; 107207
; Проверка совпадения FAT диска с FAT текущей панели. Необходимо
; для обнаружения подмены диска перед записью каталога.

M$TEST:         mov     R5, -(SP)
                mov     R2, -(SP)
                mov     R0, -(SP)
                movb    @#IMDOS, -(SP)
                .word DM$FN + 203       ; Инициализация диска (с установкой индикатора IMDOS)
                cmpb    (SP), @#IMDOS
                bne     2$
                tstb    (SP)+
                bne     4$
                call    @#K$RDFAT
                mov     #M$EDITBUF, R4
                mov     @#IOBUFF, R2
                mov     @#AFAT, R1
1$:             cmp     (R2)+, (R1)+
                beq     3$
2$:             .word DM$FN + 064       ; Вывод текста в рамке
                .byte 12, 10, 24, 13
                .asciz "Other disk!"
                .even
                .word DM$FN + 034       ; Звуковой сигнал
                .word DM$FN + 002       ; Приём символа с клавиатуры в R0
                .word DM$FN + 212       ; Инициализация диска и чтение каталога для активной панели и
                                        ; переход в режим работы с панелью. Можно использовать как
                                        ; выход в оболочку
3$:             sob     R4, 1$

4$:             mov     (SP)+, R0
                mov     (SP)+, R2
                mov     (SP)+, R5
                .word DM$FN + 020       ; R1=ADR0-40
                return
M$TEST_end: ; конец функции M$TEST
; ===========================================================================


; ===========================================================================
; 107211
; Delete
M$7211:         .word DM$FN + 027       ; Контроль MicroDOS (если MicroDOS, то HALT)
                call    sub_70314
                .word DM$FN + 073       ; Меню YES/NO
                .byte 5
                .asciz "Delete"
                .even
                .word DM$FN + 207       ; Проверка совпадения FAT диска с FAT текущей панели. Необходимо
                                        ; для обнаружения подмены диска перед записью каталога.
                .word DM$FN + 206       ; удаление всех помеченных файлов/каталогов с содержимым этих каталогов
                call    @#K$WRFAT
                .word DM$FN + 041       ; Копирование FAT из буфера ANDOS по адресу AFAT
                .word DM$FN + 037       ; Расчёт количества свободных кластеров (результат в R2)
                .word DM$FN + 070       ; Запись текущего каталога на диск и перерисовка панелей

; ===========================================================================
; 107214
; Запись каталога активной панели на диск
M$SAVE:         mov     @#ADR0, R2      ; базовый адрес начала каталога
                mov     #-3400, R1
                mov     #5, R0
                .word DM$FN + 010       ; Вызов ANDOS-овской подпрограммы RWBLOK
                return
; End of function M$SAVE


; ───────────────────────────────────────────────────────────────────────────
;107206
; удаление всех помеченных файлов/каталогов с содержимым этих каталогов

M$7206:         br      5$
1$:             movb    F$DIRN(R1), R0  ; берём номер подкаталога
                beq     4$              ; если это файл - просто удаляем
                mov     @#ADR0, R2      ; базовый адрес начала каталога
                ;если это каталог - все его записи переместим в родительский каталог
2$:             cmpb    F$PARD(R2), R0  ; запись принадлежит искомому подкаталогу?
                bne     3$              ; нет
                movb    F$PARD(R1), F$PARD(R2) ; вынем её из того каталога и поместим в текущий
3$:             add     #F$RecLen, R2   ; переходим к следующей записи
                tstb    (R2)            ; пока они не закончатся
                bne     2$

4$:             .word DM$FN + 053       ; Удаление файла/каталога
                                        ; Вход: R1 - адрес записи о файле/каталоге
5$:             .word DM$FN + 011       ; Поиск помеченного файла начиная с адреса в R1
                bne     1$
                return
; End of function M$7206

M$7206_end: ; конец функции M$7206
M$SAVE_end: ; конец функции M$SAVE
; ===========================================================================

; ───────────────────────────────────────────────────────────────────────────
; 107215
; Copy/Move Files
; R0=0 - copy, !=0 - move
M$7215:         mov     R0, -(SP)
                beq     1$
                .word DM$FN + 027       ; Контроль MicroDOS (если MicroDOS, то HALT)
1$:             call    sub_70314
                movb    @#DIRPB, R0
                bne     2$
                dec     R0
2$:             .word DM$FN + 046       ; R1=ADR0P-40
                .word DM$FN + 032       ; Поиск подкаталога с номером, находящемся в R0, адрес записи
                                        ; помещается в R1. Если таковой не найден, то R1=0
                mov     #IMTMAS, R2
                mov     R2, R5
                mov     #13, R0
3$:             movb    (R1)+, (R2)+
                sob     R0, 3$
                mov     #M$EDITBUF, R0
                .word DM$FN + 030       ; Преобразование имени файла из формата каталога ANDOS (адрес
                                        ; записи в R5) в формат блока параметров EMT 36
                .word DM$FN + 072       ; Фрагмент, сохранённый подпрограммой RAMKA, из памяти на экран
                .word DM$PR + 237
                .word DM$FN + 012       ; Расчёт адреса вывода рамки и получение размеров
                .byte 13, 4, 2, 11
                add     #101, @#AS
                add     #400, R1
                .word DM$FN + 056       ; прорисовка тела рамки
                .byte 0, 377, 374, 77
                .word DM$FN + 056       ; прорисовка тела рамки
                .byte 16, 0, 74, 74
                tst     (SP)
                beq     4$
                .word DM$FN + 004
                .asciz "MOVE TO"
                .even
                br      5$

4$:             .word DM$FN + 004
                .asciz "COPY TO"
                .even
5$:             mov     #DAPB, R4
                .word DM$FN + 200       ; Меню "выбор привода"
                tst     R0
                bne     8$
                .word DM$FN + 065       ; Строчный редактор
                .byte 203
                .asciz "SubDir"
                .even
                mov     #IMTMAS, R1
                mov     #13, R0
6$:             movb    (R3)+, (R1)+
                bne     7$
                movb    #40, -1(R1)
7$:             sob     R0, 6$
8$:             mov     (SP)+, @#400
                beq     15$
                .word DM$FN + 042       ; Сравнение приводов панелей (если =0, значит приводы одинаковые)
                bne     15$
                .word DM$FN + 067       ; поиск в каталоге директории с именем из буфера имени текущего массива
                                        ; в блоке параметров магнитофона
                movb    R0, @#DIRPB

jmp_70010:      mov     #460, R1
                mov     #161, R2
10$:            movb    R0, (R1)+
                sob     R2, 10$
                mov     R0, R3
                .word DM$FN + 020       ; R1=ADR0-40
11$:            .word DM$FN + 033       ; Поиск помеченного подкаталога начиная с адреса в R1. Если подкаталог
                                        ; найден, то адрес его записи в каталоге помещается в R1, если
                                        ; нет, то устанавливается бит Z (=0)
                beq     12$
                movb    R0, 460(R0)
                cmpb    R0, R3
                bne     11$
                clrb    F$MARK(R1)
                clrb    F$PARD(R1)
                br      11$

12$:            .word DM$FN + 020       ; R1=ADR0-40
13$:            .word DM$FN + 011       ; Поиск помеченного файла начиная с адреса в R1. Если файл найден,
                                        ; то адрес его записи в каталоге помещается в R1,
                                        ; если нет, то устанавливается бит Z (=0)
                beq     14$
                movb    F$PARD(R1), R0
                movb    460(R0), F$PARD(R1)
                clrb    F$MARK(R1)
                br      13$

14$:            .word DM$FN + 070       ; Запись текущего каталога на диск и перерисовка панелей
15$:            .word DM$FN + 207       ; Проверка совпадения FAT диска с FAT текущей панели. Необходимо
                                        ; для обнаружения подмены диска перед записью каталога.
                call    M$ChkSum        ;подсчёт контрольной суммы буфера BUFFER
                movb    R0, @#byte_126423
                clr     @#420
                clrb    @#M$CpMvOperation

; ───────────────────────────────────────────────────────────────────────────
; 107224
; прорисовка окна копирования/переноса
; и процедура копирования/переноса

M$7224:         mov     #70000, R0
1$:             clr     (R0)+
                tst     R0
                bpl     1$
                mov     #230, @#177664
                mov     #70107, R1
                mov     #57, R3
                .word DM$FN + 057       ; элемент горизонтального бордюра рамки
                .word DM$FN + 060       ; элемент горизонтального бордюра рамки
                mov     #47, R2

2$:             movb    #363, (R1)+
                mov     #42, R4
3$:             comb    (R1)+
                sob     R4, 3$
                movb    #363, (R1)+
                mov     #14, R4
4$:             comb    (R1)+
                sob     R4, 4$
                movb    #317, (R1)
                add     #20, R1
                sob     R2, 2$
                .word DM$FN + 060       ; элемент горизонтального бордюра рамки
                mov     #16, R2
                .word DM$FN + 063       ; прорисовка нижнего бордюра рамки
                mov     #71154, @#AS
                .word DM$FN + 004
                .asciz <234>"Files: "
                .even
                mov     @#NFIL, R2
                .word DM$FN + 007       ; Десятичный вывод содержимого R2, (R2<1000.)
                mov     #73054, @#AS
                .word DM$FN + 004
                .asciz "Rest :"
                .even
                .word DM$FN + 220       ; тело процедуры копирования/переноса

; ───────────────────────────────────────────────────────────────────────────
sub_70314:      .word DM$FN + 131       ; Очистка флага сохранения содержимого экрана под окном
                                        ; Очистка признака записи кода в буфер
                .word DM$FN + 020       ; R1=ADR0-40
                .word DM$FN + 011       ; Поиск помеченного файла начиная с адреса в R1. Если файл найден,
                                        ; то адрес его записи в каталоге помещается в R1,
                                        ; если нет, то устанавливается бит Z (=0)
                beq     2$
1$:             movb    SP, @#ITTB
                mov     @#ADR0, R5
                .word DM$FN + 202       ; Вывод панели на экран
                .word DM$FN + 222       ; Вывод на экран параметров диска (files, clust., free)
                movb    @#ITEGB, @#ITTB
                return

2$:             .word DM$FN + 026       ; Контроль конца каталога (адрес записи в R5). Если (R5)=0, то
                                        ; происходит HALT-прерывание
                comb    F$MARK(R5)
                .word DM$FN + 232       ; пометка файла/директории с рекурсивной пометкой всех файлов всех вложенных директорий
                sub     #M$TT4Handler-M$TT4ErrHndl, @#4 ; В 4 адрес M$TT4Handler, его туда помещает функция 107017(107052)
                br      1$
M$7224_end: ; конец функции M$7224
M$7211_end: ; конец функции M$7211
M$7213_end: ; конец функции M$7213
; ===========================================================================


; ===========================================================================
; 107220
; тело процедуры копирования/переноса файлов

M$7220:         .word DM$FN + 017       ; защита функции, после нажатия на клавишу СТОП, начнётся повторное
                                        ; выполнение защищённой функции
O$220PEP:       add     #O$226PEP2 - O$220PEP, @#M$CURRESFUN
                mov     #OVERLAYADDR + M$7220_end-M$7220, @#402
                call    sub_72642

jmp_70412:      clr     R1
                call    sub_72236
                .word DM$FN + 040       ; Копирование FAT с адреса AFAT в буфер ANDOS
                .word DM$FN + 020       ; R1=ADR0-40
                br      3$

2$:             mov     @#406, R1
3$:             .word DM$FN + 011       ; Поиск помеченного файла начиная с адреса в R1. Если файл найден,
                                        ; то адрес его записи в каталоге помещается в R1,
                                        ; если нет, то устанавливается бит Z (=0)
                beq     13$
                tstb    F$DIRN(R1)
                bne     3$
                mov     R1, @#406
                call    sub_72164
                bcs     13$
                call    M$GetFileLen    ; получение размера текущего файла в байтах
                                        ; Выход: R5:R4 - размер файла
                                        ;       R2 - ???
                mov     F$CLUS(R1), R0
                cmp     R2, @#402
                bne     5$
                mov     @#410, R1
                beq     5$
4$:             call    sub_72774
                sub     R3, R4
                sbc     R5
                sob     R1, 4$

5$:             clr     R1
                mov     R0, -(SP)
6$:             mov     R0, -(SP)
                inc     (SP)
                call    sub_72774
                sub     R3, R4
                sbc     R5
                bpl     7$
                clr     R5
                add     R4, R3
                clr     R4
7$:             mov     R3, -(SP)
                add     R1, (SP)
                add     R2, (SP)
                cmp     (SP)+, #70000
                blos    8$
                com     R5
                tst     (SP)+
                br      9$

8$:             add     R3, R1
                inc     @#420
                cmp     R0, (SP)+
                beq     6$
                mov     R5, R3
                bis     R4, R3
                beq     9$
                .word DM$FN + 054       ; Проверка DOS (если ANDOS, то =0)
                bne     6$
9$:             mov     (SP)+, R3
                tst     R1
                beq     13$
                .word DM$FN + 036       ; Кластерная операция: R3 - номер кластера, R1 - длина, R2 -
                                        ; адрес (после операции к R2 прибавляется абсолютная величина R1)
                tstb    @#ERRFDD
                beq     11$
                call    sub_72746
                mov     @#410, -(SP)
                cmp     @#404, @#402
                bne     10$
                clr     (SP)
10$:            call    sub_72620
                mov     (SP)+, @#410
                br      2$

11$:            mov     R5, R1
                bmi     13$
                bis     R4, R1
                bne     5$
                mov     R2, @#404
                call    sub_72670
                br      2$

loc_70706:      jmp     jmp_70412

13$:            mov     PC, R1
                call    sub_72236
jmp_70720:      .word DM$FN + 020       ; R1=ADR0-40
                .word DM$FN + 011       ; Поиск помеченного файла начиная с адреса в R1. Если файл найден,
                                        ; то адрес его записи в каталоге помещается в R1,
                                        ; если нет, то устанавливается бит Z (=0)
                bne     15$
                call    sub_73036
15$:            mov     R1, @#406
                call    sub_72164
                bcs     loc_70706
                tstb    @#M$ContinueOp
                bne     26$
                .word DM$FN + 044       ; Сброс режима кеширования
                .word DM$FN + 014       ; Смена активной панели
                .word DM$FN + 223       ; Инициализация диска и чтение каталога для активной  панели.
                                        ; Автоматическое преобразование каталога из формата MicroDOS.
                call    M$ChkSum        ;подсчёт контрольной суммы буфера BUFFER
                movb    R0, @#byte_126423
                .word DM$FN + 067       ; поиск в каталоге директории с именем из буфера имени текущего массива
                                        ; в блоке параметров магнитофона
                                        ; Вход: R1 - начало каталога
                                        ; Выход: R0 - номер найденной директории
                                        ;       Z - конец каталога, ничего не найдено
                .word DM$FN + 014       ; Смена активной панели
                movb    R0, @#DIRPB
                tstb    @#IMDOSP
                beq     16$
                jmp     @#M$EERR1

16$:            mov     #460, R1
                mov     #113., R2
17$:            movb    R0, (R1)+
                sob     R2, 17$
                .word DM$FN + 020       ; R1=ADR0-40
18$:            .word DM$FN + 033       ; Поиск помеченного подкаталога начиная с адреса в R1. Если подкаталог
                                        ; найден, то адрес его записи в каталоге помещается в R1, если
                                        ; нет, то устанавливается бит Z (=0)
                beq     22$
                mov     R1, R4
                .word DM$FN + 046       ; R1=ADR0P-40
                .word DM$FN + 115       ; поиск в каталоге директории с заданным именем
                                        ; Вход: R1 - начало каталога
                                        ;       R4 - буфер имени директории
                                        ; Выход: R0 - номер найденной директории
                                        ;       Z - конец каталога, ничего не найдено
                tst     R0
                beq     19$
                clrb    F$MARK(R4)
                br      21$

19$:            mov     R4, R2
                mov     R4, -(SP)
                .word DM$FN + 046       ; R1=ADR0P-40
                .word DM$FN + 055       ; создание новой директории
                                        ; Вход: R1 - начало каталога. с учётом первой записи ..
                                        ;       R2 - буфер имени директории
                bcc     20$
                jmp     @#M$EERR3

20$:            mov     (SP)+, R4
21$:            movb    F$DIRN(R4), R1
                movb    R0, 460(R1)
                mov     R4, R1
                br      18$

22$:            .word DM$FN + 020       ; R1=ADR0-40
23$:            .word DM$FN + 033       ; Поиск помеченного подкаталога начиная с адреса в R1. Если подкаталог
                                        ; найден, то адрес его записи в каталоге помещается в R1, если
                                        ; нет, то устанавливается бит Z (=0)
                beq     24$
                mov     R1, R4
                .word DM$FN + 046       ; R1=ADR0P-40
                .word DM$FN + 115       ; поиск в каталоге директории с заданным именем
                                        ; Вход: R1 - начало каталога
                                        ;       R4 - буфер имени директории
                                        ; Выход: R0 - номер найденной директории
                                        ;       Z - конец каталога, ничего не найдено
                clrb    F$MARK(R4)
                movb    F$PARD(R4), R2
                movb    460(R2), F$PARD(R1)
                mov     R4, R1
                br      23$

24$:            comb    @#M$ContinueOp
25$:            br      jmp_70720

26$:            mov     @#TDAP, @#DRVTAB+D$FLGTAB
                .word DM$FN + 043       ; Установка режима кеширования по чтению/записи каталога и FAT
                                        ; (соответствующие блоки будут обрабатываться не на диске, а
                                        ; в каталоге оболочки)
                call    sub_72746
                clr     @#TEKBLK
                .word DM$FN + 116       ; ANDOS-овская подпрограмма DONAM
                .word DM$FN + 117       ; ANDOS-овская подпрограмма DIRFI2
                bcs     29$
                movb    @#M$CpMvOperation, R3
                cmpb    R3, #2
                beq     27$
                mov     R2, -(SP)
                mov     R0, -(SP)
                .word DM$FN + 045       ; закрашиваем место под вывод сообщений в обработчике ошибок Оболочки
                add     #-11, @#AS
                .word DM$FN + 034       ; Звуковой сигнал
                .word DM$FN + 004       ; Вывод текста на экран
                .asciz "File exist: Overwrite Double All Skip"
                .even
                mov     #OVERLAYADDR + M$F220TP-M$7220, R2 ; адрес блока параметров
                .word DM$FN + 047       ; Горизонтальное меню.
                .asciz "ODAS"
                .even
                mov     (SP)+, R0
                mov     (SP)+, R2
                movb    R3, @#M$CpMvOperation
                asl     R3
                add     R3, PC
                br      27$             ; Overwrite
                br      28$             ; Double
                br      27$             ; All
                call    sub_72620       ; Skip
                call    M$CheckLen      ; проверка размера файла.
                                        ; Выход: бит С=1 - файл слишком большой, и не влазит в буфер
                                        ;           С=0 - всё в порядке
                bcs     30$
                inc     R3
                bic     #1, R3
                mov     R3, @#404
                br      25$

27$:            ; Overwrite
                call    @#K$ERASE1
                br      29$

28$:            ; Double
                call    @#K$DOUBLE
29$:            call    @#K$RDFAT
                .word DM$FN + 014       ; Смена активной панели
                .word DM$FN + 037       ; Расчёт количества свободных кластеров (результат в R2)
                .word DM$FN + 014       ; Смена активной панели
                cmp     @#416, R2
                blos    31$
                jmp     @#M$EERR2

30$:            jmp     jmp_70412

31$:            call    @#K$FRCLAS
                mov     R0, R5
32$:            mov     @#416, R2
                mov     R0, R3
                br      34$

33$:            inc     R0
                mov     R0, R4
                call    @#K$FRCLA1
                bcs     35$
                cmp     R0, R4
                bne     32$
34$:            sob     R2, 33$

                mov     R3, R5
35$:            mov     R5, R0
                call    M$AddClustChain ; добавление кластера в цепочку фат файла
                                        ; Вход: R0 - номер кластера
                                        ; Выход: R0 - номер следующего кластера
                mov     R0, @#414
                call    M$GetFileLen    ; получение размера текущего файла в байтах
                                        ; Выход: R5:R4 - размер файла
                                        ;       R2 - ???
                mov     @#410, R3
                mov     R3, @#302
                beq     37$
36$:            call    M$AddClustChain ; добавление кластера в цепочку фат файла
                                        ; Вход: R0 - номер кластера
                                        ; Выход: R0 - номер следующего кластера
                sub     #ClusterSize, R4
                sbc     R5
                sob     R3, 36$

37$:            clr     R1
                mov     R0, -(SP)
38$:            mov     #ClusterSize, -(SP)
                tst     R5
                bne     39$
                cmp     R4, (SP)
                bhi     39$
                mov     R4, (SP)
39$:            mov     (SP), -(SP)
                sub     R1, (SP)
                add     R2, (SP)
                cmp     (SP)+, #70000
                blos    40$
                tst     (SP)+
                br      42$

40$:            inc     @#410
                inc     @#420
                sub     (SP), R1
                sub     (SP)+, R4
                sbc     R5
                bne     41$
                tst     R4
                beq     42$
41$:            mov     R0, R3
                call    M$AddClustChain ; добавление кластера в цепочку фат файла
                                        ; Вход: R0 - номер кластера
                                        ; Выход: R0 - номер следующего кластера
                inc     R3
                cmp     R0, R3
                beq     38$
42$:            mov     (SP)+, R3
                tst     R1
                beq     30$
                .word DM$FN + 036       ; Кластерная операция: R3 - номер кластера, R1 - длина, R2 -
                                        ; адрес (после операции к R2 прибавляется абсолютная величина R1)
                tstb    @#ERRFDD
                beq     45$
                asr     R1
                sub     @#DRVTAB+D$WCNT, R1

                mov     R3, R0
43$:            sub     #2000, R1
                bmi     44$
                inc     R0
                br      43$

44$:            mov     @#302, @#410
                clr     @#TEKBLK
                call    @#K$RDFAT
                mov     #7767, R1
                call    @#K$SETFAT
                call    @#K$WRFAT
                br      29$

45$:            mov     R5, R1
                bis     R4, R1
                bne     37$
                mov     R2, @#404
                mov     @#414, R4
                mov     @#406, R3
                add     #F$PARD, R3
                movb    (R3)+, R1
                movb    460(R1), @#SUBDIR
                mov     (R3)+, @#ADRDIR
                mov     (R3)+, R2
                tst     (R3)+
                mov     (R3)+, R1
                mov     (R3)+, R3
                call    @#K$ENDWRT
                sub     @#416, @#FRECLP
                call    sub_72626
                tst     @#400
                beq     46$
                .word DM$FN + 040       ; Копирование FAT с адреса AFAT в буфер ANDOS
                .word DM$FN + 053       ; Удаление файла/каталога
                                        ; Вход: R1 - адрес записи о файле/каталоге
                add     @#416, @#FRECL
                .word DM$FN + 041       ; Копирование FAT из буфера ANDOS по адресу AFAT
46$:            jmp     jmp_70720

; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; добавление кластера в цепочку фат файла
; Вход: R0 - номер кластера
; Выход: R0 - номер следующего кластера

M$AddClustChain:jsr     R4, @#PUSH4
                mov     R0, R4
                call    @#K$FRCLA1      ; Поиск пустого кластера, начиная от указанного
                                        ; Параметры: R4 - кластер начала поиска
                                        ; Результат: Номер пустого кластера -> R0 (бит "C" - нет)
                mov     R0, R1          ; нашли (или не нашли, тогда тут непонятно что)
                mov     (SP), R0        ; снова достаём номер кластера
                mov     R1, (SP)        ; найденный - на место R0
                ; добавляем найденное к цепочке
                call    @#K$SETFAT      ; Запись в ячейку FAT
                                        ; Параметры: R0 - номер ячейки, R1 - содержимое
                                        ; Результат: R0 - старое содержимое ячейки
                mov     (SP), R0
                mov     #7777, R1
                ; и завершаем цепочку на всякий случай
                call    @#K$SETFAT      ; Запись в ячейку FAT
                                        ; Параметры: R0 - номер ячейки, R1 - содержимое
                                        ; Результат: R0 - старое содержимое ячейки
                jmp     @#POP4R
; End of function M$AddClustChain


; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; получение размера текущего файла в байтах
; Выход: R5:R4 - размер файла
;       R2 - ???

M$GetFileLen:   mov     @#406, R1
                mov     F$LEN(R1), R4
                mov     F$LENH(R1), R5
                mov     @#404, R2
                return
; End of function M$GetFileLen


; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; проверка размера файла.
; Выход: бит С=1 - файл слишком большой, и не влазит в буфер
;           С=0 - всё в порядке

M$CheckLen:     call    M$GetFileLen    ; получение размера текущего файла в байтах
                                        ; Выход: R5:R4 - размер файла
                                        ;       R2 - ???
                tst     R5              ; размер больше 64КБ?
                bne     MO$RetC1$       ; да - выход с ошибкой
                mov     R4, R3          ; размер больше 32кБ?
                bmi     MO$RetC1$       ; да - выход с ошибкой
                add     R2, R3          ; получим конечный адрес в буфере
                cmp     #70000, R3      ; в буфер влазит?
                bhis    2$              ; да - нормальный выход

MO$RetC1$:      sec                     ; файл слишком большой - С
2$:             return
; End of function M$CheckLen

; ───────────────────────────────────────────────────────────────────────────

sub_72164:      call    M$CheckLen      ; проверка размера файла.
                                        ; Выход: бит С=1 - файл слишком большой, и не влазит в буфер
                                        ;           С=0 - всё в порядке
                bcc     1$
                .word DM$FN + 042       ; Сравнение приводов панелей (если =0, значит приводы одинаковые)
                beq     1$
                cmp     R2, @#402
                bne     MO$RetC1$
1$:             mov     #IMMAS, R0
                mov     R1, R5
                .word DM$FN + 030       ; Преобразование имени файла из формата каталога ANDOS (адрес
                                        ; записи в R5) в формат блока параметров EMT 36 (с точкой, разделяющей
                                        ; имя и расширение, и т.п.). Преобразованное имя записывается
                                        ; на адрес в R0
                mov     #71122, @#AS
                mov     #16, R1
2$:             movb    (R3)+, R0
                iot
                sob     R1, 2$
                br      101$

; ───────────────────────────────────────────────────────────────────────────
; вход: R1 - флаг: ==0 - , !=0 - 
sub_72236:      call    sub_72670
                mov     #71111, @#AS
                mov     @#402, @#404
                tst     R1
                bne     100$
                .word DM$FN + 004       ; Вывод текста на экран
                .asciz "Read  "
                .even
                .word DM$FN + 051       ; Установка привода активной панели текущим
                                        ; Вывод имени привода на экран
                movb    @#byte_126423, (PC)+
word_72302:     .word 0
                br      1$

100$:           .word DM$FN + 004       ; Вывод текста на экран
                .asciz "Write "
                .even
                .word DM$FN + 014       ; Смена активной панели
                .word DM$FN + 051       ; Установка привода активной панели текущим
                                        ; Вывод имени привода на экран
                .word DM$FN + 014       ; Смена активной панели
                movb    @#byte_126457, word_72302
1$:             .word DM$FN + 042       ; Сравнение приводов панелей (если =0, значит приводы одинаковые)
                bne     5$
                bisb    @#M$ContinueOp, R1
                beq     101$
                mov     #15, R0
2$:             .word DM$PR + 40        ; Копирование FAT с адреса AFAT в буфер ANDOS
                sob     R0, 2$
                tst     R1
                bmi     4$
3$:             .word DM$FN + 130       ; Очистка признака записи кода в буфер
                .word DM$FN + 045       ; закрашиваем место под вывод сообщений в обработчике ошибок Оболочки
                .word DM$FN + 034       ; Звуковой сигнал
                add     #4, @#AS
                .word DM$FN + 004
                .asciz "Change disk"
                .even
                mov     #177130, R4
                call    sub_72514
                clrb    R1
                tst     R1
                bmi     4$
                tstb    @#M$ContinueOp
                beq     101$
4$:             .word DM$FN + 044       ; Сброс режима кеширования
                clr     @#TEKBLK
                call    @#K$RDFAT
                .word DM$FN + 043       ; Установка режима кеширования по чтению/записи каталога и FAT
                                        ; (соответствующие блоки будут обрабатываться не на диске, а
                                        ; в каталоге оболочки)
                call    M$ChkSum        ;подсчёт контрольной суммы буфера BUFFER
                cmpb    R0, word_72302
                bne     3$
5$:             tstb    R1
                bmi     6$
101$:           .word DM$FN + 045       ; закрашиваем место под вывод сообщений в обработчике ошибок Оболочки
6$:             clc
                return

; ███████████████ S U B R O U T I N E ███████████████████████████████████████
;подсчёт контрольной суммы буфера BUFFER

M$ChkSum:       mov     #BUFFER, R5
                mov     #BUFFERLEN, R4
                jmp     @#116622        ; CHKSUM
; End of function M$ChkSum

M$7215_end: ; конец функции M$7215
; ===========================================================================


sub_72514:      call    sub_72566
                mov     R2, R3
1$:             .word DM$FN + 106       ; что-то с проверкой нового кода в буфере клавиатуры
                beq     1$
2$:             .word DM$FN + 106       ; что-то с проверкой нового кода в буфере клавиатуры
                bne     2$
3$:             call    sub_72566
                sub     R3, R2
                bpl     4$
                neg     R2
4$:             cmp     R2, #100
                bge     3$
                return

; ───────────────────────────────────────────────────────────────────────────

loc_72554:      mov     #30000, R5
3$:             tst     (R4)
                bpl     2$
                sob     R5, 3$

sub_72566:      .word DM$FN + 106            ; что-то с проверкой нового кода в буфере клавиатуры
                clr     R2
                mov     #30000, R5
1$:             tst     (R4)
                bmi     loc_72554
                sob     R5, 1$
                br      sub_72566

2$:             inc     R2
                bmi     sub_72566
                tst     (R4)
                bpl     2$
                return

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

sub_72620:      add     @#416, @#420
sub_72626:      dec     @#NFIL
                mov     @#406, R1
                clrb    F$MARK(R1)

sub_72642:      clr     @#410
                mov     #73063, @#AS
                mov     @#NFIL, R2
                .word DM$FN + 007       ; Десятичный вывод содержимого R2, (R2<1000.)
                bne     sub_72670
                asl     @#420

sub_72670:      mov     @#420, R3
                mov     #4, R0
1$:             asl     R3
                sob     R0, 1$
                mov     #73011, @#AS
                clr     @#PRPODC
                mov     #40, R2
2$:             sub     @#NCL, R3
                bpl     3$
                .word DM$PR + 277
                br      4$

3$:             .word DM$PR + 040       ; Копирование FAT с адреса AFAT в буфер ANDOS
4$:             sob     R2, 2$
                dec     @#PRPODC
                return
; End of function sub_72670
; End of function sub_72642
; End of function sub_72626
; End of function sub_72620


; ███████████████ S U B R O U T I N E ███████████████████████████████████████


sub_72746:      call    M$GetFileLen    ; получение размера текущего файла в байтах
                                        ; Выход: R5:R4 - размер файла
                                        ;       R2 - ???
                mov     #13, R0         ; получим размер файла в кластерах
1$:             asr     R5
                ror     R4
                adc     R4
                sob     R0, 1$
                mov     R4, @#416       ; и сохраним сюда
                return
; End of function sub_72746

; ───────────────────────────────────────────────────────────────────────────

sub_72774:      mov     #ClusterSize, R3
                .word DM$FN + 054       ; Проверка DOS (если ANDOS, то =0)
                beq     1$
                cmp     (R0)+, (R0)+
                return

1$:             jmp     @#K$GETFAT
; ───────────────────────────────────────────────────────────────────────────

sub_73014:      mov     #71117, @#AS
                .word DM$FN + 051       ; Установка привода активной панели текущим
                                        ; Вывод имени привода на экран
                .word DM$FN + 040       ; Копирование FAT с адреса AFAT в буфер ANDOS
                .word DM$FN + 214       ; Запись каталога активной панели на диск
                jmp     @#K$WRFAT
; ───────────────────────────────────────────────────────────────────────────

O$226PEP2:      clr     -(SP)
; ───────────────────────────────────────────────────────────────────────────
sub_73036:     .word DM$FN + 044            ; Сброс режима кеширования
                movb    @#M$ContinueOp, R1
                beq     5$
                clrb    @#M$ContinueOp
                call    sub_72236
                .word DM$FN + 044       ; Сброс режима кеширования
                .word DM$FN + 014       ; Смена активной панели
                call    sub_73014
                .word DM$FN + 014       ; Смена активной панели
                mov     @#400, R5
                beq     4$
                tst     (SP)
                beq     3$
                mov     #AS, R0
1$:             cmpb    460(R0), @#DIRPB
                beq     2$
                .word DM$FN + 020       ; R1=ADR0-40
                .word DM$FN + 032       ; Поиск подкаталога с номером, находящемся в R0, адрес записи
                                        ; помещается в R1. Если таковой не найден, то R1=0
                comb    F$MARK(R1)
2$:             sob     R0, 1$
                .word DM$FN + 020       ; R1=ADR0-40
                .word DM$FN + 206       ; удаление всех помеченных файлов/каталогов с содержимым этих каталогов
3$:             call    sub_73014
4$:             .word DM$FN + 066       ; остановка двигателя дисковода и сброс кода клавиши
                tst     (SP)
                bne     5$
                .word DM$FN + 034       ; Звуковой сигнал
                .word DM$FN + 002       ; Приём символа с клавиатуры в R0
5$:             .word DM$FN + 042       ; Сравнение приводов панелей (если =0, значит приводы одинаковые)
                bne     6$
                .word DM$FN + 014       ; Смена активной панели
6$:             .word DM$FN + 221       ; прорисовка панелей и строки меню
                .word DM$FN + 216       ; Перерисовка обеих панелей (выход в режим работы с панелями
                                        ; оболочки)

M$F220TP:       .word 177747
                .byte 11, 12
                .word 177761
                .byte 6, 12
                .word 177770
                .byte 3, 12
                .word 177774
                .byte 4, 12
M$7220_end: ; конец функции M$7220
; ===========================================================================


; ===========================================================================
; 107225
; Просмотрщик файлов

M$7225:         .word DM$FN + 026       ; Контроль конца каталога (адрес записи в R5). Если (R5)=0, то
                                        ; происходит HALT-прерывание
                mov     F$CLUS(R5), @#416
                bne     3$
                halt

O$225PEP2:      tst     @#M$SAVESCR
                beq     2$
                mov     @#300, @#156
                mov     @#404, R3
                mov     @#406, R4
                call    sub_74360
2$:             .word DM$FN + 221       ; прорисовка панелей и строки меню
                .word DM$FN + 216       ; Перерисовка обеих панелей (выход в режим работы с панелями
                                        ; оболочки)
3$:             .word DM$FN + 207       ; Проверка совпадения FAT диска с FAT текущей панели. Необходимо
                                        ; для обнаружения подмены диска перед записью каталога.
                mov     #40000, R0
4$:             clr     (R0)+
                tst     R0
                bpl     4$
                .word DM$FN + 017       ; защита функции, после нажатия на клавишу СТОП, начнётся повторное
                                        ; выполнение защищённой функции
O$225PEP:       add     #O$225PEP2-O$225PEP, @#M$CURRESFUN
                mov     #M$EDITBUF, R1
5$:             clr     (R1)+
                cmp     R1, SP
                bne     5$
                mov     28.(R5), R1
                mov     30.(R5), R2
                mov     R1, @#470
                mov     R2, @#472
                mov     #5, R0
6$:             asr     R2
                ror     R1
                adc     R1
                adc     R2
                sob     R0, 6$
                mov     R1, @#410
                mov     PC, @#414
                mov     #42000, R1
                mov     SP, R4
                add     #14, @#177664
7$:             mov     #125252, -(R1)
                sob     R4, 7$
                mov     #40101, @#AS
                .word DM$PR + 237
                mov     #IMMAS, R0
                .word DM$FN + 030       ; Преобразование имени файла из формата каталога ANDOS (адрес
                                        ; записи в R5) в формат блока параметров EMT 36 (с точкой, разделяющей
                                        ; имя и расширение, и т.п.). Преобразованное имя записывается
                                        ; на адрес в R0
                mov     #14, R2
8$:             movb    (R3)+, R0
                .word DM$FN + 003       ; Вывод символа из R0 на экран
                cmpb    R0, #'.
                bne     9$
                movb    (R3), @#602
                movb    1(R3), @#603
9$:             sob     R2, 8$
                sub     #54126, @#602
                mov     #11, R2
                jsr     R1, sub_73564
                .asciz <234>"Find"
                .asciz "Juмp"
MV$STEP:        .asciz "Step"
MV$LINES:       .asciz "Lines"
MV$BLANK:       .asciz "Blank"
                .asciz "IniSt"
                .asciz "Print"<234>
                .asciz "%%"<237>"        "
                .even

loc_73556:      movb    (R1)+, R0
                .word DM$FN + 003       ; Вывод символа из R0 на экран
                bne     loc_73556
sub_73564:      inc     @#AS
                sob     R2, loc_73556
                clr     @#634

jmp_73576:      clr     R3
                clr     R4
loc_73602:      clrb    @#636
jmp_73606:      tst     @#630
                bmi     27$
                clr     @#630
                .word DM$PR + 014
                mov     #30, R5
jmp_73626:      mov     @#634, (SP)
jmp_73632:      mov     @#646, @#304
6$:             clr     @#640
7$:             cmp     R4, @#472
                bne     8$
                cmp     R3, @#470
                beq     18$
8$:             call    sub_75300
                mov     (SP), R1
                bmi     26$
                add     #1, R3
                adc     R4
                cmp     @#137004, #240
                bne     9$
                call    @#137006
                br      23$
                br      26$
                br      7$

9$:             dec     R1
                bmi     11$
                bne     10$
                dec     R1
10$:            mov     R1, (SP)
                br      12$

11$:            tstb    R0
                beq     26$
                cmpb    R0, #12
                beq     26$
12$:            tst     R5
                bmi     6$
                bit     #140, R0
                bne     21$
                tst     (SP)
                bne     20$
                mov     @#602, R1
                tstb    R0
                bmi     19$
                cmpb    R0, #11
                bne     13$
                mov     @#AS, R1
                mov     R1, R0
                bic     #7, R0
                add     #10, R0
                sub     R1, R0
                br      17$

13$:            blo     14$
                tst     R1
                beq     6$
14$:            movb    @#640, R1
                ble     16$
15$:            asl     R0
                asl     R0
                asl     R0
                sob     R1, 15$
16$:            incb    @#640
17$:            movb    R0, @#641
                mov     #40, R0
                call    sub_75532
                br      23$
                br      7$
18$:            br      36$

19$:            tst     R1
                beq     20$
                bic     #177600, R0
                swab    R0
                add     R0, @#640
                br      7$

20$:            mov     #40, R0
21$:            call    sub_75532
23$:            br      jmp_74456
                br      6$

22$:            .word DM$PR + 012
25$:            br      jmp_73626

26$:            tst     @#630
27$:            bne     31$
                movb    @#636, R2
                beq     32$
                .word DM$FN + 006       ; Перевод строки для печатающего устройства
                cmpb    @#PRZKB, #3
28$:            beq     loc_73602
                tstb    R2
                bmi     29$
                decb    @#636
                beq     28$
29$:            call    sub_75414
                cmp     R4, @#622
                bne     22$
                cmp     R3, @#620
                beq     28$

30$:            inc     R5
                bne     22$
                cmpb    @#BUFKL, #31
                bne     22$
                br      50$

31$:            mov     #630, R0
                mov     #440, (R0)+
                dec     (R0)
                bgt     25$
                mov     #36, (R0)
                call    sub_75414
                br      25$

32$:            tst     R5
                bmi     30$
                beq     33$
                sob     R5, 22$

33$:            cmpb    @#BUFKL, #14
                bne     34$
                mov     R3, @#620
                mov     R4, @#622
34$:            tst     (SP)
                bne     35$
                sub     #1, R3
                sbc     R4
35$:            tstb    @#636
                bne     40$
36$:            tst     @#630
                bne     54$
                clrb    @#636
                call    sub_75414
                bit     #100, @#177716
                beq     39$
; ───────────────────────────────────────────────────────────────────────────
sub_74360:      .word DM$FN + 066       ; остановка двигателя дисковода и сброс кода клавиши
                .word DM$FN + 131       ; Очистка флага сохранения содержимого экрана под окном
                                        ; Очистка признака записи кода в буфер
38$:            tstb    @#PRZKB
                beq     38$
39$:            mov     R3, @#404
                mov     R4, @#406
                call    @#101122        ; получение кода из буфера клавиатуры
40$:            emt     26              ; получение координат курсора: R1 = X, R2 = Y;
                mov     R2, R5
                inc     R5
                bit     #100, R0
                beq     41$
                bic     #240, R0
41$:            .word DM$FN + 016       ; Переход по ветвлению
                br      sub_74360

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 033       ; стрелка вниз
loc_74434:      sub     #31, R5
                mov     @#634, (SP)
                neg     (SP)
                jmp     jmp_73632

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 032       ; стрелка вверх
                .word DM$PR + 022       ; Исходная установка курсора
jmp_74456:      inc     R5
44$:            mov     @#634, (SP)
45$:            tst     R4
                bne     46$
                tst     R3
                beq     49$
46$:            sub     #1, R3
                sbc     R4
                tst     (SP)
                beq     47$
                dec     (SP)
                bne     45$
                sob     R5, 44$
                br      49$

47$:            call    sub_75300
                beq     48$
                cmp     #12, R0
                bne     45$
48$:            sob     R5, 45$
                add     #1, R3
                adc     R4
49$:            cmpb    @#BUFKL, #32    ; стрелка вверх
                beq     51$
50$:            jmp     jmp_73606

51$:            dec     R5
                bgt     sub_74360
                bne     52$
                tst     @#634
                bne     53$
52$:            inc     R5
                .word DM$PR + 32        ; стрелка вверх
53$:            jmp     jmp_73626

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 230       ; АР2/стрелка влево
                mov     #646, R0
                tst     (R0)
                beq     sub_74360
                sub     @#HSTEP, (R0)
                bpl     56$
                clr     (R0)
                br      56$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 231       ; АР2/стрелка вправо
                add     @#HSTEP, @#646
                br      56$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 232       ; АР2/стрелка вверх
54$:            jmp     jmp_73576

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 233       ; АР2/стрелка вниз
                mov     @#ADR, R1
                mov     28.(R1), R3
                mov     30.(R1), R4
                clr     R5
55$:            add     #27, R5
                br      jmp_74456

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 010       ; стрелка влево
                br      55$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 031       ; стрелка вправо
                br      loc_74434

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 014       ; СБР
56$:            br      44$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 011       ; ТАБ
                mov     #100, R0
                xor     R0, @#634
                br      44$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 'P
                .word DM$FN + 074       ; Инициализация принтера (ПУ). Если принтер отключён -  выводит
                                        ; соответствующий текст
                movb    @#NLIN, @#636
                bne     56$
                decb    @#636
                br      56$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 'F
                mov     #440, R1
                mov     #M$EDITBUF, R4
57$:            movb    (R1)+, (R4)+
                bne     57$
                .word DM$FN + 065       ; Строчный редактор
                .byte 204
                .asciz "FIND"
                .even
                .word DM$FN + 113       ; Поиск конца строки и отсечение мусора в буфере.
                                        ; Вход: R3 - начало буфера
                .word DM$FN + 072       ; Фрагмент, сохранённый подпрограммой RAMKA, из памяти на экран
                .word DM$FN + 131       ; Очистка флага сохранения содержимого экрана под окном
                                        ; Очистка признака записи кода в буфер
                mov     #440, R1
58$:            movb    (R3)+, (R1)+
                bne     58$
                mov     @#404, R3
                mov     @#406, R4
                com     @#630
                dec     R5
                ble     50$
                br      56$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 'B
                .word DM$FN + 104       ; Десятичный двузначный ввод в (R3)
                                        ; за командой - word адрес строки подсказки, адрес значения
                .word OVERLAYADDR + MV$BLANK-M$7225
                .word OTSTUP
                br      64$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 'L
                .word DM$FN + 104       ; Десятичный двузначный ввод в (R3)
                                        ; за командой - word адрес строки подсказки, адрес значения
                .word OVERLAYADDR + MV$LINES-M$7225
                .word NLIN
                br      64$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 'S
                .word DM$FN + 104       ; Десятичный двузначный ввод в (R3)
                                        ; за командой - word адрес строки подсказки, адрес значения
                .word OVERLAYADDR + MV$STEP-M$7225
                .word HSTEP
                br      64$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 'I
                mov     #ILLP, R5
                mov     R5, -(SP)
                mov     #M$EDITBUF, R1
                movb    (R5)+, R2
                beq     61$

59$:            movb    (R5)+, (R1)
                bitb    (R1), #140
                bne     60$
                bisb    #240, (R1)
60$:            inc     R1
                sob     R2, 59$

61$:            clrb    (R1)
                .word DM$FN + 065
                .byte 203
                .asciz "String"
                .even
                .word DM$FN + 113       ; Поиск конца строки и отсечение мусора в буфере.
                                        ; Вход: R3 - начало буфера
                mov     (SP)+, R5
                sub     R3, R2
                movb    R2, (R5)+
                beq     70$

62$:            movb    (R3)+, (R5)
                cmpb    (R5), #300
                bge     63$
                bicb    #240, (R5)
63$:            inc     R5
                sob     R2, 62$
                .word DM$FN + 074       ; Инициализация принтера (ПУ). Если принтер отключён -  выводит
                                        ; соответствующий текст
64$:            br      70$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 'J
                .word DM$PR + 014       ; СБР
65$:            call    sub_75414
66$:            .word DM$FN + 002       ; Приём символа с клавиатуры в R0
                .word DM$FN + 016       ; Переход по ветвлению
                br      66$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 012       ; Ввод
                clr     R5
                jmp     jmp_74456

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 010       ; Стрелка влево
67$:            sub     @#410, R3
                sbc     R4
                bpl     65$
68$:            add     @#410, R3
                adc     R4
                cmp     R4, @#472
                bne     69$
                cmp     R3, @#470
69$:            blos    65$
                br      67$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 031       ; Стрелка вправо
                br      68$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 003       ; КТ
70$:            halt


; ───────────────────────────────────────────────────────────────────────────

sub_75300:      mov     R3, R1
                clrb    R1
                bisb    R4, R1
                swab    R1
                asr     R1
                asr     R1
                asr     R1
                cmp     R1, @#414
                beq     4$
                mov     R1, @#414
                mov     @#416, R0
                .word DM$FN + 054       ; Проверка DOS (если ANDOS, то =0)
                beq     2$
                asl     R1
                asl     R1
                add     R1, R0
                br      3$

1$:             call    @#K$GETFAT
2$:             dec     R1
                bpl     1$
3$:             mov     #ClusterSize, R1
                mov     #30000, R2
                mov     R3, -(SP)
                mov     R0, R3
                .word DM$FN + 036       ; Кластерная операция: R3 - номер кластера, R1 - длина, R2 -
                                        ; адрес (после операции к R2 прибавляется абсолютная величина R1)
                mov     (SP)+, R3
4$:             mov     R3, R2
                bic     #174000, R2
                movb    30000(R2), R0
                return

; ███████████████ S U B R O U T I N E ███████████████████████████████████████


sub_75414:      mov     R3, -(SP)
                mov     R4, -(SP)
                mov     R3, -(SP)
                mov     R4, R1
                mov     #40, R2
                mov     @#204, R5
                add     #37267, R5
                mov     #1400, R0
                br      5$

1$:             mov     #10, R3
                mov     R5, R4

2$:             sub     #100, R4
                bis     #40000, R4
                tst     R1
                bpl     3$
                bic     R0, (R4)
                br      4$

3$:             bis     R0, (R4)
4$:             sob     R3, 2$

5$:             sub     @#410, (SP)
                sbc     R1
                asl     R0
                rol     R0
                bcc     6$
                rol     R0
                tst     (R5)+
6$:             sob     R2, 1$
                tst     (SP)+
                mov     (SP)+, R4
                mov     (SP)+, R3
                return
; End of function sub_75414

; ───────────────────────────────────────────────────────────────────────────

sub_75532:      mov     @#630, R1
                beq     4$
                movb    (R1)+, R2
                beq     2$
                bic     #240, R0
                bic     #240, R2
                cmpb    R2, R0
                beq     1$
                mov     #440, @#630
                br      8$

1$:             tstb    (R1)
                bne     3$
2$:             clr     R5
                return

3$:             mov     R1, @#630
                br      8$

4$:             mov     @#304, R1
                tstb    @#636
                beq     6$
                cmp     R1, @#646
                bne     5$
                mov     R0, -(SP)
                .word DM$FN + 102       ; Генерация отступа при печати
                mov     (SP)+, R0
5$:             .word DM$FN + 075       ; Печать содержимого R0 на ПУ
6$:             dec     @#304
                bpl     8$
                add     #77, R1
                bge     7$
                inc     R1
                bne     9$
                dec     @#AS
                .word DM$FN + 024       ; Включение/отключение курсора
                br      8$

7$:             iot
8$:             decb    @#641
                bgt     sub_75532
9$:             add     #2, (SP)
                return
M$7225_end: ; конец функции M$7225
; ===========================================================================


; ===========================================================================
;107226
; Menu

M$7226:         movb    @#XB, R1
                add     #41577, R1
                mov     #16, R2
                mov     #35, R3
                .word DM$FN + 071       ; Сохранение фрагмента экрана в память подпрограммой RAMKA
                mov     #2, R0
                sub     R0, R2

1$:             mov     #36, R3
2$:             movb    -100(R1), (R1)+
                sob     R3, 2$
                add     #42, R1
                sob     R0, 1$

3$:             mov     #36, R3
                bisb    #340, (R1)+
4$:             movb    #-1, (R1)+
                sob     R3, 4$
                add     #41, R1
                sob     R2, 3$
                sub     #1275, R1
                mov     R1, @#AS
                mov     R1, word_76516
                .word DM$FN + 004
                .asciz <234>"Coммand    Disk    Setup"<234>
                .even
                clr     R4
loc_76054:      call    sub_76510
                mov     #OVERLAYADDR + MO$226TP-M$7226, R2
                movb    byte_126526(R4), R3
                mov     R4, R0
                asl     R0
                add     R0, PC
                br      8$
                br      6$
                .word DM$FN + 064       ; Вывод текста в рамке
                .byte 23, 2, 36, 11
                .ascii "Color"<12>
                .ascii "Save"<12>
                .asciz <12><12><12>
                .even
                .word DM$FN + 050       ; Вертикальное меню (аналогично GOR)
                .asciz "CS"
                .even
                mov     #10, R1
                br      9$

6$:             cmp     @#116740, #240  ; DSKINI из VDISK
                beq     7$
                clrb    byte_76222
7$:             .word DM$FN + 064       ; Вывод текста в рамке
                .byte 13, 2, 50, 11
                .ascii "Backup"<12>
                .ascii "Restore"<12>
                .asciz "Init"<12><12><12>
                .even
                .word DM$FN + 050       ; Вертикальное меню (аналогично GOR)
                .ascii "BR"
byte_76222:     .byte 'I, 0
                .even
                mov     #5, R1
                br      9$

8$:             .word DM$FN + 064       ; Вывод текста в рамке
                .byte 1, 2, 74, 11
                .ascii "Coмpare"<12>
                .ascii "Naмe Sort"<12>
                .ascii "Ext. Sort"<12>
                .ascii "Date Sort"<12>
                .asciz "Press Dir"<12>
                .even
                .word DM$FN + 050       ; Вертикальное меню (аналогично GOR)
                .asciz "CNEDP"
                .even
                clr     R1

9$:             movb    R3, byte_126526(R4)
                add     R1, R3
                .word DM$FN + 016
                asl     R3
                mov     OVERLAYADDR + MM$JMPTBL-M$7226(R3), PC

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 010       ; стрелка влево
                call    sub_76510
                tst     R4
                beq     11$
                dec     R4
10$:            .word DM$FN + 072       ; Фрагмент, сохранённый подпрограммой RAMKA, из памяти на экран
                br      loc_76054

11$:            mov     #2, R4
                br      10$

12$:            clr     R4
                br      10$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 031       ; стрелка вправо
                call    sub_76510
                cmp     R4, #2
                beq     12$
                inc     R4
                br      10$

; ───────────────────────────────────────────────────────────────────────────
MM$JMPTBL:      .word OVERLAYADDR + MM$Compare-M$7226   ;Coмpare
                .word OVERLAYADDR + MM$NameSort-M$7226  ;Naмe Sort
                .word OVERLAYADDR + MM$ExtSort-M$7226   ;Ext. Sort
                .word OVERLAYADDR + MM$DateSort-M$7226  ;Date Sort
                .word OVERLAYADDR + MM$PressDir-M$7226  ;Press Dir

                .word OVERLAYADDR + MM$T00Backup-M$7226 ;Backup
                .word OVERLAYADDR + MM$T00Restore-M$7226 ;Restore
                .word 116740  ; DSKINI из VDISK         ;Init

                .word OVERLAYADDR + MM$Color-M$7226     ;Color
                .word OVERLAYADDR + MM$SaveCnf-M$7226   ;Save
; блок параметров вертикального меню
MO$226TP:       .word 171600
                .byte 11, 12
                .word 173000
                .byte 11, 12
                .word 174200
                .byte 11, 12
                .word 175400
                .byte 11, 12
                .word 176600
                .byte 11, 12
; блок параметров горизонтального меню
MO$226TP2:      .word 177777
                .byte 11, 13
                .word 12
                .byte 7, 13
                .word 22
                .byte 7, 13
; ───────────────────────────────────────────────────────────────────────────

sub_76510:      mov     #OVERLAYADDR + MO$226TP2-M$7226, R2
                mov     (PC)+, @(PC)+
word_76516:     .word 0
                .word AS
                mov     R4, R3
                .word DM$FN + 035       ; Высветить/погасить курсор меню
                return
; ───────────────────────────────────────────────────────────────────────────

sub_76530:      mov     #3100, R0
                mov     #50000, R4
                mov     #DRV$A+5, R1
                cmpb    @#DAB, #2
                bhi     word_77076
                blo     1$
                add     #6, R1
1$:             movb    (R1), R1
                bmi     2$
                asr     R0
                asr     R4
2$:             aslb    R1
                bpl     3$
                bis     #1002, @#DRVTAB+D$FLGTAB
                asr     R0
MM$RestDRV$:
3$:             return

; ───────────────────────────────────────────────────────────────────────────
MM$T00Backup:   .word DM$FN + 131       ; Очистка флага сохранения содержимого экрана под окном
                                        ; Очистка признака записи кода в буфер
                .word DM$FN + 027       ; Контроль MicroDOS (если MicroDOS, то HALT)
                .word DM$FN + 073       ; Меню YES/NO, если "YES", то программа продолжается, иначе -
                                        ; прерывание по HALT
                .byte 5
                .asciz "Backup"
                .even
                .word DM$FN + 207       ; Проверка совпадения FAT диска с FAT текущей панели. Необходимо
                                        ; для обнаружения подмены диска перед записью каталога.
                call    sub_76530
                mov     R4, -(SP)
                asr     R0
                asr     R0
                dec     R0
                mov     R0, R5
                mov     #3, R2
                mov     R2, R3
1$:             mov     R5, R0
                call    @#K$GETFAT
                tst     R0
                beq     2$
                cmp     R0, #7760
                bne     4$
2$:             inc     R5
                sob     R2, 1$

3$:             dec     R5
                mov     R5, R0
                mov     #7760, R1
                call    @#K$SETFAT
                sob     R3, 3$
                call    @#K$WRFAT
                .word DM$FN + 041       ; Копирование FAT из буфера ANDOS по адресу AFAT
                clr     R0
                call    @#K$RDBLOK
                mov     (SP)+, @#DRVTAB+D$SIDE
                call    sub_77220
                call    sub_76530
                call    @#K$WRBLOK
                inc     R0
                mov     @#AFAT, R2
                mov     #-4400, R1
                .word DM$FN + 010       ; Вызов ANDOS-овской подпрограммы RWBLOK
                .word DM$FN + 212       ; Инициализация диска и чтение каталога для активной панели и
                                        ; переход в режим работы с панелью. Можно использовать как
                                        ; выход в оболочку
4$:             .word DM$FN + 122       ; установка вектора 4 на обработку ошибочной ситуации
                jmp     @#M$EERR2

; ───────────────────────────────────────────────────────────────────────────
MM$T00Restore:  .word DM$FN + 131       ; Очистка флага сохранения содержимого экрана под окном
                                        ; Очистка признака записи кода в буфер
                .word DM$FN + 073       ; Меню YES/NO, если "YES", то программа продолжается, иначе -
                                        ; прерывание по HALT
                .byte 4
                .asciz "Restore "
                .even
                call    sub_76530
                call    @#K$RDBLOK
                inc     R0
                mov     @#AFAT, R2
                mov     #4400, R1
                .word DM$FN + 010       ; Вызов ANDOS-овской подпрограммы RWBLOK
                mov     #OVERLAYADDR + MM$RestDRV$-M$7226, @#DRIVER
                .word DM$FN + 077       ; Инициализация диска. Если не ANDOS, то устанавливается бит "С".
                .word DM$FN + 044       ; Сброс режима кеширования
                bcc     100$
                .word DM$FN + 064
                .byte 13, 11, 24, 12
                .asciz "Not saved!"
                .even
word_77076:     .word DM$FN + 076       ; останов двигателя дисковода, звуковой сигнал, пауза и СТОП
; ───────────────────────────────────────────────────────────────────────────

100$:           call    sub_76530
                call    @#K$RDBLOK
                .word DM$FN + 100       ; Дисковая операция, за кодом вызова идут: Сл.1 - номер блока
                                        ; (если <0, то блок берётся из R0, Сл.2 - длина, Сл.3 - адрес
                                        ; (если 0, то адрес берётся из R2). При дисковой ошибке
                                        ; устанавливается бит "С".
                .word 14, 4000, 30000
                clr     @#DRVTAB+D$SIDE
                call    sub_77172
                .word DM$FN + 100       ; Дисковая операция, за кодом вызова идут: Сл.1 - номер блока
                                        ; (если <0, то блок берётся из R0, Сл.2 - длина, Сл.3 - адрес
                                        ; (если 0, то адрес берётся из R2). При дисковой ошибке
                                        ; устанавливается бит "С".
                .word 14, -4000, 30000
                mov     @#ADR0, R2
                .word DM$FN + 100       ; Дисковая операция, за кодом вызова идут: Сл.1 - номер блока
                                        ; (если <0, то блок берётся из R0, Сл.2 - длина, Сл.3 - адрес
                                        ; (если 0, то адрес берётся из R2). При дисковой ошибке
                                        ; устанавливается бит "С".
                .word 5, -3400, 0
                clr     R0
                call    @#K$WRBLOK
                .word DM$FN + 040       ; Копирование FAT с адреса AFAT в буфер ANDOS
                call    @#K$WRFAT
                .word DM$FN + 212       ; Инициализация диска и чтение каталога для активной панели и
                                        ; переход в режим работы с панелью. Можно использовать как
                                        ; выход в оболочку

; ███████████████ S U B R O U T I N E ███████████████████████████████████████


sub_77172:      call    sub_77220
                movb    @#DAB, R0
                bitb    #2, DRVTAB+D$FLGTAB-1(R0)
                beq     1$
                inc     R3
1$:             incb    32(R3)

sub_77220:      mov     #DRVTAB, R3
                jmp     @#160012
; End of function sub_77220
; End of function sub_77172

; ───────────────────────────────────────────────────────────────────────────
MM$Compare:     clr     -(SP)
7$:             mov     @#ADR0, -(SP)
                .word DM$FN + 014       ; Смена активной панели
                .word DM$FN + 021       ; Блокировка прерывания по клавише СТОП
                .word DM$FN + 020       ; R1=ADR0-40
1$:             add     #32., R1
                .word DM$FN + 015       ; Проверка совпадения имени файла (подкаталога)
                                        ; (адрес записи в R1) и фильтра.
                                        ; Если имя не соответствует фильтру, то устанавливается
                                        ; бит "C", если обнаружен признак конца каталога ((R1)=0), то бит "Z"
                bcs     1$
                beq     6$
                mov     (SP), R5

2$:             mov     R1, R4
                tstb    (R5)
                beq     5$
                mov     #13, R0
                mov     R5, R3
                add     #32., R5
                cmp     24.(R1), 24.(R3)
                bne     2$
                cmp     28.(R1), 28.(R3)
                bne     2$
3$:             cmpb    (R4)+, (R3)+
                bne     2$
                sob     R0, 3$
4$:             br      1$

5$:             tstb    F$DIRN(R1)
                bne     4$
                comb    F$MARK(R1)
                br      4$

6$:             tst     (SP)+
                com     (SP)
                bmi     7$
                .word DM$FN + 103       ; UNFILD всех запомненных фрагментов экрана
                .word DM$FN + 216       ; Перерисовка обеих панелей (выход в режим работы с панелями
                                        ; оболочки)

; ───────────────────────────────────────────────────────────────────────────
MM$PressDir:    .word DM$FN + 027       ; Контроль MicroDOS (если MicroDOS, то HALT)
                mov     #345, -(SP)
                mov     @#ADR0, R5
                br      0Dir$

; ───────────────────────────────────────────────────────────────────────────
MM$DateSort:    mov     #-400, -(SP)
                br      0Sort$

; ───────────────────────────────────────────────────────────────────────────
MM$ExtSort:     mov     #10, -(SP)
                br      0Sort$

; ───────────────────────────────────────────────────────────────────────────
MM$NameSort:    clr     -(SP)
0Sort$:         mov     @#ADR, R5
0Dir$:          .word DM$FN + 021       ; Блокировка прерывания по клавише СТОП
                cmp     R5, @#ADR0
                bhis    2$
1$:             add     #32., R5
                mov     #44, R0
                .word DM$FN + 013       ; Вход: R0 - мл.байт - длительность звука, она же и частота
2$:             mov     R5, R4
                tstb    (R5)
                beq     13$
3$:             add     #32., R4
                tstb    (R4)
                beq     1$
                mov     R5, R3
                mov     R4, R1
                mov     (SP), R0
                bpl     4$
                cmp     24.(R3), 24.(R1)
                bhi     11$
                br      3$

4$:             tstb    R0
                bpl     5$
                cmpb    (R3), R0
                beq     11$
                br      3$

5$:             movb    F$DIRN(R5), R2
                tstb    F$DIRN(R4)
                bne     6$
                tstb    R2
                beq     7$
                br      3$

6$:             tstb    R2
                beq     11$
7$:             tst     R0
                bne     8$
                mov     #16, R2
                br      9$

8$:             add     R0, R1
                add     R0, R3
                mov     #3, R2
9$:             movb    (R1)+, -(SP)
                bicb    #240, (SP)
                movb    (R3)+, -(SP)
                bicb    #240, (SP)
                cmpb    (SP)+, (SP)+
                bhi     11$
                bne     3$
                dec     R2
                bmi     10$
                bne     9$
                mov     R5, R3
                mov     R4, R1
                inc     R0
10$:            sob     R0, 9$

11$:            mov     R5, R3
                mov     R4, R1
                mov     #20, R0
12$:            mov     (R3), R2
                mov     (R1), (R3)+
                mov     R2, (R1)+
                sob     R0, 12$
                br      3$

13$:            .word DM$FN + 103       ; UNFILD всех запомненных фрагментов экрана
                tstb    (SP)+
                bpl     14$
                .word DM$FN + 070       ; Запись текущего каталога на диск и перерисовка панелей
14$:            .word DM$FN + 204       ; Переход в режим работы с панелью. Можно использовать как
                                        ; выход в оболочку

; ───────────────────────────────────────────────────────────────────────────
MM$Color:       mov     #125, R0
                xor     R0, @#COLORB
                .word DM$FN + 103       ; UNFILD всех запомненных фрагментов экрана
                .word DM$FN + 227       ; прорисовка текста в рамках панелей и строки меню
                .word DM$FN + 216       ; Перерисовка обеих панелей (выход в режим работы с панелями
                                        ; оболочки)

; ───────────────────────────────────────────────────────────────────────────
MM$SaveCnf:     .word DM$FN + 073       ; Меню YES/NO, если "YES", то программа продолжается, иначе -
                                        ; прерывание по HALT
                .byte 6
                .asciz "Save"
                .even
                .word DM$FN + 207       ; Проверка совпадения FAT диска с FAT текущей панели. Необходимо
                                        ; для обнаружения подмены диска перед записью каталога.
                mov     #42, R0
                call    @#K$RDBLOK
                mov     #DiskMaster, R1
                mov     #2, R2
1$:             cmp     -1000(R1), (R1)+
                beq     2$
                .word DM$FN + 122       ; установка вектора 4 на обработку ошибочной ситуации
                jmp     @#M$EERR1

2$:             sob     R2, 1$
                clrb    @#byte_126530
3$:             mov     (R1)+, -1002(R1)
                cmp     R1, #F$PARAM
                bne     3$
                call    @#K$WRBLOK
                halt
M$7226_end: ; конец функции M$7226
; ===========================================================================

                .blkb   14

                .END
