;
; ╔═════════════════════════════════════════════════════════════════════════╗
; ║     This file is generated by The Interactive Disassembler (IDA)        ║
; ║     Copyright (c) 2006 by DataRescue sa/nv, <ida@datarescue.com>        ║
; ║ Licensed to: Ded Pihto                                                  ║
; ╚═════════════════════════════════════════════════════════════════════════╝
;
; ───────────────────────────────────────────────────────────────────────────
; Оболочка Disk Master II
;   Резидентная неоверлейная часть
; А так же:
;   Модуль файлера
;   Модуль эмулятора МикроДос
;   Модуль драйвера принтера
;   Пользовательский модуль (опция)

; Processor:        K1801VM1
; Target assembler: BK Turbo8 Cross Assembler

; ═══════════════════════════════════════════════════════════════════════════
DM$KC       = 4000      ; сигнатура цепочки переходов функции 16
DM$PR       = 70000     ; сигнатура вывода символа на экран
DM$FN       = 107000    ; сигнатура функции


M$CURSOR    = 57        ; признак гашения курсора оболочки
M$CURRESFUN = 226       ; адрес текущей выполняемой функции оболочки
M$CUROVLFUN = 230       ; текущий номер оверлейной функции, которая загружена в буфер
M$ARPTDELAY = 232       ; значение задержки после первого кода и остальных при автоповторе
M$OVLFUNMR  = 236       ; номер оверлейной функции, которая загружена в буфер
M$FILTADDR  = 242       ; адрес буфера фильтра
;300
M$BUFSPCL   = 310       ; буфер стека в кластерной операции
;500-514?

;адреса 126000..126477 используются под внутренние переменные
;модулями и оболочкой
F$DIRNME    = 126000    ;14 байтов
F$FILTR     = 126014    ;13 байтов

F$TopStack  = 126124    ;126030..126122 stack area
M$VectBuff  = 126124    ;126124..126153 область, где сохраняются
                        ;вектора и некоторые переменные
F$AFILER    = 126162    ;2 байта
F$PFILER    = 126164    ;6 байтов:
                        ; byte число столбцов * число текстовых строк
                        ; byte число текстовых строк
                        ; byte ширина окна файлера
                        ; byte высота окна файлера
                        ; word смещение от начала экрана

F$SPBUF     = 126172    ;2 байта
INKDELAY    = 126174
F$COUNT     = 126176
; АКТИВНАЯ ПАНЕЛЬ
FILT        = 126370    ; буфер фильтра оболочки
NFIL        = 126404    ; количество помеченных файлов
NCL         = 126406    ; количество занимаемых кластеров помеченных файлов
TDA         = 126410    ; таблица параметров привода
FRECL       = 126412    ; свободно кластеров
ADR0        = 126414    ; базовый адрес начала каталога
ADR1        = 126416    ; адрес начала каталога (с учётом "..")
ITEGB       = 126420    ; индикатор режима вывода помеченных файлов
ITTB        = 126421    ; индикатор текущий (0 - режим неактивен)
IMDOS       = 126422    ; индикатор DOS (0 - ANDOS, иначе - MicroDOS)
byte_126423 = 126423
; ПАССИВНАЯ ПАНЕЛЬ
FILTP       = 126424
NFILP       = 126440
NCLP        = 126442
TDAP        = 126444
FRECLP      = 126446
ADR0P       = 126450
ADR1P       = 126452
ITEGBP      = 126454
ITTBP       = 126455
IMDOSP      = 126456
byte_126457 = 126457
M$SAVESCR   = 126460    ; флаг сохранения содержимого экрана под окном
                        ; ещё там хранится адрес текущей записи о файле
M$DRIVER    = 126462

.la 126500

; ───────────────────────────────────────────────────────────────────────────
;Адреса 126500-136777  занимает  резидентный модуль оболочки Disk
;MASTER,  и входящие в него файлер, эмулятор MicroDOS и драйвер
;принтера.

; запуск оболочки откуда-то
DiskMaster:     emt     14
                br      0master$
; ───────────────────────────────────────────────────────────────────────────
COLORB:         .byte 0                 ; режим оцветнения (0 - чёрно-белый)
PRIB:           .byte 3                 ; номер драйвера принтера
ILLP:           .byte 0                 ; инициализирующая строка (1-й байт - длина строки),
                .byte 33, 122, 65       ; выводимая на принтер подпрограммой ANDOS INIPRN (120314)
                .blkb 12                ; буфер под строку инициализации
NLIN:           .byte 0                 ; количество строк для печати из режима VIEW
OTSTUP:         .byte 6                 ; левый отступ при печати
byte_126526:    .byte 1
                .byte 0
byte_126530:    .byte 0
TSS:            .byte 'E                ; имя третьего привода меню выбора приводов
HSTEP:          .byte 20                ; шаг горизонтального скроллинга во VIEW
                .byte 0
FILDPTR:        .word 40000             ; Указатель на буфер, куда сохраняется содержимое экрана под окнами
OVLEXECA:       .word OVERLAYADDR       ; адрес адреса загрузки оверлеев
M$ContinueOp:   .byte 0                 ; флаг продолжения операции копирования/переноса
                                        ; при ошибке и перезапуске оболочки
M$CpMvOperation: .byte 0                ; код операции при копировании/перемещении

; АКТИВНАЯ ПАНЕЛЬ
DAB:            .byte 1                 ; устройство активной панели
DIRB:           .byte 0                 ; номер текущего подкаталога активной панели
AFAT:           .word 1000              ; адрес FAT активной панели
ADR:            .word 4740              ; текущий адрес в активной панели
Y:              .word 1                 ; текущая вертикальная координата указателя в активной панели
CWO:            .word 0                 ; контрольное слово (=@ADR) активной панели
ILIB:           .byte 0                 ; индикатор режима прозрачности (0 - реж.откл.)
XB:             .byte 1                 ; горизонтальное координата панели (1 или 41)
DATEB:          .byte 0                 ; режим "ДАТА/ДЛИНА" (0 - "ДЛИНА")
                .even
; ПАССИВНАЯ ПАНЕЛЬ
DAPB:           .byte 5                 ; устройство пассивной панели
DIRPB:          .byte 0                 ; номер текущего подкаталога пассивной панели
AFATP:          .word 12040             ; адрес FAT пассивной панели
ADRP:           .word 0                 ; текущий адрес в пассивной панели
YP:             .word 1                 ; текущая вертикальная координата указателя в пассивной панели
CWOP:           .word 0                 ; контрольное слово (=@ADR)
ILIPB:          .byte 0                 ; индикатор режима прозрачности (0 - реж.откл.)
XPB:            .byte 41                ; горизонтальное координата панели (1 или 41)
DATEBP:         .byte 0                 ; режим "ДАТА/ДЛИНА" (0 - "ДЛИНА")
                .even

; параметры файлера для узкого экрана
F$PARAM:        .byte 15.               ; число столбцов * число текстовых строк
                .byte 3                 ; число текстовых строк
                .byte 76                ; ширина окна файлера (байт)
                .byte 37                ; высота окна файлера (байт)
                .word 2000              ; смещение от начала экрана
; ───────────────────────────────────────────────────────────────────────────

NOFILER:        clr     @#FILER         ; Признак включения/адрес файлера
; ───────────────────────────────────────────────────────────────────────────
; 107105
; отключение признака оболочки и запуск оболочки
NOMASTER:       clr     @#MASTER
; ===========================================================================

.script  ; подсчёт КС оболочки
    mov #M$CHKBGN, R5
    mov R5, R4
    sub #M$CHKEND, R4
    asr R4
    clr R0
1$: add (R5)+, R0
    sob R4, 1$
    mov R0, ModuleCS
.ends

; Точка входа в оболочку MASTER
M$ENTRY:        emt     130             ; сигнатура
0master$:       mov     #1000, SP
                mov     #/M$CHKEND-/M$CHKBGN, R4 ; проверяем целостность. столько слов
                mov     #M$CHKBGN, R5   ; с этого адреса
                clr     R0
1$:             add     (R5)+, R0
                sob     R4, 1$
                cmp     (PC)+, R0
ModuleCS:       .word   105655          ; такая КС
                bne     NOFILER
                mov     #10000, R0
                mov     @#CONFIG, R5    ; Конфигурация ЭВМ (60000 - БК11(М), 140000 - БК10+16,
                                        ; 140002 - БК10+8, 140001 - БК10+4)
                bmi     2$
                mov     #56000, @#177716 ; БК11 - подключим стр.7
2$:             add     (R5)+, R4       ; и продолжим проверку КС
                sob     R0, 2$
                asl     R5              ; ещё раз проверим БК10/БК11
                bne     3$
                mov     #16000, @#177716 ; БК11 - вернём стр.5
3$:             cmp     (PC)+, R4       ; и такая КС !!! не совпадёт из-за того, что код изменён.
OVLModCS:       .word   107356          ; надо написать патчер, чтоб КС поправлял.
; И я выхода пока не вижу. данные в другом модуле, а результат здесь.
; А компилируются они раздельно.
                bne     NOMASTER

M$CHKBGN:       call    @#InitMaster
                mov     #M$V60, @#60
                mov     #M$V274, @#274
                tstb    @#M$ContinueOp  ; продолжить незавершённую операцию?
                beq     4$              ; нет
                .word DM$FN + 224       ; да - продолжаем то, что не закончили
4$:             .word DM$FN + 201       ; инициализация панелей оболочки, их перерисовка и
                                        ; выход в режим работы с панелями оболочки

;таблица инициализации векторов и переменных
M$INITBL:       .word M$V4,     4       ;<значение>, <ячейка, куда его поместить>
                .word M$V20,    20
                .word M$V10,    10
                .word 40,       12
                .word M$SCREEN, SCREEN
                .word FILT,     M$FILTADDR
                .word M$ENTRY,  MASTER  ; Признак включения/адрес оболочки
                .word 40000,    AS
                .word 377,      PRGAHK  ; Признак гашения курсора
                .word M$KEYTRP, 60      ; Адрес символа
                .word M$KEYTRP, 274
                .word 0,        PRPODC  ; Признак подчёркивания символа

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

InitMaster:     mov     #M$VectBuff, R2 ; буфер, куда сохраняется старое содержимое ячеек
                mov     #M$INITBL, R1   ; таблица пар word содержимое, ячейка

1$:             mov     (R1)+, R0       ; берём содержимое
                mov     (R1)+, R3       ; берём адрес ячейки
                mov     (R3), (R2)+     ; сохраняем старое содержимое в буфере
                mov     R0, (R3)        ; записываем новое содержимое
                bne     1$
                return
; End of function InitMaster

; ───────────────────────────────────────────────────────────────────────────

M$V60:          jsr     R4, @#PUSH4
                mov     R5, -(SP)
                mov     #14, R2         ; длительность звука
                call    @#102056        ; звук и приём кода
                cmpb    R0, #17         ; ЛАТ ?
                bne     1$
                clrb    @#PRRUS         ; латинские буквы
                br      M$VKBDEX

1$:             cmpb    R0, #16         ; РУС ?
                bne     M$VKBDEX
                movb    #200, @#PRRUS   ; русские буквы
M$VKBDEX:       mov     #14000, @#M$ARPTDELAY   ; задаём задержку первого символа в автоповторе
                .word DM$FN + 130       ; Очистка признака записи кода в буфер
                jmp     @#101304        ; обработка кодов в мониторе БК10
; ───────────────────────────────────────────────────────────────────────────

M$V274:         jsr     R4, @#PUSH4
                mov     R5, -(SP)
                mov     #14, R2         ; длительность звука
                call    @#102056        ; звук и приём кода
                cmp     R0, #'0
                blo     2$
                cmp     R0, #'9
                bhi     3$
                sub     #'0, R0         ; если '0..'9 -> 200..211
1$:             bisb    #200, R0
                br      M$VKBDEX

                ; коды 0..57
2$:             cmpb    R0, #11
                bhi     1$              ; если 12..57 -> 212..257
                beq     M$VKBDEX        ; код 11 оставляем как есть
                bisb    #20, R0         ; если 0..10 -> 20..30
                br      1$

                ; коды 72..177
3$:             bicb    #100, R0        ; 100..177 -> 0..77
                bisb    #40, R0         ; 0..37 -> 40..77
                br      1$

; 107034
; Звуковой сигнал
M$SIGNAL:       mov     #377, R0

; 107013 Звук
; Вход: R0 - мл.байт - длительность звука, она же и частота
M$7013:         mov     (SP)+, (SP)
; перехват вывода сообщений об ошибках.
; каждый код символа - длительность звука
F$SCREEN:       jsr     R4, @#PUSH4
                clr     R2
                bisb    R0, R2          ; длительность звука БИП
                asr     R2
                mov     R2, R3          ; частота звука
                call    @#102062        ; звук БИП
                jmp     @#POP4R
; End of function M$7013


; Перехватчик сообщений андос оболочкой
M$SCREEN:       cmpb    R0, #12         ; если перевод строки
                beq     2$              ; то ничего не делать
                bhi     1$              ; если коды 13..377, то вывод их на экран
                mov     #74702, @#AS
                tstb    @#177665
                bne     1$
                .word DM$FN + 045       ; закрашиваем место под сообщение
1$:             .word DM$FN + 003       ; Вывод символа из R0 на экран
2$:             return
; End of function M$SCREEN

; ───────────────────────────────────────────────────────────────────────────

M$FATALE:       mov     #100000, @#4
                call    @100006         ; EMT 6
                halt
; ───────────────────────────────────────────────────────────────────────────
; отмена пометки файлов при ошибке копирования/перемещения/удаления

M$TT4ErrHndl:   .word DM$FN + 052       ; Отмена блокировки СТОП
                .word DM$FN + 020       ; R1=ADR0-40
1$:             .word DM$FN + 011       ; Поиск помеченного файла начиная с адреса в  R1
                beq     M$TT4Handler    ; Обработка кнопки СТОП в оболочке
                clrb    F$MARK(R1)
                br      1$


; Обработка кнопки СТОП в оболочке

M$TT4Handler:   mov     #1000, SP
                .word DM$FN + 103       ; UNFILD всех запомненных фрагментов экрана
                mov     @#M$CUROVLFUN, R0 ; текущий номер оверлейной функции, которая загружена в буфер
                .word DM$FN + 120       ; Вызов оверлейной функции
                                        ; Вход: R0 - номер кода функции * 2
                clr     @#USRERR        ; Отменяем перехват сообщений
                mov     #12704, @#M$MorphV20
                jmp     @M$CURRESFUN    ; адрес текущей выполняемой функции оболочки
; End of function M$TT4Handler

; ───────────────────────────────────────────────────────────────────────────

M$V10:          mov     R0, -(SP)
                mov     2(SP), R0
                mov     -(R0), R0       ; код команды
                bmi     2$              ; если <0 - то это системный запрос
                                        ; если >0 - то это вывод символа из R0 на экран
                .word DM$FN + 003       ; Вывод символа из R0 на экран
1$:             mov     (SP)+, R0
                rti

2$:             bic     #177400, R0     ; очищаем старший байт
                aslb    R0
                bcc     3$              ; запросы 0..177
                mov     @#M$OVLFUNMR, -(SP)    ; запросы 200..377 - оверлейные
                                        ; они загружаются из оверлейной части оболочки
                                        ; начиная с адреса 23200
                ; копируем из оверлея функцию
                .word DM$FN + 120       ; Вызов оверлейной функции
                                        ; Вход: R0 - номер кода функции * 2
                mov     2(SP), R0       ; восстанавливаем значение R0
                call    @OVLEXECA       ; выполняем оверлейную функцию
                mov     R0, 2(SP)       ; изменённый R0 сохраним в стеке, чтобы не потерять
                mov     (SP)+, R0       ; значение ячейки M$OVLFUNMR
                ; восстанавливаем предыдущую оверлейную функцию
                .word DM$FN + 120       ; Вызов оверлейной функции
                                        ; Вход: R0 - номер кода функции * 2
                br      1$

3$:             add     PC, R0          ; запрос может начинаться с номера 2
                add     (R0), R0        ; всего 2..133
                rts     R0
; ───────────────────────────────────────────────────────────────────────────
                .word M$INPUT-.         ; 107002
                                        ; Приём символа с клавиатуры в R0
                .word M$SYMB-.          ; 107003
                                        ; Вывод символа из R0 на экран
                .word M$LINE-.          ; 107004
                                        ; Вывод текста на экран, текст в виде ASCII должен располагаться за кодом вызова,
                                        ; признак конца - 0-байт, если количество символов нечётное, или 0-слово, если чётное
                .word M$7005-.          ; 107005
                                        ; вывод строки символов инверсно
                                        ; первый байт строки - смещение от текущей позиции курсора
                .word M$LF-.            ; 107006
                                        ; Перевод строки для печатающего устройства
                .word M$TYP10-.         ; 107007
                                        ; Десятичный вывод содержимого R2, (R2<1000.)
                .word M$DISK-.          ; 107010
                                        ; Вызов ANDOS-овской подпрограммы RWBLOK
                .word M$FMET-.          ; 107011
                                        ; Поиск помеченного файла начиная с адреса в R1. Если файл найден,
                                        ; то адрес его записи в каталоге помещается в R1,
                                        ; если нет, то устанавливается бит Z (=0)
                .word M$7012-.          ; 107012
                                        ; Расчёт адреса вывода рамки и получение размеров
                                        ; За командой 4 байта: X, Y, n, m
                                        ; Выход: R1 - адрес экрана по координатам XY
                                        ; R2 - n
                                        ; R3 - m
                .word M$7013-.          ; 107013 Звук
                                        ; Вход: R0 - мл.байт - длительность звука, она же и частота
                .word M$SPA-.           ; 107014
                                        ; Смена активной панели
                .word M$FIL-.           ; 107015
                                        ; Проверка совпадения имени файла (подкаталога)
                                        ; (адрес записи в R1) и фильтра.
                                        ; Если имя не соответствует фильтру, то устанавливается
                                        ; бит "C", если обнаружен признак конца каталога ((R1)=0), то бит "Z"
                .word M$7016-.          ; 107016
                                        ; Переход по ветвлению
                                        ; За командой параметры: цепочка п/п, начало 4000+код_кл. конец цепочки - слово 0
                                        ; Вход: R0 - код клавиши
                .word M$7017-.          ; 107017
                                        ; защита функции, после нажатия на клавишу СТОП, начнётся повторное
                                        ; выполнение защищённой функции
                .word M$SR1-.           ; 107020
                                        ; R1=ADR0-40
                .word M$BLS-.           ; 107021
                                        ; Блокировка прерывания по клавише СТОП
                .word M$MARK-.          ; 107022
                                        ; Инверсия указателя текущего файла (в R2 должна  находиться
                                        ; вертикальная координата - содержимое ячейки Y)
                .word M$MARK1-.         ; 107023
                                        ; Гашение указателя текущего файла (в R2 должна  находиться
                                        ; вертикальная координата - содержимое ячейки Y)
                .word M$CUR-.           ; 107024
                                        ; Включение/отключение курсора
                .word M$INPC-.          ; 107025
                                        ; Ввод с клавиатуры в R0 с включением курсора и гашением после ввода
                .word M$EOF-.           ; 107026
                                        ; Контроль конца каталога (адрес записи в R5). Если (R5)=0, то
                                        ; происходит HALT-прерывание
                .word M$CMDOS-.         ; 107027
                                        ; Контроль MicroDOS (если MicroDOS, то HALT)
                .word M$NAMER-.         ; 107030
                                        ; Преобразование имени файла из формата каталога ANDOS (адрес
                                        ; записи в R5) в формат блока параметров EMT 36 (с точкой, разделяющей
                                        ; имя и расширение, и т.п.). Преобразованное имя записывается
                                        ; на адрес в R0
                .word M$DIR-.           ; 107031
                                        ; Поиск подкаталога с номером, находящемся в DIRB, адрес записи
                                        ; помещается в R1. Если таковой не найден, то R1=0
                .word M$DIR0-.          ; 107032
                                        ; Поиск подкаталога с номером, находящемся в R0, адрес записи
                                        ; помещается в R1. Если таковой не найден, то R1=0
                .word M$FIMDI-.         ; 107033
                                        ; Поиск помеченного подкаталога начиная с адреса в R1. Если подкаталог
                                        ; найден, то адрес его записи в каталоге помещается в R1, если
                                        ; нет, то устанавливается бит Z (=0)
                .word M$SIGNAL-.        ; 107034
                                        ; Звуковой сигнал
                .word M$MCUR-.          ; 107035
                                        ; Высветить/погасить курсор меню
                                        ; Вход: R3 - индекс в таблице.
                                        ; R2 - адрес таблицы, формат:
                                        ; слово - смещение относительно базового адреса
                                        ; байт  - длина маркера (символов)
                                        ; байт  - высота маркера (точек)
                .word M$DICL-.          ; 107036
                                        ; Кластерная операция: R3 - номер кластера, R1 - длина, R2 -
                                        ; адрес (после операции к R2 прибавляется абсолютная величина R1)
                .word M$FREE-.          ; 107037
                                        ; Расчёт количества свободных кластеров (результат в R2)
                .word M$MFAT-.          ; 107040
                                        ; Копирование FAT с адреса AFAT в буфер ANDOS
                .word M$FATM-.          ; 107041
                                        ; Копирование FAT из буфера ANDOS по адресу AFAT
                .word M$CMPD-.          ; 107042
                                        ; Сравнение приводов панелей (если =0, значит приводы одинаковые)
                .word M$AES-.           ; 107043
                                        ; Установка режима кеширования по чтению/записи каталога и FAT
                                        ; (соответствующие блоки будут обрабатываться не на диске, а
                                        ; в каталоге оболочки)
                .word M$AER-.           ; 107044
                                        ; Сброс режима кеширования
                .word M$7045-.          ; 107045
                                        ; закрашиваем место под вывод сообщений в обработчике ошибок Оболочки
                .word M$7046-.          ; 107046
                                        ; R1=ADR0P-40
                .word M$GOR-.           ; 107047
                                        ; Горизонтальное меню. За кодом вызова располагаются несколько
                                        ; байтов, содержащих буквенные символы, по которым будут вызываться
                                        ; пункты меню (их количество  определяет  число  пунктов),
                                        ; признак конца - 0. В ячейке 160 - базовый адрес  экрана, R2 -
                                        ; адрес таблицы параметров, R3 - номер текущего пункта меню. Таблица
                                        ; параметров имеет следующую структуру (для каждого пункта):
                                        ; слово - смещение относительно базового адреса
                                        ; байт  - длина маркера (символов)
                                        ; байт  - высота маркера (точек)
                                        ; Подпрограмма помещает в R3 номер выбранного пункта меню.
                .word M$VERT-.          ; 107050
                                        ; Вертикальное меню (аналогично GOR)
                .word M$7051-.          ; 107051
                                        ; Установка привода активной панели текущим
                                        ; Вывод имени привода на экран
                .word M$UNBLS-.         ; 107052
                                        ; Отмена блокировки СТОП
                .word M$DELETE-.        ; 107053
                                        ; Удаление файла/каталога
                                        ; Вход: R1 - адрес записи о файле/каталоге
                .word M$DOS-.           ; 107054
                                        ; Проверка DOS (если ANDOS, то =0)
                .word M$7055-.          ; 107055
                                        ; создание новой директории
                                        ; Вход: R1 - начало каталога. с учётом первой записи ..
                                        ;       R2 - буфер имени директории
                .word M$7056-.          ; 107056
                                        ; прорисовка тела рамки
                                        ; Вход: R1 - адрес экрана
                                        ;       R2 - число строк
                                        ;       R3 - ширина
                                        ; За командой параметры 4 байта
                                        ; byte число строк, фон, левый бордюр, правый бордюр
                                        ; если число строк 0, то значение берётся из R2
                .word M$7057-.          ; 107057
                                        ; элемент горизонтального бордюра рамки
                .word M$7060-.          ; 107060
                                        ; элемент горизонтального бордюра рамки
                .word M$7061-.          ; 107061
                                        ; элемент горизонтального бордюра рамки
                .word M$7062-.          ; 107062
                                        ; прорисовка верхнего бордюра рамки
                .word M$7063-.          ; 107063
                                        ; прорисовка нижнего бордюра рамки
                .word M$RAMKA-.         ; 107064
                                        ; Вывод текста в рамке. За кодом вызова идут 4 байта параметров
                                        ; рамки:
                                        ; B1 - горизонтальная координата левого верхнего угла (X0),
                                        ; B2 - вертикальная координата (координаты по стандарту EMT 24),
                                        ; B3 - высота рамки (точек),
                                        ; В4 - длина (символов). Затем идёт текст (аналогично LINE).
                                        ; Текст может быть разбит кодами "12" на отдельные строки, каждая
                                        ; строка будет иметь горизонтальное смещение X0. Фрагмент экрана
                                        ; под рамкой сохраняется в специальном буфере, если FLAG не равен
                                        ; "0".
                .word M$EDIT-.          ; 107065
                                        ; Строчный редактор. За кодом вызова идёт байт, равный 300+х,
                                        ; где х - левый отступ для текста, выводимого в рамке  редактора,
                                        ; затем сам текст (аналогично LINE). Редактируемая строка  должна
                                        ; начинаться с адреса 500 и состоять   не   более   чем   из   12
                                        ; (десятично) символов (признак конца - 0).
                .word M$7066-.          ; 107066
                                        ; остановка двигателя дисковода и сброс кода клавиши
                .word M$7067-.          ; 107067
                                        ; поиск в каталоге директории с именем из буфера имени текущего массива
                                        ; в блоке параметров магнитофона
                                        ; Вход: R1 - начало каталога
                                        ; Выход: R0 - номер найденной директории
                                        ;       Z - конец каталога, ничего не найдено
                .word M$ENDER-.         ; 107070
                                        ; Запись текущего каталога на диск и перерисовка панелей
                .word M$FILD-.          ; 107071
                                        ; Сохранение фрагмента экрана в память подпрограммой RAMKA
                .word M$UNFILD-.        ; 107072
                                        ; Фрагмент, сохранённый подпрограммой RAMKA, из памяти на экран
                .word M$YN-.            ; 107073
                                        ; Меню YES/NO, если "YES", то программа продолжается, иначе -
                                        ; прерывание по HALT
                .word M$IPR-.           ; 107074
                                        ; Инициализация принтера (ПУ). Если принтер отключён -  выводит
                                        ; соответствующий текст
                .word M$PRINT-.         ; 107075
                                        ; Печать содержимого R0 на ПУ
                .word M$7076-.          ; 107076
                                        ; останов двигателя дисковода, звуковой сигнал, пауза и СТОП
                .word M$INIT1-.         ; 107077
                                        ; Инициализация диска. Если не ANDOS, то устанавливается бит "С".
                .word M$DISK1-.         ; 107100
                                        ; Дисковая операция, за кодом вызова идут: Сл.1 - номер блока
                                        ; (если <0, то блок берётся из R0, Сл.2 - длина, Сл.3 - адрес
                                        ; (если 0, то адрес берётся из R2). При дисковой ошибке
                                        ; устанавливается бит "С".
                .word M$7101-.          ; 107101
                                        ; Очень похоже на запуск файла
                .word M$OTS-.           ; 107102
                                        ; Генерация отступа при печати
                .word M$UFILD-.         ; 107103
                                        ; UNFILD всех запомненных фрагментов экрана
                .word M$ASC2-.          ; 107104
                                        ; Десятичный двузначный ввод в (R3)
                .word NOMASTER-.        ; 107105
                                        ; отключение признака оболочки и запуск оболочки
                .word M$7106-.          ; 107106
                                        ; что-то с проверкой нового кода в буфере клавиатуры
                .word M$7107-.          ; 107107
                                        ; повторное получение кода, если клавиша нажата
                .word M$7110-.          ; 107110
                                        ; получение параметров окна файлёра
                .word M$OTSL-.          ; 107111
                                        ; Отступ с переводом строки печатающего уст-ва
                .word M$7112-.          ; 107112
                                        ; Вывод имени привода на экран
                                        ; Вход: R0 - номер привода
                .word M$7113-.          ; 107113
                                        ; Поиск конца строки и отсечение мусора в буфере.
                                        ; Вход: R3 - начало буфера
                .word M$7114-.          ; 107114
                                        ; вертикально-горизонтальное меню.
                                        ; Вход: R0 == 0 - горизонтальное меню != 0 - вертикальное
                                        ; параметры описаны в 107047
                .word M$7115-.          ; 107115
                                        ; поиск в каталоге директории с заданным именем
                                        ; Вход: R1 - начало каталога
                                        ;       R4 - буфер имени директории
                                        ; Выход: R0 - номер найденной директории
                                        ;       Z - конец каталога, ничего не найдено
                .word M$DONAM-.         ; 107116
                                        ; ANDOS-овская подпрограмма DONAM
                .word M$FIFA-.          ; 107117
                                        ; ANDOS-овская подпрограмма DIRFI2
                .word M$7120-.          ; 107120
                                        ; Вызов оверлейной функции
                                        ; Вход: R0 - номер кода функции *2
                .word M$7121-.          ; 107121 - функция файлёра
                                        ; вывод элемента каталога на экран и повторное получение кода с клавиатуры
                .word M$7122-.          ; 107122
                                        ; установка вектора 4 на обработку ошибочной ситуации
                .word M$7123-.          ; 107123 - функция файлёра
                                        ; чтение блока каталога, в котором находится нужная запись файла
                .word M$7124-.          ; 107124 - функция файлёра
                                        ; чтение блока каталога, в котором находится нужная запись файла
                .word M$7125-.          ; 107125 - функция файлёра
                                        ; кажется определение его размеров окна
                .word M$7126-.          ; 107126 - функция файлёра
                                        ; вывод выделенного курсором элемента каталога на экран
                .word M$7127-.          ; 107127 - функция файлёра
                                        ; вывод элемента каталога на экран
                .word M$7130-.          ; 107130
                                        ; Очистка признака записи кода в буфер
                .word M$7131-.          ; 107131
                                        ; Очистка флага сохранения содержимого экрана под окном
                                        ; Очистка признака записи кода в буфер
                .word M$7132-.          ; 107132
                                        ; Обмен местами содержимого блоков A и P
                                        ; Вход: R1 - A
                                        ;       R2 - P
                                        ; предполагается, что блок P идёт непосредственно за блоком A
                .word M$7133-.          ; 107133
                                        ; Расчёт адреса вывода рамки и получение размеров
                                        ; Вход: R3 адрес блока из 4 байт: X, Y, n, m
                                        ; Выход: R1 - адрес экрана по координатам XY
                                        ; R2 - n
                                        ; R3 - m

; 107117
; ANDOS-овская подпрограмма DIRFI2
M$FIFA:         mov     (SP)+, (SP)
                jmp     @DIRFI2
; End of function M$FIFA


; 107116
; ANDOS-овская подпрограмма DONAM
M$DONAM:        mov     (SP)+, (SP)
                mov     #BPDMAG, R1
                jmp     @DONAME
; End of function M$DONAM


;107131
M$7131:         clr     @#M$SAVESCR     ; флаг сохранения содержимого экрана под окном
                br      M$7130
; 107066
; остановка двигателя дисковода и сброс кода клавиши
M$7066:         clr     @#177130
                clr     @#DRVTAB
; 107130
; Очистка признака записи кода в буфер
M$7130:         clrb    @#PRZKB         ; Признак записи кода в буфер
                rti
; End of function M$7130
; End of function M$7066
; End of function M$7131


; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; 107055
; создание новой директории
; Вход: R1 - начало каталога. с учётом первой записи ..
;       R2 - буфер имени директории
M$7055:         mov     (SP)+, (SP)
                mov     R1, R3          ; начало каталога
                mov     R1, R5
                add     #7000, R5       ; физический конец каталога

1$:             add     #F$RecLen, R3   ; переходим к следующей записи
                cmp     R5, R3          ; дошли до конца каталога?
                blo     14$             ; да - выход
                movb    (R3), R0        ; это пустая запись?
                beq     2$              ; да
                cmpb    R0, #345        ; это удалённый файл?
                bne     1$              ; нет, продолжаем поиск
                ;нашли пустую запись или удалённую
2$:             mov     R3, -(SP)       ; сохраним указатель на неё

                mov     #112., R0       ; в каталоге может поместиться только 112. записей
3$:             movb    R0, BUFFER(R0)  ; т.е. теоретически - 112 директорий
                sob     R0, 3$          ; вот их номера и формируем

4$:             mov     R1, R5          ; начало каталога
5$:             add     #F$RecLen, R1   ; переходим к следующей записи
                tstb    (R1)            ; нашли пустую запись?
                beq     6$              ; да
                movb    F$DIRN(R1), R3  ; нет, тогда это директория?
                beq     5$              ; нет, ищем дальше
                clrb    BUFFER(R3)      ; да - отметим, что такой номер уже занят
                br      4$

6$:             add     #F$RecLen, R5   ; вторая запись каталога, т.е. физически первая запись с диска
                mov     (SP)+, R1       ; достанем найденный указатель на пустую или удалённую запись
                cmp     R5, R1          ; они что?
                beq     10$             ; совпадают, т.е. диск пуст
                blo     8$              ; меньше, т.е. где-то в середине каталога
                ; больше, но такого не может быть по алгоритму
                sub     #F$RecLen, R5   ;
7$:             mov     F$RecLen(R1), (R1)+ ; сдвигаем каталог
                cmp     R1, R5
                bne     7$
                br      10$

8$:             tstb    (R1)            ; запись пустая?
                bne     9$              ; нет
                clr     F$RecLen(R1)    ; да - пустая будет следующая
9$:             mov     -(R1), F$RecLen(R1) ; раздвигаем каталог
                cmp     R1, R5
                bne     9$

10$:            mov     R1, R3
                mov     #13, R4
11$:            movb    (R2)+, (R3)+    ; копируем имя из буфера
                sob     R4, 11$
                movb    #10, (R3)+      ; формируем атрибут
                mov     #24, R4
12$:            clrb    (R3)+           ; всё остальное очищаем
                sob     R4, 12$
                mov     #BUFFER+1, R4   ; теперь возьмём
13$:            movb    (R4)+, R0       ; первый попавшийся свободный номер директории
                beq     13$
                movb    R0, F$DIRN(R1)  ; и задаём его.
14$:            return
; End of function M$7055


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

;107106
; что-то с проверкой нового кода в буфере клавиатуры

M$7106:         mov     (SP)+, (SP)
                tstb    @#PRZKB         ; новый код есть?
                beq     1$              ; да - выходим
                tst     (SP)+           ; нет - выходим ещё на уровень выше

1$:             bit     #4, (R4)
                return
; End of function M$7106

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107111
; Отступ с переводом строки печатающего уст-ва

M$OTSL:         .word DM$FN + 006       ; Перевод строки для печатающего устройства

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107102
; Генерация отступа при печати

M$OTS:          movb    @#OTSTUP, R2    ; левый отступ при печати
                ble     2$

1$:             mov     #40, R0
                .word DM$FN + 075       ; Печать содержимого R0 на ПУ
                sob     R2, 1$

2$:             rti
; End of function M$OTS
; End of function M$OTSL

; ───────────────────────────────────────────────────────────────────────────
;107101
; Очень похоже на запуск файла
M$7101:         .word DM$FN + 017       ; защита функции, после нажатия на клавишу СТОП, начнётся повторное
                                        ; выполнение защищённой функции
                mov     R2, -(SP)
                clrb    @#ILIB          ; индикатор режима прозрачности (0 - реж.откл.)
                clrb    @#ILIPB         ; индикатор режима прозрачности (0 - реж.откл.)
                clr     @#SCREEN        ; Ячейка перехвата вывода на экран сообщений
                                        ; ANDOS (Значение по умолчанию 0)
                tstb    @#BUFKL
                bpl     1$
                mov     #F$SCREEN, @#SCREEN ; Ячейка перехвата вывода на экран сообщений
                                        ; ANDOS (Значение по умолчанию 0)
1$:             mov     @#SCKLC, -(SP)  ; Счётчик ключа
                mov     @#TAKLC, -(SP)  ; Текущий адрес ключа
                emt     14
                mov     (SP)+, @#TAKLC
                mov     (SP)+, @#SCKLC
                mov     (SP)+, R2
                mov     #240, R3
                mov     R3, -(SP)       ; что-то хитрое
                mov     #13707, (R3)+
                mov     #BUFSTA, (R3)   ; Буфер стартового адреса
                mov     #M$FATALE, @(R3)+
                mov     @-(R3), 4
                jmp     @#100602        ; загрузка файла по EMT 36
; End of function M$7101

; 107100
; Дисковая операция, за кодом вызова идут:
; Сл.1 - номер блока (если <0, то блок берётся из R0),
; Сл.2 - длина,
; Сл.3 - адрес (если 0, то адрес берётся из R2).
; При дисковой ошибке устанавливается бит "С".

M$DISK1:        mov     (SP)+, R3       ; адрес возврата
                mov     (R3)+, R4       ; номер блока
                bmi     1$              ; если <0 - блок берётся из R0
                mov     R4, R0          ; иначе - из слова за командой

1$:             mov     (R3)+, R1       ; длина
                mov     (R3)+, R4       ; адрес
                beq     2$              ; если ==0 - адрес берётся из R2
                mov     R4, R2          ; иначе - из слова за командой

2$:             mov     R3, (SP)        ; корректируем адрес возврата
                mov     #DRVTAB, R3
                jmp     @DRIVER         ; Адрес входа "чтение/запись блока" драйвера НГМД
                                        ; (160004). Может использоваться для обслуживания
                                        ; нестандартных устройств, например виртуального диска)
; End of function M$DISK1

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107077
; Инициализация диска. Если не ANDOS, то устанавливается бит "С".

M$INIT1:        mov     (SP)+, (SP)
                jmp     @#M$INIDRV
; End of function M$INIT1


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107122
; установка вектора 4 на обработку ошибочной ситуации

M$7122:         mov     #M$HLT4$2, @#4
                rti
; End of function M$7122

; ───────────────────────────────────────────────────────────────────────────
M$HLT4$2:       .word DM$FN + 052       ; Отмена блокировки СТОП
                .word DM$FN + 076       ; остановка двигателя дисковода и сброс кода клавиши, звуковой сигнал, пауза и СТОП

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107067
; поиск в каталоге директории с именем из буфера имени текущего массива
; в блоке параметров магнитофона
; Вход: R1 - начало каталога
; Выход: R0 - номер найденной директории
;       Z - конец каталога, ничего не найдено
M$7067:         .word DM$FN + 020       ; R1=ADR0-40
                mov     #IMTMAS, R4     ; Имя текущего массива в блоке параметров магнитофона

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107115
; поиск в каталоге директории с заданным именем
; Вход: R1 - начало каталога
;       R4 - буфер имени директории
; Выход: R0 - номер найденной директории
;       Z - конец каталога, ничего не найдено

M$7115:         clr     R0
                cmp     (R4), #20040    ; имя есть?
                blos    3$              ; нет - и делать нечего

1$:             mov     R4, R2
                add     #F$RecLen, R1   ; переходим к следующей записи
                movb    (R1), R0        ; конец каталога?
                beq     3$              ; да - выход
                mov     #9., R0         ; будем сравнивать имя и первый символ расширения
                                        ; тут ошибка. должно быть 11.
                mov     R1, R3

2$:             cmpb    (R3)+, (R2)+    ; сравниваем
                bne     1$              ; не оно
                sob     R0, 2$
                movb    F$DIRN(R1), R0  ; нашли, это подкаталог?
                beq     1$              ; нет - ищем дальше

3$:             rti
; End of function M$7115
; End of function M$7067

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107065
; Строчный редактор. За кодом вызова идёт байт, равный 300+х,
; где х - левый отступ для текста, выводимого в рамке редактора,
; затем сам текст (аналогично LINE). Редактируемая строка должна
; начинаться с адреса 500 и состоять не более чем из 12
; (десятично) символов (признак конца - 0).

M$EDIT:         .word DM$FN + 012       ; Расчёт адреса вывода рамки и получение размеров
                .byte 11, 6, 36, 15     ; За командой 4 байта: X, Y, n, m
                                        ; Выход: R1 - адрес экрана по координатам XY
                                        ; R2 - n
                                        ; R3 - m
                .word DM$FN + 071       ; Сохранение фрагмента экрана в память подпрограммой RAMKA
                mov     #16, R2
                .word DM$FN + 062       ; прорисовка верхнего бордюра рамки
                .word DM$FN + 056       ; прорисовка тела рамки
                                        ; Вход: R1 - адрес экрана
                                        ;       R2 - число строк
                                        ;       R3 - ширина
                                        ; За командой параметры 4 байта
                                        ; byte число строк, фон, левый бордюр, правый бордюр
                                        ; если число строк 0, то значение берётся из R2
                .byte 14, 0, 163, 316

                mov     #4, R2
                .word DM$FN + 063       ; прорисовка нижнего бордюра рамки
                .word DM$FN + 005       ; вывод строки символов инверсно
                .word DM$FN + 230       ; Редактирование имени файла/директории
                rti
; End of function M$EDIT

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107113
; Поиск конца строки и отсечение мусора в буфере.
; Вход: R3 - начало буфера

M$7113:         mov     #514, R2        ; конец буфера
                call    @#K$RTRIM       ; Вход: R3 - начало строки
                                        ;       R2 - конец буфера строки+1
                                        ; Выход:R2 - указатель на последний символ в строке
                                        ;       Z - пустая строка
                beq     1$              ; строки нет?
                inc     R2              ; есть - указатель на конец строки

1$:             clrb    (R2)            ; и обозначим конец нулевым байтом
                rti
; End of function M$7113

; ───────────────────────────────────────────────────────────────────────────
; 107005
; вывод строки символов инверсно
; первый байт строки - смещение от текущей позиции курсора

M$7005:         .word DM$PR + 234       ; вывод кода 234 на экран
                                        ; переключение режима инверсии символов
                mov     4(SP), R4
                movb    (R4)+, R3       ; первый байт - смещение
                add     R3, @#AS
                bis     #40000, @#AS

1$:             movb    (R4)+, R0       ; затем строка символов
                .word DM$FN + 003       ; вывод символа на экран
                bne     1$
                inc     R4
                bic     #1, R4
                mov     R4, 4(SP)
                rti

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107053
; Удаление файла/каталога
; Вход: R1 - адрес записи о файле/каталоге

M$DELETE:       movb    #345, (R1)
                clr     F$MARK(R1)
                clr     F$DIRN(R1)      ; Признак подкаталога и одновременно его номер
                mov     F$CLUS(R1), R0  ; Номер начального кластера
                ble     2$
                mov     R1, -(SP)
                clr     R1              ; удаляем цепочку ФАТ

1$:             call    @SETFAT
                cmp     R0, #7777
                bne     1$
                mov     (SP)+, R1

2$:             rti
; End of function M$DELETE


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107012
; Расчёт адреса вывода рамки и получение размеров
; За командой 4 байта: X, Y, n, m
; Выход: R1 - адрес экрана по координатам XY
; R2 - n
; R3 - m

M$7012:         mov     (SP), R3
                add     #4, (SP)

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107133
; Расчёт адреса вывода рамки и получение размеров
; Вход: R3 адрес блока из 4 байт: X, Y, n, m
; Выход: R1 - адрес экрана по координатам XY
; R2 - n
; R3 - m

M$7133:         cmp     @#M$OVLFUNMR, #52   ; номер оверлейной функции 107225 ?
                bne     2$                  ; нет
                tst     @#M$SAVESCR         ; содержимое экрана под окном сохранять надо?
                bne     1$                  ; уже флаг выставлен, пропускаем
                mov     @#NOMSIM, @#300     ; Номер символа на экране -> @#300
                mov     PC, @#M$SAVESCR     ; отметим, что надо

1$:             mov     #20, R1         ; база
                br      3$

2$:             movb    @#XB, R1        ; горизонтальное координата панели (1 или 41)

3$:             movb    (R3)+, R2       ; берём X
                add     R2, R1          ; прибавляем к базе
                movb    (R3)+, R2       ; берём Y
                emt     24              ; установка курсора по координатам X = R1, Y = R2
                mov     @#AS, R1        ; Абсолютный адрес курсора в ОЗУ экрана
                sub     #1001, R1       ; получим верхний левый угол вывода рамки
                bis     #40000, R1
                movb    (R3)+, R2       ; размеры рамки
                movb    (R3), R3
                rti
; End of function M$7133
; End of function M$7012


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107056
; прорисовка тела рамки
; Вход: R1 - адрес экрана
;       R2 - число строк
;       R3 - ширина
; За командой параметры 4 байта
; byte число строк, фон, левый бордюр, правый бордюр
; если число строк 0, то значение берётся из R2

M$7056:         mov     R5, 2(SP)       ; сохраняем R5
                mov     (SP)+, R5       ; берём адрес возврата
                jsr     R4, @#PUSH4
                movb    (R5)+, R0       ; число строк
                beq     1$              ; если 0
                mov     R0, R2          ; то число строк берётся из R2

1$:             movb    (R5)+, R0       ; фон

2$:             movb    (R5), (R1)+     ; выведем левый бордюр
                mov     R3, R4

3$:             movb    R0, (R1)+       ; заполним фоном внутренность рамки
                sob     R4, 3$
                movb    1(R5), (R1)     ; выведем правый бордюр
                add     #77, R1         ; переходим на следующую строку
                sub     R3, R1
                bpl     4$
                sub     #40000, R1      ; корректируем выход за экран

4$:             sob     R2, 2$          ; и так всю высоту
                mov     R1, 2(SP)       ; текущее значение адреса экрана возвратим
                jsr     R4, @#POP4
                tst     (R5)+           ; двигаем адрес возврата
                rts     R5
; End of function M$7056

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107060
; элемент горизонтального бордюра рамки

M$7060:         .word DM$FN + 056       ; прорисовка тела рамки
                                        ; Вход: R1 - адрес экрана
                                        ;       R2 - число строк
                                        ;       R3 - ширина
                                        ; За командой параметры 4 байта
                                        ; byte число строк, фон, левый бордюр, правый бордюр
                                        ; если число строк 0, то значение берётся из R2
                .byte 1, 0, 3, 300
                rti
; End of function M$7060

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107062
; прорисовка верхнего бордюра рамки

M$7062:         .word DM$FN + 057       ; элемент горизонтального бордюра рамки
                .word DM$FN + 060       ; элемент горизонтального бордюра рамки

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107061
; элемент горизонтального бордюра рамки

M$7061:         .word DM$FN + 056       ; прорисовка тела рамки
                                        ; Вход: R1 - адрес экрана
                                        ;       R2 - число строк
                                        ;       R3 - ширина
                                        ; За командой параметры 4 байта
                                        ; byte число строк, фон, левый бордюр, правый бордюр
                                        ; если число строк 0, то значение берётся из R2
                .byte 0, 377, 363, 317
                rti
; End of function M$7061
; End of function M$7062

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107063
; прорисовка нижнего бордюра рамки

M$7063:         .word DM$FN + 061       ; элемент горизонтального бордюра рамки
                .word DM$FN + 060       ; элемент горизонтального бордюра рамки

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

;107057
; элемент горизонтального бордюра рамки

M$7057:         .word DM$FN + 056       ; прорисовка тела рамки
                                        ; Вход: R1 - адрес экрана
                                        ;       R2 - число строк
                                        ;       R3 - ширина
                                        ; За командой параметры 4 байта
                                        ; byte число строк, фон, левый бордюр, правый бордюр
                                        ; если число строк 0, то значение берётся из R2
                .byte 2, 377, 377, 377
                rti
; End of function M$7057
; End of function M$7063

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107120
; Вызов оверлейной функции
; Вход: R0 - номер кода функции * 2

M$7120:         jsr     R4, @#PUSH4
                asl     R0              ; код * 4
                mov     @#CONFIG, R2    ; Конфигурация ЭВМ (60000 - БК11(М), 140000 - БК10+16,
                                        ; 140002 - БК10+8, 140001 - БК10+4)
                bmi     1$
                mov     #56000, @#177716
1$:             add     R2, R0          ; адрес + код * 4
                mov     (R0)+, R4       ; размер кода функции
                mov     (R0), R2        ; смещение до кода функции
                add     R0, R2          ; адрес начала функции
                asr     R4              ; делаем размер в словах

                mov     @#OVLEXECA, R1

2$:             mov     (R2)+, (R1)+    ; пересылаем тело функции в буфер оверлея
                sob     R4, 2$
                tst     R2
                bmi     3$
                mov     #16000, @#177716

3$:             mov     (SP), @#M$OVLFUNMR ; код функции * 2 сохраним
                br      0pop$
; End of function M$7120

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107071
; Сохранение фрагмента экрана в память подпрограммой RAMKA

M$FILD:         jsr     R4, @#PUSH4
                mov     @#FILDPTR, R0   ; Указатель на буфер, куда сохраняется содержимое экрана под окнами
                tst     (R3)+           ; к ширине + 2
                add     #6, R2          ; к высоте + 6
                mov     R1, -(R0)       ; сохраним адрес экрана
                movb    R2, -(R0)       ; высоту в строках
                movb    R3, -(R0)       ; ширину в байтах

1$:             mov     R3, R4          ; сохраняем содержимое экрана

2$:             movb    (R1)+, -(R0)
                sob     R4, 2$
                add     #100, R1
                sub     R3, R1
                bpl     3$
                sub     #40000, R1

3$:             sob     R2, 1$
                bic     #1, R0          ; выравниваем адрес
                mov     @#FILDPTR, -(R0) ; сохраним указатель на начало массива данных
                mov     R0, @#FILDPTR   ; и сохраним текущий указатель

0pop$:          br      1pop$           ; восстановить R0-R4 и RTI
; End of function M$FILD

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107072
; Фрагмент, сохранённый подпрограммой RAMKA, из памяти на экран

M$UNFILD:       jsr     R4, @#PUSH4
                mov     @#FILDPTR, R0   ; Указатель на буфер, куда сохраняется содержимое экрана под окнами
                cmp     R0, #40000      ; перебор?
                bhis    1pop$           ; да - выход
                mov     (R0), R0        ; указатель на начало массива данных
                mov     R0, -(SP)       ; сохраним
                mov     -(R0), R1       ; достанем адрес экрана
                movb    -(R0), R2       ; высоту в строках
                movb    -(R0), R3       ; ширину в байтах

1$:             mov     R3, R4          ; восстанавливаем содержимое экрана

2$:             movb    -(R0), (R1)+
                sob     R4, 2$
                add     #100, R1
                sub     R3, R1
                bpl     3$
                sub     #40000, R1

3$:             sob     R2, 1$
                mov     (SP)+, @#FILDPTR ; и сохраним текущий указатель
                br      1pop$      ; восстановить R0-R4 и RTI
; End of function M$UNFILD

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

;107045
; закрашиваем место под вывод сообщений в обработчике ошибок Оболочки

M$7045:         jsr     R4, @#PUSH4
                mov     #75611, R1      ; адрес верхнего левого угла рамки
                mov     #75626, @#AS    ; адрес в рамке
                mov     #53, R3         ; ширина
                .word DM$FN + 056       ; прорисовка тела рамки
                                        ; Вход: R1 - адрес экрана
                                        ;       R2 - число строк
                                        ;       R3 - ширина
                                        ; За командой параметры 4 байта
                                        ; byte число строк, фон, левый бордюр, правый бордюр
                                        ; если число строк 0, то значение берётся из R2
                .byte 12, 377, 377, 377

1pop$:          jmp     @#POP4I         ; восстановить R0-R4 и RTI
; End of function M$7045

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107103
; UNFILD всех запомненных фрагментов экрана

M$UFILD:        .word DM$FN + 072       ; Фрагмент, сохранённый подпрограммой RAMKA, из памяти на экран
                cmp     @#FILDPTR, #40000 ; Пока есть что-то сохранённое
                bne     M$UFILD         ; восстанавливаем
                rti
; End of function M$UFILD

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; п/п "чтение/запись блока" оболочки

AESSUB:         cmp     R0, #14         ; номер блока - область данных?
                bhis    4$              ; тогда идём обычно обрабатывать
                swab    R0
                asl     R0              ; * 512.
                beq     4$              ; если загрузочный сектор, то идём обычно обрабатывать
                sub     #5000, R0       ; если область каталога
                bpl     1$              ; то идём обрабатывать
                add     #2000, R0       ; если вторая копия ФАТ
                beq     3$              ; то просто выход

1$:             add     @#ADR0P, R0     ; базовый адрес начала каталога пассивной панели
                asr     R1              ; длину в словах -> длину в двордах
                bpl     2$              ; если чтение - переход
                neg     R1              ; если запись - подготовимся
                mov     R2, R4          ; R0 <-> R2
                mov     R0, R2
                mov     R4, R0

2$:             mov     (R0)+, (R2)+    ; перемещаем куда надо
                mov     (R0)+, (R2)+
                sob     R1, 2$

3$:             clc
                return

4$:             jmp     @M$DRIVER
; End of function AESSUB


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107044
; Сброс режима кеширования

M$AER:          mov     @#M$DRIVER, @#DRIVER ; Адрес входа "чтение/запись блока" драйвера НГМД
                                        ; (160004). Может использоваться для обслуживания
                                        ; нестандартных устройств, например виртуального диска)
                rti
; End of function M$AER


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107043
; Установка режима кеширования по чтению/записи каталога и FAT
; (соответствующие блоки будут обрабатываться не на диске, а
; в каталоге оболочки)

M$AES:          mov     #AESSUB, @#DRIVER ; Адрес входа "чтение/запись блока" драйвера НГМД
                                        ; (160004). Может использоваться для обслуживания
                                        ; нестандартных устройств, например виртуального диска)
                rti
; End of function M$AES


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107041
; Копирование FAT из буфера ANDOS по адресу AFAT

M$FATM:         mov     @#AFAT, R4      ; адрес FAT активной панели
                mov     @#IOBUFF, R2    ; Адрес буфера ANDOS (125000)
                br      0MFAT$
; End of function M$FATM


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107040
; Копирование FAT с адреса AFAT в буфер ANDOS

M$MFAT:         mov     @#IOBUFF, R4    ; Адрес буфера ANDOS (125000)
                mov     @#AFAT, R2      ; адрес FAT активной панели

0MFAT$:         mov     #240, R3

2$:             mov     (R2)+, (R4)+
                mov     (R2)+, (R4)+
                sob     R3, 2$
                rti
; End of function M$MFAT


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107037
; Расчёт количества свободных кластеров (результат в R2)

M$FREE:         mov     @#SIZE, R4      ; Общее количество кластеров на диске. Определяется
                                        ; подпрограммой INIDRV после считывания таблицы
                                        ; параметров из загрузчика
                clr     R2
                mov     #2, R1          ; начинаем с начального кластера

1$:             mov     R1, R0
                call    @GETFAT         ; получим значение
                tst     R0              ; свободен ?
                bne     2$              ; нет
                inc     R2              ; подсчитаем свободный

2$:             inc     R1              ; переходим к следующему
                sob     R4, 1$
                mov     R2, @#FRECL     ; свободно кластеров активной панели
                rti
; End of function M$FREE


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107036
; Кластерная операция:
; R3 - номер кластера,
; R1 - длина в байтах,
; R2 - адрес (после операции к R2 прибавляется абсолютная величина R1)

M$DICL:         asr     R1              ; делаем длину в словах
                bmi     1$              ; если запись, переход
                adc     R1              ; если чтение, и байтов было нечётное кол-во, добавим ещё слово
1$:             jsr     R4, @#PUSH4
                mov     R5, -(SP)
                mov     R3, R0          ; номер кластера
                tst     R1              ; какая операция ?
                bmi     2$              ; запись - переход
                .word DM$FN + 054       ; чтение - проверим DOS (если ANDOS, то = 0)
                bne     3$              ; не андос
                ; запись на не андос или чтение с андос

2$:             inc     R0              ; преобразуем номер кластера в номер блока
                asl     R0
                asl     R0
                ; если чтение с не андос - значит в R0 уже был номер блока
3$:             mov     #DIKLERR, @#USRERR ; Ячейка перехвата сообщений об ошибках.
                mov     SP, @#M$BUFSPCL
                .word DM$FN + 010       ; Вызов ANDOS-овской подпрограммы RWBLOK
M$DICLEX$:      mov     @#M$BUFSPCL, SP
                clr     @#USRERR        ; Ячейка перехвата сообщений об ошибках.
                mov     (SP)+, R5
                jsr     R4, @#POP4
                asl     R1              ; длину в словах обратно в байты, если была нечётная
                                        ; то изначальное значение теряется
                bpl     4$              ; если было чтение - переход
                neg     R1              ; для записи - меняем знак

4$:             add     R1, R2          ; прибавляем к адресу длину
                rti
; End of function M$DICL

; ───────────────────────────────────────────────────────────────────────────
; перехват сообщений об ошибках в кластерной операции
DIKLERR:        .word DM$FN + 034       ; Звуковой сигнал
                cmp     @#M$OVLFUNMR, #52   ; номер оверлейной функции 107225 ?
                beq     M$DICLEX$       ; да - просто выход
                .word DM$FN + 045       ; закрашиваем место под меню
                .word DM$FN + 004       ; Вывод текста на экран
                .asciz "Error"
                .even

                movb    @#ERRFDD, R2
                .word DM$FN + 007       ; Десятичный вывод содержимого R2. ( R2<1000. )
                .word DM$FN + 004       ; Вывод текста на экран
                .asciz ": Retry"
                .even

                mov     #DKLERRMENU, R2 ; адрес таблицы параметров
                clr     R3              ; номер текущего пункта меню
                tst     4(SP)           ; какая была операция?
                bmi     1$              ; запись - переход
                .word DM$FN + 004       ; Вывод текста на экран для ошибки чтения
                .asciz " Skip"
                .even
                .word DM$FN + 047       ; Горизонтальное меню
                .asciz "RS"
                .even

                br      2$

1$:             .word DM$FN + 004       ; Вывод текста на экран для ошибки записи
                .asciz " Mark"
                .even
                .word DM$FN + 047       ; Горизонтальное меню
                .asciz "RM"
                .even

2$:             .word DM$FN + 045       ; стираем меню
                dec     R3              ; что выбрали?
                bpl     M$DICLEX$       ; второй пункт - уходим туда
                rts     R5              ; первый пункт - уходим по адресу в R5
; ───────────────────────────────────────────────────────────────────────────
DKLERRMENU:     .word 177766
                .byte 5, 12
                .word 177774
                .byte 4, 12

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107033
; Поиск помеченного подкаталога начиная с адреса в R1. Если подкаталог
; найден, то адрес его записи в каталоге помещается в R1, если
; нет, то устанавливается бит Z (=0)

M$FIMDI:        mov     (SP)+, (SP)
1$:             .word DM$FN + 011       ; Поиск помеченного файла начиная с адреса в  R1
                beq     2$
                movb    F$DIRN(R1), R0
                beq     1$
2$:             return
; End of function M$FIMDI


; 107011
; Поиск помеченного файла начиная с адреса в R1. Если файл найден, то адрес его записи
; в каталоге помещается в R1, если нет, то устанавливается бит Z (=0)

M$FMET:         mov     (SP)+, (SP)
1$:             add     #F$RecLen, R1
                cmpb    (R1), #345
                beq     1$
                tstb    (R1)
                beq     2$
                tstb    F$MARK(R1)
                beq     1$

2$:             return
; End of function M$FMET


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107042
; Сравнение приводов панелей (если =0, значит приводы одинаковые)

M$CMPD:         mov     (SP)+, (SP)
                cmpb    @#DAB, @#DAPB   ; устройство активной панели
                return
; End of function M$CMPD


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107031
; Поиск подкаталога с номером, находящемся в DIRB, адрес записи
; помещается в R1. Если таковой не найден, то R1=0

M$DIR:          movb    @#DIRB, R0      ; номер текущего подкаталога активной панели
                .word DM$FN + 020       ; R1=ADR0-40

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107032
; Поиск подкаталога с номером, находящемся в R0, адрес записи
; помещается в R1. Если таковой не найден, то R1=0

M$DIR0:         add     #F$RecLen, R1
                tstb    (R1)
                beq     1$
                cmpb    F$DIRN(R1), R0
                bne     M$DIR0
1$:             rti
; End of function M$DIR0
; End of function M$DIR


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107030
; Преобразование имени файла из формата каталога ANDOS (адрес
; записи в R5) в формат блока параметров EMT 36 (с точкой, разделяющей
; имя и расширение, и т.п.). Преобразованное имя записывается
; на адрес в R0

M$NAMER:        mov     R5, -(SP)
                mov     R0, R2
                mov     #10, R4

1$:             mov     #20040, (R0)+
                sob     R4, 1$

                mov     R2, R3
                tstb    (R5)            ; запись пустая?
                beq     3$              ; да - выход
                mov     #13, R4
                movb    F$DIRN(R5), R0  ; это каталог?
                bne     2$              ; да
                mov     #16, R4
                bisb    F$RES(R5), R0   ; что-то непонятное, мкдос чтоль?
                bne     2$
                mov     #10, R4

2$:             movb    (R5)+, (R2)+
                sob     R4, 2$
                ; ищем конец имени
                call    @#K$RTRIM       ; Вход: R3 - начало строки
                                        ;       R2 - конец буфера строки+1
                                        ; Выход:R2 - указатель на последний символ в строке
                                        ;       Z - пустая строка
                beq     3$              ; имени нет - выход
                inc     R2              ; нашли
                tst     R0              ; если каталог или не андос
                bne     3$              ; выход
                cmp     (R5), #20040    ; если расширения нет
                beq     3$              ; выход
                movb    #'., (R2)+      ; иначе добавим расширение
                movb    (R5)+, (R2)+
                movb    (R5)+, (R2)+
                movb    (R5)+, (R2)+

3$:             mov     (SP)+, R5
                rti
; End of function M$NAMER

; ───────────────────────────────────────────────────────────────────────────
; 107104
; Десятичный двузначный ввод в (R3)
; за командой - word адрес строки подсказки, адрес значения

M$ASC2:         .word DM$FN + 064       ; Вывод текста в рамке
                .byte 12, 7, 24, 13
                .asciz " "
                .even

                mov     (SP), R3        ; адрес возврата
                mov     (R3)+, R4       ; адрес строки подсказки
                mov     R3, (SP)        ; корректируем адрес возврата
                movb    @(R3)+, R3      ; достаём значение
                .word DM$PR + 234       ; вкл. инверсию символов

1$:             movb    (R4)+, R0       ; берём символ строки
                cmpb    R0, #40         ; если пробел или меньше
                blo     2$              ; то конец строки
                iot                     ; выводим на экран
                br      1$              ; и так всю строку

2$:             .word DM$PR + ':        ; выведем двоеточие
                .word DM$PR + 040       ; потом пробел
                .word DM$PR + 234       ; выкл. инверсию символов
                mov     #10., R5

3$:             mov     R3, R4          ; запомним значение
                mov     #'0 - 1, R0     ; получим мл.дес. разряд

4$:             inc     R0
                sub     R5, R3
                bpl     4$
                iot                     ; выведем
                add     #'9 + 1, R3     ; а это второй десятичный разряд
                mov     R3, R0
                iot                     ; и его выведем

5$:             .word DM$FN + 002       ; Приём символа с клавиатуры в R0
                .word DM$FN + 016       ; Переход по ветвлению
                ; тут обрабатываем коды, которых не нашлось в ветвлении
                sub     #'0, R0
                cmpb    R0, #9.         ; что нажали?
                bhi     5$              ; код вне интервала '0..'9 - игнорируем

6$:             sub     R5, R4
                bge     6$
                add     R5, R4          ; R4 = R4 % 10.
                beq     8$

7$:             add     R5, R0          ; R0 = R0 + R4 * 10.
                sob     R4, 7$

8$:             movb    R0, R3
                sub     #2, @#AS
                br      3$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 12        ; Ввод
                mov     (SP), R3        ; адрес значения
                movb    R4, @(R3)+      ; сохраняем новое значение
                add     (PC), (SP)      ; корректируем адрес возврата
                rti
; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 3         ; КТ
                halt                    ; СТОП

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107074
; Инициализация принтера (ПУ). Если принтер отключён -  выводит
; соответствующий текст

M$IPR:          mov     R5, -(SP)
                jsr     R5, @RUNNER
                .word INIPRN            ; Адрес подпрограммы инициализации принтера. Вызов:
                                        ; CALL @120312 .WORD 120314 . Бит C означает отсутствие
                                        ; драйвера принтера. Регистры не сохраняются
                mov     (SP)+, R5
                bcc     M$Ret2$
                .word DM$FN + 072       ; Фрагмент, сохранённый подпрограммой RAMKA, из памяти на экран
                .word DM$FN + 064       ; Вывод текста в рамке
                .byte 12, 7, 24, 13
                .asciz "Printer off"
                .even

; 107076
; останов двигателя дисковода, звуковой сигнал, пауза и СТОП

M$7076:         .word DM$FN + 066       ; остановка двигателя дисковода и сброс кода клавиши
                .word DM$FN + 034       ; Звуковой сигнал
                clr     R1
                sob     R1, .
                sob     R1, .
                halt
; End of function M$7076
; End of function M$IPR


; 107026
; Контроль конца каталога (адрес записи в R5). Если (R5)=0, то
; происходит HALT-прерывание

M$EOF:          tstb    (R5)
                beq     2Hlt$
                tstb    F$DIRN(R5)
                bmi     2Hlt$

M$Ret2$:        rti
; End of function M$EOF


; 107027
; Контроль MicroDOS (если MicroDOS, то HALT)

M$CMDOS:        .word DM$FN + 054       ; Проверка DOS (если ANDOS, то =0)
                beq     M$Ret2$

2Hlt$:          .word DM$FN + 034       ; Звуковой сигнал
M$Hlt2$:        halt
; End of function M$CMDOS

; 107054
; Проверка DOS (если ANDOS, то =0)

M$DOS:          mov     (SP)+, (SP)
                tstb    @#IMDOS         ; индикатор DOS активной панели (0 - ANDOS, иначе - MicroDOS)
                return
; End of function M$DOS

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107025
; Ввод с клавиатуры в R0 с включением курсора и гашением после ввода

M$INPC:         .word DM$FN + 024       ; Включение/отключение курсора
                .word DM$FN + 002       ; Приём символа с клавиатуры в R0

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107024
; Включение/отключение курсора

M$CUR:          jsr     R4, @#PUSH4
                mov     R5, -(SP)
                call    @#103230        ; вывод/гашение курсора
                jmp     @#101626        ; восстановить R0-R5
; End of function M$CUR
; End of function M$INPC

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107051
; Установка привода активной панели текущим
; Вывод имени привода на экран

M$7051:         movb    @#DAB, R0       ; устройство активной панели
                movb    R0, @#DEVICE    ; Текущее устройство (0-@:, 1-32 - A:-Z:)
                movb    R0, @#DEVTEK    ; Временное текущее устройство. Совпадает с DEVICE при
                                        ; запуске операции, изменяется при явном указании
                                        ; устройства в имени
                mov     @#TDA, @#DRVTAB+D$FLGTAB ; таблица параметров привода активной панели
; End of function M$7051


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107112
; Вывод имени привода на экран
; Вход: R0 - номер привода

M$7112:         decb    R0
                movb    R0, @#DRVTAB+D$UNIT
                add     #'A, R0
                iot
                .word DM$PR + ':
                rti
; End of function M$7112


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107052
; Отмена блокировки СТОП

M$UNBLS:        mov     #M$TT4Handler, @#4 ; Обработка кнопки СТОП в оболочке
                rti
; End of function M$UNBLS


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107021
; Блокировка прерывания по клавише СТОП

M$BLS:          mov     #M$V4, @#4
                rti
; End of function M$BLS


; ███████████████ S U B R O U T I N E ███████████████████████████████████████


M$V4:           sub     (PC), (SP)
                rti
; End of function M$V4


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107046
; R1=ADR0P-40

M$7046:         mov     @#ADR0P, R1     ; базовый адрес начала каталога пассивной панели
                br      0SR1$


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107020
; R1=ADR0-40

M$SR1:          mov     @#ADR0, R1      ; базовый адрес начала каталога активной панели
0SR1$:          sub     #F$RecLen, R1
                rti
; End of function M$SR1
; End of function M$7046

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107017
; защита функции, после нажатия на клавишу СТОП, начнётся повторное
; выполнение защищённой функции

M$7017:         .word DM$FN + 131       ; Очистка флага сохранения содержимого экрана под окном
                                        ; Очистка признака записи кода в буфер
                mov     #40000, @#FILDPTR ;Инициализируем  указатель на буфер, куда сохраняется содержимое экрана под окнами
                mov     (SP), R0        ; Достаём адрес возврата
                mov     #1000, SP       ; инициализируем стек
                .word DM$FN + 052       ; Отмена блокировки СТОП
                mov     R0, @#M$CURRESFUN ; сохраняем адрес возврата
                mov     @#M$OVLFUNMR, @#M$CUROVLFUN
                jmp     (R0)            ; и продолжаем выполнение за командой
; End of function M$7017

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107070
; Запись текущего каталога на диск и перерисовка панелей
M$ENDER:        .word DM$FN + 214       ; Запись каталога активной панели на диск
                .word DM$FN + 042       ; Сравнение приводов панелей (если =0, значит приводы одинаковые)
                bne     1$
                .word DM$FN + 217       ; Дублирование панелей (выход в режим работы с панелями оболочки)
1$:             .word DM$FN + 204       ; Переход в режим работы с панелью. Можно использовать как
                                        ; выход в оболочку
; End of function M$ENDER

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107010
; Вызов ANDOS-овской подпрограммы RWBLOK

M$DISK:         call    @RWBLOK
                rti
; End of function M$DISK

; ───────────────────────────────────────────────────────────────────────────
YNMNUTBL:       .word 177767
                .byte 5, 12
                .word 177775
                .byte 4, 12
; ───────────────────────────────────────────────────────────────────────────

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107073
; Меню YES/NO, если "YES", то программа продолжается, иначе -
; прерывание по HALT
M$YN:           .word DM$FN + 103       ; UNFILD всех запомненных фрагментов экрана
                .word DM$FN + 064       ; Вывод текста в рамке
                .byte 10, 7
                .byte 42, 20
                .asciz ""
                .even

                mov     @#AS, R2
                add     #1604, R2
                .word DM$FN + 005       ; вывод строки символов инверсно
                ;строка находится за командой вызова этой функции
                mov     R2, @#AS
                .word DM$FN + 004
                .asciz "Yes   No"<234>
                .even

                mov     #YNMNUTBL, R2
                clr     R3
                .word DM$FN + 047       ; Горизонтальное меню
                .asciz "YN"
                .even
                tst     R3
                bne     M$Hlt2$
                rti

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107126 - функция файлёра
; вывод выделенного курсором элемента каталога на экран

M$7126:         com     @#PRPODC        ; Признак подчёркивания и инверсии символа

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107127 - функция файлёра
; вывод элемента каталога на экран

M$7127:         .word DM$FN + 125
                bcs     M$Ret3$
                bne     2$
                mov     #12., R3        ; выведем 12 пробелов

1$:             .word DM$PR + 040
                sob     R3, 1$
                br      8$

2$:             tstb    F$DIRN(R1)      ; это директория?
                beq     3$              ; нет - переход
                .word DM$PR + 040       ; да - выведем пробел
                mov     #11., R3        ; и имя директории на экран
                br      7$

3$:             mov     #8., R3         ; выведем имя файла

4$:             movb    (R1)+, R0
                iot
                sob     R3, 4$
                cmp     (R1), #20040    ; расширение есть?
                beq     5$              ; нету
                .word DM$PR + '.        ; есть - выведем его через точку
                br      6$

5$:             .word DM$PR + 040       ; расширения нет - выведем пробелы вместо него

6$:             mov     #3, R3          ; и выводим три символа расширения или пробелы

7$:             movb    (R1)+, R0
                iot
                sob     R3, 7$

8$:             clr     @#PRPODC
                br      M$7123
; End of function M$7127


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107125 - функция файлёра
; кажется определение его размеров окна
; Вход: R2 - количество файлов в файлёре ?

M$7125:         mov     R2, -(SP)
                movb    @#F$PFILER+1, R0    ; кол-во текстовых строк файлёра
                mov     R2, R3
                mov     @#F$PFILER+4, R1    ; смещение от начала экрана файлёра
                bit     #77, R1             ; оно с левого края начинается?
                beq     1$                  ; да - переход
                inc     R1                  ; нет - +1

1$:             sub     R0, R2              ; вычтем кол-во текстовых строк от общего кол-ва файлов
                bmi     2$                  ; всё
                add     #15, R1             ; ширина столбца вроде бы
                br      1$

2$:             add     R0, R2              ; прибавим назад
                inc     R2                  ; получим остаток

3$:             add     #1200, R1           ; теперь спустимся вниз
                sob     R2, 3$              ; на количество остатка
                bis     #40000, R1
                mov     R1, @#AS            ;в общем, не понятно что делается, но получается правый нижний угол чтоли
                mov     (SP)+, R2

; End of function M$7125


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107123
; чтение блока каталога, в котором находится нужная запись файла
; Вход: R5 - номер записи каталога
; Выход: R1 - адрес записи в буфере

M$7123:         mov     R5, R1

; 107124
; Вход: R1 - номер записи каталога
; Выход: R1 - адрес записи в буфере

M$7124:         swab    R1
                asr     R1
                asr     R1
                asr     R1              ; R1 * 32. получим адрес записи
                mov     R0, -(SP)
                mov     #5, R0          ; начальный номер блока каталога

1$:             cmp     R1, #1000
                blt     2$
                sub     #1000, R1
                inc     R0              ; найдём блок, в котором эта запись находится
                br      1$              ; а в R1 будет адрес записи в блоке

2$:             call    @RDBLOK         ; Чтение блока в буфер
                                        ; Параметры: R0 - Номер блока на диске
                add     @#IOBUFF, R1    ; Адрес записи в буфере ANDOS
                cmp     R0, #14         ; если получилось вообще за каталогом
                bne     3$
                clrb    (R1)            ; то обозначаем запись как пустую

3$:             mov     (SP)+, R0

                tstb    @#ILIB          ; индикатор режима прозрачности (0 - реж.откл.)
                beq     M$FIL           ; Проверка совпадения имени файла (подкаталога) (адрес записи в R1) и фильтра.
                                        ; Если имя не соответствует фильтру, то устанавливается
                                        ; бит "C", если обнаружен признак конца каталога ((R1)=0), то бит "Z"
                tstb    F$DIRN(R1)      ; это директория ?
                beq     M$FIL           ; нет файл - фильтровать

M$Ret3$:        mov     (SP)+, (SP)     ; иначе выход с битом С
                sec
                return
; End of function M$7123


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107016
; Переход по ветвлению
; За командой параметры: цепочка п/п, начало 4000+код_кл. конец цепочки - слово 0
; Вход: R0 - код клавиши

M$7016:         mov     (SP), R1        ; адрес возврата, от него начнём искать
                bis     #4000, R0       ; формируем сигнатуру поиска

1$:             tst     (R1)            ; 0 ?
                beq     2$              ; конец поиска
                cmp     R0, (R1)+       ; нашли?
                bne     1$              ; нет. продолжаем

                mov     R1, (SP)        ; нашли - адрес перехода в адрес возврата
                tstb    R0              ; и если код был <0 то курсор погасим
                bmi     M$MARK1         ; Гашение указателя текущего файла (в  R2  должна  находиться
                                        ; вертикальная координата - содержимое ячейки Y)

2$:             rti
; End of function M$7016

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107035
; Высветить/погасить курсор меню
; Вход: R3 - индекс в таблице.
; R2 - адрес таблицы, формат:
; слово - смещение относительно базового адреса
; байт  - длина маркера (символов)
; байт  - высота маркера (точек)

M$MCUR:         jsr     R4, @#PUSH4
                asl     R3
                asl     R3
                add     R3, R2
                mov     (R2)+, R1
                movb    (R2)+, R3
                movb    (R2), R2
                br      0Mark1$
; End of function M$MCUR


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107023
; Гашение указателя текущего файла (в  R2  должна  находиться
; вертикальная координата - содержимое ячейки Y)

M$MARK1:        tstb    @#M$CURSOR
                beq     M$Ret4$
; End of function M$MARK1

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107022
; Инверсия указателя текущего файла (в R2 должна находиться
; вертикальная координата - содержимое ячейки Y)

M$MARK:         jsr     R4, @#PUSH4
                movb    @#XB, R1        ; горизонтальное координата панели (1 или 41)
                emt     24              ; установка курсора по координатам X = R1, Y = R2
                comb    @#M$CURSOR
                clr     R1
                mov     #12, R2
                mov     #36, R3

0Mark1$:        add     @#AS, R1

1$:             mov     R3, R4

2$:             comb    (R1)+
                sob     R4, 2$
                add     #100, R1
                sub     R3, R1
                bpl     3$
                sub     #40000, R1

3$:             sob     R2, 1$
                br      0Ret3$
; End of function M$MARK

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107015
; Проверка совпадения имени файла (подкаталога) (адрес записи в R1) и фильтра. Если имя не соответствует фильтру,
; то устанавливается бит "C", если обнаружен признак конца каталога ((R1)=0), то бит "Z"

M$FIL:          jsr     R4, @#PUSH4
                mov     @#M$FILTADDR, R3
                cmp     (R1), #"..
                beq     5$
                tstb    (R1)
                beq     6$
                cmpb    (R1), #345
                beq     1$
                tstb    @#ITTB          ; индикатор текущий активной панели (0 - режим неактивен)
                bpl     2$
                cmp     R3, #FILT       ; буфер фильтра оболочки активной панели
                bne     2$
                tstb    F$MARK(R1)
                bne     6$

1$:             sec
                br      5$

2$:             mov     #13, R4
                cmpb    F$PARD(R1), @#DIRB  ; номер текущего подкаталога активной панели
                beq     3$
                tstb    @#ILIB          ; индикатор режима прозрачности (0 - реж.откл.)
                beq     1$

3$:             movb    (R1)+, R0
                movb    (R3)+, R2
                beq     4$
                bicb    #240, R0
                bicb    #240, R2
                cmpb    R0, R2
                bne     1$

4$:             sob     R4, 3$

5$:             clz

6$:             mfps    14(SP)

0Ret3$:         br      M$Ret5$
; End of function M$FIL

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107003
; Вывод символа из R0 на экран

M$SYMB:         bitb    #140, R0
                bne     M$V20           ; IOT - вывод символа на экран, код символа в R0
                emt     16              ; Вывод символа

M$Ret4$:        rti
; End of function M$SYMB

; ───────────────────────────────────────────────────────────────────────────
; мёртвый код
                .word DM$FN + 075       ; Печать содержимого R0 на ПУ
                br      M$Ret5$
; ───────────────────────────────────────────────────────────────────────────

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; IOT - вывод символа на экран, код символа в R0

M$V20:          jsr     R4, @#PUSH4

M$MorphV20:     mov     #AS, R4         ; Ячейка Абсолютного адреса курсора в ОЗУ экрана
                mov     (R4), R3
                inc     (R4)
                mov     #100, R4
                bic     #177400, R0
                aslb    R0
                bcc     1$
                add     #300, R0

1$:             mov     R0, R2
                asl     R0
                asl     R0
                add     R2, R0
                add     #111576, R0
                mov     #5, R2
                movb    @#COLORB, R1    ; режим оцветнения (0 - черно/белый)
                bne     2$
                tst     @#PRPODC        ; Признак подчёркивания  и инверсии символа
                beq     6$

2$:             asl     R2
                mov     R5, -(SP)

3$:             movb    (R0), R5
                aslb    R5
                bisb    (R0)+, R5
                bicb    R1, R5
                tstb    @#PRINWS        ; Признак инверсии символа
                beq     4$
                comb    R5

4$:             movb    R5, (R3)
                add     R4, R3
                bpl     5$
                sub     #40000, R3

5$:             sob     R2, 3$
                mov     (SP)+, R5
                br      M$Ret5$

6$:             movb    (R0)+, (R3)
                add     R4, R3
                movb    (R0)+, (R3)
                add     R4, R3
                bpl     7$
                sub     #40000, R3

7$:             sob     R2, 6$

M$Ret5$:        jmp     @#POP4I
; End of function M$V20

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107014
; Смена активной панели

M$SPA:          .word DM$FN + 021       ; Блокировка прерывания по клавише СТОП
                jsr     R4, @#PUSH4
                mov     #DAB, R1        ; устройство активной панели
                mov     #DAPB, R2       ; устройство пассивной панели
                .word DM$FN + 132       ; меняем местами первый блок параметров
                mov     #FILT, R1       ; буфер фильтра оболочки активной панели
                mov     #FILTP, R2      ; буфер фильтра оболочки пассивной панели
                .word DM$FN + 132       ; меняем местами второй блок параметров
                .word DM$FN + 052       ; Отмена блокировки СТОП
                br      M$Ret5$
; End of function M$SPA

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107132
; Обмен местами содержимого блоков A и P
; Вход: R1 - A
;       R2 - P
; предполагается, что блок P идёт непосредственно за блоком A

M$7132:         mov     R2, R3

1$:             mov     (R1), R0
                mov     (R2), (R1)+
                mov     R0, (R2)+
                cmp     R1, R3
                bne     1$
                rti
; End of function M$7132

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107007
; Десятичный вывод содержимого R2, (R2<1000.)

M$TYP10:        jsr     R4, @#PUSH4
                mov     R2, R1
                mov     #M$DECCONST, R4 ; десятичные порядки
                br      4$

1$:             inc     R0

2$:             sub     R3, R1
                bpl     1$
                add     R3, R1
                cmp     R2, R3
                bhis    3$
                mov     #40, R0

3$:             iot

4$:             mov     #'0, R0
                movb    -(R4), R3
                bne     2$
                add     R1, R0
                br      M$MorphV20
; End of function M$TYP10

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

M$KEYTRP:       mov     #24000, @#INKDELAY
                rti
; End of function M$KEYTRP

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107121

M$7121:         .word DM$FN + 127       ; вывод элемента каталога на экран

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107107
; повторное получение кода, если клавиша нажата

M$7107:         add     #1000, @#INKDELAY
1$:             dec     @#INKDELAY
                bpl     1$
2$:             bit     #100, @#177716
                bne     2$
                movb    @#177662, R0
                rti
; End of function M$7107
; End of function M$7121

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107002
; Приём символа с клавиатуры в R0

M$INPUT:        tstb    @#PRZKB         ; Новый код в буфере есть?
                bne     1$              ; да
                dec     @#M$ARPTDELAY
                bpl     M$INPUT
1$:             mov     #7400, @#BKPOWT ; Буфер константы повтора
                movb    SP, @#PRPOWT    ; Признак повтора кода
                call    @#101010        ; п/п ЕМТ 6
                bic     #177400, R0
                rti
; End of function M$INPUT

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107050
; Вертикальное меню (аналогично GOR)

M$VERT:         mov     PC, R0
                br      M$7114
; End of function M$VERT


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107047
; Горизонтальное меню. За кодом вызова располагаются несколько
; байтов, содержащих буквенные символы, по которым будут вызываться
; пункты меню (их количество  определяет  число  пунктов),
; признак конца - 0. В ячейке 160 - базовый адрес  экрана,  R2  -
; адрес таблицы параметров, R3 - номер текущего пункта меню. Таб-
; лица параметров имеет следующую структуру (для каждого пункта):
; слово - смещение относительно базового адреса
; байт  - длина маркера (символов)
; байт  - высота маркера (точек)
; Подпрограмма помещает в R3 номер выбранного пункта меню.

M$GOR:          clr     R0

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107114
; вертикально-горизонтальное меню.
; Вход: R0 == 0 - горизонтальное меню != 0 - вертикальное
; параметры описаны в 107047

M$7114:         mov     R5, 2(SP)
                mov     (SP)+, R5
                jsr     R4, @#PUSH4
                .word DM$FN + 130       ; Очистка признака записи кода в буфер
1$:             .word DM$FN + 035       ; Высветить/погасить курсор меню
2$:             .word DM$FN + 002       ; Приём символа с клавиатуры в R0
                .word DM$FN + 016       ; Переход по ветвлению
                bic     #177640, R0
                mov     R5, R1

3$:             tstb    (R1)
                beq     7$
                cmpb    (R1)+, R0
                bne     3$
                sub     R5, R1
                dec     R1

4$:             .word DM$FN + 035       ; Высветить/погасить курсор меню
                mov     R1, R3
                .word DM$FN + 035       ; Высветить/погасить курсор меню

5$:             mov     R3, 6(SP)
                mov     R0, (SP)

6$:             tstb    (R5)+
                bne     6$
                br      5Ret$

7$:             tst     (SP)
                ble     2$
                cmpb    R0, #134 ; '\'
                bne     8$
                clr     R0
                br      5$

8$:             bit     #100, R0
                beq     2$
                mov     #2, R1
                br      4$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 10        ; Стрелка влево
                tst     (SP)
                bmi     5$

9$:             tst     R3
                beq     2$
                .word DM$FN + 035       ; Высветить/погасить курсор меню
                dec     R3
                br      1$
; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 031       ; Стрелка вправо
                tst     (SP)
                bmi     5$

10$:            mov     R5, R1

11$:            tstb    (R1)+
                bne     11$
                sub     R5, R1
                tst     -(R1)
                cmp     R3, R1
                bhis    2$
                .word DM$FN + 035       ; Высветить/погасить курсор меню
                inc     R3
                br      1$
; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 32        ; Стрелка вверх
                tst     (SP)
                bmi     9$
                br      2$
; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 33        ; Стрелка вниз
                tst     (SP)
                bmi     10$
                br      2$
; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 12        ; Ввод
                br      5$
; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 3         ; КТ
                halt
; End of function M$GOR
; End of function M$7114

; ───────────────────────────────────────────────────────────────────────────
                .byte 10.
                .byte 100.
M$DECCONST:

; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107064
; Вывод текста в рамке. За кодом вызова идут 4 байта параметров рамки:
; B1 - горизонтальная координата левого верхнего угла (X0),
; B2 - вертикальная координата (координаты по стандарту EMT 24),
; B3 - высота рамки (точек),
; В4 - длина (символов). Затем идёт текст (аналогично LINE).
; Текст может быть разбит кодами "12" на отдельные строки, каждая
; строка будет иметь горизонтальное смещение X0. Фрагмент экрана
; под рамкой сохраняется в специальном буфере, если FLAG не равен
; "0".

M$RAMKA:        mov     R5, 2(SP)
                mov     (SP)+, R5
                jsr     R4, @#PUSH4
                mov     R5, R3
                .word DM$FN + 133       ; Расчёт адреса вывода рамки и получение размеров
                                        ; Вход: R3 адрес блока из 4 байта: X, Y, n, m
                                        ; Выход: R1 - адрес экрана по координатам XY
                                        ; R2 - n
                                        ; R3 - m
                tst     @#M$SAVESCR     ; содержимое экрана под окном сохранять надо?
                beq     1$              ; нет - переход
                .word DM$FN + 071       ; Сохранение фрагмента экрана в память подпрограммой RAMKA

1$:             cmp     (R5)+, (R5)+
                .word DM$PR + 234       ; включить инверсию символов
                .word DM$FN + 057       ; элемент горизонтального бордюра рамки
                .word DM$FN + 060       ; элемент горизонтального бордюра рамки
                .word DM$FN + 063       ; прорисовка нижнего бордюра рамки
                br      3$

2$:             .word DM$FN + 003       ; Вывод символа из R0 на экран

3$:             movb    (R5)+, R0
                beq     4$
                cmp     R0, #12
                bne     2$
                .word DM$PR + 033       ; стрелка вниз
                br      3$

4$:             clr     @#PRPODC        ; выключить подчёркивание и инверсию символов

5Ret$:          jsr     R4, @#POP4

M$Ret6$:        inc     R5
                bic     #1, R5
                rts     R5
; End of function M$RAMKA


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107004
; Вывод текста на экран, текст в виде ASCII должен располагаться за кодом вызова,
; признак конца - 0-байт, если количество символов нечётное, или 0-слово, если чётное

M$LINE:         mov     R5, 2(SP)
                mov     (SP)+, R5
                mov     R0, -(SP)
                br      2$

1$:             .word DM$FN + 003       ; Вывод символа из R0 на экран

2$:             movb    (R5)+, R0
                bne     1$
                mov     (SP)+, R0
                br      M$Ret6$
; End of function M$LINE


; ███████████████ S U B R O U T I N E ███████████████████████████████████████

; 107110
; получение параметров окна файлёра.

M$7110:         mov     #F$PFILER+4, R4 ; параметры файлёра
                mov     (R4), R1        ; адрес смещения файлёра от начала экрана
                bis     #40000, R1      ; получим адрес экрана
                mov     R1, @#AS        ; и поместим его на место
                movb    -(R4), R2       ; высота файлёра
                movb    -(R4), R3       ; ширина файлёра
                rti
; End of function M$7110

; ───────────────────────────────────────────────────────────────────────────

;============================================================================
; Точка входа в файлер
F$ENTRY:        emt     130             ; сигнатура
                mov     SP, @#F$SPBUF
                mov     #F$TopStack, SP ; вершина стека, всё выше - буфер
                jsr     R4, @#PUSH4
                call    @#InitMaster    ;установка векторов 4, 10, 20, 60,
                                        ;274, ячеек 12, 120150, 242, 120172
                                        ;160, 56, 44, а то, что в них было
                                        ;сохраняем в буфере с адресов >=F$TopStack
                mov     #F$HLT, @#4
                mov     #F$SCREEN, @#SCREEN ; Ячейка перехвата вывода на экран сообщений
                                        ; ANDOS (Значение по умолчанию 0)
                mov     #XY$FIL, R1     ; (Кол-во столбцов)X(кол-во строк в файлере)
                mov     #F$PFILER, R2   ; буфер параметров файлера
                mov     @#177664, R0
                swab    R0              ; если старший байт в R0 равен 0, то Z = 1
                beq     1$              ; если режим РП включён, переход
                cmp     @#ANVP, #70000  ; нет, смотрим начальный адрес
                blo     2$              ; ОЗУ экрана
                sub     #40000, R0

1$:             mov     #F$PARAM, R1    ;параметры для узкого экрана
                                        ;(неизменяемые):
                                        ;число столбцов*число↓  17
                                        ;число текстовых строк  3
                                        ;ширина окна файлера    76 байт
                                        ;высота окна файлера    37 строк
                                        ;смещение от начала экрана 2000
2$:             mov     (R1)+, (R2)+
                mov     (R1)+, (R2)+
                mov     (R1), (R2)
                sub     #154000, R0
                clrb    R0
                ror     R0
                asr     R0              ; вычислим адрес экрана, с которого
                add     R0, (R2)        ; начинать вывод окна
                .word DM$FN + 110       ; получение параметров окна файлёра
                .word DM$FN + 056       ; прорисовка тела рамки
                                        ; Вход: R1 - адрес экрана
                                        ;       R2 - число строк
                                        ;       R3 - ширина
                                        ; За командой параметры 4 байта
                                        ; byte число строк, фон, левый бордюр, правый бордюр
                                        ; если число строк 0, то значение берётся из R2
                .byte 12, 377, 377, 377
                mov     R1, @#F$AFILER  ; адресочек сохраним

                .word DM$FN + 056       ; прорисовка тела рамки
                                        ; Вход: R1 - адрес экрана
                                        ;       R2 - число строк
                                        ;       R3 - ширина
                                        ; За командой параметры 4 байта
                                        ; byte число строк, фон, левый бордюр, правый бордюр
                                        ; если число строк 0, то значение берётся из R2
                .byte 0, 125, 125, 125

F$L3$:          mov     #F$DIRNME, R1   ; имя текущей поддиректории
                mov     #14, R3
                mov     R3, R2
4$:             movb    #40, (R1)+      ; очистим
                sob     R3, 4$

                mov     R1, @#M$FILTADDR    ; это адрес фильтра
                mov     #NAMBUF, R0     ; Буфер имени

5$:             movb    (R0)+, (R1)     ; перепишем фильтр из буфера
                bicb    #240, (R1)+     ; и делаем буквы большие и латинские
                sob     R2, 5$

F$L6$:          mov     @#M$FILTADDR, R2
                mov     #13, R0
                clr     R3              ; проверим, фильтр есть?
7$:             bisb    (R2)+, R3
                sob     R0, 7$
                beq     8$              ; нет фильтра
                com     R0              ; есть
8$:             movb    R0, @#ILIB      ; индикатор режима прозрачности (0 - реж.откл.)
                bne     F$L9$
                movb    #'\, @#F$DIRNME+13 ;если нету - то слешем ограничим директорию

F$L9$:          .word DM$FN + 110       ; получение параметров окна файлёра
                .word DM$FN + 056       ; прорисовка тела рамки
                                        ; Вход: R1 - адрес экрана
                                        ;       R2 - число строк
                                        ;       R3 - ширина
                                        ; За командой параметры 4 байта
                                        ; byte число строк, фон, левый бордюр, правый бордюр
                                        ; если число строк 0, то значение берётся из R2
                .byte 12, 377, 377, 377

                .word DM$FN + 110       ; получение параметров окна файлёра
                comb    @#PRINWS
                movb    @#DEVTEK, R0    ; Временное текущее устройство. Совпадает с DEVICE при
                                        ; запуске операции, изменяется при явном указании
                                        ; устройства в имени
                .word DM$FN + 112       ; выведем текущий привод на экран
                mov     #F$DIRNME, R5   ; и имя подкаталога
                mov     #14, R2
                call    F$OUTNM         ; простой вывод
                mov     #10, R2         ; и фильтр
                call    F$OUTMSK        ; вывод с маской
                .word DM$PR + '.
                add     R2, R5
                mov     #3, R2
                call    F$OUTMSK        ; вывод с маской

                clr     R2
                clr     @#PRPODC
                mov     @#F$AFILER, R1  ; достанем адресочек
                clr     R5

10$:            mov     R5, -(SP)
                mov     R2, -(SP)
                ble     12$
11$:            dec     R5
                .word DM$FN + 123       ; чтение блока каталога в буфер
                bcs     11$
                sob     R2, 11$
12$:            .word DM$FN + 127       ; вывод элемента каталога на экран
                bcs     13$
                inc     R2
                tstb    (R1)
                beq     14$
13$:            inc     R5
14$:            cmpb    R2, @#F$PFILER  ; файлер заполнился именами?
                blo     12$
                mov     (SP)+, R2
                mov     (SP)+, R5

15$:            .word DM$FN + 123       ; чтение блока каталога в буфер
                bcc     16$
                inc     R5
                br      15$

16$:            .word DM$FN + 126       ; вывод выделенного курсором элемента каталога на экран
17$:            .word DM$FN + 066       ; motor off
                .word DM$FN + 107       ; приём кода с клавиатуры
                mov     #1, R3
                .word DM$FN + 016       ; переход по ветвлению
                bit     #100, R0
                beq     17$
18$:            movb    R0, @#F$FILTR
19$:            br      F$L6$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 040       ; пробел
                clr     R0
                br      18$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 000       ; шаг
                .word DM$FN + 121       ; вывод элемента каталога на экран и получение кода нажатой клавиши
                bic     #177740, R0
                movb    R0, @#DEVTEK    ; Временное текущее устройство. Совпадает с DEVICE при
                                        ; запуске операции, изменяется при явном указании
                                        ; устройства в имени
                br      20$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 134       ; '\'
                br      21$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 014       ; СБР
20$:            .word DM$FN + 077       ; инициализация диска
21$:            clrb    @#DIRB          ; номер текущего подкаталога активной панели
22$:            br      F$L3$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 033       ; стрелка вниз
23$:            mov     #1, R0
24$:            mov     R5, R4
                clr     @#F$COUNT
25$:            add     R0, R4
                bmi     17$
                mov     R4, R1
                .word DM$FN + 124
                bcs     25$
                beq     17$
                add     R0, @#F$COUNT
                sob     R3, 25$
                .word DM$FN + 127       ; вывод элемента каталога на экран
                sub     R5, R4
                add     R4, R5
                movb    @#F$PFILER+1, R0
                add     @#F$COUNT, R2
                bmi     26$
                cmpb    R2, @#F$PFILER
                blt     15$
                neg     R0
26$:            add     R0, R2
                br      10$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 032       ; стрелка вверх
27$:            mov     #-1, R0
                br      24$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 010       ; стрелка влево
                movb    @#F$PFILER+1, R3
                br      27$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 031       ; стрелка вправо
                movb    @#F$PFILER+1, R3
                br      23$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + '.        ; '.'
                .word DM$FN + 121       ; вывод элемента каталога на экран и получение кода нажатой клавиши
                bit     #100, R0
                bne     28$
                clr     R0
28$:            mov     R0, @#F$FILTR+10
                br      19$

; ───────────────────────────────────────────────────────────────────────────
                .word DM$KC + 012       ; ввод
                .word DM$FN + 126       ; вывод выделенного курсором элемента каталога на экран
                mov     #13, R0
                movb    F$DIRN(R1), R2  ; это файл или директория?
                beq     30$             ; 0 - файл
                movb    R2, @#DIRB      ; номер текущего подкаталога активной панели
                mov     #F$DIRNME, R2
29$:            movb    (R1)+, (R2)+
                sob     R0, 29$
                jmp     F$L9$
; ───────────────────────────────────────────────────────────────────────────

30$:            tstb    (R1)            ; обработка файла
                beq     22$
                mov     R1, 4(SP)
                mov     R1, R5
                mov     #NAMBUF, R2     ; Буфер имени
31$:            movb    (R1)+, (R2)+    ; в R0 уже занесено значение 13
                sob     R0, 31$
                cmpb    @#COMAND, #3    ; была команда чтение?
                bne     0Ex1
                mov     6(SP), R0
                add     #6, R0
                .word DM$FN + 030       ; преобразование имени файла
                br      0Ex1
; ───────────────────────────────────────────────────────────────────────────

F$HLT:          mov     #F$EXIT, @F$SPBUF
0Ex1:           clrb    @#ILIB          ; индикатор режима прозрачности (0 - реж.откл.)
                .word DM$FN + 110       ; получение параметров окна файлёра
                add     #12, R2         ; стираем файлёр
                .word DM$FN + 056       ; прорисовка тела рамки
                                        ; Вход: R1 - адрес экрана
                                        ;       R2 - число строк
                                        ;       R3 - ширина
                                        ; За командой параметры 4 байта
                                        ; byte число строк, фон, левый бордюр, правый бордюр
                                        ; если число строк 0, то значение берётся из R2
                .byte 0, 0, 0, 0

                mov     #F$TopStack, R5
                mov     #M$INITBL, R1
1$:             mov     (R1)+, R0
                mov     (R5)+, @(R1)+
                tst     R0
                bne     1$
                mov     @#TEKBLK, (SP)   ; Номер блока диска, находящегося в буфере
                jsr     R4, @#POP4
                mov     @#F$SPBUF, SP
                return


F$OUTMSK:       tstb    (R5)
                bne     F$OUTNM
                .word DM$PR + '*
                br      1Ret
; End of function F$OUTMSK


F$OUTNM:        movb    (R5)+, R0
                cmpb    R0, #40
                blos    1$
                iot
1$:             sob     R2, F$OUTNM
1Ret:           return
; End of function F$OUTNM

F$EXIT:         halt
; ===========================================================================

; ───────────────────────────────────────────────────────────────────────────
; 107006
; Перевод строки для печатающего устройства
M$LF:           mov     #12, R0
; ───────────────────────────────────────────────────────────────────────────
; 107075
; Печать содержимого R0 на ПУ
M$PRINT:        mov     (SP)+, (SP)
                jmp     @OUTPRN         ; Адрес п/п вывода на принтер байта из R0 с перекодировкой
                                        ; в соответствии с текущей кодовой таблицей. Перед
                                        ; LF (12) автоматически выводится CR (15)
; ───────────────────────────────────────────────────────────────────────────
M$CHKEND:

; ===========================================================================
; Точка входа в эмулятор микродос
E$ENTRY:        emt     130             ; сигнатура
                call    @ENAME          ; Поиск конца строки и точки
                blos    1$              ; имя не нашли, выходим
                cmp     @#BUFFER+400, #123456   ; это точно микродос?
                beq     2$              ; да - обрабатываем
1$:             return

2$:             movb    @#COMAND, R0    ; Мл.байт - команда EMT36. В эту ячейку заносится код
                                        ; команды из первого байта блока параметров EMT36, он
                                        ; может изменятся командами ANDOS
                                        ; Ст.байт - дескриптор команды
                beq     3$              ; команду 0 обработаем
                sub     #3, R0          ; и команду 3 обработаем
                bne     1$              ; остальные - нет

3$:             mov     R0, -(SP)
                add     #6, R1
                mov     R1, -(SP)
                cmpb    1(R1), #':
                bne     5$
                mov     #7, R2
4$:             mov     2(R1), (R1)+
                sob     R2, 4$

5$:             mov     #BUFFER+500, R4 ;начало каталога
                mov     @#BUFFER+32, R5 ; количество занятых блоков
                cmp     @#BUFFER+402, #51414 ; это МКДОС?
                bne     6$
                mov     @#BUFFER+30, R5 ; тогда количество записей в каталоге
                neg     R5              ; и это отметим

6$:             mov     (SP), R2
                cmp     20(R4), R5      ; номер начального блока
                bhis    12$
                tst     (R4)+
                bmi     11$
                mov     R4, -(SP)
                mov     #7, R0
                tstb    @#COMAND        ; что за команда ?
                bne     9$              ; чтение
                mov     #16, R2         ; команда 0
7$:             movb    (R4)+, R0
                call    @#OUTCHR        ; вывод символа, п/п из ядра
                sob     R2, 7$
8$:             bit     #100, @#177716
                beq     8$
                tst     @#177662
                jsr     R4, @#PUTS
                .asciz <12>
                .even
                br      10$

9$:             cmp     (R2)+, (R4)
                bne     10$
                mov     (R4)+, 22(R2)
                sob     R0, 9$
                mov     (R4)+, 4(SP)
                cmp     (R2)+, (R4)+
                mov     (R4)+, (R2)+
                mov     (R4), (R2)
10$:            mov     (SP)+, R4
                tst     R5
                bpl     11$
                inc     R5
                beq     12$

11$:            add     #26, R4
                cmp     R4, #BUFFER+1000
                blo     6$
                mov     @#TEKBLK, R0    ; Номер блока диска, находящегося в буфере
                inc     R0
                mov     #414, R1
                call    @RWBUF1
                sub     #1000, R4
                br      6$

12$:            mov     (SP)+, R2
                tstb    @#COMAND        ; Мл.байт - команда EMT36. В эту ячейку заносится код
                                        ; команды из первого байта блока параметров EMT36, он
                                        ; может изменятся командами ANDOS
                                        ; Ст.байт - дескриптор команды
                beq     F$EXIT
                mov     (SP)+, R0
                beq     14$
                mov     R0, @#314
                add     #22, R2
                mov     (R2), R1
                mov     -(R2), R3
                mov     -24(R2), R2
                bne     13$
                mov     R3, R2
13$:            mov     R2, @#BUFSTA
                mov     R1, @#BUFDL
                inc     R1
                ror     R1
                mov     #E$EHLT, -(SP)
                jmp     @RWBLOK

14$:            jmp     @#E$EERR
; ===========================================================================

; ===========================================================================
; модуль драйвера принтера
; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; подпрограмма инициализации принтера. Вызов:
; CALL @RUNNER .WORD P$INIPRN . Бит C означает отсутствие
; драйвера принтера. Регистры не сохраняются

P$INIPRN:       emt     130
                sec
                bit     #40400, @#177714
                beq     3$
                mov     #ILLP, R1       ; инициализирующая строка (1-й байт - длина строки),
                                        ; выводимая на принтер подпрограммой ANDOS INIPRN (120314)
                movb    (R1)+, R5
                beq     2$
1$:             movb    (R1)+, R0
                call    P$OUTPRN
                sob     R5, 1$
2$:             clc
3$:             return
; End of function P$INIPRN

; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; п/п вывода на принтер байта из R0 с перекодировкой
; в соответствии с текущей кодовой таблицей. Перед
; LF (12) автоматически выводится CR (15)

P$OUTPRN:       jsr     R4, @#PUSH4
                cmpb    R0, #12         ; это перевод строки?
                bne     1$              ; нет
                mov     #15, R0         ; да - сперва LF сделаем
                call    P$GRFPRN
                mov     (SP), R0

1$:             tstb    R0
                bpl     4$
                bic     #177740, R0     ;коды из диапазона 200-377
                bit     #100, (SP)
                bne     2$
                movb    P$Tbl2(R0), R0  ; 200-277
                br      4$

2$:             movb    P$Tbl1(R0), R0  ; 300-377
                cmpb    (SP), #340      ;маленькие русские?
                bhis    3$              ;да
                add     #40, R0         ;нет - откорректируем
3$:             add     #60, R0
4$:             br      0PRN$
; End of function P$OUTPRN

; ───────────────────────────────────────────────────────────────────────────
P$Tbl1:         .byte 236, 200, 201, 226, 204, 205, 224, 203
                .byte 225, 210, 211, 212, 213, 214, 215, 216
                .byte 217, 237, 220, 221, 222, 223, 206, 202
                .byte 234, 233, 207, 230, 235, 231, 227, 232
P$Tbl2:         .byte 277, 250,  40, 241, 203, 251, 243, 224
                .byte 202,  40, 240, 246, 201, 370, 252, 225
                .byte 247, 367, 232, 371,  40, 244, 236, 245
                .byte  40, 242, 237, 207, 200, 215, 366, 233

; ███████████████ S U B R O U T I N E ███████████████████████████████████████
; п/п вывода на принтер байта из R0 без перекодировки
; (напр. для печати графики)
P$GRFPRN:       jsr     R4, @#PUSH4
0PRN$:          bic     #177400, R0
                mov     #177714, R1
1$:             mov     (R1), R2
                bic     #137377, R2
                beq     1$
                nop
                bis     R2, R0
                mov     R0, (R1)
2$:             bit     R2, (R1)
                bne     2$
                bic     R2, R0
                mov     R0, (R1)
                jmp     @#POP4R         ; восстановить R0-R4 и ret
; End of function P$GRFPRN

; ===========================================================================
; мусор
                mov     R0, (R1)
                jmp     @#POP4R         ; восстановить R0-R4 и ret
                .word 0

; ===========================================================================
;точка входа в пользовательское дополнение
U$ENTRY:        emt     130
                cmpb    @#177662, #6
                beq     1$
                .word DM$FN + 064       ; Вывод текста в рамке
                .byte 11, 11, 47, 15
                .ascii "Screen viewer"<12>
                .ascii "by MEGABRAIN."<12>
                .asciz "& Golden puss"
                .even
                clr     @#177130
                .word DM$FN + 002       ; Приём символа с клавиатуры в R0
                halt
; ───────────────────────────────────────────────────────────────────────────
                .asciz "Слушай,друг,красть идеи - плохой стиль!К тому же это гадко !!! (p.s. by GC)"
                .even
; ───────────────────────────────────────────────────────────────────────────

1$:             mov     @#ADR, R2       ; текущий адрес в активной панели
                tstb    24(R2)
                bne     14$
                mov     @#IOBUFF, U$BUFIOBIF ; Адрес буфера ANDOS (125000)
                mov     @#AFAT, @#IOBUFF ; Адрес буфера ANDOS (125000)
                mov     #U$HLT, @#4
                mov     32(R2), R0
                mov     34(R2), R2
                bic     #174000, R2
                mov     R2, word_137452

U$L2$:          mov     #40000, R5
3$:             clr     (R5)+
                clr     (R5)+
                tst     R5
                bpl     3$
                mov     #U$FATBUF, R5
4$:             mov     R0, (R5)+
                call    @GETFAT
                cmp     R0, #7777
                beq     5$
                cmp     R5, #U$FATBUF+20
                bne     4$
                mov     R0, word_137552
                mov     #-1, (R5)
                br      6$
; ───────────────────────────────────────────────────────────────────────────

5$:             clr     (R5)
6$:             mov     #U$FATBUF, R5
                mov     #40000, R2
U$L7$:          mov     (R5), -(SP)
                mov     (R5)+, R3
                beq     13$
                bmi     11$
                mov     #4000, R1

8$:             mov     R3, R0
                mov     (R5), R3
                ble     9$
                mov     R3, -(SP)
                sub     R0, (SP)
                cmp     (SP)+, #1
                bne     9$
                tst     (R5)+
                add     #4000, R1
                br      8$
; ───────────────────────────────────────────────────────────────────────────

9$:             mov     (SP)+, R3
                tst     R1
                beq     12$
                tst     (R5)
                bne     10$
                tst     word_137452
                beq     10$
                sub     #4000, R1
                add     (PC)+, R1
word_137452:    .word 0
10$:            .word DM$FN + 036       ; Кластерная операция
                br      U$L7$
; ───────────────────────────────────────────────────────────────────────────

11$:            tst     (SP)+
12$:            clr     @#177130
                tst     @#177662
                .word DM$FN + 002       ; Приём символа с клавиатуры в R0
                mov     word_137552, R0
                br      U$L2$
; ───────────────────────────────────────────────────────────────────────────

13$:            clr     @#177130
                tst     @#177662
                .word DM$FN + 002       ; Приём символа с клавиатуры в R0
U$HLT:          mov     (PC)+,@(PC)+
U$BUFIOBIF:     .word 0
                .word IOBUFF
                .word DM$FN + 221       ; прорисовка панелей и строки меню
                .word DM$FN + 216       ; Перерисовка обеих панелей (выход в режим работы с панелями
                                        ; оболочки)
14$:            halt
; ───────────────────────────────────────────────────────────────────────────
U$FATBUF:       .blkb 22
word_137552:    .word 0

                .org 140000 ; выравнивание до границы страницы, чтобы можно было собрать файл andos.sys
                            ; больше не нужно низачем
                .END
