; : BK Turbo8 Cross Assembler

;
;16'o177320;		// 100000-107777
;16'o177322;		// 110000-117777
;16'o177324;		// 120000-127777
;16'o177326;		// 130000-137777
;16'o177330;		// 140000-147777
;16'o177332;		// 150000-157777
;16'o177334;		// 160000-167777    ;
;16'o177336;		// 170000-177777    ;     
;16'o177340;		//   -    ,   -  
;16'o177342;		//   -   r/o 		    ,   -  
;16'o177344;		//   -    ,   -    =1    
;16'o177346;		//    

; 1000 -    
; 2000 - 1   
; 3000 - c  
;------------------------------------------------------------------------------

Begin:          mov     @#177230,-(SP)
                mov     @#177232,-(SP)
                mov     @#177334,-(SP)
                mov     @#177336,-(SP)
                mov     @#100, -(SP)            ;   
                mov     @#102, -(SP)
                mov     @#177340, -(SP)         ;   
                mov     @#177342, -(SP)
                mov     @#177344, -(SP)
                mov     @#177352, -(SP)
                mov     @#177346, -(SP)

                mov     @#177230,@#m230
                mov     @#177232,@#m232

; ******************************************************************************
                mov     #hello,R1
                clr     R2
                EMT     20

; ******************************************************************************
                bis     #100,@#177660       ;    
; ******************************************************************************
                bis     #140000,@#177340      ;   160 170
                bic     #140000,@#177342      ;  R/O    
; ******************************************************************************

                ;     
                mov     #frame1,R0
                mov     #1800.,R1           ; 1800 ! 6060 = 3600 
                mov     #3000,@#177334      ;  3000   160000
                mov     #160000,R2
$aa1:           mov     (R0)+,(R2)+
                sob     R1,$aa1

; ******************************************************************************

                mov     #2000,@#177336          ;   2000   170000

                mov     #vm256x192x8bit,R1  ; Video mode 256x192x8bit
                clr     R2
                EMT     20

                mov     #063233,@#177230    ;   256192 256,    256  -   96
                mov     #1000,@#177232      ;    

                call    TEST_PACK


                mov     #vm512x384x8bit,R1  ; Video mode 512x384x8bit
                clr     R2
                EMT     20

                mov     #101133,@#177230    ;   512x384x8bit,
                mov     #1000,@#177232      ;    

                call    TEST_PACK


done:           mov     #12100,@#177230     ;   
                mov     @#m232,@#177232
                ;   
$sa0:           bit     #200,@#177660       ;  
                bne     KBpressed
                bit     #100, @#177716      ;   
                beq     KBpressed
                br      $sa0


KBpressed:
; ******************************************************************************
                ;  
                bic     #10,@#177346            ;  
                clr     @#177250                ;     
                clr     @#177252                ;     
                ;  
                mov     (SP)+,@#177346
                mov     (SP)+,@#177716
                mov     (SP)+,@#177344
                mov     (SP)+,@#177342
                mov     (SP)+,@#177340
                mov     (SP)+,@#102
                mov     (SP)+,@#100
                mov     (SP)+,@#177336
                mov     (SP)+,@#177334
                mov     (SP)+,@#177232
                mov     (SP)+,@#177230
                bic     #100,@#177660       ;    
                JMP     @#100000
; ******************************************************************************


; ************************   100 *****************************
TIMER_STOP:     inc     R4
TIMER:          RTI

; ******************************************************************************
LDEC:	        MOV     R4,-(SP)    ; R3  -   
                MOV     R3,-(SP)
                MOV     R2,-(SP)
                MOV     R0,-(SP)
                MOV     #60,R0
                MOV     #MD,R2
                MOV     #5,R4               ;    
1:	            CMP     R3,@R2
                BMI     2
                INCB    R0
                SUB     (R2),R3
                BR      1
2:	            EMT     16
                MOV     #60,R0
                TST     (R2)+
                SOB     R4,1
                MOV     (SP)+,R0
                MOV     (SP)+,R2
                MOV     (SP)+,R3
                MOV     (SP)+,R4
                RET
MD:	            .WORD   10000.,1000.,100.,10.,1
; ******************************************************************************


TEST_PACK:      mov     #head,R1
                clr     R2
                EMT     20

                mov     #ms0,R1
                clr     R2
                EMT     20

                mov     #0b0011000000010000,@#170000
                mov     #0,@#170002
                mov     #0,@#170004
                mov     #0,@#170006      ;   -  0
                movb    #29.,@#170010    ;       30-1  (60px)
                movb    #60.,@#170011    ;  c -     60.
                mov     #99.,@#170012    ;  128.-29.=89.+1
                mov     #0,@#170014      ;
                mov     #177777,@#170016 ; 

                call    MEASURE_PACK


                ; 11    1  -     4000
                mov     #ms11,R1
                clr     R2
                EMT     20

                mov     #30020,@#170000
                mov     #34000,@#170002
                mov     #0,@#170004
                mov     #11,@#170006 ;   SRC 30-1
                movb    #29.,@#170010 ; 30-1
                movb    #60.,@#170011 ;
                mov     #99.,@#170012 ; -  256px  ,  128 :  128.-29.=99.
                mov     #0,@#170014 ;;7  -  Y=0
                mov     #0,@#170016 ;   

                call    MEASURE_PACK


                ; 21 -   
                mov     #ms21,R1
                clr     R2
                EMT     20

                mov     #30020,@#170000
                mov     #0,@#170002
                mov     #0,@#170004
                mov     #21,@#170006  ;   
                movb    #29.,@#170010 ; 30-1
                movb    #60.,@#170011 ;
                mov     #99.,@#170012 ;
                mov     #0.,@#170014  ;7  -  Y=0
                mov     #0,@#170016   ;

                call    MEASURE_PACK


                ; 42 -
                mov     #ms42,R1
                clr     R2
                EMT     20

                mov     #30020,@#170000
                mov     #34000,@#170002
                mov     #0,@#170004
                mov     #42,@#170006  ; 42
                movb    #29.,@#170010 ; 30-1
                movb    #60.,@#170011 ;
                mov     #99.,@#170012 ;
                mov     #0,@#170014   ;
                mov     #0,@#170016   ; //         

                call    MEASURE_PACK

                ; 33 -
                mov     #ms33,R1
                clr     R2
                EMT     20

                mov     #30020,@#170000
                mov     #0,@#170002
                mov     #0,@#170004
                mov     #33,@#170006 ;   
                movb    #29.,@#170010 ; 30-1
                movb    #60.,@#170011 ;
                mov     #99.,@#170012 ;
                mov     #0.,@#170014 ;
                mov     #0x6300,@#170016 ;

                call    MEASURE_PACK

                ; 51 -
                mov     #ms51,R1
                clr     R2
                EMT     20

                mov     #30020,@#170000
                mov     #0,@#170002
                mov     #0,@#170004
                mov     #51,@#170006  ;
                movb    #29.,@#170010 ; 30-1
                movb    #60.,@#170011 ;
                mov     #99.,@#170012 ;
                mov     #0.,@#170014  ;7  -  Y=0
                mov     #0,@#170016   ;

                call    MEASURE_PACK

                RET

; ******************************************************************************

MEASURE_PACK:   bic     #4,@#177230      ;  
                call    MEASURE


                bis     #4,@#177230      ;  
                call    MEASURE

                bic     #4,@#177230         ;  
                bis     #1100,@#170006      ;    + 
                call    MEASURE
                bic     #1100,@#170006

                bis     #2000,@#170006      ;   
                call    MEASURE
                bic     #2000,@#170006

                bis     #3000,@#170006      ;   
                call    MEASURE
                bic     #3000,@#170006

                mov     #12,R0              ;  
                EMT     16

                RET


; ******************************************************************************
MEASURE:        ;   
                MOV     R4,-(SP)
                MOV     R3,-(SP)
                MOV     R0,-(SP)

                ;  
                mov     #TIMER,@#100            ;   
                mov     #340,@#102              ; 
                bic     #4,@#177346             ; 60 !
                bis     #10,@#177346            ;   60  (       )


                wait    ;   
                wait    ;    - 
                mov     #TIMER_STOP,@#100       ;   


                ;     -   
                mov     #2000,@#177272      ;    
                mov     #40000,@#177270     ;    
                bis     #1,@#177270         ;  

                clr     R3                      ;   
                clr     R4                      ;  

                ;***********    v15b8   *****************
$wZ:            bis     #10000,@#177270     ;  

                ; **********         ************
$w0:            bit     #10000,@#177270     ;    
                bne     $w0

                ; **********     ************
$w1:            bit     #100000,@#177270    ;   
                bne     $w1
                ; ******************************************************************
                inc     R3                  ; c  

                ;tst     R4
                ;beq     $wZ                 ;   1 
                cmp     #60.,R4
                bne     $wZ

                bic     #10,@#177346        ;   60

                call    LDEC                ;     R3  

                mov     #40,R0              ; 
                EMT     16
                mov     #'|,R0              ;
                EMT     16
                mov     #40,R0              ; 
                EMT     16

                MOV     (SP)+,R0
                MOV     (SP)+,R3
                MOV     (SP)+,R4

                RET
; ******************************************************************************


hello:          .asciz  "AZ blitter speed test v1.10  2025-05-26"<12>
head:           .asciz  "Type command   | speed | layers|mirrorH|mirrorV|mirrorHV "<12>
ms0:            .asciz  "Testing cmd 0  | "
ms11:           .asciz  "Testing cmd 11 | "
ms21:           .asciz  "Testing cmd 21 | "
ms42:           .asciz  "Testing cmd 42 | "
ms33:           .asciz  "Testing cmd 33 | "
ms51:           .asciz  "Testing cmd 51 | "

vm256x192x8bit: .asciz  "Video mode 256x192x8bit"<12>
vm512x384x8bit: .asciz  "Video mode 512x384x8bit"<12>

                .even

m230:            .word   0
m232:           .word   0
mm716:          .word   0


            ;  6060
frame1:   .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,212,330,330,366,264,155,155,221,156,214,267,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,212,144,152,107,042,262,046,046,264,110,111,111,111,112,267,036,036,267,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,330,373,262,042,042,042,042,042,042,262,046,374,212,110,111,111,111,223,376,036,267,043,157,215,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,212,255,046,046,046,262,042,042,042,042,042,216,326,374,330,155,111,111,112,156,333,036,333,043,043,043,043,214,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,264,154,042,152,262,046,046,046,262,042,042,042,042,042,216,373,374,264,111,111,104,043,267,036,333,223,043,043,043,156,033,023,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,221,110,110,107,042,042,216,326,046,046,262,042,042,042,042,152,330,374,367,155,111,104,112,267,371,371,215,105,043,105,156,376,367,367,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,221,111,110,110,110,107,042,042,152,262,046,046,262,042,042,042,042,211,374,374,257,103,104,105,151,371,371,267,105,105,105,151,033,367,257,155,221,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,033,367,367,257,212,110,110,107,042,042,042,042,262,046,046,262,100,100,100,144,250,366,361,147,076,077,151,317,363,267,105,105,105,214,033,367,257,110,102,212,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,033,033,033,367,367,367,257,212,110,107,042,042,042,042,262,364,364,254,100,072,073,204,366,361,023,076,076,077,317,363,317,077,077,076,214,367,367,257,102,102,110,154,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,214,151,214,267,267,376,367,367,367,264,154,107,042,042,042,100,254,364,364,202,072,073,074,250,361,362,142,077,077,317,363,363,142,077,076,207,361,367,250,102,102,101,100,255,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,267,105,105,043,043,112,221,257,367,367,367,374,264,144,042,100,100,100,312,356,356,202,073,073,204,361,353,207,071,077,252,363,363,207,077,076,205,361,361,250,074,101,101,210,320,373,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,105,105,043,043,043,043,043,112,111,221,257,367,366,330,211,100,100,072,136,312,356,312,174,066,066,353,353,243,134,071,200,355,355,200,071,071,023,361,361,204,074,073,072,202,364,364,366,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,151,105,043,043,043,043,043,043,043,112,112,111,221,374,366,360,246,136,072,072,174,304,350,240,131,066,243,353,354,135,071,200,355,355,200,071,067,243,353,360,204,073,073,072,246,356,364,254,204,000,000,000,000,000
          .byte 000,000,000,000,000,267,267,267,215,223,043,043,043,043,043,043,112,112,111,147,257,360,360,313,202,064,064,174,350,350,014,060,163,345,302,173,063,173,347,347,200,071,067,353,353,352,066,073,072,202,356,356,356,210,100,000,000,000,000,000
          .byte 000,000,000,000,000,371,371,371,036,036,333,333,267,223,157,043,112,112,104,103,075,204,360,360,350,174,064,064,224,335,277,060,053,273,045,231,041,173,045,347,173,053,177,353,352,352,066,064,072,246,356,356,246,136,100,204,000,000,000,000
          .byte 000,000,000,000,317,371,371,033,036,036,036,036,036,036,036,333,267,215,076,076,075,075,066,352,305,342,232,056,003,270,335,162,053,230,340,275,041,165,045,045,164,053,163,345,344,242,131,064,174,312,356,356,202,072,072,100,000,000,000,000
          .byte 000,000,000,267,252,267,215,215,223,223,223,267,267,333,333,036,371,371,363,252,205,067,067,066,226,342,044,224,002,114,335,300,053,163,045,275,041,165,045,045,164,053,227,336,344,167,057,064,240,350,356,312,136,072,072,072,202,000,000,000
          .byte 000,000,000,076,103,104,104,112,043,043,043,043,043,043,157,223,267,267,363,363,363,310,177,053,060,161,044,044,114,002,225,336,163,053,045,045,121,121,045,045,053,053,272,336,277,122,056,122,350,350,350,240,064,072,072,136,246,000,000,000
          .byte 000,000,000,075,103,103,103,111,111,112,112,043,043,043,043,105,105,077,142,252,311,355,345,273,163,052,114,044,044,003,114,336,227,053,275,045,121,121,045,273,053,162,272,335,224,002,056,232,342,350,304,064,064,072,072,246,357,366,000,000
          .byte 000,000,147,075,075,075,111,103,111,111,112,112,112,112,043,105,105,077,077,071,071,200,236,340,337,226,052,114,044,224,002,272,337,053,231,045,121,165,340,273,053,162,335,335,114,002,114,270,270,350,174,064,064,072,246,313,357,360,000,000
          .byte 000,000,147,074,147,154,221,221,221,221,257,257,257,267,267,267,267,252,207,200,135,054,041,165,230,337,272,002,160,342,122,167,353,172,200,347,127,164,340,163,052,226,335,224,003,002,224,044,342,232,122,064,131,174,360,356,360,360,023,000
          .byte 000,023,250,250,366,366,366,374,367,374,367,367,367,367,367,367,362,362,355,355,347,045,231,165,041,163,337,300,056,240,304,073,353,207,200,355,071,245,345,163,052,270,044,160,002,114,044,044,270,003,056,064,167,352,352,360,360,204,075,000
          .byte 000,360,357,366,360,366,374,374,330,264,264,212,212,221,147,221,205,205,200,245,236,275,045,045,275,164,053,242,312,072,312,137,023,207,142,363,076,243,353,057,161,044,270,002,002,270,044,044,160,051,057,167,352,352,352,360,250,075,075,000
          .byte 000,360,357,357,373,255,262,211,107,107,107,107,110,102,102,102,075,075,067,053,062,054,041,165,231,347,311,075,246,210,211,211,221,215,151,267,076,361,014,064,277,342,114,002,224,044,044,224,051,052,162,300,344,352,352,243,067,075,075,252
          .byte 000,313,312,246,136,100,042,042,042,042,042,042,042,107,101,211,250,250,242,272,273,273,227,230,173,135,207,267,154,216,216,211,221,223,223,222,155,360,072,174,350,240,056,114,044,335,225,052,052,162,272,344,345,353,243,067,067,075,076,207
          .byte 250,202,136,072,100,100,042,042,042,042,042,152,216,262,364,356,356,305,305,344,300,272,273,227,245,317,215,223,221,216,216,212,214,223,223,221,264,216,100,312,304,064,122,342,335,225,115,052,162,272,337,337,345,227,067,067,067,067,076,252
          .byte 204,072,072,072,100,100,042,042,152,216,262,046,046,046,320,246,202,174,064,002,002,002,114,162,014,205,222,223,222,204,246,014,252,215,221,154,262,042,254,364,072,064,305,335,300,060,060,163,273,337,337,273,227,062,062,070,070,207,317,317
          .byte 137,072,072,072,100,100,210,262,326,046,046,326,262,152,100,072,072,064,174,224,270,044,044,224,240,210,212,221,207,227,224,227,173,243,204,254,152,216,326,100,072,313,352,226,060,053,163,273,337,337,273,164,041,062,070,135,245,310,363,363
          .byte 137,072,072,136,210,320,364,046,046,262,216,042,042,042,100,100,202,304,350,342,224,114,003,167,202,210,216,210,226,173,202,245,164,226,240,202,216,326,042,107,250,360,014,067,067,227,337,337,340,236,165,041,041,127,200,245,355,355,355,363
          .byte 137,131,246,312,356,364,364,326,216,042,042,042,042,042,210,312,356,304,174,122,051,224,277,225,174,211,211,204,226,204,205,204,232,224,167,202,255,110,154,367,367,075,075,134,236,340,045,275,165,041,041,041,165,231,347,347,355,355,355,317
          .byte 246,304,356,356,356,364,254,152,042,042,042,042,152,262,046,320,246,073,066,167,336,336,162,163,353,207,222,215,164,014,177,212,204,227,230,205,147,267,267,222,104,076,252,355,347,347,231,121,041,041,121,165,275,045,347,347,355,311,245,142
          .byte 313,350,356,356,312,202,100,100,042,042,042,216,046,046,255,154,074,074,243,353,227,053,164,275,173,252,223,221,202,243,242,221,207,165,231,245,252,157,043,043,215,371,363,311,245,121,041,041,121,165,275,045,045,045,347,355,245,200,071,071
          .byte 313,350,356,246,136,072,100,100,042,042,262,374,373,212,110,110,075,023,361,243,063,231,045,121,236,245,204,210,216,222,221,210,226,230,230,200,215,215,333,333,333,267,142,071,071,063,165,231,275,045,045,045,045,275,236,173,135,071,071,071
          .byte 313,350,246,137,073,072,101,101,211,330,374,374,154,111,111,111,367,362,207,071,245,347,121,231,236,163,240,174,204,215,252,174,224,160,162,023,222,222,156,043,105,077,077,134,200,275,347,045,045,045,045,275,231,165,127,063,071,071,071,142
          .byte 250,240,131,073,073,073,074,212,366,374,366,110,111,111,111,267,371,215,077,207,355,200,127,340,163,225,160,224,227,231,165,226,160,224,240,246,212,155,221,221,214,252,361,355,354,355,045,275,275,231,165,121,121,041,041,063,063,135,200,252
          .byte 000,066,066,073,074,074,250,366,374,367,111,111,111,112,267,376,223,105,077,317,317,071,245,273,162,270,160,224,227,231,231,163,225,174,137,210,262,255,264,330,367,361,361,243,310,230,164,165,120,054,041,054,041,041,120,173,200,245,310,317
          .byte 000,066,066,074,075,250,361,361,367,221,111,112,112,222,036,267,043,043,215,363,142,075,353,014,167,224,114,225,163,231,173,302,067,304,312,210,042,042,042,107,102,074,074,067,053,053,053,053,053,053,164,164,164,230,273,302,353,354,355,361
          .byte 000,204,066,014,023,361,361,361,205,103,104,112,223,036,333,043,043,043,036,267,104,205,360,066,240,240,174,277,053,355,135,245,023,074,210,262,326,262,216,210,144,137,074,066,014,162,163,163,227,227,273,273,337,337,345,345,345,353,353,000
          .byte 000,205,177,243,353,361,361,252,076,104,043,157,036,036,223,043,043,267,376,156,103,250,360,072,246,246,064,352,075,252,317,077,317,367,107,042,152,262,326,046,356,356,350,305,344,344,336,336,336,337,337,337,337,337,337,345,353,353,243,000
          .byte 000,000,243,353,353,361,252,075,077,077,105,267,036,267,043,043,043,333,267,111,110,330,254,100,254,246,072,360,205,077,371,215,104,257,374,211,042,042,042,136,246,246,304,305,277,335,335,336,336,336,336,336,336,272,272,243,243,177,243,000
          .byte 000,000,353,353,353,310,142,077,077,077,267,371,371,157,043,043,223,376,221,111,110,373,216,042,262,254,042,264,367,112,223,036,157,112,221,374,326,216,100,072,072,064,064,122,174,114,160,161,162,161,162,162,162,162,060,060,066,066,000,000
          .byte 000,000,361,354,310,245,071,077,077,207,363,363,267,105,043,043,267,367,155,110,154,046,216,042,262,326,042,154,367,156,043,267,333,112,111,110,264,373,312,246,202,131,064,064,002,002,002,002,002,002,051,051,052,052,060,066,060,066,000,000
          .byte 000,000,000,354,311,135,071,071,077,317,363,363,207,105,105,156,367,257,110,110,216,046,152,042,216,326,042,110,257,267,043,043,333,333,111,111,102,204,360,356,350,350,277,232,160,114,114,003,003,003,003,003,115,115,057,057,066,014,000,000
          .byte 000,000,000,252,173,071,071,071,245,363,363,317,077,076,076,267,367,257,110,107,216,046,152,042,216,046,152,110,221,367,157,043,043,036,033,214,103,074,074,246,304,350,342,342,044,044,270,270,224,224,224,224,224,224,232,232,242,000,000,000
          .byte 000,000,000,000,135,071,071,200,311,355,355,207,077,076,076,361,361,212,110,101,262,046,152,042,152,046,216,110,111,376,267,043,043,151,371,362,023,075,066,066,131,167,224,044,044,044,044,044,044,044,044,044,342,270,342,342,242,000,000,000
          .byte 000,000,000,000,200,063,135,245,355,355,355,207,077,076,214,361,361,212,101,101,254,364,210,042,042,326,326,110,111,221,371,267,105,105,142,363,361,361,177,066,066,057,122,114,224,270,270,044,044,044,044,044,044,342,342,305,000,000,000,000
          .byte 000,000,000,000,000,135,165,311,355,355,311,071,070,075,023,361,361,074,073,072,254,364,210,100,100,320,373,154,075,103,033,371,207,077,077,207,310,353,353,243,162,060,052,051,002,003,114,160,224,224,270,270,270,342,305,000,000,000,000,000
          .byte 000,000,000,000,000,000,245,347,355,355,245,070,070,067,353,353,360,137,073,072,312,356,246,072,072,246,360,250,075,076,205,363,363,207,071,071,200,354,353,345,337,272,162,115,051,002,002,002,002,003,003,114,160,167,352,000,000,000,000,000
          .byte 000,000,000,000,000,000,317,347,347,302,200,070,067,177,353,352,352,137,072,072,312,356,246,072,072,202,357,360,075,075,076,317,363,355,200,071,071,127,236,345,337,337,336,300,224,162,003,002,002,002,002,002,056,014,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,311,347,275,172,053,053,177,352,352,352,131,064,064,304,356,312,072,072,137,360,360,023,067,070,200,355,355,311,173,063,063,120,230,273,337,336,336,336,225,225,161,114,003,002,056,122,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,310,236,054,053,053,243,352,352,352,131,064,131,304,350,350,174,064,064,352,352,352,177,070,071,245,355,347,347,173,041,062,120,163,227,337,337,336,336,336,335,270,224,224,167,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,200,053,053,053,226,344,344,277,131,064,131,240,350,350,174,064,064,242,352,353,243,070,062,127,275,347,347,045,165,121,054,054,164,163,273,337,336,336,336,336,335,277,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,200,053,163,272,344,344,277,122,056,064,224,350,342,240,064,064,014,344,353,353,164,054,041,173,275,045,045,045,231,121,054,054,053,163,163,273,336,336,336,352,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,177,163,272,336,335,270,122,056,122,232,350,342,270,122,057,052,300,344,345,273,164,041,041,165,275,045,045,045,236,165,054,053,053,053,163,226,226,344,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,300,335,335,224,114,002,003,224,044,342,044,114,051,052,162,337,337,337,230,121,041,041,165,275,045,045,045,275,164,120,053,053,053,053,243,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,243,344,270,114,002,002,160,044,044,044,224,115,052,162,272,337,337,273,165,041,041,041,231,275,045,045,045,275,230,164,053,172,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,242,167,002,002,160,270,044,044,224,115,052,060,226,273,337,340,236,165,041,041,121,231,275,045,045,045,045,245,245,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,014,115,114,270,044,044,270,161,052,052,163,273,337,337,340,236,165,041,041,121,165,275,045,347,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,242,240,277,044,044,225,162,052,060,163,337,337,340,340,231,121,041,041,173,245,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .byte 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,360,352,242,162,060,060,162,227,337,345,302,245,245,200,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
          .even



                .END


