/* WRITAB.C */
/**************************************************************************
function reads file stdin to EOF and write stdout with table of booker's
pointers to strings in order of book. Receives parameters of booking.
Returns number of tetrades or NULL for insufficient memory or EOF for write 
error.
Uses function page.
**************************************************************************/
#include <stdio.h>
extern char $$FERR;
writab (numstr,numlst,order)

/******************  parametres:  ***************************************/
int	numstr,		/* number of strings in page			*/
	numlst,		/* number of lists (of 4 pages) in tetrade	*/
	order;		/* one of two orders:
			   FALSE - printing by lists
			   TRUE  - first print one side of all lists,
				   second - other side of all lists.	*/
{
/******************  variables:  ****************************************/
register long	*lptr;	/* pointer in table of strings			*/
	 long	*buff;	/* begin table of strings			*/

int	shift1,		/* even step first half of tetrade		*/
	shift2,		/* odd step first half of tetrade		*/
	between,	/* step between halfs of tetrade		*/
	shift3,		/* even step second half of tetrade		*/
	shift4,		/* odd step second half of tetrade		*/
	step=2*numstr,	/* step for move lptr by pages			*/
	half=step*numlst,/* length of one half of table			*/
	lenbuf=half*2*4,/* length of all table				*/
	tptr=1,		/* pointer of tetrades				*/
	lstptr,		/* pointer of lists in tetrade			*/
	eeooff=0;	/* end of file stdin flag			*/
/************************************************************************/

if((buff=lptr=malloc(lenbuf))==NULL) return NULL;

/********************* define of orders :  ******************************/
if (order)
	{
	shift1=  half-1;
	shift2=  -half-step+1;
	between= half-step;
	shift3=  -half-1;
	shift4=  half-step+1;
	}
else	{
	shift1=  step-1;
	shift2=  step+1;
	between= -step;
	shift3=  -step-1;
	shift4=  -step+1;
	}
/***************  main loop write tetrades: *****************************/
do  {
    lptr=buff+1;
    lstptr=numlst;
    do  {
	page (numstr,lptr);
	lptr+=shift1;
	page (numstr,lptr);
	lptr+=shift2;
	}
    while(--lstptr!=0);
    lptr+=between;
    lstptr=numlst;
    do  {
	page (numstr,lptr);
	lptr+=shift1;
	eeooff=page (numstr,lptr);
	lptr+=shift2;
	}
    while(--lstptr!=0);
    if (fwrite(buff,1,lenbuf,stdout)!=lenbuf) {mfree(buff);return EOF;}
    tptr++;
    }
while (eeooff!=EOF);
mfree(buff);
return tptr;
}
            