/*
 * Decompiled with CFR 0.152.
 */
package bk2010.preferences;

import bk2010.preferences.KeyNames;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.TreeSet;

public class KeyMap {
    private HashMap<Integer, MappedKey> keyMap = new HashMap(100);
    private boolean locked = false;
    public static final KeyMap defaultMap;
    public static final KeyMap dumbQWERTYMap;

    static {
        dumbQWERTYMap = new KeyMap(false, null);
        int key = 65;
        while (key <= 90) {
            dumbQWERTYMap.addMapping(key, key, Shift.BOTH);
            ++key;
        }
        key = 48;
        while (key <= 57) {
            dumbQWERTYMap.addMapping(key, key, Shift.BOTH);
            ++key;
        }
        dumbQWERTYMap.addMapping(525, 64, Shift.BOTH);
        dumbQWERTYMap.addMapping(91, 91, Shift.BOTH);
        dumbQWERTYMap.addMapping(93, 93, Shift.BOTH);
        dumbQWERTYMap.addMapping(192, 94, Shift.BOTH);
        dumbQWERTYMap.addMapping(92, 92, Shift.BOTH);
        dumbQWERTYMap.addMapping(222, 95, Shift.BOTH);
        dumbQWERTYMap.addMapping(47, 47, Shift.BOTH);
        dumbQWERTYMap.addMapping(44, 44, Shift.BOTH);
        dumbQWERTYMap.addMapping(46, 46, Shift.BOTH);
        dumbQWERTYMap.addMapping(45, 45, Shift.BOTH);
        dumbQWERTYMap.addMapping(61, 59, Shift.BOTH);
        dumbQWERTYMap.addMapping(59, 58, Shift.BOTH);
        dumbQWERTYMap.addMapping(9, 9, Shift.IGNORE);
        dumbQWERTYMap.addMapping(10, 10, Shift.IGNORE);
        dumbQWERTYMap.addMapping(8, 24, Shift.IGNORE);
        dumbQWERTYMap.addMapping(32, 32, Shift.IGNORE);
        dumbQWERTYMap.addMapping(38, 26, Shift.IGNORE);
        dumbQWERTYMap.addMapping(40, 27, Shift.IGNORE);
        dumbQWERTYMap.addMapping(37, 8, Shift.IGNORE);
        dumbQWERTYMap.addMapping(39, 25, Shift.IGNORE);
        dumbQWERTYMap.addMapping(112, 129, Shift.IGNORE);
        dumbQWERTYMap.addMapping(113, 3, Shift.IGNORE);
        dumbQWERTYMap.addMapping(114, 153, Shift.IGNORE);
        dumbQWERTYMap.addMapping(115, 22, Shift.IGNORE);
        dumbQWERTYMap.addMapping(116, 23, Shift.IGNORE);
        dumbQWERTYMap.addMapping(117, 130, Shift.IGNORE);
        dumbQWERTYMap.addMapping(118, 132, Shift.IGNORE);
        dumbQWERTYMap.addMapping(119, 144, Shift.IGNORE);
        dumbQWERTYMap.addMapping(120, 12, Shift.IGNORE);
        dumbQWERTYMap.addMapping(121, 19, Shift.IGNORE);
        KeyMap.dumbQWERTYMap.locked = true;
        defaultMap = dumbQWERTYMap;
    }

    public KeyMap() {
        this.keyMap.putAll(KeyMap.defaultMap.keyMap);
    }

    public KeyMap(File mapFile) {
        if (mapFile.exists()) {
            try {
                this.readFrom(mapFile);
                return;
            }
            catch (IOException e) {
                this.keyMap.clear();
                this.keyMap.putAll(KeyMap.defaultMap.keyMap);
                return;
            }
        }
        this.keyMap.clear();
        this.keyMap.putAll(KeyMap.defaultMap.keyMap);
        try {
            this.export(mapFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public KeyMap(boolean useDefaultMapping, File mapFile) {
        if (useDefaultMapping) {
            this.keyMap.putAll(KeyMap.defaultMap.keyMap);
        }
        if (mapFile != null && mapFile.exists()) {
            try {
                this.readFrom(mapFile);
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void addMapping(int virtualKey, int bkKey, Shift sh) {
        if (this.locked) {
            return;
        }
        if (bkKey < 32 || bkKey > 127) {
            sh = Shift.IGNORE;
        }
        int normal = -1;
        int shifted = -1;
        Integer boxedVK = virtualKey;
        MappedKey mk = this.keyMap.get(boxedVK);
        if (mk != null) {
            normal = mk.normal;
            shifted = mk.shifted;
        }
        if (sh != Shift.YES) {
            normal = bkKey;
        }
        if (sh == Shift.IGNORE || sh == Shift.YES) {
            shifted = bkKey;
        } else if (sh == Shift.BOTH) {
            shifted = bkKey < 64 ? bkKey ^ 0x10 : bkKey ^ 0x20;
        }
        this.keyMap.put(boxedVK, new MappedKey(normal, shifted));
    }

    public int getMappedKey(int key, boolean isShiftDown) {
        MappedKey mk = this.keyMap.get(key);
        if (mk == null) {
            return -1;
        }
        return isShiftDown ? mk.shifted : mk.normal;
    }

    public void export(File mapFile) throws IOException {
        if (mapFile == null) {
            return;
        }
        FileOutputStream fo = new FileOutputStream(mapFile);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)fo, "8859_1"));
        bw.write("# BK-2010 Emulator keyboard mapping file\n# Shift+key mapping is given after the slash\n# Which shall be padded by spaces\n#\n");
        TreeSet<Integer> allKeys = new TreeSet<Integer>(KeyNames.virtual.getAllKeys());
        for (Integer key : allKeys) {
            String vkName = KeyNames.virtual.nameForKey(key);
            if (vkName == null || vkName.isEmpty()) continue;
            MappedKey mk = this.keyMap.get(key);
            String bkNames = "";
            if (mk != null) {
                bkNames = String.valueOf(KeyNames.bk.safeNameForKey(mk.normal)) + " / " + KeyNames.bk.safeNameForKey(mk.shifted);
            }
            bw.write(String.valueOf(vkName) + " = " + bkNames + "\n");
        }
        bw.close();
        fo.close();
    }

    public boolean readFrom(File mapFile) throws IOException {
        String str;
        FileInputStream fi = new FileInputStream(mapFile);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fi, "8859_1"));
        while ((str = br.readLine()) != null) {
            String vkName;
            int vkValue;
            int vkEnd;
            if ((str = str.trim()).charAt(0) == '#' || (vkEnd = str.indexOf(61)) < 1 || (vkValue = KeyNames.virtual.intKeyForName(vkName = str.substring(0, vkEnd).trim().toUpperCase())) < 0) continue;
            int bkSplit = str.indexOf(" / ", vkEnd + 1);
            if (bkSplit < 0) {
                String bkName = KeyMap.dequoteName(str.substring(vkEnd + 1));
                int bkValue = KeyNames.bk.intKeyForName(bkName);
                if (bkValue < 0) continue;
                this.addMapping(vkValue, bkValue, bkValue >= 64 ? Shift.BOTH : Shift.IGNORE);
                continue;
            }
            String bkName1 = KeyMap.dequoteName(str.substring(vkEnd + 1, bkSplit));
            String bkName2 = KeyMap.dequoteName(str.substring(bkSplit + 3));
            int bkValue1 = KeyNames.bk.intKeyForName(bkName1);
            int bkValue2 = KeyNames.bk.intKeyForName(bkName2);
            if (bkValue1 >= 0) {
                this.addMapping(vkValue, bkValue1, Shift.NO);
            }
            if (bkValue2 < 0) continue;
            this.addMapping(vkValue, bkValue2, Shift.YES);
        }
        br.close();
        fi.close();
        return true;
    }

    private static String dequoteName(String str) {
        str = str.trim();
        int lp = 0;
        int rp = str.length();
        if (rp <= 2) {
            return str;
        }
        if (str.charAt(0) == '\"') {
            ++lp;
        }
        if (str.charAt(rp - 1) == '\"') {
            --rp;
        }
        if (lp >= rp) {
            return "";
        }
        return (str = str.substring(lp, rp)).length() > 1 ? str.toUpperCase() : str;
    }

    public static void main(String[] args) {
        try {
            defaultMap.export(new File("keyboard.ini"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected final class MappedKey {
        public final int normal;
        public final int shifted;

        public MappedKey(int normal, int shifted) {
            this.normal = normal;
            this.shifted = shifted;
        }
    }

    public static enum Shift {
        NO,
        YES,
        BOTH,
        IGNORE;

    }
}

