/*
 * Decompiled with CFR 0.152.
 */
package bk2010.preferences;

import bk2010.preferences.AYModes;
import bk2010.preferences.Afterglow;
import bk2010.preferences.CovoxModes;
import bk2010.preferences.InterpolateWhen;
import bk2010.preferences.MachineBase;
import bk2010.preferences.MonoColor;
import bk2010.preferences.ScreenSizes;
import bk2010.preferences.storage.ConfigFile;
import bk2010.preferences.types.Choice;
import bk2010.preferences.types.Disk;
import bk2010.preferences.types.OnOff;
import bk2010.preferences.types.Tape;
import java.io.File;

public class MachineConfiguration {
    ConfigFile configFile = new ConfigFile(new File("config.ini"));
    public Choice machine = new Choice("Machine type", MachineBase.modes);
    public Choice AY = new Choice("AY-3-8910", AYModes.modes);
    public Choice Covox = new Choice("Covox", CovoxModes.modes);
    public OnOff filterSound = new OnOff("Filter", true);
    public OnOff noSound = new OnOff("No sound");
    public OnOff fakeTape = new OnOff("Tape<->.bin", true);
    public Disk diskA = new Disk("a.img");
    public Disk diskB = new Disk("b.img");
    public Tape readTape = new Tape("in.wav", false);
    public Tape writeTape = new Tape("out.wav", true);
    public Choice screenSize = new Choice("Screen Size", ScreenSizes.modes);
    public Choice interpolateWhen = new Choice("Interpolate when ...", InterpolateWhen.conditions);
    public OnOff multicolor = new OnOff("Multicolor", true);
    public Choice monoColor = new Choice("Monochrome", MonoColor.colors);
    public Choice afterglow = new Choice("Afterglow", Afterglow.frames);
    public OnOff debugger = new OnOff("debugger");
    public boolean doLaunch;

    public MachineConfiguration() {
        this.Covox.select(0);
        this.screenSize.select(5);
        this.monoColor.select(0);
        this.afterglow.select(0);
    }

    public boolean saveToFile() {
        this.machine.saveTo(this.configFile, "general.");
        this.AY.saveTo(this.configFile, "sound.");
        this.Covox.saveTo(this.configFile, "sound.");
        this.filterSound.saveTo(this.configFile, "sound.");
        this.noSound.saveTo(this.configFile, "sound.");
        this.fakeTape.saveTo(this.configFile, "sound.");
        this.diskA.saveTo(this.configFile, "diskA.");
        this.diskB.saveTo(this.configFile, "diskB.");
        this.readTape.saveTo(this.configFile, "readTape.");
        this.writeTape.saveTo(this.configFile, "writeTape.");
        this.screenSize.saveTo(this.configFile, "screen.");
        this.interpolateWhen.saveTo(this.configFile, "screen.");
        this.multicolor.saveTo(this.configFile, "screen.");
        this.monoColor.saveTo(this.configFile, "screen.");
        this.afterglow.saveTo(this.configFile, "screen.");
        this.debugger.saveTo(this.configFile, "general.");
        return this.configFile.writeToDisk();
    }

    public boolean readFromFile() {
        if (!this.configFile.readFromDisk()) {
            return false;
        }
        this.machine.readFrom(this.configFile, "general.");
        this.AY.readFrom(this.configFile, "sound.");
        this.Covox.readFrom(this.configFile, "sound.");
        this.filterSound.readFrom(this.configFile, "sound.");
        this.noSound.readFrom(this.configFile, "sound.");
        this.fakeTape.readFrom(this.configFile, "sound.");
        this.diskA.readFrom(this.configFile, "diskA.");
        this.diskB.readFrom(this.configFile, "diskB.");
        this.readTape.readFrom(this.configFile, "readTape.");
        this.writeTape.readFrom(this.configFile, "writeTape.");
        this.screenSize.readFrom(this.configFile, "screen.");
        this.interpolateWhen.readFrom(this.configFile, "screen.");
        this.multicolor.readFrom(this.configFile, "screen.");
        this.monoColor.readFrom(this.configFile, "screen.");
        this.afterglow.readFrom(this.configFile, "screen.");
        this.debugger.readFrom(this.configFile, "general.");
        return true;
    }
}

