/*
 * Decompiled with CFR 0.152.
 */
package bk2010.preferences.types;

import bk2010.preferences.storage.ConfigFile;
import bk2010.preferences.storage.Setting;
import java.util.Arrays;

public class Choice
implements Cloneable {
    public final String subject;
    public final String[] choices;
    private int selected;

    public Choice(String name, String[] choices) {
        this.subject = name;
        this.choices = choices;
        this.selected = choices.length - 1;
    }

    public String[] strings() {
        return this.choices;
    }

    public void select(int n) {
        if (n >= 0 && n < this.choices.length) {
            this.selected = n;
        }
    }

    public boolean select(String str) {
        str = str.trim();
        int i = 0;
        while (i < this.choices.length) {
            String choice = this.choices[i].trim();
            if (choice.equalsIgnoreCase(str)) {
                this.selected = i;
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getSelected() {
        return this.selected;
    }

    public String getSelectedName() {
        return this.choices[this.selected];
    }

    public void saveTo(ConfigFile cf, String prefix) {
        String fullName = String.valueOf(prefix) + this.subject;
        Setting s = cf.getSetting(fullName);
        s = s == null ? new Setting(fullName, this.getSelectedName(), "") : new Setting(s.name, this.getSelectedName(), s.comments);
        cf.setSetting(s);
    }

    public void readFrom(ConfigFile cf, String prefix) {
        String fullName = String.valueOf(prefix) + this.subject;
        Setting s = cf.getSetting(fullName);
        if (s == null || s.value.isEmpty()) {
            return;
        }
        if (!this.select(s.value)) {
            System.out.println("Unknown value " + s.value + " for configuration setting " + fullName);
        }
    }

    public Choice clone() {
        Choice tmp = new Choice(this.subject, this.choices);
        tmp.selected = this.selected;
        return tmp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.choices);
        result = 31 * result + this.selected;
        result = 31 * result + (this.subject == null ? 0 : this.subject.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Choice other = (Choice)obj;
        if (!Arrays.equals(this.choices, other.choices)) {
            return false;
        }
        if (this.selected != other.selected) {
            return false;
        }
        return !(this.subject == null ? other.subject != null : !this.subject.equals(other.subject));
    }
}

