/*
 * Decompiled with CFR 0.152.
 */
package bk2010.sound;

import bk2010.hardware.Timed;
import bk2010.sound.StreamOutput;
import java.util.Arrays;

public final class SoundRenderer {
    private StreamOutput so;
    private Timed ts;
    private float cps;
    private static final int BUF_SIZE = 16384;
    private static final int BUF_MASK = 16383;
    private byte[] buf = new byte[16384];
    private int head = 0;
    private int tail = 0;
    private long lastUpdate;
    private float subSampleOffset = 0.0f;
    private static final float SND_ON = 144.0f;
    private static final float SND_OFF = 112.0f;
    private float acc = 0.0f;
    private float val = 112.0f;

    public SoundRenderer(StreamOutput output, Timed timeSource, float cyclesPerSample) {
        this.so = output;
        this.ts = timeSource;
        this.cps = cyclesPerSample;
        Arrays.fill(this.buf, (byte)-128);
        this.lastUpdate = this.ts.getCycles();
    }

    public void catchUp() {
        float rem;
        long cycles = this.ts.getCycles();
        float step = cycles - this.lastUpdate;
        if (step < (rem = this.cps - this.subSampleOffset)) {
            this.acc += this.val * step;
            this.subSampleOffset += step;
            return;
        }
        this.acc += this.val * rem;
        this.buf[this.head] = (byte)(this.acc / this.cps);
        this.head = this.head + 1 & 0x3FFF;
        step -= rem;
        this.subSampleOffset = 0.0f;
        this.acc = 0.0f;
        while (step >= this.cps) {
            this.buf[this.head] = (byte)this.val;
            this.head = this.head + 1 & 0x3FFF;
            step -= this.cps;
        }
        this.acc = this.val * step;
        this.subSampleOffset = step;
        this.lastUpdate = cycles;
    }

    public void updateBit(int maskedVal) {
        this.catchUp();
        this.val = maskedVal == 0 ? 112.0f : 144.0f;
    }

    public void push() {
        this.catchUp();
        if (this.head == this.tail) {
            return;
        }
        if (this.head < this.tail) {
            this.so.pushSamples(this.buf, this.tail, 16384 - this.tail);
            if (this.head > 0) {
                this.so.pushSamples(this.buf, 0, this.head);
            }
        } else {
            this.so.pushSamples(this.buf, this.tail, this.head - this.tail);
        }
        this.tail = this.head;
    }
}

