/*
 * Decompiled with CFR 0.152.
 */
package bk2010.sound;

import bk2010.sound.NoSoundException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public final class StreamOutput {
    private static final AudioFormat af = new AudioFormat(48000.0f, 8, 1, false, false);
    private SourceDataLine line;

    public StreamOutput() throws NoSoundException {
        try {
            this.line = AudioSystem.getSourceDataLine(af);
            this.line.open(af, 24000);
        }
        catch (LineUnavailableException e) {
            throw new NoSoundException();
        }
        this.line.start();
    }

    public void pushSamples(byte[] buf, int off, int len) {
        if (!this.line.isRunning()) {
            System.out.append('$');
        }
        this.line.write(buf, off, len);
    }

    public long timeMillis() {
        return this.line.getMicrosecondPosition() / 1000L;
    }

    public static void main(String[] args) throws NoSoundException, LineUnavailableException {
        byte[] abuf = new byte[9600];
        int i = 0;
        while (i < 9600) {
            abuf[i] = (byte)((Math.abs(i / 5) & 0x3F) + 128 - 32);
            ++i;
        }
        StreamOutput os = new StreamOutput();
        while (true) {
            os.pushSamples(abuf, 0, 9600);
        }
    }
}

