/*
 * Decompiled with CFR 0.152.
 */
package bk2010.hardware.cpu;

import bk2010.hardware.BaseBK0010;
import bk2010.hardware.TimeSource;
import bk2010.hardware.Timed;
import bk2010.hardware.bus.QBusError;
import bk2010.hardware.bus.QBusProxy;
import bk2010.hardware.cpu.Disasm;
import bk2010.io.FakeTape;
import java.io.IOException;

public final class K1801VM1
implements TimeSource,
Timed {
    public short[] regs;
    public short psw;
    public QBusProxy machine;
    public static final int SP = 6;
    public static final int PC = 7;
    public static final int OLDPC = 8;
    public static final short FLAG_I = 64;
    public static final short FLAG_T = 16;
    public static final short FLAG_N = 8;
    public static final short FLAG_Z = 4;
    public static final short FLAG_V = 2;
    public static final short FLAG_C = 1;
    public static final short FLAGS_NZVC = 15;
    public boolean trace = false;
    public static final int OP_UNKNOWN = 0;
    public static final int OP_ILLEGAL = 1;
    public static final int OP_DUMMY = 2;
    public static final int OP_HALT = 3;
    public static final int OP_WAIT = 4;
    public static final int OP_RTI = 5;
    public static final int OP_BPT = 6;
    public static final int OP_IOT = 7;
    public static final int OP_RESET = 8;
    public static final int OP_RTT = 9;
    public static final int OP_START = 10;
    public static final int OP_STEP = 11;
    public static final int OP_JMP = 12;
    public static final int OP_RTS = 13;
    public static final int OP_SCC = 14;
    public static final int OP_CCC = 15;
    public static final int OP_SWAB = 16;
    public static final int OP_BR = 17;
    public static final int OP_BNE = 18;
    public static final int OP_BEQ = 19;
    public static final int OP_BGE = 20;
    public static final int OP_BLT = 21;
    public static final int OP_BGT = 22;
    public static final int OP_BLE = 23;
    public static final int OP_JSR = 24;
    public static final int OP_CLR = 25;
    public static final int OP_COM = 26;
    public static final int OP_INC = 27;
    public static final int OP_DEC = 28;
    public static final int OP_NEG = 29;
    public static final int OP_ADC = 30;
    public static final int OP_SBC = 31;
    public static final int OP_TST = 32;
    public static final int OP_ROR = 33;
    public static final int OP_ROL = 34;
    public static final int OP_ASR = 35;
    public static final int OP_ASL = 36;
    public static final int OP_MARK = 37;
    public static final int OP_SXT = 38;
    public static final int OP_MOV = 39;
    public static final int OP_CMP = 40;
    public static final int OP_BIT = 41;
    public static final int OP_BIC = 42;
    public static final int OP_BIS = 43;
    public static final int OP_ADD = 44;
    public static final int OP_XOR = 45;
    public static final int OP_SOB = 46;
    public static final int OP_BPL = 47;
    public static final int OP_BMI = 48;
    public static final int OP_BHI = 49;
    public static final int OP_BLOS = 50;
    public static final int OP_BVC = 51;
    public static final int OP_BVS = 52;
    public static final int OP_BCC = 53;
    public static final int OP_BCS = 54;
    public static final int OP_EMT = 55;
    public static final int OP_TRAP = 56;
    public static final int OP_CLRB = 57;
    public static final int OP_COMB = 58;
    public static final int OP_INCB = 59;
    public static final int OP_DECB = 60;
    public static final int OP_NEGB = 61;
    public static final int OP_ADCB = 62;
    public static final int OP_SBCB = 63;
    public static final int OP_TSTB = 64;
    public static final int OP_RORB = 65;
    public static final int OP_ROLB = 66;
    public static final int OP_ASRB = 67;
    public static final int OP_ASLB = 68;
    public static final int OP_MTPS = 69;
    public static final int OP_MFPS = 70;
    public static final int OP_MOVB = 71;
    public static final int OP_CMPB = 72;
    public static final int OP_BITB = 73;
    public static final int OP_BICB = 74;
    public static final int OP_BISB = 75;
    public static final int OP_SUB = 76;
    public static final int OP_COUNT = 77;
    protected static final int[] opdec = new int[65536];
    public static final int MASK_2OP = 61440;
    public static final int MASK_2OPR = 65024;
    public static final int MASK_1OP = 65472;
    public static final int MASK_BRANCH = 65280;
    public static final int MASK_COND = 65520;
    public static final int MASK_1OPR = 65528;
    public static final int MASK_ALL = 65535;
    protected CPUState state = CPUState.BOGUS;
    protected short intvector;
    protected long spentCycles = 0L;
    static final int[] eaMemCycles;

    static {
        int[] nArray = new int[8];
        nArray[1] = 12;
        nArray[2] = 12;
        nArray[3] = 20;
        nArray[4] = 12;
        nArray[5] = 20;
        nArray[6] = 20;
        nArray[7] = 28;
        eaMemCycles = nArray;
        K1801VM1.register_opcode(0, 0, 1);
        K1801VM1.register_opcode(0, 65535, 3);
        K1801VM1.register_opcode(1, 65535, 4);
        K1801VM1.register_opcode(2, 65535, 5);
        K1801VM1.register_opcode(3, 65535, 6);
        K1801VM1.register_opcode(4, 65535, 7);
        K1801VM1.register_opcode(5, 65535, 8);
        K1801VM1.register_opcode(6, 65535, 9);
        K1801VM1.register_opcode(64, 65472, 12);
        K1801VM1.register_opcode(128, 65528, 13);
        K1801VM1.register_opcode(160, 65520, 15);
        K1801VM1.register_opcode(176, 65520, 14);
        K1801VM1.register_opcode(192, 65472, 16);
        K1801VM1.register_opcode(256, 65280, 17);
        K1801VM1.register_opcode(512, 65280, 18);
        K1801VM1.register_opcode(768, 65280, 19);
        K1801VM1.register_opcode(1024, 65280, 20);
        K1801VM1.register_opcode(1280, 65280, 21);
        K1801VM1.register_opcode(1536, 65280, 22);
        K1801VM1.register_opcode(1792, 65280, 23);
        K1801VM1.register_opcode(2048, 65024, 24);
        K1801VM1.register_opcode(2560, 65472, 25);
        K1801VM1.register_opcode(2624, 65472, 26);
        K1801VM1.register_opcode(2688, 65472, 27);
        K1801VM1.register_opcode(2752, 65472, 28);
        K1801VM1.register_opcode(2816, 65472, 29);
        K1801VM1.register_opcode(2880, 65472, 30);
        K1801VM1.register_opcode(2944, 65472, 31);
        K1801VM1.register_opcode(3008, 65472, 32);
        K1801VM1.register_opcode(3072, 65472, 33);
        K1801VM1.register_opcode(3136, 65472, 34);
        K1801VM1.register_opcode(3200, 65472, 35);
        K1801VM1.register_opcode(3264, 65472, 36);
        K1801VM1.register_opcode(3328, 65472, 37);
        K1801VM1.register_opcode(3520, 65472, 38);
        K1801VM1.register_opcode(4096, 61440, 39);
        K1801VM1.register_opcode(8192, 61440, 40);
        K1801VM1.register_opcode(12288, 61440, 41);
        K1801VM1.register_opcode(16384, 61440, 42);
        K1801VM1.register_opcode(20480, 61440, 43);
        K1801VM1.register_opcode(24576, 61440, 44);
        K1801VM1.register_opcode(30720, 65024, 45);
        K1801VM1.register_opcode(32256, 65024, 46);
        K1801VM1.register_opcode(32768, 65280, 47);
        K1801VM1.register_opcode(33024, 65280, 48);
        K1801VM1.register_opcode(33280, 65280, 49);
        K1801VM1.register_opcode(33536, 65280, 50);
        K1801VM1.register_opcode(33792, 65280, 51);
        K1801VM1.register_opcode(34048, 65280, 52);
        K1801VM1.register_opcode(34304, 65280, 53);
        K1801VM1.register_opcode(34560, 65280, 54);
        K1801VM1.register_opcode(34816, 65280, 55);
        K1801VM1.register_opcode(35072, 65280, 56);
        K1801VM1.register_opcode(35328, 65472, 57);
        K1801VM1.register_opcode(35392, 65472, 58);
        K1801VM1.register_opcode(35456, 65472, 59);
        K1801VM1.register_opcode(35520, 65472, 60);
        K1801VM1.register_opcode(35584, 65472, 61);
        K1801VM1.register_opcode(35648, 65472, 62);
        K1801VM1.register_opcode(35712, 65472, 63);
        K1801VM1.register_opcode(35776, 65472, 64);
        K1801VM1.register_opcode(35840, 65472, 65);
        K1801VM1.register_opcode(35904, 65472, 66);
        K1801VM1.register_opcode(35968, 65472, 67);
        K1801VM1.register_opcode(36032, 65472, 68);
        K1801VM1.register_opcode(36096, 65472, 69);
        K1801VM1.register_opcode(36288, 65472, 70);
        K1801VM1.register_opcode(36864, 61440, 71);
        K1801VM1.register_opcode(40960, 61440, 72);
        K1801VM1.register_opcode(45056, 61440, 73);
        K1801VM1.register_opcode(49152, 61440, 74);
        K1801VM1.register_opcode(53248, 61440, 75);
        K1801VM1.register_opcode(57344, 61440, 76);
    }

    public K1801VM1(QBusProxy memorymodel) {
        this.regs = new short[9];
        this.machine = memorymodel;
    }

    public K1801VM1() throws IOException {
        this.regs = new short[9];
        this.machine = new BaseBK0010();
    }

    protected void note(String what) {
        System.out.println(what);
    }

    protected void noteReg(int regNum) {
        this.note(String.valueOf(Disasm.regnames[regNum]) + " <= " + Integer.toOctalString(this.regs[regNum] & 0xFFFF));
    }

    @Override
    public final void cycles(long howMany) {
        this.spentCycles += howMany;
    }

    @Override
    public final long getCycles() {
        return this.spentCycles;
    }

    public void reset() {
        this.note("CPU reset\n");
        this.machine.reset();
        this.psw = (short)224;
        try {
            this.regs[7] = (short)(this.machine.readWord((short)-50) & 0xFF00);
        }
        catch (QBusError e) {
            this.regs[7] = -1;
        }
        this.state = CPUState.NORMAL;
    }

    protected final boolean N() {
        return (this.psw & 8) != 0;
    }

    protected final boolean Z() {
        return (this.psw & 4) != 0;
    }

    protected final boolean V() {
        return (this.psw & 2) != 0;
    }

    protected final boolean C() {
        return (this.psw & 1) != 0;
    }

    protected final void setNZVC(boolean n, boolean z, boolean v, boolean c) {
        this.psw = (short)(this.psw & 0xFFFFFFF0 | (n ? 8 : 0) | (z ? 4 : 0) | (v ? 2 : 0) | (c ? 1 : 0));
    }

    protected final void setNZByWordValue(int value, boolean clear, int also_set) {
        int newpsw = clear ? this.psw & 0xFFFFFFF0 : this.psw & 0xFFFFFFF3;
        if ((value & 0x8000) != 0) {
            newpsw |= 8;
        }
        if ((value & 0xFFFF) == 0) {
            newpsw |= 4;
        }
        this.psw = (short)(newpsw | also_set);
    }

    protected final void setNZVCByWordValue(int value, boolean carry) {
        int newpsw = this.psw & 0xFFFFFFF0;
        newpsw = (value & 0x8000) != 0 ? (newpsw |= 8 | (carry ? 0 : 2)) : (newpsw |= carry ? 2 : 0);
        if ((value & 0xFFFF) == 0) {
            newpsw |= 4;
        }
        if (carry) {
            newpsw |= 1;
        }
        this.psw = (short)newpsw;
    }

    protected final void setNZByByteValue(int value, boolean clear, int also_set) {
        int newpsw = clear ? this.psw & 0xFFFFFFF0 : this.psw & 0xFFFFFFF3;
        if ((value & 0x80) != 0) {
            newpsw |= 8;
        }
        if ((value & 0xFF) == 0) {
            newpsw |= 4;
        }
        this.psw = (short)(newpsw | also_set);
    }

    protected final void setNZVCByByteValue(int value, boolean carry) {
        int newpsw = this.psw & 0xFFFFFFF0;
        newpsw = (value & 0x80) != 0 ? (newpsw |= 8 | (carry ? 0 : 2)) : (newpsw |= carry ? 2 : 0);
        if ((value & 0xFF) == 0) {
            newpsw |= 4;
        }
        if (carry) {
            newpsw |= 1;
        }
        this.psw = (short)newpsw;
    }

    protected final short genEA(int mmode, boolean byteaccess) throws QBusError {
        int reg = mmode & 7;
        int mode = mmode >> 3 & 7;
        short ea = this.regs[reg];
        this.cycles(eaMemCycles[mode]);
        switch (mode) {
            case 0: {
                return -1;
            }
            case 1: {
                return ea;
            }
            case 2: {
                if (reg == 7 || reg == 6) {
                    ea = (short)(ea & 0xFFFFFFFE);
                    int n = reg;
                    this.regs[n] = (short)(this.regs[n] + 2);
                } else {
                    int n = reg;
                    this.regs[n] = (short)(this.regs[n] + (!byteaccess ? 2 : 1));
                }
                return ea;
            }
            case 3: {
                int n = reg;
                this.regs[n] = (short)(this.regs[n] + 2);
                return this.machine.readWord(ea);
            }
            case 4: {
                if (reg == 7 || reg == 6) {
                    int n = reg;
                    short s = (short)(this.regs[n] - 2);
                    this.regs[n] = s;
                    ea = (short)(s & 0xFFFFFFFE);
                } else {
                    int n = reg;
                    short s = (short)(this.regs[n] - (!byteaccess ? 2 : 1));
                    this.regs[n] = s;
                    ea = s;
                }
                return ea;
            }
            case 5: {
                int n = reg;
                short s = (short)(this.regs[n] - 2);
                this.regs[n] = s;
                ea = s;
                return this.machine.readWord(ea);
            }
            case 6: {
                ea = this.machine.readWord(this.regs[7]);
                this.regs[7] = (short)(this.regs[7] + 2);
                ea = (short)(ea + this.regs[reg]);
                return ea;
            }
            case 7: {
                ea = this.machine.readWord(this.regs[7]);
                this.regs[7] = (short)(this.regs[7] + 2);
                ea = (short)(ea + this.regs[reg]);
                return this.machine.readWord(ea);
            }
        }
        return -1;
    }

    protected void trap(int vector) {
        this.state = CPUState.INT;
        this.intvector = (short)(vector & 0xFF);
    }

    public void nmi() {
        this.regs[8] = this.regs[7] = (short)(this.regs[7] + 2);
        this.trap(4);
    }

    protected void exec_1op_word(short insn, int opcode) throws QBusError {
        int dst;
        int dd = insn & 0x3F;
        short ea = 0;
        int src = 0;
        int setflags = 0;
        boolean carry = false;
        if (dd <= 7) {
            src = this.regs[dd] & 0xFFFF;
        } else {
            ea = this.genEA(dd, false);
            if (opcode != 25) {
                src = this.machine.readWord(ea) & 0xFFFF;
            }
        }
        switch (opcode) {
            case 16: {
                dst = (src & 0xFF) << 8 | (src & 0xFF00) >> 8;
                this.setNZByByteValue(dst, true, 0);
                break;
            }
            case 25: {
                dst = 0;
                this.setNZByWordValue(dst, true, 0);
                break;
            }
            case 26: {
                dst = ~src;
                this.setNZByWordValue(dst, true, 1);
                break;
            }
            case 27: {
                setflags = this.psw & 1;
                dst = src + 1;
                if (src == Short.MAX_VALUE) {
                    setflags |= 2;
                }
                this.setNZByWordValue(dst, true, setflags);
                break;
            }
            case 28: {
                setflags = this.psw & 1;
                dst = src - 1;
                if (src == 32768) {
                    setflags |= 2;
                }
                this.setNZByWordValue(dst, true, setflags);
                break;
            }
            case 29: {
                dst = -src;
                if (src == 32768) {
                    setflags |= 2;
                }
                if (src != 0) {
                    setflags |= 1;
                }
                this.setNZByWordValue(dst, true, setflags);
                break;
            }
            case 30: {
                if (this.C()) {
                    if (src == Short.MAX_VALUE) {
                        setflags = 2;
                    }
                    if (src == 65535) {
                        setflags |= 1;
                    }
                    dst = src + 1;
                } else {
                    dst = src;
                }
                this.setNZByWordValue(dst, true, setflags);
                break;
            }
            case 31: {
                if (this.C()) {
                    if (src == 32768) {
                        setflags = 2;
                    }
                    if (src == 0) {
                        setflags |= 1;
                    }
                    dst = src - 1;
                } else {
                    dst = src;
                }
                this.setNZByWordValue(dst, true, setflags);
                break;
            }
            case 32: {
                int dst2 = src;
                this.setNZByWordValue(dst2, true, 0);
                return;
            }
            case 33: {
                carry = (src & 1) != 0;
                dst = src >> 1 & Short.MAX_VALUE;
                if (this.C()) {
                    dst |= 0x8000;
                }
                this.setNZVCByWordValue(dst, carry);
                break;
            }
            case 34: {
                carry = (src & 0x8000) != 0;
                dst = src << 1 & 0xFFFE;
                if (this.C()) {
                    dst |= 1;
                }
                this.setNZVCByWordValue(dst, carry);
                break;
            }
            case 35: {
                carry = (src & 1) != 0;
                dst = src >> 1 | src & 0x8000;
                this.setNZVCByWordValue(dst, carry);
                break;
            }
            case 36: {
                carry = (src & 0x8000) != 0;
                dst = src << 1;
                this.setNZVCByWordValue(dst, carry);
                break;
            }
            case 38: {
                if (this.N()) {
                    dst = 65535;
                    this.psw = (short)(this.psw & 0xFFFFFFF9);
                    break;
                }
                dst = 0;
                this.psw = (short)(this.psw & 0xFFFFFFFD | 4);
                break;
            }
            default: {
                this.note("Tried to execute unsupported 1-op insn (this shouldn't happen)\n");
                this.trap(8);
                return;
            }
        }
        if (dd <= 7) {
            this.regs[dd] = (short)dst;
            if (this.trace) {
                this.noteReg(dd);
            }
        } else {
            this.cycles(4L);
            this.machine.writeWord(ea, (short)dst);
        }
    }

    protected void exec_1op_byte(short insn, int opcode) throws QBusError {
        int dst;
        int dd = insn & 0x3F;
        short ea = 0;
        int src = 0;
        int setflags = 0;
        boolean carry = false;
        if (dd <= 7) {
            src = this.regs[dd] & 0xFF;
        } else {
            ea = this.genEA(dd, true);
            if (opcode != 57 && opcode != 70) {
                src = this.machine.readByte(ea) & 0xFF;
            }
        }
        switch (opcode) {
            case 69: {
                if (this.trace && (src & 0xFFFFFF10) != 0) {
                    this.note("MTPS: attempt to set unsupported bit(s)");
                }
                this.psw = (short)(this.psw & 0xFFFFFF10 | src & 0xEF);
                return;
            }
            case 70: {
                dst = (byte)this.psw;
                this.setNZByByteValue(dst, true, this.psw & 1);
                if (dd > 7) break;
                this.regs[dd] = (short)dst;
                return;
            }
            case 57: {
                dst = 0;
                this.setNZByByteValue(dst, true, 0);
                break;
            }
            case 58: {
                dst = ~src;
                this.setNZByByteValue(dst, true, 1);
                break;
            }
            case 59: {
                setflags = this.psw & 1;
                dst = src + 1;
                if (src == 127) {
                    setflags |= 2;
                }
                this.setNZByByteValue(dst, true, setflags);
                break;
            }
            case 60: {
                setflags = this.psw & 1;
                dst = src - 1;
                if (src == 128) {
                    setflags |= 2;
                }
                this.setNZByByteValue(dst, true, setflags);
                break;
            }
            case 61: {
                dst = -src;
                if (src == 128) {
                    setflags |= 2;
                }
                if (src != 0) {
                    setflags |= 1;
                }
                this.setNZByByteValue(dst, true, setflags);
                break;
            }
            case 62: {
                if (this.C()) {
                    if (src == 127) {
                        setflags = 2;
                    }
                    if (src == 255) {
                        setflags |= 1;
                    }
                    dst = src + 1;
                } else {
                    dst = src;
                }
                this.setNZByByteValue(dst, true, setflags);
                break;
            }
            case 63: {
                if (this.C()) {
                    if (src == 128) {
                        setflags = 2;
                    }
                    if (src == 0) {
                        setflags |= 1;
                    }
                    dst = src - 1;
                } else {
                    dst = src;
                }
                this.setNZByByteValue(dst, true, setflags);
                break;
            }
            case 64: {
                int dst2 = src;
                this.setNZByByteValue(dst2, true, 0);
                return;
            }
            case 65: {
                carry = (src & 1) != 0;
                dst = src >> 1 & 0x7F;
                if (this.C()) {
                    dst |= 0x80;
                }
                this.setNZVCByByteValue(dst, carry);
                break;
            }
            case 66: {
                carry = (src & 0x80) != 0;
                dst = src << 1 & 0xFE;
                if (this.C()) {
                    dst |= 1;
                }
                this.setNZVCByByteValue(dst, carry);
                break;
            }
            case 67: {
                carry = (src & 1) != 0;
                dst = src >> 1 | src & 0x80;
                this.setNZVCByByteValue(dst, carry);
                break;
            }
            case 68: {
                carry = (src & 0x80) != 0;
                dst = src << 1;
                this.setNZVCByByteValue(dst, carry);
                break;
            }
            default: {
                this.note("Tried to execute unsupported 1-op insn (this shouldn't happen)\n");
                this.trap(8);
                return;
            }
        }
        if (dd <= 7) {
            this.regs[dd] = (short)(this.regs[dd] & 0xFF00 | dst & 0xFF);
            if (this.trace) {
                this.noteReg(dd);
            }
        } else {
            this.cycles(4L);
            this.machine.writeByte(ea, (byte)dst);
        }
    }

    protected void exec_2op_word(short insn, int opcode) throws QBusError {
        int ss = (insn & 0xFC0) >> 6;
        int dd = insn & 0x3F;
        short ea = 0;
        int dst = 0;
        boolean samesign = false;
        int src = ss <= 7 ? this.regs[ss] & 0xFFFF : this.machine.readWord(this.genEA(ss, false)) & 0xFFFF;
        if (dd <= 7) {
            dst = this.regs[dd] & 0xFFFF;
        } else {
            ea = this.genEA(dd, false);
            if (opcode != 39) {
                dst = this.machine.readWord(ea) & 0xFFFF;
            }
        }
        switch (opcode) {
            case 39: {
                dst = src;
                this.setNZByWordValue(src, true, this.psw & 1);
                break;
            }
            case 40: {
                int setflags;
                samesign = ((dst ^ src) & 0x8000) == 0;
                src = src + 1 + (dst ^ 0xFFFF);
                int n = setflags = !samesign && ((dst ^ src) & 0x8000) == 0 ? 2 : 0;
                if ((src & 0x10000) == 0) {
                    setflags |= 1;
                }
                this.setNZByWordValue(src, true, setflags);
                if (ss <= 7) {
                    this.cycles(8L);
                }
                return;
            }
            case 41: {
                this.setNZByWordValue(dst &= src, true, this.psw & 1);
                if (ss <= 7) {
                    this.cycles(8L);
                }
                return;
            }
            case 42: {
                this.setNZByWordValue(dst &= ~src, true, this.psw & 1);
                break;
            }
            case 43: {
                this.setNZByWordValue(dst |= src, true, this.psw & 1);
                break;
            }
            case 44: {
                int setflags;
                samesign = ((dst ^ src) & 0x8000) == 0;
                dst = src + dst;
                int n = setflags = samesign && ((dst ^ src) & 0x8000) != 0 ? 2 : 0;
                if ((dst & 0x10000) != 0) {
                    setflags |= 1;
                }
                this.setNZByWordValue(dst, true, setflags);
                break;
            }
            case 76: {
                int setflags;
                samesign = ((dst ^ src) & 0x8000) == 0;
                dst = dst + 1 + (src ^ 0xFFFF);
                int n = setflags = !samesign && ((dst ^ src) & 0x8000) == 0 ? 2 : 0;
                if ((dst & 0x10000) == 0) {
                    setflags |= 1;
                }
                this.setNZByWordValue(dst, true, setflags);
                break;
            }
            default: {
                this.note("Tried to execute unsupported 2-op insn (this shouldn't happen)\n");
                this.trap(8);
                return;
            }
        }
        if (dd <= 7) {
            this.regs[dd] = (short)dst;
            if (this.trace) {
                this.noteReg(dd);
            }
        } else {
            if (ss <= 7) {
                this.cycles(8L);
            } else {
                this.cycles(4L);
            }
            this.machine.writeWord(ea, (short)dst);
        }
    }

    protected void exec_2op_byte(short insn, int opcode) throws QBusError {
        int ss = (insn & 0xFC0) >> 6;
        int dd = insn & 0x3F;
        short ea = 0;
        int dst = 0;
        int src = ss <= 7 ? this.regs[ss] & 0xFF : this.machine.readByte(this.genEA(ss, true)) & 0xFF;
        if (dd <= 7) {
            dst = this.regs[dd] & 0xFF;
        } else {
            ea = this.genEA(dd, true);
            if (opcode != 71) {
                dst = this.machine.readByte(ea) & 0xFF;
            }
        }
        switch (opcode) {
            case 71: {
                dst = src;
                this.setNZByByteValue(dst, true, this.psw & 1);
                if (dd > 7) break;
                this.regs[dd] = (byte)src;
                if (this.trace) {
                    this.noteReg(dd);
                }
                this.cycles(8L);
                return;
            }
            case 72: {
                int setflags;
                boolean samesign = ((dst ^ src) & 0x80) == 0;
                src = src + 1 + (dst ^ 0xFF);
                int n = setflags = !samesign && ((dst ^ src) & 0x80) == 0 ? 2 : 0;
                if ((src & 0x100) == 0) {
                    setflags |= 1;
                }
                this.setNZByByteValue(src, true, setflags);
                if (ss <= 7) {
                    this.cycles(8L);
                }
                return;
            }
            case 73: {
                this.setNZByByteValue(dst &= src, true, this.psw & 1);
                if (ss <= 7) {
                    this.cycles(8L);
                }
                return;
            }
            case 74: {
                this.setNZByByteValue(dst &= ~src, true, this.psw & 1);
                break;
            }
            case 75: {
                this.setNZByByteValue(dst |= src, true, this.psw & 1);
                break;
            }
            default: {
                this.note("Tried to execute unsupported 2-op insn (this shouldn't happen)\n");
                this.trap(8);
                return;
            }
        }
        if (dd <= 7) {
            this.regs[dd] = (short)(this.regs[dd] & 0xFF00 | dst & 0xFF);
            if (this.trace) {
                this.noteReg(dd);
            }
        } else {
            if (ss <= 7) {
                this.cycles(8L);
            } else {
                this.cycles(4L);
            }
            this.machine.writeByte(ea, (byte)dst);
        }
    }

    protected void take_branch(short insn, boolean condition) {
        this.cycles(4L);
        if (this.trace) {
            this.note(String.valueOf(this.N() ? "N" : " ") + (this.Z() ? "Z" : " ") + (this.V() ? "V" : " ") + (this.C() ? "C" : " ") + (condition ? " (taken)" : " (NOT taken)"));
        }
        if (!condition) {
            return;
        }
        short offset = (byte)insn;
        this.regs[7] = (short)(this.regs[7] + offset * 2);
    }

    protected void exec_mark(short insn) throws QBusError {
        this.cycles(24L);
        this.regs[6] = (short)(this.regs[7] + 2 * (insn & 0x3F));
        this.regs[7] = this.regs[5];
        this.regs[5] = this.machine.readWord(this.regs[6]);
        this.regs[6] = (short)(this.regs[6] + 2);
    }

    protected void exec_xor(short insn) throws QBusError {
        int dst;
        int dd = insn & 0x3F;
        short ea = 0;
        short src = this.regs[(insn & 0x1C0) >> 6];
        if (dd <= 7) {
            dst = this.regs[dd] & 0xFFFF;
        } else {
            ea = this.genEA(dd, false);
            dst = this.machine.readWord(ea) & 0xFFFF;
            this.cycles(8L);
        }
        this.setNZByWordValue(dst ^= src, true, this.psw & 1);
        if (dd <= 7) {
            this.regs[dd] = (short)dst;
        } else {
            this.machine.writeWord(ea, (short)dst);
        }
    }

    public void exec_insn() {
        short insn;
        this.regs[8] = this.regs[7];
        if (this.state == CPUState.BOGUS) {
            return;
        }
        if (this.state == CPUState.INT) {
            short tmp = (short)(this.intvector & 0xFFFFFFFC);
            try {
                if (this.trace) {
                    this.note("trap to " + Integer.toOctalString(tmp));
                }
                this.regs[6] = (short)(this.regs[6] - 2);
                this.machine.writeWord(this.regs[6], this.psw);
                this.regs[6] = (short)(this.regs[6] - 2);
                this.machine.writeWord(this.regs[6], this.regs[7]);
                this.regs[7] = this.machine.readWord(tmp);
                this.psw = this.machine.readWord((short)(tmp + 2));
                if (this.trace) {
                    this.note("New PC is " + Integer.toOctalString(this.regs[7] & 0xFFFF) + ", PSW is " + Integer.toOctalString(this.psw & 0xFFFF));
                }
                this.state = CPUState.NORMAL;
                return;
            }
            catch (QBusError e) {
                this.trap(4);
                return;
            }
        }
        if ((this.regs[7] & 0xFFFF) == 39998) {
            try {
                FakeTape.fakeTape(this.machine, this.regs);
            }
            catch (QBusError e) {
                this.trap(4);
            }
            return;
        }
        if ((this.psw & 0x80) == 0 && this.machine.gotInterrupt()) {
            this.cycles(56L);
            this.trap(this.machine.interruptVector());
            return;
        }
        if (this.state == CPUState.WAIT) {
            this.cycles(12L);
            return;
        }
        if (this.state == CPUState.RTT) {
            this.state = CPUState.NORMAL;
        } else if ((this.psw & 0x10) != 0) {
            if (this.trace) {
                this.note("trace");
            }
            this.trap(12);
            return;
        }
        if (this.trace) {
            this.note(Disasm.disasm(this.machine, this.regs[7]));
        }
        try {
            insn = this.machine.readWord(this.regs[7]);
            this.regs[7] = (short)(this.regs[7] + 2);
        }
        catch (QBusError e) {
            if (this.trace) {
                this.note("Error reading insn at address " + Integer.toOctalString(this.regs[7]));
            }
            this.trap(4);
            return;
        }
        this.cycles(12L);
        try {
            int op = opdec[insn & 0xFFFF];
            switch (op) {
                case 10: 
                case 11: {
                    this.cycles(120L);
                    this.trap(4);
                    break;
                }
                case 3: {
                    this.regs[8] = this.regs[7];
                    this.cycles(120L);
                    this.trap(4);
                    break;
                }
                case 4: {
                    if (this.trace) {
                        this.note("Wait");
                    }
                    this.state = CPUState.WAIT;
                    break;
                }
                case 6: {
                    this.regs[8] = this.regs[7];
                    this.cycles(56L);
                    this.trap(12);
                    break;
                }
                case 7: {
                    this.regs[8] = this.regs[7];
                    this.cycles(56L);
                    this.trap(16);
                    break;
                }
                case 55: {
                    this.regs[8] = this.regs[7];
                    this.cycles(56L);
                    this.trap(24);
                    break;
                }
                case 56: {
                    this.regs[8] = this.regs[7];
                    this.cycles(56L);
                    this.trap(28);
                    break;
                }
                case 8: {
                    this.machine.reset();
                    this.cycles(8000L);
                    break;
                }
                case 9: {
                    if (this.trace) {
                        this.note("RTT");
                    }
                    this.state = CPUState.RTT;
                }
                case 5: {
                    this.cycles(28L);
                    this.regs[7] = this.machine.readWord(this.regs[6]);
                    this.regs[6] = (short)(this.regs[6] + 2);
                    this.psw = this.machine.readWord(this.regs[6]);
                    this.regs[6] = (short)(this.regs[6] + 2);
                    break;
                }
                case 12: {
                    int dst = insn & 0x3F;
                    if (dst <= 7) {
                        this.trap(4);
                    }
                    short ea = this.genEA(dst, false);
                    this.cycles(8L);
                    this.regs[7] = ea;
                    break;
                }
                case 13: {
                    this.cycles(20L);
                    int dst = insn & 7;
                    short tmp = this.machine.readWord(this.regs[6]);
                    this.regs[6] = (short)(this.regs[6] + 2);
                    this.regs[7] = this.regs[dst];
                    this.regs[dst] = tmp;
                    break;
                }
                case 14: {
                    this.psw = (short)(this.psw | insn & 0xFFFF000F);
                    break;
                }
                case 15: {
                    this.psw = (short)(this.psw & (0xFFF0 | ~insn));
                    break;
                }
                case 24: {
                    int dst = insn & 0x3F;
                    int src = insn >> 6 & 7;
                    if (dst <= 7) {
                        this.trap(4);
                    }
                    short ea = this.genEA(dst, false);
                    this.cycles(20L);
                    this.regs[6] = (short)(this.regs[6] - 2);
                    this.machine.writeWord(this.regs[6], this.regs[src]);
                    this.regs[src] = this.regs[7];
                    this.regs[7] = ea;
                    break;
                }
                case 37: {
                    this.exec_mark(insn);
                    break;
                }
                case 45: {
                    this.exec_xor(insn);
                    break;
                }
                case 46: {
                    this.cycles(8L);
                    int n = (insn & 0x1C0) >> 6;
                    this.regs[n] = (short)(this.regs[n] - 1);
                    if (this.regs[n] == 0) break;
                    this.regs[7] = (short)(this.regs[7] - (insn & 0x3F) * 2);
                    break;
                }
                case 16: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 38: {
                    this.exec_1op_word(insn, op);
                    break;
                }
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    this.exec_1op_byte(insn, op);
                    break;
                }
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 76: {
                    this.exec_2op_word(insn, op);
                    break;
                }
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: {
                    this.exec_2op_byte(insn, op);
                    break;
                }
                case 17: {
                    this.take_branch(insn, true);
                    break;
                }
                case 51: {
                    this.take_branch(insn, !this.V());
                    break;
                }
                case 52: {
                    this.take_branch(insn, this.V());
                    break;
                }
                case 53: {
                    this.take_branch(insn, !this.C());
                    break;
                }
                case 54: {
                    this.take_branch(insn, this.C());
                    break;
                }
                case 18: {
                    this.take_branch(insn, !this.Z());
                    break;
                }
                case 19: {
                    this.take_branch(insn, this.Z());
                    break;
                }
                case 47: {
                    this.take_branch(insn, !this.N());
                    break;
                }
                case 48: {
                    this.take_branch(insn, this.N());
                    break;
                }
                case 20: {
                    this.take_branch(insn, this.N() == this.V());
                    break;
                }
                case 21: {
                    this.take_branch(insn, this.N() ^ this.V());
                    break;
                }
                case 22: {
                    this.take_branch(insn, this.N() == this.V() && !this.Z());
                    break;
                }
                case 23: {
                    this.take_branch(insn, this.N() != this.V() || this.Z());
                    break;
                }
                case 49: {
                    this.take_branch(insn, !this.C() && !this.Z());
                    break;
                }
                case 50: {
                    this.take_branch(insn, this.C() || this.Z());
                    break;
                }
                default: {
                    this.cycles(132L);
                    this.trap(8);
                    break;
                }
            }
        }
        catch (QBusError e) {
            this.regs[8] = this.regs[7];
            this.trap(4);
        }
    }

    protected static final void register_opcode(int opcode, int mask, int op_type) {
        int loc = 0;
        do {
            K1801VM1.opdec[(loc | opcode) & 0xFFFF] = op_type;
        } while ((loc = (loc | mask) + 1 & 0xFFFF & ~mask) != 0);
    }

    protected static enum CPUState {
        BOGUS,
        NORMAL,
        INT,
        RTT,
        WAIT;

    }
}

