/*
 * Decompiled with CFR 0.152.
 */
package bk2010.io;

import bk2010.hardware.Timed;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;

public final class FloppyDisk
implements Timed {
    protected static final int TF_RPS = 5;
    protected static final int TF_TRACKLENGTH = 3125;
    protected static final int TF_INDEXPOS = 3110;
    protected static final int TF_AMLENGTH = 8;
    protected static final int TF_1STIDAM = 21;
    protected static final int TF_1STID = 29;
    protected static final int TF_1STDATAAM = 43;
    protected static final int TF_1STDATA = 51;
    protected static final int TF_SECTORLENGTH = 304;
    protected static final int TS_DATAMASK = 65535;
    protected static final int TS_MARKER = 65536;
    protected static final int TS_CRC = 131072;
    protected final long cyclesPerWord;
    protected long subWordCycles;
    protected File imageFile;
    protected RandomAccessFile imageAccess;
    protected long imageSize;
    protected int[] rawTrack = new int[6250];
    protected byte[] imageTrack = new byte[10240];
    protected boolean isMounted;
    protected int track;
    protected int trackPos;
    protected boolean wordChanged;
    protected boolean verbose = false;

    public FloppyDisk(long clockFrequency) {
        this.cyclesPerWord = clockFrequency / 15625L;
    }

    protected void initCRC() {
    }

    protected void updateCRC(int data) {
    }

    protected int getCRC() {
        return 196607;
    }

    protected int writeAM(int offset, int type) {
        int i = 0;
        while (i < 6) {
            this.rawTrack[offset++] = 0;
            ++i;
        }
        this.rawTrack[offset++] = 106913;
        this.rawTrack[offset++] = 0x1A100 | type & 0xFF;
        return offset;
    }

    protected void convertImageTrackToRaw() {
        Arrays.fill(this.rawTrack, 20046);
        int sector = 0;
        while (sector < 10) {
            int head = 0;
            while (head < 2) {
                int ofs = 21 + sector * 304 + head * 3125;
                ofs = this.writeAM(ofs, 254);
                this.initCRC();
                int tmp = head + (this.track << 8);
                this.rawTrack[ofs++] = tmp;
                this.updateCRC(tmp);
                tmp = sector + 1 << 8 | 2;
                this.rawTrack[ofs++] = tmp;
                this.updateCRC(tmp);
                this.rawTrack[ofs++] = this.getCRC();
                int dataofs = (sector + head * 10) * 512;
                ofs = 43 + sector * 304 + head * 3125;
                ofs = this.writeAM(ofs, 251);
                this.initCRC();
                int i = 0;
                while (i < 256) {
                    tmp = (this.imageTrack[dataofs++] & 0xFF) << 8;
                    this.rawTrack[ofs++] = tmp |= this.imageTrack[dataofs++] & 0xFF;
                    this.updateCRC(tmp);
                    ++i;
                }
                this.rawTrack[ofs++] = this.getCRC();
                ++head;
            }
            ++sector;
        }
    }

    protected void loadTrack() {
        long ofs;
        long len;
        Arrays.fill(this.imageTrack, (byte)0);
        if (this.isMounted && (len = Math.min(10240L, this.imageSize - (ofs = (long)(this.track * 512 * 10 * 2)))) > 0L) {
            try {
                this.imageAccess.seek(ofs);
                this.imageAccess.read(this.imageTrack, 0, (int)len);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.convertImageTrackToRaw();
        if (this.verbose) {
            System.out.printf("\nFDD: selected track %d\n", this.track);
        }
    }

    public void unmountImage() {
        if (this.isMounted) {
            try {
                this.imageAccess.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.imageAccess = null;
        this.imageFile = null;
        this.imageSize = 0L;
        this.isMounted = false;
    }

    public boolean mountImage(File file) {
        this.unmountImage();
        try {
            this.imageFile = file;
            this.imageAccess = new RandomAccessFile(file, "r");
            this.imageSize = this.imageAccess.length();
            System.out.printf("\nFDD: Mounted image %s\n", file.getCanonicalFile());
            this.isMounted = true;
            this.loadTrack();
        }
        catch (IOException e) {
            this.imageAccess = null;
            this.imageFile = null;
            this.imageSize = 0L;
            this.isMounted = false;
            return false;
        }
        return this.isMounted;
    }

    public void stepPlus() {
        if (this.track < 82) {
            ++this.track;
            this.loadTrack();
        }
    }

    public void stepMinus() {
        if (this.track > 0) {
            --this.track;
            this.loadTrack();
        }
    }

    public int getStatus(int head) {
        int tmp = 4;
        tmp |= this.track == 0 ? 1 : 0;
        if (this.trackPos >= 3110) {
            tmp |= 0x8000;
        }
        if (this.wordChanged) {
            tmp |= 0x80;
        }
        if ((this.rawTrack[this.trackPos + head * 3125] & 0x20000) != 0) {
            tmp |= 0x4000;
        }
        if (this.verbose) {
            System.out.printf("\nFDD: reading status word %08o at track position %d\n", tmp, this.trackPos);
        }
        return tmp;
    }

    public int getData(int head) {
        this.wordChanged = false;
        if (!this.isMounted) {
            return 0;
        }
        if (this.verbose) {
            System.out.printf("\nFDD: reading data word %05x at track position %d\n", this.rawTrack[this.trackPos + head * 3125], this.trackPos);
        }
        return this.rawTrack[this.trackPos + head * 3125];
    }

    public boolean isMarker(int head) {
        if (!this.isMounted) {
            return false;
        }
        if (this.verbose) {
            System.out.printf("\nFDD: Scanning for marker at track position %d\n", this.trackPos);
        }
        return (this.rawTrack[this.trackPos + head * 3125] & 0x10000) != 0;
    }

    @Override
    public void cycles(long howMany) {
        this.subWordCycles += howMany;
        if (this.subWordCycles < this.cyclesPerWord) {
            return;
        }
        this.wordChanged = true;
        if (this.subWordCycles < this.cyclesPerWord * 2L) {
            this.subWordCycles -= this.cyclesPerWord;
            ++this.trackPos;
            if (this.trackPos >= 3125) {
                this.trackPos = 0;
            }
            return;
        }
        this.trackPos = (int)(((long)this.trackPos + this.subWordCycles / this.cyclesPerWord) % 3125L);
        this.subWordCycles %= this.cyclesPerWord;
    }

    protected void finalize() throws Throwable {
        this.unmountImage();
    }
}

