/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui;

import bk2010.gui.RadioButtonPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class LauncherHWConfigurationDialog
extends JDialog {
    public static final String[] machineBaseHW = new String[]{"BK0010 + BASIC", "BK0010 + DISK", "BK0010 + BASIC + DISK"};
    RadioButtonPanel machineBaseSel;
    private State selectedConfiguration = new State();

    public LauncherHWConfigurationDialog() {
        super((Frame)null, "BK2010 Launcher", true);
        this.selectedConfiguration.machine = machineBaseHW[0];
        this.selectedConfiguration.doLaunch = true;
        this.machineBaseSel = new RadioButtonPanel("Machine type", machineBaseHW);
        this.add((Component)this.machineBaseSel, "Center");
        JPanel okExitpanel = new JPanel();
        okExitpanel.setLayout(new BoxLayout(okExitpanel, 0));
        JButton jbStart = new JButton("Start emulator");
        jbStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LauncherHWConfigurationDialog.this.setValues();
                ((LauncherHWConfigurationDialog)LauncherHWConfigurationDialog.this).selectedConfiguration.doLaunch = true;
                LauncherHWConfigurationDialog.this.setVisible(false);
            }
        });
        okExitpanel.add(jbStart);
        JButton jbExit = new JButton("Quit");
        jbExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LauncherHWConfigurationDialog.this.setValues();
                ((LauncherHWConfigurationDialog)LauncherHWConfigurationDialog.this).selectedConfiguration.doLaunch = false;
                LauncherHWConfigurationDialog.this.setVisible(false);
            }
        });
        okExitpanel.add(jbExit);
        this.add((Component)okExitpanel, "South");
        this.pack();
        jbStart.requestFocusInWindow();
        Dimension winsize = this.getSize();
        Dimension scrsize = this.getToolkit().getScreenSize();
        this.setLocation((scrsize.width - winsize.width) / 2, (scrsize.height - winsize.height) / 2);
        this.setValues();
    }

    void setValues() {
        this.selectedConfiguration.machine = this.machineBaseSel.getSelection();
    }

    public static State doIt() {
        LauncherHWConfigurationDialog dlg = new LauncherHWConfigurationDialog();
        dlg.setVisible(true);
        dlg.dispose();
        return dlg.selectedConfiguration;
    }

    public static void main(String[] args) {
        LauncherHWConfigurationDialog test = new LauncherHWConfigurationDialog();
        test.setVisible(true);
        System.exit(0);
    }

    public class State {
        public String machine;
        public boolean doLaunch;
    }
}

